--- third_party/perfetto/perfetto/perfetto.cc.orig	2025-07-16 02:06:53 UTC
+++ third_party/perfetto/perfetto/perfetto.cc
@@ -14,6 +14,8 @@
 //
 // This file is automatically generated by gen_amalgamated. Do not edit.
 
+#include <sys/ucred.h>
+
 // gen_amalgamated: predefined macros
 #if !defined(PERFETTO_IMPLEMENTATION)
 #define PERFETTO_IMPLEMENTATION
@@ -42125,7 +42127,7 @@ ClockSnapshotVector CaptureClockSnapshots() {
        {0, 0}},
       {CLOCK_REALTIME, protos::pbzero::BUILTIN_CLOCK_REALTIME, {0, 0}},
       {CLOCK_MONOTONIC, protos::pbzero::BUILTIN_CLOCK_MONOTONIC, {0, 0}},
-      {CLOCK_MONOTONIC_RAW,
+      {CLOCK_MONOTONIC,
        protos::pbzero::BUILTIN_CLOCK_MONOTONIC_RAW,
        {0, 0}},
   };
@@ -58913,8 +58915,8 @@ void UnixSocket::ReadPeerCredentialsPosix() {
   int res = getpeereid(fd, &peer_uid_, nullptr);
   PERFETTO_CHECK(res == 0);
   // There is no pid when obtaining peer credentials for QNX
-#elif PERFETTO_BUILDFLAG(PERFETTO_OS_LINUX) || \
-    PERFETTO_BUILDFLAG(PERFETTO_OS_ANDROID)
+#elif !defined(__FreeBSD__) && (PERFETTO_BUILDFLAG(PERFETTO_OS_LINUX) || \
+    PERFETTO_BUILDFLAG(PERFETTO_OS_ANDROID))
   struct ucred user_cred;
   socklen_t len = sizeof(user_cred);
   int fd = sock_raw_.fd();
@@ -58922,7 +58924,7 @@ void UnixSocket::ReadPeerCredentialsPosix() {
   PERFETTO_CHECK(res == 0);
   peer_uid_ = user_cred.uid;
   peer_pid_ = user_cred.pid;
-#elif PERFETTO_BUILDFLAG(PERFETTO_OS_APPLE)
+#elif defined(__FreeBSD__) || PERFETTO_BUILDFLAG(PERFETTO_OS_APPLE)
   struct xucred user_cred;
   socklen_t len = sizeof(user_cred);
   int res = getsockopt(sock_raw_.fd(), 0, LOCAL_PEERCRED, &user_cred, &len);
