package org.jruby.parser;

public class Ruby19YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          196,  196,  209,  556,  264,  600,   85,   85,  117,  117, 
          283,  286,   85,  221,  221,  221,  540,  227,  236,  221, 
          221,  196,  209,  221,  266,  403,  195,  587,  231,  611, 
          221,  246,  246,  501,  211,  246,  293,  455,  540,  260, 
          456,  588,  423,  617,  608,  540,  196,  358,  227,   85, 
          221,  366,   72,  291,  211,  221,  265,  394,  622,  382, 
          505,  540,  497,  375,  650,  227,  226,  225,  228,  540, 
          774,  769,  301,   64,   70,  471,  116,  116,  776,  476, 
          319,  896,  831,  315,  295,  540,  116,  540,  227,  486, 
          255,  250,  312,   92,   92,  540,  231,  226,  291,   92, 
          446,  369,  258,   72,  359,  238,  394,  501,  649,  505, 
          540,  360,  480,  221,  226,   85,  546,  552,  540,  559, 
          560,  116,  738,  486,   64,   70,   68,  500,  360,  452, 
           62,   63,  379,  653,  540,  684,   92,  226,  486,  267, 
          582,  505,  679,  265,  540,  344,  540,  896,  834,   65, 
          480,  480,  337,  282,  330,  880,  335,  546,  552,   73, 
          268,  500,  338,  451,   66,   75,  116,   98,  540,  274, 
          708,  582,  687,  313,  660,  680,  500,   68,  540,   65, 
           65,   60,   61,  333,  672,   65,   65,   65,   65,  569, 
          763,   71,   65,   65,  336,  540,   65,   69,  331,  480, 
           65,  582,   92,   65,  908,  486,  784,  540,  334,  501, 
           73,  332,  277,   75,  540,   66,  259,  306,  492,   67, 
          486,  582,   65,   65,  736,  629,  227,  540,   65,  404, 
           61,  774,  929,  492,  433,  312,  221,  221,  664,  713, 
          769,  574,   71,  300,  776,  231,  459,  774,   69,  654, 
          719,  480,  795,  673,  272,  273,  540,  629,  799,  221, 
          314,  221,  221,  376,  595,  221,  834,  535,  326,  327, 
           67,  246,   85,  246,  246,  226,  714,  370,  371,   85, 
          465,  466,  467,  540,  356,  535,   65,  468,   65,  408, 
          409,  357,  300,  291,  308,  258,  380,  735,  259,  452, 
          480,  434,  435,  381,  540,  599,  851,  405,  314,  805, 
          399,  742,  501,  386,  394,  788,  313,   53,  540,  614, 
          387,   72,  394,  540,   85,  221,  221,  221,  221,   85, 
          221,  221,  628,  454,  586,  628,  326,  327,  750,  540, 
          354,  717,   64,   70,  540,  394,  660,  760,  361,  540, 
          540,  554,  571,  540,  540,  505,  540,  362,  480,   92, 
          373,  116,  221,  377,  374,  221,   92,  221,   85,  291, 
          527,  221,  221,  363,  246,  554,  540,  828,  509,  510, 
          511,  512,  627,   72,  486,  394,  221,   85,  221,  540, 
          540,  505,  554,  579,  561,   68,  564,  748,  246,   85, 
          573,  576,  783,  221,   64,   70,  554,   85,   78,   65, 
           65,   92,  739,  634,  643,  246,   92,  221,   65,  745, 
          486,  459,  500,  360,  505,  616,  616,  480,   73,  246, 
          196,  209,   65,   66,   65,   65,  554,  116,   65,  873, 
          505,  221,  277,   85,  344,   65,  528,  660,   61,  660, 
          875,  276,   65,  486,  367,   92,  554,   68,  500,  360, 
           71,   62,   63,  211,  540,  865,   69,  221,  291,  568, 
          267,  465,  466,  568,   92,  500,  360,  540,  468,  246, 
           65,  480,  480,  337,  508,  330,   92,  335,   67,  513, 
           73,  500,  360,  338,   92,   66,  568,   65,   65,   65, 
           65,   65,   65,   65,   65,  261,   63,   63,  112,  112, 
          112,  612,   63,  368,  333,  904,  389,  276,  235,  486, 
          660,  882,   71,  818,  899,  336,  390,  459,   69,  331, 
           92,  277,  492,  392,  501,   65,  116,  686,   65,  334, 
           65,   65,  332,  479,   65,   65,  393,  397,  480,   63, 
           67,  548,  699,  290,  398,   80,  540,  540,  540,   65, 
           65,   65,  400,  540,  691,  432,  413,  660,  399,  660, 
          697,  721,   65,  401,  291,  548,   65,  700,  702,  402, 
           65,  540,  448,  699,  221,   85,  419,  196,  196,  209, 
           65,  419,  548,  926,  405,  711,   85,  660,  290,  407, 
          463,  749,  456,   85,  699,   82,  548,  410,  718,  729, 
          599,   97,   97,  720,   65,   63,   65,   97,  699,  414, 
          872,  211,  418,  870,   93,  393,  393,  221,  582,  419, 
          540,  393,  527,  527,  527,  422,  548,  712,  527,  527, 
           65,  527,  116,  465,  466,  699,  540,  540,  291,  439, 
          468,  382,  518,  473,   97,   85,  548,   89,   89,  118, 
          118,  304,  305,   89,  701,  703,  459,  328,  443,  237, 
          444,  328,   92,   93,  440,   89,   85,   85,  447,  445, 
          743,  276,  450,   92,  752,  753,   85,  754,   85,  457, 
           92,   85,  221,  221,  759,  247,  253,  458,  221,  254, 
           89,  464,  343,  474,  292,  270,  345,  346,  528,  528, 
          528,  527,  506,  291,  528,  528,  116,  528,   85,  478, 
           97,  791,  793,  881,   89,  572,  815,  796,  630,  808, 
           85,  437,  527,  221,  632,  633,  599,  603,  613,  631, 
          540,  690,   92,   85,   85,   85,   88,  696,  637,  292, 
          641,   59,   60,  642,  690,  690,  384,   65,   65,  644, 
          616,    6,  656,   92,   92,  270,   89,  655,  665,   65, 
          276,    6,   63,   92,   95,   92,   65,  690,   92,   63, 
          696,  116,  666,  667,  669,  675,  820,  528,  677,  540, 
           88,   82,   85,  290,  116,   88,  688,  689,  694,  706, 
           65,  602,   94,  411,  221,  441,  281,  285,  528,  610, 
          412,   85,  442,  817,  465,  466,  470,   92,  695,  709, 
            6,  468,   85,   95,   63,   82,  715,  456,   65,   63, 
           92,   92,   92,  862,  540,  540,  722,  461,  726,  456, 
           90,  518,   82,   52,  462,  636,  456,  284,  737,   65, 
           65,   94,  889,   52,  732,  264,  733,  734,  747,   65, 
          868,   65,  761,  554,   65,   65,   65,  869,   63,  290, 
           85,   65,  518,  707,  221,  789,   85,   97,  800,   92, 
           87,   93,   85,  271,   97,  809,  246,   63,  380,  518, 
          801,   86,  811,  716,   81,  916,  518,  821,   92,   63, 
          699,  518,   52,   65,  822,  823,   65,   63,  832,   92, 
          554,  829,  465,  466,  472,  836,   65,   65,   65,  468, 
          116,  838,  518,   89,  465,  466,  475,  264,  839,   97, 
           89,  468,   89,  848,   97,  424,  840,  427,  271,  746, 
          841,  384,  270,   63,  292,  384,  843,  845,  849,  270, 
          852,  854,  856,   93,  519,  857,  657,   92,  482,  483, 
          484,  485,  858,   92,  861,   65,  867,  762,  290,   92, 
          876,  522,  877,   97,  879,   89,  891,   65,  897,  909, 
           89,  898,  911,  915,   65,  657,  522,  482,  483,  484, 
          485,  918,   97,  384,  540,   65,  920,  922,  540,  540, 
          384,  925,  270,   88,   97,  725,    8,  928,  939,  270, 
          540,  540,   97,  527,  519,  529,    8,  429,  522,   89, 
          292,  810,  528,    6,    6,    6,  384,  529,  533,    6, 
            6,   95,    6,  321,  322,  323,  324,  325,   89,  533, 
          415,  416,  417,   65,  529,  328,  535,   65,   97,   65, 
           89,  529,  540,  540,  317,   65,  119,  751,   89,   94, 
           82,  518,  830,  548,  456,    8,  927,  835,  423,  423, 
          423,  456,  198,  866,  290,  423,  343,  773,  770,  771, 
          345,  346,  347,  348,  893,   63,  318,  239,  786,  905, 
          787,  758,  264,  790,   89,  883,   63,  320,    0,  264, 
            0,    0,    6,   63,    0,   52,   52,   52,    0,  518, 
           52,   52,   52,    0,   52,   95,  518,  429,    0,  292, 
          271,  518,   82,    6,   52,   52,   94,  271,    0,   89, 
          384,    0,  819,   52,   52,    0,   52,   52,   52,   52, 
           52,  429,  518,    0,    7,  825,  826,  827,  290,  598, 
          601,    0,    0,    0,    7,   63,    0,    0,  429,   84, 
            0,    0,  567,    0,  264,   84,  575,  413,  413,  413, 
            0,  264,  429,    0,  413,  271,   63,   63,  384,  219, 
          219,  219,  271,    0,   52,  384,   63,   52,   63,  596, 
           97,   63,    0,   84,  859,  657,  262,  482,  483,  484, 
          485,   97,    0,    7,  567,   52,    0,  522,   97,    0, 
           84,  384,  519,  290,    0,    0,  279,  624,  626,    0, 
            0,  284,  429,    0,  871,  292,  814,    0,  486,    0, 
           63,    0,   83,    0,    0,    0,   89,    0,  490,  491, 
          519,    0,    0,   63,   63,   63,    0,   89,    0,    0, 
          626,   40,    0,  284,   89,  522,  670,    0,    0,    0, 
           97,   40,  522,  683,  683,    0,   83,  518,    8,    8, 
            8,    0,    0,    0,    8,    8,    0,    8,  906,  372, 
            0,   97,   97,   83,  907,  522,    0,    0,  522,    0, 
            0,   97,   63,   97,    0,  772,   97,  775,    0,  292, 
          779,  683,    0,    0,    0,  693,   89,  756,    0,    0, 
           40,   63,    0,  522,    0,    0,    0,    0,  693,  693, 
            0,    0,   63,    0,    0,  270,    0,   89,   89,  766, 
            0,  482,  483,  484,  485,   97,    0,   89,    0,   89, 
          270,  693,   89,    0,    0,    0,    0,    8,   97,   97, 
           97,    0,  112,  245,  245,    0,  724,  245,    0,  728, 
            0,  601,  704,   54,  292,    0,    0,    0,    8,  601, 
           63,    0,  270,   54,    0,    0,   63,  816,    0,  269, 
          271,   89,   63,    0,    0,  245,  245,    0,  294,  296, 
            0,    0,    0,    0,   89,   89,   89,   97,    0,    0, 
           92,  519,  219,  219,    0,    0,    7,    7,    7,    0, 
            0,    0,    7,    7,    0,    7,   97,    0,    0,    0, 
            0,    0,   54,  670,  744,    0,    0,   97,   84,  519, 
            0,  431,    0,    0,  172,  676,  678,    0,    0,  670, 
            0,    0,    0,   89,  683,    0,    0,    0,    0,  519, 
            0,    0,    0,    0,    0,  757,  519,    0,    0,    0, 
            0,  519,   89,  885,    0,    0,  657,    0,  482,  483, 
          484,  485,  892,   89,  894,   97,    0,  519,   85,    0, 
            0,   97,  519,  172,  519,    7,    0,   97,    0,  519, 
           84,  219,  219,  219,  219,    0,  514,  515,    0,  658, 
            0,   83,  522,  118,    0,  804,    7,  659,    0,   81, 
          519,    0,   85,   40,   40,   40,    0,    0,   40,   40, 
           40,   89,   40,    0,    0,    0,    0,   89,    0,   85, 
            0,    0,   40,   89,    0,  328,    0,  824,    0,  670, 
          934,   40,   40,   81,   40,   40,   40,   40,   40,    0, 
          522,  341,  342,    0,  589,    0,    0,  522,    0,  270, 
           81,    0,  518,   83,    0,    0,  343,   80,  344,   87, 
          345,  346,  347,  348,    0,    0,  351,    0,  352,  245, 
          245,  245,  296,  522,  601,    0,    0,   42,    0,    0, 
          384,    0,   40,  245,    0,  245,  245,   42,    0,    0, 
            0,   80,  864,   87,  438,    0,    0,  635,    0,  270, 
            0,    0,    0,   40,    0,    0,  270,    0,   80,    0, 
           87,  519,    0,    0,    0,   54,   54,   54,    0,  429, 
           54,   54,   54,    0,   54,    0,    0,    0,    0,  270, 
            0,    0,    0,    0,   54,   54,   42,    0,  456,    0, 
          264,  229,    0,   54,   54,    0,   54,   54,   54,   54, 
           54,  229,    0,    0,    0,  601,  516,  517,  518,  519, 
          520,  521,  522,  523,  524,  525,  526,  527,  528,  529, 
          530,  531,  532,  533,  534,  535,  536,  537,  538,  539, 
          540,  541,    0,    0,   83,  229,  245,    0,    0,  562, 
          837,  565,    0,    0,   54,  245,  577,   54,  842,  844, 
          229,  846,    0,  847,    0,  850,    0,  853,  855,    0, 
          245,    0,    0,    0,    0,   54,    0,    0,  245,    0, 
          172,    0,  172,  172,  172,  172,    0,  245,  562,  609, 
          577,  522,    0,  245,    0,    0,    0,   85,    0,    0, 
          219,  245,  450,    0,    0,    0,  245,  245,    0,  450, 
          245,    0,    0,  172,  172,    0,    0,   90,    0,  328, 
            0,  172,  172,  172,  172,    0,    0,    0,   81,  384, 
            0,  638,  639,  640,   86,  341,  342,  541,    0,  245, 
            0,    0,  245,  219,    0,   92,  270,  541,    0,    0, 
          343,  245,  344,  270,  345,  346,  347,  348,  519,   85, 
          669,    0,    0,    0,    0,    0,   90,    0,   86,    0, 
          910,  912,  913,  914,    0,    0,  917,  384,  919,  921, 
          923,  924,    0,    0,  384,   86,   80,    0,   87,    0, 
           81,    0,    0,    0,   92,    0,  541,    0,  518,   42, 
           42,   42,    0,    0,   42,   42,   42,    0,   42,    0, 
          384,    0,    0,    0,    0,  271,  937,    0,   42,  938, 
          940,  941,  942,  328,    0,    0,  519,   42,   42,  944, 
           42,   42,   42,   42,   42,  456,    0,  264,    0,  341, 
          342,    0,  456,    0,  264,    0,    0,    0,   80,  219, 
           87,  245,    0,    0,  343,    0,    0,  444,  345,  346, 
          347,  348,    0,  229,  229,  229,    0,  444,  229,  229, 
          229,  657,  229,  482,  483,  484,  485,    0,   42,   91, 
          522,    0,  229,  229,  657,    0,  482,  483,  484,  485, 
            0,  229,  229,    0,  229,  229,  229,  229,  229,   42, 
            0,  444,    0,    0,  658,    0,  229,    0,    0,    0, 
            0,    0,  833,  245,    0,  444,  444,  658,  444,    0, 
          444,    0,    0,    0,    0,    0,    0,  481,  522,  482, 
          483,  484,  485,    0,    0,  522,    0,    0,    0,  229, 
          518,    0,  229,    0,  245,  229,    0,  229,  444,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          486,  522,    0,  229,    0,    0,    0,    0,  488,  489, 
          490,  491,    0,    0,   90,  229,  792,  794,    0,    0, 
          447,    0,  797,  798,    0,    0,    0,  518,    0,    0, 
          447,    0,    0,  802,  245,    0,    0,    0,  806,  541, 
          541,  541,   92,   86,  541,  541,  541,  778,  541,  482, 
          483,  484,  485,    0,    0,  519,    0,    0,  541,  541, 
          792,  794,  797,    0,  447,    0,  245,  541,  541,    0, 
          541,  541,  541,  541,  541,  518,    0,    0,  447,  447, 
          486,  447,  518,  447,    0,    0,    0,  518,  488,  489, 
          490,  491,  271,    0,    0,    0,    0,    0,    0,  271, 
            0,    0,    0,  519,    0,   86,    0,    0,  518,    0, 
          519,  447,    0,    0,    0,  519,    0,  860,  541,    0, 
            0,  541,    0,  541,    0,    0,    0,    0,  863,    0, 
            0,  245,    0,    0,    0,    0,  519,    0,    0,  541, 
            0,    0,    0,    0,    0,    0,  165,    0,   91,    0, 
          863,    0,    0,    0,  515,  515,  515,    0,  515,  444, 
          444,  444,  515,  515,  444,  444,  444,  515,  444,  515, 
          515,  515,  515,  515,  515,  515,  444,  515,  444,  444, 
          515,  515,  515,  515,  515,  515,  515,  444,  444,  515, 
          444,  444,  444,  444,  444,  165,  515,   91,  245,  515, 
          515,  515,  444,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  444,  444,  444,  444,  444,  444, 
          444,  444,  444,  444,  444,  444,  444,  444,    0,  522, 
          444,  444,  444,  515,  444,  444,  515,  515,  444,  515, 
          515,  444,  515,  444,  515,  444,  515,  444,  515,  444, 
          444,  444,  444,  444,  444,  444,  515,  444,  515,  444, 
            0,  515,  515,  515,  515,  515,  515,    0,    0,  175, 
          515,  444,  515,  515,    0,  515,  515,  516,  516,  516, 
            0,  516,  447,  447,  447,  516,  516,  447,  447,  447, 
          516,  447,  516,  516,  516,  516,  516,  516,  516,  447, 
          516,  447,  447,  516,  516,  516,  516,  516,  516,  516, 
          447,  447,  516,  447,  447,  447,  447,  447,  175,  516, 
            0,    0,  516,  516,  516,  447,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  447,  447,  447, 
          447,  447,  447,  447,  447,  447,  447,  447,  447,  447, 
          447,    0,    0,  447,  447,  447,  516,  447,  447,  516, 
          516,  447,  516,  516,  447,  516,  447,  516,  447,  516, 
          447,  516,  447,  447,  447,  447,  447,  447,  447,  516, 
          447,  516,  447,    0,  516,  516,  516,  516,  516,  516, 
          518,    0,    0,  516,  447,  516,  516,    0,  516,  516, 
          518,    0,    0,    0,    0,   91,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  522,    0, 
            0,    0,    0,    0,    0,    0,  481,    0,  482,  483, 
          484,  485,    0,    0,  518,    0,    0,    0,    0,    0, 
            0,    0,  165,    0,  165,  165,  165,  165,  518,  518, 
            0,   90,    0,  518,    0,    0,    0,    0,    0,  486, 
          487,    0,    0,    0,  449,    0,  522,  488,  489,  490, 
          491,  449,    0,  522,    0,  165,  165,    0,  518,    0, 
            0,  518,    0,  165,  165,  165,  165,    0,    0,    0, 
            0,    0,    0,    0,  543,  544,    0,    0,  545,  522, 
            0,    0,  165,  166,    0,  167,  168,  169,  170,  171, 
          172,  173,    0,  519,  174,  175,    0,    0,    0,  176, 
          177,  178,  179,  519,    0,    0,    0,    0,  258,    0, 
            0,    0,    0,    0,    0,  181,  182,    0,  183,  184, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,    0, 
            0,  194,    0,    0,    0,    0,    0,  519,    0,  481, 
            0,  482,  483,  484,  485,  175,    0,  175,  175,  175, 
          175,  519,  519,    0,   92,    0,  519,  778,    0,  482, 
          483,  484,  485,    0,    0,    0,    0,  451,  265,    0, 
            0,    0,  486,  590,  451,    0,    0,    0,  175,  175, 
          488,  489,  490,  491,  519,    0,  175,  175,  175,  175, 
          486,    0,    0,    0,    0,    0,    0,    0,  488,  489, 
          490,  491,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  353,    0,    0,    0,    0,    0,  518,  518,  518, 
            0,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,    0, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,    0,  518, 
            0,    0,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,    0,    0,  518,  518,  518,  518,    0,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,    0,  518,  518,  518,  518,  518,  518, 
            0,    0,  160,  518,  518,  518,  518,    0,  518,  518, 
          519,  519,  519,    0,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,    0,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  160,  519,    0,    0,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,    0,    0,  519,  519,  519,  519, 
            0,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,    0,  519,  519,  519, 
          519,  519,  519,  522,    0,    0,  519,  519,  519,  519, 
            0,  519,  519,  522,    0,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,    0,  339,  340,    0, 
            0,  341,  342,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  343,  522,  344,    0, 
          345,  346,  347,  348,  349,  350,  351,    0,  352,  549, 
          550,  522,  522,  551,   91,    0,  522,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,    0, 
            0,    0,    0,  258,  522,    0,    0,    0,    0,    0, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,    0,    0,  194,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  265,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  265,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,    0,    0,    0,    0, 
          265,  341,  342,    0,    0,    0,    0,    0,  160,    0, 
          160,  160,  160,  160,  265,  265,  343,    0,  344,  265, 
          345,  346,  347,  348,  349,  350,  351,  328,  352,    0, 
          452,    0,  333,  334,    0,    0,    0,  452,    0,    0, 
            0,  160,  160,  341,  342,    0,    0,  265,    0,  160, 
          160,  160,  160,    0,    0,    0,    0,    0,  343,    0, 
          344,    0,  345,  346,  347,  348,  349,  350,  351,    0, 
          352,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          518,  518,  518,    0,  518,  522,  522,  522,  518,  518, 
          522,  522,  522,  518,  522,  518,  518,  518,  518,  518, 
          518,  518,    0,  522,  522,  522,  518,  518,  518,  518, 
          518,  518,  518,  522,  522,  518,  522,  522,  522,  522, 
          522,  265,  518,    0,    0,  518,  518,  518,  522,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,    0,    0,  522,  522,  522,  518, 
            0,  522,  518,  518,  522,  518,  518,  522,  518,  522, 
          518,  522,  518,  522,  518,  522,  522,  522,  522,  522, 
          522,  522,  518,  522,  522,  522,    0,  518,  518,  518, 
          518,  518,  518,    0,    0,  142,  518,  522,  518,  518, 
            0,  518,  518,  517,  517,  517,    0,  517,  265,  265, 
          265,  517,  517,  265,  265,  265,  517,  265,  517,  517, 
          517,  517,  517,  517,  517,    0,  517,  265,  265,  517, 
          517,  517,  517,  517,  517,  517,  265,  265,  517,  265, 
          265,  265,  265,  265,  142,  517,    0,    0,  517,  517, 
          517,  265,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  265,  265,  265,  265,  265,  265,  265, 
          265,  265,  265,  265,  265,  265,  265,    0,    0,  265, 
          265,  265,  517,    0,  265,  517,  517,  265,  517,  517, 
          265,  517,  265,  517,  265,  517,  265,  517,  265,  265, 
          265,  265,  265,  265,  265,  517,  265,  517,  265,    0, 
          517,  517,  517,  517,  517,  517,  523,    0,    0,  517, 
          265,  517,  517,    0,  517,  517,  523,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          523,    0,    0,    0,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,  523,  523,    9,   10,    0,  523, 
            0,   11,    0,   12,   13,   14,   99,  100,   17,   18, 
            0,    0,    0,    0,  101,   20,   21,   22,   23,   24, 
           25,    0,    0,  104,    0,    0,    0,  523,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,  241,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  524, 
            0,    0,    0,    0,    0,    0,    0,  217,    0,  524, 
          111,    0,    0,   46,   47,    0,   48,    0,  242,    0, 
          243,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          244,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,  524,   58,    0,   59,   60,    0,   61, 
           62,  142,    0,  142,  142,  142,  142,  524,  524,    0, 
            0,    0,  524,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  454,    0,    0,    0,    0,    0,    0, 
          454,    0,    0,    0,  142,  142,    0,    0,    0,    0, 
          524,    0,  142,  142,  142,  142,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  143,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  520,  520,  520,    0,  520,  523,  523, 
          523,  520,  520,  523,  523,  523,  520,  523,  520,  520, 
          520,  520,  520,  520,  520,  143,  523,  523,  523,  520, 
          520,  520,  520,  520,  520,  520,  523,  523,  520,  523, 
          523,  523,  523,  523,    0,  520,    0,    0,  520,  520, 
          520,  523,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  523,  523,  523,    0,    0,  523, 
          523,  523,  520,    0,  523,  520,  520,  523,  520,  520, 
          523,  520,  523,  520,  523,  520,  523,  520,  523,  523, 
          523,  523,  523,  523,  523,  520,  523,  523,  523,    0, 
          520,  520,  520,  520,  520,  520,    0,    0,  144,  520, 
          523,  520,  520,    0,  520,  520,  521,  521,  521,    0, 
          521,  524,  524,  524,  521,  521,  524,  524,  524,  521, 
          524,  521,  521,  521,  521,  521,  521,  521,    0,  524, 
          524,  524,  521,  521,  521,  521,  521,  521,  521,  524, 
          524,  521,  524,  524,  524,  524,  524,  144,  521,    0, 
            0,  521,  521,  521,  524,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
            0,    0,  524,  524,  524,  521,    0,  524,  521,  521, 
          524,  521,  521,  524,  521,  524,  521,  524,  521,  524, 
          521,  524,  524,  524,  524,  524,  524,  524,  521,  524, 
          524,  524,    0,  521,  521,  521,  521,  521,  521,  270, 
            0,    0,  521,  524,  521,  521,    0,  521,  521,  270, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  143,    0,  143,  143,  143,  143,    0,    0, 
            0,    0,    0,  270,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  453,    0,    0,  270,  270,    0, 
           93,  453,  270,    0,    0,  143,  143,    0,    0,    0, 
            0,    0,    0,  143,  143,  143,  143,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          270,    0,  557,  544,    0,    0,  558,    0,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,  383,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,  383,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,    0,    0,  194, 
            0,  328,  329,  330,  331,  332,  333,  334,  335,    0, 
          337,  338,    0,    0,    0,    0,  383,  341,  342,    0, 
            0,    0,    0,    0,  144,    0,  144,  144,  144,  144, 
            0,  383,  343,    0,  344,  383,  345,  346,  347,  348, 
          349,  350,  351,    0,  352,    0,  455,    0,    0,    0, 
            0,    0,    0,  455,    0,    0,    0,  144,  144,    0, 
            0,    0,    0,  383,    0,  144,  144,  144,  144,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  519,  519,  519,    0, 
          519,  270,  270,  270,  519,  519,  270,  270,  270,  519, 
          270,  519,  519,  519,  519,  519,  519,  519,    0,    0, 
          270,  270,  519,  519,  519,  519,  519,  519,  519,  270, 
          270,  519,  270,  270,  270,  270,  270,  265,  519,    0, 
            0,  519,  519,  519,  270,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  270,  270,  270,  270, 
          270,  270,  270,  270,  270,  270,  270,  270,  270,  270, 
            0,    0,  270,  270,  270,  519,    0,  270,  519,  519, 
          270,  519,  519,  270,  519,  270,  519,  270,  519,  270, 
          519,  270,  270,  270,  270,  270,  270,  270,  519,  270, 
            0,  270,    0,  519,  519,  519,  519,  519,  519,    0, 
            0,  101,  519,  270,  519,  519,    0,  519,  519,  244, 
          244,  244,    0,  244,  383,  383,  383,  244,  244,  383, 
          383,  383,  244,  383,  244,  244,  244,  244,  244,  244, 
          244,    0,  383,  383,  383,  244,  244,  244,  244,  244, 
          244,  244,  383,  383,  244,  383,  383,  383,  383,  383, 
          101,  244,    0,    0,  244,  244,  244,    0,  244,  244, 
          244,  244,  244,  244,  244,  244,  244,  244,  244,  383, 
          383,  383,  383,  383,  383,  383,  383,  383,  383,  383, 
          383,  383,  383,    0,    0,  383,  383,  383,  244,    0, 
          383,  244,    0,  383,  244,  244,  383,  244,  383,  244, 
          383,  244,  383,  244,  383,  383,  383,  383,  383,  383, 
          383,  244,  383,  383,  383,    0,  244,  244,  244,  244, 
          244,  244,  540,    0,    0,  244,    0,  244,  244,    0, 
          244,  244,  540,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  540,    0,    0,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
            0,  540,    9,   10,    0,  540,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,  540,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  277,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,  277,  111,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,  277, 
           58,    0,   59,   60,    0,   61,   62,  101,    0,  101, 
          101,  101,  101,    0,  277,    0,    0,    0,  277,    0, 
            0,  328,  329,  330,  331,  332,  333,  334,    0,  444, 
          337,  338,    0,    0,    0,    0,  444,  341,  342,    0, 
          101,  101,    0,    0,    0,    0,  277,    0,  101,  101, 
          101,  101,  343,    0,  344,    0,  345,  346,  347,  348, 
          349,  350,  351,    0,  352,    0,    0,    0,    0,    0, 
            0,    0,    0,  248,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  248,    0,    0,    0,    0,    0,  244, 
          244,  244,    0,  244,  540,  540,  540,  244,  244,  540, 
          540,  540,  244,  540,  244,  244,  244,  244,  244,  244, 
          244,    0,  540,  540,  540,  244,  244,  244,  244,  244, 
          244,  244,  540,  540,  244,  540,  540,  540,  540,  540, 
            0,  244,  248,  353,  244,  244,  244,    0,  244,  244, 
          244,  244,  244,  244,  244,  244,  244,  244,  244,  540, 
          540,  540,  540,  540,  540,  540,  540,  540,  540,  540, 
          540,  540,  540,    0,    0,  540,  540,  540,  244,    0, 
          540,  244,    0,  540,  244,  244,  540,  244,  540,  244, 
          540,  244,  540,  244,  540,  540, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          540,  540,  540,  540,  540,  244,  540,  540,  540,    0, 
          244,  244,  244,  244,  244,  244,  353,    0,    0,  244, 
            0,  244,  244,    0,  244,  244,  244,  244,  244,    0, 
          244,  277,  277,  277,  244,  244,  277,  277,  277,  244, 
          277,  244,  244,  244,  244,  244,  244,  244,    0,    0, 
          277,  277,  244,  244,  244,  244,  244,  244,  244,  277, 
          277,  244,  277,  277,  277,  277,  277,    0,  244,    0, 
            0,  244,  244,  244,    0,  244,  244,  244,  244,  244, 
          244,  244,  244,  244,  244,  244,  277,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,  277, 
            0,    0,  277,  277,  277,  244,    0,  277,  244,    0, 
          277,  244,  244,  277,  244,  277,  244,  277,  244,  277, 
          244,  277,  277,  277,  277,  277,  277,  277,  244,  277, 
          518,  277,    0,  244,  244,  244,  244,  244,  244,    0, 
          518,    0,  244,    0,  244,  244,    0,  244,  244,  248, 
          248,  248,    0,    0,  248,  248,  248,    0,  248,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  248,  248, 
            0,    0,    0,    0,   82,    0,    0,  248,  248,    0, 
          248,  248,  248,  248,  248,    0,    0,    0,    0,  518, 
            0,   90,    0,  518,    0,    0,    0,    0,    0,    0, 
            0,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,    0,  339,  340,    0,    0,  341,  342,    0, 
            0,  518,    0,    0,    0,    0,    0,    0,  248,    0, 
            0,  248,  343,  248,  344,    0,  345,  346,  347,  348, 
          349,  350,  351,    0,  352,    0,    0,    0,    0,  248, 
          705,    0,    0,  519,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,    0,    0,    0,    0,    0,    0, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,    0,  339,  340,    0,    0,  341,  342,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   84,    0,    0, 
            0,  343,    0,  344,    0,  345,  346,  347,  348,  349, 
          350,  351,  519,  352,   92,    0,  519,    0,    0,    0, 
          583,  550,    0,    0,  584,    0,    0,    0,  165,  166, 
            0,  167,  168,  169,  170,  171,  172,  173,    0,    0, 
          174,  175,    0,    0,  519,  176,  177,  178,  179,    0, 
            0,    0,    0,    0,  258,    0,    0,    0,    0,    0, 
          102,  181,  182,    0,  183,  184,  185,  186,  187,  188, 
          189,  190,  191,  192,  193,    0,   41,  194,    0,    0, 
            0,    0,    0,    0,    0,    0,   41,  518,  518,  518, 
            0,  518,  518,  518,  518,  518,  518,    0,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  102, 
          518,    0,    0,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,    0,  518, 
            0,    0,  518,  518,  518,   41,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,    0,    0,  518,  518,  518,  518,    0,    0,  518, 
          518,  518,  518,  518,    0,  518,    0,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,    0,  518,  518,  518,  518,  518,  518, 
            0,    0,    0,  518,    0,  518,  518,  353,  518,  518, 
          519,  519,  519,    0,  519,  519,  519,  519,  519,  519, 
            0,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,    0,  519,    0,    0,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,    0,  519,    0,    0,  519,  519,  519,    0,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,    0,    0,  519,  519,  519,  519, 
            0,    0,  519,  519,  519,  519,  519,    0,  519,    0, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,    0,  519,  519,  519, 
          519,  519,  519,  522,    0,    0,  519,    0,  519,  519, 
            0,  519,  519,  522,    0,    0,    0,    0,   41,   41, 
           41,    0,    0,   41,   41,   41,    0,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,  102,   41,  102,  102, 
          102,  102,    0,    0,    0,    0,    0,   83,    0,   41, 
           41,   41,   41,   41,    0,    0,    0,    0,  447,    0, 
            0,    0,  522,    0,   91,  447,  522,    0,    0,  102, 
          102,    0,    0,    0,    0,    0,    0,  102,  102,  102, 
          102,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  522,    0,    0,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   41,    0, 
            0,  710,    0,    0,    0,    0,  270,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  270,    0,    0,    0, 
            0,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,    0,  339,  340,    0,    0,  341,  342,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           85,    0,  343,    0,  344,    0,  345,  346,  347,  348, 
          349,  350,  351,    0,  352,  270,    0,   93,    0,  270, 
            0,    0,    0,  604,  544,    0,    0,  605,    0,    0, 
            0,  165,  166,    0,  167,  168,  169,  170,  171,  172, 
          173,    0,    0,  174,  175,    0,    0,  270,  176,  177, 
          178,  179,    0,    0,    0,    0,    0,  258,    0,    0, 
            0,    0,    0,    0,  181,  182,    0,  183,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,    0,  540, 
          194,    0,    0,    0,    0,    0,    0,    0,    0,  540, 
          518,  518,  518,    0,  518,  522,  522,  522,  518,  518, 
            0,  522,  522,  518,  522,  518,  518,  518,  518,  518, 
          518,  518,    0,  522,    0,    0,  518,  518,  518,  518, 
          518,  518,  518,  522,  522,  518,  522,  522,  522,  522, 
          522,    0,  518,    0,    0,  518,  518,  518,  540,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,    0,    0,  522,  522,  522,  518, 
            0,    0,  518,  518,  522,  518,  518,    0,  518,    0, 
          518,  522,  518,  522,  518,  522,  522,  522,  522,  522, 
          522,  522,  518,  522,  522,  522,    0,  518,  518,  518, 
          518,  518,  518,    0,    0,    0,  518,    0,  518,  518, 
            0,  518,  518,  519,  519,  519,    0,  519,  270,  270, 
          270,  519,  519,    0,  270,  270,  519,  270,  519,  519, 
          519,  519,  519,  519,  519,    0,    0,    0,    0,  519, 
          519,  519,  519,  519,  519,  519,  270,  270,  519,  270, 
          270,  270,  270,  270,    0,  519,    0,    0,  519,  519, 
          519,  289,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  270,  270,  270,  270,  270,  270,  270, 
          270,  270,  270,  270,  270,  270,  270,    0,    0,  270, 
          270,  270,  519,    0,    0,  519,  519,  270,  519,  519, 
            0,  519,    0,  519,  270,  519,  270,  519,  270,  270, 
          270,  270,  270,  270,  270,  519,  270,    0,  270,    0, 
          519,  519,  519,  519,  519,  519,    0,    0,    0,  519, 
            0,  519,  519,    0,  519,  519,  244,  244,  244,    0, 
          244,  540,  540,  540,  244,  244,  540,  540,  540,  244, 
          540,  244,  244,  244,  244,  244,  244,  244,    0,    0, 
          540,    0,  244,  244,  244,  244,  244,  244,  244,  540, 
          540,  244,  540,  540,  540,  540,  540,    0,  244,    0, 
            0,  244,  244,  244,    0,  244,  244,  244,  244,  244, 
          244,  244,  244,  244,  244,  244,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  384,  540,    0,    0, 
            0,    0,    0,    0,  540,  244,  384,    0,  244,    0, 
          540,  244,  244,    0,  244,    0,  244,    0,  244,    0, 
          244,    0,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,  540,    0,  244,  244,  244,  244,  244,  244,    0, 
          384,    0,  244,    0,  244,  244,    0,  244,  244,    0, 
            0,    0,    0,    0,  384,  384,    0,   89,    0,  384, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,    0,  384,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,  383,    0,  104, 
            0,    0,    0,    0,    0,    0,  105,  383,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,    0,    0,  108,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  383,    0,  288,    0,    0,  111,    0,    0,   46, 
           47,    0,   48,    0,    0,  383,  383,    0,    0,    0, 
          383,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    0,  383,    0, 
            0,    0,    0,  764,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  777,    0,    0,  781,    0,    0,    0, 
            0,  456,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  456,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  456,    0,    0,  384,  384, 
          384,    0,    0,  384,  384,  384,    0,  384,    0,  456, 
          456,    0,   88,    0,  456,    0,  384,  384,  384,    0, 
            0,    0,    0,    0,    0,    0,  384,  384,    0,  384, 
          384,  384,  384,  384,    0,    0,    0,    0,    0,    0, 
            0,  384,  456,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  384,  384,  384,  384,  384,  384,  384, 
          384,  384,  384,  384,  384,  384,  384,    0,    0,  384, 
          384,  384,    0,    0,  384,    0,    0,  384,    0,    0, 
          384,    0,  384,    0,  384,  540,  384,    0,  384,  384, 
          384,  384,  384,  384,  384,  540,  384,  384,  384,  383, 
          383,  383,    0,    0,  383,  383,  383,  884,  383,  886, 
          384,  887,    0,    0,    0,  890,    0,  383,  383,  383, 
          895,    0,    0,    0,    0,    0,    0,  383,  383,  540, 
          383,  383,  383,  383,  383,    0,    0,    0,    0,    0, 
            0,    0,  383,  540,  540,    0,    0,    0,  540,    0, 
            0,    0,    0,    0,  383,  383,  383,  383,  383,  383, 
          383,  383,  383,  383,  383,  383,  383,  383,    0,    0, 
          383,  383,  383,    0,    0,  383,  540,  930,  383,    0, 
            0,  383,    0,  383,  933,  383,  935,  383,  936,  383, 
          383,  383,  383,  383,  383,  383,    0,  383,  383,  383, 
            0,    0,    0,    0,    0,  943,    0,    0,    0,    0, 
            0,  383,    0,  456,  456,  456,    0,    0,  456,  456, 
          456,    0,  456,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  456,  456,    0,    0,    0,    0,    0,    0, 
            0,  456,  456,    0,  456,  456,  456,  456,  456,    0, 
            0,    0,    0,    0,    0,    0,  456,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  456,  456, 
          456,  456,  456,  456,  456,  456,  456,  456,  456,  456, 
          456,  456,    0,  264,  456,  456,  456,    0,  457,  456, 
            0,    0,  456,  264,    0,  456,    0,  456,    0,  456, 
            0,  456,    0,  456,  456,  456,  456,  456,  456,  456, 
            0,  456,    0,  456,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  456,    0,  264,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  264,  264,    0,   95,    0,  264,  540,  540,  540, 
            0,    0,  540,  540,  540,    0,  540,    0,    0,    0, 
            0,    0,    0,    0,    0,  540,  540,  540,    0,    0, 
            0,    0,    0,    0,  264,  540,  540,    0,  540,  540, 
          540,  540,  540,    0,    0,    0,    0,    0,    0,    0, 
          540,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  540,  540,  540,  540,  540,  540,  540,  540, 
          540,  540,  540,  540,  540,  540,    0,  271,  540,  540, 
          540,    0,    0,  540,    0,    0,  540,  271,    0,  540, 
            0,  540,    0,  540,    0,  540,    0,  540,  540,  540, 
          540,  540,  540,  540,    0,  540,  540,  540,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  540, 
            0,  271,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  606,  550,  271,  271,  607,   94,    0, 
          271,  165,  166,    0,  167,  168,  169,  170,  171,  172, 
          173,    0,    0,  174,  175,    0,    0,    0,  176,  177, 
          178,  179,    0,    0,    0,    0,    0,  258,  271,    0, 
            0,    0,    0,    0,  181,  182,    0,  183,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,    0,    0, 
          194,  404,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  404,    0,    0,    0,  264,  264,  264,    0,    0, 
          264,  264,  264,    0,  264,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  264,  264,    0,    0,    0,    0, 
            0,    0,    0,  264,  264,  404,  264,  264,  264,  264, 
          264,    0,    0,    0,    0,    0,    0,    0,  264,  404, 
          404,    0,    0,    0,  404,    0,    0,    0,    0,    0, 
          264,  264,  264,  264,  264,  264,  264,  264,  264,  264, 
          264,  264,  264,  264,    0,    0,  264,  264,  264,    0, 
            0,  264,  404,    0,  264,    0,    0,  264,    0,  264, 
            0,  264,  282,  264,    0,  264,  264,  264,  264,  264, 
          264,  264,  282,  264,    0,  264,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  282,    0,    0,  271, 
          271,  271,    0,    0,  271,  271,  271,    0,  271,    0, 
          282,  282,    0,    0,    0,  282,    0,    0,  271,  271, 
            0,    0,    0,    0,    0,    0,    0,  271,  271,    0, 
          271,  271,  271,  271,  271,    0,    0,    0,    0,    0, 
            0,    0,  271,  282,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  271,  271,  271,  271,  271,  271, 
          271,  271,  271,  271,  271,  271,  271,  271,    0,    0, 
          271,  271,  271,    0,    0,  271,    0,    0,  271,    0, 
            0,  271,    0,  271,    0,  271,    0,  271,    0,  271, 
          271,  271,  271,  271,  271,  271,  228,  271,    0,  271, 
            0,    0,    0,    0,    0,    0,  228,    0,    0,    0, 
            0,  271,    0,  404,  404,  404,    0,    0,  404,  404, 
          404,    0,  404,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  404,  404,    0,    0,    0,    0,    0,    0, 
          228,  404,  404,    0,  404,  404,  404,  404,  404,    0, 
            0,    0,    0,    0,  228,  228,  404,    0,    0,  228, 
            0,    0,    0,    0,    0,    0,    0,    0,  404,  404, 
          404,  404,  404,  404,  404,  404,  404,  404,  404,  404, 
          404,  404,    0,    0,  404,  404,  404,  314,    0,  404, 
            0,    0,  404,    0,    0,  404,    0,  404,    0,  404, 
          277,  404,    0,  404,  404,  404,  404,  404,  404,  404, 
          277,  404,    0,  404,  282,  282,  282,    0,    0,  282, 
          282,  282,    0,  282,    0,  404,    0,    0,    0,    0, 
            0,    0,    0,  282,  282,    0,    0,    0,    0,    0, 
            0,    0,  282,  282,  277,  282,  282,  282,  282,  282, 
            0,    0,    0,    0,    0,    0,    0,  282,  277,  277, 
            0,    0,    0,  277,    0,    0,    0,    0,    0,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,    0,    0,  282,  282,  282,    0,    0, 
          282,  277,    0,  282,    0,    0,  282,    0,  282,    0, 
          282,    0,  282,    0,  282,  282,  282,  282,  282,  282, 
          282,    0,  282,  442,  282,    0,    0,    0,    0,    0, 
            0,    0,    0,  442,    0,    0,  282,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  442,  228,  228, 
          228,    0,    0,  228,  228,  228,    0,  228,    0,    0, 
            0,  442,  442,    0,    0,    0,  442,  228,  228,    0, 
            0,    0,    0,    0,    0,    0,  228,  228,    0,  228, 
          228,  228,  228,  228,    0,    0,    0,    0,    0,    0, 
            0,  228,    0,    0,  442,    0,    0,    0,    0,    0, 
            0,    0,    0,  228,  228,  228,  228,  228,  228,  228, 
          228,  228,  228,  228,  314,  228,  228,    0,    0,  228, 
          228,  314,    0,    0,  228,    0,    0,  228,    0,    0, 
          228,    0,  228,    0,  228,  443,  228,    0,  228,  228, 
          228,  228,  228,  228,  228,  443,  228,    0,  228,    0, 
            0,    0,  277,  277,  277,    0,    0,  277,  277,  277, 
          228,  277,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  277,  277,    0,    0,    0,    0,    0,    0,  443, 
          277,  277,    0,  277,  277,  277,  277,  277,    0,    0, 
            0,    0,    0,  443,  443,  277,    0,    0,  443,    0, 
            0,    0,    0,    0,    0,    0,    0,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,  277, 
          277,    0,    0,  277,  277,  277,  443,    0,  277,    0, 
            0,  277,    0,    0,  277,    0,  277,    0,  277,    0, 
          277,    0,  277,  277,  277,  277,  277,  277,  277,    0, 
          277,  206,  277,    0,    0,    0,    0,    0,    0,    0, 
            0,  206,    0,    0,  277,  442,  442,  442,    0,    0, 
          442,  442,  442,    0,  442,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  442,  442,    0,    0,    0,    0, 
            0,    0,    0,  442,  442,  206,  442,  442,  442,  442, 
          442,    0,    0,    0,    0,    0,    0,    0,  442,  206, 
          206,    0,    0,    0,  206,    0,    0,    0,    0,    0, 
            0,  442,  442,  442,  442,  442,  442,  442,  442,  442, 
          442,  442,  442,  442,    0,    0,  442,  442,  442,    0, 
            0,  442,    0,    0,  442,    0,    0,  442,    0,  442, 
            0,  442,  202,  442,    0,  442,  442,  442,  442,  442, 
          442,  442,  202,  442,    0,  442,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  442,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  202,  443,  443,  443, 
            0,    0,  443,  443,  443,    0,  443,    0,    0,    0, 
          202,  202,    0,    0,    0,  202,  443,  443,    0,    0, 
            0,    0,    0,    0,    0,  443,  443,    0,  443,  443, 
          443,  443,  443,    0,    0,    0,    0,    0,    0,    0, 
          443,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  443,  443,  443,  443,  443,  443,  443, 
          443,  443,  443,  443,  443,  443,    0,  199,  443,  443, 
          443,    0,    0,  443,    0,    0,  443,  199,    0,  443, 
            0,  443,    0,  443,    0,  443,    0,  443,  443,  443, 
          443,  443,  443,  443,    0,  443,    0,  443,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  443, 
            0,  199,    0,  206,  206,  206,    0,    0,  206,  206, 
          206,    0,  206,    0,    0,  199,  199,    0,    0,    0, 
          199,    0,  206,  206,    0,    0,    0,    0,    0,    0, 
            0,  206,  206,    0,  206,  206,  206,  206,  206,    0, 
            0,    0,    0,    0,    0,    0,  206,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  206, 
          206,  206,  206,  206,  206,  206,  206,  206,  206,    0, 
          206,  206,    0,    0,  206,  206,    0,    0,    0,  206, 
            0,    0,  206,    0,    0,  206,    0,  206,    0,  206, 
          201,  206,    0,  206,  206,  206,  206,  206,  206,  206, 
          201,  206,    0,  206,  202,  202,  202,    0,    0,  202, 
          202,  202,    0,  202,    0,  206,    0,    0,    0,    0, 
            0,    0,    0,  202,  202,    0,    0,    0,    0,    0, 
            0,    0,  202,  202,  201,  202,  202,  202,  202,  202, 
            0,    0,    0,    0,    0,    0,    0,  202,  201,  201, 
            0,    0,    0,  201,    0,    0,    0,    0,    0,    0, 
          202,  202,  202,  202,  202,  202,  202,  202,  202,  202, 
            0,  202,  202,    0,    0,  202,  202,    0,    0,    0, 
          202,    0,    0,  202,    0,    0,  202,    0,  202,    0, 
          202,    0,  202,    0,  202,  202,  202,  202,  202,  202, 
          202,    0,  202,    0,  202,  200,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  200,  202,    0,    0,  199, 
          199,  199,    0,    0,  199,  199,  199,    0,  199,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  199, 
            0,    0,    0,    0,    0,    0,    0,  199,  199,  200, 
          199,  199,  199,  199,  199,    0,    0,    0,    0,    0, 
            0,    0,  199,  200,  200,    0,    0,    0,  200,    0, 
            0,    0,    0,    0,    0,  199,  199,  199,  199,  199, 
          199,  199,  199,  199,  199,    0,  199,  199,    0,    0, 
          199,  199,    0,    0,    0,  199,    0,    0,  199,    0, 
            0,  199,    0,  199,    0,  199,  203,  199,    0,  199, 
          199,  199,  199,  199,  199,  199,  203,  199,    0,  199, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  199,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          203,    0,  201,  201,  201,    0,    0,  201,  201,  201, 
            0,  201,    0,    0,  203,  203,    0,    0,    0,  203, 
            0,  201,  201,    0,    0,    0,    0,    0,    0,    0, 
          201,  201,    0,  201,  201,  201,  201,  201,    0,    0, 
            0,    0,    0,    0,    0,  201,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  201,  201, 
          201,  201,  201,  201,  201,  201,  201,  201,    0,  201, 
          201,    0,  204,  201,  201,    0,    0,    0,  201,    0, 
            0,  201,  204,    0,  201,    0,  201,    0,  201,    0, 
          201,    0,  201,  201,  201,  201,  201,  201,  201,    0, 
          201,    0,  201,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  201,    0,  204,  200,  200,  200, 
            0,    0,  200,  200,  200,    0,  200,    0,    0,    0, 
          204,  204,    0,    0,    0,  204,  200,  200,    0,    0, 
            0,    0,    0,    0,    0,  200,  200,    0,  200,  200, 
          200,  200,  200,    0,    0,    0,    0,    0,    0,    0, 
          200,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  200,  200,  200,  200,  200,  200,  200, 
          200,  200,  200,    0,  200,  200,    0,    0,  200,  200, 
            0,    0,    0,  200,    0,    0,  200,    0,    0,  200, 
            0,  200,    0,  200,  197,  200,    0,  200,  200,  200, 
          200,  200,  200,  200,  197,  200,    0,  200,  203,  203, 
          203,    0,    0,  203,  203,  203,    0,  203,    0,  200, 
            0,    0,    0,    0,    0,    0,    0,  203,  203,    0, 
            0,    0,    0,    0,    0,    0,  203,  203,  197,  203, 
          203,  203,  203,  203,    0,    0,    0,    0,    0,    0, 
            0,  203,  197,  197,    0,    0,    0,  197,    0,    0, 
            0,    0,    0,    0,  203,  203,  203,  203,  203,  203, 
          203,  203,  203,  203,    0,  203,  203,    0,    0,  203, 
          203,    0,    0,    0,  203,    0,    0,  203,    0,    0, 
          203,    0,  203,    0,  203,    0,  203,    0,  203,  203, 
          203,  203,  203,  203,  203,    0,  203,  198,  203,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,    0,    0, 
          203,    0,    0,    0,  204,  204,  204,    0,    0,  204, 
          204,  204,    0,  204,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  204,  204,    0,    0,    0,    0,    0, 
            0,  198,  204,  204,    0,  204,  204,  204,  204,  204, 
            0,    0,    0,    0,    0,  198,  198,  204,    0,    0, 
          198,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          204,  204,  204,  204,  204,  204,  204,  204,  204,  204, 
            0,  204,  204,    0,    0,  204,  204,    0,    0,    0, 
          204,    0,    0,  204,    0,    0,  204,    0,  204,    0, 
          204,  222,  204,    0,  204,  204,  204,  204,  204,  204, 
          204,  222,  204,    0,  204,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  204,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  222,  197,  197,  197,    0, 
            0,  197,  197,  197,    0,  197,    0,    0,    0,  222, 
          222,    0,    0,    0,  222,  197,  197,    0,    0,    0, 
            0,    0,    0,    0,  197,  197,    0,  197,  197,  197, 
          197,  197,    0,    0,    0,    0,    0,    0,    0,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  197,  197,  197,  197,  197,  197,  197,  197, 
          197,  197,    0,  197,  197,    0,    0,  197,  197,    0, 
            0,    0,  197,  223,    0,  197,    0,    0,  197,    0, 
          197,    0,    0,  223,  197,    0,    0,    0,  197,  197, 
          197,  197,  197,    0,  197,    0,  197,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  197,  198, 
          198,  198,    0,    0,  198,  198,  198,  223,  198,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  198,  198, 
            0,  223,  223,    0,    0,    0,  223,  198,  198,    0, 
          198,  198,  198,  198,  198,    0,    0,    0,    0,    0, 
            0,    0,  198,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  198,  198,  198,  198,  198, 
          198,  198,  198,  198,  198,    0,  198,  198,    0,    0, 
          198,  198,    0,    0,    0,  198,    0,    0,  198,    0, 
            0,  198,    0,  198,    0,    0,  209,  198,    0,    0, 
            0,  198,  198,  198,  198,  198,  209,  198,    0,  198, 
            0,    0,    0,  222,  222,  222,    0,    0,  222,  222, 
          222,  198,  222,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  222,  222,    0,    0,    0,    0,    0,    0, 
          209,  222,  222,    0,  222,  222,  222,  222,  222,    0, 
            0,    0,    0,    0,  209,  209,  222,    0,    0,  209, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  222, 
          222,  222,  222,  222,  222,  222,  222,  222,  222,    0, 
          222,  222,    0,    0,  222,  222,    0,    0,    0,  222, 
            0,    0,  222,    0,    0,  222,    0,  222,    0,    0, 
            0,  222,    0,    0,    0,    0,    0,  222,  222,  222, 
            0,  222,    0,  222,  207,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,  222,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  223,  223,  223,    0,    0, 
          223,  223,  223,    0,  223,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,  223,    0,    0,  207,    0, 
            0,    0,    0,  223,  223,    0,  223,  223,  223,  223, 
          223,    0,  207,  207,    0,    0,    0,  207,  223,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  223,  223,  223,  223,  223,  223,  223,  223,  223, 
          223,    0,  223,  223,    0,    0,  223,  223,    0,    0, 
            0,  223,    0,    0,  223,    0,    0,  223,    0,  223, 
            0,    0,  208,  223,    0,    0,    0,    0,    0,  223, 
          223,  223,  208,  223,    0,  223,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  209,  209, 
          209,    0,    0,  209,  209,  209,  208,  209,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  209,  209,    0, 
          208,  208,    0,    0,    0,  208,  209,  209,    0,  209, 
          209,  209,  209,  209,    0,    0,    0,    0,    0,    0, 
            0,  209,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  209,  209,  209,  209,  209,  209, 
          209,  209,  209,  209,    0,  209,  209,    0,    0,    0, 
            0,  212,    0,    0,  209,    0,    0,  209,    0,    0, 
          209,  212,  209,    0,    0,    0,  209,    0,    0,    0, 
            0,    0,  209,  209,  209,    0,  209,    0,  209,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          209,    0,    0,    0,    0,  212,  207,  207,  207,    0, 
            0,  207,  207,  207,    0,  207,    0,    0,    0,  212, 
          212,    0,    0,    0,  212,  207,  207,    0,    0,    0, 
            0,    0,    0,    0,  207,  207,    0,  207,  207,  207, 
          207,  207,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  207,  207,  207,  207,  207,  207,  207,  207, 
          207,  207,    0,  207,  207,    0,    0,    0,    0,    0, 
            0,  214,  207,    0,    0,  207,    0,    0,  207,    0, 
          207,  214,    0,    0,    0,    0,    0,    0,    0,    0, 
          207,  207,  207,    0,  207,    0,  207,    0,    0,    0, 
            0,    0,    0,    0,  208,  208,  208,    0,  207,  208, 
          208,  208,    0,  208,    0,  214,    0,    0,    0,    0, 
            0,    0,    0,  208,  208,    0,    0,    0,    0,  214, 
          214,    0,  208,  208,  214,  208,  208,  208,  208,  208, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,  208,  208,  208,  208,  208,  208,  208,  208,  208, 
            0,  208,  208,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  208,    0,    0,  208,    0,  208,    0, 
            0,  213,    0,    0,    0,    0,    0,    0,  208,  208, 
          208,  213,  208,    0,  208,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,  212,  212,  208,    0,  212,  212, 
          212,    0,  212,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  212,  212,    0,  213,    0,    0,    0,    0, 
            0,  212,  212,    0,  212,  212,  212,  212,  212,  213, 
          213,    0,    0,    0,  213,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  212, 
          212,  212,  212,  212,  212,  212,  212,  212,  212,    0, 
          212,  212,    0,    0,    0,    0,    0,    0,  211,  212, 
            0,    0,  212,    0,    0,  212,    0,  212,  211,    0, 
            0,    0,    0,    0,    0,    0,    0,  212,  212,    0, 
            0,    0,    0,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  212,    0,    0,    0,    0, 
            0,    0,  211,  214,  214,  214,    0,    0,  214,  214, 
          214,    0,  214,    0,    0,    0,  211,  211,    0,    0, 
            0,  211,  214,  214,    0,    0,    0,    0,    0,    0, 
            0,  214,  214,    0,  214,  214,  214, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          214,  214,    0,    0,    0,    0,    0,    0,    0,  214, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  214,  214,  214,  214,  214,  214,  214,  214, 
          214,  214,    0,  214,  214,    0,    0,    0,    0,  210, 
            0,    0,  214,    0,    0,  214,    0,    0,  214,  210, 
          214,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          214,  214,    0,    0,    0,    0,  214,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  214,    0, 
            0,    0,    0,  210,    0,    0,  213,  213,  213,    0, 
            0,  213,  213,  213,    0,  213,    0,  210,  210,    0, 
            0,    0,  210,    0,    0,  213,  213,    0,    0,    0, 
            0,    0,    0,    0,  213,  213,    0,  213,  213,  213, 
          213,  213,    0,    0,    0,    0,    0,    0,    0,  213, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,  213,  213,  213,  213,  213,  213,  213, 
          213,  213,    0,  213,  213,    0,    0,    0,    0,    0, 
            0,  215,  213,    0,    0,  213,    0,    0,  213,    0, 
          213,  215,    0,    0,    0,    0,    0,    0,    0,    0, 
          213,  213,    0,  211,  211,  211,  213,    0,  211,  211, 
          211,    0,  211,    0,    0,    0,    0,    0,  213,    0, 
            0,    0,  211,  211,    0,  215,    0,    0,    0,    0, 
            0,  211,  211,    0,  211,  211,  211,  211,  211,  215, 
          215,    0,    0,    0,  215,    0,  211,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  211, 
          211,  211,  211,  211,  211,  211,  211,  211,  211,    0, 
          211,  211,    0,    0,    0,    0,    0,    0,    0,  211, 
            0,    0,  211,    0,    0,  211,    0,  211,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  211,  211,  216, 
            0,    0,    0,  211,    0,    0,    0,    0,    0,  216, 
            0,    0,    0,    0,    0,  211,    0,    0,    0,    0, 
            0,  210,  210,  210,    0,    0,  210,  210,  210,    0, 
          210,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          210,  210,    0,  216,    0,    0,    0,    0,    0,  210, 
          210,    0,  210,  210,  210,  210,  210,  216,  216,    0, 
            0,    0,  216,    0,  210,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  210,  210,    0,    0,    0,  210,  210, 
            0,    0,    0,    0,    0,    0,  217,  210,    0,    0, 
          210,    0,    0,  210,    0,  210,  217,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  210,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  210,    0,    0,    0,    0,    0,    0, 
          217,    0,    0,  215,  215,  215,    0,    0,  215,  215, 
          215,    0,  215,    0,  217,  217,    0,    0,    0,  217, 
            0,    0,  215,  215,    0,    0,    0,    0,    0,    0, 
            0,  215,  215,    0,  215,  215,  215,  215,  215,    0, 
            0,    0,  224,    0,    0,    0,  215,    0,    0,    0, 
            0,    0,  224,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  215,  215,    0,    0,    0, 
          215,  215,    0,    0,    0,    0,    0,    0,    0,  215, 
            0,    0,  215,    0,    0,  215,  224,  215,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,  224,    0,  215,    0,  224,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  215,    0,    0,    0,    0, 
            0,  216,  216,  216,    0,    0,  216,  216,  216,    0, 
          216,    0,  218,    0,    0,    0,    0,    0,    0,    0, 
          216,  216,  218,    0,    0,    0,    0,    0,    0,  216, 
          216,    0,  216,  216,  216,  216,  216,    0,    0,    0, 
            0,    0,    0,    0,  216,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  218,    0,    0,    0, 
            0,    0,    0,  216,  216,    0,    0,    0,  216,  216, 
          218,  218,    0,    0,    0,  218,    0,  216,    0,    0, 
          216,    0,    0,  216,    0,  216,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  217,  217, 
          217,  216,    0,  217,  217,  217,    0,  217,    0,  219, 
            0,    0,    0,  216,    0,    0,    0,  217,  217,  219, 
            0,    0,    0,    0,    0,    0,  217,  217,    0,  217, 
          217,  217,  217,  217,    0,    0,    0,    0,    0,    0, 
            0,  217,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  219,    0,    0,    0,    0,    0,    0, 
          217,  217,    0,    0,    0,  217,  217,  219,  219,    0, 
            0,    0,  219,    0,  217,    0,    0,  217,    0,    0, 
          217,    0,  217,    0,  224,  224,  224,    0,    0,  224, 
          224,  224,    0,  224,    0,  225,    0,    0,  217,    0, 
            0,    0,    0,  224,  224,  225,    0,    0,    0,    0, 
          217,    0,  224,  224,    0,  224,  224,  224,  224,  224, 
            0,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
            0,    0,    0,   32,    0,    0,    0,    0,    0,  225, 
            0,    0,    0,   32,    0,    0,  224,  224,    0,    0, 
            0,  224,  224,  225,  225,    0,    0,    0,  225,    0, 
          224,    0,    0,  224,    0,    0,  224,    0,  224,    0, 
            0,    0,    0,    0,  218,  218,  218,  250,    0,  218, 
          218,  218,    0,  218,  224,  195,    0,    0,    0,    0, 
            0,    0,   32,  218,  218,  195,  224,    0,    0,    0, 
            0,    0,  218,  218,    0,  218,  218,  218,  218,  218, 
            0,    0,    0,    0,    0,    0,    0,  218,    0,    0, 
            0,    0,    0,    0,    0,  196,    0,    0,    0,  195, 
            0,    0,    0,    0,    0,  196,  218,  218,    0,    0, 
            0,  218,  218,  195,  195,    0,    0,    0,  195,    0, 
          218,    0,    0,  218,    0,    0,  218,    0,  218,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  196, 
            0,  219,  219,  219,  218,    0,  219,  219,  219,    0, 
          219,    0,    0,  196,  196,    0,  218,    0,  196,    0, 
          219,  219,    0,    0,    0,    0,    0,    0,    0,  219, 
          219,    0,  219,  219,  219,  219,  219,    0,    0,    0, 
          226,    0,    0,    0,  219,    0,    0,    0,    0,    0, 
          226,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  219,  219,    0,    0,    0,  219,  219, 
            0,    0,    0,    0,    0,    0,    0,  219,    0,    0, 
          219,    0,    0,  219,  226,  219,    0,  225,  225,  225, 
            0,    0,  225,  225,  225,    0,  225,    0,  226,  226, 
            0,  219,    0,    0,    0,    0,  225,  225,    0,    0, 
            0,    0,    0,  219,    0,  225,  225,    0,  225,  225, 
          225,  225,  225,    0,    0,   32,   32,   32,    0,    0, 
          225,   32,   32,    0,   32,    0,  194,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  194,    0,    0,    0, 
          225,    0,    0,    0,  225,  225,   32,   32,   32,   32, 
           32,    0,    0,  225,    0,    0,  225,    0,    0,  225, 
            0,  225,    0,    0,    0,    0,    0,  195,  195,  195, 
          194,    0,  195,  195,  195,    0,  195,  225,    0,    0, 
            0,    0,    0,    0,  194,  194,  195,  195,    0,  225, 
            0,    0,    0,    0,   32,  195,  195,    0,  195,  195, 
          195,  195,  195,    0,    0,    0,    0,  196,  196,  196, 
          195,  193,  196,  196,  196,   32,  196,    0,    0,    0, 
            0,  193,    0,    0,    0,    0,  196,  196,    0,    0, 
            0,    0,    0,    0,    0,  196,  196,    0,  196,  196, 
          196,  196,  196,  195,    0,    0,  195,    0,    0,  195, 
          196,  195,    0,    0,    0,  193,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  195,    0,  193, 
          193,    0,  189,    0,    0,    0,    0,    0,    0,  195, 
            0,    0,  189,  196,    0,    0,  196,    0,    0,  196, 
            0,  196,  226,  226,  226,    0,    0,  226,  226,  226, 
            0,  226,    0,    0,    0,    0,    0,  196,    0,    0, 
            0,  226,  226,    0,    0,    0,  189,    0,    0,  196, 
          226,  226,    0,  226,  226,  226,  226,  226,    0,    0, 
          189,  189,    0,    0,    0,  226,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  226,  190, 
            0,  226,    0,    0,  226,    0,  226,    0,    0,  190, 
            0,    0,    0,    0,    0,    0,    0,    0,  194,  194, 
          194,    0,  226,  194,  194,  194,    0,  194,    0,    0, 
            0,    0,    0,    0,  226,    0,    0,  194,  194,    0, 
            0,    0,    0,  190,    0,    0,  194,  194,    0,  194, 
          194,  194,  194,  194,    0,    0,    0,  190,  190,    0, 
            0,  194,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  191,    0,    0,    0,    0, 
            0,    0,    0,    0,  194,  191,    0,  194,    0,    0, 
          194,    0,  194,  193,  193,  193,    0,    0,  193,  193, 
          193,    0,  193,    0,    0,    0,    0,    0,  194,    0, 
            0,    0,  193,  193,    0,    0,    0,    0,    0,  191, 
          194,  193,  193,    0,  193,  193,  193,  193,  193,    0, 
            0,    0,    0,  191,  191,    0,  193,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  189,  189,  189,    0,    0,  189, 
          189,  189,    0,  189,    0,    0,    0,    0,    0,  193, 
            0,    0,  193,  189,  189,  193,    0,  193,    0,    0, 
            0,    0,  189,  189,  192,  189,  189,  189,  189,  189, 
            0,    0,    0,  193,  192,    0,    0,  189,    0,    0, 
            0,    0,    0,    0,    0,  193,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  192,    0, 
          189,    0,    0,  189,    0,    0,  189,    0,  189,    0, 
            0,    0,  192,  192,    0,  185,    0,    0,    0,    0, 
            0,  190,  190,  190,  189,  185,  190,  190,  190,    0, 
          190,    0,    0,    0,    0,    0,  189,    0,    0,    0, 
          190,  190,    0,    0,    0,    0,    0,    0,    0,  190, 
          190,    0,  190,  190,  190,  190,  190,    0,    0,  185, 
            0,    0,    0,    0,  190,    0,    0,    0,    0,    0, 
            0,    0,    0,  185,  185,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  190,    0,    0, 
          190,  187,    0,  190,    0,  190,    0,  191,  191,  191, 
            0,  187,  191,  191,  191,    0,  191,    0,    0,    0, 
            0,  190,    0,    0,    0,    0,  191,  191,    0,    0, 
            0,    0,    0,  190,    0,  191,  191,    0,  191,  191, 
          191,  191,  191,    0,    0,  187,    0,    0,    0,    0, 
          191,    0,    0,    0,    0,    0,   34,    0,    0,  187, 
          187,    0,    0,    0,    0,    0,   34,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  191,    0,    0,  191,    0,    0,  191, 
            0,  191,    0,    0,    0,    0,    0,    0,  227,    0, 
            0,    0,    0,    0,    0,    0,    0,  191,  227,    0, 
            0,    0,    0,    0,    0,   34,  192,  192,  192,  191, 
            0,  192,  192,  192,    0,  192,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  192,  192,    0,    0,    0, 
            0,    0,  227,    0,  192,  192,    0,  192,  192,  192, 
          192,  192,    0,    0,    0,    0,  227,  227,  256,  192, 
            0,    0,    0,    0,    0,    0,    0,    0,  256,    0, 
            0,    0,    0,    0,    0,    0,    0,  185,  185,  185, 
            0,    0,  185,  185,  185,    0,  185,    0,    0,    0, 
            0,    0,  192,    0,    0,  192,  185,  185,  192,    0, 
          192,    0,  251,    0,    0,  185,  185,    0,  185,  185, 
          185,  185,  185,    0,    0,    0,  192,  256,    0,    0, 
          185,    0,  188,    0,    0,    0,    0,    0,  192,    0, 
            0,    0,  188,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  185,    0,    0,  185,    0,    0,  185, 
            0,  185,    0,  187,  187,  187,  188,    0,  187,  187, 
          187,    0,  187,    0,    0,    0,    0,  185,    0,    0, 
          188,  188,  187,  187,    0,    0,    0,    0,    0,  185, 
            0,  187,  187,    0,  187,  187,  187,  187,  187,    0, 
            0,    0,    0,    0,    0,    0,  187,    0,    0,    0, 
            0,    0,  186,    0,    0,    0,    0,    0,   34,   34, 
           34,    0,  186,    0,   34,   34,    0,   34,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  187, 
            0,    0,  187,    0,    0,  187,    0,  187,    0,   34, 
           34,   34,   34,   34,    0,    0,  186,    0,    0,    0, 
          227,  227,  227,  187,    0,  227,  227,  227,    0,  227, 
          186,  186,    0,  184,    0,  187,    0,    0,    0,  227, 
          227,    0,    0,  184,    0,    0,    0,    0,  227,  227, 
            0,  227,  227,  227,  227,  227,    0,   34,    0,    0, 
            0,    0,    0,  227,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  184,   34,    0, 
          256,  256,  256,    0,    0,  256,  256,  256,    0,  256, 
            0,  184,  184,    0,    0,    0,  227,    0,    0,  227, 
            0,    0,  227,    0,  227,    0,    0,    0,    0,    0, 
            0,  256,  256,  256,  256,  256,    0,    0,    0,    0, 
          227,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  188,  188,  188,    0,    0,  188, 
          188,  188,    0,  188,    0,    0,  256,    0,    0,  256, 
            0,    0,    0,  188,  188,   96,    0,    0,    0,    0, 
            0,    0,  188,  188,    0,  188,  188,  188,  188,  188, 
          256,    0,    0,    0,    0,    0,    0,  188,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   96,    0,    0,    0,    0,    0, 
          188,    0,    0,  188,    0,    0,  188,    0,  188,    0, 
            0,    0,    0,    0,  186,  186,  186,    0,    0,  186, 
          186,  186,    0,  186,  188,    0,  444,    0,    0,    0, 
            0,    0,    0,  186,  186,    0,  188,    0,    0,    0, 
            0,    0,  186,  186,    0,  186,  186,  186,  186,    0, 
            0,    0,    0,    0,    0,    0,    0,  186,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   97,    0,    0,    0,  184,  184,  184,    0,    0, 
          184,  184,  184,    0,  184,    0,    0,    0,    0,    0, 
          186,    0,    0,  186,  184,  184,  186,    0,  186,    0, 
            0,    0,    0,  184,  184,    0,  184,  184,  184,  184, 
            0,    0,    0,    0,  186,    0,    0,    0,  184,    0, 
           97,    0,    0,    0,    0,    0,  186,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  184,  447,    0,  184,    0,    0,  184,    0,  184, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  184,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  184,    0,    0, 
            0,   96,   96,   96,   96,   96,   96,   96,   96,   96, 
           96,   96,    0,   96,   96,   96,    0,   96,   96,   96, 
           96,   96,   96,   96,    0,  515,    0,    0,   96,   96, 
           96,   96,   96,   96,   96,    0,    0,   96,    0,    0, 
            0,    0,    0,   96,   96,   96,   96,   96,   96,   96, 
            0,   96,   96,   96,   96,   96,   96,    0,   96,   96, 
           96,   96,   96,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  444,    0,    0,    0,    0,    0,    0, 
          444,   96,    0,    0,   96,  515,    0,   96,   96,    0, 
           96,    0,   96,    0,  522,    0,   96,    0,    0,    0, 
            0,   96,    0,    0,   96,    0,  515,    0,    0,   96, 
           96,   96,   96,   96,   96,    0,    0,    0,   96,    0, 
           96,   96,    0,   96,   96,    0,    0,   97,   97,   97, 
           97,   97,   97,   97,   97,   97,   97,   97,    0,   97, 
           97,   97,    0,   97,   97,   97,   97,   97,   97,   97, 
            0,  516,    0,    0,   97,   97,   97,   97,   97,   97, 
           97,    0,    0,   97,    0,    0,    0,    0,    0,   97, 
           97,   97,   97,   97,   97,   97,    0,   97,   97,   97, 
           97,   97,   97,    0,   97,   97,   97,   97,   97,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  447, 
            0,    0,    0,    0,    0,    0,  447,   97,    0,    0, 
           97,  516,    0,   97,   97,    0,   97,    0,   97,    0, 
          270,    0,   97,    0,    0,    0,    0,   97,    0,    0, 
           97,    0,  516,    0,    0,   97,   97,   97,   97,   97, 
           97,    0,    0,    0,   97,    0,   97,   97,    0,   97, 
           97,    0,    0,    0,    0,    0,    0,    0,    0,   96, 
           96,   96,   96,   96,   96,   96,   96,   96,   96,   96, 
            0,   97,   96,   96,    0,   96,   96,   96,   96,   96, 
           96,   96,    0,  522,    0,    0,   96,   96,   96,   96, 
           96,   96,   96,    0,    0,   96,    0,    0,    0,    0, 
            0,   96,   96,   96,   96,   96,   96,   96,    0,   96, 
           96,   96,   96,   96,   96,    0,   96,   96,   96,   96, 
           97,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  522,    0,    0,    0,    0,    0,    0,  522,   96, 
            0,    0,   96,  518,    0,   96,   96,    0,   96,    0, 
           96,    0,  271,    0,   96,    0,    0,    0,    0,   96, 
            0,    0,   96,    0,  522,    0,    0,   96,   96,   96, 
           96,   96,   96,    0,    0,    0,   96,    0,   96,   96, 
            0,   96,   96,    0,    0,   97,   97,   97,   97,   97, 
           97,   97,   97,   97,   97,   97,    0,  315,   97,   97, 
            0,   97,   97,   97,   97,   97,   97,   97,    0,    0, 
            0,    0,   97,   97,   97,   97,   97,   97,   97,    0, 
            0,   97,    0,    0,    0,    0,    0,   97,   97,   97, 
           97,   97,   97,   97,    0,   97,   97,   97,   97,   97, 
           97,    0,   97,   97,   97,   97,  315,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  270,    0,    0, 
            0,    0,    0,    0,  270,   97,    0,    0,   97,  519, 
            0,   97,   97,    0,   97,    0,   97,    0,    0,    0, 
           97,    0,    0,    0,    0,   97,    0,    0,   97,    0, 
            0,    0,    0,   97,   97,   97,   97,   97,   97,    0, 
            0,    0,   97,    0,   97,   97,    0,   97,   97,    0, 
            0,    0,    0,    0,    0,    0,    0,   97,   97,   97, 
           97,   97,   97,   97,   97,   97,   97,   97,    0,  540, 
           97,   97,    0,   97,   97,   97,   97,   97,   97,   97, 
            0,    0,    0,    0,   97,   97,   97,   97,   97,   97, 
           97,    0,    0,   97,    0,    0,    0,    0,    0,   97, 
           97,   97,   97,   97,   97,   97,    0,   97,   97,   97, 
           97,   97,   97,    0,   97,   97,   97,   97,  540,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  271, 
            0,    0,    0,    0,    0,    0,  271,   97,    0,    0, 
           97,    0,    0,   97,   97,    0,   97,    0,   97,    0, 
            0,    0,   97,    0,    0,    0,    0,   97,    0,    0, 
           97,    0,    0,    0,    0,   97,   97,   97,   97,   97, 
           97,    0,    0,    0,   97,    0,   97,   97,    0,   97, 
           97,    0,    0,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,    0,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  540,    0,    0,    0, 
          315,  315,  315,  315,  315,  315,  315,    0,    0,  315, 
            0,    0,    0,    0,    0,  315,  315,  315,  315,  315, 
          315,  315,    0,  315,  315,  315,  315,  315,  315,    0, 
          315,  315,  315,  315,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  540,    0,    0,    0,    0, 
            0,    0,    0,  315,    0,    0,  315,    0,    0,  315, 
          315,    0,  315,    0,  315,    0,    0,    0,  315,    0, 
            0,    0,    0,    0,    0,    0,  315,    0,    0,    0, 
            0,  315,  315,  315,  315,  315,  315,    0,    0,    0, 
          315,    0,  315,  315,    0,  315,  315,    0,    0,    0, 
            0,    0,    0,    0,    0,  540,  540,  540,  540,  540, 
          540,    0,    0,  540,  540,  540,    0,    0,    0,  540, 
          227,  540,  540,  540,  540,  540,  540,  540,    0,    0, 
            0,    0,  540,  540,  540,  540,  540,  540,  540,    0, 
            0,  540,    0,    0,    0,    0,    0,  540,  540,  540, 
          540,  540,  540,  540,    0,  540,  540,  540,  540,  540, 
          540,    0,  540,  540,  540,  540,    0,    0,    0,  226, 
            0,   14,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   14,    0,    0,    0,  540,    0,    0,  540,    0, 
            0,  540,  540,    0,  540,    0,  540,    0,    0,    0, 
          540,    0,    0,    0,    0,    0,    0,    0,  540,    0, 
            0,    0,    0,  540,  540,  540,  540,  540,  540,    0, 
            0,    0,  540,    0,  540,  540,    0,  540,  540,    0, 
           14,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  540,  540,  540,  540,  540,  540,    0,    0, 
            0,  540,  540,    0,    0,    0,  540,    0,  540,  540, 
          540,  540,  540,  540,  540,    0,    0,  184,    0,  540, 
          540,  540,  540,  540,  540,  540,    0,  184,  540,    0, 
            0,    0,    0,    0,  540,  540,  540,  540,  540,  540, 
          540,    0,  540,  540,  540,  540,  540,  540,    0,  540, 
          540,  540,  540,    0,    0,    0,    0,    0,    0,    0, 
            0,  229,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  540,    0,    0,  540,  184,    0,  540,  540, 
            0,  540,    0,  540,    0,    0,    0,  540,    0,    0, 
            0,    0,    0,    0,    0,  540,    0,  384,  540,    0, 
          540,  540,  540,  540,  540,  540,    0,  384,    0,  540, 
            0,  540,  540,    0,  540,  540,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,   81,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,  384,    0,   89,   28, 
          384,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,   14,   14,   14,    0,    0,  384,   14, 
           14,    0,   14,    0,    0,    0,  217,    0,  310,  111, 
            0,    0,   46,   47,    0,   48,    0,    0,  310,    0, 
            0,   50,    0,    0,   14,   14,   14,   14,   14,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            0,    0,  310,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  310,    0,    0, 
            0,  310,   14,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  184, 
          184,  184,    0,   14,    0,  184,  184,    0,  184,  310, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  311,    0,    0,  184,  184,    0, 
          184,  184,  184,  184,  311,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  311,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  184,  384, 
          384,  384,    0,  311,    0,  384,  384,  311,  384,    0, 
            0,    0,    0,    0,    0,    0,    0,  384,    0,  184, 
            0,    0,    0,    0,    0,    0,    0,  384,  384,    0, 
          384,  384,  384,  384,  384,  311,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  384,  384,  384,  384,  384,  384, 
          384,  384,  384,  384,  384,  384,  384,  384,    0,    0, 
          384,  384,  384,    0,    0,    0,    0,    0,  384,    0, 
            0,    0,    0,    0,    0,  384,  274,  384,    0,  384, 
          384,  384,  384,  384,  384,  384,  274,  384,  384,  384, 
          310,  310,  310,    0,    0,  310,  310,  310,    0,  310, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  310, 
            0,    0,    0,    0,    0,    0,    0,    0,  310,  310, 
          274,  310,  310,  310,  310,  310,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  274,    0,    0,    0,  274, 
            0,    0,    0,    0,    0,  310,  310,  310,  310,  310, 
          310,  310,  310,  310,  310,  310,  310,  310,  310,    0, 
            0,  310,  310,  310,    0,    0,    0,  274,    0,  310, 
            0,    0,    0,    0,    0,    0,  310,    0,  310,  456, 
          310,  310,  310,  310,  310,  310,  310,    0,  310,  456, 
          310,    0,    0,    0,    0,    0,  311,  311,  311,    0, 
            0,  311,  311,  311,    0,  311,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  311,    0,    0,    0,    0, 
            0,    0,    0,   80,  311,  311,    0,  311,  311,  311, 
          311,  311,    0,    0,    0,    0,    0,    0,  456,    0, 
           88,    0,  456,    0,    0,    0,    0,    0,    0,    0, 
            0,  311,  311,  311,  311,  311,  311,  311,  311,  311, 
          311,  311,  311,  311,  311,    0,    0,  311,  311,  311, 
          456,    0,    0,    0,    0,  311,    0,    0,    0,    0, 
            0,    0,  311,    0,  311,    0,  311,  311,  311,  311, 
          311,  311,  311,  264,  311,    0,  311,    0,    0,    0, 
            0,    0,    0,  264,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   87,  274,  274, 
          274,    0,    0,  274,  274,  274,    0,  274,    0,    0, 
            0,    0,  264,    0,   95,    0,  264,  274,    0,    0, 
            0,    0,    0,    0,    0,    0,  274,  274,    0,  274, 
          274,  274,  274,  274,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  264,    0,    0,    0,    0,    0, 
            0,    0,    0,  274,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,  274,  274,  274,  274,    0,    0,  274, 
          274,  274,    0,    0,    0,    0,    0,  274,    0,    0, 
            0,    0,    0,    0,  274,    0,  274,  271,  274,  274, 
          274,  274,  274,  274,  274,    0,  274,  271,  274,    0, 
            0,  456,  456,  456,    0,    0,    0,  456,  456,    0, 
          456,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  456, 
          456,   86,  456,  456,  456,  456,  456,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  271,    0,   94,    0, 
          271,    0,    0,    0,    0,    0,  456,  456,  456,  456, 
          456,  456,  456,  456,  456,  456,  456,  456,  456,  456, 
            0,    0,  456,  456,  456,    0,  457,    0,  271,    0, 
          456,    0,    0,    0,    0,    0,    0,  456,    0,  456, 
            0,  456,  456,  456,  456,  456,  456,  456,  250,  456, 
            0,  456,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,    0,    0,    0,    0,  264,  264,  264,    0,    0, 
            0,  264,  264,    0,  264,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  252,  250,  264,  264,    0,  264,  264,  264,  264, 
          264,  252,    0,    0,    0,    0,    0,  250,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          264,  264,  264,  264,  264,  264,  264,  264,  264,  264, 
          264,  264,  264,  264,    0,  252,  264,  264,  264,    0, 
            0,    0,    0,    0,  264,    0,    0,    0,    0,    0, 
          252,  264,   56,  264,    0,  264,  264,  264,  264,  264, 
          264,  264,   56,  264,    0,  264,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   47,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   47,  271, 
          271,  271,    0,    0,    0,  271,  271,    0,  271,    0, 
            0,   56,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  271,  271,    0, 
          271,  271,  271,  271,  271,    0,    0,    0,    0,  254, 
            0,    0,    0,    0,    0,    0,    0,   47,    0,  254, 
            0,    0,    0,    0,  271,  271,  271,  271,  271,  271, 
          271,  271,  271,  271,  271,  271,  271,  271,    0,    0, 
          271,  271,  271,    0,    0,    0,  255,    0,  271,    0, 
            0,    0,    0,  252,    0,  271,  255,  271,    0,  271, 
          271,  271,  271,  271,  271,  271,    0,  271,  254,  271, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          250,  250,  250,    0,    0,  250,  250,  250,    0,  250, 
          253,    0,    0,    0,    0,    0,    0,    0,    0,  250, 
          250,    0,    0,    0,    0,  255,    0,    0,  250,  250, 
            0,  250,  250,  250,  250,  250,    0,    0,    0,    0, 
            0,    0,    0,  252,  252,  252,    0,    0,  252,  252, 
          252,    0,  252,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  252,  252,    0,    0,    0,    0,    0,    0, 
            0,  252,  252,    0,  252,  252,  252,  252,  252,  250, 
            0,    0,  250,    0,  250,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          250,  570,    0,    0,   56,   56,   56,    0,    0,   56, 
           56,   56,    0,   56,    0,    0,    0,    0,    0,    0, 
            0,    0,  252,   56,   56,  252,    0,  252,    0,    0, 
            0,    0,   56,   56,    0,   56,   56,   56,   56,   56, 
           47,   47,   47,  252,    0,   47,   47,   47,    0,   47, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   47, 
            0,    0,    0,    0,    0,    0,    0,    0,   47,   47, 
            0,   47,   47,   47,   47,   47,    0,    0,    0,    0, 
            0,    0,    0,   56,    0,    0,   56,    0,    0,    0, 
            0,  254,  254,  254,    0,    0,  254,  254,  254,    0, 
          254,    0,    0,    0,   56,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   47, 
            0,    0,  254,  254,  254,  254,  254,    0,  255,  255, 
          255,    0,    0,  255,  255,  255,    0,  255,    0,  407, 
           47,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,    0,    0,  255,  255,  255,  255,  255,    0,    0, 
            0,  254,    0,    0,  254,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  255,    0, 
            0,  255,    0,    0,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,  255,   12,   13,   14,   99,  100,   17,   18, 
            0,    0,    0,    0,  101,  102,  103,   22,   23,   24, 
           25,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
          105,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,    0,    0,  108,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  288,    0,    0, 
          111,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    3,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,  275,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   99,  100,   17,   18,    0,    0,    0, 
            0,  101,   20,   21,   22,   23,   24,   25,    0,    0, 
          104,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
          241,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  217,    0,    0,  111,    0,    0, 
           46,   47,    0,   48,    0,  242,    0,  243,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  244,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   99,  100,   17,   18, 
            0,    0,    0,    0,  101,  102,  103,   22,   23,   24, 
           25,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,  241,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  217,    0,    0, 
          111,    0,    0,   46,   47,    0,   48,    0,  625,    0, 
          243,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          244,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,  244,  244,  244,    0,  244,    0,    0,    0,  244, 
          244,    0,    0,    0,  244,    0,  244,  244,  244,  244, 
          244,  244,  244,    0,    0,    0,    0,  244,  244,  244, 
          244,  244,  244,  244,    0,    0,  244,    0,    0,    0, 
            0,    0,    0,  244,    0,    0,  244,  244,  244,    0, 
          244,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
          244,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          244,    0,    0,  244,    0,    0,  244,  244,    0,  244, 
            0,  244,    0,  244,    0,  244,    0,    0,    0,    0, 
            0,    0,    0,  244,    0,    0,    0,    0,  244,  244, 
          244,  244,  244,  244,    0,    0,    0,  244,    0,  244, 
          244,    0,  244,  244,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,    0,    0,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,  241, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,  111,    0,    0,   46, 
           47,    0,   48,    0,  242,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  244,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   99,  100,   17,   18,    0, 
            0,    0,    0,  101,  102,  103,   22,   23,   24,   25, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,  241,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  217,    0,    0,  111, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,  243, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  244, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   99,  100, 
           17,   18,    0,    0,    0,    0,  101,  102,  103,   22, 
           23,   24,   25,    0,    0,  104,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,  241,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
            0,    0,  111,    0,    0,   46,   47,    0,   48,    0, 
          625,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  244,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  217,    0,    0,  111,  261,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   99,  100,   17,   18,    0,    0, 
            0,    0,  101,  102,  103,   22,   23,   24,   25,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,  241,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,    0,    0,  111,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   99,  100,   17, 
           18,    0,    0,    0,    0,  101,  102,  103,   22,   23, 
           24,   25,    0,    0,  104,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  217,    0, 
            0,  111,  437,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  244,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,  104,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  217,    0,    0,  111,    0,    0,   46,   47,    0, 
           48,    0,  563,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  244,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   99,  100,   17,   18,    0,    0,    0, 
            0,  101,  102,  103,   22,   23,   24,   25,    0,    0, 
          104,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  217,    0,    0,  111,    0,    0, 
           46,   47,    0,   48,    0,  563,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  244,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   99,  100,   17,   18, 
            0,    0,    0,    0,  101,  102,  103,   22,   23,   24, 
           25,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  217,    0,    0, 
          111,    0,    0,   46,   47,    0,   48,    0,  242,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          244,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   99, 
          100,   17,   18,    0,    0,    0,    0,  101,  102,  103, 
           22,   23,   24,   25,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,    0,    0,  111,    0,    0,   46,   47,    0,   48, 
            0,  803,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  244,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,    0,    0,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,  111,    0,    0,   46, 
           47,    0,   48,    0,  625,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  244,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,  529,  529,  529, 
            0,  529,    0,    0,    0,  529,  529,    0,    0,    0, 
          529,    0,  529,  529,  529,  529,  529,  529,  529,    0, 
            0,    0,    0,  529,  529,  529,  529,  529,  529,  529, 
            0,    0,  529,    0,    0,    0,    0,    0,    0,  529, 
            0,    0,  529,  529,  529,    0,  529,  529,  529,  529, 
          529,  529,    0,  529,  529,  529,  529,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  529,    0,    0,  529, 
          529,    0,  529,  529,    0,  529,    0,    0,    0,    0, 
            0,  529,    0,    0,    0,    0,    0,    0,    0,  529, 
            0,    0,    0,    0,  529,  529,  529,  529,  529,  529, 
            0,    0,    0,  529,    0,  529,  529,    0,  529,  529, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
            0,    0,  111,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   99,  100,   17,   18,    0,    0,    0,    0,  101, 
          102,  103,   22,   23,   24,   25,    0,    0,  104,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  217,    0,    0,  111,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  244,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,    0,    0,  111,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   99,  100,   17, 
           18,    0,    0,    0,    0,  101,  102,  103,   22,   23, 
           24,   25,    0,    0,  104,    0,    0,    0,    0,    0, 
            0,  105,    0,    0,   31,   32,   33,    0,  106,   35, 
           36,   37,  107,   39,    0,   40,    0,    0,  108,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  109,    0,    0,  110,    0, 
            0,  111,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           99,  100,   17,   18,    0,    0,    0,    0,  101,  102, 
          103,   22,   23,   24,   25,    0,    0,  104,    0,    0, 
            0,    0,    0,    0,  105,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,    0, 
            0,  108,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  234,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   99,  100,   17,   18,    0,    0,    0, 
            0,  101,  102,  103,   22,   23,   24,   25,    0,    0, 
          104,    0,    0,    0,    0,    0,    0,  105,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,    0,    0,  108,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  288,    0,    0,  364,    0,    0, 
           46,   47,    0,   48,    0,  365,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   99,  100,   17,   18, 
            0,    0,    0,    0,  101,  102,  103,   22,   23,   24, 
           25,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
          105,    0,    0,   31,   32,   33,    0,  106,   35,   36, 
           37,  107,   39,    0,   40,    0,    0,  108,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  110,    0,    0, 
          111,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   99, 
          100,   17,   18,    0,    0,    0,    0,  101,  102,  103, 
           22,   23,   24,   25,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,  105,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,    0, 
          108,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          288,    0,    0,  364,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,    0,    0,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,  105,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,    0,    0,  108,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  813,    0,    0,  111,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   99,  100,   17,   18,    0, 
            0,    0,    0,  101,  102,  103,   22,   23,   24,   25, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,  105, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,    0,  108,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  888,    0,    0,  111, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
          120,  121,  122,  123,  124,  125,  126,  127,    0,    0, 
          128,  129,  130,  131,  132,    0,    0,  133,  134,  135, 
          136,  137,  138,  139,    0,    0,  140,  141,  142,  200, 
          201,  202,  203,  147,  148,  149,  150,  151,  152,  153, 
          154,  155,  156,  157,  158,  204,  205,  206,    0,  207, 
          163,  263,    0,  208,    0,    0,    0,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,    0,    0,  194,   52,  120,  121, 
          122,  123,  124,  125,  126,  127,    0,    0,  128,  129, 
          130,  131,  132,    0,    0,  133,  134,  135,  136,  137, 
          138,  139,    0,    0,  140,  141,  142,  200,  201,  202, 
          203,  147,  148,  149,  150,  151,  152,  153,  154,  155, 
          156,  157,  158,  204,  205,  206,    0,  207,  163,    0, 
            0,  208,    0,    0,    0,  165,  166,    0,  167,  168, 
          169,  170,  171,  172,  173,    0,    0,  174,  175,    0, 
            0,    0,  176,  177,  178,  179,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  181,  182, 
            0,  183,  184,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,    0,    0,  194,   52,  120,  121,  122,  123, 
          124,  125,  126,  127,    0,    0,  128,  129,  130,  131, 
          132,    0,    0,  133,  134,  135,  136,  137,  138,  139, 
            0,    0,  140,  141,  142,  143,  144,  145,  146,  147, 
          148,  149,  150,  151,  152,  153,  154,  155,  156,  157, 
          158,  159,  160,  161,    0,  162,  163,   36,   37,  164, 
           39,    0,    0,  165,  166,    0,  167,  168,  169,  170, 
          171,  172,  173,    0,    0,  174,  175,    0,    0,    0, 
          176,  177,  178,  179,    0,    0,    0,    0,    0,  180, 
            0,    0,    0,    0,    0,    0,  181,  182,    0,  183, 
          184,  185,  186,  187,  188,  189,  190,  191,  192,  193, 
            0,    0,  194,  120,  121,  122,  123,  124,  125,  126, 
          127,    0,    0,  128,  129,  130,  131,  132,    0,    0, 
          133,  134,  135,  136,  137,  138,  139,    0,    0,  140, 
          141,  142,  200,  201,  202,  203,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  204,  205, 
          206,    0,  207,  163,  297,  298,  208,  299,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,    0,    0,  194, 
          120,  121,  122,  123,  124,  125,  126,  127,    0,    0, 
          128,  129,  130,  131,  132,    0,    0,  133,  134,  135, 
          136,  137,  138,  139,    0,    0,  140,  141,  142,  200, 
          201,  202,  203,  147,  148,  149,  150,  151,  152,  153, 
          154,  155,  156,  157,  158,  204,  205,  206,    0,  207, 
          163,    0,    0,  208,    0,    0,    0,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  618,  544,  194,    0,  619,    0, 
            0,    0,  165,  166,    0,  167,  168,  169,  170,  171, 
          172,  173,    0,    0,  174,  175,    0,    0,    0,  176, 
          177,  178,  179,    0,    0,    0,    0,    0,  258,    0, 
            0,    0,    0,    0,    0,  181,  182,    0,  183,  184, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  620, 
          550,  194,    0,  621,    0,    0,    0,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,    0, 
            0,    0,    0,  258,    0,    0,    0,    0,    0,    0, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  645,  544,  194,    0,  646,    0, 
            0,    0,  165,  166,    0,  167,  168,  169,  170,  171, 
          172,  173,    0,    0,  174,  175,    0,    0,    0,  176, 
          177,  178,  179,    0,    0,    0,    0,    0,  258,    0, 
            0,    0,    0,    0,    0,  181,  182,    0,  183,  184, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  647, 
          550,  194,    0,  648,    0,    0,    0,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,    0, 
            0,    0,    0,  258,    0,    0,    0,    0,    0,    0, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  900,  544,  194,    0,  901,    0, 
            0,    0,  165,  166,    0,  167,  168,  169,  170,  171, 
          172,  173,    0,    0,  174,  175,    0,    0,    0,  176, 
          177,  178,  179,    0,    0,    0,    0,    0,  258,    0, 
            0,    0,    0,    0,    0,  181,  182,    0,  183,  184, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  902, 
          550,  194,    0,  903,    0,    0,    0,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,    0, 
            0,    0,    0,  258,    0,    0,    0,    0,    0,    0, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  931,  550,  194,    0,  932,    0, 
            0,    0,  165,  166,    0,  167,  168,  169,  170,  171, 
          172,  173,    0,    0,  174,  175,    0,    0,    0,  176, 
          177,  178,  179,    0,    0,    0,    0,    0,  258,    0, 
            0,    0,    0,    0,    0,  181,  182,    0,  183,  184, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  557, 
          544,  194,    0,  558,    0,    0,    0,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,    0,    0,  194, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            6,    7,    7,  358,   27,  391,    2,    3,    4,    5, 
           47,   48,    8,    9,   10,   11,   10,   10,   14,   15, 
           16,   27,   27,   19,   28,  225,    6,  382,   11,  404, 
           26,   15,   16,  311,    7,   19,   49,  283,   10,   21, 
          286,  383,  250,  409,  399,   10,   52,   91,   10,   45, 
           46,   94,   10,   49,   27,   51,   10,   10,  413,   91, 
           10,   10,  311,  110,  464,   10,   59,   10,   11,   10, 
          675,  669,   52,   10,   10,  303,    4,    5,  677,  307, 
           79,  854,  759,   65,   51,   10,   14,   59,   10,   10, 
          340,   44,  280,    2,    3,   10,   79,   59,   94,    8, 
          275,  105,  340,   61,  328,   14,   59,  385,  463,   59, 
           59,  335,   59,  109,   59,  111,  356,  357,   59,  359, 
          360,   49,   44,   44,   61,   61,   10,   10,   10,   10, 
           10,   10,  115,   32,   59,  505,   45,   59,   59,   10, 
          380,   59,  325,   10,   59,   59,   10,  920,  761,   10, 
           10,   10,   10,   47,   10,  832,   10,  397,  398,   10, 
          361,   44,   10,   44,   10,   44,   94,    3,    0,  310, 
          570,  411,  542,  361,  486,  358,   59,   61,   10,    2, 
            3,   61,   61,   10,  305,    8,    9,   10,   11,  364, 
          664,   10,   15,   16,   10,   59,   19,   10,   10,   59, 
           61,  441,  111,   26,  881,   44,  680,   10,   10,  487, 
           61,   10,   45,   44,  305,   61,   21,   32,   44,   10, 
           59,  461,   45,   46,  610,  422,   10,   59,   51,  228, 
           61,  836,  909,   59,  308,  280,  232,  233,  487,  581, 
          838,  367,   61,   10,  843,  228,  289,  852,   61,  477, 
          592,   10,  691,  374,  378,  379,   59,  454,  697,  255, 
           65,  257,  258,  256,  390,  261,  879,  344,  290,  291, 
           61,  255,  268,  257,  258,   59,  587,  378,  379,  275, 
          370,  371,  372,  374,  328,  362,  109,  377,  111,  232, 
          233,  335,   59,  289,   32,  340,  328,  608,  103,   10, 
           59,  375,  376,  335,   10,  269,  780,  271,  113,  709, 
           91,  622,  590,  328,  267,  685,  361,  365,  267,  281, 
          335,  279,  267,  264,  320,  321,  322,  323,  324,  325, 
          326,  327,  419,   44,  381,  422,  290,  291,  649,  264, 
          282,  590,  279,  279,  269,  267,  658,  659,  337,  264, 
          344,  357,  365,   59,  269,  305,  271,   44,  305,  268, 
          306,  289,  358,  356,  310,  361,  275,  363,  364,  365, 
            0,  367,  368,   61,  358,  381,  341,  743,  321,  322, 
          323,  324,  419,  341,  305,  338,  382,  383,  384,  338, 
          362,  341,  398,  376,  361,  279,  363,  643,  382,  395, 
          367,  368,  680,  399,  341,  341,  412,  403,    2,  232, 
          233,  320,  612,  436,  451,  399,  325,  413,  279,  627, 
          341,  464,  305,  305,  374,  408,  409,  374,  279,  413, 
          436,  436,  255,  279,  257,  258,  442,  365,  261,  825, 
          358,  437,  275,  439,  358,  268,    0,  759,  279,  761, 
          825,   45,  275,  374,   61,  364,  462,  341,  341,  341, 
          279,  341,  341,  436,  267,  807,  279,  463,  464,  363, 
          341,  370,  371,  367,  383,  358,  358,  341,  377,  463, 
          341,  341,  341,  341,  320,  341,  395,  341,  279,  325, 
          341,  374,  374,  341,  403,  341,  390,  320,  321,  322, 
          323,  324,  325,  326,  327,  340,    2,    3,    4,    5, 
            6,  405,    8,  337,  341,  870,   44,  111,   14,  358, 
          832,  833,  341,  723,  866,  341,  262,  570,  341,  341, 
          439,  364,  358,  264,  812,  358,  464,  541,  361,  341, 
          363,  364,  341,  372,  367,  368,  310,  328,  377,   45, 
          341,  356,  556,   49,  335,   44,  262,  263,  264,  382, 
          383,  384,  337,  269,  546,  261,   91,  879,   91,  881, 
          552,  594,  395,   61,  570,  380,  399,  559,  560,  337, 
          403,   10,  278,  587,  580,  581,  372,  593,  594,  594, 
          413,  377,  397,  904,  271,  578,  592,  909,   94,   59, 
           91,  644,   91,  599,  608,   44,  411,  310,  591,  268, 
          269,    2,    3,  593,  437,  111,  439,    8,  622,  279, 
          820,  594,  338,   91,   10,  263,  264,  623,  868,   44, 
           59,  269,  262,  263,  264,   44,  441,  580,  268,  269, 
          463,  271,  570,  370,  371,  649,  263,  264,  644,  361, 
          377,   91,   91,  380,   45,  651,  461,    2,    3,    4, 
            5,   54,   55,    8,  559,  560,  709,  317,  317,   14, 
          317,  317,  581,   59,  268,   10,  672,  673,  341,  337, 
          623,  275,  344,  592,  308,  309,  682,  311,  684,  362, 
          599,  687,  688,  689,   44,   15,   16,  310,  694,   19, 
           45,   44,  348,  372,   49,   91,  352,  353,  262,  263, 
          264,  341,  346,  709,  268,  269,  644,  271,   44,  372, 
          111,  688,  689,   44,   59,   44,  722,  694,  424,  712, 
          726,  340,  362,  729,  430,  431,  269,  267,  264,  341, 
           10,  546,  651,  739,  740,  741,   10,  552,  362,   94, 
          446,  375,  376,  449,  559,  560,   91,  580,  581,   44, 
          743,    0,   61,  672,  673,   91,  111,   32,  306,  592, 
          364,   10,  268,  682,   10,  684,  599,  582,  687,  275, 
          585,  709,  306,   44,   59,   44,  729,  341,   44,   59, 
          279,   10,  788,  289,  722,   59,  337,  337,  337,   44, 
          623,  395,   10,  328,  800,  328,   47,   48,  362,  403, 
          335,  807,  335,  722,  370,  371,  372,  726,  337,   44, 
           59,  377,  818,   59,  320,   44,  264,   91,  651,  325, 
          739,  740,  741,  800,  263,  264,  338,  328,  263,  328, 
          279,  280,   61,    0,  335,  439,  335,   48,  264,  672, 
          673,   59,  848,   10,  337,   91,  337,  337,  362,  682, 
          328,  684,   44,  869,  687,  688,  689,  335,  364,  365, 
          866,  694,   91,  569,  870,   58,  872,  268,  337,  788, 
           44,  267,  878,   91,  275,  264,  870,  383,  328,  328, 
          344,   44,  264,  589,   44,  335,  335,  264,  807,  395, 
          904,  340,   59,  726,  337,  264,  729,  403,   44,  818, 
          916,  362,  370,  371,  372,   44,  739,  740,  741,  377, 
          848,   44,  361,  268,  370,  371,  372,   91,  264,  320, 
          275,  377,  267,   61,  325,  255,  362,  257,   91,  635, 
           44,   91,  328,  439,  289,  280,   44,   44,   44,  335, 
           44,   44,  358,  279,  340,  264,  306,  866,  308,  309, 
          310,  311,  362,  872,  264,  788,  310,  663,  464,  878, 
          264,   44,  264,  364,   44,  320,  358,  800,  362,   44, 
          325,  264,   44,  310,  807,  306,   59,  308,  309,  310, 
          311,   44,  383,  328,  264,  818,   44,   44,  268,  269, 
          335,  264,  328,  267,  395,  599,    0,  264,   44,  335, 
          344,  362,  403,  271,  340,  340,   10,  258,   91,  364, 
          365,  717,  271,  262,  263,  264,  361,  341,  344,  268, 
          269,  267,  271,  293,  294,  295,  296,  297,  383,  362, 
          241,  242,  243,  866,   58,  317,  344,  870,  439,  872, 
          395,  344,  264,  358,   67,  878,    5,  651,  403,  267, 
          279,  280,  758,  868,  328,   59,  906,  763,  370,  371, 
          372,  335,    6,  812,  570,  377,  348,  675,  672,  673, 
          352,  353,  354,  355,  852,  581,   71,   14,  682,  871, 
          684,  658,  328,  687,  439,  838,  592,   79,   -1,  335, 
           -1,   -1,  341,  599,   -1,  262,  263,  264,   -1,  328, 
          267,  268,  269,   -1,  271,  279,  335,  358,   -1,  464, 
          328,  340,  341,  362,  281,  282,  279,  335,   -1,  279, 
          280,   -1,  726,  290,  291,   -1,  293,  294,  295,  296, 
          297,  382,  361,   -1,    0,  739,  740,  741,  644,  390, 
          391,   -1,   -1,   -1,   10,  651,   -1,   -1,  399,   10, 
           -1,   -1,  363,   -1,  328,   44,  367,  370,  371,  372, 
           -1,  335,  413,   -1,  377,  328,  672,  673,  328,    9, 
           10,   11,  335,   -1,  341,  335,  682,  344,  684,  390, 
          581,  687,   -1,   44,  788,  306,   26,  308,  309,  310, 
          311,  592,   -1,   59,  405,  362,   -1,  280,  599,   -1, 
           61,  361,   91,  709,   -1,   -1,   46,  418,  419,   -1, 
           -1,  422,  463,   -1,  818,  570,  722,   -1,  339,   -1, 
          726,   -1,   10,   -1,   -1,   -1,  581,   -1,  349,  350, 
           91,   -1,   -1,  739,  740,  741,   -1,  592,   -1,   -1, 
          451,    0,   -1,  454,  599,  328,  497,   -1,   -1,   -1, 
          651,   10,  335,  504,  505,   -1,   44,  340,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,  872,  109, 
           -1,  672,  673,   61,  878,  358,   -1,   -1,  361,   -1, 
           -1,  682,  788,  684,   -1,  675,  687,  677,   -1,  644, 
          680,  542,   -1,   -1,   -1,  546,  651,  652,   -1,   -1, 
           59,  807,   -1,   91,   -1,   -1,   -1,   -1,  559,  560, 
           -1,   -1,  818,   -1,   -1,   44,   -1,  672,  673,  306, 
           -1,  308,  309,  310,  311,  726,   -1,  682,   -1,  684, 
           59,  582,  687,   -1,   -1,   -1,   -1,  341,  739,  740, 
          741,   -1,  848,   15,   16,   -1,  597,   19,   -1,  600, 
           -1,  602,  563,    0,  709,   -1,   -1,   -1,  362,  610, 
          866,   -1,   91,   10,   -1,   -1,  872,  722,   -1,   41, 
           42,  726,  878,   -1,   -1,   47,   48,   -1,   50,   51, 
           -1,   -1,   -1,   -1,  739,  740,  741,  788,   -1,   -1, 
          279,  280,  232,  233,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,  807,   -1,   -1,   -1, 
           -1,   -1,   59,  664,  625,   -1,   -1,  818,  279,  280, 
           -1,  261,   -1,   -1,   10,  499,  500,   -1,   -1,  680, 
           -1,   -1,   -1,  788,  685,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,  656,  335,   -1,   -1,   -1, 
           -1,  340,  807,  843,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  852,  818,  854,  866,   -1,  328,   10,   -1, 
           -1,  872,  361,   59,  335,  341,   -1,  878,   -1,  340, 
          341,  321,  322,  323,  324,   -1,  326,  327,   -1,  339, 
           -1,  279,  280,  848,   -1,  706,  362,  347,   -1,   10, 
          361,   -1,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  866,  271,   -1,   -1,   -1,   -1,  872,   -1,   61, 
           -1,   -1,  281,  878,   -1,  317,   -1,  738,   -1,  780, 
          920,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
          328,  333,  334,   -1,  384,   -1,   -1,  335,   -1,   91, 
           61,   -1,  340,  341,   -1,   -1,  348,   10,  350,   10, 
          352,  353,  354,  355,   -1,   -1,  358,   -1,  360,  241, 
          242,  243,  244,  361,  825,   -1,   -1,    0,   -1,   -1, 
           91,   -1,  341,  255,   -1,  257,  258,   10,   -1,   -1, 
           -1,   44,  803,   44,  266,   -1,   -1,  437,   -1,  328, 
           -1,   -1,   -1,  362,   -1,   -1,  335,   -1,   61,   -1, 
           61,  340,   -1,   -1,   -1,  262,  263,  264,   -1,  870, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,  358, 
           -1,   -1,   -1,   -1,  281,  282,   59,   -1,   91,   -1, 
           91,    0,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   10,   -1,   -1,   -1,  906,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,   -1,   -1,   44,   44,  358,   -1,   -1,  361, 
          764,  363,   -1,   -1,  341,  367,  368,  344,  772,  773, 
           59,  775,   -1,  777,   -1,  779,   -1,  781,  782,   -1, 
          382,   -1,   -1,   -1,   -1,  362,   -1,   -1,  390,   -1, 
          306,   -1,  308,  309,  310,  311,   -1,  399,  400,  401, 
          402,   91,   -1,  405,   -1,   -1,   -1,  279,   -1,   -1, 
          580,  413,  328,   -1,   -1,   -1,  418,  419,   -1,  335, 
          422,   -1,   -1,  339,  340,   -1,   -1,   10,   -1,  317, 
           -1,  347,  348,  349,  350,   -1,   -1,   -1,  279,  280, 
           -1,  443,  444,  445,   10,  333,  334,    0,   -1,  451, 
           -1,   -1,  454,  623,   -1,   10,  328,   10,   -1,   -1, 
          348,  463,  350,  335,  352,  353,  354,  355,  340,  341, 
           59,   -1,   -1,   -1,   -1,   -1,   59,   -1,   44,   -1, 
          884,  885,  886,  887,   -1,   -1,  890,  328,  892,  893, 
          894,  895,   -1,   -1,  335,   61,  279,   -1,  279,   -1, 
          341,   -1,   -1,   -1,   59,   -1,   59,   -1,   91,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          361,   -1,   -1,   -1,   -1,   91,  930,   -1,  281,  933, 
          934,  935,  936,  317,   -1,   -1,   91,  290,  291,  943, 
          293,  294,  295,  296,  297,  328,   -1,  328,   -1,  333, 
          334,   -1,  335,   -1,  335,   -1,   -1,   -1,  341,  729, 
          341,  563,   -1,   -1,  348,   -1,   -1,    0,  352,  353, 
          354,  355,   -1,  262,  263,  264,   -1,   10,  267,  268, 
          269,  306,  271,  308,  309,  310,  311,   -1,  341,  279, 
          280,   -1,  281,  282,  306,   -1,  308,  309,  310,  311, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  362, 
           -1,   44,   -1,   -1,  339,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,  347,  625,   -1,   58,   59,  339,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  306,  328,  308, 
          309,  310,  311,   -1,   -1,  335,   -1,   -1,   -1,  338, 
          340,   -1,  341,   -1,  656,  344,   -1,  346,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,  361,   -1,  362,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   -1,   -1,  267,  374,  688,  689,   -1,   -1, 
            0,   -1,  694,  695,   -1,   -1,   -1,  280,   -1,   -1, 
           10,   -1,   -1,  705,  706,   -1,   -1,   -1,  710,  262, 
          263,  264,  267,  279,  267,  268,  269,  306,  271,  308, 
          309,  310,  311,   -1,   -1,  280,   -1,   -1,  281,  282, 
          732,  733,  734,   -1,   44,   -1,  738,  290,  291,   -1, 
          293,  294,  295,  296,  297,  328,   -1,   -1,   58,   59, 
          339,   61,  335,   63,   -1,   -1,   -1,  340,  347,  348, 
          349,  350,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
           -1,   -1,   -1,  328,   -1,  341,   -1,   -1,  361,   -1, 
          335,   91,   -1,   -1,   -1,  340,   -1,  789,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,  800,   -1, 
           -1,  803,   -1,   -1,   -1,   -1,  361,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   10,   -1, 
          822,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   59,  299,   59,  870,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   91, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   10, 
          373,  374,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   59,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
            0,   -1,   -1,  373,  374,  375,  376,   -1,  378,  379, 
           10,   -1,   -1,   -1,   -1,  267,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  339, 
          340,   -1,   -1,   -1,  328,   -1,  328,  347,  348,  349, 
          350,  335,   -1,  335,   -1,  339,  340,   -1,  340,   -1, 
           -1,   91,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,  307,   -1,   -1,  310,  361, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,    0,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   10,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   44,   -1,  306, 
           -1,  308,  309,  310,  311,  306,   -1,  308,  309,  310, 
          311,   58,   59,   -1,   61,   -1,   63,  306,   -1,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,  328,   10,   -1, 
           -1,   -1,  339,  340,  335,   -1,   -1,   -1,  339,  340, 
          347,  348,  349,  350,   91,   -1,  347,  348,  349,  350, 
          339,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   10,  373,  374,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   59,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,    0,   -1,   -1,  373,  374,  375,  376, 
           -1,  378,  379,   10,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   44,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,  306, 
          307,   58,   59,  310,   61,   -1,   63,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   91,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,   -1,   -1,   -1, 
           44,  333,  334,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,   58,   59,  348,   -1,  350,   63, 
          352,  353,  354,  355,  356,  357,  358,  317,  360,   -1, 
          328,   -1,  322,  323,   -1,   -1,   -1,  335,   -1,   -1, 
           -1,  339,  340,  333,  334,   -1,   -1,   91,   -1,  347, 
          348,  349,  350,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   10,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   10,  373,  374,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   59,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,    0,   -1,   -1,  373, 
          374,  375,  376,   -1,  378,  379,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   58,   59,  265,  266,   -1,   63, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   91,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   10, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   44,  373,   -1,  375,  376,   -1,  378, 
          379,  306,   -1,  308,  309,  310,  311,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           91,   -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   59,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   10,  373, 
          374,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   59,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,    0, 
           -1,   -1,  373,  374,  375,  376,   -1,  378,  379,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   58,   59,   -1, 
           61,  335,   63,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,    0,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   10,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   44,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
           -1,   59,  348,   -1,  350,   63,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   91,   -1,  347,  348,  349,  350,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   10,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   10,  373,  374,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           59,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,    0,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,   59,  265,  266,   -1,   63,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   91,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   10,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   44, 
          373,   -1,  375,  376,   -1,  378,  379,  306,   -1,  308, 
          309,  310,  311,   -1,   59,   -1,   -1,   -1,   63,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,  328, 
          326,  327,   -1,   -1,   -1,   -1,  335,  333,  334,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   91,   -1,  347,  348, 
          349,  350,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   59,   63,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   63,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
            0,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           10,   -1,  373,   -1,  375,  376,   -1,  378,  379,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,  344,  348,  346,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1,  362, 
          297,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   59,  360,   61,   -1,   63,   -1,   -1,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   91,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           10,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,    0,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   59, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   59,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
          340,  341,  342,  343,   -1,  345,   -1,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   63,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,  340,  341,  342,  343,   -1,  345,   -1, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,    0,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   10,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,  281,  308,  309, 
          310,  311,   -1,   -1,   -1,   -1,   -1,   44,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   59,   -1,   61,  335,   63,   -1,   -1,  339, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349, 
          350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,  297,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   91,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,    0, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   59,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,  340,  341,  342,  343,   -1,  345,   -1, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   44,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,  340,  341,  342,  343, 
           -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   10,   -1,  339,   -1, 
          341,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           44,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   91,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,    0,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   10,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   91,   -1, 
           -1,   -1,   -1,  667,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  677,   -1,   -1,  680,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,  361,  362,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  841,  271,  843, 
          374,  845,   -1,   -1,   -1,  849,   -1,  280,  281,  282, 
          854,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   91,  911,  341,   -1, 
           -1,  344,   -1,  346,  918,  348,  920,  350,  922,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  361,  362, 
           -1,   -1,   -1,   -1,   -1,  939,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,    0,  333,  334,  335,   -1,  337,  338, 
           -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,    0,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,  361,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,  307,   58,   59,  310,   61,   -1, 
           63,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   91,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   91,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,    0,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  374,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   91,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
          338,   91,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,    0,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          374,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   91,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,    0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  374,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,    0,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   44,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  374,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,    0,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   10,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,    0,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          374,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,    0,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   10,  350,   -1,   -1,   -1,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   58,   59,   -1,   -1,   -1,   63,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,    0,  350,   -1,   -1, 
           -1,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  374,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,  350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358, 
           -1,  360,   -1,  362,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,   -1,   -1,   -1,   63,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,    0,  350,   -1,   -1,   -1,   -1,   -1,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           58,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   10,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   63,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  374,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   10, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,   -1,  262,  263,  264,  362,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357,    0, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   44,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,  362,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  362,   -1,  267,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   58,   59,   -1, 
           -1,   -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,    0,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1, 
          374,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   10,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   58,   59,   -1,   -1,   -1,   63,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1,  267, 
          268,  269,   -1,  271,  362,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,  281,  282,   10,  374,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   10,  324,  325,   -1,   -1, 
           -1,  329,  330,   58,   59,   -1,   -1,   -1,   63,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,  362,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   58,   59,   -1,  374,   -1,   63,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   44,  346,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   58,   59, 
           -1,  362,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,  262,  263,  264,   -1,   -1, 
          305,  268,  269,   -1,  271,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
          325,   -1,   -1,   -1,  329,  330,  293,  294,  295,  296, 
          297,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           44,   -1,  267,  268,  269,   -1,  271,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  281,  282,   -1,  374, 
           -1,   -1,   -1,   -1,  341,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,  262,  263,  264, 
          305,    0,  267,  268,  269,  362,  271,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,  338,   -1,   -1,  341,   -1,   -1,  344, 
          305,  346,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   58, 
           59,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   10,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1,  374, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           58,   59,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,    0, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  362,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   58,   59,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   10,   -1,  341,   -1,   -1, 
          344,   -1,  346,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   44, 
          374,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,  281,  282,  344,   -1,  346,   -1,   -1, 
           -1,   -1,  290,  291,    0,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,  362,   10,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   58,   59,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  362,   10,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,    0,   -1,  344,   -1,  346,   -1,  262,  263,  264, 
           -1,   10,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,  262,  263,  264,  374, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   58,   59,    0,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,  281,  282,  344,   -1, 
          346,   -1,   44,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  362,   59,   -1,   -1, 
          305,   -1,    0,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  262,  263,  264,   44,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           58,   59,  281,  282,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   10,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   44,   -1,   -1,   -1, 
          262,  263,  264,  362,   -1,  267,  268,  269,   -1,  271, 
           58,   59,   -1,    0,   -1,  374,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   10,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  362,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   58,   59,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,  362,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,  281,  282,  344,   -1,  346,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  305,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   91,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   10,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,  339,  340,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   91,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,   -1,  359,   -1,  361,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           91,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,  361,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   10,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,  339,  340,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1,  356, 
           -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,  270, 
           10,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   59, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,    0,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   10,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   59,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,    0,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   10,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   44,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   59,   -1,   61,  299, 
           63,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,   91,  268, 
          269,   -1,  271,   -1,   -1,   -1,  336,   -1,    0,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   10,   -1, 
           -1,  351,   -1,   -1,  293,  294,  295,  296,  297,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   63,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,  362,   -1,  268,  269,   -1,  271,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  262, 
          263,  264,   -1,   59,   -1,  268,  269,   63,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,  361,  362, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,   -1,   91,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,    0, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   10, 
          362,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           91,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,    0,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,    0,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   10,  362,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,  337,   -1,   91,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,    0,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   44,  290,  291,   -1,  293,  294,  295,  296, 
          297,   10,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   44,  333,  334,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           59,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   10, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,   -1,    0,   -1,  341,   -1, 
           -1,   -1,   -1,   44,   -1,  348,   10,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   59,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   59,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   44,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,  281,  282,  344,   -1,  346,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
          262,  263,  264,  362,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,  344,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  293,  294,  295,  296,  297,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   59, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,  362,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,  340,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
          340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,  364,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,  364,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,   -1, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363, 
      };
   }

}
