/*--------------------------------------------------------------------------+
$Id: TreeUtilsTest.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.tree;

import java.util.HashSet;

import junit.framework.TestCase;

/**
 * Test class for {@link TreeUtils}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 6E149EDE3C7F8AE3A21E4983F8007594
 */
public class TreeUtilsTest extends TestCase {
	/**
	 * Test for
	 * {@link TreeUtils#createTreeFromStrings(java.util.Set, String, ITreeNodeHandler)}
	 */
	public void testCreateTreeFromStrings() {
		HashSet<String> pathes = new HashSet<String>();
		pathes.add("test1/test2/test3");
		pathes.add("test4/test5/test6");
		pathes.add("test4/test7/test8");

		SimpleTreeNode<String> root = TreeUtils.createTreeFromStrings(pathes,
				"/", new SimpleTreeNodeHandler<String>("<root>"));

		assertEquals("<root>", root.getKey());
		SimpleTreeNode<String> test1 = root.getChild("test1");
		SimpleTreeNode<String> test2 = test1.getChild("test2");
		SimpleTreeNode<String> test3 = test2.getChild("test3");
		assertNotNull(test3);

		SimpleTreeNode<String> test4 = root.getChild("test4");
		SimpleTreeNode<String> test5 = test4.getChild("test5");
		SimpleTreeNode<String> test6 = test5.getChild("test6");
		assertNotNull(test6);

		SimpleTreeNode<String> test7 = test4.getChild("test7");
		SimpleTreeNode<String> test8 = test7.getChild("test8");
		assertNotNull(test8);
	}

	/**
	 * Test for
	 * {@link TreeUtils#createTreeFromStrings(java.util.Set, String, ITreeNodeHandler)}
	 * with an empty path set.
	 */
	public void testCreateTreeFromStringsempty() {
		SimpleTreeNode<String> root = TreeUtils.createTreeFromStrings(
				new HashSet<String>(), "/", new SimpleTreeNodeHandler<String>(
						"<root>"));

		assertEquals("<root>", root.getKey());
		assertTrue(root.getChildren().isEmpty());
	}
}