/*--------------------------------------------------------------------------+
$Id: VersionTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.version;

import junit.framework.TestCase;

/**
 * Test for {@link Version}.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 101AD7A6FCE39B92A2FD54D6B6D6CBC3
 */
public class VersionTest extends TestCase {

	/** Test for {@link Version#compareTo(Version)}. */
	public void testCompareEqual() {
		assertEquals(0, new Version(1, 0).compareTo(new Version(1, 0)));
		assertEquals(0, new Version(0, 0).compareTo(new Version(0, 0)));
	}

	/** Test for {@link Version#compareTo(Version)}. */
	public void testCompareLessThan() {
		assertEquals(-1, new Version(1, 0).compareTo(new Version(2, 0)));
		assertEquals(-1, new Version(0, 0).compareTo(new Version(1, 0)));
		assertEquals(-1, new Version(1, 0).compareTo(new Version(1, 3)));
	}

	/** Test for {@link Version#compareTo(Version)}. */
	public void testCompareGreaterThan() {
		assertEquals(1, new Version(2, 0).compareTo(new Version(1, 0)));
		assertEquals(1, new Version(1, 0).compareTo(new Version(0, 0)));
		assertEquals(1, new Version(1, 3).compareTo(new Version(1, 0)));
	}

	/** Test for {@link Version#equals(Object)}. */
	public void testEquals() {
		assertEquals(new Version(1, 0), new Version(1, 0));
		assertFalse(new Version(1, 0).equals(new Version(2, 0)));
	}

	/** Test for {@link Version#isSatisfied(Version, Version)}. */
	public void testIsSatisfied() {
		Version currentVersion = new Version(1, 5);
		Version compatibleVersion = new Version(1, 1);

		// greater than current version
		assertFalse(new Version(1, 6).isSatisfied(currentVersion,
				compatibleVersion));

		// less than compatible version
		assertFalse(new Version(1, 0).isSatisfied(currentVersion,
				compatibleVersion));

		// equals current version
		assertTrue(new Version(1, 5).isSatisfied(currentVersion,
				compatibleVersion));

		// equals compatible version
		assertTrue(new Version(1, 1).isSatisfied(currentVersion,
				compatibleVersion));

		// less than current version but greater than compatible version
		assertTrue(new Version(1, 4).isSatisfied(currentVersion,
				compatibleVersion));
		assertTrue(new Version(1, 3).isSatisfied(currentVersion,
				compatibleVersion));
	}
}