#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
TAR=../${SOURCE}_$2.orig.tar.gz
DIR=$SOURCE-$2
TAG=$2
SVN=http://jtype.googlecode.com/svn/tags/

svn export $SVN/$TAG $DIR
GZIP=--best tar -c -z -f $TAR $DIR
rm -rf $3 $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

