#!/bin/sh

# panic: uma_zalloc_debug: called within spinlock or critical section
# cpuid = 9
# time = 1606151277
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0101c628a0
# vpanic() at vpanic+0x181/frame 0xfffffe0101c628f0
# panic() at panic+0x43/frame 0xfffffe0101c62950
# uma_zalloc_arg() at uma_zalloc_arg+0x1e6/frame 0xfffffe0101c62990
# cpuset_modify_domain() at cpuset_modify_domain+0x1bf/frame 0xfffffe0101c62a10
# kern_cpuset_setdomain() at kern_cpuset_setdomain+0x402/frame 0xfffffe0101c62aa0
# sys_cpuset_setdomain() at sys_cpuset_setdomain+0x26/frame 0xfffffe0101c62ac0
# amd64_syscall() at amd64_syscall+0x147/frame 0xfffffe0101c62bf0
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe0101c62bf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x800380d4a, rsp = 0x7fffffffe4b8, rbp = 0x7fffffffe4f0 ---
# KDB: enter: panic
# [ thread pid 81187 tid 100369 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10b3236(%rip)
# db> x/s version
# version: FreeBSD 13.0-CURRENT #0 r367945: Mon Nov 23 09:10:40 CET 2020
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0

# Fixed by r368116

# May change policy for random threads to domainset_fixed
exit 0

. ../default.cfg
cat > /tmp/syzkaller29.c <<EOF
// https://syzkaller.appspot.com/bug?id=c3452066dba9238c4551010eb130944442d9174f
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+6743fa07b9b7528dc561@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

void execute_one(void)
{
  *(uint64_t*)0x20000240 = 1;
  *(uint64_t*)0x20000248 = 0;
  *(uint64_t*)0x20000250 = 0;
  *(uint64_t*)0x20000258 = 0;
  syscall(SYS_cpuset_setdomain, 2ul, 2ul, 0ul, 0x20ul, 0x20000240ul, 4ul);
  *(uint64_t*)0x20000240 = 1;
  *(uint64_t*)0x20000248 = 0;
  *(uint64_t*)0x20000250 = 0;
  *(uint64_t*)0x20000258 = 0;
  syscall(SYS_cpuset_setdomain, 3ul, 2ul, 0ul, 0x20ul, 0x20000240ul, 1ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller29 -Wall -Wextra -O0 /tmp/syzkaller29.c ||
    exit 1

(cd /tmp; timeout 3m ./syzkaller29)

rm -rf /tmp/syzkaller29 /tmp/syzkaller29.c /tmp/syzkaller.*
exit 0
