// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/v1/internal/eventarc_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace eventarc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EventarcTracingStub::EventarcTracingStub(std::shared_ptr<EventarcStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::eventarc::v1::Trigger> EventarcTracingStub::GetTrigger(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::GetTriggerRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc", "GetTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTrigger(context, request));
}

StatusOr<google::cloud::eventarc::v1::ListTriggersResponse>
EventarcTracingStub::ListTriggers(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::ListTriggersRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "ListTriggers");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTriggers(context, request));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncCreateTrigger(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "CreateTrigger");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateTrigger(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncUpdateTrigger(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "UpdateTrigger");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateTrigger(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncDeleteTrigger(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "DeleteTrigger");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteTrigger(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::eventarc::v1::Channel> EventarcTracingStub::GetChannel(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::GetChannelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc", "GetChannel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetChannel(context, request));
}

StatusOr<google::cloud::eventarc::v1::ListChannelsResponse>
EventarcTracingStub::ListChannels(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::ListChannelsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "ListChannels");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListChannels(context, request));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncCreateChannel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "CreateChannel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateChannel(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncUpdateChannel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "UpdateChannel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateChannel(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncDeleteChannel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "DeleteChannel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteChannel(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::eventarc::v1::Provider>
EventarcTracingStub::GetProvider(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::GetProviderRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "GetProvider");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProvider(context, request));
}

StatusOr<google::cloud::eventarc::v1::ListProvidersResponse>
EventarcTracingStub::ListProviders(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::ListProvidersRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "ListProviders");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListProviders(context, request));
}

StatusOr<google::cloud::eventarc::v1::ChannelConnection>
EventarcTracingStub::GetChannelConnection(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::GetChannelConnectionRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "GetChannelConnection");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetChannelConnection(context, request));
}

StatusOr<google::cloud::eventarc::v1::ListChannelConnectionsResponse>
EventarcTracingStub::ListChannelConnections(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::ListChannelConnectionsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "ListChannelConnections");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListChannelConnections(context, request));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncCreateChannelConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "CreateChannelConnection");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateChannelConnection(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncDeleteChannelConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "DeleteChannelConnection");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteChannelConnection(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcTracingStub::GetGoogleChannelConfig(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "GetGoogleChannelConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetGoogleChannelConfig(context, request));
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcTracingStub::UpdateGoogleChannelConfig(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.eventarc.v1.Eventarc",
                                     "UpdateGoogleChannelConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateGoogleChannelConfig(context, request));
}

future<StatusOr<google::longrunning::Operation>>
EventarcTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> EventarcTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<EventarcStub> MakeEventarcTracingStub(
    std::shared_ptr<EventarcStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<EventarcTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_v1_internal
}  // namespace cloud
}  // namespace google
