// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/azure_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_MOCKS_MOCK_AZURE_CLUSTERS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_MOCKS_MOCK_AZURE_CLUSTERS_CONNECTION_H

#include "google/cloud/gkemulticloud/v1/azure_clusters_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace gkemulticloud_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `AzureClustersConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `AzureClustersClient`. To do so,
 * construct an object of type `AzureClustersClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockAzureClustersConnection
    : public gkemulticloud_v1::AzureClustersConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(future<StatusOr<google::cloud::gkemulticloud::v1::AzureClient>>,
              CreateAzureClient,
              (google::cloud::gkemulticloud::v1::CreateAzureClientRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkemulticloud::v1::AzureClient>, GetAzureClient,
      (google::cloud::gkemulticloud::v1::GetAzureClientRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::gkemulticloud::v1::AzureClient>),
      ListAzureClients,
      (google::cloud::gkemulticloud::v1::ListAzureClientsRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>,
      DeleteAzureClient,
      (google::cloud::gkemulticloud::v1::DeleteAzureClientRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>,
      CreateAzureCluster,
      (google::cloud::gkemulticloud::v1::CreateAzureClusterRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>>,
      UpdateAzureCluster,
      (google::cloud::gkemulticloud::v1::UpdateAzureClusterRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>, GetAzureCluster,
      (google::cloud::gkemulticloud::v1::GetAzureClusterRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::gkemulticloud::v1::AzureCluster>),
      ListAzureClusters,
      (google::cloud::gkemulticloud::v1::ListAzureClustersRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>,
      DeleteAzureCluster,
      (google::cloud::gkemulticloud::v1::DeleteAzureClusterRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenResponse>,
      GenerateAzureAccessToken,
      (google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>,
      CreateAzureNodePool,
      (google::cloud::gkemulticloud::v1::CreateAzureNodePoolRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>>,
      UpdateAzureNodePool,
      (google::cloud::gkemulticloud::v1::UpdateAzureNodePoolRequest const&
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>,
              GetAzureNodePool,
              (google::cloud::gkemulticloud::v1::GetAzureNodePoolRequest const&
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::gkemulticloud::v1::AzureNodePool>),
      ListAzureNodePools,
      (google::cloud::gkemulticloud::v1::ListAzureNodePoolsRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>,
      DeleteAzureNodePool,
      (google::cloud::gkemulticloud::v1::DeleteAzureNodePoolRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkemulticloud::v1::AzureServerConfig>,
      GetAzureServerConfig,
      (google::cloud::gkemulticloud::v1::GetAzureServerConfigRequest const&
           request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEMULTICLOUD_V1_MOCKS_MOCK_AZURE_CLUSTERS_CONNECTION_H
