// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_INTERNAL_MANAGED_NOTEBOOK_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_INTERNAL_MANAGED_NOTEBOOK_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/notebooks/v1/managed_service.grpc.pb.h>
#include <google/cloud/notebooks/v1/service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ManagedNotebookServiceStub {
 public:
  virtual ~ManagedNotebookServiceStub() = 0;

  virtual StatusOr<google::cloud::notebooks::v1::ListRuntimesResponse>
  ListRuntimes(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::ListRuntimesRequest const& request) = 0;

  virtual StatusOr<google::cloud::notebooks::v1::Runtime> GetRuntime(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::GetRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::CreateRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpdateRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::UpdateRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::DeleteRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncStartRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::StartRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncStopRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::StopRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncSwitchRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::SwitchRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncResetRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::ResetRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpgradeRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncReportRuntimeEvent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::ReportRuntimeEventRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
  RefreshRuntimeTokenInternal(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::RefreshRuntimeTokenInternalRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDiagnoseRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultManagedNotebookServiceStub : public ManagedNotebookServiceStub {
 public:
  DefaultManagedNotebookServiceStub(
      std::unique_ptr<
          google::cloud::notebooks::v1::ManagedNotebookService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::notebooks::v1::ListRuntimesResponse> ListRuntimes(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::ListRuntimesRequest const& request)
      override;

  StatusOr<google::cloud::notebooks::v1::Runtime> GetRuntime(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::GetRuntimeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::CreateRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::UpdateRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::DeleteRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncStartRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::StartRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncStopRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::StopRuntimeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncSwitchRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::SwitchRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncResetRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::ResetRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpgradeRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncReportRuntimeEvent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request)
      override;

  StatusOr<google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
  RefreshRuntimeTokenInternal(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::RefreshRuntimeTokenInternalRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDiagnoseRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<
      google::cloud::notebooks::v1::ManagedNotebookService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_INTERNAL_MANAGED_NOTEBOOK_STUB_H
