// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/privateca/v1/service.proto

#include "google/cloud/privateca/v1/internal/certificate_authority_connection_impl.h"
#include "google/cloud/privateca/v1/internal/certificate_authority_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace privateca_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<privateca_v1::CertificateAuthorityServiceRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<privateca_v1::CertificateAuthorityServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<privateca_v1::CertificateAuthorityServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    privateca_v1::CertificateAuthorityServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<privateca_v1::
               CertificateAuthorityServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<privateca_v1::CertificateAuthorityServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

CertificateAuthorityServiceConnectionImpl::
    CertificateAuthorityServiceConnectionImpl(
        std::unique_ptr<google::cloud::BackgroundThreads> background,
        std::shared_ptr<privateca_v1_internal::CertificateAuthorityServiceStub>
            stub,
        Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          CertificateAuthorityServiceConnection::options())) {}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceConnectionImpl::CreateCertificate(
    google::cloud::security::privateca::v1::CreateCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCertificate(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::
                 CreateCertificateRequest const& request) {
        return stub_->CreateCertificate(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceConnectionImpl::GetCertificate(
    google::cloud::security::privateca::v1::GetCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificate(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::security::privateca::v1::GetCertificateRequest const&
              request) { return stub_->GetCertificate(context, request); },
      request, __func__);
}

StreamRange<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceConnectionImpl::ListCertificates(
    google::cloud::security::privateca::v1::ListCertificatesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCertificates(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::security::privateca::v1::Certificate>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privateca_v1::CertificateAuthorityServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::security::privateca::v1::ListCertificatesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::security::privateca::v1::
                       ListCertificatesRequest const& request) {
              return stub->ListCertificates(context, request);
            },
            r, function_name);
      },
      [](google::cloud::security::privateca::v1::ListCertificatesResponse r) {
        std::vector<google::cloud::security::privateca::v1::Certificate> result(
            r.certificates().size());
        auto& messages = *r.mutable_certificates();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceConnectionImpl::RevokeCertificate(
    google::cloud::security::privateca::v1::RevokeCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RevokeCertificate(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::
                 RevokeCertificateRequest const& request) {
        return stub_->RevokeCertificate(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceConnectionImpl::UpdateCertificate(
    google::cloud::security::privateca::v1::UpdateCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCertificate(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::
                 UpdateCertificateRequest const& request) {
        return stub_->UpdateCertificate(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceConnectionImpl::ActivateCertificateAuthority(
    google::cloud::security::privateca::v1::
        ActivateCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateAuthority>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         ActivateCertificateAuthorityRequest const& request) {
        return stub->AsyncActivateCertificateAuthority(cq, std::move(context),
                                                       options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateAuthority>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ActivateCertificateAuthority(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceConnectionImpl::CreateCertificateAuthority(
    google::cloud::security::privateca::v1::
        CreateCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateAuthority>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         CreateCertificateAuthorityRequest const& request) {
        return stub->AsyncCreateCertificateAuthority(cq, std::move(context),
                                                     options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateAuthority>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCertificateAuthority(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceConnectionImpl::DisableCertificateAuthority(
    google::cloud::security::privateca::v1::
        DisableCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateAuthority>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         DisableCertificateAuthorityRequest const& request) {
        return stub->AsyncDisableCertificateAuthority(cq, std::move(context),
                                                      options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateAuthority>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DisableCertificateAuthority(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceConnectionImpl::EnableCertificateAuthority(
    google::cloud::security::privateca::v1::
        EnableCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateAuthority>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         EnableCertificateAuthorityRequest const& request) {
        return stub->AsyncEnableCertificateAuthority(cq, std::move(context),
                                                     options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateAuthority>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EnableCertificateAuthority(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::security::privateca::v1::
             FetchCertificateAuthorityCsrResponse>
CertificateAuthorityServiceConnectionImpl::FetchCertificateAuthorityCsr(
    google::cloud::security::privateca::v1::
        FetchCertificateAuthorityCsrRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FetchCertificateAuthorityCsr(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::
                 FetchCertificateAuthorityCsrRequest const& request) {
        return stub_->FetchCertificateAuthorityCsr(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>
CertificateAuthorityServiceConnectionImpl::GetCertificateAuthority(
    google::cloud::security::privateca::v1::
        GetCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificateAuthority(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::
                 GetCertificateAuthorityRequest const& request) {
        return stub_->GetCertificateAuthority(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::security::privateca::v1::CertificateAuthority>
CertificateAuthorityServiceConnectionImpl::ListCertificateAuthorities(
    google::cloud::security::privateca::v1::ListCertificateAuthoritiesRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListCertificateAuthorities(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::security::privateca::v1::CertificateAuthority>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privateca_v1::CertificateAuthorityServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::security::privateca::v1::
              ListCertificateAuthoritiesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::security::privateca::v1::
                       ListCertificateAuthoritiesRequest const& request) {
              return stub->ListCertificateAuthorities(context, request);
            },
            r, function_name);
      },
      [](google::cloud::security::privateca::v1::
             ListCertificateAuthoritiesResponse r) {
        std::vector<
            google::cloud::security::privateca::v1::CertificateAuthority>
            result(r.certificate_authorities().size());
        auto& messages = *r.mutable_certificate_authorities();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceConnectionImpl::UndeleteCertificateAuthority(
    google::cloud::security::privateca::v1::
        UndeleteCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateAuthority>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         UndeleteCertificateAuthorityRequest const& request) {
        return stub->AsyncUndeleteCertificateAuthority(cq, std::move(context),
                                                       options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateAuthority>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UndeleteCertificateAuthority(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceConnectionImpl::DeleteCertificateAuthority(
    google::cloud::security::privateca::v1::
        DeleteCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateAuthority>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         DeleteCertificateAuthorityRequest const& request) {
        return stub->AsyncDeleteCertificateAuthority(cq, std::move(context),
                                                     options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateAuthority>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCertificateAuthority(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceConnectionImpl::UpdateCertificateAuthority(
    google::cloud::security::privateca::v1::
        UpdateCertificateAuthorityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateAuthority>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         UpdateCertificateAuthorityRequest const& request) {
        return stub->AsyncUpdateCertificateAuthority(cq, std::move(context),
                                                     options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateAuthority>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCertificateAuthority(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceConnectionImpl::CreateCaPool(
    google::cloud::security::privateca::v1::CreateCaPoolRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CaPool>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::security::privateca::v1::CreateCaPoolRequest const&
              request) {
        return stub->AsyncCreateCaPool(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CaPool>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCaPool(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceConnectionImpl::UpdateCaPool(
    google::cloud::security::privateca::v1::UpdateCaPoolRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CaPool>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::security::privateca::v1::UpdateCaPoolRequest const&
              request) {
        return stub->AsyncUpdateCaPool(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CaPool>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCaPool(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::security::privateca::v1::CaPool>
CertificateAuthorityServiceConnectionImpl::GetCaPool(
    google::cloud::security::privateca::v1::GetCaPoolRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCaPool(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::GetCaPoolRequest const&
                 request) { return stub_->GetCaPool(context, request); },
      request, __func__);
}

StreamRange<google::cloud::security::privateca::v1::CaPool>
CertificateAuthorityServiceConnectionImpl::ListCaPools(
    google::cloud::security::privateca::v1::ListCaPoolsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCaPools(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::security::privateca::v1::CaPool>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privateca_v1::CertificateAuthorityServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::security::privateca::v1::ListCaPoolsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::security::privateca::v1::
                       ListCaPoolsRequest const& request) {
              return stub->ListCaPools(context, request);
            },
            r, function_name);
      },
      [](google::cloud::security::privateca::v1::ListCaPoolsResponse r) {
        std::vector<google::cloud::security::privateca::v1::CaPool> result(
            r.ca_pools().size());
        auto& messages = *r.mutable_ca_pools();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceConnectionImpl::DeleteCaPool(
    google::cloud::security::privateca::v1::DeleteCaPoolRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::security::privateca::v1::DeleteCaPoolRequest const&
              request) {
        return stub->AsyncDeleteCaPool(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::security::privateca::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCaPool(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::security::privateca::v1::FetchCaCertsResponse>
CertificateAuthorityServiceConnectionImpl::FetchCaCerts(
    google::cloud::security::privateca::v1::FetchCaCertsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FetchCaCerts(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::FetchCaCertsRequest const&
                 request) { return stub_->FetchCaCerts(context, request); },
      request, __func__);
}

StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>
CertificateAuthorityServiceConnectionImpl::GetCertificateRevocationList(
    google::cloud::security::privateca::v1::
        GetCertificateRevocationListRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificateRevocationList(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::
                 GetCertificateRevocationListRequest const& request) {
        return stub_->GetCertificateRevocationList(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::security::privateca::v1::CertificateRevocationList>
CertificateAuthorityServiceConnectionImpl::ListCertificateRevocationLists(
    google::cloud::security::privateca::v1::
        ListCertificateRevocationListsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListCertificateRevocationLists(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::security::privateca::v1::CertificateRevocationList>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privateca_v1::CertificateAuthorityServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::security::privateca::v1::
              ListCertificateRevocationListsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::security::privateca::v1::
                       ListCertificateRevocationListsRequest const& request) {
              return stub->ListCertificateRevocationLists(context, request);
            },
            r, function_name);
      },
      [](google::cloud::security::privateca::v1::
             ListCertificateRevocationListsResponse r) {
        std::vector<
            google::cloud::security::privateca::v1::CertificateRevocationList>
            result(r.certificate_revocation_lists().size());
        auto& messages = *r.mutable_certificate_revocation_lists();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<
    StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>>
CertificateAuthorityServiceConnectionImpl::UpdateCertificateRevocationList(
    google::cloud::security::privateca::v1::
        UpdateCertificateRevocationListRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateRevocationList>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::security::privateca::v1::
              UpdateCertificateRevocationListRequest const& request) {
        return stub->AsyncUpdateCertificateRevocationList(
            cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateRevocationList>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCertificateRevocationList(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceConnectionImpl::CreateCertificateTemplate(
    google::cloud::security::privateca::v1::
        CreateCertificateTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateTemplate>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         CreateCertificateTemplateRequest const& request) {
        return stub->AsyncCreateCertificateTemplate(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateTemplate>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCertificateTemplate(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceConnectionImpl::DeleteCertificateTemplate(
    google::cloud::security::privateca::v1::
        DeleteCertificateTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         DeleteCertificateTemplateRequest const& request) {
        return stub->AsyncDeleteCertificateTemplate(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::security::privateca::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCertificateTemplate(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>
CertificateAuthorityServiceConnectionImpl::GetCertificateTemplate(
    google::cloud::security::privateca::v1::GetCertificateTemplateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificateTemplate(request),
      [this](grpc::ClientContext& context,
             google::cloud::security::privateca::v1::
                 GetCertificateTemplateRequest const& request) {
        return stub_->GetCertificateTemplate(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::security::privateca::v1::CertificateTemplate>
CertificateAuthorityServiceConnectionImpl::ListCertificateTemplates(
    google::cloud::security::privateca::v1::ListCertificateTemplatesRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListCertificateTemplates(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::security::privateca::v1::CertificateTemplate>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privateca_v1::CertificateAuthorityServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::security::privateca::v1::
              ListCertificateTemplatesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::security::privateca::v1::
                       ListCertificateTemplatesRequest const& request) {
              return stub->ListCertificateTemplates(context, request);
            },
            r, function_name);
      },
      [](google::cloud::security::privateca::v1::
             ListCertificateTemplatesResponse r) {
        std::vector<google::cloud::security::privateca::v1::CertificateTemplate>
            result(r.certificate_templates().size());
        auto& messages = *r.mutable_certificate_templates();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceConnectionImpl::UpdateCertificateTemplate(
    google::cloud::security::privateca::v1::
        UpdateCertificateTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::security::privateca::v1::CertificateTemplate>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::security::privateca::v1::
                         UpdateCertificateTemplateRequest const& request) {
        return stub->AsyncUpdateCertificateTemplate(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::security::privateca::v1::CertificateTemplate>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCertificateTemplate(request),
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privateca_v1_internal
}  // namespace cloud
}  // namespace google
