// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_CATALOG_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_CATALOG_TRACING_CONNECTION_H

#include "google/cloud/retail/v2/catalog_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class CatalogServiceTracingConnection
    : public retail_v2::CatalogServiceConnection {
 public:
  ~CatalogServiceTracingConnection() override = default;

  explicit CatalogServiceTracingConnection(
      std::shared_ptr<retail_v2::CatalogServiceConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::retail::v2::Catalog> ListCatalogs(
      google::cloud::retail::v2::ListCatalogsRequest request) override;

  StatusOr<google::cloud::retail::v2::Catalog> UpdateCatalog(
      google::cloud::retail::v2::UpdateCatalogRequest const& request) override;

  Status SetDefaultBranch(
      google::cloud::retail::v2::SetDefaultBranchRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
  GetDefaultBranch(google::cloud::retail::v2::GetDefaultBranchRequest const&
                       request) override;

  StatusOr<google::cloud::retail::v2::CompletionConfig> GetCompletionConfig(
      google::cloud::retail::v2::GetCompletionConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::CompletionConfig> UpdateCompletionConfig(
      google::cloud::retail::v2::UpdateCompletionConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> GetAttributesConfig(
      google::cloud::retail::v2::GetAttributesConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> UpdateAttributesConfig(
      google::cloud::retail::v2::UpdateAttributesConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> AddCatalogAttribute(
      google::cloud::retail::v2::AddCatalogAttributeRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> RemoveCatalogAttribute(
      google::cloud::retail::v2::RemoveCatalogAttributeRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> ReplaceCatalogAttribute(
      google::cloud::retail::v2::ReplaceCatalogAttributeRequest const& request)
      override;

 private:
  std::shared_ptr<retail_v2::CatalogServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<retail_v2::CatalogServiceConnection>
MakeCatalogServiceTracingConnection(
    std::shared_ptr<retail_v2::CatalogServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_CATALOG_TRACING_CONNECTION_H
