// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#include "google/cloud/storageinsights/v1/internal/storage_insights_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace storageinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

StorageInsightsTracingStub::StorageInsightsTracingStub(
    std::shared_ptr<StorageInsightsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::storageinsights::v1::ListReportConfigsResponse>
StorageInsightsTracingStub::ListReportConfigs(
    grpc::ClientContext& context,
    google::cloud::storageinsights::v1::ListReportConfigsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.storageinsights.v1.StorageInsights", "ListReportConfigs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListReportConfigs(context, request));
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsTracingStub::GetReportConfig(
    grpc::ClientContext& context,
    google::cloud::storageinsights::v1::GetReportConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.storageinsights.v1.StorageInsights", "GetReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetReportConfig(context, request));
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsTracingStub::CreateReportConfig(
    grpc::ClientContext& context,
    google::cloud::storageinsights::v1::CreateReportConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.storageinsights.v1.StorageInsights", "CreateReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateReportConfig(context, request));
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsTracingStub::UpdateReportConfig(
    grpc::ClientContext& context,
    google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.storageinsights.v1.StorageInsights", "UpdateReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateReportConfig(context, request));
}

Status StorageInsightsTracingStub::DeleteReportConfig(
    grpc::ClientContext& context,
    google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.storageinsights.v1.StorageInsights", "DeleteReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteReportConfig(context, request));
}

StatusOr<google::cloud::storageinsights::v1::ListReportDetailsResponse>
StorageInsightsTracingStub::ListReportDetails(
    grpc::ClientContext& context,
    google::cloud::storageinsights::v1::ListReportDetailsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.storageinsights.v1.StorageInsights", "ListReportDetails");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListReportDetails(context, request));
}

StatusOr<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsTracingStub::GetReportDetail(
    grpc::ClientContext& context,
    google::cloud::storageinsights::v1::GetReportDetailRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.storageinsights.v1.StorageInsights", "GetReportDetail");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetReportDetail(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<StorageInsightsStub> MakeStorageInsightsTracingStub(
    std::shared_ptr<StorageInsightsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<StorageInsightsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1_internal
}  // namespace cloud
}  // namespace google
