// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/support/v2/case_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SUPPORT_V2_INTERNAL_CASE_METADATA_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SUPPORT_V2_INTERNAL_CASE_METADATA_DECORATOR_H

#include "google/cloud/support/v2/internal/case_stub.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace support_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CaseServiceMetadata : public CaseServiceStub {
 public:
  ~CaseServiceMetadata() override = default;
  CaseServiceMetadata(std::shared_ptr<CaseServiceStub> child,
                      std::multimap<std::string, std::string> fixed_metadata,
                      std::string api_client_header = "");

  StatusOr<google::cloud::support::v2::Case> GetCase(
      grpc::ClientContext& context,
      google::cloud::support::v2::GetCaseRequest const& request) override;

  StatusOr<google::cloud::support::v2::ListCasesResponse> ListCases(
      grpc::ClientContext& context,
      google::cloud::support::v2::ListCasesRequest const& request) override;

  StatusOr<google::cloud::support::v2::SearchCasesResponse> SearchCases(
      grpc::ClientContext& context,
      google::cloud::support::v2::SearchCasesRequest const& request) override;

  StatusOr<google::cloud::support::v2::Case> CreateCase(
      grpc::ClientContext& context,
      google::cloud::support::v2::CreateCaseRequest const& request) override;

  StatusOr<google::cloud::support::v2::Case> UpdateCase(
      grpc::ClientContext& context,
      google::cloud::support::v2::UpdateCaseRequest const& request) override;

  StatusOr<google::cloud::support::v2::Case> EscalateCase(
      grpc::ClientContext& context,
      google::cloud::support::v2::EscalateCaseRequest const& request) override;

  StatusOr<google::cloud::support::v2::Case> CloseCase(
      grpc::ClientContext& context,
      google::cloud::support::v2::CloseCaseRequest const& request) override;

  StatusOr<google::cloud::support::v2::SearchCaseClassificationsResponse>
  SearchCaseClassifications(
      grpc::ClientContext& context,
      google::cloud::support::v2::SearchCaseClassificationsRequest const&
          request) override;

 private:
  void SetMetadata(grpc::ClientContext& context, Options const& options,
                   std::string const& request_params);
  void SetMetadata(grpc::ClientContext& context, Options const& options);

  std::shared_ptr<CaseServiceStub> child_;
  std::multimap<std::string, std::string> fixed_metadata_;
  std::string api_client_header_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace support_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SUPPORT_V2_INTERNAL_CASE_METADATA_DECORATOR_H
