/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasmodel.c - interface for canvas model.
 */

/**
 * SECTION:goocanvasmodel
 * @Title: GooCanvasModel
 * @Short_Description: the canvas model interface.
 *
 * GooCanvasModel defines the interface that canvas models must implement.
 *
 * Currently it consists of a single method which returns the root canvas
 * item.
 */
#include <config.h>
#include <gtk/gtk.h>
#include "goocanvasmodel.h"


static void goo_canvas_model_base_init (gpointer g_class);


GType
goo_canvas_model_get_type (void)
{
  static GType canvas_model_type = 0;

  if (!canvas_model_type)
    {
      static const GTypeInfo canvas_model_info =
      {
        sizeof (GooCanvasModelIface), /* class_size */
	goo_canvas_model_base_init,   /* base_init */
	NULL,			      /* base_finalize */
      };

      canvas_model_type = g_type_register_static (G_TYPE_INTERFACE,
						  "GooCanvasModel",
						  &canvas_model_info, 0);

      g_type_interface_add_prerequisite (canvas_model_type, G_TYPE_OBJECT);
    }

  return canvas_model_type;
}


static void
goo_canvas_model_base_init (gpointer g_class)
{

}


/**
 * goo_canvas_model_get_root_item:
 * @model: a #GooCanvasModel.
 * 
 * Returns the root canvas item of the model.
 * 
 * Returns: the root canvas item.
 **/
GooCanvasItem*
goo_canvas_model_get_root_item	     (GooCanvasModel *model)
{
  return GOO_CANVAS_MODEL_GET_IFACE (model)->get_root_item (model);
}
