/****************************************************************************
** Filename: zip_p.h
** Last updated [dd/mm/yyyy]: 23/10/2006
**
** pkzip 2.0 file compression.
**
** Some of the code has been inspired by other open source projects,
** (mainly Info-Zip).
** Compression and decompression actually uses the zlib library.
**
** Copyright (C) 2006 Angius Fabrizio. All rights reserved.
**
** This file is part of the OSDaB project (http://osdab.sourceforge.net/).
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See the file LICENSE.GPL that came with this software distribution or
** visit http://www.gnu.org/copyleft/gpl.html for GPL licensing information.
**
**********************************************************************/

#ifndef OSDAB_ZIP_P__H
#define OSDAB_ZIP_P__H

#include "zip.h"

#include <QtGlobal>

/*!
	zLib authors suggest using larger buffers (128K or 256K) for (de)compression (especially for inflate())
	we use a 256K buffer here - if you want to use this code on a pre-iceage mainframe please change it ;)
*/
#define ZIP_READ_BUFFER 262144

class ZipPrivate : QObject
{
	Q_OBJECT

public:
	ZipPrivate(QWidget* parent);
	virtual ~ZipPrivate();

	QWidget* parent;

	QMap<QString,ZipEntry>* headers;

	QIODevice* device;

	char buffer1[ZIP_READ_BUFFER];
	char buffer2[ZIP_READ_BUFFER];

	unsigned char* uBuffer;

	const quint32* crcTable;

	Zip::ErrorCode createArchive(QIODevice* device);
	Zip::ErrorCode closeArchive();

	bool zLibInit();

	Zip::ErrorCode createEntry(const QString& filename, const QString& root, const QString* pasword, Zip::CompressionLevel level);
	Zip::CompressionLevel detectCompressionByMime(const QString& ext);

	inline void encryptBytes(quint32* keys, char* buffer, qint64 read);

	inline void setULong(quint32 v, char* buffer, unsigned int offset);
	inline void updateKeys(quint32* keys, int c) const;
	inline void initKeys(const QString& pwd, quint32* keys) const;
	inline int decryptByte(quint32 key2) const;
};

#endif // OSDAB_ZIP_P__H
