/*--------------------------------------------------------------------------+
$Id: UnmodifiableIterator.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.util.Iterator;

/**
 * This is a wrapper for a {@link Iterator} prohibiting all calls which would
 * modify its owning container. All prohibited methods throw an
 * {@link UnsupportedOperationException}.
 * 
 * @author Benjamin Hummel
 * @author $Author: juergens $
 * 
 * @version $Revision: 26283 $
 * @levd.rating GREEN Hash: 73D7E245FAE2147047C3C3D4B19E6C48
 */
public class UnmodifiableIterator<E> implements Iterator<E> {

	/** The underlying iterator. */
	private final Iterator<E> i;

	/**
	 * Creates a new unmodifiable iterator from another iterator. All
	 * modifications to the underlying iterator will directly be visible in this
	 * wrapper.
	 */
	public UnmodifiableIterator(Iterator<E> i) {
		if (i == null) {
			throw new IllegalArgumentException(
					"Underlying iterator may not be null!");
		}
		this.i = i;
	}

	/** {@inheritDoc} */
	public boolean hasNext() {
		return i.hasNext();
	}

	/** {@inheritDoc} */
	public E next() {
		return i.next();
	}

	/**
	 * Operation is not supported.
	 * 
	 * @throws UnsupportedOperationException
	 */
	public void remove() {
		throw new UnsupportedOperationException();
	}
}