/*--------------------------------------------------------------------------+
$Id: SumAggregator.java 28099 2010-06-09 13:17:22Z hummelb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.math;

/**
 * Sum aggregator.
 * 
 * @author deissenb
 * @author $Author: hummelb $
 * @version $Rev: 28099 $
 * @levd.rating GREEN Hash: 2BC7AD863CFA78522BE30785E9043E5F
 */
public class SumAggregator extends PairwiseAggregatorBase {

	/** Returns zero. */
	@Override
	public double getNeutralElement() {
		return 0;
	}

	/** {@inheritDoc} */
	@Override
	protected double aggregate(double aggregate, double value) {
		return aggregate + value;
	}
}