/*--------------------------------------------------------------------------+
$Id: CloneUtilsTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.clone;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import junit.framework.TestCase;

/**
 * Test class for <code>CloneUtils</code>-class.
 * 
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: D6EE5A39F81F8F08C4FC0B60C49AF377
 */
public class CloneUtilsTest extends TestCase {

	/**
	 * Test if {@link CloneUtils#cloneAsDeepAsPossible(Object)} works for plain
	 * objects.
	 */
	public void testCloneAsDeepAsPossibleWithObject() throws Exception {
		Object original = new Object();
		Object clone = CloneUtils.cloneAsDeepAsPossible(original);
		assertSame(original, clone);
	}

	/**
	 * Test if {@link CloneUtils#cloneAsDeepAsPossible(Object)} works for
	 * {@link IDeepCloneable}s.
	 */
	public void testCloneAsDeepAsPossibleWithDeepCloneable() throws Exception {
		DeepCloneable original = new DeepCloneable();
		Object clone = CloneUtils.cloneAsDeepAsPossible(original);
		assertNotSame(original, clone);
	}

	/**
	 * Test if {@link CloneUtils#cloneAsDeepAsPossible(Object)} works for
	 * {@link java.util.List}s.
	 */
	@SuppressWarnings("unchecked")
	public void testCloneAsDeepAsPossibleWithList() throws Exception {
		ArrayList<Object> orig = new ArrayList<Object>();
		orig.add("test");
		orig.add(new HashSet());

		ArrayList<Object> clone = (ArrayList<Object>) CloneUtils
				.cloneAsDeepAsPossible(orig);

		assertNotSame(orig, clone);
		assertEquals(orig.get(0), clone.get(0));
		assertNotSame(orig.get(1), clone.get(1));
	}

	/**
	 * Test if {@link CloneUtils#cloneAsDeepAsPossible(Object)} works for
	 * arrays.
	 */
	public void testCloneAsDeepAsPossibleArray() throws Exception {
		String[] original = new String[1];
		original[0] = "test";
		Object clone = CloneUtils.cloneAsDeepAsPossible(original);

		assertNotSame(original, clone);
		assertTrue(clone instanceof String[]);
		assertEquals("test", ((String[]) clone)[0]);
	}

	/** Test cloning some arbitrary cloneable. */
	public void testClonable() throws DeepCloneException {
		Cloneable c = new Cloneable() {
			@Override
			public Object clone() throws CloneNotSupportedException {
				return super.clone();
			}
		};

		Object clone = CloneUtils.cloneAsDeepAsPossible(c);
		assertNotSame(c, clone);

		try {
			CloneUtils.cloneAsDeepAsPossible(new Cloneable() {
				// no public clone method!
			});
			fail("Expected exception.");
		} catch (DeepCloneException e) {
			// expected
		}
	}

	/** Test the handling of infinite recursion. */
	@SuppressWarnings("unchecked")
	public void testRecursion() {
		List l = new ArrayList();
		l.add(l);

		try {
			CloneUtils.cloneAsDeepAsPossible(l);
			fail("Expected exception.");
		} catch (DeepCloneException e) {
			// expected
		}
	}
}