/*--------------------------------------------------------------------------+
$Id: CmdLineTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.options;

import java.util.Arrays;

import junit.framework.TestCase;

/**
 * Tests for <code>CmdLine</code>
 * 
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: A118341A2AD686E6C4B0F4AE8AF29772
 */
@SuppressWarnings("deprecation")
public class CmdLineTest extends TestCase {

	/** Test argument array with standard parameter prefix. */
	private static final String[] args = { "-d", "testDir", "-o", "test 1",
			"test 2", "-x" };

	/** Test argument array with parameter prefix '/'. */
	private static final String[] args2 = { "/d", "testDir", "/o", "test 1",
			"test 2", "/x" };

	/** Command line object with standard parameter prefix. */
	private final CmdLine cmdLine = new CmdLine(args);

	/** Command line object with parameter prefix '/'. */
	private final CmdLine cmdLine2 = new CmdLine(args2, "/");

	/**
	 * Test method for 'edu.tum.cs.commons.options.CmdLine.getParameterCount()'
	 */
	public void testGetParameterCount() {
		assertEquals(6, cmdLine.getParameterCount());
		assertEquals(6, cmdLine2.getParameterCount());
	}

	/**
	 * Test method for 'edu.tum.cs.commons.options.CmdLine.getValues(String)'
	 */
	public void testGetValues() {
		String[] expected = { "test 1", "test 2" };

		assertTrue(Arrays.equals(expected, cmdLine.getValues("o")));
		assertTrue(Arrays.equals(expected, cmdLine2.getValues("o")));
	}

	/**
	 * Test method for 'edu.tum.cs.commons.options.CmdLine.getValue(String)'
	 */
	public void testGetValue() {
		assertEquals("testDir", cmdLine.getValue("d"));
		assertEquals("testDir", cmdLine2.getValue("d"));

		assertEquals("test 1", cmdLine.getValue("o"));
		assertEquals("test 1", cmdLine2.getValue("o"));
	}

	/**
	 * Test method for 'edu.tum.cs.commons.options.CmdLine.hasParameter(String)'
	 */
	public void testHasParameter() {
		assertTrue(cmdLine.hasParameter("d"));
		assertTrue(cmdLine.hasParameter("o"));
		assertTrue(cmdLine.hasParameter("x"));
		assertFalse(cmdLine.hasParameter("y"));

		assertTrue(cmdLine2.hasParameter("d"));
		assertTrue(cmdLine2.hasParameter("o"));
		assertTrue(cmdLine2.hasParameter("x"));
		assertFalse(cmdLine2.hasParameter("y"));
	}

	/**
	 * Test method for
	 * 'edu.tum.cs.commons.options.CmdLine.hasParameterAndValue(String)'
	 */
	public void testHasParameterAndValue() {
		assertTrue(cmdLine.hasParameterAndValue("d"));
		assertTrue(cmdLine.hasParameterAndValue("o"));
		assertFalse(cmdLine.hasParameterAndValue("x"));
		assertFalse(cmdLine.hasParameterAndValue("y"));

		assertTrue(cmdLine2.hasParameterAndValue("d"));
		assertTrue(cmdLine2.hasParameterAndValue("o"));
		assertFalse(cmdLine2.hasParameterAndValue("x"));
		assertFalse(cmdLine2.hasParameterAndValue("y"));
	}

}