/*--------------------------------------------------------------------------+
$Id: SimpleOptionHandler.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.options;

/**
 * Simple class providing some options via the AOption annotation and tests for
 * these options.
 * 
 * @author Benjamin Hummel
 * @author $Author: juergens $
 * 
 * @version $Rev: 26283 $
 *@levd.rating GREEN Hash: B9EE3487C0ACBC44285B008511F1A3BA
 */
public class SimpleOptionHandler {

	/** Counter modifiable via options. */
	public int counter = 0;

	/** Double modifiable via options. */
	public double storedDouble;

	/** Increase counter. */
	@AOption(shortName = 'i', longName = "inc", description = "increase the counter of this test class")
	public void increaseCounter() {
		++counter;
	}

	/** Increase counter by amount. */
	@AOption(shortName = 'g', longName = "greedy", greedy = true, description = "increase the counter by given arg")
	public void increaseCounter(int amount) {
		counter += amount;
	}

	/** Set double value. */
	@AOption(shortName = 's', longName = "store", description = "store the double value")
	public void storeDouble(double d) {
		storedDouble = d;
	}

	/** Does nothing. */
	@AOption(shortName = 'n', description = "has no long name")
	public int hasNoLongName() {
		return 0;
	}

	/** Does nothing. */
	@AOption(longName = "noshort", description = "option without short name")
	public String hasNoShortNameButAParam(String s) {
		return s;
	}

	/** Does nothing. */
	@AOption(shortName = 'l', longName = "verylonglongoptionwithlongname", description = "A lot of text describing one of the longest options we provide with an even longer option name to have the opportunity to test the formatter of the usage() method")
	public void foo() {
		// nothing to do
	}
}