/******************************************************************************
 * $Id: HTMLtemplate.cs 11081 2011-03-05 17:44:17Z tamas $
 *
 * Project:  MapServer
 * Purpose:  A C# based mapscript example to show the usage of HTML templates.
 * Author:   Tamas Szekeres, szekerest@gmail.com
 *
 ******************************************************************************
 * Copyright (c) 1996-2008 Regents of the University of Minnesota.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies of this Software or works derived from this Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *****************************************************************************/

using System;
using OSGeo.MapServer;

/// <summary>
/// A C# based mapscript example to show the usage of HTML templates.
/// </summary>
class HTMLTemplate
{
    public static void usage() 
    { 
	    Console.WriteLine("usage: HTMLTemplate {mapfile} {templatefile} {outdir}");
	    System.Environment.Exit(-1);
    }
    		  
    public static void Main(string[] args)
    {
        if (args.Length < 3) usage();
        
        mapObj map = new mapObj(args[0]);
		map.legend.template = args[1];
		map.web.imagepath = args[2];
		map.web.imageurl = "";
		string str = null;
		string[] names = null, values = null;
		names = new string[] {"map"};
		values = new string[] { args[0] };
		str = map.processLegendTemplate(names, values);
		Console.Write(str);
    }
}

