BEGIN;
CREATE TABLE "us_statecounty" (gid serial PRIMARY KEY,
"area" float8,
"perimeter" float8,
"countyp020" int8,
"state" varchar(2),
"county" varchar(50),
"fips" varchar(5),
"state_fips" varchar(2),
"square_mil" float8);
SELECT AddGeometryColumn('','us_statecounty','the_geom','4326','MULTIPOLYGON',2);
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('53.075','87.571','2','AK','North Slope Borough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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.224','3','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001100000000000000218063C000000060AED4514000000000398063C00000008088D45140000000A04F8063C0000000E088D4514000000060718063C00000002091D45140000000E0248163C0000000A0D8D4514000000040D98163C00000008001D55140000000A0338263C00000002012D55140000000606B8263C00000008031D5514000000000E78263C0000000A059D5514000000020848363C00000000099D5514000000020A58363C000000020B8D5514000000060608363C000000000CED55140000000C05D8263C00000002076D5514000000040D68163C0000000405DD55140000000807C8163C0000000603DD5514000000000DF8063C0000000200DD5514000000000218063C000000060AED45140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.118','4','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000D00000000000000A07463C0000000A0B4CF5140000000A0CD7463C0000000C0ADCF5140000000C0277563C000000020B7CF5140000000C0987563C000000040B9CF514000000040E97563C0000000209CCF514000000020427663C000000000C4CF5140000000A0087663C0000000E0D9CF5140000000A0E47563C0000000C00ED0514000000060A07563C00000002015D0514000000040517563C0000000A013D0514000000000ED7463C0000000A0EBCF5140000000E0667463C0000000C0C2CF514000000000A07463C0000000A0B4CF5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.276','5','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000012000000000000C02C6E63C0000000E0B1CD514000000080F36E63C00000006019CE514000000000E76F63C00000002091CE5140000000A03F7063C000000040B9CE5140000000002A7163C0000000C002CF514000000040A57163C0000000201CCF5140000000C0387263C0000000C00FCF514000000000657263C0000000A027CF514000000040367263C0000000E04CCF5140000000A0977163C00000006051CF5140000000803D7163C0000000E047CF5140000000C0FA7063C0000000A02FCF5140000000608A7063C0000000201ECF514000000040A36F63C0000000C08FCE5140000000E0E66E63C0000000C037CE5140000000A06D6E63C000000060F0CD5140000000C0156E63C000000000B9CD5140000000C02C6E63C0000000E0B1CD5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.167','6','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000012000000000000602A6563C00000008031CB5140000000E0A26563C00000004079CB5140000000E03D6663C000000060B2CB514000000080816663C000000000B4CB514000000020DC6663C000000080AECB514000000020FD6663C000000080BECB514000000080276763C000000020F5CB5140000000801B6763C00000002004CC514000000020CC6663C0000000E009CC514000000040246663C000000000EFCB5140000000A0EC6563C000000060DECB5140000000A0936563C000000060C5CB5140000000C0526563C0000000408ECB514000000000C36463C00000004055CB5140000000408C6463C00000006035CB5140000000E0BA6463C00000000018CB514000000060F26463C0000000A028CB5140000000602A6563C00000008031CB5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.106','7','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001100000000000080A97363C000000000B8BF514000000020097463C00000000034C0514000000020297463C0000000E05AC05140000000E0467463C000000000B7C05140000000602D7463C0000000E002C15140000000C0F37363C00000000028C1514000000060AE7363C0000000205CC1514000000000827363C00000008053C15140000000806C7363C0000000403CC1514000000040427363C000000060FEC05140000000E0247363C0000000809AC0514000000020287363C0000000404EC0514000000020087363C00000006027C0514000000080007363C000000040D3BF5140000000C0197363C0000000208FBF514000000060517363C0000000C097BF514000000080A97363C000000000B8BF5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.002','0.287','8','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000020000000000000E0447463C0000000A043BD5140000000C0627463C0000000E0DDBC514000000000707463C00000000053BC5140000000C0957463C00000008022BC514000000060897463C000000000CFBB5140000000E0837463C000000020A9BB5140000000E0CA7463C0000000E0C2BB5140000000401E7563C000000060E3BB514000000080497563C0000000C0D8BB5140000000003A7563C000000040BBBB5140000000A0197563C00000008078BB5140000000C0077563C0000000A04BBB5140000000A0BF7463C0000000402ABB514000000000917463C000000080D1BA5140000000409F7463C0000000E09ABA514000000020DA7463C0000000E0ADBA5140000000006F7563C0000000E00EBB5140000000A0337663C0000000A083BB514000000080DB7663C000000060CCBB5140000000C0217763C0000000202BBC5140000000A04E7763C000000060C1BC514000000080567763C000000080F6BC514000000040047763C000000080DDBC5140000000C09B7663C000000000C6BC5140000000C04B7663C000000040BCBC5140000000A0C87563C0000000A0D4BC514000000060067563C00000000055BD514000000020DB7463C000000060ACBD514000000080BF7463C0000000A0D4BD514000000020777463C000000060B3BD5140000000205A7463C00000004087BD5140000000E0447463C0000000A043BD5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.053','9','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C00000000000020018663C000000000D1BB5140000000A00D8663C000000080A3BB514000000040518663C0000000808DBB514000000080938663C000000040A5BB514000000060B38663C000000020DBBB5140000000C0BD8663C0000000C0F9BB5140000000609B8663C0000000C017BC5140000000E0848663C0000000201FBC514000000020428663C0000000A016BC5140000000000B8663C000000000FFBB514000000040008663C0000000A0EFBB514000000020018663C000000000D1BB5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.617','10','AK','North Slope Borough','02185','02','89639.488','SRID=4326;010600000001000000010300000001000000390000000000000058E363C00000008093B85140000000600AE363C0000000609CB85140000000E0B1E263C000000020ADB851400000004038E263C000000000C6B8514000000020CAE163C0000000E0EDB85140000000E05BE163C0000000200EB9514000000040D6E063C00000004010B951400000004067E063C0000000A019B95140000000A0F8DF63C00000004032B95140000000408BDF63C0000000E070B951400000004028DF63C0000000A098B9514000000060D0DE63C000000020C0B951400000006056DE63C000000020D1B9514000000020D1DD63C000000060E2B951400000002036DD63C00000002003BA514000000000BDDC63C0000000A032BA514000000040F6DB63C0000000A072BA5140000000E05ADB63C0000000C08BBA514000000060F6DA63C00000008085BA51400000002087DA63C0000000A08EBA5140000000C0DFD963C00000004089BA51400000000017DA63C00000004079BA514000000060B2DA63C00000004060BA5140000000400BDB63C00000008057BA5140000000206FDB63C0000000C046BA5140000000809BDB63C0000000803EBA5140000000A0FEDB63C00000000017BA51400000002056DC63C000000060E0B9514000000020C4DC63C0000000E0B0B95140000000A0FBDC63C000000080A8B951400000008033DD63C000000040AFB951400000000098DD63C000000060B5B9514000000080FBDD63C0000000209DB95140000000A080DE63C0000000E08BB9514000000080E3DE63C0000000A05CB951400000008024DF63C00000004026B95140000000005BDF63C000000040FFB851400000004086DF63C000000080D8B85140000000A0DEDF63C000000040C0B85140000000A021E063C0000000C0C6B85140000000604EE063C0000000C0CDB8514000000060B2E063C000000080C4B851400000000000E163C0000000C0BBB85140000000C090E163C000000060B9B8514000000020DEE163C0000000E0A8B851400000000015E263C00000002091B851400000000057E263C00000004079B8514000000040A3E263C0000000204AB8514000000000E5E263C0000000A02AB851400000000032E363C00000008012B851400000000028E363C00000002031B851400000004034E363C0000000804FB85140000000C04AE363C0000000C056B851400000004077E363C00000000056B85140000000808EE363C00000002074B85140000000A078E363C0000000207CB851400000000058E363C00000008093B85140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.146','11','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000015000000000000E0AA1963C000000080C9B8514000000060EA1963C00000004080B85140000000E0381A63C0000000607CB85140000000C0C31A63C000000080B8B8514000000040501B63C000000080E5B8514000000040771B63C0000000E01CB9514000000060951B63C0000000003DB9514000000060B41B63C00000006055B95140000000A0D21B63C00000006075B9514000000020BA1B63C0000000208BB95140000000408B1B63C0000000E09FB95140000000C05B1B63C000000020BCB95140000000C0251B63C000000040AAB9514000000000FE1A63C0000000807AB9514000000060D51A63C00000006052B95140000000C0AD1A63C00000008022B95140000000E06E1A63C000000040F9B8514000000060371A63C0000000A0F6B8514000000020E81963C00000000002B9514000000040A61963C000000040F7B85140000000E0AA1963C000000080C9B85140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.063','12','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C000000000000802AD663C000000040ADB851400000002057D663C0000000C0ACB85140000000A084D663C000000060D2B85140000000E0B2D663C0000000C00EB9514000000060F7D663C0000000E04AB951400000008003D763C0000000E070B9514000000060AAD663C00000000072B951400000006088D663C0000000805BB951400000006065D663C0000000A026B951400000004043D663C00000008008B951400000004020D663C0000000E0CBB85140000000802AD663C000000040ADB85140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.075','13','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000D00000000000020EA1763C000000060A0B7514000000020231863C0000000E093B75140000000204D1863C0000000E0ACB75140000000806A1863C0000000A0D4B7514000000020AD1863C0000000E042B85140000000E09A1863C0000000C086B85140000000A0751863C000000040ABB85140000000201B1863C000000000B6B85140000000A0E71763C0000000408DB8514000000080B61763C0000000C04DB8514000000000D31763C00000000012B85140000000A0D81763C0000000C0DCB7514000000020EA1763C000000060A0B75140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.049','14','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000E00000000000000E2D563C000000000D1B7514000000020EDD563C0000000E0D0B75140000000A003D663C000000040D8B75140000000401AD663C000000040E7B75140000000003CD663C000000000F6B75140000000A05ED663C00000006023B85140000000E075D663C00000004049B85140000000A076D663C0000000C067B85140000000C06BD663C0000000806FB851400000002034D663C00000002070B85140000000C006D663C00000004052B8514000000020D9D563C00000000025B8514000000060CCD563C000000020E8B7514000000000E2D563C000000000D1B75140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.041','15','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000900000000000060811763C0000000205EB75140000000E08A1763C0000000E06DB75140000000E0861763C0000000E093B7514000000060621763C0000000A0B0B75140000000001F1763C000000000B5B75140000000A0F61663C0000000C08CB7514000000040071763C00000000058B75140000000A03F1763C00000002053B7514000000060811763C0000000205EB75140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.051','16','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C000000000000206E0B63C000000040DEA65140000000A06B0B63C000000000F5A6514000000020680B63C00000006013A7514000000000590B63C0000000C038A75140000000804A0B63C00000008056A75140000000203C0B63C00000004074A7514000000080040B63C0000000E078A7514000000060CF0A63C0000000C066A7514000000020E70A63C000000080F5A65140000000200D0B63C0000000C0C9A65140000000805C0B63C000000020B7A65140000000206E0B63C000000040DEA65140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.094','17','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000011000000000000A020FF62C0000000403AA55140000000E047FF62C0000000C062A55140000000E052FF62C00000006063A551400000008080FF62C0000000A056A5514000000040B7FF62C0000000E059A5514000000020ECFF62C0000000206CA5514000000080F3FF62C0000000208BA55140000000A0F1FF62C0000000409AA55140000000E0C5FF62C0000000C097A55140000000A07FFF62C000000000BAA55140000000E03DFF62C000000020B6A55140000000A0E2FE62C0000000C073A55140000000A084FE62C00000002048A55140000000409EFE62C0000000002BA55140000000E0C0FE62C0000000C01DA55140000000C0ECFE62C00000006020A55140000000A020FF62C0000000403AA55140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.124','18','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000D000000000000C0F7FB62C0000000C0A7A451400000006039FC62C0000000A0ABA451400000006077FC62C0000000C0CDA45140000000C0F9FC62C000000020DDA451400000006098FD62C00000002014A55140000000A0BEFD62C00000004044A551400000002070FD62C0000000E04EA551400000004045FD62C0000000C044A55140000000E0C1FC62C0000000203DA55140000000802AFC62C0000000E024A5514000000080D9FB62C0000000A0EAA4514000000020D3FB62C000000020C4A45140000000C0F7FB62C0000000C0A7A45140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.471','19','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001B00000000000080B2AE62C0000000604FA35140000000004BAF62C0000000405CA35140000000A0B2AF62C0000000A083A351400000000086B062C0000000C0BBA351400000006029B162C000000040C9A35140000000A0DCB162C0000000407CA35140000000402DB262C000000040A9A351400000004088B262C0000000E099A3514000000060CDB262C0000000E00AA451400000004048B362C00000002043A45140000000409EB362C0000000E051A45140000000405DB462C00000004080A4514000000080F5B262C00000008062A45140000000C0B2B262C0000000A064A4514000000080F2B162C0000000A03DA45140000000602FB162C0000000C025A45140000000402BB062C00000006008A45140000000603BAF62C000000040F4A35140000000202CAE62C00000006098A35140000000004EAD62C0000000405FA3514000000000F0AC62C00000004040A35140000000A014AD62C0000000402CA351400000008041AD62C00000008028A35140000000E0C2AD62C0000000203BA3514000000000DAAD62C00000006035A35140000000E070AE62C0000000800CA3514000000080B2AE62C0000000604FA35140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.061','20','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000008000000000000401DA962C0000000006AA25140000000605AA962C0000000E048A25140000000608FA962C00000002055A25140000000A0B5A962C00000002077A25140000000E0A3A962C0000000009CA25140000000204AA962C000000080A3A2514000000020C2A862C00000002079A25140000000401DA962C0000000006AA25140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.072','21','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000A000000000000C09DA762C000000060DDA1514000000040DCA762C0000000E0B4A1514000000080FBA762C000000040BFA151400000002042A862C000000000E4A151400000008087A862C00000006010A251400000008096A862C00000000038A25140000000007AA862C0000000E05BA25140000000C0F8A762C00000000049A25140000000C07FA762C0000000E008A25140000000C09DA762C000000060DDA15140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.302','22','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001A00000000000060EDA262C000000080E59F5140000000C078A362C00000004074A0514000000000BEA362C0000000A0A0A051400000000006A462C000000000BEA051400000000021A462C000000020DFA051400000008072A462C00000000005A1514000000080C9A462C0000000800CA15140000000E0F8A462C00000000037A151400000002060A562C0000000C05EA15140000000E027A662C00000008096A151400000000065A662C0000000E0B2A151400000000056A662C0000000A0C8A15140000000A0FDA562C000000080C8A15140000000A034A562C00000004098A15140000000805CA462C0000000C07DA1514000000080A2A362C000000040FAA0514000000000C4A262C0000000A08AA05140000000605AA262C00000008034A0514000000040E3A162C0000000A0EC9F514000000080C1A162C0000000E0B39F5140000000E0F3A162C000000000929F51400000000035A262C0000000C0979F5140000000E075A262C0000000E0DA9F51400000006092A262C000000080F49F5140000000C0CCA262C0000000A0E29F514000000060EDA262C000000080E59F5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.052','23','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000B0000000000006032F762C0000000E0D1A05140000000E07BF762C000000040EDA05140000000A0AFF762C00000006007A1514000000040A6F762C00000002053A15140000000A089F762C0000000E086A151400000004047F762C0000000808AA151400000006020F762C00000000062A151400000002008F762C0000000C01BA15140000000E00CF762C0000000E0F5A05140000000801DF762C000000000C9A051400000006032F762C0000000E0D1A05140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.055','24','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000B000000000000E0A0F662C000000060889F5140000000A0D2F662C000000080B19F5140000000C0E1F662C0000000E0E79F5140000000C0BEF662C0000000C050A0514000000060A9F662C000000060A3A05140000000208AF662C0000000403EA05140000000E082F662C0000000401FA051400000004046F662C000000060F59F5140000000204AF662C000000020D79F5140000000A064F662C000000080B29F5140000000E0A0F662C000000060889F5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.113','25','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000014000000000000806FCE62C0000000A02E9F51400000002093CE62C000000080D59E514000000080B9CE62C000000020B29E5140000000A0E1CE62C000000000CC9E514000000000EDCE62C0000000C0119F514000000080E9CE62C000000060289F5140000000A0CBCE62C0000000C05B9F514000000040D9CE62C000000060929F514000000000E7CE62C0000000E0C89F514000000080BFCE62C0000000E0F39F5140000000008ACE62C000000040E89F5140000000205CCE62C000000020F49F5140000000802FCE62C000000080F89F514000000060D8CD62C000000000F29F5140000000207BCD62C000000080CC9F5140000000E08BCD62C000000080A79F514000000080BFCD62C0000000C0759F51400000002003CE62C0000000806B9F5140000000E01FCE62C0000000C03F9F5140000000806FCE62C0000000A02E9F5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.006','0.431','26','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000032000000000000E0EACE62C000000060C09B514000000020EACE62C0000000C00C9C5140000000C0EFCE62C000000040789C514000000000EFCE62C0000000A0C49C514000000000C8CE62C0000000C0349D5140000000E090CE62C0000000207D9D5140000000C083CE62C0000000608B9D5140000000A06FCE62C000000020C79D5140000000C045CE62C000000040019E5140000000201ECE62C0000000202C9E514000000080CECD62C0000000403D9E5140000000A094CD62C0000000E04F9E51400000006028CD62C0000000A08C9E514000000000DFCC62C0000000C0BC9E5140000000C0B3CC62C000000060FE9E51400000000097CC62C0000000202A9F5140000000E0A6CC62C0000000A0519F51400000006074CC62C0000000C07B9F5140000000600BCC62C0000000C0A19F5140000000A0A3CB62C000000040C09F5140000000E065CB62C0000000A0A49F5140000000A076CB62C0000000A07F9F514000000040C1CB62C000000000489F514000000060C8CB62C0000000A01A9F5140000000C0E2CB62C000000000FE9E5140000000C0A2CB62C0000000A0F19E5140000000C057CB62C000000040E49E5140000000E01FCB62C0000000E0A29E514000000040D7CA62C000000080869E514000000080D3CA62C000000040589E51400000006008CB62C0000000001F9E51400000000071CB62C000000020B49D5140000000C08DCB62C000000060889D5140000000E0ACCB62C0000000804D9D5140000000C0C5CB62C0000000A0F39C514000000080E4CB62C0000000E0739C5140000000C0E1CB62C0000000203E9C5140000000C02FCC62C0000000C0EF9B514000000080B7CC62C0000000E08E9B514000000060FECC62C0000000006E9B5140000000E071CD62C0000000C0489B5140000000C06FCE62C000000000F89A5140000000E06CCF62C000000080629A514000000060C9CF62C000000020439A514000000020FCCF62C0000000E05D9A5140000000600ED062C000000020769A5140000000C021D062C0000000E0869A51400000002005D062C0000000A0B29A5140000000407ECF62C000000080589B5140000000E0EACE62C000000060C09B5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.043','27','AK','North Slope Borough','02185','02','89639.488','SRID=4326;010600000001000000010300000001000000090000000000006012CB62C000000040519D5140000000E02BCB62C000000000819D5140000000A029CB62C000000020909D5140000000000ECB62C000000060B49D514000000040C9CA62C000000020C69D51400000002094CA62C000000080BA9D5140000000E09FCA62C0000000E06E9D514000000040D1CA62C0000000604C9D51400000006012CB62C000000040519D5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.051','28','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000009000000000000008BE362C0000000609C9C51400000006042E362C000000000CD9C51400000002000E362C000000020D09C5140000000A0D3E262C0000000C0D49C514000000020C3E262C000000080AD9C5140000000C0F1E262C0000000A0999C5140000000402AE362C0000000208E9C5140000000806DE362C000000060839C5140000000008BE362C0000000609C9C5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.059','29','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000A000000000000807CCB62C0000000804D9C5140000000E077CB62C0000000A06B9C51400000006074CB62C000000060829C5140000000C040CB62C000000000B49C514000000060A6CA62C0000000C0B79C514000000060A1CA62C000000020919C514000000060B9CA62C0000000A0839C5140000000E003CB62C0000000004C9C5140000000C049CB62C0000000A0329C5140000000807CCB62C0000000804D9C5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.165','30','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000F000000000000C0ADCA62C000000020B49B5140000000A0B2CA62C0000000C0DA9B51400000006086CA62C0000000E0239C5140000000A03ACA62C000000000639C514000000080D6C962C0000000C06A9C514000000060D0C962C0000000C04B9C514000000080A1C962C0000000205F9C514000000020E4C862C0000000606F9C5140000000C02CC862C0000000C0599C514000000020CDC862C000000060309C5140000000E0F5C862C0000000E0FD9B51400000006010C962C000000060E19B5140000000209CC962C0000000C0AE9B5140000000C079CA62C0000000E0A09B5140000000C0ADCA62C000000020B49B5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.285','31','AK','North Slope Borough','02185','02','89639.488','SRID=4326;010600000001000000010300000001000000180000000000008084CF62C0000000E07E995140000000C08ACF62C0000000E09D9951400000008075CF62C000000040E19951400000004043CF62C0000000600B9A5140000000C0E6CE62C0000000C02A9A5140000000209ACE62C000000080719A5140000000405FCE62C0000000C08B9A51400000002011CE62C000000040959A5140000000C0CDCD62C0000000809F9A5140000000A061CD62C000000060DC9A51400000006018CD62C0000000600C9B5140000000C08BCC62C0000000C0469B5140000000E009CC62C0000000E0819B5140000000A098CB62C000000000989B5140000000E030CB62C000000080719B51400000000068CB62C000000040299B5140000000001ACD62C0000000A0739A5140000000205ECD62C0000000C01C9A5140000000E097CD62C0000000200A9A51400000002047CE62C000000020C3995140000000A07FCE62C000000000B899514000000060A6CE62C000000080D9995140000000602FCF62C0000000C0B59951400000008084CF62C0000000E07E995140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.105','32','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C000000000000C086CB62C000000080A99A51400000004083CB62C000000020C09A5140000000006ACB62C000000040D59A5140000000001CCB62C000000080239B5140000000806DCA62C0000000C0629B5140000000C00ACA62C000000000639B514000000080ECC962C000000060519B5140000000001FCA62C000000060279B5140000000A07BCA62C000000020089B5140000000E0BECA62C000000000B99A51400000002049CB62C0000000E08D9A5140000000C086CB62C000000080A99A5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.068','33','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000B00000000000000B79B62C000000060749A5140000000C0A39B62C0000000C0A09A5140000000A09D9B62C000000040FC9A5140000000208D9B62C000000080199B514000000060519B62C0000000A0329B5140000000A0DE9A62C000000020119B514000000020C89A62C000000060D99A5140000000E0E49A62C0000000C0B59A5140000000602B9B62C0000000809D9A514000000020769B62C0000000806E9A514000000000B79B62C000000060749A5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.197','34','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001B000000000000E0FFD162C0000000405D985140000000004ED262C0000000A053985140000000205FD262C000000080739851400000002087D262C0000000608D985140000000A093D262C000000060CB9851400000004053D262C0000000800B99514000000040E5D162C0000000A057995140000000408CD162C000000060609951400000008051D162C0000000A07A9951400000004037D162C00000004097995140000000C04FD162C0000000A0CE9951400000006028D162C0000000A0F999514000000000E9D062C000000020329A514000000080BCD062C000000080369A5140000000E0A2D062C0000000C0069A5140000000605AD062C000000080EA99514000000000F3CF62C000000000099A5140000000A0DFCF62C000000060F8995140000000E000D062C000000060AE995140000000C044D062C00000008057995140000000C047D062C000000000FC9851400000002057D062C0000000A0DE98514000000060FBD062C00000008096985140000000006AD162C0000000608F985140000000009FD162C0000000009B98514000000060CAD162C0000000209E985140000000E0FFD162C0000000405D985140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.071','35','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000014000000000000A0BBFF63C0000000E07B985140000000A0B1FF63C0000000808B985140000000809DFF63C000000080AA9851400000004094FF63C000000020C99851400000004096FF63C000000020EF985140000000008DFF63C0000000E00D995140000000206DFF63C0000000E01D995140000000C02BFF63C0000000801F995140000000400AFF63C0000000401199514000000060DCFE63C0000000C0E498514000000020C4FE63C0000000C0B798514000000000C3FE63C0000000E0A0985140000000A0C1FE63C0000000208A98514000000080D6FE63C0000000607A985140000000C0F6FE63C000000000729851400000002023FF63C000000000809851400000004044FF63C0000000C0869851400000008064FF63C0000000407E985140000000809AFF63C00000004075985140000000A0BBFF63C0000000E07B985140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.003','0.337','36','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000027000000000000C0D7D662C0000000E0F7955140000000A0FED662C000000020199651400000000024D762C0000000808E965140000000805AD762C00000000070975140000000C039D762C000000020BA975140000000E0D6D662C000000000079851400000002066D662C0000000801D985140000000C06BD662C0000000C0F7975140000000407DD662C000000020CB9751400000002054D662C0000000E0B89751400000004023D662C0000000A0DB9751400000000008D662C0000000E0FF9751400000006083D562C00000000052985140000000003ED562C0000000A06B985140000000C0C6D462C000000000639851400000002070D462C0000000C05C985140000000A0F9D362C0000000009998514000000080AAD362C000000040AA9851400000006071D362C00000008070985140000000E038D362C0000000C07B985140000000E007D362C0000000609E98514000000040FED262C000000000969851400000002012D362C0000000605A985140000000A0D5D262C0000000603798514000000060DCD262C0000000000A985140000000C003D362C000000000DF975140000000A040D362C000000080B597514000000080A2D362C00000004070975140000000E0CAD362C0000000A03D975140000000C0A0D362C0000000003397514000000040D7D362C000000060EA96514000000020E2D462C00000006083965140000000604BD562C00000008055965140000000608DD562C0000000A05296514000000080AAD562C0000000C06B965140000000E0BDD562C0000000607C96514000000040EAD562C0000000E077965140000000803BD662C0000000A057965140000000C0D7D662C0000000E0F7955140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.002','0.480','37','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000021000000000000E0C92164C0000000A077955140000000C0A02164C0000000A09795514000000060612164C0000000E0B0955140000000A0022164C000000080DA95514000000080812064C000000080EE955140000000C0172064C00000006018965140000000208F1F64C0000000605A965140000000403A1E64C000000020C2965140000000E0B01D64C000000060FC965140000000601E1D64C0000000C04D975140000000A0751C64C0000000409897514000000000CB1B64C000000020CC975140000000804E1B64C00000004024985140000000C0C21A64C0000000204098514000000060671A64C00000006006985140000000E04E1A64C000000020E1975140000000A0631A64C000000040D197514000000060991A64C0000000C0C797514000000020061B64C0000000E0C3975140000000802F1B64C000000000A4975140000000A0A31B64C0000000407297514000000060041C64C0000000A05F97514000000000581C64C0000000C02E97514000000040D41C64C0000000A0D696514000000000351D64C000000000C4965140000000E0F21D64C0000000007196514000000000B31E64C0000000603C96514000000000521F64C0000000400196514000000000C61F64C000000060CF955140000000804E2064C0000000608D955140000000A05B2164C0000000E06495514000000000C72164C0000000C051955140000000E0C92164C0000000A077955140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.064','38','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000011000000000000406A0064C000000020B997514000000060760064C0000000A0CF975140000000E0570064C000000080F697514000000060380064C0000000200E985140000000A0010064C0000000000898514000000080AAFF63C0000000400A9851400000002089FF63C0000000E0FB9751400000006092FF63C000000040DD975140000000C0A7FF63C000000000D597514000000040D3FF63C0000000E0D397514000000000F3FF63C0000000E0C397514000000040130064C000000060BB97514000000040320064C0000000209C975140000000803B0064C0000000807D975140000000A0510064C0000000808497514000000000690064C000000060A2975140000000406A0064C000000020B9975140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.003','1.298','39','AK','North Slope Borough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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.046','40','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000900000000000060A18062C0000000003195514000000080938062C0000000003F95514000000040878062C0000000604595514000000080548062C0000000C06695514000000060298062C00000008062955140000000E0E87F62C0000000005C95514000000000038062C0000000A047955140000000A0438062C0000000401895514000000060A18062C00000000031955140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.385','41','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000002000000000000060B12864C0000000A007935140000000209E2864C0000000E026935140000000208C2864C0000000405593514000000060582864C0000000C075935140000000E0022864C00000006088935140000000808D2764C0000000E0A3935140000000400D2764C0000000C0BF93514000000040A32664C000000060E2935140000000002F2664C0000000000D94514000000020BD2564C0000000E05594514000000020332564C00000004081945140000000607E2464C000000000B694514000000020FF2364C0000000E0E0945140000000E06B2364C0000000602395514000000080EB2264C0000000203F95514000000040B22264C0000000401B95514000000060C42264C0000000C0EC94514000000060042364C000000040DB945140000000C04F2364C0000000C0D094514000000060BA2364C0000000E0B594514000000000302464C0000000809A945140000000C0832464C0000000407194514000000040192564C0000000004D94514000000000992564C0000000A029945140000000E0012664C0000000E0F7935140000000E0682664C000000060AF935140000000C0BA2664C0000000606F935140000000C0FB2664C0000000C06C935140000000009D2764C0000000205793514000000060062864C0000000E02C935140000000807A2864C0000000200293514000000060B12864C0000000A007935140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.098','42','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000E000000000000A03A8062C000000020A494514000000060488062C0000000E0CB94514000000060208062C000000040EE94514000000060F57F62C0000000E0E994514000000000BB7F62C000000040FB945140000000E0A37F62C0000000800095514000000000577F62C0000000800095514000000040077F62C0000000C0D994514000000040C57E62C0000000E0A494514000000080E27E62C00000008081945140000000601B7F62C0000000E07794514000000040A77F62C0000000E085945140000000A0208062C0000000C082945140000000A03A8062C000000020A4945140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.060','43','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000D00000000000060E1FB63C0000000E0EA935140000000A004FC63C0000000401F945140000000E0E4FB63C0000000402F94514000000040D0FB63C0000000C0469451400000000087FB63C0000000C07D945140000000C050FB63C0000000207F9451400000006044FB63C000000000619451400000008056FB63C0000000201C945140000000E053FB63C0000000E0E6935140000000E066FB63C000000020B193514000000080A6FB63C00000002091935140000000A0BDFB63C000000000AF93514000000060E1FB63C0000000E0EA935140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.254','44','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001E000000000000C0584364C000000040F8915140000000804F4364C0000000E00792514000000080264364C0000000C02092514000000060D44264C00000008052925140000000C0984264C0000000A08A925140000000E0264264C0000000A0C592514000000000D44164C0000000C0EF92514000000080444164C0000000604A93514000000020DE4064C0000000208C93514000000020364064C000000080C9935140000000A0C23F64C000000020F5935140000000A0773F64C00000004000945140000000409F3F64C000000040D893514000000060C83F64C000000080BF93514000000040FC3F64C000000020A6935140000000E0234064C0000000407E93514000000000574064C0000000405D93514000000040AC4064C0000000004A93514000000040EA4064C0000000A02893514000000080124164C0000000200893514000000080654164C000000020DE92514000000040CD4164C000000080AB92514000000020164264C0000000808992514000000080334264C00000008069925140000000E07A4264C0000000603892514000000060C44264C0000000E01D92514000000080D54264C000000060EF915140000000200A4364C000000080DD91514000000020404364C000000000DB915140000000C0584364C000000040F8915140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.080','45','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000016000000000000E006FB63C000000000289251400000004013FB63C000000020469251400000004015FB63C0000000206C925140000000200DFB63C000000080A19251400000006030FB63C0000000E0D5925140000000E03DFB63C0000000E00A935140000000A034FB63C000000080299351400000000001FB63C00000000060935140000000E0D7FA63C0000000C08E935140000000C0C1FA63C0000000A08793514000000040B6FA63C0000000C078935140000000E0A9FA63C0000000A05A935140000000609CFA63C0000000C025935140000000A08FFA63C00000000000935140000000606CFA63C0000000A0CB9251400000002074FA63C0000000808E9251400000000071FA63C0000000C051925140000000A079FA63C0000000E02392514000000020A3FA63C0000000E0FC91514000000060CEFA63C0000000C0FB91514000000040E5FA63C00000000012925140000000E006FB63C00000000028925140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.004','0.981','46','AK','North Slope Borough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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.076','47','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000D000000000000A0756762C000000060AB8F5140000000608E6762C0000000C09E8F514000000080CE6762C0000000C0A58F514000000020116862C000000080D38F5140000000A04F6862C000000000E28F5140000000E08F6862C000000000E98F514000000080876862C0000000800E90514000000080796862C0000000601C90514000000020566862C0000000E027905140000000401D6862C0000000003190514000000080B56762C00000006016905140000000A06B6762C000000080D88F5140000000A0756762C000000060AB8F5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.188','48','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001900000000000060086762C0000000001F8E514000000020266762C0000000E0FB8D5140000000A0616762C000000080B58D514000000040836762C000000080B18D514000000060906762C000000060D98D5140000000C0AD6762C0000000201A8E514000000020DA6762C000000040178E5140000000604D6862C000000060FD8D5140000000605F6862C0000000C00E8E5140000000A0256862C0000000A04D8E5140000000A0F26762C0000000806E8E514000000020AA6762C0000000008D8E514000000040506762C000000060C88E514000000080FE6662C000000020428F5140000000C0E06662C000000060658F5140000000A0A96662C000000000678F5140000000A0516662C0000000E0368F514000000060E46562C000000060048F5140000000609D6562C000000040898E514000000080FD6562C0000000E0938E5140000000002A6662C000000000918E514000000060366662C0000000C08A8E5140000000C0766662C0000000C02D8E5140000000A0DD6662C0000000601A8E514000000060086762C0000000001F8E5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.091','49','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C00000000000080F36962C000000060E88C5140000000A0176A62C0000000200B8D5140000000A0046A62C0000000802F8D514000000080E06962C0000000C0708D5140000000A03D6962C0000000809C8D514000000060C66862C000000040978D5140000000C0D36862C0000000405B8D514000000000FC6862C000000020398D514000000000396962C000000040EB8C5140000000407D6962C000000080AD8C514000000000A86962C000000020B28C514000000080F36962C000000060E88C5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.135','50','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001100000000000060CE6862C0000000A07B8C5140000000001E6962C0000000406D8C514000000020226962C0000000808C8C5140000000E0276962C000000020A48C5140000000E0146962C000000080C88C514000000080E36862C0000000E0E18C5140000000E0A96862C0000000E0208D5140000000E07F6862C0000000604A8D5140000000205E6862C0000000604E8D514000000020276862C000000020508D514000000060F36762C0000000C0428D514000000080A46762C0000000601B8D514000000060176762C000000080E58C5140000000C05A6762C000000080DD8C5140000000208C6762C000000020C48C5140000000A0626862C0000000C0A58C514000000060CE6862C0000000A07B8C5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.342','51','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001E000000000000A0943E62C000000000748B514000000080C03E62C000000000A08B514000000060C73E62C000000040B08B514000000060233F62C000000000CB8B5140000000C0B23F62C0000000C0F38B514000000040654062C0000000A03F8C5140000000A0FB4062C0000000A0788C5140000000804D4162C0000000C0638C5140000000009E4162C000000040288C514000000000F04162C000000080138C5140000000C0044262C000000040448C514000000060224262C0000000E07D8C5140000000606E4262C0000000C0AD8C5140000000409C4262C000000020D28C5140000000E0744262C000000020EC8C514000000000354262C000000060E48C5140000000A0F34162C0000000E0B58C514000000040B94162C0000000A0978C514000000080604162C0000000209C8C514000000000594162C000000000BA8C514000000000E34162C000000020F98C5140000000E0554262C0000000203D8D5140000000C0B94162C0000000A01A8D514000000060664162C0000000C0088D5140000000C0F84062C000000080DC8C514000000020CF3F62C0000000C0898C514000000040F03E62C000000020408C5140000000006E3E62C0000000E0E28B5140000000E05E3E62C0000000A09B8B5140000000A0943E62C000000000748B5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.169','52','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000010000000000000A0F8EA61C0000000A03B895140000000E0B9EA61C00000000078895140000000A039EA61C000000020B289514000000080E4E961C000000000CC8951400000006020E961C0000000200B8A51400000006096E861C0000000E01C8A51400000008053E861C000000060FB89514000000080BBE861C000000040EC895140000000A01DE961C0000000A0CC8951400000002075E961C000000060AB895140000000C0BFE961C0000000E08F895140000000A0E1E961C0000000608D8951400000006010EA61C00000000085895140000000E04CEA61C000000000508951400000006088EA61C0000000C041895140000000A0F8EA61C0000000A03B895140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.381','53','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000002000000000000020D8F061C0000000C0C1885140000000600EF161C000000000E98851400000004046F161C0000000802F895140000000E0D6F161C0000000C073895140000000203EF261C0000000008B895140000000C066F261C00000002072895140000000C0A6F261C0000000E05489514000000080EAF261C0000000804F895140000000E00DF361C0000000006C895140000000003BF361C00000004044895140000000E06FF361C0000000204C895140000000006DF361C0000000407A895140000000A04CF361C0000000409C89514000000060F5F261C0000000C0BD895140000000607EF261C000000080DA895140000000601FF261C000000060CC8951400000004077F161C0000000408C8951400000000062F061C00000008024895140000000A007F061C0000000400789514000000060FCEE61C0000000A0C788514000000040DCED61C0000000C084885140000000E081ED61C00000008067885140000000C097ED61C0000000004488514000000000D1ED61C0000000203D8851400000008064EE61C00000008053885140000000C08DEF61C0000000C078885140000000E0EEEF61C0000000807F8851400000000019F061C0000000E0858851400000002049F061C0000000A09C885140000000406AF061C0000000C0C08851400000008094F061C000000020C788514000000020D8F061C0000000C0C1885140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.005','0.558','54','AK','North Slope Borough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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.481','55','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000022000000000000603E0062C0000000A0D2855140000000004D0062C000000000EC85514000000060200062C00000000014865140000000405DFF61C0000000607B8651400000002072FE61C000000020D58651400000008012FE61C0000000C0148751400000008046FD61C0000000C0998751400000002042FD61C0000000A0A8875140000000603DFD61C000000020DE875140000000C0E3FC61C0000000202E885140000000E064FC61C0000000404288514000000080FDFB61C0000000602B885140000000002FFB61C000000080FD875140000000A0C1FA61C000000020D6875140000000E0DCF961C0000000205F875140000000206BF961C0000000A04687514000000060EAF861C0000000603B8751400000008041F961C0000000C019875140000000A0BDF961C0000000C033875140000000E065FA61C00000006073875140000000E033FB61C0000000E0C7875140000000208CFB61C000000020EC875140000000E058FC61C0000000C0FA875140000000C09EFC61C0000000C0ED87514000000060C5FC61C000000060B587514000000040DBFC61C0000000006B875140000000808DFD61C0000000801887514000000040EFFD61C000000080D1865140000000402FFE61C0000000608D8651400000000060FE61C0000000407D865140000000A0A3FE61C00000008077865140000000A06AFF61C0000000202886514000000020D9FF61C000000020DB855140000000603E0062C0000000A0D2855140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.060','56','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000B000000000000C092E961C0000000A032875140000000A0C9E961C0000000403387514000000040E2E961C0000000604E875140000000A0B8E961C0000000208E875140000000E091E961C0000000400C885140000000C051E961C000000040298851400000002048E961C0000000E0008851400000004036E961C000000080CF8751400000002023E961C0000000E07E875140000000A052E961C0000000C04F875140000000C092E961C0000000A032875140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.002','0.647','57','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000005A00000000000080E35864C0000000E0587C514000000020BD5864C000000020817C5140000000608F5864C000000040C87C514000000000605864C000000020007D514000000080235864C000000000227D5140000000A0BF5764C000000060647D514000000000915764C0000000E0A37D5140000000001C5764C0000000600D7E5140000000C0C75664C0000000A07C7E514000000020905664C0000000E0CB7E5140000000205A5664C0000000202A7F5140000000A0185664C000000080817F5140000000C0E15564C000000040D87F5140000000C0B35564C0000000401F805140000000E05C5564C0000000C07780514000000040035564C0000000C0B980514000000000CE5464C0000000A01F81514000000040835464C0000000A08681514000000020435464C000000020ED81514000000020E65364C0000000A07382514000000060915364C0000000C0E2825140000000805D5364C0000000C05783514000000020275364C000000020B6835140000000E0025364C0000000E0F4835140000000A0DE5264C0000000C033845140000000009B5264C0000000007C845140000000C0425264C0000000E0CC845140000000A00B5264C0000000A023855140000000E0D55164C0000000808985514000000060625164C000000080A6855140000000E0F75064C0000000E0B385514000000080C15064C000000020AF855140000000C0C95064C0000000E09785514000000000EA5064C00000002096855140000000003F5164C0000000008A855140000000805D5164C0000000207985514000000020855164C0000000805885514000000060A05164C0000000602985514000000040D05164C000000080F1845140000000C0F75164C0000000E0D0845140000000002A5264C0000000C0AF845140000000E0595264C0000000E077845140000000406B5264C0000000E05084514000000080655264C0000000E01B845140000000C05F5264C0000000E0E683514000000040835264C000000080A083514000000000B35264C0000000A068835140000000E0CF5264C0000000A048835140000000A0F65264C0000000802083514000000040305364C000000060E082514000000020565364C0000000C0B0825140000000E0855364C0000000E07882514000000040B25364C0000000C02282514000000060E05364C0000000A0DB815140000000A01B5464C0000000C0AA81514000000000435464C0000000208A815140000000605D5464C00000008053815140000000608B5464C0000000800C81514000000020BA5464C000000000CD805140000000C0E95464C00000002095805140000000E00D5564C0000000205680514000000020315564C0000000A00F80514000000080535564C0000000A0C17F5140000000806E5564C000000080927F5140000000C0965564C000000080797F514000000080D35564C0000000A0577F5140000000A0EE5564C000000080287F5140000000C0085664C0000000C0F17E514000000000315664C0000000C0D87E5140000000E0345664C0000000A09B7E514000000060645664C0000000C0637E5140000000C0B45664C0000000A0317E5140000000C0EF5664C0000000A0007E514000000000285764C000000000B97D5140000000204B5764C000000080727D5140000000C0905764C000000000417D514000000060D65764C0000000800F7D5140000000E0045864C000000000D07C514000000060335864C000000080907C514000000000675864C0000000607E7C5140000000A08C5864C0000000A04E7C5140000000C0C55864C0000000800E7C5140000000A0085964C000000040C67B5140000000004F5964C0000000409C7B514000000040725964C0000000A0B87B5140000000406A5964C0000000E0CF7B5140000000E04B5964C0000000E0E07B5140000000A0255964C000000020097C5140000000E0005964C000000060407C514000000080E35864C0000000E0587C5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.099','58','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000D0000000000000063FD61C000000060BD8451400000004093FD61C0000000E0D3845140000000E0A1FD61C000000040ED845140000000E0BAFD61C000000040088551400000008096FD61C00000002039855140000000E008FD61C0000000C05A855140000000A046FC61C0000000807485514000000040D7FC61C000000020FE84514000000080EEFC61C0000000C0F9845140000000602BFD61C0000000800A855140000000E059FD61C0000000E0018551400000002054FD61C0000000C0CA8451400000000063FD61C000000060BD845140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.069','59','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000E000000000000C0BA5164C0000000A08F84514000000080BC5164C0000000E09E84514000000020B45164C000000020B6845140000000808C5164C0000000A0D6845140000000A06F5164C0000000C0F684514000000000495164C0000000E01E855140000000C0025164C0000000405085514000000080C25064C0000000C05385514000000000C05064C0000000003D85514000000040DB5064C0000000E00D855140000000A0035164C0000000E0F4845140000000A0335164C000000000BD845140000000C06F5164C0000000C093845140000000C0BA5164C0000000A08F845140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.106','60','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000B000000000000E0690462C0000000A04E84514000000040390462C0000000E05E845140000000C0080462C0000000206F84514000000000AE0362C00000004079845140000000C0330362C0000000E07E84514000000020D70262C0000000C06984514000000000BE0262C0000000E04E84514000000080FD0262C00000004031845140000000A09B0362C00000006021845140000000201E0462C0000000C024845140000000E0690462C0000000A04E845140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.134','61','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C00000000000020980962C0000000A0CF82514000000020310962C000000020B982514000000000F40862C000000060CF825140000000005A0862C0000000201E835140000000E0E30762C0000000606283514000000080A00762C0000000406883514000000040830762C0000000A03583514000000060AD0762C0000000E01483514000000020430862C000000020D582514000000080E90862C000000040A782514000000020590962C0000000E09F82514000000020980962C0000000A0CF825140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.079','62','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000B000000000000A0291C62C000000020727F5140000000403A1C62C0000000405D7F514000000060771C62C0000000406D7F514000000080E21C62C000000020747F5140000000C04D1D62C0000000007B7F514000000040651D62C0000000209D7F514000000020391D62C0000000E09E7F5140000000000B1D62C000000000A87F5140000000C09B1C62C000000020B07F5140000000A04B1C62C0000000C0957F5140000000A0291C62C000000020727F5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.058','63','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000B000000000000C099CD61C0000000A0A87C5140000000E0CDCD61C000000020B17C5140000000A027CE61C000000080EE7C51400000004055CE61C0000000802C7D5140000000A02FCE61C0000000E05C7D5140000000C012CE61C000000060507D5140000000C002CE61C0000000203E7D514000000000C1CD61C0000000001C7D5140000000A081CD61C000000080F27C51400000004083CD61C0000000E0CB7C5140000000C099CD61C0000000A0A87C5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.056','64','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000009000000000000E0ABCC61C000000080F57B514000000080D5CC61C000000060FC7B514000000060F2CC61C0000000E0087C5140000000407BCD61C0000000A05D7C51400000008052CD61C000000000767C5140000000403BCD61C0000000007A7C5140000000E0DFCC61C000000040637C5140000000A0A4CC61C0000000A00B7C5140000000E0ABCC61C000000080F57B5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.100','65','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001600000000000040DE5A64C000000040DB79514000000060CC5A64C0000000C0FA795140000000A0A85A64C0000000A0397A514000000060825A64C0000000E0617A514000000080685A64C0000000A0987A5140000000E03A5A64C0000000C0DF7A5140000000C0025A64C000000080277B5140000000A0D25964C0000000E0577B5140000000A0A95964C000000060697B5140000000C0A35964C000000080347B514000000080B65964C0000000A01C7B514000000000DC5964C0000000E0EC7A5140000000A0EE5964C000000000D57A514000000040EB5964C0000000C0B67A514000000040DD5964C000000000997A514000000040055A64C000000000807A5140000000602C5A64C0000000205F7A5140000000403E5A64C0000000C03F7A514000000000625A64C0000000E0007A5140000000009B5A64C0000000C0C0795140000000A0C45A64C0000000C0B679514000000040DE5A64C000000040DB795140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.356','66','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000010000000000000603CC461C0000000C02677514000000080A6C461C0000000C0307751400000006001C561C0000000C047775140000000C0C7C561C000000060A777514000000060D7C661C00000002032785140000000C00FC861C0000000A00979514000000040CFC861C0000000207F7951400000008030C961C0000000C0C579514000000040B4C961C000000060297A5140000000C061C961C0000000E03A7A5140000000601BC961C000000080277A5140000000807DC861C0000000E0AF7951400000002028C761C0000000C0CB785140000000C0B1C561C0000000C0E9775140000000A0A4C461C00000008057775140000000603CC461C0000000C026775140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.003','0.740','67','AK','North Slope Borough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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.061','68','AK','North Slope Borough','02185','02','89639.488','SRID=4326;010600000001000000010300000001000000080000000000000024C261C00000004040765140000000806CC261C0000000804C76514000000060F1C261C0000000E089765140000000200CC361C000000020BD765140000000C0E2C261C000000040B6765140000000A065C261C000000000827651400000008024C261C0000000805F7651400000000024C261C00000004040765140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.098','69','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C000000000000C073C061C0000000006B75514000000000ADC061C00000004084755140000000E024C161C000000040C7755140000000A09EC161C0000000A0E3755140000000A0C8C161C0000000E00976514000000040C4C161C0000000E037765140000000407EC161C000000040247651400000000019C161C0000000600B765140000000808CC061C0000000E0C4755140000000A05AC061C000000080957551400000004052C061C0000000206D755140000000C073C061C0000000006B755140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.125','70','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000000C000000000000C0D2BD61C000000000367451400000008008BE61C000000020187451400000008068BE61C0000000E03F74514000000000E8BE61C0000000208C74514000000080B5BF61C000000000F5745140000000C0A1BF61C00000002030755140000000A066BF61C0000000603D755140000000002BBF61C0000000802B75514000000080CABE61C0000000A0E47451400000008040BE61C0000000A09674514000000000E3BD61C00000008067745140000000C0D2BD61C00000000036745140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.002','1.051','71','AK','North Slope Borough','02185','02','89639.488','SRID=4326;010600000001000000010300000001000000210000000000000043AC61C0000000C06F6C5140000000A08AAC61C0000000003E6C514000000000D5AC61C000000080436C51400000002010AD61C0000000C0556C51400000002034AD61C0000000A06B6C5140000000008EAD61C000000060836C5140000000A0F4AD61C0000000A0956C5140000000E096AE61C0000000A0176D5140000000407EB061C0000000C09D6E514000000000E0B261C0000000C05F705140000000E0F1B361C0000000A0FC70514000000020EAB461C00000008085715140000000001EB661C0000000402072514000000060DDB661C00000002070725140000000A0C8B761C0000000C0BF72514000000080C8B861C0000000E01273514000000000B4B961C00000006062735140000000C0ACBA61C000000080CB7351400000002017BC61C0000000A028745140000000607CBC61C0000000E06074514000000020C5BB61C00000000059745140000000C0EDB961C000000040BA7351400000006033B861C00000000028735140000000A07EB661C000000000A6725140000000C057B561C0000000E02472514000000040DBB361C0000000E03E7151400000002029B261C0000000E03770514000000000F3B061C000000060466F5140000000403CAF61C000000000F06D5140000000C03FAE61C000000000376D5140000000A062AD61C0000000E0C16C514000000060BEAC61C000000020C46C51400000000043AC61C0000000C06F6C5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.003','0.493','72','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000004E000000000000C0BE6464C0000000600A5E5140000000A0E76464C000000040005E5140000000A0096564C0000000E0145E5140000000E0226564C000000060395E5140000000E01D6564C000000040675E514000000080146564C000000080CA5E5140000000200C6564C000000060355F5140000000801F6564C000000020805F5140000000A0266564C000000060BC5F514000000080306564C0000000600F60514000000060336564C00000002081605140000000002B6564C000000000EC605140000000800E6564C0000000C05F61514000000000F36464C000000000DB61514000000000F56464C0000000404562514000000040FC6464C00000008081625140000000A0FB6464C000000040D562514000000080EA6464C0000000E04F63514000000060D96464C000000080CA63514000000040EB6464C00000006061645140000000C0F76464C000000000CB64514000000080ED6464C0000000C026655140000000A0EE6464C0000000808965514000000060ED6464C0000000C030665140000000A0ED6464C0000000008C665140000000E0FE6464C0000000807667514000000020DF6464C0000000402768514000000020B66464C0000000808C685140000000E0896464C0000000E02E69514000000020746464C0000000C083695140000000004D6464C000000060F869514000000040146464C0000000408C6A5140000000A0C56364C0000000E0196B514000000060796364C0000000E0626B514000000060386364C0000000A0576B5140000000803E6364C000000040316B5140000000E0576364C000000080FA6A5140000000C0916364C000000060C96A514000000080B66364C000000080996A5140000000A0D76364C0000000804B6A5140000000C0E36364C0000000C0FE69514000000060E56364C0000000A0B2695140000000C0136464C0000000A07A69514000000020416464C0000000E03A695140000000E0656464C0000000200B69514000000080606464C0000000C0DD685140000000606E6464C000000020A0685140000000008B6464C0000000602C68514000000000876464C000000000B3675140000000C08D6464C00000000039675140000000408E6464C0000000208A665140000000E07F6464C0000000801166514000000040756464C0000000E0B6655140000000E07C6464C00000008044655140000000608A6464C0000000A0AB645140000000A06B6464C0000000005A645140000000A0696464C0000000C0EF635140000000E0736464C0000000E09363514000000040926464C0000000402F635140000000E0926464C0000000C0DB62514000000040886464C00000002081625140000000E0876464C0000000E025625140000000807A6464C0000000C0B461514000000080866464C00000002068615140000000A07D6464C0000000A01C61514000000060776464C0000000E0E760514000000060756464C0000000A07D605140000000409D6464C0000000E01060514000000060BC6464C0000000C0B35F514000000000B76464C0000000A0865F5140000000C09C6464C0000000A05A5F5140000000C0B66464C0000000602B5F514000000040B26464C0000000C0055F514000000000986464C0000000C0D95E5140000000C0A66464C0000000C0A35E5140000000E0D36464C000000020645E5140000000A0B96464C000000040385E5140000000C0BE6464C0000000600A5E5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.156','73','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000025000000000000E0BE6464C0000000C0F65B5140000000A0E86464C000000020F45B514000000020ED6464C0000000E0195C514000000080F26464C000000020475C514000000040EE6464C0000000807C5C5140000000E0EB6464C000000000C15C514000000040EA6464C0000000000D5D514000000040F46464C000000000605D514000000020036564C000000000855D514000000080D26464C000000060A65D5140000000E0A06464C000000040C05D514000000040766464C000000040BB5D514000000080746464C000000020AC5D5140000000E0846464C000000020855D514000000000776464C0000000A0675D5140000000605F6464C000000060525D5140000000E0336464C0000000C0455D5140000000A0066464C0000000402A5D514000000040226464C0000000200A5D514000000060566464C000000000075D5140000000E0876464C000000020ED5C5140000000A0966464C000000000B75C5140000000C09A6464C0000000A0815C5140000000A08E6464C000000040735C5140000000805A6464C000000060765C514000000000146464C000000080915C514000000000CC6364C0000000809D5C5140000000C0D36364C000000040865C514000000060F06364C0000000C06D5C514000000080036464C0000000605D5C5140000000600A6464C0000000A03E5C514000000080FB6364C000000080195C5140000000A00E6464C000000020095C514000000020396464C0000000200E5C5140000000405A6464C0000000401B5C514000000020836464C000000040115C5140000000E0BE6464C0000000C0F65B5140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('73.832','63.003','74','AK','Yukon-Koyukuk Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.038','75','AK','North Slope Borough','02185','02','89639.488','SRID=4326;01060000000100000001030000000100000012000000000000A04CCE64C0000000208A1951400000004063CE64C00000000097195140000000A064CE64C0000000809E195140000000005CCE64C0000000E0A61951400000000052CE64C000000000A81951400000008049CE64C000000060B0195140000000002DCE64C0000000E0BA1951400000002019CE64C000000000BD19514000000000F4CD64C0000000E0CF19514000000080E1CD64C000000060D919514000000040D6CD64C000000000D319514000000080D3CD64C000000000C419514000000020DCCD64C000000080BB19514000000060E3CD64C0000000A0AB19514000000000ECCD64C000000020A319514000000080FECD64C0000000A099195140000000001BCE64C0000000208F195140000000A04CCE64C0000000208A195140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.027','76','AK','North Slope Borough','02185','02','89639.488','SRID=4326;0106000000010000000103000000010000001400000000000080FDC864C0000000605A1851400000000010C964C0000000E050185140000000E023C964C0000000E04E185140000000202FC964C000000060551851400000002039C964C000000060541851400000006044C964C0000000E05A185140000000A045C964C000000060621851400000004048C964C00000004071185140000000404CC964C0000000A087185140000000E04EC964C0000000A0961851400000004046C964C0000000209F185140000000A03DC964C000000080A7185140000000E01FC964C000000080AA185140000000A014C964C000000000A41851400000004013C964C0000000A09C185140000000C002C964C000000040781851400000006001C964C0000000C07018514000000020F6C864C0000000406A185140000000E0F4C864C0000000E06218514000000080FDC864C0000000605A185140');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('19.390','48.764','77','AK','Northwest Arctic Borough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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.037','78','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;01060000000100000001030000000100000013000000000000C0C15064C00000008087C05040000000A0D45064C00000008086C0504000000040165164C0000000007BC05040000000E0315164C0000000C071C05040000000603B5164C00000004071C05040000000A0455164C00000002078C05040000000004F5164C00000008077C05040000000C04F5164C0000000007FC0504000000080505164C00000008086C05040000000C0475164C0000000808EC05040000000003F5164C0000000A096C0504000000080355164C00000002097C05040000000C0195164C000000060A0C05040000000A0FC5064C0000000A09AC0504000000080EA5064C000000040A3C05040000000C0D65064C0000000E09CC05040000000A0CC5064C00000000096C0504000000060C25064C0000000008FC05040000000C0C15064C00000008087C05040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.036','79','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001000000000000020114F64C0000000E030BF5040000000C0244F64C00000004037BF5040000000C0394F64C0000000804CBF5040000000204E4F64C0000000605ABF5040000000C0594F64C00000004070BF5040000000205B4F64C0000000207FBF5040000000A0494F64C0000000408FBF504000000060374F64C0000000E097BF5040000000A02E4F64C0000000E09FBF5040000000401A4F64C00000000092BF504000000000FB4E64C0000000C075BF504000000040E54E64C00000000059BF504000000060DA4E64C0000000A04ABF5040000000A0D94E64C00000002043BF504000000040EB4E64C00000002033BF504000000020114F64C0000000E030BF5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.053','80','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001A00000000000040633564C0000000C054BD5040000000806B3564C00000006045BD5040000000C0903564C0000000003CBD504000000060AB3564C00000002024BD504000000040C73564C0000000401BBD504000000060D23564C00000002031BD504000000020CA3564C0000000A040BD504000000020C33564C0000000005FBD504000000040BA3564C00000000067BD504000000080B23564C0000000E07DBD504000000060B43564C00000006094BD5040000000C0B63564C000000040B2BD5040000000C0A63564C0000000A0D8BD5040000000209F3564C000000080EFBD504000000040963564C000000080F7BD504000000080713564C00000006008BE504000000020683564C0000000C008BE5040000000005E3564C0000000C001BE5040000000004B3564C0000000C002BE504000000040493564C000000040ECBD5040000000803D3564C0000000E0CEBD5040000000004E3564C000000000B0BD5040000000C04C3564C000000000A1BD5040000000204B3564C0000000808ABD5040000000605A3564C0000000C05CBD504000000040633564C0000000C054BD5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.033','81','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;01060000000100000001030000000100000011000000000000E09D0A64C0000000E05BA75040000000C0A50A64C0000000606BA7504000000060AE0A64C00000008073A75040000000E0A20A64C00000004089A75040000000C08E0A64C00000000097A7504000000000840A64C000000060A5A75040000000206F0A64C0000000A0BAA75040000000A0510A64C0000000E0C7A7504000000040430A64C0000000E0C0A7504000000080400A64C0000000C0B7A75040000000A0380A64C000000040A8A75040000000003A0A64C00000004099A75040000000E04E0A64C00000000084A75040000000605A0A64C0000000406EA75040000000A0780A64C0000000A059A75040000000008C0A64C00000004053A75040000000E09D0A64C0000000E05BA75040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('10.421','44.359','82','AK','Nome Census Area','02180','02','22960.205','SRID=4326;010600000001000000010300000001000000A4160000000000A0A88C64C0000000E05FA5504000000080AA8C64C00000004005A4504000000060AE8C64C0000000807D9E5040000000E0318A64C0000000E07D9E504000000020388A64C000000000DA8D5040000000E0358A64C0000000A05A8C504000000000348A64C0000000404C8A5040000000E0348A64C00000002054885040000000E0D28764C00000006052885040000000A0CC8764C000000000EC805040000000E0CB8764C0000000C0037E504000000020CE8764C000000080387D504000000060CD8764C000000060B475504000000060D38764C0000000802672504000000020798564C00000002024725040000000A00E8164C0000000002772504000000080D97E64C0000000A02772504000000000D77E64C0000000405E6F504000000040D57E64C0000000409C6C504000000060D17E64C0000000E0AC6A504000000040D17E64C0000000007969504000000020D47E64C00000004044695040000000A0D57E64C0000000606A68504000000040D17E64C00000006011675040000000C0867B64C00000006011675040000000602A7864C0000000C01167504000000020287864C0000000C04D5E5040000000C02C7864C000000080FC5B504000000000B06564C0000000E0F75B5040000000A0366464C000000040FC5B5040000000A0626264C0000000C0F75B5040000000E01E5F64C000000060FD5B5040000000208A5D64C000000040FB5B5040000000A0D15B64C000000020FB5B5040000000E0335A64C0000000E0F85B504000000020195A64C0000000C0FA5B5040000000801D5964C000000080FC5B5040000000E08D5864C000000080FE5B5040000000201C5364C000000000F85B504000000040904964C000000040FA5B504000000040874164C000000060FB5B5040000000A0A23964C000000060FB5B504000000000263164C000000000FD5B5040000000C0B12C64C0000000E0F95B5040000000C0612864C0000000C0FA5B5040000000809D2164C000000000F85B504000000080AB2064C000000040FB5B5040000000E0C61E64C000000000FA5B5040000000204A1C64C000000000FF5B5040000000404C1464C000000000F95B5040000000007E1364C0000000A0F95B5040000000802D1364C0000000C0FC5B5040000000007A1264C000000040FC5B5040000000200E1264C000000000F95B5040000000A0631164C000000000F85B504000000040F81064C000000020FC5B5040000000E0441064C000000060FB5B504000000000D90F64C000000000F85B504000000000260F64C0000000C0FE5B504000000020BA0E64C000000040FB5B5040000000C00F0E64C000000020FA5B504000000040A40D64C000000000FE5B5040000000E0F00C64C000000020FD5B504000000000850C64C0000000A0F95B504000000080EC0B64C0000000A0F75B504000000020660B64C000000060FC5B5040000000A0CD0A64C000000080FA5B504000000040500A64C000000000FF5B5040000000C0AE0964C000000040FD5B504000000000310964C000000020FA5B504000000080980864C000000000F85B504000000020120864C0000000A0FC5B504000000080790764C000000060FA5B504000000040FC0664C0000000C0FE5B5040000000C05A0664C0000000C0FC5B504000000000DD0564C000000080F95B5040000000C0560564C000000000FE5B504000000020BE0464C0000000A0FB5B504000000080370464C0000000A0F85B504000000040A80364C000000040FD5B5040000000A0210364C000000040FA5B504000000060890264C000000020FF5B5040000000A0020264C000000000FC5B5040000000206A0164C000000080F95B5040000000C0E30064C0000000C0FD5B504000000040540064C0000000C0FA5B5040000000E0CDFF63C000000000FF5B50400000004035FF63C000000040FC5B5040000000A0C0FE63C000000060F85B50400000008016FE63C0000000A0FD5B5040000000A0AAFD63C000000080F95B5040000000A0F7FC63C000000000FF5B5040000000C08BFC63C0000000C0FA5B504000000060E1FB63C000000060F85B5040000000E06CFB63C0000000E0FB5B504000000080C2FA63C000000060F95B50400000000057FA63C000000080FC5B504000000080A3F963C000000040FA5B5040000000C0A8F963C000000080866150400000000092F863C000000000876150400000004072F763C0000000A0876150400000006052F663C00000002088615040000000A03BF563C0000000408861504000000000FCF263C0000000A08861504000000040E5F163C0000000808861504000000080CEF063C00000002088615040000000C0AEEF63C0000000E087615040000000206FED63C000000000876150400000006058EC63C00000002086615040000000C054EC63C000000000FA5B50400000000016EC63C000000080FB5B50400000006010EC63C0000000A044595040000000C012EC63C0000000A06F565040000000600FEC63C000000000E4505040000000802CED63C0000000A0E4505040000000A049EE63C000000020E5505040000000C05DEF63C0000000C0E5505040000000E07AF063C000000020E65050400000000098F163C000000040E650504000000040A3F263C0000000C0E6505040000000A0A3F263C0000000205B4B504000000000A4F263C0000000C0CF455040000000804BF263C000000020D2455040000000204CF263C0000000E046405040000000C04CF263C0000000E0BB3A50400000006066F363C0000000E0BB3A50400000000080F463C0000000A0BB3A5040000000C090F563C0000000A0BB3A504000000060AAF663C000000040BB3A504000000000C4F763C0000000C0BA3A504000000000CCF863C000000080BA3A504000000040D0F863C0000000802F355040000000A0CBF863C0000000E0A42F5040000000A07AF963C000000020A72F504000000080E3F963C000000020A42F5040000000E089FA63C0000000A0A62F5040000000C0F2FA63C000000060A32F5040000000E0A1FB63C0000000A0A52F5040000000A00AFC63C000000060A22F5040000000A0B9FC63C000000080A42F50400000008022FD63C000000040A12F5040000000C0C8FD63C0000000A0A32F5040000000A031FE63C000000060A02F504000000040CFFE63C0000000C0A22F5040000000C0CEFE63C000000020182A504000000040CEFE63C0000000A08D245040000000C0CDFE63C000000060031F504000000060CDFE63C000000020791950400000004054FE63C000000080751950400000002054FE63C0000000A0EB1350400000002054FE63C0000000C0610E50400000000054FE63C000000020D8085040000000E053FE63C0000000A04E03504000000040DCFD63C0000000004B0350400000006042FD63C0000000804803504000000020DCFC63C0000000A04B0350400000004031FC63C0000000A04903504000000060D3FB63C0000000804C035040000000A028FB63C0000000604A03504000000040C2FA63C0000000804D0350400000006017FA63C0000000404B03504000000000B1F963C0000000604E0350400000002006F963C0000000204C035040000000A0FDF863C0000000604C03504000000020A8F863C0000000804703504000000080FDF763C0000000804C035040000000E096F763C00000002048035040000000009CF763C0000000A07DFB4F400000008098F763C0000000A06BF04F400000002095F763C0000000205AE54F4000000000A4F863C0000000E058E54F40000000C0B2F963C00000006057E54F4000000000B9FA63C00000002056E54F40000000C0C7FB63C00000002054E54F4000000020CEFC63C00000006052E54F40000000E0DCFD63C0000000E04FE54F40000000A0D4FD63C0000000C03EDA4F40000000A06CFE63C0000000A043DA4F40000000A0E2FE63C0000000E03BDA4F40000000A07AFF63C0000000C040DA4F40000000A0F0FF63C00000000039DA4F4000000080880064C0000000C03DDA4F4000000020F60064C00000006036DA4F40000000208E0164C0000000203BDA4F4000000060040264C0000000E041DA4F40000000009C0264C00000008037DA4F40000000000A0364C0000000E03EDA4F40000000E0900364C0000000A035DA4F4000000040950364C00000006023CF4F40000000009A0464C00000000020CF4F4000000080A70564C0000000C02ACF4F4000000040AC0664C0000000E026CF4F4000000060B90764C00000002022CF4F4000000080BE0864C0000000C02CCF4F40000000E0BA0964C0000000E028CF4F4000000000C80A64C00000008023CF4F4000000080D50B64C0000000C02CCF4F4000000040DA0C64C00000008027CF4F4000000080E70D64C00000008021CF4F40000000A0EC0E64C0000000E02ACF4F4000000000E90F64C0000000A025CF4F4000000080EC0F64C00000000013C44F4000000060F01064C0000000E00CC44F4000000020FD1164C0000000E014C44F4000000080091364C0000000A00DC44F40000000E00D1464C0000000E015C44F40000000401A1564C0000000400EC44F40000000E0151664C0000000A007C44F40000000C0141664C000000060F5B84F40000000C0131664C000000040E3AD4F40000000205C1564C000000000E4AD4F40000000805B1564C000000040D2A24F4000000080651664C000000040CAA24F40000000A0671764C0000000C0D1A24F40000000A0711864C000000020C9A24F40000000C0731964C000000020D0A24F40000000C07D1A64C000000040C7A24F4000000080771B64C0000000A0CEA24F4000000020721B64C000000020AE974F4000000040751B64C0000000009C8C4F4000000060781B64C0000000008A814F40000000E0771C64C00000006081814F4000000000801D64C0000000A086814F40000000E07F1E64C0000000808C814F40000000A0871F64C00000008082814F4000000080872064C00000000088814F40000000A08F2164C0000000408C814F40000000208F2264C00000006082814F40000000409F2464C0000000208A814F40000000409F2564C0000000408E814F40000000A01A2664C00000000082814F40000000E0A62664C0000000C082814F40000000C0A62764C0000000A086814F40000000E0AE2864C00000008089814F40000000C0AE2964C0000000E08C814F4000000060B62A64C00000004080814F4000000040B62B64C00000004083814F4000000060BE2C64C00000002085814F4000000040BE2D64C0000000C087814F4000000060C62E64C00000002089814F4000000060C62F64C0000000608B814F4000000060CE3064C0000000408C814F4000000080D63164C0000000E08C814F4000000060D63264C0000000608E814F4000000020DE3364C0000000C07F814F4000000000DE3464C0000000C080814F4000000020E63564C0000000A080814F4000000060723664C0000000A07F814F4000000000E63664C00000004081814F4000000020EE3764C0000000A080814F4000000000EE3864C0000000C080814F4000000020F63964C0000000A07F814F4000000080F63A64C0000000208E814F40000000A0FE3B64C0000000A08C814F40000000A0FE3C64C0000000E08B814F40000000A0063E64C0000000E089814F40000000C0063F64C0000000A088814F40000000E00E4064C00000004086814F4000000060124064C00000002030864F40000000000E4064C0000000E09A8C4F40000000C0164164C000000040988C4F4000000080174264C000000040968C4F40000000E0204364C000000020A28C4F4000000080214464C0000000C09F8C4F40000000602A4564C0000000409C8C4F40000000002B4664C000000060998C4F40000000802B4664C0000000C010944F4000000040244664C0000000C0D1954F4000000060264664C000000060AF974F40000000A0304764C000000020BA974F4000000040324864C0000000E0B6974F40000000E03B4964C000000040B2974F40000000403D4A64C0000000C0AE974F4000000060474B64C0000000A0B8974F4000000080404C64C0000000A0B5974F4000000060404C64C0000000A0CBA24F40000000E04A4D64C000000040C6A24F40000000A04D4E64C0000000A0D0A24F4000000000584F64C0000000C0CAA24F40000000205A5064C0000000C0C5A24F4000000020655164C000000040CEA24F40000000005F5264C000000000CAA24F40000000A0905264C000000040C3A24F4000000080E35264C0000000007AA34F4000000060E75264C000000020D3A34F4000000040CB5264C0000000A04EA44F4000000060865264C000000080DEA44F40000000C0605264C0000000403DA54F4000000040455264C000000080C7A54F40000000803F5264C00000002004A64F40000000A0115264C00000000064A64F4000000040A85164C00000008070A74F4000000000755164C0000000C01BA84F40000000C02E5164C00000002050A94F4000000000E25064C0000000E0EFA94F4000000060755064C000000000B2AA4F40000000C0295064C0000000806FAB4F4000000020A94F64C0000000A0ABAC4F4000000000494F64C000000060D4AD4F4000000080004F64C000000020DCAE4F4000000040D04E64C0000000A0D1AF4F4000000080A84E64C0000000C003B04F4000000020904E64C00000000016B04F4000000020704E64C00000002038B04F40000000E04E4E64C0000000803CB04F40000000C0374E64C0000000806CB04F40000000E02A4E64C0000000E0C7B04F40000000400D4E64C00000008025B14F4000000080034E64C000000040CBB14F4000000040EE4D64C0000000A027B24F40000000A0D94D64C00000000093B24F40000000C0C34D64C0000000A0E0B24F4000000040AD4D64C0000000601FB34F40000000C0964D64C0000000205EB34F40000000C0D84D64C00000006046B34F40000000A0FA4D64C0000000E050B34F40000000E0FB4D64C0000000806EB34F4000000080BF4D64C0000000000CB44F4000000000734D64C000000060BAB44F40000000A0564D64C0000000A035B54F40000000A0424D64C0000000E0AFB54F40000000C0134D64C0000000C000B64F4000000080EC4C64C0000000C041B64F40000000E0BE4C64C000000060B0B64F40000000009C4C64C00000004059B74F4000000040874C64C000000080C4B74F40000000C0534C64C0000000A06FB84F4000000080164C64C000000020FEB84F40000000E0E84B64C0000000C06CB94F40000000009B4B64C000000060FDB94F40000000205D4B64C0000000007DBA4F40000000A0374B64C000000060EABA4F40000000400F4B64C0000000A00DBB4F40000000A0D64A64C0000000E041BB4F40000000E08F4A64C0000000A0B3BB4F4000000040414A64C00000006035BC4F4000000080EB4964C0000000E0D5BC4F40000000C07C4964C00000008079BD4F4000000000174964C0000000E02ABE4F40000000E00F4964C0000000C049BE4F40000000C0E94864C000000040A8BE4F4000000060DB4864C0000000E0E5BE4F4000000000DF4864C0000000203FBF4F4000000040D04864C0000000E03EC04F40000000C0E64864C000000060D1C04F40000000400B4964C00000006017C14F40000000003E4964C0000000C01FC14F40000000E0684964C00000002038C14F4000000040744964C00000006081C14F40000000C06D4964C000000000AFC14F40000000604F4964C0000000A0FDC14F4000000020384964C0000000802DC24F40000000C03B4964C0000000A086C24F40000000E0484964C0000000A0FCC24F40000000007A4964C0000000A0A9C34F40000000C0A94964C0000000E038C44F40000000E0D74964C0000000809BC44F40000000E00E4A64C0000000E00BC54F40000000C0194A64C00000004046C54F40000000C00A4A64C00000000075C54F40000000E0C74964C0000000A07DC54F40000000A0954964C00000002084C54F40000000E0684964C0000000203FC54F40000000203D4964C00000000018C54F40000000C01B4964C0000000401CC54F40000000E0FA4864C0000000602FC54F4000000060BD4864C0000000A0ECC44F4000000040A44864C0000000C0EFC44F40000000406D4864C00000006050C54F4000000060334864C0000000C066C54F4000000080184864C0000000603DC54F4000000020E54764C00000000026C54F4000000040874764C00000002005C54F40000000A06D4764C000000080F9C44F4000000040594764C000000060A2C44F4000000060444764C0000000803CC44F4000000080384764C000000060E4C34F4000000040154764C000000000BCC34F4000000020084764C00000002046C34F4000000000DC4664C00000000010C34F40000000C0A94664C00000004016C34F40000000A0624664C0000000E087C34F40000000402C4664C000000040F7C34F4000000060E94564C0000000A0FFC34F40000000C0C04564C0000000C022C44F4000000080934564C0000000C0CEC34F40000000A0784564C000000060A5C34F40000000604F4564C000000080B9C34F40000000C0264564C000000060DCC34F40000000200A4564C00000006086C34F4000000040074564C0000000003CC34F40000000E02C4564C0000000A0CEC24F40000000E0324564C00000002092C24F40000000200F4564C0000000C05AC24F4000000020844464C0000000E0E5C14F40000000A00B4464C0000000209BC14F4000000020EA4364C0000000409FC14F40000000E0A74364C000000080B6C14F40000000407F4364C000000060D9C14F4000000000524364C00000006085C14F40000000602F4364C0000000C06BC14F40000000401F4364C0000000A07CC14F40000000E0104364C000000020BAC14F40000000A0034364C00000006015C24F40000000C0CF4264C000000000EFC14F4000000000A64264C000000020F4C14F40000000407D4264C00000000017C24F40000000E0614264C0000000A0DEC14F40000000604E4264C00000006096C14F4000000080334264C0000000E06CC14F40000000E0224264C0000000E06EC14F4000000000204264C00000008024C14F40000000A0264264C000000000F7C04F40000000E0724264C0000000600BC14F4000000060AD4264C00000004004C14F4000000060BC4264C0000000A0D5C04F4000000060B84264C0000000806DC04F40000000808A4264C0000000A00AC04F40000000C0604264C0000000C00FC04F4000000020414264C00000006040C04F40000000A01F4264C0000000A044C04F4000000080144264C000000040FBBF4F4000000040094264C0000000E0B1BF4F40000000C0CA4164C00000000051BF4F40000000007B4164C000000040E3BE4F40000000E0224164C00000008076BE4F4000000000EE4064C00000006032BE4F4000000040C44064C00000006037BE4F40000000209C4064C00000000069BE4F4000000080954064C0000000A096BE4F4000000000604064C00000008043BE4F40000000E03C4064C0000000001BBE4F40000000804C4064C000000020FBBD4F40000000A0754064C000000040E7BD4F4000000080834064C0000000E09ABD4F40000000E0824064C0000000208CBD4F4000000040AD4064C0000000E095BD4F4000000040B34064C00000006059BD4F40000000A0B14064C0000000C02CBD4F40000000C0C14064C0000000E01BBD4F4000000080174164C0000000404DBD4F4000000020404164C0000000802ABD4F4000000020684164C0000000C0F8BC4F4000000060754164C0000000809DBC4F4000000020834164C00000002051BC4F40000000A0604164C00000008037BC4F40000000E0454164C0000000E00DBC4F40000000C0444164C000000020F0BB4F40000000A07A4164C00000000072BB4F4000000020A24164C00000008031BB4F4000000020BB4164C0000000802EBB4F40000000A0034264C0000000E0BABB4F40000000802E4264C000000080D3BB4F40000000A0614264C000000020EBBB4F40000000E08A4264C000000020D7BB4F40000000A0AB4264C000000020C4BB4F4000000020BB4264C000000060A4BB4F4000000020C14264C0000000E067BB4F40000000E0B44264C0000000E000BB4F40000000009F4264C0000000207DBA4F4000000020894264C000000060F9B94F4000000040864264C000000000AFB94F40000000608D4264C00000004090B94F4000000060BB4264C00000000022B94F40000000A0D24264C000000060F2B84F4000000020EB4264C000000080E0B84F40000000800C4364C000000040DCB84F4000000000484364C0000000E0F2B84F4000000020714364C0000000E0DEB84F4000000080A24364C0000000C0C9B84F4000000040D24364C00000002088B84F40000000A0314464C0000000C004B84F40000000A0594464C000000000D3B74F40000000409C4464C0000000A0CAB74F40000000A0FF4464C000000020AFB74F4000000000304564C0000000607CB74F40000000E06D4564C000000000FDB64F4000000040764564C000000000FCB64F4000000000844564C0000000A0AFB64F40000000E0924564C00000000081B64F4000000040884564C00000008046B64F40000000206B4564C0000000A0E1B54F40000000E04C4564C0000000005FB54F4000000080414564C0000000E0E6B54F40000000C03D4564C0000000C05EB64F4000000000304564C000000020ABB64F40000000600F4564C000000040BEB64F4000000020F84464C0000000E0EDB64F4000000060D74464C00000000001B74F4000000080A64464C00000000025B74F4000000080744464C0000000602BB74F4000000020534464C0000000602FB74F40000000E0314464C0000000A033B74F4000000060194464C0000000A045B74F4000000020084464C0000000C038B74F4000000040E64364C0000000202EB74F40000000A0CC4364C00000006022B74F4000000000A34364C00000008027B74F4000000040824364C0000000803AB74F4000000040474364C0000000E032B74F40000000401E4364C0000000E046B74F4000000040DD4264C0000000C07BB74F4000000060AC4264C0000000A09FB74F4000000040734264C000000080C4B74F4000000060204264C0000000A0DDB74F4000000020F04164C00000006010B84F4000000060CF4164C00000004023B84F40000000C0AB4164C0000000E0EBB74F40000000E0714164C0000000E001B84F40000000C0574164C000000040E7B74F40000000404E4164C000000080CAB74F40000000201B4164C0000000E0B2B74F4000000040034164C0000000A0D3B74F40000000A0E34064C00000006004B84F4000000060CC4064C00000000034B84F4000000040C64064C00000008070B84F40000000A0B54064C00000008072B84F40000000C09D4064C00000004093B84F40000000C0984064C000000080EDB84F4000000020A54064C00000008054B94F4000000020B84064C0000000E08DB94F4000000020874064C0000000C0B1B94F4000000080544064C000000000A9B94F40000000E0304064C00000008071B94F40000000200C4064C0000000601CB94F4000000000F23F64C0000000A001B94F4000000000CF3F64C000000020D9B84F40000000A0D13F64C00000006043B84F40000000C0CE3F64C000000020F9B74F40000000A0B43F64C000000060DEB74F40000000C0793F64C000000080D6B74F4000000060443F64C00000006083B74F40000000800F3F64C0000000203FB74F40000000A0F73E64C0000000C05FB74F4000000080F13E64C0000000409CB74F4000000000093F64C0000000A04CB84F4000000040E93E64C0000000407DB84F40000000C0CA3E64C0000000A0CBB84F4000000080C33E64C000000060EAB84F40000000A0F03E64C0000000803EB94F4000000080D13E64C0000000007EB94F4000000060993E64C000000080C0B94F4000000020793E64C000000020E2B94F40000000604F3E64C000000020E7B94F4000000000063E64C0000000C03CB94F40000000A0E93D64C000000080E6B84F4000000000AD3D64C000000000B2B84F4000000000943D64C000000000B5B84F40000000C0603D64C0000000209DB84F40000000C01F3D64C0000000C0D1B84F40000000C0CF3C64C0000000C034B94F4000000000C93C64C00000004062B94F4000000040CB3C64C0000000E09DB94F40000000E0D53C64C000000040D8B94F4000000060C73C64C0000000C015BA4F40000000C0AD3C64C0000000E009BA4F4000000000933C64C000000020E0B94F40000000A07F3C64C0000000C097B94F40000000C05E3C64C0000000A0AAB94F40000000002E3C64C000000040CEB94F40000000E0133C64C000000080B3B94F4000000020113C64C00000002069B94F4000000040FF3B64C0000000604DB94F40000000E0C43B64C00000002054B94F4000000080A23B64C0000000603AB94F40000000C0553B64C0000000A016B94F40000000C0193B64C0000000C0F0B84F4000000080F93A64C00000006012B94F40000000E0D03A64C00000000035B94F4000000080A53A64C0000000400DB94F40000000A0923A64C0000000C0D3B84F40000000E0803A64C000000000B8B84F40000000604E3A64C0000000E0AEB84F40000000803C3A64C00000002093B84F40000000A0293A64C00000008059B84F40000000C0203A64C0000000A04BB84F40000000C0F83964C0000000207DB84F4000000020DB3964C000000000E9B84F40000000A0A43964C0000000E057B94F40000000C08D3964C00000006096B94F4000000000643964C0000000209BB94F4000000040393964C00000004082B94F40000000A0063964C00000002079B94F4000000060E73864C000000060B8B94F40000000A0D13864C00000008014BA4F4000000040B13864C00000002036BA4F4000000040673864C0000000605CBA4F40000000E0133864C00000000066BA4F40000000A0F43764C000000040A5BA4F4000000040D43764C0000000E0C6BA4F4000000060A83764C00000002090BA4F40000000C0753764C0000000E086BA4F40000000E05D3764C000000080A7BA4F4000000040373764C00000006005BB4F40000000C0103764C00000006063BB4F4000000020E83664C0000000E085BB4F4000000060A63664C000000020ABBB4F40000000606A3664C00000002085BB4F40000000A0363664C0000000205EBB4F4000000020063664C00000006090BB4F4000000020BD3564C000000060D4BB4F40000000808A3564C000000020CBBB4F40000000606F3564C00000006092BB4F4000000000653564C0000000E057BB4F4000000060343564C0000000208ABB4F4000000000133564C0000000E08DBB4F40000000A0E63464C00000002048BB4F4000000000CD3464C0000000003CBB4F4000000080B43464C0000000A04DBB4F40000000C08A3464C00000006052BB4F40000000A0573464C0000000203ABB4F40000000201A3464C000000060E7BA4F4000000020F73364C000000080BEBA4F4000000060CD3364C000000020C3BA4F40000000C0A43364C000000060E5BA4F40000000C0813364C000000080BCBA4F40000000A0653364C00000002066BA4F40000000C0443364C0000000A078BA4F40000000801B3364C0000000208CBA4F4000000020F93264C00000000072BA4F40000000E0E63264C00000002047BA4F4000000020D23264C000000020D2B94F40000000C0C73264C00000008097B94F40000000009E3264C0000000209CB94F40000000806C3264C000000060B0B94F40000000C0443264C000000080F0B94F4000000020343264C000000060F2B94F40000000E0E63164C000000000BFB94F4000000020C63164C000000080D1B94F4000000080963164C00000006021BA4F40000000E06D3164C0000000A043BA4F40000000E0323164C0000000203BBA4F40000000E0003164C00000008040BA4F4000000040D13064C00000004090BA4F40000000E0B13064C000000060CFBA4F4000000040A33064C0000000A00CBB4F40000000E0A93064C000000000CEBB4F40000000808C3064C0000000A048BC4F40000000A06B3064C0000000205BBC4F40000000404B3064C0000000607CBC4F40000000C0103064C0000000C082BC4F4000000080E42F64C0000000E03CBC4F4000000060C92F64C00000000004BC4F40000000209E2F64C0000000E0DBBB4F4000000060762F64C0000000E01BBC4F40000000C0672F64C00000002059BC4F40000000A0502F64C00000004097BC4F40000000E0272F64C000000080B9BC4F40000000C0172F64C000000020CABC4F4000000080042F64C0000000A081BC4F40000000C0122F64C00000008035BC4F40000000E0202F64C000000040E9BB4F40000000C00E2F64C000000080BEBB4F4000000060042F64C0000000C083BB4F40000000400A2F64C00000008038BB4F4000000080DD2E64C0000000C0E3BA4F40000000C0CB2E64C0000000C0C7BA4F40000000E0A92E64C000000080BCBA4F4000000080882E64C000000000C0BA4F40000000603D2E64C000000000C8BA4F40000000001B2E64C0000000C0ADBA4F4000000000E32D64C000000060FEBA4F40000000C0BA2D64C0000000802FBB4F4000000000932D64C0000000606FBB4F4000000040502D64C00000006076BB4F4000000060292D64C000000000D4BB4F40000000800A2D64C0000000E021BC4F40000000A0E92C64C00000004034BC4F4000000000982C64C00000008078BC4F40000000A0552C64C0000000608EBC4F40000000000A2C64C00000006087BC4F4000000040A62B64C0000000A0A0BC4F40000000406D2B64C000000040D3BC4F4000000040332B64C000000020E8BC4F40000000E0122B64C00000006009BD4F40000000E0DE2A64C000000000D3BC4F4000000040AB2A64C000000080ABBC4F4000000060682A64C000000060B2BC4F40000000002D2A64C0000000A09ABC4F4000000020EA2964C000000080A1BC4F40000000E0A72964C000000040B7BC4F40000000A03C2964C0000000E0EEBC4F4000000020CA2864C00000002045BD4F40000000E05F2864C0000000809ABD4F4000000060FF2764C0000000A01BBE4F4000000080B72764C0000000408BBE4F4000000040862764C000000020AEBE4F40000000404C2764C0000000E0C2BE4F40000000A0192764C000000000B9BE4F4000000020F92664C000000000DABE4F4000000040D02664C000000000FCBE4F4000000040B02664C0000000E02BBF4F40000000E06C2664C0000000E023BF4F4000000020232664C0000000E057BF4F40000000C0D82564C0000000207DBF4F4000000000C22564C000000000CABF4F40000000408A2564C00000000029C04F4000000000732564C00000000067C04F40000000C05B2564C000000000A5C04F40000000603A2564C000000040A8C04F40000000A0082564C000000020BCC04F4000000020E72464C000000060BFC04F4000000000D62464C000000020B2C04F40000000E0C32464C00000002087C04F40000000009B2464C000000000A9C04F40000000E0732464C00000004006C14F4000000000652464C00000006043C14F40000000C0672464C0000000A09CC14F4000000000722464C000000060D7C14F40000000A0622464C0000000A005C24F4000000060652464C0000000005FC24F4000000000702464C000000080A8C24F40000000E0502464C000000040F6C24F40000000E0412464C00000004033C34F40000000C0572464C000000060D5C34F4000000000402464C00000008004C44F40000000200F2464C00000000036C44F4000000040ED2364C0000000402AC44F4000000080B32364C0000000C04DC44F40000000E09A2364C0000000005FC44F40000000608C2364C000000020ABC44F4000000060642364C0000000A0EAC44F4000000020442364C0000000801AC54F40000000604E2364C00000004055C54F40000000C0712364C0000000808DC54F40000000807B2364C000000040B9C54F40000000606D2364C00000004014C64F40000000406F2364C0000000C04FC64F40000000009A2364C00000008069C64F40000000A0BB2364C00000004066C64F4000000060C42364C00000004074C64F4000000040C62364C0000000C0AFC64F4000000080A72364C0000000600CC74F40000000E0862364C0000000402DC74F40000000C0652364C0000000603FC74F4000000080552364C0000000E04FC74F4000000080422364C00000002007C74F4000000080272364C000000020CEC64F4000000020FE2264C0000000E0E0C64F40000000C0ED2264C000000060F1C64F40000000A0E72264C0000000A03CC74F4000000060F12264C00000008068C74F40000000000B2364C00000000075C74F40000000C00C2364C000000060B0C74F4000000060FD2264C0000000C0DEC74F4000000040BB2264C0000000E002C84F4000000040922264C0000000C024C84F4000000020722264C0000000A054C84F4000000020492264C00000006076C84F4000000040412264C00000002086C84F4000000080192264C000000080D4C84F4000000040EB2164C0000000405FC94F4000000020BC2164C000000020CCC94F40000000A0842164C0000000E039CA4F40000000E05D2164C000000000A6CA4F40000000A0572164C000000040F1CA4F40000000803B2164C000000000A7CB4F4000000080372164C0000000A03CCC4F4000000080292164C00000008097CC4F40000000601B2164C000000060F2CC4F4000000080F42064C0000000805ECD4F4000000080E62064C000000040B9CD4F4000000060FA2064C0000000E01FCE4F4000000000FD2064C00000002079CE4F40000000A0E52064C000000020B7CE4F4000000040C62064C0000000C004CF4F4000000020C72064C00000006022CF4F4000000020C02064C0000000E04FCF4F4000000080CC2064C000000000D5CF4F4000000040CE2064C00000008010D04F40000000E0B62064C0000000804ED04F40000000E0942064C0000000C042D04F40000000A0612064C0000000A029D04F40000000403E2064C000000040F1CF4F40000000202B2064C000000060A8CF4F4000000020092064C0000000C09CCF4F40000000C0BB1F64C00000004068CF4F40000000A0A21F64C0000000A06ACF4F40000000E0571F64C0000000608FCF4F4000000080071F64C0000000400ED04F4000000080881E64C0000000C017D14F40000000C0121E64C0000000203ED24F4000000000B41D64C0000000C017D34F40000000207D1D64C000000000A3D34F40000000402E1D64C0000000405DD44F40000000A0FF1C64C0000000C0E7D44F40000000C0CF1C64C0000000C045D54F4000000000BA1C64C000000000BFD54F40000000A0751C64C000000000C3D64F40000000C0401C64C0000000C098D74F4000000060231C64C0000000A030D84F4000000080FD1B64C000000040C9D84F4000000060E61B64C0000000E015D94F4000000040AF1B64C000000020A1D94F4000000060671B64C0000000E02DDA4F4000000060071B64C000000080E9DA4F4000000080C91A64C000000020B1DB4F4000000060841A64C0000000E0A5DC4F40000000A0251A64C0000000208EDD4F40000000C0EE1964C00000004028DE4F4000000080AA1964C0000000003BDF4F40000000C0441964C0000000805FE04F40000000E00E1964C00000004017E14F4000000020C91864C000000020FDE14F4000000060BA1864C00000000049E24F40000000009C1864C000000020C3E24F40000000E0961864C0000000E03AE34F4000000020921864C0000000A0C1E34F40000000C0831864C0000000601CE44F40000000208F1864C0000000E083E44F40000000E0941864C00000004054E54F40000000C0921864C00000006034E64F40000000809A1864C0000000404FE74F4000000080AA1864C0000000605AE84F4000000040B31864C00000002093E94F40000000A0B81864C0000000C054EA4F40000000C0C51864C0000000C0F7EA4F4000000000BB1864C000000080D8EB4F40000000A0B71864C0000000008CEC4F40000000E0C01864C000000000A9EC4F4000000020D51864C0000000A01EED4F4000000080E91864C00000004094ED4F4000000060F41864C0000000E0ECED4F4000000020091964C00000006071EE4F4000000040261964C000000020F5EE4F40000000E0301964C0000000E03EEF4F4000000060331964C00000004098EF4F40000000A0711964C000000040FBEF4F40000000608E1964C00000002070F04F4000000000991964C0000000E0B9F04F4000000000B71964C0000000605BF14F4000000080CD1964C0000000601BF24F4000000000EC1964C0000000E0CBF24F40000000E00A1A64C0000000208BF34F40000000802B1A64C00000002086F44F40000000205A1A64C00000004017F54F4000000040711A64C000000020E6F54F4000000000A21A64C0000000C0C1F64F4000000080E51A64C000000060D7F74F4000000080041B64C0000000C096F84F40000000803D1B64C0000000A062F94F4000000000651B64C00000004021FA4F4000000020A91B64C0000000C045FB4F4000000040ED1B64C0000000406AFC4F40000000A02F1C64C00000002053FD4F4000000040431C64C0000000E0AAFD4F40000000E0831C64C00000006058FE4F4000000000A01C64C000000060AFFE4F4000000000B51C64C0000000E033FF4F4000000040ED1C64C000000000E2FF4F40000000C0121D64C0000000002B005040000000800F1D64C0000000C08400504000000080E71C64C000000060B3005040000000C0E91C64C0000000A0D800504000000080EB1C64C000000060F600504000000000001D64C0000000203101504000000000031D64C00000004065015040000000A01F1D64C00000004098015040000000402B1D64C000000000CC015040000000C03F1D64C0000000C00602504000000080531D64C0000000A032025040000000405D1D64C0000000A048025040000000E0701D64C00000008074025040000000C0831D64C0000000809102504000000000971D64C000000000B6025040000000A0A11D64C0000000C0DA02504000000000AC1D64C000000040F8025040000000C0BE1D64C00000004015035040000000A0C81D64C0000000202B03504000000040DC1D64C0000000205703504000000080F01D64C0000000608A03504000000000061E64C000000020D403504000000020111E64C00000006000045040000000801E1E64C0000000E05104504000000060231E64C0000000C0A3045040000000202E1E64C0000000A0C804504000000060301E64C0000000E0ED045040000000003C1E64C0000000A02105504000000020471E64C0000000E04D05504000000060491E64C00000002073055040000000205D1E64C0000000009F055040000000405F1E64C000000040C405504000000020691E64C000000020DA05504000000000621E64C0000000E0F005504000000040631E64C00000004007065040000000005D1E64C0000000E02C065040000000A04D1E64C0000000604B06504000000020401E64C0000000C08706504000000040321E64C0000000A0BC065040000000C02C1E64C000000020F106504000000040301E64C0000000A02C075040000000602A1E64C0000000C05907504000000000361E64C0000000808D07504000000020301E64C000000080BA075040000000603B1E64C0000000E0E6075040000000003E1E64C0000000801308504000000040491E64C0000000C03F08504000000000541E64C0000000A064085040000000A0681E64C0000000609F085040000000607C1E64C000000040CB085040000000E07C1E64C0000000C0D208504000000000881E64C000000000FF085040000000E0921E64C0000000E023095040000000208C1E64C00000000042095040000000208F1E64C00000002076095040000000208B1E64C000000000C109504000000000861E64C000000000FD09504000000080811E64C000000060400A5040000000C0871E64C0000000A0A80A5040000000207B1E64C0000000E0F30A5040000000A07E1E64C0000000602F0B504000000020831E64C0000000E0790B504000000040811E64C000000000EA0B504000000040851E64C0000000002D0C5040000000C07F1E64C000000080610C5040000000806E1E64C000000020F00C504000000060701E64C0000000E00D0D5040000000006A1E64C000000080330D5040000000808A1E64C000000000A20D504000000060A11E64C000000020020E504000000040BE1E64C000000000350E504000000000DC1E64C000000000770E5040000000E0E61E64C0000000E09B0E504000000060021F64C000000080B80E5040000000C0271F64C000000000EB0E504000000040311F64C000000080F90E5040000000A03B1F64C0000000E0160F5040000000004F1F64C0000000603B0F504000000000591F64C000000060510F504000000060631F64C0000000C06E0F504000000040761F64C0000000C08B0F5040000000609A1F64C000000000A80F5040000000E0B51F64C000000080C40F504000000060D21F64C000000020F00F504000000060F71F64C0000000201B10504000000020242064C0000000003710504000000060592064C0000000605210504000000080912064C0000000809A105040000000A0C82064C0000000C0D3105040000000E0112164C0000000001B11504000000060532164C0000000A071115040000000C0A52164C0000000E0BF11504000000080022264C0000000A02B12504000000060562264C0000000409012504000000040B22264C000000020ED125040000000E00D2364C00000006042135040000000C0312364C00000002057135040000000C04E2364C0000000008A13504000000020A22364C000000040E7135040000000A0E22364C0000000602714504000000080362464C0000000008C14504000000020932464C000000020F0145040000000A0D42464C0000000203F155040000000801F2564C0000000A09C15504000000060852564C0000000E00716504000000040EA2564C0000000206416504000000060332664C0000000E0A3165040000000A07D2664C000000060F2165040000000C0C72664C0000000004117504000000040F52664C0000000206417504000000000112764C0000000A080175040000000C02C2764C0000000409D17504000000000482764C000000060B2175040000000C05B2764C0000000C0D6175040000000E06F2764C00000008002185040000000208C2764C0000000802618504000000020972764C0000000604B18504000000040992764C0000000206918504000000080882764C00000006071185040000000E0802764C0000000C080185040000000806F2764C00000008081185040000000405E2764C0000000608218504000000020552764C0000000607B185040000000004C2764C00000006074185040000000C0302764C0000000405F18504000000020272764C0000000C05018504000000060142764C0000000403B185040000000600A2764C00000006025185040000000C0F62664C0000000E00018504000000020E42664C000000060EB175040000000E0D12664C000000060DD175040000000C0C82664C000000060D617504000000000B72664C0000000C0CF17504000000060AE2664C000000020D017504000000060822664C000000060C3175040000000C0782664C0000000E0B4175040000000E0772664C000000000A6175040000000406E2664C0000000809717504000000000762664C00000004088175040000000606C2664C0000000C079175040000000E06A2664C00000006063175040000000E0602664C0000000604D175040000000404E2664C0000000E037175040000000003C2664C0000000E029175040000000402B2664C00000002032175040000000801B2664C00000004049175040000000E01C2664C0000000A05F175040000000200D2664C0000000C076175040000000E0FC2564C00000008086175040000000A0EC2564C0000000409617504000000080ED2564C000000020A517504000000040002664C0000000A0BA17504000000040092664C0000000A0C117504000000060132664C0000000A0D7175040000000E0132664C000000000DF17504000000020032664C000000060E717504000000060F22564C0000000A0EF175040000000C0E92564C000000000F017504000000080D82564C0000000E0F017504000000080B52564C000000000EB17504000000080AC2564C000000000E417504000000020922564C0000000C0DD17504000000040792564C0000000E0ED175040000000E05F2564C0000000A0F6175040000000204F2564C0000000E0FE175040000000E0472564C0000000A01518504000000040632564C0000000C02A185040000000406C2564C0000000C031185040000000E0752564C00000004040185040000000007F2564C00000004047185040000000E0A12564C0000000204D18504000000060C42564C0000000804B18504000000000F02564C0000000E050185040000000C0092664C0000000A04F185040000000A0242664C0000000405D185040000000202E2664C0000000C06B185040000000A02E2664C00000002073185040000000A02F2664C0000000008218504000000000282664C00000006091185040000000C0202664C000000020A818504000000020192664C000000060B7185040000000801A2664C0000000C0CD185040000000C02C2664C0000000E0DB185040000000003E2664C000000000DB185040000000C04F2664C0000000A0E118504000000020692664C0000000E0D8185040000000A08B2664C000000040D7185040000000E0A42664C0000000A0CE185040000000C0B52664C000000040C618504000000060E92664C0000000C0C3185040000000E0032764C000000000CA18504000000020152764C000000020C918504000000040412764C000000000D6185040000000E0522764C000000080DC185040000000A0642764C000000020E3185040000000C06D2764C000000040EA185040000000C06F2764C0000000000819504000000000682764C0000000401719504000000020702764C0000000800F195040000000C0792764C0000000E01D19504000000060822764C0000000801D195040000000E0A42764C0000000E01B195040000000A0B52764C0000000801319504000000040BE2764C0000000201319504000000080CF2764C00000004012195040000000C0DF2764C0000000800219504000000080F02764C000000040FA18504000000020F82764C000000000EB185040000000A0F72764C000000080E3185040000000C0FF2764C0000000A0DB18504000000060082864C000000040DB185040000000A0192864C000000060DA185040000000602B2864C000000000E1185040000000A03D2864C000000000EF18504000000040512864C00000006013195040000000E05B2864C0000000C030195040000000E0662864C0000000A055195040000000207A2864C00000008072195040000000207C2864C0000000409019504000000000742864C00000002098195040000000C06B2864C000000000A0195040000000005B2864C000000060A8195040000000404A2864C0000000A0B019504000000020412864C0000000A0A9195040000000A01E2864C000000040AB195040000000C0052864C000000060BB195040000000E0ED2764C000000080DA19504000000000D42764C0000000C0DB19504000000040C32764C000000000E4195040000000A0BA2764C000000080E4195040000000C0A02764C0000000C0E519504000000060882764C000000040FD19504000000080772764C0000000A0051A5040000000205F2764C0000000201D1A5040000000A0472764C0000000A0431A504000000020482764C0000000204B1A504000000080402764C0000000605A1A5040000000C0302764C0000000C0711A504000000000282764C000000020721A5040000000001F2764C0000000206B1A5040000000C00D2764C0000000006C1A504000000060F32664C0000000C0651A5040000000A0992664C0000000C0351A504000000000882664C0000000402F1A5040000000C0532664C0000000402A1A504000000000422664C0000000A0231A5040000000C0302664C000000060241A504000000080292664C0000000203B1A504000000020322664C0000000C03A1A5040000000C03C2664C000000020581A504000000000582664C0000000406D1A504000000060692664C0000000606C1A504000000060742664C000000040911A5040000000406C2664C000000020991A504000000000652664C0000000E0AF1A5040000000405E2664C000000020CE1A5040000000806F2664C000000040CD1A504000000020922664C000000080CB1A5040000000A0B42664C0000000E0C91A504000000000CE2664C000000020C11A504000000020F82664C000000040B01A5040000000201B2764C000000000B61A5040000000C0462764C000000060BB1A504000000040692764C0000000C0B91A5040000000C0832764C0000000E0BF1A5040000000A09C2764C0000000C0AF1A504000000060AB2764C000000080891A504000000060C32764C0000000806A1A5040000000A0C92764C0000000E0441A504000000040DB2764C0000000804B1A504000000080ED2764C000000080591A504000000000F02764C0000000C07E1A5040000000E0F02764C0000000A08D1A504000000060F22764C000000000A41A504000000020052864C0000000A0B91A5040000000C00D2864C000000020B91A504000000060162864C0000000A0B81A5040000000801F2864C0000000C0BF1A5040000000402F2864C000000060A81A504000000080402864C0000000A0A71A504000000000592864C000000000901A5040000000E0722864C0000000C08E1A5040000000E0952864C000000080941A504000000000C22864C000000040A11A504000000040DC2864C000000080A71A504000000080072964C000000060A51A5040000000E0212964C000000080AB1A5040000000C05D2964C000000020A11A5040000000C07F2964C0000000E0971A5040000000E0AA2964C0000000C0951A504000000020BC2964C000000000951A504000000080D52964C0000000408C1A504000000080F82964C000000000921A5040000000E0122A64C000000020981A504000000060342A64C000000080871A5040000000003D2A64C000000020871A504000000020442A64C000000060701A5040000000C0412A64C0000000204B1A5040000000802D2A64C0000000401F1A5040000000002C2A64C000000000091A5040000000E0222A64C0000000E0011A5040000000002A2A64C000000020EB19504000000020322A64C000000040E3195040000000A0312A64C0000000E0DB19504000000020312A64C000000060D4195040000000C0392A64C000000000D4195040000000E0422A64C000000000DB19504000000020542A64C000000020DA195040000000C05C2A64C0000000A0D9195040000000806E2A64C000000040E019504000000000F62B64C000000000801A5040000000001B2C64C000000080A31A5040000000C02C2C64C000000000AA1A504000000060352C64C0000000A0A91A5040000000005A2C64C0000000A0C51A5040000000605A2C64C000000020CD1A5040000000805B2C64C000000000DC1A5040000000805D2C64C0000000C0F91A5040000000005F2C64C000000020101B504000000020692C64C000000000261B5040000000C0712C64C0000000A0251B5040000000208D2C64C0000000A03A1B5040000000E09E2C64C000000020411B5040000000E0B82C64C0000000E03F1B5040000000A0C92C64C000000080371B5040000000E0FC2C64C0000000802D1B5040000000E01E2D64C000000040241B5040000000004A2D64C000000000221B504000000020982D64C000000080251B5040000000A0D42D64C000000080221B5040000000E02A2E64C0000000001E1B5040000000E06F2E64C0000000801A1B5040000000809A2E64C0000000E0101B5040000000E0CD2E64C0000000C0061B5040000000C0E72E64C000000060051B5040000000E0102F64C000000060E51A504000000080422F64C000000000C51A5040000000C0732F64C0000000009D1A504000000080AC2F64C0000000C0651A504000000060EE2F64C000000080351A504000000080FD2F64C0000000E0161A5040000000A02E3064C0000000E0EE195040000000E0453064C000000040C8195040000000804C3064C000000000AA195040000000E04A3064C0000000C09319504000000000683064C0000000804719504000000080673064C0000000004019504000000020763064C0000000E019195040000000008E3064C0000000C0FA185040000000A09D3064C000000080E318504000000020A53064C000000020D4185040000000C0AC3064C0000000E0C418504000000000CB3064C00000008087185040000000C0DB3064C0000000207F185040000000A0F53064C0000000C07D185040000000A0F63064C0000000A08C18504000000060093164C000000020A218504000000080043164C0000000A0D618504000000020DF3064C0000000C02A19504000000020D83064C0000000A04119504000000000D13064C00000006058195040000000E0B23064C0000000C09519504000000060AD3064C0000000E0C219504000000000B03064C000000000E819504000000040BC3064C0000000C01B1A504000000000C73064C000000000391A504000000000E43064C000000060641A504000000080F93064C0000000209F1A504000000020FC3064C000000060C41A504000000060073164C000000020E91A504000000040003164C0000000E0FF1A5040000000A0F13064C000000000261B504000000080E93064C0000000002E1B504000000000C13064C000000060551B5040000000A0A73064C0000000405E1B504000000060733064C000000080591B504000000020483064C0000000C05B1B5040000000C00C3064C0000000C06D1B504000000020FD2F64C000000000851B504000000080EF2F64C000000000BA1B504000000080F02F64C0000000E0C81B504000000040DF2F64C0000000C0C91B5040000000C0BE2F64C000000060E91B504000000040962F64C0000000E0101C5040000000A08E2F64C000000040201C5040000000607E2F64C000000000301C5040000000E0772F64C0000000404E1C504000000080602F64C0000000C0741C5040000000805A2F64C0000000609A1C5040000000A0422F64C000000080B91C504000000000342F64C0000000A0DF1C5040000000C0232F64C000000080EF1C5040000000C0242F64C000000060FE1C504000000060262F64C0000000A0141D504000000060282F64C000000080321D5040000000E03D2F64C0000000206D1D504000000080422F64C000000020B01D504000000040542F64C0000000C0B61D5040000000C04F2F64C0000000C0F21D5040000000E0512F64C000000080101E5040000000C04B2F64C000000020361E5040000000203C2F64C0000000604D1E504000000080352F64C0000000A06B1E504000000000372F64C000000000821E504000000020382F64C0000000E0901E5040000000604A2F64C0000000E09E1E5040000000405E2F64C000000020C31E504000000060672F64C000000040CA1E504000000080692F64C000000000E81E504000000000632F64C000000040061F504000000080642F64C0000000801C1F5040000000E05C2F64C0000000E02B1F5040000000A04D2F64C0000000804A1F504000000020462F64C0000000E0591F5040000000603D2F64C0000000605A1F5040000000202D2F64C0000000206A1F5040000000C0142F64C0000000C0811F504000000000042F64C0000000208A1F5040000000A0EC2E64C0000000A0B01F504000000020ED2E64C000000020B81F504000000020EE2E64C000000000C71F504000000060F72E64C000000000CE1F5040000000E0F82E64C000000060E41F5040000000E0F92E64C000000040F31F504000000020052F64C00000000018205040000000A0FF2E64C0000000204520504000000020002F64C0000000A04C205040000000C0012F64C00000000063205040000000A0FA2E64C0000000C07920504000000000F32E64C0000000208920504000000080D92E64C0000000E09120504000000040C92E64C0000000A0A120504000000060B82E64C000000000AA205040000000A0A72E64C000000060B220504000000020862E64C000000020C3205040000000605B2E64C0000000C0CC205040000000C0392E64C000000060DD205040000000C0202E64C0000000A0ED20504000000000102E64C000000000F6205040000000C0FF2D64C0000000C00521504000000060EE2D64C0000000A00621504000000040E62D64C0000000800E21504000000020DE2D64C0000000601621504000000060CE2D64C0000000A02D21504000000000BF2D64C0000000404C21504000000020C02D64C0000000205B215040000000C0AF2D64C0000000006B21504000000020A72D64C0000000606B215040000000009F2D64C00000004073215040000000E0962D64C0000000207B21504000000000862D64C00000008083215040000000E07D2D64C0000000608B215040000000A06C2D64C0000000408C215040000000C05B2D64C0000000A094215040000000C0422D64C0000000C0A421504000000080312D64C0000000A0A521504000000080182D64C0000000E0B5215040000000C0082D64C000000020CD21504000000060F82C64C0000000E0DC21504000000000E02C64C000000080F421504000000060D82C64C0000000E00322504000000000C82C64C0000000A01322504000000060BF2C64C0000000001422504000000000AF2C64C0000000E02322504000000020962C64C00000000034225040000000608D2C64C0000000803422504000000060742C64C0000000A04422504000000020492C64C0000000E04622504000000080272C64C00000008057225040000000A0162C64C0000000C05F22504000000060042C64C0000000C05122504000000080F22B64C0000000404B225040000000E0E82B64C0000000C03C225040000000E0CC2B64C00000004020225040000000A0A72B64C0000000C0FC215040000000809E2B64C0000000C0F5215040000000809D2B64C0000000E0E6215040000000C0782B64C0000000C0CA21504000000000662B64C000000060B521504000000060412B64C0000000409921504000000000F92A64C00000000070215040000000E0952A64C00000004039215040000000E0102A64C0000000E012215040000000E0832964C000000080F420504000000080342964C000000000E220504000000000C32864C0000000A0D820504000000000A92864C0000000E0D920504000000060A02864C000000060DA205040000000A08E2864C0000000C0D3205040000000C07C2864C000000020CD205040000000C07B2864C000000040BE205040000000A0712864C000000060A820504000000000672864C0000000008B205040000000203A2864C0000000C076205040000000A0162864C0000000806920504000000000B42764C0000000003A20504000000040532764C0000000402820504000000020F22664C0000000200F20504000000040802664C000000020FE1F5040000000803A2664C000000000FA1F504000000040F42564C000000080EE1F5040000000409D2564C000000020EB1F5040000000801B2564C000000040F11F5040000000A0B22464C000000060E71F504000000080532464C0000000E0EB1F5040000000A0052464C000000080EF1F504000000040B72364C0000000A0EB1F504000000000682364C000000000D91F5040000000E02A2364C000000060D41F504000000020E62264C000000000DF1F504000000040982264C0000000A0E21F504000000000532264C0000000E0E51F504000000000162264C000000040E11F504000000060DA2164C0000000E0F21F5040000000C0B72164C000000080F41F5040000000A0952164C0000000A0FD1F504000000060732164C0000000A00620504000000080592164C0000000C007205040000000E0362164C00000006009205040000000A0FB2064C0000000802220504000000020C92064C0000000403B20504000000080B02064C0000000C05220504000000000972064C0000000605B20504000000020862064C0000000A063205040000000E07D2064C0000000806B205040000000806D2064C0000000207B205040000000E06E2064C0000000809120504000000040702064C0000000E0A720504000000060602064C000000020BF20504000000040612064C000000000CE205040000000E0502064C0000000A0DD205040000000A0482064C000000080E520504000000060402064C000000060ED20504000000040382064C000000040F520504000000000272064C000000000F620504000000020162064C000000040FE205040000000A0062064C0000000C01C21504000000000072064C0000000402421504000000020102064C0000000602B215040000000C0182064C0000000E02A215040000000002B2064C00000000039215040000000603C2064C0000000403821504000000080452064C0000000403F215040000000204F2064C0000000C04D21504000000020582064C0000000E054215040000000E06A2064C0000000606A215040000000606B2064C0000000E071215040000000406C2064C0000000C080215040000000007E2064C0000000808721504000000020AB2064C000000040A3215040000000A0C52064C000000080A921504000000020E02064C0000000C0AF215040000000A0032164C000000020BD215040000000C0312164C0000000C0E721504000000020432164C000000000E7215040000000E0542164C0000000A0ED215040000000A0662164C000000060F421504000000060782164C000000000FB21504000000060922164C0000000C0F9215040000000C0A32164C000000000F921504000000020B52164C000000020F821504000000040BD2164C000000060F021504000000000C52164C000000000E121504000000040CD2164C000000020D9215040000000A0C32164C0000000A0CA21504000000060CB2164C000000060BB215040000000E0C02164C0000000009E21504000000020D22164C0000000409D215040000000E0DA2164C0000000C09C21504000000020ED2164C0000000E0AA21504000000020112264C0000000A0BF215040000000002C2264C000000060CD215040000000A0502264C000000080E9215040000000C0632264C0000000800622504000000080762264C0000000201C225040000000208A2264C00000008040225040000000C0932264C0000000004F22504000000040B82264C0000000406B225040000000E0C12264C0000000C07922504000000080CB2264C0000000408822504000000080D52264C0000000209E22504000000020DF2264C0000000A0AC22504000000080D72264C000000000BC22504000000060D82264C0000000E0CA22504000000080C72264C000000020D3225040000000E0BE2264C000000080D322504000000000AE2264C0000000C0DB225040000000C0A52264C0000000A0E322504000000060942264C000000060E4225040000000408C2264C000000040EC225040000000A0692264C0000000E0ED225040000000C0572264C000000040E722504000000060462264C000000000E822504000000080352264C000000040F0225040000000C0862164C0000000E0E1225040000000E0CF2064C000000060DB22504000000080892064C0000000A0CF22504000000060672064C0000000A0D8225040000000A0442064C000000040DA22504000000060332064C000000000DB22504000000060192064C000000020DC225040000000C0FF1F64C0000000C0E4225040000000C0CB1F64C000000020E722504000000040541F64C0000000600A23504000000040201F64C0000000C00C23504000000060861E64C00000000039235040000000606C1E64C0000000203A23504000000020641E64C0000000004223504000000060421E64C00000006052235040000000203A1E64C0000000405A23504000000000211E64C0000000606A23504000000080071E64C00000000073235040000000E0FE1D64C0000000607323504000000080ED1D64C00000002074235040000000C0E41D64C0000000807423504000000020DC1D64C0000000E07423504000000000D31D64C0000000C06D23504000000080D31D64C00000004075235040000000C0CA1D64C0000000A07523504000000060B91D64C00000006076235040000000C0B01D64C0000000C076235040000000A0B11D64C0000000A08523504000000060A91D64C0000000808D23504000000020A21D64C000000040A423504000000080921D64C0000000E0C223504000000020821D64C000000080D223504000000020711D64C0000000C0DA235040000000E05F1D64C000000080DB235040000000A0571D64C000000060E3235040000000C0501D64C0000000800124504000000040511D64C00000000009245040000000A0511D64C0000000601024504000000080621D64C00000002008245040000000A06B1D64C0000000400F24504000000060881D64C0000000C03A245040000000C0891D64C0000000205124504000000080811D64C00000000059245040000000007B1D64C0000000A07E24504000000040731D64C0000000E08D245040000000C0731D64C0000000609524504000000080441D64C0000000A0E9245040000000E02B1D64C0000000200125504000000020131D64C0000000A01825504000000020031D64C0000000C02F255040000000A0F21C64C0000000603F25504000000060EA1C64C00000004047255040000000E0DA1C64C0000000C06525504000000000B91C64C00000004076255040000000E08E1C64C0000000808E255040000000807D1C64C0000000408F25504000000040751C64C0000000209725504000000000641C64C0000000E097255040000000203C1C64C000000060D5255040000000E0291C64C000000020C725504000000060191C64C0000000E0D625504000000020F61B64C0000000E0D025504000000080ED1B64C000000040D125504000000060D31B64C000000060D2255040000000C0CA1B64C0000000C0D225504000000000C21B64C000000020D3255040000000E08E1B64C000000060E4255040000000A0751B64C000000060F4255040000000803B1B64C0000000C023265040000000809C1A64C00000002093265040000000A0381A64C000000020E226504000000020D51964C0000000803827504000000020821964C0000000607F27504000000000721964C00000006096275040000000E0721964C000000060A527504000000040631964C0000000E0C3275040000000C05C1964C000000080E9275040000000204D1964C00000000008285040000000A03E1964C0000000E03C28504000000040411964C0000000A069285040000000A0411964C00000002071285040000000C0331964C000000060AD285040000000202A1964C00000004034295040000000203A1964C0000000A0B2295040000000E0591964C000000060122A5040000000805C1964C0000000203F2A5040000000C0601964C0000000A0892A5040000000E0511964C000000020B72A504000000080431964C000000000EC2A5040000000E0331964C0000000800A2B5040000000602C1964C000000040212B5040000000E0251964C0000000E0462B5040000000E01E1964C000000000652B5040000000A0201964C0000000E0822B504000000040191964C0000000A0992B5040000000400C1964C0000000E0E42B504000000080061964C000000060192C5040000000C0111964C0000000C0452C5040000000E00D1964C000000000982C504000000020191964C000000060C42C5040000000C01B1964C000000020F12C504000000000201964C0000000C03B2D5040000000601A1964C000000040702D5040000000801C1964C000000080952D5040000000A0141964C0000000E0A42D5040000000E0151964C000000020BB2D504000000040171964C000000080D12D5040000000A0171964C000000000D92D504000000040211964C000000080E72D504000000040351964C000000080132E5040000000E03E1964C000000000222E5040000000E0481964C000000000382E5040000000805C1964C0000000805C2E504000000060671964C000000080812E5040000000808C1964C000000040A52E504000000060961964C000000040BB2E504000000080E11964C0000000C0112F504000000040F41964C000000040272F5040000000C0231A64C000000080682F504000000000371A64C0000000A0852F5040000000E0411A64C000000080AA2F5040000000605D1A64C0000000C0BF2F504000000060681A64C0000000A0E42F5040000000A07A1A64C0000000C0F22F5040000000A07B1A64C0000000A00130504000000020851A64C0000000401030504000000000A21A64C0000000C03B30504000000040B51A64C0000000E05830504000000020B61A64C0000000C067305040000000E0C81A64C0000000607D305040000000C0C91A64C0000000408C30504000000040D41A64C0000000C0A930504000000060E81A64C0000000A0D530504000000000E11A64C000000060EC305040000000A0E31A64C0000000201931504000000060E51A64C0000000003731504000000020F81A64C0000000804C315040000000A0021B64C0000000006A315040000000400C1B64C00000008078315040000000A01E1B64C0000000A08631504000000000311B64C0000000E094315040000000E0541B64C000000040A2315040000000C0701B64C0000000E0BE31504000000020831B64C000000020CD315040000000E08C1B64C0000000A0DB31504000000020AA1B64C0000000A00E325040000000C0B31B64C0000000201D325040000000A0C61B64C0000000C032325040000000E0C71B64C0000000204932504000000040DA1B64C00000004057325040000000E0DC1B64C00000000084325040000000A0F01B64C000000080A832504000000020FB1B64C0000000E0C5325040000000E0FD1B64C0000000A0F2325040000000E0021C64C0000000A04433504000000020041C64C0000000005B33504000000020FE1B64C00000000088335040000000A0F61B64C0000000C09E335040000000E0F81B64C000000000C433504000000060F21B64C0000000C0E933504000000060EB1B64C0000000E00734504000000040ED1B64C0000000C025345040000000E0F61B64C00000004034345040000000C0F71B64C00000002043345040000000A0091C64C0000000E04934504000000040131C64C00000006058345040000000C0251C64C00000008066345040000000602F1C64C00000000075345040000000C0411C64C00000004083345040000000005C1C64C00000000082345040000000806D1C64C0000000408134504000000040881C64C0000000A08734504000000080911C64C0000000A08E34504000000020AC1C64C0000000009534504000000060B51C64C0000000209C34504000000060D11C64C0000000C0B8345040000000C0E31C64C0000000E0C634504000000060DC1C64C0000000A0DD34504000000000D51C64C000000060F434504000000040CC1C64C0000000C0F434504000000000BC1C64C0000000E00B35504000000080AB1C64C0000000801B355040000000609A1C64C0000000C023355040000000604D1C64C0000000004535504000000060111C64C0000000005E355040000000A0EF1B64C0000000E07535504000000020DE1B64C0000000A07635504000000060C41B64C0000000407F355040000000A0BB1B64C0000000A07F355040000000E0B21B64C0000000008035504000000020AA1B64C00000006080355040000000C08F1B64C00000008081355040000000608F1B64C0000000007A35504000000080861B64C0000000607A35504000000020861B64C00000000073355040000000C0851B64C0000000806B355040000000807C1B64C00000006064355040000000207B1B64C0000000204E35504000000000831B64C0000000C03E35504000000040931B64C0000000A02735504000000080911B64C0000000E00935504000000020A21B64C000000020FA34504000000000981B64C000000040E4345040000000608E1B64C0000000A0D5345040000000C0951B64C000000000BF34504000000060831B64C0000000C0B0345040000000207A1B64C0000000C0A934504000000040681B64C000000000A3345040000000A05E1B64C00000008094345040000000E0551B64C0000000E09434504000000060441B64C0000000A095345040000000203B1B64C0000000808E34504000000060321B64C0000000E08E345040000000E0201B64C0000000A08F345040000000E00F1B64C0000000E09734504000000080071B64C0000000A09F345040000000C0FE1A64C000000020A034504000000000F61A64C000000060A034504000000060F61A64C0000000E0A7345040000000C0081B64C000000020B6345040000000A0111B64C0000000A0B5345040000000202D1B64C0000000E0CA345040000000E0351B64C000000080CA345040000000C0361B64C000000080D934504000000060401B64C000000000E8345040000000004B1B64C0000000600535504000000000441B64C0000000A023355040000000803C1B64C0000000603A35504000000020351B64C00000002051355040000000202E1B64C0000000406F355040000000602F1B64C0000000A085355040000000003A1B64C000000000A335504000000020431B64C000000020AA355040000000A0431B64C0000000A0B135504000000080551B64C000000040B8355040000000605E1B64C0000000E0B735504000000020671B64C000000080B735504000000040701B64C0000000A0BE35504000000060931B64C000000020BD35504000000020AD1B64C000000080B4355040000000E0B51B64C000000020B435504000000040D01B64C000000000B335504000000080EA1B64C0000000E0B135504000000000FC1B64C000000020B1355040000000004A1C64C0000000C09E355040000000C0521C64C0000000609E355040000000806C1C64C0000000E09535504000000000A91C64C0000000408435504000000060C21C64C00000004074355040000000C0DB1C64C0000000206435504000000040171D64C0000000A04335504000000020301D64C0000000202C35504000000040411D64C0000000E023355040000000E0511D64C00000004014355040000000205A1D64C0000000600C35504000000060691D64C000000060E6345040000000E07A1D64C0000000A0E534504000000040831D64C0000000C0DD345040000000A0A61D64C0000000A0E334504000000000E41D64C000000000E1345040000000401A1E64C000000080FC34504000000000991E64C0000000203A35504000000020B41E64C0000000E04735504000000040F31E64C00000000063355040000000E00E1F64C00000002078355040000000A02A1F64C0000000608D355040000000A03C1F64C00000000094355040000000C0571F64C0000000C0A135504000000000731F64C000000080AF355040000000E0841F64C000000020B635504000000040981F64C000000040D335504000000060A31F64C000000020F835504000000000AE1F64C00000008015365040000000A0B71F64C0000000002436504000000000B91F64C0000000603A36504000000080B91F64C0000000E041365040000000C0C21F64C0000000E048365040000000E0CB1F64C0000000005036504000000020D51F64C0000000005736504000000060F01F64C0000000C064365040000000200B2064C0000000006B36504000000060252064C0000000E069365040000000A03F2064C0000000A06836504000000040512064C0000000E067365040000000806B2064C0000000A066365040000000C0972064C0000000206C365040000000A0BC2064C0000000608836504000000020342164C0000000A0DC36504000000080B42164C00000008030375040000000A0072264C00000000070375040000000405A2264C000000000A837504000000060AE2264C000000060F637504000000000172364C0000000A070385040000000C0202364C0000000207F385040000000A0572364C000000000A2385040000000E0982364C0000000C0DA385040000000E0BD2364C000000000F738504000000020DB2364C00000008022395040000000000B2464C0000000005C39504000000020282464C0000000808739504000000080432464C00000004095395040000000606A2464C000000040CF39504000000020762464C000000080FB395040000000809C2464C0000000002E3A504000000040A82464C0000000605A3A504000000060B32464C0000000407F3A5040000000E0B42464C0000000A0953A504000000080C02464C0000000E0C13A5040000000E0B12464C000000060EF3A5040000000A0A32464C000000060243B5040000000408B2464C000000080433B5040000000A07A2464C000000020533B5040000000806A2464C0000000606A3B504000000040622464C000000040723B504000000060482464C0000000E07A3B5040000000802E2464C000000080833B5040000000E01C2464C000000060843B5040000000E00A2464C0000000C07D3B504000000020D52364C000000040713B5040000000E0B92364C000000080633B5040000000A09D2364C000000000473B5040000000C0812364C0000000E0313B5040000000E06E2364C0000000401C3B5040000000C05B2364C0000000C0063B5040000000801A2364C000000000CE3A504000000000072364C0000000E0B03A5040000000C0EA2264C000000060943A5040000000C0D82264C0000000C08D3A504000000080BC2264C000000020713A5040000000C0B32264C000000080713A504000000020902264C0000000A06B3A5040000000E0742264C0000000E05D3A504000000040632264C0000000C05E3A5040000000203F2264C000000080513A5040000000C0242264C0000000A0523A5040000000A0012264C000000040543A504000000000CD2164C0000000A0563A5040000000E0BB2164C0000000E05E3A5040000000C06C2164C000000080623A5040000000A0382164C0000000606C3A5040000000401E2164C0000000806D3A5040000000C00C2164C0000000406E3A504000000060D92064C000000000873A5040000000A0B72064C0000000009F3A504000000080952064C000000080AF3A504000000020752064C0000000C0DD3A504000000060532064C0000000C0F53A504000000020432064C0000000E00C3B5040000000E0212064C0000000402C3B5040000000C0112064C000000060433B504000000080012064C0000000805A3B504000000000EA1F64C000000060883B5040000000A0E11F64C000000040903B504000000000BF1F64C000000060993B504000000040B61F64C0000000C0993B504000000060AD1F64C0000000209A3B5040000000C0891F64C000000040943B504000000020781F64C000000000953B504000000000441F64C0000000C09E3B5040000000C0321F64C000000000A73B504000000020221F64C0000000C0B63B5040000000C0081F64C0000000C0C63B504000000000F81E64C000000080D63B5040000000C0EF1E64C000000040DE3B504000000040E81E64C000000000F53B504000000080E01E64C000000060043C504000000020D91E64C0000000201B3C504000000040D11E64C0000000602A3C5040000000C0D11E64C0000000E0313C5040000000E0C91E64C000000020413C5040000000C0CA1E64C000000020503C504000000060C31E64C0000000E0663C5040000000E0BC1E64C0000000808C3C5040000000A0BF1E64C000000040B93C504000000000C11E64C000000080CF3C5040000000A0CA1E64C000000020DE3C504000000000DF1E64C0000000000A3D5040000000C0E81E64C000000080183D5040000000A0E91E64C000000080273D504000000020EA1E64C0000000E02E3D5040000000C0F41E64C0000000604C3D504000000060FF1E64C0000000C0693D504000000060F81E64C000000000883D504000000000F11E64C0000000C09E3D5040000000A0E81E64C0000000A0A63D5040000000C0E01E64C0000000E0B53D504000000080D81E64C0000000C0BD3D504000000040C71E64C000000000C63D5040000000A0B61E64C0000000A0D53D5040000000008C1E64C0000000E0ED3D504000000020721E64C0000000A0F63D504000000000471E64C000000060073E504000000020251E64C0000000401F3E5040000000E0021E64C0000000C02F3E504000000080CE1D64C000000080393E504000000000CF1D64C000000000413E504000000080941D64C0000000E0773E5040000000606A1D64C0000000A0973E504000000000621D64C0000000609F3E5040000000A0591D64C000000040A73E5040000000205A1D64C0000000C0AE3E5040000000805A1D64C000000020B63E5040000000C0511D64C0000000A0B63E5040000000404B1D64C000000040DC3E5040000000C0551D64C0000000A0F93E504000000020581D64C0000000001F3F504000000080521D64C000000080533F5040000000E0521D64C0000000005B3F5040000000C0461D64C000000020B53F5040000000403F1D64C000000000CC3F504000000040521D64C000000080E13F504000000020531D64C000000080F03F5040000000605D1D64C00000006006405040000000C0701D64C00000008023405040000000E0821D64C0000000202A405040000000A08B1D64C0000000C029405040000000209E1D64C0000000E037405040000000C09D1D64C00000008030405040000000E0A71D64C0000000804640504000000020B11D64C0000000804D405040000000C0A81D64C00000006055405040000000C0A91D64C00000004064405040000000609A1D64C0000000608A405040000000208A1D64C000000060A140504000000080711D64C000000080C040504000000020691D64C000000040C8405040000000A0611D64C000000000DF405040000000A0481D64C000000080F640504000000080491D64C0000000600541504000000000421D64C0000000401C41504000000000431D64C0000000202B415040000000E0561D64C0000000A04F41504000000080681D64C0000000E04E41504000000060911D64C0000000C01841504000000020BC1D64C0000000800041504000000080DD1D64C000000020E1405040000000C0EE1D64C0000000E0D8405040000000C0071E64C000000060C1405040000000C0281E64C0000000809A40504000000040301E64C0000000C08340504000000080381E64C0000000E07B40504000000020381E64C00000008074405040000000602E1E64C00000000066405040000000802D1E64C0000000005740504000000040231E64C0000000004140504000000020191E64C0000000202B405040000000E00F1E64C00000000024405040000000600F1E64C0000000801C405040000000800D1E64C0000000C0FE3F504000000060151E64C000000060EF3F5040000000601D1E64C000000020E03F504000000040251E64C0000000E0D03F504000000040241E64C000000000C23F504000000060231E64C000000000B33F5040000000E0291E64C0000000608D3F504000000060171E64C0000000407F3F504000000000041E64C000000040623F504000000000F11D64C0000000A04C3F504000000040E71D64C0000000003E3F504000000080DD1D64C0000000802F3F504000000080D21D64C0000000A00A3F504000000040B61D64C000000000EE3E504000000040B51D64C000000020DF3E5040000000A0C41D64C000000000B93E504000000040C41D64C000000080B13E504000000040DD1D64C0000000009A3E504000000000EE1D64C0000000608A3E5040000000E0071E64C0000000C0813E5040000000402A1E64C000000040713E504000000020441E64C0000000C0683E504000000000791E64C000000060663E5040000000A09C1E64C0000000406C3E5040000000E0EA1E64C0000000E0593E5040000000E0041F64C000000040513E5040000000002E1F64C000000080223E504000000080471F64C000000080123E5040000000E0561F64C000000060EC3D5040000000C05E1F64C000000020DD3D5040000000605D1F64C0000000C0C63D5040000000206D1F64C000000040A83D504000000020731F64C0000000207B3D5040000000807A1F64C000000040643D5040000000C0771F64C0000000A0373D504000000060761F64C000000040213D5040000000406C1F64C0000000400B3D5040000000E0691F64C000000000E63C5040000000C0651F64C0000000E0A23C504000000060641F64C0000000808C3C5040000000E0581F64C000000020603C504000000060581F64C0000000C0583C5040000000C05F1F64C000000000423C504000000080561F64C0000000E03A3C504000000060641F64C000000080FE3B5040000000407F1F64C0000000C0043C5040000000009B1F64C0000000001A3C5040000000E0AE1F64C0000000803E3C504000000080E41F64C0000000004B3C504000000040072064C000000000423C5040000000200F2064C0000000A0323C504000000080292064C000000080313C504000000020712064C0000000C0443C504000000040A82064C0000000A0673C504000000040D32064C0000000C0563C504000000000F52064C0000000C03E3C504000000080FC2064C000000000283C504000000040042164C0000000C0183C504000000060032164C0000000E0093C5040000000601B2164C000000060E33B5040000000E0212164C0000000C0BD3B5040000000A02F2164C000000040813B504000000000372164C0000000806A3B5040000000603F2164C0000000A0623B5040000000A0352164C000000020543B504000000060452164C000000080353B5040000000C04C2164C0000000C01E3B5040000000605D2164C0000000200F3B5040000000E06C2164C000000080F03A504000000040A12164C0000000A0E63A504000000000C42164C0000000A0DD3A504000000060F02164C000000020E33A5040000000401D2264C000000000F03A504000000040412264C000000040FD3A5040000000C07F2264C000000060093B5040000000009C2264C000000000263B504000000000C12264C000000020423B504000000080D32264C000000040503B5040000000C0DD2264C000000040663B5040000000A0042364C000000040A03B5040000000403C2364C000000080CA3B5040000000A06A2364C0000000C0ED3B504000000080962364C0000000C0EB3B5040000000E0B02364C000000080EA3B504000000000C32364C000000020F13B504000000000E72364C000000080FE3B504000000000142464C0000000600B3C504000000000262464C000000000123C504000000000522464C0000000E00F3C5040000000A0742464C0000000E0063C5040000000C0852464C0000000A0FE3B5040000000A0A02464C0000000C0043C504000000020B22464C000000000043C504000000040012564C000000040003C504000000060242564C0000000A0FE3B5040000000C02C2564C0000000C0F63B5040000000603E2564C000000000F63B5040000000E0602564C0000000E0EC3B504000000000722564C0000000A0E43B5040000000E08B2564C0000000E0DB3B5040000000809C2564C000000020CC3B5040000000A0BE2564C0000000A0BB3B5040000000E0DF2564C0000000209C3B504000000020022664C0000000A08B3B5040000000600A2664C0000000C0833B504000000060342664C0000000E0633B5040000000A03C2664C0000000005C3B504000000080552664C000000060443B504000000080542664C000000080353B5040000000E05B2664C0000000C01E3B504000000020512664C000000040013B504000000060582664C000000080EA3A5040000000405E2664C000000060BD3A5040000000605C2664C0000000A09F3A5040000000A0612664C0000000006B3A5040000000606E2664C0000000A01F3A5040000000A0622664C000000060F339504000000080682664C000000040C639504000000000662664C000000000A139504000000000642664C00000002083395040000000606B2664C0000000606C39504000000040722664C0000000204E395040000000A08A2664C0000000002F395040000000C0BD2664C00000002016395040000000E0CC2664C000000000F038504000000020E52664C000000000D1385040000000200E2764C000000040A2385040000000409D2764C0000000A04138504000000040442864C000000080BA375040000000C0C12864C0000000C05A37504000000060152964C0000000E01A37504000000000482964C0000000A0FA36504000000080582964C0000000E0EA365040000000807A2964C000000040DA36504000000060932964C0000000A0C236504000000060A32964C000000060AB365040000000E0B32964C0000000A09B36504000000020BC2964C0000000C09336504000000060C32964C0000000007D36504000000020CB2964C0000000A06D365040000000E0C12964C0000000A066365040000000E0AF2964C0000000006036504000000080822964C0000000C04B365040000000A0812964C0000000E03C36504000000000802964C0000000802636504000000020912964C0000000401E365040000000E0982964C0000000000F36504000000060A92964C000000020FF355040000000A0D32964C0000000A0E6355040000000A0172A64C000000080C535504000000020282A64C0000000C0B535504000000000532A64C0000000A0A435504000000080632A64C0000000E09435504000000080852A64C00000004084355040000000408D2A64C00000000075355040000000409C2A64C0000000E04E35504000000060A22A64C00000002029355040000000E0B22A64C00000006019355040000000E0B12A64C0000000800A355040000000A0B92A64C000000020FB345040000000E0BF2A64C000000080D5345040000000A0C82A64C000000000D534504000000060D02A64C0000000C0C534504000000060CF2A64C0000000C0B634504000000060E02A64C000000080AE34504000000020F92A64C0000000E096345040000000E0012B64C0000000609634504000000020092B64C0000000A07F34504000000080192B64C0000000E06F345040000000C0202B64C0000000205934504000000040312B64C00000004049345040000000C02F2B64C0000000003334504000000040512B64C0000000E01A34504000000060582B64C0000000200434504000000000582B64C0000000A0FC33504000000080692B64C0000000C0FB33504000000020712B64C000000080EC33504000000060892B64C000000060CD335040000000A0912B64C000000080C533504000000060982B64C000000040A7335040000000009F2B64C0000000008933504000000080AF2B64C0000000407933504000000040B72B64C0000000E069335040000000C0C72B64C0000000205A335040000000E0CE2B64C00000006043335040000000A0D62B64C0000000003433504000000060DC2B64C0000000E00633504000000000E42B64C000000080F732504000000000D02B64C000000020D332504000000060CC2B64C0000000009F325040000000A0C12B64C0000000A08132504000000020C12B64C0000000407A32504000000020BF2B64C0000000605C32504000000020CF2B64C0000000404532504000000080DE2B64C0000000802632504000000080EE2B64C0000000400F32504000000020172C64C000000080E031504000000040412C64C0000000E0C7315040000000A0742C64C000000060B631504000000060A02C64C000000040B4315040000000C0B12C64C000000060B331504000000040C32C64C000000080B231504000000080012D64C000000040BE31504000000060232D64C0000000A0AD315040000000A02B2D64C0000000C0A5315040000000202B2D64C0000000609E31504000000040432D64C0000000207F31504000000020522D64C00000002059315040000000A0622D64C0000000404931504000000020792D64C0000000E013315040000000E0812D64C00000006013315040000000009B2D64C0000000200331504000000040A32D64C000000040FB305040000000E0CD2D64C000000020EA305040000000E0DF2D64C0000000C0F030504000000060022E64C000000080E730504000000060402E64C000000060F330504000000040CD2E64C000000000FB30504000000040DF2E64C00000008001315040000000A0132F64C0000000E0FE30504000000020612F64C000000000EC305040000000C09D2F64C000000060E1305040000000A0AE2F64C000000000D9305040000000E0C72F64C0000000E0C8305040000000C0FB2F64C0000000A0BE305040000000002F3064C000000020AD305040000000C0493064C000000020B3305040000000205A3064C000000060A330504000000060743064C000000000A230504000000040853064C0000000A099305040000000808D3064C0000000C091305040000000609D3064C0000000807A30504000000040AD3064C0000000406330504000000060B43064C0000000804C305040000000C0B23064C0000000203630504000000020C23064C00000008017305040000000A0C03064C00000002001305040000000A0C63064C000000060DB2F5040000000C0CE3064C000000080D32F504000000020DE3064C0000000E0B42F5040000000C0F63064C0000000209D2F5040000000A0073164C0000000C0942F5040000000E0213164C000000060932F5040000000802A3164C000000000932F504000000060463164C0000000E0A72F5040000000805B3164C000000020DB2F5040000000C05E3164C0000000E00730504000000060613164C0000000202D30504000000000643164C00000006052305040000000606A3164C0000000C0AB305040000000E09A3164C000000080EC30504000000080D23164C00000008016315040000000E0F53164C0000000201C315040000000602B3264C00000004028315040000000A0343264C0000000402F31504000000040A73264C00000002038315040000000601B3364C0000000605731504000000000883364C0000000008631504000000020F53364C000000020BC315040000000403D3464C000000020D631504000000080873464C0000000000E325040000000E0B53464C00000000031325040000000A0DB3464C00000006054325040000000E0133564C0000000A08532504000000000283564C000000000AA325040000000403C3564C000000040CE325040000000604F3564C0000000A0E3325040000000E06B3564C0000000200033504000000000913564C0000000001C335040000000A0B53564C0000000803033504000000060D03564C0000000803633504000000040DA3564C0000000E044335040000000E0E23564C0000000804433504000000020E43564C0000000605333504000000020E53564C0000000406233504000000020FC3564C0000000C0AB335040000000A0183664C000000020C8335040000000C0193664C000000000D733504000000080233664C000000080E5335040000000002E3664C000000060FB335040000000A0523664C0000000E00F345040000000607F3664C0000000601C34504000000020BC3664C0000000A011345040000000A0CD3664C0000000A01034504000000000DE3664C0000000E00034504000000020093764C000000000F7335040000000E0343764C0000000A0F433504000000060693764C0000000C0F133504000000080F73764C00000000008345040000000E0243864C0000000E01B34504000000040583864C0000000200A34504000000080843864C0000000400F345040000000E09F3864C0000000A01C345040000000A0A83864C0000000401C34504000000040AA3864C00000008032345040000000A09B3864C0000000C05834504000000040843864C0000000607F345040000000E05B3864C000000080AE345040000000C0543864C000000040C5345040000000E04E3864C000000000EB345040000000A03F3864C0000000C009355040000000402F3864C0000000A01935504000000020163864C0000000002A355040000000E0183864C0000000404F355040000000A01A3864C0000000806535504000000080F03764C0000000407E355040000000A0F13764C0000000208D355040000000A0033864C0000000A093355040000000E0213864C000000060C6355040000000403D3864C0000000C0D335504000000080623864C0000000A0EF355040000000A0743864C000000020F6355040000000608F3864C000000040FC355040000000C09F3864C000000060EC355040000000A09E3864C000000080DD35504000000080C03864C0000000A0CC35504000000080D83864C000000060AD355040000000A0F13864C0000000209D355040000000E0F53864C00000000061355040000000E0CD3864C0000000E01F355040000000C0BB3864C0000000601935504000000080B23864C00000006012355040000000E0C93864C0000000C0EB345040000000E0E13864C000000080CC34504000000060EF3864C00000006097345040000000C0173964C0000000606834504000000080503964C00000004029345040000000E04F3964C0000000E021345040000000A04D3964C00000000004345040000000C0263964C0000000E0D1335040000000800C3964C000000040D333504000000020CE3864C0000000E0C733504000000080983864C0000000E0BB335040000000E06C3864C000000040BE33504000000080633864C000000040B7335040000000803F3864C000000040AA335040000000E0C23764C0000000409333504000000000A83764C0000000408D33504000000000963764C0000000A086335040000000206F3764C00000008054335040000000C0533764C00000000047335040000000A0403764C0000000A031335040000000C0243764C0000000A01C335040000000E00F3764C0000000E0F032504000000000F43664C000000000DC32504000000020C63664C0000000A0C032504000000020863664C0000000A09E325040000000C0583664C0000000A08A325040000000A03E3664C0000000008C32504000000060123664C00000000087325040000000A0E63564C00000006089325040000000C0C33564C0000000408B32504000000040B23564C0000000208C32504000000080A93564C0000000A08C32504000000000983564C0000000808D32504000000060963564C00000004077325040000000E0A73564C0000000407632504000000000C83564C0000000204F32504000000020E13564C0000000E03E32504000000040E83564C00000000028325040000000C0123664C0000000C01632504000000080563664C000000040F531504000000040E83664C000000000C831504000000040833764C0000000A0A1315040000000C0FB3764C00000008084315040000000A0643864C0000000C07E31504000000060E53864C0000000E059315040000000C06E3964C0000000603431504000000080B33964C0000000A02131504000000060003A64C0000000E006315040000000C03B3A64C000000020ED30504000000000813A64C0000000C0E1305040000000A0A13A64C000000020C230504000000060C33A64C000000040B130504000000040ED3A64C0000000809830504000000020173B64C0000000C07F305040000000C0533B64C0000000E074305040000000406D3B64C0000000E06B305040000000A0B33B64C0000000806F30504000000040C63B64C0000000607D30504000000040D83B64C0000000E08330504000000020DE3B64C0000000205E305040000000A0DD3B64C0000000A05630504000000000DD3B64C0000000404F305040000000E0DB3B64C00000006040305040000000A0FD3B64C0000000802F30504000000040173C64C0000000A02630504000000080273C64C0000000C01630504000000040373C64C000000060FF2F5040000000E0573C64C0000000A0DF2F504000000000673C64C0000000E0C02F504000000040893C64C000000080B72F504000000080993C64C0000000A0A72F504000000060AA3C64C0000000209F2F504000000080C33C64C0000000C08E2F504000000040C23C64C0000000E07F2F504000000040C93C64C000000000692F504000000020C83C64C0000000205A2F504000000020CF3C64C000000060432F504000000080E03C64C000000060422F504000000020133D64C000000000292F5040000000401B3D64C000000020212F5040000000E0223D64C0000000C0112F504000000080443D64C0000000E0002F504000000060553D64C000000060F82E504000000040863D64C0000000C0C82E5040000000A0853D64C000000040C12E5040000000E0953D64C000000060B12E5040000000E09C3D64C0000000A09A2E504000000060AB3D64C000000060742E5040000000E0A73D64C0000000C0472E504000000020B03D64C0000000C03F2E5040000000E0C03D64C000000060372E504000000020D13D64C000000080272E504000000060FD3D64C0000000602C2E504000000020313E64C000000000222E5040000000404B3E64C000000080202E5040000000005C3E64C000000000182E5040000000805B3E64C0000000A0102E5040000000E05A3E64C000000020092E504000000080463E64C0000000E0E42D504000000040193E64C000000020D12D504000000020073E64C0000000A0CA2D504000000080EC3D64C0000000A0C42D504000000060D23D64C000000020C62D504000000080C13D64C0000000A0CE2D504000000080A83D64C000000000DF2D5040000000808F3D64C000000060EF2D5040000000606E3D64C0000000A0072E5040000000604A3D64C0000000C0FA2D504000000000403D64C0000000E0E42D5040000000603F3D64C000000080DD2D5040000000601B3D64C0000000A0D02D5040000000A0F93C64C000000060E12D504000000060AC3C64C0000000C0F42D504000000000823C64C000000020062E5040000000E0603C64C0000000801E2E5040000000803E3C64C0000000E0272E5040000000E02E3C64C0000000203F2E5040000000001E3C64C0000000A0472E5040000000C00D3C64C000000080572E5040000000400E3C64C0000000E05E2E504000000040073C64C0000000C0752E504000000040EE3B64C000000020862E504000000060D63B64C000000060A52E504000000020BF3B64C000000000CC2E504000000040953B64C0000000E0E42E504000000040633B64C000000080052F504000000040433B64C0000000C02C2F504000000080213B64C0000000A03D2F504000000040F93A64C0000000C06C2F5040000000A0C63A64C000000000862F5040000000E08B3A64C000000020A72F504000000000623A64C0000000E0BF2F5040000000C0473A64C000000060C12F5040000000402E3A64C000000040CA2F5040000000401D3A64C0000000C0D22F5040000000C0033A64C0000000A0DB2F504000000040D93964C0000000E0EC2F504000000080B73964C0000000C0FD2F504000000040963964C00000000016305040000000407D3964C00000006026305040000000205C3964C0000000A03E305040000000604C3964C0000000E055305040000000E03A3964C0000000E056305040000000C0203964C00000006058305040000000E0FD3864C0000000405A305040000000C0D23864C0000000206430504000000060B03864C0000000606D305040000000808D3864C0000000606F305040000000C0793864C0000000805230504000000060813864C0000000204330504000000020913864C0000000E02B305040000000C0C23864C0000000C003305040000000E0FC3864C000000020DB2F5040000000C0263964C000000060C22F504000000000963964C0000000609E2F5040000000402D3A64C0000000404B2F504000000080673A64C0000000A0222F504000000020C53A64C000000080FF2E504000000040FE3A64C0000000E0C72E504000000040173B64C0000000A0B72E5040000000E0263B64C000000040A02E5040000000204F3B64C000000020712E5040000000A0643B64C000000020342E5040000000408C3B64C000000080FD2D504000000080B53B64C000000040DD2D504000000080E73B64C0000000A0BC2D5040000000602A3C64C000000060932D5040000000E05C3C64C0000000207A2D5040000000E0AF3C64C000000020412D504000000020043D64C0000000E0162D5040000000607C3D64C0000000A0F92C5040000000002A3E64C000000040E82C504000000060B53E64C000000040E02C5040000000A06B3F64C000000040CE2C504000000000CC3F64C000000020D02C5040000000A03C4064C000000020C22C5040000000E0704064C000000000BF2C504000000020C94064C0000000E0C82C5040000000A0E54064C000000020E52C504000000000FA4064C000000060092D5040000000C0FB4064C0000000A01F2D5040000000A0214164C0000000E0422D5040000000005E4164C0000000E0372D5040000000E0D74164C0000000A0302D5040000000E0EF4164C000000080812D5040000000A0E94164C0000000E09F2D5040000000E0F24164C0000000C0A62D504000000020F74164C0000000E0DA2D504000000080F94164C0000000A0F82D5040000000E0024264C0000000A0FF2D5040000000E0144264C000000000062E5040000000E0264264C0000000600C2E5040000000C0374264C000000000042E5040000000A0624264C000000000FA2D5040000000008D4264C000000080E82D504000000040AF4264C000000000DF2D504000000020E14264C000000020BE2D504000000020024364C0000000C0A52D5040000000201B4364C000000040952D5040000000202D4364C0000000C09B2D5040000000C02D4364C000000020A32D504000000080414364C0000000E0BF2D5040000000C0424364C0000000C0CE2D5040000000E05C4364C000000040CD2D5040000000E06E4364C0000000A0D32D5040000000E0874364C000000040C32D504000000000984364C000000040B32D5040000000E0A84364C0000000C0AA2D5040000000C0AF4364C000000000942D504000000040A54364C0000000207E2D504000000040934364C0000000C0772D504000000040814364C000000060712D5040000000E0774364C0000000606A2D5040000000606D4364C0000000A0542D5040000000806B4364C0000000403E2D5040000000A0614364C0000000E02F2D5040000000A04F4364C000000080292D5040000000E0464364C0000000002A2D5040000000602A4364C0000000C00D2D504000000060184364C000000060072D5040000000C0174364C0000000E0FF2C504000000060ED4264C000000060112D504000000040E54264C000000060192D504000000000CD4264C000000040312D504000000020AA4264C000000040332D5040000000C08E4264C0000000E0252D5040000000206A4264C0000000A0112D504000000060194264C000000080F82C5040000000A0EC4164C000000020EC2C5040000000C0B74164C0000000C0E72C5040000000C0A54164C000000060E12C5040000000C0934164C0000000E0DA2C5040000000808A4164C000000000D42C504000000040984164C000000040A62C5040000000202B4264C0000000C08E2C5040000000E09C4264C0000000808F2C504000000020F54264C000000040992C5040000000604D4364C000000000A32C504000000080924364C000000060972C504000000040EF4364C0000000806C2C504000000040CD4464C0000000E02A2C5040000000204C4564C000000060F62B5040000000E0874564C0000000C0E32B504000000080B14564C0000000E0CA2B5040000000C0C94564C000000000B32B504000000060E14564C0000000A0932B504000000080F84564C0000000C06C2B5040000000A0F64564C000000080562B504000000040FC4564C0000000C0302B504000000080024664C000000080122B504000000040014664C000000080032B5040000000003B4664C0000000A0DA2A5040000000005C4664C000000040C22A504000000000644664C000000040BA2A5040000000208D4664C0000000E0992A5040000000C0B64664C0000000E0802A504000000040C64664C000000080692A5040000000C0CD4664C0000000205A2A5040000000C0E44664C000000040332A504000000020EC4664C0000000E0232A504000000060EA4664C0000000800D2A504000000060F24664C0000000A0052A5040000000A0F84664C000000040E7295040000000A0FD4664C000000020BA295040000000C0004764C0000000A07629504000000080FF4664C0000000C06729504000000040154764C00000000032295040000000203C4764C000000040FB285040000000204B4764C000000080DC285040000000E04E4764C000000060A0285040000000C0534764C00000004073285040000000A05A4764C0000000605C28504000000020654764C00000006009285040000000207C4764C0000000A0E2275040000000408C4764C0000000A0D227504000000080A44764C0000000C0BA27504000000000E84764C000000040A0275040000000C00A4864C0000000009E275040000000801B4864C0000000809527504000000020364864C0000000609B275040000000004F4864C0000000E08A27504000000060704864C0000000E079275040000000A07E4864C0000000A053275040000000007E4864C0000000204C275040000000E0844864C00000004035275040000000408C4864C0000000E025275040000000409E4864C0000000402C27504000000060DA4864C0000000202127504000000080164964C0000000E015275040000000A05C4964C0000000001927504000000060874964C0000000E00E275040000000C08E4964C000000080FF265040000000E0B84964C0000000E0ED265040000000A0BF4964C000000000D7265040000000C0D94964C000000040D526504000000040F14964C0000000E0B526504000000000364A64C000000020AA265040000000C0564A64C0000000A091265040000000E0704A64C00000000090265040000000E0784A64C0000000008826504000000040D34A64C0000000A046265040000000C0FA4A64C00000004017265040000000C05D4B64C000000020D5255040000000A0964B64C0000000C0A425504000000080D94B64C0000000A08225504000000000034C64C0000000806925504000000060244C64C00000008058255040000000003D4C64C00000000048255040000000C0454C64C0000000604725504000000060684C64C00000004045255040000000809A4C64C0000000A02B25504000000000C44C64C0000000801225504000000000D44C64C00000008002255040000000E0F24C64C0000000C0D324504000000080F94C64C0000000E0BC245040000000A0114D64C0000000E0A4245040000000003B4D64C0000000C08B24504000000080644D64C0000000C07224504000000020754D64C0000000206A245040000000C09F4D64C0000000006024504000000060C24D64C0000000C05D24504000000020F54D64C0000000804B245040000000201F4E64C0000000E039245040000000E02F4E64C0000000603124504000000080484E64C0000000E02024504000000080584E64C0000000E01024504000000000684E64C000000060F923504000000000804E64C000000060E1235040000000607F4E64C000000000DA23504000000000984E64C000000060C923504000000080C74E64C0000000009223504000000080D74E64C0000000008223504000000020F04E64C00000008071235040000000405A4F64C0000000E01F23504000000040A44F64C000000020EE225040000000E0DE4F64C0000000E0D322504000000080F74F64C000000060C322504000000040085064C0000000C0BA225040000000C06C5064C0000000E08E225040000000C08E5064C00000002085225040000000C0E25064C0000000A06122504000000000F25064C0000000404A225040000000C0025164C0000000A041225040000000C01A5164C0000000A02922504000000020225164C0000000401A22504000000000305164C0000000E0F3215040000000603F5164C000000080DC215040000000A0565164C000000000BD215040000000606D5164C00000002096215040000000A0845164C0000000A076215040000000A08A5164C0000000605821504000000060995164C0000000803921504000000000A05164C0000000A02221504000000040B95164C00000008019215040000000A0C65164C0000000C0EB20504000000020FF5164C000000020BB205040000000200F5264C000000020AB20504000000020275264C00000002093205040000000C0435264C0000000E04D205040000000605A5264C0000000002720504000000060605264C0000000A008205040000000A0755264C0000000E0D21F504000000040945264C000000000A41F504000000080B35264C0000000807C1F504000000020C45264C0000000E0731F5040000000C0D25264C000000000551F504000000000D85264C0000000402F1F504000000020D65264C000000000191F504000000000DE5264C000000000111F5040000000A0E45264C000000020FA1E5040000000E0FB5264C0000000A0DA1E5040000000801C5364C000000000C21E5040000000602C5364C000000000B21E5040000000404C5364C000000000921E504000000040625364C0000000A0631E504000000040605364C0000000604D1E5040000000E06E5364C0000000602E1E5040000000A0595364C000000000031E5040000000404C5364C000000080CF1D504000000020315364C000000060C21D504000000060305364C0000000E0BA1D504000000080225364C000000000801D504000000020255364C0000000803C1D504000000020215364C0000000E00F1D504000000040175364C000000080011D5040000000801E5364C000000020F21C5040000000C0255364C0000000A0E21C5040000000003B5364C0000000E0AC1C5040000000A04D5364C000000060591C5040000000405C5364C0000000803A1C5040000000C06A5364C0000000A01B1C504000000000805364C0000000C0E51B5040000000007A5364C0000000E0A21B5040000000A07C5364C0000000605F1B5040000000C0AB5364C0000000E0271B5040000000A0C35364C0000000C00F1B5040000000C0DA5364C000000040F01A5040000000A0FA5364C000000040D01A504000000080085464C0000000E0A91A504000000080105464C0000000E0A11A5040000000200F5464C000000000931A504000000000275464C0000000007B1A5040000000C0465464C0000000E05A1A5040000000204C5464C000000020351A5040000000203E5464C000000040FA19504000000020325464C0000000A0D5195040000000802F5464C0000000E0B7195040000000C03A5464C0000000C073195040000000E0265464C00000004057195040000000401A5464C0000000202B195040000000A00F5464C00000008015195040000000E0145464C0000000C0EF185040000000C0245464C0000000A0DF185040000000602B5464C0000000C0C8185040000000E0745464C0000000009718504000000080CF5464C0000000006418504000000000135564C00000008050185040000000A0505564C0000000605B185040000000206B5564C00000000061185040000000A0A65564C0000000805518504000000060C65564C00000008035185040000000A0F45564C000000080F6175040000000C0365664C000000020D417504000000040685664C000000060BA175040000000E0C25664C0000000408717504000000020205764C0000000007217504000000020285764C0000000006A175040000000C05C5764C00000002014175040000000607A5764C0000000C0DD165040000000C0AF5764C0000000408F165040000000A0BD5764C0000000E068165040000000A0D45764C0000000604916504000000020E35764C0000000802A165040000000000A5864C0000000E0FA155040000000C0215864C0000000E0E215504000000080585864C000000040A315504000000060775864C0000000C07B155040000000608E5864C0000000405C15504000000020A65864C0000000204415504000000080E75864C0000000401A155040000000E0095964C0000000E017155040000000401A5964C0000000400F15504000000000345964C0000000800D15504000000000505964C0000000002215504000000040635964C0000000203715504000000040795964C0000000006A155040000000208D5964C00000008086155040000000E0975964C0000000409C155040000000A0A65964C000000080DE15504000000000B25964C0000000A0FB15504000000040BF5964C0000000202F16504000000020C25964C0000000E04C165040000000E0C65964C0000000E08016504000000040D15964C000000060F016504000000080CF5964C0000000603B17504000000060CA5964C00000002061175040000000C0C05964C000000020B417504000000060AA5964C000000000DB17504000000020A55964C0000000C00018504000000060A15964C0000000603518504000000000935964C0000000605418504000000040875964C0000000009118504000000020825964C0000000C0B6185040000000407E5964C000000060EB185040000000A08B5964C0000000E01E195040000000E0855964C0000000403D195040000000E0875964C0000000805319504000000060815964C0000000606A195040000000C0825964C0000000407919504000000080855964C00000000097195040000000A0895964C0000000A0C3195040000000C0975964C000000080FE19504000000020A35964C0000000A01B1A504000000020A55964C000000000321A5040000000C0B75964C0000000A03F1A5040000000C0C35964C000000020641A504000000080D85964C000000020881A504000000060F45964C0000000C09C1A504000000040105A64C000000040B11A504000000060245A64C0000000C0CD1A5040000000E0365A64C000000060DB1A5040000000A04B5A64C000000060FF1A5040000000203D5A64C0000000601E1B5040000000803E5A64C0000000402D1B5040000000E0355A64C0000000C02D1B5040000000A0405A64C000000080431B5040000000A04A5A64C0000000C0511B5040000000405D5A64C0000000805F1B504000000080705A64C0000000A0741B504000000020835A64C000000040821B504000000080965A64C000000060971B5040000000808E5A64C0000000609F1B504000000060895A64C000000020C51B504000000080815A64C000000020CD1B5040000000E07A5A64C000000020E41B5040000000A0855A64C0000000C0F91B504000000020895A64C0000000001F1C5040000000808C5A64C000000020441C5040000000E0A95A64C000000080671C504000000020CF5A64C0000000E0821C5040000000C0F35A64C0000000C0961C5040000000801F5B64C0000000409B1C5040000000604D5B64C000000000B61C504000000040795B64C000000060BA1C5040000000808C5B64C000000080CF1C5040000000409F5B64C000000020DD1C504000000060995B64C000000080FB1C504000000060915B64C000000080031D5040000000A0795B64C0000000A01B1D5040000000005C5B64C000000020521D5040000000A0575B64C0000000407F1D5040000000C0515B64C0000000A09D1D5040000000E0535B64C0000000E0B31D5040000000A04C5B64C000000060C31D5040000000A0605B64C0000000E0DF1D5040000000206E5B64C000000060131E5040000000407A5B64C000000000381E5040000000C0855B64C000000020551E5040000000007D5B64C0000000C0551E5040000000A0805B64C0000000E07A1E504000000000825B64C0000000C0891E5040000000206A5B64C0000000E0A11E504000000040315B64C000000040CB1E5040000000C0185B64C0000000E0DB1E504000000080F75A64C000000020ED1E504000000020CF5A64C0000000E00D1F504000000060C95A64C0000000402C1F504000000080E15A64C000000060751F504000000060EE5A64C000000060A11F5040000000C0155B64C000000000D31F5040000000E03B5B64C0000000C0F51F5040000000E0575B64C0000000400A20504000000040875B64C0000000E033205040000000A0B65B64C0000000805D205040000000E0FF5B64C00000004085205040000000A0365C64C0000000609F205040000000409B5C64C000000040D4205040000000A0D25C64C0000000C0F520504000000060015D64C0000000001821504000000080315D64C00000000049215040000000004F5D64C0000000606C21504000000080645D64C0000000C09721504000000080855D64C000000040E021504000000000995D64C000000060F521504000000060BB5D64C0000000C04C22504000000040C85D64C0000000C07822504000000080DE5D64C000000080AB22504000000000045E64C0000000E0C6225040000000C0205E64C0000000C0E2225040000000A04F5E64C0000000E004235040000000407C5E64C0000000A01023504000000040EE5E64C0000000A017235040000000E0345F64C0000000802123504000000020605F64C0000000801E235040000000C0685F64C0000000E01D235040000000608B5F64C0000000601B23504000000080D85F64C0000000600E23504000000060146064C0000000A002235040000000E0586064C000000040F6225040000000C0A36064C000000000D322504000000040D66064C000000060C022504000000040F06064C000000080BE225040000000E0006164C0000000E0B5225040000000203E6164C000000000B922504000000020506164C000000020BF225040000000006D6164C000000000DB225040000000007F6164C000000040E122504000000040796164C0000000A0FF22504000000040716164C0000000A007235040000000405A6164C00000004027235040000000400F6164C0000000804A235040000000A0FE6064C0000000405323504000000080DD6064C0000000A064235040000000C0BD6064C0000000C08423504000000040BF6064C0000000A093235040000000A0976064C0000000E0BB23504000000040936064C000000020E9235040000000E08E6064C00000006016245040000000C09E6064C0000000E0B9245040000000E0D96064C00000008000255040000000C0036164C00000006048255040000000602E6164C0000000C09725504000000020566164C000000040C9255040000000E07D6164C0000000E0FA255040000000C0AC6164C0000000E01C265040000000C0FD6164C00000000035265040000000E0196264C00000006049265040000000A0496264C0000000E072265040000000A0786264C0000000009526504000000060BA6264C0000000A0C426504000000060E66264C0000000E0C8265040000000C0196364C0000000C0BD265040000000804E6364C000000060C126504000000060A76364C000000060D126504000000080E06364C0000000A00127504000000000F46364C0000000A016275040000000A0336464C0000000003027504000000040616464C00000002043275040000000206C6464C0000000C058275040000000C0946464C0000000C091275040000000A09F6464C000000060A727504000000040AB6464C000000080C427504000000080A56464C0000000E0E2275040000000A0A76464C000000040F927504000000020AC6464C0000000C025285040000000809E6464C0000000404C28504000000080996464C00000000072285040000000009E6464C0000000A09E28504000000040986464C000000000BD28504000000020816464C0000000A0DC28504000000000726464C000000040F4285040000000E03B6464C0000000803B295040000000E0146464C0000000406B29504000000020F06364C000000060B129504000000080FF6364C0000000A0F3295040000000202A6464C000000000E9295040000000A0426464C000000040D8295040000000005C6464C000000000CF295040000000E08D6464C0000000E0B4295040000000A0B06464C000000060B229504000000020E66464C000000060BD295040000000E0EE6464C0000000C0BC29504000000080FF6464C000000000B4295040000000401F6564C0000000C093295040000000C0766564C0000000E094295040000000A0C56564C0000000A096295040000000003B6664C0000000E0BA295040000000403A6664C000000060B329504000000000526664C0000000409B295040000000E0616664C0000000008B29504000000060826664C00000004072295040000000609C6664C00000004070295040000000C0AD6664C0000000006F29504000000060C66664C0000000405E295040000000C0D76664C0000000005D295040000000E0DE6664C0000000604D29504000000060DD6664C0000000A03E295040000000C0EB6664C0000000801F295040000000A0FB6664C0000000600F295040000000C00A6764C0000000E0F7285040000000C0246764C0000000E0F5285040000000003E6764C000000080EC28504000000040576764C000000020E3285040000000405F6764C000000020DB285040000000A0A46764C000000000D628504000000020C86764C0000000E0DA28504000000020E26764C0000000E0D828504000000000F26764C0000000C0C828504000000020F66764C0000000809B285040000000E0F36764C0000000408528504000000040FA6764C0000000406E28504000000080016864C0000000C05E285040000000201E6864C0000000C02028504000000040256864C00000002011285040000000002E6864C00000008010285040000000604E6864C0000000A0F7275040000000005F6864C0000000E0EE27504000000080776864C000000020DE27504000000060876864C000000000CE275040000000C0A76864C000000020B527504000000060B86864C000000060AC27504000000020C86864C0000000409C27504000000040D76864C0000000A084275040000000C0DD6864C0000000A06D27504000000080ED6864C0000000805D27504000000020106964C0000000E05A27504000000060296964C00000008051275040000000A04A6964C00000002040275040000000E0496964C0000000A03827504000000040506964C0000000C021275040000000A0566964C0000000C00A27504000000060546964C000000080F4265040000000E06C6964C0000000A0E326504000000000746964C000000020D4265040000000409C6964C000000020B326504000000080AA6964C0000000209426504000000080E36964C0000000606A265040000000800C6A64C0000000E050265040000000A02D6A64C0000000603F265040000000206F6A64C0000000001526504000000040906A64C0000000800326504000000060C36A64C000000020F825504000000080EF6A64C000000040FC25504000000080096B64C000000060FA255040000000403E6B64C0000000E0FD255040000000E07A6B64C000000040F925504000000080926B64C000000000E1255040000000E0986B64C000000000CA255040000000C0A06B64C000000000C225504000000040AE6B64C0000000809B255040000000A0B46B64C0000000808425504000000060B26B64C0000000406E255040000000A0B16B64C0000000C066255040000000809F6B64C0000000A060255040000000608D6B64C0000000805A25504000000000846B64C0000000C05325504000000040696B64C0000000604E255040000000A0606B64C0000000004F255040000000E0576B64C0000000A04F255040000000404F6B64C00000004050255040000000202B6B64C00000000044255040000000E0206B64C0000000E03525504000000080176B64C0000000202F255040000000C0166B64C0000000A027255040000000200E6B64C0000000402825504000000000DF6A64C00000006006255040000000E0836A64C000000060E0245040000000204C6A64C000000020BF24504000000020276A64C000000080AB24504000000040026A64C0000000C097245040000000E0DB6964C00000004075245040000000C0B46964C0000000404B24504000000060A06964C0000000C02E245040000000408B6964C0000000000B245040000000C0556964C00000000000245040000000A0396964C0000000A0EB235040000000C0266964C000000020DE235040000000601A6964C000000080B9235040000000E0066964C0000000A0A4235040000000A0F96864C0000000A078235040000000E0DB6864C00000008055235040000000C0D16864C0000000404723504000000000886864C0000000C01F235040000000E07D6864C0000000A011235040000000401A6864C000000020EC22504000000040D46764C0000000E0E9225040000000C0B16764C000000060EC22504000000000856764C0000000C0E0225040000000C02D6764C0000000C0DF22504000000000136764C000000040DA22504000000080D66664C0000000C0DE22504000000080A76664C0000000C0BC22504000000080836664C000000080B0225040000000402C6664C000000060AF225040000000E0086664C000000080AA22504000000000016664C0000000A0B222504000000000E76564C000000080B422504000000060CC6564C000000000AF22504000000000C36564C000000020A8225040000000E0B86564C0000000009A22504000000080AF6564C00000002093225040000000C0996564C0000000E067225040000000E08B6564C0000000803422504000000020766564C0000000200922504000000060656564C000000000B8215040000000C0446564C00000000077215040000000401C6564C0000000203E21504000000040FD6464C0000000000C21504000000040EB6464C0000000E00521504000000020CF6464C000000060F120504000000060AA6464C0000000A0DD20504000000080856464C0000000E0C9205040000000804F6464C000000060B7205040000000001B6464C0000000C0B320504000000040126464C000000060B4205040000000A0F76364C0000000E0AE20504000000060E66364C000000020B020504000000060BA6364C0000000E0AB20504000000020976364C0000000E0A6205040000000E0856364C000000020A8205040000000C0696364C0000000C093205040000000005A6364C0000000E0A3205040000000604C6364C000000040CA205040000000001A6364C0000000E0DC205040000000A0F96264C0000000C0F520504000000060E06264C000000000FF205040000000C0A66264C0000000202121504000000000856264C0000000202B215040000000A07B6264C0000000402421504000000000736264C0000000E024215040000000A0616264C0000000402621504000000060506264C0000000602721504000000000476264C0000000A02021504000000080336264C0000000800B21504000000080216264C00000006005215040000000C0046264C000000080E9205040000000C0F26164C000000060E320504000000000D86164C0000000C0DD205040000000C0C66164C000000000DF20504000000080B56164C000000040E020504000000040A46164C000000080E1205040000000A06F6164C0000000C0DD20504000000020696164C0000000C0F4205040000000C0796164C0000000E045215040000000C0626164C00000008065215040000000004B6164C0000000A07D21504000000020126164C000000020A7215040000000200A6164C000000040AF215040000000C0086164C000000060A0215040000000E00F6164C0000000E090215040000000800E6164C00000000082215040000000201C6164C0000000A05B21504000000060116164C0000000E045215040000000C0056164C0000000C02821504000000000FB6064C0000000201321504000000000F16064C0000000E00421504000000080EF6064C000000000F620504000000040ED6064C0000000C0DF20504000000020EB6064C000000060C9205040000000E0F06064C000000000AB20504000000020F86064C0000000809B205040000000E0FD6064C0000000407D205040000000400C6164C0000000405E20504000000080136164C0000000C04E20504000000040236164C0000000A03E205040000000C0296164C0000000C02720504000000060496164C0000000800720504000000020456164C0000000E0DA1F5040000000E04A6164C000000080BC1F504000000080586164C000000020961F5040000000E0546164C000000000711F504000000020546164C000000080691F5040000000A0486164C0000000604C1F5040000000E03D6164C0000000C0361F5040000000C0336164C000000080281F5040000000A01F6164C0000000000C1F5040000000A0156164C0000000C0FD1E5040000000000D6164C000000060FE1E5040000000A0036164C0000000A0F71E5040000000E0026164C000000020F01E504000000060016164C000000040E11E5040000000A01A6164C000000000D81E5040000000E0546164C000000060BD1E504000000040A86164C000000060991E5040000000C0F36164C0000000807D1E5040000000A0366264C000000020621E5040000000A05F6264C0000000C0481E504000000000786264C000000000381E504000000080906264C000000040271E5040000000E0A86264C000000080161E5040000000A0CA6264C0000000A00C1E5040000000A0F86264C000000060CD1D5040000000A0076364C0000000C0B51D504000000080176364C0000000C0A51D504000000080266364C0000000208E1D504000000060246364C0000000E0771D504000000060216364C0000000205A1D5040000000E03E6364C0000000A0231D5040000000203E6364C0000000201C1D504000000040336364C000000080061D504000000040296364C000000040F81C504000000080286364C0000000C0F01C5040000000601E6364C0000000A0E21C504000000000036364C0000000A0D51C504000000060F06264C000000000C81C504000000020EE6264C0000000A0B11C504000000080ED6264C000000040AA1C504000000080EA6264C0000000808C1C504000000080F26264C000000080841C504000000080EF6264C0000000C0661C5040000000A0EC6264C000000000491C504000000080EA6264C0000000C0321C5040000000E0F06264C0000000C01B1C5040000000A0F66264C000000060FD1B504000000000FD6264C000000080E61B504000000000146364C0000000E0C61B504000000060226364C0000000E0A71B5040000000A0216364C000000080A01B5040000000E00E6364C0000000E0921B5040000000001E6364C0000000607B1B5040000000A0356364C000000020631B5040000000E0556364C0000000604A1B5040000000805B6364C0000000002C1B5040000000A0586364C0000000400E1B5040000000605E6364C0000000E0EF1A5040000000205C6364C0000000A0D91A504000000060636364C000000020CA1A504000000040686364C000000040A41A5040000000806C6364C000000020771A504000000000736364C000000020601A5040000000C0826364C000000000501A5040000000009B6364C0000000403F1A504000000060B36364C0000000802E1A504000000040D46364C0000000201D1A504000000040F56364C0000000C00B1A5040000000200F6464C0000000E0091A504000000000176464C0000000E0011A5040000000E0306464C0000000E0FF195040000000E05B6464C0000000C0FC195040000000207C6464C0000000E0E319504000000060AB6464C000000080B319504000000020C56464C0000000A0B119504000000060D66464C000000060B019504000000060E86464C000000080B6195040000000800B6564C000000080BB19504000000040256564C000000080B9195040000000203F6564C0000000A0B7195040000000C0476564C000000000B7195040000000A0846564C000000000BA19504000000000AA6564C000000020D519504000000000AD6564C0000000E0F219504000000080AE6564C0000000C0011A504000000040B96564C000000060171A504000000020CE6564C0000000403B1A504000000040F96564C000000020381A504000000040156664C0000000804C1A5040000000E0206664C0000000A0691A504000000040376664C0000000409C1A504000000040446664C000000040C81A504000000080496664C000000040FC1A504000000040576664C0000000A02F1B504000000060736664C000000000441B504000000040976664C000000060501B5040000000A0B26664C0000000405D1B504000000080D66664C0000000A0691B504000000040FB6664C0000000407D1B504000000080046764C000000020841B5040000000002A6764C0000000409F1B504000000020376764C000000040CB1B5040000000403C6764C000000040FF1B5040000000A0366764C0000000A01D1C504000000060566764C000000020571C5040000000207E6764C000000080881C504000000080AE6764C000000060B91C504000000020C46764C0000000A0E41C5040000000E0D96764C0000000E00F1D5040000000E0F16764C000000080511D504000000060086864C000000040841D504000000000026864C0000000209B1D5040000000200F6864C000000020C71D5040000000C01A6864C000000040E41D5040000000801E6864C000000060091E5040000000001B6864C0000000003E1E504000000080276864C000000080621E504000000040446864C0000000607E1E504000000040736864C000000040A01E504000000080876864C0000000A0BC1E504000000000AD6864C0000000C0D71E504000000060DA6864C0000000E0EA1E5040000000E0FF6864C000000000061F5040000000801D6964C000000040291F5040000000004B6964C0000000403C1F504000000080706964C000000060571F5040000000E0AF6964C000000080701F504000000020CC6964C0000000E0841F504000000020F06964C000000020911F504000000080496A64C000000060A81F5040000000C06C6A64C000000040AD1F5040000000A0A06A64C000000040A91F5040000000A0C46A64C000000060B51F5040000000C0CE6A64C0000000A0C31F504000000060E56A64C000000040F61F504000000040FB6A64C0000000802120504000000040FE6A64C0000000403F20504000000000116B64C0000000E04C205040000000002E6B64C0000000A068205040000000E0646B64C00000006082205040000000409D6B64C000000000AB20504000000000B06B64C000000080B8205040000000A0D56B64C0000000A0D320504000000040356C64C00000004026215040000000A08A6C64C0000000A06A215040000000A0E56C64C0000000809021504000000040306D64C000000040BF215040000000A08D6D64C000000080FB21504000000020FD6D64C0000000C03D225040000000C04E6E64C0000000005D22504000000040A16E64C00000008083225040000000E0F26E64C0000000A0A2225040000000A0446F64C0000000C0C1225040000000C08D6F64C000000080E1225040000000E0FE6F64C0000000A032235040000000007F7064C0000000206C23504000000080F27064C00000000081235040000000A03B7164C0000000C0A023504000000020967164C000000020BF23504000000060DE7164C000000060D723504000000040307264C000000080F623504000000000707264C0000000600F245040000000403D7364C0000000203B245040000000C0D27364C0000000C04524504000000020407464C0000000807124504000000040C47464C0000000807D24504000000000137564C0000000C07E24504000000020587564C00000002079245040000000C07A7564C00000006076245040000000809C7564C0000000406C245040000000A0CF7564C0000000A060245040000000E0FA7564C0000000205D245040000000A02F7664C0000000606024504000000080637664C0000000405C245040000000E07F7664C0000000607024504000000080A27664C0000000A06D24504000000000D87664C00000006078245040000000E0047764C0000000C08324504000000000257764C0000000A06A24504000000060367764C0000000406924504000000060627764C0000000206D245040000000C0737764C0000000C06B24504000000060967764C0000000006924504000000080D47764C0000000E07224504000000000037864C0000000208D245040000000405F7864C000000020BA245040000000401C7964C000000020EE245040000000A0B27964C0000000E0FF24504000000060A07A64C0000000E01125504000000080127B64C00000008017255040000000C05E7B64C0000000400225504000000000B67B64C00000008002255040000000C00B7C64C000000000F4245040000000A02C7C64C000000040E2245040000000E0527C64C000000020B224504000000000817C64C0000000E079245040000000C0B07C64C00000006050245040000000C0BE7C64C00000004031245040000000C0C57C64C0000000C02124504000000080E77C64C0000000601724504000000060207D64C0000000A03F245040000000E0687D64C0000000A057245040000000E0C87D64C00000002057245040000000000E7E64C00000006051245040000000002F7E64C0000000A03F24504000000040677E64C00000006015245040000000C0B77E64C000000040DA23504000000000EA7E64C000000000C7235040000000C0447F64C0000000E099235040000000C0EA7F64C0000000009B23504000000020C68064C000000060F123504000000040A38164C0000000A00B24504000000020318264C0000000801D24504000000000698464C0000000602124504000000080E48564C00000000044245040000000207F8764C0000000E045245040000000A01F8964C00000002030245040000000E0118B64C0000000A0A2235040000000E06B8C64C0000000404023504000000060C18C64C00000002031235040000000C0EA8C64C0000000801E235040000000E0168D64C00000000022235040000000A0138D64C0000000404F23504000000060B18C64C0000000208523504000000060018C64C0000000E0C123504000000080698B64C000000060ED235040000000C0E28A64C00000004017245040000000E05D8A64C00000002050245040000000C0998964C0000000E077245040000000C03A8964C00000006080245040000000C0078964C0000000608C24504000000040B78864C0000000007D24504000000040718864C0000000A07B24504000000040258864C0000000409124504000000040068864C000000000B2245040000000A0708864C000000020BF245040000000E0218964C000000020D524504000000020998964C000000080BB245040000000E0338A64C000000040A6245040000000C0668A64C0000000409A245040000000E0498B64C0000000A051245040000000A0028C64C00000004014245040000000A0998C64C000000040E123504000000060EC8C64C0000000E0BB235040000000603D8D64C00000008087235040000000A0868D64C0000000805B235040000000804A8E64C00000006033235040000000E08C8E64C0000000E016235040000000A0238F64C0000000A0E322504000000080748F64C000000060AF22504000000020968F64C0000000E0A422504000000020E18F64C0000000808722504000000080319064C0000000A09622504000000020809064C0000000009722504000000040B09064C0000000A074225040000000C0EB9064C0000000C06722504000000020299164C0000000A06922504000000040539164C0000000405E22504000000020019264C00000006012225040000000A0719264C000000080C421504000000040F09264C000000040A221504000000020279364C00000004070215040000000606D9364C0000000C02D21504000000040A49364C0000000A0FB20504000000060179464C000000000C4205040000000C06B9464C000000020AD20504000000000959464C0000000609A20504000000020BF9464C0000000E08E20504000000060E49464C000000000A2205040000000A0F29464C0000000A0CD20504000000020CC9464C0000000C0F620504000000040209564C00000006023215040000000A0449564C0000000002F215040000000404D9564C0000000402E21504000000040799564C0000000A03121504000000040BA9564C0000000205121504000000000339664C0000000E045215040000000804E9764C0000000C023215040000000404D9864C0000000A0ED205040000000C0869864C0000000A0D120504000000040C19864C000000020BD20504000000020099964C0000000608920504000000060769964C0000000E024205040000000A0239A64C000000060D81F504000000000B99A64C0000000209D1F504000000080069B64C0000000C0951F504000000020399B64C0000000E0451F504000000080749B64C000000020F51E5040000000408F9B64C000000080B61E504000000020D49B64C0000000E0AF1E5040000000E01A9C64C000000020B81E504000000000709C64C000000080A81E504000000000B39C64C000000000931E5040000000E0CA9C64C000000040C51E504000000060979C64C0000000C00D1F5040000000A0659C64C000000020651F504000000040419C64C0000000209D1F504000000020469C64C0000000C00520504000000060719C64C0000000A088205040000000C0DA9C64C0000000A014215040000000205F9D64C000000020E9215040000000A0989D64C000000000CD215040000000E08F9D64C0000000608A215040000000C01E9D64C0000000A00621504000000040109D64C000000000DB20504000000080099D64C0000000806320504000000000FC9C64C0000000C0FB1F504000000080079D64C0000000A0CD1F5040000000604C9D64C0000000E0C61F504000000020AB9D64C0000000C0BD1F5040000000A0F89D64C000000040B61F5040000000A0389E64C0000000A08A1F504000000040549E64C000000060531F504000000000589E64C0000000802D1F5040000000C0329E64C0000000801A1F5040000000C0059E64C0000000E00F1F5040000000A0DC9D64C0000000E0221F504000000000BF9D64C0000000404B1F5040000000E0AC9D64C000000080451F5040000000A0999D64C000000060381F504000000000799D64C000000000071F504000000080599D64C000000000DD1E504000000040479D64C000000040D71E5040000000A02A9D64C000000080C31E504000000040039D64C0000000C0A11E504000000020069D64C000000080741E5040000000C0F99C64C0000000A0571E504000000000DD9C64C0000000E0431E5040000000C0CA9C64C0000000203E1E5040000000C0899C64C0000000E01E1E5040000000206C9C64C0000000C0031E504000000020569C64C000000060E01D5040000000A04A9C64C0000000E0CA1D504000000080369C64C000000060B61D504000000020159C64C000000000C11D5040000000C0079C64C000000060E01D5040000000C0EF9B64C0000000A0F11D504000000040BB9B64C000000020EF1D504000000060A19B64C0000000A0F11D5040000000A09C9B64C0000000A0CC1D5040000000809D9B64C000000080901D504000000060A29B64C000000000721D504000000040269C64C0000000E07B1D5040000000C0859C64C0000000207A1D504000000060D19C64C0000000E0631D5040000000E01B9D64C000000020461D504000000000449D64C0000000C02B1D504000000040509D64C000000000051D5040000000403A9D64C0000000A0E11C504000000000169D64C000000020D61C504000000040D19C64C0000000C0DC1C5040000000C09A9C64C000000080CB1C504000000020679C64C000000080D01C504000000020119C64C0000000C0D81C504000000060E29B64C0000000C0021D504000000000BF9B64C0000000A0FE1C5040000000608C9B64C0000000000B1D5040000000A0449B64C000000060FB1C5040000000600A9B64C000000000101D504000000000D19A64C0000000002C1D5040000000C0809A64C0000000A0601D5040000000000D9A64C000000040911D5040000000806B9964C0000000A0AF1D504000000060429964C000000080C21D5040000000C0379964C000000000F81D504000000060299964C0000000E00F1E5040000000E0F49864C0000000600D1E504000000000C49864C000000080281E504000000020959864C000000080521E504000000080619864C000000060571E5040000000C01A9864C0000000004F1E504000000060E39764C000000040361E5040000000C0DB9764C000000000FB1D504000000020029864C0000000E0D11D504000000020859864C0000000E0901D5040000000A02A9964C0000000C04C1D5040000000C0EA9964C0000000600D1D5040000000A06F9A64C000000040DB1C5040000000400E9B64C000000080A61C504000000040379C64C0000000006C1C5040000000A0DB9C64C0000000C0631C504000000060F59D64C0000000007D1C5040000000C0D99E64C0000000608C1C5040000000A0449F64C0000000605C1C504000000040B59F64C000000060151C50400000006019A064C000000020F51B50400000006085A064C000000000101C50400000004063A164C000000040721C5040000000E085A964C000000020FA1E5040000000801FAB64C0000000A0751F504000000060C7AC64C0000000C0D81F5040000000A040AF64C0000000C0782050400000006071B164C0000000A001215040000000E0B4B364C0000000A08F215040000000C093B664C0000000A04822504000000000B2B764C00000004075225040000000C080B864C0000000409B22504000000020F6B864C000000020B4225040000000605DB964C000000000A9225040000000C0FCB964C0000000E0B5225040000000C0C0BA64C0000000C0CD2250400000006048BB64C000000020EC22504000000080FEBB64C0000000001C235040000000205BBC64C0000000E03E2350400000002046BD64C00000008070235040000000C0AEBF64C000000040FF235040000000609FC264C0000000606F2450400000006094C364C0000000C0A6245040000000A055C464C0000000C0E3245040000000205DC564C000000080202550400000002051C664C00000002050255040000000A0DCC664C00000002084255040000000E014C764C0000000E09B255040000000409BC764C000000000E7255040000000C0FBC764C0000000C01F2650400000006068C864C0000000A06D265040000000C001C964C000000040FA2650400000008036CA64C0000000E0E527504000000040EFCA64C000000040582850400000002051CB64C00000004098285040000000200BCC64C0000000E0112950400000006058CC64C0000000C03D2950400000002088CC64C000000060562950400000004090CC64C0000000208A295040000000A0B0CC64C000000020E829504000000000DCCC64C000000020542A50400000008034CD64C0000000A0FE2A5040000000A0B1CD64C0000000A0E82B5040000000E057CE64C0000000C02F2D504000000080D3CE64C000000000472E50400000002011CF64C000000020ED2E5040000000A01DCF64C000000020732F504000000040EBCE64C000000080F12F504000000080C6CE64C0000000A057305040000000C0C1CE64C0000000C0DF30504000000080C9CE64C0000000404831504000000040D5CE64C00000004092315040000000E0ECCE64C00000002026325040000000E000CF64C0000000E0A332504000000020F6CE64C0000000000733504000000060B7CE64C00000002070335040000000A067CE64C000000080A6335040000000201ECE64C000000020CD33504000000080C8CD64C000000080DE33504000000000A7CD64C000000000EA3350400000008077CD64C0000000800D345040000000202ACD64C0000000A05234504000000020FECC64C0000000608C34504000000000F9CC64C0000000A0A3345040000000C0DDCC64C0000000409F34504000000020D9CC64C0000000A08134504000000020F0CC64C0000000A0333450400000004004CD64C0000000C00B3450400000000002CD64C0000000E0FC335040000000C0DBCC64C0000000C0EA335040000000E084CC64C0000000C0F43350400000002044CC64C0000000401A345040000000400ECC64C0000000804D34504000000060F1CB64C0000000807634504000000000DFCB64C000000000E2345040000000E0DACB64C0000000A00035504000000080E9CB64C0000000A02435504000000080F0CB64C00000000051355040000000002ECC64C00000004086355040000000E004CC64C0000000009A35504000000020E9CB64C000000060CA355040000000402BCC64C0000000201D365040000000A051CC64C0000000602F365040000000E07BCC64C00000000023365040000000A073CC64C000000020EF355040000000605CCC64C000000020CC355040000000806FCC64C0000000C09C355040000000E084CC64C0000000407C355040000000E097CC64C0000000E04C355040000000C09ACC64C0000000E026355040000000C09ECC64C0000000600835504000000040CECC64C0000000C0E4345040000000E0B7CC64C0000000E06E355040000000E0C1CC64C000000040E6355040000000A0C5CC64C0000000606D365040000000A0D3CC64C000000020C636504000000080EECC64C000000040FF3650400000002004CD64C0000000A04F375040000000E01DCD64C000000060F23750400000002031CD64C0000000E033385040000000002CCD64C0000000204B38504000000040F8CC64C0000000601C38504000000060D9CC64C0000000C00138504000000060D2CC64C000000060D537504000000060DACC64C0000000209837504000000040DDCC64C0000000407237504000000040D2CC64C00000006064375040000000C0B5CC64C0000000A058375040000000A09BCC64C0000000A05B3750400000004086CC64C0000000407C3750400000002097CC64C000000000AF37504000000080A4CC64C000000080CB375040000000C081CC64C000000080CF375040000000407ACC64C0000000E0D7375040000000C04ECC64C0000000E0DC375040000000C018CC64C00000004010385040000000A001CC64C0000000205E38504000000060F8CB64C00000000094385040000000201DCC64C000000080D3385040000000C069CC64C000000000F8385040000000C08DCC64C000000060FB385040000000A0F8CC64C000000040FE3850400000008017CD64C0000000C018395040000000C04ECD64C0000000C05D395040000000807ECD64C000000020AB395040000000E07CCD64C000000080D83950400000008052CD64C0000000E0E43950400000006029CD64C0000000A0F8395040000000601BCD64C0000000E0103A50400000002020CD64C0000000802E3A5040000000803ECD64C0000000E07D3A5040000000206DCD64C0000000C0C33A5040000000009BCD64C0000000A0CD3A5040000000A0C6CD64C0000000A0C83A504000000040DDCD64C000000060AF3A5040000000E0F3CD64C000000040963A50400000002032CE64C0000000A0963A50400000000075CE64C0000000A0B43A5040000000607ECE64C0000000C0EF3A504000000000B3CE64C0000000A05A3B50400000004017CF64C000000000A23B5040000000E062CF64C000000000BF3B5040000000E077CF64C000000020D33B50400000004052CF64C000000020FD3B504000000080A1CF64C000000040303C504000000060D4CF64C0000000A0573C5040000000E0FACF64C0000000C0693C5040000000A0FBCF64C0000000E0A53C504000000020F0CF64C0000000E0CC3C5040000000E009D064C0000000A0FE3C5040000000E037D064C000000060083D50400000006062D064C000000000FC3C5040000000005AD064C000000040C83C5040000000008CD064C000000060B33C504000000080C7D064C0000000A0D93C5040000000A0F6D064C0000000C0EA3C50400000004022D164C0000000C0E53C5040000000A009D164C000000060BB3C504000000080DED064C0000000A08B3C5040000000A0C0D064C000000080783C5040000000609BD064C0000000C06D3C50400000006062D064C000000040563C50400000006043D064C0000000A03B3C50400000004028D064C000000080023C5040000000E0FBCF64C000000060CB3B504000000020BECF64C000000040963B50400000008096CF64C0000000C07C3B50400000002075CF64C000000060533B5040000000600DCF64C0000000E0F53A5040000000E0A6CE64C0000000C09F3A504000000020F2CD64C0000000E0AC395040000000405BCD64C000000040CD385040000000203ECD64C00000004085385040000000605DCD64C0000000206B3850400000006092CD64C000000040A138504000000060D9CD64C0000000A0113950400000002048CE64C0000000809B39504000000020BDCE64C0000000A0153A50400000000017CF64C0000000408B3A5040000000A09DCF64C000000060033B5040000000402ED064C0000000C0813B5040000000202CD164C000000060463C5040000000203FD264C0000000001F3D5040000000C048D364C000000060BC3D50400000008047D464C0000000E04B3E504000000020A2D464C0000000808C3E5040000000C071D564C0000000E00A3F504000000020A7D564C0000000E0403F5040000000E0BBD564C0000000C0893F504000000040FBD564C000000020C63F5040000000401FD664C000000040FE3F5040000000402AD664C0000000C040405040000000A023D664C0000000608540504000000080F7D564C000000020F4405040000000E0F5D564C000000040564150400000004003D664C0000000A0A74150400000006019D664C0000000E0F74150400000006048D664C0000000807242504000000000B1D664C0000000C0CF425040000000607DD764C0000000806C4350400000006083D864C0000000A020445040000000E0A8D964C000000040BA4450400000002081DA64C0000000C02F4550400000008023DB64C000000000A4455040000000008FDB64C0000000E00F465040000000A03BDC64C000000040BF465040000000808FDC64C0000000E03C47504000000060D4DC64C0000000C09647504000000020F1DC64C000000020D7475040000000E008DD64C000000000FA475040000000402DDD64C000000000324850400000002077DD64C0000000807448504000000080DBDD64C0000000601D4950400000004038DE64C0000000009A495040000000E07ADE64C0000000C0194A50400000008096DE64C0000000A0874A5040000000C088DE64C000000080094B50400000002076DE64C0000000E06D4B50400000008055DE64C000000060EA4B504000000020FBDD64C0000000E0574D5040000000C0D1DD64C0000000203F4E50400000008060DD64C0000000605C4F50400000002089DC64C0000000609C505040000000E000DC64C00000004069515040000000C0ADDB64C000000020C6515040000000E06FDB64C00000004002525040000000403CDB64C00000000010525040000000201ADB64C0000000801B525040000000E0F6DA64C0000000C01F52504000000000D1DA64C0000000201552504000000020CCDA64C000000080F751504000000060E0DA64C000000060CF515040000000E0FADA64C00000008097515040000000C0EBDA64C0000000807351504000000060D1DA64C0000000E041515040000000A0C8DA64C0000000200E51504000000020F1DA64C0000000E0BD505040000000A0FCDA64C000000000625050400000008005DB64C0000000202C505040000000600EDB64C000000040F64F50400000004043DB64C000000040BB4F5040000000A097DB64C0000000809A4F50400000008032DC64C0000000A03C4F5040000000A0C9DC64C000000080C84E504000000020F8DC64C0000000209D4E50400000008012DD64C000000020654E50400000004011DD64C000000000294E50400000000023DD64C000000060884D5040000000C057DD64C000000080184D50400000008087DD64C0000000C0BF4C504000000060DADD64C000000080C44B5040000000A0D1DD64C0000000E05B4B5040000000A0B4DD64C0000000A0E64A5040000000809BDD64C000000080BC4A5040000000405ADD64C0000000E0784A5040000000A034DD64C000000080394A5040000000203CDD64C000000040FC495040000000C057DD64C0000000A0CB4950400000008047DD64C000000060A04950400000006029DD64C0000000608D49504000000020E3DC64C0000000006149504000000020D4DC64C0000000203D495040000000A0DBDC64C0000000A0344950400000008033DD64C0000000E05E495040000000605FDD64C0000000A059495040000000A06ADD64C000000080324950400000006015DD64C000000040E248504000000000E2DC64C0000000608648504000000040C5DC64C00000000046485040000000A0B3DC64C00000004013485040000000E08CDC64C000000080CC475040000000206BDC64C000000060A3475040000000C04BDC64C0000000E088475040000000C037DC64C000000000B1475040000000603BDC64C000000000FC475040000000C078DC64C000000080294850400000006068DC64C0000000C0674850400000002062DC64C000000060AC485040000000607CDC64C000000000DE4850400000000089DC64C000000020F3485040000000E06FDC64C0000000A0FD485040000000803CDC64C0000000600B495040000000A0B7DB64C000000000DF4850400000004012DB64C0000000A090485040000000409BDA64C0000000E04B485040000000408CDA64C000000000284850400000000099DA64C000000080D3475040000000A079DA64C000000020B94750400000008051DA64C000000080D44750400000004041DA64C000000000DE4750400000004028DA64C0000000C0B3475040000000401EDA64C000000060AD47504000000000C4D964C000000000A9475040000000202BD964C000000080A4475040000000C0A7D864C0000000407F475040000000E049D864C0000000C064475040000000000AD864C0000000405D47504000000040E3D764C0000000204B475040000000607BD764C0000000202A47504000000000CBD664C0000000C002475040000000A034D664C0000000E00C475040000000C051D564C0000000002F4750400000004071D464C0000000E05F4750400000000043D364C000000040A1475040000000E0B3D264C000000080D7475040000000C05FD264C0000000E0F74750400000004004D264C0000000E0EB475040000000A0C9D164C000000000CD4750400000000085D164C0000000C0A74750400000006069D164C000000060A3475040000000401FD164C000000000CA4750400000004017D164C00000004007485040000000C056D164C0000000C043485040000000E062D164C0000000C08D4850400000006070D164C000000040AA485040000000A059D164C000000080C3485040000000C009D164C00000008090485040000000C0CED064C000000060A64850400000000067D064C0000000E02A4950400000008070D064C00000000066495040000000E094D064C00000006069495040000000C0FAD064C00000002047495040000000C0B4D164C00000006004495040000000A047D264C000000060E4485040000000A0A4D264C000000000C3485040000000202BD364C0000000A08D4850400000004075D364C0000000E06648504000000040BED364C0000000C038485040000000A0FBD364C0000000A031485040000000C03BD464C00000006004485040000000206AD464C0000000200E485040000000A010D464C0000000807A485040000000C05CD364C000000060E24850400000008084D264C0000000C0464950400000006075D164C0000000C06D495040000000C0A9D064C000000060B24950400000000045D064C000000020DC49504000000060FECF64C000000000194A504000000000C4CF64C0000000206B4A5040000000409FCF64C0000000809C4A5040000000804ECF64C000000000D34A5040000000A0FDCE64C000000080094B5040000000A0C5CE64C0000000406A4B5040000000009ECE64C0000000C0C14B5040000000C094CE64C000000080F74B5040000000E0AFCE64C0000000C0304C5040000000A0C4CE64C0000000A0794C504000000020F0CE64C000000080A94C5040000000C0E7CE64C0000000801B4D5040000000400BCF64C000000080884D5040000000402DCF64C0000000E0224E50400000002017CF64C000000040784E5040000000008ECE64C0000000A00F4F5040000000E0A7CD64C000000040934F5040000000400CCD64C000000040F04F5040000000008FCC64C0000000A02B5050400000000048CC64C00000006068505040000000A0FBCB64C000000060BC50504000000000D6CB64C00000008022515040000000E0A1CB64C0000000C0645150400000004083CB64C000000040865150400000006062CB64C00000000099515040000000003FCB64C0000000009D515040000000C01FCB64C000000060825150400000004026CB64C0000000A072515040000000E048CB64C00000006032515040000000E042CB64C0000000600D5150400000000029CB64C0000000A0DB505040000000A01CCB64C000000060C650504000000060F3CA64C000000060A55050400000006064CA64C0000000A071505040000000402ECA64C0000000207050504000000060E2C964C0000000208F50504000000080A3C964C0000000C08E5050400000000054C964C00000008097505040000000E013C964C0000000A08F505040000000A0A7C864C0000000A08C5050400000006077C864C000000020B0505040000000C03AC864C0000000A0BE505040000000600DC864C000000000BC50504000000080BDC764C0000000A0885050400000002068C764C0000000806C505040000000400BC764C0000000A0585050400000006062C664C0000000C06350504000000080F1C564C00000000043505040000000E04FC564C00000008009505040000000200DC564C000000080B64F504000000000DDC464C000000000694F5040000000C0B1C464C000000000394F5040000000E07FC464C0000000C0184F5040000000A07EC464C000000060114F50400000006028C464C0000000C0ED4E5040000000608AC364C000000040CA4E50400000008020C364C0000000E0D54E504000000000DAC264C000000080DD4E50400000002087C264C000000000D04E5040000000E04FC264C000000000C74E5040000000000EC264C000000040EC4E5040000000A0EAC164C000000020F04E5040000000C05FC164C0000000400E4F5040000000A033C164C000000000134F5040000000002EC164C000000000EE4E50400000004013C164C0000000C0B44E50400000008003C164C000000020894E504000000020CCC064C0000000E0434E5040000000C09FC064C0000000800C4E504000000080B6C064C000000020B74D504000000040CBC064C0000000408F4D5040000000A0E7C064C0000000005F4D504000000000D8C064C000000080334D5040000000E0EDC064C000000020134D5040000000800BC164C000000040EA4C5040000000200BC164C000000000AE4C504000000080FBC064C000000080824C504000000080DEC064C0000000603A4C5040000000E0F1C064C0000000E0CE4B504000000080ACC064C0000000E0DD4B5040000000C082C064C000000080F14B50400000002066C064C000000080E54B5040000000802AC064C0000000E0BE4B5040000000A017C064C000000060B94B504000000080EABF64C0000000C0B64B504000000040B2BF64C000000040A64B5040000000C0A0BF64C000000020A84B5040000000E082BF64C0000000C0944B50400000000071BF64C0000000605A4B50400000006061BF64C0000000E02E4B50400000000027BF64C0000000A00F4B504000000060ECBE64C000000040F04A504000000020A9BE64C0000000E0D14A504000000000B4BE64C000000080A34A504000000060AEBE64C0000000807E4A504000000000A1BE64C0000000E0614A5040000000807ABE64C0000000604F4A50400000002061BE64C0000000A0594A5040000000E047BE64C0000000E0634A5040000000800CBE64C000000060794A504000000060F4BD64C0000000008B4A504000000040D2BD64C000000040964A504000000040BDBD64C0000000E0814A504000000080C0BD64C0000000E05B4A504000000080EDBD64C000000060224A50400000006025BE64C0000000C0F64950400000006031BE64C0000000C0CF495040000000A01FBE64C000000080954950400000002006BE64C0000000806349504000000040DCBD64C0000000E03A49504000000020A6BD64C0000000E0FC485040000000006EBD64C000000060EC4850400000000037BD64C000000040E3485040000000601ABD64C000000040D7485040000000000CBD64C000000020B3485040000000E0EABC64C0000000808948504000000080D1BC64C00000008057485040000000A0BCBC64C00000004043485040000000808FBC64C00000008040485040000000A07BBC64C0000000A033485040000000C07DBC64C000000040064850400000004078BC64C000000020E1475040000000406EBC64C0000000C0DA475040000000404DBC64C000000000B1475040000000202CBC64C000000080874750400000002022BC64C0000000C0444750400000002023BC64C00000000010475040000000000CBC64C0000000E0EC46504000000020E1BB64C0000000C0BC465040000000C0BDBB64C00000006084465040000000A0A6BB64C00000002061465040000000C07BBB64C00000000031465040000000C04FBB64C000000080F94550400000000026BB64C0000000E0D0455040000000A0C9BA64C00000006080455040000000E039BA64C0000000E03C455040000000A0A5B964C0000000E0174550400000000039B964C0000000E00C45504000000020B2B864C00000008004455040000000A019B864C000000020FE445040000000A016B764C000000040FB44504000000000F9B664C0000000C0E744504000000040E5B664C0000000C0DA44504000000080D0B664C000000060C6445040000000E0DFB664C0000000C0B54450400000008014B764C000000040B04450400000008036B764C000000020A5445040000000606DB764C00000004072445040000000205EB764C0000000A0464450400000000052B764C00000006031445040000000C04EB764C0000000201B445040000000C05AB764C000000040F4435040000000A04DB764C000000080D7435040000000A01FB764C000000060CD435040000000C0DCB664C0000000C0AE435040000000A03BB664C0000000E06C435040000000E0B4B564C000000060644350400000008099B564C0000000C05F435040000000601AB564C0000000004F43504000000080E3B464C0000000A04543504000000020C8B464C00000000041435040000000A0C1B464C00000008014435040000000E0ADB464C000000080074350400000002083B464C00000008013435040000000C072B464C0000000C01C435040000000006CB464C0000000A0684350400000006092B464C0000000407B43504000000000A6B464C00000004088435040000000E0B0B464C00000002096435040000000409FB464C000000020D4435040000000C04BB464C0000000203744504000000060A1B364C000000080AA44504000000000EDB264C0000000A053455040000000C03CB264C0000000601A46504000000060EDB164C0000000A05E465040000000005AB164C000000000B94650400000006058B064C0000000C03C475040000000E0B0AF64C0000000008A4750400000000086AF64C000000000964750400000006048AF64C0000000409C47504000000060FBAE64C000000020B347504000000020B7AE64C000000000C9475040000000406CAE64C0000000C0EE475040000000A047AE64C00000002027485040000000E04CAE64C0000000204C4850400000004053AE64C0000000A0784850400000008056AE64C0000000E08E4850400000008062AE64C000000040A44850400000004056AE64C000000020CB485040000000A052AE64C000000000F14850400000008055AE64C000000080434950400000006040AE64C0000000406B4950400000004012AE64C0000000E06049504000000080F1AD64C0000000003749504000000060EFAD64C00000002028495040000000E0D1AD64C0000000A014495040000000E099AD64C0000000C0034950400000002085AD64C000000040EF4850400000006067AD64C0000000A0DB485040000000805CAD64C0000000C0CD485040000000603BAD64C000000020E04850400000006010AD64C000000000EC48504000000000D6AC64C00000006008495040000000208FAC64C0000000A04B4950400000004066AC64C000000060664950400000008049AC64C000000060964950400000006035AC64C000000080C5495040000000A02FAC64C0000000A0DC495040000000E03FAC64C0000000A00F4A5040000000A055AC64C0000000802B4A5040000000606AAC64C000000000404A50400000000088AC64C0000000A0534A504000000080AFAC64C0000000C06D4A5040000000E0D6AC64C0000000E0874A504000000080E8AC64C000000000864A50400000000004AD64C0000000E08A4A5040000000C017AD64C0000000E0974A50400000006029AD64C000000020964A50400000006036AD64C0000000E0B24A5040000000404CAD64C0000000C0CE4A5040000000404DAD64C000000020D64A5040000000E03FAD64C0000000A0F54A50400000002038AD64C0000000E0FD4A5040000000602FAD64C0000000C0FE4A5040000000A01DAD64C000000080004B5040000000200DAD64C0000000C0094B50400000004004AD64C0000000A00A4B5040000000A0F1AC64C000000000054B5040000000C0E6AC64C000000000F74A5040000000A0E4AC64C000000040E84A504000000080D7AC64C000000080CB4A504000000040B4AC64C000000000CF4A5040000000E099AC64C0000000A0D14A50400000000091AC64C000000080D24A50400000006089AC64C0000000E0DA4A5040000000A082AC64C000000080EA4A50400000006096AC64C0000000A0F74A504000000040A1AC64C000000080054B5040000000C092AC64C0000000A01D4B5040000000C09DAC64C0000000802B4B50400000002099AC64C0000000004A4B50400000008088AC64C000000040534B5040000000A089AC64C0000000A05A4B5040000000C080AC64C0000000805B4B50400000006068AC64C0000000006D4B5040000000E059AC64C000000000854B5040000000205DAC64C0000000409B4B50400000006055AC64C000000080A34B50400000006061AC64C0000000E0B84B50400000008064AC64C000000040CF4B50400000008066AC64C000000000DE4B50400000004079AC64C0000000A0E34B5040000000407AAC64C000000020EB4B5040000000607DAC64C000000040014C5040000000A08CAC64C0000000E02C4C5040000000C08EAC64C0000000C03B4C5040000000C090AC64C0000000A04A4C5040000000A09AAC64C000000020514C504000000040B7AC64C0000000405D4C5040000000E0C9AC64C0000000E0624C504000000080E6AC64C0000000206F4C504000000080F2AC64C000000080844C504000000060FCAC64C0000000008B4C5040000000E0EEAC64C000000060AA4C504000000040DDAC64C000000040AC4C5040000000A0CBAC64C000000000AE4C5040000000E08CAC64C0000000C0AC4C50400000006072AC64C000000060AF4C5040000000C055AC64C000000040A34C5040000000A033AC64C000000020AE4C50400000006011AC64C000000020B94C5040000000A009AC64C000000060C14C5040000000C001AC64C0000000C0C94C504000000000EEAB64C0000000A0BC4C504000000080D1AB64C000000080B04C5040000000A078AB64C0000000A0754C50400000004052AB64C0000000E0624C50400000004003AB64C0000000A02E4C504000000040F6AA64C0000000E0114C504000000020F3AA64C0000000A0FB4B504000000040E7AA64C000000040E64B504000000060D1AA64C000000060CA4B504000000000D6AA64C0000000C0AB4B5040000000C0DBAA64C0000000C0944B5040000000A0D9AA64C0000000E0854B5040000000A0D8AA64C0000000807E4B504000000080D6AA64C0000000A06F4B504000000040D2AA64C000000000524B504000000060C7AA64C000000000444B504000000000AEAA64C0000000004E4B504000000020B1AA64C000000040644B504000000060AAAA64C000000000744B50400000002094AA64C000000040944B5040000000808FAA64C0000000E0B24B50400000000081AA64C0000000E0CA4B50400000004086AA64C0000000E0EF4B5040000000608AAA64C0000000A00D4C5040000000808EAA64C0000000402B4C50400000008099AA64C000000040394C504000000040AEAA64C0000000A04D4C504000000000C3AA64C000000020624C504000000080E9AA64C0000000E0744C504000000060F5AA64C0000000408A4C50400000000013AB64C0000000E09D4C5040000000C026AB64C000000000AB4C5040000000E028AB64C0000000C0B94C50400000002017AB64C000000080BB4C50400000008005AB64C000000060BD4C504000000000F6AA64C0000000E0CD4C504000000000F7AA64C000000040D54C5040000000C015AB64C000000060F04C50400000006028AB64C000000000F64C5040000000C04DAB64C000000040014D5040000000C083AB64C000000080034D504000000020A9AB64C0000000C00E4D5040000000E0BCAB64C0000000C01B4D504000000060D9AB64C000000000284D504000000020ECAB64C0000000A02D4D50400000008010AC64C000000080314D50400000004017AC64C0000000E0214D5040000000001EAC64C000000020124D5040000000C024AC64C000000060024D50400000008062AC64C000000020FC4C50400000004076AC64C000000040094D5040000000806FAC64C000000000194D5040000000807CAC64C0000000C0354D5040000000E076AC64C0000000E04C4D5040000000A08BAC64C000000060614D5040000000C099AC64C000000080854D5040000000C0A5AC64C0000000E09A4D504000000060C4AC64C0000000E0B54D50400000004003AD64C000000020B74D5040000000C01EAD64C0000000E0BB4D5040000000A027AD64C000000000BB4D5040000000602EAD64C000000040AB4D50400000008024AD64C0000000C0A44D50400000006023AD64C0000000609D4D50400000000028AD64C0000000C07E4D5040000000201FAD64C0000000A07F4D5040000000A02DAD64C0000000A0674D5040000000403EAD64C0000000805E4D5040000000203DAD64C000000000574D50400000004067AD64C0000000C0434D5040000000006FAD64C0000000803B4D5040000000807DAD64C000000080234D5040000000E08BAD64C0000000600B4D5040000000A091AD64C000000040F44C5040000000E09DAD64C000000080CD4C504000000060A0AD64C000000020A04C5040000000E0ADAD64C0000000A0804C504000000080A8AD64C0000000A05B4C504000000020AEAD64C000000060444C504000000000A0AD64C000000040204C5040000000E09CAD64C0000000000A4C5040000000A097AD64C0000000E0E44B5040000000409CAD64C000000060C64B5040000000E0A3AD64C000000020BE4B5040000000A0A9AD64C000000000A74B5040000000A09EAD64C000000000994B504000000020ACAD64C000000080794B5040000000E0A8AD64C000000060634B5040000000A0A4AD64C0000000A0454B5040000000A097AD64C0000000E0284B5040000000409DAD64C0000000C0114B5040000000E0A1AD64C000000040F34A504000000080A8AD64C000000080E34A5040000000C0BEAD64C000000020C34A504000000020D7AD64C0000000C0B14A5040000000C0DDAD64C000000000A24A504000000060EEAD64C0000000C0984A50400000000000AE64C000000000974A50400000002022AE64C0000000008C4A50400000006044AE64C000000000814A5040000000C05DAE64C000000000774A50400000002078AE64C000000040744A5040000000609CAE64C000000020784A504000000040D1AE64C0000000C0724A504000000060FDAE64C0000000406E4A50400000006029AF64C0000000E0694A5040000000A04BAF64C0000000E05E4A5040000000405DAF64C0000000205D4A5040000000A077AF64C0000000605A4A5040000000E08FAF64C0000000E0484A5040000000A097AF64C000000080404A5040000000A0C2AF64C0000000A0344A504000000040D5AF64C0000000403A4A504000000040D4AF64C0000000E0324A50400000006002B064C0000000403D4A5040000000400CB064C0000000C0434A50400000002016B064C0000000404A4A5040000000C027B064C000000080484A50400000002042B064C0000000C0454A5040000000A05DB064C0000000804A4A50400000000082B064C0000000404E4A5040000000E0B7B064C000000060504A504000000040DDB064C0000000805B4A504000000040DEB064C000000000634A504000000060E0B064C0000000C0714A5040000000C0D8B064C0000000207A4A5040000000E0DAB064C0000000E0884A504000000060CBB064C000000080994A5040000000A0B8B064C000000000944A504000000080C0B064C0000000A08B4A5040000000A0B7B064C0000000808C4A5040000000C0ADB064C000000000864A5040000000209BB064C000000060804A50400000004093B064C0000000C0884A50400000006089B064C000000040824A5040000000A080B064C000000020834A5040000000C077B064C000000000844A50400000004067B064C0000000408D4A5040000000805FB064C000000080954A5040000000C056B064C000000060964A50400000008033B064C0000000009A4A50400000000024B064C0000000A0AA4A5040000000601DB064C000000060BA4A5040000000C00CB064C000000080C34A50400000000004B064C000000060C44A504000000020FAAF64C0000000E0BD4A504000000080E8AF64C0000000C0BF4A504000000040C5AF64C000000040C34A5040000000A0B3AF64C000000020C54A5040000000E0ABAF64C000000060CD4A504000000020A4AF64C0000000C0D54A504000000040A7AF64C000000000EC4A504000000040B2AF64C0000000E0F94A5040000000E0C3AF64C000000020F84A5040000000C0CEAF64C000000000064B5040000000C0D9AF64C000000000144B504000000060ECAF64C0000000A0194B504000000000FEAF64C0000000C0174B5040000000E006B064C0000000E0164B50400000006021B064C000000020144B50400000002049B064C000000020F24A5040000000E050B064C0000000C0E94A5040000000C04FB064C000000060E24A5040000000A059B064C0000000E0E84A5040000000406BB064C000000000E74A50400000006098B064C000000000EA4A504000000020ACB064C000000000F74A5040000000E0BEB064C0000000A0FC4A5040000000E0BFB064C000000000044B504000000080DCB064C000000020104B5040000000E0F5B064C000000000064B5040000000803EB164C0000000A00D4B5040000000C079B164C0000000C0344B504000000040A0B164C000000060474B504000000000B4B164C000000060544B5040000000E0D3B164C0000000C0764B5040000000A0E7B164C0000000C0834B5040000000C014B264C0000000A0864B50400000000037B264C0000000A07B4B5040000000405BB264C0000000607F4B5040000000E077B264C0000000808B4B50400000008095B264C0000000009F4B5040000000C0B7B264C000000000944B504000000040BEB264C000000040844B504000000000BAB264C0000000A0664B5040000000C0B5B264C000000000494B5040000000A0B4B264C000000080414B5040000000807CB264C0000000C0304B5040000000604FB264C0000000E02D4B5040000000C006B264C000000040264B504000000020EAB164C0000000201A4B504000000040DFB164C0000000400C4B5040000000A0CDB164C0000000000E4B5040000000C0B8B164C0000000A0F94A504000000000A5B164C0000000A0EC4A5040000000209BB164C000000020E64A5040000000E097B164C0000000E0CF4A5040000000C095B164C000000000C14A504000000040A5B164C000000060B04A504000000000ADB164C000000020A84A5040000000A0BEB164C000000040A64A5040000000E0E2B164C000000020AA4A50400000002011B264C000000060B44A5040000000E019B264C000000080B34A5040000000802BB264C0000000A0B14A5040000000E044B264C000000080A74A5040000000A04CB264C0000000409F4A5040000000405EB264C0000000609D4A50400000000066B264C000000020954A5040000000C06EB264C000000020944A50400000000093B264C000000000984A504000000080ADB264C000000040954A504000000020BFB264C000000060934A5040000000C0C6B264C0000000208B4A5040000000E0F2B264C0000000A0864A50400000000015B364C0000000807B4A50400000008025B364C000000060724A5040000000C048B364C0000000A06E4A5040000000E069B364C0000000405C4A504000000020BAB364C0000000805B4A5040000000C001B464C0000000A05B4A5040000000401EB464C0000000A0674A50400000008041B464C000000000644A5040000000C064B464C000000060604A5040000000E091B464C000000020634A504000000040ACB464C000000060604A5040000000A0C5B464C000000040564A5040000000C0E7B464C0000000204B4A50400000002023B564C0000000E0354A5040000000E02AB564C0000000A02D4A50400000004044B564C000000060234A50400000000058B564C000000060304A5040000000E06CB564C0000000E0444A5040000000C081B564C000000040594A50400000008095B564C000000040664A5040000000C0A2B564C000000000834A5040000000A0B7B564C000000060974A504000000000B1B564C000000020A74A504000000060AAB564C0000000C0B64A504000000080B6B564C000000020CC4A504000000080B7B564C000000080D34A5040000000A0C3B564C0000000E0E84A504000000060CCB564C0000000E0E74A504000000000DEB564C000000020E64A5040000000400CB664C000000060F04A5040000000002AB664C0000000E0034B5040000000E03EB664C000000040184B5040000000C048B664C0000000C01E4B5040000000C053B664C0000000A02C4B5040000000C05EB664C0000000803A4B50400000000062B664C0000000C0504B50400000002059B664C0000000A0514B5040000000C03EB664C000000060544B50400000006025B664C0000000A05E4B5040000000E013B664C000000060604B5040000000000BB664C000000060614B504000000080FAB564C0000000806A4B504000000080FBB564C000000000724B50400000008005B664C000000080784B5040000000400EB664C000000080774B50400000000021B664C0000000207D4B50400000004024B664C000000060934B5040000000C01EB664C000000080AA4B50400000000022B664C0000000C0C04B50400000002023B664C000000020C84B5040000000002DB664C0000000A0CE4B50400000006046B664C000000080C44B5040000000C055B664C0000000C0B34B50400000002065B664C000000020A34B5040000000006EB664C000000040A24B5040000000A095B664C000000040BC4B504000000080A9B664C000000040C94B504000000040B2B664C000000040C84B5040000000A0CBB664C000000020BE4B5040000000C0E2B664C000000020A54B5040000000E0F9B664C0000000208C4B5040000000800BB764C0000000408A4B50400000000031B764C000000060954B5040000000A04EB764C0000000E0A84B5040000000406BB764C0000000E0B44B5040000000C09BB764C0000000E0CD4B5040000000C0C6B764C000000020FE4B504000000000F5B764C000000040084C5040000000A01BB864C0000000E01A4C50400000002037B864C0000000801F4C5040000000C048B864C0000000A01D4C50400000004059B864C000000060144C5040000000807CB864C0000000A0104C504000000020B9B864C0000000C0024C5040000000A0EBB864C000000060EE4B5040000000E039B964C0000000A0DE4B50400000002093B964C0000000C0DC4B504000000020BFB964C000000000D84B5040000000C0FAB964C0000000E0FE4B5040000000204ABA64C0000000C0324C50400000000094BA64C000000080414C5040000000A0E6BA64C0000000404F4C5040000000801BBB64C0000000C0494C5040000000004DBB64C0000000E02D4C50400000006088BB64C000000040DC4B5040000000C099BB64C0000000409E4B504000000040C1BB64C0000000A03F4B504000000020C2BB64C0000000A0CE4A504000000000C2BB64C000000080924A5040000000C0B4BB64C0000000C0754A50400000008092BB64C0000000C0444A5040000000E03EBB64C0000000802F4A50400000006003BB64C0000000C0084A5040000000C0DBBA64C0000000E0EE495040000000A0BABA64C000000020C549504000000040ABBA64C0000000A099495040000000209FBA64C000000060844950400000006061BA64C0000000C04E495040000000206ABA64C000000080114950400000004081BA64C000000080F848504000000080BCBA64C000000020E34850400000008035BB64C00000008003495040000000E08FBB64C00000002045495040000000E0E5BB64C000000060A5495040000000600CBC64C0000000C0B74950400000004083BC64C000000040C949504000000000C3BC64C000000080D1495040000000A0E9BC64C0000000E0E3495040000000000DBD64C0000000401C4A5040000000E015BD64C0000000A0574A5040000000800FBD64C000000080A34A50400000006017BD64C000000060D74A50400000006042BD64C000000080074B5040000000406BBD64C0000000C0284B5040000000E0B3BD64C000000000304B504000000040CDBD64C0000000C0254B504000000080FCBD64C000000000FB4A5040000000801EBE64C0000000E0EF4A50400000004051BE64C000000080174B5040000000E06ABE64C000000080494B5040000000A092BE64C000000060634B504000000080D2BE64C0000000806B4B5040000000400FBF64C0000000A0994B5040000000604FBF64C000000000DE4B5040000000A070BF64C0000000A0074C504000000060A2BF64C0000000E0274C504000000020D5BF64C0000000A04F4C5040000000A064C064C0000000608B4C504000000020B3C064C000000080B74C504000000080AAC064C0000000C0F44C50400000004083C064C000000060534D5040000000E04FC064C0000000A09C4D5040000000E041C064C000000000F14D50400000000041C064C0000000C0254E50400000006058C064C0000000E0484E50400000000073C064C000000040824E5040000000E0B9C064C0000000E0B64E5040000000C0D5C064C0000000A0F74E504000000080D1C064C000000020164F504000000040C1C064C0000000C05B4F504000000060DEC064C0000000E0A34F5040000000C000C164C0000000E0D44F5040000000803BC164C000000020F44F5040000000C05CC164C0000000C01D505040000000407FC164C0000000A04E505040000000609FC164C0000000C07050504000000080F3C164C0000000C085505040000000401AC264C000000020985050400000002038C264C000000080AB505040000000005EC264C0000000C0F2505040000000E096C264C0000000603F5150400000006016C364C000000040845150400000002065C364C000000060B051504000000080C5C364C0000000A0DA515040000000401CC464C0000000A03A5250400000008046C464C0000000206352504000000060F2C464C000000020A35250400000002018C564C000000020AE525040000000001EC664C000000000285350400000006001C764C0000000C070535040000000E092C764C000000080B3535040000000002FC864C0000000E0C753504000000080B2C864C0000000C0B1535040000000E0FDC864C000000080C75350400000000026C964C000000020E1535040000000A086C964C0000000200B54504000000060C0C964C0000000E0225450400000002042CA64C0000000003A545040000000C088CA64C0000000003254504000000020EACA64C000000020275450400000004044CB64C0000000C0EF535040000000607DCB64C000000020CB5350400000000092CB64C000000040A3535040000000809CCB64C0000000C074535040000000C08DCB64C0000000C0505350400000002076CB64C0000000C02D5350400000006049CB64C000000080F6525040000000E035CB64C0000000E0B4525040000000401ECB64C0000000E091525040000000E0F7CA64C0000000C04A52504000000020C1CA64C0000000200D52504000000000C4CA64C000000020E7515040000000C0D5CA64C000000020E5515040000000A024CB64C000000000115250400000002059CB64C0000000E03F525040000000C077CB64C0000000608F525040000000E0B9CB64C0000000C0DA525040000000C0F7CB64C0000000E044535040000000E06ACC64C0000000E0A8535040000000E0BFCC64C0000000C0F9535040000000206CCD64C00000004039545040000000200FCE64C000000080AE54504000000080C1CE64C0000000C01255504000000000ADCF64C000000080525550400000006036D164C000000040AD555040000000606AD264C000000020B7555040000000C0AAD264C0000000C0BE5550400000008059D264C000000060F5555040000000A0FED164C0000000C0F05550400000000088D164C0000000C0E755504000000040FDD064C0000000E0D155504000000020BED064C0000000A0D1555040000000C060D064C000000020BE555040000000203CD064C0000000C0BA555040000000C00FD164C0000000200C56504000000040D3D164C00000000032565040000000E04ED264C0000000A058565040000000E010D364C0000000E0AB565040000000806FD364C0000000A0C6565040000000A0A4D364C000000080C056504000000060C9D364C0000000E0C3565040000000E02FD464C000000060A15650400000004053D464C0000000409D5650400000006088D464C0000000209756504000000040CBD464C000000080AD5650400000006028D564C0000000C0F55650400000004075D564C00000008012575040000000A0ABD564C0000000C013575040000000C0EAD564C0000000E0135750400000006052D664C0000000A02D575040000000A0CBD664C000000020455750400000004038D764C0000000804757504000000020A6D764C00000004051575040000000A003D864C00000008064575040000000806CD864C00000008085575040000000A0D2D864C000000080CC575040000000E02ED964C000000040D8575040000000C097D964C000000020F957504000000040D8D964C0000000C000585040000000C065DA64C0000000E024585040000000601EDB64C0000000203C5850400000006049DB64C0000000802F585040000000E076DB64C0000000A031585040000000809BDB64C0000000E034585040000000E0B4DB64C0000000402A585040000000E0DADB64C0000000200058504000000040EBDB64C0000000A0F657504000000080FADB64C0000000C0E55750400000008025DC64C000000000D9575040000000006BDC64C000000000FE575040000000A094DC64C0000000E01E58504000000020D0DC64C0000000803D58504000000040F2DC64C0000000E031585040000000E024DD64C0000000C01C585040000000C05DDD64C0000000A02C585040000000A083DD64C0000000203758504000000040BBDD64C0000000A03F58504000000060C0DD64C0000000602858504000000040B1DD64C00000008004585040000000408BDD64C0000000E0F9575040000000E0F9DC64C0000000C0BF575040000000C07CDC64C00000004092575040000000401ADC64C0000000A061575040000000E0DEDB64C0000000004357504000000020BADB64C0000000C03F5750400000000098DB64C0000000604B575040000000006DDB64C000000000585750400000002042DB64C0000000A064575040000000201CDB64C0000000205A57504000000020ECDA64C0000000204957504000000020D4DA64C0000000402657504000000080D0DA64C00000000010575040000000C019DB64C000000080165750400000000046DB64C00000004011575040000000A03FDB64C000000040EC56504000000000E1DA64C0000000C0D1565040000000208BDA64C000000020B6565040000000606FDA64C0000000E0B1565040000000204DDA64C000000080BD56504000000060F3D964C000000080C05650400000004097D964C0000000C0B45650400000002028D964C0000000C0A3565040000000C0FAD864C0000000A06C5650400000000019D864C000000080FF5550400000000084D764C0000000C0E3555040000000A0D4D664C000000000CB555040000000200CD664C0000000E0875550400000004047D564C0000000E05A555040000000A0D0D464C00000000052555040000000A088D464C0000000E0525550400000008045D464C00000004071555040000000A003D464C0000000009755504000000020B0D364C0000000E0BE5550400000004034D364C000000020CD555040000000E0F3D264C000000080C555504000000020CED264C0000000C0BA555040000000C012D364C0000000006F555040000000A0B4D364C0000000A036555040000000A06AD464C0000000E00A5550400000000097D564C0000000E01C55504000000040F3D664C0000000807455504000000060FDD764C000000060C6555040000000208CD864C000000020BD555040000000C002D964C0000000C0C555504000000000F0D964C0000000E00B565040000000C0A0DA64C0000000A06056504000000020F3DB64C000000000E6565040000000809FDD64C0000000E09C575040000000A0E0DE64C0000000202458504000000040A2DF64C0000000006F58504000000020E6E064C0000000E0CF585040000000E010E264C000000040065950400000008099E264C0000000600C595040000000C084E364C0000000000E595040000000204AE464C000000000055950400000008080E464C00000000006595040000000C0D2E464C0000000000B59504000000020CBE564C00000004056595040000000405AE664C00000002081595040000000A0BBE664C00000002075595040000000606BE764C0000000E05759504000000000FDE764C0000000A05C595040000000A0BEE864C00000000072595040000000C0A7E964C00000002099595040000000402AEA64C0000000A0AE59504000000060B4EA64C000000080BB595040000000C065EB64C000000060DA59504000000080DBEB64C0000000C0DA5950400000004064EC64C000000040E0595040000000C0C0EC64C000000060EB595040000000E01FED64C000000040055A5040000000E065ED64C0000000C0295A504000000060E8ED64C0000000203F5A5040000000C00FEE64C0000000E0505A5040000000407DEE64C000000000875A504000000000B9EE64C000000040A55A504000000040FEEE64C000000040F75A50400000008045EF64C000000020235B5040000000608EEF64C000000060565B504000000000FCEF64C0000000C08C5B50400000006072F064C0000000A0C15B504000000000D7F064C000000000F95B504000000040E1F064C000000040FF5B5040000000A0DBF164C000000000B35C50400000006065F264C000000000ED5C504000000000EBF264C0000000E0105D5040000000A049F364C000000000585D5040000000606EF364C000000020BD5D5040000000E091F364C0000000E01A5E5040000000E0C2F364C000000020605E50400000006040F464C000000000BA5E5040000000C0EFF464C0000000A02B5F5040000000E061F564C0000000A0775F5040000000A015F664C000000060FF5F5040000000A074F664C00000004046605040000000406BF764C000000080AE605040000000E05DF964C000000080676150400000008069FA64C000000000DC615040000000A0A4FA64C0000000E05462504000000000D9FA64C000000000A9625040000000E036FB64C000000060E8625040000000C003FC64C0000000E02F635040000000E083FC64C00000004063635040000000A094FD64C0000000E0BF63504000000040EBFE64C0000000E00B645040000000E074FF64C00000006010645040000000E0E3FF64C00000008018645040000000802A0065C0000000803C64504000000040960065C00000004063645040000000E05E0165C0000000A0C164504000000020F80165C0000000401765504000000060340265C00000008062655040000000608C0265C000000000DF65504000000060BF0265C0000000E058665040000000A0AE0265C0000000209066504000000060990265C0000000A0DE66504000000040E40265C0000000204667504000000020480365C000000060D0675040000000E0AE0365C00000004069685040000000C0F30365C0000000200E695040000000E0F20365C0000000809669504000000040C80365C0000000A0336A5040000000209F0365C000000020D86A5040000000E0270365C0000000E0F06B5040000000C0E80265C000000020546C5040000000201C0265C0000000C0D16C504000000080F20065C000000040A76D5040000000802E0065C000000080236E504000000080160065C0000000C0356E5040000000E001FF64C0000000A0BC6E5040000000C05BFE64C000000080166F5040000000E0F5FC64C000000000D56F504000000080B4FB64C0000000C0337050400000002050FB64C0000000A06670504000000020EAFA64C000000020927050400000006074FA64C0000000C0997050400000000035FA64C000000060CF705040000000E053FA64C0000000C07F70504000000060E1FA64C00000008003705040000000005BFB64C0000000A0AF6F50400000000094FB64C0000000E0896F504000000060AFFB64C000000000596F5040000000C090FB64C0000000E0186F50400000004082FB64C000000080FC6E5040000000C082FB64C000000000CF6E5040000000C0B2FB64C000000080AA6E5040000000A0FDFB64C000000080826E5040000000C02BFC64C000000000846E5040000000403CFC64C0000000607A6E50400000004034FC64C000000060B06E50400000000040FC64C000000000BE6E50400000004065FC64C0000000C0C06E5040000000209EFC64C0000000009B6E5040000000A0CFFC64C0000000E07D6E5040000000202FFD64C000000040626E5040000000407EFD64C000000060506E504000000000E4FD64C0000000E0246E5040000000A009FE64C000000020FA6D5040000000A0F0FD64C000000080D76D504000000060A4FD64C000000020F86D50400000006074FD64C0000000C01C6E5040000000A050FD64C000000060216E5040000000A040FD64C0000000A0FD6D5040000000605CFD64C0000000409F6D504000000040E4FD64C0000000A0676D5040000000A064FE64C000000060386D504000000080C5FE64C000000020246D5040000000C017FF64C000000080F36C5040000000E06FFF64C000000060E06C5040000000C0DFFF64C0000000E0BA6C5040000000C02E0065C000000000A96C5040000000605B0065C000000020A36C5040000000A09B0065C0000000C0746C504000000020CA0065C0000000C0486C504000000020F10065C000000060256C5040000000E0190165C0000000E0DB6B504000000060260165C0000000808E6B504000000020280165C000000060686B5040000000A0250165C0000000202C6B504000000000320165C0000000E0DE6A5040000000C06A0165C000000000B96A504000000060AF0165C0000000E0A06A5040000000E0D10165C000000040676A504000000000B60165C000000000366A5040000000209A0165C0000000A0046A5040000000C0AD0165C000000040DC69504000000000B70165C0000000A0AD69504000000060E40165C0000000C04C69504000000000FE0165C0000000601469504000000080E30165C000000080EA68504000000080860165C0000000C0B268504000000080EB0065C0000000C055685040000000002C0065C0000000605868504000000020230065C0000000805968504000000000BBFF64C00000006076685040000000C07AFF64C0000000A0A4685040000000C046FF64C000000020B3685040000000002CFF64C0000000A0B66850400000004003FF64C00000002000695040000000A093FE64C000000080256950400000008041FE64C000000020566950400000008013FE64C0000000805469504000000080B7FD64C000000080516950400000000091FD64C00000006047695040000000A080FD64C00000002051695040000000607DFD64C0000000C06F695040000000209FFD64C00000004091695040000000E0BAFD64C000000080C2695040000000A09FFD64C000000080F3695040000000C096FD64C0000000C0F4695040000000E00AFD64C000000020166A504000000080F1FC64C000000000216A5040000000006DFC64C0000000E0396A5040000000803EFC64C0000000C0656A50400000000037FC64C0000000406E6A5040000000A00EFC64C0000000408A6A5040000000E0D2FB64C000000020A16A504000000000C2FB64C000000060D86A504000000040A7FB64C0000000E0DB6A50400000000094FB64C0000000C0D66A5040000000A05BFB64C0000000E0CE6A5040000000C059FB64C000000000F56A5040000000C038FB64C000000060086B5040000000C022FB64C0000000A0F46A50400000008006FB64C0000000C0F06A504000000020BFFA64C000000020FA6A504000000080A8FA64C0000000C0136B5040000000E09AFA64C0000000402C6B504000000080A0FA64C0000000C0496B5040000000E0D8FA64C000000080516B50400000004008FB64C0000000805A6B5040000000C0C3FA64C000000080726B50400000006068FA64C000000040A46B50400000008020FA64C0000000E0DA6B5040000000A002FA64C0000000800D6C504000000020F3F964C000000060256C504000000080C5F964C0000000E06E6C504000000020A1F964C000000000A16C50400000002090F964C000000020D86C50400000008096F964C0000000802A6D5040000000A0BAF964C000000040886D504000000000E2F964C000000040C76D504000000060C2F964C000000000E26D5040000000A088F964C0000000C0D26D5040000000E02EF964C0000000E07B6D5040000000A01BF964C0000000E0766D50400000006088F864C000000020736D50400000008081F764C0000000E0506D5040000000E038F764C0000000E0756D5040000000E0F7F664C0000000C0806D504000000060B0F664C0000000E0896D50400000008034F664C0000000208E6D504000000060CDF564C000000060906D5040000000C099F564C0000000208F6D50400000008066F564C0000000008E6D50400000004023F564C0000000C0816D5040000000A0E0F464C0000000A0786D5040000000E0B3F464C000000000706D5040000000A060F464C0000000806B6D5040000000C005F464C0000000606F6D50400000008088F364C0000000407F6D50400000002054F364C0000000808D6D5040000000C01BF364C000000080856D504000000040F5F264C0000000407B6D5040000000E089F264C0000000C0886D50400000004037F264C000000000B96D50400000008017F264C0000000C0D36D5040000000C0C0F164C0000000C0ED6D5040000000C096F164C000000040026E5040000000404AF164C000000080226E5040000000E0ADF064C0000000E0816E50400000000007F064C0000000E0DA6E5040000000E0EEEF64C000000000ED6E5040000000A0ACEF64C000000080136F504000000020B6EF64C000000040476F5040000000E0CEEF64C0000000006A6F5040000000E0F1EF64C000000000936F504000000000F3EF64C0000000A0FC6F504000000080CDEF64C0000000005C705040000000A095EF64C0000000E088705040000000407BEF64C000000020C1705040000000208BEF64C0000000E0E470504000000000E4EF64C000000020077150400000002009F064C0000000200A715040000000C038F064C00000004013715040000000E066F064C00000000015715040000000A060F064C0000000E024715040000000A036F064C000000060397150400000000014F064C000000020457150400000004013F064C0000000A0727150400000004096F064C0000000808071504000000000EBF064C0000000A08C715040000000E020F164C0000000E08571504000000020FFF064C0000000406471504000000060DDF064C0000000A04271504000000000D3F064C0000000603C715040000000E011F164C0000000803471504000000080C8F164C0000000A06171504000000040F3F164C00000002082715040000000E0F3F164C000000000B771504000000080F1F164C0000000603F725040000000400AF264C0000000206272504000000020EEF164C0000000005E72504000000040F6F164C0000000608A7250400000004046F264C0000000C0AD7250400000006072F264C000000080D5725040000000E077F264C000000020F3725040000000402BF264C0000000601373504000000040C2F164C0000000C02F7350400000008027F164C0000000006973504000000000F3F064C0000000207773504000000020BDF064C0000000E07D735040000000C08AF064C0000000E0657350400000004052F064C0000000E05D735040000000402EF064C00000006062735040000000A022F064C0000000A054735040000000E000F064C00000002033735040000000A0DBEF64C00000004030735040000000A0FEEE64C0000000802D7350400000006070EE64C0000000C046735040000000404FEE64C0000000005A735040000000A035EE64C0000000C0647350400000008018EE64C0000000208E735040000000C060EE64C000000020BA7350400000004050EE64C0000000C0C37350400000004080EE64C0000000C00174504000000060D0EE64C00000004025745040000000C043EF64C0000000400F745040000000E0A9EF64C0000000A04674504000000080E6EF64C0000000E064745040000000401AF064C00000004084745040000000802DF064C00000006089745040000000206BF064C0000000207A74504000000000C5F064C0000000E06E74504000000020FCF064C0000000806F745040000000E010F164C0000000007C74504000000060EBF064C000000080DB745040000000404AF064C0000000A0247550400000006018F064C00000008041755040000000002DEF64C000000080B97550400000004052EE64C00000000028765040000000A0C9ED64C0000000C093765040000000A07CEC64C00000002054775040000000E0CCEA64C0000000405578504000000080DBE864C0000000C0B87950400000000091E864C0000000A0E77950400000008027E864C0000000A0037A504000000060E4E764C000000000F579504000000060E5E764C000000080C7795040000000C00BE864C0000000209D795040000000A057E864C0000000A07579504000000060ACE864C0000000204D79504000000020C2E864C0000000402C795040000000009BE864C000000000ED785040000000005EE864C0000000A099785040000000A02BE864C0000000A0817850400000008070E764C0000000A03D78504000000020F3E664C000000080EA77504000000080EDE664C00000000098775040000000A0E6E664C0000000203E77504000000000DCE664C00000000003775040000000A089E664C00000006005775040000000001BE664C0000000A00377504000000060EBE564C000000040FA76504000000060D5E564C000000040E6765040000000C0B8E564C000000040AD765040000000807DE564C000000020967650400000008039E564C000000000B5765040000000C01FE564C0000000A0BF765040000000C0F2E464C000000020C576504000000000E3E464C000000040A176504000000020F1E464C0000000E08876504000000020E0E464C0000000805D76504000000080A2E464C0000000806C765040000000805EE464C0000000608B765040000000A01BE464C0000000A0B176504000000000D5E364C0000000A0C1765040000000A0A1E364C0000000E0D6765040000000C070E364C0000000E0FA7650400000000025E364C000000040227750400000006041E264C000000060637750400000006041E164C000000000A0775040000000402FE164C000000020A27750400000008007E164C000000020C57750400000004037E064C0000000E0747850400000004025E064C0000000E0AB785040000000600AE064C0000000C018795040000000408CDF64C00000008091795040000000602ADF64C000000080D979504000000020D9DE64C000000000E3795040000000A086DE64C000000020E5795040000000A06BDE64C000000060E8795040000000E04DDE64C0000000C0DC795040000000A02DDE64C000000020F7795040000000202BDE64C0000000401D7A50400000000038DE64C000000060327A5040000000E032DE64C0000000A0497A5040000000602CDE64C000000080597A50400000004027DE64C0000000C0707A5040000000800DDE64C0000000607B7A5040000000C0FCDD64C0000000E0847A5040000000A0EEDD64C0000000409D7A504000000060E9DD64C000000080B47A5040000000E0C7DD64C000000080C77A5040000000C0B9DD64C0000000E0DF7A5040000000408BDD64C0000000A0127B50400000004082DD64C0000000A0137B5040000000605FDD64C0000000401F7B50400000008018DD64C0000000202F7B5040000000E00CDD64C000000060217B50400000004029DD64C0000000C0F07A5040000000003ADD64C000000040E77A50400000004051DD64C0000000E0CD7A5040000000C072DD64C0000000C0BA7A50400000002070DD64C000000000AC7A5040000000A06DDD64C0000000409D7A5040000000C060DD64C000000000887A50400000000059DD64C000000080907A5040000000203FDD64C0000000209B7A5040000000C026DD64C000000020AD7A5040000000C01DDD64C000000020AE7A50400000002005DD64C000000020C07A504000000060DEDC64C000000060EA7A5040000000C0B7DC64C0000000A0147B5040000000C05EDC64C0000000A0267B50400000002022DC64C0000000C03C7B504000000040FFDB64C000000060487B504000000040E0DB64C0000000406A7B504000000060D3DB64C0000000008A7B504000000040CADB64C0000000008B7B504000000020E0DB64C0000000209F7B5040000000A0FCDB64C000000060A37B50400000004011DC64C000000000B07B50400000000015DC64C000000040C67B5040000000A017DC64C000000020D57B50400000006012DC64C000000060EC7B5040000000A029DC64C0000000E0077C50400000002039DC64C0000000C02B7C5040000000E05BDC64C000000020557C5040000000408EDC64C0000000606D7C5040000000A0C0DC64C0000000C0857C504000000060FDDC64C000000080A47C5040000000A01DDD64C0000000E0BE7C5040000000200EDD64C0000000E0CF7C50400000008021DD64C000000020D57C50400000000059DD64C000000040D67C5040000000209CDD64C000000000E57C5040000000A0C1DD64C000000020E87C504000000080CEDD64C000000060FD7C504000000000B6DD64C0000000400F7D5040000000809DDD64C000000040217D5040000000C0A7DD64C0000000A0277D504000000020D1DD64C000000000417D504000000080E4DD64C000000040467D50400000008003DE64C000000040597D5040000000800CDE64C000000040587D5040000000E00DDE64C0000000A05F7D50400000004014DE64C0000000A0847D5040000000A01EDE64C0000000008B7D5040000000003BDE64C0000000408F7D5040000000204DDE64C0000000208D7D50400000004071DE64C0000000E0887D5040000000E0BADE64C0000000C0877D504000000000ECDE64C0000000C0987D5040000000E036DF64C0000000009F7D50400000006072DF64C000000040B67D50400000008084DF64C000000020B47D5040000000A077DF64C0000000E0D37D5040000000E066DF64C000000040127E50400000002049DF64C0000000803B7E5040000000E028DF64C000000000567E5040000000A0FBDE64C0000000405B7E5040000000C0ACDE64C0000000A0737E5040000000008ADE64C0000000607F7E5040000000E04BDE64C0000000208E7E5040000000A0F6DD64C000000060B67E504000000000BFDD64C000000020EA7E5040000000E065DD64C000000000317F5040000000A038DD64C0000000606B7F5040000000E0F7DC64C000000040A07F504000000040AADC64C000000000C07F50400000004075DC64C0000000A0CD7F5040000000E03EDC64C000000000D47F5040000000E009DC64C0000000C0E17F5040000000C0EEDB64C0000000E0E47F504000000020C0DB64C0000000A017805040000000E08EDB64C0000000803B805040000000E06FDB64C0000000605D805040000000A05DDB64C0000000605F805040000000802CDB64C00000006083805040000000C00ADB64C00000006096805040000000E0E7DA64C000000000A2805040000000C0DEDA64C000000000A380504000000040B0DA64C0000000E0A0805040000000C070DA64C000000040A88050400000008043DA64C000000060AD805040000000001EDA64C000000020AA8050400000000008DA64C00000000096805040000000800EDA64C000000020868050400000006028DA64C0000000A07B8050400000000041DA64C0000000A069805040000000C074DA64C0000000A05480504000000000B3DA64C0000000E04580504000000080C2DA64C0000000003580504000000060D3DA64C0000000802B80504000000040EDDA64C0000000E020805040000000600CDB64C000000020FF7F5040000000C02CDB64C0000000C0E47F5040000000A046DB64C000000020DA7F5040000000808CDB64C0000000E0C27F5040000000409DDB64C000000060B97F504000000060BCDB64C0000000A0977F50400000006007DC64C000000020697F5040000000400FDC64C0000000A0607F5040000000402EDC64C0000000E03E7F50400000004037DC64C0000000C03D7F5040000000403BDC64C0000000201F7F5040000000802FDC64C000000060117F5040000000602ADC64C0000000C0F37E5040000000401CDC64C000000020D77E5040000000C00CDC64C000000020B37E5040000000C0EDDB64C000000020A07E504000000020D9DB64C000000060937E50400000008098DB64C000000060937E5040000000E04ADB64C0000000207E7E5040000000E022DB64C0000000206C7E5040000000C0FEDA64C000000060707E5040000000C087DA64C000000080767E5040000000E038DA64C0000000C08E7E50400000006013DA64C0000000808B7E504000000020F8D964C0000000A08E7E504000000080DAD964C000000000837E504000000000B5D964C0000000C07F7E50400000004062D964C0000000C0817E5040000000805AD964C0000000408A7E5040000000E060D964C000000040AF7E5040000000E07FD964C000000060C27E5040000000408AD964C0000000C0C87E504000000000A4D964C000000020BE7E5040000000E0B0D964C000000060D37E5040000000C0A2D964C0000000A0EB7E5040000000A07AD964C0000000800E7F5040000000008AD964C000000080327F5040000000A095D964C000000040407F504000000080A2D964C000000060557F5040000000C0C6D964C000000040517F504000000040F5D964C000000040887F5040000000200BDA64C0000000609C7F5040000000801EDA64C0000000C0A17F5040000000003BDA64C000000000A67F5040000000206CDA64C000000000B77F5040000000807BDA64C000000000DB7F50400000008072DA64C000000000DC7F50400000002064DA64C000000060F47F50400000004045DA64C000000040E17F50400000002033DA64C000000060E37F50400000004003DA64C0000000C0D97F504000000040FAD964C0000000E0DA7F504000000060C6D964C0000000E0EF7F5040000000E093D964C0000000600C805040000000E07DD964C0000000202D805040000000006DD964C0000000A0368050400000008062D964C000000020658050400000008055D964C0000000E084805040000000C033D964C0000000E097805040000000E019D964C000000060A28050400000008006D964C0000000209D80504000000020EFD864C000000060B680504000000000F3D864C0000000A0CC80504000000080F1D864C000000020FA805040000000E0F2D864C00000008001815040000000000AD964C0000000001D8150400000006014D964C00000006023815040000000601DD964C00000006022815040000000A02FD964C00000004020815040000000C041D964C0000000401E8150400000006056D964C0000000E02A815040000000205AD964C00000002041815040000000C053D964C000000000518150400000002044D964C0000000E061815040000000002ED964C0000000A0828150400000004026D964C0000000208B8150400000000018D964C000000060A381504000000060FFD864C000000060B581504000000080D0D864C000000000E881504000000040A8D864C0000000E00A8250400000006070D864C0000000A03E825040000000203FD864C00000008062825040000000A01ED864C0000000E07C825040000000C0E6D764C000000080B082504000000080BED764C000000060D38250400000004078D764C0000000601F8350400000006040D764C0000000205383504000000040EDD664C0000000E08983504000000040B0D664C0000000E09F835040000000E06DD664C000000040CD8350400000006019D664C0000000A0FC835040000000E0D1D564C00000002041845040000000E0A2D564C0000000C073845040000000005AD564C0000000E0B08450400000004027D564C000000040CD84504000000020E1D464C000000060E484504000000060AED464C0000000C000855040000000607AD464C0000000C0158550400000002016D464C0000000E05585504000000040BCD364C0000000809C8550400000008078D364C000000060C28550400000004029D364C000000060DA855040000000009ED264C0000000C00F865040000000008DD264C000000040198650400000002026D264C0000000804A865040000000200CD264C0000000005586504000000020F2D164C0000000805F8650400000004069D164C0000000A0A386504000000020DFD064C000000040E08650400000002033D064C0000000E02F8750400000004088CF64C0000000C0868750400000008011CF64C0000000C0C8875040000000C067CE64C000000000278850400000008008CE64C0000000C04F88504000000080CCCD64C0000000006D885040000000606ECD64C0000000209D885040000000801CCD64C000000020A688504000000000E7CC64C000000080B388504000000080D3CC64C000000020AE88504000000040C9CC64C0000000A0A7885040000000E0BECC64C000000040A188504000000020AFCC64C000000020B2885040000000209ECC64C000000080BB8850400000000084CC64C0000000E0C58850400000000051CC64C000000020E28850400000004030CC64C000000060FC88504000000000FCCB64C00000004011895040000000204ACB64C0000000A077895040000000E063CA64C0000000E0F28950400000002084C964C0000000205E8A5040000000C0C2C864C000000060A08A5040000000C06EC864C0000000E0D68A504000000020FEC764C0000000C0088B5040000000E0C9C764C0000000601D8B5040000000C077C764C000000040268B5040000000A036C764C0000000C0258B5040000000E010C764C000000040228B5040000000E0D8C664C0000000A0208B5040000000C0A7C664C0000000400F8B5040000000607EC664C000000080F58A5040000000E03AC664C000000020E68A504000000020AFC564C0000000A0A98A5040000000204FC564C0000000A0958A50400000006001C564C0000000C07F8A504000000060B2C464C000000080628A5040000000A075C464C000000040438A5040000000A04DC464C0000000E0308A5040000000C026C464C0000000E0258A50400000004013C464C000000060208A504000000020CBC364C000000040F3895040000000008CC364C000000020C58950400000004037C364C0000000A08289504000000000EFC264C0000000805589504000000060DAC264C00000008048895040000000A0C4C264C00000004034895040000000C0BEC264C0000000200F89504000000000B2C264C0000000E0F9885040000000E0B0C264C000000060F2885040000000A0C8C264C000000040D988504000000020DCC264C0000000C0DE88504000000040DDC264C000000020E6885040000000C0F9C264C0000000C0EA885040000000402DC364C0000000000B8950400000002043C364C0000000401F8950400000004074C364C0000000C030895040000000C096C364C0000000605A895040000000C0B5C364C0000000A06D895040000000A0C3C364C0000000608A895040000000E0ECC364C000000040A48950400000004000C464C0000000C0A9895040000000A01BC464C0000000C0A6895040000000E02DC464C0000000E0A48950400000002051C464C00000008099895040000000206AC464C0000000C087895040000000E081C464C0000000A06E895040000000A088C464C0000000C05E8950400000004086C464C00000000050895040000000009EC464C0000000C03689504000000020B8C464C0000000802C89504000000000C8C464C0000000C01B89504000000020D1C464C0000000C01A895040000000E0D1C464C0000000C0E588504000000000BCC464C000000080D188504000000040A6C464C000000040BD8850400000002086C464C000000060A28850400000000066C464C0000000A087885040000000E015C464C0000000E06288504000000080E2C364C0000000A042885040000000C06CC364C0000000601A8850400000002030C364C000000020FB875040000000A0D4C264C000000060C8875040000000C076C264C0000000E086875040000000E040C264C0000000C057875040000000002AC264C0000000003C875040000000E0F8C164C0000000A02A87504000000040DBC164C0000000A01E8750400000000098C164C0000000200F875040000000607BC164C0000000800A875040000000803AC164C0000000E009875040000000C0FAC064C00000008010875040000000E057C064C00000002029875040000000E00DC064C0000000602987504000000040AFBF64C0000000A01C8750400000000053BF64C0000000C01E875040000000E0EEBE64C00000004029875040000000406FBE64C0000000A036875040000000A0E6BD64C0000000C0448750400000004068BD64C0000000805987504000000040BCBC64C0000000E0728750400000002030BC64C0000000A06A87504000000000E6BB64C0000000C06A87504000000000ADBB64C0000000A0618750400000006076BB64C00000004067875040000000402CBB64C0000000002B875040000000E0DFBA64C0000000401C87504000000080ACBA64C0000000C0FB865040000000C053BA64C0000000A0D78650400000006020BA64C000000040B7865040000000C0D1B964C0000000A099865040000000A024B964C0000000006F86504000000080E1B864C0000000405F865040000000403BB864C000000020618650400000002032B864C00000000062865040000000C005B864C0000000206E865040000000E0C5B764C0000000A074865040000000A0B2B764C0000000006F8650400000004087B764C00000008082865040000000005CB764C0000000E095865040000000A027B764C000000060AA86504000000020FBB664C000000060B6865040000000A0E6B664C000000060A986504000000020D9B664C0000000A08C86504000000060A2B664C000000020928650400000008092B664C0000000C0A2865040000000206FB664C000000000AE865040000000E04BB664C000000020B98650400000008020B664C0000000A0CC86504000000020DCB564C0000000A0F186504000000020ABB564C0000000401C875040000000E088B564C0000000C02E875040000000C06FB564C00000006040875040000000E04FB564C0000000C0618750400000000041B564C0000000E079875040000000403BB564C000000020918750400000002022B564C0000000A0A2875040000000C006B564C000000080A5875040000000A005B564C0000000009E87504000000080F4B464C000000040A787504000000060EBB464C000000040A887504000000060DAB464C000000080B187504000000020C8B464C000000040B3875040000000E0ADB464C000000080BD875040000000E0A5B464C0000000C0C58750400000006079B464C0000000C0D1875040000000E054B464C000000080D5875040000000E05CB464C000000020CD875040000000C06BB464C000000000B5875040000000E07CB464C0000000C0AB875040000000A092B464C0000000E083875040000000C0B3B464C0000000006A875040000000C0CBB464C0000000E050875040000000A0E3B464C0000000E03787504000000080E2B464C0000000803087504000000080D9B464C00000006031875040000000A099B464C0000000C0378750400000006087B464C0000000A039875040000000206DB464C0000000C043875040000000005CB464C0000000004D8750400000000054B464C00000006055875040000000E039B464C0000000A05F875040000000C020B464C0000000207187504000000060F5B364C0000000808487504000000060EDB364C0000000E08C87504000000060E5B364C0000000409587504000000040D4B364C0000000809E87504000000020C3B364C0000000C0A787504000000000B2B364C000000000B187504000000000A9B364C0000000E0B1875040000000A096B364C0000000C0B3875040000000408AB364C0000000609E8750400000002089B364C0000000E096875040000000E07EB364C00000006090875040000000C06DB364C0000000A099875040000000C065B364C000000000A2875040000000C055B364C0000000A0B2875040000000E056B364C000000020BA8750400000000050B364C0000000E0C9875040000000204AB364C000000000E18750400000000028B364C000000080F3875040000000E006B364C0000000600D88504000000060EAB264C0000000C00888504000000020D0B264C0000000E012885040000000C0B4B264C0000000A01588504000000080A2B264C000000080178850400000006089B264C00000000029885040000000A08BB264C0000000E037885040000000A07BB264C00000008048885040000000A06CB264C0000000A060885040000000A05CB264C00000004071885040000000804BB264C0000000807A8850400000004019B264C0000000A09D8850400000002008B264C0000000E0A6885040000000C0DDB164C0000000C0C188504000000000D8B164C0000000E0D888504000000000C0B164C0000000E0F1885040000000E0A6B164C00000008003895040000000E087B164C0000000402C895040000000806CB164C0000000002F8950400000008064B164C000000040378950400000004052B164C000000000398950400000000029B164C0000000405B895040000000E017B164C00000008064895040000000C006B164C0000000C06D89504000000080F4B064C0000000A06F895040000000C0C5B064C0000000A06C89504000000040B2B064C0000000006789504000000020A8B064C00000008060895040000000C094B064C0000000E05A8950400000002077B064C0000000C04E895040000000003DB064C0000000E03D895040000000400DB064C0000000803389504000000060DDAF64C00000002029895040000000A0B6AF64C0000000E01D895040000000E08FAF64C0000000A0128950400000006073AF64C0000000E00D895040000000005FAF64C0000000C0008950400000008042AF64C000000000FC8850400000008011AF64C000000040EA88504000000000F5AE64C000000080E588504000000000ECAE64C000000060E6885040000000C0CBAE64C0000000C00789504000000020D7AE64C0000000A01589504000000060E9AE64C0000000E01389504000000080F2AE64C00000000013895040000000C0FCAE64C00000008019895040000000A024AF64C0000000402C8950400000002042AF64C00000006038895040000000407CAF64C0000000404989504000000000ABAF64C0000000404C89504000000000DDAF64C00000006065895040000000E004B064C00000002078895040000000C02DB064C000000040928950400000008054B064C0000000809D8950400000000071B064C000000040A2895040000000A096B064C000000000A689504000000020B3B064C0000000C0AA89504000000060B5B064C0000000A0B9895040000000E0C1B064C000000000CF89504000000020CDB064C000000000DD89504000000080C8B064C0000000A0FB895040000000C0CAB064C0000000800A8A5040000000A0C2B064C0000000C0128A5040000000E0C4B064C0000000A0218A5040000000A0BAB064C0000000201B8A5040000000209EB064C000000060168A5040000000409FB064C0000000C01D8A5040000000A081B064C0000000A0118A50400000008078B064C000000080128A5040000000606FB064C000000080138A50400000000064B064C000000080058A5040000000C058B064C000000080F78950400000004044B064C000000080EA895040000000E038B064C000000080DC895040000000A02EB064C000000000D68950400000000011B064C0000000E0C9895040000000A0FDAF64C000000040C489504000000040EAAF64C0000000A0BE895040000000C0D5AF64C000000080B189504000000060BAAF64C000000040B489504000000060B2AF64C000000080BC89504000000040A1AF64C0000000C0C58950400000004099AF64C000000020CE895040000000609AAF64C000000080D5895040000000609BAF64C0000000E0DC895040000000A0A5AF64C000000080E3895040000000E0AFAF64C000000000EA89504000000080BEAF64C0000000400E8A504000000020DCAF64C0000000601A8A5040000000A0F0AF64C000000080278A5040000000200DB064C0000000202C8A50400000008049B064C0000000004C8A50400000004070B064C000000040578A5040000000E08EB064C0000000C06A8A504000000040A2B064C000000060708A504000000020D1B064C000000060738A5040000000A0EDB064C000000000788A50400000000001B164C0000000A07D8A50400000006014B164C000000040838A50400000006045B164C000000000958A5040000000C058B164C0000000A09A8A50400000008087B164C0000000A09D8A504000000020ACB164C0000000009A8A5040000000A0D0B164C000000060968A504000000000ECB164C0000000A0938A50400000008007B264C0000000E0908A5040000000C019B264C0000000208F8A50400000004036B264C0000000E0938A50400000000055B264C000000060A78A5040000000E07CB264C000000000BA8A504000000020B0B264C0000000A0DA8A5040000000E0CEB264C000000020EE8A5040000000A0EDB264C0000000C0018B5040000000600CB364C000000040158B5040000000C017B364C000000040238B50400000006034B364C0000000E0278B5040000000C048B364C000000000358B5040000000A067B364C000000080488B5040000000C078B364C0000000403F8B5040000000208CB364C0000000E0448B50400000006096B364C0000000604B8B504000000020B4B364C000000080578B5040000000A0C0B364C0000000E06C8B5040000000A0E1B364C0000000408F8B5040000000A00AB464C000000040A98B5040000000203FB464C000000040D18B50400000004069B464C0000000C0F28B50400000008072B464C0000000E0F18B5040000000E085B464C000000080F78B50400000006092B464C0000000E00C8C50400000008093B464C000000040148C5040000000808BB464C0000000A01C8C5040000000E096B464C0000000802A8C50400000002099B464C000000060398C504000000060A3B464C0000000E03F8C5040000000A0B5B464C0000000203E8C504000000020D1B464C0000000403B8C504000000060DBB464C0000000E0418C504000000020FAB464C000000060558C50400000008005B564C000000040638C504000000080FCB464C000000040648C5040000000C0EFB464C0000000208B8C504000000000FAB464C0000000A0918C504000000040FBB464C000000020998C5040000000E018B564C000000040A58C5040000000602DB564C000000040B28C50400000004054B564C000000060BD8C5040000000407CB564C000000000D08C50400000008086B564C000000080D68C5040000000C090B564C000000000DD8C5040000000E0C1B564C0000000C0EE8C5040000000E0F1B564C000000000F98C5040000000C030B664C000000060278D50400000006086B664C000000060358D5040000000E0C9B664C000000040458D5040000000002BB764C000000020618D5040000000205BB764C0000000606B8D5040000000C0A7B764C0000000407A8D504000000060FCB764C0000000C0808D5040000000E048B864C0000000A08F8D50400000002082B864C0000000E0988D5040000000A015B964C000000080918D5040000000C095B964C000000060848D5040000000C015BA64C000000060778D50400000006062BA64C000000020868D50400000000090BA64C000000080818D5040000000A0ACBA64C000000000868D5040000000A0FBBA64C0000000C0A38D50400000006041BB64C000000040C28D50400000008069BB64C0000000C0D48D504000000020B5BB64C000000080188E504000000000CCBB64C000000040348E5040000000E0E2BB64C000000000508E50400000008006BC64C000000040818E5040000000400CBC64C000000060A68E5040000000E008BC64C000000060CC8E5040000000C00EBC64C000000080F18E50400000000001BC64C000000020118F5040000000E0FEBB64C0000000A03E8F504000000020F1BB64C0000000205E8F504000000000B7BB64C000000040C68F5040000000A09BBB64C000000060059050400000004070BB64C00000004055905040000000C02BBB64C0000000C0B69050400000000006BB64C000000080EF90504000000040E7BA64C0000000401891504000000060C9BA64C0000000A04891504000000060A9BA64C0000000206A9150400000004098BA64C00000006073915040000000007FBA64C00000000085915040000000C05CBA64C0000000A0979150400000002031BA64C000000020AB9150400000000018BA64C0000000C0BC915040000000C0FEB964C000000060CE915040000000E0EFB964C000000080E6915040000000A0CEB964C0000000A000925040000000C0AFB964C00000008029925040000000A06FB964C0000000406C925040000000002CB964C000000040D592504000000040C8B864C0000000A05F9350400000006073B864C0000000C0D1935040000000A027B864C00000000043945040000000800FB864C0000000205C9450400000008000B864C0000000407494504000000020E6B764C0000000807E945040000000A0D2B764C0000000E078945040000000E0ADB764C0000000A07C945040000000C095B764C0000000A0959450400000008084B764C0000000E09E945040000000A07DB764C0000000C0AE9450400000006064B764C000000060C09450400000002053B764C0000000A0C9945040000000C048B764C000000020C3945040000000A03FB764C000000000C49450400000006026B764C0000000A0D594504000000000FDB664C000000000F8945040000000C0D4B664C0000000C021955040000000A0ADB664C0000000E0529550400000004065B664C0000000209E9550400000006029B664C000000040C29550400000002008B664C000000040DC95504000000000F8B564C000000000ED95504000000080DDB564C000000040F795504000000000CAB564C0000000A0F195504000000080AEB564C000000060F4955040000000009CB564C000000040F6955040000000A089B564C000000000F89550400000008080B564C000000000F99550400000002067B564C0000000A00A965040000000E055B564C0000000E013965040000000A035B564C000000040359650400000004014B564C0000000404F965040000000C0F1B464C0000000C06196504000000000BEB464C0000000807D9650400000002082B464C0000000A0A19650400000000044B464C0000000E0B69650400000002008B464C000000000DB96504000000000F0B364C000000000F4965040000000A0CEB364C0000000000E97504000000040AEB364C0000000602F975040000000E07DB364C000000060619750400000008064B364C000000000739750400000006054B364C0000000A083975040000000E041B364C00000008085975040000000A037B364C0000000007F975040000000202CB364C00000000071975040000000C021B364C0000000806A975040000000A018B364C0000000606B975040000000400EB364C0000000E064975040000000E0FBB264C0000000C06697504000000080F1B264C0000000206097504000000060F0B264C0000000C058975040000000A000B364C00000002048975040000000A017B364C0000000A0279750400000008025B364C000000020089750400000004023B364C000000040F9965040000000201AB364C000000020FA96504000000060EEB264C0000000800D97504000000080BAB264C00000004029975040000000606DB264C0000000A0569750400000008032B264C0000000208297504000000020DCB164C000000060B0975040000000807CB164C000000080DF9750400000002063B164C000000000F19750400000008012B164C0000000000898504000000040C5B064C00000004035985040000000809AB064C00000002050985040000000C067B064C000000040739850400000006021B064C0000000C090985040000000E0D9AF64C0000000C0A6985040000000E0A4AF64C000000000BB985040000000A07EAF64C000000080F39850400000004057AF64C0000000A024995040000000E018AF64C0000000C039995040000000E0DCAE64C0000000C05D99504000000000AAAE64C0000000E0809950400000006080AE64C000000000A3995040000000A04EAE64C0000000A0CD9950400000004036AE64C0000000A0E6995040000000600AAE64C0000000E0F999504000000060DDAD64C0000000C0059A5040000000A0C0AD64C000000000019A5040000000A073AD64C0000000E0F19950400000006036AD64C0000000600E9A50400000000025AD64C0000000A0179A5040000000E0EFAC64C0000000C02B9A504000000080DEAC64C000000000359A5040000000209FAC64C0000000A0429A50400000002073AC64C000000000569A50400000008050AC64C000000060689A5040000000E02DAC64C0000000E07A9A50400000004013AC64C000000000859A504000000040C6AB64C0000000C0759A5040000000A08CAB64C0000000406C9A5040000000C06EAB64C000000000609A5040000000C040AB64C000000060649A5040000000A012AB64C0000000E0689A5040000000A0E6AA64C0000000207C9A5040000000C0BAAA64C0000000608F9A5040000000208CAA64C000000020D09A5040000000A04CAA64C0000000C0DD9A5040000000400EAA64C0000000C0F29A50400000006097A964C0000000A0059B5040000000C036A964C0000000A0F09A5040000000A0E2A864C000000020F19A504000000020A3A864C0000000A0FE9A5040000000A06AA864C000000060FC9A50400000002031A864C0000000C0F29A5040000000801CA864C0000000A0E59A504000000020DEA764C0000000A0FA9A504000000020B2A764C0000000E00D9B50400000008045A764C000000020279B5040000000A021A764C000000000329B504000000080EDA664C0000000A04D9B504000000000ADA664C0000000A0539B50400000004091A664C000000040569B5040000000E086A664C0000000A04F9B5040000000E085A664C000000040489B5040000000A07BA664C0000000C0419B50400000004070A664C0000000A0339B5040000000404BA664C000000020379B5040000000A030A664C000000020419B5040000000C00CA664C0000000204C9B5040000000A086A564C0000000C0769B5040000000A02FA564C0000000A0A49B5040000000A0FDA464C0000000E0CE9B504000000080D0A464C0000000A0DA9B5040000000409CA464C000000020F69B5040000000E084A464C000000080169C50400000002069A464C000000000199C5040000000C056A464C0000000C01A9C5040000000C031A464C0000000201E9C5040000000C00CA464C0000000A0219C5040000000E0E7A364C000000000259C504000000020A5A364C0000000201C9C50400000008045A364C0000000600E9C5040000000C0DCA264C000000080019C5040000000207CA264C000000040EC9B5040000000A01CA264C000000080DE9B50400000002097A164C0000000A0CC9B50400000004072A164C000000000D09B5040000000204BA164C000000080C49B50400000002025A164C000000080C09B5040000000A010A164C000000060B39B50400000004006A164C0000000C0AC9B50400000004004A164C0000000E09D9B50400000000001A164C000000080879B50400000002007A164C000000060709B5040000000400EA164C0000000A0609B50400000002032A164C0000000C0559B50400000000056A164C0000000004B9B5040000000E07EA164C000000080219B5040000000208CA164C0000000A0FA9A50400000002092A164C000000080E39A50400000008080A164C0000000E0A89A5040000000607DA164C000000080929A5040000000C066A164C000000080769A50400000002052A164C000000040699A5040000000004FA164C000000000539A50400000002056A164C000000040439A5040000000E077A164C000000080299A50400000004088A164C000000000199A5040000000E081A164C000000040EC995040000000A077A164C0000000C0E59950400000008075A164C0000000E0D6995040000000A07BA164C0000000A0BF9950400000006072A164C000000080C09950400000004071A164C000000020B99950400000008053A164C0000000C0AC995040000000C035A164C000000080A09950400000008004A164C0000000608E995040000000C0E6A064C00000000082995040000000A0BEA064C0000000206F99504000000040ACA064C0000000C070995040000000A097A064C0000000A063995040000000A095A064C0000000C0549950400000008094A064C0000000404D9950400000002088A064C0000000E037995040000000C0A2A064C0000000E02D99504000000000ABA064C0000000802599504000000060BDA064C0000000E023995040000000C0CEA064C0000000C01A99504000000020B6A064C0000000C0EF98504000000080A1A064C0000000A0E298504000000080A0A064C000000020DB985040000000006BA064C000000060AB985040000000C05BA064C000000060C3985040000000804DA064C0000000C0E29850400000006045A064C000000000EB9850400000006041A064C00000002011995040000000C023A064C00000008048995040000000A016A064C0000000606F9950400000008012A064C00000008095995040000000C016A064C000000040B399504000000020F89F64C000000040E399504000000020F49F64C000000040099A504000000040F29F64C0000000203E9A504000000060F09F64C000000020739A504000000060F29F64C000000000829A504000000000DD9F64C000000020B19A504000000080C59F64C000000060D19A504000000020B59F64C000000000E29A504000000000839F64C0000000400C9B5040000000E0559F64C0000000E0179B5040000000C0289F64C000000080239B5040000000E0049F64C0000000602E9B504000000040EB9E64C0000000E03F9B504000000040C09E64C0000000605A9B5040000000E08C9E64C0000000207D9B5040000000A0589E64C000000080989B504000000040499E64C000000080B09B5040000000E0389E64C000000000C19B504000000040209E64C0000000E0D99B5040000000E00F9E64C000000060EA9B5040000000C0079E64C0000000C0F29B5040000000C0099E64C0000000A0019C5040000000A0039E64C0000000C0189C5040000000C0049E64C000000020209C5040000000601C9E64C0000000A0439C5040000000801F9E64C0000000005A9C5040000000E02A9E64C000000020689C5040000000603F9E64C000000040759C504000000080439E64C000000000939C504000000080449E64C0000000809A9C504000000020339E64C0000000A0A39C5040000000A0219E64C0000000A0AC9C5040000000C0FE9D64C0000000E0BE9C504000000020E59D64C000000060D09C5040000000E0B49D64C000000060099D504000000020949D64C0000000802A9D5040000000A0819D64C0000000202C9D504000000040719D64C0000000C03C9D5040000000A0589D64C0000000A0559D504000000020439D64C0000000C0849D504000000060009D64C000000080BF9D504000000040D89C64C000000040F09D5040000000C09B9C64C0000000E0139E5040000000203C9C64C0000000A0499E504000000060D39B64C000000040809E5040000000403D9B64C000000060C29E5040000000A0979A64C0000000801C9F504000000040649A64C0000000403F9F5040000000003A9A64C000000020619F5040000000E0339A64C000000040789F504000000060249A64C000000040909F5040000000E0129A64C000000060999F5040000000A00B9A64C000000000A99F5040000000A0E79964C0000000C0B39F5040000000A0C39964C000000080BE9F5040000000208D9964C0000000E0CA9F504000000020479964C000000040EF9F5040000000E0F89864C0000000E01BA0504000000020BE9864C0000000404EA0504000000060819864C0000000C071A05040000000C04D9864C00000006094A0504000000040199864C0000000A0AFA05040000000A0C29764C000000060E4A05040000000A09F9764C0000000A0F6A05040000000C0619764C0000000A012A15040000000402F9764C0000000C03CA1504000000060D49664C00000008097A1504000000080989664C000000060C2A1504000000080799664C000000060F2A15040000000C0619664C00000008012A25040000000A0409664C00000008033A2504000000020319664C0000000804BA25040000000A0209664C0000000005CA25040000000A0239664C00000006072A2504000000000139664C0000000E082A2504000000080039664C0000000E09AA2504000000040FD9564C000000020B2A2504000000040009664C000000060C8A2504000000060049664C000000040E6A25040000000003A9664C000000060D2A25040000000C0529664C0000000A0B9A2504000000060859664C0000000808FA2504000000000BA9664C00000004074A25040000000E0D59664C0000000E071A2504000000000FB9664C0000000A06EA2504000000040059764C00000004075A25040000000600A9764C0000000809AA2504000000080F29664C0000000A0BAA25040000000E0BD9664C0000000E0D5A2504000000000809664C0000000E0F1A2504000000000419664C0000000A006A35040000000E0F99564C00000006023A3504000000040829564C00000006035A3504000000040439564C0000000E049A35040000000E0169564C0000000C05CA3504000000080CD9464C0000000A06AA3504000000020A19464C0000000A07DA35040000000007E9464C0000000A08FA35040000000003E9464C0000000C09CA3504000000080EC9364C0000000E0B2A3504000000080AD9364C000000060C7A35040000000A0529364C000000040DEA35040000000E01B9364C000000080EAA3504000000000C29264C0000000C008A45040000000E09D9264C00000006013A4504000000020689264C00000002027A45040000000E01F9264C0000000603CA4504000000060F39164C0000000404FA45040000000E0C59164C0000000A05AA45040000000605A9164C00000000082A45040000000A0E39064C0000000209BA45040000000A0469064C000000000B0A4504000000080C58F64C000000080C2A4504000000060458F64C000000060DCA4504000000020A08E64C000000060F9A45040000000400E8E64C0000000401CA5504000000020CF8D64C0000000A030A5504000000040B48D64C0000000603AA55040000000008F8D64C0000000803DA5504000000080618D64C0000000E048A55040000000603C8D64C0000000004CA5504000000040FB8C64C00000006051A5504000000060DF8C64C0000000C053A5504000000080C48C64C0000000805DA5504000000080C38C64C00000002056A55040000000A0A88C64C0000000E05FA55040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.010','1.552','83','AK','Nome Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.044','84','AK','Nome Census Area','02180','02','22960.205','SRID=4326;010600000001000000010300000001000000120000000000002072A064C0000000A0329B5040000000A084A064C000000000319B5040000000E08FA064C0000000003F9B50400000000092A064C0000000E04D9B5040000000C088A064C0000000C04E9B50400000006077A064C0000000E0579B50400000008054A064C0000000206A9B50400000006026A064C0000000606E9B5040000000E013A064C000000000709B504000000060FF9F64C0000000E0629B5040000000C0EA9F64C0000000A0559B5040000000C0E89F64C0000000C0469B5040000000E0F19F64C0000000E0459B50400000006003A064C0000000C03C9B5040000000800BA064C000000080349B50400000008030A064C000000020319B5040000000204CA064C0000000A02E9B50400000002072A064C0000000A0329B5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.342','85','AK','Nome Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.026','86','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001100000000000060A67864C0000000003099504000000040A77864C0000000803799504000000040B27864C0000000A04599504000000020B37864C0000000204D99504000000080AC7864C0000000206499504000000040AE7864C0000000207399504000000080937864C0000000A07C995040000000E0817864C0000000808599504000000040707864C0000000608E99504000000020667864C0000000A08799504000000080637864C00000004071995040000000006B7864C0000000A06199504000000080727864C00000002052995040000000A0717864C0000000A04A995040000000E0897864C0000000C02A995040000000409C7864C0000000402999504000000060A67864C00000000030995040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.029','87','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001200000000000080B97864C0000000804598504000000020CB7864C0000000A03C985040000000C0E67864C0000000803A985040000000E0F07864C0000000404198504000000000FB7864C00000000048985040000000E0067964C0000000A05D98504000000060FF7864C0000000406D98504000000060E67864C0000000C08598504000000080CB7864C0000000408F98504000000040C27864C00000000090985040000000E0AE7864C0000000008A98504000000000AE7864C00000008082985040000000E0A37864C0000000C07B98504000000000A37864C0000000607498504000000040AC7864C0000000A07398504000000060AB7864C0000000206C98504000000000B27864C0000000205598504000000080B97864C00000008045985040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.159','88','AK','Nome Census Area','02180','02','22960.205','SRID=4326;0106000000010000000103000000010000001C0000000000004029B664C0000000003B9650400000002047B664C00000002047965040000000C053B664C0000000805C9650400000008061B664C000000040799650400000008078B664C000000020959650400000002085B664C000000080AA965040000000407EB664C000000060BA9650400000000066B664C000000060D3965040000000803BB664C000000040EE965040000000C0CAB564C0000000C0269750400000006073B564C0000000A04D9750400000008009B564C00000006076975040000000E0A1B464C000000000AE975040000000808FB464C0000000C0AF975040000000205EB464C0000000209E9750400000002022B464C0000000E085975040000000E01FB464C00000000077975040000000E02EB464C0000000E05E975040000000003EB464C0000000C046975040000000A078B464C0000000401B975040000000A0CBB464C0000000A0D6965040000000E04FB564C0000000C0A3965040000000A083B564C0000000008896504000000020ADB564C0000000A065965040000000A0CFB564C0000000205396504000000040FBB564C0000000A03F965040000000C015B664C000000080359650400000004029B664C0000000003B965040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.180','89','AK','Nome Census Area','02180','02','22960.205','SRID=4326;0106000000010000000103000000010000002A000000000000401CB964C000000060419550400000008016B964C0000000A0589550400000006006B964C0000000406995504000000080F7B864C0000000808195504000000060DFB864C0000000809A955040000000E0ADB864C000000040C59550400000002062B864C000000020FA95504000000000DEB764C0000000402D965040000000A041B764C0000000407996504000000080FBB664C0000000009796504000000020E9B664C0000000E098965040000000E0DFB664C0000000C09996504000000060CCB664C00000004094965040000000A0B6B664C0000000E07F965040000000A0A7B664C0000000805B965040000000E091B664C000000040479650400000004085B664C0000000C031965040000000E081B664C0000000601B96504000000060ACB664C00000008000965040000000C0D5B664C0000000801A965040000000A0F3B664C0000000A026965040000000C023B764C0000000E0309650400000006037B764C000000080369650400000004046B764C0000000601E9650400000006056B764C0000000A00D965040000000205CB764C000000060F6955040000000A057B764C0000000C0D8955040000000004BB764C000000060C3955040000000005BB764C0000000A0B2955040000000206BB764C0000000E0A195504000000000A0B764C0000000808D955040000000A0CBB764C0000000007A955040000000C0F2B764C00000004085955040000000C021B864C00000000088955040000000A03FB864C00000000094955040000000405BB864C000000040919550400000000080B864C0000000808D95504000000040A1B864C00000008073955040000000C0CBB864C0000000A05895504000000040EEB864C000000000469550400000008007B964C00000006034955040000000401CB964C00000006041955040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.004','0.499','90','AK','Nome Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.030','91','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000000F000000000000602F7B64C00000002078945040000000E0407B64C0000000406F94504000000040537B64C0000000E06D945040000000605D7B64C0000000807494504000000080677B64C0000000407B94504000000080637B64C0000000C0A8945040000000604C7B64C000000020D0945040000000A03B7B64C000000060E094504000000060337B64C0000000A0E894504000000020207B64C0000000A0E2945040000000A00D7B64C000000000E4945040000000200A7B64C000000040C6945040000000C00F7B64C0000000A0A7945040000000A01E7B64C00000008088945040000000602F7B64C00000002078945040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.034','92','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;01060000000100000001030000000100000011000000000000802B7A64C0000000604193504000000020477A64C0000000403F93504000000080597A64C0000000E03D935040000000805A7A64C0000000404593504000000060657A64C00000008053935040000000E0687A64C0000000407193504000000040637A64C0000000C08F93504000000040557A64C000000080B693504000000060457A64C000000040CE935040000000E0337A64C000000020D7935040000000A0207A64C000000020D193504000000080167A64C000000060CA935040000000E0087A64C0000000E0A593504000000000087A64C0000000609E935040000000E00C7A64C0000000607893504000000080127A64C0000000E059935040000000802B7A64C00000006041935040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.025','93','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000000D000000000000E0DA7964C0000000800B93504000000060DE7964C0000000402993504000000040DF7964C0000000C030935040000000A0CE7964C0000000004193504000000000BD7964C0000000E049935040000000C0A97964C0000000E043935040000000A0AA7964C0000000604B93504000000080967964C0000000E03D935040000000A08A7964C0000000402893504000000000927964C0000000A01893504000000000AC7964C0000000A00793504000000060BE7964C00000002006935040000000E0DA7964C0000000800B935040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.290','94','AK','Nome Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.057','95','AK','Nome Census Area','02180','02','22960.205','SRID=4326;01060000000100000001030000000100000014000000000000E06EC064C000000040D08E50400000000080C064C0000000E0C68E5040000000C0A5C064C000000080CA8E5040000000E0C5C064C000000040E58E5040000000E0E4C064C0000000C0F88E50400000008007C164C000000060228F5040000000600DC164C000000080478F5040000000A0FEC064C0000000A05F8F504000000060DCC064C000000060728F504000000040ACC064C000000040688F5040000000608EC064C0000000405C8F5040000000408DC064C0000000E0548F5040000000C091C064C000000040368F5040000000A07AC064C0000000801A8F50400000000066C064C0000000800D8F50400000008052C064C000000000088F50400000004048C064C000000080018F5040000000E045C064C0000000C0F28E5040000000005FC064C000000000E18E5040000000E06EC064C000000040D08E5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.030','96','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;01060000000100000001030000000100000010000000000000E09C3B64C0000000E0DC8E5040000000C0AF3B64C000000060E38E5040000000E0BA3B64C000000040F98E5040000000A0C43B64C000000040008F5040000000E0B23B64C0000000A0088F5040000000A07B3B64C0000000A00B8F504000000060723B64C0000000200C8F504000000000603B64C0000000200D8F504000000040563B64C000000020068F5040000000C0533B64C000000040E88E5040000000605C3B64C000000040E08E5040000000406E3B64C0000000E0D78E5040000000A0803B64C0000000E0D68E5040000000C0893B64C000000060D68E5040000000A0933B64C000000060DD8E5040000000E09C3B64C0000000E0DC8E5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.099','97','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000002E00000000000060E33964C000000040138E5040000000E0E23964C0000000C00B8E5040000000E0EA3964C000000060FC8D504000000060F33964C000000080F48D5040000000A0FC3964C000000000F48D504000000060213A64C000000000F28D5040000000003D3A64C000000080F08D504000000000583A64C0000000A0E78D5040000000A07B3A64C0000000C0D68D504000000060853A64C0000000C0DD8D504000000000863A64C000000020E58D5040000000E0873A64C0000000A0FB8D504000000040A53A64C000000080108E504000000000AF3A64C000000080178E5040000000E0CB3A64C000000000258E5040000000E0DE3A64C0000000802B8E504000000000E83A64C0000000002B8E5040000000A0E83A64C000000080328E5040000000E0E93A64C000000060418E5040000000E0E13A64C0000000C0508E5040000000E0E43A64C000000020768E504000000040E73A64C000000000948E504000000040F23A64C000000000AA8E5040000000E0FD3A64C000000060C78E504000000040F53A64C000000040CF8E5040000000A0EC3A64C000000040D78E504000000080D03A64C000000040D18E5040000000E0B43A64C0000000C0D28E504000000000853A64C0000000C0BE8E5040000000A05F3A64C000000040B98E504000000060433A64C000000040B38E504000000000393A64C0000000C0A48E5040000000801B3A64C0000000C08F8E504000000060123A64C000000040908E504000000000ED3964C0000000C08A8E504000000060BE3964C0000000C0858E504000000080B43964C0000000C07E8E504000000060B33964C0000000C06F8E504000000000BC3964C0000000E0678E504000000080C43964C0000000E05F8E5040000000C0D53964C000000000508E504000000060E63964C0000000A0388E504000000000EF3964C0000000A0308E504000000060EE3964C000000040298E5040000000A0E43964C000000040228E504000000060E33964C000000040138E5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.006','1.131','98','AK','Nome Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.042','99','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001500000000000080072264C0000000A0688D5040000000601A2264C0000000406F8D5040000000C02D2264C0000000807D8D504000000000382264C0000000008C8D5040000000E04B2264C0000000A0A18D504000000080562264C0000000A0B78D5040000000C0612264C000000020D58D5040000000A0742264C0000000C0DB8D5040000000607E2264C0000000E0E28D5040000000407F2264C0000000C0F18D5040000000E06D2264C000000080018E504000000020652264C000000060098E504000000000492264C000000020038E5040000000802D2264C000000060048E5040000000001A2264C000000040F68D504000000020062264C0000000A0E08D504000000000FB2164C000000020C38D504000000080FA2164C0000000A0BB8D504000000040012264C0000000E0958D504000000040FF2164C000000000788D504000000080072264C0000000A0688D5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.052','100','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;01060000000100000001030000000100000019000000000000203D2064C0000000000C8D5040000000003F2064C0000000E0298D504000000080512064C000000020298D5040000000A05D2064C0000000A0558D5040000000C0672064C000000020648D504000000000602064C0000000007B8D504000000080612064C000000060918D5040000000A03F2064C0000000C0BF8D504000000060362064C000000020C08D5040000000402C2064C0000000A0B18D5040000000C0192064C000000060B28D5040000000200F2064C0000000609C8D504000000000F11F64C000000040788D504000000060E71F64C000000020718D5040000000C0DD1F64C0000000006A8D504000000040DC1F64C0000000A0538D5040000000A0D01F64C0000000A02E8D504000000020E11F64C000000000108D5040000000E0E81F64C000000020F98C504000000080032064C000000000E98C5040000000C0272064C000000000E08C5040000000403A2064C000000020DF8C5040000000A03A2064C0000000C0E68C5040000000203C2064C000000020FD8C5040000000203D2064C0000000000C8D5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.055','101','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001500000000000020E17F64C0000000E0C18C504000000000048064C000000000B08C504000000060168064C0000000A0AE8C5040000000802A8064C000000000BC8C5040000000A0348064C0000000C0C28C5040000000E0258064C000000000E28C504000000040168064C0000000C0F98C504000000020178064C000000040018D504000000020228064C0000000600F8D5040000000803E8064C0000000A0148D504000000080498064C0000000C0228D504000000040418064C0000000002B8D5040000000401F8064C000000040448D504000000080FA7F64C000000020478D5040000000A0C27F64C000000020448D5040000000A0A27F64C000000020218D5040000000009F7F64C000000040038D504000000040A87F64C000000080028D504000000040A77F64C000000020FB8C504000000020BF7F64C000000020DB8C504000000020E17F64C0000000E0C18C5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.100','102','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001D000000000000A0108164C000000020B18C504000000060358164C000000040AE8C504000000040628164C000000000A38C504000000000878164C000000020A08C5040000000A0AB8164C0000000209D8C504000000080E38164C000000040A08C504000000020098264C0000000A0A48C504000000000428264C000000020AF8C5040000000004D8264C000000040BD8C504000000000578264C000000000C48C504000000060488264C000000040E38C5040000000203F8264C000000000E48C5040000000E0368264C000000040EC8C5040000000A0238264C000000040E68C5040000000E0F48164C000000080E28C504000000040C58164C000000040D78C504000000040988164C000000060E28C5040000000E07B8164C000000020DD8C504000000040578164C000000020E08C504000000060298164C0000000C0E38C5040000000C00E8164C000000060ED8C504000000000EB8064C0000000E0F78C504000000080CF8064C000000000FA8C5040000000A0CE8064C0000000A0F28C5040000000E0CB8064C000000040DC8C504000000000CB8064C0000000C0D48C5040000000A0E48064C0000000C0C38C504000000000F78064C000000040C28C5040000000A0108164C000000020B18C5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.195','103','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;01060000000100000001030000000100000032000000000000C03F2264C0000000E091885040000000C05B2264C00000002098885040000000C0782264C000000040AD88504000000060832264C000000040C388504000000020902264C000000040F788504000000000932264C00000000024895040000000A0822264C0000000C04289504000000020692264C0000000C06189504000000060472264C0000000409089504000000080362264C000000060A789504000000080262264C0000000A0CD89504000000060202264C0000000E0FA89504000000060102264C000000000218A504000000060142264C0000000C05C8A5040000000A00D2264C000000080828A5040000000C0FD2164C0000000C0A88A504000000020002264C000000000CE8A504000000020022264C0000000E0EB8A504000000060102264C000000040368B5040000000A01C2264C0000000A0628B5040000000E0302264C0000000C07F8B5040000000203C2264C0000000409D8B5040000000A03D2264C0000000A0B38B5040000000202D2264C000000060D28B5040000000401B2264C0000000A0DA8B5040000000C0ED2164C000000020E48B5040000000A0892164C000000060F78B5040000000A02E2164C0000000600A8C504000000060F82064C0000000A01B8C5040000000A0D32064C0000000401D8C5040000000C0C02064C0000000A0168C504000000040BF2064C000000020008C504000000000C62064C000000080DA8B5040000000C0CD2064C0000000A0C38B5040000000E0F72064C0000000E0858B5040000000A0FF2064C0000000006F8B5040000000C0322164C0000000E0308B504000000080652164C000000040EB8A504000000080A92164C0000000E0958A504000000060CB2164C000000080678A504000000020D32164C0000000A0508A504000000040D92164C000000060238A504000000080DF2164C000000020F6895040000000E0D32164C000000040D189504000000080CF2164C0000000008E89504000000080CB2164C00000004052895040000000A0E02164C0000000E0EF885040000000C0F82164C000000060BA885040000000E0122264C0000000C0A2885040000000C03F2264C0000000E091885040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.028','104','AK','Nome Census Area','02180','02','22960.205','SRID=4326;0106000000010000000103000000010000000F0000000000000035B164C000000060E9895040000000004DB164C000000060D08950400000008069B164C000000000D5895040000000C073B164C0000000A0DB8950400000004080B164C000000000F18950400000008082B164C0000000E0FF895040000000A07CB164C000000000178A5040000000C06DB164C0000000202F8A5040000000C065B164C000000060378A5040000000604BB164C0000000A0418A50400000000038B164C0000000E03B8A5040000000C034B164C0000000A0258A50400000002027B164C0000000E0088A5040000000002EB164C000000020F98950400000000035B164C000000060E9895040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.075','105','AK','Nome Census Area','02180','02','22960.205','SRID=4326;010600000001000000010300000001000000170000000000004004B364C0000000407788504000000040FDB264C0000000008788504000000060E5B264C000000000A0885040000000E0B1B264C0000000C0BB885040000000E0A9B264C000000020C4885040000000C078B264C0000000A0EE885040000000E071B264C000000060FE885040000000C031B264C00000002041895040000000800FB264C00000008053895040000000E0F1B164C000000060478950400000002024B264C000000040248950400000004034B264C0000000A0138950400000000042B264C000000020F48850400000002063B264C000000020DA8850400000000072B264C000000020C2885040000000208BB264C000000080B088504000000040BBB264C0000000807E88504000000060D4B264C0000000E06C88504000000060DCB264C0000000A06488504000000080EDB264C0000000605B885040000000C0F7B264C0000000E0618850400000002003B364C0000000C06F8850400000004004B364C00000004077885040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.101','106','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000001500000000000080942464C0000000C06987504000000000B22464C0000000608687504000000040BC2464C0000000E094875040000000A0D22464C0000000C0CF875040000000E0AF2464C000000060EF87504000000060942464C000000080F087504000000080662464C0000000A0F2875040000000A0372464C0000000C0E5875040000000A0002464C000000020E887504000000000C82364C000000020D487504000000000912364C0000000A0D687504000000020622364C0000000C0C9875040000000A0452364C000000000BC875040000000404E2364C000000020B4875040000000A07A2364C0000000C09B87504000000040962364C0000000809A87504000000020C32364C0000000808987504000000040032464C0000000A086875040000000A04B2464C0000000807487504000000000792464C0000000006B87504000000080942464C0000000C069875040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.304','107','AK','Nome Census Area','02180','02','22960.205','SRID=4326;0106000000010000000103000000010000003400000000000020D0D964C0000000E04B835040000000A0E3D964C0000000405183504000000080F4D964C0000000C047835040000000E007DA64C0000000004D8350400000008013DA64C0000000C05A8350400000006020DA64C00000000070835040000000401BDA64C00000004087835040000000C014DA64C0000000209783504000000020EBD964C000000080B283504000000000D5D964C000000060D3835040000000C096D964C000000000E28350400000002004D964C00000002020845040000000606DD864C0000000007D845040000000C020D864C000000000A484504000000040A5D764C0000000A0FD84504000000040AAD664C0000000A09A85504000000060F9D564C0000000E001865040000000C0D8D564C0000000201C865040000000E0C7D564C0000000A025865040000000A0B5D564C0000000C02786504000000060ABD564C00000006021865040000000C09FD564C0000000A01386504000000040A6D564C0000000C003865040000000E0ACD564C0000000E0F385504000000080BCD564C000000000E3855040000000A0CDD564C0000000A0A485504000000000D7D564C0000000A06E85504000000080DDD564C0000000E05E855040000000A0F3D564C0000000203E855040000000C016D664C000000080328550400000000032D664C0000000802F8550400000008045D664C0000000C034855040000000805FD664C0000000402A855040000000A08BD664C0000000C01D855040000000608AD664C0000000601685504000000080B1D664C000000020EC84504000000080F2D664C000000060B7845040000000A056D764C0000000207784504000000080B5D764C0000000204E845040000000001CD864C0000000A01C8450400000006063D864C0000000E00C845040000000E0C0D864C000000060DC83504000000020E9D864C000000080B98350400000006008D964C0000000C097835040000000A00DD964C000000080808350400000004040D964C000000000648350400000002051D964C0000000805A835040000000E072D964C000000080478350400000006079D964C0000000A0378350400000002097D964C00000006043835040000000A0AAD964C0000000C04883504000000020D0D964C0000000E04B835040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.112','108','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;0106000000010000000103000000010000002C000000000000C0283A64C0000000009C825040000000203C3A64C000000000AA82504000000040583A64C000000000B082504000000080623A64C000000060BE825040000000406C3A64C000000060C5825040000000206E3A64C0000000E0DB82504000000040673A64C000000020FA82504000000000603A64C0000000001183504000000020613A64C0000000002083504000000000503A64C0000000E02F83504000000020403A64C0000000C04E835040000000E0253A64C0000000205F83504000000040043A64C0000000608683504000000000EA3964C0000000C096835040000000E0CF3964C000000020A7835040000000C0A53964C000000060D6835040000000009C3964C000000060CF83504000000000703964C000000020E8835040000000804B3964C000000020EA835040000000C0393964C000000080F2835040000000201D3964C000000000E5835040000000C0123964C0000000A0D683504000000000093964C0000000A0CF835040000000800E3964C000000040A2835040000000E0153964C0000000808B83504000000000273964C0000000A07B835040000000602E3964C0000000C064835040000000C03D3964C0000000603E835040000000C03A3964C00000002019835040000000A0523964C0000000E0EA825040000000807A3964C0000000C09D825040000000808B3964C0000000E08D82504000000040923964C0000000806F825040000000E0A23964C00000002058825040000000E0B33964C0000000404882504000000040C63964C0000000404782504000000060EB3964C0000000E04C82504000000020F53964C0000000E05382504000000040FE3964C0000000605382504000000080083A64C0000000C061825040000000E0123A64C00000004070825040000000A01C3A64C0000000407782504000000000143A64C0000000207F825040000000C0283A64C0000000009C825040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.031','109','AK','Northwest Arctic Borough','02188','02','36084.261','SRID=4326;01060000000100000001030000000100000014000000000000A0B83864C0000000E07983504000000060C23864C0000000E08083504000000020C43864C0000000409783504000000060C53864C000000020A6835040000000A0BE3864C000000080C483504000000020B63864C000000080CC835040000000409B3864C000000060D583504000000080893864C0000000C0DD83504000000060803864C000000040DE83504000000020763864C0000000C0CF835040000000C0743864C0000000E0C0835040000000E0693864C000000000AB83504000000040713864C00000002094835040000000E0793864C0000000208C835040000000608A3864C0000000E074835040000000209C3864C0000000606C83504000000020AD3864C0000000805C835040000000E0B63864C00000008063835040000000A0C03864C0000000806A835040000000A0B83864C0000000E079835040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.004','0.964','110','AK','Nome Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.000','0.099','111','AK','Nome Census Area','02180','02','22960.205','SRID=4326;0106000000010000000103000000010000002100000000000000DDDA64C0000000E00D82504000000020EBDA64C0000000602A825040000000A0E4DA64C0000000403A82504000000000D5DA64C0000000204B82504000000040C4DA64C0000000A054825040000000C0A3DA64C0000000206F8250400000004094DA64C000000000808250400000004090DA64C0000000A09E825040000000607FDA64C000000020A8825040000000A054DA64C000000040BC8250400000008028DA64C0000000E0C8825040000000A0EBD964C000000000DF82504000000080BFD964C0000000A0EB82504000000000B0D964C000000080FC825040000000809CD964C000000020F78250400000004085D964C0000000A0DB8250400000008081D964C000000060C5825040000000A07DD964C000000040AF825040000000808ED964C0000000C0A5825040000000809BD964C0000000008682504000000060B5D964C0000000807B82504000000040BDD964C0000000007382504000000020D7D964C0000000806882504000000000E8D964C0000000005F825040000000A000DA64C0000000004D825040000000A01ADA64C00000008042825040000000C035DA64C0000000603F8250400000004052DA64C0000000A043825040000000E080DA64C0000000C045825040000000A07FDA64C0000000603E825040000000A0A2DA64C0000000C03282504000000040C4DA64C0000000C01F82504000000000DDDA64C0000000E00D825040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('12.377','23.986','112','AK','Southeast Fairbanks Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.003','0.531','113','AK','Nome Census Area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
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.001','0.272','114','AK','Nome Census Area','02180','02','22960.205','SRID=4326;0106000000010000000103000000010000002700000000000000D5F964C000000060966F5040000000E0DFF964C0000000206F6F5040000000C009FA64C0000000A05A6F5040000000A036FA64C0000000E0546F5040000000E073FA64C000000060456F504000000060A5FA64C000000040286F504000000000DBFA64C000000040216F5040000000C0FEFA64C0000000A01C6F50400000002010FB64C0000000E0476F50400000004017FB64C0000000C06C6F504000000000E1FA64C000000020A16F5040000000605EFA64C000000020F66F50400000000001FA64C0000000E04D705040000000A0B2F964C00000008094705040000000C069F964C0000000A0F870504000000040DBF864C00000000040715040000000A0F1F764C0000000608B7150400000006081F764C000000060B0715040000000603EF764C000000080A2715040000000802EF764C0000000A07E715040000000A03FF764C000000060477150400000008034F764C0000000400C715040000000A04CF764C000000020FA7050400000004073F764C00000004004715040000000E090F764C0000000A00F71504000000000B9F764C0000000202171504000000020E7F764C0000000E022715040000000C037F864C00000008018715040000000A087F864C000000040D970504000000040C8F864C000000020AB70504000000060D7F864C0000000009A70504000000040FDF864C0000000606F705040000000401EF964C0000000005C705040000000004DF964C00000002030705040000000205CF964C0000000001F7050400000008056F964C000000080017050400000008070F964C000000040C96F504000000000B4F964C0000000C0A96F504000000000D5F964C000000060966F5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('0.002','0.158','115','AK','Nome Census Area','02180','02','22960.205','SRID=4326;0106000000010000000103000000010000001900000000000060121D65C000000080776F504000000080611D65C000000020926F504000000000C11D65C0000000C0A26F5040000000C0E71D65C000000060AC6F5040000000E0F31D65C0000000E0B96F504000000000031E65C000000000D66F5040000000E0251E65C00000008024705040000000C0661E65C0000000C07D705040000000E06B1E65C000000060C170504000000080481E65C000000000F4705040000000C0261E65C0000000E02D715040000000A0AB1D65C0000000C07471504000000060431D65C0000000E09271504000000000EA1C65C0000000A09F71504000000080C71C65C0000000A07E715040000000E0AD1C65C0000000605C71504000000080A41C65C00000004030715040000000A0AB1C65C000000020FA705040000000409F1C65C000000020BF70504000000060881C65C0000000207E705040000000E0751C65C0000000C02570504000000000621C65C000000080F36F504000000060791C65C000000060B36F504000000080CC1C65C000000040896F504000000060121D65C000000080776F5040');
INSERT INTO "us_statecounty" ("area","perimeter","countyp020","state","county","fips","state_fips","square_mil",the_geom) VALUES ('3.640','13.097','116','AK','Fairbanks North Star Borough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