#
# This module was written in 2007 by S James S Stapleton
# This module is released as PUBLIC DOMAIN
#
# Please respect the creator/author's intent and release all
# modifications as public domain. Thank you.
#

#import the whole library:

#
# This adds some extended functionality to various python classes for threading. If there are any bugges or errors, please mail
# them to the user sjss, at the domain var-dev (any of the org net or com should work for tld.)
#
# I* classes - these are the inheritable wrappers for the basic threading classes
# Slock[E|G] - Lockholders returned from the sacquire functions of Slock and SRlock. If these are destroyed without the contained
#              Lock having already been released, then they release the lock, and call a callback function if present (good for
#              debugging lock errors)
# RWlock     - A lock that accepts read (infinite concurrence) and write (one at a time, no other concurrent) locks.
# S[R]lock   - Lock classes that can return Slock[E|G] values with sacquire functions.

import lockholder  as _lhp
import inheritable as _ihr
import rwlock      as _rwp
import rwrlock     as _rwr
import slock       as _slp
import srlock      as _srp

Ilock      = _ihr.Ilock
Irlock     = _ihr.Irlock
Icondition = _ihr.Icondition
Ievent     = _ihr.Ievent

SlockG     = _lhp.SlockG
SlockE     = _lhp.SlockE

RWlock     = _rwp.RWlock
RWrlock    = _rwr.RWrlock

Slock      = _slp.Slock
Srlock     = _srp.Srlock
