#!/bin/env python

print "This determines the site-packages directory of python and installs extended_threading there."

import sys
import os
import time
import py_compile


verbose = False;
src = "."

pslen = len(os.sep)

def install(dest, src="."):
    """
A generic install function. it will parse through the directory in which it is placed, and try to install all the files into the
chosen destination directory (dest). It will skip over install.py. The source directory is by default ".", though it can be
changed. Do not use a file separator with src.
    """
    path = src
    contents = os.listdir(path)

    if(dest[-pslen:] != os.sep):
        dest += os.sep

    tpath = path
    if(path[0:pslen+1] == ("." + os.sep)):
        tpath = path[pslen+1:]
    elif(path == "."):
        tpath = ""
    #ensure the destination directory exists
    if(not os.path.exists(dest + tpath) and tpath != ""):
        if(verbose):
            print "Creating: " + dest+tpath
        os.mkdir(dest+tpath)
    for c in contents:
        if(c      == "install.py" or c      == "samples" or
           c[-4:] == ".txt"       or c[-4:] == ".TXT"):
            continue
        install_sub(dest, path + os.sep, c)
#def install()


def install_sub(dest, path, c):
    """
Take file [c] in [path], and install it to [dest]/[path]. If [c] is a directory, create it and install the contents of [c].
    """
    tpath = path
    if(path[0:pslen+1] == ("." + os.sep)):
        tpath = path[pslen+1:]
        
    if(os.path.isdir(path + c)):
        #ensure the destination directory exists
        if(not os.path.exists(dest + tpath + c)):
            if(verbose):
                print "Creating: " + dest+tpath
            os.mkdir(dest+tpath+c)
        #now install each file in it:
        path += c + os.sep
        contents = os.listdir(path)
        for co in contents:
            install_sub(dest, path, co)
    #if(os.path.isdir(path)):
    else:
        if(verbose):
            print " Copying: " + path + c + " --> " + dest + tpath + c
        sf = open(path+c, "rb")
        df = open(dest+tpath+c, "wb")
        #buffer input file
        sf.seek(0, 2)
        flen = sf.tell()
        sf.seek(0)
        total = 0
        if(verbose):
            sys.stdout.write("          % 9d of % 9d bytes" % (0, flen))
        while(total < flen):
            buff = sf.read()
            if(buff == ""):
                break
            df.write(buff)
            total += len(buff)
            if(verbose):
                sys.stdout.write("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b")
                sys.stdout.write("% 9d of % 9d bytes" % (total, flen))
                time.sleep(0.25)
        print ""
        sf.close()
        df.close()
        #compile if it is python
        if(c[-3:] == ".py"):
          if(verbose):
            print "          Compiling..."
          py_compile.compile(dest+tpath+c)
#def install_sub(dest, path, c):



for v in sys.argv[1:]:
    if(v == "-v" or v == "--verbose"):
        verbose = not verbose
    elif(v[:9] == "--source="):
        src = v[9:]
    else:
        print "Unknown argument, " + v
#for v in sys.argv[1:]:






#find the site-packages directories
possibles = []
for p in sys.path:
    if(p.find("site-packages") > 0):
        possibles.append(p)


if(len(possibles) == 0):
    print "No install path found."
    sys.exit(1)

#get the directory if there are multiple possibilities:
while(len(possibles) > 1):
    i = 0
    print ""
    print "Choose an install path"
    while(i < len(possibles)):
        print str(i+1) + ". " + possibles[i]
        i += 1
    print "Install to: ",
    l = sys.stdin.readline()
    if(l == ""):
        sys.exit(0)
    l = l.strip()
    try:
        l = int(l)
        if(l >= 1 and l <= len(possibles)):
            possibles = [possibles[l-1]]
    except Exception, e:
        pass
#while(len(possibles) > 1):

ans = ""
while(not (ans == "y" or ans == "yes" or
           ans == "n" or ans == "no")):
    print ""
    print "Installing to: " + possibles[0] + " (yes/no): ",
    ans = sys.stdin.readline()
    if(ans == ""):
        sys.exit(0)
    ans = ans.strip().lower()
#while(not (ans == "y" or ans == "yes" or
#           ans == "n" or ans == "no")):

if(ans == "y" or ans == "yes"):
    #install
    print ""
    path = possibles[0]
    install(path)
#if(ans == "y" or ans == "yes"):
