/* broker.c generated by valac 0.56.17, the Vala compiler
 * generated from broker.vala, do not modify */

/* libenchant: Broker
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2025 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>
#include <relocatable.h>
#include <configmake.h>
#include <sys/types.h>
#include <enchant.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef EnchantProvider* (*EnchantProviderInitFunc) (void);
typedef void (*EnchantPreConfigureFunc) (EnchantProvider* provider, const gchar* module_dir);
typedef struct _EnchantBroker EnchantBroker;

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _enchant_provider_unref0(var) ((var == NULL) ? NULL : (var = (enchant_provider_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;
#define _enchant_session_unref0(var) ((var == NULL) ? NULL : (var = (enchant_session_unref (var), NULL)))

#define TYPE_ENCHANT_PWL_DICT (enchant_pwl_dict_get_type ())
#define ENCHANT_PWL_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL_DICT, EnchantPwlDict))
#define ENCHANT_PWL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL_DICT, EnchantPwlDictClass))
#define IS_ENCHANT_PWL_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL_DICT))
#define IS_ENCHANT_PWL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL_DICT))
#define ENCHANT_PWL_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL_DICT, EnchantPwlDictClass))

typedef struct _EnchantPwlDict EnchantPwlDict;
typedef struct _EnchantPwlDictClass EnchantPwlDictClass;
#define _enchant_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_dict_unref (var), NULL)))
typedef struct _EnchantDictPrivate EnchantDictPrivate;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);

#define TYPE_ENCHANT_COMPOSITE_DICT (enchant_composite_dict_get_type ())
#define ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict))
#define ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))
#define IS_ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_COMPOSITE_DICT))
#define IS_ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_COMPOSITE_DICT))
#define ENCHANT_COMPOSITE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))

typedef struct _EnchantCompositeDict EnchantCompositeDict;
typedef struct _EnchantCompositeDictClass EnchantCompositeDictClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantBroker {
	GSList* provider_list;
	GHashTable* provider_ordering;
	GHashTable* dicts;
	gchar* _error;
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

VALA_EXTERN gchar* normalize_dictionary_tag (const gchar* dict_tag);
VALA_EXTERN gchar* iso_639_from_tag (const gchar* dict_tag);
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
static void enchant_broker_instance_init (EnchantBroker * self);
static void _enchant_provider_unref0_ (gpointer var);
static inline void _g_slist_free__enchant_provider_unref0_ (GSList* self);
VALA_EXTERN EnchantBroker* enchant_broker_init (void);
static void enchant_broker_load_providers (EnchantBroker* self);
VALA_EXTERN void enchant_broker_load_provider_ordering (EnchantBroker* self);
static void _enchant_dict_unref0_ (gpointer var);
VALA_EXTERN void enchant_broker_clear_error (EnchantBroker* self);
VALA_EXTERN void enchant_broker_set_error (EnchantBroker* self,
                               const gchar* value);
VALA_EXTERN void enchant_broker_set_ordering (EnchantBroker* self,
                                  const gchar* tag,
                                  const gchar* ordering);
static void enchant_broker_load_providers_in_dir (EnchantBroker* self,
                                           const gchar* dir_name);
VALA_EXTERN gboolean enchant_provider_is_valid (EnchantProvider* provider);
static void enchant_broker_load_ordering_from_file (EnchantBroker* self,
                                             const gchar* file);
static void _g_free0_ (gpointer var);
VALA_EXTERN GSList* enchant_get_conf_dirs (void);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN GSList* enchant_broker_get_ordered_providers (EnchantBroker* self,
                                              const gchar* tag);
VALA_EXTERN EnchantDict* enchant_broker_request_pwl_dict (EnchantBroker* self,
                                              const gchar* pwl);
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN EnchantSession* enchant_session_with_pwl (const gchar* pwlname,
                                          const gchar* exclname);
VALA_EXTERN EnchantDict* enchant_broker_new_dict (EnchantBroker* self,
                                      EnchantDict* dict);
VALA_EXTERN EnchantPwlDict* enchant_pwl_dict_new (EnchantSession* session);
VALA_EXTERN EnchantPwlDict* enchant_pwl_dict_construct (GType object_type,
                                            EnchantSession* session);
VALA_EXTERN GType enchant_pwl_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPwlDict, enchant_dict_unref)
static EnchantDict* _enchant_broker_request_dict (EnchantBroker* self,
                                           const gchar* tag,
                                           const gchar* pwl);
VALA_EXTERN EnchantSession* enchant_session_with_implicit_pwl (const gchar* lang,
                                                   const gchar* pwl);
VALA_EXTERN EnchantDict* enchant_broker_request_dict_with_pwl (EnchantBroker* self,
                                                   const gchar* composite_tag,
                                                   const gchar* pwl);
VALA_EXTERN GType enchant_composite_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantCompositeDict, enchant_dict_unref)
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_new (EnchantBroker* broker,
                                                  GSList* dict_list,
                                                  const gchar* tag);
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_construct (GType object_type,
                                                        EnchantBroker* broker,
                                                        GSList* dict_list,
                                                        const gchar* tag);
VALA_EXTERN EnchantDict* enchant_broker_request_dict (EnchantBroker* self,
                                          const gchar* tag);
VALA_EXTERN void enchant_broker_describe (EnchantBroker* self,
                              EnchantBrokerDescribeFn fn,
                              void* user_data);
VALA_EXTERN void enchant_broker_list_dicts (EnchantBroker* self,
                                EnchantDictDescribeFn fn,
                                void* user_data);
VALA_EXTERN gint _enchant_broker_dict_exists (EnchantBroker* self,
                                  const gchar* tag);
VALA_EXTERN gint _enchant_provider_dictionary_exists (EnchantProvider* self,
                                          const gchar* tag);
VALA_EXTERN gint enchant_broker_dict_exists (EnchantBroker* self,
                                 const gchar* tag);
VALA_EXTERN void enchant_broker_free_dict (EnchantBroker* self,
                               EnchantDict* dict);
VALA_EXTERN const gchar* enchant_broker_get_error (EnchantBroker* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1415 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1416 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1416 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1417 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1418 "glib-2.0.vapi"
	result = _result_;
#line 1418 "glib-2.0.vapi"
	return result;
#line 332 "broker.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1503 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1503 "glib-2.0.vapi"
	end = _tmp0_;
#line 1504 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1504 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1505 "glib-2.0.vapi"
		result = maxlen;
#line 1505 "glib-2.0.vapi"
		return result;
#line 355 "broker.c"
	} else {
		gchar* _tmp2_;
#line 1507 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1507 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1507 "glib-2.0.vapi"
		return result;
#line 364 "broker.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1514 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1516 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 383 "broker.c"
	} else {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 387 "broker.c"
	}
#line 1516 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1518 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 393 "broker.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1520 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1520 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1520 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 403 "broker.c"
	}
#line 1523 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1524 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 411 "broker.c"
	} else {
#line 1527 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 415 "broker.c"
	}
#line 1529 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1530 "glib-2.0.vapi"
		len = string_length - offset;
#line 421 "broker.c"
	}
#line 1532 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1533 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1533 "glib-2.0.vapi"
	result = _tmp3_;
#line 1533 "glib-2.0.vapi"
	return result;
#line 431 "broker.c"
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1204 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1205 "glib-2.0.vapi"
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1205 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1207 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1207 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 453 "broker.c"
		gchar* _tmp2_;
#line 1208 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1208 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1208 "glib-2.0.vapi"
		return result;
#line 461 "broker.c"
	} else {
#line 1210 "glib-2.0.vapi"
		result = -1;
#line 1210 "glib-2.0.vapi"
		return result;
#line 467 "broker.c"
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 485 "broker.c"
}

gchar*
normalize_dictionary_tag (const gchar* dict_tag)
{
	gchar* new_tag = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GString* sb = NULL;
	GString* _tmp7_;
	gint i = 0;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	const gchar* _tmp21_;
	GString* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* result;
#line 33 "broker.vala"
	g_return_val_if_fail (dict_tag != NULL, NULL);
#line 34 "broker.vala"
	_tmp0_ = string_strip (dict_tag);
#line 34 "broker.vala"
	new_tag = _tmp0_;
#line 37 "broker.vala"
	_tmp1_ = new_tag;
#line 37 "broker.vala"
	_tmp2_ = new_tag;
#line 37 "broker.vala"
	_tmp3_ = string_substring (_tmp1_, (glong) 0, (glong) string_index_of_char (_tmp2_, (gunichar) '@', 0));
#line 37 "broker.vala"
	_g_free0 (new_tag);
#line 37 "broker.vala"
	new_tag = _tmp3_;
#line 39 "broker.vala"
	_tmp4_ = new_tag;
#line 39 "broker.vala"
	_tmp5_ = new_tag;
#line 39 "broker.vala"
	_tmp6_ = string_substring (_tmp4_, (glong) 0, (glong) string_index_of_char (_tmp5_, (gunichar) '.', 0));
#line 39 "broker.vala"
	_g_free0 (new_tag);
#line 39 "broker.vala"
	new_tag = _tmp6_;
#line 42 "broker.vala"
	_tmp7_ = g_string_new ("");
#line 42 "broker.vala"
	sb = _tmp7_;
#line 539 "broker.c"
	{
		gboolean _tmp8_ = FALSE;
#line 44 "broker.vala"
		i = 0;
#line 44 "broker.vala"
		_tmp8_ = TRUE;
#line 44 "broker.vala"
		while (TRUE) {
#line 548 "broker.c"
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_;
			GString* _tmp15_;
			const gchar* _tmp16_;
#line 44 "broker.vala"
			if (!_tmp8_) {
#line 556 "broker.c"
				gint _tmp9_;
#line 46 "broker.vala"
				i = i + 1;
#line 46 "broker.vala"
				_tmp9_ = i;
#line 562 "broker.c"
			}
#line 44 "broker.vala"
			_tmp8_ = FALSE;
#line 45 "broker.vala"
			_tmp12_ = new_tag;
#line 45 "broker.vala"
			if (string_get (_tmp12_, (glong) i) != '\0') {
#line 570 "broker.c"
				const gchar* _tmp13_;
#line 45 "broker.vala"
				_tmp13_ = new_tag;
#line 45 "broker.vala"
				_tmp11_ = string_get (_tmp13_, (glong) i) != '-';
#line 576 "broker.c"
			} else {
#line 45 "broker.vala"
				_tmp11_ = FALSE;
#line 580 "broker.c"
			}
#line 45 "broker.vala"
			if (_tmp11_) {
#line 584 "broker.c"
				const gchar* _tmp14_;
#line 45 "broker.vala"
				_tmp14_ = new_tag;
#line 45 "broker.vala"
				_tmp10_ = string_get (_tmp14_, (glong) i) != '_';
#line 590 "broker.c"
			} else {
#line 45 "broker.vala"
				_tmp10_ = FALSE;
#line 594 "broker.c"
			}
#line 45 "broker.vala"
			if (!_tmp10_) {
#line 45 "broker.vala"
				break;
#line 600 "broker.c"
			}
#line 47 "broker.vala"
			_tmp15_ = sb;
#line 47 "broker.vala"
			_tmp16_ = new_tag;
#line 47 "broker.vala"
			g_string_append_c (_tmp15_, g_ascii_tolower (string_get (_tmp16_, (glong) i)));
#line 608 "broker.c"
		}
	}
#line 50 "broker.vala"
	_tmp18_ = new_tag;
#line 50 "broker.vala"
	if (string_get (_tmp18_, (glong) i) == '-') {
#line 50 "broker.vala"
		_tmp17_ = TRUE;
#line 617 "broker.c"
	} else {
		const gchar* _tmp19_;
#line 50 "broker.vala"
		_tmp19_ = new_tag;
#line 50 "broker.vala"
		_tmp17_ = string_get (_tmp19_, (glong) i) == '_';
#line 624 "broker.c"
	}
#line 50 "broker.vala"
	if (_tmp17_) {
#line 628 "broker.c"
		GString* _tmp20_;
#line 51 "broker.vala"
		_tmp20_ = sb;
#line 51 "broker.vala"
		g_string_append_c (_tmp20_, '_');
#line 634 "broker.c"
	}
#line 55 "broker.vala"
	_tmp21_ = new_tag;
#line 55 "broker.vala"
	if (string_get (_tmp21_, (glong) i) != '\0') {
#line 640 "broker.c"
		{
			gint _tmp22_;
			gboolean _tmp23_ = FALSE;
#line 56 "broker.vala"
			i = i + 1;
#line 56 "broker.vala"
			_tmp22_ = i;
#line 56 "broker.vala"
			_tmp23_ = TRUE;
#line 56 "broker.vala"
			while (TRUE) {
#line 652 "broker.c"
				const gchar* _tmp25_;
				GString* _tmp26_;
				const gchar* _tmp27_;
#line 56 "broker.vala"
				if (!_tmp23_) {
#line 658 "broker.c"
					gint _tmp24_;
#line 56 "broker.vala"
					i = i + 1;
#line 56 "broker.vala"
					_tmp24_ = i;
#line 664 "broker.c"
				}
#line 56 "broker.vala"
				_tmp23_ = FALSE;
#line 56 "broker.vala"
				_tmp25_ = new_tag;
#line 56 "broker.vala"
				if (!g_ascii_isalnum (string_get (_tmp25_, (glong) i))) {
#line 56 "broker.vala"
					break;
#line 674 "broker.c"
				}
#line 57 "broker.vala"
				_tmp26_ = sb;
#line 57 "broker.vala"
				_tmp27_ = new_tag;
#line 57 "broker.vala"
				g_string_append_c (_tmp26_, g_ascii_toupper (string_get (_tmp27_, (glong) i)));
#line 682 "broker.c"
			}
		}
	}
#line 60 "broker.vala"
	while (TRUE) {
#line 688 "broker.c"
		const gchar* _tmp28_;
		GString* _tmp29_;
		const gchar* _tmp30_;
		gint _tmp31_;
#line 60 "broker.vala"
		_tmp28_ = new_tag;
#line 60 "broker.vala"
		if (!(string_get (_tmp28_, (glong) i) != '\0')) {
#line 60 "broker.vala"
			break;
#line 699 "broker.c"
		}
#line 61 "broker.vala"
		_tmp29_ = sb;
#line 61 "broker.vala"
		_tmp30_ = new_tag;
#line 61 "broker.vala"
		_tmp31_ = i;
#line 61 "broker.vala"
		i = _tmp31_ + 1;
#line 61 "broker.vala"
		g_string_append_c (_tmp29_, string_get (_tmp30_, (glong) _tmp31_));
#line 711 "broker.c"
	}
#line 63 "broker.vala"
	_tmp32_ = sb;
#line 63 "broker.vala"
	_tmp33_ = _tmp32_->str;
#line 63 "broker.vala"
	_tmp34_ = g_strdup (_tmp33_);
#line 63 "broker.vala"
	result = _tmp34_;
#line 63 "broker.vala"
	_g_string_free0 (sb);
#line 63 "broker.vala"
	_g_free0 (new_tag);
#line 63 "broker.vala"
	return result;
#line 727 "broker.c"
}

gchar*
iso_639_from_tag (const gchar* dict_tag)
{
	gchar* _tmp0_;
	gchar* result;
#line 66 "broker.vala"
	g_return_val_if_fail (dict_tag != NULL, NULL);
#line 67 "broker.vala"
	_tmp0_ = string_substring (dict_tag, (glong) 0, (glong) string_index_of_char (dict_tag, (gunichar) '_', 0));
#line 67 "broker.vala"
	result = _tmp0_;
#line 67 "broker.vala"
	return result;
#line 743 "broker.c"
}

static void
_enchant_provider_unref0_ (gpointer var)
{
#line 77 "broker.vala"
	(var == NULL) ? NULL : (var = (enchant_provider_unref (var), NULL));
#line 751 "broker.c"
}

static inline void
_g_slist_free__enchant_provider_unref0_ (GSList* self)
{
#line 77 "broker.vala"
	g_slist_free_full (self, (GDestroyNotify) _enchant_provider_unref0_);
#line 759 "broker.c"
}

static void
_enchant_dict_unref0_ (gpointer var)
{
#line 90 "broker.vala"
	(var == NULL) ? NULL : (var = (enchant_dict_unref (var), NULL));
#line 767 "broker.c"
}

EnchantBroker*
enchant_broker_init (void)
{
	EnchantBroker* self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
#line 84 "broker.vala"
	self = g_slice_new0 (EnchantBroker);
#line 84 "broker.vala"
	enchant_broker_instance_init (self);
#line 85 "broker.vala"
	if (!g_module_supported ()) {
#line 86 "broker.vala"
		return self;
#line 785 "broker.c"
	}
#line 88 "broker.vala"
	enchant_broker_load_providers (self);
#line 89 "broker.vala"
	enchant_broker_load_provider_ordering (self);
#line 90 "broker.vala"
	_tmp0_ = g_direct_hash;
#line 90 "broker.vala"
	_tmp1_ = g_direct_equal;
#line 90 "broker.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _enchant_dict_unref0_);
#line 90 "broker.vala"
	_g_hash_table_unref0 (self->dicts);
#line 90 "broker.vala"
	self->dicts = _tmp2_;
#line 84 "broker.vala"
	return self;
#line 803 "broker.c"
}

void
enchant_broker_clear_error (EnchantBroker* self)
{
#line 99 "broker.vala"
	g_return_if_fail (self != NULL);
#line 100 "broker.vala"
	enchant_broker_set_error (self, NULL);
#line 813 "broker.c"
}

void
enchant_broker_set_ordering (EnchantBroker* self,
                             const gchar* tag,
                             const gchar* ordering)
{
	gchar* tag_dupl = NULL;
	gchar* _tmp0_;
	gchar* ordering_dupl = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
#line 108 "broker.vala"
	g_return_if_fail (self != NULL);
#line 108 "broker.vala"
	g_return_if_fail (tag != NULL);
#line 108 "broker.vala"
	g_return_if_fail (ordering != NULL);
#line 109 "broker.vala"
	enchant_broker_clear_error (self);
#line 111 "broker.vala"
	_tmp0_ = normalize_dictionary_tag (tag);
#line 111 "broker.vala"
	tag_dupl = _tmp0_;
#line 112 "broker.vala"
	_tmp1_ = string_strip (ordering);
#line 112 "broker.vala"
	ordering_dupl = _tmp1_;
#line 114 "broker.vala"
	_tmp5_ = tag_dupl;
#line 114 "broker.vala"
	if (_tmp5_ != NULL) {
#line 849 "broker.c"
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 114 "broker.vala"
		_tmp6_ = tag_dupl;
#line 114 "broker.vala"
		_tmp7_ = strlen (_tmp6_);
#line 114 "broker.vala"
		_tmp8_ = _tmp7_;
#line 114 "broker.vala"
		_tmp4_ = _tmp8_ > 0;
#line 861 "broker.c"
	} else {
#line 114 "broker.vala"
		_tmp4_ = FALSE;
#line 865 "broker.c"
	}
#line 114 "broker.vala"
	if (_tmp4_) {
#line 869 "broker.c"
		const gchar* _tmp9_;
#line 115 "broker.vala"
		_tmp9_ = ordering_dupl;
#line 115 "broker.vala"
		_tmp3_ = _tmp9_ != NULL;
#line 875 "broker.c"
	} else {
#line 114 "broker.vala"
		_tmp3_ = FALSE;
#line 879 "broker.c"
	}
#line 114 "broker.vala"
	if (_tmp3_) {
#line 883 "broker.c"
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 115 "broker.vala"
		_tmp10_ = ordering_dupl;
#line 115 "broker.vala"
		_tmp11_ = strlen (_tmp10_);
#line 115 "broker.vala"
		_tmp12_ = _tmp11_;
#line 115 "broker.vala"
		_tmp2_ = _tmp12_ > 0;
#line 895 "broker.c"
	} else {
#line 114 "broker.vala"
		_tmp2_ = FALSE;
#line 899 "broker.c"
	}
#line 114 "broker.vala"
	if (_tmp2_) {
#line 903 "broker.c"
		GHashTable* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
#line 116 "broker.vala"
		_tmp13_ = self->provider_ordering;
#line 116 "broker.vala"
		_tmp14_ = tag_dupl;
#line 116 "broker.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 116 "broker.vala"
		_tmp16_ = ordering_dupl;
#line 116 "broker.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 116 "broker.vala"
		g_hash_table_insert (_tmp13_, _tmp15_, _tmp17_);
#line 921 "broker.c"
	}
#line 108 "broker.vala"
	_g_free0 (ordering_dupl);
#line 108 "broker.vala"
	_g_free0 (tag_dupl);
#line 927 "broker.c"
}

static gchar*
_vala_gnulib_relocate (const gchar* path)
{
	gchar* newpath = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 77 "gnu.vapi"
	g_return_val_if_fail (path != NULL, NULL);
#line 78 "gnu.vapi"
	_tmp0_ = (gchar*) relocate (path);
#line 78 "gnu.vapi"
	newpath = _tmp0_;
#line 79 "gnu.vapi"
	_tmp1_ = newpath;
#line 79 "gnu.vapi"
	if (_tmp1_ != path) {
#line 947 "broker.c"
		gchar* _tmp2_;
#line 82 "gnu.vapi"
		_tmp2_ = newpath;
#line 82 "gnu.vapi"
		newpath = NULL;
#line 82 "gnu.vapi"
		result = (gchar*) _tmp2_;
#line 82 "gnu.vapi"
		return result;
#line 957 "broker.c"
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 85 "gnu.vapi"
		_tmp3_ = newpath;
#line 85 "gnu.vapi"
		_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 85 "gnu.vapi"
		result = _tmp4_;
#line 85 "gnu.vapi"
		return result;
#line 969 "broker.c"
	}
}

static void
enchant_broker_load_providers (EnchantBroker* self)
{
	gchar* module_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 119 "broker.vala"
	g_return_if_fail (self != NULL);
#line 120 "broker.vala"
	_tmp0_ = g_strdup_printf ("%s-%s", PKGLIBDIR, ENCHANT_MAJOR_VERSION);
#line 120 "broker.vala"
	_tmp1_ = _tmp0_;
#line 120 "broker.vala"
	_tmp2_ = _vala_gnulib_relocate (_tmp1_);
#line 120 "broker.vala"
	_tmp3_ = _tmp2_;
#line 120 "broker.vala"
	_g_free0 (_tmp1_);
#line 120 "broker.vala"
	module_dir = _tmp3_;
#line 121 "broker.vala"
	_tmp4_ = module_dir;
#line 121 "broker.vala"
	if (_tmp4_ != NULL) {
#line 1000 "broker.c"
		const gchar* _tmp5_;
#line 122 "broker.vala"
		_tmp5_ = module_dir;
#line 122 "broker.vala"
		enchant_broker_load_providers_in_dir (self, _tmp5_);
#line 1006 "broker.c"
	}
#line 119 "broker.vala"
	_g_free0 (module_dir);
#line 1010 "broker.c"
}

static void
enchant_broker_load_providers_in_dir (EnchantBroker* self,
                                      const gchar* dir_name)
{
	GDir* dir = NULL;
	gchar* dir_entry = NULL;
	GError* _inner_error0_ = NULL;
#line 125 "broker.vala"
	g_return_if_fail (self != NULL);
#line 125 "broker.vala"
	g_return_if_fail (dir_name != NULL);
#line 1024 "broker.c"
	{
		GDir* _tmp0_ = NULL;
		GDir* _tmp1_;
		GDir* _tmp2_;
#line 128 "broker.vala"
		_tmp1_ = g_dir_open (dir_name, (guint) 0, &_inner_error0_);
#line 128 "broker.vala"
		_tmp0_ = _tmp1_;
#line 128 "broker.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 128 "broker.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 1037 "broker.c"
				goto __catch0_g_file_error;
			}
#line 128 "broker.vala"
			_g_dir_close0 (dir);
#line 128 "broker.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 128 "broker.vala"
			g_clear_error (&_inner_error0_);
#line 128 "broker.vala"
			return;
#line 1048 "broker.c"
		}
#line 128 "broker.vala"
		_tmp2_ = _tmp0_;
#line 128 "broker.vala"
		_tmp0_ = NULL;
#line 128 "broker.vala"
		_g_dir_close0 (dir);
#line 128 "broker.vala"
		dir = _tmp2_;
#line 127 "broker.vala"
		_g_dir_close0 (_tmp0_);
#line 1060 "broker.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
#line 127 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 130 "broker.vala"
		_g_dir_close0 (dir);
#line 130 "broker.vala"
		return;
#line 1071 "broker.c"
	}
	__finally0:
#line 127 "broker.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 127 "broker.vala"
		_g_dir_close0 (dir);
#line 127 "broker.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 127 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 127 "broker.vala"
		return;
#line 1084 "broker.c"
	}
#line 134 "broker.vala"
	while (TRUE) {
#line 1088 "broker.c"
		GDir* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		GModule* module = NULL;
		EnchantProvider* provider = NULL;
		const gchar* _tmp7_;
		EnchantProvider* _tmp30_;
		EnchantProvider* _tmp45_;
#line 134 "broker.vala"
		_tmp3_ = dir;
#line 134 "broker.vala"
		_tmp4_ = g_dir_read_name (_tmp3_);
#line 134 "broker.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 134 "broker.vala"
		_g_free0 (dir_entry);
#line 134 "broker.vala"
		dir_entry = _tmp5_;
#line 134 "broker.vala"
		_tmp6_ = dir_entry;
#line 134 "broker.vala"
		if (!(_tmp6_ != NULL)) {
#line 134 "broker.vala"
			break;
#line 1114 "broker.c"
		}
#line 135 "broker.vala"
		module = NULL;
#line 136 "broker.vala"
		provider = NULL;
#line 138 "broker.vala"
		_tmp7_ = dir_entry;
#line 138 "broker.vala"
		if (string_get (_tmp7_, (glong) 0) != '.') {
#line 1124 "broker.c"
			gchar* filename = NULL;
			const gchar* _tmp8_;
			gchar* _tmp9_;
#line 139 "broker.vala"
			_tmp8_ = dir_entry;
#line 139 "broker.vala"
			_tmp9_ = g_build_filename (dir_name, _tmp8_, NULL);
#line 139 "broker.vala"
			filename = _tmp9_;
#line 1134 "broker.c"
			{
				GModule* _tmp10_ = NULL;
				const gchar* _tmp11_;
				GModule* _tmp12_;
				GModule* _tmp13_;
				void* init_func = NULL;
				gboolean _tmp14_ = FALSE;
				GModule* _tmp15_;
				void* _tmp16_ = NULL;
				gboolean _tmp17_;
#line 141 "broker.vala"
				_tmp11_ = filename;
#line 141 "broker.vala"
				_tmp12_ = g_module_open_full (_tmp11_, 0, &_inner_error0_);
#line 141 "broker.vala"
				_tmp10_ = _tmp12_;
#line 141 "broker.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 141 "broker.vala"
					if (_inner_error0_->domain == G_MODULE_ERROR) {
#line 1155 "broker.c"
						goto __catch1_g_module_error;
					}
#line 141 "broker.vala"
					_g_free0 (filename);
#line 141 "broker.vala"
					_enchant_provider_unref0 (provider);
#line 141 "broker.vala"
					_g_module_close0 (module);
#line 141 "broker.vala"
					_g_free0 (dir_entry);
#line 141 "broker.vala"
					_g_dir_close0 (dir);
#line 141 "broker.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 141 "broker.vala"
					g_clear_error (&_inner_error0_);
#line 141 "broker.vala"
					return;
#line 1174 "broker.c"
				}
#line 141 "broker.vala"
				_tmp13_ = _tmp10_;
#line 141 "broker.vala"
				_tmp10_ = NULL;
#line 141 "broker.vala"
				_g_module_close0 (module);
#line 141 "broker.vala"
				module = _tmp13_;
#line 143 "broker.vala"
				_tmp15_ = module;
#line 143 "broker.vala"
				_tmp17_ = g_module_symbol (_tmp15_, "init_enchant_provider", &_tmp16_);
#line 143 "broker.vala"
				init_func = _tmp16_;
#line 143 "broker.vala"
				if (_tmp17_) {
#line 1192 "broker.c"
					void* _tmp18_;
#line 144 "broker.vala"
					_tmp18_ = init_func;
#line 144 "broker.vala"
					_tmp14_ = _tmp18_ != NULL;
#line 1198 "broker.c"
				} else {
#line 143 "broker.vala"
					_tmp14_ = FALSE;
#line 1202 "broker.c"
				}
#line 143 "broker.vala"
				if (_tmp14_) {
#line 1206 "broker.c"
					void* _tmp19_;
					EnchantProvider* _tmp20_;
					EnchantProvider* _tmp21_;
#line 145 "broker.vala"
					_tmp19_ = init_func;
#line 145 "broker.vala"
					_tmp20_ = ((EnchantProviderInitFunc) _tmp19_) ();
#line 145 "broker.vala"
					_enchant_provider_unref0 (provider);
#line 145 "broker.vala"
					provider = _tmp20_;
#line 146 "broker.vala"
					_tmp21_ = provider;
#line 146 "broker.vala"
					if (!enchant_provider_is_valid (_tmp21_)) {
#line 1222 "broker.c"
						const gchar* _tmp22_;
						EnchantProvider* _tmp23_;
#line 147 "broker.vala"
						_tmp22_ = dir_entry;
#line 147 "broker.vala"
						g_warning ("broker.vala:147: Error loading plugin: %s's init_enchant_provider retu" \
"rned invalid provider", _tmp22_);
#line 148 "broker.vala"
						_tmp23_ = provider;
#line 148 "broker.vala"
						if (_tmp23_ != NULL) {
#line 1233 "broker.c"
							EnchantProvider* _tmp24_;
							ProviderDispose _tmp25_;
#line 149 "broker.vala"
							_tmp24_ = provider;
#line 149 "broker.vala"
							_tmp25_ = _tmp24_->dispose;
#line 149 "broker.vala"
							if (_tmp25_ != NULL) {
#line 1242 "broker.c"
								EnchantProvider* _tmp26_;
								ProviderDispose _tmp27_;
								EnchantProvider* _tmp28_;
#line 150 "broker.vala"
								_tmp26_ = provider;
#line 150 "broker.vala"
								_tmp27_ = _tmp26_->dispose;
#line 150 "broker.vala"
								_tmp28_ = provider;
#line 150 "broker.vala"
								_tmp27_ (_tmp28_);
#line 1254 "broker.c"
							}
#line 151 "broker.vala"
							_enchant_provider_unref0 (provider);
#line 151 "broker.vala"
							provider = NULL;
#line 1260 "broker.c"
						}
					}
				}
#line 140 "broker.vala"
				_g_module_close0 (_tmp10_);
#line 1266 "broker.c"
			}
			goto __finally1;
			__catch1_g_module_error:
			{
				const gchar* _tmp29_;
#line 140 "broker.vala"
				g_clear_error (&_inner_error0_);
#line 156 "broker.vala"
				_tmp29_ = g_module_error ();
#line 156 "broker.vala"
				g_warning ("broker.vala:156: Error loading plugin: %s", _tmp29_);
#line 1278 "broker.c"
			}
			__finally1:
#line 140 "broker.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 140 "broker.vala"
				_g_free0 (filename);
#line 140 "broker.vala"
				_enchant_provider_unref0 (provider);
#line 140 "broker.vala"
				_g_module_close0 (module);
#line 140 "broker.vala"
				_g_free0 (dir_entry);
#line 140 "broker.vala"
				_g_dir_close0 (dir);
#line 140 "broker.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 140 "broker.vala"
				g_clear_error (&_inner_error0_);
#line 140 "broker.vala"
				return;
#line 1299 "broker.c"
			}
#line 138 "broker.vala"
			_g_free0 (filename);
#line 1303 "broker.c"
		}
#line 159 "broker.vala"
		_tmp30_ = provider;
#line 159 "broker.vala"
		if (_tmp30_ != NULL) {
#line 1309 "broker.c"
			void* conf_func = NULL;
			gboolean _tmp31_ = FALSE;
			GModule* _tmp32_;
			void* _tmp33_ = NULL;
			gboolean _tmp34_;
#line 162 "broker.vala"
			_tmp32_ = module;
#line 162 "broker.vala"
			_tmp34_ = g_module_symbol (_tmp32_, "configure_enchant_provider", &_tmp33_);
#line 162 "broker.vala"
			conf_func = _tmp33_;
#line 162 "broker.vala"
			if (_tmp34_) {
#line 1323 "broker.c"
				void* _tmp35_;
#line 163 "broker.vala"
				_tmp35_ = conf_func;
#line 163 "broker.vala"
				_tmp31_ = _tmp35_ != NULL;
#line 1329 "broker.c"
			} else {
#line 162 "broker.vala"
				_tmp31_ = FALSE;
#line 1333 "broker.c"
			}
#line 162 "broker.vala"
			if (_tmp31_) {
#line 1337 "broker.c"
				void* _tmp36_;
				EnchantProvider* _tmp37_;
				EnchantProvider* _tmp38_;
#line 164 "broker.vala"
				_tmp36_ = conf_func;
#line 164 "broker.vala"
				_tmp37_ = provider;
#line 164 "broker.vala"
				((EnchantPreConfigureFunc) _tmp36_) (_tmp37_, dir_name);
#line 165 "broker.vala"
				_tmp38_ = provider;
#line 165 "broker.vala"
				if (!enchant_provider_is_valid (_tmp38_)) {
#line 1351 "broker.c"
					const gchar* _tmp39_;
					EnchantProvider* _tmp40_;
					ProviderDispose _tmp41_;
#line 166 "broker.vala"
					_tmp39_ = dir_entry;
#line 166 "broker.vala"
					g_warning ("broker.vala:166: Error loading plugin: %s's configure_enchant_provider" \
" modified provider and it is now invalid", _tmp39_);
#line 167 "broker.vala"
					_tmp40_ = provider;
#line 167 "broker.vala"
					_tmp41_ = _tmp40_->dispose;
#line 167 "broker.vala"
					if (_tmp41_ != NULL) {
#line 1365 "broker.c"
						EnchantProvider* _tmp42_;
						ProviderDispose _tmp43_;
						EnchantProvider* _tmp44_;
#line 168 "broker.vala"
						_tmp42_ = provider;
#line 168 "broker.vala"
						_tmp43_ = _tmp42_->dispose;
#line 168 "broker.vala"
						_tmp44_ = provider;
#line 168 "broker.vala"
						_tmp43_ (_tmp44_);
#line 1377 "broker.c"
					}
#line 169 "broker.vala"
					_enchant_provider_unref0 (provider);
#line 169 "broker.vala"
					provider = NULL;
#line 1383 "broker.c"
				}
			}
		}
#line 173 "broker.vala"
		_tmp45_ = provider;
#line 173 "broker.vala"
		if (_tmp45_ != NULL) {
#line 1391 "broker.c"
			EnchantProvider* _tmp46_;
			GModule* _tmp47_;
			EnchantProvider* _tmp48_;
			EnchantProvider* _tmp49_;
#line 174 "broker.vala"
			_tmp46_ = provider;
#line 174 "broker.vala"
			_tmp47_ = module;
#line 174 "broker.vala"
			module = NULL;
#line 174 "broker.vala"
			_g_module_close0 (_tmp46_->module);
#line 174 "broker.vala"
			_tmp46_->module = _tmp47_;
#line 175 "broker.vala"
			_tmp48_ = provider;
#line 175 "broker.vala"
			_tmp48_->owner = self;
#line 176 "broker.vala"
			_tmp49_ = provider;
#line 176 "broker.vala"
			provider = NULL;
#line 176 "broker.vala"
			self->provider_list = g_slist_append (self->provider_list, _tmp49_);
#line 1416 "broker.c"
		}
#line 134 "broker.vala"
		_enchant_provider_unref0 (provider);
#line 134 "broker.vala"
		_g_module_close0 (module);
#line 1422 "broker.c"
	}
#line 125 "broker.vala"
	_g_free0 (dir_entry);
#line 125 "broker.vala"
	_g_dir_close0 (dir);
#line 1428 "broker.c"
}

static void
enchant_broker_load_ordering_from_file (EnchantBroker* self,
                                        const gchar* file)
{
	GIOChannel* ch = NULL;
	GIOChannel* _tmp5_;
	gchar* line = NULL;
	gsize terminator = 0UL;
	GError* _inner_error0_ = NULL;
#line 181 "broker.vala"
	g_return_if_fail (self != NULL);
#line 181 "broker.vala"
	g_return_if_fail (file != NULL);
#line 182 "broker.vala"
	ch = NULL;
#line 1446 "broker.c"
	{
		GIOChannel* _tmp0_ = NULL;
		GIOChannel* _tmp1_;
		GIOChannel* _tmp2_;
#line 184 "broker.vala"
		_tmp1_ = g_io_channel_new_file (file, "r", &_inner_error0_);
#line 184 "broker.vala"
		_tmp0_ = _tmp1_;
#line 184 "broker.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "broker.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 1459 "broker.c"
				goto __catch0_g_file_error;
			}
#line 184 "broker.vala"
			_g_io_channel_unref0 (ch);
#line 184 "broker.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 184 "broker.vala"
			g_clear_error (&_inner_error0_);
#line 184 "broker.vala"
			return;
#line 1470 "broker.c"
		}
#line 184 "broker.vala"
		_tmp2_ = _tmp0_;
#line 184 "broker.vala"
		_tmp0_ = NULL;
#line 184 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 184 "broker.vala"
		ch = _tmp2_;
#line 183 "broker.vala"
		_g_io_channel_unref0 (_tmp0_);
#line 1482 "broker.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 183 "broker.vala"
		e = _inner_error0_;
#line 183 "broker.vala"
		_inner_error0_ = NULL;
#line 186 "broker.vala"
		_tmp3_ = e;
#line 186 "broker.vala"
		_tmp4_ = _tmp3_->message;
#line 186 "broker.vala"
		g_debug ("broker.vala:186: could not open ordering file %s: %s", file, _tmp4_);
#line 187 "broker.vala"
		_g_error_free0 (e);
#line 187 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 187 "broker.vala"
		return;
#line 1506 "broker.c"
	}
	__finally0:
#line 183 "broker.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 183 "broker.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 183 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 183 "broker.vala"
		return;
#line 1519 "broker.c"
	}
#line 189 "broker.vala"
	_tmp5_ = ch;
#line 189 "broker.vala"
	_vala_assert (_tmp5_ != NULL, "ch != null");
#line 191 "broker.vala"
	g_debug ("broker.vala:191: reading ordering file %s", file);
#line 1527 "broker.c"
	{
#line 195 "broker.vala"
		while (TRUE) {
#line 1531 "broker.c"
			GIOStatus _tmp6_ = 0;
			GIOChannel* _tmp7_;
			gchar* _tmp8_ = NULL;
			gsize _tmp9_ = 0UL;
			GIOStatus _tmp10_;
			gint colon = 0;
			const gchar* _tmp11_;
#line 195 "broker.vala"
			_tmp7_ = ch;
#line 195 "broker.vala"
			_tmp10_ = g_io_channel_read_line (_tmp7_, &_tmp8_, NULL, &_tmp9_, &_inner_error0_);
#line 195 "broker.vala"
			_g_free0 (line);
#line 195 "broker.vala"
			line = _tmp8_;
#line 195 "broker.vala"
			terminator = _tmp9_;
#line 195 "broker.vala"
			_tmp6_ = _tmp10_;
#line 195 "broker.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 195 "broker.vala"
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 1555 "broker.c"
					goto __catch1_g_convert_error;
				}
#line 195 "broker.vala"
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
#line 1560 "broker.c"
					goto __catch1_g_io_channel_error;
				}
#line 195 "broker.vala"
				_g_free0 (line);
#line 195 "broker.vala"
				_g_io_channel_unref0 (ch);
#line 195 "broker.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 195 "broker.vala"
				g_clear_error (&_inner_error0_);
#line 195 "broker.vala"
				return;
#line 1573 "broker.c"
			}
#line 195 "broker.vala"
			if (!(G_IO_STATUS_NORMAL == _tmp6_)) {
#line 195 "broker.vala"
				break;
#line 1579 "broker.c"
			}
#line 196 "broker.vala"
			_tmp11_ = line;
#line 196 "broker.vala"
			colon = string_index_of_char (_tmp11_, (gunichar) ':', 0);
#line 197 "broker.vala"
			if (colon != -1) {
#line 1587 "broker.c"
				gchar* tag = NULL;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* ordering = NULL;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
#line 198 "broker.vala"
				_tmp12_ = line;
#line 198 "broker.vala"
				_tmp13_ = string_substring (_tmp12_, (glong) 0, (glong) colon);
#line 198 "broker.vala"
				tag = _tmp13_;
#line 199 "broker.vala"
				_tmp14_ = line;
#line 199 "broker.vala"
				_tmp15_ = string_substring (_tmp14_, (glong) (colon + 1), (((glong) terminator) - colon) - 1);
#line 199 "broker.vala"
				ordering = _tmp15_;
#line 200 "broker.vala"
				_tmp16_ = tag;
#line 200 "broker.vala"
				_tmp17_ = ordering;
#line 200 "broker.vala"
				enchant_broker_set_ordering (self, _tmp16_, _tmp17_);
#line 197 "broker.vala"
				_g_free0 (ordering);
#line 197 "broker.vala"
				_g_free0 (tag);
#line 1618 "broker.c"
			}
		}
	}
	goto __finally1;
	__catch1_g_convert_error:
	{
#line 194 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 204 "broker.vala"
		_g_free0 (line);
#line 204 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 204 "broker.vala"
		return;
#line 1633 "broker.c"
	}
	goto __finally1;
	__catch1_g_io_channel_error:
	{
#line 194 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 206 "broker.vala"
		_g_free0 (line);
#line 206 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 206 "broker.vala"
		return;
#line 1646 "broker.c"
	}
	__finally1:
#line 194 "broker.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 194 "broker.vala"
		_g_free0 (line);
#line 194 "broker.vala"
		_g_io_channel_unref0 (ch);
#line 194 "broker.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 194 "broker.vala"
		g_clear_error (&_inner_error0_);
#line 194 "broker.vala"
		return;
#line 1661 "broker.c"
	}
#line 181 "broker.vala"
	_g_free0 (line);
#line 181 "broker.vala"
	_g_io_channel_unref0 (ch);
#line 1667 "broker.c"
}

static void
_g_free0_ (gpointer var)
{
#line 211 "broker.vala"
	var = (g_free (var), NULL);
#line 1675 "broker.c"
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
#line 210 "broker.vala"
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
#line 1683 "broker.c"
}

void
enchant_broker_load_provider_ordering (EnchantBroker* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSList* conf_dirs = NULL;
	GSList* _tmp3_;
	GSList* _tmp4_;
#line 210 "broker.vala"
	g_return_if_fail (self != NULL);
#line 211 "broker.vala"
	_tmp0_ = g_str_hash;
#line 211 "broker.vala"
	_tmp1_ = g_str_equal;
#line 211 "broker.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
#line 211 "broker.vala"
	_g_hash_table_unref0 (self->provider_ordering);
#line 211 "broker.vala"
	self->provider_ordering = _tmp2_;
#line 213 "broker.vala"
	_tmp3_ = enchant_get_conf_dirs ();
#line 213 "broker.vala"
	conf_dirs = _tmp3_;
#line 214 "broker.vala"
	_tmp4_ = conf_dirs;
#line 1713 "broker.c"
	{
		GSList* dir_collection = NULL;
		GSList* dir_it = NULL;
#line 214 "broker.vala"
		dir_collection = _tmp4_;
#line 214 "broker.vala"
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
#line 1721 "broker.c"
			gchar* _tmp5_;
			gchar* dir = NULL;
#line 214 "broker.vala"
			_tmp5_ = g_strdup ((const gchar*) dir_it->data);
#line 214 "broker.vala"
			dir = _tmp5_;
#line 1728 "broker.c"
			{
				gchar* ordering_file = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
#line 215 "broker.vala"
				_tmp6_ = dir;
#line 215 "broker.vala"
				_tmp7_ = g_build_filename (_tmp6_, "enchant.ordering", NULL);
#line 215 "broker.vala"
				ordering_file = _tmp7_;
#line 216 "broker.vala"
				_tmp8_ = ordering_file;
#line 216 "broker.vala"
				enchant_broker_load_ordering_from_file (self, _tmp8_);
#line 214 "broker.vala"
				_g_free0 (ordering_file);
#line 214 "broker.vala"
				_g_free0 (dir);
#line 1748 "broker.c"
			}
		}
	}
#line 210 "broker.vala"
	(conf_dirs == NULL) ? NULL : (conf_dirs = (_g_slist_free__g_free0_ (conf_dirs), NULL));
#line 1754 "broker.c"
}

GSList*
enchant_broker_get_ordered_providers (EnchantBroker* self,
                                      const gchar* tag)
{
	gchar* ordering = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GSList* list = NULL;
	const gchar* _tmp7_;
	GSList* _tmp23_;
	GSList* result;
#line 220 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 220 "broker.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 221 "broker.vala"
	_tmp0_ = self->provider_ordering;
#line 221 "broker.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, tag);
#line 221 "broker.vala"
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
#line 221 "broker.vala"
	ordering = _tmp2_;
#line 222 "broker.vala"
	_tmp3_ = ordering;
#line 222 "broker.vala"
	if (_tmp3_ == NULL) {
#line 1786 "broker.c"
		GHashTable* _tmp4_;
		gconstpointer _tmp5_;
		gchar* _tmp6_;
#line 223 "broker.vala"
		_tmp4_ = self->provider_ordering;
#line 223 "broker.vala"
		_tmp5_ = g_hash_table_lookup (_tmp4_, "*");
#line 223 "broker.vala"
		_tmp6_ = g_strdup ((const gchar*) _tmp5_);
#line 223 "broker.vala"
		_g_free0 (ordering);
#line 223 "broker.vala"
		ordering = _tmp6_;
#line 1800 "broker.c"
	}
#line 225 "broker.vala"
	list = NULL;
#line 227 "broker.vala"
	_tmp7_ = ordering;
#line 227 "broker.vala"
	if (_tmp7_ != NULL) {
#line 1808 "broker.c"
		gchar** tokens = NULL;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 228 "broker.vala"
		_tmp8_ = ordering;
#line 228 "broker.vala"
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, ",", 0);
#line 228 "broker.vala"
		tokens = _tmp10_;
#line 228 "broker.vala"
		tokens_length1 = _vala_array_length (_tmp9_);
#line 228 "broker.vala"
		_tokens_size_ = tokens_length1;
#line 229 "broker.vala"
		_tmp11_ = tokens;
#line 229 "broker.vala"
		_tmp11__length1 = tokens_length1;
#line 1831 "broker.c"
		{
			gchar** token_collection = NULL;
			gint token_collection_length1 = 0;
			gint _token_collection_size_ = 0;
			gint token_it = 0;
#line 229 "broker.vala"
			token_collection = _tmp11_;
#line 229 "broker.vala"
			token_collection_length1 = _tmp11__length1;
#line 229 "broker.vala"
			for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
#line 1843 "broker.c"
				const gchar* token = NULL;
#line 229 "broker.vala"
				token = token_collection[token_it];
#line 1847 "broker.c"
				{
					gchar* tok = NULL;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					GSList* _tmp14_;
#line 230 "broker.vala"
					_tmp12_ = token;
#line 230 "broker.vala"
					_tmp13_ = string_strip (_tmp12_);
#line 230 "broker.vala"
					tok = _tmp13_;
#line 232 "broker.vala"
					_tmp14_ = self->provider_list;
#line 1861 "broker.c"
					{
						GSList* provider_collection = NULL;
						GSList* provider_it = NULL;
#line 232 "broker.vala"
						provider_collection = _tmp14_;
#line 232 "broker.vala"
						for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 1869 "broker.c"
							EnchantProvider* provider = NULL;
#line 232 "broker.vala"
							provider = (EnchantProvider*) provider_it->data;
#line 1873 "broker.c"
							{
								gboolean _tmp15_ = FALSE;
								EnchantProvider* _tmp16_;
#line 233 "broker.vala"
								_tmp16_ = provider;
#line 233 "broker.vala"
								if (_tmp16_ != NULL) {
#line 1881 "broker.c"
									const gchar* _tmp17_;
									EnchantProvider* _tmp18_;
									ProviderIdentify _tmp19_;
									EnchantProvider* _tmp20_;
									const gchar* _tmp21_;
#line 233 "broker.vala"
									_tmp17_ = tok;
#line 233 "broker.vala"
									_tmp18_ = provider;
#line 233 "broker.vala"
									_tmp19_ = _tmp18_->identify;
#line 233 "broker.vala"
									_tmp20_ = provider;
#line 233 "broker.vala"
									_tmp21_ = _tmp19_ (_tmp20_);
#line 233 "broker.vala"
									_tmp15_ = g_strcmp0 (_tmp17_, _tmp21_) == 0;
#line 1899 "broker.c"
								} else {
#line 233 "broker.vala"
									_tmp15_ = FALSE;
#line 1903 "broker.c"
								}
#line 233 "broker.vala"
								if (_tmp15_) {
#line 1907 "broker.c"
									EnchantProvider* _tmp22_;
#line 234 "broker.vala"
									_tmp22_ = provider;
#line 234 "broker.vala"
									list = g_slist_append (list, _tmp22_);
#line 1913 "broker.c"
								}
							}
						}
					}
#line 229 "broker.vala"
					_g_free0 (tok);
#line 1920 "broker.c"
				}
			}
		}
#line 227 "broker.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 1926 "broker.c"
	}
#line 239 "broker.vala"
	_tmp23_ = self->provider_list;
#line 1930 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 239 "broker.vala"
		provider_collection = _tmp23_;
#line 239 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 1938 "broker.c"
			EnchantProvider* provider = NULL;
#line 239 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 1942 "broker.c"
			{
				GSList* _tmp24_;
				EnchantProvider* _tmp25_;
				GSList* _tmp26_;
#line 240 "broker.vala"
				_tmp24_ = list;
#line 240 "broker.vala"
				_tmp25_ = provider;
#line 240 "broker.vala"
				_tmp26_ = g_slist_find (_tmp24_, _tmp25_);
#line 240 "broker.vala"
				if (_tmp26_ == NULL) {
#line 1955 "broker.c"
					EnchantProvider* _tmp27_;
#line 241 "broker.vala"
					_tmp27_ = provider;
#line 241 "broker.vala"
					list = g_slist_append (list, _tmp27_);
#line 1961 "broker.c"
				}
			}
		}
	}
#line 243 "broker.vala"
	result = list;
#line 243 "broker.vala"
	_g_free0 (ordering);
#line 243 "broker.vala"
	return result;
#line 1972 "broker.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1622 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1623 "glib-2.0.vapi"
	result = self;
#line 1623 "glib-2.0.vapi"
	return result;
#line 1985 "broker.c"
}

EnchantDict*
enchant_broker_request_pwl_dict (EnchantBroker* self,
                                 const gchar* pwl)
{
	gint _tmp0_;
	gint _tmp1_;
	EnchantSession* session = NULL;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	EnchantSession* _tmp7_;
	EnchantPwlDict* _tmp8_;
	EnchantPwlDict* _tmp9_;
	EnchantDict* _tmp10_;
	EnchantDict* _tmp11_;
	EnchantDict* result;
#line 246 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 246 "broker.vala"
	g_return_val_if_fail (pwl != NULL, NULL);
#line 246 "broker.vala"
	_tmp0_ = strlen (pwl);
#line 246 "broker.vala"
	_tmp1_ = _tmp0_;
#line 246 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "pwl.length > 0", NULL);
#line 249 "broker.vala"
	enchant_broker_clear_error (self);
#line 255 "broker.vala"
	_tmp2_ = enchant_session_with_pwl (pwl, NULL);
#line 255 "broker.vala"
	session = _tmp2_;
#line 256 "broker.vala"
	_tmp3_ = session;
#line 256 "broker.vala"
	if (_tmp3_ == NULL) {
#line 2023 "broker.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 257 "broker.vala"
		_tmp4_ = string_to_string (pwl);
#line 257 "broker.vala"
		_tmp5_ = g_strconcat ("Couldn't open personal wordlist '", _tmp4_, "'", NULL);
#line 257 "broker.vala"
		_tmp6_ = _tmp5_;
#line 257 "broker.vala"
		enchant_broker_set_error (self, _tmp6_);
#line 257 "broker.vala"
		_g_free0 (_tmp6_);
#line 258 "broker.vala"
		result = NULL;
#line 258 "broker.vala"
		_enchant_session_unref0 (session);
#line 258 "broker.vala"
		return result;
#line 2043 "broker.c"
	}
#line 261 "broker.vala"
	_tmp7_ = session;
#line 261 "broker.vala"
	_tmp8_ = enchant_pwl_dict_new (_tmp7_);
#line 261 "broker.vala"
	_tmp9_ = _tmp8_;
#line 261 "broker.vala"
	_tmp10_ = enchant_broker_new_dict (self, (EnchantDict*) _tmp9_);
#line 261 "broker.vala"
	_tmp11_ = _tmp10_;
#line 261 "broker.vala"
	_enchant_dict_unref0 (_tmp9_);
#line 261 "broker.vala"
	result = _tmp11_;
#line 261 "broker.vala"
	_enchant_session_unref0 (session);
#line 261 "broker.vala"
	return result;
#line 2063 "broker.c"
}

static EnchantDict*
_enchant_broker_request_dict (EnchantBroker* self,
                              const gchar* tag,
                              const gchar* pwl)
{
	GSList* _tmp0_;
	EnchantDict* result;
#line 264 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 264 "broker.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 265 "broker.vala"
	_tmp0_ = enchant_broker_get_ordered_providers (self, tag);
#line 2079 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 265 "broker.vala"
		provider_collection = _tmp0_;
#line 265 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2087 "broker.c"
			EnchantProvider* provider = NULL;
#line 265 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2091 "broker.c"
			{
				EnchantDict* dict = NULL;
				EnchantProvider* _tmp1_;
				ProviderRequestDict _tmp2_;
				EnchantProvider* _tmp3_;
				EnchantDict* _tmp4_;
				EnchantDict* _tmp5_;
#line 266 "broker.vala"
				_tmp1_ = provider;
#line 266 "broker.vala"
				_tmp2_ = _tmp1_->request_dict;
#line 266 "broker.vala"
				_tmp3_ = provider;
#line 266 "broker.vala"
				_tmp4_ = _tmp2_ (_tmp3_, tag);
#line 266 "broker.vala"
				dict = _tmp4_;
#line 267 "broker.vala"
				_tmp5_ = dict;
#line 267 "broker.vala"
				if (_tmp5_ != NULL) {
#line 2113 "broker.c"
					EnchantDict* _tmp6_;
					EnchantSession* _tmp7_;
					EnchantDict* _tmp8_;
					EnchantDict* _tmp9_;
#line 268 "broker.vala"
					_tmp6_ = dict;
#line 268 "broker.vala"
					_tmp7_ = enchant_session_with_implicit_pwl (tag, pwl);
#line 268 "broker.vala"
					_enchant_session_unref0 (_tmp6_->session);
#line 268 "broker.vala"
					_tmp6_->session = _tmp7_;
#line 269 "broker.vala"
					_tmp8_ = dict;
#line 269 "broker.vala"
					_tmp9_ = enchant_broker_new_dict (self, _tmp8_);
#line 269 "broker.vala"
					result = _tmp9_;
#line 269 "broker.vala"
					_enchant_dict_unref0 (dict);
#line 269 "broker.vala"
					(provider_collection == NULL) ? NULL : (provider_collection = (g_slist_free (provider_collection), NULL));
#line 269 "broker.vala"
					return result;
#line 2138 "broker.c"
				}
#line 265 "broker.vala"
				_enchant_dict_unref0 (dict);
#line 2142 "broker.c"
			}
		}
#line 265 "broker.vala"
		(provider_collection == NULL) ? NULL : (provider_collection = (g_slist_free (provider_collection), NULL));
#line 2147 "broker.c"
	}
#line 273 "broker.vala"
	result = NULL;
#line 273 "broker.vala"
	return result;
#line 2153 "broker.c"
}

EnchantDict*
enchant_broker_request_dict_with_pwl (EnchantBroker* self,
                                      const gchar* composite_tag,
                                      const gchar* pwl)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar** tags = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint tags_length1;
	gint _tags_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSList* dict_list = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GSList* _tmp20_;
	EnchantCompositeDict* comp_dict = NULL;
	GSList* _tmp23_;
	EnchantCompositeDict* _tmp24_;
	EnchantDict* dict = NULL;
	EnchantCompositeDict* _tmp25_;
	EnchantDict* _tmp26_;
	EnchantDict* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	EnchantSession* _tmp30_;
	EnchantDict* _tmp31_;
	EnchantDict* result;
#line 276 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 276 "broker.vala"
	g_return_val_if_fail (composite_tag != NULL, NULL);
#line 276 "broker.vala"
	_tmp0_ = strlen (composite_tag);
#line 276 "broker.vala"
	_tmp1_ = _tmp0_;
#line 276 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "composite_tag.length > 0", NULL);
#line 280 "broker.vala"
	_tmp3_ = _tmp2_ = g_strsplit (composite_tag, ",", 0);
#line 280 "broker.vala"
	tags = _tmp3_;
#line 280 "broker.vala"
	tags_length1 = _vala_array_length (_tmp2_);
#line 280 "broker.vala"
	_tags_size_ = tags_length1;
#line 281 "broker.vala"
	_tmp4_ = tags;
#line 281 "broker.vala"
	_tmp4__length1 = tags_length1;
#line 2209 "broker.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 281 "broker.vala"
		tag_collection = _tmp4_;
#line 281 "broker.vala"
		tag_collection_length1 = _tmp4__length1;
#line 281 "broker.vala"
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
#line 2221 "broker.c"
			const gchar* tag = NULL;
#line 281 "broker.vala"
			tag = tag_collection[tag_it];
#line 2225 "broker.c"
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 282 "broker.vala"
				_tmp5_ = tag;
#line 282 "broker.vala"
				_tmp6_ = strlen (_tmp5_);
#line 282 "broker.vala"
				_tmp7_ = _tmp6_;
#line 282 "broker.vala"
				if (_tmp7_ == 0) {
#line 283 "broker.vala"
					result = NULL;
#line 283 "broker.vala"
					tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 283 "broker.vala"
					return result;
#line 2244 "broker.c"
				}
			}
		}
	}
#line 285 "broker.vala"
	enchant_broker_clear_error (self);
#line 288 "broker.vala"
	dict_list = NULL;
#line 289 "broker.vala"
	_tmp8_ = tags;
#line 289 "broker.vala"
	_tmp8__length1 = tags_length1;
#line 2257 "broker.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 289 "broker.vala"
		tag_collection = _tmp8_;
#line 289 "broker.vala"
		tag_collection_length1 = _tmp8__length1;
#line 289 "broker.vala"
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
#line 2269 "broker.c"
			const gchar* tag = NULL;
#line 289 "broker.vala"
			tag = tag_collection[tag_it];
#line 2273 "broker.c"
			{
				gchar* normalized_tag = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				EnchantDict* dict = NULL;
				const gchar* _tmp11_;
				EnchantDict* _tmp12_;
				EnchantDict* _tmp13_;
				EnchantDict* _tmp18_;
				EnchantDict* _tmp19_;
#line 290 "broker.vala"
				_tmp9_ = tag;
#line 290 "broker.vala"
				_tmp10_ = normalize_dictionary_tag (_tmp9_);
#line 290 "broker.vala"
				normalized_tag = _tmp10_;
#line 291 "broker.vala"
				_tmp11_ = normalized_tag;
#line 291 "broker.vala"
				_tmp12_ = _enchant_broker_request_dict (self, _tmp11_, pwl);
#line 291 "broker.vala"
				dict = _tmp12_;
#line 292 "broker.vala"
				_tmp13_ = dict;
#line 292 "broker.vala"
				if (_tmp13_ == NULL) {
#line 2300 "broker.c"
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					EnchantDict* _tmp17_;
#line 293 "broker.vala"
					_tmp14_ = normalized_tag;
#line 293 "broker.vala"
					_tmp15_ = iso_639_from_tag (_tmp14_);
#line 293 "broker.vala"
					_tmp16_ = _tmp15_;
#line 293 "broker.vala"
					_tmp17_ = _enchant_broker_request_dict (self, _tmp16_, pwl);
#line 293 "broker.vala"
					dict = _tmp17_;
#line 293 "broker.vala"
					_g_free0 (_tmp16_);
#line 2317 "broker.c"
				}
#line 294 "broker.vala"
				_tmp18_ = dict;
#line 294 "broker.vala"
				if (_tmp18_ == NULL) {
#line 295 "broker.vala"
					result = NULL;
#line 295 "broker.vala"
					_g_free0 (normalized_tag);
#line 295 "broker.vala"
					(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 295 "broker.vala"
					tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 295 "broker.vala"
					return result;
#line 2333 "broker.c"
				}
#line 296 "broker.vala"
				_tmp19_ = dict;
#line 296 "broker.vala"
				dict_list = g_slist_append (dict_list, _tmp19_);
#line 289 "broker.vala"
				_g_free0 (normalized_tag);
#line 2341 "broker.c"
			}
		}
	}
#line 300 "broker.vala"
	_tmp20_ = dict_list;
#line 300 "broker.vala"
	if (g_slist_length (_tmp20_) == ((guint) 1)) {
#line 2349 "broker.c"
		GSList* _tmp21_;
		gconstpointer _tmp22_;
#line 301 "broker.vala"
		_tmp21_ = dict_list;
#line 301 "broker.vala"
		_tmp22_ = _tmp21_->data;
#line 301 "broker.vala"
		result = (EnchantDict*) _tmp22_;
#line 301 "broker.vala"
		(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 301 "broker.vala"
		tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 301 "broker.vala"
		return result;
#line 2364 "broker.c"
	}
#line 304 "broker.vala"
	_tmp23_ = dict_list;
#line 304 "broker.vala"
	dict_list = NULL;
#line 304 "broker.vala"
	_tmp24_ = enchant_composite_dict_new (self, _tmp23_, composite_tag);
#line 304 "broker.vala"
	comp_dict = _tmp24_;
#line 305 "broker.vala"
	_tmp25_ = comp_dict;
#line 305 "broker.vala"
	_tmp26_ = enchant_broker_new_dict (self, (EnchantDict*) _tmp25_);
#line 305 "broker.vala"
	dict = _tmp26_;
#line 306 "broker.vala"
	_tmp27_ = dict;
#line 306 "broker.vala"
	_tmp28_ = tags;
#line 306 "broker.vala"
	_tmp28__length1 = tags_length1;
#line 306 "broker.vala"
	_tmp29_ = _tmp28_[0];
#line 306 "broker.vala"
	_tmp30_ = enchant_session_with_implicit_pwl (_tmp29_, pwl);
#line 306 "broker.vala"
	_enchant_session_unref0 (_tmp27_->session);
#line 306 "broker.vala"
	_tmp27_->session = _tmp30_;
#line 307 "broker.vala"
	_tmp31_ = dict;
#line 307 "broker.vala"
	result = _tmp31_;
#line 307 "broker.vala"
	_enchant_dict_unref0 (comp_dict);
#line 307 "broker.vala"
	(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 307 "broker.vala"
	tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 307 "broker.vala"
	return result;
#line 2406 "broker.c"
}

EnchantDict*
enchant_broker_request_dict (EnchantBroker* self,
                             const gchar* tag)
{
	EnchantDict* _tmp0_;
	EnchantDict* result;
#line 310 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 310 "broker.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 311 "broker.vala"
	_tmp0_ = enchant_broker_request_dict_with_pwl (self, tag, NULL);
#line 311 "broker.vala"
	result = _tmp0_;
#line 311 "broker.vala"
	return result;
#line 2425 "broker.c"
}

void
enchant_broker_describe (EnchantBroker* self,
                         EnchantBrokerDescribeFn fn,
                         void* user_data)
{
	GSList* _tmp0_;
#line 314 "broker.vala"
	g_return_if_fail (self != NULL);
#line 314 "broker.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 318 "broker.vala"
	enchant_broker_clear_error (self);
#line 320 "broker.vala"
	_tmp0_ = self->provider_list;
#line 2442 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 320 "broker.vala"
		provider_collection = _tmp0_;
#line 320 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2450 "broker.c"
			EnchantProvider* provider = NULL;
#line 320 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2454 "broker.c"
			{
				gchar* name = NULL;
				EnchantProvider* _tmp1_;
				ProviderIdentify _tmp2_;
				EnchantProvider* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* desc = NULL;
				EnchantProvider* _tmp6_;
				ProviderDescribe _tmp7_;
				EnchantProvider* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* file = NULL;
				EnchantProvider* _tmp11_;
				GModule* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
#line 321 "broker.vala"
				_tmp1_ = provider;
#line 321 "broker.vala"
				_tmp2_ = _tmp1_->identify;
#line 321 "broker.vala"
				_tmp3_ = provider;
#line 321 "broker.vala"
				_tmp4_ = _tmp2_ (_tmp3_);
#line 321 "broker.vala"
				_tmp5_ = g_strdup (_tmp4_);
#line 321 "broker.vala"
				name = _tmp5_;
#line 322 "broker.vala"
				_tmp6_ = provider;
#line 322 "broker.vala"
				_tmp7_ = _tmp6_->describe;
#line 322 "broker.vala"
				_tmp8_ = provider;
#line 322 "broker.vala"
				_tmp9_ = _tmp7_ (_tmp8_);
#line 322 "broker.vala"
				_tmp10_ = g_strdup (_tmp9_);
#line 322 "broker.vala"
				desc = _tmp10_;
#line 323 "broker.vala"
				_tmp11_ = provider;
#line 323 "broker.vala"
				_tmp12_ = _tmp11_->module;
#line 323 "broker.vala"
				_tmp13_ = g_module_name (_tmp12_);
#line 323 "broker.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 323 "broker.vala"
				file = _tmp14_;
#line 325 "broker.vala"
				_tmp15_ = name;
#line 325 "broker.vala"
				_tmp16_ = desc;
#line 325 "broker.vala"
				_tmp17_ = file;
#line 325 "broker.vala"
				fn (_tmp15_, _tmp16_, _tmp17_, user_data);
#line 320 "broker.vala"
				_g_free0 (file);
#line 320 "broker.vala"
				_g_free0 (desc);
#line 320 "broker.vala"
				_g_free0 (name);
#line 2524 "broker.c"
			}
		}
	}
}

void
enchant_broker_list_dicts (EnchantBroker* self,
                           EnchantDictDescribeFn fn,
                           void* user_data)
{
	GHashTable* tag_map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSList* _tmp3_;
	GSList* _tmp4_;
	GSList* tags = NULL;
	GHashTable* _tmp38_;
	GList* _tmp39_;
	GSList* _tmp44_;
#line 329 "broker.vala"
	g_return_if_fail (self != NULL);
#line 329 "broker.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 332 "broker.vala"
	_tmp0_ = g_str_hash;
#line 332 "broker.vala"
	_tmp1_ = g_str_equal;
#line 332 "broker.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
#line 332 "broker.vala"
	tag_map = _tmp2_;
#line 334 "broker.vala"
	enchant_broker_clear_error (self);
#line 335 "broker.vala"
	g_debug ("broker.vala:335: listing dictionaries");
#line 336 "broker.vala"
	_tmp3_ = self->provider_list;
#line 336 "broker.vala"
	if (_tmp3_ == NULL) {
#line 337 "broker.vala"
		g_debug ("broker.vala:337: no providers found!");
#line 2567 "broker.c"
	}
#line 339 "broker.vala"
	_tmp4_ = self->provider_list;
#line 2571 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 339 "broker.vala"
		provider_collection = _tmp4_;
#line 339 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2579 "broker.c"
			EnchantProvider* provider = NULL;
#line 339 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2583 "broker.c"
			{
				EnchantProvider* _tmp5_;
				ProviderDescribe _tmp6_;
				EnchantProvider* _tmp7_;
				const gchar* _tmp8_;
				EnchantProvider* _tmp9_;
				ProviderListDicts _tmp10_;
				EnchantProvider* _tmp11_;
				size_t _tmp12_ = 0;
				gchar** _tmp13_;
#line 340 "broker.vala"
				_tmp5_ = provider;
#line 340 "broker.vala"
				_tmp6_ = _tmp5_->describe;
#line 340 "broker.vala"
				_tmp7_ = provider;
#line 340 "broker.vala"
				_tmp8_ = _tmp6_ (_tmp7_);
#line 340 "broker.vala"
				g_debug ("broker.vala:340: provider %s", _tmp8_);
#line 342 "broker.vala"
				_tmp9_ = provider;
#line 342 "broker.vala"
				_tmp10_ = _tmp9_->list_dicts;
#line 342 "broker.vala"
				_tmp11_ = provider;
#line 342 "broker.vala"
				_tmp13_ = _tmp10_ (_tmp11_, &_tmp12_);
#line 2612 "broker.c"
				{
					gchar** tag_collection = NULL;
					gint tag_collection_length1 = 0;
					gint _tag_collection_size_ = 0;
					gint tag_it = 0;
#line 342 "broker.vala"
					tag_collection = _tmp13_;
#line 342 "broker.vala"
					tag_collection_length1 = _tmp12_;
#line 342 "broker.vala"
					for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
#line 2624 "broker.c"
						gchar* _tmp14_;
						gchar* tag = NULL;
#line 342 "broker.vala"
						_tmp14_ = g_strdup (tag_collection[tag_it]);
#line 342 "broker.vala"
						tag = _tmp14_;
#line 2631 "broker.c"
						{
							const gchar* _tmp15_;
							const gchar* _tmp23_;
							GSList* providers = NULL;
							const gchar* _tmp24_;
							GSList* _tmp25_;
							gint this_priority = 0;
							GSList* _tmp26_;
							EnchantProvider* _tmp27_;
#line 343 "broker.vala"
							_tmp15_ = tag;
#line 343 "broker.vala"
							if (_tmp15_ == NULL) {
#line 2645 "broker.c"
								EnchantProvider* _tmp16_;
								ProviderIdentify _tmp17_;
								EnchantProvider* _tmp18_;
								const gchar* _tmp19_;
								const gchar* _tmp20_;
								gchar* _tmp21_;
								gchar* _tmp22_;
#line 344 "broker.vala"
								_tmp16_ = provider;
#line 344 "broker.vala"
								_tmp17_ = _tmp16_->identify;
#line 344 "broker.vala"
								_tmp18_ = provider;
#line 344 "broker.vala"
								_tmp19_ = _tmp17_ (_tmp18_);
#line 344 "broker.vala"
								_tmp20_ = string_to_string (_tmp19_);
#line 344 "broker.vala"
								_tmp21_ = g_strconcat ("null entry in dictionaries returned by ", _tmp20_, NULL);
#line 344 "broker.vala"
								_tmp22_ = _tmp21_;
#line 344 "broker.vala"
								enchant_broker_set_error (self, _tmp22_);
#line 344 "broker.vala"
								_g_free0 (_tmp22_);
#line 345 "broker.vala"
								_g_free0 (tag);
#line 345 "broker.vala"
								continue;
#line 2675 "broker.c"
							}
#line 347 "broker.vala"
							_tmp23_ = tag;
#line 347 "broker.vala"
							g_debug ("broker.vala:347: tag %s", _tmp23_);
#line 348 "broker.vala"
							_tmp24_ = tag;
#line 348 "broker.vala"
							_tmp25_ = enchant_broker_get_ordered_providers (self, _tmp24_);
#line 348 "broker.vala"
							providers = _tmp25_;
#line 349 "broker.vala"
							_tmp26_ = providers;
#line 349 "broker.vala"
							_tmp27_ = provider;
#line 349 "broker.vala"
							this_priority = g_slist_index (_tmp26_, _tmp27_);
#line 350 "broker.vala"
							g_debug ("broker.vala:350: priority %d", this_priority);
#line 351 "broker.vala"
							if (this_priority != -1) {
#line 2697 "broker.c"
								gint min_priority = 0;
								EnchantProvider* prov = NULL;
								GHashTable* _tmp28_;
								const gchar* _tmp29_;
								gconstpointer _tmp30_;
								EnchantProvider* _tmp31_;
#line 352 "broker.vala"
								min_priority = this_priority + 1;
#line 353 "broker.vala"
								_tmp28_ = tag_map;
#line 353 "broker.vala"
								_tmp29_ = tag;
#line 353 "broker.vala"
								_tmp30_ = g_hash_table_lookup (_tmp28_, _tmp29_);
#line 353 "broker.vala"
								prov = (EnchantProvider*) _tmp30_;
#line 354 "broker.vala"
								_tmp31_ = prov;
#line 354 "broker.vala"
								if (_tmp31_ != NULL) {
#line 2718 "broker.c"
									GSList* _tmp32_;
									EnchantProvider* _tmp33_;
#line 355 "broker.vala"
									_tmp32_ = providers;
#line 355 "broker.vala"
									_tmp33_ = prov;
#line 355 "broker.vala"
									min_priority = g_slist_index (_tmp32_, _tmp33_);
#line 2727 "broker.c"
								}
#line 356 "broker.vala"
								if (this_priority < min_priority) {
#line 2731 "broker.c"
									GHashTable* _tmp34_;
									const gchar* _tmp35_;
									gchar* _tmp36_;
									EnchantProvider* _tmp37_;
#line 357 "broker.vala"
									_tmp34_ = tag_map;
#line 357 "broker.vala"
									_tmp35_ = tag;
#line 357 "broker.vala"
									_tmp36_ = g_strdup (_tmp35_);
#line 357 "broker.vala"
									_tmp37_ = provider;
#line 357 "broker.vala"
									g_hash_table_insert (_tmp34_, _tmp36_, _tmp37_);
#line 2746 "broker.c"
								}
							}
#line 342 "broker.vala"
							(providers == NULL) ? NULL : (providers = (g_slist_free (providers), NULL));
#line 342 "broker.vala"
							_g_free0 (tag);
#line 2753 "broker.c"
						}
					}
#line 342 "broker.vala"
					tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2758 "broker.c"
				}
			}
		}
	}
#line 362 "broker.vala"
	tags = NULL;
#line 363 "broker.vala"
	_tmp38_ = tag_map;
#line 363 "broker.vala"
	_tmp39_ = g_hash_table_get_keys (_tmp38_);
#line 2769 "broker.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 363 "broker.vala"
		key_collection = _tmp39_;
#line 363 "broker.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 2777 "broker.c"
			gchar* _tmp40_;
			gchar* key = NULL;
#line 363 "broker.vala"
			_tmp40_ = g_strdup ((const gchar*) key_it->data);
#line 363 "broker.vala"
			key = _tmp40_;
#line 2784 "broker.c"
			{
				const gchar* _tmp41_;
				gchar* _tmp42_;
				GCompareFunc _tmp43_;
#line 364 "broker.vala"
				_tmp41_ = key;
#line 364 "broker.vala"
				_tmp42_ = g_strdup (_tmp41_);
#line 364 "broker.vala"
				_tmp43_ = ((GCompareFunc) g_strcmp0);
#line 364 "broker.vala"
				tags = g_slist_insert_sorted (tags, _tmp42_, _tmp43_);
#line 363 "broker.vala"
				_g_free0 (key);
#line 2799 "broker.c"
			}
		}
#line 363 "broker.vala"
		(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
#line 2804 "broker.c"
	}
#line 366 "broker.vala"
	_tmp44_ = tags;
#line 2808 "broker.c"
	{
		GSList* tag_collection = NULL;
		GSList* tag_it = NULL;
#line 366 "broker.vala"
		tag_collection = _tmp44_;
#line 366 "broker.vala"
		for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
#line 2816 "broker.c"
			gchar* _tmp45_;
			gchar* tag = NULL;
#line 366 "broker.vala"
			_tmp45_ = g_strdup ((const gchar*) tag_it->data);
#line 366 "broker.vala"
			tag = _tmp45_;
#line 2823 "broker.c"
			{
				EnchantProvider* provider = NULL;
				GHashTable* _tmp46_;
				const gchar* _tmp47_;
				gconstpointer _tmp48_;
				gchar* name = NULL;
				EnchantProvider* _tmp49_;
				ProviderIdentify _tmp50_;
				EnchantProvider* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* desc = NULL;
				EnchantProvider* _tmp54_;
				ProviderDescribe _tmp55_;
				EnchantProvider* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* file = NULL;
				EnchantProvider* _tmp59_;
				GModule* _tmp60_;
				const gchar* _tmp61_;
				gchar* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				const gchar* _tmp66_;
#line 367 "broker.vala"
				_tmp46_ = tag_map;
#line 367 "broker.vala"
				_tmp47_ = tag;
#line 367 "broker.vala"
				_tmp48_ = g_hash_table_lookup (_tmp46_, _tmp47_);
#line 367 "broker.vala"
				provider = (EnchantProvider*) _tmp48_;
#line 368 "broker.vala"
				_tmp49_ = provider;
#line 368 "broker.vala"
				_tmp50_ = _tmp49_->identify;
#line 368 "broker.vala"
				_tmp51_ = provider;
#line 368 "broker.vala"
				_tmp52_ = _tmp50_ (_tmp51_);
#line 368 "broker.vala"
				_tmp53_ = g_strdup (_tmp52_);
#line 368 "broker.vala"
				name = _tmp53_;
#line 369 "broker.vala"
				_tmp54_ = provider;
#line 369 "broker.vala"
				_tmp55_ = _tmp54_->describe;
#line 369 "broker.vala"
				_tmp56_ = provider;
#line 369 "broker.vala"
				_tmp57_ = _tmp55_ (_tmp56_);
#line 369 "broker.vala"
				_tmp58_ = g_strdup (_tmp57_);
#line 369 "broker.vala"
				desc = _tmp58_;
#line 370 "broker.vala"
				_tmp59_ = provider;
#line 370 "broker.vala"
				_tmp60_ = _tmp59_->module;
#line 370 "broker.vala"
				_tmp61_ = g_module_name (_tmp60_);
#line 370 "broker.vala"
				_tmp62_ = g_strdup (_tmp61_);
#line 370 "broker.vala"
				file = _tmp62_;
#line 371 "broker.vala"
				_tmp63_ = tag;
#line 371 "broker.vala"
				_tmp64_ = name;
#line 371 "broker.vala"
				_tmp65_ = desc;
#line 371 "broker.vala"
				_tmp66_ = file;
#line 371 "broker.vala"
				fn (_tmp63_, _tmp64_, _tmp65_, _tmp66_, user_data);
#line 366 "broker.vala"
				_g_free0 (file);
#line 366 "broker.vala"
				_g_free0 (desc);
#line 366 "broker.vala"
				_g_free0 (name);
#line 366 "broker.vala"
				_g_free0 (tag);
#line 2910 "broker.c"
			}
		}
	}
#line 329 "broker.vala"
	(tags == NULL) ? NULL : (tags = (_g_slist_free__g_free0_ (tags), NULL));
#line 329 "broker.vala"
	_g_hash_table_unref0 (tag_map);
#line 2918 "broker.c"
}

gint
_enchant_broker_dict_exists (EnchantBroker* self,
                             const gchar* tag)
{
	gint _tmp0_;
	gint _tmp1_;
	GSList* _tmp2_;
	gint result;
#line 375 "broker.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 375 "broker.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 375 "broker.vala"
	_tmp0_ = strlen (tag);
#line 375 "broker.vala"
	_tmp1_ = _tmp0_;
#line 375 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "tag.length > 0", 0);
#line 379 "broker.vala"
	_tmp2_ = self->provider_list;
#line 2941 "broker.c"
	{
		GSList* provider_collection = NULL;
		GSList* provider_it = NULL;
#line 379 "broker.vala"
		provider_collection = _tmp2_;
#line 379 "broker.vala"
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
#line 2949 "broker.c"
			EnchantProvider* provider = NULL;
#line 379 "broker.vala"
			provider = (EnchantProvider*) provider_it->data;
#line 2953 "broker.c"
			{
				EnchantProvider* _tmp3_;
#line 380 "broker.vala"
				_tmp3_ = provider;
#line 380 "broker.vala"
				if (_enchant_provider_dictionary_exists (_tmp3_, tag) != 0) {
#line 381 "broker.vala"
					result = 1;
#line 381 "broker.vala"
					return result;
#line 2964 "broker.c"
				}
			}
		}
	}
#line 383 "broker.vala"
	result = 0;
#line 383 "broker.vala"
	return result;
#line 2973 "broker.c"
}

gint
enchant_broker_dict_exists (EnchantBroker* self,
                            const gchar* tag)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* normalized_tag = NULL;
	gchar* _tmp2_;
	gint exists = 0;
	const gchar* _tmp3_;
	gint result;
#line 386 "broker.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 386 "broker.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 386 "broker.vala"
	_tmp0_ = strlen (tag);
#line 386 "broker.vala"
	_tmp1_ = _tmp0_;
#line 386 "broker.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "tag.length > 0", 0);
#line 389 "broker.vala"
	enchant_broker_clear_error (self);
#line 391 "broker.vala"
	_tmp2_ = normalize_dictionary_tag (tag);
#line 391 "broker.vala"
	normalized_tag = _tmp2_;
#line 392 "broker.vala"
	exists = 0;
#line 394 "broker.vala"
	_tmp3_ = normalized_tag;
#line 394 "broker.vala"
	exists = _enchant_broker_dict_exists (self, _tmp3_);
#line 394 "broker.vala"
	if (exists == 0) {
#line 3011 "broker.c"
		gchar* iso_639_only_tag = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
#line 395 "broker.vala"
		_tmp4_ = normalized_tag;
#line 395 "broker.vala"
		_tmp5_ = iso_639_from_tag (_tmp4_);
#line 395 "broker.vala"
		iso_639_only_tag = _tmp5_;
#line 396 "broker.vala"
		_tmp6_ = iso_639_only_tag;
#line 396 "broker.vala"
		if (_tmp6_ == NULL) {
#line 397 "broker.vala"
			result = 0;
#line 397 "broker.vala"
			_g_free0 (iso_639_only_tag);
#line 397 "broker.vala"
			_g_free0 (normalized_tag);
#line 397 "broker.vala"
			return result;
#line 3036 "broker.c"
		}
#line 399 "broker.vala"
		_tmp7_ = normalized_tag;
#line 399 "broker.vala"
		_tmp8_ = iso_639_only_tag;
#line 399 "broker.vala"
		if (g_strcmp0 (_tmp7_, _tmp8_) != 0) {
#line 3044 "broker.c"
			const gchar* _tmp9_;
#line 400 "broker.vala"
			_tmp9_ = iso_639_only_tag;
#line 400 "broker.vala"
			exists = _enchant_broker_dict_exists (self, _tmp9_);
#line 3050 "broker.c"
		}
#line 394 "broker.vala"
		_g_free0 (iso_639_only_tag);
#line 3054 "broker.c"
	}
#line 403 "broker.vala"
	result = exists;
#line 403 "broker.vala"
	_g_free0 (normalized_tag);
#line 403 "broker.vala"
	return result;
#line 3062 "broker.c"
}

static gpointer
_enchant_dict_ref0 (gpointer self)
{
#line 407 "broker.vala"
	return self ? enchant_dict_ref (self) : NULL;
#line 3070 "broker.c"
}

EnchantDict*
enchant_broker_new_dict (EnchantBroker* self,
                         EnchantDict* dict)
{
	GHashTable* _tmp0_;
	EnchantDict* _tmp1_;
	EnchantDict* dict_ref = NULL;
	EnchantDict* result;
#line 406 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 406 "broker.vala"
	g_return_val_if_fail (dict != NULL, NULL);
#line 407 "broker.vala"
	_tmp0_ = self->dicts;
#line 407 "broker.vala"
	_tmp1_ = _enchant_dict_ref0 (dict);
#line 407 "broker.vala"
	g_hash_table_add (_tmp0_, _tmp1_);
#line 408 "broker.vala"
	dict_ref = dict;
#line 409 "broker.vala"
	result = dict_ref;
#line 409 "broker.vala"
	return result;
#line 3097 "broker.c"
}

void
enchant_broker_free_dict (EnchantBroker* self,
                          EnchantDict* dict)
{
	GHashTable* _tmp0_;
#line 412 "broker.vala"
	g_return_if_fail (self != NULL);
#line 412 "broker.vala"
	g_return_if_fail (dict != NULL);
#line 413 "broker.vala"
	_tmp0_ = self->dicts;
#line 413 "broker.vala"
	g_hash_table_remove (_tmp0_, dict);
#line 414 "broker.vala"
	enchant_broker_clear_error (self);
#line 3115 "broker.c"
}

const gchar*
enchant_broker_get_error (EnchantBroker* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 104 "broker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "broker.vala"
	_tmp0_ = self->_error;
#line 104 "broker.vala"
	result = _tmp0_;
#line 104 "broker.vala"
	return result;
#line 3131 "broker.c"
}

void
enchant_broker_set_error (EnchantBroker* self,
                          const gchar* value)
{
	gchar* _tmp0_;
#line 105 "broker.vala"
	g_return_if_fail (self != NULL);
#line 105 "broker.vala"
	_tmp0_ = g_strdup (value);
#line 105 "broker.vala"
	_g_free0 (self->_error);
#line 105 "broker.vala"
	self->_error = _tmp0_;
#line 3147 "broker.c"
}

static void
enchant_broker_instance_init (EnchantBroker * self)
{
}

void
enchant_broker_free (EnchantBroker * self)
{
#line 96 "broker.vala"
	g_return_if_fail (self != NULL);
#line 77 "broker.vala"
	(self->provider_list == NULL) ? NULL : (self->provider_list = (_g_slist_free__enchant_provider_unref0_ (self->provider_list), NULL));
#line 78 "broker.vala"
	_g_hash_table_unref0 (self->provider_ordering);
#line 79 "broker.vala"
	_g_hash_table_unref0 (self->dicts);
#line 81 "broker.vala"
	_g_free0 (self->_error);
#line 76 "broker.vala"
	g_slice_free (EnchantBroker, self);
#line 3170 "broker.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

