#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsAddLogContainer(plfolog: *const super::super::Foundation::FILE_OBJECT, pcbcontainer: *const u64, puszcontainerpath: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsAddLogContainer(plfolog : *const super::super::Foundation:: FILE_OBJECT, pcbcontainer : *const u64, puszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsAddLogContainer(plfolog, pcbcontainer, puszcontainerpath) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsAddLogContainerSet(plfolog: *const super::super::Foundation::FILE_OBJECT, pcbcontainer: Option<*const u64>, rguszcontainerpath: &[super::super::super::Win32::Foundation::UNICODE_STRING]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsAddLogContainerSet(plfolog : *const super::super::Foundation:: FILE_OBJECT, ccontainers : u16, pcbcontainer : *const u64, rguszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsAddLogContainerSet(plfolog, rguszcontainerpath.len().try_into().unwrap(), pcbcontainer.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(rguszcontainerpath.as_ptr())) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsAdvanceLogBase(pvmarshalcontext: *mut core::ffi::c_void, plsnbase: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, fflags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsAdvanceLogBase(pvmarshalcontext : *mut core::ffi::c_void, plsnbase : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, fflags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsAdvanceLogBase(pvmarshalcontext as _, plsnbase, fflags) }
}
#[inline]
pub unsafe fn ClfsAlignReservedLog(pvmarshalcontext: *const core::ffi::c_void, rgcbreservation: &[i64], pcbalignreservation: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsAlignReservedLog(pvmarshalcontext : *const core::ffi::c_void, crecords : u32, rgcbreservation : *const i64, pcbalignreservation : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsAlignReservedLog(pvmarshalcontext, rgcbreservation.len().try_into().unwrap(), core::mem::transmute(rgcbreservation.as_ptr()), pcbalignreservation as _) }
}
#[inline]
pub unsafe fn ClfsAllocReservedLog(pvmarshalcontext: *const core::ffi::c_void, pcbadjustment: &[i64]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsAllocReservedLog(pvmarshalcontext : *const core::ffi::c_void, crecords : u32, pcbadjustment : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsAllocReservedLog(pvmarshalcontext, pcbadjustment.len().try_into().unwrap(), core::mem::transmute(pcbadjustment.as_ptr())) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCloseAndResetLogFile(plfolog: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsCloseAndResetLogFile(plfolog : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsCloseAndResetLogFile(plfolog) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCloseLogFileObject(plfolog: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsCloseLogFileObject(plfolog : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsCloseLogFileObject(plfolog) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateLogFile(pplfolog: *mut *mut super::super::Foundation::FILE_OBJECT, puszlogfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, fdesiredaccess: u32, dwsharemode: u32, psdlogfile: Option<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, fcreatedisposition: u32, fcreateoptions: u32, fflagsandattributes: u32, flogoptionflag: u32, pvcontext: Option<*const core::ffi::c_void>, cbcontext: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsCreateLogFile(pplfolog : *mut *mut super::super::Foundation:: FILE_OBJECT, puszlogfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, fdesiredaccess : u32, dwsharemode : u32, psdlogfile : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, fcreatedisposition : u32, fcreateoptions : u32, fflagsandattributes : u32, flogoptionflag : u32, pvcontext : *const core::ffi::c_void, cbcontext : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsCreateLogFile(pplfolog as _, puszlogfilename, fdesiredaccess, dwsharemode, psdlogfile.unwrap_or(core::mem::zeroed()) as _, fcreatedisposition, fcreateoptions, fflagsandattributes, flogoptionflag, pvcontext.unwrap_or(core::mem::zeroed()) as _, cbcontext) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateMarshallingArea(plfolog: *const super::super::Foundation::FILE_OBJECT, epooltype: super::super::Foundation::POOL_TYPE, pfnallocbuffer: PALLOCATE_FUNCTION, pfnfreebuffer: super::super::Foundation::PFREE_FUNCTION, cbmarshallingbuffer: u32, cmaxwritebuffers: u32, cmaxreadbuffers: u32, ppvmarshalcontext: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsCreateMarshallingArea(plfolog : *const super::super::Foundation:: FILE_OBJECT, epooltype : super::super::Foundation:: POOL_TYPE, pfnallocbuffer : PALLOCATE_FUNCTION, pfnfreebuffer : super::super::Foundation:: PFREE_FUNCTION, cbmarshallingbuffer : u32, cmaxwritebuffers : u32, cmaxreadbuffers : u32, ppvmarshalcontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsCreateMarshallingArea(plfolog, epooltype, pfnallocbuffer, pfnfreebuffer, cbmarshallingbuffer, cmaxwritebuffers, cmaxreadbuffers, ppvmarshalcontext as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateMarshallingAreaEx(plfolog: *const super::super::Foundation::FILE_OBJECT, epooltype: super::super::Foundation::POOL_TYPE, pfnallocbuffer: PALLOCATE_FUNCTION, pfnfreebuffer: super::super::Foundation::PFREE_FUNCTION, cbmarshallingbuffer: u32, cmaxwritebuffers: u32, cmaxreadbuffers: u32, calignmentsize: u32, fflags: u64, ppvmarshalcontext: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsCreateMarshallingAreaEx(plfolog : *const super::super::Foundation:: FILE_OBJECT, epooltype : super::super::Foundation:: POOL_TYPE, pfnallocbuffer : PALLOCATE_FUNCTION, pfnfreebuffer : super::super::Foundation:: PFREE_FUNCTION, cbmarshallingbuffer : u32, cmaxwritebuffers : u32, cmaxreadbuffers : u32, calignmentsize : u32, fflags : u64, ppvmarshalcontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsCreateMarshallingAreaEx(plfolog, epooltype, pfnallocbuffer, pfnfreebuffer, cbmarshallingbuffer, cmaxwritebuffers, cmaxreadbuffers, calignmentsize, fflags, ppvmarshalcontext as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateScanContext(plfolog: *const super::super::Foundation::FILE_OBJECT, cfromcontainer: u32, ccontainers: u32, escanmode: u8, pcxscan: *mut super::super::super::Win32::Storage::FileSystem::CLS_SCAN_CONTEXT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsCreateScanContext(plfolog : *const super::super::Foundation:: FILE_OBJECT, cfromcontainer : u32, ccontainers : u32, escanmode : u8, pcxscan : *mut super::super::super::Win32::Storage::FileSystem:: CLS_SCAN_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsCreateScanContext(plfolog, cfromcontainer, ccontainers, escanmode, pcxscan as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsDeleteLogByPointer(plfolog: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsDeleteLogByPointer(plfolog : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsDeleteLogByPointer(plfolog) }
}
#[inline]
pub unsafe fn ClfsDeleteLogFile(puszlogfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, pvreserved: Option<*const core::ffi::c_void>, flogoptionflag: u32, pvcontext: Option<*const core::ffi::c_void>, cbcontext: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsDeleteLogFile(puszlogfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, pvreserved : *const core::ffi::c_void, flogoptionflag : u32, pvcontext : *const core::ffi::c_void, cbcontext : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsDeleteLogFile(puszlogfilename, pvreserved.unwrap_or(core::mem::zeroed()) as _, flogoptionflag, pvcontext.unwrap_or(core::mem::zeroed()) as _, cbcontext) }
}
#[inline]
pub unsafe fn ClfsDeleteMarshallingArea(pvmarshalcontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsDeleteMarshallingArea(pvmarshalcontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsDeleteMarshallingArea(pvmarshalcontext) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsEarlierLsn(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Storage::FileSystem::CLS_LSN {
    windows_link::link!("clfs.sys" "system" fn ClfsEarlierLsn(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Storage::FileSystem:: CLS_LSN);
    unsafe { ClfsEarlierLsn(plsn) }
}
#[inline]
pub unsafe fn ClfsFinalize() {
    windows_link::link!("clfs.sys" "system" fn ClfsFinalize());
    unsafe { ClfsFinalize() }
}
#[inline]
pub unsafe fn ClfsFlushBuffers(pvmarshalcontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsFlushBuffers(pvmarshalcontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsFlushBuffers(pvmarshalcontext) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsFlushToLsn(pvmarshalcontext: *const core::ffi::c_void, plsnflush: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnlastflushed: Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsFlushToLsn(pvmarshalcontext : *const core::ffi::c_void, plsnflush : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnlastflushed : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsFlushToLsn(pvmarshalcontext, plsnflush, plsnlastflushed.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ClfsFreeReservedLog(pvmarshalcontext: *const core::ffi::c_void, pcbadjustment: &[i64]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsFreeReservedLog(pvmarshalcontext : *const core::ffi::c_void, crecords : u32, pcbadjustment : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsFreeReservedLog(pvmarshalcontext, pcbadjustment.len().try_into().unwrap(), core::mem::transmute(pcbadjustment.as_ptr())) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsGetContainerName(plfolog: *const super::super::Foundation::FILE_OBJECT, cidlogicalcontainer: u32, puszcontainername: *mut super::super::super::Win32::Foundation::UNICODE_STRING, pcactuallencontainername: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsGetContainerName(plfolog : *const super::super::Foundation:: FILE_OBJECT, cidlogicalcontainer : u32, puszcontainername : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, pcactuallencontainername : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsGetContainerName(plfolog, cidlogicalcontainer, puszcontainername as _, pcactuallencontainername.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsGetIoStatistics(plfolog: *const super::super::Foundation::FILE_OBJECT, pvstatsbuffer: *mut core::ffi::c_void, cbstatsbuffer: u32, estatsclass: super::super::super::Win32::Storage::FileSystem::CLFS_IOSTATS_CLASS, pcbstatswritten: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsGetIoStatistics(plfolog : *const super::super::Foundation:: FILE_OBJECT, pvstatsbuffer : *mut core::ffi::c_void, cbstatsbuffer : u32, estatsclass : super::super::super::Win32::Storage::FileSystem:: CLFS_IOSTATS_CLASS, pcbstatswritten : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsGetIoStatistics(plfolog, pvstatsbuffer as _, cbstatsbuffer, estatsclass, pcbstatswritten.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsGetLogFileInformation(plfolog: *const super::super::Foundation::FILE_OBJECT, pinfobuffer: *mut super::super::super::Win32::Storage::FileSystem::CLS_INFORMATION, pcbinfobuffer: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsGetLogFileInformation(plfolog : *const super::super::Foundation:: FILE_OBJECT, pinfobuffer : *mut super::super::super::Win32::Storage::FileSystem:: CLS_INFORMATION, pcbinfobuffer : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsGetLogFileInformation(plfolog, pinfobuffer as _, pcbinfobuffer as _) }
}
#[inline]
pub unsafe fn ClfsInitialize() -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsInitialize() -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsInitialize() }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLaterLsn(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Storage::FileSystem::CLS_LSN {
    windows_link::link!("clfs.sys" "system" fn ClfsLaterLsn(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Storage::FileSystem:: CLS_LSN);
    unsafe { ClfsLaterLsn(plsn) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnBlockOffset(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> u32 {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnBlockOffset(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> u32);
    unsafe { ClfsLsnBlockOffset(plsn) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnContainer(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> u32 {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnContainer(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> u32);
    unsafe { ClfsLsnContainer(plsn) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnCreate(cidcontainer: u32, offblock: u32, crecord: u32) -> super::super::super::Win32::Storage::FileSystem::CLS_LSN {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnCreate(cidcontainer : u32, offblock : u32, crecord : u32) -> super::super::super::Win32::Storage::FileSystem:: CLS_LSN);
    unsafe { ClfsLsnCreate(cidcontainer, offblock, crecord) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnDifference(plsnstart: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnfinish: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, cbcontainer: u32, cbmaxblock: u32, pcbdifference: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnDifference(plsnstart : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnfinish : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, cbcontainer : u32, cbmaxblock : u32, pcbdifference : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsLsnDifference(plsnstart, plsnfinish, cbcontainer, cbmaxblock, pcbdifference as _) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnEqual(plsn1: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsn2: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> bool {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnEqual(plsn1 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsn2 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> bool);
    unsafe { ClfsLsnEqual(plsn1, plsn2) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnGreater(plsn1: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsn2: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> bool {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnGreater(plsn1 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsn2 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> bool);
    unsafe { ClfsLsnGreater(plsn1, plsn2) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnInvalid(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> bool {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnInvalid(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> bool);
    unsafe { ClfsLsnInvalid(plsn) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnLess(plsn1: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsn2: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> bool {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnLess(plsn1 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsn2 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> bool);
    unsafe { ClfsLsnLess(plsn1, plsn2) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnNull(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> bool {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnNull(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> bool);
    unsafe { ClfsLsnNull(plsn) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnRecordSequence(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> u32 {
    windows_link::link!("clfs.sys" "system" fn ClfsLsnRecordSequence(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> u32);
    unsafe { ClfsLsnRecordSequence(plsn) }
}
#[inline]
pub unsafe fn ClfsMgmtDeregisterManagedClient(clientcookie: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtDeregisterManagedClient(clientcookie : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtDeregisterManagedClient(clientcookie) }
}
#[inline]
pub unsafe fn ClfsMgmtHandleLogFileFull(client: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtHandleLogFileFull(client : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtHandleLogFileFull(client) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtInstallPolicy(logfile: *const super::super::Foundation::FILE_OBJECT, policy: *const super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY, policylength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtInstallPolicy(logfile : *const super::super::Foundation:: FILE_OBJECT, policy : *const super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY, policylength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtInstallPolicy(logfile, policy, policylength) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtQueryPolicy(logfile: *const super::super::Foundation::FILE_OBJECT, policytype: super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY_TYPE, policy: *mut super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY, policylength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtQueryPolicy(logfile : *const super::super::Foundation:: FILE_OBJECT, policytype : super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY_TYPE, policy : *mut super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY, policylength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtQueryPolicy(logfile, policytype, policy as _, policylength as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtRegisterManagedClient(logfile: *const super::super::Foundation::FILE_OBJECT, registrationdata: *const CLFS_MGMT_CLIENT_REGISTRATION, clientcookie: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtRegisterManagedClient(logfile : *const super::super::Foundation:: FILE_OBJECT, registrationdata : *const CLFS_MGMT_CLIENT_REGISTRATION, clientcookie : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtRegisterManagedClient(logfile, registrationdata, clientcookie as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtRemovePolicy(logfile: *const super::super::Foundation::FILE_OBJECT, policytype: super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtRemovePolicy(logfile : *const super::super::Foundation:: FILE_OBJECT, policytype : super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtRemovePolicy(logfile, policytype) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtSetLogFileSize(logfile: *const super::super::Foundation::FILE_OBJECT, newsizeincontainers: *const u64, resultingsizeincontainers: Option<*mut u64>, completionroutine: PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtSetLogFileSize(logfile : *const super::super::Foundation:: FILE_OBJECT, newsizeincontainers : *const u64, resultingsizeincontainers : *mut u64, completionroutine : PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtSetLogFileSize(logfile, newsizeincontainers, resultingsizeincontainers.unwrap_or(core::mem::zeroed()) as _, completionroutine, completionroutinedata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtSetLogFileSizeAsClient(logfile: *const super::super::Foundation::FILE_OBJECT, clientcookie: Option<*const *const core::ffi::c_void>, newsizeincontainers: *const u64, resultingsizeincontainers: Option<*mut u64>, completionroutine: PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtSetLogFileSizeAsClient(logfile : *const super::super::Foundation:: FILE_OBJECT, clientcookie : *const *const core::ffi::c_void, newsizeincontainers : *const u64, resultingsizeincontainers : *mut u64, completionroutine : PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtSetLogFileSizeAsClient(logfile, clientcookie.unwrap_or(core::mem::zeroed()) as _, newsizeincontainers, resultingsizeincontainers.unwrap_or(core::mem::zeroed()) as _, completionroutine, completionroutinedata.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ClfsMgmtTailAdvanceFailure(client: *const core::ffi::c_void, reason: super::super::super::Win32::Foundation::NTSTATUS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsMgmtTailAdvanceFailure(client : *const core::ffi::c_void, reason : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsMgmtTailAdvanceFailure(client, reason) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsQueryLogFileInformation(plfolog: *const super::super::Foundation::FILE_OBJECT, einformationclass: super::super::super::Win32::Storage::FileSystem::CLS_LOG_INFORMATION_CLASS, pinfoinputbuffer: Option<*const core::ffi::c_void>, cbinfoinputbuffer: Option<u32>, pinfobuffer: *mut core::ffi::c_void, pcbinfobuffer: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsQueryLogFileInformation(plfolog : *const super::super::Foundation:: FILE_OBJECT, einformationclass : super::super::super::Win32::Storage::FileSystem:: CLS_LOG_INFORMATION_CLASS, pinfoinputbuffer : *const core::ffi::c_void, cbinfoinputbuffer : u32, pinfobuffer : *mut core::ffi::c_void, pcbinfobuffer : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsQueryLogFileInformation(plfolog, einformationclass, pinfoinputbuffer.unwrap_or(core::mem::zeroed()) as _, cbinfoinputbuffer.unwrap_or(core::mem::zeroed()) as _, pinfobuffer as _, pcbinfobuffer as _) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadLogRecord(pvmarshalcontext: *const core::ffi::c_void, plsnfirst: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, pecontextmode: super::super::super::Win32::Storage::FileSystem::CLFS_CONTEXT_MODE, ppvreadbuffer: *mut *mut core::ffi::c_void, pcbreadbuffer: *mut u32, perecordtype: *mut u8, plsnundonext: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnprevious: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, ppvreadcontext: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsReadLogRecord(pvmarshalcontext : *const core::ffi::c_void, plsnfirst : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, pecontextmode : super::super::super::Win32::Storage::FileSystem:: CLFS_CONTEXT_MODE, ppvreadbuffer : *mut *mut core::ffi::c_void, pcbreadbuffer : *mut u32, perecordtype : *mut u8, plsnundonext : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, ppvreadcontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsReadLogRecord(pvmarshalcontext, plsnfirst as _, pecontextmode, ppvreadbuffer as _, pcbreadbuffer as _, perecordtype as _, plsnundonext as _, plsnprevious as _, ppvreadcontext as _) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadNextLogRecord(pvreadcontext: *mut core::ffi::c_void, ppvbuffer: *mut *mut core::ffi::c_void, pcbbuffer: *mut u32, perecordtype: *mut u8, plsnuser: Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, plsnundonext: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnprevious: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnrecord: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsReadNextLogRecord(pvreadcontext : *mut core::ffi::c_void, ppvbuffer : *mut *mut core::ffi::c_void, pcbbuffer : *mut u32, perecordtype : *mut u8, plsnuser : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnundonext : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnrecord : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsReadNextLogRecord(pvreadcontext as _, ppvbuffer as _, pcbbuffer as _, perecordtype as _, plsnuser.unwrap_or(core::mem::zeroed()) as _, plsnundonext as _, plsnprevious as _, plsnrecord as _) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadPreviousRestartArea(pvreadcontext: *const core::ffi::c_void, ppvrestartbuffer: *mut *mut core::ffi::c_void, pcbrestartbuffer: *mut u32, plsnrestart: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsReadPreviousRestartArea(pvreadcontext : *const core::ffi::c_void, ppvrestartbuffer : *mut *mut core::ffi::c_void, pcbrestartbuffer : *mut u32, plsnrestart : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsReadPreviousRestartArea(pvreadcontext, ppvrestartbuffer as _, pcbrestartbuffer as _, plsnrestart as _) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadRestartArea(pvmarshalcontext: *mut core::ffi::c_void, ppvrestartbuffer: *mut *mut core::ffi::c_void, pcbrestartbuffer: *mut u32, plsn: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, ppvreadcontext: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsReadRestartArea(pvmarshalcontext : *mut core::ffi::c_void, ppvrestartbuffer : *mut *mut core::ffi::c_void, pcbrestartbuffer : *mut u32, plsn : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, ppvreadcontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsReadRestartArea(pvmarshalcontext as _, ppvrestartbuffer as _, pcbrestartbuffer as _, plsn as _, ppvreadcontext as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsRemoveLogContainer(plfolog: *const super::super::Foundation::FILE_OBJECT, puszcontainerpath: *const super::super::super::Win32::Foundation::UNICODE_STRING, fforce: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsRemoveLogContainer(plfolog : *const super::super::Foundation:: FILE_OBJECT, puszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, fforce : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsRemoveLogContainer(plfolog, puszcontainerpath, fforce) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsRemoveLogContainerSet(plfolog: *const super::super::Foundation::FILE_OBJECT, rgwszcontainerpath: &[super::super::super::Win32::Foundation::UNICODE_STRING], fforce: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsRemoveLogContainerSet(plfolog : *const super::super::Foundation:: FILE_OBJECT, ccontainers : u16, rgwszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, fforce : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsRemoveLogContainerSet(plfolog, rgwszcontainerpath.len().try_into().unwrap(), core::mem::transmute(rgwszcontainerpath.as_ptr()), fforce) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReserveAndAppendLog(pvmarshalcontext: *const core::ffi::c_void, rgwriteentries: Option<&[super::super::super::Win32::Storage::FileSystem::CLS_WRITE_ENTRY]>, plsnundonext: Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, plsnprevious: Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, rgcbreservation: Option<&mut [i64]>, fflags: u32, plsn: Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsReserveAndAppendLog(pvmarshalcontext : *const core::ffi::c_void, rgwriteentries : *const super::super::super::Win32::Storage::FileSystem:: CLS_WRITE_ENTRY, cwriteentries : u32, plsnundonext : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, creserverecords : u32, rgcbreservation : *mut i64, fflags : u32, plsn : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe {
        ClfsReserveAndAppendLog(
            pvmarshalcontext,
            core::mem::transmute(rgwriteentries.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            rgwriteentries.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            plsnundonext.unwrap_or(core::mem::zeroed()) as _,
            plsnprevious.unwrap_or(core::mem::zeroed()) as _,
            rgcbreservation.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(rgcbreservation.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fflags,
            plsn.unwrap_or(core::mem::zeroed()) as _,
        )
    }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReserveAndAppendLogAligned(pvmarshalcontext: *const core::ffi::c_void, rgwriteentries: Option<&[super::super::super::Win32::Storage::FileSystem::CLS_WRITE_ENTRY]>, cbentryalignment: u32, plsnundonext: Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, plsnprevious: Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, rgcbreservation: Option<&mut [i64]>, fflags: u32, plsn: Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsReserveAndAppendLogAligned(pvmarshalcontext : *const core::ffi::c_void, rgwriteentries : *const super::super::super::Win32::Storage::FileSystem:: CLS_WRITE_ENTRY, cwriteentries : u32, cbentryalignment : u32, plsnundonext : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, creserverecords : u32, rgcbreservation : *mut i64, fflags : u32, plsn : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe {
        ClfsReserveAndAppendLogAligned(
            pvmarshalcontext,
            core::mem::transmute(rgwriteentries.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            rgwriteentries.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            cbentryalignment,
            plsnundonext.unwrap_or(core::mem::zeroed()) as _,
            plsnprevious.unwrap_or(core::mem::zeroed()) as _,
            rgcbreservation.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(rgcbreservation.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fflags,
            plsn.unwrap_or(core::mem::zeroed()) as _,
        )
    }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsScanLogContainers(pcxscan: *mut super::super::super::Win32::Storage::FileSystem::CLS_SCAN_CONTEXT, escanmode: u8) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsScanLogContainers(pcxscan : *mut super::super::super::Win32::Storage::FileSystem:: CLS_SCAN_CONTEXT, escanmode : u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsScanLogContainers(pcxscan as _, escanmode) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsSetArchiveTail(plfolog: *const super::super::Foundation::FILE_OBJECT, plsnarchivetail: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsSetArchiveTail(plfolog : *const super::super::Foundation:: FILE_OBJECT, plsnarchivetail : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsSetArchiveTail(plfolog, plsnarchivetail) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsSetEndOfLog(plfolog: *const super::super::Foundation::FILE_OBJECT, plsnend: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsSetEndOfLog(plfolog : *const super::super::Foundation:: FILE_OBJECT, plsnend : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsSetEndOfLog(plfolog, plsnend) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsSetLogFileInformation(plfolog: *const super::super::Foundation::FILE_OBJECT, einformationclass: super::super::super::Win32::Storage::FileSystem::CLS_LOG_INFORMATION_CLASS, pinfobuffer: *const core::ffi::c_void, cbbuffer: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsSetLogFileInformation(plfolog : *const super::super::Foundation:: FILE_OBJECT, einformationclass : super::super::super::Win32::Storage::FileSystem:: CLS_LOG_INFORMATION_CLASS, pinfobuffer : *const core::ffi::c_void, cbbuffer : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsSetLogFileInformation(plfolog, einformationclass, pinfobuffer, cbbuffer) }
}
#[inline]
pub unsafe fn ClfsTerminateReadLog(pvcursorcontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsTerminateReadLog(pvcursorcontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsTerminateReadLog(pvcursorcontext) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsWriteRestartArea(pvmarshalcontext: *mut core::ffi::c_void, pvrestartbuffer: *const core::ffi::c_void, cbrestartbuffer: u32, plsnbase: Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, fflags: u32, pcbwritten: Option<*mut u32>, plsnnext: Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("clfs.sys" "system" fn ClfsWriteRestartArea(pvmarshalcontext : *mut core::ffi::c_void, pvrestartbuffer : *const core::ffi::c_void, cbrestartbuffer : u32, plsnbase : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, fflags : u32, pcbwritten : *mut u32, plsnnext : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ClfsWriteRestartArea(pvmarshalcontext as _, pvrestartbuffer, cbrestartbuffer, plsnbase.unwrap_or(core::mem::zeroed()) as _, fflags, pcbwritten.unwrap_or(core::mem::zeroed()) as _, plsnnext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn CmCallbackGetKeyObjectID(cookie: *const i64, object: *const core::ffi::c_void, objectid: Option<*mut usize>, objectname: Option<*mut *mut super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn CmCallbackGetKeyObjectID(cookie : *const i64, object : *const core::ffi::c_void, objectid : *mut usize, objectname : *mut *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { CmCallbackGetKeyObjectID(cookie, object, objectid.unwrap_or(core::mem::zeroed()) as _, objectname.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn CmCallbackGetKeyObjectIDEx(cookie: *const i64, object: *const core::ffi::c_void, objectid: Option<*mut usize>, objectname: Option<*mut *mut super::super::super::Win32::Foundation::UNICODE_STRING>, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn CmCallbackGetKeyObjectIDEx(cookie : *const i64, object : *const core::ffi::c_void, objectid : *mut usize, objectname : *mut *mut super::super::super::Win32::Foundation:: UNICODE_STRING, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { CmCallbackGetKeyObjectIDEx(cookie, object, objectid.unwrap_or(core::mem::zeroed()) as _, objectname.unwrap_or(core::mem::zeroed()) as _, flags) }
}
#[inline]
pub unsafe fn CmCallbackReleaseKeyObjectIDEx(objectname: *const super::super::super::Win32::Foundation::UNICODE_STRING) {
    windows_link::link!("ntoskrnl.exe" "system" fn CmCallbackReleaseKeyObjectIDEx(objectname : *const super::super::super::Win32::Foundation:: UNICODE_STRING));
    unsafe { CmCallbackReleaseKeyObjectIDEx(objectname) }
}
#[inline]
pub unsafe fn CmGetBoundTransaction(cookie: *const i64, object: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn CmGetBoundTransaction(cookie : *const i64, object : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { CmGetBoundTransaction(cookie, object) }
}
#[inline]
pub unsafe fn CmGetCallbackVersion(major: Option<*mut u32>, minor: Option<*mut u32>) {
    windows_link::link!("ntoskrnl.exe" "system" fn CmGetCallbackVersion(major : *mut u32, minor : *mut u32));
    unsafe { CmGetCallbackVersion(major.unwrap_or(core::mem::zeroed()) as _, minor.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn CmRegisterCallback(function: PEX_CALLBACK_FUNCTION, context: Option<*const core::ffi::c_void>, cookie: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn CmRegisterCallback(function : PEX_CALLBACK_FUNCTION, context : *const core::ffi::c_void, cookie : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { CmRegisterCallback(function, context.unwrap_or(core::mem::zeroed()) as _, cookie as _) }
}
#[inline]
pub unsafe fn CmRegisterCallbackEx(function: PEX_CALLBACK_FUNCTION, altitude: *const super::super::super::Win32::Foundation::UNICODE_STRING, driver: *const core::ffi::c_void, context: Option<*const core::ffi::c_void>, cookie: *mut i64, reserved: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn CmRegisterCallbackEx(function : PEX_CALLBACK_FUNCTION, altitude : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driver : *const core::ffi::c_void, context : *const core::ffi::c_void, cookie : *mut i64, reserved : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { CmRegisterCallbackEx(function, altitude, driver, context.unwrap_or(core::mem::zeroed()) as _, cookie as _, reserved.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn CmSetCallbackObjectContext(object: *mut core::ffi::c_void, cookie: *const i64, newcontext: *const core::ffi::c_void, oldcontext: Option<*mut *mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn CmSetCallbackObjectContext(object : *mut core::ffi::c_void, cookie : *const i64, newcontext : *const core::ffi::c_void, oldcontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { CmSetCallbackObjectContext(object as _, cookie, newcontext, oldcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn CmUnRegisterCallback(cookie: i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn CmUnRegisterCallback(cookie : i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { CmUnRegisterCallback(cookie) }
}
#[inline]
pub unsafe fn DbgBreakPointWithStatus(status: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn DbgBreakPointWithStatus(status : u32));
    unsafe { DbgBreakPointWithStatus(status) }
}
#[inline]
pub unsafe fn DbgPrint<P0>(format: P0) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "cdecl" fn DbgPrint(format : windows_core::PCSTR) -> u32);
    unsafe { DbgPrint(format.param().abi()) }
}
#[inline]
pub unsafe fn DbgPrintEx<P2>(componentid: u32, level: u32, format: P2) -> u32
where
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "cdecl" fn DbgPrintEx(componentid : u32, level : u32, format : windows_core::PCSTR) -> u32);
    unsafe { DbgPrintEx(componentid, level, format.param().abi()) }
}
#[inline]
pub unsafe fn DbgPrintReturnControlC<P0>(format: P0) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "cdecl" fn DbgPrintReturnControlC(format : windows_core::PCSTR) -> u32);
    unsafe { DbgPrintReturnControlC(format.param().abi()) }
}
#[inline]
pub unsafe fn DbgPrompt<P0>(prompt: P0, response: &mut [u8]) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn DbgPrompt(prompt : windows_core::PCSTR, response : windows_core::PSTR, length : u32) -> u32);
    unsafe { DbgPrompt(prompt.param().abi(), core::mem::transmute(response.as_ptr()), response.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn DbgQueryDebugFilterState(componentid: u32, level: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn DbgQueryDebugFilterState(componentid : u32, level : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { DbgQueryDebugFilterState(componentid, level) }
}
#[inline]
pub unsafe fn DbgSetDebugFilterState(componentid: u32, level: u32, state: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn DbgSetDebugFilterState(componentid : u32, level : u32, state : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { DbgSetDebugFilterState(componentid, level, state) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn DbgSetDebugPrintCallback(debugprintcallback: PDEBUG_PRINT_CALLBACK, enable: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn DbgSetDebugPrintCallback(debugprintcallback : PDEBUG_PRINT_CALLBACK, enable : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { DbgSetDebugPrintCallback(debugprintcallback, enable) }
}
#[inline]
pub unsafe fn EtwActivityIdControl(controlcode: u32, activityid: *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwActivityIdControl(controlcode : u32, activityid : *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwActivityIdControl(controlcode, activityid as _) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwEventEnabled(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR) -> bool {
    windows_link::link!("ntdll.dll" "system" fn EtwEventEnabled(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR) -> bool);
    unsafe { EtwEventEnabled(reghandle, eventdescriptor) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwProviderEnabled(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE, level: u8, keyword: u64) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwProviderEnabled(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE, level : u8, keyword : u64) -> bool);
    unsafe { EtwProviderEnabled(reghandle, level, keyword) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwRegister(providerid: *const windows_core::GUID, enablecallback: PETWENABLECALLBACK, callbackcontext: Option<*const core::ffi::c_void>, reghandle: *mut super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwRegister(providerid : *const windows_core::GUID, enablecallback : PETWENABLECALLBACK, callbackcontext : *const core::ffi::c_void, reghandle : *mut super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwRegister(providerid, enablecallback, callbackcontext.unwrap_or(core::mem::zeroed()) as _, reghandle as _) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwSetInformation(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE, informationclass: super::super::super::Win32::System::Diagnostics::Etw::EVENT_INFO_CLASS, eventinformation: Option<*const core::ffi::c_void>, informationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwSetInformation(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE, informationclass : super::super::super::Win32::System::Diagnostics::Etw:: EVENT_INFO_CLASS, eventinformation : *const core::ffi::c_void, informationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwSetInformation(reghandle, informationclass, eventinformation.unwrap_or(core::mem::zeroed()) as _, informationlength) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwUnregister(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwUnregister(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwUnregister(reghandle) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwWrite(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR, activityid: Option<*const windows_core::GUID>, userdata: Option<&[super::super::super::Win32::System::Diagnostics::Etw::EVENT_DATA_DESCRIPTOR]>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwWrite(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR, activityid : *const windows_core::GUID, userdatacount : u32, userdata : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DATA_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwWrite(reghandle, eventdescriptor, activityid.unwrap_or(core::mem::zeroed()) as _, userdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(userdata.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwWriteEx(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR, filter: u64, flags: u32, activityid: Option<*const windows_core::GUID>, relatedactivityid: Option<*const windows_core::GUID>, userdata: Option<&[super::super::super::Win32::System::Diagnostics::Etw::EVENT_DATA_DESCRIPTOR]>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwWriteEx(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR, filter : u64, flags : u32, activityid : *const windows_core::GUID, relatedactivityid : *const windows_core::GUID, userdatacount : u32, userdata : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DATA_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwWriteEx(reghandle, eventdescriptor, filter, flags, activityid.unwrap_or(core::mem::zeroed()) as _, relatedactivityid.unwrap_or(core::mem::zeroed()) as _, userdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(userdata.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwWriteString<P4>(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE, level: u8, keyword: u64, activityid: Option<*const windows_core::GUID>, string: P4) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntoskrnl.exe" "system" fn EtwWriteString(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE, level : u8, keyword : u64, activityid : *const windows_core::GUID, string : windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwWriteString(reghandle, level, keyword, activityid.unwrap_or(core::mem::zeroed()) as _, string.param().abi()) }
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwWriteTransfer(reghandle: super::super::super::Win32::System::Diagnostics::Etw::REGHANDLE, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR, activityid: Option<*const windows_core::GUID>, relatedactivityid: Option<*const windows_core::GUID>, userdata: Option<&[super::super::super::Win32::System::Diagnostics::Etw::EVENT_DATA_DESCRIPTOR]>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn EtwWriteTransfer(reghandle : super::super::super::Win32::System::Diagnostics::Etw:: REGHANDLE, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR, activityid : *const windows_core::GUID, relatedactivityid : *const windows_core::GUID, userdatacount : u32, userdata : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DATA_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { EtwWriteTransfer(reghandle, eventdescriptor, activityid.unwrap_or(core::mem::zeroed()) as _, relatedactivityid.unwrap_or(core::mem::zeroed()) as _, userdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(userdata.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireFastMutex(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireFastMutex(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { ExAcquireFastMutex(fastmutex as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireFastMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireFastMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { ExAcquireFastMutexUnsafe(fastmutex as _) }
}
#[inline]
pub unsafe fn ExAcquirePushLockExclusiveEx(pushlock: *mut usize, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquirePushLockExclusiveEx(pushlock : *mut usize, flags : u32));
    unsafe { ExAcquirePushLockExclusiveEx(pushlock as _, flags) }
}
#[inline]
pub unsafe fn ExAcquirePushLockSharedEx(pushlock: *mut usize, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquirePushLockSharedEx(pushlock : *mut usize, flags : u32));
    unsafe { ExAcquirePushLockSharedEx(pushlock as _, flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireResourceExclusiveLite(resource: *mut super::super::Foundation::ERESOURCE, wait: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireResourceExclusiveLite(resource : *mut super::super::Foundation:: ERESOURCE, wait : bool) -> bool);
    unsafe { ExAcquireResourceExclusiveLite(resource as _, wait) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireResourceSharedLite(resource: *mut super::super::Foundation::ERESOURCE, wait: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireResourceSharedLite(resource : *mut super::super::Foundation:: ERESOURCE, wait : bool) -> bool);
    unsafe { ExAcquireResourceSharedLite(resource as _, wait) }
}
#[inline]
pub unsafe fn ExAcquireRundownProtection(runref: *mut EX_RUNDOWN_REF) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtection(runref : *mut EX_RUNDOWN_REF) -> bool);
    unsafe { ExAcquireRundownProtection(runref as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAcquireRundownProtectionCacheAware(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE) -> bool);
    unsafe { ExAcquireRundownProtectionCacheAware(runrefcacheaware) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAcquireRundownProtectionCacheAwareEx(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE, count: u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtectionCacheAwareEx(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, count : u32) -> bool);
    unsafe { ExAcquireRundownProtectionCacheAwareEx(runrefcacheaware, count) }
}
#[inline]
pub unsafe fn ExAcquireRundownProtectionEx(runref: *mut EX_RUNDOWN_REF, count: u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtectionEx(runref : *mut EX_RUNDOWN_REF, count : u32) -> bool);
    unsafe { ExAcquireRundownProtectionEx(runref as _, count) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireSharedStarveExclusive(resource: *mut super::super::Foundation::ERESOURCE, wait: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireSharedStarveExclusive(resource : *mut super::super::Foundation:: ERESOURCE, wait : bool) -> bool);
    unsafe { ExAcquireSharedStarveExclusive(resource as _, wait) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireSharedWaitForExclusive(resource: *mut super::super::Foundation::ERESOURCE, wait: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireSharedWaitForExclusive(resource : *mut super::super::Foundation:: ERESOURCE, wait : bool) -> bool);
    unsafe { ExAcquireSharedWaitForExclusive(resource as _, wait) }
}
#[inline]
pub unsafe fn ExAcquireSpinLockExclusive(spinlock: *mut i32) -> u8 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockExclusive(spinlock : *mut i32) -> u8);
    unsafe { ExAcquireSpinLockExclusive(spinlock as _) }
}
#[inline]
pub unsafe fn ExAcquireSpinLockExclusiveAtDpcLevel(spinlock: *mut i32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockExclusiveAtDpcLevel(spinlock : *mut i32));
    unsafe { ExAcquireSpinLockExclusiveAtDpcLevel(spinlock as _) }
}
#[inline]
pub unsafe fn ExAcquireSpinLockShared(spinlock: *mut i32) -> u8 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockShared(spinlock : *mut i32) -> u8);
    unsafe { ExAcquireSpinLockShared(spinlock as _) }
}
#[inline]
pub unsafe fn ExAcquireSpinLockSharedAtDpcLevel(spinlock: *mut i32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockSharedAtDpcLevel(spinlock : *mut i32));
    unsafe { ExAcquireSpinLockSharedAtDpcLevel(spinlock as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocateCacheAwareRundownProtection(pooltype: super::super::Foundation::POOL_TYPE, pooltag: u32) -> super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocateCacheAwareRundownProtection(pooltype : super::super::Foundation:: POOL_TYPE, pooltag : u32) -> super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE);
    unsafe { ExAllocateCacheAwareRundownProtection(pooltype, pooltag) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePool(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocatePool(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize) -> *mut core::ffi::c_void);
    unsafe { ExAllocatePool(pooltype, numberofbytes) }
}
#[inline]
pub unsafe fn ExAllocatePool2(flags: u64, numberofbytes: usize, tag: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocatePool2(flags : u64, numberofbytes : usize, tag : u32) -> *mut core::ffi::c_void);
    unsafe { ExAllocatePool2(flags, numberofbytes, tag) }
}
#[inline]
pub unsafe fn ExAllocatePool3(flags: u64, numberofbytes: usize, tag: u32, extendedparameters: Option<&[POOL_EXTENDED_PARAMETER]>) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocatePool3(flags : u64, numberofbytes : usize, tag : u32, extendedparameters : *const POOL_EXTENDED_PARAMETER, extendedparameterscount : u32) -> *mut core::ffi::c_void);
    unsafe { ExAllocatePool3(flags, numberofbytes, tag, core::mem::transmute(extendedparameters.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), extendedparameters.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithQuota(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithQuota(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize) -> *mut core::ffi::c_void);
    unsafe { ExAllocatePoolWithQuota(pooltype, numberofbytes) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithQuotaTag(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize, tag: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithQuotaTag(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize, tag : u32) -> *mut core::ffi::c_void);
    unsafe { ExAllocatePoolWithQuotaTag(pooltype, numberofbytes, tag) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithTag(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize, tag: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithTag(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize, tag : u32) -> *mut core::ffi::c_void);
    unsafe { ExAllocatePoolWithTag(pooltype, numberofbytes, tag) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithTagPriority(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize, tag: u32, priority: EX_POOL_PRIORITY) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithTagPriority(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize, tag : u32, priority : EX_POOL_PRIORITY) -> *mut core::ffi::c_void);
    unsafe { ExAllocatePoolWithTagPriority(pooltype, numberofbytes, tag, priority) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocateTimer(callback: PEXT_CALLBACK, callbackcontext: Option<*const core::ffi::c_void>, attributes: u32) -> super::super::Foundation::PEX_TIMER {
    windows_link::link!("ntoskrnl.exe" "system" fn ExAllocateTimer(callback : PEXT_CALLBACK, callbackcontext : *const core::ffi::c_void, attributes : u32) -> super::super::Foundation:: PEX_TIMER);
    unsafe { ExAllocateTimer(callback, callbackcontext.unwrap_or(core::mem::zeroed()) as _, attributes) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExCancelTimer(timer: super::super::Foundation::PEX_TIMER, parameters: Option<*const core::ffi::c_void>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExCancelTimer(timer : super::super::Foundation:: PEX_TIMER, parameters : *const core::ffi::c_void) -> bool);
    unsafe { ExCancelTimer(timer, parameters.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExCleanupRundownProtectionCacheAware(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExCleanupRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    unsafe { ExCleanupRundownProtectionCacheAware(runrefcacheaware) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExConvertExclusiveToSharedLite(resource: *mut super::super::Foundation::ERESOURCE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExConvertExclusiveToSharedLite(resource : *mut super::super::Foundation:: ERESOURCE));
    unsafe { ExConvertExclusiveToSharedLite(resource as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ExCreateCallback(callbackobject: *mut super::super::Foundation::PCALLBACK_OBJECT, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, create: bool, allowmultiplecallbacks: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExCreateCallback(callbackobject : *mut super::super::Foundation:: PCALLBACK_OBJECT, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, create : bool, allowmultiplecallbacks : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExCreateCallback(callbackobject as _, objectattributes, create, allowmultiplecallbacks) }
}
#[inline]
pub unsafe fn ExCreatePool(flags: u32, tag: usize, params: Option<*const POOL_CREATE_EXTENDED_PARAMS>, poolhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExCreatePool(flags : u32, tag : usize, params : *const POOL_CREATE_EXTENDED_PARAMS, poolhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExCreatePool(flags, tag, params.unwrap_or(core::mem::zeroed()) as _, poolhandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExDeleteResourceLite(resource: *mut super::super::Foundation::ERESOURCE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExDeleteResourceLite(resource : *mut super::super::Foundation:: ERESOURCE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExDeleteResourceLite(resource as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExDeleteTimer(timer: super::super::Foundation::PEX_TIMER, cancel: bool, wait: bool, parameters: Option<*const EXT_DELETE_PARAMETERS>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExDeleteTimer(timer : super::super::Foundation:: PEX_TIMER, cancel : bool, wait : bool, parameters : *const EXT_DELETE_PARAMETERS) -> bool);
    unsafe { ExDeleteTimer(timer, cancel, wait, parameters.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ExDestroyPool(poolhandle: super::super::super::Win32::Foundation::HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExDestroyPool(poolhandle : super::super::super::Win32::Foundation:: HANDLE));
    unsafe { ExDestroyPool(poolhandle) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExEnterCriticalRegionAndAcquireResourceExclusive(resource: *mut super::super::Foundation::ERESOURCE) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExEnterCriticalRegionAndAcquireResourceExclusive(resource : *mut super::super::Foundation:: ERESOURCE) -> *mut core::ffi::c_void);
    unsafe { ExEnterCriticalRegionAndAcquireResourceExclusive(resource as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExEnterCriticalRegionAndAcquireResourceShared(resource: *mut super::super::Foundation::ERESOURCE) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExEnterCriticalRegionAndAcquireResourceShared(resource : *mut super::super::Foundation:: ERESOURCE) -> *mut core::ffi::c_void);
    unsafe { ExEnterCriticalRegionAndAcquireResourceShared(resource as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExEnterCriticalRegionAndAcquireSharedWaitForExclusive(resource: *mut super::super::Foundation::ERESOURCE) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExEnterCriticalRegionAndAcquireSharedWaitForExclusive(resource : *mut super::super::Foundation:: ERESOURCE) -> *mut core::ffi::c_void);
    unsafe { ExEnterCriticalRegionAndAcquireSharedWaitForExclusive(resource as _) }
}
#[inline]
pub unsafe fn ExEnumerateSystemFirmwareTables(firmwaretableprovidersignature: u32, firmwaretablebuffer: Option<*mut core::ffi::c_void>, bufferlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExEnumerateSystemFirmwareTables(firmwaretableprovidersignature : u32, firmwaretablebuffer : *mut core::ffi::c_void, bufferlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExEnumerateSystemFirmwareTables(firmwaretableprovidersignature, firmwaretablebuffer.unwrap_or(core::mem::zeroed()) as _, bufferlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExExtendZone(zone: *mut ZONE_HEADER, segment: *mut core::ffi::c_void, segmentsize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExExtendZone(zone : *mut ZONE_HEADER, segment : *mut core::ffi::c_void, segmentsize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExExtendZone(zone as _, segment as _, segmentsize) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExFreeCacheAwareRundownProtection(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExFreeCacheAwareRundownProtection(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    unsafe { ExFreeCacheAwareRundownProtection(runrefcacheaware) }
}
#[inline]
pub unsafe fn ExFreePool(p: *mut core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExFreePool(p : *mut core::ffi::c_void));
    unsafe { ExFreePool(p as _) }
}
#[inline]
pub unsafe fn ExFreePool2(p: *mut core::ffi::c_void, tag: u32, extendedparameters: Option<&[POOL_EXTENDED_PARAMETER]>) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExFreePool2(p : *mut core::ffi::c_void, tag : u32, extendedparameters : *const POOL_EXTENDED_PARAMETER, extendedparameterscount : u32));
    unsafe { ExFreePool2(p as _, tag, core::mem::transmute(extendedparameters.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), extendedparameters.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())) }
}
#[inline]
pub unsafe fn ExFreePoolWithTag(p: *mut core::ffi::c_void, tag: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExFreePoolWithTag(p : *mut core::ffi::c_void, tag : u32));
    unsafe { ExFreePoolWithTag(p as _, tag) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExGetExclusiveWaiterCount(resource: *const super::super::Foundation::ERESOURCE) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExGetExclusiveWaiterCount(resource : *const super::super::Foundation:: ERESOURCE) -> u32);
    unsafe { ExGetExclusiveWaiterCount(resource) }
}
#[inline]
pub unsafe fn ExGetFirmwareEnvironmentVariable(variablename: *const super::super::super::Win32::Foundation::UNICODE_STRING, vendorguid: *const windows_core::GUID, value: Option<*mut core::ffi::c_void>, valuelength: *mut u32, attributes: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExGetFirmwareEnvironmentVariable(variablename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, vendorguid : *const windows_core::GUID, value : *mut core::ffi::c_void, valuelength : *mut u32, attributes : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExGetFirmwareEnvironmentVariable(variablename, vendorguid, value.unwrap_or(core::mem::zeroed()) as _, valuelength as _, attributes.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ExGetFirmwareType() -> super::super::super::Win32::System::SystemInformation::FIRMWARE_TYPE {
    windows_link::link!("ntoskrnl.exe" "system" fn ExGetFirmwareType() -> super::super::super::Win32::System::SystemInformation:: FIRMWARE_TYPE);
    unsafe { ExGetFirmwareType() }
}
#[inline]
pub unsafe fn ExGetPreviousMode() -> i8 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExGetPreviousMode() -> i8);
    unsafe { ExGetPreviousMode() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExGetSharedWaiterCount(resource: *const super::super::Foundation::ERESOURCE) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExGetSharedWaiterCount(resource : *const super::super::Foundation:: ERESOURCE) -> u32);
    unsafe { ExGetSharedWaiterCount(resource) }
}
#[inline]
pub unsafe fn ExGetSystemFirmwareTable(firmwaretableprovidersignature: u32, firmwaretableid: u32, firmwaretablebuffer: Option<*mut core::ffi::c_void>, bufferlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExGetSystemFirmwareTable(firmwaretableprovidersignature : u32, firmwaretableid : u32, firmwaretablebuffer : *mut core::ffi::c_void, bufferlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExGetSystemFirmwareTable(firmwaretableprovidersignature, firmwaretableid, firmwaretablebuffer.unwrap_or(core::mem::zeroed()) as _, bufferlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ExInitializePushLock() -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInitializePushLock(pushlock : *mut usize));
    unsafe {
        let mut result__ = core::mem::zeroed();
        ExInitializePushLock(&mut result__);
        result__
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExInitializeResourceLite(resource: *mut super::super::Foundation::ERESOURCE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInitializeResourceLite(resource : *mut super::super::Foundation:: ERESOURCE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExInitializeResourceLite(resource as _) }
}
#[inline]
pub unsafe fn ExInitializeRundownProtection() -> EX_RUNDOWN_REF {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInitializeRundownProtection(runref : *mut EX_RUNDOWN_REF));
    unsafe {
        let mut result__ = core::mem::zeroed();
        ExInitializeRundownProtection(&mut result__);
        result__
    }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExInitializeRundownProtectionCacheAware(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE, runrefsize: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInitializeRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, runrefsize : usize));
    unsafe { ExInitializeRundownProtectionCacheAware(runrefcacheaware, runrefsize) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExInitializeRundownProtectionCacheAwareEx(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInitializeRundownProtectionCacheAwareEx(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, flags : u32));
    unsafe { ExInitializeRundownProtectionCacheAwareEx(runrefcacheaware, flags) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExInitializeZone(zone: *mut ZONE_HEADER, blocksize: u32, initialsegment: *mut core::ffi::c_void, initialsegmentsize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInitializeZone(zone : *mut ZONE_HEADER, blocksize : u32, initialsegment : *mut core::ffi::c_void, initialsegmentsize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExInitializeZone(zone as _, blocksize, initialsegment as _, initialsegmentsize) }
}
#[inline]
pub unsafe fn ExInterlockedAddLargeInteger(addend: *mut i64, increment: i64, lock: *mut usize) -> i64 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInterlockedAddLargeInteger(addend : *mut i64, increment : i64, lock : *mut usize) -> i64);
    unsafe { ExInterlockedAddLargeInteger(addend as _, increment, lock as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExInterlockedExtendZone(zone: *mut ZONE_HEADER, segment: *mut core::ffi::c_void, segmentsize: u32, lock: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExInterlockedExtendZone(zone : *mut ZONE_HEADER, segment : *mut core::ffi::c_void, segmentsize : u32, lock : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExInterlockedExtendZone(zone as _, segment as _, segmentsize, lock as _) }
}
#[inline]
pub unsafe fn ExIsManufacturingModeEnabled() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExIsManufacturingModeEnabled() -> bool);
    unsafe { ExIsManufacturingModeEnabled() }
}
#[inline]
pub unsafe fn ExIsProcessorFeaturePresent(processorfeature: u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExIsProcessorFeaturePresent(processorfeature : u32) -> bool);
    unsafe { ExIsProcessorFeaturePresent(processorfeature) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExIsResourceAcquiredExclusiveLite(resource: *const super::super::Foundation::ERESOURCE) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExIsResourceAcquiredExclusiveLite(resource : *const super::super::Foundation:: ERESOURCE) -> bool);
    unsafe { ExIsResourceAcquiredExclusiveLite(resource) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExIsResourceAcquiredSharedLite(resource: *const super::super::Foundation::ERESOURCE) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExIsResourceAcquiredSharedLite(resource : *const super::super::Foundation:: ERESOURCE) -> u32);
    unsafe { ExIsResourceAcquiredSharedLite(resource) }
}
#[inline]
pub unsafe fn ExIsSoftBoot() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExIsSoftBoot() -> bool);
    unsafe { ExIsSoftBoot() }
}
#[inline]
pub unsafe fn ExLocalTimeToSystemTime(localtime: *const i64) -> i64 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExLocalTimeToSystemTime(localtime : *const i64, systemtime : *mut i64));
    unsafe {
        let mut result__ = core::mem::zeroed();
        ExLocalTimeToSystemTime(localtime, &mut result__);
        result__
    }
}
#[inline]
pub unsafe fn ExNotifyCallback(callbackobject: *const core::ffi::c_void, argument1: Option<*const core::ffi::c_void>, argument2: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExNotifyCallback(callbackobject : *const core::ffi::c_void, argument1 : *const core::ffi::c_void, argument2 : *const core::ffi::c_void));
    unsafe { ExNotifyCallback(callbackobject, argument1.unwrap_or(core::mem::zeroed()) as _, argument2.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ExQueryTimerResolution(maximumtime: *mut u32, minimumtime: *mut u32, currenttime: *mut u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExQueryTimerResolution(maximumtime : *mut u32, minimumtime : *mut u32, currenttime : *mut u32));
    unsafe { ExQueryTimerResolution(maximumtime as _, minimumtime as _, currenttime as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExQueueWorkItem(workitem: *mut super::super::Foundation::WORK_QUEUE_ITEM, queuetype: WORK_QUEUE_TYPE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExQueueWorkItem(workitem : *mut super::super::Foundation:: WORK_QUEUE_ITEM, queuetype : WORK_QUEUE_TYPE));
    unsafe { ExQueueWorkItem(workitem as _, queuetype) }
}
#[inline]
pub unsafe fn ExRaiseAccessViolation() {
    windows_link::link!("ntoskrnl.exe" "system" fn ExRaiseAccessViolation());
    unsafe { ExRaiseAccessViolation() }
}
#[inline]
pub unsafe fn ExRaiseDatatypeMisalignment() {
    windows_link::link!("ntoskrnl.exe" "system" fn ExRaiseDatatypeMisalignment());
    unsafe { ExRaiseDatatypeMisalignment() }
}
#[inline]
pub unsafe fn ExRaiseStatus(status: super::super::super::Win32::Foundation::NTSTATUS) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExRaiseStatus(status : super::super::super::Win32::Foundation:: NTSTATUS));
    unsafe { ExRaiseStatus(status) }
}
#[inline]
pub unsafe fn ExReInitializeRundownProtection(runref: *mut EX_RUNDOWN_REF) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReInitializeRundownProtection(runref : *mut EX_RUNDOWN_REF));
    unsafe { ExReInitializeRundownProtection(runref as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExReInitializeRundownProtectionCacheAware(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReInitializeRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    unsafe { ExReInitializeRundownProtectionCacheAware(runrefcacheaware) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExRegisterCallback(callbackobject: super::super::Foundation::PCALLBACK_OBJECT, callbackfunction: PCALLBACK_FUNCTION, callbackcontext: Option<*const core::ffi::c_void>) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn ExRegisterCallback(callbackobject : super::super::Foundation:: PCALLBACK_OBJECT, callbackfunction : PCALLBACK_FUNCTION, callbackcontext : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { ExRegisterCallback(callbackobject, callbackfunction, callbackcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReinitializeResourceLite(resource: *mut super::super::Foundation::ERESOURCE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReinitializeResourceLite(resource : *mut super::super::Foundation:: ERESOURCE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExReinitializeResourceLite(resource as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseFastMutex(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseFastMutex(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { ExReleaseFastMutex(fastmutex as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseFastMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseFastMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { ExReleaseFastMutexUnsafe(fastmutex as _) }
}
#[inline]
pub unsafe fn ExReleasePushLockExclusiveEx(pushlock: *mut usize, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleasePushLockExclusiveEx(pushlock : *mut usize, flags : u32));
    unsafe { ExReleasePushLockExclusiveEx(pushlock as _, flags) }
}
#[inline]
pub unsafe fn ExReleasePushLockSharedEx(pushlock: *mut usize, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleasePushLockSharedEx(pushlock : *mut usize, flags : u32));
    unsafe { ExReleasePushLockSharedEx(pushlock as _, flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseResourceAndLeaveCriticalRegion(resource: *mut super::super::Foundation::ERESOURCE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseResourceAndLeaveCriticalRegion(resource : *mut super::super::Foundation:: ERESOURCE));
    unsafe { ExReleaseResourceAndLeaveCriticalRegion(resource as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseResourceForThreadLite(resource: *mut super::super::Foundation::ERESOURCE, resourcethreadid: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseResourceForThreadLite(resource : *mut super::super::Foundation:: ERESOURCE, resourcethreadid : usize));
    unsafe { ExReleaseResourceForThreadLite(resource as _, resourcethreadid) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseResourceLite(resource: *mut super::super::Foundation::ERESOURCE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseResourceLite(resource : *mut super::super::Foundation:: ERESOURCE));
    unsafe { ExReleaseResourceLite(resource as _) }
}
#[inline]
pub unsafe fn ExReleaseRundownProtection(runref: *mut EX_RUNDOWN_REF) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtection(runref : *mut EX_RUNDOWN_REF));
    unsafe { ExReleaseRundownProtection(runref as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExReleaseRundownProtectionCacheAware(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    unsafe { ExReleaseRundownProtectionCacheAware(runrefcacheaware) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExReleaseRundownProtectionCacheAwareEx(runref: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE, count: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtectionCacheAwareEx(runref : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, count : u32));
    unsafe { ExReleaseRundownProtectionCacheAwareEx(runref, count) }
}
#[inline]
pub unsafe fn ExReleaseRundownProtectionEx(runref: *mut EX_RUNDOWN_REF, count: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtectionEx(runref : *mut EX_RUNDOWN_REF, count : u32));
    unsafe { ExReleaseRundownProtectionEx(runref as _, count) }
}
#[inline]
pub unsafe fn ExReleaseSpinLockExclusive(spinlock: *mut i32, oldirql: u8) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockExclusive(spinlock : *mut i32, oldirql : u8));
    unsafe { ExReleaseSpinLockExclusive(spinlock as _, oldirql) }
}
#[inline]
pub unsafe fn ExReleaseSpinLockExclusiveFromDpcLevel(spinlock: *mut i32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockExclusiveFromDpcLevel(spinlock : *mut i32));
    unsafe { ExReleaseSpinLockExclusiveFromDpcLevel(spinlock as _) }
}
#[inline]
pub unsafe fn ExReleaseSpinLockShared(spinlock: *mut i32, oldirql: u8) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockShared(spinlock : *mut i32, oldirql : u8));
    unsafe { ExReleaseSpinLockShared(spinlock as _, oldirql) }
}
#[inline]
pub unsafe fn ExReleaseSpinLockSharedFromDpcLevel(spinlock: *mut i32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockSharedFromDpcLevel(spinlock : *mut i32));
    unsafe { ExReleaseSpinLockSharedFromDpcLevel(spinlock as _) }
}
#[inline]
pub unsafe fn ExRundownCompleted() -> EX_RUNDOWN_REF {
    windows_link::link!("ntoskrnl.exe" "system" fn ExRundownCompleted(runref : *mut EX_RUNDOWN_REF));
    unsafe {
        let mut result__ = core::mem::zeroed();
        ExRundownCompleted(&mut result__);
        result__
    }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExRundownCompletedCacheAware(runrefcacheaware: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExRundownCompletedCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    unsafe { ExRundownCompletedCacheAware(runrefcacheaware) }
}
#[inline]
pub unsafe fn ExSecurePoolUpdate(securepoolhandle: super::super::super::Win32::Foundation::HANDLE, tag: u32, allocation: *const core::ffi::c_void, cookie: usize, offset: usize, size: usize, buffer: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSecurePoolUpdate(securepoolhandle : super::super::super::Win32::Foundation:: HANDLE, tag : u32, allocation : *const core::ffi::c_void, cookie : usize, offset : usize, size : usize, buffer : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExSecurePoolUpdate(securepoolhandle, tag, allocation, cookie, offset, size, buffer) }
}
#[inline]
pub unsafe fn ExSecurePoolValidate(securepoolhandle: super::super::super::Win32::Foundation::HANDLE, tag: u32, allocation: *const core::ffi::c_void, cookie: usize) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSecurePoolValidate(securepoolhandle : super::super::super::Win32::Foundation:: HANDLE, tag : u32, allocation : *const core::ffi::c_void, cookie : usize) -> u32);
    unsafe { ExSecurePoolValidate(securepoolhandle, tag, allocation, cookie) }
}
#[inline]
pub unsafe fn ExSetFirmwareEnvironmentVariable(variablename: *const super::super::super::Win32::Foundation::UNICODE_STRING, vendorguid: *const windows_core::GUID, value: Option<*const core::ffi::c_void>, valuelength: u32, attributes: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSetFirmwareEnvironmentVariable(variablename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, vendorguid : *const windows_core::GUID, value : *const core::ffi::c_void, valuelength : u32, attributes : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExSetFirmwareEnvironmentVariable(variablename, vendorguid, value.unwrap_or(core::mem::zeroed()) as _, valuelength, attributes) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExSetResourceOwnerPointer(resource: *mut super::super::Foundation::ERESOURCE, ownerpointer: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSetResourceOwnerPointer(resource : *mut super::super::Foundation:: ERESOURCE, ownerpointer : *const core::ffi::c_void));
    unsafe { ExSetResourceOwnerPointer(resource as _, ownerpointer) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExSetResourceOwnerPointerEx(resource: *mut super::super::Foundation::ERESOURCE, ownerpointer: *const core::ffi::c_void, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSetResourceOwnerPointerEx(resource : *mut super::super::Foundation:: ERESOURCE, ownerpointer : *const core::ffi::c_void, flags : u32));
    unsafe { ExSetResourceOwnerPointerEx(resource as _, ownerpointer, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExSetTimer(timer: super::super::Foundation::PEX_TIMER, duetime: i64, period: i64, parameters: Option<*const _EXT_SET_PARAMETERS_V0>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSetTimer(timer : super::super::Foundation:: PEX_TIMER, duetime : i64, period : i64, parameters : *const _EXT_SET_PARAMETERS_V0) -> bool);
    unsafe { ExSetTimer(timer, duetime, period, parameters.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ExSetTimerResolution(desiredtime: u32, setresolution: bool) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSetTimerResolution(desiredtime : u32, setresolution : bool) -> u32);
    unsafe { ExSetTimerResolution(desiredtime, setresolution) }
}
#[inline]
pub unsafe fn ExSizeOfRundownProtectionCacheAware() -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSizeOfRundownProtectionCacheAware() -> usize);
    unsafe { ExSizeOfRundownProtectionCacheAware() }
}
#[inline]
pub unsafe fn ExSystemTimeToLocalTime(systemtime: *const i64) -> i64 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExSystemTimeToLocalTime(systemtime : *const i64, localtime : *mut i64));
    unsafe {
        let mut result__ = core::mem::zeroed();
        ExSystemTimeToLocalTime(systemtime, &mut result__);
        result__
    }
}
#[inline]
pub unsafe fn ExTryAcquireSpinLockExclusiveAtDpcLevel(spinlock: *mut i32) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExTryAcquireSpinLockExclusiveAtDpcLevel(spinlock : *mut i32) -> u32);
    unsafe { ExTryAcquireSpinLockExclusiveAtDpcLevel(spinlock as _) }
}
#[inline]
pub unsafe fn ExTryAcquireSpinLockSharedAtDpcLevel(spinlock: *mut i32) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExTryAcquireSpinLockSharedAtDpcLevel(spinlock : *mut i32) -> u32);
    unsafe { ExTryAcquireSpinLockSharedAtDpcLevel(spinlock as _) }
}
#[inline]
pub unsafe fn ExTryConvertSharedSpinLockExclusive(spinlock: *mut i32) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn ExTryConvertSharedSpinLockExclusive(spinlock : *mut i32) -> u32);
    unsafe { ExTryConvertSharedSpinLockExclusive(spinlock as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExTryToAcquireFastMutex(fastmutex: *mut super::super::Foundation::FAST_MUTEX) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExTryToAcquireFastMutex(fastmutex : *mut super::super::Foundation:: FAST_MUTEX) -> bool);
    unsafe { ExTryToAcquireFastMutex(fastmutex as _) }
}
#[inline]
pub unsafe fn ExUnregisterCallback(callbackregistration: *mut core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExUnregisterCallback(callbackregistration : *mut core::ffi::c_void));
    unsafe { ExUnregisterCallback(callbackregistration as _) }
}
#[inline]
pub unsafe fn ExUuidCreate(uuid: *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ExUuidCreate(uuid : *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ExUuidCreate(uuid as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExVerifySuite(suitetype: super::super::super::Win32::System::Kernel::SUITE_TYPE) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ExVerifySuite(suitetype : super::super::super::Win32::System::Kernel:: SUITE_TYPE) -> bool);
    unsafe { ExVerifySuite(suitetype) }
}
#[inline]
pub unsafe fn ExWaitForRundownProtectionRelease(runref: *mut EX_RUNDOWN_REF) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExWaitForRundownProtectionRelease(runref : *mut EX_RUNDOWN_REF));
    unsafe { ExWaitForRundownProtectionRelease(runref as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExWaitForRundownProtectionReleaseCacheAware(runref: super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE) {
    windows_link::link!("ntoskrnl.exe" "system" fn ExWaitForRundownProtectionReleaseCacheAware(runref : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    unsafe { ExWaitForRundownProtectionReleaseCacheAware(runref) }
}
#[inline]
pub unsafe fn FsRtlIsTotalDeviceFailure(status: super::super::super::Win32::Foundation::NTSTATUS) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn FsRtlIsTotalDeviceFailure(status : super::super::super::Win32::Foundation:: NTSTATUS) -> bool);
    unsafe { FsRtlIsTotalDeviceFailure(status) }
}
#[inline]
pub unsafe fn HalAcquireDisplayOwnership(resetdisplayparameters: PHAL_RESET_DISPLAY_PARAMETERS) {
    windows_link::link!("hal.dll" "system" fn HalAcquireDisplayOwnership(resetdisplayparameters : PHAL_RESET_DISPLAY_PARAMETERS));
    unsafe { HalAcquireDisplayOwnership(resetdisplayparameters) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_IscsiDisc", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn HalAllocateAdapterChannel(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, wcb: *const WAIT_CONTEXT_BLOCK, numberofmapregisters: u32, executionroutine: super::super::Foundation::DRIVER_CONTROL) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("hal.dll" "system" fn HalAllocateAdapterChannel(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, wcb : *const WAIT_CONTEXT_BLOCK, numberofmapregisters : u32, executionroutine : super::super::Foundation:: DRIVER_CONTROL) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HalAllocateAdapterChannel(adapterobject, wcb, numberofmapregisters, executionroutine) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalAllocateCommonBuffer(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, length: u32, logicaladdress: *mut i64, cacheenabled: bool) -> *mut core::ffi::c_void {
    windows_link::link!("hal.dll" "system" fn HalAllocateCommonBuffer(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, length : u32, logicaladdress : *mut i64, cacheenabled : bool) -> *mut core::ffi::c_void);
    unsafe { HalAllocateCommonBuffer(adapterobject, length, logicaladdress as _, cacheenabled) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalAllocateCrashDumpRegisters(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, numberofmapregisters: *mut u32) -> *mut core::ffi::c_void {
    windows_link::link!("hal.dll" "system" fn HalAllocateCrashDumpRegisters(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, numberofmapregisters : *mut u32) -> *mut core::ffi::c_void);
    unsafe { HalAllocateCrashDumpRegisters(adapterobject, numberofmapregisters as _) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn HalAllocateHardwareCounters(groupaffinty: Option<&[super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY]>, resourcelist: Option<*const PHYSICAL_COUNTER_RESOURCE_LIST>, countersethandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("hal.dll" "system" fn HalAllocateHardwareCounters(groupaffinty : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, groupcount : u32, resourcelist : *const PHYSICAL_COUNTER_RESOURCE_LIST, countersethandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HalAllocateHardwareCounters(core::mem::transmute(groupaffinty.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), groupaffinty.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), resourcelist.unwrap_or(core::mem::zeroed()) as _, countersethandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn HalAssignSlotResources(registrypath: *const super::super::super::Win32::Foundation::UNICODE_STRING, driverclassname: *const super::super::super::Win32::Foundation::UNICODE_STRING, driverobject: *const super::super::Foundation::DRIVER_OBJECT, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, bustype: INTERFACE_TYPE, busnumber: u32, slotnumber: u32, allocatedresources: *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("hal.dll" "system" fn HalAssignSlotResources(registrypath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverclassname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, bustype : INTERFACE_TYPE, busnumber : u32, slotnumber : u32, allocatedresources : *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HalAssignSlotResources(registrypath, driverclassname, driverobject, deviceobject, bustype, busnumber, slotnumber, allocatedresources as _) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn HalBugCheckSystem(errorsource: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_DESCRIPTOR, errorrecord: *const WHEA_ERROR_RECORD) {
    windows_link::link!("hal.dll" "system" fn HalBugCheckSystem(errorsource : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_DESCRIPTOR, errorrecord : *const WHEA_ERROR_RECORD));
    unsafe { HalBugCheckSystem(errorsource, errorrecord) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalDmaAllocateCrashDumpRegistersEx(adapter: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, numberofmapregisters: u32, r#type: HAL_DMA_CRASH_DUMP_REGISTER_TYPE, mapregisterbase: *mut *mut core::ffi::c_void, mapregistersavailable: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("hal.dll" "system" fn HalDmaAllocateCrashDumpRegistersEx(adapter : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, numberofmapregisters : u32, r#type : HAL_DMA_CRASH_DUMP_REGISTER_TYPE, mapregisterbase : *mut *mut core::ffi::c_void, mapregistersavailable : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HalDmaAllocateCrashDumpRegistersEx(adapter, numberofmapregisters, r#type, mapregisterbase as _, mapregistersavailable as _) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalDmaFreeCrashDumpRegistersEx(adapter: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, r#type: HAL_DMA_CRASH_DUMP_REGISTER_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("hal.dll" "system" fn HalDmaFreeCrashDumpRegistersEx(adapter : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, r#type : HAL_DMA_CRASH_DUMP_REGISTER_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HalDmaFreeCrashDumpRegistersEx(adapter, r#type) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn HalExamineMBR(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, mbrtypeidentifier: u32, buffer: *mut *mut core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn HalExamineMBR(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, mbrtypeidentifier : u32, buffer : *mut *mut core::ffi::c_void));
    unsafe { HalExamineMBR(deviceobject, sectorsize, mbrtypeidentifier, buffer as _) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalFreeCommonBuffer(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, length: u32, logicaladdress: i64, virtualaddress: *const core::ffi::c_void, cacheenabled: bool) {
    windows_link::link!("hal.dll" "system" fn HalFreeCommonBuffer(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, length : u32, logicaladdress : i64, virtualaddress : *const core::ffi::c_void, cacheenabled : bool));
    unsafe { HalFreeCommonBuffer(adapterobject, length, logicaladdress, virtualaddress, cacheenabled) }
}
#[inline]
pub unsafe fn HalFreeHardwareCounters(countersethandle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("hal.dll" "system" fn HalFreeHardwareCounters(countersethandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HalFreeHardwareCounters(countersethandle) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalGetAdapter(devicedescription: *const DEVICE_DESCRIPTION, numberofmapregisters: *mut u32) -> *mut super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT {
    windows_link::link!("hal.dll" "system" fn HalGetAdapter(devicedescription : *const DEVICE_DESCRIPTION, numberofmapregisters : *mut u32) -> *mut super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT);
    unsafe { HalGetAdapter(devicedescription, numberofmapregisters as _) }
}
#[inline]
pub unsafe fn HalGetBusData(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *mut core::ffi::c_void, length: u32) -> u32 {
    windows_link::link!("hal.dll" "system" fn HalGetBusData(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *mut core::ffi::c_void, length : u32) -> u32);
    unsafe { HalGetBusData(busdatatype, busnumber, slotnumber, buffer as _, length) }
}
#[inline]
pub unsafe fn HalGetBusDataByOffset(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *mut core::ffi::c_void, offset: u32, length: u32) -> u32 {
    windows_link::link!("hal.dll" "system" fn HalGetBusDataByOffset(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *mut core::ffi::c_void, offset : u32, length : u32) -> u32);
    unsafe { HalGetBusDataByOffset(busdatatype, busnumber, slotnumber, buffer as _, offset, length) }
}
#[inline]
pub unsafe fn HalGetInterruptVector(interfacetype: INTERFACE_TYPE, busnumber: u32, businterruptlevel: u32, businterruptvector: u32, irql: *mut u8, affinity: *mut usize) -> u32 {
    windows_link::link!("hal.dll" "system" fn HalGetInterruptVector(interfacetype : INTERFACE_TYPE, busnumber : u32, businterruptlevel : u32, businterruptvector : u32, irql : *mut u8, affinity : *mut usize) -> u32);
    unsafe { HalGetInterruptVector(interfacetype, busnumber, businterruptlevel, businterruptvector, irql as _, affinity as _) }
}
#[inline]
pub unsafe fn HalMakeBeep(frequency: u32) -> bool {
    windows_link::link!("hal.dll" "system" fn HalMakeBeep(frequency : u32) -> bool);
    unsafe { HalMakeBeep(frequency) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalReadDmaCounter(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT) -> u32 {
    windows_link::link!("hal.dll" "system" fn HalReadDmaCounter(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT) -> u32);
    unsafe { HalReadDmaCounter(adapterobject) }
}
#[inline]
pub unsafe fn HalSetBusData(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *const core::ffi::c_void, length: u32) -> u32 {
    windows_link::link!("hal.dll" "system" fn HalSetBusData(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *const core::ffi::c_void, length : u32) -> u32);
    unsafe { HalSetBusData(busdatatype, busnumber, slotnumber, buffer, length) }
}
#[inline]
pub unsafe fn HalSetBusDataByOffset(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *const core::ffi::c_void, offset: u32, length: u32) -> u32 {
    windows_link::link!("hal.dll" "system" fn HalSetBusDataByOffset(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *const core::ffi::c_void, offset : u32, length : u32) -> u32);
    unsafe { HalSetBusDataByOffset(busdatatype, busnumber, slotnumber, buffer, offset, length) }
}
#[inline]
pub unsafe fn HalTranslateBusAddress(interfacetype: INTERFACE_TYPE, busnumber: u32, busaddress: i64, addressspace: *mut u32, translatedaddress: *mut i64) -> bool {
    windows_link::link!("hal.dll" "system" fn HalTranslateBusAddress(interfacetype : INTERFACE_TYPE, busnumber : u32, busaddress : i64, addressspace : *mut u32, translatedaddress : *mut i64) -> bool);
    unsafe { HalTranslateBusAddress(interfacetype, busnumber, busaddress, addressspace as _, translatedaddress as _) }
}
#[inline]
pub unsafe fn HvlRegisterWheaErrorNotification(callback: PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn HvlRegisterWheaErrorNotification(callback : PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HvlRegisterWheaErrorNotification(callback) }
}
#[inline]
pub unsafe fn HvlUnregisterWheaErrorNotification(callback: PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn HvlUnregisterWheaErrorNotification(callback : PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { HvlUnregisterWheaErrorNotification(callback) }
}
#[inline]
pub unsafe fn IoAcquireCancelSpinLock() -> u8 {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAcquireCancelSpinLock(irql : *mut u8));
    unsafe {
        let mut result__ = core::mem::zeroed();
        IoAcquireCancelSpinLock(&mut result__);
        result__
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAcquireKsrPersistentMemory(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, buffer: *mut core::ffi::c_void, size: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAcquireKsrPersistentMemory(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffer : *mut core::ffi::c_void, size : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAcquireKsrPersistentMemory(driverobject, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, buffer as _, size as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAcquireKsrPersistentMemoryEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, datatag: Option<*const u16>, dataversion: Option<*mut u32>, buffer: *mut core::ffi::c_void, size: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAcquireKsrPersistentMemoryEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, datatag : *const u16, dataversion : *mut u32, buffer : *mut core::ffi::c_void, size : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAcquireKsrPersistentMemoryEx(driverobject, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, physicaldeviceid.unwrap_or(core::mem::zeroed()) as _, datatag.unwrap_or(core::mem::zeroed()) as _, dataversion.unwrap_or(core::mem::zeroed()) as _, buffer as _, size as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoAcquireRemoveLockEx<P2>(removelock: *mut IO_REMOVE_LOCK, tag: Option<*const core::ffi::c_void>, file: P2, line: u32, remlocksize: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntoskrnl.exe" "system" fn IoAcquireRemoveLockEx(removelock : *mut IO_REMOVE_LOCK, tag : *const core::ffi::c_void, file : windows_core::PCSTR, line : u32, remlocksize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAcquireRemoveLockEx(removelock as _, tag.unwrap_or(core::mem::zeroed()) as _, file.param().abi(), line, remlocksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_IscsiDisc", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateAdapterChannel(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, numberofmapregisters: u32, executionroutine: super::super::Foundation::DRIVER_CONTROL, context: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateAdapterChannel(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, numberofmapregisters : u32, executionroutine : super::super::Foundation:: DRIVER_CONTROL, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAllocateAdapterChannel(adapterobject, deviceobject, numberofmapregisters, executionroutine, context) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateController(controllerobject: *const CONTROLLER_OBJECT, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, executionroutine: super::super::Foundation::DRIVER_CONTROL, context: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateController(controllerobject : *const CONTROLLER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, executionroutine : super::super::Foundation:: DRIVER_CONTROL, context : *const core::ffi::c_void));
    unsafe { IoAllocateController(controllerobject, deviceobject, executionroutine, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateDriverObjectExtension(driverobject: *const super::super::Foundation::DRIVER_OBJECT, clientidentificationaddress: *const core::ffi::c_void, driverobjectextensionsize: u32, driverobjectextension: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateDriverObjectExtension(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, clientidentificationaddress : *const core::ffi::c_void, driverobjectextensionsize : u32, driverobjectextension : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAllocateDriverObjectExtension(driverobject, clientidentificationaddress, driverobjectextensionsize, driverobjectextension as _) }
}
#[inline]
pub unsafe fn IoAllocateErrorLogEntry(ioobject: *const core::ffi::c_void, entrysize: u8) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateErrorLogEntry(ioobject : *const core::ffi::c_void, entrysize : u8) -> *mut core::ffi::c_void);
    unsafe { IoAllocateErrorLogEntry(ioobject, entrysize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateIrp(stacksize: i8, chargequota: bool) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateIrp(stacksize : i8, chargequota : bool) -> *mut super::super::Foundation:: IRP);
    unsafe { IoAllocateIrp(stacksize, chargequota) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateIrpEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, stacksize: i8, chargequota: bool) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateIrpEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, stacksize : i8, chargequota : bool) -> *mut super::super::Foundation:: IRP);
    unsafe { IoAllocateIrpEx(deviceobject, stacksize, chargequota) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateMdl(virtualaddress: Option<*const core::ffi::c_void>, length: u32, secondarybuffer: bool, chargequota: bool, irp: Option<*mut super::super::Foundation::IRP>) -> *mut super::super::Foundation::MDL {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateMdl(virtualaddress : *const core::ffi::c_void, length : u32, secondarybuffer : bool, chargequota : bool, irp : *mut super::super::Foundation:: IRP) -> *mut super::super::Foundation:: MDL);
    unsafe { IoAllocateMdl(virtualaddress.unwrap_or(core::mem::zeroed()) as _, length, secondarybuffer, chargequota, irp.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateSfioStreamIdentifier(fileobject: *const super::super::Foundation::FILE_OBJECT, length: u32, signature: *const core::ffi::c_void, streamidentifier: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateSfioStreamIdentifier(fileobject : *const super::super::Foundation:: FILE_OBJECT, length : u32, signature : *const core::ffi::c_void, streamidentifier : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAllocateSfioStreamIdentifier(fileobject, length, signature, streamidentifier as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateWorkItem(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::Foundation::PIO_WORKITEM {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAllocateWorkItem(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::Foundation:: PIO_WORKITEM);
    unsafe { IoAllocateWorkItem(deviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAssignResources(registrypath: *const super::super::super::Win32::Foundation::UNICODE_STRING, driverclassname: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, driverobject: *const super::super::Foundation::DRIVER_OBJECT, deviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, requestedresources: Option<*const IO_RESOURCE_REQUIREMENTS_LIST>, allocatedresources: *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAssignResources(registrypath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverclassname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, requestedresources : *const IO_RESOURCE_REQUIREMENTS_LIST, allocatedresources : *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAssignResources(registrypath, driverclassname.unwrap_or(core::mem::zeroed()) as _, driverobject, deviceobject.unwrap_or(core::mem::zeroed()) as _, requestedresources.unwrap_or(core::mem::zeroed()) as _, allocatedresources as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDevice(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::super::Win32::Foundation::UNICODE_STRING, attacheddevice: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAttachDevice(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::super::Win32::Foundation:: UNICODE_STRING, attacheddevice : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAttachDevice(sourcedevice, targetdevice, attacheddevice as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDeviceByPointer(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAttachDeviceByPointer(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAttachDeviceByPointer(sourcedevice, targetdevice) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDeviceToDeviceStack(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::Foundation::DEVICE_OBJECT) -> *mut super::super::Foundation::DEVICE_OBJECT {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAttachDeviceToDeviceStack(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::Foundation:: DEVICE_OBJECT) -> *mut super::super::Foundation:: DEVICE_OBJECT);
    unsafe { IoAttachDeviceToDeviceStack(sourcedevice, targetdevice) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDeviceToDeviceStackSafe(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::Foundation::DEVICE_OBJECT, attachedtodeviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoAttachDeviceToDeviceStackSafe(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::Foundation:: DEVICE_OBJECT, attachedtodeviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoAttachDeviceToDeviceStackSafe(sourcedevice, targetdevice, attachedtodeviceobject as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoBuildAsynchronousFsdRequest(majorfunction: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, buffer: Option<*mut core::ffi::c_void>, length: Option<u32>, startingoffset: Option<*const i64>, iostatusblock: Option<*const super::super::super::Win32::System::IO::IO_STATUS_BLOCK>) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoBuildAsynchronousFsdRequest(majorfunction : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffer : *mut core::ffi::c_void, length : u32, startingoffset : *const i64, iostatusblock : *const super::super::super::Win32::System::IO:: IO_STATUS_BLOCK) -> *mut super::super::Foundation:: IRP);
    unsafe { IoBuildAsynchronousFsdRequest(majorfunction, deviceobject, buffer.unwrap_or(core::mem::zeroed()) as _, length.unwrap_or(core::mem::zeroed()) as _, startingoffset.unwrap_or(core::mem::zeroed()) as _, iostatusblock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoBuildDeviceIoControlRequest(iocontrolcode: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, inputbuffer: Option<*const core::ffi::c_void>, inputbufferlength: u32, outputbuffer: Option<*mut core::ffi::c_void>, outputbufferlength: u32, internaldeviceiocontrol: bool, event: Option<*const super::super::Foundation::KEVENT>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoBuildDeviceIoControlRequest(iocontrolcode : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, inputbuffer : *const core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut core::ffi::c_void, outputbufferlength : u32, internaldeviceiocontrol : bool, event : *const super::super::Foundation:: KEVENT, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK) -> *mut super::super::Foundation:: IRP);
    unsafe { IoBuildDeviceIoControlRequest(iocontrolcode, deviceobject, inputbuffer.unwrap_or(core::mem::zeroed()) as _, inputbufferlength, outputbuffer.unwrap_or(core::mem::zeroed()) as _, outputbufferlength, internaldeviceiocontrol, event.unwrap_or(core::mem::zeroed()) as _, iostatusblock as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoBuildPartialMdl(sourcemdl: *const super::super::Foundation::MDL, targetmdl: *mut super::super::Foundation::MDL, virtualaddress: *mut core::ffi::c_void, length: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoBuildPartialMdl(sourcemdl : *const super::super::Foundation:: MDL, targetmdl : *mut super::super::Foundation:: MDL, virtualaddress : *mut core::ffi::c_void, length : u32));
    unsafe { IoBuildPartialMdl(sourcemdl, targetmdl as _, virtualaddress as _, length) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoBuildSynchronousFsdRequest(majorfunction: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, buffer: *mut core::ffi::c_void, length: u32, startingoffset: Option<*const i64>, event: *const super::super::Foundation::KEVENT, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoBuildSynchronousFsdRequest(majorfunction : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffer : *mut core::ffi::c_void, length : u32, startingoffset : *const i64, event : *const super::super::Foundation:: KEVENT, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK) -> *mut super::super::Foundation:: IRP);
    unsafe { IoBuildSynchronousFsdRequest(majorfunction, deviceobject, buffer as _, length, startingoffset.unwrap_or(core::mem::zeroed()) as _, event, iostatusblock as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCancelFileOpen(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, fileobject: *const super::super::Foundation::FILE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCancelFileOpen(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, fileobject : *const super::super::Foundation:: FILE_OBJECT));
    unsafe { IoCancelFileOpen(deviceobject, fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCancelIrp(irp: *const super::super::Foundation::IRP) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCancelIrp(irp : *const super::super::Foundation:: IRP) -> bool);
    unsafe { IoCancelIrp(irp) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCheckLinkShareAccess(desiredaccess: u32, desiredshareaccess: u32, fileobject: Option<*mut super::super::Foundation::FILE_OBJECT>, shareaccess: Option<*mut SHARE_ACCESS>, linkshareaccess: Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCheckLinkShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCheckLinkShareAccess(desiredaccess, desiredshareaccess, fileobject.unwrap_or(core::mem::zeroed()) as _, shareaccess.unwrap_or(core::mem::zeroed()) as _, linkshareaccess.unwrap_or(core::mem::zeroed()) as _, ioshareaccessflags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCheckShareAccess(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, update: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCheckShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, update : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCheckShareAccess(desiredaccess, desiredshareaccess, fileobject as _, shareaccess as _, update) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCheckShareAccessEx(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, update: bool, writepermission: Option<*const bool>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCheckShareAccessEx(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, update : bool, writepermission : *const bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCheckShareAccessEx(desiredaccess, desiredshareaccess, fileobject as _, shareaccess as _, update, writepermission.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCleanupIrp(irp: *mut super::super::Foundation::IRP) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCleanupIrp(irp : *mut super::super::Foundation:: IRP));
    unsafe { IoCleanupIrp(irp as _) }
}
#[inline]
pub unsafe fn IoClearActivityIdThread(originalid: *const windows_core::GUID) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoClearActivityIdThread(originalid : *const windows_core::GUID));
    unsafe { IoClearActivityIdThread(originalid) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoClearIrpExtraCreateParameter(irp: *mut super::super::Foundation::IRP) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoClearIrpExtraCreateParameter(irp : *mut super::super::Foundation:: IRP));
    unsafe { IoClearIrpExtraCreateParameter(irp as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoConnectInterrupt(interruptobject: *mut super::super::Foundation::PKINTERRUPT, serviceroutine: PKSERVICE_ROUTINE, servicecontext: Option<*const core::ffi::c_void>, spinlock: Option<*const usize>, vector: u32, irql: u8, synchronizeirql: u8, interruptmode: KINTERRUPT_MODE, sharevector: bool, processorenablemask: usize, floatingsave: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoConnectInterrupt(interruptobject : *mut super::super::Foundation:: PKINTERRUPT, serviceroutine : PKSERVICE_ROUTINE, servicecontext : *const core::ffi::c_void, spinlock : *const usize, vector : u32, irql : u8, synchronizeirql : u8, interruptmode : KINTERRUPT_MODE, sharevector : bool, processorenablemask : usize, floatingsave : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoConnectInterrupt(interruptobject as _, serviceroutine, servicecontext.unwrap_or(core::mem::zeroed()) as _, spinlock.unwrap_or(core::mem::zeroed()) as _, vector, irql, synchronizeirql, interruptmode, sharevector, processorenablemask, floatingsave) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoConnectInterruptEx(parameters: *mut IO_CONNECT_INTERRUPT_PARAMETERS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoConnectInterruptEx(parameters : *mut IO_CONNECT_INTERRUPT_PARAMETERS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoConnectInterruptEx(parameters as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoCreateController(size: u32) -> *mut CONTROLLER_OBJECT {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateController(size : u32) -> *mut CONTROLLER_OBJECT);
    unsafe { IoCreateController(size) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCreateDevice(driverobject: *const super::super::Foundation::DRIVER_OBJECT, deviceextensionsize: u32, devicename: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, devicetype: u32, devicecharacteristics: u32, exclusive: bool, deviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateDevice(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, deviceextensionsize : u32, devicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, devicetype : u32, devicecharacteristics : u32, exclusive : bool, deviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateDevice(driverobject, deviceextensionsize, devicename.unwrap_or(core::mem::zeroed()) as _, devicetype, devicecharacteristics, exclusive, deviceobject as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCreateDisk(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, disk: Option<*const super::super::super::Win32::System::Ioctl::CREATE_DISK>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateDisk(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, disk : *const super::super::super::Win32::System::Ioctl:: CREATE_DISK) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateDisk(deviceobject, disk.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoCreateFile(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: Option<*const i64>, fileattributes: u32, shareaccess: u32, disposition: u32, createoptions: u32, eabuffer: Option<*const core::ffi::c_void>, ealength: u32, createfiletype: CREATE_FILE_TYPE, internalparameters: Option<*const core::ffi::c_void>, options: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateFile(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, disposition : u32, createoptions : u32, eabuffer : *const core::ffi::c_void, ealength : u32, createfiletype : CREATE_FILE_TYPE, internalparameters : *const core::ffi::c_void, options : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateFile(filehandle as _, desiredaccess, objectattributes, iostatusblock as _, allocationsize.unwrap_or(core::mem::zeroed()) as _, fileattributes, shareaccess, disposition, createoptions, eabuffer.unwrap_or(core::mem::zeroed()) as _, ealength, createfiletype, internalparameters.unwrap_or(core::mem::zeroed()) as _, options) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoCreateFileEx(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: Option<*const i64>, fileattributes: u32, shareaccess: u32, disposition: u32, createoptions: u32, eabuffer: Option<*const core::ffi::c_void>, ealength: u32, createfiletype: CREATE_FILE_TYPE, internalparameters: Option<*const core::ffi::c_void>, options: u32, drivercontext: Option<*const IO_DRIVER_CREATE_CONTEXT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateFileEx(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, disposition : u32, createoptions : u32, eabuffer : *const core::ffi::c_void, ealength : u32, createfiletype : CREATE_FILE_TYPE, internalparameters : *const core::ffi::c_void, options : u32, drivercontext : *const IO_DRIVER_CREATE_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateFileEx(filehandle as _, desiredaccess, objectattributes, iostatusblock as _, allocationsize.unwrap_or(core::mem::zeroed()) as _, fileattributes, shareaccess, disposition, createoptions, eabuffer.unwrap_or(core::mem::zeroed()) as _, ealength, createfiletype, internalparameters.unwrap_or(core::mem::zeroed()) as _, options, drivercontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoCreateFileSpecifyDeviceObjectHint(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: Option<*const i64>, fileattributes: u32, shareaccess: u32, disposition: u32, createoptions: u32, eabuffer: Option<*const core::ffi::c_void>, ealength: u32, createfiletype: CREATE_FILE_TYPE, internalparameters: Option<*const core::ffi::c_void>, options: u32, deviceobject: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateFileSpecifyDeviceObjectHint(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, disposition : u32, createoptions : u32, eabuffer : *const core::ffi::c_void, ealength : u32, createfiletype : CREATE_FILE_TYPE, internalparameters : *const core::ffi::c_void, options : u32, deviceobject : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateFileSpecifyDeviceObjectHint(filehandle as _, desiredaccess, objectattributes, iostatusblock as _, allocationsize.unwrap_or(core::mem::zeroed()) as _, fileattributes, shareaccess, disposition, createoptions, eabuffer.unwrap_or(core::mem::zeroed()) as _, ealength, createfiletype, internalparameters.unwrap_or(core::mem::zeroed()) as _, options, deviceobject.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoCreateNotificationEvent(eventname: *const super::super::super::Win32::Foundation::UNICODE_STRING, eventhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> *mut super::super::Foundation::KEVENT {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateNotificationEvent(eventname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, eventhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> *mut super::super::Foundation:: KEVENT);
    unsafe { IoCreateNotificationEvent(eventname, eventhandle as _) }
}
#[inline]
pub unsafe fn IoCreateSymbolicLink(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, devicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateSymbolicLink(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, devicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateSymbolicLink(symboliclinkname, devicename) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoCreateSynchronizationEvent(eventname: *const super::super::super::Win32::Foundation::UNICODE_STRING, eventhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> *mut super::super::Foundation::KEVENT {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateSynchronizationEvent(eventname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, eventhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> *mut super::super::Foundation:: KEVENT);
    unsafe { IoCreateSynchronizationEvent(eventname, eventhandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn IoCreateSystemThread(ioobject: *mut core::ffi::c_void, threadhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, processhandle: Option<super::super::super::Win32::Foundation::HANDLE>, clientid: Option<*mut super::super::super::Win32::System::WindowsProgramming::CLIENT_ID>, startroutine: PKSTART_ROUTINE, startcontext: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateSystemThread(ioobject : *mut core::ffi::c_void, threadhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, processhandle : super::super::super::Win32::Foundation:: HANDLE, clientid : *mut super::super::super::Win32::System::WindowsProgramming:: CLIENT_ID, startroutine : PKSTART_ROUTINE, startcontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateSystemThread(ioobject as _, threadhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, processhandle.unwrap_or(core::mem::zeroed()) as _, clientid.unwrap_or(core::mem::zeroed()) as _, startroutine, startcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoCreateUnprotectedSymbolicLink(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, devicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCreateUnprotectedSymbolicLink(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, devicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCreateUnprotectedSymbolicLink(symboliclinkname, devicename) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInitialize(csq: *mut IO_CSQ, csqinsertirp: PIO_CSQ_INSERT_IRP, csqremoveirp: PIO_CSQ_REMOVE_IRP, csqpeeknextirp: PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock: PIO_CSQ_ACQUIRE_LOCK, csqreleaselock: PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp: PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCsqInitialize(csq : *mut IO_CSQ, csqinsertirp : PIO_CSQ_INSERT_IRP, csqremoveirp : PIO_CSQ_REMOVE_IRP, csqpeeknextirp : PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock : PIO_CSQ_ACQUIRE_LOCK, csqreleaselock : PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp : PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCsqInitialize(csq as _, csqinsertirp, csqremoveirp, csqpeeknextirp, csqacquirelock, csqreleaselock, csqcompletecanceledirp) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInitializeEx(csq: *mut IO_CSQ, csqinsertirp: PIO_CSQ_INSERT_IRP_EX, csqremoveirp: PIO_CSQ_REMOVE_IRP, csqpeeknextirp: PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock: PIO_CSQ_ACQUIRE_LOCK, csqreleaselock: PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp: PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCsqInitializeEx(csq : *mut IO_CSQ, csqinsertirp : PIO_CSQ_INSERT_IRP_EX, csqremoveirp : PIO_CSQ_REMOVE_IRP, csqpeeknextirp : PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock : PIO_CSQ_ACQUIRE_LOCK, csqreleaselock : PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp : PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCsqInitializeEx(csq as _, csqinsertirp, csqremoveirp, csqpeeknextirp, csqacquirelock, csqreleaselock, csqcompletecanceledirp) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInsertIrp(csq: *mut IO_CSQ, irp: *mut super::super::Foundation::IRP, context: Option<*mut IO_CSQ_IRP_CONTEXT>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCsqInsertIrp(csq : *mut IO_CSQ, irp : *mut super::super::Foundation:: IRP, context : *mut IO_CSQ_IRP_CONTEXT));
    unsafe { IoCsqInsertIrp(csq as _, irp as _, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInsertIrpEx(csq: *mut IO_CSQ, irp: *mut super::super::Foundation::IRP, context: Option<*mut IO_CSQ_IRP_CONTEXT>, insertcontext: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCsqInsertIrpEx(csq : *mut IO_CSQ, irp : *mut super::super::Foundation:: IRP, context : *mut IO_CSQ_IRP_CONTEXT, insertcontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoCsqInsertIrpEx(csq as _, irp as _, context.unwrap_or(core::mem::zeroed()) as _, insertcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqRemoveIrp(csq: *mut IO_CSQ, context: *mut IO_CSQ_IRP_CONTEXT) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCsqRemoveIrp(csq : *mut IO_CSQ, context : *mut IO_CSQ_IRP_CONTEXT) -> *mut super::super::Foundation:: IRP);
    unsafe { IoCsqRemoveIrp(csq as _, context as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqRemoveNextIrp(csq: *mut IO_CSQ, peekcontext: Option<*const core::ffi::c_void>) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoCsqRemoveNextIrp(csq : *mut IO_CSQ, peekcontext : *const core::ffi::c_void) -> *mut super::super::Foundation:: IRP);
    unsafe { IoCsqRemoveNextIrp(csq as _, peekcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoDecrementKeepAliveCount(fileobject: *mut super::super::Foundation::FILE_OBJECT, process: super::super::Foundation::PEPROCESS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoDecrementKeepAliveCount(fileobject : *mut super::super::Foundation:: FILE_OBJECT, process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoDecrementKeepAliveCount(fileobject as _, process) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoDeleteController(controllerobject: *const CONTROLLER_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoDeleteController(controllerobject : *const CONTROLLER_OBJECT));
    unsafe { IoDeleteController(controllerobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoDeleteDevice(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoDeleteDevice(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoDeleteDevice(deviceobject) }
}
#[inline]
pub unsafe fn IoDeleteSymbolicLink(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoDeleteSymbolicLink(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoDeleteSymbolicLink(symboliclinkname) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoDetachDevice(targetdevice: *mut super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoDetachDevice(targetdevice : *mut super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoDetachDevice(targetdevice as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoDisconnectInterrupt(interruptobject: super::super::Foundation::PKINTERRUPT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoDisconnectInterrupt(interruptobject : super::super::Foundation:: PKINTERRUPT));
    unsafe { IoDisconnectInterrupt(interruptobject) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoDisconnectInterruptEx(parameters: *const IO_DISCONNECT_INTERRUPT_PARAMETERS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoDisconnectInterruptEx(parameters : *const IO_DISCONNECT_INTERRUPT_PARAMETERS));
    unsafe { IoDisconnectInterruptEx(parameters) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoEnumerateKsrPersistentMemoryEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, callback: PIO_PERSISTED_MEMORY_ENUMERATION_CALLBACK, callbackcontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoEnumerateKsrPersistentMemoryEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, callback : PIO_PERSISTED_MEMORY_ENUMERATION_CALLBACK, callbackcontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoEnumerateKsrPersistentMemoryEx(driverobject, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, physicaldeviceid.unwrap_or(core::mem::zeroed()) as _, callback, callbackcontext) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Storage_IscsiDisc"))]
#[inline]
pub unsafe fn IoFlushAdapterBuffers(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, mdl: *const super::super::Foundation::MDL, mapregisterbase: *const core::ffi::c_void, currentva: *const core::ffi::c_void, length: u32, writetodevice: bool) -> bool {
    windows_link::link!("hal.dll" "system" fn IoFlushAdapterBuffers(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, mdl : *const super::super::Foundation:: MDL, mapregisterbase : *const core::ffi::c_void, currentva : *const core::ffi::c_void, length : u32, writetodevice : bool) -> bool);
    unsafe { IoFlushAdapterBuffers(adapterobject, mdl, mapregisterbase, currentva, length, writetodevice) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoForwardIrpSynchronously(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoForwardIrpSynchronously(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP) -> bool);
    unsafe { IoForwardIrpSynchronously(deviceobject, irp) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn IoFreeAdapterChannel(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT) {
    windows_link::link!("hal.dll" "system" fn IoFreeAdapterChannel(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT));
    unsafe { IoFreeAdapterChannel(adapterobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoFreeController(controllerobject: *const CONTROLLER_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoFreeController(controllerobject : *const CONTROLLER_OBJECT));
    unsafe { IoFreeController(controllerobject) }
}
#[inline]
pub unsafe fn IoFreeErrorLogEntry(elentry: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoFreeErrorLogEntry(elentry : *const core::ffi::c_void));
    unsafe { IoFreeErrorLogEntry(elentry) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoFreeIrp(irp: *const super::super::Foundation::IRP) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoFreeIrp(irp : *const super::super::Foundation:: IRP));
    unsafe { IoFreeIrp(irp) }
}
#[inline]
pub unsafe fn IoFreeKsrPersistentMemory(datahandle: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoFreeKsrPersistentMemory(datahandle : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoFreeKsrPersistentMemory(datahandle) }
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn IoFreeMapRegisters(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, mapregisterbase: *const core::ffi::c_void, numberofmapregisters: u32) {
    windows_link::link!("hal.dll" "system" fn IoFreeMapRegisters(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, mapregisterbase : *const core::ffi::c_void, numberofmapregisters : u32));
    unsafe { IoFreeMapRegisters(adapterobject, mapregisterbase, numberofmapregisters) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoFreeMdl(mdl: *mut super::super::Foundation::MDL) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoFreeMdl(mdl : *mut super::super::Foundation:: MDL));
    unsafe { IoFreeMdl(mdl as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoFreeSfioStreamIdentifier(fileobject: *const super::super::Foundation::FILE_OBJECT, signature: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoFreeSfioStreamIdentifier(fileobject : *const super::super::Foundation:: FILE_OBJECT, signature : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoFreeSfioStreamIdentifier(fileobject, signature) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoFreeWorkItem(ioworkitem: super::super::Foundation::PIO_WORKITEM) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoFreeWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM));
    unsafe { IoFreeWorkItem(ioworkitem) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetActivityIdIrp(irp: *const super::super::Foundation::IRP, guid: *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetActivityIdIrp(irp : *const super::super::Foundation:: IRP, guid : *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetActivityIdIrp(irp, guid as _) }
}
#[inline]
pub unsafe fn IoGetActivityIdThread() -> *mut windows_core::GUID {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetActivityIdThread() -> *mut windows_core::GUID);
    unsafe { IoGetActivityIdThread() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn IoGetAffinityInterrupt(interruptobject: super::super::Foundation::PKINTERRUPT, groupaffinity: *mut super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetAffinityInterrupt(interruptobject : super::super::Foundation:: PKINTERRUPT, groupaffinity : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetAffinityInterrupt(interruptobject, groupaffinity as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetAttachedDeviceReference(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> *mut super::super::Foundation::DEVICE_OBJECT {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetAttachedDeviceReference(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> *mut super::super::Foundation:: DEVICE_OBJECT);
    unsafe { IoGetAttachedDeviceReference(deviceobject) }
}
#[inline]
pub unsafe fn IoGetBootDiskInformation(bootdiskinformation: *mut BOOTDISK_INFORMATION, size: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetBootDiskInformation(bootdiskinformation : *mut BOOTDISK_INFORMATION, size : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetBootDiskInformation(bootdiskinformation as _, size) }
}
#[inline]
pub unsafe fn IoGetBootDiskInformationLite(bootdiskinformation: *mut *mut BOOTDISK_INFORMATION_LITE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetBootDiskInformationLite(bootdiskinformation : *mut *mut BOOTDISK_INFORMATION_LITE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetBootDiskInformationLite(bootdiskinformation as _) }
}
#[inline]
pub unsafe fn IoGetConfigurationInformation() -> *mut CONFIGURATION_INFORMATION {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetConfigurationInformation() -> *mut CONFIGURATION_INFORMATION);
    unsafe { IoGetConfigurationInformation() }
}
#[inline]
pub unsafe fn IoGetContainerInformation(informationclass: IO_CONTAINER_INFORMATION_CLASS, containerobject: Option<*const core::ffi::c_void>, buffer: Option<*mut core::ffi::c_void>, bufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetContainerInformation(informationclass : IO_CONTAINER_INFORMATION_CLASS, containerobject : *const core::ffi::c_void, buffer : *mut core::ffi::c_void, bufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetContainerInformation(informationclass, containerobject.unwrap_or(core::mem::zeroed()) as _, buffer.unwrap_or(core::mem::zeroed()) as _, bufferlength) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoGetCurrentProcess() -> super::super::Foundation::PEPROCESS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetCurrentProcess() -> super::super::Foundation:: PEPROCESS);
    unsafe { IoGetCurrentProcess() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceDirectory(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, directorytype: DEVICE_DIRECTORY_TYPE, flags: u32, reserved: *const core::ffi::c_void, devicedirectoryhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDeviceDirectory(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, directorytype : DEVICE_DIRECTORY_TYPE, flags : u32, reserved : *const core::ffi::c_void, devicedirectoryhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDeviceDirectory(physicaldeviceobject, directorytype, flags, reserved, devicedirectoryhandle as _) }
}
#[inline]
pub unsafe fn IoGetDeviceInterfaceAlias(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, aliasinterfaceclassguid: *const windows_core::GUID, aliassymboliclinkname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDeviceInterfaceAlias(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, aliasinterfaceclassguid : *const windows_core::GUID, aliassymboliclinkname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDeviceInterfaceAlias(symboliclinkname, aliasinterfaceclassguid, aliassymboliclinkname as _) }
}
#[cfg(feature = "Win32_Devices_Properties")]
#[inline]
pub unsafe fn IoGetDeviceInterfacePropertyData(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, propertykey: *const super::super::super::Win32::Foundation::DEVPROPKEY, lcid: u32, flags: Option<u32>, size: u32, data: *mut core::ffi::c_void, requiredsize: *mut u32, r#type: *mut super::super::super::Win32::Devices::Properties::DEVPROPTYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDeviceInterfacePropertyData(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, propertykey : *const super::super::super::Win32::Foundation:: DEVPROPKEY, lcid : u32, flags : u32, size : u32, data : *mut core::ffi::c_void, requiredsize : *mut u32, r#type : *mut super::super::super::Win32::Devices::Properties:: DEVPROPTYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDeviceInterfacePropertyData(symboliclinkname, propertykey, lcid, flags.unwrap_or(core::mem::zeroed()) as _, size, data as _, requiredsize as _, r#type as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceInterfaces(interfaceclassguid: *const windows_core::GUID, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, flags: u32, symboliclinklist: *mut windows_core::PWSTR) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDeviceInterfaces(interfaceclassguid : *const windows_core::GUID, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, flags : u32, symboliclinklist : *mut windows_core::PWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDeviceInterfaces(interfaceclassguid, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, flags, symboliclinklist as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceNumaNode(pdo: *const super::super::Foundation::DEVICE_OBJECT, nodenumber: *mut u16) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDeviceNumaNode(pdo : *const super::super::Foundation:: DEVICE_OBJECT, nodenumber : *mut u16) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDeviceNumaNode(pdo, nodenumber as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceObjectPointer(objectname: *const super::super::super::Win32::Foundation::UNICODE_STRING, desiredaccess: u32, fileobject: *mut *mut super::super::Foundation::FILE_OBJECT, deviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDeviceObjectPointer(objectname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, desiredaccess : u32, fileobject : *mut *mut super::super::Foundation:: FILE_OBJECT, deviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDeviceObjectPointer(objectname, desiredaccess, fileobject as _, deviceobject as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceProperty(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, deviceproperty: DEVICE_REGISTRY_PROPERTY, bufferlength: u32, propertybuffer: Option<*mut core::ffi::c_void>, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDeviceProperty(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, deviceproperty : DEVICE_REGISTRY_PROPERTY, bufferlength : u32, propertybuffer : *mut core::ffi::c_void, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDeviceProperty(deviceobject, deviceproperty, bufferlength, propertybuffer.unwrap_or(core::mem::zeroed()) as _, resultlength as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Devices_Properties", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDevicePropertyData(pdo: *const super::super::Foundation::DEVICE_OBJECT, propertykey: *const super::super::super::Win32::Foundation::DEVPROPKEY, lcid: u32, flags: Option<u32>, size: u32, data: *mut core::ffi::c_void, requiredsize: *mut u32, r#type: *mut super::super::super::Win32::Devices::Properties::DEVPROPTYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDevicePropertyData(pdo : *const super::super::Foundation:: DEVICE_OBJECT, propertykey : *const super::super::super::Win32::Foundation:: DEVPROPKEY, lcid : u32, flags : u32, size : u32, data : *mut core::ffi::c_void, requiredsize : *mut u32, r#type : *mut super::super::super::Win32::Devices::Properties:: DEVPROPTYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDevicePropertyData(pdo, propertykey, lcid, flags.unwrap_or(core::mem::zeroed()) as _, size, data as _, requiredsize as _, r#type as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDmaAdapter(physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, devicedescription: *const DEVICE_DESCRIPTION, numberofmapregisters: *mut u32) -> *mut DMA_ADAPTER {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDmaAdapter(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devicedescription : *const DEVICE_DESCRIPTION, numberofmapregisters : *mut u32) -> *mut DMA_ADAPTER);
    unsafe { IoGetDmaAdapter(physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, devicedescription, numberofmapregisters as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDriverDirectory(driverobject: *const super::super::Foundation::DRIVER_OBJECT, directorytype: DRIVER_DIRECTORY_TYPE, flags: u32, driverdirectoryhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDriverDirectory(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, directorytype : DRIVER_DIRECTORY_TYPE, flags : u32, driverdirectoryhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetDriverDirectory(driverobject, directorytype, flags, driverdirectoryhandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDriverObjectExtension(driverobject: *const super::super::Foundation::DRIVER_OBJECT, clientidentificationaddress: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetDriverObjectExtension(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, clientidentificationaddress : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { IoGetDriverObjectExtension(driverobject, clientidentificationaddress) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn IoGetFileObjectGenericMapping() -> *mut super::super::super::Win32::Security::GENERIC_MAPPING {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetFileObjectGenericMapping() -> *mut super::super::super::Win32::Security:: GENERIC_MAPPING);
    unsafe { IoGetFileObjectGenericMapping() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetFsZeroingOffset(irp: *const super::super::Foundation::IRP, zeroingoffset: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetFsZeroingOffset(irp : *const super::super::Foundation:: IRP, zeroingoffset : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetFsZeroingOffset(irp, zeroingoffset as _) }
}
#[inline]
pub unsafe fn IoGetInitialStack() -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetInitialStack() -> *mut core::ffi::c_void);
    unsafe { IoGetInitialStack() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetInitiatorProcess(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::Foundation::PEPROCESS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetInitiatorProcess(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::Foundation:: PEPROCESS);
    unsafe { IoGetInitiatorProcess(fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetIoAttributionHandle(irp: *const super::super::Foundation::IRP, ioattributionhandle: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetIoAttributionHandle(irp : *const super::super::Foundation:: IRP, ioattributionhandle : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetIoAttributionHandle(irp, ioattributionhandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetIoPriorityHint(irp: *const super::super::Foundation::IRP) -> super::super::Foundation::IO_PRIORITY_HINT {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetIoPriorityHint(irp : *const super::super::Foundation:: IRP) -> super::super::Foundation:: IO_PRIORITY_HINT);
    unsafe { IoGetIoPriorityHint(irp) }
}
#[inline]
pub unsafe fn IoGetIommuInterface(version: u32, interfaceout: *mut DMA_IOMMU_INTERFACE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetIommuInterface(version : u32, interfaceout : *mut DMA_IOMMU_INTERFACE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetIommuInterface(version, interfaceout as _) }
}
#[inline]
pub unsafe fn IoGetIommuInterfaceEx(version: u32, flags: u64, interfaceout: *mut DMA_IOMMU_INTERFACE_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetIommuInterfaceEx(version : u32, flags : u64, interfaceout : *mut DMA_IOMMU_INTERFACE_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetIommuInterfaceEx(version, flags, interfaceout as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetIrpExtraCreateParameter(irp: *const super::super::Foundation::IRP, extracreateparameter: *mut *mut isize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetIrpExtraCreateParameter(irp : *const super::super::Foundation:: IRP, extracreateparameter : *mut *mut isize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoGetIrpExtraCreateParameter(irp, extracreateparameter as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetPagingIoPriority(irp: *const super::super::Foundation::IRP) -> IO_PAGING_PRIORITY {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetPagingIoPriority(irp : *const super::super::Foundation:: IRP) -> IO_PAGING_PRIORITY);
    unsafe { IoGetPagingIoPriority(irp) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetRelatedDeviceObject(fileobject: *const super::super::Foundation::FILE_OBJECT) -> *mut super::super::Foundation::DEVICE_OBJECT {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetRelatedDeviceObject(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> *mut super::super::Foundation:: DEVICE_OBJECT);
    unsafe { IoGetRelatedDeviceObject(fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetSfioStreamIdentifier(fileobject: *const super::super::Foundation::FILE_OBJECT, signature: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetSfioStreamIdentifier(fileobject : *const super::super::Foundation:: FILE_OBJECT, signature : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { IoGetSfioStreamIdentifier(fileobject, signature) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetSilo(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetSilo(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::Foundation:: PESILO);
    unsafe { IoGetSilo(fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetSiloParameters(fileobject: *const super::super::Foundation::FILE_OBJECT) -> *mut IO_FOEXT_SILO_PARAMETERS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetSiloParameters(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> *mut IO_FOEXT_SILO_PARAMETERS);
    unsafe { IoGetSiloParameters(fileobject) }
}
#[inline]
pub unsafe fn IoGetStackLimits(lowlimit: *mut usize, highlimit: *mut usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetStackLimits(lowlimit : *mut usize, highlimit : *mut usize));
    unsafe { IoGetStackLimits(lowlimit as _, highlimit as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetTopLevelIrp() -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetTopLevelIrp() -> *mut super::super::Foundation:: IRP);
    unsafe { IoGetTopLevelIrp() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetTransactionParameterBlock(fileobject: *const super::super::Foundation::FILE_OBJECT) -> *mut TXN_PARAMETER_BLOCK {
    windows_link::link!("ntoskrnl.exe" "system" fn IoGetTransactionParameterBlock(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> *mut TXN_PARAMETER_BLOCK);
    unsafe { IoGetTransactionParameterBlock(fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIncrementKeepAliveCount(fileobject: *mut super::super::Foundation::FILE_OBJECT, process: super::super::Foundation::PEPROCESS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoIncrementKeepAliveCount(fileobject : *mut super::super::Foundation:: FILE_OBJECT, process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoIncrementKeepAliveCount(fileobject as _, process) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInitializeIrp(irp: *mut super::super::Foundation::IRP, packetsize: u16, stacksize: i8) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoInitializeIrp(irp : *mut super::super::Foundation:: IRP, packetsize : u16, stacksize : i8));
    unsafe { IoInitializeIrp(irp as _, packetsize, stacksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInitializeIrpEx(irp: *mut super::super::Foundation::IRP, deviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, packetsize: u16, stacksize: i8) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoInitializeIrpEx(irp : *mut super::super::Foundation:: IRP, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, packetsize : u16, stacksize : i8));
    unsafe { IoInitializeIrpEx(irp as _, deviceobject.unwrap_or(core::mem::zeroed()) as _, packetsize, stacksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoInitializeRemoveLockEx(lock: *mut IO_REMOVE_LOCK, allocatetag: u32, maxlockedminutes: u32, highwatermark: u32, remlocksize: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoInitializeRemoveLockEx(lock : *mut IO_REMOVE_LOCK, allocatetag : u32, maxlockedminutes : u32, highwatermark : u32, remlocksize : u32));
    unsafe { IoInitializeRemoveLockEx(lock as _, allocatetag, maxlockedminutes, highwatermark, remlocksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInitializeTimer(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, timerroutine: PIO_TIMER_ROUTINE, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoInitializeTimer(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, timerroutine : PIO_TIMER_ROUTINE, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoInitializeTimer(deviceobject, timerroutine, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoInitializeWorkItem(ioobject: *const core::ffi::c_void, ioworkitem: super::super::Foundation::PIO_WORKITEM) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoInitializeWorkItem(ioobject : *const core::ffi::c_void, ioworkitem : super::super::Foundation:: PIO_WORKITEM));
    unsafe { IoInitializeWorkItem(ioobject, ioworkitem) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInvalidateDeviceRelations(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, r#type: DEVICE_RELATION_TYPE) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoInvalidateDeviceRelations(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, r#type : DEVICE_RELATION_TYPE));
    unsafe { IoInvalidateDeviceRelations(deviceobject, r#type) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInvalidateDeviceState(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoInvalidateDeviceState(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoInvalidateDeviceState(physicaldeviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIs32bitProcess(irp: Option<*const super::super::Foundation::IRP>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoIs32bitProcess(irp : *const super::super::Foundation:: IRP) -> bool);
    unsafe { IoIs32bitProcess(irp.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIsFileObjectIgnoringSharing(fileobject: *const super::super::Foundation::FILE_OBJECT) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoIsFileObjectIgnoringSharing(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> bool);
    unsafe { IoIsFileObjectIgnoringSharing(fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIsFileOriginRemote(fileobject: *const super::super::Foundation::FILE_OBJECT) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoIsFileOriginRemote(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> bool);
    unsafe { IoIsFileOriginRemote(fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIsInitiator32bitProcess(irp: *const super::super::Foundation::IRP) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoIsInitiator32bitProcess(irp : *const super::super::Foundation:: IRP) -> bool);
    unsafe { IoIsInitiator32bitProcess(irp) }
}
#[inline]
pub unsafe fn IoIsValidIrpStatus(status: super::super::super::Win32::Foundation::NTSTATUS) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn IoIsValidIrpStatus(status : super::super::super::Win32::Foundation:: NTSTATUS) -> u32);
    unsafe { IoIsValidIrpStatus(status) }
}
#[inline]
pub unsafe fn IoIsWdmVersionAvailable(majorversion: u8, minorversion: u8) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoIsWdmVersionAvailable(majorversion : u8, minorversion : u8) -> bool);
    unsafe { IoIsWdmVersionAvailable(majorversion, minorversion) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoMakeAssociatedIrp(irp: *const super::super::Foundation::IRP, stacksize: i8) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoMakeAssociatedIrp(irp : *const super::super::Foundation:: IRP, stacksize : i8) -> *mut super::super::Foundation:: IRP);
    unsafe { IoMakeAssociatedIrp(irp, stacksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoMakeAssociatedIrpEx(irp: *const super::super::Foundation::IRP, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, stacksize: i8) -> *mut super::super::Foundation::IRP {
    windows_link::link!("ntoskrnl.exe" "system" fn IoMakeAssociatedIrpEx(irp : *const super::super::Foundation:: IRP, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, stacksize : i8) -> *mut super::super::Foundation:: IRP);
    unsafe { IoMakeAssociatedIrpEx(irp, deviceobject, stacksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Storage_IscsiDisc"))]
#[inline]
pub unsafe fn IoMapTransfer(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, mdl: *const super::super::Foundation::MDL, mapregisterbase: *const core::ffi::c_void, currentva: *const core::ffi::c_void, length: *mut u32, writetodevice: bool) -> i64 {
    windows_link::link!("hal.dll" "system" fn IoMapTransfer(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, mdl : *const super::super::Foundation:: MDL, mapregisterbase : *const core::ffi::c_void, currentva : *const core::ffi::c_void, length : *mut u32, writetodevice : bool) -> i64);
    unsafe { IoMapTransfer(adapterobject, mdl, mapregisterbase, currentva, length as _, writetodevice) }
}
#[inline]
pub unsafe fn IoOpenDeviceInterfaceRegistryKey(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, desiredaccess: u32, deviceinterfaceregkey: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoOpenDeviceInterfaceRegistryKey(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, desiredaccess : u32, deviceinterfaceregkey : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoOpenDeviceInterfaceRegistryKey(symboliclinkname, desiredaccess, deviceinterfaceregkey as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoOpenDeviceRegistryKey(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, devinstkeytype: u32, desiredaccess: u32, deviceregkey: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoOpenDeviceRegistryKey(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devinstkeytype : u32, desiredaccess : u32, deviceregkey : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoOpenDeviceRegistryKey(deviceobject, devinstkeytype, desiredaccess, deviceregkey as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoOpenDriverRegistryKey(driverobject: *const super::super::Foundation::DRIVER_OBJECT, regkeytype: DRIVER_REGKEY_TYPE, desiredaccess: u32, flags: u32, driverregkey: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoOpenDriverRegistryKey(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, regkeytype : DRIVER_REGKEY_TYPE, desiredaccess : u32, flags : u32, driverregkey : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoOpenDriverRegistryKey(driverobject, regkeytype, desiredaccess, flags, driverregkey as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoPropagateActivityIdToThread(irp: *const super::super::Foundation::IRP, propagatedid: *mut windows_core::GUID, originalid: *mut *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoPropagateActivityIdToThread(irp : *const super::super::Foundation:: IRP, propagatedid : *mut windows_core::GUID, originalid : *mut *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoPropagateActivityIdToThread(irp, propagatedid as _, originalid as _) }
}
#[inline]
pub unsafe fn IoQueryDeviceDescription(bustype: Option<*const INTERFACE_TYPE>, busnumber: Option<*const u32>, controllertype: Option<*const CONFIGURATION_TYPE>, controllernumber: Option<*const u32>, peripheraltype: Option<*const CONFIGURATION_TYPE>, peripheralnumber: Option<*const u32>, calloutroutine: PIO_QUERY_DEVICE_ROUTINE, context: Option<*mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoQueryDeviceDescription(bustype : *const INTERFACE_TYPE, busnumber : *const u32, controllertype : *const CONFIGURATION_TYPE, controllernumber : *const u32, peripheraltype : *const CONFIGURATION_TYPE, peripheralnumber : *const u32, calloutroutine : PIO_QUERY_DEVICE_ROUTINE, context : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoQueryDeviceDescription(bustype.unwrap_or(core::mem::zeroed()) as _, busnumber.unwrap_or(core::mem::zeroed()) as _, controllertype.unwrap_or(core::mem::zeroed()) as _, controllernumber.unwrap_or(core::mem::zeroed()) as _, peripheraltype.unwrap_or(core::mem::zeroed()) as _, peripheralnumber.unwrap_or(core::mem::zeroed()) as _, calloutroutine, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoQueryFullDriverPath(driverobject: *const super::super::Foundation::DRIVER_OBJECT, fullpath: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoQueryFullDriverPath(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, fullpath : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoQueryFullDriverPath(driverobject, fullpath as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoQueryInformationByName(objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *mut core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS, options: u32, drivercontext: Option<*const IO_DRIVER_CREATE_CONTEXT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoQueryInformationByName(objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *mut core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS, options : u32, drivercontext : *const IO_DRIVER_CREATE_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoQueryInformationByName(objectattributes, iostatusblock as _, fileinformation as _, length, fileinformationclass, options, drivercontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoQueryKsrPersistentMemorySize(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, buffersize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoQueryKsrPersistentMemorySize(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffersize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoQueryKsrPersistentMemorySize(driverobject, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, buffersize as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoQueryKsrPersistentMemorySizeEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, datatag: Option<*const u16>, dataversion: Option<*mut u32>, buffersize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoQueryKsrPersistentMemorySizeEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, datatag : *const u16, dataversion : *mut u32, buffersize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoQueryKsrPersistentMemorySizeEx(driverobject, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, physicaldeviceid.unwrap_or(core::mem::zeroed()) as _, datatag.unwrap_or(core::mem::zeroed()) as _, dataversion.unwrap_or(core::mem::zeroed()) as _, buffersize as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoQueueWorkItem(ioworkitem: super::super::Foundation::PIO_WORKITEM, workerroutine: PIO_WORKITEM_ROUTINE, queuetype: WORK_QUEUE_TYPE, context: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoQueueWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM, workerroutine : PIO_WORKITEM_ROUTINE, queuetype : WORK_QUEUE_TYPE, context : *const core::ffi::c_void));
    unsafe { IoQueueWorkItem(ioworkitem, workerroutine, queuetype, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoQueueWorkItemEx(ioworkitem: super::super::Foundation::PIO_WORKITEM, workerroutine: PIO_WORKITEM_ROUTINE_EX, queuetype: WORK_QUEUE_TYPE, context: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoQueueWorkItemEx(ioworkitem : super::super::Foundation:: PIO_WORKITEM, workerroutine : PIO_WORKITEM_ROUTINE_EX, queuetype : WORK_QUEUE_TYPE, context : *const core::ffi::c_void));
    unsafe { IoQueueWorkItemEx(ioworkitem, workerroutine, queuetype, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRaiseHardError(irp: *const super::super::Foundation::IRP, vpb: Option<*const super::super::Foundation::VPB>, realdeviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRaiseHardError(irp : *const super::super::Foundation:: IRP, vpb : *const super::super::Foundation:: VPB, realdeviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoRaiseHardError(irp, vpb.unwrap_or(core::mem::zeroed()) as _, realdeviceobject) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoRaiseInformationalHardError(errorstatus: super::super::super::Win32::Foundation::NTSTATUS, string: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, thread: Option<super::super::Foundation::PKTHREAD>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRaiseInformationalHardError(errorstatus : super::super::super::Win32::Foundation:: NTSTATUS, string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, thread : super::super::Foundation:: PKTHREAD) -> bool);
    unsafe { IoRaiseInformationalHardError(errorstatus, string.unwrap_or(core::mem::zeroed()) as _, thread.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReadDiskSignature(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, bytespersector: u32, signature: *mut DISK_SIGNATURE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReadDiskSignature(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, bytespersector : u32, signature : *mut DISK_SIGNATURE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReadDiskSignature(deviceobject, bytespersector, signature as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReadPartitionTable(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, returnrecognizedpartitions: bool, partitionbuffer: *mut *mut super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReadPartitionTable(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, returnrecognizedpartitions : bool, partitionbuffer : *mut *mut super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReadPartitionTable(deviceobject, sectorsize, returnrecognizedpartitions, partitionbuffer as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReadPartitionTableEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, drivelayout: *mut *mut super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReadPartitionTableEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, drivelayout : *mut *mut super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReadPartitionTableEx(deviceobject, drivelayout as _) }
}
#[inline]
pub unsafe fn IoRecordIoAttribution(opaquehandle: *mut core::ffi::c_void, attributioninformation: *const IO_ATTRIBUTION_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRecordIoAttribution(opaquehandle : *mut core::ffi::c_void, attributioninformation : *const IO_ATTRIBUTION_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoRecordIoAttribution(opaquehandle as _, attributioninformation) }
}
#[inline]
pub unsafe fn IoRegisterBootDriverCallback(callbackfunction: PBOOT_DRIVER_CALLBACK_FUNCTION, callbackcontext: Option<*const core::ffi::c_void>) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterBootDriverCallback(callbackfunction : PBOOT_DRIVER_CALLBACK_FUNCTION, callbackcontext : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { IoRegisterBootDriverCallback(callbackfunction, callbackcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterBootDriverReinitialization(driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverreinitializationroutine: super::super::Foundation::DRIVER_REINITIALIZE, context: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterBootDriverReinitialization(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverreinitializationroutine : super::super::Foundation:: DRIVER_REINITIALIZE, context : *const core::ffi::c_void));
    unsafe { IoRegisterBootDriverReinitialization(driverobject, driverreinitializationroutine, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoRegisterContainerNotification(notificationclass: IO_CONTAINER_NOTIFICATION_CLASS, callbackfunction: PIO_CONTAINER_NOTIFICATION_FUNCTION, notificationinformation: Option<*const core::ffi::c_void>, notificationinformationlength: u32, callbackregistration: *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterContainerNotification(notificationclass : IO_CONTAINER_NOTIFICATION_CLASS, callbackfunction : PIO_CONTAINER_NOTIFICATION_FUNCTION, notificationinformation : *const core::ffi::c_void, notificationinformationlength : u32, callbackregistration : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoRegisterContainerNotification(notificationclass, callbackfunction, notificationinformation.unwrap_or(core::mem::zeroed()) as _, notificationinformationlength, callbackregistration as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterDeviceInterface(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, interfaceclassguid: *const windows_core::GUID, referencestring: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, symboliclinkname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterDeviceInterface(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, interfaceclassguid : *const windows_core::GUID, referencestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, symboliclinkname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoRegisterDeviceInterface(physicaldeviceobject, interfaceclassguid, referencestring.unwrap_or(core::mem::zeroed()) as _, symboliclinkname as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterDriverReinitialization(driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverreinitializationroutine: super::super::Foundation::DRIVER_REINITIALIZE, context: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterDriverReinitialization(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverreinitializationroutine : super::super::Foundation:: DRIVER_REINITIALIZE, context : *const core::ffi::c_void));
    unsafe { IoRegisterDriverReinitialization(driverobject, driverreinitializationroutine, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterLastChanceShutdownNotification(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterLastChanceShutdownNotification(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoRegisterLastChanceShutdownNotification(deviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterPlugPlayNotification(eventcategory: IO_NOTIFICATION_EVENT_CATEGORY, eventcategoryflags: u32, eventcategorydata: Option<*const core::ffi::c_void>, driverobject: *const super::super::Foundation::DRIVER_OBJECT, callbackroutine: super::super::Foundation::DRIVER_NOTIFICATION_CALLBACK_ROUTINE, context: Option<*mut core::ffi::c_void>, notificationentry: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterPlugPlayNotification(eventcategory : IO_NOTIFICATION_EVENT_CATEGORY, eventcategoryflags : u32, eventcategorydata : *const core::ffi::c_void, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, callbackroutine : super::super::Foundation:: DRIVER_NOTIFICATION_CALLBACK_ROUTINE, context : *mut core::ffi::c_void, notificationentry : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoRegisterPlugPlayNotification(eventcategory, eventcategoryflags, eventcategorydata.unwrap_or(core::mem::zeroed()) as _, driverobject, callbackroutine, context.unwrap_or(core::mem::zeroed()) as _, notificationentry as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterShutdownNotification(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRegisterShutdownNotification(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoRegisterShutdownNotification(deviceobject) }
}
#[inline]
pub unsafe fn IoReleaseCancelSpinLock(irql: u8) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReleaseCancelSpinLock(irql : u8));
    unsafe { IoReleaseCancelSpinLock(irql) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoReleaseRemoveLockAndWaitEx(removelock: *mut IO_REMOVE_LOCK, tag: Option<*const core::ffi::c_void>, remlocksize: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReleaseRemoveLockAndWaitEx(removelock : *mut IO_REMOVE_LOCK, tag : *const core::ffi::c_void, remlocksize : u32));
    unsafe { IoReleaseRemoveLockAndWaitEx(removelock as _, tag.unwrap_or(core::mem::zeroed()) as _, remlocksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoReleaseRemoveLockEx(removelock: *mut IO_REMOVE_LOCK, tag: Option<*const core::ffi::c_void>, remlocksize: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReleaseRemoveLockEx(removelock : *mut IO_REMOVE_LOCK, tag : *const core::ffi::c_void, remlocksize : u32));
    unsafe { IoReleaseRemoveLockEx(removelock as _, tag.unwrap_or(core::mem::zeroed()) as _, remlocksize) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRemoveLinkShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: Option<*mut LINK_SHARE_ACCESS>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRemoveLinkShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS));
    unsafe { IoRemoveLinkShareAccess(fileobject, shareaccess as _, linkshareaccess.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRemoveLinkShareAccessEx(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRemoveLinkShareAccessEx(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32));
    unsafe { IoRemoveLinkShareAccessEx(fileobject, shareaccess as _, linkshareaccess.unwrap_or(core::mem::zeroed()) as _, ioshareaccessflags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRemoveShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRemoveShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS));
    unsafe { IoRemoveShareAccess(fileobject, shareaccess as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReplacePartitionUnit(targetpdo: *const super::super::Foundation::DEVICE_OBJECT, sparepdo: *const super::super::Foundation::DEVICE_OBJECT, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReplacePartitionUnit(targetpdo : *const super::super::Foundation:: DEVICE_OBJECT, sparepdo : *const super::super::Foundation:: DEVICE_OBJECT, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReplacePartitionUnit(targetpdo, sparepdo, flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportDetectedDevice(driverobject: *const super::super::Foundation::DRIVER_OBJECT, legacybustype: INTERFACE_TYPE, busnumber: u32, slotnumber: u32, resourcelist: Option<*const CM_RESOURCE_LIST>, resourcerequirements: Option<*const IO_RESOURCE_REQUIREMENTS_LIST>, resourceassigned: bool, deviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportDetectedDevice(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, legacybustype : INTERFACE_TYPE, busnumber : u32, slotnumber : u32, resourcelist : *const CM_RESOURCE_LIST, resourcerequirements : *const IO_RESOURCE_REQUIREMENTS_LIST, resourceassigned : bool, deviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReportDetectedDevice(driverobject, legacybustype, busnumber, slotnumber, resourcelist.unwrap_or(core::mem::zeroed()) as _, resourcerequirements.unwrap_or(core::mem::zeroed()) as _, resourceassigned, deviceobject as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoReportInterruptActive(parameters: *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportInterruptActive(parameters : *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS));
    unsafe { IoReportInterruptActive(parameters) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoReportInterruptInactive(parameters: *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportInterruptInactive(parameters : *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS));
    unsafe { IoReportInterruptInactive(parameters) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportResourceForDetection(driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverlist: Option<*const CM_RESOURCE_LIST>, driverlistsize: Option<u32>, deviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, devicelist: Option<*const CM_RESOURCE_LIST>, devicelistsize: Option<u32>, conflictdetected: *mut bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportResourceForDetection(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverlist : *const CM_RESOURCE_LIST, driverlistsize : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devicelist : *const CM_RESOURCE_LIST, devicelistsize : u32, conflictdetected : *mut bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReportResourceForDetection(driverobject, driverlist.unwrap_or(core::mem::zeroed()) as _, driverlistsize.unwrap_or(core::mem::zeroed()) as _, deviceobject.unwrap_or(core::mem::zeroed()) as _, devicelist.unwrap_or(core::mem::zeroed()) as _, devicelistsize.unwrap_or(core::mem::zeroed()) as _, conflictdetected as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportResourceUsage(driverclassname: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverlist: Option<*const CM_RESOURCE_LIST>, driverlistsize: Option<u32>, deviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, devicelist: Option<*const CM_RESOURCE_LIST>, devicelistsize: Option<u32>, overrideconflict: bool, conflictdetected: *mut bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportResourceUsage(driverclassname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverlist : *const CM_RESOURCE_LIST, driverlistsize : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devicelist : *const CM_RESOURCE_LIST, devicelistsize : u32, overrideconflict : bool, conflictdetected : *mut bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReportResourceUsage(driverclassname.unwrap_or(core::mem::zeroed()) as _, driverobject, driverlist.unwrap_or(core::mem::zeroed()) as _, driverlistsize.unwrap_or(core::mem::zeroed()) as _, deviceobject.unwrap_or(core::mem::zeroed()) as _, devicelist.unwrap_or(core::mem::zeroed()) as _, devicelistsize.unwrap_or(core::mem::zeroed()) as _, overrideconflict, conflictdetected as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportRootDevice(driverobject: *const super::super::Foundation::DRIVER_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportRootDevice(driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReportRootDevice(driverobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportTargetDeviceChange(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, notificationstructure: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportTargetDeviceChange(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, notificationstructure : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReportTargetDeviceChange(physicaldeviceobject, notificationstructure) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportTargetDeviceChangeAsynchronous(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, notificationstructure: *const core::ffi::c_void, callback: PDEVICE_CHANGE_COMPLETE_CALLBACK, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReportTargetDeviceChangeAsynchronous(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, notificationstructure : *const core::ffi::c_void, callback : PDEVICE_CHANGE_COMPLETE_CALLBACK, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReportTargetDeviceChangeAsynchronous(physicaldeviceobject, notificationstructure, callback, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRequestDeviceEject(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRequestDeviceEject(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoRequestDeviceEject(physicaldeviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRequestDeviceEjectEx(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, callback: PIO_DEVICE_EJECT_CALLBACK, context: Option<*const core::ffi::c_void>, driverobject: Option<*const super::super::Foundation::DRIVER_OBJECT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoRequestDeviceEjectEx(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, callback : PIO_DEVICE_EJECT_CALLBACK, context : *const core::ffi::c_void, driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoRequestDeviceEjectEx(physicaldeviceobject, callback, context.unwrap_or(core::mem::zeroed()) as _, driverobject.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReserveKsrPersistentMemory(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, size: usize, flags: u32, datahandle: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReserveKsrPersistentMemory(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, size : usize, flags : u32, datahandle : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReserveKsrPersistentMemory(driverobject, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, size, flags, datahandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReserveKsrPersistentMemoryEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, datatag: Option<*const u16>, dataversion: u32, size: usize, flags: u32, datahandle: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReserveKsrPersistentMemoryEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, datatag : *const u16, dataversion : u32, size : usize, flags : u32, datahandle : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoReserveKsrPersistentMemoryEx(driverobject, physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, physicaldeviceid.unwrap_or(core::mem::zeroed()) as _, datatag.unwrap_or(core::mem::zeroed()) as _, dataversion, size, flags, datahandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReuseIrp(irp: *mut super::super::Foundation::IRP, iostatus: super::super::super::Win32::Foundation::NTSTATUS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoReuseIrp(irp : *mut super::super::Foundation:: IRP, iostatus : super::super::super::Win32::Foundation:: NTSTATUS));
    unsafe { IoReuseIrp(irp as _, iostatus) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetActivityIdIrp(irp: *mut super::super::Foundation::IRP, guid: Option<*const windows_core::GUID>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetActivityIdIrp(irp : *mut super::super::Foundation:: IRP, guid : *const windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetActivityIdIrp(irp as _, guid.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoSetActivityIdThread(activityid: *const windows_core::GUID) -> *mut windows_core::GUID {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetActivityIdThread(activityid : *const windows_core::GUID) -> *mut windows_core::GUID);
    unsafe { IoSetActivityIdThread(activityid) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetCompletionRoutineEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP, completionroutine: super::super::Foundation::PIO_COMPLETION_ROUTINE, context: Option<*const core::ffi::c_void>, invokeonsuccess: bool, invokeonerror: bool, invokeoncancel: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetCompletionRoutineEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP, completionroutine : super::super::Foundation:: PIO_COMPLETION_ROUTINE, context : *const core::ffi::c_void, invokeonsuccess : bool, invokeonerror : bool, invokeoncancel : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetCompletionRoutineEx(deviceobject, irp, completionroutine, context.unwrap_or(core::mem::zeroed()) as _, invokeonsuccess, invokeonerror, invokeoncancel) }
}
#[inline]
pub unsafe fn IoSetDeviceInterfacePropertyData(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, propertykey: *const super::super::super::Win32::Foundation::DEVPROPKEY, lcid: u32, flags: u32, r#type: u32, size: u32, data: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetDeviceInterfacePropertyData(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, propertykey : *const super::super::super::Win32::Foundation:: DEVPROPKEY, lcid : u32, flags : u32, r#type : u32, size : u32, data : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetDeviceInterfacePropertyData(symboliclinkname, propertykey, lcid, flags, r#type, size, data.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoSetDeviceInterfaceState(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, enable: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetDeviceInterfaceState(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, enable : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetDeviceInterfaceState(symboliclinkname, enable) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetDevicePropertyData(pdo: *const super::super::Foundation::DEVICE_OBJECT, propertykey: *const super::super::super::Win32::Foundation::DEVPROPKEY, lcid: u32, flags: u32, r#type: u32, size: u32, data: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetDevicePropertyData(pdo : *const super::super::Foundation:: DEVICE_OBJECT, propertykey : *const super::super::super::Win32::Foundation:: DEVPROPKEY, lcid : u32, flags : u32, r#type : u32, size : u32, data : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetDevicePropertyData(pdo, propertykey, lcid, flags, r#type, size, data.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFileObjectIgnoreSharing(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetFileObjectIgnoreSharing(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetFileObjectIgnoreSharing(fileobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFileOrigin(fileobject: *const super::super::Foundation::FILE_OBJECT, remote: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetFileOrigin(fileobject : *const super::super::Foundation:: FILE_OBJECT, remote : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetFileOrigin(fileobject, remote) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFsZeroingOffset(irp: *mut super::super::Foundation::IRP, zeroingoffset: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetFsZeroingOffset(irp : *mut super::super::Foundation:: IRP, zeroingoffset : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetFsZeroingOffset(irp as _, zeroingoffset) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFsZeroingOffsetRequired(irp: *mut super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetFsZeroingOffsetRequired(irp : *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetFsZeroingOffsetRequired(irp as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetHardErrorOrVerifyDevice(irp: *const super::super::Foundation::IRP, deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetHardErrorOrVerifyDevice(irp : *const super::super::Foundation:: IRP, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoSetHardErrorOrVerifyDevice(irp, deviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetIoAttributionIrp(irp: *mut super::super::Foundation::IRP, attributionsource: *const core::ffi::c_void, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetIoAttributionIrp(irp : *mut super::super::Foundation:: IRP, attributionsource : *const core::ffi::c_void, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetIoAttributionIrp(irp as _, attributionsource, flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetIoPriorityHint(irp: *const super::super::Foundation::IRP, priorityhint: super::super::Foundation::IO_PRIORITY_HINT) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetIoPriorityHint(irp : *const super::super::Foundation:: IRP, priorityhint : super::super::Foundation:: IO_PRIORITY_HINT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetIoPriorityHint(irp, priorityhint) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetIrpExtraCreateParameter(irp: *mut super::super::Foundation::IRP, extracreateparameter: *const isize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetIrpExtraCreateParameter(irp : *mut super::super::Foundation:: IRP, extracreateparameter : *const isize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetIrpExtraCreateParameter(irp as _, extracreateparameter) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetLinkShareAccess(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetLinkShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32));
    unsafe { IoSetLinkShareAccess(desiredaccess, desiredshareaccess, fileobject as _, shareaccess as _, linkshareaccess.unwrap_or(core::mem::zeroed()) as _, ioshareaccessflags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetMasterIrpStatus(masterirp: *mut super::super::Foundation::IRP, status: super::super::super::Win32::Foundation::NTSTATUS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetMasterIrpStatus(masterirp : *mut super::super::Foundation:: IRP, status : super::super::super::Win32::Foundation:: NTSTATUS));
    unsafe { IoSetMasterIrpStatus(masterirp as _, status) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetPartitionInformation(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, partitionnumber: u32, partitiontype: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetPartitionInformation(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, partitionnumber : u32, partitiontype : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetPartitionInformation(deviceobject, sectorsize, partitionnumber, partitiontype) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetPartitionInformationEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, partitionnumber: u32, partitioninfo: *const super::super::super::Win32::System::Ioctl::SET_PARTITION_INFORMATION_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetPartitionInformationEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, partitionnumber : u32, partitioninfo : *const super::super::super::Win32::System::Ioctl:: SET_PARTITION_INFORMATION_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetPartitionInformationEx(deviceobject, partitionnumber, partitioninfo) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetShareAccess(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS));
    unsafe { IoSetShareAccess(desiredaccess, desiredshareaccess, fileobject as _, shareaccess as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetShareAccessEx(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, writepermission: Option<*const bool>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetShareAccessEx(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, writepermission : *const bool));
    unsafe { IoSetShareAccessEx(desiredaccess, desiredshareaccess, fileobject as _, shareaccess as _, writepermission.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetStartIoAttributes(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, deferredstartio: bool, noncancelable: bool) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetStartIoAttributes(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, deferredstartio : bool, noncancelable : bool));
    unsafe { IoSetStartIoAttributes(deviceobject, deferredstartio, noncancelable) }
}
#[inline]
pub unsafe fn IoSetSystemPartition(volumenamestring: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetSystemPartition(volumenamestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSetSystemPartition(volumenamestring) }
}
#[inline]
pub unsafe fn IoSetThreadHardErrorMode(enableharderrors: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetThreadHardErrorMode(enableharderrors : bool) -> bool);
    unsafe { IoSetThreadHardErrorMode(enableharderrors) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetTopLevelIrp(irp: Option<*const super::super::Foundation::IRP>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSetTopLevelIrp(irp : *const super::super::Foundation:: IRP));
    unsafe { IoSetTopLevelIrp(irp.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSizeOfIrpEx(deviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, stacksize: i8) -> u16 {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSizeOfIrpEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, stacksize : i8) -> u16);
    unsafe { IoSizeOfIrpEx(deviceobject.unwrap_or(core::mem::zeroed()) as _, stacksize) }
}
#[inline]
pub unsafe fn IoSizeofWorkItem() -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSizeofWorkItem() -> u32);
    unsafe { IoSizeofWorkItem() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartNextPacket(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, cancelable: bool) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoStartNextPacket(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, cancelable : bool));
    unsafe { IoStartNextPacket(deviceobject, cancelable) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartNextPacketByKey(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, cancelable: bool, key: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoStartNextPacketByKey(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, cancelable : bool, key : u32));
    unsafe { IoStartNextPacketByKey(deviceobject, cancelable, key) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartPacket(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP, key: Option<*const u32>, cancelfunction: super::super::Foundation::DRIVER_CANCEL) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoStartPacket(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP, key : *const u32, cancelfunction : super::super::Foundation:: DRIVER_CANCEL));
    unsafe { IoStartPacket(deviceobject, irp, key.unwrap_or(core::mem::zeroed()) as _, cancelfunction) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartTimer(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoStartTimer(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoStartTimer(deviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStopTimer(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoStopTimer(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoStopTimer(deviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSynchronousCallDriver(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoSynchronousCallDriver(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoSynchronousCallDriver(deviceobject, irp) }
}
#[inline]
pub unsafe fn IoTransferActivityId(activityid: *const windows_core::GUID, relatedactivityid: *const windows_core::GUID) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoTransferActivityId(activityid : *const windows_core::GUID, relatedactivityid : *const windows_core::GUID));
    unsafe { IoTransferActivityId(activityid, relatedactivityid) }
}
#[inline]
pub unsafe fn IoTranslateBusAddress(interfacetype: INTERFACE_TYPE, busnumber: u32, busaddress: i64, addressspace: *mut u32, translatedaddress: *mut i64) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoTranslateBusAddress(interfacetype : INTERFACE_TYPE, busnumber : u32, busaddress : i64, addressspace : *mut u32, translatedaddress : *mut i64) -> bool);
    unsafe { IoTranslateBusAddress(interfacetype, busnumber, busaddress, addressspace as _, translatedaddress as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoTryQueueWorkItem(ioworkitem: super::super::Foundation::PIO_WORKITEM, workerroutine: PIO_WORKITEM_ROUTINE_EX, queuetype: WORK_QUEUE_TYPE, context: Option<*const core::ffi::c_void>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn IoTryQueueWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM, workerroutine : PIO_WORKITEM_ROUTINE_EX, queuetype : WORK_QUEUE_TYPE, context : *const core::ffi::c_void) -> bool);
    unsafe { IoTryQueueWorkItem(ioworkitem, workerroutine, queuetype, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoUninitializeWorkItem(ioworkitem: super::super::Foundation::PIO_WORKITEM) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUninitializeWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM));
    unsafe { IoUninitializeWorkItem(ioworkitem) }
}
#[inline]
pub unsafe fn IoUnregisterBootDriverCallback(callbackhandle: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUnregisterBootDriverCallback(callbackhandle : *const core::ffi::c_void));
    unsafe { IoUnregisterBootDriverCallback(callbackhandle) }
}
#[inline]
pub unsafe fn IoUnregisterContainerNotification(callbackregistration: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUnregisterContainerNotification(callbackregistration : *const core::ffi::c_void));
    unsafe { IoUnregisterContainerNotification(callbackregistration) }
}
#[inline]
pub unsafe fn IoUnregisterPlugPlayNotification(notificationentry: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUnregisterPlugPlayNotification(notificationentry : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoUnregisterPlugPlayNotification(notificationentry) }
}
#[inline]
pub unsafe fn IoUnregisterPlugPlayNotificationEx(notificationentry: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUnregisterPlugPlayNotificationEx(notificationentry : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoUnregisterPlugPlayNotificationEx(notificationentry) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUnregisterShutdownNotification(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUnregisterShutdownNotification(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { IoUnregisterShutdownNotification(deviceobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUpdateLinkShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: Option<*mut LINK_SHARE_ACCESS>) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUpdateLinkShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS));
    unsafe { IoUpdateLinkShareAccess(fileobject, shareaccess as _, linkshareaccess.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUpdateLinkShareAccessEx(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUpdateLinkShareAccessEx(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32));
    unsafe { IoUpdateLinkShareAccessEx(fileobject, shareaccess as _, linkshareaccess.unwrap_or(core::mem::zeroed()) as _, ioshareaccessflags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUpdateShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoUpdateShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS));
    unsafe { IoUpdateShareAccess(fileobject, shareaccess as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoValidateDeviceIoControlAccess(irp: *const super::super::Foundation::IRP, requiredaccess: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoValidateDeviceIoControlAccess(irp : *const super::super::Foundation:: IRP, requiredaccess : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoValidateDeviceIoControlAccess(irp, requiredaccess) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoVerifyPartitionTable(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, fixerrors: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoVerifyPartitionTable(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, fixerrors : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoVerifyPartitionTable(deviceobject, fixerrors) }
}
#[inline]
pub unsafe fn IoVolumeDeviceNameToGuid(volumedevicename: *const super::super::super::Win32::Foundation::UNICODE_STRING, guid: *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceNameToGuid(volumedevicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, guid : *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoVolumeDeviceNameToGuid(volumedevicename, guid as _) }
}
#[inline]
pub unsafe fn IoVolumeDeviceNameToGuidPath(volumedevicename: *const super::super::super::Win32::Foundation::UNICODE_STRING, guidpath: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceNameToGuidPath(volumedevicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, guidpath : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoVolumeDeviceNameToGuidPath(volumedevicename, guidpath as _) }
}
#[inline]
pub unsafe fn IoVolumeDeviceToDosName(volumedeviceobject: *const core::ffi::c_void, dosname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceToDosName(volumedeviceobject : *const core::ffi::c_void, dosname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoVolumeDeviceToDosName(volumedeviceobject, dosname as _) }
}
#[inline]
pub unsafe fn IoVolumeDeviceToGuid(volumedeviceobject: *const core::ffi::c_void, guid: *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceToGuid(volumedeviceobject : *const core::ffi::c_void, guid : *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoVolumeDeviceToGuid(volumedeviceobject, guid as _) }
}
#[inline]
pub unsafe fn IoVolumeDeviceToGuidPath(volumedeviceobject: *const core::ffi::c_void, guidpath: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceToGuidPath(volumedeviceobject : *const core::ffi::c_void, guidpath : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoVolumeDeviceToGuidPath(volumedeviceobject, guidpath as _) }
}
#[inline]
pub unsafe fn IoWMIAllocateInstanceIds(guid: *const windows_core::GUID, instancecount: u32, firstinstanceid: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIAllocateInstanceIds(guid : *const windows_core::GUID, instancecount : u32, firstinstanceid : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIAllocateInstanceIds(guid, instancecount, firstinstanceid as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWMIDeviceObjectToInstanceName(datablockobject: *const core::ffi::c_void, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, instancename: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIDeviceObjectToInstanceName(datablockobject : *const core::ffi::c_void, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, instancename : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIDeviceObjectToInstanceName(datablockobject, deviceobject, instancename as _) }
}
#[inline]
pub unsafe fn IoWMIExecuteMethod(datablockobject: *const core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, methodid: u32, inbuffersize: u32, outbuffersize: *mut u32, inoutbuffer: Option<*mut u8>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIExecuteMethod(datablockobject : *const core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, methodid : u32, inbuffersize : u32, outbuffersize : *mut u32, inoutbuffer : *mut u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIExecuteMethod(datablockobject, instancename, methodid, inbuffersize, outbuffersize as _, inoutbuffer.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoWMIHandleToInstanceName(datablockobject: *const core::ffi::c_void, filehandle: super::super::super::Win32::Foundation::HANDLE, instancename: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIHandleToInstanceName(datablockobject : *const core::ffi::c_void, filehandle : super::super::super::Win32::Foundation:: HANDLE, instancename : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIHandleToInstanceName(datablockobject, filehandle, instancename as _) }
}
#[inline]
pub unsafe fn IoWMIOpenBlock(guid: *const windows_core::GUID, desiredaccess: u32, datablockobject: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIOpenBlock(guid : *const windows_core::GUID, desiredaccess : u32, datablockobject : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIOpenBlock(guid, desiredaccess, datablockobject as _) }
}
#[inline]
pub unsafe fn IoWMIQueryAllData(datablockobject: *const core::ffi::c_void, inoutbuffersize: *mut u32, outbuffer: Option<*mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIQueryAllData(datablockobject : *const core::ffi::c_void, inoutbuffersize : *mut u32, outbuffer : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIQueryAllData(datablockobject, inoutbuffersize as _, outbuffer.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoWMIQueryAllDataMultiple(datablockobjectlist: &[*const core::ffi::c_void], inoutbuffersize: *mut u32, outbuffer: Option<*mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIQueryAllDataMultiple(datablockobjectlist : *const *const core::ffi::c_void, objectcount : u32, inoutbuffersize : *mut u32, outbuffer : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIQueryAllDataMultiple(core::mem::transmute(datablockobjectlist.as_ptr()), datablockobjectlist.len().try_into().unwrap(), inoutbuffersize as _, outbuffer.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoWMIQuerySingleInstance(datablockobject: *const core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, inoutbuffersize: *mut u32, outbuffer: Option<*mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIQuerySingleInstance(datablockobject : *const core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, inoutbuffersize : *mut u32, outbuffer : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIQuerySingleInstance(datablockobject, instancename, inoutbuffersize as _, outbuffer.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoWMIQuerySingleInstanceMultiple(datablockobjectlist: *const *const core::ffi::c_void, instancenames: *const super::super::super::Win32::Foundation::UNICODE_STRING, objectcount: u32, inoutbuffersize: *mut u32, outbuffer: Option<*mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIQuerySingleInstanceMultiple(datablockobjectlist : *const *const core::ffi::c_void, instancenames : *const super::super::super::Win32::Foundation:: UNICODE_STRING, objectcount : u32, inoutbuffersize : *mut u32, outbuffer : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIQuerySingleInstanceMultiple(datablockobjectlist, instancenames, objectcount, inoutbuffersize as _, outbuffer.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWMIRegistrationControl(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, action: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIRegistrationControl(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, action : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIRegistrationControl(deviceobject, action) }
}
#[inline]
pub unsafe fn IoWMISetNotificationCallback(object: *mut core::ffi::c_void, callback: WMI_NOTIFICATION_CALLBACK, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMISetNotificationCallback(object : *mut core::ffi::c_void, callback : WMI_NOTIFICATION_CALLBACK, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMISetNotificationCallback(object as _, callback, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IoWMISetSingleInstance(datablockobject: *const core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, version: u32, valuebuffersize: u32, valuebuffer: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMISetSingleInstance(datablockobject : *const core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, version : u32, valuebuffersize : u32, valuebuffer : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMISetSingleInstance(datablockobject, instancename, version, valuebuffersize, valuebuffer) }
}
#[inline]
pub unsafe fn IoWMISetSingleItem(datablockobject: *const core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, dataitemid: u32, version: u32, valuebuffersize: u32, valuebuffer: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMISetSingleItem(datablockobject : *const core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, dataitemid : u32, version : u32, valuebuffersize : u32, valuebuffer : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMISetSingleItem(datablockobject, instancename, dataitemid, version, valuebuffersize, valuebuffer) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWMISuggestInstanceName(physicaldeviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, symboliclinkname: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, combinenames: bool, suggestedinstancename: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMISuggestInstanceName(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, combinenames : bool, suggestedinstancename : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMISuggestInstanceName(physicaldeviceobject.unwrap_or(core::mem::zeroed()) as _, symboliclinkname.unwrap_or(core::mem::zeroed()) as _, combinenames, suggestedinstancename as _) }
}
#[inline]
pub unsafe fn IoWMIWriteEvent(wnodeeventitem: *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWMIWriteEvent(wnodeeventitem : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWMIWriteEvent(wnodeeventitem as _) }
}
#[inline]
pub unsafe fn IoWithinStackLimits(regionstart: usize, regionsize: usize) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWithinStackLimits(regionstart : usize, regionsize : usize) -> u32);
    unsafe { IoWithinStackLimits(regionstart, regionsize) }
}
#[inline]
pub unsafe fn IoWriteErrorLogEntry(elentry: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWriteErrorLogEntry(elentry : *const core::ffi::c_void));
    unsafe { IoWriteErrorLogEntry(elentry) }
}
#[inline]
pub unsafe fn IoWriteKsrPersistentMemory(datahandle: *const core::ffi::c_void, buffer: *const core::ffi::c_void, size: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWriteKsrPersistentMemory(datahandle : *const core::ffi::c_void, buffer : *const core::ffi::c_void, size : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWriteKsrPersistentMemory(datahandle, buffer, size) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWritePartitionTable(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, sectorspertrack: u32, numberofheads: u32, partitionbuffer: *const super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWritePartitionTable(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, sectorspertrack : u32, numberofheads : u32, partitionbuffer : *const super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWritePartitionTable(deviceobject, sectorsize, sectorspertrack, numberofheads, partitionbuffer) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWritePartitionTableEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, drivelayout: *const super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IoWritePartitionTableEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, drivelayout : *const super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IoWritePartitionTableEx(deviceobject, drivelayout) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IofCallDriver(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *mut super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn IofCallDriver(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { IofCallDriver(deviceobject, irp as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IofCompleteRequest(irp: *const super::super::Foundation::IRP, priorityboost: i8) {
    windows_link::link!("ntoskrnl.exe" "system" fn IofCompleteRequest(irp : *const super::super::Foundation:: IRP, priorityboost : i8));
    unsafe { IofCompleteRequest(irp, priorityboost) }
}
#[inline]
pub unsafe fn KdChangeOption(option: KD_OPTION, inbufferbytes: u32, inbuffer: *const core::ffi::c_void, outbufferbytes: u32, outbuffer: *mut core::ffi::c_void, outbufferneeded: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KdChangeOption(option : KD_OPTION, inbufferbytes : u32, inbuffer : *const core::ffi::c_void, outbufferbytes : u32, outbuffer : *mut core::ffi::c_void, outbufferneeded : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KdChangeOption(option, inbufferbytes, inbuffer, outbufferbytes, outbuffer as _, outbufferneeded as _) }
}
#[inline]
pub unsafe fn KdDisableDebugger() -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KdDisableDebugger() -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KdDisableDebugger() }
}
#[inline]
pub unsafe fn KdEnableDebugger() -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KdEnableDebugger() -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KdEnableDebugger() }
}
#[inline]
pub unsafe fn KdRefreshDebuggerNotPresent() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KdRefreshDebuggerNotPresent() -> bool);
    unsafe { KdRefreshDebuggerNotPresent() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeAcquireGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAcquireGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { KeAcquireGuardedMutex(mutex as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeAcquireGuardedMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAcquireGuardedMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { KeAcquireGuardedMutexUnsafe(fastmutex as _) }
}
#[inline]
pub unsafe fn KeAcquireInStackQueuedSpinLock(spinlock: *mut usize, lockhandle: *mut KLOCK_QUEUE_HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAcquireInStackQueuedSpinLock(spinlock : *mut usize, lockhandle : *mut KLOCK_QUEUE_HANDLE));
    unsafe { KeAcquireInStackQueuedSpinLock(spinlock as _, lockhandle as _) }
}
#[inline]
pub unsafe fn KeAcquireInStackQueuedSpinLockAtDpcLevel(spinlock: *mut usize, lockhandle: *mut KLOCK_QUEUE_HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAcquireInStackQueuedSpinLockAtDpcLevel(spinlock : *mut usize, lockhandle : *mut KLOCK_QUEUE_HANDLE));
    unsafe { KeAcquireInStackQueuedSpinLockAtDpcLevel(spinlock as _, lockhandle as _) }
}
#[inline]
pub unsafe fn KeAcquireInStackQueuedSpinLockForDpc(spinlock: *mut usize, lockhandle: *mut KLOCK_QUEUE_HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAcquireInStackQueuedSpinLockForDpc(spinlock : *mut usize, lockhandle : *mut KLOCK_QUEUE_HANDLE));
    unsafe { KeAcquireInStackQueuedSpinLockForDpc(spinlock as _, lockhandle as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeAcquireInterruptSpinLock(interrupt: super::super::Foundation::PKINTERRUPT) -> u8 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAcquireInterruptSpinLock(interrupt : super::super::Foundation:: PKINTERRUPT) -> u8);
    unsafe { KeAcquireInterruptSpinLock(interrupt) }
}
#[inline]
pub unsafe fn KeAcquireSpinLockForDpc(spinlock: *mut usize) -> u8 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAcquireSpinLockForDpc(spinlock : *mut usize) -> u8);
    unsafe { KeAcquireSpinLockForDpc(spinlock as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeAddTriageDumpDataBlock(ktriagedumpdataarray: *mut KTRIAGE_DUMP_DATA_ARRAY, address: *const core::ffi::c_void, size: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAddTriageDumpDataBlock(ktriagedumpdataarray : *mut KTRIAGE_DUMP_DATA_ARRAY, address : *const core::ffi::c_void, size : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeAddTriageDumpDataBlock(ktriagedumpdataarray as _, address, size) }
}
#[inline]
pub unsafe fn KeAreAllApcsDisabled() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAreAllApcsDisabled() -> bool);
    unsafe { KeAreAllApcsDisabled() }
}
#[inline]
pub unsafe fn KeAreApcsDisabled() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeAreApcsDisabled() -> bool);
    unsafe { KeAreApcsDisabled() }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeBugCheck(bugcheckcode: super::super::super::Win32::System::Diagnostics::Debug::BUGCHECK_ERROR) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeBugCheck(bugcheckcode : super::super::super::Win32::System::Diagnostics::Debug:: BUGCHECK_ERROR));
    unsafe { KeBugCheck(bugcheckcode) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeBugCheckEx(bugcheckcode: super::super::super::Win32::System::Diagnostics::Debug::BUGCHECK_ERROR, bugcheckparameter1: usize, bugcheckparameter2: usize, bugcheckparameter3: usize, bugcheckparameter4: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeBugCheckEx(bugcheckcode : super::super::super::Win32::System::Diagnostics::Debug:: BUGCHECK_ERROR, bugcheckparameter1 : usize, bugcheckparameter2 : usize, bugcheckparameter3 : usize, bugcheckparameter4 : usize));
    unsafe { KeBugCheckEx(bugcheckcode, bugcheckparameter1, bugcheckparameter2, bugcheckparameter3, bugcheckparameter4) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeCancelTimer(param0: *mut KTIMER) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeCancelTimer(param0 : *mut KTIMER) -> bool);
    unsafe { KeCancelTimer(param0 as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeClearEvent(event: *mut super::super::Foundation::KEVENT) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeClearEvent(event : *mut super::super::Foundation:: KEVENT));
    unsafe { KeClearEvent(event as _) }
}
#[inline]
pub unsafe fn KeConvertAuxiliaryCounterToPerformanceCounter(auxiliarycountervalue: u64, performancecountervalue: *mut u64, conversionerror: Option<*mut u64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeConvertAuxiliaryCounterToPerformanceCounter(auxiliarycountervalue : u64, performancecountervalue : *mut u64, conversionerror : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeConvertAuxiliaryCounterToPerformanceCounter(auxiliarycountervalue, performancecountervalue as _, conversionerror.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeConvertPerformanceCounterToAuxiliaryCounter(performancecountervalue: u64, auxiliarycountervalue: *mut u64, conversionerror: Option<*mut u64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeConvertPerformanceCounterToAuxiliaryCounter(performancecountervalue : u64, auxiliarycountervalue : *mut u64, conversionerror : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeConvertPerformanceCounterToAuxiliaryCounter(performancecountervalue, auxiliarycountervalue as _, conversionerror.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeDelayExecutionThread(waitmode: i8, alertable: bool, interval: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeDelayExecutionThread(waitmode : i8, alertable : bool, interval : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeDelayExecutionThread(waitmode, alertable, interval) }
}
#[inline]
pub unsafe fn KeDeregisterBoundCallback(handle: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeDeregisterBoundCallback(handle : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeDeregisterBoundCallback(handle) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeDeregisterBugCheckCallback(callbackrecord: *mut KBUGCHECK_CALLBACK_RECORD) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeDeregisterBugCheckCallback(callbackrecord : *mut KBUGCHECK_CALLBACK_RECORD) -> bool);
    unsafe { KeDeregisterBugCheckCallback(callbackrecord as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeDeregisterBugCheckReasonCallback(callbackrecord: *mut KBUGCHECK_REASON_CALLBACK_RECORD) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeDeregisterBugCheckReasonCallback(callbackrecord : *mut KBUGCHECK_REASON_CALLBACK_RECORD) -> bool);
    unsafe { KeDeregisterBugCheckReasonCallback(callbackrecord as _) }
}
#[inline]
pub unsafe fn KeDeregisterNmiCallback(handle: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeDeregisterNmiCallback(handle : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeDeregisterNmiCallback(handle) }
}
#[inline]
pub unsafe fn KeDeregisterProcessorChangeCallback(callbackhandle: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeDeregisterProcessorChangeCallback(callbackhandle : *const core::ffi::c_void));
    unsafe { KeDeregisterProcessorChangeCallback(callbackhandle) }
}
#[inline]
pub unsafe fn KeEnterCriticalRegion() {
    windows_link::link!("ntoskrnl.exe" "system" fn KeEnterCriticalRegion());
    unsafe { KeEnterCriticalRegion() }
}
#[inline]
pub unsafe fn KeEnterGuardedRegion() {
    windows_link::link!("ntoskrnl.exe" "system" fn KeEnterGuardedRegion());
    unsafe { KeEnterGuardedRegion() }
}
#[inline]
pub unsafe fn KeExpandKernelStackAndCallout(callout: PEXPAND_STACK_CALLOUT, parameter: Option<*const core::ffi::c_void>, size: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeExpandKernelStackAndCallout(callout : PEXPAND_STACK_CALLOUT, parameter : *const core::ffi::c_void, size : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeExpandKernelStackAndCallout(callout, parameter.unwrap_or(core::mem::zeroed()) as _, size) }
}
#[inline]
pub unsafe fn KeExpandKernelStackAndCalloutEx(callout: PEXPAND_STACK_CALLOUT, parameter: Option<*const core::ffi::c_void>, size: usize, wait: bool, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeExpandKernelStackAndCalloutEx(callout : PEXPAND_STACK_CALLOUT, parameter : *const core::ffi::c_void, size : usize, wait : bool, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeExpandKernelStackAndCalloutEx(callout, parameter.unwrap_or(core::mem::zeroed()) as _, size, wait, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeFlushIoBuffers(mdl: *const super::super::Foundation::MDL, readoperation: bool, dmaoperation: bool) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeFlushIoBuffers(mdl : *const super::super::Foundation:: MDL, readoperation : bool, dmaoperation : bool));
    unsafe { KeFlushIoBuffers(mdl, readoperation, dmaoperation) }
}
#[inline]
pub unsafe fn KeFlushQueuedDpcs() {
    windows_link::link!("ntoskrnl.exe" "system" fn KeFlushQueuedDpcs());
    unsafe { KeFlushQueuedDpcs() }
}
#[inline]
pub unsafe fn KeFlushWriteBuffer() {
    windows_link::link!("hal.dll" "system" fn KeFlushWriteBuffer());
    unsafe { KeFlushWriteBuffer() }
}
#[inline]
pub unsafe fn KeGetCurrentIrql() -> u8 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeGetCurrentIrql() -> u8);
    unsafe { KeGetCurrentIrql() }
}
#[inline]
pub unsafe fn KeGetCurrentNodeNumber() -> u16 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeGetCurrentNodeNumber() -> u16);
    unsafe { KeGetCurrentNodeNumber() }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeGetCurrentProcessorNumberEx(procnumber: Option<*mut super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER>) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeGetCurrentProcessorNumberEx(procnumber : *mut super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> u32);
    unsafe { KeGetCurrentProcessorNumberEx(procnumber.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeGetProcessorIndexFromNumber(procnumber: *const super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeGetProcessorIndexFromNumber(procnumber : *const super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> u32);
    unsafe { KeGetProcessorIndexFromNumber(procnumber) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeGetProcessorNumberFromIndex(procindex: u32, procnumber: *mut super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeGetProcessorNumberFromIndex(procindex : u32, procnumber : *mut super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeGetProcessorNumberFromIndex(procindex, procnumber as _) }
}
#[inline]
pub unsafe fn KeGetRecommendedSharedDataAlignment() -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeGetRecommendedSharedDataAlignment() -> u32);
    unsafe { KeGetRecommendedSharedDataAlignment() }
}
#[inline]
pub unsafe fn KeInitializeCrashDumpHeader(dumptype: u32, flags: u32, buffer: *mut core::ffi::c_void, buffersize: u32, bufferneeded: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeCrashDumpHeader(dumptype : u32, flags : u32, buffer : *mut core::ffi::c_void, buffersize : u32, bufferneeded : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeInitializeCrashDumpHeader(dumptype, flags, buffer as _, buffersize, bufferneeded.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE));
    unsafe { KeInitializeDeviceQueue(devicequeue as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeDpc(dpc: *mut super::super::Foundation::KDPC, deferredroutine: super::super::Foundation::PKDEFERRED_ROUTINE, deferredcontext: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeDpc(dpc : *mut super::super::Foundation:: KDPC, deferredroutine : super::super::Foundation:: PKDEFERRED_ROUTINE, deferredcontext : *const core::ffi::c_void));
    unsafe { KeInitializeDpc(dpc as _, deferredroutine, deferredcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeEvent(event: *mut super::super::Foundation::KEVENT, r#type: super::super::super::Win32::System::Kernel::EVENT_TYPE, state: bool) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeEvent(event : *mut super::super::Foundation:: KEVENT, r#type : super::super::super::Win32::System::Kernel:: EVENT_TYPE, state : bool));
    unsafe { KeInitializeEvent(event as _, r#type, state) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { KeInitializeGuardedMutex(mutex as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeMutex(mutex: *mut super::super::Foundation::KMUTANT, level: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeMutex(mutex : *mut super::super::Foundation:: KMUTANT, level : u32));
    unsafe { KeInitializeMutex(mutex as _, level) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeSemaphore(semaphore: *mut KSEMAPHORE, count: i32, limit: i32) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeSemaphore(semaphore : *mut KSEMAPHORE, count : i32, limit : i32));
    unsafe { KeInitializeSemaphore(semaphore as _, count, limit) }
}
#[inline]
pub unsafe fn KeInitializeSpinLock() -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeSpinLock(spinlock : *mut usize));
    unsafe {
        let mut result__ = core::mem::zeroed();
        KeInitializeSpinLock(&mut result__);
        result__
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeThreadedDpc(dpc: *mut super::super::Foundation::KDPC, deferredroutine: super::super::Foundation::PKDEFERRED_ROUTINE, deferredcontext: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeThreadedDpc(dpc : *mut super::super::Foundation:: KDPC, deferredroutine : super::super::Foundation:: PKDEFERRED_ROUTINE, deferredcontext : *const core::ffi::c_void));
    unsafe { KeInitializeThreadedDpc(dpc as _, deferredroutine, deferredcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeTimer(timer: *mut KTIMER) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeTimer(timer : *mut KTIMER));
    unsafe { KeInitializeTimer(timer as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeTimerEx(timer: *mut KTIMER, r#type: super::super::super::Win32::System::Kernel::TIMER_TYPE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeTimerEx(timer : *mut KTIMER, r#type : super::super::super::Win32::System::Kernel:: TIMER_TYPE));
    unsafe { KeInitializeTimerEx(timer as _, r#type) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeInitializeTriageDumpDataArray(ktriagedumpdataarray: *mut KTRIAGE_DUMP_DATA_ARRAY, size: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInitializeTriageDumpDataArray(ktriagedumpdataarray : *mut KTRIAGE_DUMP_DATA_ARRAY, size : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeInitializeTriageDumpDataArray(ktriagedumpdataarray as _, size) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInsertByKeyDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, devicequeueentry: *mut KDEVICE_QUEUE_ENTRY, sortkey: u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInsertByKeyDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, devicequeueentry : *mut KDEVICE_QUEUE_ENTRY, sortkey : u32) -> bool);
    unsafe { KeInsertByKeyDeviceQueue(devicequeue as _, devicequeueentry as _, sortkey) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInsertDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, devicequeueentry: *mut KDEVICE_QUEUE_ENTRY) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInsertDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, devicequeueentry : *mut KDEVICE_QUEUE_ENTRY) -> bool);
    unsafe { KeInsertDeviceQueue(devicequeue as _, devicequeueentry as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInsertQueueDpc(dpc: *mut super::super::Foundation::KDPC, systemargument1: Option<*const core::ffi::c_void>, systemargument2: Option<*const core::ffi::c_void>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInsertQueueDpc(dpc : *mut super::super::Foundation:: KDPC, systemargument1 : *const core::ffi::c_void, systemargument2 : *const core::ffi::c_void) -> bool);
    unsafe { KeInsertQueueDpc(dpc as _, systemargument1.unwrap_or(core::mem::zeroed()) as _, systemargument2.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeInvalidateAllCaches() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInvalidateAllCaches() -> bool);
    unsafe { KeInvalidateAllCaches() }
}
#[inline]
pub unsafe fn KeInvalidateRangeAllCaches(baseaddress: *const core::ffi::c_void, length: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeInvalidateRangeAllCaches(baseaddress : *const core::ffi::c_void, length : u32));
    unsafe { KeInvalidateRangeAllCaches(baseaddress, length) }
}
#[inline]
pub unsafe fn KeIpiGenericCall(broadcastfunction: PKIPI_BROADCAST_WORKER, context: usize) -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn KeIpiGenericCall(broadcastfunction : PKIPI_BROADCAST_WORKER, context : usize) -> usize);
    unsafe { KeIpiGenericCall(broadcastfunction, context) }
}
#[inline]
pub unsafe fn KeIsExecutingDpc() -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeIsExecutingDpc() -> u32);
    unsafe { KeIsExecutingDpc() }
}
#[inline]
pub unsafe fn KeLeaveCriticalRegion() {
    windows_link::link!("ntoskrnl.exe" "system" fn KeLeaveCriticalRegion());
    unsafe { KeLeaveCriticalRegion() }
}
#[inline]
pub unsafe fn KeLeaveGuardedRegion() {
    windows_link::link!("ntoskrnl.exe" "system" fn KeLeaveGuardedRegion());
    unsafe { KeLeaveGuardedRegion() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KePulseEvent(event: *mut super::super::Foundation::KEVENT, increment: i32, wait: bool) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KePulseEvent(event : *mut super::super::Foundation:: KEVENT, increment : i32, wait : bool) -> i32);
    unsafe { KePulseEvent(event as _, increment, wait) }
}
#[inline]
pub unsafe fn KeQueryActiveGroupCount() -> u16 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryActiveGroupCount() -> u16);
    unsafe { KeQueryActiveGroupCount() }
}
#[inline]
pub unsafe fn KeQueryActiveProcessorCount(activeprocessors: Option<*mut usize>) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryActiveProcessorCount(activeprocessors : *mut usize) -> u32);
    unsafe { KeQueryActiveProcessorCount(activeprocessors.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeQueryActiveProcessorCountEx(groupnumber: u16) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryActiveProcessorCountEx(groupnumber : u16) -> u32);
    unsafe { KeQueryActiveProcessorCountEx(groupnumber) }
}
#[inline]
pub unsafe fn KeQueryActiveProcessors() -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryActiveProcessors() -> usize);
    unsafe { KeQueryActiveProcessors() }
}
#[inline]
pub unsafe fn KeQueryAuxiliaryCounterFrequency(auxiliarycounterfrequency: Option<*mut u64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryAuxiliaryCounterFrequency(auxiliarycounterfrequency : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeQueryAuxiliaryCounterFrequency(auxiliarycounterfrequency.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeQueryDpcWatchdogInformation(watchdoginformation: *mut KDPC_WATCHDOG_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryDpcWatchdogInformation(watchdoginformation : *mut KDPC_WATCHDOG_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeQueryDpcWatchdogInformation(watchdoginformation as _) }
}
#[inline]
pub unsafe fn KeQueryGroupAffinity(groupnumber: u16) -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryGroupAffinity(groupnumber : u16) -> usize);
    unsafe { KeQueryGroupAffinity(groupnumber) }
}
#[inline]
pub unsafe fn KeQueryHardwareCounterConfiguration(counterarray: &mut [HARDWARE_COUNTER], count: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryHardwareCounterConfiguration(counterarray : *mut HARDWARE_COUNTER, maximumcount : u32, count : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeQueryHardwareCounterConfiguration(core::mem::transmute(counterarray.as_ptr()), counterarray.len().try_into().unwrap(), count as _) }
}
#[inline]
pub unsafe fn KeQueryHighestNodeNumber() -> u16 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryHighestNodeNumber() -> u16);
    unsafe { KeQueryHighestNodeNumber() }
}
#[inline]
pub unsafe fn KeQueryInterruptTimePrecise(qpctimestamp: *mut u64) -> u64 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryInterruptTimePrecise(qpctimestamp : *mut u64) -> u64);
    unsafe { KeQueryInterruptTimePrecise(qpctimestamp as _) }
}
#[cfg(all(feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn KeQueryLogicalProcessorRelationship(processornumber: Option<*const super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER>, relationshiptype: super::super::super::Win32::System::SystemInformation::LOGICAL_PROCESSOR_RELATIONSHIP, information: Option<*mut super::super::super::Win32::System::SystemInformation::SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX>, length: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryLogicalProcessorRelationship(processornumber : *const super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER, relationshiptype : super::super::super::Win32::System::SystemInformation:: LOGICAL_PROCESSOR_RELATIONSHIP, information : *mut super::super::super::Win32::System::SystemInformation:: SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX, length : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeQueryLogicalProcessorRelationship(processornumber.unwrap_or(core::mem::zeroed()) as _, relationshiptype, information.unwrap_or(core::mem::zeroed()) as _, length as _) }
}
#[inline]
pub unsafe fn KeQueryMaximumGroupCount() -> u16 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryMaximumGroupCount() -> u16);
    unsafe { KeQueryMaximumGroupCount() }
}
#[inline]
pub unsafe fn KeQueryMaximumProcessorCount() -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryMaximumProcessorCount() -> u32);
    unsafe { KeQueryMaximumProcessorCount() }
}
#[inline]
pub unsafe fn KeQueryMaximumProcessorCountEx(groupnumber: u16) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryMaximumProcessorCountEx(groupnumber : u16) -> u32);
    unsafe { KeQueryMaximumProcessorCountEx(groupnumber) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeQueryNodeActiveAffinity(nodenumber: u16, affinity: Option<*mut super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY>, count: Option<*mut u16>) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryNodeActiveAffinity(nodenumber : u16, affinity : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, count : *mut u16));
    unsafe { KeQueryNodeActiveAffinity(nodenumber, affinity.unwrap_or(core::mem::zeroed()) as _, count.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeQueryNodeActiveAffinity2(nodenumber: u16, groupaffinities: Option<&mut [super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY]>, groupaffinitiesrequired: *mut u16) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryNodeActiveAffinity2(nodenumber : u16, groupaffinities : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, groupaffinitiescount : u16, groupaffinitiesrequired : *mut u16) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeQueryNodeActiveAffinity2(nodenumber, core::mem::transmute(groupaffinities.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), groupaffinities.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), groupaffinitiesrequired as _) }
}
#[inline]
pub unsafe fn KeQueryNodeActiveProcessorCount(nodenumber: u16) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryNodeActiveProcessorCount(nodenumber : u16) -> u32);
    unsafe { KeQueryNodeActiveProcessorCount(nodenumber) }
}
#[inline]
pub unsafe fn KeQueryNodeMaximumProcessorCount(nodenumber: u16) -> u16 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryNodeMaximumProcessorCount(nodenumber : u16) -> u16);
    unsafe { KeQueryNodeMaximumProcessorCount(nodenumber) }
}
#[inline]
pub unsafe fn KeQueryPerformanceCounter(performancefrequency: Option<*mut i64>) -> i64 {
    windows_link::link!("hal.dll" "system" fn KeQueryPerformanceCounter(performancefrequency : *mut i64) -> i64);
    unsafe { KeQueryPerformanceCounter(performancefrequency.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeQueryPriorityThread(thread: super::super::Foundation::PKTHREAD) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryPriorityThread(thread : super::super::Foundation:: PKTHREAD) -> i32);
    unsafe { KeQueryPriorityThread(thread) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeQueryRuntimeThread(thread: super::super::Foundation::PKTHREAD, usertime: *mut u32) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryRuntimeThread(thread : super::super::Foundation:: PKTHREAD, usertime : *mut u32) -> u32);
    unsafe { KeQueryRuntimeThread(thread, usertime as _) }
}
#[inline]
pub unsafe fn KeQuerySystemTimePrecise() -> i64 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQuerySystemTimePrecise(currenttime : *mut i64));
    unsafe {
        let mut result__ = core::mem::zeroed();
        KeQuerySystemTimePrecise(&mut result__);
        result__
    }
}
#[inline]
pub unsafe fn KeQueryTimeIncrement() -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryTimeIncrement() -> u32);
    unsafe { KeQueryTimeIncrement() }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeQueryTotalCycleTimeThread(thread: super::super::Foundation::PKTHREAD, cycletimestamp: *mut u64) -> u64 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryTotalCycleTimeThread(thread : super::super::Foundation:: PKTHREAD, cycletimestamp : *mut u64) -> u64);
    unsafe { KeQueryTotalCycleTimeThread(thread, cycletimestamp as _) }
}
#[inline]
pub unsafe fn KeQueryUnbiasedInterruptTime() -> u64 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryUnbiasedInterruptTime() -> u64);
    unsafe { KeQueryUnbiasedInterruptTime() }
}
#[inline]
pub unsafe fn KeQueryUnbiasedInterruptTimePrecise(qpctimestamp: *mut u64) -> u64 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeQueryUnbiasedInterruptTimePrecise(qpctimestamp : *mut u64) -> u64);
    unsafe { KeQueryUnbiasedInterruptTimePrecise(qpctimestamp as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateEvent(event: *const super::super::Foundation::KEVENT) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReadStateEvent(event : *const super::super::Foundation:: KEVENT) -> i32);
    unsafe { KeReadStateEvent(event) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateMutex(mutex: *const super::super::Foundation::KMUTANT) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReadStateMutex(mutex : *const super::super::Foundation:: KMUTANT) -> i32);
    unsafe { KeReadStateMutex(mutex) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateSemaphore(semaphore: *const KSEMAPHORE) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReadStateSemaphore(semaphore : *const KSEMAPHORE) -> i32);
    unsafe { KeReadStateSemaphore(semaphore) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateTimer(timer: *const KTIMER) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReadStateTimer(timer : *const KTIMER) -> bool);
    unsafe { KeReadStateTimer(timer) }
}
#[inline]
pub unsafe fn KeRegisterBoundCallback(callbackroutine: PBOUND_CALLBACK) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRegisterBoundCallback(callbackroutine : PBOUND_CALLBACK) -> *mut core::ffi::c_void);
    unsafe { KeRegisterBoundCallback(callbackroutine) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeRegisterBugCheckCallback(callbackrecord: *mut KBUGCHECK_CALLBACK_RECORD, callbackroutine: PKBUGCHECK_CALLBACK_ROUTINE, buffer: Option<*const core::ffi::c_void>, length: u32, component: *const u8) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRegisterBugCheckCallback(callbackrecord : *mut KBUGCHECK_CALLBACK_RECORD, callbackroutine : PKBUGCHECK_CALLBACK_ROUTINE, buffer : *const core::ffi::c_void, length : u32, component : *const u8) -> bool);
    unsafe { KeRegisterBugCheckCallback(callbackrecord as _, callbackroutine, buffer.unwrap_or(core::mem::zeroed()) as _, length, component) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeRegisterBugCheckReasonCallback(callbackrecord: *mut KBUGCHECK_REASON_CALLBACK_RECORD, callbackroutine: PKBUGCHECK_REASON_CALLBACK_ROUTINE, reason: KBUGCHECK_CALLBACK_REASON, component: *const u8) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRegisterBugCheckReasonCallback(callbackrecord : *mut KBUGCHECK_REASON_CALLBACK_RECORD, callbackroutine : PKBUGCHECK_REASON_CALLBACK_ROUTINE, reason : KBUGCHECK_CALLBACK_REASON, component : *const u8) -> bool);
    unsafe { KeRegisterBugCheckReasonCallback(callbackrecord as _, callbackroutine, reason, component) }
}
#[inline]
pub unsafe fn KeRegisterNmiCallback(callbackroutine: PNMI_CALLBACK, context: Option<*const core::ffi::c_void>) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRegisterNmiCallback(callbackroutine : PNMI_CALLBACK, context : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { KeRegisterNmiCallback(callbackroutine, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeRegisterProcessorChangeCallback(callbackfunction: PPROCESSOR_CALLBACK_FUNCTION, callbackcontext: Option<*const core::ffi::c_void>, flags: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRegisterProcessorChangeCallback(callbackfunction : PPROCESSOR_CALLBACK_FUNCTION, callbackcontext : *const core::ffi::c_void, flags : u32) -> *mut core::ffi::c_void);
    unsafe { KeRegisterProcessorChangeCallback(callbackfunction, callbackcontext.unwrap_or(core::mem::zeroed()) as _, flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { KeReleaseGuardedMutex(mutex as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseGuardedMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseGuardedMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    unsafe { KeReleaseGuardedMutexUnsafe(fastmutex as _) }
}
#[inline]
pub unsafe fn KeReleaseInStackQueuedSpinLock(lockhandle: *const KLOCK_QUEUE_HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseInStackQueuedSpinLock(lockhandle : *const KLOCK_QUEUE_HANDLE));
    unsafe { KeReleaseInStackQueuedSpinLock(lockhandle) }
}
#[inline]
pub unsafe fn KeReleaseInStackQueuedSpinLockForDpc(lockhandle: *const KLOCK_QUEUE_HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseInStackQueuedSpinLockForDpc(lockhandle : *const KLOCK_QUEUE_HANDLE));
    unsafe { KeReleaseInStackQueuedSpinLockForDpc(lockhandle) }
}
#[inline]
pub unsafe fn KeReleaseInStackQueuedSpinLockFromDpcLevel(lockhandle: *const KLOCK_QUEUE_HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseInStackQueuedSpinLockFromDpcLevel(lockhandle : *const KLOCK_QUEUE_HANDLE));
    unsafe { KeReleaseInStackQueuedSpinLockFromDpcLevel(lockhandle) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeReleaseInterruptSpinLock(interrupt: super::super::Foundation::PKINTERRUPT, oldirql: u8) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseInterruptSpinLock(interrupt : super::super::Foundation:: PKINTERRUPT, oldirql : u8));
    unsafe { KeReleaseInterruptSpinLock(interrupt, oldirql) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseMutex(mutex: *mut super::super::Foundation::KMUTANT, wait: bool) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseMutex(mutex : *mut super::super::Foundation:: KMUTANT, wait : bool) -> i32);
    unsafe { KeReleaseMutex(mutex as _, wait) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseSemaphore(semaphore: *mut KSEMAPHORE, increment: i32, adjustment: i32, wait: bool) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseSemaphore(semaphore : *mut KSEMAPHORE, increment : i32, adjustment : i32, wait : bool) -> i32);
    unsafe { KeReleaseSemaphore(semaphore as _, increment, adjustment, wait) }
}
#[inline]
pub unsafe fn KeReleaseSpinLockForDpc(spinlock: *mut usize, oldirql: u8) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeReleaseSpinLockForDpc(spinlock : *mut usize, oldirql : u8));
    unsafe { KeReleaseSpinLockForDpc(spinlock as _, oldirql) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveByKeyDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, sortkey: u32) -> *mut KDEVICE_QUEUE_ENTRY {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRemoveByKeyDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, sortkey : u32) -> *mut KDEVICE_QUEUE_ENTRY);
    unsafe { KeRemoveByKeyDeviceQueue(devicequeue as _, sortkey) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveByKeyDeviceQueueIfBusy(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, sortkey: u32) -> *mut KDEVICE_QUEUE_ENTRY {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRemoveByKeyDeviceQueueIfBusy(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, sortkey : u32) -> *mut KDEVICE_QUEUE_ENTRY);
    unsafe { KeRemoveByKeyDeviceQueueIfBusy(devicequeue as _, sortkey) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE) -> *mut KDEVICE_QUEUE_ENTRY {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRemoveDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE) -> *mut KDEVICE_QUEUE_ENTRY);
    unsafe { KeRemoveDeviceQueue(devicequeue as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveEntryDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, devicequeueentry: *mut KDEVICE_QUEUE_ENTRY) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRemoveEntryDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, devicequeueentry : *mut KDEVICE_QUEUE_ENTRY) -> bool);
    unsafe { KeRemoveEntryDeviceQueue(devicequeue as _, devicequeueentry as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveQueueDpc(dpc: *mut super::super::Foundation::KDPC) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRemoveQueueDpc(dpc : *mut super::super::Foundation:: KDPC) -> bool);
    unsafe { KeRemoveQueueDpc(dpc as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveQueueDpcEx(dpc: *mut super::super::Foundation::KDPC, waitifactive: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRemoveQueueDpcEx(dpc : *mut super::super::Foundation:: KDPC, waitifactive : bool) -> bool);
    unsafe { KeRemoveQueueDpcEx(dpc as _, waitifactive) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeResetEvent(event: *mut super::super::Foundation::KEVENT) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeResetEvent(event : *mut super::super::Foundation:: KEVENT) -> i32);
    unsafe { KeResetEvent(event as _) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeRestoreExtendedProcessorState(xstatesave: *const XSTATE_SAVE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRestoreExtendedProcessorState(xstatesave : *const XSTATE_SAVE));
    unsafe { KeRestoreExtendedProcessorState(xstatesave) }
}
#[inline]
pub unsafe fn KeRevertToUserAffinityThread() {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRevertToUserAffinityThread());
    unsafe { KeRevertToUserAffinityThread() }
}
#[inline]
pub unsafe fn KeRevertToUserAffinityThreadEx(affinity: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRevertToUserAffinityThreadEx(affinity : usize));
    unsafe { KeRevertToUserAffinityThreadEx(affinity) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeRevertToUserGroupAffinityThread(previousaffinity: *const super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeRevertToUserGroupAffinityThread(previousaffinity : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY));
    unsafe { KeRevertToUserGroupAffinityThread(previousaffinity) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeSaveExtendedProcessorState(mask: u64, xstatesave: *mut XSTATE_SAVE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSaveExtendedProcessorState(mask : u64, xstatesave : *mut XSTATE_SAVE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeSaveExtendedProcessorState(mask, xstatesave as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeSetBasePriorityThread(thread: super::super::Foundation::PKTHREAD, increment: i32) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetBasePriorityThread(thread : super::super::Foundation:: PKTHREAD, increment : i32) -> i32);
    unsafe { KeSetBasePriorityThread(thread, increment) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetCoalescableTimer(timer: *mut KTIMER, duetime: i64, period: u32, tolerabledelay: u32, dpc: Option<*const super::super::Foundation::KDPC>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetCoalescableTimer(timer : *mut KTIMER, duetime : i64, period : u32, tolerabledelay : u32, dpc : *const super::super::Foundation:: KDPC) -> bool);
    unsafe { KeSetCoalescableTimer(timer as _, duetime, period, tolerabledelay, dpc.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetEvent(event: *mut super::super::Foundation::KEVENT, increment: i32, wait: bool) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetEvent(event : *mut super::super::Foundation:: KEVENT, increment : i32, wait : bool) -> i32);
    unsafe { KeSetEvent(event as _, increment, wait) }
}
#[inline]
pub unsafe fn KeSetHardwareCounterConfiguration(counterarray: &[HARDWARE_COUNTER]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetHardwareCounterConfiguration(counterarray : *const HARDWARE_COUNTER, count : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeSetHardwareCounterConfiguration(core::mem::transmute(counterarray.as_ptr()), counterarray.len().try_into().unwrap()) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetImportanceDpc(dpc: *mut super::super::Foundation::KDPC, importance: KDPC_IMPORTANCE) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetImportanceDpc(dpc : *mut super::super::Foundation:: KDPC, importance : KDPC_IMPORTANCE));
    unsafe { KeSetImportanceDpc(dpc as _, importance) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeSetPriorityThread(thread: super::super::Foundation::PKTHREAD, priority: i32) -> i32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetPriorityThread(thread : super::super::Foundation:: PKTHREAD, priority : i32) -> i32);
    unsafe { KeSetPriorityThread(thread, priority) }
}
#[inline]
pub unsafe fn KeSetSystemAffinityThread(affinity: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetSystemAffinityThread(affinity : usize));
    unsafe { KeSetSystemAffinityThread(affinity) }
}
#[inline]
pub unsafe fn KeSetSystemAffinityThreadEx(affinity: usize) -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetSystemAffinityThreadEx(affinity : usize) -> usize);
    unsafe { KeSetSystemAffinityThreadEx(affinity) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeSetSystemGroupAffinityThread(affinity: *const super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY, previousaffinity: Option<*mut super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY>) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetSystemGroupAffinityThread(affinity : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, previousaffinity : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY));
    unsafe { KeSetSystemGroupAffinityThread(affinity, previousaffinity.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTargetProcessorDpc(dpc: *mut super::super::Foundation::KDPC, number: i8) {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetTargetProcessorDpc(dpc : *mut super::super::Foundation:: KDPC, number : i8));
    unsafe { KeSetTargetProcessorDpc(dpc as _, number) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTargetProcessorDpcEx(dpc: *mut super::super::Foundation::KDPC, procnumber: *const super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetTargetProcessorDpcEx(dpc : *mut super::super::Foundation:: KDPC, procnumber : *const super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeSetTargetProcessorDpcEx(dpc as _, procnumber) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTimer(timer: *mut KTIMER, duetime: i64, dpc: Option<*const super::super::Foundation::KDPC>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetTimer(timer : *mut KTIMER, duetime : i64, dpc : *const super::super::Foundation:: KDPC) -> bool);
    unsafe { KeSetTimer(timer as _, duetime, dpc.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTimerEx(timer: *mut KTIMER, duetime: i64, period: i32, dpc: Option<*const super::super::Foundation::KDPC>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSetTimerEx(timer : *mut KTIMER, duetime : i64, period : i32, dpc : *const super::super::Foundation:: KDPC) -> bool);
    unsafe { KeSetTimerEx(timer as _, duetime, period, dpc.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeShouldYieldProcessor() -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn KeShouldYieldProcessor() -> u32);
    unsafe { KeShouldYieldProcessor() }
}
#[inline]
pub unsafe fn KeStallExecutionProcessor(microseconds: u32) {
    windows_link::link!("hal.dll" "system" fn KeStallExecutionProcessor(microseconds : u32));
    unsafe { KeStallExecutionProcessor(microseconds) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeSynchronizeExecution(interrupt: super::super::Foundation::PKINTERRUPT, synchronizeroutine: PKSYNCHRONIZE_ROUTINE, synchronizecontext: Option<*const core::ffi::c_void>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeSynchronizeExecution(interrupt : super::super::Foundation:: PKINTERRUPT, synchronizeroutine : PKSYNCHRONIZE_ROUTINE, synchronizecontext : *const core::ffi::c_void) -> bool);
    unsafe { KeSynchronizeExecution(interrupt, synchronizeroutine, synchronizecontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeTestSpinLock(spinlock: *const usize) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeTestSpinLock(spinlock : *const usize) -> bool);
    unsafe { KeTestSpinLock(spinlock) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeTryToAcquireGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeTryToAcquireGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX) -> bool);
    unsafe { KeTryToAcquireGuardedMutex(mutex as _) }
}
#[inline]
pub unsafe fn KeTryToAcquireSpinLockAtDpcLevel(spinlock: *mut usize) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn KeTryToAcquireSpinLockAtDpcLevel(spinlock : *mut usize) -> bool);
    unsafe { KeTryToAcquireSpinLockAtDpcLevel(spinlock as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeWaitForMultipleObjects(object: &[*const core::ffi::c_void], waittype: super::super::super::Win32::System::Kernel::WAIT_TYPE, waitreason: KWAIT_REASON, waitmode: i8, alertable: bool, timeout: Option<*const i64>, waitblockarray: Option<*mut super::super::Foundation::KWAIT_BLOCK>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeWaitForMultipleObjects(count : u32, object : *const *const core::ffi::c_void, waittype : super::super::super::Win32::System::Kernel:: WAIT_TYPE, waitreason : KWAIT_REASON, waitmode : i8, alertable : bool, timeout : *const i64, waitblockarray : *mut super::super::Foundation:: KWAIT_BLOCK) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeWaitForMultipleObjects(object.len().try_into().unwrap(), core::mem::transmute(object.as_ptr()), waittype, waitreason, waitmode, alertable, timeout.unwrap_or(core::mem::zeroed()) as _, waitblockarray.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KeWaitForSingleObject(object: *const core::ffi::c_void, waitreason: KWAIT_REASON, waitmode: i8, alertable: bool, timeout: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn KeWaitForSingleObject(object : *const core::ffi::c_void, waitreason : KWAIT_REASON, waitmode : i8, alertable : bool, timeout : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { KeWaitForSingleObject(object, waitreason, waitmode, alertable, timeout.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn KfRaiseIrql(newirql: u8) -> u8 {
    windows_link::link!("ntoskrnl.exe" "system" fn KfRaiseIrql(newirql : u8) -> u8);
    unsafe { KfRaiseIrql(newirql) }
}
#[inline]
pub unsafe fn MmAddPhysicalMemory(startaddress: *const i64, numberofbytes: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAddPhysicalMemory(startaddress : *const i64, numberofbytes : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmAddPhysicalMemory(startaddress, numberofbytes as _) }
}
#[inline]
pub unsafe fn MmAddVerifierSpecialThunks(entryroutine: usize, thunkbuffer: *const core::ffi::c_void, thunkbuffersize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAddVerifierSpecialThunks(entryroutine : usize, thunkbuffer : *const core::ffi::c_void, thunkbuffersize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmAddVerifierSpecialThunks(entryroutine, thunkbuffer, thunkbuffersize) }
}
#[inline]
pub unsafe fn MmAddVerifierThunks(thunkbuffer: *const core::ffi::c_void, thunkbuffersize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAddVerifierThunks(thunkbuffer : *const core::ffi::c_void, thunkbuffersize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmAddVerifierThunks(thunkbuffer, thunkbuffersize) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAdvanceMdl(mdl: *mut super::super::Foundation::MDL, numberofbytes: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAdvanceMdl(mdl : *mut super::super::Foundation:: MDL, numberofbytes : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmAdvanceMdl(mdl as _, numberofbytes) }
}
#[inline]
pub unsafe fn MmAllocateContiguousMemory(numberofbytes: usize, highestacceptableaddress: i64) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemory(numberofbytes : usize, highestacceptableaddress : i64) -> *mut core::ffi::c_void);
    unsafe { MmAllocateContiguousMemory(numberofbytes, highestacceptableaddress) }
}
#[inline]
pub unsafe fn MmAllocateContiguousMemoryEx(numberofbytes: *const usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: i64, preferrednode: u32, protect: u32, partitionobject: Option<*const core::ffi::c_void>, tag: u32, flags: u32, baseaddress: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemoryEx(numberofbytes : *const usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, preferrednode : u32, protect : u32, partitionobject : *const core::ffi::c_void, tag : u32, flags : u32, baseaddress : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmAllocateContiguousMemoryEx(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple, preferrednode, protect, partitionobject.unwrap_or(core::mem::zeroed()) as _, tag, flags, baseaddress as _) }
}
#[inline]
pub unsafe fn MmAllocateContiguousMemorySpecifyCache(numberofbytes: usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: Option<i64>, cachetype: MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemorySpecifyCache(numberofbytes : usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, cachetype : MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void);
    unsafe { MmAllocateContiguousMemorySpecifyCache(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple.unwrap_or(core::mem::zeroed()) as _, cachetype) }
}
#[inline]
pub unsafe fn MmAllocateContiguousMemorySpecifyCacheNode(numberofbytes: usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: Option<i64>, cachetype: MEMORY_CACHING_TYPE, preferrednode: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemorySpecifyCacheNode(numberofbytes : usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, cachetype : MEMORY_CACHING_TYPE, preferrednode : u32) -> *mut core::ffi::c_void);
    unsafe { MmAllocateContiguousMemorySpecifyCacheNode(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple.unwrap_or(core::mem::zeroed()) as _, cachetype, preferrednode) }
}
#[inline]
pub unsafe fn MmAllocateContiguousNodeMemory(numberofbytes: usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: Option<i64>, protect: u32, preferrednode: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousNodeMemory(numberofbytes : usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, protect : u32, preferrednode : u32) -> *mut core::ffi::c_void);
    unsafe { MmAllocateContiguousNodeMemory(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple.unwrap_or(core::mem::zeroed()) as _, protect, preferrednode) }
}
#[inline]
pub unsafe fn MmAllocateMappingAddress(numberofbytes: usize, pooltag: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateMappingAddress(numberofbytes : usize, pooltag : u32) -> *mut core::ffi::c_void);
    unsafe { MmAllocateMappingAddress(numberofbytes, pooltag) }
}
#[inline]
pub unsafe fn MmAllocateMappingAddressEx(numberofbytes: usize, pooltag: u32, flags: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateMappingAddressEx(numberofbytes : usize, pooltag : u32, flags : u32) -> *mut core::ffi::c_void);
    unsafe { MmAllocateMappingAddressEx(numberofbytes, pooltag, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocateMdlForIoSpace(physicaladdresslist: &[MM_PHYSICAL_ADDRESS_LIST], newmdl: *mut *mut super::super::Foundation::MDL) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateMdlForIoSpace(physicaladdresslist : *const MM_PHYSICAL_ADDRESS_LIST, numberofentries : usize, newmdl : *mut *mut super::super::Foundation:: MDL) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmAllocateMdlForIoSpace(core::mem::transmute(physicaladdresslist.as_ptr()), physicaladdresslist.len().try_into().unwrap(), newmdl as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocateNodePagesForMdlEx(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize, cachetype: MEMORY_CACHING_TYPE, idealnode: u32, flags: u32) -> *mut super::super::Foundation::MDL {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateNodePagesForMdlEx(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize, cachetype : MEMORY_CACHING_TYPE, idealnode : u32, flags : u32) -> *mut super::super::Foundation:: MDL);
    unsafe { MmAllocateNodePagesForMdlEx(lowaddress, highaddress, skipbytes, totalbytes, cachetype, idealnode, flags) }
}
#[inline]
pub unsafe fn MmAllocateNonCachedMemory(numberofbytes: usize) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocateNonCachedMemory(numberofbytes : usize) -> *mut core::ffi::c_void);
    unsafe { MmAllocateNonCachedMemory(numberofbytes) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocatePagesForMdl(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize) -> *mut super::super::Foundation::MDL {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocatePagesForMdl(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize) -> *mut super::super::Foundation:: MDL);
    unsafe { MmAllocatePagesForMdl(lowaddress, highaddress, skipbytes, totalbytes) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocatePagesForMdlEx(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize, cachetype: MEMORY_CACHING_TYPE, flags: u32) -> *mut super::super::Foundation::MDL {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocatePagesForMdlEx(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize, cachetype : MEMORY_CACHING_TYPE, flags : u32) -> *mut super::super::Foundation:: MDL);
    unsafe { MmAllocatePagesForMdlEx(lowaddress, highaddress, skipbytes, totalbytes, cachetype, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocatePartitionNodePagesForMdlEx(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize, cachetype: MEMORY_CACHING_TYPE, idealnode: u32, flags: u32, partitionobject: Option<*const core::ffi::c_void>) -> *mut super::super::Foundation::MDL {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAllocatePartitionNodePagesForMdlEx(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize, cachetype : MEMORY_CACHING_TYPE, idealnode : u32, flags : u32, partitionobject : *const core::ffi::c_void) -> *mut super::super::Foundation:: MDL);
    unsafe { MmAllocatePartitionNodePagesForMdlEx(lowaddress, highaddress, skipbytes, totalbytes, cachetype, idealnode, flags, partitionobject.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAreMdlPagesCached(memorydescriptorlist: *const super::super::Foundation::MDL) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn MmAreMdlPagesCached(memorydescriptorlist : *const super::super::Foundation:: MDL) -> u32);
    unsafe { MmAreMdlPagesCached(memorydescriptorlist) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmBuildMdlForNonPagedPool(memorydescriptorlist: *mut super::super::Foundation::MDL) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmBuildMdlForNonPagedPool(memorydescriptorlist : *mut super::super::Foundation:: MDL));
    unsafe { MmBuildMdlForNonPagedPool(memorydescriptorlist as _) }
}
#[inline]
pub unsafe fn MmCopyMemory(targetaddress: *const core::ffi::c_void, sourceaddress: MM_COPY_ADDRESS, numberofbytes: usize, flags: u32, numberofbytestransferred: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmCopyMemory(targetaddress : *const core::ffi::c_void, sourceaddress : MM_COPY_ADDRESS, numberofbytes : usize, flags : u32, numberofbytestransferred : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmCopyMemory(targetaddress, core::mem::transmute(sourceaddress), numberofbytes, flags, numberofbytestransferred as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmCreateMdl(memorydescriptorlist: Option<*mut super::super::Foundation::MDL>, base: Option<*const core::ffi::c_void>, length: usize) -> *mut super::super::Foundation::MDL {
    windows_link::link!("ntoskrnl.exe" "system" fn MmCreateMdl(memorydescriptorlist : *mut super::super::Foundation:: MDL, base : *const core::ffi::c_void, length : usize) -> *mut super::super::Foundation:: MDL);
    unsafe { MmCreateMdl(memorydescriptorlist.unwrap_or(core::mem::zeroed()) as _, base.unwrap_or(core::mem::zeroed()) as _, length) }
}
#[inline]
pub unsafe fn MmCreateMirror() -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmCreateMirror() -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmCreateMirror() }
}
#[inline]
pub unsafe fn MmFreeContiguousMemory(baseaddress: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmFreeContiguousMemory(baseaddress : *const core::ffi::c_void));
    unsafe { MmFreeContiguousMemory(baseaddress) }
}
#[inline]
pub unsafe fn MmFreeContiguousMemorySpecifyCache(baseaddress: *const core::ffi::c_void, numberofbytes: usize, cachetype: MEMORY_CACHING_TYPE) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmFreeContiguousMemorySpecifyCache(baseaddress : *const core::ffi::c_void, numberofbytes : usize, cachetype : MEMORY_CACHING_TYPE));
    unsafe { MmFreeContiguousMemorySpecifyCache(baseaddress, numberofbytes, cachetype) }
}
#[inline]
pub unsafe fn MmFreeMappingAddress(baseaddress: *const core::ffi::c_void, pooltag: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmFreeMappingAddress(baseaddress : *const core::ffi::c_void, pooltag : u32));
    unsafe { MmFreeMappingAddress(baseaddress, pooltag) }
}
#[inline]
pub unsafe fn MmFreeNonCachedMemory(baseaddress: *const core::ffi::c_void, numberofbytes: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmFreeNonCachedMemory(baseaddress : *const core::ffi::c_void, numberofbytes : usize));
    unsafe { MmFreeNonCachedMemory(baseaddress, numberofbytes) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmFreePagesFromMdl(memorydescriptorlist: *mut super::super::Foundation::MDL) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmFreePagesFromMdl(memorydescriptorlist : *mut super::super::Foundation:: MDL));
    unsafe { MmFreePagesFromMdl(memorydescriptorlist as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmFreePagesFromMdlEx(memorydescriptorlist: *mut super::super::Foundation::MDL, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmFreePagesFromMdlEx(memorydescriptorlist : *mut super::super::Foundation:: MDL, flags : u32));
    unsafe { MmFreePagesFromMdlEx(memorydescriptorlist as _, flags) }
}
#[inline]
pub unsafe fn MmGetCacheAttribute(physicaladdress: i64, cachetype: *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetCacheAttribute(physicaladdress : i64, cachetype : *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmGetCacheAttribute(physicaladdress, cachetype as _) }
}
#[inline]
pub unsafe fn MmGetCacheAttributeEx(physicaladdress: i64, flags: u32, cachetype: *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetCacheAttributeEx(physicaladdress : i64, flags : u32, cachetype : *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmGetCacheAttributeEx(physicaladdress, flags, cachetype as _) }
}
#[inline]
pub unsafe fn MmGetPhysicalAddress(baseaddress: *const core::ffi::c_void) -> i64 {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetPhysicalAddress(baseaddress : *const core::ffi::c_void) -> i64);
    unsafe { MmGetPhysicalAddress(baseaddress) }
}
#[inline]
pub unsafe fn MmGetPhysicalMemoryRanges() -> *mut PHYSICAL_MEMORY_RANGE {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetPhysicalMemoryRanges() -> *mut PHYSICAL_MEMORY_RANGE);
    unsafe { MmGetPhysicalMemoryRanges() }
}
#[inline]
pub unsafe fn MmGetPhysicalMemoryRangesEx(partitionobject: Option<*const core::ffi::c_void>) -> *mut PHYSICAL_MEMORY_RANGE {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetPhysicalMemoryRangesEx(partitionobject : *const core::ffi::c_void) -> *mut PHYSICAL_MEMORY_RANGE);
    unsafe { MmGetPhysicalMemoryRangesEx(partitionobject.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn MmGetPhysicalMemoryRangesEx2(partitionobject: Option<*const core::ffi::c_void>, flags: u32) -> *mut PHYSICAL_MEMORY_RANGE {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetPhysicalMemoryRangesEx2(partitionobject : *const core::ffi::c_void, flags : u32) -> *mut PHYSICAL_MEMORY_RANGE);
    unsafe { MmGetPhysicalMemoryRangesEx2(partitionobject.unwrap_or(core::mem::zeroed()) as _, flags) }
}
#[inline]
pub unsafe fn MmGetSystemRoutineAddress(systemroutinename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetSystemRoutineAddress(systemroutinename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> *mut core::ffi::c_void);
    unsafe { MmGetSystemRoutineAddress(systemroutinename) }
}
#[inline]
pub unsafe fn MmGetVirtualForPhysical(physicaladdress: i64) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmGetVirtualForPhysical(physicaladdress : i64) -> *mut core::ffi::c_void);
    unsafe { MmGetVirtualForPhysical(physicaladdress) }
}
#[inline]
pub unsafe fn MmIsAddressValid(virtualaddress: *const core::ffi::c_void) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsAddressValid(virtualaddress : *const core::ffi::c_void) -> bool);
    unsafe { MmIsAddressValid(virtualaddress) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn MmIsDriverSuspectForVerifier(driverobject: *const super::super::Foundation::DRIVER_OBJECT) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsDriverSuspectForVerifier(driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> u32);
    unsafe { MmIsDriverSuspectForVerifier(driverobject) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn MmIsDriverVerifying(driverobject: *const super::super::Foundation::DRIVER_OBJECT) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsDriverVerifying(driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> u32);
    unsafe { MmIsDriverVerifying(driverobject) }
}
#[inline]
pub unsafe fn MmIsDriverVerifyingByAddress(addresswithinsection: *const core::ffi::c_void) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsDriverVerifyingByAddress(addresswithinsection : *const core::ffi::c_void) -> u32);
    unsafe { MmIsDriverVerifyingByAddress(addresswithinsection) }
}
#[inline]
pub unsafe fn MmIsIoSpaceActive(startaddress: i64, numberofbytes: usize) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsIoSpaceActive(startaddress : i64, numberofbytes : usize) -> u32);
    unsafe { MmIsIoSpaceActive(startaddress, numberofbytes) }
}
#[inline]
pub unsafe fn MmIsNonPagedSystemAddressValid(virtualaddress: *const core::ffi::c_void) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsNonPagedSystemAddressValid(virtualaddress : *const core::ffi::c_void) -> bool);
    unsafe { MmIsNonPagedSystemAddressValid(virtualaddress) }
}
#[inline]
pub unsafe fn MmIsThisAnNtAsSystem() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsThisAnNtAsSystem() -> bool);
    unsafe { MmIsThisAnNtAsSystem() }
}
#[inline]
pub unsafe fn MmIsVerifierEnabled(verifierflags: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmIsVerifierEnabled(verifierflags : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmIsVerifierEnabled(verifierflags as _) }
}
#[inline]
pub unsafe fn MmLockPagableDataSection(addresswithinsection: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmLockPagableDataSection(addresswithinsection : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { MmLockPagableDataSection(addresswithinsection) }
}
#[inline]
pub unsafe fn MmLockPagableSectionByHandle(imagesectionhandle: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmLockPagableSectionByHandle(imagesectionhandle : *const core::ffi::c_void));
    unsafe { MmLockPagableSectionByHandle(imagesectionhandle) }
}
#[inline]
pub unsafe fn MmMapIoSpace(physicaladdress: i64, numberofbytes: usize, cachetype: MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapIoSpace(physicaladdress : i64, numberofbytes : usize, cachetype : MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void);
    unsafe { MmMapIoSpace(physicaladdress, numberofbytes, cachetype) }
}
#[inline]
pub unsafe fn MmMapIoSpaceEx(physicaladdress: i64, numberofbytes: usize, protect: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapIoSpaceEx(physicaladdress : i64, numberofbytes : usize, protect : u32) -> *mut core::ffi::c_void);
    unsafe { MmMapIoSpaceEx(physicaladdress, numberofbytes, protect) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapLockedPages(memorydescriptorlist: *mut super::super::Foundation::MDL, accessmode: i8) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapLockedPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, accessmode : i8) -> *mut core::ffi::c_void);
    unsafe { MmMapLockedPages(memorydescriptorlist as _, accessmode) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapLockedPagesSpecifyCache(memorydescriptorlist: *mut super::super::Foundation::MDL, accessmode: i8, cachetype: MEMORY_CACHING_TYPE, requestedaddress: Option<*const core::ffi::c_void>, bugcheckonfailure: u32, priority: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapLockedPagesSpecifyCache(memorydescriptorlist : *mut super::super::Foundation:: MDL, accessmode : i8, cachetype : MEMORY_CACHING_TYPE, requestedaddress : *const core::ffi::c_void, bugcheckonfailure : u32, priority : u32) -> *mut core::ffi::c_void);
    unsafe { MmMapLockedPagesSpecifyCache(memorydescriptorlist as _, accessmode, cachetype, requestedaddress.unwrap_or(core::mem::zeroed()) as _, bugcheckonfailure, priority) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapLockedPagesWithReservedMapping(mappingaddress: *const core::ffi::c_void, pooltag: u32, memorydescriptorlist: *mut super::super::Foundation::MDL, cachetype: MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapLockedPagesWithReservedMapping(mappingaddress : *const core::ffi::c_void, pooltag : u32, memorydescriptorlist : *mut super::super::Foundation:: MDL, cachetype : MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void);
    unsafe { MmMapLockedPagesWithReservedMapping(mappingaddress, pooltag, memorydescriptorlist as _, cachetype) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapMdl(memorydescriptorlist: *mut super::super::Foundation::MDL, protection: u32, driverroutine: PMM_MDL_ROUTINE, drivercontext: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapMdl(memorydescriptorlist : *mut super::super::Foundation:: MDL, protection : u32, driverroutine : PMM_MDL_ROUTINE, drivercontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmMapMdl(memorydescriptorlist as _, protection, driverroutine, drivercontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapMemoryDumpMdlEx(va: *const core::ffi::c_void, pagetotal: u32, memorydumpmdl: *mut super::super::Foundation::MDL, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapMemoryDumpMdlEx(va : *const core::ffi::c_void, pagetotal : u32, memorydumpmdl : *mut super::super::Foundation:: MDL, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmMapMemoryDumpMdlEx(va, pagetotal, memorydumpmdl as _, flags) }
}
#[inline]
pub unsafe fn MmMapUserAddressesToPage(baseaddress: *const core::ffi::c_void, numberofbytes: usize, pageaddress: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapUserAddressesToPage(baseaddress : *const core::ffi::c_void, numberofbytes : usize, pageaddress : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmMapUserAddressesToPage(baseaddress, numberofbytes, pageaddress) }
}
#[inline]
pub unsafe fn MmMapVideoDisplay(physicaladdress: i64, numberofbytes: usize, cachetype: MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapVideoDisplay(physicaladdress : i64, numberofbytes : usize, cachetype : MEMORY_CACHING_TYPE) -> *mut core::ffi::c_void);
    unsafe { MmMapVideoDisplay(physicaladdress, numberofbytes, cachetype) }
}
#[inline]
pub unsafe fn MmMapViewInSessionSpace(section: *const core::ffi::c_void, mappedbase: *mut *mut core::ffi::c_void, viewsize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapViewInSessionSpace(section : *const core::ffi::c_void, mappedbase : *mut *mut core::ffi::c_void, viewsize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmMapViewInSessionSpace(section, mappedbase as _, viewsize as _) }
}
#[inline]
pub unsafe fn MmMapViewInSessionSpaceEx(section: *const core::ffi::c_void, mappedbase: *mut *mut core::ffi::c_void, viewsize: *mut usize, sectionoffset: *mut i64, flags: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapViewInSessionSpaceEx(section : *const core::ffi::c_void, mappedbase : *mut *mut core::ffi::c_void, viewsize : *mut usize, sectionoffset : *mut i64, flags : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmMapViewInSessionSpaceEx(section, mappedbase as _, viewsize as _, sectionoffset as _, flags) }
}
#[inline]
pub unsafe fn MmMapViewInSystemSpace(section: *const core::ffi::c_void, mappedbase: *mut *mut core::ffi::c_void, viewsize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapViewInSystemSpace(section : *const core::ffi::c_void, mappedbase : *mut *mut core::ffi::c_void, viewsize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmMapViewInSystemSpace(section, mappedbase as _, viewsize as _) }
}
#[inline]
pub unsafe fn MmMapViewInSystemSpaceEx(section: *const core::ffi::c_void, mappedbase: *mut *mut core::ffi::c_void, viewsize: *mut usize, sectionoffset: *mut i64, flags: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMapViewInSystemSpaceEx(section : *const core::ffi::c_void, mappedbase : *mut *mut core::ffi::c_void, viewsize : *mut usize, sectionoffset : *mut i64, flags : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmMapViewInSystemSpaceEx(section, mappedbase as _, viewsize as _, sectionoffset as _, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMdlPageContentsState(memorydescriptorlist: *mut super::super::Foundation::MDL, state: MM_MDL_PAGE_CONTENTS_STATE) -> MM_MDL_PAGE_CONTENTS_STATE {
    windows_link::link!("ntoskrnl.exe" "system" fn MmMdlPageContentsState(memorydescriptorlist : *mut super::super::Foundation:: MDL, state : MM_MDL_PAGE_CONTENTS_STATE) -> MM_MDL_PAGE_CONTENTS_STATE);
    unsafe { MmMdlPageContentsState(memorydescriptorlist as _, state) }
}
#[inline]
pub unsafe fn MmPageEntireDriver(addresswithinsection: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn MmPageEntireDriver(addresswithinsection : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { MmPageEntireDriver(addresswithinsection) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmProbeAndLockPages(memorydescriptorlist: *mut super::super::Foundation::MDL, accessmode: i8, operation: LOCK_OPERATION) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmProbeAndLockPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, accessmode : i8, operation : LOCK_OPERATION));
    unsafe { MmProbeAndLockPages(memorydescriptorlist as _, accessmode, operation) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmProbeAndLockProcessPages(memorydescriptorlist: *mut super::super::Foundation::MDL, process: super::super::Foundation::PEPROCESS, accessmode: i8, operation: LOCK_OPERATION) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmProbeAndLockProcessPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, process : super::super::Foundation:: PEPROCESS, accessmode : i8, operation : LOCK_OPERATION));
    unsafe { MmProbeAndLockProcessPages(memorydescriptorlist as _, process, accessmode, operation) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Storage_FileSystem"))]
#[inline]
pub unsafe fn MmProbeAndLockSelectedPages(memorydescriptorlist: *mut super::super::Foundation::MDL, segmentarray: *const super::super::super::Win32::Storage::FileSystem::FILE_SEGMENT_ELEMENT, accessmode: i8, operation: LOCK_OPERATION) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmProbeAndLockSelectedPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, segmentarray : *const super::super::super::Win32::Storage::FileSystem:: FILE_SEGMENT_ELEMENT, accessmode : i8, operation : LOCK_OPERATION));
    unsafe { MmProbeAndLockSelectedPages(memorydescriptorlist as _, segmentarray, accessmode, operation) }
}
#[inline]
pub unsafe fn MmProtectDriverSection(addresswithinsection: *const core::ffi::c_void, size: usize, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmProtectDriverSection(addresswithinsection : *const core::ffi::c_void, size : usize, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmProtectDriverSection(addresswithinsection, size, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmProtectMdlSystemAddress(memorydescriptorlist: *const super::super::Foundation::MDL, newprotect: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmProtectMdlSystemAddress(memorydescriptorlist : *const super::super::Foundation:: MDL, newprotect : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmProtectMdlSystemAddress(memorydescriptorlist, newprotect) }
}
#[inline]
pub unsafe fn MmQuerySystemSize() -> MM_SYSTEMSIZE {
    windows_link::link!("ntoskrnl.exe" "system" fn MmQuerySystemSize() -> MM_SYSTEMSIZE);
    unsafe { MmQuerySystemSize() }
}
#[inline]
pub unsafe fn MmRemovePhysicalMemory(startaddress: *const i64, numberofbytes: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmRemovePhysicalMemory(startaddress : *const i64, numberofbytes : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmRemovePhysicalMemory(startaddress, numberofbytes as _) }
}
#[inline]
pub unsafe fn MmResetDriverPaging(addresswithinsection: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmResetDriverPaging(addresswithinsection : *const core::ffi::c_void));
    unsafe { MmResetDriverPaging(addresswithinsection) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmRotatePhysicalView(virtualaddress: *const core::ffi::c_void, numberofbytes: *mut usize, newmdl: Option<*const super::super::Foundation::MDL>, direction: MM_ROTATE_DIRECTION, copyfunction: PMM_ROTATE_COPY_CALLBACK_FUNCTION, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmRotatePhysicalView(virtualaddress : *const core::ffi::c_void, numberofbytes : *mut usize, newmdl : *const super::super::Foundation:: MDL, direction : MM_ROTATE_DIRECTION, copyfunction : PMM_ROTATE_COPY_CALLBACK_FUNCTION, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmRotatePhysicalView(virtualaddress, numberofbytes as _, newmdl.unwrap_or(core::mem::zeroed()) as _, direction, copyfunction, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn MmSecureVirtualMemory(address: *const core::ffi::c_void, size: usize, probemode: u32) -> super::super::super::Win32::Foundation::HANDLE {
    windows_link::link!("ntoskrnl.exe" "system" fn MmSecureVirtualMemory(address : *const core::ffi::c_void, size : usize, probemode : u32) -> super::super::super::Win32::Foundation:: HANDLE);
    unsafe { MmSecureVirtualMemory(address, size, probemode) }
}
#[inline]
pub unsafe fn MmSecureVirtualMemoryEx(address: *const core::ffi::c_void, size: usize, probemode: u32, flags: u32) -> super::super::super::Win32::Foundation::HANDLE {
    windows_link::link!("ntoskrnl.exe" "system" fn MmSecureVirtualMemoryEx(address : *const core::ffi::c_void, size : usize, probemode : u32, flags : u32) -> super::super::super::Win32::Foundation:: HANDLE);
    unsafe { MmSecureVirtualMemoryEx(address, size, probemode, flags) }
}
#[inline]
pub unsafe fn MmSetPermanentCacheAttribute(startaddress: i64, numberofbytes: i64, cachetype: MEMORY_CACHING_TYPE, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmSetPermanentCacheAttribute(startaddress : i64, numberofbytes : i64, cachetype : MEMORY_CACHING_TYPE, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmSetPermanentCacheAttribute(startaddress, numberofbytes, cachetype, flags) }
}
#[inline]
pub unsafe fn MmSizeOfMdl(base: Option<*const core::ffi::c_void>, length: usize) -> usize {
    windows_link::link!("ntoskrnl.exe" "system" fn MmSizeOfMdl(base : *const core::ffi::c_void, length : usize) -> usize);
    unsafe { MmSizeOfMdl(base.unwrap_or(core::mem::zeroed()) as _, length) }
}
#[inline]
pub unsafe fn MmUnlockPagableImageSection(imagesectionhandle: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnlockPagableImageSection(imagesectionhandle : *const core::ffi::c_void));
    unsafe { MmUnlockPagableImageSection(imagesectionhandle) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmUnlockPages(memorydescriptorlist: *mut super::super::Foundation::MDL) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnlockPages(memorydescriptorlist : *mut super::super::Foundation:: MDL));
    unsafe { MmUnlockPages(memorydescriptorlist as _) }
}
#[inline]
pub unsafe fn MmUnmapIoSpace(baseaddress: *const core::ffi::c_void, numberofbytes: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnmapIoSpace(baseaddress : *const core::ffi::c_void, numberofbytes : usize));
    unsafe { MmUnmapIoSpace(baseaddress, numberofbytes) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmUnmapLockedPages(baseaddress: *const core::ffi::c_void, memorydescriptorlist: *mut super::super::Foundation::MDL) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnmapLockedPages(baseaddress : *const core::ffi::c_void, memorydescriptorlist : *mut super::super::Foundation:: MDL));
    unsafe { MmUnmapLockedPages(baseaddress, memorydescriptorlist as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmUnmapReservedMapping(baseaddress: *const core::ffi::c_void, pooltag: u32, memorydescriptorlist: *mut super::super::Foundation::MDL) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnmapReservedMapping(baseaddress : *const core::ffi::c_void, pooltag : u32, memorydescriptorlist : *mut super::super::Foundation:: MDL));
    unsafe { MmUnmapReservedMapping(baseaddress, pooltag, memorydescriptorlist as _) }
}
#[inline]
pub unsafe fn MmUnmapVideoDisplay(baseaddress: *const core::ffi::c_void, numberofbytes: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnmapVideoDisplay(baseaddress : *const core::ffi::c_void, numberofbytes : usize));
    unsafe { MmUnmapVideoDisplay(baseaddress, numberofbytes) }
}
#[inline]
pub unsafe fn MmUnmapViewInSessionSpace(mappedbase: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnmapViewInSessionSpace(mappedbase : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmUnmapViewInSessionSpace(mappedbase) }
}
#[inline]
pub unsafe fn MmUnmapViewInSystemSpace(mappedbase: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnmapViewInSystemSpace(mappedbase : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { MmUnmapViewInSystemSpace(mappedbase) }
}
#[inline]
pub unsafe fn MmUnsecureVirtualMemory(securehandle: super::super::super::Win32::Foundation::HANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn MmUnsecureVirtualMemory(securehandle : super::super::super::Win32::Foundation:: HANDLE));
    unsafe { MmUnsecureVirtualMemory(securehandle) }
}
#[inline]
pub unsafe fn NtAllocateLocallyUniqueId(luid: *mut super::super::super::Win32::Foundation::LUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtAllocateLocallyUniqueId(luid : *mut super::super::super::Win32::Foundation:: LUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtAllocateLocallyUniqueId(luid as _) }
}
#[inline]
pub unsafe fn NtCommitComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtCommitComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtCommitComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtCommitEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtCommitEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtCommitEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtCommitTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, wait: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtCommitTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtCommitTransaction(transactionhandle, wait) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtCreateEnlistment(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, transactionhandle: super::super::super::Win32::Foundation::HANDLE, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: Option<u32>, notificationmask: u32, enlistmentkey: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtCreateEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionhandle : super::super::super::Win32::Foundation:: HANDLE, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, notificationmask : u32, enlistmentkey : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtCreateEnlistment(enlistmenthandle as _, desiredaccess, resourcemanagerhandle, transactionhandle, objectattributes.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, notificationmask, enlistmentkey.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtCreateResourceManager(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: super::super::super::Win32::Foundation::HANDLE, rmguid: *const windows_core::GUID, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: Option<u32>, description: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtCreateResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, rmguid : *const windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtCreateResourceManager(resourcemanagerhandle as _, desiredaccess, tmhandle, rmguid, objectattributes.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, description.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtCreateTransaction(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, uow: Option<*const windows_core::GUID>, tmhandle: Option<super::super::super::Win32::Foundation::HANDLE>, createoptions: Option<u32>, isolationlevel: Option<u32>, isolationflags: Option<u32>, timeout: Option<*const i64>, description: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtCreateTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE, createoptions : u32, isolationlevel : u32, isolationflags : u32, timeout : *const i64, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtCreateTransaction(transactionhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, uow.unwrap_or(core::mem::zeroed()) as _, tmhandle.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, isolationlevel.unwrap_or(core::mem::zeroed()) as _, isolationflags.unwrap_or(core::mem::zeroed()) as _, timeout.unwrap_or(core::mem::zeroed()) as _, description.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtCreateTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, createoptions: Option<u32>, commitstrength: Option<u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtCreateTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, createoptions : u32, commitstrength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtCreateTransactionManager(tmhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, logfilename.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, commitstrength.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtDisplayString(string: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtDisplayString(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtDisplayString(string) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtEnumerateTransactionObject(rootobjecthandle: Option<super::super::super::Win32::Foundation::HANDLE>, querytype: super::super::super::Win32::System::SystemServices::KTMOBJECT_TYPE, objectcursor: *mut super::super::super::Win32::System::SystemServices::KTMOBJECT_CURSOR, objectcursorlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtEnumerateTransactionObject(rootobjecthandle : super::super::super::Win32::Foundation:: HANDLE, querytype : super::super::super::Win32::System::SystemServices:: KTMOBJECT_TYPE, objectcursor : *mut super::super::super::Win32::System::SystemServices:: KTMOBJECT_CURSOR, objectcursorlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtEnumerateTransactionObject(rootobjecthandle.unwrap_or(core::mem::zeroed()) as _, querytype, objectcursor as _, objectcursorlength, returnlength as _) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn NtGetNotificationResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, transactionnotification: *mut super::super::super::Win32::Storage::FileSystem::TRANSACTION_NOTIFICATION, notificationlength: u32, timeout: Option<*const i64>, returnlength: Option<*mut u32>, asynchronous: u32, asynchronouscontext: Option<usize>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtGetNotificationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionnotification : *mut super::super::super::Win32::Storage::FileSystem:: TRANSACTION_NOTIFICATION, notificationlength : u32, timeout : *const i64, returnlength : *mut u32, asynchronous : u32, asynchronouscontext : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtGetNotificationResourceManager(resourcemanagerhandle, transactionnotification as _, notificationlength, timeout.unwrap_or(core::mem::zeroed()) as _, returnlength.unwrap_or(core::mem::zeroed()) as _, asynchronous, asynchronouscontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtLoadDriver(driverservicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtLoadDriver(driverservicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtLoadDriver(driverservicename) }
}
#[inline]
pub unsafe fn NtMakeTemporaryObject(handle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtMakeTemporaryObject(handle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtMakeTemporaryObject(handle) }
}
#[inline]
pub unsafe fn NtManagePartition(targethandle: super::super::super::Win32::Foundation::HANDLE, sourcehandle: Option<super::super::super::Win32::Foundation::HANDLE>, partitioninformationclass: PARTITION_INFORMATION_CLASS, partitioninformation: *mut core::ffi::c_void, partitioninformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtManagePartition(targethandle : super::super::super::Win32::Foundation:: HANDLE, sourcehandle : super::super::super::Win32::Foundation:: HANDLE, partitioninformationclass : PARTITION_INFORMATION_CLASS, partitioninformation : *mut core::ffi::c_void, partitioninformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtManagePartition(targethandle, sourcehandle.unwrap_or(core::mem::zeroed()) as _, partitioninformationclass, partitioninformation as _, partitioninformationlength) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtOpenEnlistment(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, enlistmentguid: *const windows_core::GUID, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtOpenEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentguid : *const windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtOpenEnlistment(enlistmenthandle as _, desiredaccess, resourcemanagerhandle, enlistmentguid, objectattributes.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtOpenResourceManager(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: super::super::super::Win32::Foundation::HANDLE, resourcemanagerguid: Option<*const windows_core::GUID>, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtOpenResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerguid : *const windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtOpenResourceManager(resourcemanagerhandle as _, desiredaccess, tmhandle, resourcemanagerguid.unwrap_or(core::mem::zeroed()) as _, objectattributes.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtOpenTransaction(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, uow: *const windows_core::GUID, tmhandle: Option<super::super::super::Win32::Foundation::HANDLE>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtOpenTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtOpenTransaction(transactionhandle as _, desiredaccess, objectattributes, uow, tmhandle.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn NtOpenTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, tmidentity: Option<*const windows_core::GUID>, openoptions: Option<u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtOpenTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, tmidentity : *const windows_core::GUID, openoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtOpenTransactionManager(tmhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, logfilename.unwrap_or(core::mem::zeroed()) as _, tmidentity.unwrap_or(core::mem::zeroed()) as _, openoptions.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn NtPowerInformation(informationlevel: super::super::super::Win32::System::Power::POWER_INFORMATION_LEVEL, inputbuffer: Option<*const core::ffi::c_void>, inputbufferlength: u32, outputbuffer: Option<*mut core::ffi::c_void>, outputbufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtPowerInformation(informationlevel : super::super::super::Win32::System::Power:: POWER_INFORMATION_LEVEL, inputbuffer : *const core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut core::ffi::c_void, outputbufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtPowerInformation(informationlevel, inputbuffer.unwrap_or(core::mem::zeroed()) as _, inputbufferlength, outputbuffer.unwrap_or(core::mem::zeroed()) as _, outputbufferlength) }
}
#[inline]
pub unsafe fn NtPrePrepareComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtPrePrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtPrePrepareComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtPrePrepareEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtPrePrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtPrePrepareEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtPrepareComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtPrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtPrepareComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtPrepareEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtPrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtPrepareEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtPropagationComplete(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, requestcookie: u32, bufferlength: u32, buffer: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtPropagationComplete(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, requestcookie : u32, bufferlength : u32, buffer : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtPropagationComplete(resourcemanagerhandle, requestcookie, bufferlength, buffer) }
}
#[inline]
pub unsafe fn NtPropagationFailed(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, requestcookie: u32, propstatus: super::super::super::Win32::Foundation::NTSTATUS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtPropagationFailed(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, requestcookie : u32, propstatus : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtPropagationFailed(resourcemanagerhandle, requestcookie, propstatus) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *mut core::ffi::c_void, enlistmentinformationlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtQueryInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *mut core::ffi::c_void, enlistmentinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtQueryInformationEnlistment(enlistmenthandle, enlistmentinformationclass, enlistmentinformation as _, enlistmentinformationlength, returnlength as _) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *mut core::ffi::c_void, resourcemanagerinformationlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtQueryInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *mut core::ffi::c_void, resourcemanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtQueryInformationResourceManager(resourcemanagerhandle, resourcemanagerinformationclass, resourcemanagerinformation as _, resourcemanagerinformationlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *mut core::ffi::c_void, transactioninformationlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtQueryInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *mut core::ffi::c_void, transactioninformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtQueryInformationTransaction(transactionhandle, transactioninformationclass, transactioninformation as _, transactioninformationlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationTransactionManager(transactionmanagerhandle: super::super::super::Win32::Foundation::HANDLE, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *mut core::ffi::c_void, transactionmanagerinformationlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtQueryInformationTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *mut core::ffi::c_void, transactionmanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtQueryInformationTransactionManager(transactionmanagerhandle, transactionmanagerinformationclass, transactionmanagerinformation as _, transactionmanagerinformationlength, returnlength as _) }
}
#[inline]
pub unsafe fn NtReadOnlyEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtReadOnlyEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtReadOnlyEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtRecoverEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, enlistmentkey: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRecoverEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentkey : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRecoverEnlistment(enlistmenthandle, enlistmentkey.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtRecoverResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRecoverResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRecoverResourceManager(resourcemanagerhandle) }
}
#[inline]
pub unsafe fn NtRecoverTransactionManager(transactionmanagerhandle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRecoverTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRecoverTransactionManager(transactionmanagerhandle) }
}
#[inline]
pub unsafe fn NtRegisterProtocolAddressInformation(resourcemanager: super::super::super::Win32::Foundation::HANDLE, protocolid: *const windows_core::GUID, protocolinformationsize: u32, protocolinformation: *const core::ffi::c_void, createoptions: Option<u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRegisterProtocolAddressInformation(resourcemanager : super::super::super::Win32::Foundation:: HANDLE, protocolid : *const windows_core::GUID, protocolinformationsize : u32, protocolinformation : *const core::ffi::c_void, createoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRegisterProtocolAddressInformation(resourcemanager, protocolid, protocolinformationsize, protocolinformation, createoptions.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtRenameTransactionManager(logfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, existingtransactionmanagerguid: *const windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRenameTransactionManager(logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, existingtransactionmanagerguid : *const windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRenameTransactionManager(logfilename, existingtransactionmanagerguid) }
}
#[inline]
pub unsafe fn NtRollbackComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRollbackComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRollbackComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtRollbackEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRollbackEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRollbackEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtRollbackTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, wait: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRollbackTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRollbackTransaction(transactionhandle, wait) }
}
#[inline]
pub unsafe fn NtRollforwardTransactionManager(transactionmanagerhandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtRollforwardTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtRollforwardTransactionManager(transactionmanagerhandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationEnlistment(enlistmenthandle: Option<super::super::super::Win32::Foundation::HANDLE>, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *const core::ffi::c_void, enlistmentinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtSetInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *const core::ffi::c_void, enlistmentinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtSetInformationEnlistment(enlistmenthandle.unwrap_or(core::mem::zeroed()) as _, enlistmentinformationclass, enlistmentinformation, enlistmentinformationlength) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *const core::ffi::c_void, resourcemanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtSetInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *const core::ffi::c_void, resourcemanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtSetInformationResourceManager(resourcemanagerhandle, resourcemanagerinformationclass, resourcemanagerinformation, resourcemanagerinformationlength) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *const core::ffi::c_void, transactioninformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtSetInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *const core::ffi::c_void, transactioninformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtSetInformationTransaction(transactionhandle, transactioninformationclass, transactioninformation, transactioninformationlength) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationTransactionManager(tmhandle: Option<super::super::super::Win32::Foundation::HANDLE>, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *const core::ffi::c_void, transactionmanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtSetInformationTransactionManager(tmhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *const core::ffi::c_void, transactionmanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtSetInformationTransactionManager(tmhandle.unwrap_or(core::mem::zeroed()) as _, transactionmanagerinformationclass, transactionmanagerinformation, transactionmanagerinformationlength) }
}
#[inline]
pub unsafe fn NtSinglePhaseReject(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtSinglePhaseReject(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtSinglePhaseReject(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn NtUnloadDriver(driverservicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn NtUnloadDriver(driverservicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { NtUnloadDriver(driverservicename) }
}
#[inline]
pub unsafe fn ObCloseHandle(handle: super::super::super::Win32::Foundation::HANDLE, previousmode: i8) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ObCloseHandle(handle : super::super::super::Win32::Foundation:: HANDLE, previousmode : i8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ObCloseHandle(handle, previousmode) }
}
#[inline]
pub unsafe fn ObDereferenceObjectDeferDelete(object: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn ObDereferenceObjectDeferDelete(object : *const core::ffi::c_void));
    unsafe { ObDereferenceObjectDeferDelete(object) }
}
#[inline]
pub unsafe fn ObDereferenceObjectDeferDeleteWithTag(object: *const core::ffi::c_void, tag: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ObDereferenceObjectDeferDeleteWithTag(object : *const core::ffi::c_void, tag : u32));
    unsafe { ObDereferenceObjectDeferDeleteWithTag(object, tag) }
}
#[inline]
pub unsafe fn ObGetFilterVersion() -> u16 {
    windows_link::link!("ntoskrnl.exe" "system" fn ObGetFilterVersion() -> u16);
    unsafe { ObGetFilterVersion() }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn ObGetObjectSecurity(object: *const core::ffi::c_void, securitydescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, memoryallocated: *mut bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ObGetObjectSecurity(object : *const core::ffi::c_void, securitydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, memoryallocated : *mut bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ObGetObjectSecurity(object, securitydescriptor as _, memoryallocated as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByHandle(handle: super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objecttype: Option<super::super::Foundation::POBJECT_TYPE>, accessmode: i8, object: *mut *mut core::ffi::c_void, handleinformation: Option<*mut OBJECT_HANDLE_INFORMATION>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByHandle(handle : super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8, object : *mut *mut core::ffi::c_void, handleinformation : *mut OBJECT_HANDLE_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ObReferenceObjectByHandle(handle, desiredaccess, objecttype.unwrap_or(core::mem::zeroed()) as _, accessmode, object as _, handleinformation.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByHandleWithTag(handle: super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objecttype: Option<super::super::Foundation::POBJECT_TYPE>, accessmode: i8, tag: u32, object: *mut *mut core::ffi::c_void, handleinformation: Option<*mut OBJECT_HANDLE_INFORMATION>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByHandleWithTag(handle : super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8, tag : u32, object : *mut *mut core::ffi::c_void, handleinformation : *mut OBJECT_HANDLE_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ObReferenceObjectByHandleWithTag(handle, desiredaccess, objecttype.unwrap_or(core::mem::zeroed()) as _, accessmode, tag, object as _, handleinformation.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByPointer(object: *const core::ffi::c_void, desiredaccess: u32, objecttype: Option<super::super::Foundation::POBJECT_TYPE>, accessmode: i8) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByPointer(object : *const core::ffi::c_void, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ObReferenceObjectByPointer(object, desiredaccess, objecttype.unwrap_or(core::mem::zeroed()) as _, accessmode) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByPointerWithTag(object: *const core::ffi::c_void, desiredaccess: u32, objecttype: Option<super::super::Foundation::POBJECT_TYPE>, accessmode: i8, tag: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByPointerWithTag(object : *const core::ffi::c_void, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8, tag : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ObReferenceObjectByPointerWithTag(object, desiredaccess, objecttype.unwrap_or(core::mem::zeroed()) as _, accessmode, tag) }
}
#[inline]
pub unsafe fn ObReferenceObjectSafe(object: *const core::ffi::c_void) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ObReferenceObjectSafe(object : *const core::ffi::c_void) -> bool);
    unsafe { ObReferenceObjectSafe(object) }
}
#[inline]
pub unsafe fn ObReferenceObjectSafeWithTag(object: *const core::ffi::c_void, tag: u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn ObReferenceObjectSafeWithTag(object : *const core::ffi::c_void, tag : u32) -> bool);
    unsafe { ObReferenceObjectSafeWithTag(object, tag) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObRegisterCallbacks(callbackregistration: *const OB_CALLBACK_REGISTRATION, registrationhandle: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn ObRegisterCallbacks(callbackregistration : *const OB_CALLBACK_REGISTRATION, registrationhandle : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ObRegisterCallbacks(callbackregistration, registrationhandle as _) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn ObReleaseObjectSecurity(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, memoryallocated: bool) {
    windows_link::link!("ntoskrnl.exe" "system" fn ObReleaseObjectSecurity(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, memoryallocated : bool));
    unsafe { ObReleaseObjectSecurity(securitydescriptor, memoryallocated) }
}
#[inline]
pub unsafe fn ObUnRegisterCallbacks(registrationhandle: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn ObUnRegisterCallbacks(registrationhandle : *const core::ffi::c_void));
    unsafe { ObUnRegisterCallbacks(registrationhandle) }
}
#[inline]
pub unsafe fn ObfDereferenceObject(object: *const core::ffi::c_void) -> isize {
    windows_link::link!("ntoskrnl.exe" "system" fn ObfDereferenceObject(object : *const core::ffi::c_void) -> isize);
    unsafe { ObfDereferenceObject(object) }
}
#[inline]
pub unsafe fn ObfDereferenceObjectWithTag(object: *const core::ffi::c_void, tag: u32) -> isize {
    windows_link::link!("ntoskrnl.exe" "system" fn ObfDereferenceObjectWithTag(object : *const core::ffi::c_void, tag : u32) -> isize);
    unsafe { ObfDereferenceObjectWithTag(object, tag) }
}
#[inline]
pub unsafe fn ObfReferenceObject(object: *const core::ffi::c_void) -> isize {
    windows_link::link!("ntoskrnl.exe" "system" fn ObfReferenceObject(object : *const core::ffi::c_void) -> isize);
    unsafe { ObfReferenceObject(object) }
}
#[inline]
pub unsafe fn ObfReferenceObjectWithTag(object: *const core::ffi::c_void, tag: u32) -> isize {
    windows_link::link!("ntoskrnl.exe" "system" fn ObfReferenceObjectWithTag(object : *const core::ffi::c_void, tag : u32) -> isize);
    unsafe { ObfReferenceObjectWithTag(object, tag) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwAddInstance(buffer: super::super::Foundation::PPCW_BUFFER, name: *const super::super::super::Win32::Foundation::UNICODE_STRING, id: u32, data: &[PCW_DATA]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PcwAddInstance(buffer : super::super::Foundation:: PPCW_BUFFER, name : *const super::super::super::Win32::Foundation:: UNICODE_STRING, id : u32, count : u32, data : *const PCW_DATA) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PcwAddInstance(buffer, name, id, data.len().try_into().unwrap(), core::mem::transmute(data.as_ptr())) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwCloseInstance(instance: super::super::Foundation::PPCW_INSTANCE) {
    windows_link::link!("ntoskrnl.exe" "system" fn PcwCloseInstance(instance : super::super::Foundation:: PPCW_INSTANCE));
    unsafe { PcwCloseInstance(instance) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwCreateInstance(instance: *mut super::super::Foundation::PPCW_INSTANCE, registration: super::super::Foundation::PPCW_REGISTRATION, name: *const super::super::super::Win32::Foundation::UNICODE_STRING, data: &[PCW_DATA]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PcwCreateInstance(instance : *mut super::super::Foundation:: PPCW_INSTANCE, registration : super::super::Foundation:: PPCW_REGISTRATION, name : *const super::super::super::Win32::Foundation:: UNICODE_STRING, count : u32, data : *const PCW_DATA) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PcwCreateInstance(instance as _, registration, name, data.len().try_into().unwrap(), core::mem::transmute(data.as_ptr())) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwRegister(registration: *mut super::super::Foundation::PPCW_REGISTRATION, info: *const PCW_REGISTRATION_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PcwRegister(registration : *mut super::super::Foundation:: PPCW_REGISTRATION, info : *const PCW_REGISTRATION_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PcwRegister(registration as _, info) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwUnregister(registration: super::super::Foundation::PPCW_REGISTRATION) {
    windows_link::link!("ntoskrnl.exe" "system" fn PcwUnregister(registration : super::super::Foundation:: PPCW_REGISTRATION));
    unsafe { PcwUnregister(registration) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoCallDriver(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *mut super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoCallDriver(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoCallDriver(deviceobject, irp as _) }
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn PoClearPowerRequest(powerrequest: *mut core::ffi::c_void, r#type: super::super::super::Win32::System::Power::POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoClearPowerRequest(powerrequest : *mut core::ffi::c_void, r#type : super::super::super::Win32::System::Power:: POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoClearPowerRequest(powerrequest as _, r#type) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoCreatePowerRequest(powerrequest: *mut *mut core::ffi::c_void, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, context: Option<*const COUNTED_REASON_CONTEXT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoCreatePowerRequest(powerrequest : *mut *mut core::ffi::c_void, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, context : *const COUNTED_REASON_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoCreatePowerRequest(powerrequest as _, deviceobject, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoCreateThermalRequest(thermalrequest: *mut *mut core::ffi::c_void, targetdeviceobject: *const super::super::Foundation::DEVICE_OBJECT, policydeviceobject: *const super::super::Foundation::DEVICE_OBJECT, context: *const COUNTED_REASON_CONTEXT, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoCreateThermalRequest(thermalrequest : *mut *mut core::ffi::c_void, targetdeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, policydeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, context : *const COUNTED_REASON_CONTEXT, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoCreateThermalRequest(thermalrequest as _, targetdeviceobject, policydeviceobject, context, flags) }
}
#[inline]
pub unsafe fn PoDeletePowerRequest(powerrequest: *mut core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoDeletePowerRequest(powerrequest : *mut core::ffi::c_void));
    unsafe { PoDeletePowerRequest(powerrequest as _) }
}
#[inline]
pub unsafe fn PoDeleteThermalRequest(thermalrequest: *mut core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoDeleteThermalRequest(thermalrequest : *mut core::ffi::c_void));
    unsafe { PoDeleteThermalRequest(thermalrequest as _) }
}
#[inline]
pub unsafe fn PoEndDeviceBusy(idlepointer: *mut u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoEndDeviceBusy(idlepointer : *mut u32));
    unsafe { PoEndDeviceBusy(idlepointer as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxActivateComponent(handle: super::super::Foundation::POHANDLE, component: u32, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxActivateComponent(handle : super::super::Foundation:: POHANDLE, component : u32, flags : u32));
    unsafe { PoFxActivateComponent(handle, component, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteDevicePowerNotRequired(handle: super::super::Foundation::POHANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxCompleteDevicePowerNotRequired(handle : super::super::Foundation:: POHANDLE));
    unsafe { PoFxCompleteDevicePowerNotRequired(handle) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteDirectedPowerDown(handle: super::super::Foundation::POHANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxCompleteDirectedPowerDown(handle : super::super::Foundation:: POHANDLE));
    unsafe { PoFxCompleteDirectedPowerDown(handle) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteIdleCondition(handle: super::super::Foundation::POHANDLE, component: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxCompleteIdleCondition(handle : super::super::Foundation:: POHANDLE, component : u32));
    unsafe { PoFxCompleteIdleCondition(handle, component) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteIdleState(handle: super::super::Foundation::POHANDLE, component: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxCompleteIdleState(handle : super::super::Foundation:: POHANDLE, component : u32));
    unsafe { PoFxCompleteIdleState(handle, component) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxIdleComponent(handle: super::super::Foundation::POHANDLE, component: u32, flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxIdleComponent(handle : super::super::Foundation:: POHANDLE, component : u32, flags : u32));
    unsafe { PoFxIdleComponent(handle, component, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxIssueComponentPerfStateChange(handle: super::super::Foundation::POHANDLE, flags: u32, component: u32, perfchange: *const PO_FX_PERF_STATE_CHANGE, context: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxIssueComponentPerfStateChange(handle : super::super::Foundation:: POHANDLE, flags : u32, component : u32, perfchange : *const PO_FX_PERF_STATE_CHANGE, context : *const core::ffi::c_void));
    unsafe { PoFxIssueComponentPerfStateChange(handle, flags, component, perfchange, context) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxIssueComponentPerfStateChangeMultiple(handle: super::super::Foundation::POHANDLE, flags: u32, component: u32, perfchangescount: u32, perfchanges: *const PO_FX_PERF_STATE_CHANGE, context: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxIssueComponentPerfStateChangeMultiple(handle : super::super::Foundation:: POHANDLE, flags : u32, component : u32, perfchangescount : u32, perfchanges : *const PO_FX_PERF_STATE_CHANGE, context : *const core::ffi::c_void));
    unsafe { PoFxIssueComponentPerfStateChangeMultiple(handle, flags, component, perfchangescount, perfchanges, context) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxNotifySurprisePowerOn(pdo: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxNotifySurprisePowerOn(pdo : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { PoFxNotifySurprisePowerOn(pdo) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxPowerControl(handle: super::super::Foundation::POHANDLE, powercontrolcode: *const windows_core::GUID, inbuffer: Option<*const core::ffi::c_void>, inbuffersize: usize, outbuffer: Option<*mut core::ffi::c_void>, outbuffersize: usize, bytesreturned: Option<*mut usize>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxPowerControl(handle : super::super::Foundation:: POHANDLE, powercontrolcode : *const windows_core::GUID, inbuffer : *const core::ffi::c_void, inbuffersize : usize, outbuffer : *mut core::ffi::c_void, outbuffersize : usize, bytesreturned : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoFxPowerControl(handle, powercontrolcode, inbuffer.unwrap_or(core::mem::zeroed()) as _, inbuffersize, outbuffer.unwrap_or(core::mem::zeroed()) as _, outbuffersize, bytesreturned.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxPowerOnCrashdumpDevice(handle: super::super::Foundation::POHANDLE, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxPowerOnCrashdumpDevice(handle : super::super::Foundation:: POHANDLE, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoFxPowerOnCrashdumpDevice(handle, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxQueryCurrentComponentPerfState(handle: super::super::Foundation::POHANDLE, flags: u32, component: u32, setindex: u32, currentperf: *mut u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxQueryCurrentComponentPerfState(handle : super::super::Foundation:: POHANDLE, flags : u32, component : u32, setindex : u32, currentperf : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoFxQueryCurrentComponentPerfState(handle, flags, component, setindex, currentperf as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxRegisterComponentPerfStates(handle: super::super::Foundation::POHANDLE, component: u32, flags: u64, componentperfstatecallback: PPO_FX_COMPONENT_PERF_STATE_CALLBACK, inputstateinfo: *const PO_FX_COMPONENT_PERF_INFO, outputstateinfo: *mut *mut PO_FX_COMPONENT_PERF_INFO) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxRegisterComponentPerfStates(handle : super::super::Foundation:: POHANDLE, component : u32, flags : u64, componentperfstatecallback : PPO_FX_COMPONENT_PERF_STATE_CALLBACK, inputstateinfo : *const PO_FX_COMPONENT_PERF_INFO, outputstateinfo : *mut *mut PO_FX_COMPONENT_PERF_INFO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoFxRegisterComponentPerfStates(handle, component, flags, componentperfstatecallback, inputstateinfo, outputstateinfo as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxRegisterCrashdumpDevice(handle: super::super::Foundation::POHANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxRegisterCrashdumpDevice(handle : super::super::Foundation:: POHANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoFxRegisterCrashdumpDevice(handle) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxRegisterDevice(pdo: *const super::super::Foundation::DEVICE_OBJECT, device: *const PO_FX_DEVICE_V1, handle: *mut super::super::Foundation::POHANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxRegisterDevice(pdo : *const super::super::Foundation:: DEVICE_OBJECT, device : *const PO_FX_DEVICE_V1, handle : *mut super::super::Foundation:: POHANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoFxRegisterDevice(pdo, device, handle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxRegisterDripsWatchdogCallback(handle: super::super::Foundation::POHANDLE, callback: PPO_FX_DRIPS_WATCHDOG_CALLBACK, includechilddevices: bool, matchingdriverobject: Option<*const super::super::Foundation::DRIVER_OBJECT>) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxRegisterDripsWatchdogCallback(handle : super::super::Foundation:: POHANDLE, callback : PPO_FX_DRIPS_WATCHDOG_CALLBACK, includechilddevices : bool, matchingdriverobject : *const super::super::Foundation:: DRIVER_OBJECT));
    unsafe { PoFxRegisterDripsWatchdogCallback(handle, callback, includechilddevices, matchingdriverobject.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxReportDevicePoweredOn(handle: super::super::Foundation::POHANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxReportDevicePoweredOn(handle : super::super::Foundation:: POHANDLE));
    unsafe { PoFxReportDevicePoweredOn(handle) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetComponentLatency(handle: super::super::Foundation::POHANDLE, component: u32, latency: u64) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxSetComponentLatency(handle : super::super::Foundation:: POHANDLE, component : u32, latency : u64));
    unsafe { PoFxSetComponentLatency(handle, component, latency) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetComponentResidency(handle: super::super::Foundation::POHANDLE, component: u32, residency: u64) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxSetComponentResidency(handle : super::super::Foundation:: POHANDLE, component : u32, residency : u64));
    unsafe { PoFxSetComponentResidency(handle, component, residency) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetComponentWake(handle: super::super::Foundation::POHANDLE, component: u32, wakehint: bool) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxSetComponentWake(handle : super::super::Foundation:: POHANDLE, component : u32, wakehint : bool));
    unsafe { PoFxSetComponentWake(handle, component, wakehint) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetDeviceIdleTimeout(handle: super::super::Foundation::POHANDLE, idletimeout: u64) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxSetDeviceIdleTimeout(handle : super::super::Foundation:: POHANDLE, idletimeout : u64));
    unsafe { PoFxSetDeviceIdleTimeout(handle, idletimeout) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxSetTargetDripsDevicePowerState(handle: super::super::Foundation::POHANDLE, targetstate: super::super::super::Win32::System::Power::DEVICE_POWER_STATE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxSetTargetDripsDevicePowerState(handle : super::super::Foundation:: POHANDLE, targetstate : super::super::super::Win32::System::Power:: DEVICE_POWER_STATE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoFxSetTargetDripsDevicePowerState(handle, targetstate) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxStartDevicePowerManagement(handle: super::super::Foundation::POHANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxStartDevicePowerManagement(handle : super::super::Foundation:: POHANDLE));
    unsafe { PoFxStartDevicePowerManagement(handle) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxUnregisterDevice(handle: super::super::Foundation::POHANDLE) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoFxUnregisterDevice(handle : super::super::Foundation:: POHANDLE));
    unsafe { PoFxUnregisterDevice(handle) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoGetSystemWake(irp: *const super::super::Foundation::IRP) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PoGetSystemWake(irp : *const super::super::Foundation:: IRP) -> bool);
    unsafe { PoGetSystemWake(irp) }
}
#[inline]
pub unsafe fn PoGetThermalRequestSupport(thermalrequest: *const core::ffi::c_void, r#type: PO_THERMAL_REQUEST_TYPE) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PoGetThermalRequestSupport(thermalrequest : *const core::ffi::c_void, r#type : PO_THERMAL_REQUEST_TYPE) -> bool);
    unsafe { PoGetThermalRequestSupport(thermalrequest, r#type) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoQueryWatchdogTime(pdo: *const super::super::Foundation::DEVICE_OBJECT, secondsremaining: *mut u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PoQueryWatchdogTime(pdo : *const super::super::Foundation:: DEVICE_OBJECT, secondsremaining : *mut u32) -> bool);
    unsafe { PoQueryWatchdogTime(pdo, secondsremaining as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoRegisterDeviceForIdleDetection(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, conservationidletime: u32, performanceidletime: u32, state: super::super::super::Win32::System::Power::DEVICE_POWER_STATE) -> *mut u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn PoRegisterDeviceForIdleDetection(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, conservationidletime : u32, performanceidletime : u32, state : super::super::super::Win32::System::Power:: DEVICE_POWER_STATE) -> *mut u32);
    unsafe { PoRegisterDeviceForIdleDetection(deviceobject, conservationidletime, performanceidletime, state) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoRegisterPowerSettingCallback(deviceobject: Option<*const super::super::Foundation::DEVICE_OBJECT>, settingguid: *const windows_core::GUID, callback: PPOWER_SETTING_CALLBACK, context: Option<*const core::ffi::c_void>, handle: Option<*mut *mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoRegisterPowerSettingCallback(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, settingguid : *const windows_core::GUID, callback : PPOWER_SETTING_CALLBACK, context : *const core::ffi::c_void, handle : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoRegisterPowerSettingCallback(deviceobject.unwrap_or(core::mem::zeroed()) as _, settingguid, callback, context.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn PoRegisterSystemState(statehandle: Option<*mut core::ffi::c_void>, flags: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn PoRegisterSystemState(statehandle : *mut core::ffi::c_void, flags : u32) -> *mut core::ffi::c_void);
    unsafe { PoRegisterSystemState(statehandle.unwrap_or(core::mem::zeroed()) as _, flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoRequestPowerIrp(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, minorfunction: u8, powerstate: POWER_STATE, completionfunction: PREQUEST_POWER_COMPLETE, context: Option<*const core::ffi::c_void>, irp: Option<*mut *mut super::super::Foundation::IRP>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoRequestPowerIrp(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, minorfunction : u8, powerstate : POWER_STATE, completionfunction : PREQUEST_POWER_COMPLETE, context : *const core::ffi::c_void, irp : *mut *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoRequestPowerIrp(deviceobject, minorfunction, core::mem::transmute(powerstate), completionfunction, context.unwrap_or(core::mem::zeroed()) as _, irp.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn PoSetDeviceBusyEx(idlepointer: *mut u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetDeviceBusyEx(idlepointer : *mut u32));
    unsafe { PoSetDeviceBusyEx(idlepointer as _) }
}
#[inline]
pub unsafe fn PoSetHiberRange(memorymap: Option<*const core::ffi::c_void>, flags: u32, address: *const core::ffi::c_void, length: usize, tag: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetHiberRange(memorymap : *const core::ffi::c_void, flags : u32, address : *const core::ffi::c_void, length : usize, tag : u32));
    unsafe { PoSetHiberRange(memorymap.unwrap_or(core::mem::zeroed()) as _, flags, address, length, tag) }
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn PoSetPowerRequest(powerrequest: *mut core::ffi::c_void, r#type: super::super::super::Win32::System::Power::POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetPowerRequest(powerrequest : *mut core::ffi::c_void, r#type : super::super::super::Win32::System::Power:: POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoSetPowerRequest(powerrequest as _, r#type) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoSetPowerState(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, r#type: POWER_STATE_TYPE, state: POWER_STATE) -> POWER_STATE {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetPowerState(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, r#type : POWER_STATE_TYPE, state : POWER_STATE) -> POWER_STATE);
    unsafe { PoSetPowerState(deviceobject, r#type, core::mem::transmute(state)) }
}
#[inline]
pub unsafe fn PoSetSystemState(flags: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetSystemState(flags : u32));
    unsafe { PoSetSystemState(flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoSetSystemWake(irp: *mut super::super::Foundation::IRP) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetSystemWake(irp : *mut super::super::Foundation:: IRP));
    unsafe { PoSetSystemWake(irp as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoSetSystemWakeDevice(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetSystemWakeDevice(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    unsafe { PoSetSystemWakeDevice(deviceobject) }
}
#[inline]
pub unsafe fn PoSetThermalActiveCooling(thermalrequest: *mut core::ffi::c_void, engaged: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetThermalActiveCooling(thermalrequest : *mut core::ffi::c_void, engaged : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoSetThermalActiveCooling(thermalrequest as _, engaged) }
}
#[inline]
pub unsafe fn PoSetThermalPassiveCooling(thermalrequest: *mut core::ffi::c_void, throttle: u8) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoSetThermalPassiveCooling(thermalrequest : *mut core::ffi::c_void, throttle : u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoSetThermalPassiveCooling(thermalrequest as _, throttle) }
}
#[inline]
pub unsafe fn PoStartDeviceBusy(idlepointer: *mut u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoStartDeviceBusy(idlepointer : *mut u32));
    unsafe { PoStartDeviceBusy(idlepointer as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoStartNextPowerIrp(irp: *mut super::super::Foundation::IRP) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoStartNextPowerIrp(irp : *mut super::super::Foundation:: IRP));
    unsafe { PoStartNextPowerIrp(irp as _) }
}
#[inline]
pub unsafe fn PoUnregisterPowerSettingCallback(handle: *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PoUnregisterPowerSettingCallback(handle : *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PoUnregisterPowerSettingCallback(handle as _) }
}
#[inline]
pub unsafe fn PoUnregisterSystemState(statehandle: *mut core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn PoUnregisterSystemState(statehandle : *mut core::ffi::c_void));
    unsafe { PoUnregisterSystemState(statehandle as _) }
}
#[inline]
pub unsafe fn ProbeForRead(address: *const core::ffi::c_void, length: usize, alignment: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ProbeForRead(address : *const core::ffi::c_void, length : usize, alignment : u32));
    unsafe { ProbeForRead(address, length, alignment) }
}
#[inline]
pub unsafe fn ProbeForWrite(address: *mut core::ffi::c_void, length: usize, alignment: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn ProbeForWrite(address : *mut core::ffi::c_void, length : usize, alignment : u32));
    unsafe { ProbeForWrite(address as _, length, alignment) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsAcquireSiloHardReference(silo: super::super::Foundation::PESILO) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsAcquireSiloHardReference(silo : super::super::Foundation:: PESILO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsAcquireSiloHardReference(silo) }
}
#[inline]
pub unsafe fn PsAllocSiloContextSlot(reserved: usize, returnedcontextslot: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsAllocSiloContextSlot(reserved : usize, returnedcontextslot : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsAllocSiloContextSlot(reserved, returnedcontextslot as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsAllocateAffinityToken(affinitytoken: *mut super::super::Foundation::PAFFINITY_TOKEN) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsAllocateAffinityToken(affinitytoken : *mut super::super::Foundation:: PAFFINITY_TOKEN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsAllocateAffinityToken(affinitytoken as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsAttachSiloToCurrentThread(silo: super::super::Foundation::PESILO) -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn PsAttachSiloToCurrentThread(silo : super::super::Foundation:: PESILO) -> super::super::Foundation:: PESILO);
    unsafe { PsAttachSiloToCurrentThread(silo) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsCreateSiloContext(silo: super::super::Foundation::PESILO, size: u32, pooltype: super::super::Foundation::POOL_TYPE, contextcleanupcallback: SILO_CONTEXT_CLEANUP_CALLBACK, returnedsilocontext: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsCreateSiloContext(silo : super::super::Foundation:: PESILO, size : u32, pooltype : super::super::Foundation:: POOL_TYPE, contextcleanupcallback : SILO_CONTEXT_CLEANUP_CALLBACK, returnedsilocontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsCreateSiloContext(silo, size, pooltype, contextcleanupcallback, returnedsilocontext as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn PsCreateSystemThread(threadhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, processhandle: Option<super::super::super::Win32::Foundation::HANDLE>, clientid: Option<*mut super::super::super::Win32::System::WindowsProgramming::CLIENT_ID>, startroutine: PKSTART_ROUTINE, startcontext: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsCreateSystemThread(threadhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, processhandle : super::super::super::Win32::Foundation:: HANDLE, clientid : *mut super::super::super::Win32::System::WindowsProgramming:: CLIENT_ID, startroutine : PKSTART_ROUTINE, startcontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsCreateSystemThread(threadhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, processhandle.unwrap_or(core::mem::zeroed()) as _, clientid.unwrap_or(core::mem::zeroed()) as _, startroutine, startcontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn PsDereferenceSiloContext(silocontext: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsDereferenceSiloContext(silocontext : *const core::ffi::c_void));
    unsafe { PsDereferenceSiloContext(silocontext) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsDetachSiloFromCurrentThread(previoussilo: super::super::Foundation::PESILO) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsDetachSiloFromCurrentThread(previoussilo : super::super::Foundation:: PESILO));
    unsafe { PsDetachSiloFromCurrentThread(previoussilo) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsFreeAffinityToken(affinitytoken: super::super::Foundation::PAFFINITY_TOKEN) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsFreeAffinityToken(affinitytoken : super::super::Foundation:: PAFFINITY_TOKEN));
    unsafe { PsFreeAffinityToken(affinitytoken) }
}
#[inline]
pub unsafe fn PsFreeSiloContextSlot(contextslot: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsFreeSiloContextSlot(contextslot : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsFreeSiloContextSlot(contextslot) }
}
#[inline]
pub unsafe fn PsGetCurrentProcessId() -> super::super::super::Win32::Foundation::HANDLE {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetCurrentProcessId() -> super::super::super::Win32::Foundation:: HANDLE);
    unsafe { PsGetCurrentProcessId() }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetCurrentServerSilo() -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetCurrentServerSilo() -> super::super::Foundation:: PESILO);
    unsafe { PsGetCurrentServerSilo() }
}
#[inline]
pub unsafe fn PsGetCurrentServerSiloName() -> *mut super::super::super::Win32::Foundation::UNICODE_STRING {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetCurrentServerSiloName() -> *mut super::super::super::Win32::Foundation:: UNICODE_STRING);
    unsafe { PsGetCurrentServerSiloName() }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetCurrentSilo() -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetCurrentSilo() -> super::super::Foundation:: PESILO);
    unsafe { PsGetCurrentSilo() }
}
#[inline]
pub unsafe fn PsGetCurrentThreadId() -> super::super::super::Win32::Foundation::HANDLE {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetCurrentThreadId() -> super::super::super::Win32::Foundation:: HANDLE);
    unsafe { PsGetCurrentThreadId() }
}
#[inline]
pub unsafe fn PsGetCurrentThreadTeb() -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetCurrentThreadTeb() -> *mut core::ffi::c_void);
    unsafe { PsGetCurrentThreadTeb() }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetEffectiveServerSilo(silo: super::super::Foundation::PESILO) -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetEffectiveServerSilo(silo : super::super::Foundation:: PESILO) -> super::super::Foundation:: PESILO);
    unsafe { PsGetEffectiveServerSilo(silo) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetHostSilo() -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetHostSilo() -> super::super::Foundation:: PESILO);
    unsafe { PsGetHostSilo() }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetJobServerSilo(job: Option<super::super::Foundation::PEJOB>, serversilo: *mut super::super::Foundation::PESILO) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetJobServerSilo(job : super::super::Foundation:: PEJOB, serversilo : *mut super::super::Foundation:: PESILO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsGetJobServerSilo(job.unwrap_or(core::mem::zeroed()) as _, serversilo as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetJobSilo(job: super::super::Foundation::PEJOB, silo: *mut super::super::Foundation::PESILO) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetJobSilo(job : super::super::Foundation:: PEJOB, silo : *mut super::super::Foundation:: PESILO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsGetJobSilo(job, silo as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetParentSilo(job: Option<super::super::Foundation::PEJOB>) -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetParentSilo(job : super::super::Foundation:: PEJOB) -> super::super::Foundation:: PESILO);
    unsafe { PsGetParentSilo(job.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetPermanentSiloContext(silo: super::super::Foundation::PESILO, contextslot: u32, returnedsilocontext: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetPermanentSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, returnedsilocontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsGetPermanentSiloContext(silo, contextslot, returnedsilocontext as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessCreateTimeQuadPart(process: super::super::Foundation::PEPROCESS) -> i64 {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetProcessCreateTimeQuadPart(process : super::super::Foundation:: PEPROCESS) -> i64);
    unsafe { PsGetProcessCreateTimeQuadPart(process) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessExitStatus(process: super::super::Foundation::PEPROCESS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetProcessExitStatus(process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsGetProcessExitStatus(process) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessId(process: super::super::Foundation::PEPROCESS) -> super::super::super::Win32::Foundation::HANDLE {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetProcessId(process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: HANDLE);
    unsafe { PsGetProcessId(process) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessStartKey(process: super::super::Foundation::PEPROCESS) -> u64 {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetProcessStartKey(process : super::super::Foundation:: PEPROCESS) -> u64);
    unsafe { PsGetProcessStartKey(process) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetServerSiloServiceSessionId(silo: super::super::Foundation::PESILO) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetServerSiloServiceSessionId(silo : super::super::Foundation:: PESILO) -> u32);
    unsafe { PsGetServerSiloServiceSessionId(silo) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetSiloContainerId(silo: super::super::Foundation::PESILO) -> *mut windows_core::GUID {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetSiloContainerId(silo : super::super::Foundation:: PESILO) -> *mut windows_core::GUID);
    unsafe { PsGetSiloContainerId(silo) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetSiloContext(silo: super::super::Foundation::PESILO, contextslot: u32, returnedsilocontext: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, returnedsilocontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsGetSiloContext(silo, contextslot, returnedsilocontext as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetSiloMonitorContextSlot(monitor: super::super::Foundation::PSILO_MONITOR) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetSiloMonitorContextSlot(monitor : super::super::Foundation:: PSILO_MONITOR) -> u32);
    unsafe { PsGetSiloMonitorContextSlot(monitor) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadCreateTime(thread: super::super::Foundation::PETHREAD) -> i64 {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetThreadCreateTime(thread : super::super::Foundation:: PETHREAD) -> i64);
    unsafe { PsGetThreadCreateTime(thread) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadExitStatus(thread: super::super::Foundation::PETHREAD) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetThreadExitStatus(thread : super::super::Foundation:: PETHREAD) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsGetThreadExitStatus(thread) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadId(thread: super::super::Foundation::PETHREAD) -> super::super::super::Win32::Foundation::HANDLE {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetThreadId(thread : super::super::Foundation:: PETHREAD) -> super::super::super::Win32::Foundation:: HANDLE);
    unsafe { PsGetThreadId(thread) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadProcessId(thread: super::super::Foundation::PETHREAD) -> super::super::super::Win32::Foundation::HANDLE {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetThreadProcessId(thread : super::super::Foundation:: PETHREAD) -> super::super::super::Win32::Foundation:: HANDLE);
    unsafe { PsGetThreadProcessId(thread) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadProperty(thread: super::super::Foundation::PETHREAD, key: usize, flags: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetThreadProperty(thread : super::super::Foundation:: PETHREAD, key : usize, flags : u32) -> *mut core::ffi::c_void);
    unsafe { PsGetThreadProperty(thread, key, flags) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadServerSilo(thread: super::super::Foundation::PETHREAD) -> super::super::Foundation::PESILO {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetThreadServerSilo(thread : super::super::Foundation:: PETHREAD) -> super::super::Foundation:: PESILO);
    unsafe { PsGetThreadServerSilo(thread) }
}
#[inline]
pub unsafe fn PsGetVersion(majorversion: Option<*mut u32>, minorversion: Option<*mut u32>, buildnumber: Option<*mut u32>, csdversion: Option<*mut super::super::super::Win32::Foundation::UNICODE_STRING>) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PsGetVersion(majorversion : *mut u32, minorversion : *mut u32, buildnumber : *mut u32, csdversion : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> bool);
    unsafe { PsGetVersion(majorversion.unwrap_or(core::mem::zeroed()) as _, minorversion.unwrap_or(core::mem::zeroed()) as _, buildnumber.unwrap_or(core::mem::zeroed()) as _, csdversion.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsInsertPermanentSiloContext(silo: super::super::Foundation::PESILO, contextslot: u32, silocontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsInsertPermanentSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, silocontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsInsertPermanentSiloContext(silo, contextslot, silocontext) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsInsertSiloContext(silo: super::super::Foundation::PESILO, contextslot: u32, silocontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsInsertSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, silocontext : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsInsertSiloContext(silo, contextslot, silocontext) }
}
#[inline]
pub unsafe fn PsIsCurrentThreadInServerSilo() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PsIsCurrentThreadInServerSilo() -> bool);
    unsafe { PsIsCurrentThreadInServerSilo() }
}
#[inline]
pub unsafe fn PsIsCurrentThreadPrefetching() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PsIsCurrentThreadPrefetching() -> bool);
    unsafe { PsIsCurrentThreadPrefetching() }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsIsHostSilo(silo: super::super::Foundation::PESILO) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PsIsHostSilo(silo : super::super::Foundation:: PESILO) -> bool);
    unsafe { PsIsHostSilo(silo) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsMakeSiloContextPermanent(silo: super::super::Foundation::PESILO, contextslot: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsMakeSiloContextPermanent(silo : super::super::Foundation:: PESILO, contextslot : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsMakeSiloContextPermanent(silo, contextslot) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsQueryTotalCycleTimeProcess(process: super::super::Foundation::PEPROCESS, cycletimestamp: *mut u64) -> u64 {
    windows_link::link!("ntoskrnl.exe" "system" fn PsQueryTotalCycleTimeProcess(process : super::super::Foundation:: PEPROCESS, cycletimestamp : *mut u64) -> u64);
    unsafe { PsQueryTotalCycleTimeProcess(process, cycletimestamp as _) }
}
#[inline]
pub unsafe fn PsReferenceSiloContext(silocontext: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsReferenceSiloContext(silocontext : *const core::ffi::c_void));
    unsafe { PsReferenceSiloContext(silocontext) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsRegisterSiloMonitor(registration: *const SILO_MONITOR_REGISTRATION, returnedmonitor: *mut super::super::Foundation::PSILO_MONITOR) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsRegisterSiloMonitor(registration : *const SILO_MONITOR_REGISTRATION, returnedmonitor : *mut super::super::Foundation:: PSILO_MONITOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsRegisterSiloMonitor(registration, returnedmonitor as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsReleaseSiloHardReference(silo: super::super::Foundation::PESILO) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsReleaseSiloHardReference(silo : super::super::Foundation:: PESILO));
    unsafe { PsReleaseSiloHardReference(silo) }
}
#[inline]
pub unsafe fn PsRemoveCreateThreadNotifyRoutine(notifyroutine: PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsRemoveCreateThreadNotifyRoutine(notifyroutine : PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsRemoveCreateThreadNotifyRoutine(notifyroutine) }
}
#[inline]
pub unsafe fn PsRemoveLoadImageNotifyRoutine(notifyroutine: PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsRemoveLoadImageNotifyRoutine(notifyroutine : PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsRemoveLoadImageNotifyRoutine(notifyroutine) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsRemoveSiloContext(silo: super::super::Foundation::PESILO, contextslot: u32, removedsilocontext: Option<*mut *mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsRemoveSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, removedsilocontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsRemoveSiloContext(silo, contextslot, removedsilocontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsReplaceSiloContext(silo: super::super::Foundation::PESILO, contextslot: u32, newsilocontext: *const core::ffi::c_void, oldsilocontext: Option<*mut *mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsReplaceSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, newsilocontext : *const core::ffi::c_void, oldsilocontext : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsReplaceSiloContext(silo, contextslot, newsilocontext, oldsilocontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsRevertToUserMultipleGroupAffinityThread(affinitytoken: super::super::Foundation::PAFFINITY_TOKEN) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsRevertToUserMultipleGroupAffinityThread(affinitytoken : super::super::Foundation:: PAFFINITY_TOKEN));
    unsafe { PsRevertToUserMultipleGroupAffinityThread(affinitytoken) }
}
#[inline]
pub unsafe fn PsSetCreateProcessNotifyRoutine(notifyroutine: PCREATE_PROCESS_NOTIFY_ROUTINE, remove: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetCreateProcessNotifyRoutine(notifyroutine : PCREATE_PROCESS_NOTIFY_ROUTINE, remove : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetCreateProcessNotifyRoutine(notifyroutine, remove) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn PsSetCreateProcessNotifyRoutineEx(notifyroutine: PCREATE_PROCESS_NOTIFY_ROUTINE_EX, remove: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetCreateProcessNotifyRoutineEx(notifyroutine : PCREATE_PROCESS_NOTIFY_ROUTINE_EX, remove : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetCreateProcessNotifyRoutineEx(notifyroutine, remove) }
}
#[inline]
pub unsafe fn PsSetCreateProcessNotifyRoutineEx2(notifytype: PSCREATEPROCESSNOTIFYTYPE, notifyinformation: *const core::ffi::c_void, remove: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetCreateProcessNotifyRoutineEx2(notifytype : PSCREATEPROCESSNOTIFYTYPE, notifyinformation : *const core::ffi::c_void, remove : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetCreateProcessNotifyRoutineEx2(notifytype, notifyinformation, remove) }
}
#[inline]
pub unsafe fn PsSetCreateThreadNotifyRoutine(notifyroutine: PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetCreateThreadNotifyRoutine(notifyroutine : PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetCreateThreadNotifyRoutine(notifyroutine) }
}
#[inline]
pub unsafe fn PsSetCreateThreadNotifyRoutineEx(notifytype: PSCREATETHREADNOTIFYTYPE, notifyinformation: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetCreateThreadNotifyRoutineEx(notifytype : PSCREATETHREADNOTIFYTYPE, notifyinformation : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetCreateThreadNotifyRoutineEx(notifytype, notifyinformation) }
}
#[inline]
pub unsafe fn PsSetCurrentThreadPrefetching(prefetching: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetCurrentThreadPrefetching(prefetching : bool) -> bool);
    unsafe { PsSetCurrentThreadPrefetching(prefetching) }
}
#[inline]
pub unsafe fn PsSetLoadImageNotifyRoutine(notifyroutine: PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetLoadImageNotifyRoutine(notifyroutine : PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetLoadImageNotifyRoutine(notifyroutine) }
}
#[inline]
pub unsafe fn PsSetLoadImageNotifyRoutineEx(notifyroutine: PLOAD_IMAGE_NOTIFY_ROUTINE, flags: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetLoadImageNotifyRoutineEx(notifyroutine : PLOAD_IMAGE_NOTIFY_ROUTINE, flags : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetLoadImageNotifyRoutineEx(notifyroutine, flags) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn PsSetSystemMultipleGroupAffinityThread(groupaffinities: &[super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY], affinitytoken: super::super::Foundation::PAFFINITY_TOKEN) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsSetSystemMultipleGroupAffinityThread(groupaffinities : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, groupcount : u16, affinitytoken : super::super::Foundation:: PAFFINITY_TOKEN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsSetSystemMultipleGroupAffinityThread(core::mem::transmute(groupaffinities.as_ptr()), groupaffinities.len().try_into().unwrap(), affinitytoken) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsStartSiloMonitor(monitor: super::super::Foundation::PSILO_MONITOR) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsStartSiloMonitor(monitor : super::super::Foundation:: PSILO_MONITOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsStartSiloMonitor(monitor) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsTerminateServerSilo(serversilo: super::super::Foundation::PESILO, exitstatus: super::super::super::Win32::Foundation::NTSTATUS) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsTerminateServerSilo(serversilo : super::super::Foundation:: PESILO, exitstatus : super::super::super::Win32::Foundation:: NTSTATUS));
    unsafe { PsTerminateServerSilo(serversilo, exitstatus) }
}
#[inline]
pub unsafe fn PsTerminateSystemThread(exitstatus: super::super::super::Win32::Foundation::NTSTATUS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsTerminateSystemThread(exitstatus : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsTerminateSystemThread(exitstatus) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsUnregisterSiloMonitor(monitor: super::super::Foundation::PSILO_MONITOR) {
    windows_link::link!("ntoskrnl.exe" "system" fn PsUnregisterSiloMonitor(monitor : super::super::Foundation:: PSILO_MONITOR));
    unsafe { PsUnregisterSiloMonitor(monitor) }
}
#[inline]
pub unsafe fn PsWrapApcWow64Thread(apccontext: *mut *mut core::ffi::c_void, apcroutine: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn PsWrapApcWow64Thread(apccontext : *mut *mut core::ffi::c_void, apcroutine : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PsWrapApcWow64Thread(apccontext as _, apcroutine as _) }
}
#[inline]
pub unsafe fn PshedAllocateMemory(size: u32) -> *mut core::ffi::c_void {
    windows_link::link!("pshed.dll" "system" fn PshedAllocateMemory(size : u32) -> *mut core::ffi::c_void);
    unsafe { PshedAllocateMemory(size) }
}
#[inline]
pub unsafe fn PshedFreeMemory(address: *const core::ffi::c_void) {
    windows_link::link!("pshed.dll" "system" fn PshedFreeMemory(address : *const core::ffi::c_void));
    unsafe { PshedFreeMemory(address) }
}
#[inline]
pub unsafe fn PshedIsSystemWheaEnabled() -> bool {
    windows_link::link!("pshed.dll" "system" fn PshedIsSystemWheaEnabled() -> bool);
    unsafe { PshedIsSystemWheaEnabled() }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn PshedRegisterPlugin(packet: *mut WHEA_PSHED_PLUGIN_REGISTRATION_PACKET_V2) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("pshed.dll" "system" fn PshedRegisterPlugin(packet : *mut WHEA_PSHED_PLUGIN_REGISTRATION_PACKET_V2) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { PshedRegisterPlugin(packet as _) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn PshedSynchronizeExecution(errorsource: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_DESCRIPTOR, synchronizeroutine: PKSYNCHRONIZE_ROUTINE, synchronizecontext: *const core::ffi::c_void) -> bool {
    windows_link::link!("pshed.dll" "system" fn PshedSynchronizeExecution(errorsource : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_DESCRIPTOR, synchronizeroutine : PKSYNCHRONIZE_ROUTINE, synchronizecontext : *const core::ffi::c_void) -> bool);
    unsafe { PshedSynchronizeExecution(errorsource, synchronizeroutine, synchronizecontext) }
}
#[inline]
pub unsafe fn PshedUnregisterPlugin(pluginhandle: *const core::ffi::c_void) {
    windows_link::link!("pshed.dll" "system" fn PshedUnregisterPlugin(pluginhandle : *const core::ffi::c_void));
    unsafe { PshedUnregisterPlugin(pluginhandle) }
}
#[inline]
pub unsafe fn RtlAppendUnicodeStringToString(destination: *mut super::super::super::Win32::Foundation::UNICODE_STRING, source: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlAppendUnicodeStringToString(destination : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, source : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlAppendUnicodeStringToString(destination as _, source) }
}
#[inline]
pub unsafe fn RtlAppendUnicodeToString<P1>(destination: *mut super::super::super::Win32::Foundation::UNICODE_STRING, source: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlAppendUnicodeToString(destination : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, source : windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlAppendUnicodeToString(destination as _, source.param().abi()) }
}
#[inline]
pub unsafe fn RtlAreBitsClear(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlAreBitsClear(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> bool);
    unsafe { RtlAreBitsClear(bitmapheader, startingindex, length) }
}
#[inline]
pub unsafe fn RtlAreBitsSet(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlAreBitsSet(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> bool);
    unsafe { RtlAreBitsSet(bitmapheader, startingindex, length) }
}
#[inline]
pub unsafe fn RtlAssert<P3>(voidfailedassertion: *const core::ffi::c_void, voidfilename: *const core::ffi::c_void, linenumber: u32, mutablemessage: P3)
where
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlAssert(voidfailedassertion : *const core::ffi::c_void, voidfilename : *const core::ffi::c_void, linenumber : u32, mutablemessage : windows_core::PCSTR));
    unsafe { RtlAssert(voidfailedassertion, voidfilename, linenumber, mutablemessage.param().abi()) }
}
#[inline]
pub unsafe fn RtlCheckRegistryKey<P1>(relativeto: u32, path: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlCheckRegistryKey(relativeto : u32, path : windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlCheckRegistryKey(relativeto, path.param().abi()) }
}
#[inline]
pub unsafe fn RtlClearAllBits(bitmapheader: *const RTL_BITMAP) {
    windows_link::link!("ntdll.dll" "system" fn RtlClearAllBits(bitmapheader : *const RTL_BITMAP));
    unsafe { RtlClearAllBits(bitmapheader) }
}
#[inline]
pub unsafe fn RtlClearBit(bitmapheader: *const RTL_BITMAP, bitnumber: u32) {
    windows_link::link!("ntdll.dll" "system" fn RtlClearBit(bitmapheader : *const RTL_BITMAP, bitnumber : u32));
    unsafe { RtlClearBit(bitmapheader, bitnumber) }
}
#[inline]
pub unsafe fn RtlClearBits(bitmapheader: *const RTL_BITMAP, startingindex: u32, numbertoclear: u32) {
    windows_link::link!("ntdll.dll" "system" fn RtlClearBits(bitmapheader : *const RTL_BITMAP, startingindex : u32, numbertoclear : u32));
    unsafe { RtlClearBits(bitmapheader, startingindex, numbertoclear) }
}
#[inline]
pub unsafe fn RtlCmDecodeMemIoResource(descriptor: *const CM_PARTIAL_RESOURCE_DESCRIPTOR, start: Option<*mut u64>) -> u64 {
    windows_link::link!("ntdll.dll" "system" fn RtlCmDecodeMemIoResource(descriptor : *const CM_PARTIAL_RESOURCE_DESCRIPTOR, start : *mut u64) -> u64);
    unsafe { RtlCmDecodeMemIoResource(descriptor, start.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlCmEncodeMemIoResource(descriptor: *const CM_PARTIAL_RESOURCE_DESCRIPTOR, r#type: u8, length: u64, start: u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlCmEncodeMemIoResource(descriptor : *const CM_PARTIAL_RESOURCE_DESCRIPTOR, r#type : u8, length : u64, start : u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlCmEncodeMemIoResource(descriptor, r#type, length, start) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlCompareString(string1: *const super::super::super::Win32::System::Kernel::STRING, string2: *const super::super::super::Win32::System::Kernel::STRING, caseinsensitive: bool) -> i32 {
    windows_link::link!("ntdll.dll" "system" fn RtlCompareString(string1 : *const super::super::super::Win32::System::Kernel:: STRING, string2 : *const super::super::super::Win32::System::Kernel:: STRING, caseinsensitive : bool) -> i32);
    unsafe { RtlCompareString(string1, string2, caseinsensitive) }
}
#[inline]
pub unsafe fn RtlCompareUnicodeString(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: bool) -> i32 {
    windows_link::link!("ntdll.dll" "system" fn RtlCompareUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : bool) -> i32);
    unsafe { RtlCompareUnicodeString(string1, string2, caseinsensitive) }
}
#[inline]
pub unsafe fn RtlCompareUnicodeStrings(string1: &[u16], string2: &[u16], caseinsensitive: bool) -> i32 {
    windows_link::link!("ntdll.dll" "system" fn RtlCompareUnicodeStrings(string1 : *const u16, string1length : usize, string2 : *const u16, string2length : usize, caseinsensitive : bool) -> i32);
    unsafe { RtlCompareUnicodeStrings(core::mem::transmute(string1.as_ptr()), string1.len().try_into().unwrap(), core::mem::transmute(string2.as_ptr()), string2.len().try_into().unwrap(), caseinsensitive) }
}
#[inline]
pub unsafe fn RtlContractHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlContractHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE) -> bool);
    unsafe { RtlContractHashTable(hashtable) }
}
#[inline]
pub unsafe fn RtlCopyBitMap(source: *const RTL_BITMAP, destination: *const RTL_BITMAP, targetbit: u32) {
    windows_link::link!("ntdll.dll" "system" fn RtlCopyBitMap(source : *const RTL_BITMAP, destination : *const RTL_BITMAP, targetbit : u32));
    unsafe { RtlCopyBitMap(source, destination, targetbit) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlCopyString(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: Option<*const super::super::super::Win32::System::Kernel::STRING>) {
    windows_link::link!("ntdll.dll" "system" fn RtlCopyString(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const super::super::super::Win32::System::Kernel:: STRING));
    unsafe { RtlCopyString(destinationstring as _, sourcestring.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlCopyUnicodeString(destinationstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING, sourcestring: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) {
    windows_link::link!("ntdll.dll" "system" fn RtlCopyUnicodeString(destinationstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, sourcestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING));
    unsafe { RtlCopyUnicodeString(destinationstring as _, sourcestring.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlCreateHashTable(hashtable: *mut *mut RTL_DYNAMIC_HASH_TABLE, shift: u32, flags: Option<u32>) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlCreateHashTable(hashtable : *mut *mut RTL_DYNAMIC_HASH_TABLE, shift : u32, flags : u32) -> bool);
    unsafe { RtlCreateHashTable(hashtable as _, shift, flags.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlCreateHashTableEx(hashtable: *mut *mut RTL_DYNAMIC_HASH_TABLE, initialsize: u32, shift: u32, flags: Option<u32>) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlCreateHashTableEx(hashtable : *mut *mut RTL_DYNAMIC_HASH_TABLE, initialsize : u32, shift : u32, flags : u32) -> bool);
    unsafe { RtlCreateHashTableEx(hashtable as _, initialsize, shift, flags.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlCreateRegistryKey<P1>(relativeto: u32, path: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlCreateRegistryKey(relativeto : u32, path : windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlCreateRegistryKey(relativeto, path.param().abi()) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlCreateSecurityDescriptor(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, revision: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlCreateSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, revision : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlCreateSecurityDescriptor(securitydescriptor as _, revision) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlDelete(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    windows_link::link!("ntdll.dll" "system" fn RtlDelete(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    unsafe { RtlDelete(links) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlDeleteElementGenericTable(table: *const RTL_GENERIC_TABLE, buffer: *const core::ffi::c_void) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlDeleteElementGenericTable(table : *const RTL_GENERIC_TABLE, buffer : *const core::ffi::c_void) -> bool);
    unsafe { RtlDeleteElementGenericTable(table, buffer) }
}
#[inline]
pub unsafe fn RtlDeleteElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const core::ffi::c_void) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlDeleteElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const core::ffi::c_void) -> bool);
    unsafe { RtlDeleteElementGenericTableAvl(table, buffer) }
}
#[inline]
pub unsafe fn RtlDeleteElementGenericTableAvlEx(table: *const RTL_AVL_TABLE, nodeorparent: *const core::ffi::c_void) {
    windows_link::link!("ntdll.dll" "system" fn RtlDeleteElementGenericTableAvlEx(table : *const RTL_AVL_TABLE, nodeorparent : *const core::ffi::c_void));
    unsafe { RtlDeleteElementGenericTableAvlEx(table, nodeorparent) }
}
#[inline]
pub unsafe fn RtlDeleteHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE) {
    windows_link::link!("ntdll.dll" "system" fn RtlDeleteHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE));
    unsafe { RtlDeleteHashTable(hashtable) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlDeleteNoSplay(links: *const super::super::Foundation::RTL_SPLAY_LINKS, root: *mut *mut super::super::Foundation::RTL_SPLAY_LINKS) {
    windows_link::link!("ntdll.dll" "system" fn RtlDeleteNoSplay(links : *const super::super::Foundation:: RTL_SPLAY_LINKS, root : *mut *mut super::super::Foundation:: RTL_SPLAY_LINKS));
    unsafe { RtlDeleteNoSplay(links, root as _) }
}
#[inline]
pub unsafe fn RtlDeleteRegistryValue<P1, P2>(relativeto: u32, path: P1, valuename: P2) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlDeleteRegistryValue(relativeto : u32, path : windows_core::PCWSTR, valuename : windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlDeleteRegistryValue(relativeto, path.param().abi(), valuename.param().abi()) }
}
#[inline]
pub unsafe fn RtlDowncaseUnicodeChar(sourcecharacter: u16) -> u16 {
    windows_link::link!("ntdll.dll" "system" fn RtlDowncaseUnicodeChar(sourcecharacter : u16) -> u16);
    unsafe { RtlDowncaseUnicodeChar(sourcecharacter) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEndEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) {
    windows_link::link!("ntdll.dll" "system" fn RtlEndEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR));
    unsafe { RtlEndEnumerationHashTable(hashtable, enumerator as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEndStrongEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) {
    windows_link::link!("ntdll.dll" "system" fn RtlEndStrongEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR));
    unsafe { RtlEndStrongEnumerationHashTable(hashtable, enumerator as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEndWeakEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) {
    windows_link::link!("ntdll.dll" "system" fn RtlEndWeakEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR));
    unsafe { RtlEndWeakEnumerationHashTable(hashtable, enumerator as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEnumerateEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    windows_link::link!("ntdll.dll" "system" fn RtlEnumerateEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    unsafe { RtlEnumerateEntryHashTable(hashtable, enumerator as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlEnumerateGenericTable(table: *const RTL_GENERIC_TABLE, restart: bool) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlEnumerateGenericTable(table : *const RTL_GENERIC_TABLE, restart : bool) -> *mut core::ffi::c_void);
    unsafe { RtlEnumerateGenericTable(table, restart) }
}
#[inline]
pub unsafe fn RtlEnumerateGenericTableAvl(table: *const RTL_AVL_TABLE, restart: bool) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableAvl(table : *const RTL_AVL_TABLE, restart : bool) -> *mut core::ffi::c_void);
    unsafe { RtlEnumerateGenericTableAvl(table, restart) }
}
#[inline]
pub unsafe fn RtlEnumerateGenericTableLikeADirectory(table: *const RTL_AVL_TABLE, matchfunction: PRTL_AVL_MATCH_FUNCTION, matchdata: Option<*const core::ffi::c_void>, nextflag: u32, restartkey: *mut *mut core::ffi::c_void, deletecount: *mut u32, buffer: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableLikeADirectory(table : *const RTL_AVL_TABLE, matchfunction : PRTL_AVL_MATCH_FUNCTION, matchdata : *const core::ffi::c_void, nextflag : u32, restartkey : *mut *mut core::ffi::c_void, deletecount : *mut u32, buffer : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { RtlEnumerateGenericTableLikeADirectory(table, matchfunction, matchdata.unwrap_or(core::mem::zeroed()) as _, nextflag, restartkey as _, deletecount as _, buffer) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlEnumerateGenericTableWithoutSplaying(table: *const RTL_GENERIC_TABLE, restartkey: *mut *mut core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableWithoutSplaying(table : *const RTL_GENERIC_TABLE, restartkey : *mut *mut core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { RtlEnumerateGenericTableWithoutSplaying(table, restartkey as _) }
}
#[inline]
pub unsafe fn RtlEnumerateGenericTableWithoutSplayingAvl(table: *const RTL_AVL_TABLE, restartkey: *mut *mut core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableWithoutSplayingAvl(table : *const RTL_AVL_TABLE, restartkey : *mut *mut core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { RtlEnumerateGenericTableWithoutSplayingAvl(table, restartkey as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEqualString(string1: *const super::super::super::Win32::System::Kernel::STRING, string2: *const super::super::super::Win32::System::Kernel::STRING, caseinsensitive: bool) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlEqualString(string1 : *const super::super::super::Win32::System::Kernel:: STRING, string2 : *const super::super::super::Win32::System::Kernel:: STRING, caseinsensitive : bool) -> bool);
    unsafe { RtlEqualString(string1, string2, caseinsensitive) }
}
#[inline]
pub unsafe fn RtlEqualUnicodeString(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: bool) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlEqualUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : bool) -> bool);
    unsafe { RtlEqualUnicodeString(string1, string2, caseinsensitive) }
}
#[inline]
pub unsafe fn RtlExpandHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlExpandHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE) -> bool);
    unsafe { RtlExpandHashTable(hashtable) }
}
#[inline]
pub unsafe fn RtlExtractBitMap(source: *const RTL_BITMAP, destination: *const RTL_BITMAP, targetbit: u32, numberofbits: u32) {
    windows_link::link!("ntdll.dll" "system" fn RtlExtractBitMap(source : *const RTL_BITMAP, destination : *const RTL_BITMAP, targetbit : u32, numberofbits : u32));
    unsafe { RtlExtractBitMap(source, destination, targetbit, numberofbits) }
}
#[inline]
pub unsafe fn RtlFindClearBits(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindClearBits(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    unsafe { RtlFindClearBits(bitmapheader, numbertofind, hintindex) }
}
#[inline]
pub unsafe fn RtlFindClearBitsAndSet(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindClearBitsAndSet(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    unsafe { RtlFindClearBitsAndSet(bitmapheader, numbertofind, hintindex) }
}
#[inline]
pub unsafe fn RtlFindClearRuns(bitmapheader: *const RTL_BITMAP, runarray: &mut [RTL_BITMAP_RUN], locatelongestruns: bool) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindClearRuns(bitmapheader : *const RTL_BITMAP, runarray : *mut RTL_BITMAP_RUN, sizeofrunarray : u32, locatelongestruns : bool) -> u32);
    unsafe { RtlFindClearRuns(bitmapheader, core::mem::transmute(runarray.as_ptr()), runarray.len().try_into().unwrap(), locatelongestruns) }
}
#[inline]
pub unsafe fn RtlFindClosestEncodableLength(sourcelength: u64, targetlength: *mut u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlFindClosestEncodableLength(sourcelength : u64, targetlength : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlFindClosestEncodableLength(sourcelength, targetlength as _) }
}
#[inline]
pub unsafe fn RtlFindFirstRunClear(bitmapheader: *const RTL_BITMAP, startingindex: *mut u32) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlFindFirstRunClear(bitmapheader : *const RTL_BITMAP, startingindex : *mut u32) -> u32);
    unsafe { RtlFindFirstRunClear(bitmapheader, startingindex as _) }
}
#[inline]
pub unsafe fn RtlFindLastBackwardRunClear(bitmapheader: *const RTL_BITMAP, fromindex: u32, startingrunindex: *mut u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindLastBackwardRunClear(bitmapheader : *const RTL_BITMAP, fromindex : u32, startingrunindex : *mut u32) -> u32);
    unsafe { RtlFindLastBackwardRunClear(bitmapheader, fromindex, startingrunindex as _) }
}
#[inline]
pub unsafe fn RtlFindLeastSignificantBit(set: u64) -> i8 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindLeastSignificantBit(set : u64) -> i8);
    unsafe { RtlFindLeastSignificantBit(set) }
}
#[inline]
pub unsafe fn RtlFindLongestRunClear(bitmapheader: *const RTL_BITMAP, startingindex: *mut u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindLongestRunClear(bitmapheader : *const RTL_BITMAP, startingindex : *mut u32) -> u32);
    unsafe { RtlFindLongestRunClear(bitmapheader, startingindex as _) }
}
#[inline]
pub unsafe fn RtlFindMostSignificantBit(set: u64) -> i8 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindMostSignificantBit(set : u64) -> i8);
    unsafe { RtlFindMostSignificantBit(set) }
}
#[inline]
pub unsafe fn RtlFindNextForwardRunClear(bitmapheader: *const RTL_BITMAP, fromindex: u32, startingrunindex: *mut u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindNextForwardRunClear(bitmapheader : *const RTL_BITMAP, fromindex : u32, startingrunindex : *mut u32) -> u32);
    unsafe { RtlFindNextForwardRunClear(bitmapheader, fromindex, startingrunindex as _) }
}
#[inline]
pub unsafe fn RtlFindSetBits(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindSetBits(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    unsafe { RtlFindSetBits(bitmapheader, numbertofind, hintindex) }
}
#[inline]
pub unsafe fn RtlFindSetBitsAndClear(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlFindSetBitsAndClear(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    unsafe { RtlFindSetBitsAndClear(bitmapheader, numbertofind, hintindex) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlFreeUTF8String(utf8string: Option<*mut super::super::super::Win32::System::Kernel::STRING>) {
    windows_link::link!("ntdll.dll" "system" fn RtlFreeUTF8String(utf8string : *mut super::super::super::Win32::System::Kernel:: STRING));
    unsafe { RtlFreeUTF8String(utf8string.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlGUIDFromString(guidstring: *const super::super::super::Win32::Foundation::UNICODE_STRING, guid: *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlGUIDFromString(guidstring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, guid : *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlGUIDFromString(guidstring, guid as _) }
}
#[inline]
pub unsafe fn RtlGenerateClass5Guid(namespaceguid: *const windows_core::GUID, buffer: *const core::ffi::c_void, buffersize: u32, guid: *mut windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlGenerateClass5Guid(namespaceguid : *const windows_core::GUID, buffer : *const core::ffi::c_void, buffersize : u32, guid : *mut windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlGenerateClass5Guid(namespaceguid, buffer, buffersize, guid as _) }
}
#[inline]
pub unsafe fn RtlGetActiveConsoleId() -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlGetActiveConsoleId() -> u32);
    unsafe { RtlGetActiveConsoleId() }
}
#[inline]
pub unsafe fn RtlGetCallersAddress(callersaddress: *mut *mut core::ffi::c_void, callerscaller: *mut *mut core::ffi::c_void) {
    windows_link::link!("ntdll.dll" "system" fn RtlGetCallersAddress(callersaddress : *mut *mut core::ffi::c_void, callerscaller : *mut *mut core::ffi::c_void));
    unsafe { RtlGetCallersAddress(callersaddress as _, callerscaller as _) }
}
#[inline]
pub unsafe fn RtlGetConsoleSessionForegroundProcessId() -> u64 {
    windows_link::link!("ntdll.dll" "system" fn RtlGetConsoleSessionForegroundProcessId() -> u64);
    unsafe { RtlGetConsoleSessionForegroundProcessId() }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlGetElementGenericTable(table: *const RTL_GENERIC_TABLE, i: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlGetElementGenericTable(table : *const RTL_GENERIC_TABLE, i : u32) -> *mut core::ffi::c_void);
    unsafe { RtlGetElementGenericTable(table, i) }
}
#[inline]
pub unsafe fn RtlGetElementGenericTableAvl(table: *const RTL_AVL_TABLE, i: u32) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlGetElementGenericTableAvl(table : *const RTL_AVL_TABLE, i : u32) -> *mut core::ffi::c_void);
    unsafe { RtlGetElementGenericTableAvl(table, i) }
}
#[inline]
pub unsafe fn RtlGetEnabledExtendedFeatures(featuremask: u64) -> u64 {
    windows_link::link!("ntdll.dll" "system" fn RtlGetEnabledExtendedFeatures(featuremask : u64) -> u64);
    unsafe { RtlGetEnabledExtendedFeatures(featuremask) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlGetNextEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, context: *const RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    windows_link::link!("ntdll.dll" "system" fn RtlGetNextEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, context : *const RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    unsafe { RtlGetNextEntryHashTable(hashtable, context) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlGetNtProductType(ntproducttype: *mut super::super::super::Win32::System::Kernel::NT_PRODUCT_TYPE) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlGetNtProductType(ntproducttype : *mut super::super::super::Win32::System::Kernel:: NT_PRODUCT_TYPE) -> bool);
    unsafe { RtlGetNtProductType(ntproducttype as _) }
}
#[inline]
pub unsafe fn RtlGetNtSystemRoot() -> windows_core::PCWSTR {
    windows_link::link!("ntdll.dll" "system" fn RtlGetNtSystemRoot() -> windows_core::PCWSTR);
    unsafe { RtlGetNtSystemRoot() }
}
#[inline]
pub unsafe fn RtlGetPersistedStateLocation<P0, P1, P2>(sourceid: P0, customvalue: P1, defaultpath: P2, statelocationtype: STATE_LOCATION_TYPE, targetpath: Option<windows_core::PWSTR>, bufferlengthin: u32, bufferlengthout: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlGetPersistedStateLocation(sourceid : windows_core::PCWSTR, customvalue : windows_core::PCWSTR, defaultpath : windows_core::PCWSTR, statelocationtype : STATE_LOCATION_TYPE, targetpath : windows_core::PWSTR, bufferlengthin : u32, bufferlengthout : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlGetPersistedStateLocation(sourceid.param().abi(), customvalue.param().abi(), defaultpath.param().abi(), statelocationtype, targetpath.unwrap_or(core::mem::zeroed()) as _, bufferlengthin, bufferlengthout.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlGetSuiteMask() -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlGetSuiteMask() -> u32);
    unsafe { RtlGetSuiteMask() }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn RtlGetVersion(lpversioninformation: *mut super::super::super::Win32::System::SystemInformation::OSVERSIONINFOW) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlGetVersion(lpversioninformation : *mut super::super::super::Win32::System::SystemInformation:: OSVERSIONINFOW) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlGetVersion(lpversioninformation as _) }
}
#[inline]
pub unsafe fn RtlHashUnicodeString(string: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: bool, hashalgorithm: u32, hashvalue: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlHashUnicodeString(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : bool, hashalgorithm : u32, hashvalue : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlHashUnicodeString(string, caseinsensitive, hashalgorithm, hashvalue as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlInitEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> bool);
    unsafe { RtlInitEnumerationHashTable(hashtable, enumerator as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitStrongEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlInitStrongEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> bool);
    unsafe { RtlInitStrongEnumerationHashTable(hashtable, enumerator as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitUTF8String(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: Option<*const i8>) {
    windows_link::link!("ntdll.dll" "system" fn RtlInitUTF8String(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const i8));
    unsafe { RtlInitUTF8String(destinationstring as _, sourcestring.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitUTF8StringEx(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: Option<*const i8>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlInitUTF8StringEx(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const i8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlInitUTF8StringEx(destinationstring as _, sourcestring.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitWeakEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlInitWeakEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> bool);
    unsafe { RtlInitWeakEnumerationHashTable(hashtable, enumerator as _) }
}
#[inline]
pub unsafe fn RtlInitializeBitMap(bitmapheader: *mut RTL_BITMAP, bitmapbuffer: Option<*const u32>, sizeofbitmap: Option<u32>) {
    windows_link::link!("ntdll.dll" "system" fn RtlInitializeBitMap(bitmapheader : *mut RTL_BITMAP, bitmapbuffer : *const u32, sizeofbitmap : u32));
    unsafe { RtlInitializeBitMap(bitmapheader as _, bitmapbuffer.unwrap_or(core::mem::zeroed()) as _, sizeofbitmap.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlInitializeGenericTable(table: *mut RTL_GENERIC_TABLE, compareroutine: PRTL_GENERIC_COMPARE_ROUTINE, allocateroutine: PRTL_GENERIC_ALLOCATE_ROUTINE, freeroutine: PRTL_GENERIC_FREE_ROUTINE, tablecontext: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntdll.dll" "system" fn RtlInitializeGenericTable(table : *mut RTL_GENERIC_TABLE, compareroutine : PRTL_GENERIC_COMPARE_ROUTINE, allocateroutine : PRTL_GENERIC_ALLOCATE_ROUTINE, freeroutine : PRTL_GENERIC_FREE_ROUTINE, tablecontext : *const core::ffi::c_void));
    unsafe { RtlInitializeGenericTable(table as _, compareroutine, allocateroutine, freeroutine, tablecontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlInitializeGenericTableAvl(table: *mut RTL_AVL_TABLE, compareroutine: PRTL_AVL_COMPARE_ROUTINE, allocateroutine: PRTL_AVL_ALLOCATE_ROUTINE, freeroutine: PRTL_AVL_FREE_ROUTINE, tablecontext: Option<*const core::ffi::c_void>) {
    windows_link::link!("ntdll.dll" "system" fn RtlInitializeGenericTableAvl(table : *mut RTL_AVL_TABLE, compareroutine : PRTL_AVL_COMPARE_ROUTINE, allocateroutine : PRTL_AVL_ALLOCATE_ROUTINE, freeroutine : PRTL_AVL_FREE_ROUTINE, tablecontext : *const core::ffi::c_void));
    unsafe { RtlInitializeGenericTableAvl(table as _, compareroutine, allocateroutine, freeroutine, tablecontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlInsertElementGenericTable(table: *const RTL_GENERIC_TABLE, buffer: *const core::ffi::c_void, buffersize: u32, newelement: Option<*mut bool>) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlInsertElementGenericTable(table : *const RTL_GENERIC_TABLE, buffer : *const core::ffi::c_void, buffersize : u32, newelement : *mut bool) -> *mut core::ffi::c_void);
    unsafe { RtlInsertElementGenericTable(table, buffer, buffersize, newelement.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlInsertElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const core::ffi::c_void, buffersize: u32, newelement: Option<*mut bool>) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlInsertElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const core::ffi::c_void, buffersize : u32, newelement : *mut bool) -> *mut core::ffi::c_void);
    unsafe { RtlInsertElementGenericTableAvl(table, buffer, buffersize, newelement.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlInsertElementGenericTableFull(table: *const RTL_GENERIC_TABLE, buffer: *const core::ffi::c_void, buffersize: u32, newelement: Option<*mut bool>, nodeorparent: *const core::ffi::c_void, searchresult: TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlInsertElementGenericTableFull(table : *const RTL_GENERIC_TABLE, buffer : *const core::ffi::c_void, buffersize : u32, newelement : *mut bool, nodeorparent : *const core::ffi::c_void, searchresult : TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void);
    unsafe { RtlInsertElementGenericTableFull(table, buffer, buffersize, newelement.unwrap_or(core::mem::zeroed()) as _, nodeorparent, searchresult) }
}
#[inline]
pub unsafe fn RtlInsertElementGenericTableFullAvl(table: *const RTL_AVL_TABLE, buffer: *const core::ffi::c_void, buffersize: u32, newelement: Option<*mut bool>, nodeorparent: *const core::ffi::c_void, searchresult: TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlInsertElementGenericTableFullAvl(table : *const RTL_AVL_TABLE, buffer : *const core::ffi::c_void, buffersize : u32, newelement : *mut bool, nodeorparent : *const core::ffi::c_void, searchresult : TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void);
    unsafe { RtlInsertElementGenericTableFullAvl(table, buffer, buffersize, newelement.unwrap_or(core::mem::zeroed()) as _, nodeorparent, searchresult) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInsertEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, entry: *const RTL_DYNAMIC_HASH_TABLE_ENTRY, signature: usize, context: Option<*mut RTL_DYNAMIC_HASH_TABLE_CONTEXT>) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlInsertEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, entry : *const RTL_DYNAMIC_HASH_TABLE_ENTRY, signature : usize, context : *mut RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> bool);
    unsafe { RtlInsertEntryHashTable(hashtable, entry, signature, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlInt64ToUnicodeString(value: u64, base: Option<u32>, string: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlInt64ToUnicodeString(value : u64, base : u32, string : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlInt64ToUnicodeString(value, base.unwrap_or(core::mem::zeroed()) as _, string as _) }
}
#[inline]
pub unsafe fn RtlIntegerToUnicodeString(value: u32, base: Option<u32>, string: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlIntegerToUnicodeString(value : u32, base : u32, string : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlIntegerToUnicodeString(value, base.unwrap_or(core::mem::zeroed()) as _, string as _) }
}
#[inline]
pub unsafe fn RtlIoDecodeMemIoResource(descriptor: *const IO_RESOURCE_DESCRIPTOR, alignment: Option<*mut u64>, minimumaddress: Option<*mut u64>, maximumaddress: Option<*mut u64>) -> u64 {
    windows_link::link!("ntdll.dll" "system" fn RtlIoDecodeMemIoResource(descriptor : *const IO_RESOURCE_DESCRIPTOR, alignment : *mut u64, minimumaddress : *mut u64, maximumaddress : *mut u64) -> u64);
    unsafe { RtlIoDecodeMemIoResource(descriptor, alignment.unwrap_or(core::mem::zeroed()) as _, minimumaddress.unwrap_or(core::mem::zeroed()) as _, maximumaddress.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlIoEncodeMemIoResource(descriptor: *const IO_RESOURCE_DESCRIPTOR, r#type: u8, length: u64, alignment: u64, minimumaddress: u64, maximumaddress: u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlIoEncodeMemIoResource(descriptor : *const IO_RESOURCE_DESCRIPTOR, r#type : u8, length : u64, alignment : u64, minimumaddress : u64, maximumaddress : u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlIoEncodeMemIoResource(descriptor, r#type, length, alignment, minimumaddress, maximumaddress) }
}
#[inline]
pub unsafe fn RtlIsApiSetImplemented<P0>(apisetname: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlIsApiSetImplemented(apisetname : windows_core::PCSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlIsApiSetImplemented(apisetname.param().abi()) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlIsGenericTableEmpty(table: *const RTL_GENERIC_TABLE) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlIsGenericTableEmpty(table : *const RTL_GENERIC_TABLE) -> bool);
    unsafe { RtlIsGenericTableEmpty(table) }
}
#[inline]
pub unsafe fn RtlIsGenericTableEmptyAvl(table: *const RTL_AVL_TABLE) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlIsGenericTableEmptyAvl(table : *const RTL_AVL_TABLE) -> bool);
    unsafe { RtlIsGenericTableEmptyAvl(table) }
}
#[inline]
pub unsafe fn RtlIsMultiSessionSku() -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlIsMultiSessionSku() -> bool);
    unsafe { RtlIsMultiSessionSku() }
}
#[inline]
pub unsafe fn RtlIsMultiUsersInSessionSku() -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlIsMultiUsersInSessionSku() -> bool);
    unsafe { RtlIsMultiUsersInSessionSku() }
}
#[inline]
pub unsafe fn RtlIsNtDdiVersionAvailable(version: u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlIsNtDdiVersionAvailable(version : u32) -> bool);
    unsafe { RtlIsNtDdiVersionAvailable(version) }
}
#[inline]
pub unsafe fn RtlIsServicePackVersionInstalled(version: u32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlIsServicePackVersionInstalled(version : u32) -> bool);
    unsafe { RtlIsServicePackVersionInstalled(version) }
}
#[inline]
pub unsafe fn RtlIsStateSeparationEnabled() -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlIsStateSeparationEnabled() -> bool);
    unsafe { RtlIsStateSeparationEnabled() }
}
#[inline]
pub unsafe fn RtlIsUntrustedObject(handle: Option<super::super::super::Win32::Foundation::HANDLE>, object: Option<*const core::ffi::c_void>, untrustedobject: *mut bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlIsUntrustedObject(handle : super::super::super::Win32::Foundation:: HANDLE, object : *const core::ffi::c_void, untrustedobject : *mut bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlIsUntrustedObject(handle.unwrap_or(core::mem::zeroed()) as _, object.unwrap_or(core::mem::zeroed()) as _, untrustedobject as _) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlLengthSecurityDescriptor(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlLengthSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> u32);
    unsafe { RtlLengthSecurityDescriptor(securitydescriptor) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlLookupElementGenericTable(table: *const RTL_GENERIC_TABLE, buffer: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlLookupElementGenericTable(table : *const RTL_GENERIC_TABLE, buffer : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { RtlLookupElementGenericTable(table, buffer) }
}
#[inline]
pub unsafe fn RtlLookupElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlLookupElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { RtlLookupElementGenericTableAvl(table, buffer) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlLookupElementGenericTableFull(table: *const RTL_GENERIC_TABLE, buffer: *const core::ffi::c_void, nodeorparent: *mut *mut core::ffi::c_void, searchresult: *mut TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlLookupElementGenericTableFull(table : *const RTL_GENERIC_TABLE, buffer : *const core::ffi::c_void, nodeorparent : *mut *mut core::ffi::c_void, searchresult : *mut TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void);
    unsafe { RtlLookupElementGenericTableFull(table, buffer, nodeorparent as _, searchresult as _) }
}
#[inline]
pub unsafe fn RtlLookupElementGenericTableFullAvl(table: *const RTL_AVL_TABLE, buffer: *const core::ffi::c_void, nodeorparent: *mut *mut core::ffi::c_void, searchresult: *mut TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlLookupElementGenericTableFullAvl(table : *const RTL_AVL_TABLE, buffer : *const core::ffi::c_void, nodeorparent : *mut *mut core::ffi::c_void, searchresult : *mut TABLE_SEARCH_RESULT) -> *mut core::ffi::c_void);
    unsafe { RtlLookupElementGenericTableFullAvl(table, buffer, nodeorparent as _, searchresult as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlLookupEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, signature: usize, context: Option<*mut RTL_DYNAMIC_HASH_TABLE_CONTEXT>) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    windows_link::link!("ntdll.dll" "system" fn RtlLookupEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, signature : usize, context : *mut RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    unsafe { RtlLookupEntryHashTable(hashtable, signature, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlLookupFirstMatchingElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const core::ffi::c_void, restartkey: *mut *mut core::ffi::c_void) -> *mut core::ffi::c_void {
    windows_link::link!("ntdll.dll" "system" fn RtlLookupFirstMatchingElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const core::ffi::c_void, restartkey : *mut *mut core::ffi::c_void) -> *mut core::ffi::c_void);
    unsafe { RtlLookupFirstMatchingElementGenericTableAvl(table, buffer, restartkey as _) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlMapGenericMask(accessmask: *mut u32, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING) {
    windows_link::link!("ntdll.dll" "system" fn RtlMapGenericMask(accessmask : *mut u32, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING));
    unsafe { RtlMapGenericMask(accessmask as _, genericmapping) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlNormalizeSecurityDescriptor(securitydescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, securitydescriptorlength: u32, newsecuritydescriptor: Option<*mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, newsecuritydescriptorlength: Option<*mut u32>, checkonly: bool) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlNormalizeSecurityDescriptor(securitydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, securitydescriptorlength : u32, newsecuritydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, newsecuritydescriptorlength : *mut u32, checkonly : bool) -> bool);
    unsafe { RtlNormalizeSecurityDescriptor(securitydescriptor as _, securitydescriptorlength, newsecuritydescriptor.unwrap_or(core::mem::zeroed()) as _, newsecuritydescriptorlength.unwrap_or(core::mem::zeroed()) as _, checkonly) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlNumberGenericTableElements(table: *const RTL_GENERIC_TABLE) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlNumberGenericTableElements(table : *const RTL_GENERIC_TABLE) -> u32);
    unsafe { RtlNumberGenericTableElements(table) }
}
#[inline]
pub unsafe fn RtlNumberGenericTableElementsAvl(table: *const RTL_AVL_TABLE) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlNumberGenericTableElementsAvl(table : *const RTL_AVL_TABLE) -> u32);
    unsafe { RtlNumberGenericTableElementsAvl(table) }
}
#[inline]
pub unsafe fn RtlNumberOfClearBits(bitmapheader: *const RTL_BITMAP) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlNumberOfClearBits(bitmapheader : *const RTL_BITMAP) -> u32);
    unsafe { RtlNumberOfClearBits(bitmapheader) }
}
#[inline]
pub unsafe fn RtlNumberOfClearBitsInRange(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlNumberOfClearBitsInRange(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> u32);
    unsafe { RtlNumberOfClearBitsInRange(bitmapheader, startingindex, length) }
}
#[inline]
pub unsafe fn RtlNumberOfSetBits(bitmapheader: *const RTL_BITMAP) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlNumberOfSetBits(bitmapheader : *const RTL_BITMAP) -> u32);
    unsafe { RtlNumberOfSetBits(bitmapheader) }
}
#[inline]
pub unsafe fn RtlNumberOfSetBitsInRange(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlNumberOfSetBitsInRange(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> u32);
    unsafe { RtlNumberOfSetBitsInRange(bitmapheader, startingindex, length) }
}
#[inline]
pub unsafe fn RtlNumberOfSetBitsUlongPtr(target: usize) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlNumberOfSetBitsUlongPtr(target : usize) -> u32);
    unsafe { RtlNumberOfSetBitsUlongPtr(target) }
}
#[inline]
pub unsafe fn RtlPrefetchMemoryNonTemporal(source: *const core::ffi::c_void, length: usize) {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlPrefetchMemoryNonTemporal(source : *const core::ffi::c_void, length : usize));
    unsafe { RtlPrefetchMemoryNonTemporal(source, length) }
}
#[inline]
pub unsafe fn RtlPrefixUnicodeString(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: bool) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlPrefixUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : bool) -> bool);
    unsafe { RtlPrefixUnicodeString(string1, string2, caseinsensitive) }
}
#[inline]
pub unsafe fn RtlQueryRegistryValueWithFallback(primaryhandle: Option<super::super::super::Win32::Foundation::HANDLE>, fallbackhandle: Option<super::super::super::Win32::Foundation::HANDLE>, valuename: *const super::super::super::Win32::Foundation::UNICODE_STRING, valuelength: u32, valuetype: Option<*mut u32>, valuedata: *mut core::ffi::c_void, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlQueryRegistryValueWithFallback(primaryhandle : super::super::super::Win32::Foundation:: HANDLE, fallbackhandle : super::super::super::Win32::Foundation:: HANDLE, valuename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, valuelength : u32, valuetype : *mut u32, valuedata : *mut core::ffi::c_void, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlQueryRegistryValueWithFallback(primaryhandle.unwrap_or(core::mem::zeroed()) as _, fallbackhandle.unwrap_or(core::mem::zeroed()) as _, valuename, valuelength, valuetype.unwrap_or(core::mem::zeroed()) as _, valuedata as _, resultlength as _) }
}
#[inline]
pub unsafe fn RtlQueryRegistryValues<P1>(relativeto: u32, path: P1, querytable: *mut RTL_QUERY_REGISTRY_TABLE, context: Option<*const core::ffi::c_void>, environment: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlQueryRegistryValues(relativeto : u32, path : windows_core::PCWSTR, querytable : *mut RTL_QUERY_REGISTRY_TABLE, context : *const core::ffi::c_void, environment : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlQueryRegistryValues(relativeto, path.param().abi(), querytable as _, context.unwrap_or(core::mem::zeroed()) as _, environment.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlQueryValidationRunlevel(componentname: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlQueryValidationRunlevel(componentname : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> u32);
    unsafe { RtlQueryValidationRunlevel(componentname.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlRealPredecessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    windows_link::link!("ntdll.dll" "system" fn RtlRealPredecessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    unsafe { RtlRealPredecessor(links) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlRealSuccessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    windows_link::link!("ntdll.dll" "system" fn RtlRealSuccessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    unsafe { RtlRealSuccessor(links) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlRemoveEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, entry: *const RTL_DYNAMIC_HASH_TABLE_ENTRY, context: Option<*mut RTL_DYNAMIC_HASH_TABLE_CONTEXT>) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlRemoveEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, entry : *const RTL_DYNAMIC_HASH_TABLE_ENTRY, context : *mut RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> bool);
    unsafe { RtlRemoveEntryHashTable(hashtable, entry, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceBeginInitialize(runonce: *mut super::super::super::Win32::System::Threading::INIT_ONCE, flags: u32, context: Option<*mut *mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlRunOnceBeginInitialize(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE, flags : u32, context : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlRunOnceBeginInitialize(runonce as _, flags, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceComplete(runonce: *mut super::super::super::Win32::System::Threading::INIT_ONCE, flags: u32, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlRunOnceComplete(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE, flags : u32, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlRunOnceComplete(runonce as _, flags, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceExecuteOnce(runonce: *mut super::super::super::Win32::System::Threading::INIT_ONCE, initfn: PRTL_RUN_ONCE_INIT_FN, parameter: Option<*mut core::ffi::c_void>, context: Option<*mut *mut core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlRunOnceExecuteOnce(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE, initfn : PRTL_RUN_ONCE_INIT_FN, parameter : *mut core::ffi::c_void, context : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlRunOnceExecuteOnce(runonce as _, initfn, parameter.unwrap_or(core::mem::zeroed()) as _, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceInitialize() -> super::super::super::Win32::System::Threading::INIT_ONCE {
    windows_link::link!("ntdll.dll" "system" fn RtlRunOnceInitialize(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE));
    unsafe {
        let mut result__ = core::mem::zeroed();
        RtlRunOnceInitialize(&mut result__);
        result__
    }
}
#[inline]
pub unsafe fn RtlSetAllBits(bitmapheader: *const RTL_BITMAP) {
    windows_link::link!("ntdll.dll" "system" fn RtlSetAllBits(bitmapheader : *const RTL_BITMAP));
    unsafe { RtlSetAllBits(bitmapheader) }
}
#[inline]
pub unsafe fn RtlSetBit(bitmapheader: *const RTL_BITMAP, bitnumber: u32) {
    windows_link::link!("ntdll.dll" "system" fn RtlSetBit(bitmapheader : *const RTL_BITMAP, bitnumber : u32));
    unsafe { RtlSetBit(bitmapheader, bitnumber) }
}
#[inline]
pub unsafe fn RtlSetBits(bitmapheader: *const RTL_BITMAP, startingindex: u32, numbertoset: u32) {
    windows_link::link!("ntdll.dll" "system" fn RtlSetBits(bitmapheader : *const RTL_BITMAP, startingindex : u32, numbertoset : u32));
    unsafe { RtlSetBits(bitmapheader, startingindex, numbertoset) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlSetDaclSecurityDescriptor(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, daclpresent: bool, dacl: Option<*const super::super::super::Win32::Security::ACL>, dacldefaulted: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlSetDaclSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, daclpresent : bool, dacl : *const super::super::super::Win32::Security:: ACL, dacldefaulted : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlSetDaclSecurityDescriptor(securitydescriptor as _, daclpresent, dacl.unwrap_or(core::mem::zeroed()) as _, dacldefaulted) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn RtlSetSystemGlobalData(dataid: super::super::super::Win32::System::SystemInformation::RTL_SYSTEM_GLOBAL_DATA_ID, buffer: *const core::ffi::c_void, size: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlSetSystemGlobalData(dataid : super::super::super::Win32::System::SystemInformation:: RTL_SYSTEM_GLOBAL_DATA_ID, buffer : *const core::ffi::c_void, size : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlSetSystemGlobalData(dataid, buffer, size) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlSplay(links: *mut super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    windows_link::link!("ntdll.dll" "system" fn RtlSplay(links : *mut super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    unsafe { RtlSplay(links as _) }
}
#[inline]
pub unsafe fn RtlStringFromGUID(guid: *const windows_core::GUID, guidstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlStringFromGUID(guid : *const windows_core::GUID, guidstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlStringFromGUID(guid, guidstring as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlStronglyEnumerateEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    windows_link::link!("ntdll.dll" "system" fn RtlStronglyEnumerateEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    unsafe { RtlStronglyEnumerateEntryHashTable(hashtable, enumerator as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlSubtreePredecessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    windows_link::link!("ntdll.dll" "system" fn RtlSubtreePredecessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    unsafe { RtlSubtreePredecessor(links) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlSubtreeSuccessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    windows_link::link!("ntdll.dll" "system" fn RtlSubtreeSuccessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    unsafe { RtlSubtreeSuccessor(links) }
}
#[inline]
pub unsafe fn RtlSuffixUnicodeString(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: bool) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlSuffixUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : bool) -> bool);
    unsafe { RtlSuffixUnicodeString(string1, string2, caseinsensitive) }
}
#[inline]
pub unsafe fn RtlTestBit(bitmapheader: *const RTL_BITMAP, bitnumber: u32) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlTestBit(bitmapheader : *const RTL_BITMAP, bitnumber : u32) -> bool);
    unsafe { RtlTestBit(bitmapheader, bitnumber) }
}
#[inline]
pub unsafe fn RtlTimeFieldsToTime(timefields: *const TIME_FIELDS, time: *mut i64) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlTimeFieldsToTime(timefields : *const TIME_FIELDS, time : *mut i64) -> bool);
    unsafe { RtlTimeFieldsToTime(timefields, time as _) }
}
#[inline]
pub unsafe fn RtlTimeToTimeFields(time: *const i64) -> TIME_FIELDS {
    windows_link::link!("ntdll.dll" "system" fn RtlTimeToTimeFields(time : *const i64, timefields : *mut TIME_FIELDS));
    unsafe {
        let mut result__ = core::mem::zeroed();
        RtlTimeToTimeFields(time, &mut result__);
        result__
    }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlUTF8StringToUnicodeString(destinationstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING, sourcestring: *const super::super::super::Win32::System::Kernel::STRING, allocatedestinationstring: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlUTF8StringToUnicodeString(destinationstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, sourcestring : *const super::super::super::Win32::System::Kernel:: STRING, allocatedestinationstring : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlUTF8StringToUnicodeString(destinationstring as _, sourcestring, allocatedestinationstring) }
}
#[inline]
pub unsafe fn RtlUTF8ToUnicodeN(unicodestringdestination: windows_core::PWSTR, unicodestringmaxbytecount: u32, unicodestringactualbytecount: *mut u32, utf8stringsource: &[u8]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlUTF8ToUnicodeN(unicodestringdestination : windows_core::PWSTR, unicodestringmaxbytecount : u32, unicodestringactualbytecount : *mut u32, utf8stringsource : windows_core::PCSTR, utf8stringbytecount : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlUTF8ToUnicodeN(core::mem::transmute(unicodestringdestination), unicodestringmaxbytecount, unicodestringactualbytecount as _, core::mem::transmute(utf8stringsource.as_ptr()), utf8stringsource.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn RtlUnicodeStringToInt64(string: *const super::super::super::Win32::Foundation::UNICODE_STRING, base: Option<u32>, number: *mut i64, endpointer: Option<*mut windows_core::PWSTR>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlUnicodeStringToInt64(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, base : u32, number : *mut i64, endpointer : *mut windows_core::PWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlUnicodeStringToInt64(string, base.unwrap_or(core::mem::zeroed()) as _, number as _, endpointer.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn RtlUnicodeStringToInteger(string: *const super::super::super::Win32::Foundation::UNICODE_STRING, base: Option<u32>, value: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlUnicodeStringToInteger(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, base : u32, value : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlUnicodeStringToInteger(string, base.unwrap_or(core::mem::zeroed()) as _, value as _) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlUnicodeStringToUTF8String(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: *const super::super::super::Win32::Foundation::UNICODE_STRING, allocatedestinationstring: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlUnicodeStringToUTF8String(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, allocatedestinationstring : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlUnicodeStringToUTF8String(destinationstring as _, sourcestring, allocatedestinationstring) }
}
#[inline]
pub unsafe fn RtlUnicodeToUTF8N(utf8stringdestination: &mut [u8], utf8stringactualbytecount: *mut u32, unicodestringsource: *const u16, unicodestringbytecount: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlUnicodeToUTF8N(utf8stringdestination : windows_core::PSTR, utf8stringmaxbytecount : u32, utf8stringactualbytecount : *mut u32, unicodestringsource : *const u16, unicodestringbytecount : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlUnicodeToUTF8N(core::mem::transmute(utf8stringdestination.as_ptr()), utf8stringdestination.len().try_into().unwrap(), utf8stringactualbytecount as _, unicodestringsource, unicodestringbytecount) }
}
#[inline]
pub unsafe fn RtlUpcaseUnicodeChar(sourcecharacter: u16) -> u16 {
    windows_link::link!("ntdll.dll" "system" fn RtlUpcaseUnicodeChar(sourcecharacter : u16) -> u16);
    unsafe { RtlUpcaseUnicodeChar(sourcecharacter) }
}
#[inline]
pub unsafe fn RtlUpcaseUnicodeString(destinationstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING, sourcestring: *const super::super::super::Win32::Foundation::UNICODE_STRING, allocatedestinationstring: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlUpcaseUnicodeString(destinationstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, sourcestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, allocatedestinationstring : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlUpcaseUnicodeString(destinationstring as _, sourcestring, allocatedestinationstring) }
}
#[inline]
pub unsafe fn RtlUpperChar(character: i8) -> i8 {
    windows_link::link!("ntdll.dll" "system" fn RtlUpperChar(character : i8) -> i8);
    unsafe { RtlUpperChar(character) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlUpperString(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: *const super::super::super::Win32::System::Kernel::STRING) {
    windows_link::link!("ntdll.dll" "system" fn RtlUpperString(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const super::super::super::Win32::System::Kernel:: STRING));
    unsafe { RtlUpperString(destinationstring as _, sourcestring) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlValidRelativeSecurityDescriptor(securitydescriptorinput: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, securitydescriptorlength: u32, requiredinformation: u32) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlValidRelativeSecurityDescriptor(securitydescriptorinput : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, securitydescriptorlength : u32, requiredinformation : u32) -> bool);
    unsafe { RtlValidRelativeSecurityDescriptor(securitydescriptorinput, securitydescriptorlength, requiredinformation) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlValidSecurityDescriptor(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR) -> bool {
    windows_link::link!("ntdll.dll" "system" fn RtlValidSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> bool);
    unsafe { RtlValidSecurityDescriptor(securitydescriptor) }
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn RtlVerifyVersionInfo(versioninfo: *const super::super::super::Win32::System::SystemInformation::OSVERSIONINFOEXW, typemask: u32, conditionmask: u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn RtlVerifyVersionInfo(versioninfo : *const super::super::super::Win32::System::SystemInformation:: OSVERSIONINFOEXW, typemask : u32, conditionmask : u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlVerifyVersionInfo(versioninfo, typemask, conditionmask) }
}
#[inline]
pub unsafe fn RtlVolumeDeviceToDosName(volumedeviceobject: *const core::ffi::c_void, dosname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn RtlVolumeDeviceToDosName(volumedeviceobject : *const core::ffi::c_void, dosname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlVolumeDeviceToDosName(volumedeviceobject, dosname as _) }
}
#[inline]
pub unsafe fn RtlWalkFrameChain(callers: *mut *mut core::ffi::c_void, count: u32, flags: u32) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlWalkFrameChain(callers : *mut *mut core::ffi::c_void, count : u32, flags : u32) -> u32);
    unsafe { RtlWalkFrameChain(callers as _, count, flags) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlWeaklyEnumerateEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    windows_link::link!("ntdll.dll" "system" fn RtlWeaklyEnumerateEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    unsafe { RtlWeaklyEnumerateEntryHashTable(hashtable, enumerator as _) }
}
#[inline]
pub unsafe fn RtlWriteRegistryValue<P1, P2>(relativeto: u32, path: P1, valuename: P2, valuetype: u32, valuedata: Option<*const core::ffi::c_void>, valuelength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn RtlWriteRegistryValue(relativeto : u32, path : windows_core::PCWSTR, valuename : windows_core::PCWSTR, valuetype : u32, valuedata : *const core::ffi::c_void, valuelength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { RtlWriteRegistryValue(relativeto, path.param().abi(), valuename.param().abi(), valuetype, valuedata.unwrap_or(core::mem::zeroed()) as _, valuelength) }
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlxAnsiStringToUnicodeSize(ansistring: *const super::super::super::Win32::System::Kernel::STRING) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlxAnsiStringToUnicodeSize(ansistring : *const super::super::super::Win32::System::Kernel:: STRING) -> u32);
    unsafe { RtlxAnsiStringToUnicodeSize(ansistring) }
}
#[inline]
pub unsafe fn RtlxUnicodeStringToAnsiSize(unicodestring: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> u32 {
    windows_link::link!("ntdll.dll" "system" fn RtlxUnicodeStringToAnsiSize(unicodestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> u32);
    unsafe { RtlxUnicodeStringToAnsiSize(unicodestring) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeAccessCheck(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, subjectsecuritycontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT, subjectcontextlocked: bool, desiredaccess: u32, previouslygrantedaccess: u32, privileges: Option<*mut *mut super::super::super::Win32::Security::PRIVILEGE_SET>, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING, accessmode: i8, grantedaccess: *mut u32, accessstatus: *mut i32) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn SeAccessCheck(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, subjectsecuritycontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT, subjectcontextlocked : bool, desiredaccess : u32, previouslygrantedaccess : u32, privileges : *mut *mut super::super::super::Win32::Security:: PRIVILEGE_SET, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING, accessmode : i8, grantedaccess : *mut u32, accessstatus : *mut i32) -> bool);
    unsafe { SeAccessCheck(securitydescriptor, subjectsecuritycontext, subjectcontextlocked, desiredaccess, previouslygrantedaccess, privileges.unwrap_or(core::mem::zeroed()) as _, genericmapping, accessmode, grantedaccess as _, accessstatus as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeAssignSecurity(parentdescriptor: Option<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, explicitdescriptor: Option<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, newdescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, isdirectoryobject: bool, subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING, pooltype: super::super::Foundation::POOL_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn SeAssignSecurity(parentdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, explicitdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, newdescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, isdirectoryobject : bool, subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING, pooltype : super::super::Foundation:: POOL_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { SeAssignSecurity(parentdescriptor.unwrap_or(core::mem::zeroed()) as _, explicitdescriptor.unwrap_or(core::mem::zeroed()) as _, newdescriptor as _, isdirectoryobject, subjectcontext, genericmapping, pooltype) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeAssignSecurityEx(parentdescriptor: Option<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, explicitdescriptor: Option<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, newdescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, objecttype: Option<*const windows_core::GUID>, isdirectoryobject: bool, autoinheritflags: u32, subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING, pooltype: super::super::Foundation::POOL_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn SeAssignSecurityEx(parentdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, explicitdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, newdescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, objecttype : *const windows_core::GUID, isdirectoryobject : bool, autoinheritflags : u32, subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING, pooltype : super::super::Foundation:: POOL_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { SeAssignSecurityEx(parentdescriptor.unwrap_or(core::mem::zeroed()) as _, explicitdescriptor.unwrap_or(core::mem::zeroed()) as _, newdescriptor as _, objecttype.unwrap_or(core::mem::zeroed()) as _, isdirectoryobject, autoinheritflags, subjectcontext, genericmapping, pooltype) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeCaptureSubjectContext() -> super::super::Foundation::SECURITY_SUBJECT_CONTEXT {
    windows_link::link!("ntoskrnl.exe" "system" fn SeCaptureSubjectContext(subjectcontext : *mut super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    unsafe {
        let mut result__ = core::mem::zeroed();
        SeCaptureSubjectContext(&mut result__);
        result__
    }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SeComputeAutoInheritByObjectType(objecttype: *const core::ffi::c_void, securitydescriptor: Option<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, parentsecuritydescriptor: Option<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>) -> u32 {
    windows_link::link!("ntoskrnl.exe" "system" fn SeComputeAutoInheritByObjectType(objecttype : *const core::ffi::c_void, securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, parentsecuritydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> u32);
    unsafe { SeComputeAutoInheritByObjectType(objecttype, securitydescriptor.unwrap_or(core::mem::zeroed()) as _, parentsecuritydescriptor.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SeDeassignSecurity(securitydescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn SeDeassignSecurity(securitydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { SeDeassignSecurity(securitydescriptor as _) }
}
#[inline]
pub unsafe fn SeEtwWriteKMCveEvent(cveid: *const super::super::super::Win32::Foundation::UNICODE_STRING, additionaldetails: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn SeEtwWriteKMCveEvent(cveid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, additionaldetails : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { SeEtwWriteKMCveEvent(cveid, additionaldetails.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeLockSubjectContext(subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT) {
    windows_link::link!("ntoskrnl.exe" "system" fn SeLockSubjectContext(subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    unsafe { SeLockSubjectContext(subjectcontext) }
}
#[inline]
pub unsafe fn SeRegisterImageVerificationCallback(imagetype: SE_IMAGE_TYPE, callbacktype: SE_IMAGE_VERIFICATION_CALLBACK_TYPE, callbackfunction: PSE_IMAGE_VERIFICATION_CALLBACK_FUNCTION, callbackcontext: Option<*const core::ffi::c_void>, token: Option<*const core::ffi::c_void>, callbackhandle: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn SeRegisterImageVerificationCallback(imagetype : SE_IMAGE_TYPE, callbacktype : SE_IMAGE_VERIFICATION_CALLBACK_TYPE, callbackfunction : PSE_IMAGE_VERIFICATION_CALLBACK_FUNCTION, callbackcontext : *const core::ffi::c_void, token : *const core::ffi::c_void, callbackhandle : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { SeRegisterImageVerificationCallback(imagetype, callbacktype, callbackfunction, callbackcontext.unwrap_or(core::mem::zeroed()) as _, token.unwrap_or(core::mem::zeroed()) as _, callbackhandle as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeReleaseSubjectContext(subjectcontext: *mut super::super::Foundation::SECURITY_SUBJECT_CONTEXT) {
    windows_link::link!("ntoskrnl.exe" "system" fn SeReleaseSubjectContext(subjectcontext : *mut super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    unsafe { SeReleaseSubjectContext(subjectcontext as _) }
}
#[cfg(feature = "Win32_Security_Authentication_Identity")]
#[inline]
pub unsafe fn SeReportSecurityEvent(flags: u32, sourcename: *const super::super::super::Win32::Foundation::UNICODE_STRING, usersid: Option<super::super::super::Win32::Security::PSID>, auditparameters: *const super::super::super::Win32::Security::Authentication::Identity::SE_ADT_PARAMETER_ARRAY) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn SeReportSecurityEvent(flags : u32, sourcename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, usersid : super::super::super::Win32::Security:: PSID, auditparameters : *const super::super::super::Win32::Security::Authentication::Identity:: SE_ADT_PARAMETER_ARRAY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { SeReportSecurityEvent(flags, sourcename, usersid.unwrap_or(core::mem::zeroed()) as _, auditparameters) }
}
#[cfg(feature = "Win32_Security_Authentication_Identity")]
#[inline]
pub unsafe fn SeSetAuditParameter(auditparameters: *mut super::super::super::Win32::Security::Authentication::Identity::SE_ADT_PARAMETER_ARRAY, r#type: super::super::super::Win32::Security::Authentication::Identity::SE_ADT_PARAMETER_TYPE, index: u32, data: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn SeSetAuditParameter(auditparameters : *mut super::super::super::Win32::Security::Authentication::Identity:: SE_ADT_PARAMETER_ARRAY, r#type : super::super::super::Win32::Security::Authentication::Identity:: SE_ADT_PARAMETER_TYPE, index : u32, data : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { SeSetAuditParameter(auditparameters as _, r#type, index, data) }
}
#[inline]
pub unsafe fn SeSinglePrivilegeCheck(privilegevalue: super::super::super::Win32::Foundation::LUID, previousmode: i8) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn SeSinglePrivilegeCheck(privilegevalue : super::super::super::Win32::Foundation:: LUID, previousmode : i8) -> bool);
    unsafe { SeSinglePrivilegeCheck(core::mem::transmute(privilegevalue), previousmode) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeUnlockSubjectContext(subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT) {
    windows_link::link!("ntoskrnl.exe" "system" fn SeUnlockSubjectContext(subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    unsafe { SeUnlockSubjectContext(subjectcontext) }
}
#[inline]
pub unsafe fn SeUnregisterImageVerificationCallback(callbackhandle: *const core::ffi::c_void) {
    windows_link::link!("ntoskrnl.exe" "system" fn SeUnregisterImageVerificationCallback(callbackhandle : *const core::ffi::c_void));
    unsafe { SeUnregisterImageVerificationCallback(callbackhandle) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SeValidSecurityDescriptor(length: u32, securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn SeValidSecurityDescriptor(length : u32, securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> bool);
    unsafe { SeValidSecurityDescriptor(length, securitydescriptor) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmCommitComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmCommitComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmCommitComplete(enlistment, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmCommitEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmCommitEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmCommitEnlistment(enlistment, tmvirtualclock) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmCommitTransaction(transaction: *const super::super::Foundation::KTRANSACTION, wait: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmCommitTransaction(transaction : *const super::super::Foundation:: KTRANSACTION, wait : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmCommitTransaction(transaction, wait) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn TmCreateEnlistment(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, previousmode: i8, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, resourcemanager: *const isize, transaction: *const super::super::Foundation::KTRANSACTION, createoptions: Option<u32>, notificationmask: u32, enlistmentkey: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmCreateEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, previousmode : i8, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, resourcemanager : *const isize, transaction : *const super::super::Foundation:: KTRANSACTION, createoptions : u32, notificationmask : u32, enlistmentkey : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmCreateEnlistment(enlistmenthandle as _, previousmode, desiredaccess, objectattributes, resourcemanager, transaction, createoptions.unwrap_or(core::mem::zeroed()) as _, notificationmask, enlistmentkey.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmDereferenceEnlistmentKey(enlistment: *const super::super::Foundation::KENLISTMENT, lastreference: Option<*mut bool>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmDereferenceEnlistmentKey(enlistment : *const super::super::Foundation:: KENLISTMENT, lastreference : *mut bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmDereferenceEnlistmentKey(enlistment, lastreference.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmEnableCallbacks(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER, callbackroutine: PTM_RM_NOTIFICATION, rmkey: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmEnableCallbacks(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER, callbackroutine : PTM_RM_NOTIFICATION, rmkey : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmEnableCallbacks(resourcemanager, callbackroutine, rmkey.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmGetTransactionId(transaction: *const super::super::Foundation::KTRANSACTION) -> windows_core::GUID {
    windows_link::link!("ntoskrnl.exe" "system" fn TmGetTransactionId(transaction : *const super::super::Foundation:: KTRANSACTION, transactionid : *mut windows_core::GUID));
    unsafe {
        let mut result__ = core::mem::zeroed();
        TmGetTransactionId(transaction, &mut result__);
        result__
    }
}
#[inline]
pub unsafe fn TmInitializeTransactionManager(transactionmanager: *const isize, logfilename: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, tmid: Option<*const windows_core::GUID>, createoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmInitializeTransactionManager(transactionmanager : *const isize, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, tmid : *const windows_core::GUID, createoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmInitializeTransactionManager(transactionmanager, logfilename.unwrap_or(core::mem::zeroed()) as _, tmid.unwrap_or(core::mem::zeroed()) as _, createoptions) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmIsTransactionActive(transaction: *const super::super::Foundation::KTRANSACTION) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn TmIsTransactionActive(transaction : *const super::super::Foundation:: KTRANSACTION) -> bool);
    unsafe { TmIsTransactionActive(transaction) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrePrepareComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmPrePrepareComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmPrePrepareComplete(enlistment, tmvirtualclock) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrePrepareEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmPrePrepareEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmPrePrepareEnlistment(enlistment, tmvirtualclock) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrepareComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmPrepareComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmPrepareComplete(enlistment, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrepareEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmPrepareEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmPrepareEnlistment(enlistment, tmvirtualclock) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPropagationComplete(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER, requestcookie: u32, bufferlength: u32, buffer: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmPropagationComplete(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER, requestcookie : u32, bufferlength : u32, buffer : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmPropagationComplete(resourcemanager, requestcookie, bufferlength, buffer) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPropagationFailed(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER, requestcookie: u32, status: super::super::super::Win32::Foundation::NTSTATUS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmPropagationFailed(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER, requestcookie : u32, status : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmPropagationFailed(resourcemanager, requestcookie, status) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmReadOnlyEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmReadOnlyEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmReadOnlyEnlistment(enlistment, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRecoverEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, enlistmentkey: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRecoverEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, enlistmentkey : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRecoverEnlistment(enlistment, enlistmentkey) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRecoverResourceManager(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRecoverResourceManager(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRecoverResourceManager(resourcemanager) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRecoverTransactionManager(tm: *const super::super::Foundation::KTM, targetvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRecoverTransactionManager(tm : *const super::super::Foundation:: KTM, targetvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRecoverTransactionManager(tm, targetvirtualclock) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmReferenceEnlistmentKey(enlistment: *const super::super::Foundation::KENLISTMENT, key: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmReferenceEnlistmentKey(enlistment : *const super::super::Foundation:: KENLISTMENT, key : *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmReferenceEnlistmentKey(enlistment, key as _) }
}
#[inline]
pub unsafe fn TmRenameTransactionManager(logfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, existingtransactionmanagerguid: *const windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRenameTransactionManager(logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, existingtransactionmanagerguid : *const windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRenameTransactionManager(logfilename, existingtransactionmanagerguid) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRequestOutcomeEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRequestOutcomeEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRequestOutcomeEnlistment(enlistment, tmvirtualclock) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRollbackComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRollbackComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRollbackComplete(enlistment, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRollbackEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRollbackEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRollbackEnlistment(enlistment, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRollbackTransaction(transaction: *const super::super::Foundation::KTRANSACTION, wait: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmRollbackTransaction(transaction : *const super::super::Foundation:: KTRANSACTION, wait : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmRollbackTransaction(transaction, wait) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmSinglePhaseReject(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn TmSinglePhaseReject(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { TmSinglePhaseReject(enlistment, tmvirtualclock) }
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn VslCreateSecureSection(handle: *mut super::super::super::Win32::Foundation::HANDLE, targetprocess: super::super::Foundation::PEPROCESS, mdl: *const super::super::Foundation::MDL, devicepageprotection: u32, attributes: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn VslCreateSecureSection(handle : *mut super::super::super::Win32::Foundation:: HANDLE, targetprocess : super::super::Foundation:: PEPROCESS, mdl : *const super::super::Foundation:: MDL, devicepageprotection : u32, attributes : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { VslCreateSecureSection(handle as _, targetprocess, mdl, devicepageprotection, attributes) }
}
#[inline]
pub unsafe fn VslDeleteSecureSection(globalhandle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn VslDeleteSecureSection(globalhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { VslDeleteSecureSection(globalhandle) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddErrorSource(errorsource: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_DESCRIPTOR, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaAddErrorSource(errorsource : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_DESCRIPTOR, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaAddErrorSource(errorsource, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddErrorSourceDeviceDriver(context: Option<*mut core::ffi::c_void>, configuration: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numberpreallocatederrorreports: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaAddErrorSourceDeviceDriver(context : *mut core::ffi::c_void, configuration : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numberpreallocatederrorreports : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaAddErrorSourceDeviceDriver(context.unwrap_or(core::mem::zeroed()) as _, configuration, numberpreallocatederrorreports) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddErrorSourceDeviceDriverV1(context: Option<*mut core::ffi::c_void>, configuration: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numbufferstopreallocate: u32, maxdatalength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaAddErrorSourceDeviceDriverV1(context : *mut core::ffi::c_void, configuration : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numbufferstopreallocate : u32, maxdatalength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaAddErrorSourceDeviceDriverV1(context.unwrap_or(core::mem::zeroed()) as _, configuration, numbufferstopreallocate, maxdatalength) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddHwErrorReportSectionDeviceDriver(errorhandle: *const core::ffi::c_void, sectiondatalength: u32, bufferset: *mut super::super::super::Win32::System::Diagnostics::Debug::WHEA_DRIVER_BUFFER_SET) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaAddHwErrorReportSectionDeviceDriver(errorhandle : *const core::ffi::c_void, sectiondatalength : u32, bufferset : *mut super::super::super::Win32::System::Diagnostics::Debug:: WHEA_DRIVER_BUFFER_SET) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaAddHwErrorReportSectionDeviceDriver(errorhandle, sectiondatalength, bufferset as _) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaConfigureErrorSource(sourcetype: super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_TYPE, configuration: *const WHEA_ERROR_SOURCE_CONFIGURATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaConfigureErrorSource(sourcetype : super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_TYPE, configuration : *const WHEA_ERROR_SOURCE_CONFIGURATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaConfigureErrorSource(sourcetype, configuration) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn WheaCreateHwErrorReportDeviceDriver(errorsourceid: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> *mut core::ffi::c_void {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaCreateHwErrorReportDeviceDriver(errorsourceid : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> *mut core::ffi::c_void);
    unsafe { WheaCreateHwErrorReportDeviceDriver(errorsourceid, deviceobject) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaErrorSourceGetState(errorsourceid: u32) -> super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_STATE {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaErrorSourceGetState(errorsourceid : u32) -> super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_STATE);
    unsafe { WheaErrorSourceGetState(errorsourceid) }
}
#[inline]
pub unsafe fn WheaGetNotifyAllOfflinesPolicy() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaGetNotifyAllOfflinesPolicy() -> bool);
    unsafe { WheaGetNotifyAllOfflinesPolicy() }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaHighIrqlLogSelEventHandlerRegister(handler: PFN_WHEA_HIGH_IRQL_LOG_SEL_EVENT_HANDLER, context: *const core::ffi::c_void) -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaHighIrqlLogSelEventHandlerRegister(handler : PFN_WHEA_HIGH_IRQL_LOG_SEL_EVENT_HANDLER, context : *const core::ffi::c_void) -> bool);
    unsafe { WheaHighIrqlLogSelEventHandlerRegister(handler, context) }
}
#[inline]
pub unsafe fn WheaHighIrqlLogSelEventHandlerUnregister() {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaHighIrqlLogSelEventHandlerUnregister());
    unsafe { WheaHighIrqlLogSelEventHandlerUnregister() }
}
#[inline]
pub unsafe fn WheaHwErrorReportAbandonDeviceDriver(errorhandle: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportAbandonDeviceDriver(errorhandle : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaHwErrorReportAbandonDeviceDriver(errorhandle) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaHwErrorReportSetSectionNameDeviceDriver(bufferset: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_DRIVER_BUFFER_SET, name: &[u8]) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportSetSectionNameDeviceDriver(bufferset : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_DRIVER_BUFFER_SET, namelength : u32, name : *const u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaHwErrorReportSetSectionNameDeviceDriver(bufferset, name.len().try_into().unwrap(), core::mem::transmute(name.as_ptr())) }
}
#[inline]
pub unsafe fn WheaHwErrorReportSetSeverityDeviceDriver(errorhandle: *const core::ffi::c_void, errorseverity: WHEA_ERROR_SEVERITY) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportSetSeverityDeviceDriver(errorhandle : *const core::ffi::c_void, errorseverity : WHEA_ERROR_SEVERITY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaHwErrorReportSetSeverityDeviceDriver(errorhandle, errorseverity) }
}
#[inline]
pub unsafe fn WheaHwErrorReportSubmitDeviceDriver(errorhandle: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportSubmitDeviceDriver(errorhandle : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaHwErrorReportSubmitDeviceDriver(errorhandle) }
}
#[inline]
pub unsafe fn WheaInitializeRecordHeader(header: *mut WHEA_ERROR_RECORD_HEADER) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaInitializeRecordHeader(header : *mut WHEA_ERROR_RECORD_HEADER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaInitializeRecordHeader(header as _) }
}
#[inline]
pub unsafe fn WheaIsCriticalState() -> bool {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaIsCriticalState() -> bool);
    unsafe { WheaIsCriticalState() }
}
#[inline]
pub unsafe fn WheaLogInternalEvent(entry: *const WHEA_EVENT_LOG_ENTRY) {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaLogInternalEvent(entry : *const WHEA_EVENT_LOG_ENTRY));
    unsafe { WheaLogInternalEvent(entry) }
}
#[inline]
pub unsafe fn WheaRegisterInUsePageOfflineNotification(callback: PFN_IN_USE_PAGE_OFFLINE_NOTIFY, context: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaRegisterInUsePageOfflineNotification(callback : PFN_IN_USE_PAGE_OFFLINE_NOTIFY, context : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaRegisterInUsePageOfflineNotification(callback, context.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn WheaRemoveErrorSource(errorsourceid: u32) {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaRemoveErrorSource(errorsourceid : u32));
    unsafe { WheaRemoveErrorSource(errorsourceid) }
}
#[inline]
pub unsafe fn WheaRemoveErrorSourceDeviceDriver(errorsourceid: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaRemoveErrorSourceDeviceDriver(errorsourceid : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaRemoveErrorSourceDeviceDriver(errorsourceid) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaReportHwError(errorpacket: *mut WHEA_ERROR_PACKET_V2) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaReportHwError(errorpacket : *mut WHEA_ERROR_PACKET_V2) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaReportHwError(errorpacket as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn WheaReportHwErrorDeviceDriver<P6>(errorsourceid: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, errordata: &[u8], sectiontypeguid: *const windows_core::GUID, errorseverity: WHEA_ERROR_SEVERITY, devicefriendlyname: P6) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P6: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntoskrnl.exe" "system" fn WheaReportHwErrorDeviceDriver(errorsourceid : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, errordata : *const u8, errordatalength : u32, sectiontypeguid : *const windows_core::GUID, errorseverity : WHEA_ERROR_SEVERITY, devicefriendlyname : windows_core::PCSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaReportHwErrorDeviceDriver(errorsourceid, deviceobject, core::mem::transmute(errordata.as_ptr()), errordata.len().try_into().unwrap(), sectiontypeguid, errorseverity, devicefriendlyname.param().abi()) }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaUnconfigureErrorSource(sourcetype: super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaUnconfigureErrorSource(sourcetype : super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaUnconfigureErrorSource(sourcetype) }
}
#[inline]
pub unsafe fn WheaUnregisterInUsePageOfflineNotification(callback: PFN_IN_USE_PAGE_OFFLINE_NOTIFY) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WheaUnregisterInUsePageOfflineNotification(callback : PFN_IN_USE_PAGE_OFFLINE_NOTIFY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WheaUnregisterInUsePageOfflineNotification(callback) }
}
#[inline]
pub unsafe fn WmiQueryTraceInformation(traceinformationclass: TRACE_INFORMATION_CLASS, traceinformation: *mut core::ffi::c_void, traceinformationlength: u32, requiredlength: Option<*mut u32>, buffer: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntoskrnl.exe" "system" fn WmiQueryTraceInformation(traceinformationclass : TRACE_INFORMATION_CLASS, traceinformation : *mut core::ffi::c_void, traceinformationlength : u32, requiredlength : *mut u32, buffer : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { WmiQueryTraceInformation(traceinformationclass, traceinformation as _, traceinformationlength, requiredlength.unwrap_or(core::mem::zeroed()) as _, buffer.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwAllocateLocallyUniqueId(luid: *mut super::super::super::Win32::Foundation::LUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwAllocateLocallyUniqueId(luid : *mut super::super::super::Win32::Foundation:: LUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwAllocateLocallyUniqueId(luid as _) }
}
#[inline]
pub unsafe fn ZwClose(handle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwClose(handle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwClose(handle) }
}
#[inline]
pub unsafe fn ZwCommitComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCommitComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCommitComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwCommitEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCommitEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCommitEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwCommitTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, wait: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCommitTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCommitTransaction(transactionhandle, wait) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwCreateEnlistment(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, transactionhandle: super::super::super::Win32::Foundation::HANDLE, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: Option<u32>, notificationmask: u32, enlistmentkey: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCreateEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionhandle : super::super::super::Win32::Foundation:: HANDLE, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, notificationmask : u32, enlistmentkey : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCreateEnlistment(enlistmenthandle as _, desiredaccess, resourcemanagerhandle, transactionhandle, objectattributes.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, notificationmask, enlistmentkey.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwCreateFile(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: Option<*const i64>, fileattributes: u32, shareaccess: u32, createdisposition: u32, createoptions: u32, eabuffer: Option<*const core::ffi::c_void>, ealength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCreateFile(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, createdisposition : u32, createoptions : u32, eabuffer : *const core::ffi::c_void, ealength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCreateFile(filehandle as _, desiredaccess, objectattributes, iostatusblock as _, allocationsize.unwrap_or(core::mem::zeroed()) as _, fileattributes, shareaccess, createdisposition, createoptions, eabuffer.unwrap_or(core::mem::zeroed()) as _, ealength) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwCreateResourceManager(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: super::super::super::Win32::Foundation::HANDLE, resourcemanagerguid: Option<*const windows_core::GUID>, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: Option<u32>, description: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCreateResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerguid : *const windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCreateResourceManager(resourcemanagerhandle as _, desiredaccess, tmhandle, resourcemanagerguid.unwrap_or(core::mem::zeroed()) as _, objectattributes.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, description.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwCreateSection(sectionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, maximumsize: Option<*const i64>, sectionpageprotection: u32, allocationattributes: u32, filehandle: Option<super::super::super::Win32::Foundation::HANDLE>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCreateSection(sectionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, maximumsize : *const i64, sectionpageprotection : u32, allocationattributes : u32, filehandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCreateSection(sectionhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, maximumsize.unwrap_or(core::mem::zeroed()) as _, sectionpageprotection, allocationattributes, filehandle.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwCreateTransaction(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, uow: Option<*const windows_core::GUID>, tmhandle: Option<super::super::super::Win32::Foundation::HANDLE>, createoptions: Option<u32>, isolationlevel: Option<u32>, isolationflags: Option<u32>, timeout: Option<*const i64>, description: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCreateTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE, createoptions : u32, isolationlevel : u32, isolationflags : u32, timeout : *const i64, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCreateTransaction(transactionhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, uow.unwrap_or(core::mem::zeroed()) as _, tmhandle.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, isolationlevel.unwrap_or(core::mem::zeroed()) as _, isolationflags.unwrap_or(core::mem::zeroed()) as _, timeout.unwrap_or(core::mem::zeroed()) as _, description.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwCreateTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, createoptions: Option<u32>, commitstrength: Option<u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwCreateTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, createoptions : u32, commitstrength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwCreateTransactionManager(tmhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, logfilename.unwrap_or(core::mem::zeroed()) as _, createoptions.unwrap_or(core::mem::zeroed()) as _, commitstrength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_IO")]
#[inline]
pub unsafe fn ZwDeviceIoControlFile(filehandle: super::super::super::Win32::Foundation::HANDLE, event: Option<super::super::super::Win32::Foundation::HANDLE>, apcroutine: super::super::super::Win32::System::IO::PIO_APC_ROUTINE, apccontext: Option<*const core::ffi::c_void>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, iocontrolcode: u32, inputbuffer: Option<*const core::ffi::c_void>, inputbufferlength: u32, outputbuffer: Option<*mut core::ffi::c_void>, outputbufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwDeviceIoControlFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, event : super::super::super::Win32::Foundation:: HANDLE, apcroutine : super::super::super::Win32::System::IO:: PIO_APC_ROUTINE, apccontext : *const core::ffi::c_void, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, iocontrolcode : u32, inputbuffer : *const core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut core::ffi::c_void, outputbufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwDeviceIoControlFile(filehandle, event.unwrap_or(core::mem::zeroed()) as _, apcroutine, apccontext.unwrap_or(core::mem::zeroed()) as _, iostatusblock as _, iocontrolcode, inputbuffer.unwrap_or(core::mem::zeroed()) as _, inputbufferlength, outputbuffer.unwrap_or(core::mem::zeroed()) as _, outputbufferlength) }
}
#[inline]
pub unsafe fn ZwDisplayString(string: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwDisplayString(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwDisplayString(string) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwEnumerateTransactionObject(rootobjecthandle: Option<super::super::super::Win32::Foundation::HANDLE>, querytype: super::super::super::Win32::System::SystemServices::KTMOBJECT_TYPE, objectcursor: *mut super::super::super::Win32::System::SystemServices::KTMOBJECT_CURSOR, objectcursorlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwEnumerateTransactionObject(rootobjecthandle : super::super::super::Win32::Foundation:: HANDLE, querytype : super::super::super::Win32::System::SystemServices:: KTMOBJECT_TYPE, objectcursor : *mut super::super::super::Win32::System::SystemServices:: KTMOBJECT_CURSOR, objectcursorlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwEnumerateTransactionObject(rootobjecthandle.unwrap_or(core::mem::zeroed()) as _, querytype, objectcursor as _, objectcursorlength, returnlength as _) }
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ZwGetNotificationResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, transactionnotification: *mut super::super::super::Win32::Storage::FileSystem::TRANSACTION_NOTIFICATION, notificationlength: u32, timeout: *const i64, returnlength: Option<*mut u32>, asynchronous: u32, asynchronouscontext: Option<usize>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwGetNotificationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionnotification : *mut super::super::super::Win32::Storage::FileSystem:: TRANSACTION_NOTIFICATION, notificationlength : u32, timeout : *const i64, returnlength : *mut u32, asynchronous : u32, asynchronouscontext : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwGetNotificationResourceManager(resourcemanagerhandle, transactionnotification as _, notificationlength, timeout, returnlength.unwrap_or(core::mem::zeroed()) as _, asynchronous, asynchronouscontext.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwLoadDriver(driverservicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwLoadDriver(driverservicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwLoadDriver(driverservicename) }
}
#[inline]
pub unsafe fn ZwMakeTemporaryObject(handle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwMakeTemporaryObject(handle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwMakeTemporaryObject(handle) }
}
#[inline]
pub unsafe fn ZwManagePartition(targethandle: super::super::super::Win32::Foundation::HANDLE, sourcehandle: Option<super::super::super::Win32::Foundation::HANDLE>, partitioninformationclass: PARTITION_INFORMATION_CLASS, partitioninformation: *mut core::ffi::c_void, partitioninformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwManagePartition(targethandle : super::super::super::Win32::Foundation:: HANDLE, sourcehandle : super::super::super::Win32::Foundation:: HANDLE, partitioninformationclass : PARTITION_INFORMATION_CLASS, partitioninformation : *mut core::ffi::c_void, partitioninformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwManagePartition(targethandle, sourcehandle.unwrap_or(core::mem::zeroed()) as _, partitioninformationclass, partitioninformation as _, partitioninformationlength) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwOpenEnlistment(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, rmhandle: super::super::super::Win32::Foundation::HANDLE, enlistmentguid: *const windows_core::GUID, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwOpenEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, rmhandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentguid : *const windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwOpenEnlistment(enlistmenthandle as _, desiredaccess, rmhandle, enlistmentguid, objectattributes.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwOpenFile(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, shareaccess: u32, openoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwOpenFile(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, shareaccess : u32, openoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwOpenFile(filehandle as _, desiredaccess, objectattributes, iostatusblock as _, shareaccess, openoptions) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwOpenResourceManager(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: super::super::super::Win32::Foundation::HANDLE, resourcemanagerguid: *const windows_core::GUID, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwOpenResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerguid : *const windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwOpenResourceManager(resourcemanagerhandle as _, desiredaccess, tmhandle, resourcemanagerguid, objectattributes.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwOpenSymbolicLinkObject(linkhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwOpenSymbolicLinkObject(linkhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwOpenSymbolicLinkObject(linkhandle as _, desiredaccess, objectattributes) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwOpenTransaction(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, uow: *const windows_core::GUID, tmhandle: Option<super::super::super::Win32::Foundation::HANDLE>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwOpenTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwOpenTransaction(transactionhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, uow, tmhandle.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn ZwOpenTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, tmidentity: Option<*const windows_core::GUID>, openoptions: Option<u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwOpenTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, tmidentity : *const windows_core::GUID, openoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwOpenTransactionManager(tmhandle as _, desiredaccess, objectattributes.unwrap_or(core::mem::zeroed()) as _, logfilename.unwrap_or(core::mem::zeroed()) as _, tmidentity.unwrap_or(core::mem::zeroed()) as _, openoptions.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn ZwPowerInformation(informationlevel: super::super::super::Win32::System::Power::POWER_INFORMATION_LEVEL, inputbuffer: Option<*const core::ffi::c_void>, inputbufferlength: u32, outputbuffer: Option<*mut core::ffi::c_void>, outputbufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwPowerInformation(informationlevel : super::super::super::Win32::System::Power:: POWER_INFORMATION_LEVEL, inputbuffer : *const core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut core::ffi::c_void, outputbufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwPowerInformation(informationlevel, inputbuffer.unwrap_or(core::mem::zeroed()) as _, inputbufferlength, outputbuffer.unwrap_or(core::mem::zeroed()) as _, outputbufferlength) }
}
#[inline]
pub unsafe fn ZwPrePrepareComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwPrePrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwPrePrepareComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwPrePrepareEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwPrePrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwPrePrepareEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwPrepareComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwPrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwPrepareComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwPrepareEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwPrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwPrepareEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwPropagationComplete(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, requestcookie: u32, bufferlength: u32, buffer: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwPropagationComplete(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, requestcookie : u32, bufferlength : u32, buffer : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwPropagationComplete(resourcemanagerhandle, requestcookie, bufferlength, buffer) }
}
#[inline]
pub unsafe fn ZwPropagationFailed(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, requestcookie: u32, propstatus: super::super::super::Win32::Foundation::NTSTATUS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwPropagationFailed(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, requestcookie : u32, propstatus : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwPropagationFailed(resourcemanagerhandle, requestcookie, propstatus) }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwQueryInformationByName(objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *mut core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwQueryInformationByName(objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *mut core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwQueryInformationByName(objectattributes, iostatusblock as _, fileinformation as _, length, fileinformationclass) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *mut core::ffi::c_void, enlistmentinformationlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwQueryInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *mut core::ffi::c_void, enlistmentinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwQueryInformationEnlistment(enlistmenthandle, enlistmentinformationclass, enlistmentinformation as _, enlistmentinformationlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Wdk_Storage_FileSystem", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwQueryInformationFile(filehandle: super::super::super::Win32::Foundation::HANDLE, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *mut core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwQueryInformationFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *mut core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwQueryInformationFile(filehandle, iostatusblock as _, fileinformation as _, length, fileinformationclass) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *mut core::ffi::c_void, resourcemanagerinformationlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwQueryInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *mut core::ffi::c_void, resourcemanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwQueryInformationResourceManager(resourcemanagerhandle, resourcemanagerinformationclass, resourcemanagerinformation as _, resourcemanagerinformationlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *mut core::ffi::c_void, transactioninformationlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwQueryInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *mut core::ffi::c_void, transactioninformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwQueryInformationTransaction(transactionhandle, transactioninformationclass, transactioninformation as _, transactioninformationlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationTransactionManager(transactionmanagerhandle: super::super::super::Win32::Foundation::HANDLE, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *mut core::ffi::c_void, transactionmanagerinformationlength: u32, returnlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwQueryInformationTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *mut core::ffi::c_void, transactionmanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwQueryInformationTransactionManager(transactionmanagerhandle, transactionmanagerinformationclass, transactionmanagerinformation as _, transactionmanagerinformationlength, returnlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwQuerySymbolicLinkObject(linkhandle: super::super::super::Win32::Foundation::HANDLE, linktarget: *mut super::super::super::Win32::Foundation::UNICODE_STRING, returnedlength: Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwQuerySymbolicLinkObject(linkhandle : super::super::super::Win32::Foundation:: HANDLE, linktarget : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, returnedlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwQuerySymbolicLinkObject(linkhandle, linktarget as _, returnedlength.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_IO")]
#[inline]
pub unsafe fn ZwReadFile(filehandle: super::super::super::Win32::Foundation::HANDLE, event: Option<super::super::super::Win32::Foundation::HANDLE>, apcroutine: super::super::super::Win32::System::IO::PIO_APC_ROUTINE, apccontext: Option<*const core::ffi::c_void>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, buffer: *mut core::ffi::c_void, length: u32, byteoffset: Option<*const i64>, key: Option<*const u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwReadFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, event : super::super::super::Win32::Foundation:: HANDLE, apcroutine : super::super::super::Win32::System::IO:: PIO_APC_ROUTINE, apccontext : *const core::ffi::c_void, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, buffer : *mut core::ffi::c_void, length : u32, byteoffset : *const i64, key : *const u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwReadFile(filehandle, event.unwrap_or(core::mem::zeroed()) as _, apcroutine, apccontext.unwrap_or(core::mem::zeroed()) as _, iostatusblock as _, buffer as _, length, byteoffset.unwrap_or(core::mem::zeroed()) as _, key.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwReadOnlyEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwReadOnlyEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwReadOnlyEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwRecoverEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, enlistmentkey: Option<*const core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRecoverEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentkey : *const core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRecoverEnlistment(enlistmenthandle, enlistmentkey.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwRecoverResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRecoverResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRecoverResourceManager(resourcemanagerhandle) }
}
#[inline]
pub unsafe fn ZwRecoverTransactionManager(transactionmanagerhandle: super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRecoverTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRecoverTransactionManager(transactionmanagerhandle) }
}
#[inline]
pub unsafe fn ZwRegisterProtocolAddressInformation(resourcemanager: super::super::super::Win32::Foundation::HANDLE, protocolid: *const windows_core::GUID, protocolinformationsize: u32, protocolinformation: *const core::ffi::c_void, createoptions: Option<u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRegisterProtocolAddressInformation(resourcemanager : super::super::super::Win32::Foundation:: HANDLE, protocolid : *const windows_core::GUID, protocolinformationsize : u32, protocolinformation : *const core::ffi::c_void, createoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRegisterProtocolAddressInformation(resourcemanager, protocolid, protocolinformationsize, protocolinformation, createoptions.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwRenameTransactionManager(logfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, existingtransactionmanagerguid: *const windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRenameTransactionManager(logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, existingtransactionmanagerguid : *const windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRenameTransactionManager(logfilename, existingtransactionmanagerguid) }
}
#[inline]
pub unsafe fn ZwRollbackComplete(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRollbackComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRollbackComplete(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwRollbackEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRollbackEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRollbackEnlistment(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwRollbackTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, wait: bool) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRollbackTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : bool) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRollbackTransaction(transactionhandle, wait) }
}
#[inline]
pub unsafe fn ZwRollforwardTransactionManager(transactionmanagerhandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwRollforwardTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwRollforwardTransactionManager(transactionmanagerhandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationEnlistment(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *const core::ffi::c_void, enlistmentinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwSetInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *const core::ffi::c_void, enlistmentinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwSetInformationEnlistment(enlistmenthandle, enlistmentinformationclass, enlistmentinformation, enlistmentinformationlength) }
}
#[cfg(all(feature = "Wdk_Storage_FileSystem", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwSetInformationFile(filehandle: super::super::super::Win32::Foundation::HANDLE, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *const core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwSetInformationFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *const core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwSetInformationFile(filehandle, iostatusblock as _, fileinformation, length, fileinformationclass) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationResourceManager(resourcemanagerhandle: super::super::super::Win32::Foundation::HANDLE, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *const core::ffi::c_void, resourcemanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwSetInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *const core::ffi::c_void, resourcemanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwSetInformationResourceManager(resourcemanagerhandle, resourcemanagerinformationclass, resourcemanagerinformation, resourcemanagerinformationlength) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationTransaction(transactionhandle: super::super::super::Win32::Foundation::HANDLE, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *const core::ffi::c_void, transactioninformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwSetInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *const core::ffi::c_void, transactioninformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwSetInformationTransaction(transactionhandle, transactioninformationclass, transactioninformation, transactioninformationlength) }
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationTransactionManager(tmhandle: super::super::super::Win32::Foundation::HANDLE, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *const core::ffi::c_void, transactionmanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwSetInformationTransactionManager(tmhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *const core::ffi::c_void, transactionmanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwSetInformationTransactionManager(tmhandle, transactionmanagerinformationclass, transactionmanagerinformation, transactionmanagerinformationlength) }
}
#[inline]
pub unsafe fn ZwSinglePhaseReject(enlistmenthandle: super::super::super::Win32::Foundation::HANDLE, tmvirtualclock: Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwSinglePhaseReject(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwSinglePhaseReject(enlistmenthandle, tmvirtualclock.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn ZwUnloadDriver(driverservicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwUnloadDriver(driverservicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwUnloadDriver(driverservicename) }
}
#[cfg(feature = "Win32_System_IO")]
#[inline]
pub unsafe fn ZwWriteFile(filehandle: super::super::super::Win32::Foundation::HANDLE, event: Option<super::super::super::Win32::Foundation::HANDLE>, apcroutine: super::super::super::Win32::System::IO::PIO_APC_ROUTINE, apccontext: Option<*const core::ffi::c_void>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, buffer: *const core::ffi::c_void, length: u32, byteoffset: Option<*const i64>, key: Option<*const u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    windows_link::link!("ntdll.dll" "system" fn ZwWriteFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, event : super::super::super::Win32::Foundation:: HANDLE, apcroutine : super::super::super::Win32::System::IO:: PIO_APC_ROUTINE, apccontext : *const core::ffi::c_void, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, buffer : *const core::ffi::c_void, length : u32, byteoffset : *const i64, key : *const u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    unsafe { ZwWriteFile(filehandle, event.unwrap_or(core::mem::zeroed()) as _, apcroutine, apccontext.unwrap_or(core::mem::zeroed()) as _, iostatusblock as _, buffer, length, byteoffset.unwrap_or(core::mem::zeroed()) as _, key.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn vDbgPrintEx<P2>(componentid: u32, level: u32, format: P2, arglist: *const i8) -> u32
where
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn vDbgPrintEx(componentid : u32, level : u32, format : windows_core::PCSTR, arglist : *const i8) -> u32);
    unsafe { vDbgPrintEx(componentid, level, format.param().abi(), arglist) }
}
#[inline]
pub unsafe fn vDbgPrintExWithPrefix<P0, P3>(prefix: P0, componentid: u32, level: u32, format: P3, arglist: *const i8) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("ntdll.dll" "system" fn vDbgPrintExWithPrefix(prefix : windows_core::PCSTR, componentid : u32, level : u32, format : windows_core::PCSTR, arglist : *const i8) -> u32);
    unsafe { vDbgPrintExWithPrefix(prefix.param().abi(), componentid, level, format.param().abi(), arglist) }
}
pub const ACPIBus: INTERFACE_TYPE = INTERFACE_TYPE(17i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ACPI_DEBUGGING_DEVICE_IN_USE {
    pub NameSpacePathLength: u32,
    pub NameSpacePath: [u16; 1],
}
impl Default for ACPI_DEBUGGING_DEVICE_IN_USE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ACPI_INTERFACE_STANDARD {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub GpeConnectVector: PGPE_CONNECT_VECTOR,
    pub GpeDisconnectVector: PGPE_DISCONNECT_VECTOR,
    pub GpeEnableEvent: PGPE_ENABLE_EVENT,
    pub GpeDisableEvent: PGPE_DISABLE_EVENT,
    pub GpeClearStatus: PGPE_CLEAR_STATUS,
    pub RegisterForDeviceNotifications: PREGISTER_FOR_DEVICE_NOTIFICATIONS,
    pub UnregisterForDeviceNotifications: PUNREGISTER_FOR_DEVICE_NOTIFICATIONS,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ACPI_INTERFACE_STANDARD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ACPI_INTERFACE_STANDARD2 {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub GpeConnectVector: PGPE_CONNECT_VECTOR2,
    pub GpeDisconnectVector: PGPE_DISCONNECT_VECTOR2,
    pub GpeEnableEvent: PGPE_ENABLE_EVENT2,
    pub GpeDisableEvent: PGPE_DISABLE_EVENT2,
    pub GpeClearStatus: PGPE_CLEAR_STATUS2,
    pub RegisterForDeviceNotifications: PREGISTER_FOR_DEVICE_NOTIFICATIONS2,
    pub UnregisterForDeviceNotifications: PUNREGISTER_FOR_DEVICE_NOTIFICATIONS2,
}
impl Default for ACPI_INTERFACE_STANDARD2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const ADAPTER_INFO_API_BYPASS: u32 = 2u32;
pub const ADAPTER_INFO_SYNCHRONOUS_CALLBACK: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AGP_TARGET_BUS_INTERFACE_STANDARD {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub SetBusData: PGET_SET_DEVICE_DATA,
    pub GetBusData: PGET_SET_DEVICE_DATA,
    pub CapabilityID: u8,
}
impl Default for AGP_TARGET_BUS_INTERFACE_STANDARD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(feature = "Wdk_Foundation")]
pub type ALLOCATE_FUNCTION = Option<unsafe extern "system" fn(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize, tag: u32) -> *mut core::ffi::c_void>;
pub const ALLOC_DATA_PRAGMA: u32 = 1u32;
pub const ALLOC_PRAGMA: u32 = 1u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ALTERNATIVE_ARCHITECTURE_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub union AMD_L1_CACHE_INFO {
    pub Ulong: u32,
    pub Anonymous: AMD_L1_CACHE_INFO_0,
}
impl Default for AMD_L1_CACHE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct AMD_L1_CACHE_INFO_0 {
    pub LineSize: u8,
    pub LinesPerTag: u8,
    pub Associativity: u8,
    pub Size: u8,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union AMD_L2_CACHE_INFO {
    pub Ulong: u32,
    pub Anonymous: AMD_L2_CACHE_INFO_0,
}
impl Default for AMD_L2_CACHE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct AMD_L2_CACHE_INFO_0 {
    pub LineSize: u8,
    pub _bitfield: u8,
    pub Size: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union AMD_L3_CACHE_INFO {
    pub Ulong: u32,
    pub Anonymous: AMD_L3_CACHE_INFO_0,
}
impl Default for AMD_L3_CACHE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct AMD_L3_CACHE_INFO_0 {
    pub LineSize: u8,
    pub _bitfield1: u8,
    pub _bitfield2: u16,
}
pub const ANY_SIZE: u32 = 1u32;
pub const APC_LEVEL: u32 = 1u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ARBITER_ACTION(pub i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_ADD_RESERVED_PARAMETERS {
    pub ReserveDevice: *mut super::super::Foundation::DEVICE_OBJECT,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ARBITER_ADD_RESERVED_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_BOOT_ALLOCATION_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for ARBITER_BOOT_ALLOCATION_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_CONFLICT_INFO {
    pub OwningObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub Start: u64,
    pub End: u64,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ARBITER_CONFLICT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const ARBITER_FLAG_BOOT_CONFIG: u32 = 1u32;
pub const ARBITER_FLAG_OTHER_ENUM: u32 = 4u32;
pub const ARBITER_FLAG_ROOT_ENUM: u32 = 2u32;
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub ArbiterHandler: PARBITER_HANDLER,
    pub Flags: u32,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ARBITER_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_LIST_ENTRY {
    pub ListEntry: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub AlternativeCount: u32,
    pub Alternatives: *mut IO_RESOURCE_DESCRIPTOR,
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub RequestSource: ARBITER_REQUEST_SOURCE,
    pub Flags: u32,
    pub WorkSpace: isize,
    pub InterfaceType: INTERFACE_TYPE,
    pub SlotNumber: u32,
    pub BusNumber: u32,
    pub Assignment: *mut CM_PARTIAL_RESOURCE_DESCRIPTOR,
    pub SelectedAlternative: *mut IO_RESOURCE_DESCRIPTOR,
    pub Result: ARBITER_RESULT,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ARBITER_LIST_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub struct ARBITER_PARAMETERS {
    pub Parameters: ARBITER_PARAMETERS_0,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ARBITER_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub union ARBITER_PARAMETERS_0 {
    pub TestAllocation: ARBITER_TEST_ALLOCATION_PARAMETERS,
    pub RetestAllocation: ARBITER_RETEST_ALLOCATION_PARAMETERS,
    pub BootAllocation: ARBITER_BOOT_ALLOCATION_PARAMETERS,
    pub QueryAllocatedResources: ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS,
    pub QueryConflict: ARBITER_QUERY_CONFLICT_PARAMETERS,
    pub QueryArbitrate: ARBITER_QUERY_ARBITRATE_PARAMETERS,
    pub AddReserved: ARBITER_ADD_RESERVED_PARAMETERS,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ARBITER_PARAMETERS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const ARBITER_PARTIAL: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    pub AllocatedResources: *mut *mut CM_PARTIAL_RESOURCE_LIST,
}
impl Default for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_QUERY_ARBITRATE_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for ARBITER_QUERY_ARBITRATE_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_QUERY_CONFLICT_PARAMETERS {
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub ConflictingResource: *mut IO_RESOURCE_DESCRIPTOR,
    pub ConflictCount: *mut u32,
    pub Conflicts: *mut *mut ARBITER_CONFLICT_INFO,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for ARBITER_QUERY_CONFLICT_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ARBITER_REQUEST_SOURCE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ARBITER_RESULT(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_RETEST_ALLOCATION_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub AllocateFromCount: u32,
    pub AllocateFrom: *mut CM_PARTIAL_RESOURCE_DESCRIPTOR,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for ARBITER_RETEST_ALLOCATION_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ARBITER_TEST_ALLOCATION_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub AllocateFromCount: u32,
    pub AllocateFrom: *mut CM_PARTIAL_RESOURCE_DESCRIPTOR,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for ARBITER_TEST_ALLOCATION_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[derive(Clone, Copy)]
pub struct ARM64_NT_CONTEXT {
    pub ContextFlags: u32,
    pub Cpsr: u32,
    pub Anonymous: ARM64_NT_CONTEXT_0,
    pub Sp: u64,
    pub Pc: u64,
    pub V: [super::super::super::Win32::System::Diagnostics::Debug::ARM64_NT_NEON128; 32],
    pub Fpcr: u32,
    pub Fpsr: u32,
    pub Bcr: [u32; 8],
    pub Bvr: [u64; 8],
    pub Wcr: [u32; 2],
    pub Wvr: [u64; 2],
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl Default for ARM64_NT_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[derive(Clone, Copy)]
pub union ARM64_NT_CONTEXT_0 {
    pub Anonymous: ARM64_NT_CONTEXT_0_0,
    pub X: [u64; 31],
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl Default for ARM64_NT_CONTEXT_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ARM64_NT_CONTEXT_0_0 {
    pub X0: u64,
    pub X1: u64,
    pub X2: u64,
    pub X3: u64,
    pub X4: u64,
    pub X5: u64,
    pub X6: u64,
    pub X7: u64,
    pub X8: u64,
    pub X9: u64,
    pub X10: u64,
    pub X11: u64,
    pub X12: u64,
    pub X13: u64,
    pub X14: u64,
    pub X15: u64,
    pub X16: u64,
    pub X17: u64,
    pub X18: u64,
    pub X19: u64,
    pub X20: u64,
    pub X21: u64,
    pub X22: u64,
    pub X23: u64,
    pub X24: u64,
    pub X25: u64,
    pub X26: u64,
    pub X27: u64,
    pub X28: u64,
    pub Fp: u64,
    pub Lr: u64,
}
pub const ARM64_PCR_RESERVED_MASK: u32 = 4095u32;
pub const ARM_PROCESSOR_ERROR_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe19e3d16_bc11_11e4_9caa_c2051d5d46b0);
pub const ATS_DEVICE_SVM_OPTOUT: u32 = 1u32;
pub const AccessFlagFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(5i32);
pub const AddressSizeFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(1i32);
pub const AgpControl: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(1i32);
pub const AllLoggerHandlesClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(6i32);
pub const AperturePageSize: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(3i32);
pub const ApertureSize: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(2i32);
pub const ApicDestinationModeLogicalClustered: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(3i32);
pub const ApicDestinationModeLogicalFlat: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(2i32);
pub const ApicDestinationModePhysical: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(1i32);
pub const ApicDestinationModeUnknown: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(4i32);
pub const ArbiterActionAddReserved: ARBITER_ACTION = ARBITER_ACTION(8i32);
pub const ArbiterActionBootAllocation: ARBITER_ACTION = ARBITER_ACTION(9i32);
pub const ArbiterActionCommitAllocation: ARBITER_ACTION = ARBITER_ACTION(2i32);
pub const ArbiterActionQueryAllocatedResources: ARBITER_ACTION = ARBITER_ACTION(4i32);
pub const ArbiterActionQueryArbitrate: ARBITER_ACTION = ARBITER_ACTION(7i32);
pub const ArbiterActionQueryConflict: ARBITER_ACTION = ARBITER_ACTION(6i32);
pub const ArbiterActionRetestAllocation: ARBITER_ACTION = ARBITER_ACTION(1i32);
pub const ArbiterActionRollbackAllocation: ARBITER_ACTION = ARBITER_ACTION(3i32);
pub const ArbiterActionTestAllocation: ARBITER_ACTION = ARBITER_ACTION(0i32);
pub const ArbiterActionWriteReservedResources: ARBITER_ACTION = ARBITER_ACTION(5i32);
pub const ArbiterRequestHalReported: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(1i32);
pub const ArbiterRequestLegacyAssigned: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(2i32);
pub const ArbiterRequestLegacyReported: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(0i32);
pub const ArbiterRequestPnpDetected: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(3i32);
pub const ArbiterRequestPnpEnumerated: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(4i32);
pub const ArbiterRequestUndefined: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(-1i32);
pub const ArbiterResultExternalConflict: ARBITER_RESULT = ARBITER_RESULT(1i32);
pub const ArbiterResultNullRequest: ARBITER_RESULT = ARBITER_RESULT(2i32);
pub const ArbiterResultSuccess: ARBITER_RESULT = ARBITER_RESULT(0i32);
pub const ArbiterResultUndefined: ARBITER_RESULT = ARBITER_RESULT(-1i32);
pub const ArcSystem: CONFIGURATION_TYPE = CONFIGURATION_TYPE(0i32);
pub const AssignSecurityDescriptor: SECURITY_OPERATION_CODE = SECURITY_OPERATION_CODE(3i32);
pub const AudioController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(23i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDCB_CALLBACK_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDCB_CLASSIFICATION(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDCB_IMAGE_INFORMATION {
    pub Classification: BDCB_CLASSIFICATION,
    pub ImageFlags: u32,
    pub ImageName: super::super::super::Win32::Foundation::UNICODE_STRING,
    pub RegistryPath: super::super::super::Win32::Foundation::UNICODE_STRING,
    pub CertificatePublisher: super::super::super::Win32::Foundation::UNICODE_STRING,
    pub CertificateIssuer: super::super::super::Win32::Foundation::UNICODE_STRING,
    pub ImageHash: *mut core::ffi::c_void,
    pub CertificateThumbprint: *mut core::ffi::c_void,
    pub ImageHashAlgorithm: u32,
    pub ThumbprintHashAlgorithm: u32,
    pub ImageHashLength: u32,
    pub CertificateThumbprintLength: u32,
}
impl Default for BDCB_IMAGE_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct BDCB_STATUS_UPDATE_CONTEXT {
    pub StatusType: BDCB_STATUS_UPDATE_TYPE,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDCB_STATUS_UPDATE_TYPE(pub i32);
pub const BMC_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x487565ba_6494_4367_95ca_4eff893522f6);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct BOOTDISK_INFORMATION {
    pub BootPartitionOffset: i64,
    pub SystemPartitionOffset: i64,
    pub BootDeviceSignature: u32,
    pub SystemDeviceSignature: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct BOOTDISK_INFORMATION_EX {
    pub BootPartitionOffset: i64,
    pub SystemPartitionOffset: i64,
    pub BootDeviceSignature: u32,
    pub SystemDeviceSignature: u32,
    pub BootDeviceGuid: windows_core::GUID,
    pub SystemDeviceGuid: windows_core::GUID,
    pub BootDeviceIsGpt: bool,
    pub SystemDeviceIsGpt: bool,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct BOOTDISK_INFORMATION_LITE {
    pub NumberEntries: u32,
    pub Entries: [LOADER_PARTITION_INFORMATION_EX; 1],
}
impl Default for BOOTDISK_INFORMATION_LITE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type BOOT_DRIVER_CALLBACK_FUNCTION = Option<unsafe extern "system" fn(callbackcontext: *const core::ffi::c_void, classification: BDCB_CALLBACK_TYPE, imageinformation: *mut BDCB_IMAGE_INFORMATION)>;
pub const BOOT_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x3d61a466_ab40_409a_a698_f362d464b38f);
pub type BOUND_CALLBACK = Option<unsafe extern "system" fn() -> BOUND_CALLBACK_STATUS>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BOUND_CALLBACK_STATUS(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BUS_DATA_TYPE(pub i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BUS_INTERFACE_STANDARD {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub TranslateBusAddress: PTRANSLATE_BUS_ADDRESS,
    pub GetDmaAdapter: PGET_DMA_ADAPTER,
    pub SetBusData: PGET_SET_DEVICE_DATA,
    pub GetBusData: PGET_SET_DEVICE_DATA,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for BUS_INTERFACE_STANDARD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BUS_QUERY_ID_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BUS_RESOURCE_UPDATE_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub GetUpdatedBusResource: PGET_UPDATED_BUS_RESOURCE,
}
impl Default for BUS_RESOURCE_UPDATE_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union BUS_SPECIFIC_RESET_FLAGS {
    pub u: BUS_SPECIFIC_RESET_FLAGS_0,
    pub AsUlonglong: u64,
}
impl Default for BUS_SPECIFIC_RESET_FLAGS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct BUS_SPECIFIC_RESET_FLAGS_0 {
    pub _bitfield: u64,
}
pub const BackgroundWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(4i32);
pub const BdCbClassificationEnd: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(4i32);
pub const BdCbClassificationKnownBadImage: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(2i32);
pub const BdCbClassificationKnownBadImageBootCritical: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(3i32);
pub const BdCbClassificationKnownGoodImage: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(1i32);
pub const BdCbClassificationUnknownImage: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(0i32);
pub const BdCbInitializeImage: BDCB_CALLBACK_TYPE = BDCB_CALLBACK_TYPE(1i32);
pub const BdCbStatusPrepareForDependencyLoad: BDCB_STATUS_UPDATE_TYPE = BDCB_STATUS_UPDATE_TYPE(0i32);
pub const BdCbStatusPrepareForDriverLoad: BDCB_STATUS_UPDATE_TYPE = BDCB_STATUS_UPDATE_TYPE(1i32);
pub const BdCbStatusPrepareForUnload: BDCB_STATUS_UPDATE_TYPE = BDCB_STATUS_UPDATE_TYPE(2i32);
pub const BdCbStatusUpdate: BDCB_CALLBACK_TYPE = BDCB_CALLBACK_TYPE(0i32);
pub const BoundExceptionContinueSearch: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(0i32);
pub const BoundExceptionError: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(2i32);
pub const BoundExceptionHandled: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(1i32);
pub const BoundExceptionMaximum: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(3i32);
pub const BufferEmpty: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(0i32);
pub const BufferFinished: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(3i32);
pub const BufferIncomplete: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(4i32);
pub const BufferInserted: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(1i32);
pub const BufferStarted: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(2i32);
pub const BusQueryCompatibleIDs: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(2i32);
pub const BusQueryContainerID: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(5i32);
pub const BusQueryDeviceID: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(0i32);
pub const BusQueryDeviceSerialNumber: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(4i32);
pub const BusQueryHardwareIDs: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(1i32);
pub const BusQueryInstanceID: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(3i32);
pub const BusRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(0i32);
pub const BusWidth32Bits: PCI_BUS_WIDTH = PCI_BUS_WIDTH(0i32);
pub const BusWidth64Bits: PCI_BUS_WIDTH = PCI_BUS_WIDTH(1i32);
pub const CBus: INTERFACE_TYPE = INTERFACE_TYPE(9i32);
pub const CLFS_MAX_CONTAINER_INFO: u32 = 256u32;
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CLFS_MGMT_CLIENT_REGISTRATION {
    pub Version: u32,
    pub AdvanceTailCallback: PCLFS_CLIENT_ADVANCE_TAIL_CALLBACK,
    pub AdvanceTailCallbackData: *mut core::ffi::c_void,
    pub LogGrowthCompleteCallback: PCLFS_CLIENT_LFF_HANDLER_COMPLETE_CALLBACK,
    pub LogGrowthCompleteCallbackData: *mut core::ffi::c_void,
    pub LogUnpinnedCallback: PCLFS_CLIENT_LOG_UNPINNED_CALLBACK,
    pub LogUnpinnedCallbackData: *mut core::ffi::c_void,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for CLFS_MGMT_CLIENT_REGISTRATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CLFS_SCAN_BACKWARD: u8 = 4u8;
pub const CLFS_SCAN_BUFFERED: u8 = 32u8;
pub const CLFS_SCAN_CLOSE: u8 = 8u8;
pub const CLFS_SCAN_FORWARD: u8 = 2u8;
pub const CLFS_SCAN_INIT: u8 = 1u8;
pub const CLFS_SCAN_INITIALIZED: u8 = 16u8;
pub const CLOCK1_LEVEL: u32 = 28u32;
pub const CLOCK2_LEVEL: u32 = 28u32;
pub const CLOCK_LEVEL: u32 = 28u32;
pub const CMCI_LEVEL: u32 = 5u32;
pub const CMCI_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x919448b2_3739_4b7f_a8f1_e0062805c2a3);
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CMC_DRIVER_INFO {
    pub ExceptionCallback: PDRIVER_CMC_EXCEPTION_CALLBACK,
    pub DpcCallback: super::super::Foundation::PKDEFERRED_ROUTINE,
    pub DeviceContext: *mut core::ffi::c_void,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for CMC_DRIVER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CMC_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x2dce8bb1_bdd7_450e_b9ad_9cf4ebd4f890);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_COMPONENT_INFORMATION {
    pub Flags: DEVICE_FLAGS,
    pub Version: u32,
    pub Key: u32,
    pub AffinityMask: usize,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_DISK_GEOMETRY_DEVICE_DATA {
    pub BytesPerSector: u32,
    pub NumberOfCylinders: u32,
    pub SectorsPerTrack: u32,
    pub NumberOfHeads: u32,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct CM_EISA_FUNCTION_INFORMATION {
    pub CompressedId: u32,
    pub IdSlotFlags1: u8,
    pub IdSlotFlags2: u8,
    pub MinorRevision: u8,
    pub MajorRevision: u8,
    pub Selections: [u8; 26],
    pub FunctionFlags: u8,
    pub TypeString: [u8; 80],
    pub EisaMemory: [EISA_MEMORY_CONFIGURATION; 9],
    pub EisaIrq: [EISA_IRQ_CONFIGURATION; 7],
    pub EisaDma: [EISA_DMA_CONFIGURATION; 4],
    pub EisaPort: [EISA_PORT_CONFIGURATION; 20],
    pub InitializationData: [u8; 60],
}
impl Default for CM_EISA_FUNCTION_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct CM_EISA_SLOT_INFORMATION {
    pub ReturnCode: u8,
    pub ReturnFlags: u8,
    pub MajorRevision: u8,
    pub MinorRevision: u8,
    pub Checksum: u16,
    pub NumberFunctions: u8,
    pub FunctionInformation: u8,
    pub CompressedId: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CM_FLOPPY_DEVICE_DATA {
    pub Version: u16,
    pub Revision: u16,
    pub Size: [i8; 8],
    pub MaxDensity: u32,
    pub MountDensity: u32,
    pub StepRateHeadUnloadTime: u8,
    pub HeadLoadTime: u8,
    pub MotorOffTime: u8,
    pub SectorLengthCode: u8,
    pub SectorPerTrack: u8,
    pub ReadWriteGapLength: u8,
    pub DataTransferLength: u8,
    pub FormatGapLength: u8,
    pub FormatFillCharacter: u8,
    pub HeadSettleTime: u8,
    pub MotorSettleTime: u8,
    pub MaximumTrackValue: u8,
    pub DataTransferRate: u8,
}
impl Default for CM_FLOPPY_DEVICE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CM_FULL_RESOURCE_DESCRIPTOR {
    pub InterfaceType: INTERFACE_TYPE,
    pub BusNumber: u32,
    pub PartialResourceList: CM_PARTIAL_RESOURCE_LIST,
}
impl Default for CM_FULL_RESOURCE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct CM_INT13_DRIVE_PARAMETER {
    pub DriveSelect: u16,
    pub MaxCylinders: u32,
    pub SectorsPerTrack: u16,
    pub MaxHeads: u16,
    pub NumberDrives: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_KEYBOARD_DEVICE_DATA {
    pub Version: u16,
    pub Revision: u16,
    pub Type: u8,
    pub Subtype: u8,
    pub KeyboardFlags: u16,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct CM_MCA_POS_DATA {
    pub AdapterId: u16,
    pub PosData1: u8,
    pub PosData2: u8,
    pub PosData3: u8,
    pub PosData4: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_MONITOR_DEVICE_DATA {
    pub Version: u16,
    pub Revision: u16,
    pub HorizontalScreenSize: u16,
    pub VerticalScreenSize: u16,
    pub HorizontalResolution: u16,
    pub VerticalResolution: u16,
    pub HorizontalDisplayTimeLow: u16,
    pub HorizontalDisplayTime: u16,
    pub HorizontalDisplayTimeHigh: u16,
    pub HorizontalBackPorchLow: u16,
    pub HorizontalBackPorch: u16,
    pub HorizontalBackPorchHigh: u16,
    pub HorizontalFrontPorchLow: u16,
    pub HorizontalFrontPorch: u16,
    pub HorizontalFrontPorchHigh: u16,
    pub HorizontalSyncLow: u16,
    pub HorizontalSync: u16,
    pub HorizontalSyncHigh: u16,
    pub VerticalBackPorchLow: u16,
    pub VerticalBackPorch: u16,
    pub VerticalBackPorchHigh: u16,
    pub VerticalFrontPorchLow: u16,
    pub VerticalFrontPorch: u16,
    pub VerticalFrontPorchHigh: u16,
    pub VerticalSyncLow: u16,
    pub VerticalSync: u16,
    pub VerticalSyncHigh: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR {
    pub Type: u8,
    pub ShareDisposition: u8,
    pub Flags: u16,
    pub u: CM_PARTIAL_RESOURCE_DESCRIPTOR_0,
}
impl Default for CM_PARTIAL_RESOURCE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union CM_PARTIAL_RESOURCE_DESCRIPTOR_0 {
    pub Generic: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_0,
    pub Port: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_1,
    pub Interrupt: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_2,
    pub MessageInterrupt: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3,
    pub Memory: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_4,
    pub Dma: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_5,
    pub DmaV3: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_6,
    pub DevicePrivate: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_7,
    pub BusNumber: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_8,
    pub DeviceSpecificData: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_9,
    pub Memory40: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_10,
    pub Memory48: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_11,
    pub Memory64: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_12,
    pub Connection: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_13,
}
impl Default for CM_PARTIAL_RESOURCE_DESCRIPTOR_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_8 {
    pub Start: u32,
    pub Length: u32,
    pub Reserved: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_13 {
    pub Class: u8,
    pub Type: u8,
    pub Reserved1: u8,
    pub Reserved2: u8,
    pub IdLowPart: u32,
    pub IdHighPart: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_7 {
    pub Data: [u32; 3],
}
impl Default for CM_PARTIAL_RESOURCE_DESCRIPTOR_0_7 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_9 {
    pub DataSize: u32,
    pub Reserved1: u32,
    pub Reserved2: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_6 {
    pub Channel: u32,
    pub RequestLine: u32,
    pub TransferWidth: u8,
    pub Reserved1: u8,
    pub Reserved2: u8,
    pub Reserved3: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_5 {
    pub Channel: u32,
    pub Port: u32,
    pub Reserved1: u32,
}
#[repr(C, packed(4))]
#[derive(Clone, Copy, Default)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_0 {
    pub Start: i64,
    pub Length: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_2 {
    pub Level: u32,
    pub Vector: u32,
    pub Affinity: usize,
}
#[repr(C, packed(4))]
#[derive(Clone, Copy, Default)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_10 {
    pub Start: i64,
    pub Length40: u32,
}
#[repr(C, packed(4))]
#[derive(Clone, Copy, Default)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_11 {
    pub Start: i64,
    pub Length48: u32,
}
#[repr(C, packed(4))]
#[derive(Clone, Copy, Default)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_12 {
    pub Start: i64,
    pub Length64: u32,
}
#[repr(C, packed(4))]
#[derive(Clone, Copy, Default)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_4 {
    pub Start: i64,
    pub Length: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3 {
    pub Anonymous: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3_0,
}
impl Default for CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3_0 {
    pub Raw: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3_0_0,
    pub Translated: CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3_0_1,
}
impl Default for CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3_0_0 {
    pub Reserved: u16,
    pub MessageCount: u16,
    pub Vector: u32,
    pub Affinity: usize,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_3_0_1 {
    pub Level: u32,
    pub Vector: u32,
    pub Affinity: usize,
}
#[repr(C, packed(4))]
#[derive(Clone, Copy, Default)]
pub struct CM_PARTIAL_RESOURCE_DESCRIPTOR_0_1 {
    pub Start: i64,
    pub Length: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CM_PARTIAL_RESOURCE_LIST {
    pub Version: u16,
    pub Revision: u16,
    pub Count: u32,
    pub PartialDescriptors: [CM_PARTIAL_RESOURCE_DESCRIPTOR; 1],
}
impl Default for CM_PARTIAL_RESOURCE_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CM_PCCARD_DEVICE_DATA {
    pub Flags: u8,
    pub ErrorCode: u8,
    pub Reserved: u16,
    pub BusData: u32,
    pub DeviceId: u32,
    pub LegacyBaseAddress: u32,
    pub IRQMap: [u8; 16],
}
impl Default for CM_PCCARD_DEVICE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct CM_PNP_BIOS_DEVICE_NODE {
    pub Size: u16,
    pub Node: u8,
    pub ProductId: u32,
    pub DeviceType: [u8; 3],
    pub DeviceAttributes: u16,
}
impl Default for CM_PNP_BIOS_DEVICE_NODE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct CM_PNP_BIOS_INSTALLATION_CHECK {
    pub Signature: [u8; 4],
    pub Revision: u8,
    pub Length: u8,
    pub ControlField: u16,
    pub Checksum: u8,
    pub EventFlagAddress: u32,
    pub RealModeEntryOffset: u16,
    pub RealModeEntrySegment: u16,
    pub ProtectedModeEntryOffset: u16,
    pub ProtectedModeCodeBaseAddress: u32,
    pub OemDeviceId: u32,
    pub RealModeDataBaseAddress: u16,
    pub ProtectedModeDataBaseAddress: u32,
}
impl Default for CM_PNP_BIOS_INSTALLATION_CHECK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Power")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CM_POWER_DATA {
    pub PD_Size: u32,
    pub PD_MostRecentPowerState: super::super::super::Win32::System::Power::DEVICE_POWER_STATE,
    pub PD_Capabilities: super::super::super::Win32::System::Power::DEVICE_POWER_CAPABILITIES,
    pub PD_D1Latency: u32,
    pub PD_D2Latency: u32,
    pub PD_D3Latency: u32,
    pub PD_PowerStateMapping: [super::super::super::Win32::System::Power::DEVICE_POWER_STATE; 7],
    pub PD_DeepestSystemWake: super::super::super::Win32::System::Power::SYSTEM_POWER_STATE,
}
#[cfg(feature = "Win32_System_Power")]
impl Default for CM_POWER_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CM_RESOURCE_CONNECTION_CLASS_FUNCTION_CONFIG: u32 = 3u32;
pub const CM_RESOURCE_CONNECTION_CLASS_GPIO: u32 = 1u32;
pub const CM_RESOURCE_CONNECTION_CLASS_SERIAL: u32 = 2u32;
pub const CM_RESOURCE_CONNECTION_TYPE_FUNCTION_CONFIG: u32 = 1u32;
pub const CM_RESOURCE_CONNECTION_TYPE_GPIO_IO: u32 = 2u32;
pub const CM_RESOURCE_CONNECTION_TYPE_SERIAL_I2C: u32 = 1u32;
pub const CM_RESOURCE_CONNECTION_TYPE_SERIAL_SPI: u32 = 2u32;
pub const CM_RESOURCE_CONNECTION_TYPE_SERIAL_UART: u32 = 3u32;
pub const CM_RESOURCE_DMA_16: u32 = 1u32;
pub const CM_RESOURCE_DMA_32: u32 = 2u32;
pub const CM_RESOURCE_DMA_8: u32 = 0u32;
pub const CM_RESOURCE_DMA_8_AND_16: u32 = 4u32;
pub const CM_RESOURCE_DMA_BUS_MASTER: u32 = 8u32;
pub const CM_RESOURCE_DMA_TYPE_A: u32 = 16u32;
pub const CM_RESOURCE_DMA_TYPE_B: u32 = 32u32;
pub const CM_RESOURCE_DMA_TYPE_F: u32 = 64u32;
pub const CM_RESOURCE_DMA_V3: u32 = 128u32;
pub const CM_RESOURCE_INTERRUPT_LATCHED: u32 = 1u32;
pub const CM_RESOURCE_INTERRUPT_LEVEL_LATCHED_BITS: u32 = 1u32;
pub const CM_RESOURCE_INTERRUPT_LEVEL_SENSITIVE: u32 = 0u32;
pub const CM_RESOURCE_INTERRUPT_MESSAGE: u32 = 2u32;
pub const CM_RESOURCE_INTERRUPT_POLICY_INCLUDED: u32 = 4u32;
pub const CM_RESOURCE_INTERRUPT_SECONDARY_INTERRUPT: u32 = 16u32;
pub const CM_RESOURCE_INTERRUPT_WAKE_HINT: u32 = 32u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CM_RESOURCE_LIST {
    pub Count: u32,
    pub List: [CM_FULL_RESOURCE_DESCRIPTOR; 1],
}
impl Default for CM_RESOURCE_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CM_RESOURCE_MEMORY_24: u32 = 16u32;
pub const CM_RESOURCE_MEMORY_BAR: u32 = 128u32;
pub const CM_RESOURCE_MEMORY_CACHEABLE: u32 = 32u32;
pub const CM_RESOURCE_MEMORY_COMBINEDWRITE: u32 = 8u32;
pub const CM_RESOURCE_MEMORY_COMPAT_FOR_INACCESSIBLE_RANGE: u32 = 256u32;
pub const CM_RESOURCE_MEMORY_LARGE: u32 = 3584u32;
pub const CM_RESOURCE_MEMORY_LARGE_40: u32 = 512u32;
pub const CM_RESOURCE_MEMORY_LARGE_40_MAXLEN: u64 = 1099511627520u64;
pub const CM_RESOURCE_MEMORY_LARGE_48: u32 = 1024u32;
pub const CM_RESOURCE_MEMORY_LARGE_48_MAXLEN: u64 = 281474976645120u64;
pub const CM_RESOURCE_MEMORY_LARGE_64: u32 = 2048u32;
pub const CM_RESOURCE_MEMORY_LARGE_64_MAXLEN: u64 = 18446744069414584320u64;
pub const CM_RESOURCE_MEMORY_PREFETCHABLE: u32 = 4u32;
pub const CM_RESOURCE_MEMORY_READ_ONLY: u32 = 1u32;
pub const CM_RESOURCE_MEMORY_READ_WRITE: u32 = 0u32;
pub const CM_RESOURCE_MEMORY_WINDOW_DECODE: u32 = 64u32;
pub const CM_RESOURCE_MEMORY_WRITEABILITY_MASK: u32 = 3u32;
pub const CM_RESOURCE_MEMORY_WRITE_ONLY: u32 = 2u32;
pub const CM_RESOURCE_PORT_10_BIT_DECODE: u32 = 4u32;
pub const CM_RESOURCE_PORT_12_BIT_DECODE: u32 = 8u32;
pub const CM_RESOURCE_PORT_16_BIT_DECODE: u32 = 16u32;
pub const CM_RESOURCE_PORT_BAR: u32 = 256u32;
pub const CM_RESOURCE_PORT_IO: u32 = 1u32;
pub const CM_RESOURCE_PORT_MEMORY: u32 = 0u32;
pub const CM_RESOURCE_PORT_PASSIVE_DECODE: u32 = 64u32;
pub const CM_RESOURCE_PORT_POSITIVE_DECODE: u32 = 32u32;
pub const CM_RESOURCE_PORT_WINDOW_DECODE: u32 = 128u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_ROM_BLOCK {
    pub Address: u32,
    pub Size: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_SCSI_DEVICE_DATA {
    pub Version: u16,
    pub Revision: u16,
    pub HostIdentifier: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_SERIAL_DEVICE_DATA {
    pub Version: u16,
    pub Revision: u16,
    pub BaudClock: u32,
}
pub const CM_SERVICE_MEASURED_BOOT_LOAD: u32 = 32u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CM_SHARE_DISPOSITION(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CM_SONIC_DEVICE_DATA {
    pub Version: u16,
    pub Revision: u16,
    pub DataConfigurationRegister: u16,
    pub EthernetAddress: [u8; 8],
}
impl Default for CM_SONIC_DEVICE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CM_VIDEO_DEVICE_DATA {
    pub Version: u16,
    pub Revision: u16,
    pub VideoClock: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CONFIGURATION_INFORMATION {
    pub DiskCount: u32,
    pub FloppyCount: u32,
    pub CdRomCount: u32,
    pub TapeCount: u32,
    pub ScsiPortCount: u32,
    pub SerialCount: u32,
    pub ParallelCount: u32,
    pub AtDiskPrimaryAddressClaimed: bool,
    pub AtDiskSecondaryAddressClaimed: bool,
    pub Version: u32,
    pub MediumChangerCount: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CONFIGURATION_TYPE(pub i32);
pub const CONNECT_CURRENT_VERSION: u32 = 5u32;
pub const CONNECT_FULLY_SPECIFIED: u32 = 1u32;
pub const CONNECT_FULLY_SPECIFIED_GROUP: u32 = 4u32;
pub const CONNECT_LINE_BASED: u32 = 2u32;
pub const CONNECT_MESSAGE_BASED: u32 = 3u32;
pub const CONNECT_MESSAGE_BASED_PASSIVE: u32 = 5u32;
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CONTROLLER_OBJECT {
    pub Type: i16,
    pub Size: i16,
    pub ControllerExtension: *mut core::ffi::c_void,
    pub DeviceWaitQueue: super::super::Foundation::KDEVICE_QUEUE,
    pub Spare1: u32,
    pub Spare2: i64,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
impl Default for CONTROLLER_OBJECT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct COUNTED_REASON_CONTEXT {
    pub Version: u32,
    pub Flags: u32,
    pub Anonymous: COUNTED_REASON_CONTEXT_0,
}
impl Default for COUNTED_REASON_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union COUNTED_REASON_CONTEXT_0 {
    pub Anonymous: COUNTED_REASON_CONTEXT_0_0,
    pub SimpleString: super::super::super::Win32::Foundation::UNICODE_STRING,
}
impl Default for COUNTED_REASON_CONTEXT_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct COUNTED_REASON_CONTEXT_0_0 {
    pub ResourceFileName: super::super::super::Win32::Foundation::UNICODE_STRING,
    pub ResourceReasonId: u16,
    pub StringCount: u32,
    pub ReasonStrings: *mut super::super::super::Win32::Foundation::UNICODE_STRING,
}
impl Default for COUNTED_REASON_CONTEXT_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CP15_PCR_RESERVED_MASK: u32 = 4095u32;
pub const CPER_EMPTY_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x00000000_0000_0000_0000_000000000000);
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CPE_DRIVER_INFO {
    pub ExceptionCallback: PDRIVER_CPE_EXCEPTION_CALLBACK,
    pub DpcCallback: super::super::Foundation::PKDEFERRED_ROUTINE,
    pub DeviceContext: *mut core::ffi::c_void,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for CPE_DRIVER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CPE_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x4e292f96_d843_4a55_a8c2_d481f27ebeee);
pub const CP_GET_ERROR: u32 = 2u32;
pub const CP_GET_NODATA: u32 = 1u32;
pub const CP_GET_SUCCESS: u32 = 0u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CRASHDUMP_FUNCTIONS_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub PowerOn: PCRASHDUMP_POWER_ON,
}
impl Default for CRASHDUMP_FUNCTIONS_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREATE_FILE_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CREATE_USER_PROCESS_ECP_CONTEXT {
    pub Size: u16,
    pub Reserved: u16,
    pub AccessToken: *mut core::ffi::c_void,
}
impl Default for CREATE_USER_PROCESS_ECP_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CardPresent: PCI_EXPRESS_CARD_PRESENCE = PCI_EXPRESS_CARD_PRESENCE(1i32);
pub const CbusConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(3i32);
pub const CdromController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(15i32);
pub const CentralProcessor: CONFIGURATION_TYPE = CONFIGURATION_TYPE(1i32);
pub const ClfsClientRecord: u8 = 3u8;
pub const ClfsContainerActive: u32 = 4u32;
pub const ClfsContainerActivePendingDelete: u32 = 8u32;
pub const ClfsContainerInactive: u32 = 2u32;
pub const ClfsContainerInitializing: u32 = 1u32;
pub const ClfsContainerPendingArchive: u32 = 16u32;
pub const ClfsContainerPendingArchiveAndDelete: u32 = 32u32;
pub const ClfsDataRecord: u8 = 1u8;
pub const ClfsNullRecord: u8 = 0u8;
pub const ClfsRestartRecord: u8 = 2u8;
pub const ClsContainerActive: u32 = 4u32;
pub const ClsContainerActivePendingDelete: u32 = 8u32;
pub const ClsContainerInactive: u32 = 2u32;
pub const ClsContainerInitializing: u32 = 1u32;
pub const ClsContainerPendingArchive: u32 = 16u32;
pub const ClsContainerPendingArchiveAndDelete: u32 = 32u32;
pub const CmResourceShareDeviceExclusive: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(1i32);
pub const CmResourceShareDriverExclusive: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(2i32);
pub const CmResourceShareShared: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(3i32);
pub const CmResourceShareUndetermined: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(0i32);
pub const CmResourceTypeBusNumber: u32 = 6u32;
pub const CmResourceTypeConfigData: u32 = 128u32;
pub const CmResourceTypeConnection: u32 = 132u32;
pub const CmResourceTypeDevicePrivate: u32 = 129u32;
pub const CmResourceTypeDeviceSpecific: u32 = 5u32;
pub const CmResourceTypeDma: u32 = 4u32;
pub const CmResourceTypeInterrupt: u32 = 2u32;
pub const CmResourceTypeMaximum: u32 = 8u32;
pub const CmResourceTypeMemory: u32 = 3u32;
pub const CmResourceTypeMemoryLarge: u32 = 7u32;
pub const CmResourceTypeMfCardConfig: u32 = 131u32;
pub const CmResourceTypeNonArbitrated: u32 = 128u32;
pub const CmResourceTypeNull: u32 = 0u32;
pub const CmResourceTypePcCardConfig: u32 = 130u32;
pub const CmResourceTypePort: u32 = 1u32;
pub const Cmos: BUS_DATA_TYPE = BUS_DATA_TYPE(0i32);
pub const CommonBufferConfigTypeHardwareAccessPermissions: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(2i32);
pub const CommonBufferConfigTypeLogicalAddressLimits: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(0i32);
pub const CommonBufferConfigTypeMax: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(3i32);
pub const CommonBufferConfigTypeSubSection: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(1i32);
pub const CommonBufferHardwareAccessMax: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(3i32);
pub const CommonBufferHardwareAccessReadOnly: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(0i32);
pub const CommonBufferHardwareAccessReadWrite: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(2i32);
pub const CommonBufferHardwareAccessWriteOnly: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(1i32);
pub const Compatible: DMA_SPEED = DMA_SPEED(0i32);
pub const ConfigurationSpaceUndefined: BUS_DATA_TYPE = BUS_DATA_TYPE(-1i32);
pub const ContinueCompletion: IO_COMPLETION_ROUTINE_RESULT = IO_COMPLETION_ROUTINE_RESULT(0i32);
pub const CreateFileTypeMailslot: CREATE_FILE_TYPE = CREATE_FILE_TYPE(2i32);
pub const CreateFileTypeNamedPipe: CREATE_FILE_TYPE = CREATE_FILE_TYPE(1i32);
pub const CreateFileTypeNone: CREATE_FILE_TYPE = CREATE_FILE_TYPE(0i32);
pub const CriticalWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(0i32);
pub const CustomPriorityWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(32i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3COLD_AUX_POWER_AND_TIMING_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub RequestCorePowerRail: PD3COLD_REQUEST_CORE_POWER_RAIL,
    pub RequestAuxPower: PD3COLD_REQUEST_AUX_POWER,
    pub RequestPerstDelay: PD3COLD_REQUEST_PERST_DELAY,
}
impl Default for D3COLD_AUX_POWER_AND_TIMING_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3COLD_LAST_TRANSITION_STATUS(pub i32);
pub type D3COLD_REQUEST_AUX_POWER = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, auxpowerinmilliwatts: u32, retryinseconds: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type D3COLD_REQUEST_CORE_POWER_RAIL = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, corepowerrailneeded: bool)>;
pub type D3COLD_REQUEST_PERST_DELAY = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, delayinmicroseconds: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3COLD_SUPPORT_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub SetD3ColdSupport: PSET_D3COLD_SUPPORT,
    pub GetIdleWakeInfo: PGET_IDLE_WAKE_INFO,
    pub GetD3ColdCapability: PGET_D3COLD_CAPABILITY,
    pub GetBusDriverD3ColdSupport: PGET_D3COLD_CAPABILITY,
    pub GetLastTransitionStatus: PGET_D3COLD_LAST_TRANSITION_STATUS,
}
impl Default for D3COLD_SUPPORT_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const D3COLD_SUPPORT_INTERFACE_VERSION: u32 = 1u32;
pub const DBG_DEVICE_FLAG_BARS_MAPPED: u32 = 2u32;
pub const DBG_DEVICE_FLAG_HAL_SCRATCH_ALLOCATED: u32 = 1u32;
pub const DBG_DEVICE_FLAG_HOST_VISIBLE_ALLOCATED: u32 = 32u32;
pub const DBG_DEVICE_FLAG_SCRATCH_ALLOCATED: u32 = 4u32;
pub const DBG_DEVICE_FLAG_SYNTHETIC: u32 = 16u32;
pub const DBG_DEVICE_FLAG_UNCACHED_MEMORY: u32 = 8u32;
pub const DBG_STATUS_BUGCHECK_FIRST: u32 = 3u32;
pub const DBG_STATUS_BUGCHECK_SECOND: u32 = 4u32;
pub const DBG_STATUS_CONTROL_C: u32 = 1u32;
pub const DBG_STATUS_DEBUG_CONTROL: u32 = 6u32;
pub const DBG_STATUS_FATAL: u32 = 5u32;
pub const DBG_STATUS_SYSRQ: u32 = 2u32;
pub const DBG_STATUS_WORKER: u32 = 7u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DEBUGGING_DEVICE_IN_USE {
    pub NameSpace: KD_NAMESPACE_ENUM,
    pub StructureLength: u32,
    pub Anonymous: DEBUGGING_DEVICE_IN_USE_0,
}
impl Default for DEBUGGING_DEVICE_IN_USE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEBUGGING_DEVICE_IN_USE_0 {
    pub AcpiDevice: ACPI_DEBUGGING_DEVICE_IN_USE,
    pub PciDevice: PCI_DEBUGGING_DEVICE_IN_USE,
}
impl Default for DEBUGGING_DEVICE_IN_USE_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DEBUGGING_DEVICE_IN_USE_INFORMATION {
    pub DeviceCount: u32,
    pub Device: [DEBUGGING_DEVICE_IN_USE; 1],
}
impl Default for DEBUGGING_DEVICE_IN_USE_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DEBUG_DEVICE_ADDRESS {
    pub Type: u8,
    pub Valid: bool,
    pub Anonymous: DEBUG_DEVICE_ADDRESS_0,
    pub TranslatedAddress: *mut u8,
    pub Length: u32,
}
impl Default for DEBUG_DEVICE_ADDRESS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEBUG_DEVICE_ADDRESS_0 {
    pub Reserved: [u8; 2],
    pub Anonymous: DEBUG_DEVICE_ADDRESS_0_0,
}
impl Default for DEBUG_DEVICE_ADDRESS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_DEVICE_ADDRESS_0_0 {
    pub BitWidth: u8,
    pub AccessSize: u8,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DEBUG_DEVICE_DESCRIPTOR {
    pub Bus: u32,
    pub Slot: u32,
    pub Segment: u16,
    pub VendorID: u16,
    pub DeviceID: u16,
    pub BaseClass: u8,
    pub SubClass: u8,
    pub ProgIf: u8,
    pub Anonymous: DEBUG_DEVICE_DESCRIPTOR_0,
    pub Initialized: bool,
    pub Configured: bool,
    pub BaseAddress: [DEBUG_DEVICE_ADDRESS; 6],
    pub Memory: DEBUG_MEMORY_REQUIREMENTS,
    pub Dbg2TableIndex: u32,
    pub PortType: u16,
    pub PortSubtype: u16,
    pub OemData: *mut core::ffi::c_void,
    pub OemDataLength: u32,
    pub NameSpace: KD_NAMESPACE_ENUM,
    pub NameSpacePath: windows_core::PWSTR,
    pub NameSpacePathLength: u32,
    pub TransportType: u32,
    pub TransportData: DEBUG_TRANSPORT_DATA,
    pub EfiIoMmuData: DEBUG_EFI_IOMMU_DATA,
}
impl Default for DEBUG_DEVICE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEBUG_DEVICE_DESCRIPTOR_0 {
    pub Flags: u8,
    pub Anonymous: DEBUG_DEVICE_DESCRIPTOR_0_0,
}
impl Default for DEBUG_DEVICE_DESCRIPTOR_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_DEVICE_DESCRIPTOR_0_0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_EFI_IOMMU_DATA {
    pub PciIoProtocolHandle: *mut core::ffi::c_void,
    pub Mapping: *mut core::ffi::c_void,
}
impl Default for DEBUG_EFI_IOMMU_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_MEMORY_REQUIREMENTS {
    pub Start: i64,
    pub MaxEnd: i64,
    pub VirtualAddress: *mut core::ffi::c_void,
    pub Length: u32,
    pub Cached: bool,
    pub Aligned: bool,
}
impl Default for DEBUG_MEMORY_REQUIREMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_TRANSPORT_DATA {
    pub HwContextSize: u32,
    pub SharedVisibleDataSize: u32,
    pub UseSerialFraming: bool,
    pub ValidUSBCoreId: bool,
    pub USBCoreId: u8,
}
pub const DEFAULT_DEVICE_DRIVER_CREATOR_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x57217c8d_5e66_44fb_8033_9b74cacedf5b);
pub type DEVICE_BUS_SPECIFIC_RESET_HANDLER = Option<unsafe extern "system" fn(interfacecontext: *const core::ffi::c_void, bustype: *const windows_core::GUID, resettypeselected: DEVICE_BUS_SPECIFIC_RESET_TYPE, flags: *const BUS_SPECIFIC_RESET_FLAGS, resetparameters: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DEVICE_BUS_SPECIFIC_RESET_INFO {
    pub BusTypeGuid: windows_core::GUID,
    pub ResetTypeSupported: DEVICE_BUS_SPECIFIC_RESET_TYPE,
}
impl Default for DEVICE_BUS_SPECIFIC_RESET_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEVICE_BUS_SPECIFIC_RESET_TYPE {
    pub Pci: DEVICE_BUS_SPECIFIC_RESET_TYPE_0,
    pub Acpi: DEVICE_BUS_SPECIFIC_RESET_TYPE_1,
    pub AsULONGLONG: u64,
}
impl Default for DEVICE_BUS_SPECIFIC_RESET_TYPE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEVICE_BUS_SPECIFIC_RESET_TYPE_1 {
    pub _bitfield: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEVICE_BUS_SPECIFIC_RESET_TYPE_0 {
    pub _bitfield: u64,
}
#[repr(C)]
#[cfg(feature = "Win32_System_Power")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEVICE_CAPABILITIES {
    pub Size: u16,
    pub Version: u16,
    pub _bitfield: u32,
    pub Address: u32,
    pub UINumber: u32,
    pub DeviceState: [super::super::super::Win32::System::Power::DEVICE_POWER_STATE; 7],
    pub SystemWake: super::super::super::Win32::System::Power::SYSTEM_POWER_STATE,
    pub DeviceWake: super::super::super::Win32::System::Power::DEVICE_POWER_STATE,
    pub D1Latency: u32,
    pub D2Latency: u32,
    pub D3Latency: u32,
}
#[cfg(feature = "Win32_System_Power")]
impl Default for DEVICE_CAPABILITIES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type DEVICE_CHANGE_COMPLETE_CALLBACK = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEVICE_DESCRIPTION {
    pub Version: u32,
    pub Master: bool,
    pub ScatterGather: bool,
    pub DemandMode: bool,
    pub AutoInitialize: bool,
    pub Dma32BitAddresses: bool,
    pub IgnoreCount: bool,
    pub Reserved1: bool,
    pub Dma64BitAddresses: bool,
    pub BusNumber: u32,
    pub DmaChannel: u32,
    pub InterfaceType: INTERFACE_TYPE,
    pub DmaWidth: DMA_WIDTH,
    pub DmaSpeed: DMA_SPEED,
    pub MaximumLength: u32,
    pub DmaPort: u32,
    pub DmaAddressWidth: u32,
    pub DmaControllerInstance: u32,
    pub DmaRequestLine: u32,
    pub DeviceAddress: i64,
}
pub const DEVICE_DESCRIPTION_VERSION: u32 = 0u32;
pub const DEVICE_DESCRIPTION_VERSION1: u32 = 1u32;
pub const DEVICE_DESCRIPTION_VERSION2: u32 = 2u32;
pub const DEVICE_DESCRIPTION_VERSION3: u32 = 3u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_DIRECTORY_TYPE(pub i32);
pub const DEVICE_DRIVER_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x0033f803_2e70_4e88_992c_6f26daf3db7a);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEVICE_FAULT_CONFIGURATION {
    pub FaultHandler: PIOMMU_DEVICE_FAULT_HANDLER,
    pub FaultContext: *mut core::ffi::c_void,
}
impl Default for DEVICE_FAULT_CONFIGURATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEVICE_FLAGS {
    pub _bitfield: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_INSTALL_STATE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEVICE_INTERFACE_CHANGE_NOTIFICATION {
    pub Version: u16,
    pub Size: u16,
    pub Event: windows_core::GUID,
    pub InterfaceClassGuid: windows_core::GUID,
    pub SymbolicLinkName: *mut super::super::super::Win32::Foundation::UNICODE_STRING,
}
impl Default for DEVICE_INTERFACE_CHANGE_NOTIFICATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEVICE_INTERFACE_INCLUDE_NONACTIVE: u32 = 1u32;
pub type DEVICE_QUERY_BUS_SPECIFIC_RESET_HANDLER = Option<unsafe extern "system" fn(interfacecontext: *const core::ffi::c_void, resetinfocount: *mut u32, resetinfosupported: *mut DEVICE_BUS_SPECIFIC_RESET_INFO) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_REGISTRY_PROPERTY(pub i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEVICE_RELATIONS {
    pub Count: u32,
    pub Objects: [*mut super::super::Foundation::DEVICE_OBJECT; 1],
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for DEVICE_RELATIONS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_RELATION_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_REMOVAL_POLICY(pub i32);
pub type DEVICE_RESET_COMPLETION = Option<unsafe extern "system" fn(status: super::super::super::Win32::Foundation::NTSTATUS, context: *mut core::ffi::c_void)>;
pub type DEVICE_RESET_HANDLER = Option<unsafe extern "system" fn(interfacecontext: *const core::ffi::c_void, resettype: DEVICE_RESET_TYPE, flags: u32, resetparameters: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEVICE_RESET_INTERFACE_STANDARD {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub DeviceReset: PDEVICE_RESET_HANDLER,
    pub SupportedResetTypes: u32,
    pub Reserved: *mut core::ffi::c_void,
    pub QueryBusSpecificResetInfo: PDEVICE_QUERY_BUS_SPECIFIC_RESET_HANDLER,
    pub DeviceBusSpecificReset: PDEVICE_BUS_SPECIFIC_RESET_HANDLER,
    pub GetDeviceResetStatus: PGET_DEVICE_RESET_STATUS,
}
impl Default for DEVICE_RESET_INTERFACE_STANDARD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEVICE_RESET_INTERFACE_VERSION: u32 = 1u32;
pub const DEVICE_RESET_INTERFACE_VERSION_1: u32 = 1u32;
pub const DEVICE_RESET_INTERFACE_VERSION_2: u32 = 2u32;
pub const DEVICE_RESET_INTERFACE_VERSION_3: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEVICE_RESET_STATUS_FLAGS {
    pub u: DEVICE_RESET_STATUS_FLAGS_0,
    pub AsUlonglong: u64,
}
impl Default for DEVICE_RESET_STATUS_FLAGS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEVICE_RESET_STATUS_FLAGS_0 {
    pub _bitfield: u64,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_RESET_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_TEXT_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_USAGE_NOTIFICATION_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEVICE_WAKE_DEPTH(pub i32);
pub const DIRECTORY_CREATE_OBJECT: u32 = 4u32;
pub const DIRECTORY_CREATE_SUBDIRECTORY: u32 = 8u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DIRECTORY_NOTIFY_INFORMATION_CLASS(pub i32);
pub const DIRECTORY_QUERY: u32 = 1u32;
pub const DIRECTORY_TRAVERSE: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DISK_SIGNATURE {
    pub PartitionStyle: u32,
    pub Anonymous: DISK_SIGNATURE_0,
}
impl Default for DISK_SIGNATURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DISK_SIGNATURE_0 {
    pub Mbr: DISK_SIGNATURE_0_0,
    pub Gpt: DISK_SIGNATURE_0_1,
}
impl Default for DISK_SIGNATURE_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DISK_SIGNATURE_0_1 {
    pub DiskId: windows_core::GUID,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DISK_SIGNATURE_0_0 {
    pub Signature: u32,
    pub CheckSum: u32,
}
pub const DISPATCH_LEVEL: u32 = 2u32;
pub const DMAV3_TRANFER_WIDTH_128: u32 = 4u32;
pub const DMAV3_TRANFER_WIDTH_16: u32 = 1u32;
pub const DMAV3_TRANFER_WIDTH_256: u32 = 5u32;
pub const DMAV3_TRANFER_WIDTH_32: u32 = 2u32;
pub const DMAV3_TRANFER_WIDTH_64: u32 = 3u32;
pub const DMAV3_TRANFER_WIDTH_8: u32 = 0u32;
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DMA_ADAPTER {
    pub Version: u16,
    pub Size: u16,
    pub DmaOperations: *mut DMA_OPERATIONS,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for DMA_ADAPTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DMA_ADAPTER_INFO {
    pub Version: u32,
    pub Anonymous: DMA_ADAPTER_INFO_0,
}
impl Default for DMA_ADAPTER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DMA_ADAPTER_INFO_0 {
    pub V1: DMA_ADAPTER_INFO_V1,
    pub Crashdump: DMA_ADAPTER_INFO_CRASHDUMP,
}
impl Default for DMA_ADAPTER_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DMA_ADAPTER_INFO_CRASHDUMP {
    pub DeviceDescription: DEVICE_DESCRIPTION,
    pub DeviceIdSize: usize,
    pub DeviceId: *mut core::ffi::c_void,
}
impl Default for DMA_ADAPTER_INFO_CRASHDUMP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_ADAPTER_INFO_V1 {
    pub ReadDmaCounterAvailable: u32,
    pub ScatterGatherLimit: u32,
    pub DmaAddressWidth: u32,
    pub Flags: u32,
    pub MinimumTransferUnit: u32,
}
pub const DMA_ADAPTER_INFO_VERSION1: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION {
    pub ConfigType: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE,
    pub Anonymous: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_0,
}
impl Default for DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_0 {
    pub LogicalAddressLimits: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_0_0,
    pub SubSection: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_0_1,
    pub HardwareAccessType: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE,
    pub Reserved: [u64; 4],
}
impl Default for DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_0_0 {
    pub MinimumAddress: i64,
    pub MaximumAddress: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_0_1 {
    pub Offset: u64,
    pub Length: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(pub i32);
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type DMA_COMPLETION_ROUTINE = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, completioncontext: *const core::ffi::c_void, status: DMA_COMPLETION_STATUS)>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DMA_COMPLETION_STATUS(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_CONFIGURATION_BYTE0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_CONFIGURATION_BYTE1 {
    pub _bitfield: u8,
}
pub const DMA_FAIL_ON_BOUNCE: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_IOMMU_INTERFACE {
    pub Version: u32,
    pub CreateDomain: PIOMMU_DOMAIN_CREATE,
    pub DeleteDomain: PIOMMU_DOMAIN_DELETE,
    pub AttachDevice: PIOMMU_DOMAIN_ATTACH_DEVICE,
    pub DetachDevice: PIOMMU_DOMAIN_DETACH_DEVICE,
    pub FlushDomain: PIOMMU_FLUSH_DOMAIN,
    pub FlushDomainByVaList: PIOMMU_FLUSH_DOMAIN_VA_LIST,
    pub QueryInputMappings: PIOMMU_QUERY_INPUT_MAPPINGS,
    pub MapLogicalRange: PIOMMU_MAP_LOGICAL_RANGE,
    pub UnmapLogicalRange: PIOMMU_UNMAP_LOGICAL_RANGE,
    pub MapIdentityRange: PIOMMU_MAP_IDENTITY_RANGE,
    pub UnmapIdentityRange: PIOMMU_UNMAP_IDENTITY_RANGE,
    pub SetDeviceFaultReporting: PIOMMU_SET_DEVICE_FAULT_REPORTING,
    pub ConfigureDomain: PIOMMU_DOMAIN_CONFIGURE,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DMA_IOMMU_INTERFACE_EX {
    pub Size: usize,
    pub Version: u32,
    pub Anonymous: DMA_IOMMU_INTERFACE_EX_0,
}
impl Default for DMA_IOMMU_INTERFACE_EX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DMA_IOMMU_INTERFACE_EX_0 {
    pub V1: DMA_IOMMU_INTERFACE_V1,
    pub V2: DMA_IOMMU_INTERFACE_V2,
}
impl Default for DMA_IOMMU_INTERFACE_EX_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DMA_IOMMU_INTERFACE_EX_VERSION: u32 = 1u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_1: u32 = 1u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_2: u32 = 2u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_MAX: u32 = 2u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_MIN: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_IOMMU_INTERFACE_V1 {
    pub CreateDomain: PIOMMU_DOMAIN_CREATE,
    pub DeleteDomain: PIOMMU_DOMAIN_DELETE,
    pub AttachDevice: PIOMMU_DOMAIN_ATTACH_DEVICE,
    pub DetachDevice: PIOMMU_DOMAIN_DETACH_DEVICE,
    pub FlushDomain: PIOMMU_FLUSH_DOMAIN,
    pub FlushDomainByVaList: PIOMMU_FLUSH_DOMAIN_VA_LIST,
    pub QueryInputMappings: PIOMMU_QUERY_INPUT_MAPPINGS,
    pub MapLogicalRange: PIOMMU_MAP_LOGICAL_RANGE,
    pub UnmapLogicalRange: PIOMMU_UNMAP_LOGICAL_RANGE,
    pub MapIdentityRange: PIOMMU_MAP_IDENTITY_RANGE,
    pub UnmapIdentityRange: PIOMMU_UNMAP_IDENTITY_RANGE,
    pub SetDeviceFaultReporting: PIOMMU_SET_DEVICE_FAULT_REPORTING,
    pub ConfigureDomain: PIOMMU_DOMAIN_CONFIGURE,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_IOMMU_INTERFACE_V2 {
    pub CreateDomainEx: PIOMMU_DOMAIN_CREATE_EX,
    pub DeleteDomain: PIOMMU_DOMAIN_DELETE,
    pub AttachDeviceEx: PIOMMU_DOMAIN_ATTACH_DEVICE_EX,
    pub DetachDeviceEx: PIOMMU_DOMAIN_DETACH_DEVICE_EX,
    pub FlushDomain: PIOMMU_FLUSH_DOMAIN,
    pub FlushDomainByVaList: PIOMMU_FLUSH_DOMAIN_VA_LIST,
    pub QueryInputMappings: PIOMMU_QUERY_INPUT_MAPPINGS,
    pub MapLogicalRangeEx: PIOMMU_MAP_LOGICAL_RANGE_EX,
    pub UnmapLogicalRange: PIOMMU_UNMAP_LOGICAL_RANGE,
    pub MapIdentityRangeEx: PIOMMU_MAP_IDENTITY_RANGE_EX,
    pub UnmapIdentityRangeEx: PIOMMU_UNMAP_IDENTITY_RANGE_EX,
    pub SetDeviceFaultReportingEx: PIOMMU_SET_DEVICE_FAULT_REPORTING_EX,
    pub ConfigureDomain: PIOMMU_DOMAIN_CONFIGURE,
    pub QueryAvailableDomainTypes: PIOMMU_DEVICE_QUERY_DOMAIN_TYPES,
    pub RegisterInterfaceStateChangeCallback: PIOMMU_REGISTER_INTERFACE_STATE_CHANGE_CALLBACK,
    pub UnregisterInterfaceStateChangeCallback: PIOMMU_UNREGISTER_INTERFACE_STATE_CHANGE_CALLBACK,
    pub ReserveLogicalAddressRange: PIOMMU_RESERVE_LOGICAL_ADDRESS_RANGE,
    pub FreeReservedLogicalAddressRange: PIOMMU_FREE_RESERVED_LOGICAL_ADDRESS_RANGE,
    pub MapReservedLogicalRange: PIOMMU_MAP_RESERVED_LOGICAL_RANGE,
    pub UnmapReservedLogicalRange: PIOMMU_UNMAP_RESERVED_LOGICAL_RANGE,
    pub CreateDevice: PIOMMU_DEVICE_CREATE,
    pub DeleteDevice: PIOMMU_DEVICE_DELETE,
}
pub const DMA_IOMMU_INTERFACE_VERSION: u32 = 1u32;
pub const DMA_IOMMU_INTERFACE_VERSION_1: u32 = 1u32;
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_OPERATIONS {
    pub Size: u32,
    pub PutDmaAdapter: PPUT_DMA_ADAPTER,
    pub AllocateCommonBuffer: PALLOCATE_COMMON_BUFFER,
    pub FreeCommonBuffer: PFREE_COMMON_BUFFER,
    pub AllocateAdapterChannel: PALLOCATE_ADAPTER_CHANNEL,
    pub FlushAdapterBuffers: PFLUSH_ADAPTER_BUFFERS,
    pub FreeAdapterChannel: PFREE_ADAPTER_CHANNEL,
    pub FreeMapRegisters: PFREE_MAP_REGISTERS,
    pub MapTransfer: PMAP_TRANSFER,
    pub GetDmaAlignment: PGET_DMA_ALIGNMENT,
    pub ReadDmaCounter: PREAD_DMA_COUNTER,
    pub GetScatterGatherList: PGET_SCATTER_GATHER_LIST,
    pub PutScatterGatherList: PPUT_SCATTER_GATHER_LIST,
    pub CalculateScatterGatherList: PCALCULATE_SCATTER_GATHER_LIST_SIZE,
    pub BuildScatterGatherList: PBUILD_SCATTER_GATHER_LIST,
    pub BuildMdlFromScatterGatherList: PBUILD_MDL_FROM_SCATTER_GATHER_LIST,
    pub GetDmaAdapterInfo: PGET_DMA_ADAPTER_INFO,
    pub GetDmaTransferInfo: PGET_DMA_TRANSFER_INFO,
    pub InitializeDmaTransferContext: PINITIALIZE_DMA_TRANSFER_CONTEXT,
    pub AllocateCommonBufferEx: PALLOCATE_COMMON_BUFFER_EX,
    pub AllocateAdapterChannelEx: PALLOCATE_ADAPTER_CHANNEL_EX,
    pub ConfigureAdapterChannel: PCONFIGURE_ADAPTER_CHANNEL,
    pub CancelAdapterChannel: PCANCEL_ADAPTER_CHANNEL,
    pub MapTransferEx: PMAP_TRANSFER_EX,
    pub GetScatterGatherListEx: PGET_SCATTER_GATHER_LIST_EX,
    pub BuildScatterGatherListEx: PBUILD_SCATTER_GATHER_LIST_EX,
    pub FlushAdapterBuffersEx: PFLUSH_ADAPTER_BUFFERS_EX,
    pub FreeAdapterObject: PFREE_ADAPTER_OBJECT,
    pub CancelMappedTransfer: PCANCEL_MAPPED_TRANSFER,
    pub AllocateDomainCommonBuffer: PALLOCATE_DOMAIN_COMMON_BUFFER,
    pub FlushDmaBuffer: PFLUSH_DMA_BUFFER,
    pub JoinDmaDomain: PJOIN_DMA_DOMAIN,
    pub LeaveDmaDomain: PLEAVE_DMA_DOMAIN,
    pub GetDmaDomain: PGET_DMA_DOMAIN,
    pub AllocateCommonBufferWithBounds: PALLOCATE_COMMON_BUFFER_WITH_BOUNDS,
    pub AllocateCommonBufferVector: PALLOCATE_COMMON_BUFFER_VECTOR,
    pub GetCommonBufferFromVectorByIndex: PGET_COMMON_BUFFER_FROM_VECTOR_BY_INDEX,
    pub FreeCommonBufferFromVector: PFREE_COMMON_BUFFER_FROM_VECTOR,
    pub FreeCommonBufferVector: PFREE_COMMON_BUFFER_VECTOR,
    pub CreateCommonBufferFromMdl: PCREATE_COMMON_BUFFER_FROM_MDL,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DMA_SPEED(pub i32);
pub const DMA_SYNCHRONOUS_CALLBACK: u32 = 1u32;
pub const DMA_TRANSFER_CONTEXT_SIZE_V1: u32 = 128u32;
pub const DMA_TRANSFER_CONTEXT_VERSION1: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DMA_TRANSFER_INFO {
    pub Version: u32,
    pub Anonymous: DMA_TRANSFER_INFO_0,
}
impl Default for DMA_TRANSFER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DMA_TRANSFER_INFO_0 {
    pub V1: DMA_TRANSFER_INFO_V1,
    pub V2: DMA_TRANSFER_INFO_V2,
}
impl Default for DMA_TRANSFER_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_TRANSFER_INFO_V1 {
    pub MapRegisterCount: u32,
    pub ScatterGatherElementCount: u32,
    pub ScatterGatherListSize: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DMA_TRANSFER_INFO_V2 {
    pub MapRegisterCount: u32,
    pub ScatterGatherElementCount: u32,
    pub ScatterGatherListSize: u32,
    pub LogicalPageCount: u32,
}
pub const DMA_TRANSFER_INFO_VERSION1: u32 = 1u32;
pub const DMA_TRANSFER_INFO_VERSION2: u32 = 2u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DMA_WIDTH(pub i32);
pub const DMA_ZERO_BUFFERS: u32 = 2u32;
pub const DOMAIN_COMMON_BUFFER_LARGE_PAGE: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DOMAIN_CONFIGURATION {
    pub Type: DOMAIN_CONFIGURATION_ARCH,
    pub Anonymous: DOMAIN_CONFIGURATION_0,
}
impl Default for DOMAIN_CONFIGURATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DOMAIN_CONFIGURATION_0 {
    pub Arm64: DOMAIN_CONFIGURATION_ARM64,
    pub X64: DOMAIN_CONFIGURATION_X64,
}
impl Default for DOMAIN_CONFIGURATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DOMAIN_CONFIGURATION_ARCH(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DOMAIN_CONFIGURATION_ARM64 {
    pub Ttbr0: i64,
    pub Ttbr1: i64,
    pub Mair0: u32,
    pub Mair1: u32,
    pub InputSize0: u8,
    pub InputSize1: u8,
    pub CoherentTableWalks: bool,
    pub TranslationEnabled: bool,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DOMAIN_CONFIGURATION_X64 {
    pub FirstLevelPageTableRoot: i64,
    pub TranslationEnabled: bool,
}
pub const DPC_NORMAL: u32 = 0u32;
pub const DPC_THREADED: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DPC_WATCHDOG_GLOBAL_TRIAGE_BLOCK {
    pub Signature: u32,
    pub Revision: u16,
    pub Size: u16,
    pub DpcWatchdogProfileOffset: u16,
    pub DpcWatchdogProfileLength: u32,
}
pub const DPC_WATCHDOG_GLOBAL_TRIAGE_BLOCK_REVISION_1: u32 = 1u32;
pub const DPC_WATCHDOG_GLOBAL_TRIAGE_BLOCK_SIGNATURE: u32 = 2931740382u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DRIVER_DIRECTORY_TYPE(pub i32);
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type DRIVER_LIST_CONTROL = Option<unsafe extern "system" fn(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP, scattergather: *const SCATTER_GATHER_LIST, context: *const core::ffi::c_void)>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DRIVER_REGKEY_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DRIVER_RUNTIME_INIT_FLAGS(pub i32);
pub const DRIVER_VERIFIER_FORCE_IRQL_CHECKING: u32 = 2u32;
pub const DRIVER_VERIFIER_INJECT_ALLOCATION_FAILURES: u32 = 4u32;
pub const DRIVER_VERIFIER_IO_CHECKING: u32 = 16u32;
pub const DRIVER_VERIFIER_SPECIAL_POOLING: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DRIVER_VERIFIER_THUNK_PAIRS {
    pub PristineRoutine: PDRIVER_VERIFIER_THUNK_ROUTINE,
    pub NewRoutine: PDRIVER_VERIFIER_THUNK_ROUTINE,
}
pub const DRIVER_VERIFIER_TRACK_POOL_ALLOCATIONS: u32 = 8u32;
pub const DRS_LEVEL: u32 = 14u32;
pub const DRVO_BOOTREINIT_REGISTERED: u32 = 32u32;
pub const DRVO_BUILTIN_DRIVER: u32 = 4u32;
pub const DRVO_INITIALIZED: u32 = 16u32;
pub const DRVO_LEGACY_DRIVER: u32 = 2u32;
pub const DRVO_LEGACY_RESOURCES: u32 = 64u32;
pub const DRVO_REINIT_REGISTERED: u32 = 8u32;
pub const DRVO_UNLOAD_INVOKED: u32 = 1u32;
pub const DUPLICATE_SAME_ATTRIBUTES: u32 = 4u32;
pub const DeallocateObject: IO_ALLOCATION_ACTION = IO_ALLOCATION_ACTION(2i32);
pub const DeallocateObjectKeepRegisters: IO_ALLOCATION_ACTION = IO_ALLOCATION_ACTION(3i32);
pub const DelayExecution: KWAIT_REASON = KWAIT_REASON(4i32);
pub const DelayedWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(1i32);
pub const DeleteSecurityDescriptor: SECURITY_OPERATION_CODE = SECURITY_OPERATION_CODE(2i32);
pub const DeviceDirectoryData: DEVICE_DIRECTORY_TYPE = DEVICE_DIRECTORY_TYPE(0i32);
pub const DevicePowerState: POWER_STATE_TYPE = POWER_STATE_TYPE(1i32);
pub const DevicePropertyAddress: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(16i32);
pub const DevicePropertyAllocatedResources: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(21i32);
pub const DevicePropertyBootConfiguration: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(3i32);
pub const DevicePropertyBootConfigurationTranslated: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4i32);
pub const DevicePropertyBusNumber: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(14i32);
pub const DevicePropertyBusTypeGuid: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(8204i32);
pub const DevicePropertyClassGuid: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4102i32);
pub const DevicePropertyClassName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4101i32);
pub const DevicePropertyCompatibleIDs: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(16386i32);
pub const DevicePropertyContainerID: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4118i32);
pub const DevicePropertyDeviceDescription: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4096i32);
pub const DevicePropertyDriverKeyName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4103i32);
pub const DevicePropertyEnumeratorName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4111i32);
pub const DevicePropertyFriendlyName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4105i32);
pub const DevicePropertyHardwareID: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(16385i32);
pub const DevicePropertyInstallState: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(18i32);
pub const DevicePropertyLegacyBusType: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(13i32);
pub const DevicePropertyLocationInformation: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4106i32);
pub const DevicePropertyManufacturer: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4104i32);
pub const DevicePropertyPhysicalDeviceObjectName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4107i32);
pub const DevicePropertyRemovalPolicy: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(19i32);
pub const DevicePropertyResourceRequirements: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(20i32);
pub const DevicePropertyUINumber: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(17i32);
pub const DeviceTextDescription: DEVICE_TEXT_TYPE = DEVICE_TEXT_TYPE(0i32);
pub const DeviceTextLocationInformation: DEVICE_TEXT_TYPE = DEVICE_TEXT_TYPE(1i32);
pub const DeviceUsageTypeBoot: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(4i32);
pub const DeviceUsageTypeDumpFile: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(3i32);
pub const DeviceUsageTypeGuestAssigned: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(6i32);
pub const DeviceUsageTypeHibernation: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(2i32);
pub const DeviceUsageTypePaging: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(1i32);
pub const DeviceUsageTypePostDisplay: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(5i32);
pub const DeviceUsageTypeUndefined: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(0i32);
pub const DeviceWakeDepthD0: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(1i32);
pub const DeviceWakeDepthD1: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(2i32);
pub const DeviceWakeDepthD2: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(3i32);
pub const DeviceWakeDepthD3cold: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(5i32);
pub const DeviceWakeDepthD3hot: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(4i32);
pub const DeviceWakeDepthMaximum: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(6i32);
pub const DeviceWakeDepthNotWakeable: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(0i32);
pub const DirectoryNotifyExtendedInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(2i32);
pub const DirectoryNotifyFullInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(3i32);
pub const DirectoryNotifyInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(1i32);
pub const DirectoryNotifyMaximumInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(4i32);
pub const DisabledControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(11i32);
pub const DiskController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(13i32);
pub const DiskIoNotifyRoutinesClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(11i32);
pub const DiskPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(25i32);
pub const DisplayController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(19i32);
pub const DmaAborted: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(1i32);
pub const DmaCancelled: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(3i32);
pub const DmaComplete: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(0i32);
pub const DmaError: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(2i32);
pub const DockingInformation: CONFIGURATION_TYPE = CONFIGURATION_TYPE(38i32);
pub const DomainConfigurationArm64: DOMAIN_CONFIGURATION_ARCH = DOMAIN_CONFIGURATION_ARCH(0i32);
pub const DomainConfigurationInvalid: DOMAIN_CONFIGURATION_ARCH = DOMAIN_CONFIGURATION_ARCH(2i32);
pub const DomainConfigurationX64: DOMAIN_CONFIGURATION_ARCH = DOMAIN_CONFIGURATION_ARCH(1i32);
pub const DomainTypeMax: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(3i32);
pub const DomainTypePassThrough: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(1i32);
pub const DomainTypeTranslate: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(0i32);
pub const DomainTypeUnmanaged: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(2i32);
pub const DriverDirectoryData: DRIVER_DIRECTORY_TYPE = DRIVER_DIRECTORY_TYPE(1i32);
pub const DriverDirectoryImage: DRIVER_DIRECTORY_TYPE = DRIVER_DIRECTORY_TYPE(0i32);
pub const DriverDirectorySharedData: DRIVER_DIRECTORY_TYPE = DRIVER_DIRECTORY_TYPE(2i32);
pub const DriverRegKeyParameters: DRIVER_REGKEY_TYPE = DRIVER_REGKEY_TYPE(0i32);
pub const DriverRegKeyPersistentState: DRIVER_REGKEY_TYPE = DRIVER_REGKEY_TYPE(1i32);
pub const DriverRegKeySharedPersistentState: DRIVER_REGKEY_TYPE = DRIVER_REGKEY_TYPE(2i32);
pub const DrvRtPoolNxOptIn: DRIVER_RUNTIME_INIT_FLAGS = DRIVER_RUNTIME_INIT_FLAGS(1i32);
pub const DtiAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(11i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct EFI_ACPI_RAS_SIGNAL_TABLE {
    pub Header: WHEA_ACPI_HEADER,
    pub NumberRecord: u32,
    pub Entries: [SIGNAL_REG_VALUE; 1],
}
impl Default for EFI_ACPI_RAS_SIGNAL_TABLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const EFLAG_SIGN: u32 = 32768u32;
pub const EFLAG_ZERO: u32 = 16384u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EISA_DMA_CONFIGURATION {
    pub ConfigurationByte0: DMA_CONFIGURATION_BYTE0,
    pub ConfigurationByte1: DMA_CONFIGURATION_BYTE1,
}
pub const EISA_EMPTY_SLOT: u32 = 131u32;
pub const EISA_FREE_FORM_DATA: u32 = 64u32;
pub const EISA_FUNCTION_ENABLED: u32 = 128u32;
pub const EISA_HAS_DMA_ENTRY: u32 = 8u32;
pub const EISA_HAS_IRQ_ENTRY: u32 = 4u32;
pub const EISA_HAS_MEMORY_ENTRY: u32 = 2u32;
pub const EISA_HAS_PORT_INIT_ENTRY: u32 = 32u32;
pub const EISA_HAS_PORT_RANGE: u32 = 16u32;
pub const EISA_HAS_TYPE_ENTRY: u32 = 1u32;
pub const EISA_INVALID_BIOS_CALL: u32 = 134u32;
pub const EISA_INVALID_CONFIGURATION: u32 = 130u32;
pub const EISA_INVALID_FUNCTION: u32 = 129u32;
pub const EISA_INVALID_SLOT: u32 = 128u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EISA_IRQ_CONFIGURATION {
    pub ConfigurationByte: EISA_IRQ_DESCRIPTOR,
    pub Reserved: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EISA_IRQ_DESCRIPTOR {
    pub _bitfield: u8,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct EISA_MEMORY_CONFIGURATION {
    pub ConfigurationByte: EISA_MEMORY_TYPE,
    pub DataSize: u8,
    pub AddressLowWord: u16,
    pub AddressHighByte: u8,
    pub MemorySize: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EISA_MEMORY_TYPE {
    pub _bitfield: u8,
}
pub const EISA_MEMORY_TYPE_RAM: u32 = 1u32;
pub const EISA_MORE_ENTRIES: u32 = 128u32;
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct EISA_PORT_CONFIGURATION {
    pub Configuration: EISA_PORT_DESCRIPTOR,
    pub PortAddress: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EISA_PORT_DESCRIPTOR {
    pub _bitfield: u8,
}
pub const EISA_SYSTEM_MEMORY: u32 = 0u32;
pub type ENABLE_VIRTUALIZATION = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, numvfs: u16, enablevfmigration: bool, enablemigrationinterrupt: bool, enablevirtualization: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub const ERROR_LOG_LIMIT_SIZE: u32 = 240u32;
pub const ERROR_MAJOR_REVISION_SAL_03_00: u32 = 0u32;
pub const ERROR_MEMORY_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf2_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_MINOR_REVISION_SAL_03_00: u32 = 2u32;
pub const ERROR_PCI_BUS_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf4_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PCI_COMPONENT_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf6_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PLATFORM_BUS_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf9_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PLATFORM_HOST_CONTROLLER_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf8_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PLATFORM_SPECIFIC_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf7_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PROCESSOR_STATE_PARAMETER_BUS_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_BUS_CHECK_SHIFT: u32 = 61u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_CACHE_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_CACHE_CHECK_SHIFT: u32 = 59u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_MICROARCH_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_MICROARCH_CHECK_SHIFT: u32 = 63u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_REG_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_REG_CHECK_SHIFT: u32 = 62u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_TLB_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_TLB_CHECK_SHIFT: u32 = 60u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_UNKNOWN_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_UNKNOWN_CHECK_SHIFT: u32 = 63u32;
pub const ERROR_SMBIOS_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf5_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_SYSTEM_EVENT_LOG_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe429faf3_3cb7_11d4_bca7_0080c73c8881);
pub const ERRTYP_BUS: u32 = 16u32;
pub const ERRTYP_CACHE: u32 = 6u32;
pub const ERRTYP_FLOW: u32 = 9u32;
pub const ERRTYP_FUNCTION: u32 = 7u32;
pub const ERRTYP_IMPROPER: u32 = 18u32;
pub const ERRTYP_INTERNAL: u32 = 1u32;
pub const ERRTYP_LOSSOFLOCKSTEP: u32 = 20u32;
pub const ERRTYP_MAP: u32 = 17u32;
pub const ERRTYP_MEM: u32 = 4u32;
pub const ERRTYP_PARITY: u32 = 22u32;
pub const ERRTYP_PATHERROR: u32 = 24u32;
pub const ERRTYP_POISONED: u32 = 26u32;
pub const ERRTYP_PROTOCOL: u32 = 23u32;
pub const ERRTYP_RESPONSE: u32 = 21u32;
pub const ERRTYP_SELFTEST: u32 = 8u32;
pub const ERRTYP_TIMEOUT: u32 = 25u32;
pub const ERRTYP_TLB: u32 = 5u32;
pub const ERRTYP_UNIMPL: u32 = 19u32;
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
pub type ETWENABLECALLBACK = Option<unsafe extern "system" fn(sourceid: *const windows_core::GUID, controlcode: u32, level: u8, matchanykeyword: u64, matchallkeyword: u64, filterdata: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_FILTER_DESCRIPTOR, callbackcontext: *mut core::ffi::c_void)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ETW_TRACE_SESSION_SETTINGS {
    pub Version: u32,
    pub BufferSize: u32,
    pub MinimumBuffers: u32,
    pub MaximumBuffers: u32,
    pub LoggerMode: u32,
    pub FlushTimer: u32,
    pub FlushThreshold: u32,
    pub ClockType: u32,
}
pub const EVENT_QUERY_STATE: u32 = 1u32;
pub const EXCEPTION_ALIGNMENT_CHECK: u32 = 17u32;
pub const EXCEPTION_BOUND_CHECK: u32 = 5u32;
pub const EXCEPTION_CP_FAULT: u32 = 21u32;
pub const EXCEPTION_DEBUG: u32 = 1u32;
pub const EXCEPTION_DIVIDED_BY_ZERO: u32 = 0u32;
pub const EXCEPTION_DOUBLE_FAULT: u32 = 8u32;
pub const EXCEPTION_GP_FAULT: u32 = 13u32;
pub const EXCEPTION_INT3: u32 = 3u32;
pub const EXCEPTION_INVALID_OPCODE: u32 = 6u32;
pub const EXCEPTION_INVALID_TSS: u32 = 10u32;
pub const EXCEPTION_NMI: u32 = 2u32;
pub const EXCEPTION_NPX_ERROR: u32 = 16u32;
pub const EXCEPTION_NPX_NOT_AVAILABLE: u32 = 7u32;
pub const EXCEPTION_NPX_OVERRUN: u32 = 9u32;
pub const EXCEPTION_RESERVED_TRAP: u32 = 15u32;
pub const EXCEPTION_SEGMENT_NOT_PRESENT: u32 = 11u32;
pub const EXCEPTION_SE_FAULT: u32 = 23u32;
pub const EXCEPTION_SOFTWARE_ORIGINATE: u32 = 128u32;
pub const EXCEPTION_STACK_FAULT: u32 = 12u32;
pub const EXCEPTION_VIRTUALIZATION_FAULT: u32 = 32u32;
pub type EXPAND_STACK_CALLOUT = Option<unsafe extern "system" fn(parameter: *const core::ffi::c_void)>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EXTENDED_AGP_REGISTER(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXTENDED_CREATE_INFORMATION {
    pub ExtendedCreateFlags: i64,
    pub EaBuffer: *mut core::ffi::c_void,
    pub EaLength: u32,
}
impl Default for EXTENDED_CREATE_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXTENDED_CREATE_INFORMATION_32 {
    pub ExtendedCreateFlags: i64,
    pub EaBuffer: *mut core::ffi::c_void,
    pub EaLength: u32,
}
impl Default for EXTENDED_CREATE_INFORMATION_32 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const EXTINT_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xfe84086e_b557_43cf_ac1b_17982e078470);
#[cfg(feature = "Wdk_Foundation")]
pub type EXT_CALLBACK = Option<unsafe extern "system" fn(timer: super::super::Foundation::PEX_TIMER, context: *const core::ffi::c_void)>;
pub type EXT_DELETE_CALLBACK = Option<unsafe extern "system" fn(context: *const core::ffi::c_void)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXT_DELETE_PARAMETERS {
    pub Version: u32,
    pub Reserved: u32,
    pub DeleteCallback: PEXT_DELETE_CALLBACK,
    pub DeleteContext: *mut core::ffi::c_void,
}
impl Default for EXT_DELETE_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type EX_CALLBACK_FUNCTION = Option<unsafe extern "system" fn(callbackcontext: *const core::ffi::c_void, argument1: *const core::ffi::c_void, argument2: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub const EX_CARR_ALLOCATE_NONPAGED_POOL: u32 = 1u32;
pub const EX_CARR_ALLOCATE_PAGED_POOL: u32 = 0u32;
pub const EX_CARR_DISABLE_EXPANSION: u32 = 2u32;
pub const EX_CREATE_FLAG_FILE_DEST_OPEN_FOR_COPY: u32 = 2u32;
pub const EX_CREATE_FLAG_FILE_SOURCE_OPEN_FOR_COPY: u32 = 1u32;
pub const EX_DEFAULT_PUSH_LOCK_FLAGS: u32 = 0u32;
pub const EX_LOOKASIDE_LIST_EX_FLAGS_FAIL_NO_RAISE: u32 = 2u32;
pub const EX_LOOKASIDE_LIST_EX_FLAGS_RAISE_ON_FAIL: u32 = 1u32;
pub const EX_MAXIMUM_LOOKASIDE_DEPTH_BASE: u32 = 256u32;
pub const EX_MAXIMUM_LOOKASIDE_DEPTH_LIMIT: u32 = 1024u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EX_POOL_PRIORITY(pub i32);
pub const EX_RUNDOWN_ACTIVE: u32 = 1u32;
pub const EX_RUNDOWN_COUNT_SHIFT: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct EX_RUNDOWN_REF {
    pub Anonymous: EX_RUNDOWN_REF_0,
}
impl Default for EX_RUNDOWN_REF {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union EX_RUNDOWN_REF_0 {
    pub Count: usize,
    pub Ptr: *mut core::ffi::c_void,
}
impl Default for EX_RUNDOWN_REF_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const EX_TIMER_HIGH_RESOLUTION: u32 = 4u32;
pub const EX_TIMER_NO_WAKE: u32 = 8u32;
pub const Eisa: INTERFACE_TYPE = INTERFACE_TYPE(2i32);
pub const EisaAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(8i32);
pub const EisaConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(1i32);
pub const EjectionRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(1i32);
pub const EndAlternatives: ALTERNATIVE_ARCHITECTURE_TYPE = ALTERNATIVE_ARCHITECTURE_TYPE(2i32);
pub const EventCategoryDeviceInterfaceChange: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(2i32);
pub const EventCategoryHardwareProfileChange: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(1i32);
pub const EventCategoryKernelSoftRestart: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(4i32);
pub const EventCategoryReserved: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(0i32);
pub const EventCategoryTargetDeviceChange: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(3i32);
pub const EventLoggerHandleClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(5i32);
pub const Executive: KWAIT_REASON = KWAIT_REASON(0i32);
pub const ExternalFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(3i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub struct FAULT_INFORMATION {
    pub Type: FAULT_INFORMATION_ARCH,
    pub IsStage1: bool,
    pub Anonymous: FAULT_INFORMATION_0,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for FAULT_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub union FAULT_INFORMATION_0 {
    pub Arm64: FAULT_INFORMATION_ARM64,
    pub X64: FAULT_INFORMATION_X64,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for FAULT_INFORMATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FAULT_INFORMATION_ARCH(pub i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FAULT_INFORMATION_ARM64 {
    pub DomainHandle: *mut core::ffi::c_void,
    pub FaultAddress: *mut core::ffi::c_void,
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub InputMappingId: u32,
    pub Flags: FAULT_INFORMATION_ARM64_FLAGS,
    pub Type: FAULT_INFORMATION_ARM64_TYPE,
    pub IommuBaseAddress: u64,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for FAULT_INFORMATION_ARM64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FAULT_INFORMATION_ARM64_FLAGS {
    pub _bitfield: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FAULT_INFORMATION_ARM64_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FAULT_INFORMATION_X64 {
    pub DomainHandle: *mut core::ffi::c_void,
    pub FaultAddress: *mut core::ffi::c_void,
    pub Flags: FAULT_INFORMATION_X64_FLAGS,
    pub Type: FAULT_INFORMATION_ARM64_TYPE,
    pub IommuBaseAddress: u64,
    pub PciSegment: u32,
}
impl Default for FAULT_INFORMATION_X64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FAULT_INFORMATION_X64_FLAGS {
    pub _bitfield: u32,
}
pub const FILE_128_BYTE_ALIGNMENT: u32 = 127u32;
pub const FILE_256_BYTE_ALIGNMENT: u32 = 255u32;
pub const FILE_32_BYTE_ALIGNMENT: u32 = 31u32;
pub const FILE_512_BYTE_ALIGNMENT: u32 = 511u32;
pub const FILE_64_BYTE_ALIGNMENT: u32 = 63u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_ATTRIBUTE_TAG_INFORMATION {
    pub FileAttributes: u32,
    pub ReparseTag: u32,
}
pub const FILE_ATTRIBUTE_VALID_FLAGS: u32 = 32695u32;
pub const FILE_ATTRIBUTE_VALID_KERNEL_SET_FLAGS: u32 = 5910951u32;
pub const FILE_ATTRIBUTE_VALID_SET_FLAGS: u32 = 12711u32;
pub const FILE_AUTOGENERATED_DEVICE_NAME: u32 = 128u32;
pub const FILE_BYTE_ALIGNMENT: u32 = 0u32;
pub const FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL: u32 = 512u32;
pub const FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_DEPRECATED: u32 = 512u32;
pub const FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_EX: u32 = 16384u32;
pub const FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL: u32 = 768u32;
pub const FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_DEPRECATED: u32 = 768u32;
pub const FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_EX: u32 = 32768u32;
pub const FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK: u32 = 768u32;
pub const FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK_DEPRECATED: u32 = 768u32;
pub const FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK_EX: u32 = 768u32;
pub const FILE_CHARACTERISTIC_CSV: u32 = 65536u32;
pub const FILE_CHARACTERISTIC_PNP_DEVICE: u32 = 2048u32;
pub const FILE_CHARACTERISTIC_TS_DEVICE: u32 = 4096u32;
pub const FILE_CHARACTERISTIC_WEBDAV_DEVICE: u32 = 8192u32;
pub const FILE_DEVICE_ALLOW_APPCONTAINER_TRAVERSAL: u32 = 131072u32;
pub const FILE_DEVICE_IS_MOUNTED: u32 = 32u32;
pub const FILE_DEVICE_REQUIRE_SECURITY_CHECK: u32 = 1048576u32;
pub const FILE_DEVICE_SECURE_OPEN: u32 = 256u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_END_OF_FILE_INFORMATION {
    pub EndOfFile: i64,
}
pub const FILE_FLOPPY_DISKETTE: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_FS_DEVICE_INFORMATION {
    pub DeviceType: u32,
    pub Characteristics: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_FS_FULL_SIZE_INFORMATION {
    pub TotalAllocationUnits: i64,
    pub CallerAvailableAllocationUnits: i64,
    pub ActualAvailableAllocationUnits: i64,
    pub SectorsPerAllocationUnit: u32,
    pub BytesPerSector: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_FS_FULL_SIZE_INFORMATION_EX {
    pub ActualTotalAllocationUnits: u64,
    pub ActualAvailableAllocationUnits: u64,
    pub ActualPoolUnavailableAllocationUnits: u64,
    pub CallerTotalAllocationUnits: u64,
    pub CallerAvailableAllocationUnits: u64,
    pub CallerPoolUnavailableAllocationUnits: u64,
    pub UsedAllocationUnits: u64,
    pub TotalReservedAllocationUnits: u64,
    pub VolumeStorageReserveAllocationUnits: u64,
    pub AvailableCommittedAllocationUnits: u64,
    pub PoolAvailableAllocationUnits: u64,
    pub SectorsPerAllocationUnit: u32,
    pub BytesPerSector: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FILE_FS_LABEL_INFORMATION {
    pub VolumeLabelLength: u32,
    pub VolumeLabel: [u16; 1],
}
impl Default for FILE_FS_LABEL_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_FS_METADATA_SIZE_INFORMATION {
    pub TotalMetadataAllocationUnits: i64,
    pub SectorsPerAllocationUnit: u32,
    pub BytesPerSector: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FILE_FS_OBJECTID_INFORMATION {
    pub ObjectId: [u8; 16],
    pub ExtendedInfo: [u8; 48],
}
impl Default for FILE_FS_OBJECTID_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_FS_SIZE_INFORMATION {
    pub TotalAllocationUnits: i64,
    pub AvailableAllocationUnits: i64,
    pub SectorsPerAllocationUnit: u32,
    pub BytesPerSector: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FILE_FS_VOLUME_INFORMATION {
    pub VolumeCreationTime: i64,
    pub VolumeSerialNumber: u32,
    pub VolumeLabelLength: u32,
    pub SupportsObjects: bool,
    pub VolumeLabel: [u16; 1],
}
impl Default for FILE_FS_VOLUME_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FILE_IOSTATUSBLOCK_RANGE_INFORMATION {
    pub IoStatusBlockRange: *mut u8,
    pub Length: u32,
}
impl Default for FILE_IOSTATUSBLOCK_RANGE_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_IO_COMPLETION_NOTIFICATION_INFORMATION {
    pub Flags: u32,
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_IO_PRIORITY_HINT_INFORMATION {
    pub PriorityHint: super::super::Foundation::IO_PRIORITY_HINT,
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_IO_PRIORITY_HINT_INFORMATION_EX {
    pub PriorityHint: super::super::Foundation::IO_PRIORITY_HINT,
    pub BoostOutstanding: bool,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_IS_REMOTE_DEVICE_INFORMATION {
    pub IsRemote: bool,
}
pub const FILE_LONG_ALIGNMENT: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct FILE_MEMORY_PARTITION_INFORMATION {
    pub OwnerPartitionHandle: usize,
    pub Flags: FILE_MEMORY_PARTITION_INFORMATION_0,
}
impl Default for FILE_MEMORY_PARTITION_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union FILE_MEMORY_PARTITION_INFORMATION_0 {
    pub Anonymous: FILE_MEMORY_PARTITION_INFORMATION_0_0,
    pub AllFlags: u32,
}
impl Default for FILE_MEMORY_PARTITION_INFORMATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FILE_MEMORY_PARTITION_INFORMATION_0_0 {
    pub NoCrossPartitionAccess: u8,
    pub Spare: [u8; 3],
}
impl Default for FILE_MEMORY_PARTITION_INFORMATION_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_NUMA_NODE_INFORMATION {
    pub NodeNumber: u16,
}
pub const FILE_OCTA_ALIGNMENT: u32 = 15u32;
pub const FILE_PORTABLE_DEVICE: u32 = 262144u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FILE_PROCESS_IDS_USING_FILE_INFORMATION {
    pub NumberOfProcessIdsInList: u32,
    pub ProcessIdList: [usize; 1],
}
impl Default for FILE_PROCESS_IDS_USING_FILE_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const FILE_QUAD_ALIGNMENT: u32 = 7u32;
pub const FILE_QUERY_INDEX_SPECIFIED: u32 = 4u32;
pub const FILE_QUERY_NO_CURSOR_UPDATE: u32 = 16u32;
pub const FILE_QUERY_RESTART_SCAN: u32 = 1u32;
pub const FILE_QUERY_RETURN_ON_DISK_ENTRIES_ONLY: u32 = 8u32;
pub const FILE_QUERY_RETURN_SINGLE_ENTRY: u32 = 2u32;
pub const FILE_READ_ONLY_DEVICE: u32 = 2u32;
pub const FILE_REMOTE_DEVICE: u32 = 16u32;
pub const FILE_REMOTE_DEVICE_VSMB: u32 = 524288u32;
pub const FILE_REMOVABLE_MEDIA: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_SFIO_RESERVE_INFORMATION {
    pub RequestsPerPeriod: u32,
    pub Period: u32,
    pub RetryFailures: bool,
    pub Discardable: bool,
    pub RequestSize: u32,
    pub NumOutstandingRequests: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_SFIO_VOLUME_INFORMATION {
    pub MaximumRequestsPerPeriod: u32,
    pub MinimumPeriod: u32,
    pub MinimumTransferSize: u32,
}
pub const FILE_SHARE_VALID_FLAGS: u32 = 7u32;
pub const FILE_SKIP_SET_USER_EVENT_ON_FAST_IO: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_STANDARD_INFORMATION_EX {
    pub AllocationSize: i64,
    pub EndOfFile: i64,
    pub NumberOfLinks: u32,
    pub DeletePending: bool,
    pub Directory: bool,
    pub AlternateStream: bool,
    pub MetadataAttribute: bool,
}
pub const FILE_USE_FILE_POINTER_POSITION: u32 = 4294967294u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FILE_VALID_DATA_LENGTH_INFORMATION {
    pub ValidDataLength: i64,
}
pub const FILE_VALID_EXTENDED_OPTION_FLAGS: u32 = 268435456u32;
pub const FILE_VIRTUAL_VOLUME: u32 = 64u32;
pub const FILE_WORD_ALIGNMENT: u32 = 1u32;
pub const FILE_WRITE_ONCE_MEDIA: u32 = 8u32;
pub const FILE_WRITE_TO_END_OF_FILE: u32 = 4294967295u32;
pub const FIRMWARE_ERROR_RECORD_REFERENCE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x81212a96_09ed_4996_9471_8d729c8e69ed);
pub const FLAG_OWNER_POINTER_IS_THREAD: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FLOATING_SAVE_AREA {
    pub ControlWord: u32,
    pub StatusWord: u32,
    pub TagWord: u32,
    pub ErrorOffset: u32,
    pub ErrorSelector: u32,
    pub DataOffset: u32,
    pub DataSelector: u32,
    pub RegisterArea: [u8; 80],
    pub Spare0: u32,
}
impl Default for FLOATING_SAVE_AREA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const FLUSH_MULTIPLE_MAXIMUM: u32 = 32u32;
pub const FM_LOCK_BIT: u32 = 1u32;
pub const FM_LOCK_BIT_V: u32 = 0u32;
pub const FO_ALERTABLE_IO: u32 = 4u32;
pub const FO_BYPASS_IO_ENABLED: u32 = 8388608u32;
pub const FO_CACHE_SUPPORTED: u32 = 64u32;
pub const FO_CLEANUP_COMPLETE: u32 = 16384u32;
pub const FO_DELETE_ON_CLOSE: u32 = 65536u32;
pub const FO_DIRECT_DEVICE_OPEN: u32 = 2048u32;
pub const FO_DISALLOW_EXCLUSIVE: u32 = 33554432u32;
pub const FO_FILE_FAST_IO_READ: u32 = 524288u32;
pub const FO_FILE_MODIFIED: u32 = 4096u32;
pub const FO_FILE_OPEN: u32 = 1u32;
pub const FO_FILE_OPEN_CANCELLED: u32 = 2097152u32;
pub const FO_FILE_SIZE_CHANGED: u32 = 8192u32;
pub const FO_FLAGS_VALID_ONLY_DURING_CREATE: u32 = 33554432u32;
pub const FO_GENERATE_AUDIT_ON_CLOSE: u32 = 1024u32;
pub const FO_HANDLE_CREATED: u32 = 262144u32;
pub const FO_INDIRECT_WAIT_OBJECT: u32 = 268435456u32;
pub const FO_MAILSLOT: u32 = 512u32;
pub const FO_NAMED_PIPE: u32 = 128u32;
pub const FO_NO_INTERMEDIATE_BUFFERING: u32 = 8u32;
pub const FO_OPENED_CASE_SENSITIVE: u32 = 131072u32;
pub const FO_QUEUE_IRP_TO_THREAD: u32 = 1024u32;
pub const FO_RANDOM_ACCESS: u32 = 1048576u32;
pub const FO_REMOTE_ORIGIN: u32 = 16777216u32;
pub const FO_SECTION_MINSTORE_TREATMENT: u32 = 536870912u32;
pub const FO_SEQUENTIAL_ONLY: u32 = 32u32;
pub const FO_SKIP_COMPLETION_PORT: u32 = 33554432u32;
pub const FO_SKIP_SET_EVENT: u32 = 67108864u32;
pub const FO_SKIP_SET_FAST_IO: u32 = 134217728u32;
pub const FO_STREAM_FILE: u32 = 256u32;
pub const FO_SYNCHRONOUS_IO: u32 = 2u32;
pub const FO_TEMPORARY_FILE: u32 = 32768u32;
pub const FO_VOLUME_OPEN: u32 = 4194304u32;
pub const FO_WRITE_THROUGH: u32 = 16u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_16GB: u32 = 6u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_1GB: u32 = 2u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_1MB: u32 = 9u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_256MB: u32 = 0u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_2GB: u32 = 3u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_32GB: u32 = 7u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_4GB: u32 = 4u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_512MB: u32 = 1u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_8GB: u32 = 5u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_16MB: u32 = 4u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_1MB: u32 = 0u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_2MB: u32 = 1u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_4MB: u32 = 2u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_8MB: u32 = 3u32;
pub const FPB_MEM_VECTOR_GRANULARITY_1B: u32 = 8u32;
pub const FPB_RID_VECTOR_GRANULARITY_256RIDS: u32 = 5u32;
pub const FPB_RID_VECTOR_GRANULARITY_64RIDS: u32 = 3u32;
pub const FPB_RID_VECTOR_GRANULARITY_8RIDS: u32 = 0u32;
pub const FPB_VECTOR_SELECT_MEM_HIGH: u32 = 2u32;
pub const FPB_VECTOR_SELECT_MEM_LOW: u32 = 1u32;
pub const FPB_VECTOR_SELECT_RID: u32 = 0u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_1KBITS: u32 = 2u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_256BITS: u32 = 0u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_2KBITS: u32 = 3u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_4KBITS: u32 = 4u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_512BITS: u32 = 1u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_8KBITS: u32 = 5u32;
pub type FPGA_BUS_SCAN = Option<unsafe extern "system" fn(context: *const core::ffi::c_void)>;
pub type FPGA_CONTROL_CONFIG_SPACE = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, enable: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type FPGA_CONTROL_ERROR_REPORTING = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, uncorrectablemask: u32, correctablemask: u32, disableerrorreporting: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FPGA_CONTROL_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub BusScan: PFPGA_BUS_SCAN,
    pub ControlLink: PFPGA_CONTROL_LINK,
    pub ControlConfigSpace: PFPGA_CONTROL_CONFIG_SPACE,
    pub ControlErrorReporting: PFPGA_CONTROL_ERROR_REPORTING,
}
impl Default for FPGA_CONTROL_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type FPGA_CONTROL_LINK = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, enable: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type FREE_FUNCTION = Option<unsafe extern "system" fn(buffer: *const core::ffi::c_void)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct FUNCTION_LEVEL_DEVICE_RESET_PARAMETERS {
    pub Size: u32,
    pub DeviceResetCompletion: PDEVICE_RESET_COMPLETION,
    pub CompletionContext: *mut core::ffi::c_void,
}
impl Default for FUNCTION_LEVEL_DEVICE_RESET_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type FWMI_NOTIFICATION_CALLBACK = Option<unsafe extern "system" fn(wnode: *mut core::ffi::c_void, context: *mut core::ffi::c_void)>;
pub const FailControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(4i32);
pub const FaultInformationArm64: FAULT_INFORMATION_ARCH = FAULT_INFORMATION_ARCH(1i32);
pub const FaultInformationInvalid: FAULT_INFORMATION_ARCH = FAULT_INFORMATION_ARCH(0i32);
pub const FaultInformationX64: FAULT_INFORMATION_ARCH = FAULT_INFORMATION_ARCH(2i32);
pub const FloatingPointProcessor: CONFIGURATION_TYPE = CONFIGURATION_TYPE(2i32);
pub const FloppyDiskPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(26i32);
pub const FltIoNotifyRoutinesClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(13i32);
pub const FreePage: KWAIT_REASON = KWAIT_REASON(1i32);
pub const FunctionLevelDeviceReset: DEVICE_RESET_TYPE = DEVICE_RESET_TYPE(0i32);
pub const GENERIC_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x3e62a467_ab40_409a_a698_f362d464b38f);
pub const GENERIC_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe71254e8_c1b9_4940_ab76_909703a4320f);
pub const GENPROC_FLAGS_CORRECTED: u32 = 8u32;
pub const GENPROC_FLAGS_OVERFLOW: u32 = 4u32;
pub const GENPROC_FLAGS_PRECISEIP: u32 = 2u32;
pub const GENPROC_FLAGS_RESTARTABLE: u32 = 1u32;
pub const GENPROC_OP_DATAREAD: u32 = 1u32;
pub const GENPROC_OP_DATAWRITE: u32 = 2u32;
pub const GENPROC_OP_GENERIC: u32 = 0u32;
pub const GENPROC_OP_INSTRUCTIONEXE: u32 = 3u32;
pub const GENPROC_PROCERRTYPE_BUS: u32 = 4u32;
pub const GENPROC_PROCERRTYPE_CACHE: u32 = 1u32;
pub const GENPROC_PROCERRTYPE_MAE: u32 = 8u32;
pub const GENPROC_PROCERRTYPE_TLB: u32 = 2u32;
pub const GENPROC_PROCERRTYPE_UNKNOWN: u32 = 0u32;
pub const GENPROC_PROCISA_ARM32: u32 = 4u32;
pub const GENPROC_PROCISA_ARM64: u32 = 8u32;
pub const GENPROC_PROCISA_IPF: u32 = 1u32;
pub const GENPROC_PROCISA_X64: u32 = 2u32;
pub const GENPROC_PROCISA_X86: u32 = 0u32;
pub const GENPROC_PROCTYPE_ARM: u32 = 2u32;
pub const GENPROC_PROCTYPE_IPF: u32 = 1u32;
pub const GENPROC_PROCTYPE_XPF: u32 = 0u32;
pub type GET_D3COLD_CAPABILITY = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, d3coldsupported: *mut bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type GET_D3COLD_LAST_TRANSITION_STATUS = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, lasttransitionstatus: *mut D3COLD_LAST_TRANSITION_STATUS)>;
pub type GET_DEVICE_RESET_STATUS = Option<unsafe extern "system" fn(interfacecontext: *const core::ffi::c_void, isresetting: *mut bool, resettypeselected: *mut DEVICE_BUS_SPECIFIC_RESET_TYPE, flags: *mut DEVICE_RESET_STATUS_FLAGS) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type GET_DMA_ADAPTER = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, devicedescriptor: *const DEVICE_DESCRIPTION, numberofmapregisters: *mut u32) -> *mut DMA_ADAPTER>;
#[cfg(feature = "Win32_System_Power")]
pub type GET_IDLE_WAKE_INFO = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, systempowerstate: super::super::super::Win32::System::Power::SYSTEM_POWER_STATE, deepestwakeabledstate: *mut DEVICE_WAKE_DEPTH) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type GET_SDEV_IDENTIFIER = Option<unsafe extern "system" fn(interfacecontext: *const core::ffi::c_void) -> u64>;
pub type GET_SET_DEVICE_DATA = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, datatype: u32, buffer: *mut core::ffi::c_void, offset: u32, length: u32) -> u32>;
pub type GET_UPDATED_BUS_RESOURCE = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, updatedresourcelist: *mut *mut CM_RESOURCE_LIST, updatedtranslatedresourcelist: *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type GET_VIRTUAL_DEVICE_DATA = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, virtualfunction: u16, buffer: *mut core::ffi::c_void, offset: u32, length: u32) -> u32>;
pub type GET_VIRTUAL_DEVICE_LOCATION = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, virtualfunction: u16, segmentnumber: *mut u16, busnumber: *mut u8, functionnumber: *mut u8) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type GET_VIRTUAL_DEVICE_RESOURCES = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, capturedbusnumbers: *mut u8)>;
pub type GET_VIRTUAL_FUNCTION_PROBED_BARS = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, baseregistervalues: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub const GUID_ECP_CREATE_USER_PROCESS: windows_core::GUID = windows_core::GUID::from_u128(0xe0e429ff_6ddc_4e65_aab6_45d05a038a08);
pub const GartHigh: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(5i32);
pub const GartLow: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(4i32);
pub const GenericEqual: RTL_GENERIC_COMPARE_RESULTS = RTL_GENERIC_COMPARE_RESULTS(2i32);
pub const GenericGreaterThan: RTL_GENERIC_COMPARE_RESULTS = RTL_GENERIC_COMPARE_RESULTS(1i32);
pub const GenericLessThan: RTL_GENERIC_COMPARE_RESULTS = RTL_GENERIC_COMPARE_RESULTS(0i32);
pub const GlobalLoggerHandleClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(4i32);
pub const GroupAffinityAllGroupZero: IRQ_GROUP_POLICY = IRQ_GROUP_POLICY(0i32);
pub const GroupAffinityDontCare: IRQ_GROUP_POLICY = IRQ_GROUP_POLICY(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_AMLI_BAD_IO_ADDRESS_LIST {
    pub BadAddrBegin: u32,
    pub BadAddrSize: u32,
    pub OSVersionTrigger: u32,
    pub IOHandler: PHALIOREADWRITEHANDLER,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HAL_APIC_DESTINATION_MODE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_BUS_INFORMATION {
    pub BusType: INTERFACE_TYPE,
    pub ConfigurationType: BUS_DATA_TYPE,
    pub BusNumber: u32,
    pub Reserved: u32,
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_CALLBACKS {
    pub SetSystemInformation: super::super::Foundation::PCALLBACK_OBJECT,
    pub BusCheck: super::super::Foundation::PCALLBACK_OBJECT,
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_DISPATCH {
    pub Version: u32,
    pub HalQuerySystemInformation: pHalQuerySystemInformation,
    pub HalSetSystemInformation: pHalSetSystemInformation,
    pub HalQueryBusSlots: pHalQueryBusSlots,
    pub Spare1: u32,
    pub HalExamineMBR: pHalExamineMBR,
    pub HalIoReadPartitionTable: pHalIoReadPartitionTable,
    pub HalIoSetPartitionInformation: pHalIoSetPartitionInformation,
    pub HalIoWritePartitionTable: pHalIoWritePartitionTable,
    pub HalReferenceHandlerForBus: pHalHandlerForBus,
    pub HalReferenceBusHandler: pHalReferenceBusHandler,
    pub HalDereferenceBusHandler: pHalReferenceBusHandler,
    pub HalInitPnpDriver: pHalInitPnpDriver,
    pub HalInitPowerManagement: pHalInitPowerManagement,
    pub HalGetDmaAdapter: pHalGetDmaAdapter,
    pub HalGetInterruptTranslator: pHalGetInterruptTranslator,
    pub HalStartMirroring: pHalStartMirroring,
    pub HalEndMirroring: pHalEndMirroring,
    pub HalMirrorPhysicalMemory: pHalMirrorPhysicalMemory,
    pub HalEndOfBoot: pHalEndOfBoot,
    pub HalMirrorVerify: pHalMirrorVerify,
    pub HalGetCachedAcpiTable: pHalGetAcpiTable,
    pub HalSetPciErrorHandlerCallback: pHalSetPciErrorHandlerCallback,
    pub HalGetPrmCache: pHalGetPrmCache,
}
pub const HAL_DISPATCH_VERSION: u32 = 5u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HAL_DISPLAY_BIOS_INFORMATION(pub i32);
pub const HAL_DMA_ADAPTER_VERSION_1: u32 = 1u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HAL_DMA_CRASH_DUMP_REGISTER_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct HAL_ERROR_INFO {
    pub Version: u32,
    pub InitMaxSize: u32,
    pub McaMaxSize: u32,
    pub McaPreviousEventsCount: u32,
    pub McaCorrectedEventsCount: u32,
    pub McaKernelDeliveryFails: u32,
    pub McaDriverDpcQueueFails: u32,
    pub McaReserved: u32,
    pub CmcMaxSize: u32,
    pub CmcPollingInterval: u32,
    pub CmcInterruptsCount: u32,
    pub CmcKernelDeliveryFails: u32,
    pub CmcDriverDpcQueueFails: u32,
    pub CmcGetStateFails: u32,
    pub CmcClearStateFails: u32,
    pub CmcReserved: u32,
    pub CmcLogId: u64,
    pub CpeMaxSize: u32,
    pub CpePollingInterval: u32,
    pub CpeInterruptsCount: u32,
    pub CpeKernelDeliveryFails: u32,
    pub CpeDriverDpcQueueFails: u32,
    pub CpeGetStateFails: u32,
    pub CpeClearStateFails: u32,
    pub CpeInterruptSources: u32,
    pub CpeLogId: u64,
    pub KernelReserved: [u64; 4],
}
impl Default for HAL_ERROR_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const HAL_MASK_UNMASK_FLAGS_NONE: u32 = 0u32;
pub const HAL_MASK_UNMASK_FLAGS_SERVICING_COMPLETE: u32 = 2u32;
pub const HAL_MASK_UNMASK_FLAGS_SERVICING_DEFERRED: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_MCA_INTERFACE {
    pub Lock: PHALMCAINTERFACELOCK,
    pub Unlock: PHALMCAINTERFACEUNLOCK,
    pub ReadRegister: PHALMCAINTERFACEREADREGISTER,
}
pub const HAL_MCA_RECORD: MCA_EXCEPTION_TYPE = MCA_EXCEPTION_TYPE(1i32);
pub const HAL_MCE_RECORD: MCA_EXCEPTION_TYPE = MCA_EXCEPTION_TYPE(0i32);
pub const HAL_PLATFORM_ACPI_TABLES_CACHED: i32 = 32i32;
pub const HAL_PLATFORM_DISABLE_PTCG: i32 = 4i32;
pub const HAL_PLATFORM_DISABLE_UC_MAIN_MEMORY: i32 = 8i32;
pub const HAL_PLATFORM_DISABLE_WRITE_COMBINING: i32 = 1i32;
pub const HAL_PLATFORM_ENABLE_WRITE_COMBINING_MMIO: i32 = 16i32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_PLATFORM_INFORMATION {
    pub PlatformFlags: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_POWER_INFORMATION {
    pub TBD: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_PROCESSOR_FEATURE {
    pub UsableFeatureBits: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HAL_PROCESSOR_SPEED_INFORMATION {
    pub ProcessorSpeed: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HAL_QUERY_INFORMATION_CLASS(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HAL_SET_INFORMATION_CLASS(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HARDWARE_COUNTER {
    pub Type: HARDWARE_COUNTER_TYPE,
    pub Reserved: u32,
    pub Index: u64,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HARDWARE_COUNTER_TYPE(pub i32);
pub const HASH_STRING_ALGORITHM_DEFAULT: u32 = 0u32;
pub const HASH_STRING_ALGORITHM_INVALID: u32 = 4294967295u32;
pub const HASH_STRING_ALGORITHM_X65599: u32 = 1u32;
pub const HIGH_LEVEL: u32 = 31u32;
pub const HIGH_PRIORITY: u32 = 31u32;
pub type HVL_WHEA_ERROR_NOTIFICATION = Option<unsafe extern "system" fn(recoverycontext: *const WHEA_RECOVERY_CONTEXT, platformdirected: bool, poisoned: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HWPROFILE_CHANGE_NOTIFICATION {
    pub Version: u16,
    pub Size: u16,
    pub Event: windows_core::GUID,
}
pub const HalAcpiAuditInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(26i32);
pub const HalCallbackInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(5i32);
pub const HalChannelTopologyInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(31i32);
pub const HalCmcLog: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(7i32);
pub const HalCmcLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(13i32);
pub const HalCmcRegisterDriver: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(4i32);
pub const HalCpeLog: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(8i32);
pub const HalCpeLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(14i32);
pub const HalCpeRegisterDriver: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(5i32);
pub const HalDisplayBiosInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(9i32);
pub const HalDisplayEmulatedBios: HAL_DISPLAY_BIOS_INFORMATION = HAL_DISPLAY_BIOS_INFORMATION(1i32);
pub const HalDisplayInt10Bios: HAL_DISPLAY_BIOS_INFORMATION = HAL_DISPLAY_BIOS_INFORMATION(0i32);
pub const HalDisplayNoBios: HAL_DISPLAY_BIOS_INFORMATION = HAL_DISPLAY_BIOS_INFORMATION(2i32);
pub const HalDmaCrashDumpRegisterSet1: HAL_DMA_CRASH_DUMP_REGISTER_TYPE = HAL_DMA_CRASH_DUMP_REGISTER_TYPE(0i32);
pub const HalDmaCrashDumpRegisterSet2: HAL_DMA_CRASH_DUMP_REGISTER_TYPE = HAL_DMA_CRASH_DUMP_REGISTER_TYPE(1i32);
pub const HalDmaCrashDumpRegisterSetMax: HAL_DMA_CRASH_DUMP_REGISTER_TYPE = HAL_DMA_CRASH_DUMP_REGISTER_TYPE(2i32);
pub const HalDmaRemappingInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(47i32);
pub const HalEnlightenment: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(11i32);
pub const HalErrorInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(12i32);
pub const HalExternalCacheInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(32i32);
pub const HalFrameBufferCachingInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(8i32);
pub const HalFrequencyInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(22i32);
pub const HalFwBootPerformanceInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(34i32);
pub const HalFwS3PerformanceInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(35i32);
pub const HalGenerateCmcInterrupt: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(9i32);
pub const HalGetChannelPowerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(36i32);
pub const HalHardwareWatchdogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(46i32);
pub const HalHeterogeneousMemoryAttributesInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(49i32);
pub const HalHypervisorInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(24i32);
pub const HalI386ExceptionChainTerminatorInformation: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(15i32);
pub const HalInformationClassUnused1: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(2i32);
pub const HalInitLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(21i32);
pub const HalInstalledBusInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(0i32);
pub const HalInterruptControllerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(39i32);
pub const HalIrtInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(27i32);
pub const HalKernelErrorHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(3i32);
pub const HalMapRegisterInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(6i32);
pub const HalMcaLog: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(6i32);
pub const HalMcaLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(7i32);
pub const HalMcaRegisterDriver: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(2i32);
pub const HalNumaRangeTableInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(30i32);
pub const HalNumaTopologyInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(11i32);
pub const HalParkingPageInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(29i32);
pub const HalPartitionIpiInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(18i32);
pub const HalPlatformInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(19i32);
pub const HalPlatformTimerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(25i32);
pub const HalPowerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(3i32);
pub const HalProcessorBrandString: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(23i32);
pub const HalProcessorFeatureInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(10i32);
pub const HalProcessorSpeedInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(4i32);
pub const HalProfileDpgoSourceInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(12i32);
pub const HalProfileSourceAdd: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(20i32);
pub const HalProfileSourceInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(1i32);
pub const HalProfileSourceInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(1i32);
pub const HalProfileSourceInterval: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(0i32);
pub const HalProfileSourceRemove: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(21i32);
pub const HalProfileSourceTimerHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(10i32);
pub const HalPsciInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(38i32);
pub const HalQueryAMLIIllegalIOPortAddresses: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(16i32);
pub const HalQueryAcpiWakeAlarmSystemPowerStateInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(43i32);
pub const HalQueryArmErrataInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(41i32);
pub const HalQueryDebuggerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(33i32);
pub const HalQueryHyperlaunchEntrypoint: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(45i32);
pub const HalQueryIommuReservedRegionInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(40i32);
pub const HalQueryMaxHotPlugMemoryAddress: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(17i32);
pub const HalQueryMcaInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(15i32);
pub const HalQueryPerDeviceMsiLimitInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(50i32);
pub const HalQueryProcessorEfficiencyInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(42i32);
pub const HalQueryProfileCorruptionStatus: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(51i32);
pub const HalQueryProfileCounterOwnership: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(52i32);
pub const HalQueryProfileNumberOfCounters: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(44i32);
pub const HalQueryProfileSourceList: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(20i32);
pub const HalQueryStateElementInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(37i32);
pub const HalQueryUnused0001: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(48i32);
pub const HalRegisterSecondaryInterruptInterface: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(13i32);
pub const HalSecondaryInterruptInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(28i32);
pub const HalSetChannelPowerInformation: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(14i32);
pub const HalSetClockTimerMinimumInterval: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(23i32);
pub const HalSetHvciEnabled: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(18i32);
pub const HalSetProcessorTraceInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(19i32);
pub const HalSetPsciSuspendMode: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(17i32);
pub const HalSetResetParkDisposition: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(16i32);
pub const HalSetSwInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(22i32);
pub const HighImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(2i32);
pub const HighPagePriority: MM_PAGE_PRIORITY = MM_PAGE_PRIORITY(32i32);
pub const HighPoolPriority: EX_POOL_PRIORITY = EX_POOL_PRIORITY(32i32);
pub const HighPoolPrioritySpecialPoolOverrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(40i32);
pub const HighPoolPrioritySpecialPoolUnderrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(41i32);
pub const HotSpareControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(7i32);
pub const HyperCriticalWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(2i32);
pub const IMAGE_ADDRESSING_MODE_32BIT: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IMAGE_INFO {
    pub Anonymous: IMAGE_INFO_0,
    pub ImageBase: *mut core::ffi::c_void,
    pub ImageSelector: u32,
    pub ImageSize: usize,
    pub ImageSectionNumber: u32,
}
impl Default for IMAGE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union IMAGE_INFO_0 {
    pub Properties: u32,
    pub Anonymous: IMAGE_INFO_0_0,
}
impl Default for IMAGE_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IMAGE_INFO_0_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub struct IMAGE_INFO_EX {
    pub Size: usize,
    pub ImageInfo: IMAGE_INFO,
    pub FileObject: *mut super::super::Foundation::FILE_OBJECT,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IMAGE_INFO_EX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const INITIAL_PRIVILEGE_COUNT: u32 = 3u32;
#[repr(C)]
#[cfg(feature = "Win32_Security")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct INITIAL_PRIVILEGE_SET {
    pub PrivilegeCount: u32,
    pub Control: u32,
    pub Privilege: [super::super::super::Win32::Security::LUID_AND_ATTRIBUTES; 3],
}
#[cfg(feature = "Win32_Security")]
impl Default for INITIAL_PRIVILEGE_SET {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const INIT_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xcc5263e8_9308_454a_89d0_340bd39bc98e);
pub const INJECT_ERRTYPE_MEMORY_CORRECTABLE: u32 = 8u32;
pub const INJECT_ERRTYPE_MEMORY_UNCORRECTABLEFATAL: u32 = 32u32;
pub const INJECT_ERRTYPE_MEMORY_UNCORRECTABLENONFATAL: u32 = 16u32;
pub const INJECT_ERRTYPE_PCIEXPRESS_CORRECTABLE: u32 = 64u32;
pub const INJECT_ERRTYPE_PCIEXPRESS_UNCORRECTABLEFATAL: u32 = 256u32;
pub const INJECT_ERRTYPE_PCIEXPRESS_UNCORRECTABLENONFATAL: u32 = 128u32;
pub const INJECT_ERRTYPE_PLATFORM_CORRECTABLE: u32 = 512u32;
pub const INJECT_ERRTYPE_PLATFORM_UNCORRECTABLEFATAL: u32 = 2048u32;
pub const INJECT_ERRTYPE_PLATFORM_UNCORRECTABLENONFATAL: u32 = 1024u32;
pub const INJECT_ERRTYPE_PROCESSOR_CORRECTABLE: u32 = 1u32;
pub const INJECT_ERRTYPE_PROCESSOR_UNCORRECTABLEFATAL: u32 = 4u32;
pub const INJECT_ERRTYPE_PROCESSOR_UNCORRECTABLENONFATAL: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct INPUT_MAPPING_ELEMENT {
    pub InputMappingId: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union INTEL_CACHE_INFO_EAX {
    pub Ulong: u32,
    pub Anonymous: INTEL_CACHE_INFO_EAX_0,
}
impl Default for INTEL_CACHE_INFO_EAX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct INTEL_CACHE_INFO_EAX_0 {
    pub _bitfield: i32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union INTEL_CACHE_INFO_EBX {
    pub Ulong: u32,
    pub Anonymous: INTEL_CACHE_INFO_EBX_0,
}
impl Default for INTEL_CACHE_INFO_EBX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct INTEL_CACHE_INFO_EBX_0 {
    pub _bitfield: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct INTEL_CACHE_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
}
impl Default for INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct INTERFACE_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct INTERLOCKED_RESULT(pub i32);
pub const IOCTL_CANCEL_DEVICE_WAKE: u32 = 2719752u32;
pub const IOCTL_QUERY_DEVICE_POWER_STATE: u32 = 2703360u32;
pub const IOCTL_SET_DEVICE_WAKE: u32 = 2719748u32;
pub const IOMMU_ACCESS_NONE: u32 = 0u32;
pub const IOMMU_ACCESS_READ: u32 = 1u32;
pub const IOMMU_ACCESS_WRITE: u32 = 2u32;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IOMMU_DEVICE_CREATE = Option<unsafe extern "system" fn(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, deviceconfig: *const IOMMU_DEVICE_CREATION_CONFIGURATION, dmadeviceout: *mut *mut super::super::Foundation::IOMMU_DMA_DEVICE) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy)]
pub struct IOMMU_DEVICE_CREATION_CONFIGURATION {
    pub NextConfiguration: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub ConfigType: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE,
    pub Anonymous: IOMMU_DEVICE_CREATION_CONFIGURATION_0,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for IOMMU_DEVICE_CREATION_CONFIGURATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy)]
pub union IOMMU_DEVICE_CREATION_CONFIGURATION_0 {
    pub Acpi: IOMMU_DEVICE_CREATION_CONFIGURATION_ACPI,
    pub DeviceId: *mut core::ffi::c_void,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for IOMMU_DEVICE_CREATION_CONFIGURATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IOMMU_DEVICE_CREATION_CONFIGURATION_ACPI {
    pub InputMappingBase: u32,
    pub MappingsCount: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(pub i32);
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DEVICE_DELETE = Option<unsafe extern "system" fn(dmadevice: *const super::super::Foundation::IOMMU_DMA_DEVICE) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IOMMU_DEVICE_FAULT_HANDLER = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, faultinformation: *mut FAULT_INFORMATION)>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DEVICE_QUERY_DOMAIN_TYPES = Option<unsafe extern "system" fn(dmadevice: *const super::super::Foundation::IOMMU_DMA_DEVICE, availabledomains: *mut u32)>;
#[repr(C)]
#[derive(Clone, Copy)]
pub union IOMMU_DMA_DOMAIN_CREATION_FLAGS {
    pub Anonymous: IOMMU_DMA_DOMAIN_CREATION_FLAGS_0,
    pub AsUlonglong: u64,
}
impl Default for IOMMU_DMA_DOMAIN_CREATION_FLAGS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IOMMU_DMA_DOMAIN_CREATION_FLAGS_0 {
    pub _bitfield: u64,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IOMMU_DMA_DOMAIN_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IOMMU_DMA_LOGICAL_ADDRESS_TOKEN {
    pub LogicalAddressBase: u64,
    pub Size: usize,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOMMU_DMA_LOGICAL_ADDRESS_TOKEN_MAPPED_SEGMENT {
    pub OwningToken: *mut IOMMU_DMA_LOGICAL_ADDRESS_TOKEN,
    pub Offset: usize,
    pub Size: usize,
}
impl Default for IOMMU_DMA_LOGICAL_ADDRESS_TOKEN_MAPPED_SEGMENT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG {
    pub LogicalAllocatorType: IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE,
    pub Anonymous: IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG_0,
}
impl Default for IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG_0 {
    pub BuddyAllocatorConfig: IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG_0_0,
}
impl Default for IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG_0_0 {
    pub AddressWidth: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOMMU_DMA_RESERVED_REGION {
    pub RegionNext: *mut IOMMU_DMA_RESERVED_REGION,
    pub Base: u64,
    pub NumberOfPages: usize,
    pub ShouldMap: bool,
}
impl Default for IOMMU_DMA_RESERVED_REGION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IOMMU_DOMAIN_ATTACH_DEVICE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, inputmappingidbase: u32, mappingcount: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DOMAIN_ATTACH_DEVICE_EX = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, dmadevice: *const super::super::Foundation::IOMMU_DMA_DEVICE) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DOMAIN_CONFIGURE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, configuration: *const DOMAIN_CONFIGURATION) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DOMAIN_CREATE = Option<unsafe extern "system" fn(osmanagedpagetable: bool, domainout: *mut *mut super::super::Foundation::IOMMU_DMA_DOMAIN) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DOMAIN_CREATE_EX = Option<unsafe extern "system" fn(domaintype: IOMMU_DMA_DOMAIN_TYPE, flags: IOMMU_DMA_DOMAIN_CREATION_FLAGS, logicalallocatorconfig: *const IOMMU_DMA_LOGICAL_ALLOCATOR_CONFIG, reservedregions: *const IOMMU_DMA_RESERVED_REGION, domainout: *mut *mut super::super::Foundation::IOMMU_DMA_DOMAIN) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DOMAIN_DELETE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IOMMU_DOMAIN_DETACH_DEVICE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, inputmappingid: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_DOMAIN_DETACH_DEVICE_EX = Option<unsafe extern "system" fn(dmadevice: *const super::super::Foundation::IOMMU_DMA_DEVICE) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_FLUSH_DOMAIN = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_FLUSH_DOMAIN_VA_LIST = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, lastlevel: bool, number: u32, valist: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type IOMMU_FREE_RESERVED_LOGICAL_ADDRESS_RANGE = Option<unsafe extern "system" fn(logicaladdresstoken: *const IOMMU_DMA_LOGICAL_ADDRESS_TOKEN) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IOMMU_INTERFACE_STATE_CHANGE {
    pub PresentFields: IOMMU_INTERFACE_STATE_CHANGE_FIELDS,
    pub AvailableDomainTypes: u32,
}
impl Default for IOMMU_INTERFACE_STATE_CHANGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type IOMMU_INTERFACE_STATE_CHANGE_CALLBACK = Option<unsafe extern "system" fn(statechange: *const IOMMU_INTERFACE_STATE_CHANGE, context: *const core::ffi::c_void)>;
#[repr(C)]
#[derive(Clone, Copy)]
pub union IOMMU_INTERFACE_STATE_CHANGE_FIELDS {
    pub Anonymous: IOMMU_INTERFACE_STATE_CHANGE_FIELDS_0,
    pub AsULONG: u32,
}
impl Default for IOMMU_INTERFACE_STATE_CHANGE_FIELDS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IOMMU_INTERFACE_STATE_CHANGE_FIELDS_0 {
    pub _bitfield: u32,
}
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_MAP_IDENTITY_RANGE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, permissions: u32, mdl: *const super::super::Foundation::MDL) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_MAP_IDENTITY_RANGE_EX = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, permissions: u32, physicaladdresstomap: *const IOMMU_MAP_PHYSICAL_ADDRESS) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_MAP_LOGICAL_RANGE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, permissions: u32, mdl: *const super::super::Foundation::MDL, logicaladdress: u64) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_MAP_LOGICAL_RANGE_EX = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, permissions: u32, physicaladdresstomap: *const IOMMU_MAP_PHYSICAL_ADDRESS, explicitlogicaladdress: *const u64, minlogicaladdress: *const u64, maxlogicaladdress: *const u64, logicaladdressout: *mut u64) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub struct IOMMU_MAP_PHYSICAL_ADDRESS {
    pub MapType: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE,
    pub Anonymous: IOMMU_MAP_PHYSICAL_ADDRESS_0,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IOMMU_MAP_PHYSICAL_ADDRESS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub union IOMMU_MAP_PHYSICAL_ADDRESS_0 {
    pub Mdl: IOMMU_MAP_PHYSICAL_ADDRESS_0_0,
    pub ContiguousRange: IOMMU_MAP_PHYSICAL_ADDRESS_0_1,
    pub PfnArray: IOMMU_MAP_PHYSICAL_ADDRESS_0_2,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IOMMU_MAP_PHYSICAL_ADDRESS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IOMMU_MAP_PHYSICAL_ADDRESS_0_1 {
    pub Base: i64,
    pub Size: usize,
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOMMU_MAP_PHYSICAL_ADDRESS_0_0 {
    pub Mdl: *mut super::super::Foundation::MDL,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IOMMU_MAP_PHYSICAL_ADDRESS_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOMMU_MAP_PHYSICAL_ADDRESS_0_2 {
    pub PageFrame: *mut u32,
    pub NumberOfPages: usize,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IOMMU_MAP_PHYSICAL_ADDRESS_0_2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(pub i32);
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_MAP_RESERVED_LOGICAL_RANGE = Option<unsafe extern "system" fn(logicaladdresstoken: *mut IOMMU_DMA_LOGICAL_ADDRESS_TOKEN, offset: usize, permissions: u32, physicaladdresstomap: *const IOMMU_MAP_PHYSICAL_ADDRESS, mappedsegment: *mut IOMMU_DMA_LOGICAL_ADDRESS_TOKEN_MAPPED_SEGMENT) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IOMMU_QUERY_INPUT_MAPPINGS = Option<unsafe extern "system" fn(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, buffer: *mut INPUT_MAPPING_ELEMENT, bufferlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_REGISTER_INTERFACE_STATE_CHANGE_CALLBACK = Option<unsafe extern "system" fn(statechangecallback: PIOMMU_INTERFACE_STATE_CHANGE_CALLBACK, context: *const core::ffi::c_void, dmadevice: *const super::super::Foundation::IOMMU_DMA_DEVICE, statefields: *const IOMMU_INTERFACE_STATE_CHANGE_FIELDS) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_RESERVE_LOGICAL_ADDRESS_RANGE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, size: usize, explicitlogicaladdress: *const u64, minlogicaladdress: *const u64, maxlogicaladdress: *const u64, logicaladdresstoken: *mut *mut IOMMU_DMA_LOGICAL_ADDRESS_TOKEN) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IOMMU_SET_DEVICE_FAULT_REPORTING = Option<unsafe extern "system" fn(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, inputmappingidbase: u32, enable: bool, faultconfig: *const DEVICE_FAULT_CONFIGURATION) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_SET_DEVICE_FAULT_REPORTING_EX = Option<unsafe extern "system" fn(dmadevice: *const super::super::Foundation::IOMMU_DMA_DEVICE, inputmappingidbase: u32, enable: bool, faultconfig: *const DEVICE_FAULT_CONFIGURATION) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_UNMAP_IDENTITY_RANGE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, mdl: *const super::super::Foundation::MDL) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_UNMAP_IDENTITY_RANGE_EX = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, mappedphysicaladdress: *const IOMMU_MAP_PHYSICAL_ADDRESS) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_UNMAP_LOGICAL_RANGE = Option<unsafe extern "system" fn(domain: *const super::super::Foundation::IOMMU_DMA_DOMAIN, logicaladdress: u64, numberofpages: u64) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type IOMMU_UNMAP_RESERVED_LOGICAL_RANGE = Option<unsafe extern "system" fn(mappedsegment: *mut IOMMU_DMA_LOGICAL_ADDRESS_TOKEN_MAPPED_SEGMENT) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(feature = "Wdk_Foundation")]
pub type IOMMU_UNREGISTER_INTERFACE_STATE_CHANGE_CALLBACK = Option<unsafe extern "system" fn(statechangecallback: PIOMMU_INTERFACE_STATE_CHANGE_CALLBACK, dmadevice: *const super::super::Foundation::IOMMU_DMA_DEVICE) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_ACCESS_MODE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_ACCESS_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_ALLOCATION_ACTION(pub i32);
pub const IO_ATTACH_DEVICE: u32 = 1024u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IO_ATTRIBUTION_INFORMATION {
    pub Version: u32,
    pub Flags: IO_ATTRIBUTION_INFORMATION_0,
    pub Length: u32,
    pub ServiceStartTime: u64,
    pub CurrentTime: u64,
}
impl Default for IO_ATTRIBUTION_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union IO_ATTRIBUTION_INFORMATION_0 {
    pub Anonymous: IO_ATTRIBUTION_INFORMATION_0_0,
    pub AllFlags: u32,
}
impl Default for IO_ATTRIBUTION_INFORMATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_ATTRIBUTION_INFORMATION_0_0 {
    pub _bitfield: u32,
}
pub const IO_ATTRIBUTION_INFO_V1: u32 = 1u32;
pub const IO_CHECK_CREATE_PARAMETERS: u32 = 512u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_CHECK_DELETE: u32 = 16u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_CHECK_READ: u32 = 4u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_CHECK_WRITE: u32 = 8u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_UPDATE_FILE_OBJECT: u32 = 2u32;
pub const IO_CHECK_SHARE_ACCESS_FORCE_CHECK: u32 = 32u32;
pub const IO_CHECK_SHARE_ACCESS_FORCE_USING_SCB: u32 = 64u32;
pub const IO_CHECK_SHARE_ACCESS_UPDATE_SHARE_ACCESS: u32 = 1u32;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_COMPLETION_ROUTINE = Option<unsafe extern "system" fn(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP, context: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_COMPLETION_ROUTINE_RESULT(pub i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS {
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub InterruptObject: *mut super::super::Foundation::PKINTERRUPT,
    pub ServiceRoutine: PKSERVICE_ROUTINE,
    pub ServiceContext: *mut core::ffi::c_void,
    pub SpinLock: *mut usize,
    pub SynchronizeIrql: u8,
    pub FloatingSave: bool,
    pub ShareVector: bool,
    pub Vector: u32,
    pub Irql: u8,
    pub InterruptMode: KINTERRUPT_MODE,
    pub ProcessorEnableMask: usize,
    pub Group: u16,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS {
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub InterruptObject: *mut super::super::Foundation::PKINTERRUPT,
    pub ServiceRoutine: PKSERVICE_ROUTINE,
    pub ServiceContext: *mut core::ffi::c_void,
    pub SpinLock: *mut usize,
    pub SynchronizeIrql: u8,
    pub FloatingSave: bool,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub struct IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS {
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub ConnectionContext: IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS_0,
    pub MessageServiceRoutine: PKMESSAGE_SERVICE_ROUTINE,
    pub ServiceContext: *mut core::ffi::c_void,
    pub SpinLock: *mut usize,
    pub SynchronizeIrql: u8,
    pub FloatingSave: bool,
    pub FallBackServiceRoutine: PKSERVICE_ROUTINE,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub union IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS_0 {
    pub Generic: *mut *mut core::ffi::c_void,
    pub InterruptMessageTable: *mut *mut IO_INTERRUPT_MESSAGE_INFO,
    pub InterruptObject: *mut super::super::Foundation::PKINTERRUPT,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub struct IO_CONNECT_INTERRUPT_PARAMETERS {
    pub Version: u32,
    pub Anonymous: IO_CONNECT_INTERRUPT_PARAMETERS_0,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CONNECT_INTERRUPT_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy)]
pub union IO_CONNECT_INTERRUPT_PARAMETERS_0 {
    pub FullySpecified: IO_CONNECT_INTERRUPT_FULLY_SPECIFIED_PARAMETERS,
    pub LineBased: IO_CONNECT_INTERRUPT_LINE_BASED_PARAMETERS,
    pub MessageBased: IO_CONNECT_INTERRUPT_MESSAGE_BASED_PARAMETERS,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CONNECT_INTERRUPT_PARAMETERS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_CONTAINER_INFORMATION_CLASS(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_CONTAINER_NOTIFICATION_CLASS(pub i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_CSQ {
    pub Type: u32,
    pub CsqInsertIrp: PIO_CSQ_INSERT_IRP,
    pub CsqRemoveIrp: PIO_CSQ_REMOVE_IRP,
    pub CsqPeekNextIrp: PIO_CSQ_PEEK_NEXT_IRP,
    pub CsqAcquireLock: PIO_CSQ_ACQUIRE_LOCK,
    pub CsqReleaseLock: PIO_CSQ_RELEASE_LOCK,
    pub CsqCompleteCanceledIrp: PIO_CSQ_COMPLETE_CANCELED_IRP,
    pub ReservePointer: *mut core::ffi::c_void,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CSQ {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_CSQ_ACQUIRE_LOCK = Option<unsafe extern "system" fn(csq: *const IO_CSQ, irql: *mut u8)>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_CSQ_COMPLETE_CANCELED_IRP = Option<unsafe extern "system" fn(csq: *const IO_CSQ, irp: *const super::super::Foundation::IRP)>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_CSQ_INSERT_IRP = Option<unsafe extern "system" fn(csq: *const IO_CSQ, irp: *const super::super::Foundation::IRP)>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_CSQ_INSERT_IRP_EX = Option<unsafe extern "system" fn(csq: *const IO_CSQ, irp: *const super::super::Foundation::IRP, insertcontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_CSQ_IRP_CONTEXT {
    pub Type: u32,
    pub Irp: *mut super::super::Foundation::IRP,
    pub Csq: *mut IO_CSQ,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_CSQ_IRP_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_CSQ_PEEK_NEXT_IRP = Option<unsafe extern "system" fn(csq: *const IO_CSQ, irp: *const super::super::Foundation::IRP, peekcontext: *const core::ffi::c_void) -> *mut super::super::Foundation::IRP>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_CSQ_RELEASE_LOCK = Option<unsafe extern "system" fn(csq: *const IO_CSQ, irql: u8)>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_CSQ_REMOVE_IRP = Option<unsafe extern "system" fn(csq: *const IO_CSQ, irp: *const super::super::Foundation::IRP)>;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub struct IO_DISCONNECT_INTERRUPT_PARAMETERS {
    pub Version: u32,
    pub ConnectionContext: IO_DISCONNECT_INTERRUPT_PARAMETERS_0,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_DISCONNECT_INTERRUPT_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub union IO_DISCONNECT_INTERRUPT_PARAMETERS_0 {
    pub Generic: *mut core::ffi::c_void,
    pub InterruptObject: super::super::Foundation::PKINTERRUPT,
    pub InterruptMessageTable: *mut IO_INTERRUPT_MESSAGE_INFO,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_DISCONNECT_INTERRUPT_PARAMETERS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_DPC_ROUTINE = Option<unsafe extern "system" fn(dpc: *const super::super::Foundation::KDPC, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *mut super::super::Foundation::IRP, context: *const core::ffi::c_void)>;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_DRIVER_CREATE_CONTEXT {
    pub Size: i16,
    pub ExtraCreateParameter: *mut isize,
    pub DeviceObjectHint: *mut core::ffi::c_void,
    pub TxnParameters: *mut TXN_PARAMETER_BLOCK,
    pub SiloContext: super::super::Foundation::PESILO,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_DRIVER_CREATE_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_ERROR_LOG_MESSAGE {
    pub Type: u16,
    pub Size: u16,
    pub DriverNameLength: u16,
    pub TimeStamp: i64,
    pub DriverNameOffset: u32,
    pub EntryData: IO_ERROR_LOG_PACKET,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_ERROR_LOG_PACKET {
    pub MajorFunctionCode: u8,
    pub RetryCount: u8,
    pub DumpDataSize: u16,
    pub NumberOfStrings: u16,
    pub StringOffset: u16,
    pub EventCategory: u16,
    pub ErrorCode: super::super::super::Win32::Foundation::NTSTATUS,
    pub UniqueErrorValue: u32,
    pub FinalStatus: super::super::super::Win32::Foundation::NTSTATUS,
    pub SequenceNumber: u32,
    pub IoControlCode: u32,
    pub DeviceOffset: i64,
    pub DumpData: [u32; 1],
}
impl Default for IO_ERROR_LOG_PACKET {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_FOEXT_SHADOW_FILE {
    pub BackingFileObject: *mut super::super::Foundation::FILE_OBJECT,
    pub BackingFltInstance: *mut core::ffi::c_void,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl Default for IO_FOEXT_SHADOW_FILE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub struct IO_FOEXT_SILO_PARAMETERS {
    pub Length: u32,
    pub Anonymous: IO_FOEXT_SILO_PARAMETERS_0,
    pub SiloContext: super::super::Foundation::PESILO,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_FOEXT_SILO_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub union IO_FOEXT_SILO_PARAMETERS_0 {
    pub Anonymous: IO_FOEXT_SILO_PARAMETERS_0_0,
    pub Flags: u32,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_FOEXT_SILO_PARAMETERS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_FOEXT_SILO_PARAMETERS_0_0 {
    pub _bitfield: u32,
}
pub const IO_FORCE_ACCESS_CHECK: u32 = 1u32;
pub const IO_IGNORE_SHARE_ACCESS_CHECK: u32 = 2048u32;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_INTERRUPT_MESSAGE_INFO {
    pub UnifiedIrql: u8,
    pub MessageCount: u32,
    pub MessageInfo: [IO_INTERRUPT_MESSAGE_INFO_ENTRY; 1],
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_INTERRUPT_MESSAGE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_INTERRUPT_MESSAGE_INFO_ENTRY {
    pub MessageAddress: i64,
    pub TargetProcessorSet: usize,
    pub InterruptObject: super::super::Foundation::PKINTERRUPT,
    pub MessageData: u32,
    pub Vector: u32,
    pub Irql: u8,
    pub Mode: KINTERRUPT_MODE,
    pub Polarity: KINTERRUPT_POLARITY,
}
pub const IO_KEYBOARD_INCREMENT: u32 = 6u32;
pub const IO_MOUSE_INCREMENT: u32 = 6u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_NOTIFICATION_EVENT_CATEGORY(pub i32);
pub const IO_NO_PARAMETER_CHECKING: u32 = 256u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_PAGING_PRIORITY(pub i32);
pub const IO_PARALLEL_INCREMENT: u32 = 1u32;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_PERSISTED_MEMORY_ENUMERATION_CALLBACK = Option<unsafe extern "system" fn(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, physicaldeviceid: *const super::super::super::Win32::Foundation::UNICODE_STRING, datatag: *const u16, dataversion: *const u32, context: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_QUERY_DEVICE_DATA_FORMAT(pub i32);
pub const IO_REMOUNT: u32 = 1u32;
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub struct IO_REMOVE_LOCK {
    pub Common: IO_REMOVE_LOCK_COMMON_BLOCK,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
impl Default for IO_REMOVE_LOCK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub struct IO_REMOVE_LOCK_COMMON_BLOCK {
    pub Removed: bool,
    pub Reserved: [bool; 3],
    pub IoCount: i32,
    pub RemoveEvent: super::super::Foundation::KEVENT,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
impl Default for IO_REMOVE_LOCK_COMMON_BLOCK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_REMOVE_LOCK_DBG_BLOCK {
    pub Signature: i32,
    pub HighWatermark: u32,
    pub MaxLockedTicks: i64,
    pub AllocateTag: i32,
    pub LockList: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub Spin: usize,
    pub LowMemoryCount: i32,
    pub Reserved1: [u32; 4],
    pub Reserved2: *mut core::ffi::c_void,
    pub Blocks: super::super::Foundation::PIO_REMOVE_LOCK_TRACKING_BLOCK,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
impl Default for IO_REMOVE_LOCK_DBG_BLOCK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const IO_REPARSE: u32 = 0u32;
pub const IO_REPARSE_GLOBAL: u32 = 2u32;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub struct IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS {
    pub Version: u32,
    pub ConnectionContext: IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS_0,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub union IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS_0 {
    pub Generic: *mut core::ffi::c_void,
    pub InterruptObject: super::super::Foundation::PKINTERRUPT,
    pub InterruptMessageTable: *mut IO_INTERRUPT_MESSAGE_INFO,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const IO_RESOURCE_ALTERNATIVE: u32 = 8u32;
pub const IO_RESOURCE_DEFAULT: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IO_RESOURCE_DESCRIPTOR {
    pub Option: u8,
    pub Type: u8,
    pub ShareDisposition: u8,
    pub Spare1: u8,
    pub Flags: u16,
    pub Spare2: u16,
    pub u: IO_RESOURCE_DESCRIPTOR_0,
}
impl Default for IO_RESOURCE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union IO_RESOURCE_DESCRIPTOR_0 {
    pub Port: IO_RESOURCE_DESCRIPTOR_0_0,
    pub Memory: IO_RESOURCE_DESCRIPTOR_0_1,
    pub Interrupt: IO_RESOURCE_DESCRIPTOR_0_2,
    pub Dma: IO_RESOURCE_DESCRIPTOR_0_3,
    pub DmaV3: IO_RESOURCE_DESCRIPTOR_0_4,
    pub Generic: IO_RESOURCE_DESCRIPTOR_0_5,
    pub DevicePrivate: IO_RESOURCE_DESCRIPTOR_0_6,
    pub BusNumber: IO_RESOURCE_DESCRIPTOR_0_7,
    pub ConfigData: IO_RESOURCE_DESCRIPTOR_0_8,
    pub Memory40: IO_RESOURCE_DESCRIPTOR_0_9,
    pub Memory48: IO_RESOURCE_DESCRIPTOR_0_10,
    pub Memory64: IO_RESOURCE_DESCRIPTOR_0_11,
    pub Connection: IO_RESOURCE_DESCRIPTOR_0_12,
}
impl Default for IO_RESOURCE_DESCRIPTOR_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_7 {
    pub Length: u32,
    pub MinBusNumber: u32,
    pub MaxBusNumber: u32,
    pub Reserved: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_8 {
    pub Priority: u32,
    pub Reserved1: u32,
    pub Reserved2: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_12 {
    pub Class: u8,
    pub Type: u8,
    pub Reserved1: u8,
    pub Reserved2: u8,
    pub IdLowPart: u32,
    pub IdHighPart: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_6 {
    pub Data: [u32; 3],
}
impl Default for IO_RESOURCE_DESCRIPTOR_0_6 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_4 {
    pub RequestLine: u32,
    pub Reserved: u32,
    pub Channel: u32,
    pub TransferWidth: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_3 {
    pub MinimumChannel: u32,
    pub MaximumChannel: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_5 {
    pub Length: u32,
    pub Alignment: u32,
    pub MinimumAddress: i64,
    pub MaximumAddress: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_2 {
    pub MinimumVector: u32,
    pub MaximumVector: u32,
    pub AffinityPolicy: IRQ_DEVICE_POLICY,
    pub PriorityPolicy: IRQ_PRIORITY,
    pub TargetedProcessors: usize,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_9 {
    pub Length40: u32,
    pub Alignment40: u32,
    pub MinimumAddress: i64,
    pub MaximumAddress: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_10 {
    pub Length48: u32,
    pub Alignment48: u32,
    pub MinimumAddress: i64,
    pub MaximumAddress: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_11 {
    pub Length64: u32,
    pub Alignment64: u32,
    pub MinimumAddress: i64,
    pub MaximumAddress: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_1 {
    pub Length: u32,
    pub Alignment: u32,
    pub MinimumAddress: i64,
    pub MaximumAddress: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_RESOURCE_DESCRIPTOR_0_0 {
    pub Length: u32,
    pub Alignment: u32,
    pub MinimumAddress: i64,
    pub MaximumAddress: i64,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IO_RESOURCE_LIST {
    pub Version: u16,
    pub Revision: u16,
    pub Count: u32,
    pub Descriptors: [IO_RESOURCE_DESCRIPTOR; 1],
}
impl Default for IO_RESOURCE_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const IO_RESOURCE_PREFERRED: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IO_RESOURCE_REQUIREMENTS_LIST {
    pub ListSize: u32,
    pub InterfaceType: INTERFACE_TYPE,
    pub BusNumber: u32,
    pub SlotNumber: u32,
    pub Reserved: [u32; 3],
    pub AlternativeLists: u32,
    pub List: [IO_RESOURCE_LIST; 1],
}
impl Default for IO_RESOURCE_REQUIREMENTS_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const IO_SERIAL_INCREMENT: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_SESSION_CONNECT_INFO {
    pub SessionId: u32,
    pub LocalSession: bool,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_SESSION_EVENT(pub i32);
pub const IO_SESSION_MAX_PAYLOAD_SIZE: i32 = 256i32;
pub type IO_SESSION_NOTIFICATION_FUNCTION = Option<unsafe extern "system" fn(sessionobject: *const core::ffi::c_void, ioobject: *const core::ffi::c_void, event: u32, context: *const core::ffi::c_void, notificationpayload: *const core::ffi::c_void, payloadlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IO_SESSION_STATE(pub i32);
pub const IO_SESSION_STATE_ALL_EVENTS: u32 = 4294967295u32;
pub const IO_SESSION_STATE_CONNECT_EVENT: u32 = 4u32;
pub const IO_SESSION_STATE_CREATION_EVENT: u32 = 1u32;
pub const IO_SESSION_STATE_DISCONNECT_EVENT: u32 = 8u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_SESSION_STATE_INFORMATION {
    pub SessionId: u32,
    pub SessionState: IO_SESSION_STATE,
    pub LocalSession: bool,
}
pub const IO_SESSION_STATE_LOGOFF_EVENT: u32 = 32u32;
pub const IO_SESSION_STATE_LOGON_EVENT: u32 = 16u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IO_SESSION_STATE_NOTIFICATION {
    pub Size: u32,
    pub Flags: u32,
    pub IoObject: *mut core::ffi::c_void,
    pub EventMask: u32,
    pub Context: *mut core::ffi::c_void,
}
impl Default for IO_SESSION_STATE_NOTIFICATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const IO_SESSION_STATE_TERMINATION_EVENT: u32 = 2u32;
pub const IO_SESSION_STATE_VALID_EVENT_MASK: u32 = 63u32;
pub const IO_SET_IRP_IO_ATTRIBUTION_FLAGS_MASK: u32 = 3u32;
pub const IO_SET_IRP_IO_ATTRIBUTION_FROM_PROCESS: u32 = 2u32;
pub const IO_SET_IRP_IO_ATTRIBUTION_FROM_THREAD: u32 = 1u32;
pub const IO_SHARE_ACCESS_NON_PRIMARY_STREAM: u32 = 128u32;
pub const IO_SHARE_ACCESS_NO_WRITE_PERMISSION: u32 = 2147483648u32;
pub const IO_SOUND_INCREMENT: u32 = 8u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct IO_STATUS_BLOCK32 {
    pub Status: super::super::super::Win32::Foundation::NTSTATUS,
    pub Information: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct IO_STATUS_BLOCK64 {
    pub Anonymous: IO_STATUS_BLOCK64_0,
    pub Information: u64,
}
impl Default for IO_STATUS_BLOCK64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union IO_STATUS_BLOCK64_0 {
    pub Status: super::super::super::Win32::Foundation::NTSTATUS,
    pub Pointer: *mut core::ffi::c_void,
}
impl Default for IO_STATUS_BLOCK64_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_TIMER_ROUTINE = Option<unsafe extern "system" fn(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, context: *const core::ffi::c_void)>;
pub const IO_TYPE_ADAPTER: u32 = 1u32;
pub const IO_TYPE_CONTROLLER: u32 = 2u32;
pub const IO_TYPE_CSQ: u32 = 2u32;
pub const IO_TYPE_CSQ_EX: u32 = 3u32;
pub const IO_TYPE_CSQ_IRP_CONTEXT: u32 = 1u32;
pub const IO_TYPE_DEVICE: u32 = 3u32;
pub const IO_TYPE_DEVICE_OBJECT_EXTENSION: u32 = 13u32;
pub const IO_TYPE_DRIVER: u32 = 4u32;
pub const IO_TYPE_ERROR_LOG: u32 = 11u32;
pub const IO_TYPE_ERROR_MESSAGE: u32 = 12u32;
pub const IO_TYPE_FILE: u32 = 5u32;
pub const IO_TYPE_IORING: u32 = 14u32;
pub const IO_TYPE_IRP: u32 = 6u32;
pub const IO_TYPE_MASTER_ADAPTER: u32 = 7u32;
pub const IO_TYPE_OPEN_PACKET: u32 = 8u32;
pub const IO_TYPE_TIMER: u32 = 9u32;
pub const IO_TYPE_VPB: u32 = 10u32;
pub const IO_VIDEO_INCREMENT: u32 = 1u32;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type IO_WORKITEM_ROUTINE = Option<unsafe extern "system" fn(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, context: *const core::ffi::c_void)>;
#[cfg(feature = "Wdk_Foundation")]
pub type IO_WORKITEM_ROUTINE_EX = Option<unsafe extern "system" fn(ioobject: *const core::ffi::c_void, context: *const core::ffi::c_void, ioworkitem: super::super::Foundation::PIO_WORKITEM)>;
pub const IPF_SAL_RECORD_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x6f3380d1_6eb0_497f_a578_4d4c65a71617);
pub const IPI_LEVEL: u32 = 29u32;
pub const IPMI_MSR_DUMP_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x1c15b445_9b06_4667_ac25_33c056b88803);
pub const IRP_ALLOCATED_FIXED_SIZE: u32 = 4u32;
pub const IRP_ALLOCATED_MUST_SUCCEED: u32 = 2u32;
pub const IRP_ASSOCIATED_IRP: u32 = 8u32;
pub const IRP_BUFFERED_IO: u32 = 16u32;
pub const IRP_CLOSE_OPERATION: u32 = 1024u32;
pub const IRP_CREATE_OPERATION: u32 = 128u32;
pub const IRP_DEALLOCATE_BUFFER: u32 = 32u32;
pub const IRP_DEFER_IO_COMPLETION: u32 = 2048u32;
pub const IRP_HOLD_DEVICE_QUEUE: u32 = 8192u32;
pub const IRP_INPUT_OPERATION: u32 = 64u32;
pub const IRP_LOOKASIDE_ALLOCATION: u32 = 8u32;
pub const IRP_MJ_CLEANUP: u32 = 18u32;
pub const IRP_MJ_CLOSE: u32 = 2u32;
pub const IRP_MJ_CREATE: u32 = 0u32;
pub const IRP_MJ_CREATE_MAILSLOT: u32 = 19u32;
pub const IRP_MJ_CREATE_NAMED_PIPE: u32 = 1u32;
pub const IRP_MJ_DEVICE_CHANGE: u32 = 24u32;
pub const IRP_MJ_DEVICE_CONTROL: u32 = 14u32;
pub const IRP_MJ_DIRECTORY_CONTROL: u32 = 12u32;
pub const IRP_MJ_FILE_SYSTEM_CONTROL: u32 = 13u32;
pub const IRP_MJ_FLUSH_BUFFERS: u32 = 9u32;
pub const IRP_MJ_INTERNAL_DEVICE_CONTROL: u32 = 15u32;
pub const IRP_MJ_LOCK_CONTROL: u32 = 17u32;
pub const IRP_MJ_MAXIMUM_FUNCTION: u32 = 27u32;
pub const IRP_MJ_PNP: u32 = 27u32;
pub const IRP_MJ_PNP_POWER: u32 = 27u32;
pub const IRP_MJ_POWER: u32 = 22u32;
pub const IRP_MJ_QUERY_EA: u32 = 7u32;
pub const IRP_MJ_QUERY_INFORMATION: u32 = 5u32;
pub const IRP_MJ_QUERY_QUOTA: u32 = 25u32;
pub const IRP_MJ_QUERY_SECURITY: u32 = 20u32;
pub const IRP_MJ_QUERY_VOLUME_INFORMATION: u32 = 10u32;
pub const IRP_MJ_READ: u32 = 3u32;
pub const IRP_MJ_SCSI: u32 = 15u32;
pub const IRP_MJ_SET_EA: u32 = 8u32;
pub const IRP_MJ_SET_INFORMATION: u32 = 6u32;
pub const IRP_MJ_SET_QUOTA: u32 = 26u32;
pub const IRP_MJ_SET_SECURITY: u32 = 21u32;
pub const IRP_MJ_SET_VOLUME_INFORMATION: u32 = 11u32;
pub const IRP_MJ_SHUTDOWN: u32 = 16u32;
pub const IRP_MJ_SYSTEM_CONTROL: u32 = 23u32;
pub const IRP_MJ_WRITE: u32 = 4u32;
pub const IRP_MN_CANCEL_REMOVE_DEVICE: u32 = 3u32;
pub const IRP_MN_CANCEL_STOP_DEVICE: u32 = 6u32;
pub const IRP_MN_CHANGE_SINGLE_INSTANCE: u32 = 2u32;
pub const IRP_MN_CHANGE_SINGLE_ITEM: u32 = 3u32;
pub const IRP_MN_COMPLETE: u32 = 4u32;
pub const IRP_MN_COMPRESSED: u32 = 8u32;
pub const IRP_MN_DEVICE_ENUMERATED: u32 = 25u32;
pub const IRP_MN_DEVICE_USAGE_NOTIFICATION: u32 = 22u32;
pub const IRP_MN_DISABLE_COLLECTION: u32 = 7u32;
pub const IRP_MN_DISABLE_EVENTS: u32 = 5u32;
pub const IRP_MN_DPC: u32 = 1u32;
pub const IRP_MN_EJECT: u32 = 17u32;
pub const IRP_MN_ENABLE_COLLECTION: u32 = 6u32;
pub const IRP_MN_ENABLE_EVENTS: u32 = 4u32;
pub const IRP_MN_EXECUTE_METHOD: u32 = 9u32;
pub const IRP_MN_FILTER_RESOURCE_REQUIREMENTS: u32 = 13u32;
pub const IRP_MN_FLUSH_AND_PURGE: u32 = 1u32;
pub const IRP_MN_FLUSH_DATA_ONLY: u32 = 2u32;
pub const IRP_MN_FLUSH_DATA_SYNC_ONLY: u32 = 4u32;
pub const IRP_MN_FLUSH_NO_SYNC: u32 = 3u32;
pub const IRP_MN_KERNEL_CALL: u32 = 4u32;
pub const IRP_MN_LOAD_FILE_SYSTEM: u32 = 3u32;
pub const IRP_MN_LOCK: u32 = 1u32;
pub const IRP_MN_MDL: u32 = 2u32;
pub const IRP_MN_MOUNT_VOLUME: u32 = 1u32;
pub const IRP_MN_NORMAL: u32 = 0u32;
pub const IRP_MN_NOTIFY_CHANGE_DIRECTORY: u32 = 2u32;
pub const IRP_MN_NOTIFY_CHANGE_DIRECTORY_EX: u32 = 3u32;
pub const IRP_MN_POWER_SEQUENCE: u32 = 1u32;
pub const IRP_MN_QUERY_ALL_DATA: u32 = 0u32;
pub const IRP_MN_QUERY_BUS_INFORMATION: u32 = 21u32;
pub const IRP_MN_QUERY_CAPABILITIES: u32 = 9u32;
pub const IRP_MN_QUERY_DEVICE_RELATIONS: u32 = 7u32;
pub const IRP_MN_QUERY_DEVICE_TEXT: u32 = 12u32;
pub const IRP_MN_QUERY_DIRECTORY: u32 = 1u32;
pub const IRP_MN_QUERY_ID: u32 = 19u32;
pub const IRP_MN_QUERY_INTERFACE: u32 = 8u32;
pub const IRP_MN_QUERY_LEGACY_BUS_INFORMATION: u32 = 24u32;
pub const IRP_MN_QUERY_PNP_DEVICE_STATE: u32 = 20u32;
pub const IRP_MN_QUERY_POWER: u32 = 3u32;
pub const IRP_MN_QUERY_REMOVE_DEVICE: u32 = 1u32;
pub const IRP_MN_QUERY_RESOURCES: u32 = 10u32;
pub const IRP_MN_QUERY_RESOURCE_REQUIREMENTS: u32 = 11u32;
pub const IRP_MN_QUERY_SINGLE_INSTANCE: u32 = 1u32;
pub const IRP_MN_QUERY_STOP_DEVICE: u32 = 5u32;
pub const IRP_MN_READ_CONFIG: u32 = 15u32;
pub const IRP_MN_REGINFO: u32 = 8u32;
pub const IRP_MN_REGINFO_EX: u32 = 11u32;
pub const IRP_MN_REMOVE_DEVICE: u32 = 2u32;
pub const IRP_MN_SCSI_CLASS: u32 = 1u32;
pub const IRP_MN_SET_LOCK: u32 = 18u32;
pub const IRP_MN_SET_POWER: u32 = 2u32;
pub const IRP_MN_START_DEVICE: u32 = 0u32;
pub const IRP_MN_STOP_DEVICE: u32 = 4u32;
pub const IRP_MN_SURPRISE_REMOVAL: u32 = 23u32;
pub const IRP_MN_TRACK_LINK: u32 = 4u32;
pub const IRP_MN_UNLOCK_ALL: u32 = 3u32;
pub const IRP_MN_UNLOCK_ALL_BY_KEY: u32 = 4u32;
pub const IRP_MN_UNLOCK_SINGLE: u32 = 2u32;
pub const IRP_MN_USER_FS_REQUEST: u32 = 0u32;
pub const IRP_MN_VERIFY_VOLUME: u32 = 2u32;
pub const IRP_MN_WAIT_WAKE: u32 = 0u32;
pub const IRP_MN_WRITE_CONFIG: u32 = 16u32;
pub const IRP_MOUNT_COMPLETION: u32 = 2u32;
pub const IRP_NOCACHE: u32 = 1u32;
pub const IRP_OB_QUERY_NAME: u32 = 4096u32;
pub const IRP_PAGING_IO: u32 = 2u32;
pub const IRP_QUOTA_CHARGED: u32 = 1u32;
pub const IRP_READ_OPERATION: u32 = 256u32;
pub const IRP_SYNCHRONOUS_API: u32 = 4u32;
pub const IRP_SYNCHRONOUS_PAGING_IO: u32 = 64u32;
pub const IRP_UM_DRIVER_INITIATED_IO: u32 = 4194304u32;
pub const IRP_WRITE_OPERATION: u32 = 512u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IRQ_DEVICE_POLICY(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IRQ_GROUP_POLICY(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct IRQ_PRIORITY(pub i32);
pub const InACriticalArrayControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(8i32);
pub const InAFailedArrayControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(9i32);
pub const IndicatorBlink: PCI_EXPRESS_INDICATOR_STATE = PCI_EXPRESS_INDICATOR_STATE(2i32);
pub const IndicatorOff: PCI_EXPRESS_INDICATOR_STATE = PCI_EXPRESS_INDICATOR_STATE(3i32);
pub const IndicatorOn: PCI_EXPRESS_INDICATOR_STATE = PCI_EXPRESS_INDICATOR_STATE(1i32);
pub const InitiateReset: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(1i32);
pub const InstallStateFailedInstall: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(2i32);
pub const InstallStateFinishInstall: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(3i32);
pub const InstallStateInstalled: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(0i32);
pub const InstallStateNeedsReinstall: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(1i32);
pub const IntelCacheData: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(1i32);
pub const IntelCacheInstruction: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(2i32);
pub const IntelCacheNull: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(0i32);
pub const IntelCacheRam: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(4i32);
pub const IntelCacheTrace: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(5i32);
pub const IntelCacheUnified: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(3i32);
pub const InterfaceTypeUndefined: INTERFACE_TYPE = INTERFACE_TYPE(-1i32);
pub const Internal: INTERFACE_TYPE = INTERFACE_TYPE(0i32);
pub const InternalPowerBus: INTERFACE_TYPE = INTERFACE_TYPE(13i32);
pub const InterruptActiveBoth: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(3i32);
pub const InterruptActiveBothTriggerHigh: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(4i32);
pub const InterruptActiveBothTriggerLow: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(3i32);
pub const InterruptActiveHigh: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(1i32);
pub const InterruptActiveLow: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(2i32);
pub const InterruptFallingEdge: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(2i32);
pub const InterruptPolarityUnknown: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(0i32);
pub const InterruptRisingEdge: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(1i32);
pub const InvalidDeviceTypeControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(10i32);
pub const IoMaxContainerInformationClass: IO_CONTAINER_INFORMATION_CLASS = IO_CONTAINER_INFORMATION_CLASS(1i32);
pub const IoMaxContainerNotificationClass: IO_CONTAINER_NOTIFICATION_CLASS = IO_CONTAINER_NOTIFICATION_CLASS(1i32);
pub const IoModifyAccess: LOCK_OPERATION = LOCK_OPERATION(2i32);
pub const IoPagingPriorityHigh: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(2i32);
pub const IoPagingPriorityInvalid: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(0i32);
pub const IoPagingPriorityNormal: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(1i32);
pub const IoPagingPriorityReserved1: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(3i32);
pub const IoPagingPriorityReserved2: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(4i32);
pub const IoQueryDeviceComponentInformation: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(2i32);
pub const IoQueryDeviceConfigurationData: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(1i32);
pub const IoQueryDeviceIdentifier: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(0i32);
pub const IoQueryDeviceMaxData: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(3i32);
pub const IoReadAccess: LOCK_OPERATION = LOCK_OPERATION(0i32);
pub const IoSessionEventConnected: IO_SESSION_EVENT = IO_SESSION_EVENT(3i32);
pub const IoSessionEventCreated: IO_SESSION_EVENT = IO_SESSION_EVENT(1i32);
pub const IoSessionEventDisconnected: IO_SESSION_EVENT = IO_SESSION_EVENT(4i32);
pub const IoSessionEventIgnore: IO_SESSION_EVENT = IO_SESSION_EVENT(0i32);
pub const IoSessionEventLogoff: IO_SESSION_EVENT = IO_SESSION_EVENT(6i32);
pub const IoSessionEventLogon: IO_SESSION_EVENT = IO_SESSION_EVENT(5i32);
pub const IoSessionEventMax: IO_SESSION_EVENT = IO_SESSION_EVENT(7i32);
pub const IoSessionEventTerminated: IO_SESSION_EVENT = IO_SESSION_EVENT(2i32);
pub const IoSessionStateConnected: IO_SESSION_STATE = IO_SESSION_STATE(3i32);
pub const IoSessionStateCreated: IO_SESSION_STATE = IO_SESSION_STATE(1i32);
pub const IoSessionStateDisconnected: IO_SESSION_STATE = IO_SESSION_STATE(4i32);
pub const IoSessionStateDisconnectedLoggedOn: IO_SESSION_STATE = IO_SESSION_STATE(5i32);
pub const IoSessionStateInformation: IO_CONTAINER_INFORMATION_CLASS = IO_CONTAINER_INFORMATION_CLASS(0i32);
pub const IoSessionStateInitialized: IO_SESSION_STATE = IO_SESSION_STATE(2i32);
pub const IoSessionStateLoggedOff: IO_SESSION_STATE = IO_SESSION_STATE(7i32);
pub const IoSessionStateLoggedOn: IO_SESSION_STATE = IO_SESSION_STATE(6i32);
pub const IoSessionStateMax: IO_SESSION_STATE = IO_SESSION_STATE(9i32);
pub const IoSessionStateNotification: IO_CONTAINER_NOTIFICATION_CLASS = IO_CONTAINER_NOTIFICATION_CLASS(0i32);
pub const IoSessionStateTerminated: IO_SESSION_STATE = IO_SESSION_STATE(8i32);
pub const IoWriteAccess: LOCK_OPERATION = LOCK_OPERATION(1i32);
pub const IommuDeviceCreationConfigTypeAcpi: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(1i32);
pub const IommuDeviceCreationConfigTypeDeviceId: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(2i32);
pub const IommuDeviceCreationConfigTypeMax: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(3i32);
pub const IommuDeviceCreationConfigTypeNone: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(0i32);
pub const IommuDmaLogicalAllocatorBuddy: IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE = IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(1i32);
pub const IommuDmaLogicalAllocatorMax: IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE = IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(2i32);
pub const IommuDmaLogicalAllocatorNone: IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE = IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(0i32);
pub const IrqPolicyAllCloseProcessors: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(1i32);
pub const IrqPolicyAllProcessorsInMachine: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(3i32);
pub const IrqPolicyAllProcessorsInMachineWhenSteered: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(6i32);
pub const IrqPolicyMachineDefault: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(0i32);
pub const IrqPolicyOneCloseProcessor: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(2i32);
pub const IrqPolicySpecifiedProcessors: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(4i32);
pub const IrqPolicySpreadMessagesAcrossAllProcessors: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(5i32);
pub const IrqPriorityHigh: IRQ_PRIORITY = IRQ_PRIORITY(3i32);
pub const IrqPriorityLow: IRQ_PRIORITY = IRQ_PRIORITY(1i32);
pub const IrqPriorityNormal: IRQ_PRIORITY = IRQ_PRIORITY(2i32);
pub const IrqPriorityUndefined: IRQ_PRIORITY = IRQ_PRIORITY(0i32);
pub const Isa: INTERFACE_TYPE = INTERFACE_TYPE(1i32);
pub const IsochCommand: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(6i32);
pub const IsochStatus: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(0i32);
pub const KADDRESS_BASE: u32 = 0u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KADDRESS_RANGE {
    pub Address: *mut core::ffi::c_void,
    pub Size: usize,
}
impl Default for KADDRESS_RANGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KADDRESS_RANGE_DESCRIPTOR {
    pub AddressRanges: *const KADDRESS_RANGE,
    pub AddressRangeCount: usize,
}
impl Default for KADDRESS_RANGE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KAPC {
    pub Type: u8,
    pub AllFlags: u8,
    pub Size: u8,
    pub SpareByte1: u8,
    pub SpareLong0: u32,
    pub Thread: *mut isize,
    pub ApcListEntry: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub Reserved: [*mut core::ffi::c_void; 3],
    pub NormalContext: *mut core::ffi::c_void,
    pub SystemArgument1: *mut core::ffi::c_void,
    pub SystemArgument2: *mut core::ffi::c_void,
    pub ApcStateIndex: i8,
    pub ApcMode: i8,
    pub Inserted: bool,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for KAPC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_ADD_PAGES {
    pub Context: *mut core::ffi::c_void,
    pub Flags: u32,
    pub BugCheckCode: u32,
    pub Address: usize,
    pub Count: usize,
}
impl Default for KBUGCHECK_ADD_PAGES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KBUGCHECK_BUFFER_DUMP_STATE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KBUGCHECK_CALLBACK_REASON(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_CALLBACK_RECORD {
    pub Entry: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub CallbackRoutine: PKBUGCHECK_CALLBACK_ROUTINE,
    pub Buffer: *mut core::ffi::c_void,
    pub Length: u32,
    pub Component: *mut u8,
    pub Checksum: usize,
    pub State: u8,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for KBUGCHECK_CALLBACK_RECORD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type KBUGCHECK_CALLBACK_ROUTINE = Option<unsafe extern "system" fn(buffer: *mut core::ffi::c_void, length: u32)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_DUMP_IO {
    pub Offset: u64,
    pub Buffer: *mut core::ffi::c_void,
    pub BufferLength: u32,
    pub Type: KBUGCHECK_DUMP_IO_TYPE,
}
impl Default for KBUGCHECK_DUMP_IO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KBUGCHECK_DUMP_IO_TYPE(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_REASON_CALLBACK_RECORD {
    pub Entry: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub CallbackRoutine: PKBUGCHECK_REASON_CALLBACK_ROUTINE,
    pub Component: *mut u8,
    pub Checksum: usize,
    pub Reason: KBUGCHECK_CALLBACK_REASON,
    pub State: u8,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for KBUGCHECK_REASON_CALLBACK_RECORD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Kernel")]
pub type KBUGCHECK_REASON_CALLBACK_ROUTINE = Option<unsafe extern "system" fn(reason: KBUGCHECK_CALLBACK_REASON, record: *const KBUGCHECK_REASON_CALLBACK_RECORD, reasonspecificdata: *mut core::ffi::c_void, reasonspecificdatalength: u32)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_REMOVE_PAGES {
    pub Context: *mut core::ffi::c_void,
    pub Flags: u32,
    pub BugCheckCode: u32,
    pub Address: usize,
    pub Count: usize,
}
impl Default for KBUGCHECK_REMOVE_PAGES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_SECONDARY_DUMP_DATA {
    pub InBuffer: *mut core::ffi::c_void,
    pub InBufferLength: u32,
    pub MaximumAllowed: u32,
    pub Guid: windows_core::GUID,
    pub OutBuffer: *mut core::ffi::c_void,
    pub OutBufferLength: u32,
}
impl Default for KBUGCHECK_SECONDARY_DUMP_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_SECONDARY_DUMP_DATA_EX {
    pub InBuffer: *mut core::ffi::c_void,
    pub InBufferLength: u32,
    pub MaximumAllowed: u32,
    pub Guid: windows_core::GUID,
    pub OutBuffer: *mut core::ffi::c_void,
    pub OutBufferLength: u32,
    pub Context: *mut core::ffi::c_void,
    pub Flags: u32,
    pub DumpType: u32,
    pub BugCheckCode: u32,
    pub BugCheckParameter1: usize,
    pub BugCheckParameter2: usize,
    pub BugCheckParameter3: usize,
    pub BugCheckParameter4: usize,
}
impl Default for KBUGCHECK_SECONDARY_DUMP_DATA_EX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KBUGCHECK_TRIAGE_DUMP_DATA {
    pub DataArray: *mut KTRIAGE_DUMP_DATA_ARRAY,
    pub Flags: u32,
    pub MaxVirtMemSize: u32,
    pub BugCheckCode: u32,
    pub BugCheckParameter1: usize,
    pub BugCheckParameter2: usize,
    pub BugCheckParameter3: usize,
    pub BugCheckParameter4: usize,
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for KBUGCHECK_TRIAGE_DUMP_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const KB_ADD_PAGES_FLAG_ADDITIONAL_RANGES_EXIST: u32 = 2147483648u32;
pub const KB_ADD_PAGES_FLAG_PHYSICAL_ADDRESS: u32 = 2u32;
pub const KB_ADD_PAGES_FLAG_VIRTUAL_ADDRESS: u32 = 1u32;
pub const KB_REMOVE_PAGES_FLAG_ADDITIONAL_RANGES_EXIST: u32 = 2147483648u32;
pub const KB_REMOVE_PAGES_FLAG_PHYSICAL_ADDRESS: u32 = 2u32;
pub const KB_REMOVE_PAGES_FLAG_VIRTUAL_ADDRESS: u32 = 1u32;
pub const KB_SECONDARY_DATA_FLAG_ADDITIONAL_DATA: u32 = 1u32;
pub const KB_SECONDARY_DATA_FLAG_NO_DEVICE_ACCESS: u32 = 2u32;
pub const KB_TRIAGE_DUMP_DATA_FLAG_BUGCHECK_ACTIVE: u32 = 1u32;
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
pub type KDEFERRED_ROUTINE = Option<unsafe extern "system" fn(dpc: *const super::super::Foundation::KDPC, deferredcontext: *const core::ffi::c_void, systemargument1: *const core::ffi::c_void, systemargument2: *const core::ffi::c_void)>;
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KDEVICE_QUEUE_ENTRY {
    pub DeviceListEntry: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub SortKey: u32,
    pub Inserted: bool,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KDPC_IMPORTANCE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KDPC_WATCHDOG_INFORMATION {
    pub DpcTimeLimit: u32,
    pub DpcTimeCount: u32,
    pub DpcWatchdogLimit: u32,
    pub DpcWatchdogCount: u32,
    pub Reserved: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KD_CALLBACK_ACTION(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KD_NAMESPACE_ENUM(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KD_OPTION(pub i32);
pub const KD_OPTION_SET_BLOCK_ENABLE: KD_OPTION = KD_OPTION(0i32);
pub const KENCODED_TIMER_PROCESSOR: u32 = 1u32;
pub const KERNEL_LARGE_STACK_COMMIT: u32 = 12288u32;
pub const KERNEL_LARGE_STACK_SIZE: u32 = 61440u32;
pub const KERNEL_MCA_EXCEPTION_STACK_SIZE: u32 = 8192u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KERNEL_SOFT_RESTART_NOTIFICATION {
    pub Version: u16,
    pub Size: u16,
    pub Event: windows_core::GUID,
}
pub const KERNEL_SOFT_RESTART_NOTIFICATION_VERSION: u32 = 1u32;
pub const KERNEL_STACK_SIZE: u32 = 12288u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KERNEL_USER_TIMES {
    pub CreateTime: i64,
    pub ExitTime: i64,
    pub KernelTime: i64,
    pub UserTime: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_BASIC_INFORMATION {
    pub LastWriteTime: i64,
    pub TitleIndex: u32,
    pub NameLength: u32,
    pub Name: [u16; 1],
}
impl Default for KEY_BASIC_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_CACHED_INFORMATION {
    pub LastWriteTime: i64,
    pub TitleIndex: u32,
    pub SubKeys: u32,
    pub MaxNameLen: u32,
    pub Values: u32,
    pub MaxValueNameLen: u32,
    pub MaxValueDataLen: u32,
    pub NameLength: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_CONTROL_FLAGS_INFORMATION {
    pub ControlFlags: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_FULL_INFORMATION {
    pub LastWriteTime: i64,
    pub TitleIndex: u32,
    pub ClassOffset: u32,
    pub ClassLength: u32,
    pub SubKeys: u32,
    pub MaxNameLen: u32,
    pub MaxClassLen: u32,
    pub Values: u32,
    pub MaxValueNameLen: u32,
    pub MaxValueDataLen: u32,
    pub Class: [u16; 1],
}
impl Default for KEY_FULL_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_LAYER_INFORMATION {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_NAME_INFORMATION {
    pub NameLength: u32,
    pub Name: [u16; 1],
}
impl Default for KEY_NAME_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_NODE_INFORMATION {
    pub LastWriteTime: i64,
    pub TitleIndex: u32,
    pub ClassOffset: u32,
    pub ClassLength: u32,
    pub NameLength: u32,
    pub Name: [u16; 1],
}
impl Default for KEY_NODE_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_SET_VIRTUALIZATION_INFORMATION {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_TRUST_INFORMATION {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_VALUE_BASIC_INFORMATION {
    pub TitleIndex: u32,
    pub Type: u32,
    pub NameLength: u32,
    pub Name: [u16; 1],
}
impl Default for KEY_VALUE_BASIC_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_VALUE_FULL_INFORMATION {
    pub TitleIndex: u32,
    pub Type: u32,
    pub DataOffset: u32,
    pub DataLength: u32,
    pub NameLength: u32,
    pub Name: [u16; 1],
}
impl Default for KEY_VALUE_FULL_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_VALUE_LAYER_INFORMATION {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_VALUE_PARTIAL_INFORMATION {
    pub TitleIndex: u32,
    pub Type: u32,
    pub DataLength: u32,
    pub Data: [u8; 1],
}
impl Default for KEY_VALUE_PARTIAL_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KEY_VALUE_PARTIAL_INFORMATION_ALIGN64 {
    pub Type: u32,
    pub DataLength: u32,
    pub Data: [u8; 1],
}
impl Default for KEY_VALUE_PARTIAL_INFORMATION_ALIGN64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_VIRTUALIZATION_INFORMATION {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_WOW64_FLAGS_INFORMATION {
    pub UserFlags: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KEY_WRITE_TIME_INFORMATION {
    pub LastWriteTime: i64,
}
pub const KE_MAX_TRIAGE_DUMP_DATA_MEMORY_SIZE: u32 = 33554432u32;
pub const KE_PROCESSOR_CHANGE_ADD_EXISTING: u32 = 1u32;
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KE_PROCESSOR_CHANGE_NOTIFY_CONTEXT {
    pub State: KE_PROCESSOR_CHANGE_NOTIFY_STATE,
    pub NtNumber: u32,
    pub Status: super::super::super::Win32::Foundation::NTSTATUS,
    pub ProcNumber: super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KE_PROCESSOR_CHANGE_NOTIFY_STATE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KFLOATING_SAVE {
    pub ControlWord: u32,
    pub StatusWord: u32,
    pub ErrorOffset: u32,
    pub ErrorSelector: u32,
    pub DataOffset: u32,
    pub DataSelector: u32,
    pub Spare0: u32,
    pub Spare1: u32,
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub struct KGATE {
    pub Header: super::super::Foundation::DISPATCHER_HEADER,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
impl Default for KGATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KINTERRUPT_MODE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KINTERRUPT_POLARITY(pub i32);
pub type KIPI_BROADCAST_WORKER = Option<unsafe extern "system" fn(argument: usize) -> usize>;
pub const KI_USER_SHARED_DATA: u32 = 4292804608u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KLOCK_QUEUE_HANDLE {
    pub LockQueue: KSPIN_LOCK_QUEUE,
    pub OldIrql: u8,
}
pub type KMESSAGE_SERVICE_ROUTINE = Option<unsafe extern "system" fn(interrupt: *const isize, servicecontext: *const core::ffi::c_void, messageid: u32) -> bool>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KPROFILE_SOURCE(pub i32);
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub struct KSEMAPHORE {
    pub Header: super::super::Foundation::DISPATCHER_HEADER,
    pub Limit: i32,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
impl Default for KSEMAPHORE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type KSERVICE_ROUTINE = Option<unsafe extern "system" fn(interrupt: *const isize, servicecontext: *const core::ffi::c_void) -> bool>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KSPIN_LOCK_QUEUE {
    pub Next: *mut KSPIN_LOCK_QUEUE,
    pub Lock: *mut usize,
}
impl Default for KSPIN_LOCK_QUEUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type KSTART_ROUTINE = Option<unsafe extern "system" fn(startcontext: *const core::ffi::c_void)>;
pub type KSYNCHRONIZE_ROUTINE = Option<unsafe extern "system" fn(synchronizecontext: *const core::ffi::c_void) -> bool>;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KSYSTEM_TIME {
    pub LowPart: u32,
    pub High1Time: i32,
    pub High2Time: i32,
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub struct KTIMER {
    pub Header: super::super::Foundation::DISPATCHER_HEADER,
    pub DueTime: u64,
    pub TimerListEntry: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub Dpc: *mut super::super::Foundation::KDPC,
    pub Period: u32,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
impl Default for KTIMER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KTRIAGE_DUMP_DATA_ARRAY {
    pub List: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub NumBlocksUsed: u32,
    pub NumBlocksTotal: u32,
    pub DataSize: u32,
    pub MaxDataSize: u32,
    pub ComponentNameBufferLength: u32,
    pub ComponentName: *mut u8,
    pub Blocks: [KADDRESS_RANGE; 1],
}
#[cfg(feature = "Win32_System_Kernel")]
impl Default for KTRIAGE_DUMP_DATA_ARRAY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const KUMS_UCH_VOLATILE_BIT: u32 = 0u32;
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub struct KUSER_SHARED_DATA {
    pub TickCountLowDeprecated: u32,
    pub TickCountMultiplier: u32,
    pub InterruptTime: KSYSTEM_TIME,
    pub SystemTime: KSYSTEM_TIME,
    pub TimeZoneBias: KSYSTEM_TIME,
    pub ImageNumberLow: u16,
    pub ImageNumberHigh: u16,
    pub NtSystemRoot: [u16; 260],
    pub MaxStackTraceDepth: u32,
    pub CryptoExponent: u32,
    pub TimeZoneId: u32,
    pub LargePageMinimum: u32,
    pub AitSamplingValue: u32,
    pub AppCompatFlag: u32,
    pub RNGSeedVersion: u64,
    pub GlobalValidationRunlevel: u32,
    pub TimeZoneBiasStamp: i32,
    pub NtBuildNumber: u32,
    pub NtProductType: super::super::super::Win32::System::Kernel::NT_PRODUCT_TYPE,
    pub ProductTypeIsValid: bool,
    pub Reserved0: [bool; 1],
    pub NativeProcessorArchitecture: u16,
    pub NtMajorVersion: u32,
    pub NtMinorVersion: u32,
    pub ProcessorFeatures: [bool; 64],
    pub Reserved1: u32,
    pub Reserved3: u32,
    pub TimeSlip: u32,
    pub AlternativeArchitecture: ALTERNATIVE_ARCHITECTURE_TYPE,
    pub BootId: u32,
    pub SystemExpirationDate: i64,
    pub SuiteMask: u32,
    pub KdDebuggerEnabled: bool,
    pub Anonymous1: KUSER_SHARED_DATA_0,
    pub CyclesPerYield: u16,
    pub ActiveConsoleId: u32,
    pub DismountCount: u32,
    pub ComPlusPackage: u32,
    pub LastSystemRITEventTickCount: u32,
    pub NumberOfPhysicalPages: u32,
    pub SafeBootMode: bool,
    pub Anonymous2: KUSER_SHARED_DATA_1,
    pub Reserved12: [u8; 2],
    pub Anonymous3: KUSER_SHARED_DATA_2,
    pub DataFlagsPad: [u32; 1],
    pub TestRetInstruction: u64,
    pub QpcFrequency: i64,
    pub SystemCall: u32,
    pub Reserved2: u32,
    pub SystemCallPad: [u64; 2],
    pub Anonymous4: KUSER_SHARED_DATA_3,
    pub Cookie: u32,
    pub CookiePad: [u32; 1],
    pub ConsoleSessionForegroundProcessId: i64,
    pub TimeUpdateLock: u64,
    pub BaselineSystemTimeQpc: u64,
    pub BaselineInterruptTimeQpc: u64,
    pub QpcSystemTimeIncrement: u64,
    pub QpcInterruptTimeIncrement: u64,
    pub QpcSystemTimeIncrementShift: u8,
    pub QpcInterruptTimeIncrementShift: u8,
    pub UnparkedProcessorCount: u16,
    pub EnclaveFeatureMask: [u32; 4],
    pub TelemetryCoverageRound: u32,
    pub UserModeGlobalLogger: [u16; 16],
    pub ImageFileExecutionOptions: u32,
    pub LangGenerationCount: u32,
    pub Reserved4: u64,
    pub InterruptTimeBias: u64,
    pub QpcBias: u64,
    pub ActiveProcessorCount: u32,
    pub ActiveGroupCount: u8,
    pub Reserved9: u8,
    pub Anonymous5: KUSER_SHARED_DATA_4,
    pub TimeZoneBiasEffectiveStart: i64,
    pub TimeZoneBiasEffectiveEnd: i64,
    pub XState: super::super::super::Win32::System::Diagnostics::Debug::XSTATE_CONFIGURATION,
    pub FeatureConfigurationChangeStamp: KSYSTEM_TIME,
    pub Spare: u32,
    pub UserPointerAuthMask: u64,
}
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl Default for KUSER_SHARED_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub union KUSER_SHARED_DATA_0 {
    pub MitigationPolicies: u8,
    pub Anonymous: KUSER_SHARED_DATA_0_0,
}
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl Default for KUSER_SHARED_DATA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KUSER_SHARED_DATA_0_0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub union KUSER_SHARED_DATA_1 {
    pub VirtualizationFlags: u8,
}
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl Default for KUSER_SHARED_DATA_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub union KUSER_SHARED_DATA_2 {
    pub SharedDataFlags: u32,
    pub Anonymous: KUSER_SHARED_DATA_2_0,
}
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl Default for KUSER_SHARED_DATA_2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KUSER_SHARED_DATA_2_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub union KUSER_SHARED_DATA_3 {
    pub TickCount: KSYSTEM_TIME,
    pub TickCountQuad: u64,
    pub Anonymous: KUSER_SHARED_DATA_3_0,
}
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl Default for KUSER_SHARED_DATA_3 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KUSER_SHARED_DATA_3_0 {
    pub ReservedTickCountOverlay: [u32; 3],
    pub TickCountPad: [u32; 1],
}
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl Default for KUSER_SHARED_DATA_3_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy)]
pub union KUSER_SHARED_DATA_4 {
    pub QpcData: u16,
    pub Anonymous: KUSER_SHARED_DATA_4_0,
}
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
impl Default for KUSER_SHARED_DATA_4 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Diagnostics_Debug", feature = "Win32_System_Kernel"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct KUSER_SHARED_DATA_4_0 {
    pub QpcBypassEnabled: u8,
    pub QpcShift: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct KWAIT_CHAIN {
    pub Head: *mut core::ffi::c_void,
}
impl Default for KWAIT_CHAIN {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct KWAIT_REASON(pub i32);
pub const KbCallbackAddPages: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(4i32);
pub const KbCallbackDumpIo: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(3i32);
pub const KbCallbackInvalid: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(0i32);
pub const KbCallbackRemovePages: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(6i32);
pub const KbCallbackReserved1: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(1i32);
pub const KbCallbackReserved2: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(8i32);
pub const KbCallbackSecondaryDumpData: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(2i32);
pub const KbCallbackSecondaryMultiPartDumpData: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(5i32);
pub const KbCallbackTriageDumpData: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(7i32);
pub const KbDumpIoBody: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(2i32);
pub const KbDumpIoComplete: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(4i32);
pub const KbDumpIoHeader: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(1i32);
pub const KbDumpIoInvalid: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(0i32);
pub const KbDumpIoSecondaryData: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(3i32);
pub const KdConfigureDeviceAndContinue: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(0i32);
pub const KdConfigureDeviceAndStop: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(2i32);
pub const KdNameSpaceACPI: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(1i32);
pub const KdNameSpaceAny: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(2i32);
pub const KdNameSpaceMax: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(4i32);
pub const KdNameSpaceNone: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(3i32);
pub const KdNameSpacePCI: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(0i32);
pub const KdSkipDeviceAndContinue: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(1i32);
pub const KdSkipDeviceAndStop: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(3i32);
pub const KeProcessorAddCompleteNotify: KE_PROCESSOR_CHANGE_NOTIFY_STATE = KE_PROCESSOR_CHANGE_NOTIFY_STATE(1i32);
pub const KeProcessorAddFailureNotify: KE_PROCESSOR_CHANGE_NOTIFY_STATE = KE_PROCESSOR_CHANGE_NOTIFY_STATE(2i32);
pub const KeProcessorAddStartNotify: KE_PROCESSOR_CHANGE_NOTIFY_STATE = KE_PROCESSOR_CHANGE_NOTIFY_STATE(0i32);
pub const KeepObject: IO_ALLOCATION_ACTION = IO_ALLOCATION_ACTION(1i32);
pub const KernelMode: MODE = MODE(0i32);
pub const KeyboardController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(22i32);
pub const KeyboardPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(32i32);
pub const L0sAndL1EntryDisabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(0i32);
pub const L0sAndL1EntryEnabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(3i32);
pub const L0sAndL1EntrySupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(3i32);
pub const L0sEntryEnabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(1i32);
pub const L0sEntrySupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(1i32);
pub const L0s_128ns_256ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(2i32);
pub const L0s_1us_2us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(5i32);
pub const L0s_256ns_512ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(3i32);
pub const L0s_2us_4us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(6i32);
pub const L0s_512ns_1us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(4i32);
pub const L0s_64ns_128ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(1i32);
pub const L0s_Above4us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(7i32);
pub const L0s_Below64ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(0i32);
pub const L1EntryEnabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(2i32);
pub const L1EntrySupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(2i32);
pub const L1_16us_32us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(5i32);
pub const L1_1us_2us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(1i32);
pub const L1_2us_4us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(2i32);
pub const L1_32us_64us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(6i32);
pub const L1_4us_8us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(3i32);
pub const L1_8us_16us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(4i32);
pub const L1_Above64us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(7i32);
pub const L1_Below1us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct LEGACY_BUS_INFORMATION {
    pub BusTypeGuid: windows_core::GUID,
    pub LegacyBusType: INTERFACE_TYPE,
    pub BusNumber: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct LINK_SHARE_ACCESS {
    pub OpenCount: u32,
    pub Deleters: u32,
    pub SharedDelete: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct LOADER_PARTITION_INFORMATION_EX {
    pub PartitionStyle: u32,
    pub PartitionNumber: u32,
    pub Anonymous: LOADER_PARTITION_INFORMATION_EX_0,
    pub Flags: u32,
}
impl Default for LOADER_PARTITION_INFORMATION_EX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union LOADER_PARTITION_INFORMATION_EX_0 {
    pub Signature: u32,
    pub DeviceId: windows_core::GUID,
}
impl Default for LOADER_PARTITION_INFORMATION_EX_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct LOCK_OPERATION(pub i32);
pub const LOCK_QUEUE_HALTED: u32 = 4u32;
pub const LOCK_QUEUE_HALTED_BIT: u32 = 2u32;
pub const LOCK_QUEUE_OWNER: u32 = 2u32;
pub const LOCK_QUEUE_OWNER_BIT: u32 = 1u32;
pub const LOCK_QUEUE_WAIT: u32 = 1u32;
pub const LOCK_QUEUE_WAIT_BIT: u32 = 0u32;
pub const LONG_2ND_MOST_SIGNIFICANT_BIT: u32 = 2u32;
pub const LONG_3RD_MOST_SIGNIFICANT_BIT: u32 = 1u32;
pub const LONG_LEAST_SIGNIFICANT_BIT: u32 = 0u32;
pub const LONG_MOST_SIGNIFICANT_BIT: u32 = 3u32;
pub const LOWBYTE_MASK: u32 = 255u32;
pub const LOW_LEVEL: u32 = 0u32;
pub const LOW_PRIORITY: u32 = 0u32;
pub const LOW_REALTIME_PRIORITY: u32 = 16u32;
pub const LastDStateTransitionD3cold: D3COLD_LAST_TRANSITION_STATUS = D3COLD_LAST_TRANSITION_STATUS(2i32);
pub const LastDStateTransitionD3hot: D3COLD_LAST_TRANSITION_STATUS = D3COLD_LAST_TRANSITION_STATUS(1i32);
pub const LastDStateTransitionStatusUnknown: D3COLD_LAST_TRANSITION_STATUS = D3COLD_LAST_TRANSITION_STATUS(0i32);
pub const LastDrvRtFlag: DRIVER_RUNTIME_INIT_FLAGS = DRIVER_RUNTIME_INIT_FLAGS(2i32);
pub const Latched: KINTERRUPT_MODE = KINTERRUPT_MODE(1i32);
pub const LevelSensitive: KINTERRUPT_MODE = KINTERRUPT_MODE(0i32);
pub const LinePeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(35i32);
pub const LocateControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(3i32);
pub const LocationTypeFileSystem: STATE_LOCATION_TYPE = STATE_LOCATION_TYPE(1i32);
pub const LocationTypeMaximum: STATE_LOCATION_TYPE = STATE_LOCATION_TYPE(2i32);
pub const LocationTypeRegistry: STATE_LOCATION_TYPE = STATE_LOCATION_TYPE(0i32);
pub const LoggerEventsLoggedClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(10i32);
pub const LoggerEventsLostClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(8i32);
pub const LowImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(0i32);
pub const LowPagePriority: MM_PAGE_PRIORITY = MM_PAGE_PRIORITY(0i32);
pub const LowPoolPriority: EX_POOL_PRIORITY = EX_POOL_PRIORITY(0i32);
pub const LowPoolPrioritySpecialPoolOverrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(8i32);
pub const LowPoolPrioritySpecialPoolUnderrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(9i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct MAILSLOT_CREATE_PARAMETERS {
    pub MailslotQuota: u32,
    pub MaximumMessageSize: u32,
    pub ReadTimeout: i64,
    pub TimeoutSpecified: bool,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MAP_REGISTER_ENTRY {
    pub MapRegister: *mut core::ffi::c_void,
    pub WriteToDevice: bool,
}
impl Default for MAP_REGISTER_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const MAXIMUM_DEBUG_BARS: u32 = 6u32;
pub const MAXIMUM_FILENAME_LENGTH: u32 = 256u32;
pub const MAXIMUM_PRIORITY: u32 = 32u32;
pub const MAX_EVENT_COUNTERS: u32 = 31u32;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MCA_DRIVER_INFO {
    pub ExceptionCallback: isize,
    pub DpcCallback: super::super::Foundation::PKDEFERRED_ROUTINE,
    pub DeviceContext: *mut core::ffi::c_void,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for MCA_DRIVER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct MCA_EXCEPTION {
    pub VersionNumber: u32,
    pub ExceptionType: MCA_EXCEPTION_TYPE,
    pub TimeStamp: i64,
    pub ProcessorNumber: u32,
    pub Reserved1: u32,
    pub u: MCA_EXCEPTION_0,
    pub ExtCnt: u32,
    pub Reserved3: u32,
    pub ExtReg: [u64; 24],
}
impl Default for MCA_EXCEPTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union MCA_EXCEPTION_0 {
    pub Mca: MCA_EXCEPTION_0_0,
    pub Mce: MCA_EXCEPTION_0_1,
}
impl Default for MCA_EXCEPTION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct MCA_EXCEPTION_0_0 {
    pub BankNumber: u8,
    pub Reserved2: [u8; 7],
    pub Status: MCI_STATS,
    pub Address: MCI_ADDR,
    pub Misc: u64,
}
impl Default for MCA_EXCEPTION_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct MCA_EXCEPTION_0_1 {
    pub Address: u64,
    pub Type: u64,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MCA_EXCEPTION_TYPE(pub i32);
pub const MCA_EXTREG_V2MAX: u32 = 24u32;
pub const MCE_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe8f56ffe_919c_4cc5_ba88_65abe14913bb);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub union MCG_CAP {
    pub Anonymous: MCG_CAP_0,
    pub QuadPart: u64,
}
impl Default for MCG_CAP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct MCG_CAP_0 {
    pub _bitfield: u64,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub union MCG_STATUS {
    pub Anonymous: MCG_STATUS_0,
    pub QuadPart: u64,
}
impl Default for MCG_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct MCG_STATUS_0 {
    pub _bitfield: u32,
    pub Reserved2: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union MCI_ADDR {
    pub Anonymous: MCI_ADDR_0,
    pub QuadPart: u64,
}
impl Default for MCI_ADDR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct MCI_ADDR_0 {
    pub Address: u32,
    pub Reserved: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union MCI_STATS {
    pub MciStats: MCI_STATS_0,
    pub QuadPart: u64,
}
impl Default for MCI_STATS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct MCI_STATS_0 {
    pub McaCod: u16,
    pub MsCod: u16,
    pub _bitfield: u32,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub union MCI_STATUS {
    pub CommonBits: MCI_STATUS_BITS_COMMON,
    pub AmdBits: MCI_STATUS_AMD_BITS,
    pub IntelBits: MCI_STATUS_INTEL_BITS,
    pub QuadPart: u64,
}
impl Default for MCI_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct MCI_STATUS_AMD_BITS {
    pub _bitfield: u64,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct MCI_STATUS_BITS_COMMON {
    pub _bitfield: u64,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct MCI_STATUS_INTEL_BITS {
    pub _bitfield: u64,
}
pub const MDL_ALLOCATED_FIXED_SIZE: u32 = 8u32;
pub const MDL_DESCRIBES_AWE: u32 = 1024u32;
pub const MDL_FREE_EXTRA_PTES: u32 = 512u32;
pub const MDL_INTERNAL: u32 = 32768u32;
pub const MDL_LOCKED_PAGE_TABLES: u32 = 256u32;
pub const MDL_PAGE_CONTENTS_INVARIANT: u32 = 16384u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MEMORY_CACHING_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MEMORY_CACHING_TYPE_ORIG(pub i32);
pub const MEMORY_CORRECTABLE_ERROR_SUMMARY_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x0e36c93e_ca15_4a83_ba8a_cbe80f7f0017);
pub const MEMORY_ERROR_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xa5bc1114_6f64_4ede_b863_3e83ed7c83b1);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct MEMORY_PARTITION_DEDICATED_MEMORY_OPEN_INFORMATION {
    pub DedicatedMemoryTypeId: u64,
    pub HandleAttributes: u32,
    pub DesiredAccess: u32,
    pub DedicatedMemoryPartitionHandle: super::super::super::Win32::Foundation::HANDLE,
}
pub const MEM_COMMIT: u32 = 4096u32;
pub const MEM_DECOMMIT: u32 = 16384u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MEM_DEDICATED_ATTRIBUTE_TYPE(pub i32);
pub const MEM_EXTENDED_PARAMETER_EC_CODE: u32 = 64u32;
pub const MEM_EXTENDED_PARAMETER_TYPE_BITS: u32 = 8u32;
pub const MEM_LARGE_PAGES: u32 = 536870912u32;
pub const MEM_MAPPED: u32 = 262144u32;
pub const MEM_PRIVATE: u32 = 131072u32;
pub const MEM_RELEASE: u32 = 32768u32;
pub const MEM_RESERVE: u32 = 8192u32;
pub const MEM_RESET: u32 = 524288u32;
pub const MEM_RESET_UNDO: u32 = 16777216u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MEM_SECTION_EXTENDED_PARAMETER_TYPE(pub i32);
pub const MEM_TOP_DOWN: u32 = 1048576u32;
pub const MM_ADD_PHYSICAL_MEMORY_ALREADY_ZEROED: u32 = 1u32;
pub const MM_ADD_PHYSICAL_MEMORY_HUGE_PAGES_ONLY: u32 = 4u32;
pub const MM_ADD_PHYSICAL_MEMORY_LARGE_PAGES_ONLY: u32 = 2u32;
pub const MM_ALLOCATE_AND_HOT_REMOVE: u32 = 256u32;
pub const MM_ALLOCATE_CONTIGUOUS_MEMORY_FAST_ONLY: u32 = 1u32;
pub const MM_ALLOCATE_FAST_LARGE_PAGES: u32 = 64u32;
pub const MM_ALLOCATE_FROM_LOCAL_NODE_ONLY: u32 = 2u32;
pub const MM_ALLOCATE_FULLY_REQUIRED: u32 = 4u32;
pub const MM_ALLOCATE_NO_WAIT: u32 = 8u32;
pub const MM_ALLOCATE_PREFER_CONTIGUOUS: u32 = 16u32;
pub const MM_ALLOCATE_REQUIRE_CONTIGUOUS_CHUNKS: u32 = 32u32;
pub const MM_ALLOCATE_TRIM_IF_NECESSARY: u32 = 128u32;
pub const MM_ANY_NODE_OK: u32 = 2147483648u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct MM_COPY_ADDRESS {
    pub Anonymous: MM_COPY_ADDRESS_0,
}
impl Default for MM_COPY_ADDRESS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union MM_COPY_ADDRESS_0 {
    pub VirtualAddress: *mut core::ffi::c_void,
    pub PhysicalAddress: i64,
}
impl Default for MM_COPY_ADDRESS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const MM_COPY_MEMORY_PHYSICAL: u32 = 1u32;
pub const MM_COPY_MEMORY_VIRTUAL: u32 = 2u32;
pub const MM_DONT_ZERO_ALLOCATION: u32 = 1u32;
pub const MM_DUMP_MAP_CACHED: u32 = 1u32;
pub const MM_DUMP_MAP_INVALIDATE: u32 = 2u32;
pub const MM_FREE_MDL_PAGES_ZERO: u32 = 1u32;
pub const MM_GET_CACHE_ATTRIBUTE_IO_SPACE: u32 = 1u32;
pub const MM_GET_PHYSICAL_MEMORY_RANGES_INCLUDE_ALL_PARTITIONS: u32 = 2u32;
pub const MM_GET_PHYSICAL_MEMORY_RANGES_INCLUDE_FILE_ONLY: u32 = 1u32;
pub const MM_MAPPING_ADDRESS_DIVISIBLE: u32 = 1u32;
pub const MM_MAXIMUM_DISK_IO_SIZE: u32 = 65536u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MM_MDL_PAGE_CONTENTS_STATE(pub i32);
pub type MM_MDL_ROUTINE = Option<unsafe extern "system" fn(drivercontext: *const core::ffi::c_void, mappedva: *const core::ffi::c_void)>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MM_PAGE_PRIORITY(pub i32);
pub const MM_PERMANENT_ADDRESS_IS_IO_SPACE: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct MM_PHYSICAL_ADDRESS_LIST {
    pub PhysicalAddress: i64,
    pub NumberOfBytes: usize,
}
pub const MM_PROTECT_DRIVER_SECTION_ALLOW_UNLOAD: u32 = 1u32;
pub const MM_PROTECT_DRIVER_SECTION_VALID_FLAGS: u32 = 1u32;
pub const MM_REMOVE_PHYSICAL_MEMORY_BAD_ONLY: u32 = 1u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MM_ROTATE_DIRECTION(pub i32);
pub const MM_SECURE_EXCLUSIVE: u32 = 1u32;
pub const MM_SECURE_NO_CHANGE: u32 = 2u32;
pub const MM_SECURE_NO_INHERIT: u32 = 8u32;
pub const MM_SECURE_USER_MODE_ONLY: u32 = 4u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MM_SYSTEMSIZE(pub i32);
pub const MM_SYSTEM_SPACE_END: u32 = 4294967295u32;
pub const MM_SYSTEM_VIEW_EXCEPTIONS_FOR_INPAGE_ERRORS: u32 = 1u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct MODE(pub i32);
pub const MPIBus: INTERFACE_TYPE = INTERFACE_TYPE(10i32);
pub const MPIConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(8i32);
pub const MPSABus: INTERFACE_TYPE = INTERFACE_TYPE(11i32);
pub const MPSAConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(9i32);
pub const MRLClosed: PCI_EXPRESS_MRL_STATE = PCI_EXPRESS_MRL_STATE(0i32);
pub const MRLOpen: PCI_EXPRESS_MRL_STATE = PCI_EXPRESS_MRL_STATE(1i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct MU_TELEMETRY_SECTION {
    pub ComponentID: windows_core::GUID,
    pub SubComponentID: windows_core::GUID,
    pub Reserved: u32,
    pub ErrorStatusValue: u32,
    pub AdditionalInfo1: u64,
    pub AdditionalInfo2: u64,
}
pub const MU_TELEMETRY_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x85183a8b_9c41_429c_939c_5c3c087ca280);
pub const MapPhysicalAddressTypeContiguousRange: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(1i32);
pub const MapPhysicalAddressTypeMax: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(3i32);
pub const MapPhysicalAddressTypeMdl: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(0i32);
pub const MapPhysicalAddressTypePfn: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(2i32);
pub const MaxFaultType: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(7i32);
pub const MaxHardwareCounterType: HARDWARE_COUNTER_TYPE = HARDWARE_COUNTER_TYPE(1i32);
pub const MaxPayload1024Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(3i32);
pub const MaxPayload128Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(0i32);
pub const MaxPayload2048Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(4i32);
pub const MaxPayload256Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(1i32);
pub const MaxPayload4096Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(5i32);
pub const MaxPayload512Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(2i32);
pub const MaxRegNtNotifyClass: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(51i32);
pub const MaxSubsystemInformationType: SUBSYSTEM_INFORMATION_TYPE = SUBSYSTEM_INFORMATION_TYPE(2i32);
pub const MaxTraceInformationClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(16i32);
pub const MaximumBusDataType: BUS_DATA_TYPE = BUS_DATA_TYPE(12i32);
pub const MaximumDmaSpeed: DMA_SPEED = DMA_SPEED(5i32);
pub const MaximumDmaWidth: DMA_WIDTH = DMA_WIDTH(5i32);
pub const MaximumInterfaceType: INTERFACE_TYPE = INTERFACE_TYPE(18i32);
pub const MaximumMode: MODE = MODE(2i32);
pub const MaximumType: CONFIGURATION_TYPE = CONFIGURATION_TYPE(41i32);
pub const MaximumWaitReason: KWAIT_REASON = KWAIT_REASON(42i32);
pub const MaximumWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(7i32);
pub const MdlMappingNoExecute: u32 = 1073741824u32;
pub const MdlMappingNoWrite: u32 = 2147483648u32;
pub const MdlMappingWithGuardPtes: u32 = 536870912u32;
pub const MediumHighImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(3i32);
pub const MediumImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(1i32);
pub const MemDedicatedAttributeMax: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(4i32);
pub const MemDedicatedAttributeReadBandwidth: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(0i32);
pub const MemDedicatedAttributeReadLatency: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(1i32);
pub const MemDedicatedAttributeWriteBandwidth: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(2i32);
pub const MemDedicatedAttributeWriteLatency: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(3i32);
pub const MemSectionExtendedParameterInvalidType: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(0i32);
pub const MemSectionExtendedParameterMax: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(4i32);
pub const MemSectionExtendedParameterNumaNode: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(2i32);
pub const MemSectionExtendedParameterSigningLevel: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(3i32);
pub const MemSectionExtendedParameterUserPhysicalFlags: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(1i32);
pub const MicroChannel: INTERFACE_TYPE = INTERFACE_TYPE(3i32);
pub const MmCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(1i32);
pub const MmFrameBufferCached: MEMORY_CACHING_TYPE_ORIG = MEMORY_CACHING_TYPE_ORIG(2i32);
pub const MmHardwareCoherentCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(3i32);
pub const MmLargeSystem: MM_SYSTEMSIZE = MM_SYSTEMSIZE(2i32);
pub const MmMaximumCacheType: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(6i32);
pub const MmMaximumRotateDirection: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(4i32);
pub const MmMdlPageContentsDynamic: MM_MDL_PAGE_CONTENTS_STATE = MM_MDL_PAGE_CONTENTS_STATE(0i32);
pub const MmMdlPageContentsInvariant: MM_MDL_PAGE_CONTENTS_STATE = MM_MDL_PAGE_CONTENTS_STATE(1i32);
pub const MmMdlPageContentsQuery: MM_MDL_PAGE_CONTENTS_STATE = MM_MDL_PAGE_CONTENTS_STATE(2i32);
pub const MmMediumSystem: MM_SYSTEMSIZE = MM_SYSTEMSIZE(1i32);
pub const MmNonCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(0i32);
pub const MmNonCachedUnordered: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(4i32);
pub const MmNotMapped: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(-1i32);
pub const MmSmallSystem: MM_SYSTEMSIZE = MM_SYSTEMSIZE(0i32);
pub const MmToFrameBuffer: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(0i32);
pub const MmToFrameBufferNoCopy: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(1i32);
pub const MmToRegularMemory: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(2i32);
pub const MmToRegularMemoryNoCopy: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(3i32);
pub const MmUSWCCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(5i32);
pub const MmWriteCombined: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(2i32);
pub const ModemPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(28i32);
pub const ModifyAccess: IO_ACCESS_TYPE = IO_ACCESS_TYPE(2i32);
pub const MonitorPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(29i32);
pub const MonitorRequestReasonAcDcDisplayBurst: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(5i32);
pub const MonitorRequestReasonAcDcDisplayBurstSuppressed: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(28i32);
pub const MonitorRequestReasonBatteryCountChange: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(16i32);
pub const MonitorRequestReasonBatteryCountChangeSuppressed: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(49i32);
pub const MonitorRequestReasonBatteryPreCritical: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(53i32);
pub const MonitorRequestReasonBuiltinPanel: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(47i32);
pub const MonitorRequestReasonDP: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(19i32);
pub const MonitorRequestReasonDim: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(46i32);
pub const MonitorRequestReasonDirectedDrips: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(45i32);
pub const MonitorRequestReasonDisplayRequiredUnDim: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(48i32);
pub const MonitorRequestReasonFullWake: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(9i32);
pub const MonitorRequestReasonGracePeriod: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(17i32);
pub const MonitorRequestReasonIdleTimeout: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(12i32);
pub const MonitorRequestReasonLid: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(15i32);
pub const MonitorRequestReasonMax: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(55i32);
pub const MonitorRequestReasonNearProximity: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(22i32);
pub const MonitorRequestReasonPdcSignal: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(27i32);
pub const MonitorRequestReasonPdcSignalFingerprint: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(44i32);
pub const MonitorRequestReasonPdcSignalHeyCortana: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(42i32);
pub const MonitorRequestReasonPdcSignalHolographicShell: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(43i32);
pub const MonitorRequestReasonPdcSignalSensorsHumanPresence: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(52i32);
pub const MonitorRequestReasonPdcSignalWindowsMobilePwrNotif: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(40i32);
pub const MonitorRequestReasonPdcSignalWindowsMobileShell: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(41i32);
pub const MonitorRequestReasonPnP: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(18i32);
pub const MonitorRequestReasonPoSetSystemState: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(7i32);
pub const MonitorRequestReasonPolicyChange: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(13i32);
pub const MonitorRequestReasonPowerButton: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(1i32);
pub const MonitorRequestReasonRemoteConnection: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(2i32);
pub const MonitorRequestReasonResumeModernStandby: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(50i32);
pub const MonitorRequestReasonResumePdc: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(24i32);
pub const MonitorRequestReasonResumeS4: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(25i32);
pub const MonitorRequestReasonScMonitorpower: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(3i32);
pub const MonitorRequestReasonScreenOffRequest: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(11i32);
pub const MonitorRequestReasonSessionUnlock: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(10i32);
pub const MonitorRequestReasonSetThreadExecutionState: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(8i32);
pub const MonitorRequestReasonSleepButton: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(14i32);
pub const MonitorRequestReasonSxTransition: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(20i32);
pub const MonitorRequestReasonSystemIdle: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(21i32);
pub const MonitorRequestReasonSystemStateEntered: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(29i32);
pub const MonitorRequestReasonTerminal: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(26i32);
pub const MonitorRequestReasonTerminalInit: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(51i32);
pub const MonitorRequestReasonThermalStandby: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(23i32);
pub const MonitorRequestReasonUnknown: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(0i32);
pub const MonitorRequestReasonUserDisplayBurst: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(6i32);
pub const MonitorRequestReasonUserInput: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(4i32);
pub const MonitorRequestReasonUserInputAccelerometer: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(35i32);
pub const MonitorRequestReasonUserInputHid: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(36i32);
pub const MonitorRequestReasonUserInputInitialization: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(39i32);
pub const MonitorRequestReasonUserInputKeyboard: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(31i32);
pub const MonitorRequestReasonUserInputMouse: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(32i32);
pub const MonitorRequestReasonUserInputPen: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(34i32);
pub const MonitorRequestReasonUserInputPoUserPresent: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(37i32);
pub const MonitorRequestReasonUserInputSessionSwitch: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(38i32);
pub const MonitorRequestReasonUserInputTouch: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(54i32);
pub const MonitorRequestReasonUserInputTouchpad: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(33i32);
pub const MonitorRequestReasonWinrt: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(30i32);
pub const MonitorRequestTypeOff: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(0i32);
pub const MonitorRequestTypeOnAndPresent: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(1i32);
pub const MonitorRequestTypeToggleOn: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(2i32);
pub const MultiFunctionAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(12i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct NAMED_PIPE_CREATE_PARAMETERS {
    pub NamedPipeType: u32,
    pub ReadMode: u32,
    pub CompletionMode: u32,
    pub MaximumInstances: u32,
    pub InboundQuota: u32,
    pub OutboundQuota: u32,
    pub DefaultTimeout: i64,
    pub TimeoutSpecified: bool,
}
pub const NEC98x86: ALTERNATIVE_ARCHITECTURE_TYPE = ALTERNATIVE_ARCHITECTURE_TYPE(1i32);
pub type NMI_CALLBACK = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, handled: bool) -> bool>;
pub const NMI_NOTIFY_TYPE_GUID: windows_core::GUID = windows_core::GUID::from_u128(0x5bad89ff_b7e6_42c9_814a_cf2485d6e98a);
pub const NMI_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe71254e7_c1b9_4940_ab76_909703a4320f);
#[repr(C)]
#[derive(Clone, Copy)]
pub union NPEM_CAPABILITY_STANDARD {
    pub Anonymous: NPEM_CAPABILITY_STANDARD_0,
    pub AsULONG: u32,
}
impl Default for NPEM_CAPABILITY_STANDARD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct NPEM_CAPABILITY_STANDARD_0 {
    pub _bitfield: u32,
}
pub type NPEM_CONTROL_ENABLE_DISABLE = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, enablenpem: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct NPEM_CONTROL_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub SetNpemSupportState: PNPEM_CONTROL_ENABLE_DISABLE,
    pub QueryStandardCapabilities: PNPEM_CONTROL_QUERY_STANDARD_CAPABILITIES,
    pub SetStandardControl: PNPEM_CONTROL_SET_STANDARD_CONTROL,
    pub QueryNpemControl: PNPEM_CONTROL_QUERY_CONTROL,
}
impl Default for NPEM_CONTROL_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const NPEM_CONTROL_INTERFACE_CURRENT_VERSION: u32 = 2u32;
pub const NPEM_CONTROL_INTERFACE_VERSION1: u32 = 1u32;
pub const NPEM_CONTROL_INTERFACE_VERSION2: u32 = 2u32;
pub type NPEM_CONTROL_QUERY_CONTROL = Option<unsafe extern "system" fn(context: *const core::ffi::c_void) -> u32>;
pub type NPEM_CONTROL_QUERY_STANDARD_CAPABILITIES = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, standardcapabilities: *mut NPEM_CAPABILITY_STANDARD) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type NPEM_CONTROL_SET_STANDARD_CONTROL = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, standardcontrol: NPEM_CONTROL_STANDARD_CONTROL_BIT, set: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct NPEM_CONTROL_STANDARD_CONTROL_BIT(pub i32);
#[cfg(feature = "Win32_Security")]
pub type NTFS_DEREF_EXPORTED_SECURITY_DESCRIPTOR = Option<unsafe extern "system" fn(vcb: *const core::ffi::c_void, securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR)>;
pub const NT_PAGING_LEVELS: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct NT_TIB32 {
    pub ExceptionList: u32,
    pub StackBase: u32,
    pub StackLimit: u32,
    pub SubSystemTib: u32,
    pub Anonymous: NT_TIB32_0,
    pub ArbitraryUserPointer: u32,
    pub Self_: u32,
}
impl Default for NT_TIB32 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union NT_TIB32_0 {
    pub FiberData: u32,
    pub Version: u32,
}
impl Default for NT_TIB32_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const NX_SUPPORT_POLICY_ALWAYSOFF: u32 = 0u32;
pub const NX_SUPPORT_POLICY_ALWAYSON: u32 = 1u32;
pub const NX_SUPPORT_POLICY_OPTIN: u32 = 2u32;
pub const NX_SUPPORT_POLICY_OPTOUT: u32 = 3u32;
pub const NetworkController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(18i32);
pub const NetworkPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(36i32);
pub const NoAspmSupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(0i32);
pub const NormalPagePriority: MM_PAGE_PRIORITY = MM_PAGE_PRIORITY(16i32);
pub const NormalPoolPriority: EX_POOL_PRIORITY = EX_POOL_PRIORITY(16i32);
pub const NormalPoolPrioritySpecialPoolOverrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(24i32);
pub const NormalPoolPrioritySpecialPoolUnderrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(25i32);
pub const NormalWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(3i32);
pub const NuBus: INTERFACE_TYPE = INTERFACE_TYPE(7i32);
pub const NuBusConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(6i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct OBJECT_HANDLE_INFORMATION {
    pub HandleAttributes: u32,
    pub GrantedAccess: u32,
}
pub const OBJECT_TYPE_CREATE: u32 = 1u32;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct OB_CALLBACK_REGISTRATION {
    pub Version: u16,
    pub OperationRegistrationCount: u16,
    pub Altitude: super::super::super::Win32::Foundation::UNICODE_STRING,
    pub RegistrationContext: *mut core::ffi::c_void,
    pub OperationRegistration: *mut OB_OPERATION_REGISTRATION,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for OB_CALLBACK_REGISTRATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const OB_FLT_REGISTRATION_VERSION: u32 = 256u32;
pub const OB_FLT_REGISTRATION_VERSION_0100: u32 = 256u32;
pub const OB_OPERATION_HANDLE_CREATE: u32 = 1u32;
pub const OB_OPERATION_HANDLE_DUPLICATE: u32 = 2u32;
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct OB_OPERATION_REGISTRATION {
    pub ObjectType: *mut super::super::Foundation::POBJECT_TYPE,
    pub Operations: u32,
    pub PreOperation: POB_PRE_OPERATION_CALLBACK,
    pub PostOperation: POB_POST_OPERATION_CALLBACK,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for OB_OPERATION_REGISTRATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct OB_POST_CREATE_HANDLE_INFORMATION {
    pub GrantedAccess: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct OB_POST_DUPLICATE_HANDLE_INFORMATION {
    pub GrantedAccess: u32,
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub struct OB_POST_OPERATION_INFORMATION {
    pub Operation: u32,
    pub Anonymous: OB_POST_OPERATION_INFORMATION_0,
    pub Object: *mut core::ffi::c_void,
    pub ObjectType: super::super::Foundation::POBJECT_TYPE,
    pub CallContext: *mut core::ffi::c_void,
    pub ReturnStatus: super::super::super::Win32::Foundation::NTSTATUS,
    pub Parameters: *mut OB_POST_OPERATION_PARAMETERS,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for OB_POST_OPERATION_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub union OB_POST_OPERATION_INFORMATION_0 {
    pub Flags: u32,
    pub Anonymous: OB_POST_OPERATION_INFORMATION_0_0,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for OB_POST_OPERATION_INFORMATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct OB_POST_OPERATION_INFORMATION_0_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union OB_POST_OPERATION_PARAMETERS {
    pub CreateHandleInformation: OB_POST_CREATE_HANDLE_INFORMATION,
    pub DuplicateHandleInformation: OB_POST_DUPLICATE_HANDLE_INFORMATION,
}
impl Default for OB_POST_OPERATION_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct OB_PREOP_CALLBACK_STATUS(pub i32);
pub const OB_PREOP_SUCCESS: OB_PREOP_CALLBACK_STATUS = OB_PREOP_CALLBACK_STATUS(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct OB_PRE_CREATE_HANDLE_INFORMATION {
    pub DesiredAccess: u32,
    pub OriginalDesiredAccess: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct OB_PRE_DUPLICATE_HANDLE_INFORMATION {
    pub DesiredAccess: u32,
    pub OriginalDesiredAccess: u32,
    pub SourceProcess: *mut core::ffi::c_void,
    pub TargetProcess: *mut core::ffi::c_void,
}
impl Default for OB_PRE_DUPLICATE_HANDLE_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub struct OB_PRE_OPERATION_INFORMATION {
    pub Operation: u32,
    pub Anonymous: OB_PRE_OPERATION_INFORMATION_0,
    pub Object: *mut core::ffi::c_void,
    pub ObjectType: super::super::Foundation::POBJECT_TYPE,
    pub CallContext: *mut core::ffi::c_void,
    pub Parameters: *mut OB_PRE_OPERATION_PARAMETERS,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for OB_PRE_OPERATION_INFORMATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy)]
pub union OB_PRE_OPERATION_INFORMATION_0 {
    pub Flags: u32,
    pub Anonymous: OB_PRE_OPERATION_INFORMATION_0_0,
}
#[cfg(feature = "Wdk_Foundation")]
impl Default for OB_PRE_OPERATION_INFORMATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Wdk_Foundation")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct OB_PRE_OPERATION_INFORMATION_0_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union OB_PRE_OPERATION_PARAMETERS {
    pub CreateHandleInformation: OB_PRE_CREATE_HANDLE_INFORMATION,
    pub DuplicateHandleInformation: OB_PRE_DUPLICATE_HANDLE_INFORMATION,
}
impl Default for OB_PRE_OPERATION_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const OPLOCK_KEY_FLAG_PARENT_KEY: u32 = 1u32;
pub const OPLOCK_KEY_FLAG_TARGET_KEY: u32 = 2u32;
pub const OPLOCK_KEY_VERSION_WIN7: u32 = 1u32;
pub const OPLOCK_KEY_VERSION_WIN8: u32 = 2u32;
pub const OSC_CAPABILITIES_MASKED: u32 = 16u32;
pub const OSC_FIRMWARE_FAILURE: u32 = 2u32;
pub const OSC_UNRECOGNIZED_REVISION: u32 = 8u32;
pub const OSC_UNRECOGNIZED_UUID: u32 = 4u32;
pub const OkControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(2i32);
pub const OtherController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(24i32);
pub const OtherPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(34i32);
pub const PAGE_ENCLAVE_NO_CHANGE: u32 = 536870912u32;
pub const PAGE_ENCLAVE_THREAD_CONTROL: u32 = 2147483648u32;
pub const PAGE_ENCLAVE_UNVALIDATED: u32 = 536870912u32;
pub const PAGE_EXECUTE: u32 = 16u32;
pub const PAGE_EXECUTE_READ: u32 = 32u32;
pub const PAGE_EXECUTE_READWRITE: u32 = 64u32;
pub const PAGE_EXECUTE_WRITECOPY: u32 = 128u32;
pub const PAGE_GRAPHICS_COHERENT: u32 = 131072u32;
pub const PAGE_GRAPHICS_EXECUTE: u32 = 16384u32;
pub const PAGE_GRAPHICS_EXECUTE_READ: u32 = 32768u32;
pub const PAGE_GRAPHICS_EXECUTE_READWRITE: u32 = 65536u32;
pub const PAGE_GRAPHICS_NOACCESS: u32 = 2048u32;
pub const PAGE_GRAPHICS_NOCACHE: u32 = 262144u32;
pub const PAGE_GRAPHICS_READONLY: u32 = 4096u32;
pub const PAGE_GRAPHICS_READWRITE: u32 = 8192u32;
pub const PAGE_GUARD: u32 = 256u32;
pub const PAGE_NOACCESS: u32 = 1u32;
pub const PAGE_NOCACHE: u32 = 512u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PAGE_PRIORITY_INFORMATION {
    pub PagePriority: u32,
}
pub const PAGE_READONLY: u32 = 2u32;
pub const PAGE_READWRITE: u32 = 4u32;
pub const PAGE_REVERT_TO_FILE_MAP: u32 = 2147483648u32;
pub const PAGE_SHIFT: i32 = 12i32;
pub const PAGE_SIZE: u32 = 4096u32;
pub const PAGE_TARGETS_INVALID: u32 = 1073741824u32;
pub const PAGE_TARGETS_NO_UPDATE: u32 = 1073741824u32;
pub const PAGE_WRITECOMBINE: u32 = 1024u32;
pub const PAGE_WRITECOPY: u32 = 8u32;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PALLOCATE_ADAPTER_CHANNEL = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, numberofmapregisters: u32, executionroutine: super::super::Foundation::DRIVER_CONTROL, context: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PALLOCATE_ADAPTER_CHANNEL_EX = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, dmatransfercontext: *const core::ffi::c_void, numberofmapregisters: u32, flags: u32, executionroutine: super::super::Foundation::DRIVER_CONTROL, executioncontext: *const core::ffi::c_void, mapregisterbase: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PALLOCATE_COMMON_BUFFER = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, length: u32, logicaladdress: *mut i64, cacheenabled: bool) -> *mut core::ffi::c_void>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PALLOCATE_COMMON_BUFFER_EX = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, maximumaddress: *const i64, length: u32, logicaladdress: *mut i64, cacheenabled: bool, preferrednode: u32) -> *mut core::ffi::c_void>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PALLOCATE_COMMON_BUFFER_VECTOR = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, lowaddress: i64, highaddress: i64, cachetype: MEMORY_CACHING_TYPE, idealnode: u32, flags: u32, numberofelements: u32, sizeofelements: u64, vectorout: *mut *mut super::super::Foundation::DMA_COMMON_BUFFER_VECTOR) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PALLOCATE_COMMON_BUFFER_WITH_BOUNDS = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, minimumaddress: *const i64, maximumaddress: *const i64, length: u32, flags: u32, cachetype: *const MEMORY_CACHING_TYPE, preferrednode: u32, logicaladdress: *mut i64) -> *mut core::ffi::c_void>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PALLOCATE_DOMAIN_COMMON_BUFFER = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, domainhandle: super::super::super::Win32::Foundation::HANDLE, maximumaddress: *const i64, length: u32, flags: u32, cachetype: *const MEMORY_CACHING_TYPE, preferrednode: u32, logicaladdress: *mut i64, virtualaddress: *mut *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type PALLOCATE_FUNCTION = Option<unsafe extern "system" fn() -> *mut core::ffi::c_void>;
pub type PALLOCATE_FUNCTION_EX = Option<unsafe extern "system" fn() -> *mut core::ffi::c_void>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PARBITER_HANDLER = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, action: ARBITER_ACTION, parameters: *mut ARBITER_PARAMETERS) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub const PARKING_TOPOLOGY_POLICY_DISABLED: u32 = 0u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PARTITION_INFORMATION_CLASS(pub i32);
pub const PASSIVE_LEVEL: u32 = 0u32;
pub type PBOOT_DRIVER_CALLBACK_FUNCTION = Option<unsafe extern "system" fn()>;
pub type PBOUND_CALLBACK = Option<unsafe extern "system" fn() -> BOUND_CALLBACK_STATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PBUILD_MDL_FROM_SCATTER_GATHER_LIST = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, scattergather: *const SCATTER_GATHER_LIST, originalmdl: *const super::super::Foundation::MDL, targetmdl: *mut *mut super::super::Foundation::MDL) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PBUILD_SCATTER_GATHER_LIST = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, mdl: *const super::super::Foundation::MDL, currentva: *const core::ffi::c_void, length: u32, executionroutine: DRIVER_LIST_CONTROL, context: *const core::ffi::c_void, writetodevice: bool, scattergatherbuffer: *const core::ffi::c_void, scattergatherlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PBUILD_SCATTER_GATHER_LIST_EX = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, dmatransfercontext: *const core::ffi::c_void, mdl: *const super::super::Foundation::MDL, offset: u64, length: u32, flags: u32, executionroutine: DRIVER_LIST_CONTROL, context: *const core::ffi::c_void, writetodevice: bool, scattergatherbuffer: *const core::ffi::c_void, scattergatherlength: u32, dmacompletionroutine: PDMA_COMPLETION_ROUTINE, completioncontext: *const core::ffi::c_void, scattergatherlist: *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PCALCULATE_SCATTER_GATHER_LIST_SIZE = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, mdl: *const super::super::Foundation::MDL, currentva: *const core::ffi::c_void, length: u32, scattergatherlistsize: *mut u32, pnumberofmapregisters: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type PCALLBACK_FUNCTION = Option<unsafe extern "system" fn()>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PCANCEL_ADAPTER_CHANNEL = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, dmatransfercontext: *const core::ffi::c_void) -> bool>;
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub type PCANCEL_MAPPED_TRANSFER = Option<unsafe extern "system" fn(dmaadapter: *const DMA_ADAPTER, dmatransfercontext: *const core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub const PCCARD_DEVICE_PCI: u32 = 16u32;
pub const PCCARD_DUP_LEGACY_BASE: u32 = 6u32;
pub const PCCARD_MAP_ERROR: u32 = 1u32;
pub const PCCARD_MAP_ZERO: u32 = 2u32;
pub const PCCARD_NO_CONTROLLERS: u32 = 7u32;
pub const PCCARD_NO_LEGACY_BASE: u32 = 5u32;
pub const PCCARD_NO_PIC: u32 = 4u32;
pub const PCCARD_NO_TIMER: u32 = 3u32;
pub const PCCARD_SCAN_DISABLED: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCIBUSDATA {
    pub Tag: u32,
    pub Version: u32,
    pub ReadConfig: PciReadWriteConfig,
    pub WriteConfig: PciReadWriteConfig,
    pub Pin2Line: PciPin2Line,
    pub Line2Pin: PciLine2Pin,
    pub ParentSlot: PCI_SLOT_NUMBER,
    pub Reserved: [*mut core::ffi::c_void; 4],
}
impl Default for PCIBUSDATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCIBus: INTERFACE_TYPE = INTERFACE_TYPE(5i32);
pub const PCIConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(4i32);
pub const PCIEXPRESS_ERROR_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xd995e954_bbc1_430f_ad91_b44dcb3c6f35);
pub const PCIE_CORRECTABLE_ERROR_SUMMARY_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xe96eca99_53e2_4f52_9be7_d2dbe9508ed0);
pub const PCIXBUS_ERROR_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xc5753963_3b84_4095_bf78_eddad3f9c9dd);
pub const PCIXBUS_ERRTYPE_ADDRESSPARITY: u32 = 6u32;
pub const PCIXBUS_ERRTYPE_BUSTIMEOUT: u32 = 4u32;
pub const PCIXBUS_ERRTYPE_COMMANDPARITY: u32 = 7u32;
pub const PCIXBUS_ERRTYPE_DATAPARITY: u32 = 1u32;
pub const PCIXBUS_ERRTYPE_MASTERABORT: u32 = 3u32;
pub const PCIXBUS_ERRTYPE_MASTERDATAPARITY: u32 = 5u32;
pub const PCIXBUS_ERRTYPE_SYSTEM: u32 = 2u32;
pub const PCIXBUS_ERRTYPE_UNKNOWN: u32 = 0u32;
pub const PCIXDEVICE_ERROR_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xeb5e4685_ca66_4769_b6a2_26068b001326);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCIX_BRIDGE_CAPABILITY {
    pub Header: PCI_CAPABILITIES_HEADER,
    pub SecondaryStatus: PCIX_BRIDGE_CAPABILITY_0,
    pub BridgeStatus: PCIX_BRIDGE_CAPABILITY_1,
    pub UpstreamSplitTransactionCapacity: u16,
    pub UpstreamSplitTransactionLimit: u16,
    pub DownstreamSplitTransactionCapacity: u16,
    pub DownstreamSplitTransactionLimit: u16,
    pub EccControlStatus: PCIX_BRIDGE_CAPABILITY_2,
    pub EccFirstAddress: u32,
    pub EccSecondAddress: u32,
    pub EccAttribute: u32,
}
impl Default for PCIX_BRIDGE_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCIX_BRIDGE_CAPABILITY_1 {
    pub Anonymous: PCIX_BRIDGE_CAPABILITY_1_0,
    pub AsULONG: u32,
}
impl Default for PCIX_BRIDGE_CAPABILITY_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCIX_BRIDGE_CAPABILITY_1_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCIX_BRIDGE_CAPABILITY_2 {
    pub Anonymous: PCIX_BRIDGE_CAPABILITY_2_0,
    pub AsULONG: u32,
}
impl Default for PCIX_BRIDGE_CAPABILITY_2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCIX_BRIDGE_CAPABILITY_2_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCIX_BRIDGE_CAPABILITY_0 {
    pub Anonymous: PCIX_BRIDGE_CAPABILITY_0_0,
    pub AsUSHORT: u16,
}
impl Default for PCIX_BRIDGE_CAPABILITY_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCIX_BRIDGE_CAPABILITY_0_0 {
    pub _bitfield: u16,
}
pub const PCIX_MODE1_100MHZ: u32 = 2u32;
pub const PCIX_MODE1_133MHZ: u32 = 3u32;
pub const PCIX_MODE1_66MHZ: u32 = 1u32;
pub const PCIX_MODE2_266_100MHZ: u32 = 10u32;
pub const PCIX_MODE2_266_133MHZ: u32 = 11u32;
pub const PCIX_MODE2_266_66MHZ: u32 = 9u32;
pub const PCIX_MODE2_533_100MHZ: u32 = 14u32;
pub const PCIX_MODE2_533_133MHZ: u32 = 15u32;
pub const PCIX_MODE2_533_66MHZ: u32 = 13u32;
pub const PCIX_MODE_CONVENTIONAL_PCI: u32 = 0u32;
pub const PCIX_VERSION_DUAL_MODE_ECC: u32 = 2u32;
pub const PCIX_VERSION_MODE1_ONLY: u32 = 0u32;
pub const PCIX_VERSION_MODE2_ECC: u32 = 1u32;
pub const PCI_ACS_ALLOWED: u32 = 0u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_ACS_BIT(pub i32);
pub const PCI_ACS_BLOCKED: u32 = 1u32;
pub const PCI_ACS_REDIRECTED: u32 = 2u32;
pub const PCI_ADDRESS_IO_ADDRESS_MASK: u32 = 4294967292u32;
pub const PCI_ADDRESS_IO_SPACE: u32 = 1u32;
pub const PCI_ADDRESS_MEMORY_ADDRESS_MASK: u32 = 4294967280u32;
pub const PCI_ADDRESS_MEMORY_PREFETCHABLE: u32 = 8u32;
pub const PCI_ADDRESS_MEMORY_TYPE_MASK: u32 = 6u32;
pub const PCI_ADDRESS_ROM_ADDRESS_MASK: u32 = 4294965248u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_ADVANCED_FEATURES_CAPABILITY {
    pub Header: PCI_CAPABILITIES_HEADER,
    pub Length: u8,
    pub Capabilities: PCI_ADVANCED_FEATURES_CAPABILITY_0,
    pub Control: PCI_ADVANCED_FEATURES_CAPABILITY_1,
    pub Status: PCI_ADVANCED_FEATURES_CAPABILITY_2,
}
impl Default for PCI_ADVANCED_FEATURES_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_ADVANCED_FEATURES_CAPABILITY_0 {
    pub Anonymous: PCI_ADVANCED_FEATURES_CAPABILITY_0_0,
    pub AsUCHAR: u8,
}
impl Default for PCI_ADVANCED_FEATURES_CAPABILITY_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_ADVANCED_FEATURES_CAPABILITY_0_0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_ADVANCED_FEATURES_CAPABILITY_1 {
    pub Anonymous: PCI_ADVANCED_FEATURES_CAPABILITY_1_0,
    pub AsUCHAR: u8,
}
impl Default for PCI_ADVANCED_FEATURES_CAPABILITY_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_ADVANCED_FEATURES_CAPABILITY_1_0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_ADVANCED_FEATURES_CAPABILITY_2 {
    pub Anonymous: PCI_ADVANCED_FEATURES_CAPABILITY_2_0,
    pub AsUCHAR: u8,
}
impl Default for PCI_ADVANCED_FEATURES_CAPABILITY_2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_ADVANCED_FEATURES_CAPABILITY_2_0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_APERTURE_PAGE_SIZE {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_CAPABILITY {
    pub Header: PCI_CAPABILITIES_HEADER,
    pub _bitfield: u16,
    pub AGPStatus: PCI_AGP_CAPABILITY_0,
    pub AGPCommand: PCI_AGP_CAPABILITY_1,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_CAPABILITY_1 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_CAPABILITY_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_CONTROL {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_EXTENDED_CAPABILITY {
    pub IsochStatus: PCI_AGP_ISOCH_STATUS,
    pub AgpControl: PCI_AGP_CONTROL,
    pub ApertureSize: u16,
    pub AperturePageSize: PCI_AGP_APERTURE_PAGE_SIZE,
    pub GartLow: u32,
    pub GartHigh: u32,
    pub IsochCommand: PCI_AGP_ISOCH_COMMAND,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_ISOCH_COMMAND {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_AGP_ISOCH_STATUS {
    pub _bitfield: u32,
}
pub const PCI_AGP_RATE_1X: u32 = 1u32;
pub const PCI_AGP_RATE_2X: u32 = 2u32;
pub const PCI_AGP_RATE_4X: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_ATS_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub SetAddressTranslationServices: PPCI_SET_ATS,
    pub InvalidateQueueDepth: u8,
}
impl Default for PCI_ATS_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_ATS_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_BRIDGE_TYPE: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_BUS_INTERFACE_STANDARD {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub ReadConfig: PPCI_READ_WRITE_CONFIG,
    pub WriteConfig: PPCI_READ_WRITE_CONFIG,
    pub PinToLine: PPCI_PIN_TO_LINE,
    pub LineToPin: PPCI_LINE_TO_PIN,
    pub RootBusCapability: PPCI_ROOT_BUS_CAPABILITY,
    pub ExpressWakeControl: PPCI_EXPRESS_WAKE_CONTROL,
    pub PrepareMultistageResume: PPCI_PREPARE_MULTISTAGE_RESUME,
}
impl Default for PCI_BUS_INTERFACE_STANDARD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_BUS_INTERFACE_STANDARD_VERSION: u32 = 2u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_BUS_WIDTH(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_CAPABILITIES_HEADER {
    pub CapabilityID: u8,
    pub Next: u8,
}
pub const PCI_CAPABILITY_ID_ADVANCED_FEATURES: u32 = 19u32;
pub const PCI_CAPABILITY_ID_AGP: u32 = 2u32;
pub const PCI_CAPABILITY_ID_AGP_TARGET: u32 = 14u32;
pub const PCI_CAPABILITY_ID_CPCI_HOTSWAP: u32 = 6u32;
pub const PCI_CAPABILITY_ID_CPCI_RES_CTRL: u32 = 11u32;
pub const PCI_CAPABILITY_ID_DEBUG_PORT: u32 = 10u32;
pub const PCI_CAPABILITY_ID_FPB: u32 = 21u32;
pub const PCI_CAPABILITY_ID_HYPERTRANSPORT: u32 = 8u32;
pub const PCI_CAPABILITY_ID_MSI: u32 = 5u32;
pub const PCI_CAPABILITY_ID_MSIX: u32 = 17u32;
pub const PCI_CAPABILITY_ID_P2P_SSID: u32 = 13u32;
pub const PCI_CAPABILITY_ID_PCIX: u32 = 7u32;
pub const PCI_CAPABILITY_ID_PCI_EXPRESS: u32 = 16u32;
pub const PCI_CAPABILITY_ID_POWER_MANAGEMENT: u32 = 1u32;
pub const PCI_CAPABILITY_ID_SATA_CONFIG: u32 = 18u32;
pub const PCI_CAPABILITY_ID_SECURE: u32 = 15u32;
pub const PCI_CAPABILITY_ID_SHPC: u32 = 12u32;
pub const PCI_CAPABILITY_ID_SLOT_ID: u32 = 4u32;
pub const PCI_CAPABILITY_ID_VENDOR_SPECIFIC: u32 = 9u32;
pub const PCI_CAPABILITY_ID_VPD: u32 = 3u32;
pub const PCI_CARDBUS_BRIDGE_TYPE: u32 = 2u32;
pub const PCI_CLASS_BASE_SYSTEM_DEV: u32 = 8u32;
pub const PCI_CLASS_BRIDGE_DEV: u32 = 6u32;
pub const PCI_CLASS_DATA_ACQ_SIGNAL_PROC: u32 = 17u32;
pub const PCI_CLASS_DISPLAY_CTLR: u32 = 3u32;
pub const PCI_CLASS_DOCKING_STATION: u32 = 10u32;
pub const PCI_CLASS_ENCRYPTION_DECRYPTION: u32 = 16u32;
pub const PCI_CLASS_INPUT_DEV: u32 = 9u32;
pub const PCI_CLASS_INTELLIGENT_IO_CTLR: u32 = 14u32;
pub const PCI_CLASS_MASS_STORAGE_CTLR: u32 = 1u32;
pub const PCI_CLASS_MEMORY_CTLR: u32 = 5u32;
pub const PCI_CLASS_MULTIMEDIA_DEV: u32 = 4u32;
pub const PCI_CLASS_NETWORK_CTLR: u32 = 2u32;
pub const PCI_CLASS_NOT_DEFINED: u32 = 255u32;
pub const PCI_CLASS_PRE_20: u32 = 0u32;
pub const PCI_CLASS_PROCESSOR: u32 = 11u32;
pub const PCI_CLASS_SATELLITE_COMMS_CTLR: u32 = 15u32;
pub const PCI_CLASS_SERIAL_BUS_CTLR: u32 = 12u32;
pub const PCI_CLASS_SIMPLE_COMMS_CTLR: u32 = 7u32;
pub const PCI_CLASS_WIRELESS_CTLR: u32 = 13u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_COMMON_CONFIG {
    pub Base: PCI_COMMON_HEADER,
    pub DeviceSpecific: [u8; 192],
}
impl Default for PCI_COMMON_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_COMMON_HEADER {
    pub VendorID: u16,
    pub DeviceID: u16,
    pub Command: u16,
    pub Status: u16,
    pub RevisionID: u8,
    pub ProgIf: u8,
    pub SubClass: u8,
    pub BaseClass: u8,
    pub CacheLineSize: u8,
    pub LatencyTimer: u8,
    pub HeaderType: u8,
    pub BIST: u8,
    pub u: PCI_COMMON_HEADER_0,
}
impl Default for PCI_COMMON_HEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_COMMON_HEADER_0 {
    pub type0: PCI_COMMON_HEADER_0_0,
    pub type1: PCI_COMMON_HEADER_0_1,
    pub type2: PCI_COMMON_HEADER_0_2,
}
impl Default for PCI_COMMON_HEADER_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_COMMON_HEADER_0_0 {
    pub BaseAddresses: [u32; 6],
    pub CIS: u32,
    pub SubVendorID: u16,
    pub SubSystemID: u16,
    pub ROMBaseAddress: u32,
    pub CapabilitiesPtr: u8,
    pub Reserved1: [u8; 3],
    pub Reserved2: u32,
    pub InterruptLine: u8,
    pub InterruptPin: u8,
    pub MinimumGrant: u8,
    pub MaximumLatency: u8,
}
impl Default for PCI_COMMON_HEADER_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_COMMON_HEADER_0_1 {
    pub BaseAddresses: [u32; 2],
    pub PrimaryBus: u8,
    pub SecondaryBus: u8,
    pub SubordinateBus: u8,
    pub SecondaryLatency: u8,
    pub IOBase: u8,
    pub IOLimit: u8,
    pub SecondaryStatus: u16,
    pub MemoryBase: u16,
    pub MemoryLimit: u16,
    pub PrefetchBase: u16,
    pub PrefetchLimit: u16,
    pub PrefetchBaseUpper32: u32,
    pub PrefetchLimitUpper32: u32,
    pub IOBaseUpper16: u16,
    pub IOLimitUpper16: u16,
    pub CapabilitiesPtr: u8,
    pub Reserved1: [u8; 3],
    pub ROMBaseAddress: u32,
    pub InterruptLine: u8,
    pub InterruptPin: u8,
    pub BridgeControl: u16,
}
impl Default for PCI_COMMON_HEADER_0_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_COMMON_HEADER_0_2 {
    pub SocketRegistersBaseAddress: u32,
    pub CapabilitiesPtr: u8,
    pub Reserved: u8,
    pub SecondaryStatus: u16,
    pub PrimaryBus: u8,
    pub SecondaryBus: u8,
    pub SubordinateBus: u8,
    pub SecondaryLatency: u8,
    pub Range: [PCI_COMMON_HEADER_0_2_0; 4],
    pub InterruptLine: u8,
    pub InterruptPin: u8,
    pub BridgeControl: u16,
}
impl Default for PCI_COMMON_HEADER_0_2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_COMMON_HEADER_0_2_0 {
    pub Base: u32,
    pub Limit: u32,
}
pub const PCI_DATA_VERSION: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_DEBUGGING_DEVICE_IN_USE {
    pub Segment: u16,
    pub Bus: u32,
    pub Slot: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_DEVICE_D3COLD_STATE_REASON(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_DEVICE_PRESENCE_PARAMETERS {
    pub Size: u32,
    pub Flags: u32,
    pub VendorID: u16,
    pub DeviceID: u16,
    pub RevisionID: u8,
    pub SubVendorID: u16,
    pub SubSystemID: u16,
    pub BaseClass: u8,
    pub SubClass: u8,
    pub ProgIf: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_DEVICE_PRESENT_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub IsDevicePresent: PPCI_IS_DEVICE_PRESENT,
    pub IsDevicePresentEx: PPCI_IS_DEVICE_PRESENT_EX,
}
impl Default for PCI_DEVICE_PRESENT_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_DEVICE_PRESENT_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_DEVICE_TYPE: u32 = 0u32;
pub const PCI_DISABLE_LEVEL_INTERRUPT: u32 = 1024u32;
pub const PCI_ENABLE_BUS_MASTER: u32 = 4u32;
pub const PCI_ENABLE_FAST_BACK_TO_BACK: u32 = 512u32;
pub const PCI_ENABLE_IO_SPACE: u32 = 1u32;
pub const PCI_ENABLE_MEMORY_SPACE: u32 = 2u32;
pub const PCI_ENABLE_PARITY: u32 = 64u32;
pub const PCI_ENABLE_SERR: u32 = 256u32;
pub const PCI_ENABLE_SPECIAL_CYCLES: u32 = 8u32;
pub const PCI_ENABLE_VGA_COMPATIBLE_PALETTE: u32 = 32u32;
pub const PCI_ENABLE_WAIT_CYCLE: u32 = 128u32;
pub const PCI_ENABLE_WRITE_AND_INVALIDATE: u32 = 16u32;
pub type PCI_ERROR_HANDLER_CALLBACK = Option<unsafe extern "system" fn()>;
pub const PCI_EXPRESS_ACCESS_CONTROL_SERVICES_CAP_ID: u32 = 13u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_ACS_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Capability: PCI_EXPRESS_ACS_CAPABILITY_REGISTER,
    pub Control: PCI_EXPRESS_ACS_CONTROL,
    pub EgressControl: [u32; 1],
}
impl Default for PCI_EXPRESS_ACS_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ACS_CAPABILITY_REGISTER {
    pub Anonymous: PCI_EXPRESS_ACS_CAPABILITY_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_ACS_CAPABILITY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ACS_CAPABILITY_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ACS_CONTROL {
    pub Anonymous: PCI_EXPRESS_ACS_CONTROL_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_ACS_CONTROL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ACS_CONTROL_0 {
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_ADVANCED_ERROR_REPORTING_CAP_ID: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_AER_CAPABILITIES {
    pub Anonymous: PCI_EXPRESS_AER_CAPABILITIES_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_AER_CAPABILITIES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_AER_CAPABILITIES_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_AER_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub UncorrectableErrorStatus: PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS,
    pub UncorrectableErrorMask: PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK,
    pub UncorrectableErrorSeverity: PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY,
    pub CorrectableErrorStatus: PCI_EXPRESS_CORRECTABLE_ERROR_STATUS,
    pub CorrectableErrorMask: PCI_EXPRESS_CORRECTABLE_ERROR_MASK,
    pub CapabilitiesAndControl: PCI_EXPRESS_AER_CAPABILITIES,
    pub HeaderLog: [u32; 4],
    pub SecUncorrectableErrorStatus: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS,
    pub SecUncorrectableErrorMask: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK,
    pub SecUncorrectableErrorSeverity: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY,
    pub SecCapabilitiesAndControl: PCI_EXPRESS_SEC_AER_CAPABILITIES,
    pub SecHeaderLog: [u32; 4],
}
impl Default for PCI_EXPRESS_AER_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ARI_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Capability: PCI_EXPRESS_ARI_CAPABILITY_REGISTER,
    pub Control: PCI_EXPRESS_ARI_CONTROL_REGISTER,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ARI_CAPABILITY_REGISTER {
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_ARI_CAP_ID: u32 = 14u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ARI_CONTROL_REGISTER {
    pub _bitfield: u16,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_ASPM_CONTROL(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_ASPM_SUPPORT(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_ATS_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Capability: PCI_EXPRESS_ATS_CAPABILITY_REGISTER,
    pub Control: PCI_EXPRESS_ATS_CONTROL_REGISTER,
}
impl Default for PCI_EXPRESS_ATS_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ATS_CAPABILITY_REGISTER {
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_ATS_CAP_ID: u32 = 15u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ATS_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_ATS_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_ATS_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ATS_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_BRIDGE_AER_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub UncorrectableErrorStatus: PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS,
    pub UncorrectableErrorMask: PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK,
    pub UncorrectableErrorSeverity: PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY,
    pub CorrectableErrorStatus: PCI_EXPRESS_CORRECTABLE_ERROR_STATUS,
    pub CorrectableErrorMask: PCI_EXPRESS_CORRECTABLE_ERROR_MASK,
    pub CapabilitiesAndControl: PCI_EXPRESS_AER_CAPABILITIES,
    pub HeaderLog: [u32; 4],
    pub SecUncorrectableErrorStatus: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS,
    pub SecUncorrectableErrorMask: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK,
    pub SecUncorrectableErrorSeverity: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY,
    pub SecCapabilitiesAndControl: PCI_EXPRESS_SEC_AER_CAPABILITIES,
    pub SecHeaderLog: [u32; 4],
}
impl Default for PCI_EXPRESS_BRIDGE_AER_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CAPABILITIES_REGISTER {
    pub Anonymous: PCI_EXPRESS_CAPABILITIES_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_CAPABILITIES_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CAPABILITIES_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_CAPABILITY {
    pub Header: PCI_CAPABILITIES_HEADER,
    pub ExpressCapabilities: PCI_EXPRESS_CAPABILITIES_REGISTER,
    pub DeviceCapabilities: PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER,
    pub DeviceControl: PCI_EXPRESS_DEVICE_CONTROL_REGISTER,
    pub DeviceStatus: PCI_EXPRESS_DEVICE_STATUS_REGISTER,
    pub LinkCapabilities: PCI_EXPRESS_LINK_CAPABILITIES_REGISTER,
    pub LinkControl: PCI_EXPRESS_LINK_CONTROL_REGISTER,
    pub LinkStatus: PCI_EXPRESS_LINK_STATUS_REGISTER,
    pub SlotCapabilities: PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER,
    pub SlotControl: PCI_EXPRESS_SLOT_CONTROL_REGISTER,
    pub SlotStatus: PCI_EXPRESS_SLOT_STATUS_REGISTER,
    pub RootControl: PCI_EXPRESS_ROOT_CONTROL_REGISTER,
    pub RootCapabilities: PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER,
    pub RootStatus: PCI_EXPRESS_ROOT_STATUS_REGISTER,
    pub DeviceCapabilities2: PCI_EXPRESS_DEVICE_CAPABILITIES_2_REGISTER,
    pub DeviceControl2: PCI_EXPRESS_DEVICE_CONTROL_2_REGISTER,
    pub DeviceStatus2: PCI_EXPRESS_DEVICE_STATUS_2_REGISTER,
    pub LinkCapabilities2: PCI_EXPRESS_LINK_CAPABILITIES_2_REGISTER,
    pub LinkControl2: PCI_EXPRESS_LINK_CONTROL_2_REGISTER,
    pub LinkStatus2: PCI_EXPRESS_LINK_STATUS_2_REGISTER,
}
impl Default for PCI_EXPRESS_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_CARD_PRESENCE(pub i32);
pub const PCI_EXPRESS_CONFIGURATION_ACCESS_CORRELATION_CAP_ID: u32 = 12u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CORRECTABLE_ERROR_MASK {
    pub Anonymous: PCI_EXPRESS_CORRECTABLE_ERROR_MASK_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_CORRECTABLE_ERROR_MASK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CORRECTABLE_ERROR_MASK_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CORRECTABLE_ERROR_STATUS {
    pub Anonymous: PCI_EXPRESS_CORRECTABLE_ERROR_STATUS_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_CORRECTABLE_ERROR_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CORRECTABLE_ERROR_STATUS_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_CXL_DVSEC_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub DvsecHeader1: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_1,
    pub DvsecHeader2: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_2,
    pub Reserved: [u8; 46],
}
impl Default for PCI_EXPRESS_CXL_DVSEC_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CXL_DVSEC_CAPABILITY_REGISTER_V11 {
    pub Anonymous: PCI_EXPRESS_CXL_DVSEC_CAPABILITY_REGISTER_V11_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_CXL_DVSEC_CAPABILITY_REGISTER_V11 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_CAPABILITY_REGISTER_V11_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_CXL_DVSEC_CAPABILITY_V11 {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub DvsecHeader1: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_1,
    pub DvsecHeader2: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_2,
    pub Capability: PCI_EXPRESS_CXL_DVSEC_CAPABILITY_REGISTER_V11,
    pub Control: PCI_EXPRESS_CXL_DVSEC_CONTROL_REGISTER,
    pub Status: PCI_EXPRESS_CXL_DVSEC_STATUS_REGISTER,
    pub Control2: u16,
    pub Status2: u16,
    pub Lock: PCI_EXPRESS_CXL_DVSEC_LOCK_REGISTER,
    pub Reserved: u16,
    pub Range1SizeHigh: PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_HIGH_REGISTER,
    pub Range1SizeLow: PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_LOW_REGISTER_V11,
    pub Range1BaseHigh: PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_HIGH_REGISTER,
    pub Range1BaseLow: PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_LOW_REGISTER,
    pub Range2SizeHigh: PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_HIGH_REGISTER,
    pub Range2SizeLow: PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_LOW_REGISTER_V11,
    pub Range2BaseHigh: PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_HIGH_REGISTER,
    pub Range2BaseLow: PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_LOW_REGISTER,
}
impl Default for PCI_EXPRESS_CXL_DVSEC_CAPABILITY_V11 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CXL_DVSEC_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_CXL_DVSEC_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_CXL_DVSEC_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CXL_DVSEC_LOCK_REGISTER {
    pub Anonymous: PCI_EXPRESS_CXL_DVSEC_LOCK_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_CXL_DVSEC_LOCK_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_LOCK_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_HIGH_REGISTER {
    pub MemBaseHigh: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_LOW_REGISTER {
    pub Anonymous: PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_LOW_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_LOW_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_RANGE_BASE_LOW_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_HIGH_REGISTER {
    pub MemSizeHigh: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_LOW_REGISTER_V11 {
    pub Anonymous: PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_LOW_REGISTER_V11_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_LOW_REGISTER_V11 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_RANGE_SIZE_LOW_REGISTER_V11_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_CXL_DVSEC_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_CXL_DVSEC_STATUS_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_CXL_DVSEC_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_CXL_DVSEC_STATUS_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub DvsecHeader1: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_1,
    pub DvsecHeader2: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_2,
    pub DvsecRegisters: [u16; 1],
}
impl Default for PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_CAP_ID: u32 = 35u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_1 {
    pub Anonymous: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_1_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_1_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_2 {
    pub Anonymous: PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_2_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_HEADER_2_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DEVICE_CAPABILITIES_2_REGISTER {
    pub Anonymous: PCI_EXPRESS_DEVICE_CAPABILITIES_2_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DEVICE_CAPABILITIES_2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_CAPABILITIES_2_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER {
    pub Anonymous: PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_CAPABILITIES_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DEVICE_CONTROL_2_REGISTER {
    pub Anonymous: PCI_EXPRESS_DEVICE_CONTROL_2_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DEVICE_CONTROL_2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_CONTROL_2_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DEVICE_CONTROL_REGISTER {
    pub Anonymous1: PCI_EXPRESS_DEVICE_CONTROL_REGISTER_0,
    pub Anonymous2: PCI_EXPRESS_DEVICE_CONTROL_REGISTER_1,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DEVICE_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_CONTROL_REGISTER_1 {
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_DEVICE_SERIAL_NUMBER_CAP_ID: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DEVICE_STATUS_2_REGISTER {
    pub Anonymous: PCI_EXPRESS_DEVICE_STATUS_2_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DEVICE_STATUS_2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_STATUS_2_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DEVICE_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_DEVICE_STATUS_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DEVICE_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_STATUS_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_DEVICE_TYPE(pub i32);
pub const PCI_EXPRESS_DPA_CAP_ID: u32 = 22u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_DPC_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub DpcCapabilities: PCI_EXPRESS_DPC_CAPS_REGISTER,
    pub DpcControl: PCI_EXPRESS_DPC_CONTROL_REGISTER,
    pub DpcStatus: PCI_EXPRESS_DPC_STATUS_REGISTER,
    pub DpcErrSrcId: PCI_EXPRESS_DPC_ERROR_SOURCE_ID,
    pub RpPioStatus: PCI_EXPRESS_DPC_RP_PIO_STATUS_REGISTER,
    pub RpPioMask: PCI_EXPRESS_DPC_RP_PIO_MASK_REGISTER,
    pub RpPioSeverity: PCI_EXPRESS_DPC_RP_PIO_SEVERITY_REGISTER,
    pub RpPioSysError: PCI_EXPRESS_DPC_RP_PIO_SYSERR_REGISTER,
    pub RpPioException: PCI_EXPRESS_DPC_RP_PIO_EXCEPTION_REGISTER,
    pub RpPioHeaderLog: PCI_EXPRESS_DPC_RP_PIO_HEADERLOG_REGISTER,
    pub RpPioImpSpecLog: PCI_EXPRESS_DPC_RP_PIO_IMPSPECLOG_REGISTER,
    pub RpPioPrefixLog: PCI_EXPRESS_DPC_RP_PIO_TLPPREFIXLOG_REGISTER,
}
impl Default for PCI_EXPRESS_DPC_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_CAPS_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_CAPS_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DPC_CAPS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_CAPS_REGISTER_0 {
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_DPC_CAP_ID: u32 = 29u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DPC_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_ERROR_SOURCE_ID {
    pub Anonymous: PCI_EXPRESS_DPC_ERROR_SOURCE_ID_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DPC_ERROR_SOURCE_ID {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_ERROR_SOURCE_ID_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_RP_PIO_EXCEPTION_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_RP_PIO_EXCEPTION_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_EXCEPTION_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_RP_PIO_EXCEPTION_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_EXPRESS_DPC_RP_PIO_HEADERLOG_REGISTER {
    pub PioHeaderLogRegister: [u32; 4],
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_HEADERLOG_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_RP_PIO_IMPSPECLOG_REGISTER {
    pub PioImpSpecLog: u32,
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_IMPSPECLOG_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_RP_PIO_MASK_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_RP_PIO_MASK_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_MASK_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_RP_PIO_MASK_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_RP_PIO_SEVERITY_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_RP_PIO_SEVERITY_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_SEVERITY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_RP_PIO_SEVERITY_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_RP_PIO_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_RP_PIO_STATUS_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_RP_PIO_STATUS_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_RP_PIO_SYSERR_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_RP_PIO_SYSERR_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_SYSERR_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_RP_PIO_SYSERR_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_EXPRESS_DPC_RP_PIO_TLPPREFIXLOG_REGISTER {
    pub PioTlpPrefixLogRegister: [u32; 4],
}
impl Default for PCI_EXPRESS_DPC_RP_PIO_TLPPREFIXLOG_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_DPC_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_DPC_STATUS_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_DPC_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_DPC_STATUS_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER {
    pub CapabilityID: u16,
    pub _bitfield: u16,
}
pub type PCI_EXPRESS_ENTER_LINK_QUIESCENT_MODE = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ERROR_SOURCE_ID {
    pub Anonymous: PCI_EXPRESS_ERROR_SOURCE_ID_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_ERROR_SOURCE_ID {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ERROR_SOURCE_ID_0 {
    pub _bitfield1: u16,
    pub _bitfield2: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_EVENT_COLLECTOR_ENDPOINT_ASSOCIATION_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub AssociationBitmap: u32,
}
pub type PCI_EXPRESS_EXIT_LINK_QUIESCENT_MODE = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub const PCI_EXPRESS_FRS_QUEUEING_CAP_ID: u32 = 33u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_INDICATOR_STATE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_L0s_EXIT_LATENCY(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_L1_EXIT_LATENCY(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_L1_PM_SS_CAPABILITIES_REGISTER {
    pub Anonymous: PCI_EXPRESS_L1_PM_SS_CAPABILITIES_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_L1_PM_SS_CAPABILITIES_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_L1_PM_SS_CAPABILITIES_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_L1_PM_SS_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub L1PmSsCapabilities: PCI_EXPRESS_L1_PM_SS_CAPABILITIES_REGISTER,
    pub L1PmSsControl1: PCI_EXPRESS_L1_PM_SS_CONTROL_1_REGISTER,
    pub L1PmSsControl2: PCI_EXPRESS_L1_PM_SS_CONTROL_2_REGISTER,
}
impl Default for PCI_EXPRESS_L1_PM_SS_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_EXPRESS_L1_PM_SS_CAP_ID: u32 = 30u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_L1_PM_SS_CONTROL_1_REGISTER {
    pub Anonymous: PCI_EXPRESS_L1_PM_SS_CONTROL_1_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_L1_PM_SS_CONTROL_1_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_L1_PM_SS_CONTROL_1_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_L1_PM_SS_CONTROL_2_REGISTER {
    pub Anonymous: PCI_EXPRESS_L1_PM_SS_CONTROL_2_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_L1_PM_SS_CONTROL_2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_L1_PM_SS_CONTROL_2_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LANE_ERROR_STATUS {
    pub LaneBitmap: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LINK_CAPABILITIES_2_REGISTER {
    pub Anonymous: PCI_EXPRESS_LINK_CAPABILITIES_2_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_LINK_CAPABILITIES_2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LINK_CAPABILITIES_2_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LINK_CAPABILITIES_REGISTER {
    pub Anonymous: PCI_EXPRESS_LINK_CAPABILITIES_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_LINK_CAPABILITIES_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LINK_CAPABILITIES_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_LINK_CONTROL3 {
    pub Anonymous: PCI_EXPRESS_LINK_CONTROL3_0,
}
impl Default for PCI_EXPRESS_LINK_CONTROL3 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LINK_CONTROL3_0 {
    pub Anonymous: PCI_EXPRESS_LINK_CONTROL3_0_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_LINK_CONTROL3_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LINK_CONTROL3_0_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LINK_CONTROL_2_REGISTER {
    pub Anonymous: PCI_EXPRESS_LINK_CONTROL_2_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_LINK_CONTROL_2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LINK_CONTROL_2_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LINK_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_LINK_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_LINK_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LINK_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_EXPRESS_LINK_QUIESCENT_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub PciExpressEnterLinkQuiescentMode: PPCI_EXPRESS_ENTER_LINK_QUIESCENT_MODE,
    pub PciExpressExitLinkQuiescentMode: PPCI_EXPRESS_EXIT_LINK_QUIESCENT_MODE,
}
impl Default for PCI_EXPRESS_LINK_QUIESCENT_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_EXPRESS_LINK_QUIESCENT_INTERFACE_VERSION: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LINK_STATUS_2_REGISTER {
    pub Anonymous: PCI_EXPRESS_LINK_STATUS_2_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_LINK_STATUS_2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LINK_STATUS_2_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LINK_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_LINK_STATUS_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_LINK_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LINK_STATUS_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_LINK_SUBSTATE(pub i32);
pub const PCI_EXPRESS_LN_REQUESTER_CAP_ID: u32 = 28u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_LTR_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Latency: PCI_EXPRESS_LTR_MAX_LATENCY_REGISTER,
}
impl Default for PCI_EXPRESS_LTR_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_EXPRESS_LTR_CAP_ID: u32 = 24u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_LTR_MAX_LATENCY_REGISTER {
    pub Anonymous: PCI_EXPRESS_LTR_MAX_LATENCY_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_LTR_MAX_LATENCY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_LTR_MAX_LATENCY_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_MAX_PAYLOAD_SIZE(pub i32);
pub const PCI_EXPRESS_MFVC_CAP_ID: u32 = 8u32;
pub const PCI_EXPRESS_MPCIE_CAP_ID: u32 = 32u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_MRL_STATE(pub i32);
pub const PCI_EXPRESS_MULTICAST_CAP_ID: u32 = 18u32;
pub const PCI_EXPRESS_MULTI_ROOT_IO_VIRTUALIZATION_CAP_ID: u32 = 17u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_NPEM_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Capability: PCI_EXPRESS_NPEM_CAPABILITY_REGISTER,
    pub Control: PCI_EXPRESS_NPEM_CONTROL_REGISTER,
    pub Status: PCI_EXPRESS_NPEM_STATUS_REGISTER,
}
impl Default for PCI_EXPRESS_NPEM_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_NPEM_CAPABILITY_REGISTER {
    pub Anonymous: PCI_EXPRESS_NPEM_CAPABILITY_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_NPEM_CAPABILITY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_NPEM_CAPABILITY_REGISTER_0 {
    pub _bitfield: u32,
}
pub const PCI_EXPRESS_NPEM_CAP_ID: u32 = 41u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_NPEM_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_NPEM_CONTROL_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_NPEM_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_NPEM_CONTROL_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_NPEM_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_NPEM_STATUS_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_NPEM_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_NPEM_STATUS_REGISTER_0 {
    pub _bitfield: u32,
}
pub const PCI_EXPRESS_PAGE_REQUEST_CAP_ID: u32 = 19u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_PASID_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Capability: PCI_EXPRESS_PASID_CAPABILITY_REGISTER,
    pub Control: PCI_EXPRESS_PASID_CONTROL_REGISTER,
}
impl Default for PCI_EXPRESS_PASID_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_PASID_CAPABILITY_REGISTER {
    pub Anonymous: PCI_EXPRESS_PASID_CAPABILITY_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_PASID_CAPABILITY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_PASID_CAPABILITY_REGISTER_0 {
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_PASID_CAP_ID: u32 = 27u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_PASID_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_PASID_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_PASID_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_PASID_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_PME_REQUESTOR_ID {
    pub Anonymous: PCI_EXPRESS_PME_REQUESTOR_ID_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_PME_REQUESTOR_ID {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_PME_REQUESTOR_ID_0 {
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_PMUX_CAP_ID: u32 = 26u32;
pub const PCI_EXPRESS_POWER_BUDGETING_CAP_ID: u32 = 4u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_POWER_STATE(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_PRI_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Control: PCI_EXPRESS_PRI_CONTROL_REGISTER,
    pub Status: PCI_EXPRESS_PRI_STATUS_REGISTER,
    pub PRCapacity: u32,
    pub PRAllocation: u32,
}
impl Default for PCI_EXPRESS_PRI_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_PRI_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_PRI_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_PRI_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_PRI_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_PRI_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_PRI_STATUS_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_PRI_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_PRI_STATUS_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_PTM_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub PtmCapability: PCI_EXPRESS_PTM_CAPABILITY_REGISTER,
    pub PtmControl: PCI_EXPRESS_PTM_CONTROL_REGISTER,
}
impl Default for PCI_EXPRESS_PTM_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_PTM_CAPABILITY_REGISTER {
    pub Anonymous: PCI_EXPRESS_PTM_CAPABILITY_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_PTM_CAPABILITY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_PTM_CAPABILITY_REGISTER_0 {
    pub _bitfield: u32,
}
pub const PCI_EXPRESS_PTM_CAP_ID: u32 = 31u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_PTM_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_PTM_CONTROL_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_PTM_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_PTM_CONTROL_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_EXPRESS_RCB(pub i32);
pub const PCI_EXPRESS_RCRB_HEADER_CAP_ID: u32 = 10u32;
pub const PCI_EXPRESS_RC_EVENT_COLLECTOR_ENDPOINT_ASSOCIATION_CAP_ID: u32 = 7u32;
pub const PCI_EXPRESS_RC_INTERNAL_LINK_CONTROL_CAP_ID: u32 = 6u32;
pub const PCI_EXPRESS_RC_LINK_DECLARATION_CAP_ID: u32 = 5u32;
pub const PCI_EXPRESS_READINESS_TIME_REPORTING_CAP_ID: u32 = 34u32;
pub const PCI_EXPRESS_RESERVED_FOR_AMD_CAP_ID: u32 = 20u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_RESIZABLE_BAR_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Entry: [PCI_EXPRESS_RESIZABLE_BAR_ENTRY; 6],
}
impl Default for PCI_EXPRESS_RESIZABLE_BAR_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_RESIZABLE_BAR_CAPABILITY_REGISTER {
    pub Anonymous: PCI_EXPRESS_RESIZABLE_BAR_CAPABILITY_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_RESIZABLE_BAR_CAPABILITY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_RESIZABLE_BAR_CAPABILITY_REGISTER_0 {
    pub _bitfield: u32,
}
pub const PCI_EXPRESS_RESIZABLE_BAR_CAP_ID: u32 = 21u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_RESIZABLE_BAR_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_RESIZABLE_BAR_CONTROL_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_RESIZABLE_BAR_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_RESIZABLE_BAR_CONTROL_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_RESIZABLE_BAR_ENTRY {
    pub Capability: PCI_EXPRESS_RESIZABLE_BAR_CAPABILITY_REGISTER,
    pub Control: PCI_EXPRESS_RESIZABLE_BAR_CONTROL_REGISTER,
}
impl Default for PCI_EXPRESS_RESIZABLE_BAR_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_ROOTPORT_AER_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub UncorrectableErrorStatus: PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS,
    pub UncorrectableErrorMask: PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK,
    pub UncorrectableErrorSeverity: PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY,
    pub CorrectableErrorStatus: PCI_EXPRESS_CORRECTABLE_ERROR_STATUS,
    pub CorrectableErrorMask: PCI_EXPRESS_CORRECTABLE_ERROR_MASK,
    pub CapabilitiesAndControl: PCI_EXPRESS_AER_CAPABILITIES,
    pub HeaderLog: [u32; 4],
    pub RootErrorCommand: PCI_EXPRESS_ROOT_ERROR_COMMAND,
    pub RootErrorStatus: PCI_EXPRESS_ROOT_ERROR_STATUS,
    pub ErrorSourceId: PCI_EXPRESS_ERROR_SOURCE_ID,
}
impl Default for PCI_EXPRESS_ROOTPORT_AER_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER {
    pub Anonymous: PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ROOT_CAPABILITIES_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ROOT_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_ROOT_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_ROOT_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ROOT_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ROOT_ERROR_COMMAND {
    pub Anonymous: PCI_EXPRESS_ROOT_ERROR_COMMAND_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_ROOT_ERROR_COMMAND {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ROOT_ERROR_COMMAND_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ROOT_ERROR_STATUS {
    pub Anonymous: PCI_EXPRESS_ROOT_ERROR_STATUS_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_ROOT_ERROR_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ROOT_ERROR_STATUS_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_EXPRESS_ROOT_PORT_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub ReadConfigSpace: PPCI_EXPRESS_ROOT_PORT_READ_CONFIG_SPACE,
    pub WriteConfigSpace: PPCI_EXPRESS_ROOT_PORT_WRITE_CONFIG_SPACE,
}
impl Default for PCI_EXPRESS_ROOT_PORT_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_EXPRESS_ROOT_PORT_INTERFACE_VERSION: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_ROOT_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_ROOT_STATUS_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_ROOT_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_ROOT_STATUS_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_SECONDARY_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub LinkControl3: PCI_EXPRESS_LINK_CONTROL3,
    pub LaneErrorStatus: PCI_EXPRESS_LANE_ERROR_STATUS,
}
impl Default for PCI_EXPRESS_SECONDARY_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_EXPRESS_SECONDARY_PCI_EXPRESS_CAP_ID: u32 = 25u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SEC_AER_CAPABILITIES {
    pub Anonymous: PCI_EXPRESS_SEC_AER_CAPABILITIES_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_SEC_AER_CAPABILITIES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SEC_AER_CAPABILITIES_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK {
    pub Anonymous: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_MASK_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY {
    pub Anonymous: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_SEVERITY_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS {
    pub Anonymous: PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SEC_UNCORRECTABLE_ERROR_STATUS_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SERIAL_NUMBER_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub LowSerialNumber: u32,
    pub HighSerialNumber: u32,
}
pub const PCI_EXPRESS_SINGLE_ROOT_IO_VIRTUALIZATION_CAP_ID: u32 = 16u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER {
    pub Anonymous: PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SLOT_CAPABILITIES_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SLOT_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_SLOT_CONTROL_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_SLOT_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SLOT_CONTROL_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SLOT_STATUS_REGISTER {
    pub Anonymous: PCI_EXPRESS_SLOT_STATUS_REGISTER_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_SLOT_STATUS_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SLOT_STATUS_REGISTER_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_SRIOV_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub SRIOVCapabilities: PCI_EXPRESS_SRIOV_CAPS,
    pub SRIOVControl: PCI_EXPRESS_SRIOV_CONTROL,
    pub SRIOVStatus: PCI_EXPRESS_SRIOV_STATUS,
    pub InitialVFs: u16,
    pub TotalVFs: u16,
    pub NumVFs: u16,
    pub FunctionDependencyLink: u8,
    pub RsvdP1: u8,
    pub FirstVFOffset: u16,
    pub VFStride: u16,
    pub RsvdP2: u16,
    pub VFDeviceId: u16,
    pub SupportedPageSizes: u32,
    pub SystemPageSize: u32,
    pub BaseAddresses: [u32; 6],
    pub VFMigrationStateArrayOffset: PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY,
}
impl Default for PCI_EXPRESS_SRIOV_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SRIOV_CAPS {
    pub Anonymous: PCI_EXPRESS_SRIOV_CAPS_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_SRIOV_CAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SRIOV_CAPS_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SRIOV_CONTROL {
    pub Anonymous: PCI_EXPRESS_SRIOV_CONTROL_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_SRIOV_CONTROL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SRIOV_CONTROL_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY {
    pub Anonymous: PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SRIOV_MIGRATION_STATE_ARRAY_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_SRIOV_STATUS {
    pub Anonymous: PCI_EXPRESS_SRIOV_STATUS_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_SRIOV_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_SRIOV_STATUS_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_TPH_REQUESTER_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub RequesterCapability: PCI_EXPRESS_TPH_REQUESTER_CAPABILITY_REGISTER,
    pub RequesterControl: PCI_EXPRESS_TPH_REQUESTER_CONTROL_REGISTER,
}
impl Default for PCI_EXPRESS_TPH_REQUESTER_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_TPH_REQUESTER_CAPABILITY_REGISTER {
    pub Anonymous: PCI_EXPRESS_TPH_REQUESTER_CAPABILITY_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_TPH_REQUESTER_CAPABILITY_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_TPH_REQUESTER_CAPABILITY_REGISTER_0 {
    pub _bitfield: u32,
}
pub const PCI_EXPRESS_TPH_REQUESTER_CAP_ID: u32 = 23u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_TPH_REQUESTER_CONTROL_REGISTER {
    pub Anonymous: PCI_EXPRESS_TPH_REQUESTER_CONTROL_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_TPH_REQUESTER_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_TPH_REQUESTER_CONTROL_REGISTER_0 {
    pub _bitfield: u32,
}
pub const PCI_EXPRESS_TPH_ST_LOCATION_MSIX_TABLE: u32 = 2u32;
pub const PCI_EXPRESS_TPH_ST_LOCATION_NONE: u32 = 0u32;
pub const PCI_EXPRESS_TPH_ST_LOCATION_RESERVED: u32 = 3u32;
pub const PCI_EXPRESS_TPH_ST_LOCATION_TPH_CAPABILITY: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_TPH_ST_TABLE_ENTRY {
    pub Anonymous: PCI_EXPRESS_TPH_ST_TABLE_ENTRY_0,
    pub AsUSHORT: u16,
}
impl Default for PCI_EXPRESS_TPH_ST_TABLE_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_TPH_ST_TABLE_ENTRY_0 {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK {
    pub Anonymous: PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_UNCORRECTABLE_ERROR_MASK_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY {
    pub Anonymous: PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_UNCORRECTABLE_ERROR_SEVERITY_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS {
    pub Anonymous: PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS_0,
    pub AsULONG: u32,
}
impl Default for PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_UNCORRECTABLE_ERROR_STATUS_0 {
    pub _bitfield: u32,
}
pub const PCI_EXPRESS_VC_AND_MFVC_CAP_ID: u32 = 9u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_EXPRESS_VENDOR_SPECIFIC_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub VsecId: u16,
    pub _bitfield: u16,
}
pub const PCI_EXPRESS_VENDOR_SPECIFIC_CAP_ID: u32 = 11u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_EXPRESS_VIRTUAL_CHANNEL_CAPABILITY {
    pub Header: PCI_EXPRESS_ENHANCED_CAPABILITY_HEADER,
    pub Capabilities1: VIRTUAL_CHANNEL_CAPABILITIES1,
    pub Capabilities2: VIRTUAL_CHANNEL_CAPABILITIES2,
    pub Control: VIRTUAL_CHANNEL_CONTROL,
    pub Status: VIRTUAL_CHANNEL_STATUS,
    pub Resource: [VIRTUAL_RESOURCE; 8],
}
impl Default for PCI_EXPRESS_VIRTUAL_CHANNEL_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_EXPRESS_VIRTUAL_CHANNEL_CAP_ID: u32 = 2u32;
pub type PCI_EXPRESS_WAKE_CONTROL = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, enablewake: bool)>;
pub const PCI_EXTENDED_CONFIG_LENGTH: u32 = 4096u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_FIRMWARE_BUS_CAPS {
    pub Type: u16,
    pub Length: u16,
    pub Anonymous: PCI_FIRMWARE_BUS_CAPS_0,
    pub CurrentSpeedAndMode: u8,
    pub SupportedSpeedsAndModesLowByte: u8,
    pub SupportedSpeedsAndModesHighByte: u8,
    pub Voltage: u8,
    pub Reserved2: [u8; 7],
}
impl Default for PCI_FIRMWARE_BUS_CAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FIRMWARE_BUS_CAPS_0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FIRMWARE_BUS_CAPS_RETURN_BUFFER {
    pub Version: u16,
    pub Status: u16,
    pub Length: u32,
    pub Caps: PCI_FIRMWARE_BUS_CAPS,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_FPB_CAPABILITIES_REGISTER {
    pub Anonymous: PCI_FPB_CAPABILITIES_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_FPB_CAPABILITIES_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_CAPABILITIES_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_FPB_CAPABILITY {
    pub Header: PCI_FPB_CAPABILITY_HEADER,
    pub CapabilitiesRegister: PCI_FPB_CAPABILITIES_REGISTER,
    pub RidVectorControl1Register: PCI_FPB_RID_VECTOR_CONTROL1_REGISTER,
    pub RidVectorControl2Register: PCI_FPB_RID_VECTOR_CONTROL2_REGISTER,
    pub MemLowVectorControlRegister: PCI_FPB_MEM_LOW_VECTOR_CONTROL_REGISTER,
    pub MemHighVectorControl1Register: PCI_FPB_MEM_HIGH_VECTOR_CONTROL1_REGISTER,
    pub MemHighVectorControl2Register: PCI_FPB_MEM_HIGH_VECTOR_CONTROL2_REGISTER,
    pub VectorAccessControlRegister: PCI_FPB_VECTOR_ACCESS_CONTROL_REGISTER,
    pub VectorAccessDataRegister: PCI_FPB_VECTOR_ACCESS_DATA_REGISTER,
}
impl Default for PCI_FPB_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_CAPABILITY_HEADER {
    pub Header: PCI_CAPABILITIES_HEADER,
    pub Reserved: u16,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_FPB_MEM_HIGH_VECTOR_CONTROL1_REGISTER {
    pub Anonymous: PCI_FPB_MEM_HIGH_VECTOR_CONTROL1_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_FPB_MEM_HIGH_VECTOR_CONTROL1_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_MEM_HIGH_VECTOR_CONTROL1_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_MEM_HIGH_VECTOR_CONTROL2_REGISTER {
    pub MemHighVectorStartUpper: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_FPB_MEM_LOW_VECTOR_CONTROL_REGISTER {
    pub Anonymous: PCI_FPB_MEM_LOW_VECTOR_CONTROL_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_FPB_MEM_LOW_VECTOR_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_MEM_LOW_VECTOR_CONTROL_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_FPB_RID_VECTOR_CONTROL1_REGISTER {
    pub Anonymous: PCI_FPB_RID_VECTOR_CONTROL1_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_FPB_RID_VECTOR_CONTROL1_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_RID_VECTOR_CONTROL1_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_FPB_RID_VECTOR_CONTROL2_REGISTER {
    pub Anonymous: PCI_FPB_RID_VECTOR_CONTROL2_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_FPB_RID_VECTOR_CONTROL2_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_RID_VECTOR_CONTROL2_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_FPB_VECTOR_ACCESS_CONTROL_REGISTER {
    pub Anonymous: PCI_FPB_VECTOR_ACCESS_CONTROL_REGISTER_0,
    pub AsULONG: u32,
}
impl Default for PCI_FPB_VECTOR_ACCESS_CONTROL_REGISTER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_VECTOR_ACCESS_CONTROL_REGISTER_0 {
    pub _bitfield: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_FPB_VECTOR_ACCESS_DATA_REGISTER {
    pub VectorAccessData: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct PCI_HARDWARE_INTERFACE(pub i32);
pub const PCI_INVALID_ALTERNATE_FUNCTION_NUMBER: u32 = 255u32;
pub const PCI_INVALID_VENDORID: u32 = 65535u32;
pub type PCI_IS_DEVICE_PRESENT = Option<unsafe extern "system" fn(vendorid: u16, deviceid: u16, revisionid: u8, subvendorid: u16, subsystemid: u16, flags: u32) -> bool>;
pub type PCI_IS_DEVICE_PRESENT_EX = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, parameters: *const PCI_DEVICE_PRESENCE_PARAMETERS) -> bool>;
pub type PCI_LINE_TO_PIN = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, pcinewdata: *const PCI_COMMON_CONFIG, pciolddata: *const PCI_COMMON_CONFIG)>;
pub const PCI_MAX_BRIDGE_NUMBER: u32 = 255u32;
pub const PCI_MAX_DEVICES: u32 = 32u32;
pub const PCI_MAX_FUNCTION: u32 = 8u32;
pub const PCI_MAX_SEGMENT_NUMBER: u32 = 65535u32;
pub type PCI_MSIX_GET_ENTRY = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, tableentry: u32, messagenumber: *mut u32, masked: *mut bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type PCI_MSIX_GET_TABLE_SIZE = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, tablesize: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type PCI_MSIX_MASKUNMASK_ENTRY = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, tableentry: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type PCI_MSIX_SET_ENTRY = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, tableentry: u32, messagenumber: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_MSIX_TABLE_CONFIG_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub SetTableEntry: PPCI_MSIX_SET_ENTRY,
    pub MaskTableEntry: PPCI_MSIX_MASKUNMASK_ENTRY,
    pub UnmaskTableEntry: PPCI_MSIX_MASKUNMASK_ENTRY,
    pub GetTableEntry: PPCI_MSIX_GET_ENTRY,
    pub GetTableSize: PPCI_MSIX_GET_TABLE_SIZE,
}
impl Default for PCI_MSIX_TABLE_CONFIG_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_MSIX_TABLE_CONFIG_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_MULTIFUNCTION: u32 = 128u32;
pub type PCI_PIN_TO_LINE = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, pcidata: *const PCI_COMMON_CONFIG)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_PMC {
    pub _bitfield: u8,
    pub Support: PCI_PMC_0,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_PMC_0 {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_PMCSR {
    pub _bitfield: u16,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_PMCSR_BSE {
    pub _bitfield: u8,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_PM_CAPABILITY {
    pub Header: PCI_CAPABILITIES_HEADER,
    pub PMC: PCI_PM_CAPABILITY_0,
    pub PMCSR: PCI_PM_CAPABILITY_1,
    pub PMCSR_BSE: PCI_PM_CAPABILITY_2,
    pub Data: u8,
}
impl Default for PCI_PM_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_PM_CAPABILITY_2 {
    pub BridgeSupport: PCI_PMCSR_BSE,
    pub AsUCHAR: u8,
}
impl Default for PCI_PM_CAPABILITY_2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_PM_CAPABILITY_1 {
    pub ControlStatus: PCI_PMCSR,
    pub AsUSHORT: u16,
}
impl Default for PCI_PM_CAPABILITY_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_PM_CAPABILITY_0 {
    pub Capabilities: PCI_PMC,
    pub AsUSHORT: u16,
}
impl Default for PCI_PM_CAPABILITY_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type PCI_PREPARE_MULTISTAGE_RESUME = Option<unsafe extern "system" fn(context: *const core::ffi::c_void)>;
pub const PCI_PROGRAMMING_INTERFACE_MSC_NVM_EXPRESS: u32 = 2u32;
pub const PCI_PTM_TIME_SOURCE_AUX: u32 = 4294967295u32;
pub type PCI_READ_WRITE_CONFIG = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, busoffset: u32, slot: u32, buffer: *const core::ffi::c_void, offset: u32, length: u32) -> u32>;
pub const PCI_RECOVERY_SECTION_GUID: windows_core::GUID = windows_core::GUID::from_u128(0xdd060800_f6e1_4204_ac27_c4bca9568402);
pub const PCI_ROMADDRESS_ENABLED: u32 = 1u32;
pub type PCI_ROOT_BUS_CAPABILITY = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, hardwarecapability: *mut PCI_ROOT_BUS_HARDWARE_CAPABILITY)>;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_ROOT_BUS_HARDWARE_CAPABILITY {
    pub SecondaryInterface: PCI_HARDWARE_INTERFACE,
    pub Anonymous: PCI_ROOT_BUS_HARDWARE_CAPABILITY_0,
    pub OscFeatureSupport: PCI_ROOT_BUS_OSC_SUPPORT_FIELD,
    pub OscControlRequest: PCI_ROOT_BUS_OSC_CONTROL_FIELD,
    pub OscControlGranted: PCI_ROOT_BUS_OSC_CONTROL_FIELD,
}
impl Default for PCI_ROOT_BUS_HARDWARE_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_ROOT_BUS_HARDWARE_CAPABILITY_0 {
    pub BusCapabilitiesFound: bool,
    pub CurrentSpeedAndMode: u32,
    pub SupportedSpeedsAndModes: u32,
    pub DeviceIDMessagingCapable: bool,
    pub SecondaryBusWidth: PCI_BUS_WIDTH,
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_ROOT_BUS_OSC_CONTROL_FIELD {
    pub u: PCI_ROOT_BUS_OSC_CONTROL_FIELD_0,
}
impl Default for PCI_ROOT_BUS_OSC_CONTROL_FIELD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_ROOT_BUS_OSC_CONTROL_FIELD_0 {
    pub Anonymous: PCI_ROOT_BUS_OSC_CONTROL_FIELD_0_0,
    pub AsULONG: u32,
}
impl Default for PCI_ROOT_BUS_OSC_CONTROL_FIELD_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_ROOT_BUS_OSC_CONTROL_FIELD_0_0 {
    pub _bitfield: u32,
}
pub const PCI_ROOT_BUS_OSC_METHOD_CAPABILITY_REVISION: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_ROOT_BUS_OSC_SUPPORT_FIELD {
    pub u: PCI_ROOT_BUS_OSC_SUPPORT_FIELD_0,
}
impl Default for PCI_ROOT_BUS_OSC_SUPPORT_FIELD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_ROOT_BUS_OSC_SUPPORT_FIELD_0 {
    pub Anonymous: PCI_ROOT_BUS_OSC_SUPPORT_FIELD_0_0,
    pub AsULONG: u32,
}
impl Default for PCI_ROOT_BUS_OSC_SUPPORT_FIELD_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_ROOT_BUS_OSC_SUPPORT_FIELD_0_0 {
    pub _bitfield: u32,
}
pub const PCI_SECURITY_DIRECT_TRANSLATED_P2P: u32 = 4u32;
pub const PCI_SECURITY_ENHANCED: u32 = 2u32;
pub const PCI_SECURITY_FULLY_SUPPORTED: u32 = 1u32;
pub const PCI_SECURITY_GUEST_ASSIGNED: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_SECURITY_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub SetAccessControlServices: PPCI_SET_ACS,
}
impl Default for PCI_SECURITY_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct PCI_SECURITY_INTERFACE2 {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub Flags: u32,
    pub SupportedScenarios: u32,
    pub SetAccessControlServices: PPCI_SET_ACS2,
}
impl Default for PCI_SECURITY_INTERFACE2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const PCI_SECURITY_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_SECURITY_INTERFACE_VERSION2: u32 = 2u32;
pub const PCI_SECURITY_SRIOV_DIRECT_TRANSLATED_P2P: u32 = 262144u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_SEGMENT_BUS_NUMBER {
    pub u: PCI_SEGMENT_BUS_NUMBER_0,
}
impl Default for PCI_SEGMENT_BUS_NUMBER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_SEGMENT_BUS_NUMBER_0 {
    pub bits: PCI_SEGMENT_BUS_NUMBER_0_0,
    pub AsULONG: u32,
}
impl Default for PCI_SEGMENT_BUS_NUMBER_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_SEGMENT_BUS_NUMBER_0_0 {
    pub _bitfield: u32,
}
pub type PCI_SET_ACS = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, enablesourcevalidation: PCI_ACS_BIT, enabletranslationblocking: PCI_ACS_BIT, enablep2prequestredirect: PCI_ACS_BIT, enablecompletionredirect: PCI_ACS_BIT, enableupstreamforwarding: PCI_ACS_BIT, enableegresscontrol: PCI_ACS_BIT, enabledirecttranslatedp2p: PCI_ACS_BIT) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type PCI_SET_ACS2 = Option<unsafe extern "system" fn(context: *mut core::ffi::c_void, scenariostomodify: u32, scenariostate: u32) -> super::super::super::Win32::Foundation::NTSTATUS>;
pub type PCI_SET_ATS = Option<unsafe extern "system" fn(context: *const core::ffi::c_void, enableats: bool) -> super::super::super::Win32::Foundation::NTSTATUS>;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct PCI_SLOT_NUMBER {
    pub u: PCI_SLOT_NUMBER_0,
}
impl Default for PCI_SLOT_NUMBER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union PCI_SLOT_NUMBER_0 {
    pub bits: PCI_SLOT_NUMBER_0_0,
    pub AsULONG: u32,
}
impl Default for PCI_SLOT_NUMBER_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct PCI_SLOT_NUMBER_0_0 {
    pub _bitfield: u32,
}
pub const PCI_STATUS_66MHZ_CAPABLE: u32 = 32u32;
pub const PCI_STATUS_CAPABILITIES_LIST: u32 = 16u32;
pub const PCI_STATUS_DATA_PARITY_DETECTED: u32 = 256u32;
pub const PCI_STATUS_DETECTED_PARITY_ERROR: u32 = 32768u32;
pub const PCI_STATUS_DEVSEL: u32 = 1536u32;
pub const PCI_STATUS_FA