/*
	Public domain by Andrew M. <liquidsun@gmail.com>
	Modified from the amd64-51-30k implementation by
		Daniel J. Bernstein
		Niels Duif
		Tanja Lange
		Peter Schwabe
		Bo-Yin Yang
*/


#include "ed25519-donna-portable.h"
#include "curve25519-donna-32bit.h"
#include "curve25519-donna-helpers.h"
#include "modm-donna-32bit.h"

typedef unsigned char hash_512bits[64];
typedef unsigned char *hash_512bits_p;


/*
 * Arithmetic on the twisted Edwards curve -x^2 + y^2 = 1 + dx^2y^2
 * with d = -(121665/121666) = 37095705934669439343138083508754565189542113879843219016388785533085940283555
 * Base point: (15112221349535400772501151409588531511454012693041857206046113283949847762202,46316835694926478169428394003475163141307993866256225615783033603165251855960);
 */

typedef struct ge25519_t {
	bignum25519 x, y, z, t;
} ge25519;

typedef struct ge25519_p1p1_t {
	bignum25519 x, y, z, t;
} ge25519_p1p1;

typedef struct ge25519_niels_t {
	bignum25519 ysubx, xaddy, t2d;
} ge25519_niels;

#include "ed25519-donna-basepoint-table.h"
#include "ed25519-donna-32bit-tables.h"

#include "ed25519-donna-impl-base.h"
