// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Mappings for the contents of dcomptypes.h
use shared::dxgitype::DXGI_RATIONAL;
use shared::minwindef::DWORD;
use um::winnt::LARGE_INTEGER;
ENUM!{enum DCOMPOSITION_BITMAP_INTERPOLATION_MODE {
    DCOMPOSITION_BITMAP_INTERPOLATION_MODE_NEAREST_NEIGHBOR = 0,
    DCOMPOSITION_BITMAP_INTERPOLATION_MODE_LINEAR = 1,
    DCOMPOSITION_BITMAP_INTERPOLATION_MODE_INHERIT = 0xffffffff,
}}
ENUM!{enum DCOMPOSITION_BORDER_MODE {
    DCOMPOSITION_BORDER_MODE_SOFT = 0,
    DCOMPOSITION_BORDER_MODE_HARD = 1,
    DCOMPOSITION_BORDER_MODE_INHERIT = 0xffffffff,
}}
ENUM!{enum DCOMPOSITION_COMPOSITE_MODE {
    DCOMPOSITION_COMPOSITE_MODE_SOURCE_OVER = 0,
    DCOMPOSITION_COMPOSITE_MODE_DESTINATION_INVERT = 1,
    DCOMPOSITION_COMPOSITE_MODE_MIN_BLEND = 2,
    DCOMPOSITION_COMPOSITE_MODE_INHERIT = 0xffffffff,
}}
ENUM!{enum DCOMPOSITION_BACKFACE_VISIBILITY {
    DCOMPOSITION_BACKFACE_VISIBILITY_VISIBLE = 0,
    DCOMPOSITION_BACKFACE_VISIBILITY_HIDDEN = 1,
    DCOMPOSITION_BACKFACE_VISIBILITY_INHERIT = 0xffffffff,
}}
ENUM!{enum DCOMPOSITION_OPACITY_MODE {
    DCOMPOSITION_OPACITY_MODE_LAYER = 0,
    DCOMPOSITION_OPACITY_MODE_MULTIPLY = 1,
    DCOMPOSITION_OPACITY_MODE_INHERIT = 0xffffffff,
}}
ENUM!{enum DCOMPOSITION_DEPTH_MODE {
    DCOMPOSITION_DEPTH_MODE_TREE = 0,
    DCOMPOSITION_DEPTH_MODE_SPATIAL = 1,
    DCOMPOSITION_DEPTH_MODE_INHERIT = 0xffffffff,
}}
STRUCT!{struct DCOMPOSITION_FRAME_STATISTICS {
    lastFrameTime: LARGE_INTEGER,
    currentCompositionRate: DXGI_RATIONAL,
    currentTime: LARGE_INTEGER,
    timeFrequency: LARGE_INTEGER,
    nextEstimatedFrameTime: LARGE_INTEGER,
}}
pub const COMPOSITIONOBJECT_READ: DWORD = 0x0001;
pub const COMPOSITIONOBJECT_WRITE: DWORD = 0x0002;
pub const COMPOSITIONOBJECT_ALL_ACCESS: DWORD = COMPOSITIONOBJECT_READ | COMPOSITIONOBJECT_WRITE;
