/*
  Fifteen - display differences between two archives
  Copyright (C) 2011  Christopher Howard
  
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

	.file "randboard.S"
	.comm gf_bsquare_values, 16
	.globl gf_randboard
	.text
	.type gf_randboard, @function
gf_randboard:			
	movq %rdi, %r8		// random bits
	movq $0, %r9		// index for empty square
	movq $0, %r12		// counter for pulling random bits
.LF0:				// search for empty square
	cmpb $0, gf_bsquare_values(%r9)
	je .LF1
	inc %r9
	jmp .LF0
.LF1:
	movq %r8, %r10
	and $3, %r10		// get two random bits (4 possible values)
	cmp $0, %r10
	je .LF2
	cmp $1, %r10
	je .LF3
	cmp $2, %r10
	je .LF4
	cmp $3, %r10
	je .LF5
.LF11:
	cmp $14, %r12
	je .LF6
	addq $1, %r12
	shr $2, %r8
	jmp .LF1
	ret
.LF2:				// try to swap empty with square above
	cmp $4, %r9		// can't swap if empty is in top row
	jl .LF11
	subq $4, %r9
	movzb gf_bsquare_values(%r9), %r13
	movb $0, gf_bsquare_values(%r9)
	addq $4, %r9
	movb %r13b, gf_bsquare_values(%r9)
	subq $4, %r9
	jmp .LF11
.LF3:				// try to swap empty with square below
	cmp $11, %r9		// can't swap if empty is in bottom row
	jg .LF11
	addq $4, %r9
	movzb gf_bsquare_values(%r9), %r13
	movb $0, gf_bsquare_values(%r9)
	subq $4, %r9
	movb %r13b, gf_bsquare_values(%r9)
	addq $4, %r9
	jmp .LF11
.LF4:				// try to swap empty with square to left
	cmp $0, %r9		// can't swap if empty is in left column
	je .LF11
	cmp $4, %r9		
	je .LF11
	cmp $8, %r9		
	je .LF11
	cmp $12, %r9		
	je .LF11
	dec %r9
	movzb gf_bsquare_values(%r9), %r13
	movb $0, gf_bsquare_values(%r9)
	inc %r9
	movb %r13b, gf_bsquare_values(%r9)
	dec %r9
	jmp .LF11
.LF5:				// try to swap empty with square to right
	cmp $3, %r9		// can't swap if empty is in right column
	je .LF11
	cmp $7, %r9		
	je .LF11
	cmp $11, %r9		
	je .LF11
	cmp $15, %r9		
	je .LF11
	inc %r9
	movzb gf_bsquare_values(%r9), %r13
	movb $0, gf_bsquare_values(%r9)
	dec %r9
	movb %r13b, gf_bsquare_values(%r9)
	inc %r9
	jmp .LF11
.LF6:
	ret
#if defined(__linux__) && defined(__ELF__)
	.section .note.GNU-stack,"",%progbits
#endif

	