/*****************************************************************************
 * Copyright (c) 2014-2025 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "VehicleSubpositionData.h"

#include "Vehicle.h"

using namespace OpenRCT2;
using enum VehiclePitch;
using enum VehicleRoll;

#define CREATE_VEHICLE_INFO(VAR, ...)                                                                                          \
    static constexpr VehicleInfo VAR##_data[] = __VA_ARGS__;                                                                   \
    static constexpr VehicleInfoList VAR = { static_cast<uint16_t>(std::size(VAR##_data)), VAR##_data };

// clang-format off
#define MINI_GOLF_STATE(STATE)                                                                                                 \
    {                                                                                                                          \
        kLocationNull, EnumValue(MiniGolfState::STATE), 0, 0, flat, unbanked                                                   \
    }
#define MINI_GOLF_ANIMATION(VALUE)                                                                                             \
    {                                                                                                                          \
        kLocationNull, EnumValue(MiniGolfState::Unk4), EnumValue(MiniGolfAnimation::VALUE), 0, flat, unbanked                  \
    }

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE57A, {
    { 31, 16, 0, 0, flat, unbanked }, { 30, 16, 0, 0, flat, unbanked }, { 29, 16, 0, 0, flat, unbanked }, { 28, 16, 0, 0, flat, unbanked }, { 27, 16, 0, 0, flat, unbanked }, { 26, 16, 0, 0, flat, unbanked },
    { 25, 16, 0, 0, flat, unbanked }, { 24, 16, 0, 0, flat, unbanked }, { 23, 16, 0, 0, flat, unbanked }, { 22, 16, 0, 0, flat, unbanked }, { 21, 16, 0, 0, flat, unbanked }, { 20, 16, 0, 0, flat, unbanked },
    { 19, 16, 0, 0, flat, unbanked }, { 18, 16, 0, 0, flat, unbanked }, { 17, 16, 0, 0, flat, unbanked }, { 16, 16, 0, 0, flat, unbanked }, { 15, 16, 0, 0, flat, unbanked }, { 14, 16, 0, 0, flat, unbanked },
    { 13, 16, 0, 0, flat, unbanked }, { 12, 16, 0, 0, flat, unbanked }, { 11, 16, 0, 0, flat, unbanked }, { 10, 16, 0, 0, flat, unbanked }, {  9, 16, 0, 0, flat, unbanked }, {  8, 16, 0, 0, flat, unbanked },
    {  7, 16, 0, 0, flat, unbanked }, {  6, 16, 0, 0, flat, unbanked }, {  5, 16, 0, 0, flat, unbanked }, {  4, 16, 0, 0, flat, unbanked }, {  3, 16, 0, 0, flat, unbanked }, {  2, 16, 0, 0, flat, unbanked },
    {  1, 16, 0, 0, flat, unbanked }, {  0, 16, 0, 0, flat, unbanked },
})


CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE69C, {
    { 16,  0, 0, 8, flat, unbanked }, { 16,  1, 0, 8, flat, unbanked }, { 16,  2, 0, 8, flat, unbanked }, { 16,  3, 0, 8, flat, unbanked }, { 16,  4, 0, 8, flat, unbanked }, { 16,  5, 0, 8, flat, unbanked },
    { 16,  6, 0, 8, flat, unbanked }, { 16,  7, 0, 8, flat, unbanked }, { 16,  8, 0, 8, flat, unbanked }, { 16,  9, 0, 8, flat, unbanked }, { 16, 10, 0, 8, flat, unbanked }, { 16, 11, 0, 8, flat, unbanked },
    { 16, 12, 0, 8, flat, unbanked }, { 16, 13, 0, 8, flat, unbanked }, { 16, 14, 0, 8, flat, unbanked }, { 16, 15, 0, 8, flat, unbanked }, { 16, 16, 0, 8, flat, unbanked }, { 16, 17, 0, 8, flat, unbanked },
    { 16, 18, 0, 8, flat, unbanked }, { 16, 19, 0, 8, flat, unbanked }, { 16, 20, 0, 8, flat, unbanked }, { 16, 21, 0, 8, flat, unbanked }, { 16, 22, 0, 8, flat, unbanked }, { 16, 23, 0, 8, flat, unbanked },
    { 16, 24, 0, 8, flat, unbanked }, { 16, 25, 0, 8, flat, unbanked }, { 16, 26, 0, 8, flat, unbanked }, { 16, 27, 0, 8, flat, unbanked }, { 16, 28, 0, 8, flat, unbanked }, { 16, 29, 0, 8, flat, unbanked },
    { 16, 30, 0, 8, flat, unbanked }, { 16, 31, 0, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE7BE, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 16, flat, unbanked }, {  4, 16, 0, 16, flat, unbanked }, {  5, 16, 0, 16, flat, unbanked },
    {  6, 16, 0, 16, flat, unbanked }, {  7, 16, 0, 16, flat, unbanked }, {  8, 16, 0, 16, flat, unbanked }, {  9, 16, 0, 16, flat, unbanked }, { 10, 16, 0, 16, flat, unbanked }, { 11, 16, 0, 16, flat, unbanked },
    { 12, 16, 0, 16, flat, unbanked }, { 13, 16, 0, 16, flat, unbanked }, { 14, 16, 0, 16, flat, unbanked }, { 15, 16, 0, 16, flat, unbanked }, { 16, 16, 0, 16, flat, unbanked }, { 17, 16, 0, 16, flat, unbanked },
    { 18, 16, 0, 16, flat, unbanked }, { 19, 16, 0, 16, flat, unbanked }, { 20, 16, 0, 16, flat, unbanked }, { 21, 16, 0, 16, flat, unbanked }, { 22, 16, 0, 16, flat, unbanked }, { 23, 16, 0, 16, flat, unbanked },
    { 24, 16, 0, 16, flat, unbanked }, { 25, 16, 0, 16, flat, unbanked }, { 26, 16, 0, 16, flat, unbanked }, { 27, 16, 0, 16, flat, unbanked }, { 28, 16, 0, 16, flat, unbanked }, { 29, 16, 0, 16, flat, unbanked },
    { 30, 16, 0, 16, flat, unbanked }, { 31, 16, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE8E0, {
    { 16, 31, 0, 24, flat, unbanked }, { 16, 30, 0, 24, flat, unbanked }, { 16, 29, 0, 24, flat, unbanked }, { 16, 28, 0, 24, flat, unbanked }, { 16, 27, 0, 24, flat, unbanked }, { 16, 26, 0, 24, flat, unbanked },
    { 16, 25, 0, 24, flat, unbanked }, { 16, 24, 0, 24, flat, unbanked }, { 16, 23, 0, 24, flat, unbanked }, { 16, 22, 0, 24, flat, unbanked }, { 16, 21, 0, 24, flat, unbanked }, { 16, 20, 0, 24, flat, unbanked },
    { 16, 19, 0, 24, flat, unbanked }, { 16, 18, 0, 24, flat, unbanked }, { 16, 17, 0, 24, flat, unbanked }, { 16, 16, 0, 24, flat, unbanked }, { 16, 15, 0, 24, flat, unbanked }, { 16, 14, 0, 24, flat, unbanked },
    { 16, 13, 0, 24, flat, unbanked }, { 16, 12, 0, 24, flat, unbanked }, { 16, 11, 0, 24, flat, unbanked }, { 16, 10, 0, 24, flat, unbanked }, { 16,  9, 0, 24, flat, unbanked }, { 16,  8, 0, 24, flat, unbanked },
    { 16,  7, 0, 24, flat, unbanked }, { 16,  6, 0, 24, flat, unbanked }, { 16,  5, 0, 24, flat, unbanked }, { 16,  4, 0, 24, flat, unbanked }, { 16,  3, 0, 24, flat, unbanked }, { 16,  2, 0, 24, flat, unbanked },
    { 16,  1, 0, 24, flat, unbanked }, { 16,  0, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C232A, {
    { 31, 16,  0, 0, up25, unbanked }, { 30, 16,  1, 0, up25, unbanked }, { 29, 16,  1, 0, up25, unbanked }, { 28, 16,  2, 0, up25, unbanked }, { 27, 16,  2, 0, up25, unbanked }, { 26, 16,  3, 0, up25, unbanked },
    { 25, 16,  3, 0, up25, unbanked }, { 24, 16,  4, 0, up25, unbanked }, { 23, 16,  4, 0, up25, unbanked }, { 22, 16,  5, 0, up25, unbanked }, { 21, 16,  5, 0, up25, unbanked }, { 20, 16,  6, 0, up25, unbanked },
    { 19, 16,  6, 0, up25, unbanked }, { 18, 16,  7, 0, up25, unbanked }, { 17, 16,  7, 0, up25, unbanked }, { 16, 16,  8, 0, up25, unbanked }, { 15, 16,  8, 0, up25, unbanked }, { 14, 16,  9, 0, up25, unbanked },
    { 13, 16,  9, 0, up25, unbanked }, { 12, 16, 10, 0, up25, unbanked }, { 11, 16, 10, 0, up25, unbanked }, { 10, 16, 11, 0, up25, unbanked }, {  9, 16, 11, 0, up25, unbanked }, {  8, 16, 12, 0, up25, unbanked },
    {  7, 16, 12, 0, up25, unbanked }, {  6, 16, 13, 0, up25, unbanked }, {  5, 16, 13, 0, up25, unbanked }, {  4, 16, 14, 0, up25, unbanked }, {  3, 16, 14, 0, up25, unbanked }, {  2, 16, 15, 0, up25, unbanked },
    {  1, 16, 15, 0, up25, unbanked }, {  0, 16, 16, 0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C244C, {
    { 16,  0,  0, 8, up25, unbanked }, { 16,  1,  0, 8, up25, unbanked }, { 16,  2,  1, 8, up25, unbanked }, { 16,  3,  1, 8, up25, unbanked }, { 16,  4,  2, 8, up25, unbanked }, { 16,  5,  2, 8, up25, unbanked },
    { 16,  6,  3, 8, up25, unbanked }, { 16,  7,  3, 8, up25, unbanked }, { 16,  8,  4, 8, up25, unbanked }, { 16,  9,  4, 8, up25, unbanked }, { 16, 10,  5, 8, up25, unbanked }, { 16, 11,  5, 8, up25, unbanked },
    { 16, 12,  6, 8, up25, unbanked }, { 16, 13,  6, 8, up25, unbanked }, { 16, 14,  7, 8, up25, unbanked }, { 16, 15,  7, 8, up25, unbanked }, { 16, 16,  8, 8, up25, unbanked }, { 16, 17,  8, 8, up25, unbanked },
    { 16, 18,  9, 8, up25, unbanked }, { 16, 19,  9, 8, up25, unbanked }, { 16, 20, 10, 8, up25, unbanked }, { 16, 21, 10, 8, up25, unbanked }, { 16, 22, 11, 8, up25, unbanked }, { 16, 23, 11, 8, up25, unbanked },
    { 16, 24, 12, 8, up25, unbanked }, { 16, 25, 12, 8, up25, unbanked }, { 16, 26, 13, 8, up25, unbanked }, { 16, 27, 13, 8, up25, unbanked }, { 16, 28, 14, 8, up25, unbanked }, { 16, 29, 14, 8, up25, unbanked },
    { 16, 30, 15, 8, up25, unbanked }, { 16, 31, 15, 8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C256E, {
    {  0, 16,  0, 16, up25, unbanked }, {  1, 16,  0, 16, up25, unbanked }, {  2, 16,  1, 16, up25, unbanked }, {  3, 16,  1, 16, up25, unbanked }, {  4, 16,  2, 16, up25, unbanked },
    {  5, 16,  2, 16, up25, unbanked }, {  6, 16,  3, 16, up25, unbanked }, {  7, 16,  3, 16, up25, unbanked }, {  8, 16,  4, 16, up25, unbanked }, {  9, 16,  4, 16, up25, unbanked },
    { 10, 16,  5, 16, up25, unbanked }, { 11, 16,  5, 16, up25, unbanked }, { 12, 16,  6, 16, up25, unbanked }, { 13, 16,  6, 16, up25, unbanked }, { 14, 16,  7, 16, up25, unbanked },
    { 15, 16,  7, 16, up25, unbanked }, { 16, 16,  8, 16, up25, unbanked }, { 17, 16,  8, 16, up25, unbanked }, { 18, 16,  9, 16, up25, unbanked }, { 19, 16,  9, 16, up25, unbanked },
    { 20, 16, 10, 16, up25, unbanked }, { 21, 16, 10, 16, up25, unbanked }, { 22, 16, 11, 16, up25, unbanked }, { 23, 16, 11, 16, up25, unbanked }, { 24, 16, 12, 16, up25, unbanked },
    { 25, 16, 12, 16, up25, unbanked }, { 26, 16, 13, 16, up25, unbanked }, { 27, 16, 13, 16, up25, unbanked }, { 28, 16, 14, 16, up25, unbanked }, { 29, 16, 14, 16, up25, unbanked },
    { 30, 16, 15, 16, up25, unbanked }, { 31, 16, 15, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2690, {
    { 16, 31,  0, 24, up25, unbanked }, { 16, 30,  1, 24, up25, unbanked }, { 16, 29,  1, 24, up25, unbanked }, { 16, 28,  2, 24, up25, unbanked }, { 16, 27,  2, 24, up25, unbanked },
    { 16, 26,  3, 24, up25, unbanked }, { 16, 25,  3, 24, up25, unbanked }, { 16, 24,  4, 24, up25, unbanked }, { 16, 23,  4, 24, up25, unbanked }, { 16, 22,  5, 24, up25, unbanked },
    { 16, 21,  5, 24, up25, unbanked }, { 16, 20,  6, 24, up25, unbanked }, { 16, 19,  6, 24, up25, unbanked }, { 16, 18,  7, 24, up25, unbanked }, { 16, 17,  7, 24, up25, unbanked },
    { 16, 16,  8, 24, up25, unbanked }, { 16, 15,  8, 24, up25, unbanked }, { 16, 14,  9, 24, up25, unbanked }, { 16, 13,  9, 24, up25, unbanked }, { 16, 12, 10, 24, up25, unbanked },
    { 16, 11, 10, 24, up25, unbanked }, { 16, 10, 11, 24, up25, unbanked }, { 16,  9, 11, 24, up25, unbanked }, { 16,  8, 12, 24, up25, unbanked }, { 16,  7, 12, 24, up25, unbanked },
    { 16,  6, 13, 24, up25, unbanked }, { 16,  5, 13, 24, up25, unbanked }, { 16,  4, 14, 24, up25, unbanked }, { 16,  3, 14, 24, up25, unbanked }, { 16,  2, 15, 24, up25, unbanked },
    { 16,  1, 15, 24, up25, unbanked }, { 16,  0, 16, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF312, {
    { 31, 16,  0, 0, up60, unbanked }, { 31, 16,  1, 0, up60, unbanked }, { 30, 16,  2, 0, up60, unbanked }, { 30, 16,  3, 0, up60, unbanked }, { 29, 16,  4, 0, up60, unbanked }, { 29, 16,  5, 0, up60, unbanked },
    { 28, 16,  6, 0, up60, unbanked }, { 28, 16,  7, 0, up60, unbanked }, { 27, 16,  8, 0, up60, unbanked }, { 27, 16,  9, 0, up60, unbanked }, { 26, 16, 10, 0, up60, unbanked }, { 26, 16, 11, 0, up60, unbanked },
    { 25, 16, 12, 0, up60, unbanked }, { 25, 16, 13, 0, up60, unbanked }, { 24, 16, 14, 0, up60, unbanked }, { 24, 16, 15, 0, up60, unbanked }, { 23, 16, 16, 0, up60, unbanked }, { 23, 16, 17, 0, up60, unbanked },
    { 22, 16, 18, 0, up60, unbanked }, { 22, 16, 19, 0, up60, unbanked }, { 21, 16, 20, 0, up60, unbanked }, { 21, 16, 21, 0, up60, unbanked }, { 20, 16, 22, 0, up60, unbanked }, { 20, 16, 23, 0, up60, unbanked },
    { 19, 16, 24, 0, up60, unbanked }, { 19, 16, 25, 0, up60, unbanked }, { 18, 16, 26, 0, up60, unbanked }, { 18, 16, 27, 0, up60, unbanked }, { 17, 16, 28, 0, up60, unbanked }, { 17, 16, 29, 0, up60, unbanked },
    { 16, 16, 30, 0, up60, unbanked }, { 16, 16, 31, 0, up60, unbanked }, { 15, 16, 32, 0, up60, unbanked }, { 15, 16, 33, 0, up60, unbanked }, { 14, 16, 34, 0, up60, unbanked }, { 14, 16, 35, 0, up60, unbanked },
    { 13, 16, 36, 0, up60, unbanked }, { 13, 16, 37, 0, up60, unbanked }, { 12, 16, 38, 0, up60, unbanked }, { 12, 16, 39, 0, up60, unbanked }, { 11, 16, 40, 0, up60, unbanked }, { 11, 16, 41, 0, up60, unbanked },
    { 10, 16, 42, 0, up60, unbanked }, { 10, 16, 43, 0, up60, unbanked }, {  9, 16, 44, 0, up60, unbanked }, {  9, 16, 45, 0, up60, unbanked }, {  8, 16, 46, 0, up60, unbanked }, {  8, 16, 47, 0, up60, unbanked },
    {  7, 16, 48, 0, up60, unbanked }, {  7, 16, 49, 0, up60, unbanked }, {  6, 16, 50, 0, up60, unbanked }, {  6, 16, 51, 0, up60, unbanked }, {  5, 16, 52, 0, up60, unbanked }, {  5, 16, 53, 0, up60, unbanked },
    {  4, 16, 54, 0, up60, unbanked }, {  4, 16, 55, 0, up60, unbanked }, {  3, 16, 56, 0, up60, unbanked }, {  3, 16, 57, 0, up60, unbanked }, {  2, 16, 58, 0, up60, unbanked }, {  2, 16, 59, 0, up60, unbanked },
    {  1, 16, 60, 0, up60, unbanked }, {  1, 16, 61, 0, up60, unbanked }, {  0, 16, 62, 0, up60, unbanked }, {  0, 16, 63, 0, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF554, {
    { 16,  0,  0, 8, up60, unbanked }, { 16,  0,  1, 8, up60, unbanked }, { 16,  1,  2, 8, up60, unbanked }, { 16,  1,  3, 8, up60, unbanked }, { 16,  2,  4, 8, up60, unbanked }, { 16,  2,  5, 8, up60, unbanked },
    { 16,  3,  6, 8, up60, unbanked }, { 16,  3,  7, 8, up60, unbanked }, { 16,  4,  8, 8, up60, unbanked }, { 16,  4,  9, 8, up60, unbanked }, { 16,  5, 10, 8, up60, unbanked }, { 16,  5, 11, 8, up60, unbanked },
    { 16,  6, 12, 8, up60, unbanked }, { 16,  6, 13, 8, up60, unbanked }, { 16,  7, 14, 8, up60, unbanked }, { 16,  7, 15, 8, up60, unbanked }, { 16,  8, 16, 8, up60, unbanked }, { 16,  8, 17, 8, up60, unbanked },
    { 16,  9, 18, 8, up60, unbanked }, { 16,  9, 19, 8, up60, unbanked }, { 16, 10, 20, 8, up60, unbanked }, { 16, 10, 21, 8, up60, unbanked }, { 16, 11, 22, 8, up60, unbanked }, { 16, 11, 23, 8, up60, unbanked },
    { 16, 12, 24, 8, up60, unbanked }, { 16, 12, 25, 8, up60, unbanked }, { 16, 13, 26, 8, up60, unbanked }, { 16, 13, 27, 8, up60, unbanked }, { 16, 14, 28, 8, up60, unbanked }, { 16, 14, 29, 8, up60, unbanked },
    { 16, 15, 30, 8, up60, unbanked }, { 16, 15, 31, 8, up60, unbanked }, { 16, 16, 32, 8, up60, unbanked }, { 16, 16, 33, 8, up60, unbanked }, { 16, 17, 34, 8, up60, unbanked }, { 16, 17, 35, 8, up60, unbanked },
    { 16, 18, 36, 8, up60, unbanked }, { 16, 18, 37, 8, up60, unbanked }, { 16, 19, 38, 8, up60, unbanked }, { 16, 19, 39, 8, up60, unbanked }, { 16, 20, 40, 8, up60, unbanked }, { 16, 20, 41, 8, up60, unbanked },
    { 16, 21, 42, 8, up60, unbanked }, { 16, 21, 43, 8, up60, unbanked }, { 16, 22, 44, 8, up60, unbanked }, { 16, 22, 45, 8, up60, unbanked }, { 16, 23, 46, 8, up60, unbanked }, { 16, 23, 47, 8, up60, unbanked },
    { 16, 24, 48, 8, up60, unbanked }, { 16, 24, 49, 8, up60, unbanked }, { 16, 25, 50, 8, up60, unbanked }, { 16, 25, 51, 8, up60, unbanked }, { 16, 26, 52, 8, up60, unbanked }, { 16, 26, 53, 8, up60, unbanked },
    { 16, 27, 54, 8, up60, unbanked }, { 16, 27, 55, 8, up60, unbanked }, { 16, 28, 56, 8, up60, unbanked }, { 16, 28, 57, 8, up60, unbanked }, { 16, 29, 58, 8, up60, unbanked }, { 16, 29, 59, 8, up60, unbanked },
    { 16, 30, 60, 8, up60, unbanked }, { 16, 30, 61, 8, up60, unbanked }, { 16, 31, 62, 8, up60, unbanked }, { 16, 31, 63, 8, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF796, {
    {  0, 16,  0, 16, up60, unbanked }, {  0, 16,  1, 16, up60, unbanked }, {  1, 16,  2, 16, up60, unbanked }, {  1, 16,  3, 16, up60, unbanked }, {  2, 16,  4, 16, up60, unbanked },
    {  2, 16,  5, 16, up60, unbanked }, {  3, 16,  6, 16, up60, unbanked }, {  3, 16,  7, 16, up60, unbanked }, {  4, 16,  8, 16, up60, unbanked }, {  4, 16,  9, 16, up60, unbanked },
    {  5, 16, 10, 16, up60, unbanked }, {  5, 16, 11, 16, up60, unbanked }, {  6, 16, 12, 16, up60, unbanked }, {  6, 16, 13, 16, up60, unbanked }, {  7, 16, 14, 16, up60, unbanked },
    {  7, 16, 15, 16, up60, unbanked }, {  8, 16, 16, 16, up60, unbanked }, {  8, 16, 17, 16, up60, unbanked }, {  9, 16, 18, 16, up60, unbanked }, {  9, 16, 19, 16, up60, unbanked },
    { 10, 16, 20, 16, up60, unbanked }, { 10, 16, 21, 16, up60, unbanked }, { 11, 16, 22, 16, up60, unbanked }, { 11, 16, 23, 16, up60, unbanked }, { 12, 16, 24, 16, up60, unbanked },
    { 12, 16, 25, 16, up60, unbanked }, { 13, 16, 26, 16, up60, unbanked }, { 13, 16, 27, 16, up60, unbanked }, { 14, 16, 28, 16, up60, unbanked }, { 14, 16, 29, 16, up60, unbanked },
    { 15, 16, 30, 16, up60, unbanked }, { 15, 16, 31, 16, up60, unbanked }, { 16, 16, 32, 16, up60, unbanked }, { 16, 16, 33, 16, up60, unbanked }, { 17, 16, 34, 16, up60, unbanked },
    { 17, 16, 35, 16, up60, unbanked }, { 18, 16, 36, 16, up60, unbanked }, { 18, 16, 37, 16, up60, unbanked }, { 19, 16, 38, 16, up60, unbanked }, { 19, 16, 39, 16, up60, unbanked },
    { 20, 16, 40, 16, up60, unbanked }, { 20, 16, 41, 16, up60, unbanked }, { 21, 16, 42, 16, up60, unbanked }, { 21, 16, 43, 16, up60, unbanked }, { 22, 16, 44, 16, up60, unbanked },
    { 22, 16, 45, 16, up60, unbanked }, { 23, 16, 46, 16, up60, unbanked }, { 23, 16, 47, 16, up60, unbanked }, { 24, 16, 48, 16, up60, unbanked }, { 24, 16, 49, 16, up60, unbanked },
    { 25, 16, 50, 16, up60, unbanked }, { 25, 16, 51, 16, up60, unbanked }, { 26, 16, 52, 16, up60, unbanked }, { 26, 16, 53, 16, up60, unbanked }, { 27, 16, 54, 16, up60, unbanked },
    { 27, 16, 55, 16, up60, unbanked }, { 28, 16, 56, 16, up60, unbanked }, { 28, 16, 57, 16, up60, unbanked }, { 29, 16, 58, 16, up60, unbanked }, { 29, 16, 59, 16, up60, unbanked },
    { 30, 16, 60, 16, up60, unbanked }, { 30, 16, 61, 16, up60, unbanked }, { 31, 16, 62, 16, up60, unbanked }, { 31, 16, 63, 16, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF9D8, {
    { 16, 31,  0, 24, up60, unbanked }, { 16, 31,  1, 24, up60, unbanked }, { 16, 30,  2, 24, up60, unbanked }, { 16, 30,  3, 24, up60, unbanked }, { 16, 29,  4, 24, up60, unbanked },
    { 16, 29,  5, 24, up60, unbanked }, { 16, 28,  6, 24, up60, unbanked }, { 16, 28,  7, 24, up60, unbanked }, { 16, 27,  8, 24, up60, unbanked }, { 16, 27,  9, 24, up60, unbanked },
    { 16, 26, 10, 24, up60, unbanked }, { 16, 26, 11, 24, up60, unbanked }, { 16, 25, 12, 24, up60, unbanked }, { 16, 25, 13, 24, up60, unbanked }, { 16, 24, 14, 24, up60, unbanked },
    { 16, 24, 15, 24, up60, unbanked }, { 16, 23, 16, 24, up60, unbanked }, { 16, 23, 17, 24, up60, unbanked }, { 16, 22, 18, 24, up60, unbanked }, { 16, 22, 19, 24, up60, unbanked },
    { 16, 21, 20, 24, up60, unbanked }, { 16, 21, 21, 24, up60, unbanked }, { 16, 20, 22, 24, up60, unbanked }, { 16, 20, 23, 24, up60, unbanked }, { 16, 19, 24, 24, up60, unbanked },
    { 16, 19, 25, 24, up60, unbanked }, { 16, 18, 26, 24, up60, unbanked }, { 16, 18, 27, 24, up60, unbanked }, { 16, 17, 28, 24, up60, unbanked }, { 16, 17, 29, 24, up60, unbanked },
    { 16, 16, 30, 24, up60, unbanked }, { 16, 16, 31, 24, up60, unbanked }, { 16, 15, 32, 24, up60, unbanked }, { 16, 15, 33, 24, up60, unbanked }, { 16, 14, 34, 24, up60, unbanked },
    { 16, 14, 35, 24, up60, unbanked }, { 16, 13, 36, 24, up60, unbanked }, { 16, 13, 37, 24, up60, unbanked }, { 16, 12, 38, 24, up60, unbanked }, { 16, 12, 39, 24, up60, unbanked },
    { 16, 11, 40, 24, up60, unbanked }, { 16, 11, 41, 24, up60, unbanked }, { 16, 10, 42, 24, up60, unbanked }, { 16, 10, 43, 24, up60, unbanked }, { 16,  9, 44, 24, up60, unbanked },
    { 16,  9, 45, 24, up60, unbanked }, { 16,  8, 46, 24, up60, unbanked }, { 16,  8, 47, 24, up60, unbanked }, { 16,  7, 48, 24, up60, unbanked }, { 16,  7, 49, 24, up60, unbanked },
    { 16,  6, 50, 24, up60, unbanked }, { 16,  6, 51, 24, up60, unbanked }, { 16,  5, 52, 24, up60, unbanked }, { 16,  5, 53, 24, up60, unbanked }, { 16,  4, 54, 24, up60, unbanked },
    { 16,  4, 55, 24, up60, unbanked }, { 16,  3, 56, 24, up60, unbanked }, { 16,  3, 57, 24, up60, unbanked }, { 16,  2, 58, 24, up60, unbanked }, { 16,  2, 59, 24, up60, unbanked },
    { 16,  1, 60, 24, up60, unbanked }, { 16,  1, 61, 24, up60, unbanked }, { 16,  0, 62, 24, up60, unbanked }, { 16,  0, 63, 24, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFC1A, {
    { 31, 16, 0, 0, flat, unbanked }, { 30, 16, 0, 0, flat, unbanked }, { 29, 16, 0, 0, flat, unbanked }, { 28, 16, 0, 0, flat, unbanked }, { 27, 16, 0, 0, flat, unbanked }, { 26, 16, 0, 0, flat, unbanked },
    { 25, 16, 0, 0, flat, unbanked }, { 24, 16, 0, 0, flat, unbanked }, { 23, 16, 0, 0, up12, unbanked }, { 22, 16, 0, 0, up12, unbanked }, { 21, 16, 1, 0, up12, unbanked }, { 20, 16, 1, 0, up12, unbanked },
    { 19, 16, 1, 0, up12, unbanked }, { 18, 16, 1, 0, up12, unbanked }, { 17, 16, 1, 0, up12, unbanked }, { 16, 16, 1, 0, up12, unbanked }, { 15, 16, 2, 0, up12, unbanked }, { 14, 16, 2, 0, up12, unbanked },
    { 13, 16, 2, 0, up12, unbanked }, { 12, 16, 2, 0, up12, unbanked }, { 11, 16, 3, 0, up12, unbanked }, { 10, 16, 3, 0, up12, unbanked }, {  9, 16, 3, 0, up12, unbanked }, {  8, 16, 4, 0, up12, unbanked },
    {  7, 16, 4, 0, up25, unbanked }, {  6, 16, 5, 0, up25, unbanked }, {  5, 16, 5, 0, up25, unbanked }, {  4, 16, 6, 0, up25, unbanked }, {  3, 16, 6, 0, up25, unbanked }, {  2, 16, 7, 0, up25, unbanked },
    {  1, 16, 7, 0, up25, unbanked }, {  0, 16, 8, 0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFD3C, {
    { 16,  0, 0, 8, flat, unbanked }, { 16,  1, 0, 8, flat, unbanked }, { 16,  2, 0, 8, flat, unbanked }, { 16,  3, 0, 8, flat, unbanked }, { 16,  4, 0, 8, flat, unbanked }, { 16,  5, 0, 8, flat, unbanked },
    { 16,  6, 0, 8, flat, unbanked }, { 16,  7, 0, 8, flat, unbanked }, { 16,  8, 0, 8, up12, unbanked }, { 16,  9, 0, 8, up12, unbanked }, { 16, 10, 1, 8, up12, unbanked }, { 16, 11, 1, 8, up12, unbanked },
    { 16, 12, 1, 8, up12, unbanked }, { 16, 13, 1, 8, up12, unbanked }, { 16, 14, 1, 8, up12, unbanked }, { 16, 15, 1, 8, up12, unbanked }, { 16, 16, 2, 8, up12, unbanked }, { 16, 17, 2, 8, up12, unbanked },
    { 16, 18, 2, 8, up12, unbanked }, { 16, 19, 2, 8, up12, unbanked }, { 16, 20, 3, 8, up12, unbanked }, { 16, 21, 3, 8, up12, unbanked }, { 16, 22, 3, 8, up12, unbanked }, { 16, 23, 4, 8, up12, unbanked },
    { 16, 24, 4, 8, up25, unbanked }, { 16, 25, 4, 8, up25, unbanked }, { 16, 26, 5, 8, up25, unbanked }, { 16, 27, 5, 8, up25, unbanked }, { 16, 28, 6, 8, up25, unbanked }, { 16, 29, 6, 8, up25, unbanked },
    { 16, 30, 7, 8, up25, unbanked }, { 16, 31, 7, 8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFE5E, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 16, flat, unbanked }, {  4, 16, 0, 16, flat, unbanked }, {  5, 16, 0, 16, flat, unbanked },
    {  6, 16, 0, 16, flat, unbanked }, {  7, 16, 0, 16, flat, unbanked }, {  8, 16, 0, 16, up12, unbanked }, {  9, 16, 0, 16, up12, unbanked }, { 10, 16, 1, 16, up12, unbanked }, { 11, 16, 1, 16, up12, unbanked },
    { 12, 16, 1, 16, up12, unbanked }, { 13, 16, 1, 16, up12, unbanked }, { 14, 16, 1, 16, up12, unbanked }, { 15, 16, 1, 16, up12, unbanked }, { 16, 16, 2, 16, up12, unbanked }, { 17, 16, 2, 16, up12, unbanked },
    { 18, 16, 2, 16, up12, unbanked }, { 19, 16, 2, 16, up12, unbanked }, { 20, 16, 3, 16, up12, unbanked }, { 21, 16, 3, 16, up12, unbanked }, { 22, 16, 3, 16, up12, unbanked }, { 23, 16, 4, 16, up12, unbanked },
    { 24, 16, 4, 16, up25, unbanked }, { 25, 16, 4, 16, up25, unbanked }, { 26, 16, 5, 16, up25, unbanked }, { 27, 16, 5, 16, up25, unbanked }, { 28, 16, 6, 16, up25, unbanked }, { 29, 16, 6, 16, up25, unbanked },
    { 30, 16, 7, 16, up25, unbanked }, { 31, 16, 7, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFF80, {
    { 16, 31, 0, 24, flat, unbanked }, { 16, 30, 0, 24, flat, unbanked }, { 16, 29, 0, 24, flat, unbanked }, { 16, 28, 0, 24, flat, unbanked }, { 16, 27, 0, 24, flat, unbanked }, { 16, 26, 0, 24, flat, unbanked },
    { 16, 25, 0, 24, flat, unbanked }, { 16, 24, 0, 24, flat, unbanked }, { 16, 23, 0, 24, up12, unbanked }, { 16, 22, 0, 24, up12, unbanked }, { 16, 21, 1, 24, up12, unbanked }, { 16, 20, 1, 24, up12, unbanked },
    { 16, 19, 1, 24, up12, unbanked }, { 16, 18, 1, 24, up12, unbanked }, { 16, 17, 1, 24, up12, unbanked }, { 16, 16, 1, 24, up12, unbanked }, { 16, 15, 2, 24, up12, unbanked }, { 16, 14, 2, 24, up12, unbanked },
    { 16, 13, 2, 24, up12, unbanked }, { 16, 12, 2, 24, up12, unbanked }, { 16, 11, 3, 24, up12, unbanked }, { 16, 10, 3, 24, up12, unbanked }, { 16,  9, 3, 24, up12, unbanked }, { 16,  8, 4, 24, up12, unbanked },
    { 16,  7, 4, 24, up25, unbanked }, { 16,  6, 5, 24, up25, unbanked }, { 16,  5, 5, 24, up25, unbanked }, { 16,  4, 6, 24, up25, unbanked }, { 16,  3, 6, 24, up25, unbanked }, { 16,  2, 7, 24, up25, unbanked },
    { 16,  1, 7, 24, up25, unbanked }, { 16,  0, 8, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0E3A, {
    { 31, 16,  0, 0, up25, unbanked }, { 30, 16,  0, 0, up25, unbanked }, { 29, 16,  1, 0, up25, unbanked }, { 28, 16,  1, 0, up25, unbanked }, { 27, 16,  2, 0, up25, unbanked }, { 26, 16,  3, 0, up25, unbanked },
    { 25, 16,  3, 0, up25, unbanked }, { 24, 16,  4, 0, up25, unbanked }, { 23, 16,  5, 0, up25, unbanked }, { 22, 16,  5, 0, up25, unbanked }, { 21, 16,  6, 0, up42, unbanked }, { 20, 16,  7, 0, up42, unbanked },
    { 19, 16,  8, 0, up42, unbanked }, { 18, 16,  8, 0, up42, unbanked }, { 17, 16,  9, 0, up42, unbanked }, { 16, 16, 10, 0, up42, unbanked }, { 15, 16, 11, 0, up42, unbanked }, { 14, 16, 12, 0, up42, unbanked },
    { 13, 16, 13, 0, up42, unbanked }, { 12, 16, 14, 0, up42, unbanked }, { 11, 16, 15, 0, up42, unbanked }, { 10, 16, 16, 0, up42, unbanked }, {  9, 16, 17, 0, up42, unbanked }, {  8, 16, 18, 0, up42, unbanked },
    {  8, 16, 19, 0, up42, unbanked }, {  7, 16, 20, 0, up42, unbanked }, {  6, 16, 21, 0, up42, unbanked }, {  5, 16, 22, 0, up60, unbanked }, {  5, 16, 23, 0, up60, unbanked }, {  4, 16, 24, 0, up60, unbanked },
    {  3, 16, 25, 0, up60, unbanked }, {  3, 16, 26, 0, up60, unbanked }, {  2, 16, 27, 0, up60, unbanked }, {  1, 16, 28, 0, up60, unbanked }, {  1, 16, 29, 0, up60, unbanked }, {  0, 16, 30, 0, up60, unbanked },
    {  0, 16, 31, 0, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0F89, {
    { 16,  0,  0, 8, up25, unbanked }, { 16,  1,  0, 8, up25, unbanked }, { 16,  2,  1, 8, up25, unbanked }, { 16,  3,  1, 8, up25, unbanked }, { 16,  4,  2, 8, up25, unbanked }, { 16,  5,  3, 8, up25, unbanked },
    { 16,  6,  3, 8, up25, unbanked }, { 16,  7,  4, 8, up25, unbanked }, { 16,  8,  5, 8, up25, unbanked }, { 16,  9,  5, 8, up25, unbanked }, { 16, 10,  6, 8, up42, unbanked }, { 16, 11,  7, 8, up42, unbanked },
    { 16, 12,  8, 8, up42, unbanked }, { 16, 13,  8, 8, up42, unbanked }, { 16, 14,  9, 8, up42, unbanked }, { 16, 15, 10, 8, up42, unbanked }, { 16, 16, 11, 8, up42, unbanked }, { 16, 17, 12, 8, up42, unbanked },
    { 16, 18, 13, 8, up42, unbanked }, { 16, 19, 14, 8, up42, unbanked }, { 16, 20, 15, 8, up42, unbanked }, { 16, 21, 16, 8, up42, unbanked }, { 16, 22, 17, 8, up42, unbanked }, { 16, 23, 18, 8, up42, unbanked },
    { 16, 23, 19, 8, up42, unbanked }, { 16, 24, 20, 8, up42, unbanked }, { 16, 25, 21, 8, up42, unbanked }, { 16, 26, 22, 8, up60, unbanked }, { 16, 26, 23, 8, up60, unbanked }, { 16, 27, 24, 8, up60, unbanked },
    { 16, 28, 25, 8, up60, unbanked }, { 16, 28, 26, 8, up60, unbanked }, { 16, 29, 27, 8, up60, unbanked }, { 16, 30, 28, 8, up60, unbanked }, { 16, 30, 29, 8, up60, unbanked }, { 16, 31, 30, 8, up60, unbanked },
    { 16, 31, 31, 8, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C10D8, {
    {  0, 16,  0, 16, up25, unbanked }, {  1, 16,  0, 16, up25, unbanked }, {  2, 16,  1, 16, up25, unbanked }, {  3, 16,  1, 16, up25, unbanked }, {  4, 16,  2, 16, up25, unbanked },
    {  5, 16,  3, 16, up25, unbanked }, {  6, 16,  3, 16, up25, unbanked }, {  7, 16,  4, 16, up25, unbanked }, {  8, 16,  5, 16, up25, unbanked }, {  9, 16,  5, 16, up25, unbanked },
    { 10, 16,  6, 16, up42, unbanked }, { 11, 16,  7, 16, up42, unbanked }, { 12, 16,  8, 16, up42, unbanked }, { 13, 16,  8, 16, up42, unbanked }, { 14, 16,  9, 16, up42, unbanked },
    { 15, 16, 10, 16, up42, unbanked }, { 16, 16, 11, 16, up42, unbanked }, { 17, 16, 12, 16, up42, unbanked }, { 18, 16, 13, 16, up42, unbanked }, { 19, 16, 14, 16, up42, unbanked },
    { 20, 16, 15, 16, up42, unbanked }, { 21, 16, 16, 16, up42, unbanked }, { 22, 16, 17, 16, up42, unbanked }, { 23, 16, 18, 16, up42, unbanked }, { 23, 16, 19, 16, up42, unbanked },
    { 24, 16, 20, 16, up42, unbanked }, { 25, 16, 21, 16, up42, unbanked }, { 26, 16, 22, 16, up60, unbanked }, { 26, 16, 23, 16, up60, unbanked }, { 27, 16, 24, 16, up60, unbanked },
    { 28, 16, 25, 16, up60, unbanked }, { 28, 16, 26, 16, up60, unbanked }, { 29, 16, 27, 16, up60, unbanked }, { 30, 16, 28, 16, up60, unbanked }, { 30, 16, 29, 16, up60, unbanked },
    { 31, 16, 30, 16, up60, unbanked }, { 31, 16, 31, 16, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1227, {
    { 16, 31,  0, 24, up25, unbanked }, { 16, 30,  0, 24, up25, unbanked }, { 16, 29,  1, 24, up25, unbanked }, { 16, 28,  1, 24, up25, unbanked }, { 16, 27,  2, 24, up25, unbanked },
    { 16, 26,  3, 24, up25, unbanked }, { 16, 25,  3, 24, up25, unbanked }, { 16, 24,  4, 24, up25, unbanked }, { 16, 23,  5, 24, up25, unbanked }, { 16, 22,  5, 24, up25, unbanked },
    { 16, 21,  6, 24, up42, unbanked }, { 16, 20,  7, 24, up42, unbanked }, { 16, 19,  8, 24, up42, unbanked }, { 16, 18,  8, 24, up42, unbanked }, { 16, 17,  9, 24, up42, unbanked },
    { 16, 16, 10, 24, up42, unbanked }, { 16, 15, 11, 24, up42, unbanked }, { 16, 14, 12, 24, up42, unbanked }, { 16, 13, 13, 24, up42, unbanked }, { 16, 12, 14, 24, up42, unbanked },
    { 16, 11, 15, 24, up42, unbanked }, { 16, 10, 16, 24, up42, unbanked }, { 16,  9, 17, 24, up42, unbanked }, { 16,  8, 18, 24, up42, unbanked }, { 16,  8, 19, 24, up42, unbanked },
    { 16,  7, 20, 24, up42, unbanked }, { 16,  6, 21, 24, up42, unbanked }, { 16,  5, 22, 24, up60, unbanked }, { 16,  5, 23, 24, up60, unbanked }, { 16,  4, 24, 24, up60, unbanked },
    { 16,  3, 25, 24, up60, unbanked }, { 16,  3, 26, 24, up60, unbanked }, { 16,  2, 27, 24, up60, unbanked }, { 16,  1, 28, 24, up60, unbanked }, { 16,  1, 29, 24, up60, unbanked },
    { 16,  0, 30, 24, up60, unbanked }, { 16,  0, 31, 24, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1376, {
    { 31, 16,  0, 0, up60, unbanked }, { 31, 16,  1, 0, up60, unbanked }, { 30, 16,  2, 0, up60, unbanked }, { 30, 16,  3, 0, up60, unbanked }, { 29, 16,  4, 0, up60, unbanked }, { 28, 16,  5, 0, up60, unbanked },
    { 28, 16,  6, 0, up60, unbanked }, { 27, 16,  7, 0, up60, unbanked }, { 26, 16,  8, 0, up60, unbanked }, { 26, 16,  9, 0, up60, unbanked }, { 25, 16, 10, 0, up42, unbanked }, { 24, 16, 11, 0, up42, unbanked },
    { 23, 16, 12, 0, up42, unbanked }, { 23, 16, 13, 0, up42, unbanked }, { 22, 16, 14, 0, up42, unbanked }, { 21, 16, 15, 0, up42, unbanked }, { 20, 16, 16, 0, up42, unbanked }, { 19, 16, 17, 0, up42, unbanked },
    { 18, 16, 18, 0, up42, unbanked }, { 17, 16, 19, 0, up42, unbanked }, { 16, 16, 20, 0, up42, unbanked }, { 15, 16, 21, 0, up42, unbanked }, { 14, 16, 22, 0, up42, unbanked }, { 13, 16, 23, 0, up42, unbanked },
    { 12, 16, 23, 0, up42, unbanked }, { 11, 16, 24, 0, up42, unbanked }, { 10, 16, 25, 0, up42, unbanked }, {  9, 16, 26, 0, up25, unbanked }, {  8, 16, 26, 0, up25, unbanked }, {  7, 16, 27, 0, up25, unbanked },
    {  6, 16, 28, 0, up25, unbanked }, {  5, 16, 28, 0, up25, unbanked }, {  4, 16, 29, 0, up25, unbanked }, {  3, 16, 30, 0, up25, unbanked }, {  2, 16, 30, 0, up25, unbanked }, {  1, 16, 31, 0, up25, unbanked },
    {  0, 16, 31, 0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C14C5, {
    { 16,  0,  0, 8, up60, unbanked }, { 16,  0,  1, 8, up60, unbanked }, { 16,  1,  2, 8, up60, unbanked }, { 16,  1,  3, 8, up60, unbanked }, { 16,  2,  4, 8, up60, unbanked }, { 16,  3,  5, 8, up60, unbanked },
    { 16,  3,  6, 8, up60, unbanked }, { 16,  4,  7, 8, up60, unbanked }, { 16,  5,  8, 8, up60, unbanked }, { 16,  5,  9, 8, up60, unbanked }, { 16,  6, 10, 8, up42, unbanked }, { 16,  7, 11, 8, up42, unbanked },
    { 16,  8, 12, 8, up42, unbanked }, { 16,  8, 13, 8, up42, unbanked }, { 16,  9, 14, 8, up42, unbanked }, { 16, 10, 15, 8, up42, unbanked }, { 16, 11, 16, 8, up42, unbanked }, { 16, 12, 17, 8, up42, unbanked },
    { 16, 13, 18, 8, up42, unbanked }, { 16, 14, 19, 8, up42, unbanked }, { 16, 15, 20, 8, up42, unbanked }, { 16, 16, 21, 8, up42, unbanked }, { 16, 17, 22, 8, up42, unbanked }, { 16, 18, 23, 8, up42, unbanked },
    { 16, 19, 23, 8, up42, unbanked }, { 16, 20, 24, 8, up42, unbanked }, { 16, 21, 25, 8, up42, unbanked }, { 16, 22, 26, 8, up25, unbanked }, { 16, 23, 26, 8, up25, unbanked }, { 16, 24, 27, 8, up25, unbanked },
    { 16, 25, 28, 8, up25, unbanked }, { 16, 26, 28, 8, up25, unbanked }, { 16, 27, 29, 8, up25, unbanked }, { 16, 28, 30, 8, up25, unbanked }, { 16, 29, 30, 8, up25, unbanked }, { 16, 30, 31, 8, up25, unbanked },
    { 16, 31, 31, 8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1614, {
    {  0, 16,  0, 16, up60, unbanked }, {  0, 16,  1, 16, up60, unbanked }, {  1, 16,  2, 16, up60, unbanked }, {  1, 16,  3, 16, up60, unbanked }, {  2, 16,  4, 16, up60, unbanked },
    {  3, 16,  5, 16, up60, unbanked }, {  3, 16,  6, 16, up60, unbanked }, {  4, 16,  7, 16, up60, unbanked }, {  5, 16,  8, 16, up60, unbanked }, {  5, 16,  9, 16, up60, unbanked },
    {  6, 16, 10, 16, up42, unbanked }, {  7, 16, 11, 16, up42, unbanked }, {  8, 16, 12, 16, up42, unbanked }, {  8, 16, 13, 16, up42, unbanked }, {  9, 16, 14, 16, up42, unbanked },
    { 10, 16, 15, 16, up42, unbanked }, { 11, 16, 16, 16, up42, unbanked }, { 12, 16, 17, 16, up42, unbanked }, { 13, 16, 18, 16, up42, unbanked }, { 14, 16, 19, 16, up42, unbanked },
    { 15, 16, 20, 16, up42, unbanked }, { 16, 16, 21, 16, up42, unbanked }, { 17, 16, 22, 16, up42, unbanked }, { 18, 16, 23, 16, up42, unbanked }, { 19, 16, 23, 16, up42, unbanked },
    { 20, 16, 24, 16, up42, unbanked }, { 21, 16, 25, 16, up42, unbanked }, { 22, 16, 26, 16, up25, unbanked }, { 23, 16, 26, 16, up25, unbanked }, { 24, 16, 27, 16, up25, unbanked },
    { 25, 16, 28, 16, up25, unbanked }, { 26, 16, 28, 16, up25, unbanked }, { 27, 16, 29, 16, up25, unbanked }, { 28, 16, 30, 16, up25, unbanked }, { 29, 16, 30, 16, up25, unbanked },
    { 30, 16, 31, 16, up25, unbanked }, { 31, 16, 31, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1763, {
    { 16, 31,  0, 24, up60, unbanked }, { 16, 31,  1, 24, up60, unbanked }, { 16, 30,  2, 24, up60, unbanked }, { 16, 30,  3, 24, up60, unbanked }, { 16, 29,  4, 24, up60, unbanked },
    { 16, 28,  5, 24, up60, unbanked }, { 16, 28,  6, 24, up60, unbanked }, { 16, 27,  7, 24, up60, unbanked }, { 16, 26,  8, 24, up60, unbanked }, { 16, 26,  9, 24, up60, unbanked },
    { 16, 25, 10, 24, up42, unbanked }, { 16, 24, 11, 24, up42, unbanked }, { 16, 23, 12, 24, up42, unbanked }, { 16, 23, 13, 24, up42, unbanked }, { 16, 22, 14, 24, up42, unbanked },
    { 16, 21, 15, 24, up42, unbanked }, { 16, 20, 16, 24, up42, unbanked }, { 16, 19, 17, 24, up42, unbanked }, { 16, 18, 18, 24, up42, unbanked }, { 16, 17, 19, 24, up42, unbanked },
    { 16, 16, 20, 24, up42, unbanked }, { 16, 15, 21, 24, up42, unbanked }, { 16, 14, 22, 24, up42, unbanked }, { 16, 13, 23, 24, up42, unbanked }, { 16, 12, 23, 24, up42, unbanked },
    { 16, 11, 24, 24, up42, unbanked }, { 16, 10, 25, 24, up42, unbanked }, { 16,  9, 26, 24, up25, unbanked }, { 16,  8, 26, 24, up25, unbanked }, { 16,  7, 27, 24, up25, unbanked },
    { 16,  6, 28, 24, up25, unbanked }, { 16,  5, 28, 24, up25, unbanked }, { 16,  4, 29, 24, up25, unbanked }, { 16,  3, 30, 24, up25, unbanked }, { 16,  2, 30, 24, up25, unbanked },
    { 16,  1, 31, 24, up25, unbanked }, { 16,  0, 31, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C00A2, {
    { 31, 16, 0, 0, up25, unbanked }, { 30, 16, 1, 0, up25, unbanked }, { 29, 16, 1, 0, up25, unbanked }, { 28, 16, 2, 0, up25, unbanked }, { 27, 16, 2, 0, up25, unbanked }, { 26, 16, 3, 0, up25, unbanked },
    { 25, 16, 3, 0, up25, unbanked }, { 24, 16, 3, 0, up25, unbanked }, { 23, 16, 4, 0, up12, unbanked }, { 22, 16, 4, 0, up12, unbanked }, { 21, 16, 4, 0, up12, unbanked }, { 20, 16, 5, 0, up12, unbanked },
    { 19, 16, 5, 0, up12, unbanked }, { 18, 16, 5, 0, up12, unbanked }, { 17, 16, 6, 0, up12, unbanked }, { 16, 16, 6, 0, up12, unbanked }, { 15, 16, 6, 0, up12, unbanked }, { 14, 16, 6, 0, up12, unbanked },
    { 13, 16, 7, 0, up12, unbanked }, { 12, 16, 7, 0, up12, unbanked }, { 11, 16, 7, 0, up12, unbanked }, { 10, 16, 7, 0, up12, unbanked }, {  9, 16, 7, 0, flat, unbanked }, {  8, 16, 7, 0, flat, unbanked },
    {  7, 16, 8, 0, flat, unbanked }, {  6, 16, 8, 0, flat, unbanked }, {  5, 16, 8, 0, flat, unbanked }, {  4, 16, 8, 0, flat, unbanked }, {  3, 16, 8, 0, flat, unbanked }, {  2, 16, 8, 0, flat, unbanked },
    {  1, 16, 8, 0, flat, unbanked }, {  0, 16, 8, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C01C4, {
    { 16,  0, 0, 8, up25, unbanked }, { 16,  1, 0, 8, up25, unbanked }, { 16,  2, 1, 8, up25, unbanked }, { 16,  3, 1, 8, up25, unbanked }, { 16,  4, 2, 8, up25, unbanked }, { 16,  5, 2, 8, up25, unbanked },
    { 16,  6, 3, 8, up25, unbanked }, { 16,  7, 3, 8, up25, unbanked }, { 16,  8, 4, 8, up12, unbanked }, { 16,  9, 4, 8, up12, unbanked }, { 16, 10, 4, 8, up12, unbanked }, { 16, 11, 5, 8, up12, unbanked },
    { 16, 12, 5, 8, up12, unbanked }, { 16, 13, 5, 8, up12, unbanked }, { 16, 14, 6, 8, up12, unbanked }, { 16, 15, 6, 8, up12, unbanked }, { 16, 16, 6, 8, up12, unbanked }, { 16, 17, 6, 8, up12, unbanked },
    { 16, 18, 7, 8, up12, unbanked }, { 16, 19, 7, 8, up12, unbanked }, { 16, 20, 7, 8, up12, unbanked }, { 16, 21, 7, 8, up12, unbanked }, { 16, 22, 7, 8, flat, unbanked }, { 16, 23, 7, 8, flat, unbanked },
    { 16, 24, 8, 8, flat, unbanked }, { 16, 25, 8, 8, flat, unbanked }, { 16, 26, 8, 8, flat, unbanked }, { 16, 27, 8, 8, flat, unbanked }, { 16, 28, 8, 8, flat, unbanked }, { 16, 29, 8, 8, flat, unbanked },
    { 16, 30, 8, 8, flat, unbanked }, { 16, 31, 8, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C02E6, {
    {  0, 16, 0, 16, up25, unbanked }, {  1, 16, 0, 16, up25, unbanked }, {  2, 16, 1, 16, up25, unbanked }, {  3, 16, 1, 16, up25, unbanked }, {  4, 16, 2, 16, up25, unbanked }, {  5, 16, 2, 16, up25, unbanked },
    {  6, 16, 3, 16, up25, unbanked }, {  7, 16, 3, 16, up25, unbanked }, {  8, 16, 4, 16, up12, unbanked }, {  9, 16, 4, 16, up12, unbanked }, { 10, 16, 4, 16, up12, unbanked }, { 11, 16, 5, 16, up12, unbanked },
    { 12, 16, 5, 16, up12, unbanked }, { 13, 16, 5, 16, up12, unbanked }, { 14, 16, 6, 16, up12, unbanked }, { 15, 16, 6, 16, up12, unbanked }, { 16, 16, 6, 16, up12, unbanked }, { 17, 16, 6, 16, up12, unbanked },
    { 18, 16, 7, 16, up12, unbanked }, { 19, 16, 7, 16, up12, unbanked }, { 20, 16, 7, 16, up12, unbanked }, { 21, 16, 7, 16, up12, unbanked }, { 22, 16, 7, 16, flat, unbanked }, { 23, 16, 7, 16, flat, unbanked },
    { 24, 16, 8, 16, flat, unbanked }, { 25, 16, 8, 16, flat, unbanked }, { 26, 16, 8, 16, flat, unbanked }, { 27, 16, 8, 16, flat, unbanked }, { 28, 16, 8, 16, flat, unbanked }, { 29, 16, 8, 16, flat, unbanked },
    { 30, 16, 8, 16, flat, unbanked }, { 31, 16, 8, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0408, {
    { 16, 31, 0, 24, up25, unbanked }, { 16, 30, 1, 24, up25, unbanked }, { 16, 29, 1, 24, up25, unbanked }, { 16, 28, 2, 24, up25, unbanked }, { 16, 27, 2, 24, up25, unbanked }, { 16, 26, 3, 24, up25, unbanked },
    { 16, 25, 3, 24, up25, unbanked }, { 16, 24, 3, 24, up25, unbanked }, { 16, 23, 4, 24, up12, unbanked }, { 16, 22, 4, 24, up12, unbanked }, { 16, 21, 4, 24, up12, unbanked }, { 16, 20, 5, 24, up12, unbanked },
    { 16, 19, 5, 24, up12, unbanked }, { 16, 18, 5, 24, up12, unbanked }, { 16, 17, 6, 24, up12, unbanked }, { 16, 16, 6, 24, up12, unbanked }, { 16, 15, 6, 24, up12, unbanked }, { 16, 14, 6, 24, up12, unbanked },
    { 16, 13, 7, 24, up12, unbanked }, { 16, 12, 7, 24, up12, unbanked }, { 16, 11, 7, 24, up12, unbanked }, { 16, 10, 7, 24, up12, unbanked }, { 16,  9, 7, 24, flat, unbanked }, { 16,  8, 7, 24, flat, unbanked },
    { 16,  7, 8, 24, flat, unbanked }, { 16,  6, 8, 24, flat, unbanked }, { 16,  5, 8, 24, flat, unbanked }, { 16,  4, 8, 24, flat, unbanked }, { 16,  3, 8, 24, flat, unbanked }, { 16,  2, 8, 24, flat, unbanked },
    { 16,  1, 8, 24, flat, unbanked }, { 16,  0, 8, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C27B2, {
    { 31, 16, 15, 0, down25, unbanked }, { 30, 16, 15, 0, down25, unbanked }, { 29, 16, 14, 0, down25, unbanked }, { 28, 16, 14, 0, down25, unbanked }, { 27, 16, 13, 0, down25, unbanked },
    { 26, 16, 13, 0, down25, unbanked }, { 25, 16, 12, 0, down25, unbanked }, { 24, 16, 12, 0, down25, unbanked }, { 23, 16, 11, 0, down25, unbanked }, { 22, 16, 11, 0, down25, unbanked },
    { 21, 16, 10, 0, down25, unbanked }, { 20, 16, 10, 0, down25, unbanked }, { 19, 16,  9, 0, down25, unbanked }, { 18, 16,  9, 0, down25, unbanked }, { 17, 16,  8, 0, down25, unbanked },
    { 16, 16,  8, 0, down25, unbanked }, { 15, 16,  7, 0, down25, unbanked }, { 14, 16,  7, 0, down25, unbanked }, { 13, 16,  6, 0, down25, unbanked }, { 12, 16,  6, 0, down25, unbanked },
    { 11, 16,  5, 0, down25, unbanked }, { 10, 16,  5, 0, down25, unbanked }, {  9, 16,  4, 0, down25, unbanked }, {  8, 16,  4, 0, down25, unbanked }, {  7, 16,  3, 0, down25, unbanked },
    {  6, 16,  3, 0, down25, unbanked }, {  5, 16,  2, 0, down25, unbanked }, {  4, 16,  2, 0, down25, unbanked }, {  3, 16,  1, 0, down25, unbanked }, {  2, 16,  1, 0, down25, unbanked },
    {  1, 16,  0, 0, down25, unbanked }, {  0, 16,  0, 0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C28D4, {
    { 16,  0, 15, 8, down25, unbanked }, { 16,  1, 14, 8, down25, unbanked }, { 16,  2, 14, 8, down25, unbanked }, { 16,  3, 13, 8, down25, unbanked }, { 16,  4, 13, 8, down25, unbanked },
    { 16,  5, 12, 8, down25, unbanked }, { 16,  6, 12, 8, down25, unbanked }, { 16,  7, 11, 8, down25, unbanked }, { 16,  8, 11, 8, down25, unbanked }, { 16,  9, 10, 8, down25, unbanked },
    { 16, 10, 10, 8, down25, unbanked }, { 16, 11,  9, 8, down25, unbanked }, { 16, 12,  9, 8, down25, unbanked }, { 16, 13,  8, 8, down25, unbanked }, { 16, 14,  8, 8, down25, unbanked },
    { 16, 15,  7, 8, down25, unbanked }, { 16, 16,  7, 8, down25, unbanked }, { 16, 17,  6, 8, down25, unbanked }, { 16, 18,  6, 8, down25, unbanked }, { 16, 19,  5, 8, down25, unbanked },
    { 16, 20,  5, 8, down25, unbanked }, { 16, 21,  4, 8, down25, unbanked }, { 16, 22,  4, 8, down25, unbanked }, { 16, 23,  3, 8, down25, unbanked }, { 16, 24,  3, 8, down25, unbanked },
    { 16, 25,  2, 8, down25, unbanked }, { 16, 26,  2, 8, down25, unbanked }, { 16, 27,  1, 8, down25, unbanked }, { 16, 28,  1, 8, down25, unbanked }, { 16, 29,  0, 8, down25, unbanked },
    { 16, 30,  0, 8, down25, unbanked }, { 16, 31, -1, 8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C29F6, {
    {  0, 16, 15, 16, down25, unbanked }, {  1, 16, 14, 16, down25, unbanked }, {  2, 16, 14, 16, down25, unbanked }, {  3, 16, 13, 16, down25, unbanked }, {  4, 16, 13, 16, down25, unbanked },
    {  5, 16, 12, 16, down25, unbanked }, {  6, 16, 12, 16, down25, unbanked }, {  7, 16, 11, 16, down25, unbanked }, {  8, 16, 11, 16, down25, unbanked }, {  9, 16, 10, 16, down25, unbanked },
    { 10, 16, 10, 16, down25, unbanked }, { 11, 16,  9, 16, down25, unbanked }, { 12, 16,  9, 16, down25, unbanked }, { 13, 16,  8, 16, down25, unbanked }, { 14, 16,  8, 16, down25, unbanked },
    { 15, 16,  7, 16, down25, unbanked }, { 16, 16,  7, 16, down25, unbanked }, { 17, 16,  6, 16, down25, unbanked }, { 18, 16,  6, 16, down25, unbanked }, { 19, 16,  5, 16, down25, unbanked },
    { 20, 16,  5, 16, down25, unbanked }, { 21, 16,  4, 16, down25, unbanked }, { 22, 16,  4, 16, down25, unbanked }, { 23, 16,  3, 16, down25, unbanked }, { 24, 16,  3, 16, down25, unbanked },
    { 25, 16,  2, 16, down25, unbanked }, { 26, 16,  2, 16, down25, unbanked }, { 27, 16,  1, 16, down25, unbanked }, { 28, 16,  1, 16, down25, unbanked }, { 29, 16,  0, 16, down25, unbanked },
    { 30, 16,  0, 16, down25, unbanked }, { 31, 16, -1, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2B18, {
    { 16, 31, 15, 24, down25, unbanked }, { 16, 30, 15, 24, down25, unbanked }, { 16, 29, 14, 24, down25, unbanked }, { 16, 28, 14, 24, down25, unbanked }, { 16, 27, 13, 24, down25, unbanked },
    { 16, 26, 13, 24, down25, unbanked }, { 16, 25, 12, 24, down25, unbanked }, { 16, 24, 12, 24, down25, unbanked }, { 16, 23, 11, 24, down25, unbanked }, { 16, 22, 11, 24, down25, unbanked },
    { 16, 21, 10, 24, down25, unbanked }, { 16, 20, 10, 24, down25, unbanked }, { 16, 19,  9, 24, down25, unbanked }, { 16, 18,  9, 24, down25, unbanked }, { 16, 17,  8, 24, down25, unbanked },
    { 16, 16,  8, 24, down25, unbanked }, { 16, 15,  7, 24, down25, unbanked }, { 16, 14,  7, 24, down25, unbanked }, { 16, 13,  6, 24, down25, unbanked }, { 16, 12,  6, 24, down25, unbanked },
    { 16, 11,  5, 24, down25, unbanked }, { 16, 10,  5, 24, down25, unbanked }, { 16,  9,  4, 24, down25, unbanked }, { 16,  8,  4, 24, down25, unbanked }, { 16,  7,  3, 24, down25, unbanked },
    { 16,  6,  3, 24, down25, unbanked }, { 16,  5,  2, 24, down25, unbanked }, { 16,  4,  2, 24, down25, unbanked }, { 16,  3,  1, 24, down25, unbanked }, { 16,  2,  1, 24, down25, unbanked },
    { 16,  1,  0, 24, down25, unbanked }, { 16,  0,  0, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2C3A, {
    { 31, 16, 63, 0, down60, unbanked }, { 31, 16, 62, 0, down60, unbanked }, { 30, 16, 61, 0, down60, unbanked }, { 30, 16, 60, 0, down60, unbanked }, { 29, 16, 59, 0, down60, unbanked },
    { 29, 16, 58, 0, down60, unbanked }, { 28, 16, 57, 0, down60, unbanked }, { 28, 16, 56, 0, down60, unbanked }, { 27, 16, 55, 0, down60, unbanked }, { 27, 16, 54, 0, down60, unbanked },
    { 26, 16, 53, 0, down60, unbanked }, { 26, 16, 52, 0, down60, unbanked }, { 25, 16, 51, 0, down60, unbanked }, { 25, 16, 50, 0, down60, unbanked }, { 24, 16, 49, 0, down60, unbanked },
    { 24, 16, 48, 0, down60, unbanked }, { 23, 16, 47, 0, down60, unbanked }, { 23, 16, 46, 0, down60, unbanked }, { 22, 16, 45, 0, down60, unbanked }, { 22, 16, 44, 0, down60, unbanked },
    { 21, 16, 43, 0, down60, unbanked }, { 21, 16, 42, 0, down60, unbanked }, { 20, 16, 41, 0, down60, unbanked }, { 20, 16, 40, 0, down60, unbanked }, { 19, 16, 39, 0, down60, unbanked },
    { 19, 16, 38, 0, down60, unbanked }, { 18, 16, 37, 0, down60, unbanked }, { 18, 16, 36, 0, down60, unbanked }, { 17, 16, 35, 0, down60, unbanked }, { 17, 16, 34, 0, down60, unbanked },
    { 16, 16, 33, 0, down60, unbanked }, { 16, 16, 32, 0, down60, unbanked }, { 15, 16, 31, 0, down60, unbanked }, { 15, 16, 30, 0, down60, unbanked }, { 14, 16, 29, 0, down60, unbanked },
    { 14, 16, 28, 0, down60, unbanked }, { 13, 16, 27, 0, down60, unbanked }, { 13, 16, 26, 0, down60, unbanked }, { 12, 16, 25, 0, down60, unbanked }, { 12, 16, 24, 0, down60, unbanked },
    { 11, 16, 23, 0, down60, unbanked }, { 11, 16, 22, 0, down60, unbanked }, { 10, 16, 21, 0, down60, unbanked }, { 10, 16, 20, 0, down60, unbanked }, {  9, 16, 19, 0, down60, unbanked },
    {  9, 16, 18, 0, down60, unbanked }, {  8, 16, 17, 0, down60, unbanked }, {  8, 16, 16, 0, down60, unbanked }, {  7, 16, 15, 0, down60, unbanked }, {  7, 16, 14, 0, down60, unbanked },
    {  6, 16, 13, 0, down60, unbanked }, {  6, 16, 12, 0, down60, unbanked }, {  5, 16, 11, 0, down60, unbanked }, {  5, 16, 10, 0, down60, unbanked }, {  4, 16,  9, 0, down60, unbanked },
    {  4, 16,  8, 0, down60, unbanked }, {  3, 16,  7, 0, down60, unbanked }, {  3, 16,  6, 0, down60, unbanked }, {  2, 16,  5, 0, down60, unbanked }, {  2, 16,  4, 0, down60, unbanked },
    {  1, 16,  3, 0, down60, unbanked }, {  1, 16,  2, 0, down60, unbanked }, {  0, 16,  1, 0, down60, unbanked }, {  0, 16,  0, 0, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2E7C, {
    { 16,  0, 63, 8, down60, unbanked }, { 16,  0, 62, 8, down60, unbanked }, { 16,  1, 61, 8, down60, unbanked }, { 16,  1, 60, 8, down60, unbanked }, { 16,  2, 59, 8, down60, unbanked },
    { 16,  2, 58, 8, down60, unbanked }, { 16,  3, 57, 8, down60, unbanked }, { 16,  3, 56, 8, down60, unbanked }, { 16,  4, 55, 8, down60, unbanked }, { 16,  4, 54, 8, down60, unbanked },
    { 16,  5, 53, 8, down60, unbanked }, { 16,  5, 52, 8, down60, unbanked }, { 16,  6, 51, 8, down60, unbanked }, { 16,  6, 50, 8, down60, unbanked }, { 16,  7, 49, 8, down60, unbanked },
    { 16,  7, 48, 8, down60, unbanked }, { 16,  8, 47, 8, down60, unbanked }, { 16,  8, 46, 8, down60, unbanked }, { 16,  9, 45, 8, down60, unbanked }, { 16,  9, 44, 8, down60, unbanked },
    { 16, 10, 43, 8, down60, unbanked }, { 16, 10, 42, 8, down60, unbanked }, { 16, 11, 41, 8, down60, unbanked }, { 16, 11, 40, 8, down60, unbanked }, { 16, 12, 39, 8, down60, unbanked },
    { 16, 12, 38, 8, down60, unbanked }, { 16, 13, 37, 8, down60, unbanked }, { 16, 13, 36, 8, down60, unbanked }, { 16, 14, 35, 8, down60, unbanked }, { 16, 14, 34, 8, down60, unbanked },
    { 16, 15, 33, 8, down60, unbanked }, { 16, 15, 32, 8, down60, unbanked }, { 16, 16, 31, 8, down60, unbanked }, { 16, 16, 30, 8, down60, unbanked }, { 16, 17, 29, 8, down60, unbanked },
    { 16, 17, 28, 8, down60, unbanked }, { 16, 18, 27, 8, down60, unbanked }, { 16, 18, 26, 8, down60, unbanked }, { 16, 19, 25, 8, down60, unbanked }, { 16, 19, 24, 8, down60, unbanked },
    { 16, 20, 23, 8, down60, unbanked }, { 16, 20, 22, 8, down60, unbanked }, { 16, 21, 21, 8, down60, unbanked }, { 16, 21, 20, 8, down60, unbanked }, { 16, 22, 19, 8, down60, unbanked },
    { 16, 22, 18, 8, down60, unbanked }, { 16, 23, 17, 8, down60, unbanked }, { 16, 23, 16, 8, down60, unbanked }, { 16, 24, 15, 8, down60, unbanked }, { 16, 24, 14, 8, down60, unbanked },
    { 16, 25, 13, 8, down60, unbanked }, { 16, 25, 12, 8, down60, unbanked }, { 16, 26, 11, 8, down60, unbanked }, { 16, 26, 10, 8, down60, unbanked }, { 16, 27,  9, 8, down60, unbanked },
    { 16, 27,  8, 8, down60, unbanked }, { 16, 28,  7, 8, down60, unbanked }, { 16, 28,  6, 8, down60, unbanked }, { 16, 29,  5, 8, down60, unbanked }, { 16, 29,  4, 8, down60, unbanked },
    { 16, 30,  3, 8, down60, unbanked }, { 16, 30,  2, 8, down60, unbanked }, { 16, 31,  1, 8, down60, unbanked }, { 16, 31,  0, 8, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C30BE, {
    {  0, 16, 63, 16, down60, unbanked }, {  0, 16, 62, 16, down60, unbanked }, {  1, 16, 61, 16, down60, unbanked }, {  1, 16, 60, 16, down60, unbanked }, {  2, 16, 59, 16, down60, unbanked },
    {  2, 16, 58, 16, down60, unbanked }, {  3, 16, 57, 16, down60, unbanked }, {  3, 16, 56, 16, down60, unbanked }, {  4, 16, 55, 16, down60, unbanked }, {  4, 16, 54, 16, down60, unbanked },
    {  5, 16, 53, 16, down60, unbanked }, {  5, 16, 52, 16, down60, unbanked }, {  6, 16, 51, 16, down60, unbanked }, {  6, 16, 50, 16, down60, unbanked }, {  7, 16, 49, 16, down60, unbanked },
    {  7, 16, 48, 16, down60, unbanked }, {  8, 16, 47, 16, down60, unbanked }, {  8, 16, 46, 16, down60, unbanked }, {  9, 16, 45, 16, down60, unbanked }, {  9, 16, 44, 16, down60, unbanked },
    { 10, 16, 43, 16, down60, unbanked }, { 10, 16, 42, 16, down60, unbanked }, { 11, 16, 41, 16, down60, unbanked }, { 11, 16, 40, 16, down60, unbanked }, { 12, 16, 39, 16, down60, unbanked },
    { 12, 16, 38, 16, down60, unbanked }, { 13, 16, 37, 16, down60, unbanked }, { 13, 16, 36, 16, down60, unbanked }, { 14, 16, 35, 16, down60, unbanked }, { 14, 16, 34, 16, down60, unbanked },
    { 15, 16, 33, 16, down60, unbanked }, { 15, 16, 32, 16, down60, unbanked }, { 16, 16, 31, 16, down60, unbanked }, { 16, 16, 30, 16, down60, unbanked }, { 17, 16, 29, 16, down60, unbanked },
    { 17, 16, 28, 16, down60, unbanked }, { 18, 16, 27, 16, down60, unbanked }, { 18, 16, 26, 16, down60, unbanked }, { 19, 16, 25, 16, down60, unbanked }, { 19, 16, 24, 16, down60, unbanked },
    { 20, 16, 23, 16, down60, unbanked }, { 20, 16, 22, 16, down60, unbanked }, { 21, 16, 21, 16, down60, unbanked }, { 21, 16, 20, 16, down60, unbanked }, { 22, 16, 19, 16, down60, unbanked },
    { 22, 16, 18, 16, down60, unbanked }, { 23, 16, 17, 16, down60, unbanked }, { 23, 16, 16, 16, down60, unbanked }, { 24, 16, 15, 16, down60, unbanked }, { 24, 16, 14, 16, down60, unbanked },
    { 25, 16, 13, 16, down60, unbanked }, { 25, 16, 12, 16, down60, unbanked }, { 26, 16, 11, 16, down60, unbanked }, { 26, 16, 10, 16, down60, unbanked }, { 27, 16,  9, 16, down60, unbanked },
    { 27, 16,  8, 16, down60, unbanked }, { 28, 16,  7, 16, down60, unbanked }, { 28, 16,  6, 16, down60, unbanked }, { 29, 16,  5, 16, down60, unbanked }, { 29, 16,  4, 16, down60, unbanked },
    { 30, 16,  3, 16, down60, unbanked }, { 30, 16,  2, 16, down60, unbanked }, { 31, 16,  1, 16, down60, unbanked }, { 31, 16,  0, 16, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3300, {
    { 16, 31, 63, 24, down60, unbanked }, { 16, 31, 62, 24, down60, unbanked }, { 16, 30, 61, 24, down60, unbanked }, { 16, 30, 60, 24, down60, unbanked }, { 16, 29, 59, 24, down60, unbanked },
    { 16, 29, 58, 24, down60, unbanked }, { 16, 28, 57, 24, down60, unbanked }, { 16, 28, 56, 24, down60, unbanked }, { 16, 27, 55, 24, down60, unbanked }, { 16, 27, 54, 24, down60, unbanked },
    { 16, 26, 53, 24, down60, unbanked }, { 16, 26, 52, 24, down60, unbanked }, { 16, 25, 51, 24, down60, unbanked }, { 16, 25, 50, 24, down60, unbanked }, { 16, 24, 49, 24, down60, unbanked },
    { 16, 24, 48, 24, down60, unbanked }, { 16, 23, 47, 24, down60, unbanked }, { 16, 23, 46, 24, down60, unbanked }, { 16, 22, 45, 24, down60, unbanked }, { 16, 22, 44, 24, down60, unbanked },
    { 16, 21, 43, 24, down60, unbanked }, { 16, 21, 42, 24, down60, unbanked }, { 16, 20, 41, 24, down60, unbanked }, { 16, 20, 40, 24, down60, unbanked }, { 16, 19, 39, 24, down60, unbanked },
    { 16, 19, 38, 24, down60, unbanked }, { 16, 18, 37, 24, down60, unbanked }, { 16, 18, 36, 24, down60, unbanked }, { 16, 17, 35, 24, down60, unbanked }, { 16, 17, 34, 24, down60, unbanked },
    { 16, 16, 33, 24, down60, unbanked }, { 16, 16, 32, 24, down60, unbanked }, { 16, 15, 31, 24, down60, unbanked }, { 16, 15, 30, 24, down60, unbanked }, { 16, 14, 29, 24, down60, unbanked },
    { 16, 14, 28, 24, down60, unbanked }, { 16, 13, 27, 24, down60, unbanked }, { 16, 13, 26, 24, down60, unbanked }, { 16, 12, 25, 24, down60, unbanked }, { 16, 12, 24, 24, down60, unbanked },
    { 16, 11, 23, 24, down60, unbanked }, { 16, 11, 22, 24, down60, unbanked }, { 16, 10, 21, 24, down60, unbanked }, { 16, 10, 20, 24, down60, unbanked }, { 16,  9, 19, 24, down60, unbanked },
    { 16,  9, 18, 24, down60, unbanked }, { 16,  8, 17, 24, down60, unbanked }, { 16,  8, 16, 24, down60, unbanked }, { 16,  7, 15, 24, down60, unbanked }, { 16,  7, 14, 24, down60, unbanked },
    { 16,  6, 13, 24, down60, unbanked }, { 16,  6, 12, 24, down60, unbanked }, { 16,  5, 11, 24, down60, unbanked }, { 16,  5, 10, 24, down60, unbanked }, { 16,  4,  9, 24, down60, unbanked },
    { 16,  4,  8, 24, down60, unbanked }, { 16,  3,  7, 24, down60, unbanked }, { 16,  3,  6, 24, down60, unbanked }, { 16,  2,  5, 24, down60, unbanked }, { 16,  2,  4, 24, down60, unbanked },
    { 16,  1,  3, 24, down60, unbanked }, { 16,  1,  2, 24, down60, unbanked }, { 16,  0,  1, 24, down60, unbanked }, { 16,  0,  0, 24, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C09B2, {
    { 31, 16, 8, 0,   flat, unbanked }, { 30, 16, 8, 0,   flat, unbanked }, { 29, 16, 8, 0,   flat, unbanked }, { 28, 16, 8, 0,   flat, unbanked }, { 27, 16, 8, 0,   flat, unbanked },
    { 26, 16, 8, 0,   flat, unbanked }, { 25, 16, 8, 0,   flat, unbanked }, { 24, 16, 8, 0,   flat, unbanked }, { 23, 16, 7, 0, down12, unbanked }, { 22, 16, 7, 0, down12, unbanked },
    { 21, 16, 7, 0, down12, unbanked }, { 20, 16, 7, 0, down12, unbanked }, { 19, 16, 7, 0, down12, unbanked }, { 18, 16, 7, 0, down12, unbanked }, { 17, 16, 6, 0, down12, unbanked },
    { 16, 16, 6, 0, down12, unbanked }, { 15, 16, 6, 0, down12, unbanked }, { 14, 16, 6, 0, down12, unbanked }, { 13, 16, 5, 0, down12, unbanked }, { 12, 16, 5, 0, down12, unbanked },
    { 11, 16, 5, 0, down12, unbanked }, { 10, 16, 4, 0, down12, unbanked }, {  9, 16, 4, 0, down12, unbanked }, {  8, 16, 4, 0, down12, unbanked }, {  7, 16, 3, 0, down25, unbanked },
    {  6, 16, 3, 0, down25, unbanked }, {  5, 16, 2, 0, down25, unbanked }, {  4, 16, 2, 0, down25, unbanked }, {  3, 16, 1, 0, down25, unbanked }, {  2, 16, 1, 0, down25, unbanked },
    {  1, 16, 0, 0, down25, unbanked }, {  0, 16, 0, 0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0AD4, {
    { 16,  0, 8, 8,   flat, unbanked }, { 16,  1, 8, 8,   flat, unbanked }, { 16,  2, 8, 8,   flat, unbanked }, { 16,  3, 8, 8,   flat, unbanked }, { 16,  4, 8, 8,   flat, unbanked },
    { 16,  5, 8, 8,   flat, unbanked }, { 16,  6, 8, 8,   flat, unbanked }, { 16,  7, 8, 8,   flat, unbanked }, { 16,  8, 7, 8, down12, unbanked }, { 16,  9, 7, 8, down12, unbanked },
    { 16, 10, 7, 8, down12, unbanked }, { 16, 11, 7, 8, down12, unbanked }, { 16, 12, 7, 8, down12, unbanked }, { 16, 13, 7, 8, down12, unbanked }, { 16, 14, 6, 8, down12, unbanked },
    { 16, 15, 6, 8, down12, unbanked }, { 16, 16, 6, 8, down12, unbanked }, { 16, 17, 6, 8, down12, unbanked }, { 16, 18, 5, 8, down12, unbanked }, { 16, 19, 5, 8, down12, unbanked },
    { 16, 20, 5, 8, down12, unbanked }, { 16, 21, 4, 8, down12, unbanked }, { 16, 22, 4, 8, down12, unbanked }, { 16, 23, 4, 8, down12, unbanked }, { 16, 24, 3, 8, down25, unbanked },
    { 16, 25, 3, 8, down25, unbanked }, { 16, 26, 3, 8, down25, unbanked }, { 16, 27, 2, 8, down25, unbanked }, { 16, 28, 2, 8, down25, unbanked }, { 16, 29, 1, 8, down25, unbanked },
    { 16, 30, 1, 8, down25, unbanked }, { 16, 31, 0, 8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0BF6, {
    {  0, 16, 8, 16,   flat, unbanked }, {  1, 16, 8, 16,   flat, unbanked }, {  2, 16, 8, 16,   flat, unbanked }, {  3, 16, 8, 16,   flat, unbanked }, {  4, 16, 8, 16,   flat, unbanked },
    {  5, 16, 8, 16,   flat, unbanked }, {  6, 16, 8, 16,   flat, unbanked }, {  7, 16, 8, 16,   flat, unbanked }, {  8, 16, 7, 16, down12, unbanked }, {  9, 16, 7, 16, down12, unbanked },
    { 10, 16, 7, 16, down12, unbanked }, { 11, 16, 7, 16, down12, unbanked }, { 12, 16, 7, 16, down12, unbanked }, { 13, 16, 7, 16, down12, unbanked }, { 14, 16, 6, 16, down12, unbanked },
    { 15, 16, 6, 16, down12, unbanked }, { 16, 16, 6, 16, down12, unbanked }, { 17, 16, 6, 16, down12, unbanked }, { 18, 16, 5, 16, down12, unbanked }, { 19, 16, 5, 16, down12, unbanked },
    { 20, 16, 5, 16, down12, unbanked }, { 21, 16, 4, 16, down12, unbanked }, { 22, 16, 4, 16, down12, unbanked }, { 23, 16, 4, 16, down12, unbanked }, { 24, 16, 3, 16, down25, unbanked },
    { 25, 16, 3, 16, down25, unbanked }, { 26, 16, 3, 16, down25, unbanked }, { 27, 16, 2, 16, down25, unbanked }, { 28, 16, 2, 16, down25, unbanked }, { 29, 16, 1, 16, down25, unbanked },
    { 30, 16, 1, 16, down25, unbanked }, { 31, 16, 0, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0D18, {
    { 16, 31, 8, 24,   flat, unbanked }, { 16, 30, 8, 24,   flat, unbanked }, { 16, 29, 8, 24,   flat, unbanked }, { 16, 28, 8, 24,   flat, unbanked }, { 16, 27, 8, 24,   flat, unbanked },
    { 16, 26, 8, 24,   flat, unbanked }, { 16, 25, 8, 24,   flat, unbanked }, { 16, 24, 8, 24,   flat, unbanked }, { 16, 23, 7, 24, down12, unbanked }, { 16, 22, 7, 24, down12, unbanked },
    { 16, 21, 7, 24, down12, unbanked }, { 16, 20, 7, 24, down12, unbanked }, { 16, 19, 7, 24, down12, unbanked }, { 16, 18, 7, 24, down12, unbanked }, { 16, 17, 6, 24, down12, unbanked },
    { 16, 16, 6, 24, down12, unbanked }, { 16, 15, 6, 24, down12, unbanked }, { 16, 14, 6, 24, down12, unbanked }, { 16, 13, 5, 24, down12, unbanked }, { 16, 12, 5, 24, down12, unbanked },
    { 16, 11, 5, 24, down12, unbanked }, { 16, 10, 4, 24, down12, unbanked }, { 16,  9, 4, 24, down12, unbanked }, { 16,  8, 4, 24, down12, unbanked }, { 16,  7, 3, 24, down25, unbanked },
    { 16,  6, 3, 24, down25, unbanked }, { 16,  5, 2, 24, down25, unbanked }, { 16,  4, 2, 24, down25, unbanked }, { 16,  3, 1, 24, down25, unbanked }, { 16,  2, 1, 24, down25, unbanked },
    { 16,  1, 0, 24, down25, unbanked }, { 16,  0, 0, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1DEE, {
    { 31, 16, 31, 0, down25, unbanked }, { 30, 16, 31, 0, down25, unbanked }, { 29, 16, 30, 0, down25, unbanked }, { 28, 16, 30, 0, down25, unbanked }, { 27, 16, 29, 0, down25, unbanked },
    { 26, 16, 28, 0, down25, unbanked }, { 25, 16, 28, 0, down25, unbanked }, { 24, 16, 27, 0, down25, unbanked }, { 23, 16, 26, 0, down25, unbanked }, { 22, 16, 26, 0, down25, unbanked },
    { 21, 16, 25, 0, down42, unbanked }, { 20, 16, 24, 0, down42, unbanked }, { 19, 16, 23, 0, down42, unbanked }, { 18, 16, 23, 0, down42, unbanked }, { 17, 16, 22, 0, down42, unbanked },
    { 16, 16, 21, 0, down42, unbanked }, { 15, 16, 20, 0, down42, unbanked }, { 14, 16, 19, 0, down42, unbanked }, { 13, 16, 18, 0, down42, unbanked }, { 12, 16, 16, 0, down42, unbanked },
    { 11, 16, 15, 0, down42, unbanked }, { 10, 16, 14, 0, down42, unbanked }, {  9, 16, 13, 0, down42, unbanked }, {  8, 16, 12, 0, down42, unbanked }, {  8, 16, 11, 0, down42, unbanked },
    {  7, 16, 10, 0, down42, unbanked }, {  6, 16,  9, 0, down42, unbanked }, {  5, 16,  8, 0, down60, unbanked }, {  5, 16,  7, 0, down60, unbanked }, {  4, 16,  6, 0, down60, unbanked },
    {  3, 16,  5, 0, down60, unbanked }, {  3, 16,  4, 0, down60, unbanked }, {  2, 16,  3, 0, down60, unbanked }, {  1, 16,  2, 0, down60, unbanked }, {  1, 16,  1, 0, down60, unbanked },
    {  0, 16,  0, 0, down60, unbanked }, {  0, 16, -1, 0, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1F3D, {
    { 16,  0, 31, 8, down25, unbanked }, { 16,  1, 31, 8, down25, unbanked }, { 16,  2, 30, 8, down25, unbanked }, { 16,  3, 30, 8, down25, unbanked }, { 16,  4, 29, 8, down25, unbanked },
    { 16,  5, 28, 8, down25, unbanked }, { 16,  6, 28, 8, down25, unbanked }, { 16,  7, 27, 8, down25, unbanked }, { 16,  8, 26, 8, down25, unbanked }, { 16,  9, 26, 8, down25, unbanked },
    { 16, 10, 25, 8, down42, unbanked }, { 16, 11, 24, 8, down42, unbanked }, { 16, 12, 23, 8, down42, unbanked }, { 16, 13, 23, 8, down42, unbanked }, { 16, 14, 22, 8, down42, unbanked },
    { 16, 15, 21, 8, down42, unbanked }, { 16, 16, 20, 8, down42, unbanked }, { 16, 17, 19, 8, down42, unbanked }, { 16, 18, 18, 8, down42, unbanked }, { 16, 19, 16, 8, down42, unbanked },
    { 16, 20, 15, 8, down42, unbanked }, { 16, 21, 14, 8, down42, unbanked }, { 16, 22, 13, 8, down42, unbanked }, { 16, 23, 12, 8, down42, unbanked }, { 16, 23, 11, 8, down42, unbanked },
    { 16, 24, 10, 8, down42, unbanked }, { 16, 25,  9, 8, down42, unbanked }, { 16, 26,  8, 8, down60, unbanked }, { 16, 26,  7, 8, down60, unbanked }, { 16, 27,  6, 8, down60, unbanked },
    { 16, 28,  5, 8, down60, unbanked }, { 16, 28,  4, 8, down60, unbanked }, { 16, 29,  3, 8, down60, unbanked }, { 16, 30,  2, 8, down60, unbanked }, { 16, 30,  1, 8, down60, unbanked },
    { 16, 31,  0, 8, down60, unbanked }, { 16, 31, -1, 8, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C208C, {
    {  0, 16, 31, 16, down25, unbanked }, {  1, 16, 31, 16, down25, unbanked }, {  2, 16, 30, 16, down25, unbanked }, {  3, 16, 30, 16, down25, unbanked }, {  4, 16, 29, 16, down25, unbanked },
    {  5, 16, 28, 16, down25, unbanked }, {  6, 16, 28, 16, down25, unbanked }, {  7, 16, 27, 16, down25, unbanked }, {  8, 16, 26, 16, down25, unbanked }, {  9, 16, 26, 16, down25, unbanked },
    { 10, 16, 25, 16, down42, unbanked }, { 11, 16, 24, 16, down42, unbanked }, { 12, 16, 23, 16, down42, unbanked }, { 13, 16, 23, 16, down42, unbanked }, { 14, 16, 22, 16, down42, unbanked },
    { 15, 16, 21, 16, down42, unbanked }, { 16, 16, 20, 16, down42, unbanked }, { 17, 16, 19, 16, down42, unbanked }, { 18, 16, 18, 16, down42, unbanked }, { 19, 16, 16, 16, down42, unbanked },
    { 20, 16, 15, 16, down42, unbanked }, { 21, 16, 14, 16, down42, unbanked }, { 22, 16, 13, 16, down42, unbanked }, { 23, 16, 12, 16, down42, unbanked }, { 23, 16, 11, 16, down42, unbanked },
    { 24, 16, 10, 16, down42, unbanked }, { 25, 16,  9, 16, down42, unbanked }, { 26, 16,  8, 16, down60, unbanked }, { 26, 16,  7, 16, down60, unbanked }, { 27, 16,  6, 16, down60, unbanked },
    { 28, 16,  5, 16, down60, unbanked }, { 28, 16,  4, 16, down60, unbanked }, { 29, 16,  3, 16, down60, unbanked }, { 30, 16,  2, 16, down60, unbanked }, { 30, 16,  1, 16, down60, unbanked },
    { 31, 16,  0, 16, down60, unbanked }, { 31, 16, -1, 16, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C21DB, {
    { 16, 31, 31, 24, down25, unbanked }, { 16, 30, 31, 24, down25, unbanked }, { 16, 29, 30, 24, down25, unbanked }, { 16, 28, 30, 24, down25, unbanked }, { 16, 27, 29, 24, down25, unbanked },
    { 16, 26, 28, 24, down25, unbanked }, { 16, 25, 28, 24, down25, unbanked }, { 16, 24, 27, 24, down25, unbanked }, { 16, 23, 26, 24, down25, unbanked }, { 16, 22, 26, 24, down25, unbanked },
    { 16, 21, 25, 24, down42, unbanked }, { 16, 20, 24, 24, down42, unbanked }, { 16, 19, 23, 24, down42, unbanked }, { 16, 18, 23, 24, down42, unbanked }, { 16, 17, 22, 24, down42, unbanked },
    { 16, 16, 21, 24, down42, unbanked }, { 16, 15, 20, 24, down42, unbanked }, { 16, 14, 19, 24, down42, unbanked }, { 16, 13, 18, 24, down42, unbanked }, { 16, 12, 16, 24, down42, unbanked },
    { 16, 11, 15, 24, down42, unbanked }, { 16, 10, 14, 24, down42, unbanked }, { 16,  9, 13, 24, down42, unbanked }, { 16,  8, 12, 24, down42, unbanked }, { 16,  8, 11, 24, down42, unbanked },
    { 16,  7, 10, 24, down42, unbanked }, { 16,  6,  9, 24, down42, unbanked }, { 16,  5,  8, 24, down60, unbanked }, { 16,  5,  7, 24, down60, unbanked }, { 16,  4,  6, 24, down60, unbanked },
    { 16,  3,  5, 24, down60, unbanked }, { 16,  3,  4, 24, down60, unbanked }, { 16,  2,  3, 24, down60, unbanked }, { 16,  1,  2, 24, down60, unbanked }, { 16,  1,  1, 24, down60, unbanked },
    { 16,  0,  0, 24, down60, unbanked }, { 16,  0, -1, 24, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C18B2, {
    { 31, 16, 31, 0, down60, unbanked }, { 31, 16, 30, 0, down60, unbanked }, { 30, 16, 29, 0, down60, unbanked }, { 30, 16, 28, 0, down60, unbanked }, { 29, 16, 27, 0, down60, unbanked },
    { 28, 16, 26, 0, down60, unbanked }, { 28, 16, 25, 0, down60, unbanked }, { 27, 16, 24, 0, down60, unbanked }, { 26, 16, 23, 0, down60, unbanked }, { 26, 16, 22, 0, down60, unbanked },
    { 25, 16, 21, 0, down42, unbanked }, { 24, 16, 20, 0, down42, unbanked }, { 23, 16, 19, 0, down42, unbanked }, { 23, 16, 18, 0, down42, unbanked }, { 22, 16, 17, 0, down42, unbanked },
    { 21, 16, 16, 0, down42, unbanked }, { 20, 16, 15, 0, down42, unbanked }, { 19, 16, 14, 0, down42, unbanked }, { 18, 16, 13, 0, down42, unbanked }, { 16, 16, 12, 0, down42, unbanked },
    { 15, 16, 11, 0, down42, unbanked }, { 14, 16, 10, 0, down42, unbanked }, { 13, 16,  9, 0, down42, unbanked }, { 12, 16,  8, 0, down42, unbanked }, { 11, 16,  8, 0, down42, unbanked },
    { 10, 16,  7, 0, down42, unbanked }, {  9, 16,  6, 0, down42, unbanked }, {  8, 16,  5, 0, down25, unbanked }, {  7, 16,  5, 0, down25, unbanked }, {  6, 16,  4, 0, down25, unbanked },
    {  5, 16,  3, 0, down25, unbanked }, {  4, 16,  3, 0, down25, unbanked }, {  3, 16,  2, 0, down25, unbanked }, {  2, 16,  1, 0, down25, unbanked }, {  1, 16,  1, 0, down25, unbanked },
    {  0, 16,  0, 0, down25, unbanked }, { -1, 16,  0, 0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1A01, {
    { 16,  0, 31, 8, down60, unbanked }, { 16,  0, 30, 8, down60, unbanked }, { 16,  1, 29, 8, down60, unbanked }, { 16,  1, 28, 8, down60, unbanked }, { 16,  2, 27, 8, down60, unbanked },
    { 16,  3, 26, 8, down60, unbanked }, { 16,  3, 25, 8, down60, unbanked }, { 16,  4, 24, 8, down60, unbanked }, { 16,  5, 23, 8, down60, unbanked }, { 16,  5, 22, 8, down60, unbanked },
    { 16,  6, 21, 8, down42, unbanked }, { 16,  7, 20, 8, down42, unbanked }, { 16,  8, 19, 8, down42, unbanked }, { 16,  8, 18, 8, down42, unbanked }, { 16,  9, 17, 8, down42, unbanked },
    { 16, 10, 16, 8, down42, unbanked }, { 16, 11, 15, 8, down42, unbanked }, { 16, 12, 14, 8, down42, unbanked }, { 16, 13, 13, 8, down42, unbanked }, { 16, 15, 12, 8, down42, unbanked },
    { 16, 16, 11, 8, down42, unbanked }, { 16, 17, 10, 8, down42, unbanked }, { 16, 18,  9, 8, down42, unbanked }, { 16, 19,  8, 8, down42, unbanked }, { 16, 20,  8, 8, down42, unbanked },
    { 16, 21,  7, 8, down42, unbanked }, { 16, 22,  6, 8, down42, unbanked }, { 16, 23,  5, 8, down25, unbanked }, { 16, 24,  5, 8, down25, unbanked }, { 16, 25,  4, 8, down25, unbanked },
    { 16, 26,  3, 8, down25, unbanked }, { 16, 27,  3, 8, down25, unbanked }, { 16, 28,  2, 8, down25, unbanked }, { 16, 29,  1, 8, down25, unbanked }, { 16, 30,  1, 8, down25, unbanked },
    { 16, 31,  0, 8, down25, unbanked }, { 16, 32,  0, 8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1B50, {
    {  0, 16, 31, 16, down60, unbanked }, {  0, 16, 30, 16, down60, unbanked }, {  1, 16, 29, 16, down60, unbanked }, {  1, 16, 28, 16, down60, unbanked }, {  2, 16, 27, 16, down60, unbanked },
    {  3, 16, 26, 16, down60, unbanked }, {  3, 16, 25, 16, down60, unbanked }, {  4, 16, 24, 16, down60, unbanked }, {  5, 16, 23, 16, down60, unbanked }, {  5, 16, 22, 16, down60, unbanked },
    {  6, 16, 21, 16, down42, unbanked }, {  7, 16, 20, 16, down42, unbanked }, {  8, 16, 19, 16, down42, unbanked }, {  8, 16, 18, 16, down42, unbanked }, {  9, 16, 17, 16, down42, unbanked },
    { 10, 16, 16, 16, down42, unbanked }, { 11, 16, 15, 16, down42, unbanked }, { 12, 16, 14, 16, down42, unbanked }, { 13, 16, 13, 16, down42, unbanked }, { 15, 16, 12, 16, down42, unbanked },
    { 16, 16, 11, 16, down42, unbanked }, { 17, 16, 10, 16, down42, unbanked }, { 18, 16,  9, 16, down42, unbanked }, { 19, 16,  8, 16, down42, unbanked }, { 20, 16,  8, 16, down42, unbanked },
    { 21, 16,  7, 16, down42, unbanked }, { 22, 16,  6, 16, down42, unbanked }, { 23, 16,  5, 16, down25, unbanked }, { 24, 16,  5, 16, down25, unbanked }, { 25, 16,  4, 16, down25, unbanked },
    { 26, 16,  3, 16, down25, unbanked }, { 27, 16,  3, 16, down25, unbanked }, { 28, 16,  2, 16, down25, unbanked }, { 29, 16,  1, 16, down25, unbanked }, { 30, 16,  1, 16, down25, unbanked },
    { 31, 16,  0, 16, down25, unbanked }, { 32, 16,  0, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1C9F, {
    { 16, 31, 31, 24, down60, unbanked }, { 16, 31, 30, 24, down60, unbanked }, { 16, 30, 29, 24, down60, unbanked }, { 16, 30, 28, 24, down60, unbanked }, { 16, 29, 27, 24, down60, unbanked },
    { 16, 28, 26, 24, down60, unbanked }, { 16, 28, 25, 24, down60, unbanked }, { 16, 27, 24, 24, down60, unbanked }, { 16, 26, 23, 24, down60, unbanked }, { 16, 26, 22, 24, down60, unbanked },
    { 16, 25, 21, 24, down42, unbanked }, { 16, 24, 20, 24, down42, unbanked }, { 16, 23, 19, 24, down42, unbanked }, { 16, 23, 18, 24, down42, unbanked }, { 16, 22, 17, 24, down42, unbanked },
    { 16, 21, 16, 24, down42, unbanked }, { 16, 20, 15, 24, down42, unbanked }, { 16, 19, 14, 24, down42, unbanked }, { 16, 18, 13, 24, down42, unbanked }, { 16, 16, 12, 24, down42, unbanked },
    { 16, 15, 11, 24, down42, unbanked }, { 16, 14, 10, 24, down42, unbanked }, { 16, 13,  9, 24, down42, unbanked }, { 16, 12,  8, 24, down42, unbanked }, { 16, 11,  8, 24, down42, unbanked },
    { 16, 10,  7, 24, down42, unbanked }, { 16,  9,  6, 24, down42, unbanked }, { 16,  8,  5, 24, down25, unbanked }, { 16,  7,  5, 24, down25, unbanked }, { 16,  6,  4, 24, down25, unbanked },
    { 16,  5,  3, 24, down25, unbanked }, { 16,  4,  3, 24, down25, unbanked }, { 16,  3,  2, 24, down25, unbanked }, { 16,  2,  1, 24, down25, unbanked }, { 16,  1,  1, 24, down25, unbanked },
    { 16,  0,  0, 24, down25, unbanked }, { 16, -1,  0, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C052A, {
    { 31, 16, 7, 0, down25, unbanked }, { 30, 16, 7, 0, down25, unbanked }, { 29, 16, 6, 0, down25, unbanked }, { 28, 16, 6, 0, down25, unbanked }, { 27, 16, 5, 0, down25, unbanked },
    { 26, 16, 5, 0, down25, unbanked }, { 25, 16, 4, 0, down25, unbanked }, { 24, 16, 4, 0, down25, unbanked }, { 23, 16, 4, 0, down12, unbanked }, { 22, 16, 3, 0, down12, unbanked },
    { 21, 16, 3, 0, down12, unbanked }, { 20, 16, 3, 0, down12, unbanked }, { 19, 16, 2, 0, down12, unbanked }, { 18, 16, 2, 0, down12, unbanked }, { 17, 16, 2, 0, down12, unbanked },
    { 16, 16, 2, 0, down12, unbanked }, { 15, 16, 1, 0, down12, unbanked }, { 14, 16, 1, 0, down12, unbanked }, { 13, 16, 1, 0, down12, unbanked }, { 12, 16, 1, 0, down12, unbanked },
    { 11, 16, 1, 0, down12, unbanked }, { 10, 16, 1, 0, down12, unbanked }, {  9, 16, 0, 0,   flat, unbanked }, {  8, 16, 0, 0,   flat, unbanked }, {  7, 16, 0, 0,   flat, unbanked },
    {  6, 16, 0, 0,   flat, unbanked }, {  5, 16, 0, 0,   flat, unbanked }, {  4, 16, 0, 0,   flat, unbanked }, {  3, 16, 0, 0,   flat, unbanked }, {  2, 16, 0, 0,   flat, unbanked },
    {  1, 16, 0, 0,   flat, unbanked }, {  0, 16, 0, 0,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C064C, {
    { 16,  0, 8, 8, down25, unbanked }, { 16,  1, 7, 8, down25, unbanked }, { 16,  2, 7, 8, down25, unbanked }, { 16,  3, 6, 8, down25, unbanked }, { 16,  4, 6, 8, down25, unbanked },
    { 16,  5, 5, 8, down25, unbanked }, { 16,  6, 5, 8, down25, unbanked }, { 16,  7, 4, 8, down25, unbanked }, { 16,  8, 4, 8, down12, unbanked }, { 16,  9, 3, 8, down12, unbanked },
    { 16, 10, 3, 8, down12, unbanked }, { 16, 11, 3, 8, down12, unbanked }, { 16, 12, 2, 8, down12, unbanked }, { 16, 13, 2, 8, down12, unbanked }, { 16, 14, 2, 8, down12, unbanked },
    { 16, 15, 2, 8, down12, unbanked }, { 16, 16, 1, 8, down12, unbanked }, { 16, 17, 1, 8, down12, unbanked }, { 16, 18, 1, 8, down12, unbanked }, { 16, 19, 1, 8, down12, unbanked },
    { 16, 20, 1, 8, down12, unbanked }, { 16, 21, 1, 8, down12, unbanked }, { 16, 22, 0, 8,   flat, unbanked }, { 16, 23, 0, 8,   flat, unbanked }, { 16, 24, 0, 8,   flat, unbanked },
    { 16, 25, 0, 8,   flat, unbanked }, { 16, 26, 0, 8,   flat, unbanked }, { 16, 27, 0, 8,   flat, unbanked }, { 16, 28, 0, 8,   flat, unbanked }, { 16, 29, 0, 8,   flat, unbanked },
    { 16, 30, 0, 8,   flat, unbanked }, { 16, 31, 0, 8,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C076E, {
    {  0, 16, 8, 16, down25, unbanked }, {  1, 16, 7, 16, down25, unbanked }, {  2, 16, 7, 16, down25, unbanked }, {  3, 16, 6, 16, down25, unbanked }, {  4, 16, 6, 16, down25, unbanked },
    {  5, 16, 5, 16, down25, unbanked }, {  6, 16, 5, 16, down25, unbanked }, {  7, 16, 4, 16, down25, unbanked }, {  8, 16, 4, 16, down12, unbanked }, {  9, 16, 3, 16, down12, unbanked },
    { 10, 16, 3, 16, down12, unbanked }, { 11, 16, 3, 16, down12, unbanked }, { 12, 16, 2, 16, down12, unbanked }, { 13, 16, 2, 16, down12, unbanked }, { 14, 16, 2, 16, down12, unbanked },
    { 15, 16, 2, 16, down12, unbanked }, { 16, 16, 1, 16, down12, unbanked }, { 17, 16, 1, 16, down12, unbanked }, { 18, 16, 1, 16, down12, unbanked }, { 19, 16, 1, 16, down12, unbanked },
    { 20, 16, 1, 16, down12, unbanked }, { 21, 16, 1, 16, down12, unbanked }, { 22, 16, 0, 16,   flat, unbanked }, { 23, 16, 0, 16,   flat, unbanked }, { 24, 16, 0, 16,   flat, unbanked },
    { 25, 16, 0, 16,   flat, unbanked }, { 26, 16, 0, 16,   flat, unbanked }, { 27, 16, 0, 16,   flat, unbanked }, { 28, 16, 0, 16,   flat, unbanked }, { 29, 16, 0, 16,   flat, unbanked },
    { 30, 16, 0, 16,   flat, unbanked }, { 31, 16, 0, 16,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0890, {
    { 16, 31, 7, 24, down25, unbanked }, { 16, 30, 7, 24, down25, unbanked }, { 16, 29, 6, 24, down25, unbanked }, { 16, 28, 6, 24, down25, unbanked }, { 16, 27, 5, 24, down25, unbanked },
    { 16, 26, 5, 24, down25, unbanked }, { 16, 25, 4, 24, down25, unbanked }, { 16, 24, 4, 24, down25, unbanked }, { 16, 23, 4, 24, down12, unbanked }, { 16, 22, 3, 24, down12, unbanked },
    { 16, 21, 3, 24, down12, unbanked }, { 16, 20, 3, 24, down12, unbanked }, { 16, 19, 2, 24, down12, unbanked }, { 16, 18, 2, 24, down12, unbanked }, { 16, 17, 2, 24, down12, unbanked },
    { 16, 16, 2, 24, down12, unbanked }, { 16, 15, 1, 24, down12, unbanked }, { 16, 14, 1, 24, down12, unbanked }, { 16, 13, 1, 24, down12, unbanked }, { 16, 12, 1, 24, down12, unbanked },
    { 16, 11, 1, 24, down12, unbanked }, { 16, 10, 1, 24, down12, unbanked }, { 16,  9, 0, 24,   flat, unbanked }, { 16,  8, 0, 24,   flat, unbanked }, { 16,  7, 0, 24,   flat, unbanked },
    { 16,  6, 0, 24,   flat, unbanked }, { 16,  5, 0, 24,   flat, unbanked }, { 16,  4, 0, 24,   flat, unbanked }, { 16,  3, 0, 24,   flat, unbanked }, { 16,  2, 0, 24,   flat, unbanked },
    { 16,  1, 0, 24,   flat, unbanked }, { 16,  0, 0, 24,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C8092, {
    {  31,  16, 0,  0, flat, unbanked }, {  30,  16, 0,  0, flat, unbanked }, {  29,  16, 0,  0, flat, unbanked }, {  28,  16, 0,  0, flat, unbanked }, {  27,  16, 0,  0, flat, unbanked },
    {  26,  16, 0,  0, flat, unbanked }, {  25,  16, 0,  0, flat, unbanked }, {  24,  16, 0, 31, flat, unbanked }, {  23,  15, 0, 31, flat, unbanked }, {  22,  15, 0, 31, flat, unbanked },
    {  21,  15, 0, 31, flat, unbanked }, {  20,  15, 0, 31, flat, unbanked }, {  19,  15, 0, 31, flat, unbanked }, {  18,  15, 0, 31, flat, unbanked }, {  17,  14, 0, 31, flat, unbanked },
    {  16,  14, 0, 31, flat, unbanked }, {  15,  14, 0, 31, flat, unbanked }, {  14,  14, 0, 31, flat, unbanked }, {  13,  14, 0, 31, flat, unbanked }, {  12,  13, 0, 31, flat, unbanked },
    {  11,  13, 0, 31, flat, unbanked }, {  10,  13, 0, 30, flat, unbanked }, {   9,  13, 0, 30, flat, unbanked }, {   8,  12, 0, 30, flat, unbanked }, {   7,  12, 0, 30, flat, unbanked },
    {   6,  12, 0, 30, flat, unbanked }, {   5,  11, 0, 30, flat, unbanked }, {   4,  11, 0, 30, flat, unbanked }, {   3,  11, 0, 30, flat, unbanked }, {   2,  10, 0, 30, flat, unbanked },
    {   1,  10, 0, 30, flat, unbanked }, {   0,   9, 0, 30, flat, unbanked }, {  -1,   9, 0, 30, flat, unbanked }, {  -2,   8, 0, 30, flat, unbanked }, {  -3,   8, 0, 30, flat, unbanked },
    {  -4,   7, 0, 30, flat, unbanked }, {  -5,   7, 0, 29, flat, unbanked }, {  -6,   6, 0, 29, flat, unbanked }, {  -7,   6, 0, 29, flat, unbanked }, {  -8,   5, 0, 29, flat, unbanked },
    {  -9,   4, 0, 29, flat, unbanked }, { -10,   4, 0, 29, flat, unbanked }, { -11,   3, 0, 29, flat, unbanked }, { -12,   2, 0, 29, flat, unbanked }, { -13,   2, 0, 29, flat, unbanked },
    { -14,   1, 0, 29, flat, unbanked }, { -15,   0, 0, 29, flat, unbanked }, { -16,   0, 0, 29, flat, unbanked }, { -17,  -1, 0, 29, flat, unbanked }, { -18,  -2, 0, 28, flat, unbanked },
    { -19,  -3, 0, 28, flat, unbanked }, { -20,  -3, 0, 28, flat, unbanked }, { -21,  -4, 0, 28, flat, unbanked }, { -22,  -5, 0, 28, flat, unbanked }, { -23,  -6, 0, 28, flat, unbanked },
    { -24,  -7, 0, 28, flat, unbanked }, { -25,  -7, 0, 28, flat, unbanked }, { -26,  -8, 0, 28, flat, unbanked }, { -27,  -9, 0, 28, flat, unbanked }, { -28, -10, 0, 28, flat, unbanked },
    { -29, -11, 0, 28, flat, unbanked }, { -29, -12, 0, 28, flat, unbanked }, { -30, -13, 0, 27, flat, unbanked }, { -31, -14, 0, 27, flat, unbanked }, { -32, -15, 0, 27, flat, unbanked },
    { -32, -16, 0, 27, flat, unbanked }, { -33, -17, 0, 27, flat, unbanked }, { -34, -18, 0, 27, flat, unbanked }, { -34, -19, 0, 27, flat, unbanked }, { -35, -20, 0, 27, flat, unbanked },
    { -36, -21, 0, 27, flat, unbanked }, { -36, -22, 0, 27, flat, unbanked }, { -37, -23, 0, 27, flat, unbanked }, { -38, -24, 0, 27, flat, unbanked }, { -38, -25, 0, 27, flat, unbanked },
    { -39, -26, 0, 26, flat, unbanked }, { -39, -27, 0, 26, flat, unbanked }, { -40, -28, 0, 26, flat, unbanked }, { -40, -29, 0, 26, flat, unbanked }, { -41, -30, 0, 26, flat, unbanked },
    { -41, -31, 0, 26, flat, unbanked }, { -42, -32, 0, 26, flat, unbanked }, { -42, -33, 0, 26, flat, unbanked }, { -43, -34, 0, 26, flat, unbanked }, { -43, -35, 0, 26, flat, unbanked },
    { -43, -36, 0, 26, flat, unbanked }, { -44, -37, 0, 26, flat, unbanked }, { -44, -38, 0, 26, flat, unbanked }, { -44, -39, 0, 26, flat, unbanked }, { -45, -40, 0, 25, flat, unbanked },
    { -45, -41, 0, 25, flat, unbanked }, { -45, -42, 0, 25, flat, unbanked }, { -45, -43, 0, 25, flat, unbanked }, { -46, -44, 0, 25, flat, unbanked }, { -46, -45, 0, 25, flat, unbanked },
    { -46, -46, 0, 25, flat, unbanked }, { -46, -47, 0, 25, flat, unbanked }, { -46, -48, 0, 25, flat, unbanked }, { -47, -49, 0, 25, flat, unbanked }, { -47, -50, 0, 25, flat, unbanked },
    { -47, -51, 0, 25, flat, unbanked }, { -47, -52, 0, 25, flat, unbanked }, { -47, -53, 0, 25, flat, unbanked }, { -47, -54, 0, 25, flat, unbanked }, { -48, -55, 0, 25, flat, unbanked },
    { -48, -56, 0, 24, flat, unbanked }, { -48, -57, 0, 24, flat, unbanked }, { -48, -58, 0, 24, flat, unbanked }, { -48, -59, 0, 24, flat, unbanked }, { -48, -60, 0, 24, flat, unbanked },
    { -48, -61, 0, 24, flat, unbanked }, { -48, -62, 0, 24, flat, unbanked }, { -48, -63, 0, 24, flat, unbanked }, { -48, -64, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C8496, {
    {  16,  0, 0, 8, flat, unbanked }, {  16,  1, 0, 8, flat, unbanked }, {  16,  2, 0, 8, flat, unbanked }, {  16,  3, 0, 8, flat, unbanked }, {  16,  4, 0, 8, flat, unbanked }, {  16,  5, 0, 8, flat, unbanked },
    {  16,  6, 0, 8, flat, unbanked }, {  16,  7, 0, 8, flat, unbanked }, {  16,  8, 0, 7, flat, unbanked }, {  15,  9, 0, 7, flat, unbanked }, {  15, 10, 0, 7, flat, unbanked }, {  15, 11, 0, 7, flat, unbanked },
    {  15, 12, 0, 7, flat, unbanked }, {  15, 13, 0, 7, flat, unbanked }, {  15, 14, 0, 7, flat, unbanked }, {  14, 15, 0, 7, flat, unbanked }, {  14, 16, 0, 7, flat, unbanked }, {  14, 17, 0, 7, flat, unbanked },
    {  14, 18, 0, 7, flat, unbanked }, {  14, 19, 0, 7, flat, unbanked }, {  13, 20, 0, 7, flat, unbanked }, {  13, 21, 0, 7, flat, unbanked }, {  13, 22, 0, 6, flat, unbanked }, {  13, 23, 0, 6, flat, unbanked },
    {  12, 24, 0, 6, flat, unbanked }, {  12, 25, 0, 6, flat, unbanked }, {  12, 26, 0, 6, flat, unbanked }, {  11, 27, 0, 6, flat, unbanked }, {  11, 28, 0, 6, flat, unbanked }, {  11, 29, 0, 6, flat, unbanked },
    {  10, 30, 0, 6, flat, unbanked }, {  10, 31, 0, 6, flat, unbanked }, {   9, 32, 0, 6, flat, unbanked }, {   9, 33, 0, 6, flat, unbanked }, {   8, 34, 0, 6, flat, unbanked }, {   8, 35, 0, 6, flat, unbanked },
    {   7, 36, 0, 6, flat, unbanked }, {   7, 37, 0, 5, flat, unbanked }, {   6, 38, 0, 5, flat, unbanked }, {   6, 39, 0, 5, flat, unbanked }, {   5, 40, 0, 5, flat, unbanked }, {   4, 41, 0, 5, flat, unbanked },
    {   4, 42, 0, 5, flat, unbanked }, {   3, 43, 0, 5, flat, unbanked }, {   2, 44, 0, 5, flat, unbanked }, {   2, 45, 0, 5, flat, unbanked }, {   1, 46, 0, 5, flat, unbanked }, {   0, 47, 0, 5, flat, unbanked },
    {   0, 48, 0, 5, flat, unbanked }, {  -1, 49, 0, 5, flat, unbanked }, {  -2, 50, 0, 4, flat, unbanked }, {  -3, 51, 0, 4, flat, unbanked }, {  -3, 52, 0, 4, flat, unbanked }, {  -4, 53, 0, 4, flat, unbanked },
    {  -5, 54, 0, 4, flat, unbanked }, {  -6, 55, 0, 4, flat, unbanked }, {  -7, 56, 0, 4, flat, unbanked }, {  -7, 57, 0, 4, flat, unbanked }, {  -8, 58, 0, 4, flat, unbanked }, {  -9, 59, 0, 4, flat, unbanked },
    { -10, 60, 0, 4, flat, unbanked }, { -11, 61, 0, 4, flat, unbanked }, { -12, 61, 0, 4, flat, unbanked }, { -13, 62, 0, 3, flat, unbanked }, { -14, 63, 0, 3, flat, unbanked }, { -15, 64, 0, 3, flat, unbanked },
    { -16, 64, 0, 3, flat, unbanked }, { -17, 65, 0, 3, flat, unbanked }, { -18, 66, 0, 3, flat, unbanked }, { -19, 66, 0, 3, flat, unbanked }, { -20, 67, 0, 3, flat, unbanked }, { -21, 68, 0, 3, flat, unbanked },
    { -22, 68, 0, 3, flat, unbanked }, { -23, 69, 0, 3, flat, unbanked }, { -24, 70, 0, 3, flat, unbanked }, { -25, 70, 0, 3, flat, unbanked }, { -26, 71, 0, 2, flat, unbanked }, { -27, 71, 0, 2, flat, unbanked },
    { -28, 72, 0, 2, flat, unbanked }, { -29, 72, 0, 2, flat, unbanked }, { -30, 73, 0, 2, flat, unbanked }, { -31, 73, 0, 2, flat, unbanked }, { -32, 74, 0, 2, flat, unbanked }, { -33, 74, 0, 2, flat, unbanked },
    { -34, 75, 0, 2, flat, unbanked }, { -35, 75, 0, 2, flat, unbanked }, { -36, 75, 0, 2, flat, unbanked }, { -37, 76, 0, 2, flat, unbanked }, { -38, 76, 0, 2, flat, unbanked }, { -39, 76, 0, 2, flat, unbanked },
    { -40, 77, 0, 1, flat, unbanked }, { -41, 77, 0, 1, flat, unbanked }, { -42, 77, 0, 1, flat, unbanked }, { -43, 77, 0, 1, flat, unbanked }, { -44, 78, 0, 1, flat, unbanked }, { -45, 78, 0, 1, flat, unbanked },
    { -46, 78, 0, 1, flat, unbanked }, { -47, 78, 0, 1, flat, unbanked }, { -48, 78, 0, 1, flat, unbanked }, { -49, 79, 0, 1, flat, unbanked }, { -50, 79, 0, 1, flat, unbanked }, { -51, 79, 0, 1, flat, unbanked },
    { -52, 79, 0, 1, flat, unbanked }, { -53, 79, 0, 1, flat, unbanked }, { -54, 79, 0, 1, flat, unbanked }, { -55, 80, 0, 1, flat, unbanked }, { -56, 80, 0, 0, flat, unbanked }, { -57, 80, 0, 0, flat, unbanked },
    { -58, 80, 0, 0, flat, unbanked }, { -59, 80, 0, 0, flat, unbanked }, { -60, 80, 0, 0, flat, unbanked }, { -61, 80, 0, 0, flat, unbanked }, { -62, 80, 0, 0, flat, unbanked }, { -63, 80, 0, 0, flat, unbanked },
    { -64, 80, 0, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C88A3, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 16, flat, unbanked }, {  4, 16, 0, 16, flat, unbanked }, {  5, 16, 0, 16, flat, unbanked },
    {  6, 16, 0, 16, flat, unbanked }, {  7, 16, 0, 16, flat, unbanked }, {  8, 16, 0, 15, flat, unbanked }, {  9, 17, 0, 15, flat, unbanked }, { 10, 17, 0, 15, flat, unbanked }, { 11, 17, 0, 15, flat, unbanked },
    { 12, 17, 0, 15, flat, unbanked }, { 13, 17, 0, 15, flat, unbanked }, { 14, 17, 0, 15, flat, unbanked }, { 15, 18, 0, 15, flat, unbanked }, { 16, 18, 0, 15, flat, unbanked }, { 17, 18, 0, 15, flat, unbanked },
    { 18, 18, 0, 15, flat, unbanked }, { 19, 18, 0, 15, flat, unbanked }, { 20, 19, 0, 15, flat, unbanked }, { 21, 19, 0, 15, flat, unbanked }, { 22, 19, 0, 14, flat, unbanked }, { 23, 19, 0, 14, flat, unbanked },
    { 24, 20, 0, 14, flat, unbanked }, { 25, 20, 0, 14, flat, unbanked }, { 26, 20, 0, 14, flat, unbanked }, { 27, 21, 0, 14, flat, unbanked }, { 28, 21, 0, 14, flat, unbanked }, { 29, 21, 0, 14, flat, unbanked },
    { 30, 22, 0, 14, flat, unbanked }, { 31, 22, 0, 14, flat, unbanked }, { 32, 23, 0, 14, flat, unbanked }, { 33, 23, 0, 14, flat, unbanked }, { 34, 24, 0, 14, flat, unbanked }, { 35, 24, 0, 14, flat, unbanked },
    { 36, 25, 0, 14, flat, unbanked }, { 37, 25, 0, 13, flat, unbanked }, { 38, 26, 0, 13, flat, unbanked }, { 39, 26, 0, 13, flat, unbanked }, { 40, 27, 0, 13, flat, unbanked }, { 41, 28, 0, 13, flat, unbanked },
    { 42, 28, 0, 13, flat, unbanked }, { 43, 29, 0, 13, flat, unbanked }, { 44, 30, 0, 13, flat, unbanked }, { 45, 30, 0, 13, flat, unbanked }, { 46, 31, 0, 13, flat, unbanked }, { 47, 32, 0, 13, flat, unbanked },
    { 48, 32, 0, 13, flat, unbanked }, { 49, 33, 0, 13, flat, unbanked }, { 50, 34, 0, 12, flat, unbanked }, { 51, 35, 0, 12, flat, unbanked }, { 52, 35, 0, 12, flat, unbanked }, { 53, 36, 0, 12, flat, unbanked },
    { 54, 37, 0, 12, flat, unbanked }, { 55, 38, 0, 12, flat, unbanked }, { 56, 39, 0, 12, flat, unbanked }, { 57, 39, 0, 12, flat, unbanked }, { 58, 40, 0, 12, flat, unbanked }, { 59, 41, 0, 12, flat, unbanked },
    { 60, 42, 0, 12, flat, unbanked }, { 61, 43, 0, 12, flat, unbanked }, { 61, 44, 0, 12, flat, unbanked }, { 62, 45, 0, 11, flat, unbanked }, { 63, 46, 0, 11, flat, unbanked }, { 64, 47, 0, 11, flat, unbanked },
    { 64, 48, 0, 11, flat, unbanked }, { 65, 49, 0, 11, flat, unbanked }, { 66, 50, 0, 11, flat, unbanked }, { 66, 51, 0, 11, flat, unbanked }, { 67, 52, 0, 11, flat, unbanked }, { 68, 53, 0, 11, flat, unbanked },
    { 68, 54, 0, 11, flat, unbanked }, { 69, 55, 0, 11, flat, unbanked }, { 70, 56, 0, 11, flat, unbanked }, { 70, 57, 0, 11, flat, unbanked }, { 71, 58, 0, 10, flat, unbanked }, { 71, 59, 0, 10, flat, unbanked },
    { 72, 60, 0, 10, flat, unbanked }, { 72, 61, 0, 10, flat, unbanked }, { 73, 62, 0, 10, flat, unbanked }, { 73, 63, 0, 10, flat, unbanked }, { 74, 64, 0, 10, flat, unbanked }, { 74, 65, 0, 10, flat, unbanked },
    { 75, 66, 0, 10, flat, unbanked }, { 75, 67, 0, 10, flat, unbanked }, { 75, 68, 0, 10, flat, unbanked }, { 76, 69, 0, 10, flat, unbanked }, { 76, 70, 0, 10, flat, unbanked }, { 76, 71, 0, 10, flat, unbanked },
    { 77, 72, 0,  9, flat, unbanked }, { 77, 73, 0,  9, flat, unbanked }, { 77, 74, 0,  9, flat, unbanked }, { 77, 75, 0,  9, flat, unbanked }, { 78, 76, 0,  9, flat, unbanked }, { 78, 77, 0,  9, flat, unbanked },
    { 78, 78, 0,  9, flat, unbanked }, { 78, 79, 0,  9, flat, unbanked }, { 78, 80, 0,  9, flat, unbanked }, { 79, 81, 0,  9, flat, unbanked }, { 79, 82, 0,  9, flat, unbanked }, { 79, 83, 0,  9, flat, unbanked },
    { 79, 84, 0,  9, flat, unbanked }, { 79, 85, 0,  9, flat, unbanked }, { 79, 86, 0,  9, flat, unbanked }, { 80, 87, 0,  9, flat, unbanked }, { 80, 88, 0,  8, flat, unbanked }, { 80, 89, 0,  8, flat, unbanked },
    { 80, 90, 0,  8, flat, unbanked }, { 80, 91, 0,  8, flat, unbanked }, { 80, 92, 0,  8, flat, unbanked }, { 80, 93, 0,  8, flat, unbanked }, { 80, 94, 0,  8, flat, unbanked }, { 80, 95, 0,  8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C8CA7, {
    { 16,  31, 0, 24, flat, unbanked }, { 16,  30, 0, 24, flat, unbanked }, { 16,  29, 0, 24, flat, unbanked }, { 16,  28, 0, 24, flat, unbanked }, { 16,  27, 0, 24, flat, unbanked },
    { 16,  26, 0, 24, flat, unbanked }, { 16,  25, 0, 24, flat, unbanked }, { 16,  24, 0, 23, flat, unbanked }, { 17,  23, 0, 23, flat, unbanked }, { 17,  22, 0, 23, flat, unbanked },
    { 17,  21, 0, 23, flat, unbanked }, { 17,  20, 0, 23, flat, unbanked }, { 17,  19, 0, 23, flat, unbanked }, { 17,  18, 0, 23, flat, unbanked }, { 18,  17, 0, 23, flat, unbanked },
    { 18,  16, 0, 23, flat, unbanked }, { 18,  15, 0, 23, flat, unbanked }, { 18,  14, 0, 23, flat, unbanked }, { 18,  13, 0, 23, flat, unbanked }, { 19,  12, 0, 23, flat, unbanked },
    { 19,  11, 0, 23, flat, unbanked }, { 19,  10, 0, 22, flat, unbanked }, { 19,   9, 0, 22, flat, unbanked }, { 20,   8, 0, 22, flat, unbanked }, { 20,   7, 0, 22, flat, unbanked },
    { 20,   6, 0, 22, flat, unbanked }, { 21,   5, 0, 22, flat, unbanked }, { 21,   4, 0, 22, flat, unbanked }, { 21,   3, 0, 22, flat, unbanked }, { 22,   2, 0, 22, flat, unbanked },
    { 22,   1, 0, 22, flat, unbanked }, { 23,   0, 0, 22, flat, unbanked }, { 23,  -1, 0, 22, flat, unbanked }, { 24,  -2, 0, 22, flat, unbanked }, { 24,  -3, 0, 22, flat, unbanked },
    { 25,  -4, 0, 22, flat, unbanked }, { 25,  -5, 0, 21, flat, unbanked }, { 26,  -6, 0, 21, flat, unbanked }, { 26,  -7, 0, 21, flat, unbanked }, { 27,  -8, 0, 21, flat, unbanked },
    { 28,  -9, 0, 21, flat, unbanked }, { 28, -10, 0, 21, flat, unbanked }, { 29, -11, 0, 21, flat, unbanked }, { 30, -12, 0, 21, flat, unbanked }, { 30, -13, 0, 21, flat, unbanked },
    { 31, -14, 0, 21, flat, unbanked }, { 32, -15, 0, 21, flat, unbanked }, { 32, -16, 0, 21, flat, unbanked }, { 33, -17, 0, 21, flat, unbanked }, { 34, -18, 0, 20, flat, unbanked },
    { 35, -19, 0, 20, flat, unbanked }, { 35, -20, 0, 20, flat, unbanked }, { 36, -21, 0, 20, flat, unbanked }, { 37, -22, 0, 20, flat, unbanked }, { 38, -23, 0, 20, flat, unbanked },
    { 39, -24, 0, 20, flat, unbanked }, { 39, -25, 0, 20, flat, unbanked }, { 40, -26, 0, 20, flat, unbanked }, { 41, -27, 0, 20, flat, unbanked }, { 42, -28, 0, 20, flat, unbanked },
    { 43, -29, 0, 20, flat, unbanked }, { 44, -29, 0, 20, flat, unbanked }, { 45, -30, 0, 19, flat, unbanked }, { 46, -31, 0, 19, flat, unbanked }, { 47, -32, 0, 19, flat, unbanked },
    { 48, -32, 0, 19, flat, unbanked }, { 49, -33, 0, 19, flat, unbanked }, { 50, -34, 0, 19, flat, unbanked }, { 51, -34, 0, 19, flat, unbanked }, { 52, -35, 0, 19, flat, unbanked },
    { 53, -36, 0, 19, flat, unbanked }, { 54, -36, 0, 19, flat, unbanked }, { 55, -37, 0, 19, flat, unbanked }, { 56, -38, 0, 19, flat, unbanked }, { 57, -38, 0, 19, flat, unbanked },
    { 58, -39, 0, 18, flat, unbanked }, { 59, -39, 0, 18, flat, unbanked }, { 60, -40, 0, 18, flat, unbanked }, { 61, -40, 0, 18, flat, unbanked }, { 62, -41, 0, 18, flat, unbanked },
    { 63, -41, 0, 18, flat, unbanked }, { 64, -42, 0, 18, flat, unbanked }, { 65, -42, 0, 18, flat, unbanked }, { 66, -43, 0, 18, flat, unbanked }, { 67, -43, 0, 18, flat, unbanked },
    { 68, -43, 0, 18, flat, unbanked }, { 69, -44, 0, 18, flat, unbanked }, { 70, -44, 0, 18, flat, unbanked }, { 71, -44, 0, 18, flat, unbanked }, { 72, -45, 0, 17, flat, unbanked },
    { 73, -45, 0, 17, flat, unbanked }, { 74, -45, 0, 17, flat, unbanked }, { 75, -45, 0, 17, flat, unbanked }, { 76, -46, 0, 17, flat, unbanked }, { 77, -46, 0, 17, flat, unbanked },
    { 78, -46, 0, 17, flat, unbanked }, { 79, -46, 0, 17, flat, unbanked }, { 80, -46, 0, 17, flat, unbanked }, { 81, -47, 0, 17, flat, unbanked }, { 82, -47, 0, 17, flat, unbanked },
    { 83, -47, 0, 17, flat, unbanked }, { 84, -47, 0, 17, flat, unbanked }, { 85, -47, 0, 17, flat, unbanked }, { 86, -47, 0, 17, flat, unbanked }, { 87, -48, 0, 17, flat, unbanked },
    { 88, -48, 0, 16, flat, unbanked }, { 89, -48, 0, 16, flat, unbanked }, { 90, -48, 0, 16, flat, unbanked }, { 91, -48, 0, 16, flat, unbanked }, { 92, -48, 0, 16, flat, unbanked },
    { 93, -48, 0, 16, flat, unbanked }, { 94, -48, 0, 16, flat, unbanked }, { 95, -48, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C90A2, {
    {  31, 16, 0, 0, flat, unbanked }, {  30, 16, 0, 0, flat, unbanked }, {  29, 16, 0, 0, flat, unbanked }, {  28, 16, 0, 0, flat, unbanked }, {  27, 16, 0, 0, flat, unbanked }, {  26, 16, 0, 0, flat, unbanked },
    {  25, 16, 0, 0, flat, unbanked }, {  24, 16, 0, 1, flat, unbanked }, {  23, 17, 0, 1, flat, unbanked }, {  22, 17, 0, 1, flat, unbanked }, {  21, 17, 0, 1, flat, unbanked }, {  20, 17, 0, 1, flat, unbanked },
    {  19, 17, 0, 1, flat, unbanked }, {  18, 17, 0, 1, flat, unbanked }, {  17, 18, 0, 1, flat, unbanked }, {  16, 18, 0, 1, flat, unbanked }, {  15, 18, 0, 1, flat, unbanked }, {  14, 18, 0, 1, flat, unbanked },
    {  13, 18, 0, 1, flat, unbanked }, {  12, 19, 0, 1, flat, unbanked }, {  11, 19, 0, 1, flat, unbanked }, {  10, 19, 0, 2, flat, unbanked }, {   9, 19, 0, 2, flat, unbanked }, {   8, 20, 0, 2, flat, unbanked },
    {   7, 20, 0, 2, flat, unbanked }, {   6, 20, 0, 2, flat, unbanked }, {   5, 21, 0, 2, flat, unbanked }, {   4, 21, 0, 2, flat, unbanked }, {   3, 21, 0, 2, flat, unbanked }, {   2, 22, 0, 2, flat, unbanked },
    {   1, 22, 0, 2, flat, unbanked }, {   0, 23, 0, 2, flat, unbanked }, {  -1, 23, 0, 2, flat, unbanked }, {  -2, 24, 0, 2, flat, unbanked }, {  -3, 24, 0, 2, flat, unbanked }, {  -4, 25, 0, 2, flat, unbanked },
    {  -5, 25, 0, 3, flat, unbanked }, {  -6, 26, 0, 3, flat, unbanked }, {  -7, 26, 0, 3, flat, unbanked }, {  -8, 27, 0, 3, flat, unbanked }, {  -9, 28, 0, 3, flat, unbanked }, { -10, 28, 0, 3, flat, unbanked },
    { -11, 29, 0, 3, flat, unbanked }, { -12, 30, 0, 3, flat, unbanked }, { -13, 30, 0, 3, flat, unbanked }, { -14, 31, 0, 3, flat, unbanked }, { -15, 32, 0, 3, flat, unbanked }, { -16, 32, 0, 3, flat, unbanked },
    { -17, 33, 0, 3, flat, unbanked }, { -18, 34, 0, 4, flat, unbanked }, { -19, 35, 0, 4, flat, unbanked }, { -20, 35, 0, 4, flat, unbanked }, { -21, 36, 0, 4, flat, unbanked }, { -22, 37, 0, 4, flat, unbanked },
    { -23, 38, 0, 4, flat, unbanked }, { -24, 39, 0, 4, flat, unbanked }, { -25, 39, 0, 4, flat, unbanked }, { -26, 40, 0, 4, flat, unbanked }, { -27, 41, 0, 4, flat, unbanked }, { -28, 42, 0, 4, flat, unbanked },
    { -29, 43, 0, 4, flat, unbanked }, { -29, 44, 0, 4, flat, unbanked }, { -30, 45, 0, 5, flat, unbanked }, { -31, 46, 0, 5, flat, unbanked }, { -32, 47, 0, 5, flat, unbanked }, { -32, 48, 0, 5, flat, unbanked },
    { -33, 49, 0, 5, flat, unbanked }, { -34, 50, 0, 5, flat, unbanked }, { -34, 51, 0, 5, flat, unbanked }, { -35, 52, 0, 5, flat, unbanked }, { -36, 53, 0, 5, flat, unbanked }, { -36, 54, 0, 5, flat, unbanked },
    { -37, 55, 0, 5, flat, unbanked }, { -38, 56, 0, 5, flat, unbanked }, { -38, 57, 0, 5, flat, unbanked }, { -39, 58, 0, 6, flat, unbanked }, { -39, 59, 0, 6, flat, unbanked }, { -40, 60, 0, 6, flat, unbanked },
    { -40, 61, 0, 6, flat, unbanked }, { -41, 62, 0, 6, flat, unbanked }, { -41, 63, 0, 6, flat, unbanked }, { -42, 64, 0, 6, flat, unbanked }, { -42, 65, 0, 6, flat, unbanked }, { -43, 66, 0, 6, flat, unbanked },
    { -43, 67, 0, 6, flat, unbanked }, { -43, 68, 0, 6, flat, unbanked }, { -44, 69, 0, 6, flat, unbanked }, { -44, 70, 0, 6, flat, unbanked }, { -44, 71, 0, 6, flat, unbanked }, { -45, 72, 0, 7, flat, unbanked },
    { -45, 73, 0, 7, flat, unbanked }, { -45, 74, 0, 7, flat, unbanked }, { -45, 75, 0, 7, flat, unbanked }, { -46, 76, 0, 7, flat, unbanked }, { -46, 77, 0, 7, flat, unbanked }, { -46, 78, 0, 7, flat, unbanked },
    { -46, 79, 0, 7, flat, unbanked }, { -46, 80, 0, 7, flat, unbanked }, { -47, 81, 0, 7, flat, unbanked }, { -47, 82, 0, 7, flat, unbanked }, { -47, 83, 0, 7, flat, unbanked }, { -47, 84, 0, 7, flat, unbanked },
    { -47, 85, 0, 7, flat, unbanked }, { -47, 86, 0, 7, flat, unbanked }, { -48, 87, 0, 7, flat, unbanked }, { -48, 88, 0, 8, flat, unbanked }, { -48, 89, 0, 8, flat, unbanked }, { -48, 90, 0, 8, flat, unbanked },
    { -48, 91, 0, 8, flat, unbanked }, { -48, 92, 0, 8, flat, unbanked }, { -48, 93, 0, 8, flat, unbanked }, { -48, 94, 0, 8, flat, unbanked }, { -48, 95, 0, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C949D, {
    { 16,  0, 0,  8, flat, unbanked }, { 16,  1, 0,  8, flat, unbanked }, { 16,  2, 0,  8, flat, unbanked }, { 16,  3, 0,  8, flat, unbanked }, { 16,  4, 0,  8, flat, unbanked }, { 16,  5, 0,  8, flat, unbanked },
    { 16,  6, 0,  8, flat, unbanked }, { 16,  7, 0,  8, flat, unbanked }, { 16,  8, 0,  9, flat, unbanked }, { 17,  9, 0,  9, flat, unbanked }, { 17, 10, 0,  9, flat, unbanked }, { 17, 11, 0,  9, flat, unbanked },
    { 17, 12, 0,  9, flat, unbanked }, { 17, 13, 0,  9, flat, unbanked }, { 17, 14, 0,  9, flat, unbanked }, { 18, 15, 0,  9, flat, unbanked }, { 18, 16, 0,  9, flat, unbanked }, { 18, 17, 0,  9, flat, unbanked },
    { 18, 18, 0,  9, flat, unbanked }, { 18, 19, 0,  9, flat, unbanked }, { 19, 20, 0,  9, flat, unbanked }, { 19, 21, 0,  9, flat, unbanked }, { 19, 22, 0, 10, flat, unbanked }, { 19, 23, 0, 10, flat, unbanked },
    { 20, 24, 0, 10, flat, unbanked }, { 20, 25, 0, 10, flat, unbanked }, { 20, 26, 0, 10, flat, unbanked }, { 21, 27, 0, 10, flat, unbanked }, { 21, 28, 0, 10, flat, unbanked }, { 21, 29, 0, 10, flat, unbanked },
    { 22, 30, 0, 10, flat, unbanked }, { 22, 31, 0, 10, flat, unbanked }, { 23, 32, 0, 10, flat, unbanked }, { 23, 33, 0, 10, flat, unbanked }, { 24, 34, 0, 10, flat, unbanked }, { 24, 35, 0, 10, flat, unbanked },
    { 25, 36, 0, 10, flat, unbanked }, { 25, 37, 0, 11, flat, unbanked }, { 26, 38, 0, 11, flat, unbanked }, { 26, 39, 0, 11, flat, unbanked }, { 27, 40, 0, 11, flat, unbanked }, { 28, 41, 0, 11, flat, unbanked },
    { 28, 42, 0, 11, flat, unbanked }, { 29, 43, 0, 11, flat, unbanked }, { 30, 44, 0, 11, flat, unbanked }, { 30, 45, 0, 11, flat, unbanked }, { 31, 46, 0, 11, flat, unbanked }, { 32, 47, 0, 11, flat, unbanked },
    { 32, 48, 0, 11, flat, unbanked }, { 33, 49, 0, 11, flat, unbanked }, { 34, 50, 0, 12, flat, unbanked }, { 35, 51, 0, 12, flat, unbanked }, { 35, 52, 0, 12, flat, unbanked }, { 36, 53, 0, 12, flat, unbanked },
    { 37, 54, 0, 12, flat, unbanked }, { 38, 55, 0, 12, flat, unbanked }, { 39, 56, 0, 12, flat, unbanked }, { 39, 57, 0, 12, flat, unbanked }, { 40, 58, 0, 12, flat, unbanked }, { 41, 59, 0, 12, flat, unbanked },
    { 42, 60, 0, 12, flat, unbanked }, { 43, 61, 0, 12, flat, unbanked }, { 44, 61, 0, 12, flat, unbanked }, { 45, 62, 0, 13, flat, unbanked }, { 46, 63, 0, 13, flat, unbanked }, { 47, 64, 0, 13, flat, unbanked },
    { 48, 64, 0, 13, flat, unbanked }, { 49, 65, 0, 13, flat, unbanked }, { 50, 66, 0, 13, flat, unbanked }, { 51, 66, 0, 13, flat, unbanked }, { 52, 67, 0, 13, flat, unbanked }, { 53, 68, 0, 13, flat, unbanked },
    { 54, 68, 0, 13, flat, unbanked }, { 55, 69, 0, 13, flat, unbanked }, { 56, 70, 0, 13, flat, unbanked }, { 57, 70, 0, 13, flat, unbanked }, { 58, 71, 0, 14, flat, unbanked }, { 59, 71, 0, 14, flat, unbanked },
    { 60, 72, 0, 14, flat, unbanked }, { 61, 72, 0, 14, flat, unbanked }, { 62, 73, 0, 14, flat, unbanked }, { 63, 73, 0, 14, flat, unbanked }, { 64, 74, 0, 14, flat, unbanked }, { 65, 74, 0, 14, flat, unbanked },
    { 66, 75, 0, 14, flat, unbanked }, { 67, 75, 0, 14, flat, unbanked }, { 68, 75, 0, 14, flat, unbanked }, { 69, 76, 0, 14, flat, unbanked }, { 70, 76, 0, 14, flat, unbanked }, { 71, 76, 0, 14, flat, unbanked },
    { 72, 77, 0, 15, flat, unbanked }, { 73, 77, 0, 15, flat, unbanked }, { 74, 77, 0, 15, flat, unbanked }, { 75, 77, 0, 15, flat, unbanked }, { 76, 78, 0, 15, flat, unbanked }, { 77, 78, 0, 15, flat, unbanked },
    { 78, 78, 0, 15, flat, unbanked }, { 79, 78, 0, 15, flat, unbanked }, { 80, 78, 0, 15, flat, unbanked }, { 81, 79, 0, 15, flat, unbanked }, { 82, 79, 0, 15, flat, unbanked }, { 83, 79, 0, 15, flat, unbanked },
    { 84, 79, 0, 15, flat, unbanked }, { 85, 79, 0, 15, flat, unbanked }, { 86, 79, 0, 15, flat, unbanked }, { 87, 80, 0, 15, flat, unbanked }, { 88, 80, 0, 16, flat, unbanked }, { 89, 80, 0, 16, flat, unbanked },
    { 90, 80, 0, 16, flat, unbanked }, { 91, 80, 0, 16, flat, unbanked }, { 92, 80, 0, 16, flat, unbanked }, { 93, 80, 0, 16, flat, unbanked }, { 94, 80, 0, 16, flat, unbanked }, { 95, 80, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C98A1, {
    {  0,  16, 0, 16, flat, unbanked }, {  1,  16, 0, 16, flat, unbanked }, {  2,  16, 0, 16, flat, unbanked }, {  3,  16, 0, 16, flat, unbanked }, {  4,  16, 0, 16, flat, unbanked },
    {  5,  16, 0, 16, flat, unbanked }, {  6,  16, 0, 16, flat, unbanked }, {  7,  16, 0, 16, flat, unbanked }, {  8,  16, 0, 17, flat, unbanked }, {  9,  15, 0, 17, flat, unbanked },
    { 10,  15, 0, 17, flat, unbanked }, { 11,  15, 0, 17, flat, unbanked }, { 12,  15, 0, 17, flat, unbanked }, { 13,  15, 0, 17, flat, unbanked }, { 14,  15, 0, 17, flat, unbanked },
    { 15,  14, 0, 17, flat, unbanked }, { 16,  14, 0, 17, flat, unbanked }, { 17,  14, 0, 17, flat, unbanked }, { 18,  14, 0, 17, flat, unbanked }, { 19,  14, 0, 17, flat, unbanked },
    { 20,  13, 0, 17, flat, unbanked }, { 21,  13, 0, 17, flat, unbanked }, { 22,  13, 0, 18, flat, unbanked }, { 23,  13, 0, 18, flat, unbanked }, { 24,  12, 0, 18, flat, unbanked },
    { 25,  12, 0, 18, flat, unbanked }, { 26,  12, 0, 18, flat, unbanked }, { 27,  11, 0, 18, flat, unbanked }, { 28,  11, 0, 18, flat, unbanked }, { 29,  11, 0, 18, flat, unbanked },
    { 30,  10, 0, 18, flat, unbanked }, { 31,  10, 0, 18, flat, unbanked }, { 32,   9, 0, 18, flat, unbanked }, { 33,   9, 0, 18, flat, unbanked }, { 34,   8, 0, 18, flat, unbanked },
    { 35,   8, 0, 18, flat, unbanked }, { 36,   7, 0, 18, flat, unbanked }, { 37,   7, 0, 19, flat, unbanked }, { 38,   6, 0, 19, flat, unbanked }, { 39,   6, 0, 19, flat, unbanked },
    { 40,   5, 0, 19, flat, unbanked }, { 41,   4, 0, 19, flat, unbanked }, { 42,   4, 0, 19, flat, unbanked }, { 43,   3, 0, 19, flat, unbanked }, { 44,   2, 0, 19, flat, unbanked },
    { 45,   2, 0, 19, flat, unbanked }, { 46,   1, 0, 19, flat, unbanked }, { 47,   0, 0, 19, flat, unbanked }, { 48,   0, 0, 19, flat, unbanked }, { 49,  -1, 0, 19, flat, unbanked },
    { 50,  -2, 0, 20, flat, unbanked }, { 51,  -3, 0, 20, flat, unbanked }, { 52,  -3, 0, 20, flat, unbanked }, { 53,  -4, 0, 20, flat, unbanked }, { 54,  -5, 0, 20, flat, unbanked },
    { 55,  -6, 0, 20, flat, unbanked }, { 56,  -7, 0, 20, flat, unbanked }, { 57,  -7, 0, 20, flat, unbanked }, { 58,  -8, 0, 20, flat, unbanked }, { 59,  -9, 0, 20, flat, unbanked },
    { 60, -10, 0, 20, flat, unbanked }, { 61, -11, 0, 20, flat, unbanked }, { 61, -12, 0, 20, flat, unbanked }, { 62, -13, 0, 21, flat, unbanked }, { 63, -14, 0, 21, flat, unbanked },
    { 64, -15, 0, 21, flat, unbanked }, { 64, -16, 0, 21, flat, unbanked }, { 65, -17, 0, 21, flat, unbanked }, { 66, -18, 0, 21, flat, unbanked }, { 66, -19, 0, 21, flat, unbanked },
    { 67, -20, 0, 21, flat, unbanked }, { 68, -21, 0, 21, flat, unbanked }, { 68, -22, 0, 21, flat, unbanked }, { 69, -23, 0, 21, flat, unbanked }, { 70, -24, 0, 21, flat, unbanked },
    { 70, -25, 0, 21, flat, unbanked }, { 71, -26, 0, 22, flat, unbanked }, { 71, -27, 0, 22, flat, unbanked }, { 72, -28, 0, 22, flat, unbanked }, { 72, -29, 0, 22, flat, unbanked },
    { 73, -30, 0, 22, flat, unbanked }, { 73, -31, 0, 22, flat, unbanked }, { 74, -32, 0, 22, flat, unbanked }, { 74, -33, 0, 22, flat, unbanked }, { 75, -34, 0, 22, flat, unbanked },
    { 75, -35, 0, 22, flat, unbanked }, { 75, -36, 0, 22, flat, unbanked }, { 76, -37, 0, 22, flat, unbanked }, { 76, -38, 0, 22, flat, unbanked }, { 76, -39, 0, 22, flat, unbanked },
    { 77, -40, 0, 23, flat, unbanked }, { 77, -41, 0, 23, flat, unbanked }, { 77, -42, 0, 23, flat, unbanked }, { 77, -43, 0, 23, flat, unbanked }, { 78, -44, 0, 23, flat, unbanked },
    { 78, -45, 0, 23, flat, unbanked }, { 78, -46, 0, 23, flat, unbanked }, { 78, -47, 0, 23, flat, unbanked }, { 78, -48, 0, 23, flat, unbanked }, { 79, -49, 0, 23, flat, unbanked },
    { 79, -50, 0, 23, flat, unbanked }, { 79, -51, 0, 23, flat, unbanked }, { 79, -52, 0, 23, flat, unbanked }, { 79, -53, 0, 23, flat, unbanked }, { 79, -54, 0, 23, flat, unbanked },
    { 80, -55, 0, 23, flat, unbanked }, { 80, -56, 0, 24, flat, unbanked }, { 80, -57, 0, 24, flat, unbanked }, { 80, -58, 0, 24, flat, unbanked }, { 80, -59, 0, 24, flat, unbanked },
    { 80, -60, 0, 24, flat, unbanked }, { 80, -61, 0, 24, flat, unbanked }, { 80, -62, 0, 24, flat, unbanked }, { 80, -63, 0, 24, flat, unbanked }, { 80, -64, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C9CAE, {
    {  16,  31, 0, 24, flat, unbanked }, {  16,  30, 0, 24, flat, unbanked }, {  16,  29, 0, 24, flat, unbanked }, {  16,  28, 0, 24, flat, unbanked }, {  16,  27, 0, 24, flat, unbanked },
    {  16,  26, 0, 24, flat, unbanked }, {  16,  25, 0, 24, flat, unbanked }, {  16,  24, 0, 25, flat, unbanked }, {  15,  23, 0, 25, flat, unbanked }, {  15,  22, 0, 25, flat, unbanked },
    {  15,  21, 0, 25, flat, unbanked }, {  15,  20, 0, 25, flat, unbanked }, {  15,  19, 0, 25, flat, unbanked }, {  15,  18, 0, 25, flat, unbanked }, {  14,  17, 0, 25, flat, unbanked },
    {  14,  16, 0, 25, flat, unbanked }, {  14,  15, 0, 25, flat, unbanked }, {  14,  14, 0, 25, flat, unbanked }, {  14,  13, 0, 25, flat, unbanked }, {  13,  12, 0, 25, flat, unbanked },
    {  13,  11, 0, 25, flat, unbanked }, {  13,  10, 0, 26, flat, unbanked }, {  13,   9, 0, 26, flat, unbanked }, {  12,   8, 0, 26, flat, unbanked }, {  12,   7, 0, 26, flat, unbanked },
    {  12,   6, 0, 26, flat, unbanked }, {  11,   5, 0, 26, flat, unbanked }, {  11,   4, 0, 26, flat, unbanked }, {  11,   3, 0, 26, flat, unbanked }, {  10,   2, 0, 26, flat, unbanked },
    {  10,   1, 0, 26, flat, unbanked }, {   9,   0, 0, 26, flat, unbanked }, {   9,  -1, 0, 26, flat, unbanked }, {   8,  -2, 0, 26, flat, unbanked }, {   8,  -3, 0, 26, flat, unbanked },
    {   7,  -4, 0, 26, flat, unbanked }, {   7,  -5, 0, 27, flat, unbanked }, {   6,  -6, 0, 27, flat, unbanked }, {   6,  -7, 0, 27, flat, unbanked }, {   5,  -8, 0, 27, flat, unbanked },
    {   4,  -9, 0, 27, flat, unbanked }, {   4, -10, 0, 27, flat, unbanked }, {   3, -11, 0, 27, flat, unbanked }, {   2, -12, 0, 27, flat, unbanked }, {   2, -13, 0, 27, flat, unbanked },
    {   1, -14, 0, 27, flat, unbanked }, {   0, -15, 0, 27, flat, unbanked }, {   0, -16, 0, 27, flat, unbanked }, {  -1, -17, 0, 27, flat, unbanked }, {  -2, -18, 0, 28, flat, unbanked },
    {  -3, -19, 0, 28, flat, unbanked }, {  -3, -20, 0, 28, flat, unbanked }, {  -4, -21, 0, 28, flat, unbanked }, {  -5, -22, 0, 28, flat, unbanked }, {  -6, -23, 0, 28, flat, unbanked },
    {  -7, -24, 0, 28, flat, unbanked }, {  -7, -25, 0, 28, flat, unbanked }, {  -8, -26, 0, 28, flat, unbanked }, {  -9, -27, 0, 28, flat, unbanked }, { -10, -28, 0, 28, flat, unbanked },
    { -11, -29, 0, 28, flat, unbanked }, { -12, -29, 0, 28, flat, unbanked }, { -13, -30, 0, 29, flat, unbanked }, { -14, -31, 0, 29, flat, unbanked }, { -15, -32, 0, 29, flat, unbanked },
    { -16, -32, 0, 29, flat, unbanked }, { -17, -33, 0, 29, flat, unbanked }, { -18, -34, 0, 29, flat, unbanked }, { -19, -34, 0, 29, flat, unbanked }, { -20, -35, 0, 29, flat, unbanked },
    { -21, -36, 0, 29, flat, unbanked }, { -22, -36, 0, 29, flat, unbanked }, { -23, -37, 0, 29, flat, unbanked }, { -24, -38, 0, 29, flat, unbanked }, { -25, -38, 0, 29, flat, unbanked },
    { -26, -39, 0, 30, flat, unbanked }, { -27, -39, 0, 30, flat, unbanked }, { -28, -40, 0, 30, flat, unbanked }, { -29, -40, 0, 30, flat, unbanked }, { -30, -41, 0, 30, flat, unbanked },
    { -31, -41, 0, 30, flat, unbanked }, { -32, -42, 0, 30, flat, unbanked }, { -33, -42, 0, 30, flat, unbanked }, { -34, -43, 0, 30, flat, unbanked }, { -35, -43, 0, 30, flat, unbanked },
    { -36, -43, 0, 30, flat, unbanked }, { -37, -44, 0, 30, flat, unbanked }, { -38, -44, 0, 30, flat, unbanked }, { -39, -44, 0, 30, flat, unbanked }, { -40, -45, 0, 31, flat, unbanked },
    { -41, -45, 0, 31, flat, unbanked }, { -42, -45, 0, 31, flat, unbanked }, { -43, -45, 0, 31, flat, unbanked }, { -44, -46, 0, 31, flat, unbanked }, { -45, -46, 0, 31, flat, unbanked },
    { -46, -46, 0, 31, flat, unbanked }, { -47, -46, 0, 31, flat, unbanked }, { -48, -46, 0, 31, flat, unbanked }, { -49, -47, 0, 31, flat, unbanked }, { -50, -47, 0, 31, flat, unbanked },
    { -51, -47, 0, 31, flat, unbanked }, { -52, -47, 0, 31, flat, unbanked }, { -53, -47, 0, 31, flat, unbanked }, { -54, -47, 0, 31, flat, unbanked }, { -55, -48, 0, 31, flat, unbanked },
    { -56, -48, 0,  0, flat, unbanked }, { -57, -48, 0,  0, flat, unbanked }, { -58, -48, 0,  0, flat, unbanked }, { -59, -48, 0,  0, flat, unbanked }, { -60, -48, 0,  0, flat, unbanked },
    { -61, -48, 0,  0, flat, unbanked }, { -62, -48, 0,  0, flat, unbanked }, { -63, -48, 0,  0, flat, unbanked }, { -64, -48, 0,  0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3542, {
    { 31, 16, 0, 0, flat, unbanked }, { 30, 16, 0, 0, flat, unbanked }, { 29, 16, 0, 0, flat, unbanked }, { 28, 16, 0, 0, flat, unbanked }, { 27, 16, 0, 0, flat, unbanked }, { 26, 16, 0, 0, flat, unbanked },
    { 25, 16, 0, 0, flat, unbanked }, { 24, 16, 0, 0, flat, unbanked }, { 23, 16, 0, 0, flat,   left22 }, { 22, 16, 0, 0, flat,   left22 }, { 21, 16, 0, 0, flat,   left22 }, { 20, 16, 0, 0, flat,   left22 },
    { 19, 16, 0, 0, flat,   left22 }, { 18, 16, 0, 0, flat,   left22 }, { 17, 16, 0, 0, flat,   left22 }, { 16, 16, 0, 0, flat,   left22 }, { 15, 16, 0, 0, flat,   left22 }, { 14, 16, 0, 0, flat,   left22 },
    { 13, 16, 0, 0, flat,   left22 }, { 12, 16, 0, 0, flat,   left22 }, { 11, 16, 0, 0, flat,   left22 }, { 10, 16, 0, 0, flat,   left22 }, {  9, 16, 0, 0, flat,   left22 }, {  8, 16, 0, 0, flat,   left22 },
    {  7, 16, 0, 0, flat,   left45 }, {  6, 16, 0, 0, flat,   left45 }, {  5, 16, 0, 0, flat,   left45 }, {  4, 16, 0, 0, flat,   left45 }, {  3, 16, 0, 0, flat,   left45 }, {  2, 16, 0, 0, flat,   left45 },
    {  1, 16, 0, 0, flat,   left45 }, {  0, 16, 0, 0, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3664, {
    { 16,  0, 0, 8, flat, unbanked }, { 16,  1, 0, 8, flat, unbanked }, { 16,  2, 0, 8, flat, unbanked }, { 16,  3, 0, 8, flat, unbanked }, { 16,  4, 0, 8, flat, unbanked }, { 16,  5, 0, 8, flat, unbanked },
    { 16,  6, 0, 8, flat, unbanked }, { 16,  7, 0, 8, flat, unbanked }, { 16,  8, 0, 8, flat,   left22 }, { 16,  9, 0, 8, flat,   left22 }, { 16, 10, 0, 8, flat,   left22 }, { 16, 11, 0, 8, flat,   left22 },
    { 16, 12, 0, 8, flat,   left22 }, { 16, 13, 0, 8, flat,   left22 }, { 16, 14, 0, 8, flat,   left22 }, { 16, 15, 0, 8, flat,   left22 }, { 16, 16, 0, 8, flat,   left22 }, { 16, 17, 0, 8, flat,   left22 },
    { 16, 18, 0, 8, flat,   left22 }, { 16, 19, 0, 8, flat,   left22 }, { 16, 20, 0, 8, flat,   left22 }, { 16, 21, 0, 8, flat,   left22 }, { 16, 22, 0, 8, flat,   left22 }, { 16, 23, 0, 8, flat,   left22 },
    { 16, 24, 0, 8, flat,   left45 }, { 16, 25, 0, 8, flat,   left45 }, { 16, 26, 0, 8, flat,   left45 }, { 16, 27, 0, 8, flat,   left45 }, { 16, 28, 0, 8, flat,   left45 }, { 16, 29, 0, 8, flat,   left45 },
    { 16, 30, 0, 8, flat,   left45 }, { 16, 31, 0, 8, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3786, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 16, flat, unbanked }, {  4, 16, 0, 16, flat, unbanked }, {  5, 16, 0, 16, flat, unbanked },
    {  6, 16, 0, 16, flat, unbanked }, {  7, 16, 0, 16, flat, unbanked }, {  8, 16, 0, 16, flat,   left22 }, {  9, 16, 0, 16, flat,   left22 }, { 10, 16, 0, 16, flat,   left22 }, { 11, 16, 0, 16, flat,   left22 },
    { 12, 16, 0, 16, flat,   left22 }, { 13, 16, 0, 16, flat,   left22 }, { 14, 16, 0, 16, flat,   left22 }, { 15, 16, 0, 16, flat,   left22 }, { 16, 16, 0, 16, flat,   left22 }, { 17, 16, 0, 16, flat,   left22 },
    { 18, 16, 0, 16, flat,   left22 }, { 19, 16, 0, 16, flat,   left22 }, { 20, 16, 0, 16, flat,   left22 }, { 21, 16, 0, 16, flat,   left22 }, { 22, 16, 0, 16, flat,   left22 }, { 23, 16, 0, 16, flat,   left22 },
    { 24, 16, 0, 16, flat,   left45 }, { 25, 16, 0, 16, flat,   left45 }, { 26, 16, 0, 16, flat,   left45 }, { 27, 16, 0, 16, flat,   left45 }, { 28, 16, 0, 16, flat,   left45 }, { 29, 16, 0, 16, flat,   left45 },
    { 30, 16, 0, 16, flat,   left45 }, { 31, 16, 0, 16, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C38A8, {
    { 16, 31, 0, 24, flat, unbanked }, { 16, 30, 0, 24, flat, unbanked }, { 16, 29, 0, 24, flat, unbanked }, { 16, 28, 0, 24, flat, unbanked }, { 16, 27, 0, 24, flat, unbanked }, { 16, 26, 0, 24, flat, unbanked },
    { 16, 25, 0, 24, flat, unbanked }, { 16, 24, 0, 24, flat, unbanked }, { 16, 23, 0, 24, flat,   left22 }, { 16, 22, 0, 24, flat,   left22 }, { 16, 21, 0, 24, flat,   left22 }, { 16, 20, 0, 24, flat,   left22 },
    { 16, 19, 0, 24, flat,   left22 }, { 16, 18, 0, 24, flat,   left22 }, { 16, 17, 0, 24, flat,   left22 }, { 16, 16, 0, 24, flat,   left22 }, { 16, 15, 0, 24, flat,   left22 }, { 16, 14, 0, 24, flat,   left22 },
    { 16, 13, 0, 24, flat,   left22 }, { 16, 12, 0, 24, flat,   left22 }, { 16, 11, 0, 24, flat,   left22 }, { 16, 10, 0, 24, flat,   left22 }, { 16,  9, 0, 24, flat,   left22 }, { 16,  8, 0, 24, flat,   left22 },
    { 16,  7, 0, 24, flat,   left45 }, { 16,  6, 0, 24, flat,   left45 }, { 16,  5, 0, 24, flat,   left45 }, { 16,  4, 0, 24, flat,   left45 }, { 16,  3, 0, 24, flat,   left45 }, { 16,  2, 0, 24, flat,   left45 },
    { 16,  1, 0, 24, flat,   left45 }, { 16,  0, 0, 24, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C39CA, {
    { 31, 16, 0, 0, flat, unbanked }, { 30, 16, 0, 0, flat, unbanked }, { 29, 16, 0, 0, flat, unbanked }, { 28, 16, 0, 0, flat, unbanked }, { 27, 16, 0, 0, flat, unbanked }, { 26, 16, 0, 0, flat, unbanked },
    { 25, 16, 0, 0, flat, unbanked }, { 24, 16, 0, 0, flat, unbanked }, { 23, 16, 0, 0, flat,  right22 }, { 22, 16, 0, 0, flat,  right22 }, { 21, 16, 0, 0, flat,  right22 }, { 20, 16, 0, 0, flat,  right22 },
    { 19, 16, 0, 0, flat,  right22 }, { 18, 16, 0, 0, flat,  right22 }, { 17, 16, 0, 0, flat,  right22 }, { 16, 16, 0, 0, flat,  right22 }, { 15, 16, 0, 0, flat,  right22 }, { 14, 16, 0, 0, flat,  right22 },
    { 13, 16, 0, 0, flat,  right22 }, { 12, 16, 0, 0, flat,  right22 }, { 11, 16, 0, 0, flat,  right22 }, { 10, 16, 0, 0, flat,  right22 }, {  9, 16, 0, 0, flat,  right22 }, {  8, 16, 0, 0, flat,  right22 },
    {  7, 16, 0, 0, flat,  right45 }, {  6, 16, 0, 0, flat,  right45 }, {  5, 16, 0, 0, flat,  right45 }, {  4, 16, 0, 0, flat,  right45 }, {  3, 16, 0, 0, flat,  right45 }, {  2, 16, 0, 0, flat,  right45 },
    {  1, 16, 0, 0, flat,  right45 }, {  0, 16, 0, 0, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3AEC, {
    { 16,  0, 0, 8, flat, unbanked }, { 16,  1, 0, 8, flat, unbanked }, { 16,  2, 0, 8, flat, unbanked }, { 16,  3, 0, 8, flat, unbanked }, { 16,  4, 0, 8, flat, unbanked }, { 16,  5, 0, 8, flat, unbanked },
    { 16,  6, 0, 8, flat, unbanked }, { 16,  7, 0, 8, flat, unbanked }, { 16,  8, 0, 8, flat,  right22 }, { 16,  9, 0, 8, flat,  right22 }, { 16, 10, 0, 8, flat,  right22 }, { 16, 11, 0, 8, flat,  right22 },
    { 16, 12, 0, 8, flat,  right22 }, { 16, 13, 0, 8, flat,  right22 }, { 16, 14, 0, 8, flat,  right22 }, { 16, 15, 0, 8, flat,  right22 }, { 16, 16, 0, 8, flat,  right22 }, { 16, 17, 0, 8, flat,  right22 },
    { 16, 18, 0, 8, flat,  right22 }, { 16, 19, 0, 8, flat,  right22 }, { 16, 20, 0, 8, flat,  right22 }, { 16, 21, 0, 8, flat,  right22 }, { 16, 22, 0, 8, flat,  right22 }, { 16, 23, 0, 8, flat,  right22 },
    { 16, 24, 0, 8, flat,  right45 }, { 16, 25, 0, 8, flat,  right45 }, { 16, 26, 0, 8, flat,  right45 }, { 16, 27, 0, 8, flat,  right45 }, { 16, 28, 0, 8, flat,  right45 }, { 16, 29, 0, 8, flat,  right45 },
    { 16, 30, 0, 8, flat,  right45 }, { 16, 31, 0, 8, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3C0E, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 16, flat, unbanked }, {  4, 16, 0, 16, flat, unbanked }, {  5, 16, 0, 16, flat, unbanked },
    {  6, 16, 0, 16, flat, unbanked }, {  7, 16, 0, 16, flat, unbanked }, {  8, 16, 0, 16, flat,  right22 }, {  9, 16, 0, 16, flat,  right22 }, { 10, 16, 0, 16, flat,  right22 }, { 11, 16, 0, 16, flat,  right22 },
    { 12, 16, 0, 16, flat,  right22 }, { 13, 16, 0, 16, flat,  right22 }, { 14, 16, 0, 16, flat,  right22 }, { 15, 16, 0, 16, flat,  right22 }, { 16, 16, 0, 16, flat,  right22 }, { 17, 16, 0, 16, flat,  right22 },
    { 18, 16, 0, 16, flat,  right22 }, { 19, 16, 0, 16, flat,  right22 }, { 20, 16, 0, 16, flat,  right22 }, { 21, 16, 0, 16, flat,  right22 }, { 22, 16, 0, 16, flat,  right22 }, { 23, 16, 0, 16, flat,  right22 },
    { 24, 16, 0, 16, flat,  right45 }, { 25, 16, 0, 16, flat,  right45 }, { 26, 16, 0, 16, flat,  right45 }, { 27, 16, 0, 16, flat,  right45 }, { 28, 16, 0, 16, flat,  right45 }, { 29, 16, 0, 16, flat,  right45 },
    { 30, 16, 0, 16, flat,  right45 }, { 31, 16, 0, 16, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3D30, {
    { 16, 31, 0, 24, flat, unbanked }, { 16, 30, 0, 24, flat, unbanked }, { 16, 29, 0, 24, flat, unbanked }, { 16, 28, 0, 24, flat, unbanked }, { 16, 27, 0, 24, flat, unbanked }, { 16, 26, 0, 24, flat, unbanked },
    { 16, 25, 0, 24, flat, unbanked }, { 16, 24, 0, 24, flat, unbanked }, { 16, 23, 0, 24, flat,  right22 }, { 16, 22, 0, 24, flat,  right22 }, { 16, 21, 0, 24, flat,  right22 }, { 16, 20, 0, 24, flat,  right22 },
    { 16, 19, 0, 24, flat,  right22 }, { 16, 18, 0, 24, flat,  right22 }, { 16, 17, 0, 24, flat,  right22 }, { 16, 16, 0, 24, flat,  right22 }, { 16, 15, 0, 24, flat,  right22 }, { 16, 14, 0, 24, flat,  right22 },
    { 16, 13, 0, 24, flat,  right22 }, { 16, 12, 0, 24, flat,  right22 }, { 16, 11, 0, 24, flat,  right22 }, { 16, 10, 0, 24, flat,  right22 }, { 16,  9, 0, 24, flat,  right22 }, { 16,  8, 0, 24, flat,  right22 },
    { 16,  7, 0, 24, flat,  right45 }, { 16,  6, 0, 24, flat,  right45 }, { 16,  5, 0, 24, flat,  right45 }, { 16,  4, 0, 24, flat,  right45 }, { 16,  3, 0, 24, flat,  right45 }, { 16,  2, 0, 24, flat,  right45 },
    { 16,  1, 0, 24, flat,  right45 }, { 16,  0, 0, 24, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3E52, {
    { 31, 16, 0, 0, flat,   left45 }, { 30, 16, 0, 0, flat,   left45 }, { 29, 16, 0, 0, flat,   left45 }, { 28, 16, 0, 0, flat,   left45 }, { 27, 16, 0, 0, flat,   left45 }, { 26, 16, 0, 0, flat,   left45 },
    { 25, 16, 0, 0, flat,   left45 }, { 24, 16, 0, 0, flat,   left45 }, { 23, 16, 0, 0, flat,   left22 }, { 22, 16, 0, 0, flat,   left22 }, { 21, 16, 0, 0, flat,   left22 }, { 20, 16, 0, 0, flat,   left22 },
    { 19, 16, 0, 0, flat,   left22 }, { 18, 16, 0, 0, flat,   left22 }, { 17, 16, 0, 0, flat,   left22 }, { 16, 16, 0, 0, flat,   left22 }, { 15, 16, 0, 0, flat,   left22 }, { 14, 16, 0, 0, flat,   left22 },
    { 13, 16, 0, 0, flat,   left22 }, { 12, 16, 0, 0, flat,   left22 }, { 11, 16, 0, 0, flat,   left22 }, { 10, 16, 0, 0, flat,   left22 }, {  9, 16, 0, 0, flat,   left22 }, {  8, 16, 0, 0, flat,   left22 },
    {  7, 16, 0, 0, flat, unbanked }, {  6, 16, 0, 0, flat, unbanked }, {  5, 16, 0, 0, flat, unbanked }, {  4, 16, 0, 0, flat, unbanked }, {  3, 16, 0, 0, flat, unbanked }, {  2, 16, 0, 0, flat, unbanked },
    {  1, 16, 0, 0, flat, unbanked }, {  0, 16, 0, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3F74, {
    { 16,  0, 0, 8, flat,   left45 }, { 16,  1, 0, 8, flat,   left45 }, { 16,  2, 0, 8, flat,   left45 }, { 16,  3, 0, 8, flat,   left45 }, { 16,  4, 0, 8, flat,   left45 }, { 16,  5, 0, 8, flat,   left45 },
    { 16,  6, 0, 8, flat,   left45 }, { 16,  7, 0, 8, flat,   left45 }, { 16,  8, 0, 8, flat,   left22 }, { 16,  9, 0, 8, flat,   left22 }, { 16, 10, 0, 8, flat,   left22 }, { 16, 11, 0, 8, flat,   left22 },
    { 16, 12, 0, 8, flat,   left22 }, { 16, 13, 0, 8, flat,   left22 }, { 16, 14, 0, 8, flat,   left22 }, { 16, 15, 0, 8, flat,   left22 }, { 16, 16, 0, 8, flat,   left22 }, { 16, 17, 0, 8, flat,   left22 },
    { 16, 18, 0, 8, flat,   left22 }, { 16, 19, 0, 8, flat,   left22 }, { 16, 20, 0, 8, flat,   left22 }, { 16, 21, 0, 8, flat,   left22 }, { 16, 22, 0, 8, flat,   left22 }, { 16, 23, 0, 8, flat,   left22 },
    { 16, 24, 0, 8, flat, unbanked }, { 16, 25, 0, 8, flat, unbanked }, { 16, 26, 0, 8, flat, unbanked }, { 16, 27, 0, 8, flat, unbanked }, { 16, 28, 0, 8, flat, unbanked }, { 16, 29, 0, 8, flat, unbanked },
    { 16, 30, 0, 8, flat, unbanked }, { 16, 31, 0, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4096, {
    {  0, 16, 0, 16, flat,   left45 }, {  1, 16, 0, 16, flat,   left45 }, {  2, 16, 0, 16, flat,   left45 }, {  3, 16, 0, 16, flat,   left45 }, {  4, 16, 0, 16, flat,   left45 }, {  5, 16, 0, 16, flat,   left45 },
    {  6, 16, 0, 16, flat,   left45 }, {  7, 16, 0, 16, flat,   left45 }, {  8, 16, 0, 16, flat,   left22 }, {  9, 16, 0, 16, flat,   left22 }, { 10, 16, 0, 16, flat,   left22 }, { 11, 16, 0, 16, flat,   left22 },
    { 12, 16, 0, 16, flat,   left22 }, { 13, 16, 0, 16, flat,   left22 }, { 14, 16, 0, 16, flat,   left22 }, { 15, 16, 0, 16, flat,   left22 }, { 16, 16, 0, 16, flat,   left22 }, { 17, 16, 0, 16, flat,   left22 },
    { 18, 16, 0, 16, flat,   left22 }, { 19, 16, 0, 16, flat,   left22 }, { 20, 16, 0, 16, flat,   left22 }, { 21, 16, 0, 16, flat,   left22 }, { 22, 16, 0, 16, flat,   left22 }, { 23, 16, 0, 16, flat,   left22 },
    { 24, 16, 0, 16, flat, unbanked }, { 25, 16, 0, 16, flat, unbanked }, { 26, 16, 0, 16, flat, unbanked }, { 27, 16, 0, 16, flat, unbanked }, { 28, 16, 0, 16, flat, unbanked }, { 29, 16, 0, 16, flat, unbanked },
    { 30, 16, 0, 16, flat, unbanked }, { 31, 16, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C41B8, {
    { 16, 31, 0, 24, flat,   left45 }, { 16, 30, 0, 24, flat,   left45 }, { 16, 29, 0, 24, flat,   left45 }, { 16, 28, 0, 24, flat,   left45 }, { 16, 27, 0, 24, flat,   left45 }, { 16, 26, 0, 24, flat,   left45 },
    { 16, 25, 0, 24, flat,   left45 }, { 16, 24, 0, 24, flat,   left45 }, { 16, 23, 0, 24, flat,   left22 }, { 16, 22, 0, 24, flat,   left22 }, { 16, 21, 0, 24, flat,   left22 }, { 16, 20, 0, 24, flat,   left22 },
    { 16, 19, 0, 24, flat,   left22 }, { 16, 18, 0, 24, flat,   left22 }, { 16, 17, 0, 24, flat,   left22 }, { 16, 16, 0, 24, flat,   left22 }, { 16, 15, 0, 24, flat,   left22 }, { 16, 14, 0, 24, flat,   left22 },
    { 16, 13, 0, 24, flat,   left22 }, { 16, 12, 0, 24, flat,   left22 }, { 16, 11, 0, 24, flat,   left22 }, { 16, 10, 0, 24, flat,   left22 }, { 16,  9, 0, 24, flat,   left22 }, { 16,  8, 0, 24, flat,   left22 },
    { 16,  7, 0, 24, flat, unbanked }, { 16,  6, 0, 24, flat, unbanked }, { 16,  5, 0, 24, flat, unbanked }, { 16,  4, 0, 24, flat, unbanked }, { 16,  3, 0, 24, flat, unbanked }, { 16,  2, 0, 24, flat, unbanked },
    { 16,  1, 0, 24, flat, unbanked }, { 16,  0, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C42DA, {
    { 31, 16, 0, 0, flat,  right45 }, { 30, 16, 0, 0, flat,  right45 }, { 29, 16, 0, 0, flat,  right45 }, { 28, 16, 0, 0, flat,  right45 }, { 27, 16, 0, 0, flat,  right45 }, { 26, 16, 0, 0, flat,  right45 },
    { 25, 16, 0, 0, flat,  right45 }, { 24, 16, 0, 0, flat,  right45 }, { 23, 16, 0, 0, flat,  right22 }, { 22, 16, 0, 0, flat,  right22 }, { 21, 16, 0, 0, flat,  right22 }, { 20, 16, 0, 0, flat,  right22 },
    { 19, 16, 0, 0, flat,  right22 }, { 18, 16, 0, 0, flat,  right22 }, { 17, 16, 0, 0, flat,  right22 }, { 16, 16, 0, 0, flat,  right22 }, { 15, 16, 0, 0, flat,  right22 }, { 14, 16, 0, 0, flat,  right22 },
    { 13, 16, 0, 0, flat,  right22 }, { 12, 16, 0, 0, flat,  right22 }, { 11, 16, 0, 0, flat,  right22 }, { 10, 16, 0, 0, flat,  right22 }, {  9, 16, 0, 0, flat,  right22 }, {  8, 16, 0, 0, flat,  right22 },
    {  7, 16, 0, 0, flat, unbanked }, {  6, 16, 0, 0, flat, unbanked }, {  5, 16, 0, 0, flat, unbanked }, {  4, 16, 0, 0, flat, unbanked }, {  3, 16, 0, 0, flat, unbanked }, {  2, 16, 0, 0, flat, unbanked },
    {  1, 16, 0, 0, flat, unbanked }, {  0, 16, 0, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C43FC, {
    { 16,  0, 0, 8, flat,  right45 }, { 16,  1, 0, 8, flat,  right45 }, { 16,  2, 0, 8, flat,  right45 }, { 16,  3, 0, 8, flat,  right45 }, { 16,  4, 0, 8, flat,  right45 }, { 16,  5, 0, 8, flat,  right45 },
    { 16,  6, 0, 8, flat,  right45 }, { 16,  7, 0, 8, flat,  right45 }, { 16,  8, 0, 8, flat,  right22 }, { 16,  9, 0, 8, flat,  right22 }, { 16, 10, 0, 8, flat,  right22 }, { 16, 11, 0, 8, flat,  right22 },
    { 16, 12, 0, 8, flat,  right22 }, { 16, 13, 0, 8, flat,  right22 }, { 16, 14, 0, 8, flat,  right22 }, { 16, 15, 0, 8, flat,  right22 }, { 16, 16, 0, 8, flat,  right22 }, { 16, 17, 0, 8, flat,  right22 },
    { 16, 18, 0, 8, flat,  right22 }, { 16, 19, 0, 8, flat,  right22 }, { 16, 20, 0, 8, flat,  right22 }, { 16, 21, 0, 8, flat,  right22 }, { 16, 22, 0, 8, flat,  right22 }, { 16, 23, 0, 8, flat,  right22 },
    { 16, 24, 0, 8, flat, unbanked }, { 16, 25, 0, 8, flat, unbanked }, { 16, 26, 0, 8, flat, unbanked }, { 16, 27, 0, 8, flat, unbanked }, { 16, 28, 0, 8, flat, unbanked }, { 16, 29, 0, 8, flat, unbanked },
    { 16, 30, 0, 8, flat, unbanked }, { 16, 31, 0, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C451E, {
    {  0, 16, 0, 16, flat,  right45 }, {  1, 16, 0, 16, flat,  right45 }, {  2, 16, 0, 16, flat,  right45 }, {  3, 16, 0, 16, flat,  right45 }, {  4, 16, 0, 16, flat,  right45 }, {  5, 16, 0, 16, flat,  right45 },
    {  6, 16, 0, 16, flat,  right45 }, {  7, 16, 0, 16, flat,  right45 }, {  8, 16, 0, 16, flat,  right22 }, {  9, 16, 0, 16, flat,  right22 }, { 10, 16, 0, 16, flat,  right22 }, { 11, 16, 0, 16, flat,  right22 },
    { 12, 16, 0, 16, flat,  right22 }, { 13, 16, 0, 16, flat,  right22 }, { 14, 16, 0, 16, flat,  right22 }, { 15, 16, 0, 16, flat,  right22 }, { 16, 16, 0, 16, flat,  right22 }, { 17, 16, 0, 16, flat,  right22 },
    { 18, 16, 0, 16, flat,  right22 }, { 19, 16, 0, 16, flat,  right22 }, { 20, 16, 0, 16, flat,  right22 }, { 21, 16, 0, 16, flat,  right22 }, { 22, 16, 0, 16, flat,  right22 }, { 23, 16, 0, 16, flat,  right22 },
    { 24, 16, 0, 16, flat, unbanked }, { 25, 16, 0, 16, flat, unbanked }, { 26, 16, 0, 16, flat, unbanked }, { 27, 16, 0, 16, flat, unbanked }, { 28, 16, 0, 16, flat, unbanked }, { 29, 16, 0, 16, flat, unbanked },
    { 30, 16, 0, 16, flat, unbanked }, { 31, 16, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4640, {
    { 16, 31, 0, 24, flat,  right45 }, { 16, 30, 0, 24, flat,  right45 }, { 16, 29, 0, 24, flat,  right45 }, { 16, 28, 0, 24, flat,  right45 }, { 16, 27, 0, 24, flat,  right45 }, { 16, 26, 0, 24, flat,  right45 },
    { 16, 25, 0, 24, flat,  right45 }, { 16, 24, 0, 24, flat,  right45 }, { 16, 23, 0, 24, flat,  right22 }, { 16, 22, 0, 24, flat,  right22 }, { 16, 21, 0, 24, flat,  right22 }, { 16, 20, 0, 24, flat,  right22 },
    { 16, 19, 0, 24, flat,  right22 }, { 16, 18, 0, 24, flat,  right22 }, { 16, 17, 0, 24, flat,  right22 }, { 16, 16, 0, 24, flat,  right22 }, { 16, 15, 0, 24, flat,  right22 }, { 16, 14, 0, 24, flat,  right22 },
    { 16, 13, 0, 24, flat,  right22 }, { 16, 12, 0, 24, flat,  right22 }, { 16, 11, 0, 24, flat,  right22 }, { 16, 10, 0, 24, flat,  right22 }, { 16,  9, 0, 24, flat,  right22 }, { 16,  8, 0, 24, flat,  right22 },
    { 16,  7, 0, 24, flat, unbanked }, { 16,  6, 0, 24, flat, unbanked }, { 16,  5, 0, 24, flat, unbanked }, { 16,  4, 0, 24, flat, unbanked }, { 16,  3, 0, 24, flat, unbanked }, { 16,  2, 0, 24, flat, unbanked },
    { 16,  1, 0, 24, flat, unbanked }, { 16,  0, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CA0B2, {
    {  31,  16, 0,  0, flat, left45 }, {  30,  16, 0,  0, flat, left45 }, {  29,  16, 0,  0, flat, left45 }, {  28,  16, 0,  0, flat, left45 }, {  27,  16, 0,  0, flat, left45 }, {  26,  16, 0,  0, flat, left45 },
    {  25,  16, 0,  0, flat, left45 }, {  24,  16, 0, 31, flat, left45 }, {  23,  15, 0, 31, flat, left45 }, {  22,  15, 0, 31, flat, left45 }, {  21,  15, 0, 31, flat, left45 }, {  20,  15, 0, 31, flat, left45 },
    {  19,  15, 0, 31, flat, left45 }, {  18,  15, 0, 31, flat, left45 }, {  17,  14, 0, 31, flat, left45 }, {  16,  14, 0, 31, flat, left45 }, {  15,  14, 0, 31, flat, left45 }, {  14,  14, 0, 31, flat, left45 },
    {  13,  14, 0, 31, flat, left45 }, {  12,  13, 0, 31, flat, left45 }, {  11,  13, 0, 31, flat, left45 }, {  10,  13, 0, 30, flat, left45 }, {   9,  13, 0, 30, flat, left45 }, {   8,  12, 0, 30, flat, left45 },
    {   7,  12, 0, 30, flat, left45 }, {   6,  12, 0, 30, flat, left45 }, {   5,  11, 0, 30, flat, left45 }, {   4,  11, 0, 30, flat, left45 }, {   3,  11, 0, 30, flat, left45 }, {   2,  10, 0, 30, flat, left45 },
    {   1,  10, 0, 30, flat, left45 }, {   0,   9, 0, 30, flat, left45 }, {  -1,   9, 0, 30, flat, left45 }, {  -2,   8, 0, 30, flat, left45 }, {  -3,   8, 0, 30, flat, left45 }, {  -4,   7, 0, 30, flat, left45 },
    {  -5,   7, 0, 29, flat, left45 }, {  -6,   6, 0, 29, flat, left45 }, {  -7,   6, 0, 29, flat, left45 }, {  -8,   5, 0, 29, flat, left45 }, {  -9,   4, 0, 29, flat, left45 }, { -10,   4, 0, 29, flat, left45 },
    { -11,   3, 0, 29, flat, left45 }, { -12,   2, 0, 29, flat, left45 }, { -13,   2, 0, 29, flat, left45 }, { -14,   1, 0, 29, flat, left45 }, { -15,   0, 0, 29, flat, left45 }, { -16,   0, 0, 29, flat, left45 },
    { -17,  -1, 0, 29, flat, left45 }, { -18,  -2, 0, 28, flat, left45 }, { -19,  -3, 0, 28, flat, left45 }, { -20,  -3, 0, 28, flat, left45 }, { -21,  -4, 0, 28, flat, left45 }, { -22,  -5, 0, 28, flat, left45 },
    { -23,  -6, 0, 28, flat, left45 }, { -24,  -7, 0, 28, flat, left45 }, { -25,  -7, 0, 28, flat, left45 }, { -26,  -8, 0, 28, flat, left45 }, { -27,  -9, 0, 28, flat, left45 }, { -28, -10, 0, 28, flat, left45 },
    { -29, -11, 0, 28, flat, left45 }, { -29, -12, 0, 28, flat, left45 }, { -30, -13, 0, 27, flat, left45 }, { -31, -14, 0, 27, flat, left45 }, { -32, -15, 0, 27, flat, left45 }, { -32, -16, 0, 27, flat, left45 },
    { -33, -17, 0, 27, flat, left45 }, { -34, -18, 0, 27, flat, left45 }, { -34, -19, 0, 27, flat, left45 }, { -35, -20, 0, 27, flat, left45 }, { -36, -21, 0, 27, flat, left45 }, { -36, -22, 0, 27, flat, left45 },
    { -37, -23, 0, 27, flat, left45 }, { -38, -24, 0, 27, flat, left45 }, { -38, -25, 0, 27, flat, left45 }, { -39, -26, 0, 26, flat, left45 }, { -39, -27, 0, 26, flat, left45 }, { -40, -28, 0, 26, flat, left45 },
    { -40, -29, 0, 26, flat, left45 }, { -41, -30, 0, 26, flat, left45 }, { -41, -31, 0, 26, flat, left45 }, { -42, -32, 0, 26, flat, left45 }, { -42, -33, 0, 26, flat, left45 }, { -43, -34, 0, 26, flat, left45 },
    { -43, -35, 0, 26, flat, left45 }, { -43, -36, 0, 26, flat, left45 }, { -44, -37, 0, 26, flat, left45 }, { -44, -38, 0, 26, flat, left45 }, { -44, -39, 0, 26, flat, left45 }, { -45, -40, 0, 25, flat, left45 },
    { -45, -41, 0, 25, flat, left45 }, { -45, -42, 0, 25, flat, left45 }, { -45, -43, 0, 25, flat, left45 }, { -46, -44, 0, 25, flat, left45 }, { -46, -45, 0, 25, flat, left45 }, { -46, -46, 0, 25, flat, left45 },
    { -46, -47, 0, 25, flat, left45 }, { -46, -48, 0, 25, flat, left45 }, { -47, -49, 0, 25, flat, left45 }, { -47, -50, 0, 25, flat, left45 }, { -47, -51, 0, 25, flat, left45 }, { -47, -52, 0, 25, flat, left45 },
    { -47, -53, 0, 25, flat, left45 }, { -47, -54, 0, 25, flat, left45 }, { -48, -55, 0, 25, flat, left45 }, { -48, -56, 0, 24, flat, left45 }, { -48, -57, 0, 24, flat, left45 }, { -48, -58, 0, 24, flat, left45 },
    { -48, -59, 0, 24, flat, left45 }, { -48, -60, 0, 24, flat, left45 }, { -48, -61, 0, 24, flat, left45 }, { -48, -62, 0, 24, flat, left45 }, { -48, -63, 0, 24, flat, left45 }, { -48, -64, 0, 24, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CA4B6, {
    {  16,  0, 0, 8, flat, left45 }, {  16,  1, 0, 8, flat, left45 }, {  16,  2, 0, 8, flat, left45 }, {  16,  3, 0, 8, flat, left45 }, {  16,  4, 0, 8, flat, left45 }, {  16,  5, 0, 8, flat, left45 },
    {  16,  6, 0, 8, flat, left45 }, {  16,  7, 0, 8, flat, left45 }, {  16,  8, 0, 7, flat, left45 }, {  15,  9, 0, 7, flat, left45 }, {  15, 10, 0, 7, flat, left45 }, {  15, 11, 0, 7, flat, left45 },
    {  15, 12, 0, 7, flat, left45 }, {  15, 13, 0, 7, flat, left45 }, {  15, 14, 0, 7, flat, left45 }, {  14, 15, 0, 7, flat, left45 }, {  14, 16, 0, 7, flat, left45 }, {  14, 17, 0, 7, flat, left45 },
    {  14, 18, 0, 7, flat, left45 }, {  14, 19, 0, 7, flat, left45 }, {  13, 20, 0, 7, flat, left45 }, {  13, 21, 0, 7, flat, left45 }, {  13, 22, 0, 6, flat, left45 }, {  13, 23, 0, 6, flat, left45 },
    {  12, 24, 0, 6, flat, left45 }, {  12, 25, 0, 6, flat, left45 }, {  12, 26, 0, 6, flat, left45 }, {  11, 27, 0, 6, flat, left45 }, {  11, 28, 0, 6, flat, left45 }, {  11, 29, 0, 6, flat, left45 },
    {  10, 30, 0, 6, flat, left45 }, {  10, 31, 0, 6, flat, left45 }, {   9, 32, 0, 6, flat, left45 }, {   9, 33, 0, 6, flat, left45 }, {   8, 34, 0, 6, flat, left45 }, {   8, 35, 0, 6, flat, left45 },
    {   7, 36, 0, 6, flat, left45 }, {   7, 37, 0, 5, flat, left45 }, {   6, 38, 0, 5, flat, left45 }, {   6, 39, 0, 5, flat, left45 }, {   5, 40, 0, 5, flat, left45 }, {   4, 41, 0, 5, flat, left45 },
    {   4, 42, 0, 5, flat, left45 }, {   3, 43, 0, 5, flat, left45 }, {   2, 44, 0, 5, flat, left45 }, {   2, 45, 0, 5, flat, left45 }, {   1, 46, 0, 5, flat, left45 }, {   0, 47, 0, 5, flat, left45 },
    {   0, 48, 0, 5, flat, left45 }, {  -1, 49, 0, 5, flat, left45 }, {  -2, 50, 0, 4, flat, left45 }, {  -3, 51, 0, 4, flat, left45 }, {  -3, 52, 0, 4, flat, left45 }, {  -4, 53, 0, 4, flat, left45 },
    {  -5, 54, 0, 4, flat, left45 }, {  -6, 55, 0, 4, flat, left45 }, {  -7, 56, 0, 4, flat, left45 }, {  -7, 57, 0, 4, flat, left45 }, {  -8, 58, 0, 4, flat, left45 }, {  -9, 59, 0, 4, flat, left45 },
    { -10, 60, 0, 4, flat, left45 }, { -11, 61, 0, 4, flat, left45 }, { -12, 61, 0, 4, flat, left45 }, { -13, 62, 0, 3, flat, left45 }, { -14, 63, 0, 3, flat, left45 }, { -15, 64, 0, 3, flat, left45 },
    { -16, 64, 0, 3, flat, left45 }, { -17, 65, 0, 3, flat, left45 }, { -18, 66, 0, 3, flat, left45 }, { -19, 66, 0, 3, flat, left45 }, { -20, 67, 0, 3, flat, left45 }, { -21, 68, 0, 3, flat, left45 },
    { -22, 68, 0, 3, flat, left45 }, { -23, 69, 0, 3, flat, left45 }, { -24, 70, 0, 3, flat, left45 }, { -25, 70, 0, 3, flat, left45 }, { -26, 71, 0, 2, flat, left45 }, { -27, 71, 0, 2, flat, left45 },
    { -28, 72, 0, 2, flat, left45 }, { -29, 72, 0, 2, flat, left45 }, { -30, 73, 0, 2, flat, left45 }, { -31, 73, 0, 2, flat, left45 }, { -32, 74, 0, 2, flat, left45 }, { -33, 74, 0, 2, flat, left45 },
    { -34, 75, 0, 2, flat, left45 }, { -35, 75, 0, 2, flat, left45 }, { -36, 75, 0, 2, flat, left45 }, { -37, 76, 0, 2, flat, left45 }, { -38, 76, 0, 2, flat, left45 }, { -39, 76, 0, 2, flat, left45 },
    { -40, 77, 0, 1, flat, left45 }, { -41, 77, 0, 1, flat, left45 }, { -42, 77, 0, 1, flat, left45 }, { -43, 77, 0, 1, flat, left45 }, { -44, 78, 0, 1, flat, left45 }, { -45, 78, 0, 1, flat, left45 },
    { -46, 78, 0, 1, flat, left45 }, { -47, 78, 0, 1, flat, left45 }, { -48, 78, 0, 1, flat, left45 }, { -49, 79, 0, 1, flat, left45 }, { -50, 79, 0, 1, flat, left45 }, { -51, 79, 0, 1, flat, left45 },
    { -52, 79, 0, 1, flat, left45 }, { -53, 79, 0, 1, flat, left45 }, { -54, 79, 0, 1, flat, left45 }, { -55, 80, 0, 1, flat, left45 }, { -56, 80, 0, 0, flat, left45 }, { -57, 80, 0, 0, flat, left45 },
    { -58, 80, 0, 0, flat, left45 }, { -59, 80, 0, 0, flat, left45 }, { -60, 80, 0, 0, flat, left45 }, { -61, 80, 0, 0, flat, left45 }, { -62, 80, 0, 0, flat, left45 }, { -63, 80, 0, 0, flat, left45 },
    { -64, 80, 0, 0, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CA8C3, {
    {  0, 16, 0, 16, flat, left45 }, {  1, 16, 0, 16, flat, left45 }, {  2, 16, 0, 16, flat, left45 }, {  3, 16, 0, 16, flat, left45 }, {  4, 16, 0, 16, flat, left45 }, {  5, 16, 0, 16, flat, left45 },
    {  6, 16, 0, 16, flat, left45 }, {  7, 16, 0, 16, flat, left45 }, {  8, 16, 0, 15, flat, left45 }, {  9, 17, 0, 15, flat, left45 }, { 10, 17, 0, 15, flat, left45 }, { 11, 17, 0, 15, flat, left45 },
    { 12, 17, 0, 15, flat, left45 }, { 13, 17, 0, 15, flat, left45 }, { 14, 17, 0, 15, flat, left45 }, { 15, 18, 0, 15, flat, left45 }, { 16, 18, 0, 15, flat, left45 }, { 17, 18, 0, 15, flat, left45 },
    { 18, 18, 0, 15, flat, left45 }, { 19, 18, 0, 15, flat, left45 }, { 20, 19, 0, 15, flat, left45 }, { 21, 19, 0, 15, flat, left45 }, { 22, 19, 0, 14, flat, left45 }, { 23, 19, 0, 14, flat, left45 },
    { 24, 20, 0, 14, flat, left45 }, { 25, 20, 0, 14, flat, left45 }, { 26, 20, 0, 14, flat, left45 }, { 27, 21, 0, 14, flat, left45 }, { 28, 21, 0, 14, flat, left45 }, { 29, 21, 0, 14, flat, left45 },
    { 30, 22, 0, 14, flat, left45 }, { 31, 22, 0, 14, flat, left45 }, { 32, 23, 0, 14, flat, left45 }, { 33, 23, 0, 14, flat, left45 }, { 34, 24, 0, 14, flat, left45 }, { 35, 24, 0, 14, flat, left45 },
    { 36, 25, 0, 14, flat, left45 }, { 37, 25, 0, 13, flat, left45 }, { 38, 26, 0, 13, flat, left45 }, { 39, 26, 0, 13, flat, left45 }, { 40, 27, 0, 13, flat, left45 }, { 41, 28, 0, 13, flat, left45 },
    { 42, 28, 0, 13, flat, left45 }, { 43, 29, 0, 13, flat, left45 }, { 44, 30, 0, 13, flat, left45 }, { 45, 30, 0, 13, flat, left45 }, { 46, 31, 0, 13, flat, left45 }, { 47, 32, 0, 13, flat, left45 },
    { 48, 32, 0, 13, flat, left45 }, { 49, 33, 0, 13, flat, left45 }, { 50, 34, 0, 12, flat, left45 }, { 51, 35, 0, 12, flat, left45 }, { 52, 35, 0, 12, flat, left45 }, { 53, 36, 0, 12, flat, left45 },
    { 54, 37, 0, 12, flat, left45 }, { 55, 38, 0, 12, flat, left45 }, { 56, 39, 0, 12, flat, left45 }, { 57, 39, 0, 12, flat, left45 }, { 58, 40, 0, 12, flat, left45 }, { 59, 41, 0, 12, flat, left45 },
    { 60, 42, 0, 12, flat, left45 }, { 61, 43, 0, 12, flat, left45 }, { 61, 44, 0, 12, flat, left45 }, { 62, 45, 0, 11, flat, left45 }, { 63, 46, 0, 11, flat, left45 }, { 64, 47, 0, 11, flat, left45 },
    { 64, 48, 0, 11, flat, left45 }, { 65, 49, 0, 11, flat, left45 }, { 66, 50, 0, 11, flat, left45 }, { 66, 51, 0, 11, flat, left45 }, { 67, 52, 0, 11, flat, left45 }, { 68, 53, 0, 11, flat, left45 },
    { 68, 54, 0, 11, flat, left45 }, { 69, 55, 0, 11, flat, left45 }, { 70, 56, 0, 11, flat, left45 }, { 70, 57, 0, 11, flat, left45 }, { 71, 58, 0, 10, flat, left45 }, { 71, 59, 0, 10, flat, left45 },
    { 72, 60, 0, 10, flat, left45 }, { 72, 61, 0, 10, flat, left45 }, { 73, 62, 0, 10, flat, left45 }, { 73, 63, 0, 10, flat, left45 }, { 74, 64, 0, 10, flat, left45 }, { 74, 65, 0, 10, flat, left45 },
    { 75, 66, 0, 10, flat, left45 }, { 75, 67, 0, 10, flat, left45 }, { 75, 68, 0, 10, flat, left45 }, { 76, 69, 0, 10, flat, left45 }, { 76, 70, 0, 10, flat, left45 }, { 76, 71, 0, 10, flat, left45 },
    { 77, 72, 0,  9, flat, left45 }, { 77, 73, 0,  9, flat, left45 }, { 77, 74, 0,  9, flat, left45 }, { 77, 75, 0,  9, flat, left45 }, { 78, 76, 0,  9, flat, left45 }, { 78, 77, 0,  9, flat, left45 },
    { 78, 78, 0,  9, flat, left45 }, { 78, 79, 0,  9, flat, left45 }, { 78, 80, 0,  9, flat, left45 }, { 79, 81, 0,  9, flat, left45 }, { 79, 82, 0,  9, flat, left45 }, { 79, 83, 0,  9, flat, left45 },
    { 79, 84, 0,  9, flat, left45 }, { 79, 85, 0,  9, flat, left45 }, { 79, 86, 0,  9, flat, left45 }, { 80, 87, 0,  9, flat, left45 }, { 80, 88, 0,  8, flat, left45 }, { 80, 89, 0,  8, flat, left45 },
    { 80, 90, 0,  8, flat, left45 }, { 80, 91, 0,  8, flat, left45 }, { 80, 92, 0,  8, flat, left45 }, { 80, 93, 0,  8, flat, left45 }, { 80, 94, 0,  8, flat, left45 }, { 80, 95, 0,  8, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CACC7, {
    { 16,  31, 0, 24, flat, left45 }, { 16,  30, 0, 24, flat, left45 }, { 16,  29, 0, 24, flat, left45 }, { 16,  28, 0, 24, flat, left45 }, { 16,  27, 0, 24, flat, left45 }, { 16,  26, 0, 24, flat, left45 },
    { 16,  25, 0, 24, flat, left45 }, { 16,  24, 0, 23, flat, left45 }, { 17,  23, 0, 23, flat, left45 }, { 17,  22, 0, 23, flat, left45 }, { 17,  21, 0, 23, flat, left45 }, { 17,  20, 0, 23, flat, left45 },
    { 17,  19, 0, 23, flat, left45 }, { 17,  18, 0, 23, flat, left45 }, { 18,  17, 0, 23, flat, left45 }, { 18,  16, 0, 23, flat, left45 }, { 18,  15, 0, 23, flat, left45 }, { 18,  14, 0, 23, flat, left45 },
    { 18,  13, 0, 23, flat, left45 }, { 19,  12, 0, 23, flat, left45 }, { 19,  11, 0, 23, flat, left45 }, { 19,  10, 0, 22, flat, left45 }, { 19,   9, 0, 22, flat, left45 }, { 20,   8, 0, 22, flat, left45 },
    { 20,   7, 0, 22, flat, left45 }, { 20,   6, 0, 22, flat, left45 }, { 21,   5, 0, 22, flat, left45 }, { 21,   4, 0, 22, flat, left45 }, { 21,   3, 0, 22, flat, left45 }, { 22,   2, 0, 22, flat, left45 },
    { 22,   1, 0, 22, flat, left45 }, { 23,   0, 0, 22, flat, left45 }, { 23,  -1, 0, 22, flat, left45 }, { 24,  -2, 0, 22, flat, left45 }, { 24,  -3, 0, 22, flat, left45 }, { 25,  -4, 0, 22, flat, left45 },
    { 25,  -5, 0, 21, flat, left45 }, { 26,  -6, 0, 21, flat, left45 }, { 26,  -7, 0, 21, flat, left45 }, { 27,  -8, 0, 21, flat, left45 }, { 28,  -9, 0, 21, flat, left45 }, { 28, -10, 0, 21, flat, left45 },
    { 29, -11, 0, 21, flat, left45 }, { 30, -12, 0, 21, flat, left45 }, { 30, -13, 0, 21, flat, left45 }, { 31, -14, 0, 21, flat, left45 }, { 32, -15, 0, 21, flat, left45 }, { 32, -16, 0, 21, flat, left45 },
    { 33, -17, 0, 21, flat, left45 }, { 34, -18, 0, 20, flat, left45 }, { 35, -19, 0, 20, flat, left45 }, { 35, -20, 0, 20, flat, left45 }, { 36, -21, 0, 20, flat, left45 }, { 37, -22, 0, 20, flat, left45 },
    { 38, -23, 0, 20, flat, left45 }, { 39, -24, 0, 20, flat, left45 }, { 39, -25, 0, 20, flat, left45 }, { 40, -26, 0, 20, flat, left45 }, { 41, -27, 0, 20, flat, left45 }, { 42, -28, 0, 20, flat, left45 },
    { 43, -29, 0, 20, flat, left45 }, { 44, -29, 0, 20, flat, left45 }, { 45, -30, 0, 19, flat, left45 }, { 46, -31, 0, 19, flat, left45 }, { 47, -32, 0, 19, flat, left45 }, { 48, -32, 0, 19, flat, left45 },
    { 49, -33, 0, 19, flat, left45 }, { 50, -34, 0, 19, flat, left45 }, { 51, -34, 0, 19, flat, left45 }, { 52, -35, 0, 19, flat, left45 }, { 53, -36, 0, 19, flat, left45 }, { 54, -36, 0, 19, flat, left45 },
    { 55, -37, 0, 19, flat, left45 }, { 56, -38, 0, 19, flat, left45 }, { 57, -38, 0, 19, flat, left45 }, { 58, -39, 0, 18, flat, left45 }, { 59, -39, 0, 18, flat, left45 }, { 60, -40, 0, 18, flat, left45 },
    { 61, -40, 0, 18, flat, left45 }, { 62, -41, 0, 18, flat, left45 }, { 63, -41, 0, 18, flat, left45 }, { 64, -42, 0, 18, flat, left45 }, { 65, -42, 0, 18, flat, left45 }, { 66, -43, 0, 18, flat, left45 },
    { 67, -43, 0, 18, flat, left45 }, { 68, -43, 0, 18, flat, left45 }, { 69, -44, 0, 18, flat, left45 }, { 70, -44, 0, 18, flat, left45 }, { 71, -44, 0, 18, flat, left45 }, { 72, -45, 0, 17, flat, left45 },
    { 73, -45, 0, 17, flat, left45 }, { 74, -45, 0, 17, flat, left45 }, { 75, -45, 0, 17, flat, left45 }, { 76, -46, 0, 17, flat, left45 }, { 77, -46, 0, 17, flat, left45 }, { 78, -46, 0, 17, flat, left45 },
    { 79, -46, 0, 17, flat, left45 }, { 80, -46, 0, 17, flat, left45 }, { 81, -47, 0, 17, flat, left45 }, { 82, -47, 0, 17, flat, left45 }, { 83, -47, 0, 17, flat, left45 }, { 84, -47, 0, 17, flat, left45 },
    { 85, -47, 0, 17, flat, left45 }, { 86, -47, 0, 17, flat, left45 }, { 87, -48, 0, 17, flat, left45 }, { 88, -48, 0, 16, flat, left45 }, { 89, -48, 0, 16, flat, left45 }, { 90, -48, 0, 16, flat, left45 },
    { 91, -48, 0, 16, flat, left45 }, { 92, -48, 0, 16, flat, left45 }, { 93, -48, 0, 16, flat, left45 }, { 94, -48, 0, 16, flat, left45 }, { 95, -48, 0, 16, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CB0C2, {
    {  31, 16, 0, 0, flat, right45 }, {  30, 16, 0, 0, flat, right45 }, {  29, 16, 0, 0, flat, right45 }, {  28, 16, 0, 0, flat, right45 }, {  27, 16, 0, 0, flat, right45 }, {  26, 16, 0, 0, flat, right45 },
    {  25, 16, 0, 0, flat, right45 }, {  24, 16, 0, 1, flat, right45 }, {  23, 17, 0, 1, flat, right45 }, {  22, 17, 0, 1, flat, right45 }, {  21, 17, 0, 1, flat, right45 }, {  20, 17, 0, 1, flat, right45 },
    {  19, 17, 0, 1, flat, right45 }, {  18, 17, 0, 1, flat, right45 }, {  17, 18, 0, 1, flat, right45 }, {  16, 18, 0, 1, flat, right45 }, {  15, 18, 0, 1, flat, right45 }, {  14, 18, 0, 1, flat, right45 },
    {  13, 18, 0, 1, flat, right45 }, {  12, 19, 0, 1, flat, right45 }, {  11, 19, 0, 1, flat, right45 }, {  10, 19, 0, 2, flat, right45 }, {   9, 19, 0, 2, flat, right45 }, {   8, 20, 0, 2, flat, right45 },
    {   7, 20, 0, 2, flat, right45 }, {   6, 20, 0, 2, flat, right45 }, {   5, 21, 0, 2, flat, right45 }, {   4, 21, 0, 2, flat, right45 }, {   3, 21, 0, 2, flat, right45 }, {   2, 22, 0, 2, flat, right45 },
    {   1, 22, 0, 2, flat, right45 }, {   0, 23, 0, 2, flat, right45 }, {  -1, 23, 0, 2, flat, right45 }, {  -2, 24, 0, 2, flat, right45 }, {  -3, 24, 0, 2, flat, right45 }, {  -4, 25, 0, 2, flat, right45 },
    {  -5, 25, 0, 3, flat, right45 }, {  -6, 26, 0, 3, flat, right45 }, {  -7, 26, 0, 3, flat, right45 }, {  -8, 27, 0, 3, flat, right45 }, {  -9, 28, 0, 3, flat, right45 }, { -10, 28, 0, 3, flat, right45 },
    { -11, 29, 0, 3, flat, right45 }, { -12, 30, 0, 3, flat, right45 }, { -13, 30, 0, 3, flat, right45 }, { -14, 31, 0, 3, flat, right45 }, { -15, 32, 0, 3, flat, right45 }, { -16, 32, 0, 3, flat, right45 },
    { -17, 33, 0, 3, flat, right45 }, { -18, 34, 0, 4, flat, right45 }, { -19, 35, 0, 4, flat, right45 }, { -20, 35, 0, 4, flat, right45 }, { -21, 36, 0, 4, flat, right45 }, { -22, 37, 0, 4, flat, right45 },
    { -23, 38, 0, 4, flat, right45 }, { -24, 39, 0, 4, flat, right45 }, { -25, 39, 0, 4, flat, right45 }, { -26, 40, 0, 4, flat, right45 }, { -27, 41, 0, 4, flat, right45 }, { -28, 42, 0, 4, flat, right45 },
    { -29, 43, 0, 4, flat, right45 }, { -29, 44, 0, 4, flat, right45 }, { -30, 45, 0, 5, flat, right45 }, { -31, 46, 0, 5, flat, right45 }, { -32, 47, 0, 5, flat, right45 }, { -32, 48, 0, 5, flat, right45 },
    { -33, 49, 0, 5, flat, right45 }, { -34, 50, 0, 5, flat, right45 }, { -34, 51, 0, 5, flat, right45 }, { -35, 52, 0, 5, flat, right45 }, { -36, 53, 0, 5, flat, right45 }, { -36, 54, 0, 5, flat, right45 },
    { -37, 55, 0, 5, flat, right45 }, { -38, 56, 0, 5, flat, right45 }, { -38, 57, 0, 5, flat, right45 }, { -39, 58, 0, 6, flat, right45 }, { -39, 59, 0, 6, flat, right45 }, { -40, 60, 0, 6, flat, right45 },
    { -40, 61, 0, 6, flat, right45 }, { -41, 62, 0, 6, flat, right45 }, { -41, 63, 0, 6, flat, right45 }, { -42, 64, 0, 6, flat, right45 }, { -42, 65, 0, 6, flat, right45 }, { -43, 66, 0, 6, flat, right45 },
    { -43, 67, 0, 6, flat, right45 }, { -43, 68, 0, 6, flat, right45 }, { -44, 69, 0, 6, flat, right45 }, { -44, 70, 0, 6, flat, right45 }, { -44, 71, 0, 6, flat, right45 }, { -45, 72, 0, 7, flat, right45 },
    { -45, 73, 0, 7, flat, right45 }, { -45, 74, 0, 7, flat, right45 }, { -45, 75, 0, 7, flat, right45 }, { -46, 76, 0, 7, flat, right45 }, { -46, 77, 0, 7, flat, right45 }, { -46, 78, 0, 7, flat, right45 },
    { -46, 79, 0, 7, flat, right45 }, { -46, 80, 0, 7, flat, right45 }, { -47, 81, 0, 7, flat, right45 }, { -47, 82, 0, 7, flat, right45 }, { -47, 83, 0, 7, flat, right45 }, { -47, 84, 0, 7, flat, right45 },
    { -47, 85, 0, 7, flat, right45 }, { -47, 86, 0, 7, flat, right45 }, { -48, 87, 0, 7, flat, right45 }, { -48, 88, 0, 8, flat, right45 }, { -48, 89, 0, 8, flat, right45 }, { -48, 90, 0, 8, flat, right45 },
    { -48, 91, 0, 8, flat, right45 }, { -48, 92, 0, 8, flat, right45 }, { -48, 93, 0, 8, flat, right45 }, { -48, 94, 0, 8, flat, right45 }, { -48, 95, 0, 8, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CB4BD, {
    { 16,  0, 0,  8, flat, right45 }, { 16,  1, 0,  8, flat, right45 }, { 16,  2, 0,  8, flat, right45 }, { 16,  3, 0,  8, flat, right45 }, { 16,  4, 0,  8, flat, right45 }, { 16,  5, 0,  8, flat, right45 },
    { 16,  6, 0,  8, flat, right45 }, { 16,  7, 0,  8, flat, right45 }, { 16,  8, 0,  9, flat, right45 }, { 17,  9, 0,  9, flat, right45 }, { 17, 10, 0,  9, flat, right45 }, { 17, 11, 0,  9, flat, right45 },
    { 17, 12, 0,  9, flat, right45 }, { 17, 13, 0,  9, flat, right45 }, { 17, 14, 0,  9, flat, right45 }, { 18, 15, 0,  9, flat, right45 }, { 18, 16, 0,  9, flat, right45 }, { 18, 17, 0,  9, flat, right45 },
    { 18, 18, 0,  9, flat, right45 }, { 18, 19, 0,  9, flat, right45 }, { 19, 20, 0,  9, flat, right45 }, { 19, 21, 0,  9, flat, right45 }, { 19, 22, 0, 10, flat, right45 }, { 19, 23, 0, 10, flat, right45 },
    { 20, 24, 0, 10, flat, right45 }, { 20, 25, 0, 10, flat, right45 }, { 20, 26, 0, 10, flat, right45 }, { 21, 27, 0, 10, flat, right45 }, { 21, 28, 0, 10, flat, right45 }, { 21, 29, 0, 10, flat, right45 },
    { 22, 30, 0, 10, flat, right45 }, { 22, 31, 0, 10, flat, right45 }, { 23, 32, 0, 10, flat, right45 }, { 23, 33, 0, 10, flat, right45 }, { 24, 34, 0, 10, flat, right45 }, { 24, 35, 0, 10, flat, right45 },
    { 25, 36, 0, 10, flat, right45 }, { 25, 37, 0, 11, flat, right45 }, { 26, 38, 0, 11, flat, right45 }, { 26, 39, 0, 11, flat, right45 }, { 27, 40, 0, 11, flat, right45 }, { 28, 41, 0, 11, flat, right45 },
    { 28, 42, 0, 11, flat, right45 }, { 29, 43, 0, 11, flat, right45 }, { 30, 44, 0, 11, flat, right45 }, { 30, 45, 0, 11, flat, right45 }, { 31, 46, 0, 11, flat, right45 }, { 32, 47, 0, 11, flat, right45 },
    { 32, 48, 0, 11, flat, right45 }, { 33, 49, 0, 11, flat, right45 }, { 34, 50, 0, 12, flat, right45 }, { 35, 51, 0, 12, flat, right45 }, { 35, 52, 0, 12, flat, right45 }, { 36, 53, 0, 12, flat, right45 },
    { 37, 54, 0, 12, flat, right45 }, { 38, 55, 0, 12, flat, right45 }, { 39, 56, 0, 12, flat, right45 }, { 39, 57, 0, 12, flat, right45 }, { 40, 58, 0, 12, flat, right45 }, { 41, 59, 0, 12, flat, right45 },
    { 42, 60, 0, 12, flat, right45 }, { 43, 61, 0, 12, flat, right45 }, { 44, 61, 0, 12, flat, right45 }, { 45, 62, 0, 13, flat, right45 }, { 46, 63, 0, 13, flat, right45 }, { 47, 64, 0, 13, flat, right45 },
    { 48, 64, 0, 13, flat, right45 }, { 49, 65, 0, 13, flat, right45 }, { 50, 66, 0, 13, flat, right45 }, { 51, 66, 0, 13, flat, right45 }, { 52, 67, 0, 13, flat, right45 }, { 53, 68, 0, 13, flat, right45 },
    { 54, 68, 0, 13, flat, right45 }, { 55, 69, 0, 13, flat, right45 }, { 56, 70, 0, 13, flat, right45 }, { 57, 70, 0, 13, flat, right45 }, { 58, 71, 0, 14, flat, right45 }, { 59, 71, 0, 14, flat, right45 },
    { 60, 72, 0, 14, flat, right45 }, { 61, 72, 0, 14, flat, right45 }, { 62, 73, 0, 14, flat, right45 }, { 63, 73, 0, 14, flat, right45 }, { 64, 74, 0, 14, flat, right45 }, { 65, 74, 0, 14, flat, right45 },
    { 66, 75, 0, 14, flat, right45 }, { 67, 75, 0, 14, flat, right45 }, { 68, 75, 0, 14, flat, right45 }, { 69, 76, 0, 14, flat, right45 }, { 70, 76, 0, 14, flat, right45 }, { 71, 76, 0, 14, flat, right45 },
    { 72, 77, 0, 15, flat, right45 }, { 73, 77, 0, 15, flat, right45 }, { 74, 77, 0, 15, flat, right45 }, { 75, 77, 0, 15, flat, right45 }, { 76, 78, 0, 15, flat, right45 }, { 77, 78, 0, 15, flat, right45 },
    { 78, 78, 0, 15, flat, right45 }, { 79, 78, 0, 15, flat, right45 }, { 80, 78, 0, 15, flat, right45 }, { 81, 79, 0, 15, flat, right45 }, { 82, 79, 0, 15, flat, right45 }, { 83, 79, 0, 15, flat, right45 },
    { 84, 79, 0, 15, flat, right45 }, { 85, 79, 0, 15, flat, right45 }, { 86, 79, 0, 15, flat, right45 }, { 87, 80, 0, 15, flat, right45 }, { 88, 80, 0, 16, flat, right45 }, { 89, 80, 0, 16, flat, right45 },
    { 90, 80, 0, 16, flat, right45 }, { 91, 80, 0, 16, flat, right45 }, { 92, 80, 0, 16, flat, right45 }, { 93, 80, 0, 16, flat, right45 }, { 94, 80, 0, 16, flat, right45 }, { 95, 80, 0, 16, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CB8C1, {
    {  0,  16, 0, 16, flat, right45 }, {  1,  16, 0, 16, flat, right45 }, {  2,  16, 0, 16, flat, right45 }, {  3,  16, 0, 16, flat, right45 }, {  4,  16, 0, 16, flat, right45 }, {  5,  16, 0, 16, flat, right45 },
    {  6,  16, 0, 16, flat, right45 }, {  7,  16, 0, 16, flat, right45 }, {  8,  16, 0, 17, flat, right45 }, {  9,  15, 0, 17, flat, right45 }, { 10,  15, 0, 17, flat, right45 }, { 11,  15, 0, 17, flat, right45 },
    { 12,  15, 0, 17, flat, right45 }, { 13,  15, 0, 17, flat, right45 }, { 14,  15, 0, 17, flat, right45 }, { 15,  14, 0, 17, flat, right45 }, { 16,  14, 0, 17, flat, right45 }, { 17,  14, 0, 17, flat, right45 },
    { 18,  14, 0, 17, flat, right45 }, { 19,  14, 0, 17, flat, right45 }, { 20,  13, 0, 17, flat, right45 }, { 21,  13, 0, 17, flat, right45 }, { 22,  13, 0, 18, flat, right45 }, { 23,  13, 0, 18, flat, right45 },
    { 24,  12, 0, 18, flat, right45 }, { 25,  12, 0, 18, flat, right45 }, { 26,  12, 0, 18, flat, right45 }, { 27,  11, 0, 18, flat, right45 }, { 28,  11, 0, 18, flat, right45 }, { 29,  11, 0, 18, flat, right45 },
    { 30,  10, 0, 18, flat, right45 }, { 31,  10, 0, 18, flat, right45 }, { 32,   9, 0, 18, flat, right45 }, { 33,   9, 0, 18, flat, right45 }, { 34,   8, 0, 18, flat, right45 }, { 35,   8, 0, 18, flat, right45 },
    { 36,   7, 0, 18, flat, right45 }, { 37,   7, 0, 19, flat, right45 }, { 38,   6, 0, 19, flat, right45 }, { 39,   6, 0, 19, flat, right45 }, { 40,   5, 0, 19, flat, right45 }, { 41,   4, 0, 19, flat, right45 },
    { 42,   4, 0, 19, flat, right45 }, { 43,   3, 0, 19, flat, right45 }, { 44,   2, 0, 19, flat, right45 }, { 45,   2, 0, 19, flat, right45 }, { 46,   1, 0, 19, flat, right45 }, { 47,   0, 0, 19, flat, right45 },
    { 48,   0, 0, 19, flat, right45 }, { 49,  -1, 0, 19, flat, right45 }, { 50,  -2, 0, 20, flat, right45 }, { 51,  -3, 0, 20, flat, right45 }, { 52,  -3, 0, 20, flat, right45 }, { 53,  -4, 0, 20, flat, right45 },
    { 54,  -5, 0, 20, flat, right45 }, { 55,  -6, 0, 20, flat, right45 }, { 56,  -7, 0, 20, flat, right45 }, { 57,  -7, 0, 20, flat, right45 }, { 58,  -8, 0, 20, flat, right45 }, { 59,  -9, 0, 20, flat, right45 },
    { 60, -10, 0, 20, flat, right45 }, { 61, -11, 0, 20, flat, right45 }, { 61, -12, 0, 20, flat, right45 }, { 62, -13, 0, 21, flat, right45 }, { 63, -14, 0, 21, flat, right45 }, { 64, -15, 0, 21, flat, right45 },
    { 64, -16, 0, 21, flat, right45 }, { 65, -17, 0, 21, flat, right45 }, { 66, -18, 0, 21, flat, right45 }, { 66, -19, 0, 21, flat, right45 }, { 67, -20, 0, 21, flat, right45 }, { 68, -21, 0, 21, flat, right45 },
    { 68, -22, 0, 21, flat, right45 }, { 69, -23, 0, 21, flat, right45 }, { 70, -24, 0, 21, flat, right45 }, { 70, -25, 0, 21, flat, right45 }, { 71, -26, 0, 22, flat, right45 }, { 71, -27, 0, 22, flat, right45 },
    { 72, -28, 0, 22, flat, right45 }, { 72, -29, 0, 22, flat, right45 }, { 73, -30, 0, 22, flat, right45 }, { 73, -31, 0, 22, flat, right45 }, { 74, -32, 0, 22, flat, right45 }, { 74, -33, 0, 22, flat, right45 },
    { 75, -34, 0, 22, flat, right45 }, { 75, -35, 0, 22, flat, right45 }, { 75, -36, 0, 22, flat, right45 }, { 76, -37, 0, 22, flat, right45 }, { 76, -38, 0, 22, flat, right45 }, { 76, -39, 0, 22, flat, right45 },
    { 77, -40, 0, 23, flat, right45 }, { 77, -41, 0, 23, flat, right45 }, { 77, -42, 0, 23, flat, right45 }, { 77, -43, 0, 23, flat, right45 }, { 78, -44, 0, 23, flat, right45 }, { 78, -45, 0, 23, flat, right45 },
    { 78, -46, 0, 23, flat, right45 }, { 78, -47, 0, 23, flat, right45 }, { 78, -48, 0, 23, flat, right45 }, { 79, -49, 0, 23, flat, right45 }, { 79, -50, 0, 23, flat, right45 }, { 79, -51, 0, 23, flat, right45 },
    { 79, -52, 0, 23, flat, right45 }, { 79, -53, 0, 23, flat, right45 }, { 79, -54, 0, 23, flat, right45 }, { 80, -55, 0, 23, flat, right45 }, { 80, -56, 0, 24, flat, right45 }, { 80, -57, 0, 24, flat, right45 },
    { 80, -58, 0, 24, flat, right45 }, { 80, -59, 0, 24, flat, right45 }, { 80, -60, 0, 24, flat, right45 }, { 80, -61, 0, 24, flat, right45 }, { 80, -62, 0, 24, flat, right45 }, { 80, -63, 0, 24, flat, right45 },
    { 80, -64, 0, 24, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CBCCE, {
    {  16,  31, 0, 24, flat, right45 }, {  16,  30, 0, 24, flat, right45 }, {  16,  29, 0, 24, flat, right45 }, {  16,  28, 0, 24, flat, right45 }, {  16,  27, 0, 24, flat, right45 },
    {  16,  26, 0, 24, flat, right45 }, {  16,  25, 0, 24, flat, right45 }, {  16,  24, 0, 25, flat, right45 }, {  15,  23, 0, 25, flat, right45 }, {  15,  22, 0, 25, flat, right45 },
    {  15,  21, 0, 25, flat, right45 }, {  15,  20, 0, 25, flat, right45 }, {  15,  19, 0, 25, flat, right45 }, {  15,  18, 0, 25, flat, right45 }, {  14,  17, 0, 25, flat, right45 },
    {  14,  16, 0, 25, flat, right45 }, {  14,  15, 0, 25, flat, right45 }, {  14,  14, 0, 25, flat, right45 }, {  14,  13, 0, 25, flat, right45 }, {  13,  12, 0, 25, flat, right45 },
    {  13,  11, 0, 25, flat, right45 }, {  13,  10, 0, 26, flat, right45 }, {  13,   9, 0, 26, flat, right45 }, {  12,   8, 0, 26, flat, right45 }, {  12,   7, 0, 26, flat, right45 },
    {  12,   6, 0, 26, flat, right45 }, {  11,   5, 0, 26, flat, right45 }, {  11,   4, 0, 26, flat, right45 }, {  11,   3, 0, 26, flat, right45 }, {  10,   2, 0, 26, flat, right45 },
    {  10,   1, 0, 26, flat, right45 }, {   9,   0, 0, 26, flat, right45 }, {   9,  -1, 0, 26, flat, right45 }, {   8,  -2, 0, 26, flat, right45 }, {   8,  -3, 0, 26, flat, right45 },
    {   7,  -4, 0, 26, flat, right45 }, {   7,  -5, 0, 27, flat, right45 }, {   6,  -6, 0, 27, flat, right45 }, {   6,  -7, 0, 27, flat, right45 }, {   5,  -8, 0, 27, flat, right45 },
    {   4,  -9, 0, 27, flat, right45 }, {   4, -10, 0, 27, flat, right45 }, {   3, -11, 0, 27, flat, right45 }, {   2, -12, 0, 27, flat, right45 }, {   2, -13, 0, 27, flat, right45 },
    {   1, -14, 0, 27, flat, right45 }, {   0, -15, 0, 27, flat, right45 }, {   0, -16, 0, 27, flat, right45 }, {  -1, -17, 0, 27, flat, right45 }, {  -2, -18, 0, 28, flat, right45 },
    {  -3, -19, 0, 28, flat, right45 }, {  -3, -20, 0, 28, flat, right45 }, {  -4, -21, 0, 28, flat, right45 }, {  -5, -22, 0, 28, flat, right45 }, {  -6, -23, 0, 28, flat, right45 },
    {  -7, -24, 0, 28, flat, right45 }, {  -7, -25, 0, 28, flat, right45 }, {  -8, -26, 0, 28, flat, right45 }, {  -9, -27, 0, 28, flat, right45 }, { -10, -28, 0, 28, flat, right45 },
    { -11, -29, 0, 28, flat, right45 }, { -12, -29, 0, 28, flat, right45 }, { -13, -30, 0, 29, flat, right45 }, { -14, -31, 0, 29, flat, right45 }, { -15, -32, 0, 29, flat, right45 },
    { -16, -32, 0, 29, flat, right45 }, { -17, -33, 0, 29, flat, right45 }, { -18, -34, 0, 29, flat, right45 }, { -19, -34, 0, 29, flat, right45 }, { -20, -35, 0, 29, flat, right45 },
    { -21, -36, 0, 29, flat, right45 }, { -22, -36, 0, 29, flat, right45 }, { -23, -37, 0, 29, flat, right45 }, { -24, -38, 0, 29, flat, right45 }, { -25, -38, 0, 29, flat, right45 },
    { -26, -39, 0, 30, flat, right45 }, { -27, -39, 0, 30, flat, right45 }, { -28, -40, 0, 30, flat, right45 }, { -29, -40, 0, 30, flat, right45 }, { -30, -41, 0, 30, flat, right45 },
    { -31, -41, 0, 30, flat, right45 }, { -32, -42, 0, 30, flat, right45 }, { -33, -42, 0, 30, flat, right45 }, { -34, -43, 0, 30, flat, right45 }, { -35, -43, 0, 30, flat, right45 },
    { -36, -43, 0, 30, flat, right45 }, { -37, -44, 0, 30, flat, right45 }, { -38, -44, 0, 30, flat, right45 }, { -39, -44, 0, 30, flat, right45 }, { -40, -45, 0, 31, flat, right45 },
    { -41, -45, 0, 31, flat, right45 }, { -42, -45, 0, 31, flat, right45 }, { -43, -45, 0, 31, flat, right45 }, { -44, -46, 0, 31, flat, right45 }, { -45, -46, 0, 31, flat, right45 },
    { -46, -46, 0, 31, flat, right45 }, { -47, -46, 0, 31, flat, right45 }, { -48, -46, 0, 31, flat, right45 }, { -49, -47, 0, 31, flat, right45 }, { -50, -47, 0, 31, flat, right45 },
    { -51, -47, 0, 31, flat, right45 }, { -52, -47, 0, 31, flat, right45 }, { -53, -47, 0, 31, flat, right45 }, { -54, -47, 0, 31, flat, right45 }, { -55, -48, 0, 31, flat, right45 },
    { -56, -48, 0,  0, flat, right45 }, { -57, -48, 0,  0, flat, right45 }, { -58, -48, 0,  0, flat, right45 }, { -59, -48, 0,  0, flat, right45 }, { -60, -48, 0,  0, flat, right45 },
    { -61, -48, 0,  0, flat, right45 }, { -62, -48, 0,  0, flat, right45 }, { -63, -48, 0,  0, flat, right45 }, { -64, -48, 0,  0, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4762, {
    { 31, 16, 0, 0, flat,   left45 }, { 30, 16, 0, 0, flat,   left45 }, { 29, 16, 0, 0, flat,   left45 }, { 28, 16, 0, 0, flat,   left45 }, { 27, 16, 0, 0, flat,   left45 }, { 26, 16, 0, 0, flat,   left45 },
    { 25, 16, 0, 0, flat,   left45 }, { 24, 16, 0, 0, flat,   left45 }, { 23, 16, 0, 0, up12,   left22 }, { 22, 16, 0, 0, up12,   left22 }, { 21, 16, 1, 0, up12,   left22 }, { 20, 16, 1, 0, up12,   left22 },
    { 19, 16, 1, 0, up12,   left22 }, { 18, 16, 1, 0, up12,   left22 }, { 17, 16, 1, 0, up12,   left22 }, { 16, 16, 1, 0, up12,   left22 }, { 15, 16, 2, 0, up12,   left22 }, { 14, 16, 2, 0, up12,   left22 },
    { 13, 16, 2, 0, up12,   left22 }, { 12, 16, 2, 0, up12,   left22 }, { 11, 16, 3, 0, up12,   left22 }, { 10, 16, 3, 0, up12,   left22 }, {  9, 16, 3, 0, up12,   left22 }, {  8, 16, 4, 0, up12,   left22 },
    {  7, 16, 4, 0, up25, unbanked }, {  6, 16, 4, 0, up25, unbanked }, {  5, 16, 5, 0, up25, unbanked }, {  4, 16, 5, 0, up25, unbanked }, {  3, 16, 6, 0, up25, unbanked }, {  2, 16, 6, 0, up25, unbanked },
    {  1, 16, 7, 0, up25, unbanked }, {  0, 16, 7, 0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4884, {
    { 16,  0, 0, 8, flat,   left45 }, { 16,  1, 0, 8, flat,   left45 }, { 16,  2, 0, 8, flat,   left45 }, { 16,  3, 0, 8, flat,   left45 }, { 16,  4, 0, 8, flat,   left45 }, { 16,  5, 0, 8, flat,   left45 },
    { 16,  6, 0, 8, flat,   left45 }, { 16,  7, 0, 8, flat,   left45 }, { 16,  8, 0, 8, up12,   left22 }, { 16,  9, 0, 8, up12,   left22 }, { 16, 10, 1, 8, up12,   left22 }, { 16, 11, 1, 8, up12,   left22 },
    { 16, 12, 1, 8, up12,   left22 }, { 16, 13, 1, 8, up12,   left22 }, { 16, 14, 1, 8, up12,   left22 }, { 16, 15, 1, 8, up12,   left22 }, { 16, 16, 2, 8, up12,   left22 }, { 16, 17, 2, 8, up12,   left22 },
    { 16, 18, 2, 8, up12,   left22 }, { 16, 19, 2, 8, up12,   left22 }, { 16, 20, 3, 8, up12,   left22 }, { 16, 21, 3, 8, up12,   left22 }, { 16, 22, 3, 8, up12,   left22 }, { 16, 23, 4, 8, up12,   left22 },
    { 16, 24, 4, 8, up25, unbanked }, { 16, 25, 4, 8, up25, unbanked }, { 16, 26, 5, 8, up25, unbanked }, { 16, 27, 5, 8, up25, unbanked }, { 16, 28, 6, 8, up25, unbanked }, { 16, 29, 6, 8, up25, unbanked },
    { 16, 30, 7, 8, up25, unbanked }, { 16, 31, 7, 8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C49A6, {
    {  0, 16, 0, 16, flat,   left45 }, {  1, 16, 0, 16, flat,   left45 }, {  2, 16, 0, 16, flat,   left45 }, {  3, 16, 0, 16, flat,   left45 }, {  4, 16, 0, 16, flat,   left45 }, {  5, 16, 0, 16, flat,   left45 },
    {  6, 16, 0, 16, flat,   left45 }, {  7, 16, 0, 16, flat,   left45 }, {  8, 16, 0, 16, up12,   left22 }, {  9, 16, 0, 16, up12,   left22 }, { 10, 16, 1, 16, up12,   left22 }, { 11, 16, 1, 16, up12,   left22 },
    { 12, 16, 1, 16, up12,   left22 }, { 13, 16, 1, 16, up12,   left22 }, { 14, 16, 1, 16, up12,   left22 }, { 15, 16, 1, 16, up12,   left22 }, { 16, 16, 2, 16, up12,   left22 }, { 17, 16, 2, 16, up12,   left22 },
    { 18, 16, 2, 16, up12,   left22 }, { 19, 16, 2, 16, up12,   left22 }, { 20, 16, 3, 16, up12,   left22 }, { 21, 16, 3, 16, up12,   left22 }, { 22, 16, 3, 16, up12,   left22 }, { 23, 16, 4, 16, up12,   left22 },
    { 24, 16, 4, 16, up25, unbanked }, { 25, 16, 4, 16, up25, unbanked }, { 26, 16, 5, 16, up25, unbanked }, { 27, 16, 5, 16, up25, unbanked }, { 28, 16, 6, 16, up25, unbanked }, { 29, 16, 6, 16, up25, unbanked },
    { 30, 16, 7, 16, up25, unbanked }, { 31, 16, 7, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4AC8, {
    { 16, 31, 0, 24, flat,   left45 }, { 16, 30, 0, 24, flat,   left45 }, { 16, 29, 0, 24, flat,   left45 }, { 16, 28, 0, 24, flat,   left45 }, { 16, 27, 0, 24, flat,   left45 }, { 16, 26, 0, 24, flat,   left45 },
    { 16, 25, 0, 24, flat,   left45 }, { 16, 24, 0, 24, flat,   left45 }, { 16, 23, 0, 24, up12,   left22 }, { 16, 22, 0, 24, up12,   left22 }, { 16, 21, 1, 24, up12,   left22 }, { 16, 20, 1, 24, up12,   left22 },
    { 16, 19, 1, 24, up12,   left22 }, { 16, 18, 1, 24, up12,   left22 }, { 16, 17, 1, 24, up12,   left22 }, { 16, 16, 1, 24, up12,   left22 }, { 16, 15, 2, 24, up12,   left22 }, { 16, 14, 2, 24, up12,   left22 },
    { 16, 13, 2, 24, up12,   left22 }, { 16, 12, 2, 24, up12,   left22 }, { 16, 11, 3, 24, up12,   left22 }, { 16, 10, 3, 24, up12,   left22 }, { 16,  9, 3, 24, up12,   left22 }, { 16,  8, 4, 24, up12,   left22 },
    { 16,  7, 4, 24, up25, unbanked }, { 16,  6, 4, 24, up25, unbanked }, { 16,  5, 5, 24, up25, unbanked }, { 16,  4, 5, 24, up25, unbanked }, { 16,  3, 6, 24, up25, unbanked }, { 16,  2, 6, 24, up25, unbanked },
    { 16,  1, 7, 24, up25, unbanked }, { 16,  0, 7, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4BEA, {
    { 31, 16, 0, 0, flat,  right45 }, { 30, 16, 0, 0, flat,  right45 }, { 29, 16, 0, 0, flat,  right45 }, { 28, 16, 0, 0, flat,  right45 }, { 27, 16, 0, 0, flat,  right45 }, { 26, 16, 0, 0, flat,  right45 },
    { 25, 16, 0, 0, flat,  right45 }, { 24, 16, 0, 0, flat,  right45 }, { 23, 16, 0, 0, up12,  right22 }, { 22, 16, 0, 0, up12,  right22 }, { 21, 16, 1, 0, up12,  right22 }, { 20, 16, 1, 0, up12,  right22 },
    { 19, 16, 1, 0, up12,  right22 }, { 18, 16, 1, 0, up12,  right22 }, { 17, 16, 1, 0, up12,  right22 }, { 16, 16, 1, 0, up12,  right22 }, { 15, 16, 2, 0, up12,  right22 }, { 14, 16, 2, 0, up12,  right22 },
    { 13, 16, 2, 0, up12,  right22 }, { 12, 16, 2, 0, up12,  right22 }, { 11, 16, 3, 0, up12,  right22 }, { 10, 16, 3, 0, up12,  right22 }, {  9, 16, 3, 0, up12,  right22 }, {  8, 16, 4, 0, up12,  right22 },
    {  7, 16, 4, 0, up25, unbanked }, {  6, 16, 4, 0, up25, unbanked }, {  5, 16, 5, 0, up25, unbanked }, {  4, 16, 5, 0, up25, unbanked }, {  3, 16, 6, 0, up25, unbanked }, {  2, 16, 6, 0, up25, unbanked },
    {  1, 16, 7, 0, up25, unbanked }, {  0, 16, 7, 0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4D0C, {
    { 16,  0, 0, 8, flat,  right45 }, { 16,  1, 0, 8, flat,  right45 }, { 16,  2, 0, 8, flat,  right45 }, { 16,  3, 0, 8, flat,  right45 }, { 16,  4, 0, 8, flat,  right45 }, { 16,  5, 0, 8, flat,  right45 },
    { 16,  6, 0, 8, flat,  right45 }, { 16,  7, 0, 8, flat,  right45 }, { 16,  8, 0, 8, up12,  right22 }, { 16,  9, 0, 8, up12,  right22 }, { 16, 10, 1, 8, up12,  right22 }, { 16, 11, 1, 8, up12,  right22 },
    { 16, 12, 1, 8, up12,  right22 }, { 16, 13, 1, 8, up12,  right22 }, { 16, 14, 1, 8, up12,  right22 }, { 16, 15, 1, 8, up12,  right22 }, { 16, 16, 2, 8, up12,  right22 }, { 16, 17, 2, 8, up12,  right22 },
    { 16, 18, 2, 8, up12,  right22 }, { 16, 19, 2, 8, up12,  right22 }, { 16, 20, 3, 8, up12,  right22 }, { 16, 21, 3, 8, up12,  right22 }, { 16, 22, 3, 8, up12,  right22 }, { 16, 23, 4, 8, up12,  right22 },
    { 16, 24, 4, 8, up25, unbanked }, { 16, 25, 4, 8, up25, unbanked }, { 16, 26, 5, 8, up25, unbanked }, { 16, 27, 5, 8, up25, unbanked }, { 16, 28, 6, 8, up25, unbanked }, { 16, 29, 6, 8, up25, unbanked },
    { 16, 30, 7, 8, up25, unbanked }, { 16, 31, 7, 8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4E2E, {
    {  0, 16, 0, 16, flat,  right45 }, {  1, 16, 0, 16, flat,  right45 }, {  2, 16, 0, 16, flat,  right45 }, {  3, 16, 0, 16, flat,  right45 }, {  4, 16, 0, 16, flat,  right45 }, {  5, 16, 0, 16, flat,  right45 },
    {  6, 16, 0, 16, flat,  right45 }, {  7, 16, 0, 16, flat,  right45 }, {  8, 16, 0, 16, up12,  right22 }, {  9, 16, 0, 16, up12,  right22 }, { 10, 16, 1, 16, up12,  right22 }, { 11, 16, 1, 16, up12,  right22 },
    { 12, 16, 1, 16, up12,  right22 }, { 13, 16, 1, 16, up12,  right22 }, { 14, 16, 1, 16, up12,  right22 }, { 15, 16, 1, 16, up12,  right22 }, { 16, 16, 2, 16, up12,  right22 }, { 17, 16, 2, 16, up12,  right22 },
    { 18, 16, 2, 16, up12,  right22 }, { 19, 16, 2, 16, up12,  right22 }, { 20, 16, 3, 16, up12,  right22 }, { 21, 16, 3, 16, up12,  right22 }, { 22, 16, 3, 16, up12,  right22 }, { 23, 16, 4, 16, up12,  right22 },
    { 24, 16, 4, 16, up25, unbanked }, { 25, 16, 4, 16, up25, unbanked }, { 26, 16, 5, 16, up25, unbanked }, { 27, 16, 5, 16, up25, unbanked }, { 28, 16, 6, 16, up25, unbanked }, { 29, 16, 6, 16, up25, unbanked },
    { 30, 16, 7, 16, up25, unbanked }, { 31, 16, 7, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4F50, {
    { 16, 31, 0, 24, flat,  right45 }, { 16, 30, 0, 24, flat,  right45 }, { 16, 29, 0, 24, flat,  right45 }, { 16, 28, 0, 24, flat,  right45 }, { 16, 27, 0, 24, flat,  right45 }, { 16, 26, 0, 24, flat,  right45 },
    { 16, 25, 0, 24, flat,  right45 }, { 16, 24, 0, 24, flat,  right45 }, { 16, 23, 0, 24, up12,  right22 }, { 16, 22, 0, 24, up12,  right22 }, { 16, 21, 1, 24, up12,  right22 }, { 16, 20, 1, 24, up12,  right22 },
    { 16, 19, 1, 24, up12,  right22 }, { 16, 18, 1, 24, up12,  right22 }, { 16, 17, 1, 24, up12,  right22 }, { 16, 16, 1, 24, up12,  right22 }, { 16, 15, 2, 24, up12,  right22 }, { 16, 14, 2, 24, up12,  right22 },
    { 16, 13, 2, 24, up12,  right22 }, { 16, 12, 2, 24, up12,  right22 }, { 16, 11, 3, 24, up12,  right22 }, { 16, 10, 3, 24, up12,  right22 }, { 16,  9, 3, 24, up12,  right22 }, { 16,  8, 4, 24, up12,  right22 },
    { 16,  7, 4, 24, up25, unbanked }, { 16,  6, 4, 24, up25, unbanked }, { 16,  5, 5, 24, up25, unbanked }, { 16,  4, 5, 24, up25, unbanked }, { 16,  3, 6, 24, up25, unbanked }, { 16,  2, 6, 24, up25, unbanked },
    { 16,  1, 7, 24, up25, unbanked }, { 16,  0, 7, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5072, {
    { 31, 16, 0, 0, up25, unbanked }, { 30, 16, 0, 0, up25, unbanked }, { 29, 16, 1, 0, up25, unbanked }, { 28, 16, 1, 0, up25, unbanked }, { 27, 16, 2, 0, up25, unbanked }, { 26, 16, 2, 0, up25, unbanked },
    { 25, 16, 3, 0, up25, unbanked }, { 24, 16, 3, 0, up25, unbanked }, { 23, 16, 4, 0, up12,   left22 }, { 22, 16, 4, 0, up12,   left22 }, { 21, 16, 4, 0, up12,   left22 }, { 20, 16, 5, 0, up12,   left22 },
    { 19, 16, 5, 0, up12,   left22 }, { 18, 16, 5, 0, up12,   left22 }, { 17, 16, 6, 0, up12,   left22 }, { 16, 16, 6, 0, up12,   left22 }, { 15, 16, 6, 0, up12,   left22 }, { 14, 16, 6, 0, up12,   left22 },
    { 13, 16, 7, 0, up12,   left22 }, { 12, 16, 7, 0, up12,   left22 }, { 11, 16, 7, 0, up12,   left22 }, { 10, 16, 7, 0, up12,   left22 }, {  9, 16, 7, 0, flat,   left45 }, {  8, 16, 7, 0, flat,   left45 },
    {  7, 16, 8, 0, flat,   left45 }, {  6, 16, 8, 0, flat,   left45 }, {  5, 16, 8, 0, flat,   left45 }, {  4, 16, 8, 0, flat,   left45 }, {  3, 16, 8, 0, flat,   left45 }, {  2, 16, 8, 0, flat,   left45 },
    {  1, 16, 8, 0, flat,   left45 }, {  0, 16, 8, 0, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C51A6, {
    { 16,  0, 0, 8, up25, unbanked }, { 16,  1, 0, 8, up25, unbanked }, { 16,  2, 1, 8, up25, unbanked }, { 16,  3, 1, 8, up25, unbanked }, { 16,  4, 2, 8, up25, unbanked }, { 16,  5, 2, 8, up25, unbanked },
    { 16,  6, 3, 8, up25, unbanked }, { 16,  7, 3, 8, up25, unbanked }, { 16,  8, 4, 8, up12,   left22 }, { 16,  9, 4, 8, up12,   left22 }, { 16, 10, 4, 8, up12,   left22 }, { 16, 11, 5, 8, up12,   left22 },
    { 16, 12, 5, 8, up12,   left22 }, { 16, 13, 5, 8, up12,   left22 }, { 16, 14, 6, 8, up12,   left22 }, { 16, 15, 6, 8, up12,   left22 }, { 16, 16, 6, 8, up12,   left22 }, { 16, 17, 6, 8, up12,   left22 },
    { 16, 18, 7, 8, up12,   left22 }, { 16, 19, 7, 8, up12,   left22 }, { 16, 20, 7, 8, up12,   left22 }, { 16, 21, 7, 8, up12,   left22 }, { 16, 22, 7, 8, flat,   left45 }, { 16, 23, 7, 8, flat,   left45 },
    { 16, 24, 8, 8, flat,   left45 }, { 16, 25, 8, 8, flat,   left45 }, { 16, 26, 8, 8, flat,   left45 }, { 16, 27, 8, 8, flat,   left45 }, { 16, 28, 8, 8, flat,   left45 }, { 16, 29, 8, 8, flat,   left45 },
    { 16, 30, 8, 8, flat,   left45 }, { 16, 31, 8, 8, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C52DA, {
    {  0, 16, 0, 16, up25, unbanked }, {  1, 16, 0, 16, up25, unbanked }, {  2, 16, 1, 16, up25, unbanked }, {  3, 16, 1, 16, up25, unbanked }, {  4, 16, 2, 16, up25, unbanked }, {  5, 16, 2, 16, up25, unbanked },
    {  6, 16, 3, 16, up25, unbanked }, {  7, 16, 3, 16, up25, unbanked }, {  8, 16, 4, 16, up12,   left22 }, {  9, 16, 4, 16, up12,   left22 }, { 10, 16, 4, 16, up12,   left22 }, { 11, 16, 5, 16, up12,   left22 },
    { 12, 16, 5, 16, up12,   left22 }, { 13, 16, 5, 16, up12,   left22 }, { 14, 16, 6, 16, up12,   left22 }, { 15, 16, 6, 16, up12,   left22 }, { 16, 16, 6, 16, up12,   left22 }, { 17, 16, 6, 16, up12,   left22 },
    { 18, 16, 7, 16, up12,   left22 }, { 19, 16, 7, 16, up12,   left22 }, { 20, 16, 7, 16, up12,   left22 }, { 21, 16, 7, 16, up12,   left22 }, { 22, 16, 7, 16, flat,   left45 }, { 23, 16, 7, 16, flat,   left45 },
    { 24, 16, 8, 16, flat,   left45 }, { 25, 16, 8, 16, flat,   left45 }, { 26, 16, 8, 16, flat,   left45 }, { 27, 16, 8, 16, flat,   left45 }, { 28, 16, 8, 16, flat,   left45 }, { 29, 16, 8, 16, flat,   left45 },
    { 30, 16, 8, 16, flat,   left45 }, { 31, 16, 8, 16, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C540E, {
    { 16, 31, 0, 24, up25, unbanked }, { 16, 30, 0, 24, up25, unbanked }, { 16, 29, 1, 24, up25, unbanked }, { 16, 28, 1, 24, up25, unbanked }, { 16, 27, 2, 24, up25, unbanked }, { 16, 26, 2, 24, up25, unbanked },
    { 16, 25, 3, 24, up25, unbanked }, { 16, 24, 3, 24, up25, unbanked }, { 16, 23, 4, 24, up12,   left22 }, { 16, 22, 4, 24, up12,   left22 }, { 16, 21, 4, 24, up12,   left22 }, { 16, 20, 5, 24, up12,   left22 },
    { 16, 19, 5, 24, up12,   left22 }, { 16, 18, 5, 24, up12,   left22 }, { 16, 17, 6, 24, up12,   left22 }, { 16, 16, 6, 24, up12,   left22 }, { 16, 15, 6, 24, up12,   left22 }, { 16, 14, 6, 24, up12,   left22 },
    { 16, 13, 7, 24, up12,   left22 }, { 16, 12, 7, 24, up12,   left22 }, { 16, 11, 7, 24, up12,   left22 }, { 16, 10, 7, 24, up12,   left22 }, { 16,  9, 7, 24, flat,   left45 }, { 16,  8, 7, 24, flat,   left45 },
    { 16,  7, 8, 24, flat,   left45 }, { 16,  6, 8, 24, flat,   left45 }, { 16,  5, 8, 24, flat,   left45 }, { 16,  4, 8, 24, flat,   left45 }, { 16,  3, 8, 24, flat,   left45 }, { 16,  2, 8, 24, flat,   left45 },
    { 16,  1, 8, 24, flat,   left45 }, { 16,  0, 8, 24, flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5542, {
    { 31, 16, 0, 0, up25, unbanked }, { 30, 16, 0, 0, up25, unbanked }, { 29, 16, 1, 0, up25, unbanked }, { 28, 16, 1, 0, up25, unbanked }, { 27, 16, 2, 0, up25, unbanked }, { 26, 16, 2, 0, up25, unbanked },
    { 25, 16, 3, 0, up25, unbanked }, { 24, 16, 3, 0, up25, unbanked }, { 23, 16, 4, 0, up12,  right22 }, { 22, 16, 4, 0, up12,  right22 }, { 21, 16, 4, 0, up12,  right22 }, { 20, 16, 5, 0, up12,  right22 },
    { 19, 16, 5, 0, up12,  right22 }, { 18, 16, 5, 0, up12,  right22 }, { 17, 16, 6, 0, up12,  right22 }, { 16, 16, 6, 0, up12,  right22 }, { 15, 16, 6, 0, up12,  right22 }, { 14, 16, 6, 0, up12,  right22 },
    { 13, 16, 7, 0, up12,  right22 }, { 12, 16, 7, 0, up12,  right22 }, { 11, 16, 7, 0, up12,  right22 }, { 10, 16, 7, 0, up12,  right22 }, {  9, 16, 7, 0, flat,  right45 }, {  8, 16, 7, 0, flat,  right45 },
    {  7, 16, 8, 0, flat,  right45 }, {  6, 16, 8, 0, flat,  right45 }, {  5, 16, 8, 0, flat,  right45 }, {  4, 16, 8, 0, flat,  right45 }, {  3, 16, 8, 0, flat,  right45 }, {  2, 16, 8, 0, flat,  right45 },
    {  1, 16, 8, 0, flat,  right45 }, {  0, 16, 8, 0, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5676, {
    { 16,  0, 0, 8, up25, unbanked }, { 16,  1, 0, 8, up25, unbanked }, { 16,  2, 1, 8, up25, unbanked }, { 16,  3, 1, 8, up25, unbanked }, { 16,  4, 2, 8, up25, unbanked }, { 16,  5, 2, 8, up25, unbanked },
    { 16,  6, 3, 8, up25, unbanked }, { 16,  7, 3, 8, up25, unbanked }, { 16,  8, 4, 8, up12,  right22 }, { 16,  9, 4, 8, up12,  right22 }, { 16, 10, 4, 8, up12,  right22 }, { 16, 11, 5, 8, up12,  right22 },
    { 16, 12, 5, 8, up12,  right22 }, { 16, 13, 5, 8, up12,  right22 }, { 16, 14, 6, 8, up12,  right22 }, { 16, 15, 6, 8, up12,  right22 }, { 16, 16, 6, 8, up12,  right22 }, { 16, 17, 6, 8, up12,  right22 },
    { 16, 18, 7, 8, up12,  right22 }, { 16, 19, 7, 8, up12,  right22 }, { 16, 20, 7, 8, up12,  right22 }, { 16, 21, 7, 8, up12,  right22 }, { 16, 22, 7, 8, flat,  right45 }, { 16, 23, 7, 8, flat,  right45 },
    { 16, 24, 8, 8, flat,  right45 }, { 16, 25, 8, 8, flat,  right45 }, { 16, 26, 8, 8, flat,  right45 }, { 16, 27, 8, 8, flat,  right45 }, { 16, 28, 8, 8, flat,  right45 }, { 16, 29, 8, 8, flat,  right45 },
    { 16, 30, 8, 8, flat,  right45 }, { 16, 31, 8, 8, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C57AA, {
    {  0, 16, 0, 16, up25, unbanked }, {  1, 16, 0, 16, up25, unbanked }, {  2, 16, 1, 16, up25, unbanked }, {  3, 16, 1, 16, up25, unbanked }, {  4, 16, 2, 16, up25, unbanked }, {  5, 16, 2, 16, up25, unbanked },
    {  6, 16, 3, 16, up25, unbanked }, {  7, 16, 3, 16, up25, unbanked }, {  8, 16, 4, 16, up12,  right22 }, {  9, 16, 4, 16, up12,  right22 }, { 10, 16, 4, 16, up12,  right22 }, { 11, 16, 5, 16, up12,  right22 },
    { 12, 16, 5, 16, up12,  right22 }, { 13, 16, 5, 16, up12,  right22 }, { 14, 16, 6, 16, up12,  right22 }, { 15, 16, 6, 16, up12,  right22 }, { 16, 16, 6, 16, up12,  right22 }, { 17, 16, 6, 16, up12,  right22 },
    { 18, 16, 7, 16, up12,  right22 }, { 19, 16, 7, 16, up12,  right22 }, { 20, 16, 7, 16, up12,  right22 }, { 21, 16, 7, 16, up12,  right22 }, { 22, 16, 7, 16, flat,  right45 }, { 23, 16, 7, 16, flat,  right45 },
    { 24, 16, 8, 16, flat,  right45 }, { 25, 16, 8, 16, flat,  right45 }, { 26, 16, 8, 16, flat,  right45 }, { 27, 16, 8, 16, flat,  right45 }, { 28, 16, 8, 16, flat,  right45 }, { 29, 16, 8, 16, flat,  right45 },
    { 30, 16, 8, 16, flat,  right45 }, { 31, 16, 8, 16, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C58DE, {
    { 16, 31, 0, 24, up25, unbanked }, { 16, 30, 0, 24, up25, unbanked }, { 16, 29, 1, 24, up25, unbanked }, { 16, 28, 1, 24, up25, unbanked }, { 16, 27, 2, 24, up25, unbanked }, { 16, 26, 2, 24, up25, unbanked },
    { 16, 25, 3, 24, up25, unbanked }, { 16, 24, 3, 24, up25, unbanked }, { 16, 23, 4, 24, up12,  right22 }, { 16, 22, 4, 24, up12,  right22 }, { 16, 21, 4, 24, up12,  right22 }, { 16, 20, 5, 24, up12,  right22 },
    { 16, 19, 5, 24, up12,  right22 }, { 16, 18, 5, 24, up12,  right22 }, { 16, 17, 6, 24, up12,  right22 }, { 16, 16, 6, 24, up12,  right22 }, { 16, 15, 6, 24, up12,  right22 }, { 16, 14, 6, 24, up12,  right22 },
    { 16, 13, 7, 24, up12,  right22 }, { 16, 12, 7, 24, up12,  right22 }, { 16, 11, 7, 24, up12,  right22 }, { 16, 10, 7, 24, up12,  right22 }, { 16,  9, 7, 24, flat,  right45 }, { 16,  8, 7, 24, flat,  right45 },
    { 16,  7, 8, 24, flat,  right45 }, { 16,  6, 8, 24, flat,  right45 }, { 16,  5, 8, 24, flat,  right45 }, { 16,  4, 8, 24, flat,  right45 }, { 16,  3, 8, 24, flat,  right45 }, { 16,  2, 8, 24, flat,  right45 },
    { 16,  1, 8, 24, flat,  right45 }, { 16,  0, 8, 24, flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6322, {
    { 31, 16, 8, 0,   flat,   left45 }, { 30, 16, 8, 0,   flat,   left45 }, { 29, 16, 8, 0,   flat,   left45 }, { 28, 16, 8, 0,   flat,   left45 }, { 27, 16, 8, 0,   flat,   left45 }, { 26, 16, 8, 0,   flat,   left45 },
    { 25, 16, 8, 0,   flat,   left45 }, { 24, 16, 8, 0,   flat,   left45 }, { 23, 16, 7, 0, down12,   left22 }, { 22, 16, 7, 0, down12,   left22 }, { 21, 16, 7, 0, down12,   left22 }, { 20, 16, 7, 0, down12,   left22 },
    { 19, 16, 7, 0, down12,   left22 }, { 18, 16, 7, 0, down12,   left22 }, { 17, 16, 6, 0, down12,   left22 }, { 16, 16, 6, 0, down12,   left22 }, { 15, 16, 6, 0, down12,   left22 }, { 14, 16, 6, 0, down12,   left22 },
    { 13, 16, 5, 0, down12,   left22 }, { 12, 16, 5, 0, down12,   left22 }, { 11, 16, 5, 0, down12,   left22 }, { 10, 16, 4, 0, down12,   left22 }, {  9, 16, 4, 0, down12,   left22 }, {  8, 16, 4, 0, down12,   left22 },
    {  7, 16, 3, 0, down25, unbanked }, {  6, 16, 3, 0, down25, unbanked }, {  5, 16, 2, 0, down25, unbanked }, {  4, 16, 2, 0, down25, unbanked }, {  3, 16, 1, 0, down25, unbanked }, {  2, 16, 1, 0, down25, unbanked },
    {  1, 16, 0, 0, down25, unbanked }, {  0, 16, 0, 0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6444, {
    { 16,  0, 8, 8,   flat,   left45 }, { 16,  1, 8, 8,   flat,   left45 }, { 16,  2, 8, 8,   flat,   left45 }, { 16,  3, 8, 8,   flat,   left45 }, { 16,  4, 8, 8,   flat,   left45 },
    { 16,  5, 8, 8,   flat,   left45 }, { 16,  6, 8, 8,   flat,   left45 }, { 16,  7, 8, 8,   flat,   left45 }, { 16,  8, 7, 8, down12,   left22 }, { 16,  9, 7, 8, down12,   left22 },
    { 16, 10, 7, 8, down12,   left22 }, { 16, 11, 7, 8, down12,   left22 }, { 16, 12, 7, 8, down12,   left22 }, { 16, 13, 7, 8, down12,   left22 }, { 16, 14, 6, 8, down12,   left22 },
    { 16, 15, 6, 8, down12,   left22 }, { 16, 16, 6, 8, down12,   left22 }, { 16, 17, 6, 8, down12,   left22 }, { 16, 18, 5, 8, down12,   left22 }, { 16, 19, 5, 8, down12,   left22 },
    { 16, 20, 5, 8, down12,   left22 }, { 16, 21, 4, 8, down12,   left22 }, { 16, 22, 4, 8, down12,   left22 }, { 16, 23, 4, 8, down12,   left22 }, { 16, 24, 3, 8, down25, unbanked },
    { 16, 25, 3, 8, down25, unbanked }, { 16, 26, 2, 8, down25, unbanked }, { 16, 27, 2, 8, down25, unbanked }, { 16, 28, 1, 8, down25, unbanked }, { 16, 29, 1, 8, down25, unbanked },
    { 16, 30, 0, 8, down25, unbanked }, { 16, 31, 0, 8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6566, {
    {  0, 16, 8, 16,   flat,   left45 }, {  1, 16, 8, 16,   flat,   left45 }, {  2, 16, 8, 16,   flat,   left45 }, {  3, 16, 8, 16,   flat,   left45 }, {  4, 16, 8, 16,   flat,   left45 },
    {  5, 16, 8, 16,   flat,   left45 }, {  6, 16, 8, 16,   flat,   left45 }, {  7, 16, 8, 16,   flat,   left45 }, {  8, 16, 7, 16, down12,   left22 }, {  9, 16, 7, 16, down12,   left22 },
    { 10, 16, 7, 16, down12,   left22 }, { 11, 16, 7, 16, down12,   left22 }, { 12, 16, 7, 16, down12,   left22 }, { 13, 16, 7, 16, down12,   left22 }, { 14, 16, 6, 16, down12,   left22 },
    { 15, 16, 6, 16, down12,   left22 }, { 16, 16, 6, 16, down12,   left22 }, { 17, 16, 6, 16, down12,   left22 }, { 18, 16, 5, 16, down12,   left22 }, { 19, 16, 5, 16, down12,   left22 },
    { 20, 16, 5, 16, down12,   left22 }, { 21, 16, 4, 16, down12,   left22 }, { 22, 16, 4, 16, down12,   left22 }, { 23, 16, 4, 16, down12,   left22 }, { 24, 16, 3, 16, down25, unbanked },
    { 25, 16, 3, 16, down25, unbanked }, { 26, 16, 2, 16, down25, unbanked }, { 27, 16, 2, 16, down25, unbanked }, { 28, 16, 1, 16, down25, unbanked }, { 29, 16, 1, 16, down25, unbanked },
    { 30, 16, 0, 16, down25, unbanked }, { 31, 16, 0, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6688, {
    { 16, 31, 8, 24,   flat,   left45 }, { 16, 30, 8, 24,   flat,   left45 }, { 16, 29, 8, 24,   flat,   left45 }, { 16, 28, 8, 24,   flat,   left45 }, { 16, 27, 8, 24,   flat,   left45 },
    { 16, 26, 8, 24,   flat,   left45 }, { 16, 25, 8, 24,   flat,   left45 }, { 16, 24, 8, 24,   flat,   left45 }, { 16, 23, 7, 24, down12,   left22 }, { 16, 22, 7, 24, down12,   left22 },
    { 16, 21, 7, 24, down12,   left22 }, { 16, 20, 7, 24, down12,   left22 }, { 16, 19, 7, 24, down12,   left22 }, { 16, 18, 7, 24, down12,   left22 }, { 16, 17, 6, 24, down12,   left22 },
    { 16, 16, 6, 24, down12,   left22 }, { 16, 15, 6, 24, down12,   left22 }, { 16, 14, 6, 24, down12,   left22 }, { 16, 13, 5, 24, down12,   left22 }, { 16, 12, 5, 24, down12,   left22 },
    { 16, 11, 5, 24, down12,   left22 }, { 16, 10, 4, 24, down12,   left22 }, { 16,  9, 4, 24, down12,   left22 }, { 16,  8, 4, 24, down12,   left22 }, { 16,  7, 3, 24, down25, unbanked },
    { 16,  6, 3, 24, down25, unbanked }, { 16,  5, 2, 24, down25, unbanked }, { 16,  4, 2, 24, down25, unbanked }, { 16,  3, 1, 24, down25, unbanked }, { 16,  2, 1, 24, down25, unbanked },
    { 16,  1, 0, 24, down25, unbanked }, { 16,  0, 0, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C67AA, {
    { 31, 16, 8, 0,   flat,  right45 }, { 30, 16, 8, 0,   flat,  right45 }, { 29, 16, 8, 0,   flat,  right45 }, { 28, 16, 8, 0,   flat,  right45 }, { 27, 16, 8, 0,   flat,  right45 }, { 26, 16, 8, 0,   flat,  right45 },
    { 25, 16, 8, 0,   flat,  right45 }, { 24, 16, 8, 0,   flat,  right45 }, { 23, 16, 7, 0, down12,  right22 }, { 22, 16, 7, 0, down12,  right22 }, { 21, 16, 7, 0, down12,  right22 }, { 20, 16, 7, 0, down12,  right22 },
    { 19, 16, 7, 0, down12,  right22 }, { 18, 16, 7, 0, down12,  right22 }, { 17, 16, 6, 0, down12,  right22 }, { 16, 16, 6, 0, down12,  right22 }, { 15, 16, 6, 0, down12,  right22 }, { 14, 16, 6, 0, down12,  right22 },
    { 13, 16, 5, 0, down12,  right22 }, { 12, 16, 5, 0, down12,  right22 }, { 11, 16, 5, 0, down12,  right22 }, { 10, 16, 4, 0, down12,  right22 }, {  9, 16, 4, 0, down12,  right22 }, {  8, 16, 4, 0, down12,  right22 },
    {  7, 16, 3, 0, down25, unbanked }, {  6, 16, 3, 0, down25, unbanked }, {  5, 16, 2, 0, down25, unbanked }, {  4, 16, 2, 0, down25, unbanked }, {  3, 16, 1, 0, down25, unbanked }, {  2, 16, 1, 0, down25, unbanked },
    {  1, 16, 0, 0, down25, unbanked }, {  0, 16, 0, 0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C68CC, {
    { 16,  0, 8, 8,   flat,  right45 }, { 16,  1, 8, 8,   flat,  right45 }, { 16,  2, 8, 8,   flat,  right45 }, { 16,  3, 8, 8,   flat,  right45 }, { 16,  4, 8, 8,   flat,  right45 },
    { 16,  5, 8, 8,   flat,  right45 }, { 16,  6, 8, 8,   flat,  right45 }, { 16,  7, 8, 8,   flat,  right45 }, { 16,  8, 7, 8, down12,  right22 }, { 16,  9, 7, 8, down12,  right22 },
    { 16, 10, 7, 8, down12,  right22 }, { 16, 11, 7, 8, down12,  right22 }, { 16, 12, 7, 8, down12,  right22 }, { 16, 13, 7, 8, down12,  right22 }, { 16, 14, 6, 8, down12,  right22 },
    { 16, 15, 6, 8, down12,  right22 }, { 16, 16, 6, 8, down12,  right22 }, { 16, 17, 6, 8, down12,  right22 }, { 16, 18, 5, 8, down12,  right22 }, { 16, 19, 5, 8, down12,  right22 },
    { 16, 20, 5, 8, down12,  right22 }, { 16, 21, 4, 8, down12,  right22 }, { 16, 22, 4, 8, down12,  right22 }, { 16, 23, 4, 8, down12,  right22 }, { 16, 24, 3, 8, down25, unbanked },
    { 16, 25, 3, 8, down25, unbanked }, { 16, 26, 2, 8, down25, unbanked }, { 16, 27, 2, 8, down25, unbanked }, { 16, 28, 1, 8, down25, unbanked }, { 16, 29, 1, 8, down25, unbanked },
    { 16, 30, 0, 8, down25, unbanked }, { 16, 31, 0, 8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C69EE, {
    {  0, 16, 8, 16,   flat,  right45 }, {  1, 16, 8, 16,   flat,  right45 }, {  2, 16, 8, 16,   flat,  right45 }, {  3, 16, 8, 16,   flat,  right45 }, {  4, 16, 8, 16,   flat,  right45 },
    {  5, 16, 8, 16,   flat,  right45 }, {  6, 16, 8, 16,   flat,  right45 }, {  7, 16, 8, 16,   flat,  right45 }, {  8, 16, 7, 16, down12,  right22 }, {  9, 16, 7, 16, down12,  right22 },
    { 10, 16, 7, 16, down12,  right22 }, { 11, 16, 7, 16, down12,  right22 }, { 12, 16, 7, 16, down12,  right22 }, { 13, 16, 7, 16, down12,  right22 }, { 14, 16, 6, 16, down12,  right22 },
    { 15, 16, 6, 16, down12,  right22 }, { 16, 16, 6, 16, down12,  right22 }, { 17, 16, 6, 16, down12,  right22 }, { 18, 16, 5, 16, down12,  right22 }, { 19, 16, 5, 16, down12,  right22 },
    { 20, 16, 5, 16, down12,  right22 }, { 21, 16, 4, 16, down12,  right22 }, { 22, 16, 4, 16, down12,  right22 }, { 23, 16, 4, 16, down12,  right22 }, { 24, 16, 3, 16, down25, unbanked },
    { 25, 16, 3, 16, down25, unbanked }, { 26, 16, 2, 16, down25, unbanked }, { 27, 16, 2, 16, down25, unbanked }, { 28, 16, 1, 16, down25, unbanked }, { 29, 16, 1, 16, down25, unbanked },
    { 30, 16, 0, 16, down25, unbanked }, { 31, 16, 0, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6B10, {
    { 16, 31, 8, 24,   flat,  right45 }, { 16, 30, 8, 24,   flat,  right45 }, { 16, 29, 8, 24,   flat,  right45 }, { 16, 28, 8, 24,   flat,  right45 }, { 16, 27, 8, 24,   flat,  right45 },
    { 16, 26, 8, 24,   flat,  right45 }, { 16, 25, 8, 24,   flat,  right45 }, { 16, 24, 8, 24,   flat,  right45 }, { 16, 23, 7, 24, down12,  right22 }, { 16, 22, 7, 24, down12,  right22 },
    { 16, 21, 7, 24, down12,  right22 }, { 16, 20, 7, 24, down12,  right22 }, { 16, 19, 7, 24, down12,  right22 }, { 16, 18, 7, 24, down12,  right22 }, { 16, 17, 6, 24, down12,  right22 },
    { 16, 16, 6, 24, down12,  right22 }, { 16, 15, 6, 24, down12,  right22 }, { 16, 14, 6, 24, down12,  right22 }, { 16, 13, 5, 24, down12,  right22 }, { 16, 12, 5, 24, down12,  right22 },
    { 16, 11, 5, 24, down12,  right22 }, { 16, 10, 4, 24, down12,  right22 }, { 16,  9, 4, 24, down12,  right22 }, { 16,  8, 4, 24, down12,  right22 }, { 16,  7, 3, 24, down25, unbanked },
    { 16,  6, 3, 24, down25, unbanked }, { 16,  5, 2, 24, down25, unbanked }, { 16,  4, 2, 24, down25, unbanked }, { 16,  3, 1, 24, down25, unbanked }, { 16,  2, 1, 24, down25, unbanked },
    { 16,  1, 0, 24, down25, unbanked }, { 16,  0, 0, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5A12, {
    { 31, 16, 7, 0, down25, unbanked }, { 30, 16, 7, 0, down25, unbanked }, { 29, 16, 6, 0, down25, unbanked }, { 28, 16, 6, 0, down25, unbanked }, { 27, 16, 5, 0, down25, unbanked },
    { 26, 16, 5, 0, down25, unbanked }, { 25, 16, 4, 0, down25, unbanked }, { 24, 16, 4, 0, down25, unbanked }, { 23, 16, 4, 0, down12,   left22 }, { 22, 16, 3, 0, down12,   left22 },
    { 21, 16, 3, 0, down12,   left22 }, { 20, 16, 3, 0, down12,   left22 }, { 19, 16, 2, 0, down12,   left22 }, { 18, 16, 2, 0, down12,   left22 }, { 17, 16, 2, 0, down12,   left22 },
    { 16, 16, 2, 0, down12,   left22 }, { 15, 16, 1, 0, down12,   left22 }, { 14, 16, 1, 0, down12,   left22 }, { 13, 16, 1, 0, down12,   left22 }, { 12, 16, 1, 0, down12,   left22 },
    { 11, 16, 1, 0, down12,   left22 }, { 10, 16, 1, 0, down12,   left22 }, {  9, 16, 0, 0,   flat,   left45 }, {  8, 16, 0, 0,   flat,   left45 }, {  7, 16, 0, 0,   flat,   left45 },
    {  6, 16, 0, 0,   flat,   left45 }, {  5, 16, 0, 0,   flat,   left45 }, {  4, 16, 0, 0,   flat,   left45 }, {  3, 16, 0, 0,   flat,   left45 }, {  2, 16, 0, 0,   flat,   left45 },
    {  1, 16, 0, 0,   flat,   left45 }, {  0, 16, 0, 0,   flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5B34, {
    { 16,  0, 7, 8, down25, unbanked }, { 16,  1, 7, 8, down25, unbanked }, { 16,  2, 6, 8, down25, unbanked }, { 16,  3, 6, 8, down25, unbanked }, { 16,  4, 5, 8, down25, unbanked }, { 16,  5, 5, 8, down25, unbanked },
    { 16,  6, 4, 8, down25, unbanked }, { 16,  7, 4, 8, down25, unbanked }, { 16,  8, 4, 8, down12,   left22 }, { 16,  9, 3, 8, down12,   left22 }, { 16, 10, 3, 8, down12,   left22 }, { 16, 11, 3, 8, down12,   left22 },
    { 16, 12, 2, 8, down12,   left22 }, { 16, 13, 2, 8, down12,   left22 }, { 16, 14, 2, 8, down12,   left22 }, { 16, 15, 2, 8, down12,   left22 }, { 16, 16, 1, 8, down12,   left22 }, { 16, 17, 1, 8, down12,   left22 },
    { 16, 18, 1, 8, down12,   left22 }, { 16, 19, 1, 8, down12,   left22 }, { 16, 20, 1, 8, down12,   left22 }, { 16, 21, 1, 8, down12,   left22 }, { 16, 22, 0, 8,   flat,   left45 }, { 16, 23, 0, 8,   flat,   left45 },
    { 16, 24, 0, 8,   flat,   left45 }, { 16, 25, 0, 8,   flat,   left45 }, { 16, 26, 0, 8,   flat,   left45 }, { 16, 27, 0, 8,   flat,   left45 }, { 16, 28, 0, 8,   flat,   left45 }, { 16, 29, 0, 8,   flat,   left45 },
    { 16, 30, 0, 8,   flat,   left45 }, { 16, 31, 0, 8,   flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5C56, {
    {  0, 16, 7, 16, down25, unbanked }, {  1, 16, 7, 16, down25, unbanked }, {  2, 16, 6, 16, down25, unbanked }, {  3, 16, 6, 16, down25, unbanked }, {  4, 16, 5, 16, down25, unbanked },
    {  5, 16, 5, 16, down25, unbanked }, {  6, 16, 4, 16, down25, unbanked }, {  7, 16, 4, 16, down25, unbanked }, {  8, 16, 4, 16, down12,   left22 }, {  9, 16, 3, 16, down12,   left22 },
    { 10, 16, 3, 16, down12,   left22 }, { 11, 16, 3, 16, down12,   left22 }, { 12, 16, 2, 16, down12,   left22 }, { 13, 16, 2, 16, down12,   left22 }, { 14, 16, 2, 16, down12,   left22 },
    { 15, 16, 2, 16, down12,   left22 }, { 16, 16, 1, 16, down12,   left22 }, { 17, 16, 1, 16, down12,   left22 }, { 18, 16, 1, 16, down12,   left22 }, { 19, 16, 1, 16, down12,   left22 },
    { 20, 16, 1, 16, down12,   left22 }, { 21, 16, 1, 16, down12,   left22 }, { 22, 16, 0, 16,   flat,   left45 }, { 23, 16, 0, 16,   flat,   left45 }, { 24, 16, 0, 16,   flat,   left45 },
    { 25, 16, 0, 16,   flat,   left45 }, { 26, 16, 0, 16,   flat,   left45 }, { 27, 16, 0, 16,   flat,   left45 }, { 28, 16, 0, 16,   flat,   left45 }, { 29, 16, 0, 16,   flat,   left45 },
    { 30, 16, 0, 16,   flat,   left45 }, { 31, 16, 0, 16,   flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5D78, {
    { 16, 31, 7, 24, down25, unbanked }, { 16, 30, 7, 24, down25, unbanked }, { 16, 29, 6, 24, down25, unbanked }, { 16, 28, 6, 24, down25, unbanked }, { 16, 27, 5, 24, down25, unbanked },
    { 16, 26, 5, 24, down25, unbanked }, { 16, 25, 4, 24, down25, unbanked }, { 16, 24, 4, 24, down25, unbanked }, { 16, 23, 4, 24, down12,   left22 }, { 16, 22, 3, 24, down12,   left22 },
    { 16, 21, 3, 24, down12,   left22 }, { 16, 20, 3, 24, down12,   left22 }, { 16, 19, 2, 24, down12,   left22 }, { 16, 18, 2, 24, down12,   left22 }, { 16, 17, 2, 24, down12,   left22 },
    { 16, 16, 2, 24, down12,   left22 }, { 16, 15, 1, 24, down12,   left22 }, { 16, 14, 1, 24, down12,   left22 }, { 16, 13, 1, 24, down12,   left22 }, { 16, 12, 1, 24, down12,   left22 },
    { 16, 11, 1, 24, down12,   left22 }, { 16, 10, 1, 24, down12,   left22 }, { 16,  9, 0, 24,   flat,   left45 }, { 16,  8, 0, 24,   flat,   left45 }, { 16,  7, 0, 24,   flat,   left45 },
    { 16,  6, 0, 24,   flat,   left45 }, { 16,  5, 0, 24,   flat,   left45 }, { 16,  4, 0, 24,   flat,   left45 }, { 16,  3, 0, 24,   flat,   left45 }, { 16,  2, 0, 24,   flat,   left45 },
    { 16,  1, 0, 24,   flat,   left45 }, { 16,  0, 0, 24,   flat,   left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5E9A, {
    { 31, 16, 7, 0, down25, unbanked }, { 30, 16, 7, 0, down25, unbanked }, { 29, 16, 6, 0, down25, unbanked }, { 28, 16, 6, 0, down25, unbanked }, { 27, 16, 5, 0, down25, unbanked },
    { 26, 16, 5, 0, down25, unbanked }, { 25, 16, 4, 0, down25, unbanked }, { 24, 16, 4, 0, down25, unbanked }, { 23, 16, 4, 0, down12,  right22 }, { 22, 16, 3, 0, down12,  right22 },
    { 21, 16, 3, 0, down12,  right22 }, { 20, 16, 3, 0, down12,  right22 }, { 19, 16, 2, 0, down12,  right22 }, { 18, 16, 2, 0, down12,  right22 }, { 17, 16, 2, 0, down12,  right22 },
    { 16, 16, 2, 0, down12,  right22 }, { 15, 16, 1, 0, down12,  right22 }, { 14, 16, 1, 0, down12,  right22 }, { 13, 16, 1, 0, down12,  right22 }, { 12, 16, 1, 0, down12,  right22 },
    { 11, 16, 1, 0, down12,  right22 }, { 10, 16, 1, 0, down12,  right22 }, {  9, 16, 0, 0,   flat,  right45 }, {  8, 16, 0, 0,   flat,  right45 }, {  7, 16, 0, 0,   flat,  right45 },
    {  6, 16, 0, 0,   flat,  right45 }, {  5, 16, 0, 0,   flat,  right45 }, {  4, 16, 0, 0,   flat,  right45 }, {  3, 16, 0, 0,   flat,  right45 }, {  2, 16, 0, 0,   flat,  right45 },
    {  1, 16, 0, 0,   flat,  right45 }, {  0, 16, 0, 0,   flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5FBC, {
    { 16,  0, 7, 8, down25, unbanked }, { 16,  1, 7, 8, down25, unbanked }, { 16,  2, 6, 8, down25, unbanked }, { 16,  3, 6, 8, down25, unbanked }, { 16,  4, 5, 8, down25, unbanked }, { 16,  5, 5, 8, down25, unbanked },
    { 16,  6, 4, 8, down25, unbanked }, { 16,  7, 4, 8, down25, unbanked }, { 16,  8, 4, 8, down12,  right22 }, { 16,  9, 3, 8, down12,  right22 }, { 16, 10, 3, 8, down12,  right22 }, { 16, 11, 3, 8, down12,  right22 },
    { 16, 12, 2, 8, down12,  right22 }, { 16, 13, 2, 8, down12,  right22 }, { 16, 14, 2, 8, down12,  right22 }, { 16, 15, 2, 8, down12,  right22 }, { 16, 16, 1, 8, down12,  right22 }, { 16, 17, 1, 8, down12,  right22 },
    { 16, 18, 1, 8, down12,  right22 }, { 16, 19, 1, 8, down12,  right22 }, { 16, 20, 1, 8, down12,  right22 }, { 16, 21, 1, 8, down12,  right22 }, { 16, 22, 0, 8,   flat,  right45 }, { 16, 23, 0, 8,   flat,  right45 },
    { 16, 24, 0, 8,   flat,  right45 }, { 16, 25, 0, 8,   flat,  right45 }, { 16, 26, 0, 8,   flat,  right45 }, { 16, 27, 0, 8,   flat,  right45 }, { 16, 28, 0, 8,   flat,  right45 }, { 16, 29, 0, 8,   flat,  right45 },
    { 16, 30, 0, 8,   flat,  right45 }, { 16, 31, 0, 8,   flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C60DE, {
    {  0, 16, 7, 16, down25, unbanked }, {  1, 16, 7, 16, down25, unbanked }, {  2, 16, 6, 16, down25, unbanked }, {  3, 16, 6, 16, down25, unbanked }, {  4, 16, 5, 16, down25, unbanked },
    {  5, 16, 5, 16, down25, unbanked }, {  6, 16, 4, 16, down25, unbanked }, {  7, 16, 4, 16, down25, unbanked }, {  8, 16, 4, 16, down12,  right22 }, {  9, 16, 3, 16, down12,  right22 },
    { 10, 16, 3, 16, down12,  right22 }, { 11, 16, 3, 16, down12,  right22 }, { 12, 16, 2, 16, down12,  right22 }, { 13, 16, 2, 16, down12,  right22 }, { 14, 16, 2, 16, down12,  right22 },
    { 15, 16, 2, 16, down12,  right22 }, { 16, 16, 1, 16, down12,  right22 }, { 17, 16, 1, 16, down12,  right22 }, { 18, 16, 1, 16, down12,  right22 }, { 19, 16, 1, 16, down12,  right22 },
    { 20, 16, 1, 16, down12,  right22 }, { 21, 16, 1, 16, down12,  right22 }, { 22, 16, 0, 16,   flat,  right45 }, { 23, 16, 0, 16,   flat,  right45 }, { 24, 16, 0, 16,   flat,  right45 },
    { 25, 16, 0, 16,   flat,  right45 }, { 26, 16, 0, 16,   flat,  right45 }, { 27, 16, 0, 16,   flat,  right45 }, { 28, 16, 0, 16,   flat,  right45 }, { 29, 16, 0, 16,   flat,  right45 },
    { 30, 16, 0, 16,   flat,  right45 }, { 31, 16, 0, 16,   flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6200, {
    { 16, 31, 7, 24, down25, unbanked }, { 16, 30, 7, 24, down25, unbanked }, { 16, 29, 6, 24, down25, unbanked }, { 16, 28, 6, 24, down25, unbanked }, { 16, 27, 5, 24, down25, unbanked },
    { 16, 26, 5, 24, down25, unbanked }, { 16, 25, 4, 24, down25, unbanked }, { 16, 24, 4, 24, down25, unbanked }, { 16, 23, 4, 24, down12,  right22 }, { 16, 22, 3, 24, down12,  right22 },
    { 16, 21, 3, 24, down12,  right22 }, { 16, 20, 3, 24, down12,  right22 }, { 16, 19, 2, 24, down12,  right22 }, { 16, 18, 2, 24, down12,  right22 }, { 16, 17, 2, 24, down12,  right22 },
    { 16, 16, 2, 24, down12,  right22 }, { 16, 15, 1, 24, down12,  right22 }, { 16, 14, 1, 24, down12,  right22 }, { 16, 13, 1, 24, down12,  right22 }, { 16, 12, 1, 24, down12,  right22 },
    { 16, 11, 1, 24, down12,  right22 }, { 16, 10, 1, 24, down12,  right22 }, { 16,  9, 0, 24,   flat,  right45 }, { 16,  8, 0, 24,   flat,  right45 }, { 16,  7, 0, 24,   flat,  right45 },
    { 16,  6, 0, 24,   flat,  right45 }, { 16,  5, 0, 24,   flat,  right45 }, { 16,  4, 0, 24,   flat,  right45 }, { 16,  3, 0, 24,   flat,  right45 }, { 16,  2, 0, 24,   flat,  right45 },
    { 16,  1, 0, 24,   flat,  right45 }, { 16,  0, 0, 24,   flat,  right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEA02, {
    { 31, 16, 0, 0, flat, left45 }, { 30, 16, 0, 0, flat, left45 }, { 29, 16, 0, 0, flat, left45 }, { 28, 16, 0, 0, flat, left45 }, { 27, 16, 0, 0, flat, left45 }, { 26, 16, 0, 0, flat, left45 },
    { 25, 16, 0, 0, flat, left45 }, { 24, 16, 0, 0, flat, left45 }, { 23, 16, 0, 0, flat, left45 }, { 22, 16, 0, 0, flat, left45 }, { 21, 16, 0, 0, flat, left45 }, { 20, 16, 0, 0, flat, left45 },
    { 19, 16, 0, 0, flat, left45 }, { 18, 16, 0, 0, flat, left45 }, { 17, 16, 0, 0, flat, left45 }, { 16, 16, 0, 0, flat, left45 }, { 15, 16, 0, 0, flat, left45 }, { 14, 16, 0, 0, flat, left45 },
    { 13, 16, 0, 0, flat, left45 }, { 12, 16, 0, 0, flat, left45 }, { 11, 16, 0, 0, flat, left45 }, { 10, 16, 0, 0, flat, left45 }, {  9, 16, 0, 0, flat, left45 }, {  8, 16, 0, 0, flat, left45 },
    {  7, 16, 0, 0, flat, left45 }, {  6, 16, 0, 0, flat, left45 }, {  5, 16, 0, 0, flat, left45 }, {  4, 16, 0, 0, flat, left45 }, {  3, 16, 0, 0, flat, left45 }, {  2, 16, 0, 0, flat, left45 },
    {  1, 16, 0, 0, flat, left45 }, {  0, 16, 0, 0, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEB24, {
    { 16,  0, 0, 8, flat, left45 }, { 16,  1, 0, 8, flat, left45 }, { 16,  2, 0, 8, flat, left45 }, { 16,  3, 0, 8, flat, left45 }, { 16,  4, 0, 8, flat, left45 }, { 16,  5, 0, 8, flat, left45 },
    { 16,  6, 0, 8, flat, left45 }, { 16,  7, 0, 8, flat, left45 }, { 16,  8, 0, 8, flat, left45 }, { 16,  9, 0, 8, flat, left45 }, { 16, 10, 0, 8, flat, left45 }, { 16, 11, 0, 8, flat, left45 },
    { 16, 12, 0, 8, flat, left45 }, { 16, 13, 0, 8, flat, left45 }, { 16, 14, 0, 8, flat, left45 }, { 16, 15, 0, 8, flat, left45 }, { 16, 16, 0, 8, flat, left45 }, { 16, 17, 0, 8, flat, left45 },
    { 16, 18, 0, 8, flat, left45 }, { 16, 19, 0, 8, flat, left45 }, { 16, 20, 0, 8, flat, left45 }, { 16, 21, 0, 8, flat, left45 }, { 16, 22, 0, 8, flat, left45 }, { 16, 23, 0, 8, flat, left45 },
    { 16, 24, 0, 8, flat, left45 }, { 16, 25, 0, 8, flat, left45 }, { 16, 26, 0, 8, flat, left45 }, { 16, 27, 0, 8, flat, left45 }, { 16, 28, 0, 8, flat, left45 }, { 16, 29, 0, 8, flat, left45 },
    { 16, 30, 0, 8, flat, left45 }, { 16, 31, 0, 8, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEC46, {
    {  0, 16, 0, 16, flat, left45 }, {  1, 16, 0, 16, flat, left45 }, {  2, 16, 0, 16, flat, left45 }, {  3, 16, 0, 16, flat, left45 }, {  4, 16, 0, 16, flat, left45 }, {  5, 16, 0, 16, flat, left45 },
    {  6, 16, 0, 16, flat, left45 }, {  7, 16, 0, 16, flat, left45 }, {  8, 16, 0, 16, flat, left45 }, {  9, 16, 0, 16, flat, left45 }, { 10, 16, 0, 16, flat, left45 }, { 11, 16, 0, 16, flat, left45 },
    { 12, 16, 0, 16, flat, left45 }, { 13, 16, 0, 16, flat, left45 }, { 14, 16, 0, 16, flat, left45 }, { 15, 16, 0, 16, flat, left45 }, { 16, 16, 0, 16, flat, left45 }, { 17, 16, 0, 16, flat, left45 },
    { 18, 16, 0, 16, flat, left45 }, { 19, 16, 0, 16, flat, left45 }, { 20, 16, 0, 16, flat, left45 }, { 21, 16, 0, 16, flat, left45 }, { 22, 16, 0, 16, flat, left45 }, { 23, 16, 0, 16, flat, left45 },
    { 24, 16, 0, 16, flat, left45 }, { 25, 16, 0, 16, flat, left45 }, { 26, 16, 0, 16, flat, left45 }, { 27, 16, 0, 16, flat, left45 }, { 28, 16, 0, 16, flat, left45 }, { 29, 16, 0, 16, flat, left45 },
    { 30, 16, 0, 16, flat, left45 }, { 31, 16, 0, 16, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BED68, {
    { 16, 31, 0, 24, flat, left45 }, { 16, 30, 0, 24, flat, left45 }, { 16, 29, 0, 24, flat, left45 }, { 16, 28, 0, 24, flat, left45 }, { 16, 27, 0, 24, flat, left45 }, { 16, 26, 0, 24, flat, left45 },
    { 16, 25, 0, 24, flat, left45 }, { 16, 24, 0, 24, flat, left45 }, { 16, 23, 0, 24, flat, left45 }, { 16, 22, 0, 24, flat, left45 }, { 16, 21, 0, 24, flat, left45 }, { 16, 20, 0, 24, flat, left45 },
    { 16, 19, 0, 24, flat, left45 }, { 16, 18, 0, 24, flat, left45 }, { 16, 17, 0, 24, flat, left45 }, { 16, 16, 0, 24, flat, left45 }, { 16, 15, 0, 24, flat, left45 }, { 16, 14, 0, 24, flat, left45 },
    { 16, 13, 0, 24, flat, left45 }, { 16, 12, 0, 24, flat, left45 }, { 16, 11, 0, 24, flat, left45 }, { 16, 10, 0, 24, flat, left45 }, { 16,  9, 0, 24, flat, left45 }, { 16,  8, 0, 24, flat, left45 },
    { 16,  7, 0, 24, flat, left45 }, { 16,  6, 0, 24, flat, left45 }, { 16,  5, 0, 24, flat, left45 }, { 16,  4, 0, 24, flat, left45 }, { 16,  3, 0, 24, flat, left45 }, { 16,  2, 0, 24, flat, left45 },
    { 16,  1, 0, 24, flat, left45 }, { 16,  0, 0, 24, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEE8A, {
    { 31, 16, 0, 0, flat, right45 }, { 30, 16, 0, 0, flat, right45 }, { 29, 16, 0, 0, flat, right45 }, { 28, 16, 0, 0, flat, right45 }, { 27, 16, 0, 0, flat, right45 }, { 26, 16, 0, 0, flat, right45 },
    { 25, 16, 0, 0, flat, right45 }, { 24, 16, 0, 0, flat, right45 }, { 23, 16, 0, 0, flat, right45 }, { 22, 16, 0, 0, flat, right45 }, { 21, 16, 0, 0, flat, right45 }, { 20, 16, 0, 0, flat, right45 },
    { 19, 16, 0, 0, flat, right45 }, { 18, 16, 0, 0, flat, right45 }, { 17, 16, 0, 0, flat, right45 }, { 16, 16, 0, 0, flat, right45 }, { 15, 16, 0, 0, flat, right45 }, { 14, 16, 0, 0, flat, right45 },
    { 13, 16, 0, 0, flat, right45 }, { 12, 16, 0, 0, flat, right45 }, { 11, 16, 0, 0, flat, right45 }, { 10, 16, 0, 0, flat, right45 }, {  9, 16, 0, 0, flat, right45 }, {  8, 16, 0, 0, flat, right45 },
    {  7, 16, 0, 0, flat, right45 }, {  6, 16, 0, 0, flat, right45 }, {  5, 16, 0, 0, flat, right45 }, {  4, 16, 0, 0, flat, right45 }, {  3, 16, 0, 0, flat, right45 }, {  2, 16, 0, 0, flat, right45 },
    {  1, 16, 0, 0, flat, right45 }, {  0, 16, 0, 0, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEFAC, {
    { 16,  0, 0, 8, flat, right45 }, { 16,  1, 0, 8, flat, right45 }, { 16,  2, 0, 8, flat, right45 }, { 16,  3, 0, 8, flat, right45 }, { 16,  4, 0, 8, flat, right45 }, { 16,  5, 0, 8, flat, right45 },
    { 16,  6, 0, 8, flat, right45 }, { 16,  7, 0, 8, flat, right45 }, { 16,  8, 0, 8, flat, right45 }, { 16,  9, 0, 8, flat, right45 }, { 16, 10, 0, 8, flat, right45 }, { 16, 11, 0, 8, flat, right45 },
    { 16, 12, 0, 8, flat, right45 }, { 16, 13, 0, 8, flat, right45 }, { 16, 14, 0, 8, flat, right45 }, { 16, 15, 0, 8, flat, right45 }, { 16, 16, 0, 8, flat, right45 }, { 16, 17, 0, 8, flat, right45 },
    { 16, 18, 0, 8, flat, right45 }, { 16, 19, 0, 8, flat, right45 }, { 16, 20, 0, 8, flat, right45 }, { 16, 21, 0, 8, flat, right45 }, { 16, 22, 0, 8, flat, right45 }, { 16, 23, 0, 8, flat, right45 },
    { 16, 24, 0, 8, flat, right45 }, { 16, 25, 0, 8, flat, right45 }, { 16, 26, 0, 8, flat, right45 }, { 16, 27, 0, 8, flat, right45 }, { 16, 28, 0, 8, flat, right45 }, { 16, 29, 0, 8, flat, right45 },
    { 16, 30, 0, 8, flat, right45 }, { 16, 31, 0, 8, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF0CE, {
    {  0, 16, 0, 16, flat, right45 }, {  1, 16, 0, 16, flat, right45 }, {  2, 16, 0, 16, flat, right45 }, {  3, 16, 0, 16, flat, right45 }, {  4, 16, 0, 16, flat, right45 }, {  5, 16, 0, 16, flat, right45 },
    {  6, 16, 0, 16, flat, right45 }, {  7, 16, 0, 16, flat, right45 }, {  8, 16, 0, 16, flat, right45 }, {  9, 16, 0, 16, flat, right45 }, { 10, 16, 0, 16, flat, right45 }, { 11, 16, 0, 16, flat, right45 },
    { 12, 16, 0, 16, flat, right45 }, { 13, 16, 0, 16, flat, right45 }, { 14, 16, 0, 16, flat, right45 }, { 15, 16, 0, 16, flat, right45 }, { 16, 16, 0, 16, flat, right45 }, { 17, 16, 0, 16, flat, right45 },
    { 18, 16, 0, 16, flat, right45 }, { 19, 16, 0, 16, flat, right45 }, { 20, 16, 0, 16, flat, right45 }, { 21, 16, 0, 16, flat, right45 }, { 22, 16, 0, 16, flat, right45 }, { 23, 16, 0, 16, flat, right45 },
    { 24, 16, 0, 16, flat, right45 }, { 25, 16, 0, 16, flat, right45 }, { 26, 16, 0, 16, flat, right45 }, { 27, 16, 0, 16, flat, right45 }, { 28, 16, 0, 16, flat, right45 }, { 29, 16, 0, 16, flat, right45 },
    { 30, 16, 0, 16, flat, right45 }, { 31, 16, 0, 16, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF1F0, {
    { 16, 31, 0, 24, flat, right45 }, { 16, 30, 0, 24, flat, right45 }, { 16, 29, 0, 24, flat, right45 }, { 16, 28, 0, 24, flat, right45 }, { 16, 27, 0, 24, flat, right45 }, { 16, 26, 0, 24, flat, right45 },
    { 16, 25, 0, 24, flat, right45 }, { 16, 24, 0, 24, flat, right45 }, { 16, 23, 0, 24, flat, right45 }, { 16, 22, 0, 24, flat, right45 }, { 16, 21, 0, 24, flat, right45 }, { 16, 20, 0, 24, flat, right45 },
    { 16, 19, 0, 24, flat, right45 }, { 16, 18, 0, 24, flat, right45 }, { 16, 17, 0, 24, flat, right45 }, { 16, 16, 0, 24, flat, right45 }, { 16, 15, 0, 24, flat, right45 }, { 16, 14, 0, 24, flat, right45 },
    { 16, 13, 0, 24, flat, right45 }, { 16, 12, 0, 24, flat, right45 }, { 16, 11, 0, 24, flat, right45 }, { 16, 10, 0, 24, flat, right45 }, { 16,  9, 0, 24, flat, right45 }, { 16,  8, 0, 24, flat, right45 },
    { 16,  7, 0, 24, flat, right45 }, { 16,  6, 0, 24, flat, right45 }, { 16,  5, 0, 24, flat, right45 }, { 16,  4, 0, 24, flat, right45 }, { 16,  3, 0, 24, flat, right45 }, { 16,  2, 0, 24, flat, right45 },
    { 16,  1, 0, 24, flat, right45 }, { 16,  0, 0, 24, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D047E, {
    {  31,  16,  0,  0, up25, unbanked }, {  30,  16,  0,  0, up25, unbanked }, {  29,  16,  1,  0, up25, unbanked }, {  28,  16,  1,  0, up25, unbanked }, {  27,  16,  2,  0, up25, unbanked },
    {  26,  16,  2,  0, up25, unbanked }, {  25,  16,  3,  0, up25, unbanked }, {  24,  16,  3, 31, up25, unbanked }, {  23,  15,  4, 31, up25, unbanked }, {  22,  15,  4, 31, up25, unbanked },
    {  21,  15,  5, 31, up25, unbanked }, {  20,  15,  5, 31, up25, unbanked }, {  19,  15,  6, 31, up25, unbanked }, {  18,  15,  6, 31, up25, unbanked }, {  17,  14,  7, 31, up25, unbanked },
    {  16,  14,  8, 31, up25, unbanked }, {  15,  14,  8, 31, up25, unbanked }, {  14,  14,  8, 31, up25, unbanked }, {  13,  14,  9, 31, up25, unbanked }, {  12,  13,  9, 31, up25, unbanked },
    {  11,  13, 10, 31, up25, unbanked }, {  10,  13, 11, 30, up25, unbanked }, {   9,  13, 11, 30, up25, unbanked }, {   8,  12, 12, 30, up25, unbanked }, {   7,  12, 12, 30, up25, unbanked },
    {   6,  12, 13, 30, up25, unbanked }, {   5,  11, 13, 30, up25, unbanked }, {   4,  11, 14, 30, up25, unbanked }, {   3,  11, 14, 30, up25, unbanked }, {   2,  10, 15, 30, up25, unbanked },
    {   1,  10, 15, 30, up25, unbanked }, {   0,   9, 16, 30, up25, unbanked }, {  -1,   9, 17, 30, up25, unbanked }, {  -2,   8, 17, 30, up25, unbanked }, {  -3,   8, 18, 30, up25, unbanked },
    {  -4,   7, 18, 30, up25, unbanked }, {  -5,   7, 19, 29, up25, unbanked }, {  -6,   6, 19, 29, up25, unbanked }, {  -7,   6, 20, 29, up25, unbanked }, {  -8,   5, 21, 29, up25, unbanked },
    {  -9,   4, 21, 29, up25, unbanked }, { -10,   4, 22, 29, up25, unbanked }, { -11,   3, 22, 29, up25, unbanked }, { -12,   2, 23, 29, up25, unbanked }, { -13,   2, 24, 29, up25, unbanked },
    { -14,   1, 24, 29, up25, unbanked }, { -15,   0, 25, 29, up25, unbanked }, { -16,   0, 26, 29, up25, unbanked }, { -17,  -1, 26, 29, up25, unbanked }, { -18,  -2, 27, 28, up25, unbanked },
    { -19,  -3, 27, 28, up25, unbanked }, { -20,  -3, 28, 28, up25, unbanked }, { -21,  -4, 29, 28, up25, unbanked }, { -22,  -5, 29, 28, up25, unbanked }, { -23,  -6, 30, 28, up25, unbanked },
    { -24,  -7, 31, 28, up25, unbanked }, { -25,  -7, 31, 28, up25, unbanked }, { -26,  -8, 32, 28, up25, unbanked }, { -27,  -9, 32, 28, up25, unbanked }, { -28, -10, 33, 28, up25, unbanked },
    { -29, -11, 34, 28, up25, unbanked }, { -29, -12, 34, 28, up25, unbanked }, { -30, -13, 35, 27, up25, unbanked }, { -31, -14, 36, 27, up25, unbanked }, { -32, -15, 36, 27, up25, unbanked },
    { -32, -16, 37, 27, up25, unbanked }, { -33, -17, 37, 27, up25, unbanked }, { -34, -18, 38, 27, up25, unbanked }, { -34, -19, 39, 27, up25, unbanked }, { -35, -20, 39, 27, up25, unbanked },
    { -36, -21, 40, 27, up25, unbanked }, { -36, -22, 41, 27, up25, unbanked }, { -37, -23, 41, 27, up25, unbanked }, { -38, -24, 42, 27, up25, unbanked }, { -38, -25, 42, 27, up25, unbanked },
    { -39, -26, 43, 26, up25, unbanked }, { -39, -27, 44, 26, up25, unbanked }, { -40, -28, 44, 26, up25, unbanked }, { -40, -29, 45, 26, up25, unbanked }, { -41, -30, 45, 26, up25, unbanked },
    { -41, -31, 46, 26, up25, unbanked }, { -42, -32, 46, 26, up25, unbanked }, { -42, -33, 47, 26, up25, unbanked }, { -43, -34, 48, 26, up25, unbanked }, { -43, -35, 48, 26, up25, unbanked },
    { -43, -36, 49, 26, up25, unbanked }, { -44, -37, 49, 26, up25, unbanked }, { -44, -38, 50, 26, up25, unbanked }, { -44, -39, 50, 26, up25, unbanked }, { -45, -40, 51, 25, up25, unbanked },
    { -45, -41, 51, 25, up25, unbanked }, { -45, -42, 52, 25, up25, unbanked }, { -45, -43, 52, 25, up25, unbanked }, { -46, -44, 53, 25, up25, unbanked }, { -46, -45, 54, 25, up25, unbanked },
    { -46, -46, 54, 25, up25, unbanked }, { -46, -47, 55, 25, up25, unbanked }, { -46, -48, 55, 25, up25, unbanked }, { -47, -49, 55, 25, up25, unbanked }, { -47, -50, 56, 25, up25, unbanked },
    { -47, -51, 57, 25, up25, unbanked }, { -47, -52, 57, 25, up25, unbanked }, { -47, -53, 58, 25, up25, unbanked }, { -47, -54, 58, 25, up25, unbanked }, { -48, -55, 59, 25, up25, unbanked },
    { -48, -56, 59, 24, up25, unbanked }, { -48, -57, 60, 24, up25, unbanked }, { -48, -58, 60, 24, up25, unbanked }, { -48, -59, 61, 24, up25, unbanked }, { -48, -60, 61, 24, up25, unbanked },
    { -48, -61, 62, 24, up25, unbanked }, { -48, -62, 62, 24, up25, unbanked }, { -48, -63, 63, 24, up25, unbanked }, { -48, -64, 64, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D0882, {
    {  16,  0,  0, 8, up25, unbanked }, {  16,  1,  0, 8, up25, unbanked }, {  16,  2,  0, 8, up25, unbanked }, {  16,  3,  1, 8, up25, unbanked }, {  16,  4,  1, 8, up25, unbanked },
    {  16,  5,  2, 8, up25, unbanked }, {  16,  6,  2, 8, up25, unbanked }, {  16,  7,  3, 8, up25, unbanked }, {  16,  8,  3, 7, up25, unbanked }, {  15,  9,  4, 7, up25, unbanked },
    {  15, 10,  4, 7, up25, unbanked }, {  15, 11,  5, 7, up25, unbanked }, {  15, 12,  5, 7, up25, unbanked }, {  15, 13,  6, 7, up25, unbanked }, {  15, 14,  6, 7, up25, unbanked },
    {  14, 15,  7, 7, up25, unbanked }, {  14, 16,  8, 7, up25, unbanked }, {  14, 17,  8, 7, up25, unbanked }, {  14, 18,  8, 7, up25, unbanked }, {  14, 19,  9, 7, up25, unbanked },
    {  13, 20,  9, 7, up25, unbanked }, {  13, 21, 10, 7, up25, unbanked }, {  13, 22, 11, 6, up25, unbanked }, {  13, 23, 11, 6, up25, unbanked }, {  12, 24, 12, 6, up25, unbanked },
    {  12, 25, 12, 6, up25, unbanked }, {  12, 26, 13, 6, up25, unbanked }, {  11, 27, 13, 6, up25, unbanked }, {  11, 28, 14, 6, up25, unbanked }, {  11, 29, 14, 6, up25, unbanked },
    {  10, 30, 15, 6, up25, unbanked }, {  10, 31, 15, 6, up25, unbanked }, {   9, 32, 16, 6, up25, unbanked }, {   9, 33, 17, 6, up25, unbanked }, {   8, 34, 17, 6, up25, unbanked },
    {   8, 35, 18, 6, up25, unbanked }, {   7, 36, 18, 6, up25, unbanked }, {   7, 37, 19, 5, up25, unbanked }, {   6, 38, 19, 5, up25, unbanked }, {   6, 39, 20, 5, up25, unbanked },
    {   5, 40, 21, 5, up25, unbanked }, {   4, 41, 21, 5, up25, unbanked }, {   4, 42, 22, 5, up25, unbanked }, {   3, 43, 22, 5, up25, unbanked }, {   2, 44, 23, 5, up25, unbanked },
    {   2, 45, 24, 5, up25, unbanked }, {   1, 46, 24, 5, up25, unbanked }, {   0, 47, 25, 5, up25, unbanked }, {   0, 48, 26, 5, up25, unbanked }, {  -1, 49, 26, 5, up25, unbanked },
    {  -2, 50, 27, 4, up25, unbanked }, {  -3, 51, 27, 4, up25, unbanked }, {  -3, 52, 28, 4, up25, unbanked }, {  -4, 53, 29, 4, up25, unbanked }, {  -5, 54, 29, 4, up25, unbanked },
    {  -6, 55, 30, 4, up25, unbanked }, {  -7, 56, 31, 4, up25, unbanked }, {  -7, 57, 31, 4, up25, unbanked }, {  -8, 58, 32, 4, up25, unbanked }, {  -9, 59, 32, 4, up25, unbanked },
    { -10, 60, 33, 4, up25, unbanked }, { -11, 61, 34, 4, up25, unbanked }, { -12, 61, 34, 4, up25, unbanked }, { -13, 62, 35, 3, up25, unbanked }, { -14, 63, 36, 3, up25, unbanked },
    { -15, 64, 36, 3, up25, unbanked }, { -16, 64, 37, 3, up25, unbanked }, { -17, 65, 37, 3, up25, unbanked }, { -18, 66, 38, 3, up25, unbanked }, { -19, 66, 39, 3, up25, unbanked },
    { -20, 67, 39, 3, up25, unbanked }, { -21, 68, 40, 3, up25, unbanked }, { -22, 68, 41, 3, up25, unbanked }, { -23, 69, 41, 3, up25, unbanked }, { -24, 70, 42, 3, up25, unbanked },
    { -25, 70, 42, 3, up25, unbanked }, { -26, 71, 43, 2, up25, unbanked }, { -27, 71, 44, 2, up25, unbanked }, { -28, 72, 44, 2, up25, unbanked }, { -29, 72, 45, 2, up25, unbanked },
    { -30, 73, 45, 2, up25, unbanked }, { -31, 73, 46, 2, up25, unbanked }, { -32, 74, 46, 2, up25, unbanked }, { -33, 74, 47, 2, up25, unbanked }, { -34, 75, 48, 2, up25, unbanked },
    { -35, 75, 48, 2, up25, unbanked }, { -36, 75, 49, 2, up25, unbanked }, { -37, 76, 49, 2, up25, unbanked }, { -38, 76, 50, 2, up25, unbanked }, { -39, 76, 50, 2, up25, unbanked },
    { -40, 77, 51, 1, up25, unbanked }, { -41, 77, 51, 1, up25, unbanked }, { -42, 77, 52, 1, up25, unbanked }, { -43, 77, 52, 1, up25, unbanked }, { -44, 78, 53, 1, up25, unbanked },
    { -45, 78, 54, 1, up25, unbanked }, { -46, 78, 54, 1, up25, unbanked }, { -47, 78, 55, 1, up25, unbanked }, { -48, 78, 55, 1, up25, unbanked }, { -49, 79, 55, 1, up25, unbanked },
    { -50, 79, 56, 1, up25, unbanked }, { -51, 79, 57, 1, up25, unbanked }, { -52, 79, 57, 1, up25, unbanked }, { -53, 79, 58, 1, up25, unbanked }, { -54, 79, 58, 1, up25, unbanked },
    { -55, 80, 59, 1, up25, unbanked }, { -56, 80, 59, 0, up25, unbanked }, { -57, 80, 60, 0, up25, unbanked }, { -58, 80, 60, 0, up25, unbanked }, { -59, 80, 61, 0, up25, unbanked },
    { -60, 80, 61, 0, up25, unbanked }, { -61, 80, 62, 0, up25, unbanked }, { -62, 80, 62, 0, up25, unbanked }, { -63, 80, 63, 0, up25, unbanked }, { -64, 80, 64, 0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D0C8F, {
    {  0, 16,  0, 16, up25, unbanked }, {  1, 16,  0, 16, up25, unbanked }, {  2, 16,  0, 16, up25, unbanked }, {  3, 16,  1, 16, up25, unbanked }, {  4, 16,  1, 16, up25, unbanked },
    {  5, 16,  2, 16, up25, unbanked }, {  6, 16,  2, 16, up25, unbanked }, {  7, 16,  3, 16, up25, unbanked }, {  8, 16,  3, 15, up25, unbanked }, {  9, 17,  4, 15, up25, unbanked },
    { 10, 17,  5, 15, up25, unbanked }, { 11, 17,  5, 15, up25, unbanked }, { 12, 17,  5, 15, up25, unbanked }, { 13, 17,  6, 15, up25, unbanked }, { 14, 17,  6, 15, up25, unbanked },
    { 15, 18,  7, 15, up25, unbanked }, { 16, 18,  8, 15, up25, unbanked }, { 17, 18,  8, 15, up25, unbanked }, { 18, 18,  9, 15, up25, unbanked }, { 19, 18,  9, 15, up25, unbanked },
    { 20, 19, 10, 15, up25, unbanked }, { 21, 19, 10, 15, up25, unbanked }, { 22, 19, 11, 14, up25, unbanked }, { 23, 19, 11, 14, up25, unbanked }, { 24, 20, 12, 14, up25, unbanked },
    { 25, 20, 12, 14, up25, unbanked }, { 26, 20, 13, 14, up25, unbanked }, { 27, 21, 13, 14, up25, unbanked }, { 28, 21, 14, 14, up25, unbanked }, { 29, 21, 14, 14, up25, unbanked },
    { 30, 22, 15, 14, up25, unbanked }, { 31, 22, 16, 14, up25, unbanked }, { 32, 23, 16, 14, up25, unbanked }, { 33, 23, 17, 14, up25, unbanked }, { 34, 24, 17, 14, up25, unbanked },
    { 35, 24, 18, 14, up25, unbanked }, { 36, 25, 18, 14, up25, unbanked }, { 37, 25, 19, 13, up25, unbanked }, { 38, 26, 20, 13, up25, unbanked }, { 39, 26, 20, 13, up25, unbanked },
    { 40, 27, 21, 13, up25, unbanked }, { 41, 28, 21, 13, up25, unbanked }, { 42, 28, 22, 13, up25, unbanked }, { 43, 29, 23, 13, up25, unbanked }, { 44, 30, 23, 13, up25, unbanked },
    { 45, 30, 24, 13, up25, unbanked }, { 46, 31, 24, 13, up25, unbanked }, { 47, 32, 25, 13, up25, unbanked }, { 48, 32, 26, 13, up25, unbanked }, { 49, 33, 26, 13, up25, unbanked },
    { 50, 34, 27, 12, up25, unbanked }, { 51, 35, 28, 12, up25, unbanked }, { 52, 35, 28, 12, up25, unbanked }, { 53, 36, 29, 12, up25, unbanked }, { 54, 37, 29, 12, up25, unbanked },
    { 55, 38, 30, 12, up25, unbanked }, { 56, 39, 31, 12, up25, unbanked }, { 57, 39, 32, 12, up25, unbanked }, { 58, 40, 32, 12, up25, unbanked }, { 59, 41, 33, 12, up25, unbanked },
    { 60, 42, 33, 12, up25, unbanked }, { 61, 43, 34, 12, up25, unbanked }, { 61, 44, 35, 12, up25, unbanked }, { 62, 45, 35, 11, up25, unbanked }, { 63, 46, 36, 11, up25, unbanked },
    { 64, 47, 37, 11, up25, unbanked }, { 64, 48, 37, 11, up25, unbanked }, { 65, 49, 38, 11, up25, unbanked }, { 66, 50, 38, 11, up25, unbanked }, { 66, 51, 39, 11, up25, unbanked },
    { 67, 52, 40, 11, up25, unbanked }, { 68, 53, 40, 11, up25, unbanked }, { 68, 54, 41, 11, up25, unbanked }, { 69, 55, 41, 11, up25, unbanked }, { 70, 56, 42, 11, up25, unbanked },
    { 70, 57, 43, 11, up25, unbanked }, { 71, 58, 43, 10, up25, unbanked }, { 71, 59, 44, 10, up25, unbanked }, { 72, 60, 44, 10, up25, unbanked }, { 72, 61, 45, 10, up25, unbanked },
    { 73, 62, 46, 10, up25, unbanked }, { 73, 63, 46, 10, up25, unbanked }, { 74, 64, 47, 10, up25, unbanked }, { 74, 65, 47, 10, up25, unbanked }, { 75, 66, 48, 10, up25, unbanked },
    { 75, 67, 49, 10, up25, unbanked }, { 75, 68, 49, 10, up25, unbanked }, { 76, 69, 50, 10, up25, unbanked }, { 76, 70, 50, 10, up25, unbanked }, { 76, 71, 51, 10, up25, unbanked },
    { 77, 72, 51,  9, up25, unbanked }, { 77, 73, 52,  9, up25, unbanked }, { 77, 74, 52,  9, up25, unbanked }, { 77, 75, 53,  9, up25, unbanked }, { 78, 76, 53,  9, up25, unbanked },
    { 78, 77, 54,  9, up25, unbanked }, { 78, 78, 54,  9, up25, unbanked }, { 78, 79, 55,  9, up25, unbanked }, { 78, 80, 55,  9, up25, unbanked }, { 79, 81, 56,  9, up25, unbanked },
    { 79, 82, 57,  9, up25, unbanked }, { 79, 83, 57,  9, up25, unbanked }, { 79, 84, 58,  9, up25, unbanked }, { 79, 85, 58,  9, up25, unbanked }, { 79, 86, 58,  9, up25, unbanked },
    { 80, 87, 59,  9, up25, unbanked }, { 80, 88, 60,  8, up25, unbanked }, { 80, 89, 60,  8, up25, unbanked }, { 80, 90, 61,  8, up25, unbanked }, { 80, 91, 61,  8, up25, unbanked },
    { 80, 92, 62,  8, up25, unbanked }, { 80, 93, 62,  8, up25, unbanked }, { 80, 94, 63,  8, up25, unbanked }, { 80, 95, 63,  8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D1093, {
    { 16,  31,  0, 24, up25, unbanked }, { 16,  30,  0, 24, up25, unbanked }, { 16,  29,  1, 24, up25, unbanked }, { 16,  28,  1, 24, up25, unbanked }, { 16,  27,  2, 24, up25, unbanked },
    { 16,  26,  2, 24, up25, unbanked }, { 16,  25,  3, 24, up25, unbanked }, { 16,  24,  3, 23, up25, unbanked }, { 17,  23,  4, 23, up25, unbanked }, { 17,  22,  5, 23, up25, unbanked },
    { 17,  21,  5, 23, up25, unbanked }, { 17,  20,  5, 23, up25, unbanked }, { 17,  19,  6, 23, up25, unbanked }, { 17,  18,  6, 23, up25, unbanked }, { 18,  17,  7, 23, up25, unbanked },
    { 18,  16,  8, 23, up25, unbanked }, { 18,  15,  8, 23, up25, unbanked }, { 18,  14,  9, 23, up25, unbanked }, { 18,  13,  9, 23, up25, unbanked }, { 19,  12, 10, 23, up25, unbanked },
    { 19,  11, 10, 23, up25, unbanked }, { 19,  10, 11, 22, up25, unbanked }, { 19,   9, 11, 22, up25, unbanked }, { 20,   8, 12, 22, up25, unbanked }, { 20,   7, 12, 22, up25, unbanked },
    { 20,   6, 13, 22, up25, unbanked }, { 21,   5, 13, 22, up25, unbanked }, { 21,   4, 14, 22, up25, unbanked }, { 21,   3, 14, 22, up25, unbanked }, { 22,   2, 15, 22, up25, unbanked },
    { 22,   1, 16, 22, up25, unbanked }, { 23,   0, 16, 22, up25, unbanked }, { 23,  -1, 17, 22, up25, unbanked }, { 24,  -2, 17, 22, up25, unbanked }, { 24,  -3, 18, 22, up25, unbanked },
    { 25,  -4, 18, 22, up25, unbanked }, { 25,  -5, 19, 21, up25, unbanked }, { 26,  -6, 20, 21, up25, unbanked }, { 26,  -7, 20, 21, up25, unbanked }, { 27,  -8, 21, 21, up25, unbanked },
    { 28,  -9, 21, 21, up25, unbanked }, { 28, -10, 22, 21, up25, unbanked }, { 29, -11, 23, 21, up25, unbanked }, { 30, -12, 23, 21, up25, unbanked }, { 30, -13, 24, 21, up25, unbanked },
    { 31, -14, 24, 21, up25, unbanked }, { 32, -15, 25, 21, up25, unbanked }, { 32, -16, 26, 21, up25, unbanked }, { 33, -17, 26, 21, up25, unbanked }, { 34, -18, 27, 20, up25, unbanked },
    { 35, -19, 28, 20, up25, unbanked }, { 35, -20, 28, 20, up25, unbanked }, { 36, -21, 29, 20, up25, unbanked }, { 37, -22, 29, 20, up25, unbanked }, { 38, -23, 30, 20, up25, unbanked },
    { 39, -24, 31, 20, up25, unbanked }, { 39, -25, 32, 20, up25, unbanked }, { 40, -26, 32, 20, up25, unbanked }, { 41, -27, 33, 20, up25, unbanked }, { 42, -28, 33, 20, up25, unbanked },
    { 43, -29, 34, 20, up25, unbanked }, { 44, -29, 35, 20, up25, unbanked }, { 45, -30, 35, 19, up25, unbanked }, { 46, -31, 36, 19, up25, unbanked }, { 47, -32, 37, 19, up25, unbanked },
    { 48, -32, 37, 19, up25, unbanked }, { 49, -33, 38, 19, up25, unbanked }, { 50, -34, 38, 19, up25, unbanked }, { 51, -34, 39, 19, up25, unbanked }, { 52, -35, 40, 19, up25, unbanked },
    { 53, -36, 40, 19, up25, unbanked }, { 54, -36, 41, 19, up25, unbanked }, { 55, -37, 41, 19, up25, unbanked }, { 56, -38, 42, 19, up25, unbanked }, { 57, -38, 43, 19, up25, unbanked },
    { 58, -39, 43, 18, up25, unbanked }, { 59, -39, 44, 18, up25, unbanked }, { 60, -40, 44, 18, up25, unbanked }, { 61, -40, 45, 18, up25, unbanked }, { 62, -41, 46, 18, up25, unbanked },
    { 63, -41, 46, 18, up25, unbanked }, { 64, -42, 47, 18, up25, unbanked }, { 65, -42, 47, 18, up25, unbanked }, { 66, -43, 48, 18, up25, unbanked }, { 67, -43, 49, 18, up25, unbanked },
    { 68, -43, 49, 18, up25, unbanked }, { 69, -44, 50, 18, up25, unbanked }, { 70, -44, 50, 18, up25, unbanked }, { 71, -44, 51, 18, up25, unbanked }, { 72, -45, 51, 17, up25, unbanked },
    { 73, -45, 52, 17, up25, unbanked }, { 74, -45, 52, 17, up25, unbanked }, { 75, -45, 53, 17, up25, unbanked }, { 76, -46, 53, 17, up25, unbanked }, { 77, -46, 54, 17, up25, unbanked },
    { 78, -46, 54, 17, up25, unbanked }, { 79, -46, 55, 17, up25, unbanked }, { 80, -46, 55, 17, up25, unbanked }, { 81, -47, 56, 17, up25, unbanked }, { 82, -47, 57, 17, up25, unbanked },
    { 83, -47, 57, 17, up25, unbanked }, { 84, -47, 58, 17, up25, unbanked }, { 85, -47, 58, 17, up25, unbanked }, { 86, -47, 58, 17, up25, unbanked }, { 87, -48, 59, 17, up25, unbanked },
    { 88, -48, 60, 16, up25, unbanked }, { 89, -48, 60, 16, up25, unbanked }, { 90, -48, 61, 16, up25, unbanked }, { 91, -48, 61, 16, up25, unbanked }, { 92, -48, 62, 16, up25, unbanked },
    { 93, -48, 62, 16, up25, unbanked }, { 94, -48, 63, 16, up25, unbanked }, { 95, -48, 63, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D148E, {
    {  31, 16,  0, 0, up25, unbanked }, {  30, 16,  0, 0, up25, unbanked }, {  29, 16,  1, 0, up25, unbanked }, {  28, 16,  1, 0, up25, unbanked }, {  27, 16,  2, 0, up25, unbanked },
    {  26, 16,  2, 0, up25, unbanked }, {  25, 16,  3, 0, up25, unbanked }, {  24, 16,  3, 1, up25, unbanked }, {  23, 17,  4, 1, up25, unbanked }, {  22, 17,  5, 1, up25, unbanked },
    {  21, 17,  5, 1, up25, unbanked }, {  20, 17,  5, 1, up25, unbanked }, {  19, 17,  6, 1, up25, unbanked }, {  18, 17,  6, 1, up25, unbanked }, {  17, 18,  7, 1, up25, unbanked },
    {  16, 18,  8, 1, up25, unbanked }, {  15, 18,  8, 1, up25, unbanked }, {  14, 18,  9, 1, up25, unbanked }, {  13, 18,  9, 1, up25, unbanked }, {  12, 19, 10, 1, up25, unbanked },
    {  11, 19, 10, 1, up25, unbanked }, {  10, 19, 11, 2, up25, unbanked }, {   9, 19, 11, 2, up25, unbanked }, {   8, 20, 12, 2, up25, unbanked }, {   7, 20, 12, 2, up25, unbanked },
    {   6, 20, 13, 2, up25, unbanked }, {   5, 21, 13, 2, up25, unbanked }, {   4, 21, 14, 2, up25, unbanked }, {   3, 21, 14, 2, up25, unbanked }, {   2, 22, 15, 2, up25, unbanked },
    {   1, 22, 16, 2, up25, unbanked }, {   0, 23, 16, 2, up25, unbanked }, {  -1, 23, 17, 2, up25, unbanked }, {  -2, 24, 17, 2, up25, unbanked }, {  -3, 24, 18, 2, up25, unbanked },
    {  -4, 25, 18, 2, up25, unbanked }, {  -5, 25, 19, 3, up25, unbanked }, {  -6, 26, 20, 3, up25, unbanked }, {  -7, 26, 20, 3, up25, unbanked }, {  -8, 27, 21, 3, up25, unbanked },
    {  -9, 28, 21, 3, up25, unbanked }, { -10, 28, 22, 3, up25, unbanked }, { -11, 29, 23, 3, up25, unbanked }, { -12, 30, 23, 3, up25, unbanked }, { -13, 30, 24, 3, up25, unbanked },
    { -14, 31, 24, 3, up25, unbanked }, { -15, 32, 25, 3, up25, unbanked }, { -16, 32, 26, 3, up25, unbanked }, { -17, 33, 26, 3, up25, unbanked }, { -18, 34, 27, 4, up25, unbanked },
    { -19, 35, 28, 4, up25, unbanked }, { -20, 35, 28, 4, up25, unbanked }, { -21, 36, 29, 4, up25, unbanked }, { -22, 37, 29, 4, up25, unbanked }, { -23, 38, 30, 4, up25, unbanked },
    { -24, 39, 31, 4, up25, unbanked }, { -25, 39, 32, 4, up25, unbanked }, { -26, 40, 32, 4, up25, unbanked }, { -27, 41, 33, 4, up25, unbanked }, { -28, 42, 33, 4, up25, unbanked },
    { -29, 43, 34, 4, up25, unbanked }, { -29, 44, 35, 4, up25, unbanked }, { -30, 45, 35, 5, up25, unbanked }, { -31, 46, 36, 5, up25, unbanked }, { -32, 47, 37, 5, up25, unbanked },
    { -32, 48, 37, 5, up25, unbanked }, { -33, 49, 38, 5, up25, unbanked }, { -34, 50, 38, 5, up25, unbanked }, { -34, 51, 39, 5, up25, unbanked }, { -35, 52, 40, 5, up25, unbanked },
    { -36, 53, 40, 5, up25, unbanked }, { -36, 54, 41, 5, up25, unbanked }, { -37, 55, 41, 5, up25, unbanked }, { -38, 56, 42, 5, up25, unbanked }, { -38, 57, 43, 5, up25, unbanked },
    { -39, 58, 43, 6, up25, unbanked }, { -39, 59, 44, 6, up25, unbanked }, { -40, 60, 44, 6, up25, unbanked }, { -40, 61, 45, 6, up25, unbanked }, { -41, 62, 46, 6, up25, unbanked },
    { -41, 63, 46, 6, up25, unbanked }, { -42, 64, 47, 6, up25, unbanked }, { -42, 65, 47, 6, up25, unbanked }, { -43, 66, 48, 6, up25, unbanked }, { -43, 67, 49, 6, up25, unbanked },
    { -43, 68, 49, 6, up25, unbanked }, { -44, 69, 50, 6, up25, unbanked }, { -44, 70, 50, 6, up25, unbanked }, { -44, 71, 51, 6, up25, unbanked }, { -45, 72, 51, 7, up25, unbanked },
    { -45, 73, 52, 7, up25, unbanked }, { -45, 74, 52, 7, up25, unbanked }, { -45, 75, 53, 7, up25, unbanked }, { -46, 76, 53, 7, up25, unbanked }, { -46, 77, 54, 7, up25, unbanked },
    { -46, 78, 54, 7, up25, unbanked }, { -46, 79, 55, 7, up25, unbanked }, { -46, 80, 55, 7, up25, unbanked }, { -47, 81, 56, 7, up25, unbanked }, { -47, 82, 57, 7, up25, unbanked },
    { -47, 83, 57, 7, up25, unbanked }, { -47, 84, 58, 7, up25, unbanked }, { -47, 85, 58, 7, up25, unbanked }, { -47, 86, 58, 7, up25, unbanked }, { -48, 87, 59, 7, up25, unbanked },
    { -48, 88, 60, 8, up25, unbanked }, { -48, 89, 60, 8, up25, unbanked }, { -48, 90, 61, 8, up25, unbanked }, { -48, 91, 61, 8, up25, unbanked }, { -48, 92, 62, 8, up25, unbanked },
    { -48, 93, 62, 8, up25, unbanked }, { -48, 94, 63, 8, up25, unbanked }, { -48, 95, 63, 8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D1889, {
    { 16,  0,  0,  8, up25, unbanked }, { 16,  1,  0,  8, up25, unbanked }, { 16,  2,  0,  8, up25, unbanked }, { 16,  3,  1,  8, up25, unbanked }, { 16,  4,  1,  8, up25, unbanked },
    { 16,  5,  2,  8, up25, unbanked }, { 16,  6,  2,  8, up25, unbanked }, { 16,  7,  3,  8, up25, unbanked }, { 16,  8,  3,  9, up25, unbanked }, { 17,  9,  4,  9, up25, unbanked },
    { 17, 10,  5,  9, up25, unbanked }, { 17, 11,  5,  9, up25, unbanked }, { 17, 12,  5,  9, up25, unbanked }, { 17, 13,  6,  9, up25, unbanked }, { 17, 14,  6,  9, up25, unbanked },
    { 18, 15,  7,  9, up25, unbanked }, { 18, 16,  8,  9, up25, unbanked }, { 18, 17,  8,  9, up25, unbanked }, { 18, 18,  9,  9, up25, unbanked }, { 18, 19,  9,  9, up25, unbanked },
    { 19, 20, 10,  9, up25, unbanked }, { 19, 21, 10,  9, up25, unbanked }, { 19, 22, 11, 10, up25, unbanked }, { 19, 23, 11, 10, up25, unbanked }, { 20, 24, 12, 10, up25, unbanked },
    { 20, 25, 12, 10, up25, unbanked }, { 20, 26, 13, 10, up25, unbanked }, { 21, 27, 13, 10, up25, unbanked }, { 21, 28, 14, 10, up25, unbanked }, { 21, 29, 14, 10, up25, unbanked },
    { 22, 30, 15, 10, up25, unbanked }, { 22, 31, 16, 10, up25, unbanked }, { 23, 32, 16, 10, up25, unbanked }, { 23, 33, 17, 10, up25, unbanked }, { 24, 34, 17, 10, up25, unbanked },
    { 24, 35, 18, 10, up25, unbanked }, { 25, 36, 18, 10, up25, unbanked }, { 25, 37, 19, 11, up25, unbanked }, { 26, 38, 20, 11, up25, unbanked }, { 26, 39, 20, 11, up25, unbanked },
    { 27, 40, 21, 11, up25, unbanked }, { 28, 41, 21, 11, up25, unbanked }, { 28, 42, 22, 11, up25, unbanked }, { 29, 43, 23, 11, up25, unbanked }, { 30, 44, 23, 11, up25, unbanked },
    { 30, 45, 24, 11, up25, unbanked }, { 31, 46, 24, 11, up25, unbanked }, { 32, 47, 25, 11, up25, unbanked }, { 32, 48, 26, 11, up25, unbanked }, { 33, 49, 26, 11, up25, unbanked },
    { 34, 50, 27, 12, up25, unbanked }, { 35, 51, 28, 12, up25, unbanked }, { 35, 52, 28, 12, up25, unbanked }, { 36, 53, 29, 12, up25, unbanked }, { 37, 54, 29, 12, up25, unbanked },
    { 38, 55, 30, 12, up25, unbanked }, { 39, 56, 31, 12, up25, unbanked }, { 39, 57, 32, 12, up25, unbanked }, { 40, 58, 32, 12, up25, unbanked }, { 41, 59, 33, 12, up25, unbanked },
    { 42, 60, 33, 12, up25, unbanked }, { 43, 61, 34, 12, up25, unbanked }, { 44, 61, 35, 12, up25, unbanked }, { 45, 62, 35, 13, up25, unbanked }, { 46, 63, 36, 13, up25, unbanked },
    { 47, 64, 37, 13, up25, unbanked }, { 48, 64, 37, 13, up25, unbanked }, { 49, 65, 38, 13, up25, unbanked }, { 50, 66, 38, 13, up25, unbanked }, { 51, 66, 39, 13, up25, unbanked },
    { 52, 67, 40, 13, up25, unbanked }, { 53, 68, 40, 13, up25, unbanked }, { 54, 68, 41, 13, up25, unbanked }, { 55, 69, 41, 13, up25, unbanked }, { 56, 70, 42, 13, up25, unbanked },
    { 57, 70, 43, 13, up25, unbanked }, { 58, 71, 43, 14, up25, unbanked }, { 59, 71, 44, 14, up25, unbanked }, { 60, 72, 44, 14, up25, unbanked }, { 61, 72, 45, 14, up25, unbanked },
    { 62, 73, 46, 14, up25, unbanked }, { 63, 73, 46, 14, up25, unbanked }, { 64, 74, 47, 14, up25, unbanked }, { 65, 74, 47, 14, up25, unbanked }, { 66, 75, 48, 14, up25, unbanked },
    { 67, 75, 49, 14, up25, unbanked }, { 68, 75, 49, 14, up25, unbanked }, { 69, 76, 50, 14, up25, unbanked }, { 70, 76, 50, 14, up25, unbanked }, { 71, 76, 51, 14, up25, unbanked },
    { 72, 77, 51, 15, up25, unbanked }, { 73, 77, 52, 15, up25, unbanked }, { 74, 77, 52, 15, up25, unbanked }, { 75, 77, 53, 15, up25, unbanked }, { 76, 78, 53, 15, up25, unbanked },
    { 77, 78, 54, 15, up25, unbanked }, { 78, 78, 54, 15, up25, unbanked }, { 79, 78, 55, 15, up25, unbanked }, { 80, 78, 55, 15, up25, unbanked }, { 81, 79, 56, 15, up25, unbanked },
    { 82, 79, 57, 15, up25, unbanked }, { 83, 79, 57, 15, up25, unbanked }, { 84, 79, 58, 15, up25, unbanked }, { 85, 79, 58, 15, up25, unbanked }, { 86, 79, 58, 15, up25, unbanked },
    { 87, 80, 59, 15, up25, unbanked }, { 88, 80, 60, 16, up25, unbanked }, { 89, 80, 60, 16, up25, unbanked }, { 90, 80, 61, 16, up25, unbanked }, { 91, 80, 61, 16, up25, unbanked },
    { 92, 80, 62, 16, up25, unbanked }, { 93, 80, 62, 16, up25, unbanked }, { 94, 80, 63, 16, up25, unbanked }, { 95, 80, 63, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D1C8D, {
    {  0,  16,  0, 16, up25, unbanked }, {  1,  16,  0, 16, up25, unbanked }, {  2,  16,  0, 16, up25, unbanked }, {  3,  16,  1, 16, up25, unbanked }, {  4,  16,  1, 16, up25, unbanked },
    {  5,  16,  2, 16, up25, unbanked }, {  6,  16,  2, 16, up25, unbanked }, {  7,  16,  3, 16, up25, unbanked }, {  8,  16,  3, 17, up25, unbanked }, {  9,  15,  4, 17, up25, unbanked },
    { 10,  15,  4, 17, up25, unbanked }, { 11,  15,  5, 17, up25, unbanked }, { 12,  15,  5, 17, up25, unbanked }, { 13,  15,  6, 17, up25, unbanked }, { 14,  15,  6, 17, up25, unbanked },
    { 15,  14,  7, 17, up25, unbanked }, { 16,  14,  8, 17, up25, unbanked }, { 17,  14,  8, 17, up25, unbanked }, { 18,  14,  8, 17, up25, unbanked }, { 19,  14,  9, 17, up25, unbanked },
    { 20,  13,  9, 17, up25, unbanked }, { 21,  13, 10, 17, up25, unbanked }, { 22,  13, 11, 18, up25, unbanked }, { 23,  13, 11, 18, up25, unbanked }, { 24,  12, 12, 18, up25, unbanked },
    { 25,  12, 12, 18, up25, unbanked }, { 26,  12, 13, 18, up25, unbanked }, { 27,  11, 13, 18, up25, unbanked }, { 28,  11, 14, 18, up25, unbanked }, { 29,  11, 14, 18, up25, unbanked },
    { 30,  10, 15, 18, up25, unbanked }, { 31,  10, 15, 18, up25, unbanked }, { 32,   9, 16, 18, up25, unbanked }, { 33,   9, 17, 18, up25, unbanked }, { 34,   8, 17, 18, up25, unbanked },
    { 35,   8, 18, 18, up25, unbanked }, { 36,   7, 18, 18, up25, unbanked }, { 37,   7, 19, 19, up25, unbanked }, { 38,   6, 19, 19, up25, unbanked }, { 39,   6, 20, 19, up25, unbanked },
    { 40,   5, 21, 19, up25, unbanked }, { 41,   4, 21, 19, up25, unbanked }, { 42,   4, 22, 19, up25, unbanked }, { 43,   3, 22, 19, up25, unbanked }, { 44,   2, 23, 19, up25, unbanked },
    { 45,   2, 24, 19, up25, unbanked }, { 46,   1, 24, 19, up25, unbanked }, { 47,   0, 25, 19, up25, unbanked }, { 48,   0, 26, 19, up25, unbanked }, { 49,  -1, 26, 19, up25, unbanked },
    { 50,  -2, 27, 20, up25, unbanked }, { 51,  -3, 27, 20, up25, unbanked }, { 52,  -3, 28, 20, up25, unbanked }, { 53,  -4, 29, 20, up25, unbanked }, { 54,  -5, 29, 20, up25, unbanked },
    { 55,  -6, 30, 20, up25, unbanked }, { 56,  -7, 31, 20, up25, unbanked }, { 57,  -7, 31, 20, up25, unbanked }, { 58,  -8, 32, 20, up25, unbanked }, { 59,  -9, 32, 20, up25, unbanked },
    { 60, -10, 33, 20, up25, unbanked }, { 61, -11, 34, 20, up25, unbanked }, { 61, -12, 34, 20, up25, unbanked }, { 62, -13, 35, 21, up25, unbanked }, { 63, -14, 36, 21, up25, unbanked },
    { 64, -15, 36, 21, up25, unbanked }, { 64, -16, 37, 21, up25, unbanked }, { 65, -17, 37, 21, up25, unbanked }, { 66, -18, 38, 21, up25, unbanked }, { 66, -19, 39, 21, up25, unbanked },
    { 67, -20, 39, 21, up25, unbanked }, { 68, -21, 40, 21, up25, unbanked }, { 68, -22, 41, 21, up25, unbanked }, { 69, -23, 41, 21, up25, unbanked }, { 70, -24, 42, 21, up25, unbanked },
    { 70, -25, 42, 21, up25, unbanked }, { 71, -26, 43, 22, up25, unbanked }, { 71, -27, 44, 22, up25, unbanked }, { 72, -28, 44, 22, up25, unbanked }, { 72, -29, 45, 22, up25, unbanked },
    { 73, -30, 45, 22, up25, unbanked }, { 73, -31, 46, 22, up25, unbanked }, { 74, -32, 46, 22, up25, unbanked }, { 74, -33, 47, 22, up25, unbanked }, { 75, -34, 48, 22, up25, unbanked },
    { 75, -35, 48, 22, up25, unbanked }, { 75, -36, 49, 22, up25, unbanked }, { 76, -37, 49, 22, up25, unbanked }, { 76, -38, 50, 22, up25, unbanked }, { 76, -39, 50, 22, up25, unbanked },
    { 77, -40, 51, 23, up25, unbanked }, { 77, -41, 51, 23, up25, unbanked }, { 77, -42, 52, 23, up25, unbanked }, { 77, -43, 52, 23, up25, unbanked }, { 78, -44, 53, 23, up25, unbanked },
    { 78, -45, 54, 23, up25, unbanked }, { 78, -46, 54, 23, up25, unbanked }, { 78, -47, 55, 23, up25, unbanked }, { 78, -48, 55, 23, up25, unbanked }, { 79, -49, 55, 23, up25, unbanked },
    { 79, -50, 56, 23, up25, unbanked }, { 79, -51, 57, 23, up25, unbanked }, { 79, -52, 57, 23, up25, unbanked }, { 79, -53, 58, 23, up25, unbanked }, { 79, -54, 58, 23, up25, unbanked },
    { 80, -55, 59, 23, up25, unbanked }, { 80, -56, 59, 24, up25, unbanked }, { 80, -57, 60, 24, up25, unbanked }, { 80, -58, 60, 24, up25, unbanked }, { 80, -59, 61, 24, up25, unbanked },
    { 80, -60, 61, 24, up25, unbanked }, { 80, -61, 62, 24, up25, unbanked }, { 80, -62, 62, 24, up25, unbanked }, { 80, -63, 63, 24, up25, unbanked }, { 80, -64, 64, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D209A, {
    {  16,  31,  0, 24, up25, unbanked }, {  16,  30,  0, 24, up25, unbanked }, {  16,  29,  1, 24, up25, unbanked }, {  16,  28,  1, 24, up25, unbanked }, {  16,  27,  2, 24, up25, unbanked },
    {  16,  26,  2, 24, up25, unbanked }, {  16,  25,  3, 24, up25, unbanked }, {  16,  24,  3, 25, up25, unbanked }, {  15,  23,  4, 25, up25, unbanked }, {  15,  22,  4, 25, up25, unbanked },
    {  15,  21,  5, 25, up25, unbanked }, {  15,  20,  5, 25, up25, unbanked }, {  15,  19,  6, 25, up25, unbanked }, {  15,  18,  6, 25, up25, unbanked }, {  14,  17,  7, 25, up25, unbanked },
    {  14,  16,  8, 25, up25, unbanked }, {  14,  15,  8, 25, up25, unbanked }, {  14,  14,  8, 25, up25, unbanked }, {  14,  13,  9, 25, up25, unbanked }, {  13,  12,  9, 25, up25, unbanked },
    {  13,  11, 10, 25, up25, unbanked }, {  13,  10, 11, 26, up25, unbanked }, {  13,   9, 11, 26, up25, unbanked }, {  12,   8, 12, 26, up25, unbanked }, {  12,   7, 12, 26, up25, unbanked },
    {  12,   6, 13, 26, up25, unbanked }, {  11,   5, 13, 26, up25, unbanked }, {  11,   4, 14, 26, up25, unbanked }, {  11,   3, 14, 26, up25, unbanked }, {  10,   2, 15, 26, up25, unbanked },
    {  10,   1, 15, 26, up25, unbanked }, {   9,   0, 16, 26, up25, unbanked }, {   9,  -1, 17, 26, up25, unbanked }, {   8,  -2, 17, 26, up25, unbanked }, {   8,  -3, 18, 26, up25, unbanked },
    {   7,  -4, 18, 26, up25, unbanked }, {   7,  -5, 19, 27, up25, unbanked }, {   6,  -6, 19, 27, up25, unbanked }, {   6,  -7, 20, 27, up25, unbanked }, {   5,  -8, 21, 27, up25, unbanked },
    {   4,  -9, 21, 27, up25, unbanked }, {   4, -10, 22, 27, up25, unbanked }, {   3, -11, 22, 27, up25, unbanked }, {   2, -12, 23, 27, up25, unbanked }, {   2, -13, 24, 27, up25, unbanked },
    {   1, -14, 24, 27, up25, unbanked }, {   0, -15, 25, 27, up25, unbanked }, {   0, -16, 26, 27, up25, unbanked }, {  -1, -17, 26, 27, up25, unbanked }, {  -2, -18, 27, 28, up25, unbanked },
    {  -3, -19, 27, 28, up25, unbanked }, {  -3, -20, 28, 28, up25, unbanked }, {  -4, -21, 29, 28, up25, unbanked }, {  -5, -22, 29, 28, up25, unbanked }, {  -6, -23, 30, 28, up25, unbanked },
    {  -7, -24, 31, 28, up25, unbanked }, {  -7, -25, 32, 28, up25, unbanked }, {  -8, -26, 32, 28, up25, unbanked }, {  -9, -27, 33, 28, up25, unbanked }, { -10, -28, 33, 28, up25, unbanked },
    { -11, -29, 34, 28, up25, unbanked }, { -12, -29, 35, 28, up25, unbanked }, { -13, -30, 35, 29, up25, unbanked }, { -14, -31, 36, 29, up25, unbanked }, { -15, -32, 37, 29, up25, unbanked },
    { -16, -32, 37, 29, up25, unbanked }, { -17, -33, 38, 29, up25, unbanked }, { -18, -34, 38, 29, up25, unbanked }, { -19, -34, 39, 29, up25, unbanked }, { -20, -35, 40, 29, up25, unbanked },
    { -21, -36, 40, 29, up25, unbanked }, { -22, -36, 41, 29, up25, unbanked }, { -23, -37, 41, 29, up25, unbanked }, { -24, -38, 42, 29, up25, unbanked }, { -25, -38, 43, 29, up25, unbanked },
    { -26, -39, 43, 30, up25, unbanked }, { -27, -39, 44, 30, up25, unbanked }, { -28, -40, 44, 30, up25, unbanked }, { -29, -40, 45, 30, up25, unbanked }, { -30, -41, 45, 30, up25, unbanked },
    { -31, -41, 46, 30, up25, unbanked }, { -32, -42, 47, 30, up25, unbanked }, { -33, -42, 47, 30, up25, unbanked }, { -34, -43, 48, 30, up25, unbanked }, { -35, -43, 48, 30, up25, unbanked },
    { -36, -43, 49, 30, up25, unbanked }, { -37, -44, 49, 30, up25, unbanked }, { -38, -44, 50, 30, up25, unbanked }, { -39, -44, 51, 30, up25, unbanked }, { -40, -45, 51, 31, up25, unbanked },
    { -41, -45, 52, 31, up25, unbanked }, { -42, -45, 52, 31, up25, unbanked }, { -43, -45, 53, 31, up25, unbanked }, { -44, -46, 53, 31, up25, unbanked }, { -45, -46, 54, 31, up25, unbanked },
    { -46, -46, 54, 31, up25, unbanked }, { -47, -46, 55, 31, up25, unbanked }, { -48, -46, 55, 31, up25, unbanked }, { -49, -47, 56, 31, up25, unbanked }, { -50, -47, 56, 31, up25, unbanked },
    { -51, -47, 57, 31, up25, unbanked }, { -52, -47, 57, 31, up25, unbanked }, { -53, -47, 58, 31, up25, unbanked }, { -54, -47, 58, 31, up25, unbanked }, { -55, -48, 59, 31, up25, unbanked },
    { -56, -48, 59,  0, up25, unbanked }, { -57, -48, 60,  0, up25, unbanked }, { -58, -48, 60,  0, up25, unbanked }, { -59, -48, 61,  0, up25, unbanked }, { -60, -48, 61,  0, up25, unbanked },
    { -61, -48, 62,  0, up25, unbanked }, { -62, -48, 62,  0, up25, unbanked }, { -63, -48, 63,  0, up25, unbanked }, { -64, -48, 64,  0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D249E, {
    {  31,  16,  15,  0, down25, unbanked }, {  30,  16,  15,  0, down25, unbanked }, {  29,  16,  14,  0, down25, unbanked }, {  28,  16,  14,  0, down25, unbanked }, {  27,  16,  13,  0, down25, unbanked },
    {  26,  16,  13,  0, down25, unbanked }, {  25,  16,  12,  0, down25, unbanked }, {  24,  16,  12, 31, down25, unbanked }, {  23,  15,  11, 31, down25, unbanked }, {  22,  15,  11, 31, down25, unbanked },
    {  21,  15,  10, 31, down25, unbanked }, {  20,  15,  10, 31, down25, unbanked }, {  19,  15,   9, 31, down25, unbanked }, {  18,  15,   9, 31, down25, unbanked }, {  17,  14,   8, 31, down25, unbanked },
    {  16,  14,   7, 31, down25, unbanked }, {  15,  14,   7, 31, down25, unbanked }, {  14,  14,   7, 31, down25, unbanked }, {  13,  14,   6, 31, down25, unbanked }, {  12,  13,   6, 31, down25, unbanked },
    {  11,  13,   5, 31, down25, unbanked }, {  10,  13,   4, 30, down25, unbanked }, {   9,  13,   4, 30, down25, unbanked }, {   8,  12,   3, 30, down25, unbanked }, {   7,  12,   3, 30, down25, unbanked },
    {   6,  12,   2, 30, down25, unbanked }, {   5,  11,   2, 30, down25, unbanked }, {   4,  11,   1, 30, down25, unbanked }, {   3,  11,   1, 30, down25, unbanked }, {   2,  10,   0, 30, down25, unbanked },
    {   1,  10,   0, 30, down25, unbanked }, {   0,   9,  -1, 30, down25, unbanked }, {  -1,   9,  -2, 30, down25, unbanked }, {  -2,   8,  -2, 30, down25, unbanked }, {  -3,   8,  -3, 30, down25, unbanked },
    {  -4,   7,  -3, 30, down25, unbanked }, {  -5,   7,  -4, 29, down25, unbanked }, {  -6,   6,  -4, 29, down25, unbanked }, {  -7,   6,  -5, 29, down25, unbanked }, {  -8,   5,  -6, 29, down25, unbanked },
    {  -9,   4,  -6, 29, down25, unbanked }, { -10,   4,  -7, 29, down25, unbanked }, { -11,   3,  -7, 29, down25, unbanked }, { -12,   2,  -8, 29, down25, unbanked }, { -13,   2,  -9, 29, down25, unbanked },
    { -14,   1,  -9, 29, down25, unbanked }, { -15,   0, -10, 29, down25, unbanked }, { -16,   0, -11, 29, down25, unbanked }, { -17,  -1, -11, 29, down25, unbanked }, { -18,  -2, -12, 28, down25, unbanked },
    { -19,  -3, -12, 28, down25, unbanked }, { -20,  -3, -13, 28, down25, unbanked }, { -21,  -4, -14, 28, down25, unbanked }, { -22,  -5, -14, 28, down25, unbanked }, { -23,  -6, -15, 28, down25, unbanked },
    { -24,  -7, -16, 28, down25, unbanked }, { -25,  -7, -16, 28, down25, unbanked }, { -26,  -8, -17, 28, down25, unbanked }, { -27,  -9, -17, 28, down25, unbanked }, { -28, -10, -18, 28, down25, unbanked },
    { -29, -11, -19, 28, down25, unbanked }, { -29, -12, -19, 28, down25, unbanked }, { -30, -13, -20, 27, down25, unbanked }, { -31, -14, -21, 27, down25, unbanked }, { -32, -15, -21, 27, down25, unbanked },
    { -32, -16, -22, 27, down25, unbanked }, { -33, -17, -22, 27, down25, unbanked }, { -34, -18, -23, 27, down25, unbanked }, { -34, -19, -24, 27, down25, unbanked }, { -35, -20, -24, 27, down25, unbanked },
    { -36, -21, -25, 27, down25, unbanked }, { -36, -22, -26, 27, down25, unbanked }, { -37, -23, -26, 27, down25, unbanked }, { -38, -24, -27, 27, down25, unbanked }, { -38, -25, -27, 27, down25, unbanked },
    { -39, -26, -28, 26, down25, unbanked }, { -39, -27, -29, 26, down25, unbanked }, { -40, -28, -29, 26, down25, unbanked }, { -40, -29, -30, 26, down25, unbanked }, { -41, -30, -30, 26, down25, unbanked },
    { -41, -31, -31, 26, down25, unbanked }, { -42, -32, -31, 26, down25, unbanked }, { -42, -33, -32, 26, down25, unbanked }, { -43, -34, -33, 26, down25, unbanked }, { -43, -35, -33, 26, down25, unbanked },
    { -43, -36, -34, 26, down25, unbanked }, { -44, -37, -34, 26, down25, unbanked }, { -44, -38, -35, 26, down25, unbanked }, { -44, -39, -35, 26, down25, unbanked }, { -45, -40, -36, 25, down25, unbanked },
    { -45, -41, -36, 25, down25, unbanked }, { -45, -42, -37, 25, down25, unbanked }, { -45, -43, -37, 25, down25, unbanked }, { -46, -44, -38, 25, down25, unbanked }, { -46, -45, -39, 25, down25, unbanked },
    { -46, -46, -39, 25, down25, unbanked }, { -46, -47, -40, 25, down25, unbanked }, { -46, -48, -40, 25, down25, unbanked }, { -47, -49, -40, 25, down25, unbanked }, { -47, -50, -41, 25, down25, unbanked },
    { -47, -51, -42, 25, down25, unbanked }, { -47, -52, -42, 25, down25, unbanked }, { -47, -53, -43, 25, down25, unbanked }, { -47, -54, -43, 25, down25, unbanked }, { -48, -55, -44, 25, down25, unbanked },
    { -48, -56, -44, 24, down25, unbanked }, { -48, -57, -45, 24, down25, unbanked }, { -48, -58, -45, 24, down25, unbanked }, { -48, -59, -46, 24, down25, unbanked }, { -48, -60, -46, 24, down25, unbanked },
    { -48, -61, -47, 24, down25, unbanked }, { -48, -62, -47, 24, down25, unbanked }, { -48, -63, -48, 24, down25, unbanked }, { -48, -64, -49, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D28A2, {
    {  16,  0,  15, 8, down25, unbanked }, {  16,  1,  15, 8, down25, unbanked }, {  16,  2,  15, 8, down25, unbanked }, {  16,  3,  14, 8, down25, unbanked }, {  16,  4,  14, 8, down25, unbanked },
    {  16,  5,  13, 8, down25, unbanked }, {  16,  6,  13, 8, down25, unbanked }, {  16,  7,  12, 8, down25, unbanked }, {  16,  8,  12, 7, down25, unbanked }, {  15,  9,  11, 7, down25, unbanked },
    {  15, 10,  11, 7, down25, unbanked }, {  15, 11,  10, 7, down25, unbanked }, {  15, 12,  10, 7, down25, unbanked }, {  15, 13,   9, 7, down25, unbanked }, {  15, 14,   9, 7, down25, unbanked },
    {  14, 15,   8, 7, down25, unbanked }, {  14, 16,   7, 7, down25, unbanked }, {  14, 17,   7, 7, down25, unbanked }, {  14, 18,   7, 7, down25, unbanked }, {  14, 19,   6, 7, down25, unbanked },
    {  13, 20,   6, 7, down25, unbanked }, {  13, 21,   5, 7, down25, unbanked }, {  13, 22,   4, 6, down25, unbanked }, {  13, 23,   4, 6, down25, unbanked }, {  12, 24,   3, 6, down25, unbanked },
    {  12, 25,   3, 6, down25, unbanked }, {  12, 26,   2, 6, down25, unbanked }, {  11, 27,   2, 6, down25, unbanked }, {  11, 28,   1, 6, down25, unbanked }, {  11, 29,   1, 6, down25, unbanked },
    {  10, 30,   0, 6, down25, unbanked }, {  10, 31,   0, 6, down25, unbanked }, {   9, 32,  -1, 6, down25, unbanked }, {   9, 33,  -2, 6, down25, unbanked }, {   8, 34,  -2, 6, down25, unbanked },
    {   8, 35,  -3, 6, down25, unbanked }, {   7, 36,  -3, 6, down25, unbanked }, {   7, 37,  -4, 5, down25, unbanked }, {   6, 38,  -4, 5, down25, unbanked }, {   6, 39,  -5, 5, down25, unbanked },
    {   5, 40,  -6, 5, down25, unbanked }, {   4, 41,  -6, 5, down25, unbanked }, {   4, 42,  -7, 5, down25, unbanked }, {   3, 43,  -7, 5, down25, unbanked }, {   2, 44,  -8, 5, down25, unbanked },
    {   2, 45,  -9, 5, down25, unbanked }, {   1, 46,  -9, 5, down25, unbanked }, {   0, 47, -10, 5, down25, unbanked }, {   0, 48, -11, 5, down25, unbanked }, {  -1, 49, -11, 5, down25, unbanked },
    {  -2, 50, -12, 4, down25, unbanked }, {  -3, 51, -12, 4, down25, unbanked }, {  -3, 52, -13, 4, down25, unbanked }, {  -4, 53, -14, 4, down25, unbanked }, {  -5, 54, -14, 4, down25, unbanked },
    {  -6, 55, -15, 4, down25, unbanked }, {  -7, 56, -16, 4, down25, unbanked }, {  -7, 57, -16, 4, down25, unbanked }, {  -8, 58, -17, 4, down25, unbanked }, {  -9, 59, -17, 4, down25, unbanked },
    { -10, 60, -18, 4, down25, unbanked }, { -11, 61, -19, 4, down25, unbanked }, { -12, 61, -19, 4, down25, unbanked }, { -13, 62, -20, 3, down25, unbanked }, { -14, 63, -21, 3, down25, unbanked },
    { -15, 64, -21, 3, down25, unbanked }, { -16, 64, -22, 3, down25, unbanked }, { -17, 65, -22, 3, down25, unbanked }, { -18, 66, -23, 3, down25, unbanked }, { -19, 66, -24, 3, down25, unbanked },
    { -20, 67, -24, 3, down25, unbanked }, { -21, 68, -25, 3, down25, unbanked }, { -22, 68, -26, 3, down25, unbanked }, { -23, 69, -26, 3, down25, unbanked }, { -24, 70, -27, 3, down25, unbanked },
    { -25, 70, -27, 3, down25, unbanked }, { -26, 71, -28, 2, down25, unbanked }, { -27, 71, -29, 2, down25, unbanked }, { -28, 72, -29, 2, down25, unbanked }, { -29, 72, -30, 2, down25, unbanked },
    { -30, 73, -30, 2, down25, unbanked }, { -31, 73, -31, 2, down25, unbanked }, { -32, 74, -31, 2, down25, unbanked }, { -33, 74, -32, 2, down25, unbanked }, { -34, 75, -33, 2, down25, unbanked },
    { -35, 75, -33, 2, down25, unbanked }, { -36, 75, -34, 2, down25, unbanked }, { -37, 76, -34, 2, down25, unbanked }, { -38, 76, -35, 2, down25, unbanked }, { -39, 76, -35, 2, down25, unbanked },
    { -40, 77, -36, 1, down25, unbanked }, { -41, 77, -36, 1, down25, unbanked }, { -42, 77, -37, 1, down25, unbanked }, { -43, 77, -37, 1, down25, unbanked }, { -44, 78, -38, 1, down25, unbanked },
    { -45, 78, -39, 1, down25, unbanked }, { -46, 78, -39, 1, down25, unbanked }, { -47, 78, -40, 1, down25, unbanked }, { -48, 78, -40, 1, down25, unbanked }, { -49, 79, -40, 1, down25, unbanked },
    { -50, 79, -41, 1, down25, unbanked }, { -51, 79, -42, 1, down25, unbanked }, { -52, 79, -42, 1, down25, unbanked }, { -53, 79, -43, 1, down25, unbanked }, { -54, 79, -43, 1, down25, unbanked },
    { -55, 80, -44, 1, down25, unbanked }, { -56, 80, -44, 0, down25, unbanked }, { -57, 80, -45, 0, down25, unbanked }, { -58, 80, -45, 0, down25, unbanked }, { -59, 80, -46, 0, down25, unbanked },
    { -60, 80, -46, 0, down25, unbanked }, { -61, 80, -47, 0, down25, unbanked }, { -62, 80, -47, 0, down25, unbanked }, { -63, 80, -48, 0, down25, unbanked }, { -64, 80, -49, 0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D2CAF, {
    {  0, 16,  15, 16, down25, unbanked }, {  1, 16,  15, 16, down25, unbanked }, {  2, 16,  15, 16, down25, unbanked }, {  3, 16,  14, 16, down25, unbanked }, {  4, 16,  14, 16, down25, unbanked },
    {  5, 16,  13, 16, down25, unbanked }, {  6, 16,  13, 16, down25, unbanked }, {  7, 16,  12, 16, down25, unbanked }, {  8, 16,  12, 15, down25, unbanked }, {  9, 17,  11, 15, down25, unbanked },
    { 10, 17,  10, 15, down25, unbanked }, { 11, 17,  10, 15, down25, unbanked }, { 12, 17,  10, 15, down25, unbanked }, { 13, 17,   9, 15, down25, unbanked }, { 14, 17,   9, 15, down25, unbanked },
    { 15, 18,   8, 15, down25, unbanked }, { 16, 18,   7, 15, down25, unbanked }, { 17, 18,   7, 15, down25, unbanked }, { 18, 18,   6, 15, down25, unbanked }, { 19, 18,   6, 15, down25, unbanked },
    { 20, 19,   5, 15, down25, unbanked }, { 21, 19,   5, 15, down25, unbanked }, { 22, 19,   4, 14, down25, unbanked }, { 23, 19,   4, 14, down25, unbanked }, { 24, 20,   3, 14, down25, unbanked },
    { 25, 20,   3, 14, down25, unbanked }, { 26, 20,   2, 14, down25, unbanked }, { 27, 21,   2, 14, down25, unbanked }, { 28, 21,   1, 14, down25, unbanked }, { 29, 21,   1, 14, down25, unbanked },
    { 30, 22,   0, 14, down25, unbanked }, { 31, 22,  -1, 14, down25, unbanked }, { 32, 23,  -1, 14, down25, unbanked }, { 33, 23,  -2, 14, down25, unbanked }, { 34, 24,  -2, 14, down25, unbanked },
    { 35, 24,  -3, 14, down25, unbanked }, { 36, 25,  -3, 14, down25, unbanked }, { 37, 25,  -4, 13, down25, unbanked }, { 38, 26,  -5, 13, down25, unbanked }, { 39, 26,  -5, 13, down25, unbanked },
    { 40, 27,  -6, 13, down25, unbanked }, { 41, 28,  -6, 13, down25, unbanked }, { 42, 28,  -7, 13, down25, unbanked }, { 43, 29,  -8, 13, down25, unbanked }, { 44, 30,  -8, 13, down25, unbanked },
    { 45, 30,  -9, 13, down25, unbanked }, { 46, 31,  -9, 13, down25, unbanked }, { 47, 32, -10, 13, down25, unbanked }, { 48, 32, -11, 13, down25, unbanked }, { 49, 33, -11, 13, down25, unbanked },
    { 50, 34, -12, 12, down25, unbanked }, { 51, 35, -13, 12, down25, unbanked }, { 52, 35, -13, 12, down25, unbanked }, { 53, 36, -14, 12, down25, unbanked }, { 54, 37, -14, 12, down25, unbanked },
    { 55, 38, -15, 12, down25, unbanked }, { 56, 39, -16, 12, down25, unbanked }, { 57, 39, -17, 12, down25, unbanked }, { 58, 40, -17, 12, down25, unbanked }, { 59, 41, -18, 12, down25, unbanked },
    { 60, 42, -18, 12, down25, unbanked }, { 61, 43, -19, 12, down25, unbanked }, { 61, 44, -20, 12, down25, unbanked }, { 62, 45, -20, 11, down25, unbanked }, { 63, 46, -21, 11, down25, unbanked },
    { 64, 47, -22, 11, down25, unbanked }, { 64, 48, -22, 11, down25, unbanked }, { 65, 49, -23, 11, down25, unbanked }, { 66, 50, -23, 11, down25, unbanked }, { 66, 51, -24, 11, down25, unbanked },
    { 67, 52, -25, 11, down25, unbanked }, { 68, 53, -25, 11, down25, unbanked }, { 68, 54, -26, 11, down25, unbanked }, { 69, 55, -26, 11, down25, unbanked }, { 70, 56, -27, 11, down25, unbanked },
    { 70, 57, -28, 11, down25, unbanked }, { 71, 58, -28, 10, down25, unbanked }, { 71, 59, -29, 10, down25, unbanked }, { 72, 60, -29, 10, down25, unbanked }, { 72, 61, -30, 10, down25, unbanked },
    { 73, 62, -31, 10, down25, unbanked }, { 73, 63, -31, 10, down25, unbanked }, { 74, 64, -32, 10, down25, unbanked }, { 74, 65, -32, 10, down25, unbanked }, { 75, 66, -33, 10, down25, unbanked },
    { 75, 67, -34, 10, down25, unbanked }, { 75, 68, -34, 10, down25, unbanked }, { 76, 69, -35, 10, down25, unbanked }, { 76, 70, -35, 10, down25, unbanked }, { 76, 71, -36, 10, down25, unbanked },
    { 77, 72, -36,  9, down25, unbanked }, { 77, 73, -37,  9, down25, unbanked }, { 77, 74, -37,  9, down25, unbanked }, { 77, 75, -38,  9, down25, unbanked }, { 78, 76, -38,  9, down25, unbanked },
    { 78, 77, -39,  9, down25, unbanked }, { 78, 78, -39,  9, down25, unbanked }, { 78, 79, -40,  9, down25, unbanked }, { 78, 80, -40,  9, down25, unbanked }, { 79, 81, -41,  9, down25, unbanked },
    { 79, 82, -42,  9, down25, unbanked }, { 79, 83, -42,  9, down25, unbanked }, { 79, 84, -43,  9, down25, unbanked }, { 79, 85, -43,  9, down25, unbanked }, { 79, 86, -43,  9, down25, unbanked },
    { 80, 87, -44,  9, down25, unbanked }, { 80, 88, -45,  8, down25, unbanked }, { 80, 89, -45,  8, down25, unbanked }, { 80, 90, -46,  8, down25, unbanked }, { 80, 91, -46,  8, down25, unbanked },
    { 80, 92, -47,  8, down25, unbanked }, { 80, 93, -47,  8, down25, unbanked }, { 80, 94, -48,  8, down25, unbanked }, { 80, 95, -48,  8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D30B3, {
    { 16,  31,  15, 24, down25, unbanked }, { 16,  30,  15, 24, down25, unbanked }, { 16,  29,  14, 24, down25, unbanked }, { 16,  28,  14, 24, down25, unbanked }, { 16,  27,  13, 24, down25, unbanked },
    { 16,  26,  13, 24, down25, unbanked }, { 16,  25,  12, 24, down25, unbanked }, { 16,  24,  12, 23, down25, unbanked }, { 17,  23,  11, 23, down25, unbanked }, { 17,  22,  10, 23, down25, unbanked },
    { 17,  21,  10, 23, down25, unbanked }, { 17,  20,  10, 23, down25, unbanked }, { 17,  19,   9, 23, down25, unbanked }, { 17,  18,   9, 23, down25, unbanked }, { 18,  17,   8, 23, down25, unbanked },
    { 18,  16,   7, 23, down25, unbanked }, { 18,  15,   7, 23, down25, unbanked }, { 18,  14,   6, 23, down25, unbanked }, { 18,  13,   6, 23, down25, unbanked }, { 19,  12,   5, 23, down25, unbanked },
    { 19,  11,   5, 23, down25, unbanked }, { 19,  10,   4, 22, down25, unbanked }, { 19,   9,   4, 22, down25, unbanked }, { 20,   8,   3, 22, down25, unbanked }, { 20,   7,   3, 22, down25, unbanked },
    { 20,   6,   2, 22, down25, unbanked }, { 21,   5,   2, 22, down25, unbanked }, { 21,   4,   1, 22, down25, unbanked }, { 21,   3,   1, 22, down25, unbanked }, { 22,   2,   0, 22, down25, unbanked },
    { 22,   1,  -1, 22, down25, unbanked }, { 23,   0,  -1, 22, down25, unbanked }, { 23,  -1,  -2, 22, down25, unbanked }, { 24,  -2,  -2, 22, down25, unbanked }, { 24,  -3,  -3, 22, down25, unbanked },
    { 25,  -4,  -3, 22, down25, unbanked }, { 25,  -5,  -4, 21, down25, unbanked }, { 26,  -6,  -5, 21, down25, unbanked }, { 26,  -7,  -5, 21, down25, unbanked }, { 27,  -8,  -6, 21, down25, unbanked },
    { 28,  -9,  -6, 21, down25, unbanked }, { 28, -10,  -7, 21, down25, unbanked }, { 29, -11,  -8, 21, down25, unbanked }, { 30, -12,  -8, 21, down25, unbanked }, { 30, -13,  -9, 21, down25, unbanked },
    { 31, -14,  -9, 21, down25, unbanked }, { 32, -15, -10, 21, down25, unbanked }, { 32, -16, -11, 21, down25, unbanked }, { 33, -17, -11, 21, down25, unbanked }, { 34, -18, -12, 20, down25, unbanked },
    { 35, -19, -13, 20, down25, unbanked }, { 35, -20, -13, 20, down25, unbanked }, { 36, -21, -14, 20, down25, unbanked }, { 37, -22, -14, 20, down25, unbanked }, { 38, -23, -15, 20, down25, unbanked },
    { 39, -24, -16, 20, down25, unbanked }, { 39, -25, -17, 20, down25, unbanked }, { 40, -26, -17, 20, down25, unbanked }, { 41, -27, -18, 20, down25, unbanked }, { 42, -28, -18, 20, down25, unbanked },
    { 43, -29, -19, 20, down25, unbanked }, { 44, -29, -20, 20, down25, unbanked }, { 45, -30, -20, 19, down25, unbanked }, { 46, -31, -21, 19, down25, unbanked }, { 47, -32, -22, 19, down25, unbanked },
    { 48, -32, -22, 19, down25, unbanked }, { 49, -33, -23, 19, down25, unbanked }, { 50, -34, -23, 19, down25, unbanked }, { 51, -34, -24, 19, down25, unbanked }, { 52, -35, -25, 19, down25, unbanked },
    { 53, -36, -25, 19, down25, unbanked }, { 54, -36, -26, 19, down25, unbanked }, { 55, -37, -26, 19, down25, unbanked }, { 56, -38, -27, 19, down25, unbanked }, { 57, -38, -28, 19, down25, unbanked },
    { 58, -39, -28, 18, down25, unbanked }, { 59, -39, -29, 18, down25, unbanked }, { 60, -40, -29, 18, down25, unbanked }, { 61, -40, -30, 18, down25, unbanked }, { 62, -41, -31, 18, down25, unbanked },
    { 63, -41, -31, 18, down25, unbanked }, { 64, -42, -32, 18, down25, unbanked }, { 65, -42, -32, 18, down25, unbanked }, { 66, -43, -33, 18, down25, unbanked }, { 67, -43, -34, 18, down25, unbanked },
    { 68, -43, -34, 18, down25, unbanked }, { 69, -44, -35, 18, down25, unbanked }, { 70, -44, -35, 18, down25, unbanked }, { 71, -44, -36, 18, down25, unbanked }, { 72, -45, -36, 17, down25, unbanked },
    { 73, -45, -37, 17, down25, unbanked }, { 74, -45, -37, 17, down25, unbanked }, { 75, -45, -38, 17, down25, unbanked }, { 76, -46, -38, 17, down25, unbanked }, { 77, -46, -39, 17, down25, unbanked },
    { 78, -46, -39, 17, down25, unbanked }, { 79, -46, -40, 17, down25, unbanked }, { 80, -46, -40, 17, down25, unbanked }, { 81, -47, -41, 17, down25, unbanked }, { 82, -47, -42, 17, down25, unbanked },
    { 83, -47, -42, 17, down25, unbanked }, { 84, -47, -43, 17, down25, unbanked }, { 85, -47, -43, 17, down25, unbanked }, { 86, -47, -43, 17, down25, unbanked }, { 87, -48, -44, 17, down25, unbanked },
    { 88, -48, -45, 16, down25, unbanked }, { 89, -48, -45, 16, down25, unbanked }, { 90, -48, -46, 16, down25, unbanked }, { 91, -48, -46, 16, down25, unbanked }, { 92, -48, -47, 16, down25, unbanked },
    { 93, -48, -47, 16, down25, unbanked }, { 94, -48, -48, 16, down25, unbanked }, { 95, -48, -48, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D34AE, {
    {  31, 16,  15, 0, down25, unbanked }, {  30, 16,  15, 0, down25, unbanked }, {  29, 16,  14, 0, down25, unbanked }, {  28, 16,  14, 0, down25, unbanked }, {  27, 16,  13, 0, down25, unbanked },
    {  26, 16,  13, 0, down25, unbanked }, {  25, 16,  12, 0, down25, unbanked }, {  24, 16,  12, 1, down25, unbanked }, {  23, 17,  11, 1, down25, unbanked }, {  22, 17,  10, 1, down25, unbanked },
    {  21, 17,  10, 1, down25, unbanked }, {  20, 17,  10, 1, down25, unbanked }, {  19, 17,   9, 1, down25, unbanked }, {  18, 17,   9, 1, down25, unbanked }, {  17, 18,   8, 1, down25, unbanked },
    {  16, 18,   7, 1, down25, unbanked }, {  15, 18,   7, 1, down25, unbanked }, {  14, 18,   6, 1, down25, unbanked }, {  13, 18,   6, 1, down25, unbanked }, {  12, 19,   5, 1, down25, unbanked },
    {  11, 19,   5, 1, down25, unbanked }, {  10, 19,   4, 2, down25, unbanked }, {   9, 19,   4, 2, down25, unbanked }, {   8, 20,   3, 2, down25, unbanked }, {   7, 20,   3, 2, down25, unbanked },
    {   6, 20,   2, 2, down25, unbanked }, {   5, 21,   2, 2, down25, unbanked }, {   4, 21,   1, 2, down25, unbanked }, {   3, 21,   1, 2, down25, unbanked }, {   2, 22,   0, 2, down25, unbanked },
    {   1, 22,  -1, 2, down25, unbanked }, {   0, 23,  -1, 2, down25, unbanked }, {  -1, 23,  -2, 2, down25, unbanked }, {  -2, 24,  -2, 2, down25, unbanked }, {  -3, 24,  -3, 2, down25, unbanked },
    {  -4, 25,  -3, 2, down25, unbanked }, {  -5, 25,  -4, 3, down25, unbanked }, {  -6, 26,  -5, 3, down25, unbanked }, {  -7, 26,  -5, 3, down25, unbanked }, {  -8, 27,  -6, 3, down25, unbanked },
    {  -9, 28,  -6, 3, down25, unbanked }, { -10, 28,  -7, 3, down25, unbanked }, { -11, 29,  -8, 3, down25, unbanked }, { -12, 30,  -8, 3, down25, unbanked }, { -13, 30,  -9, 3, down25, unbanked },
    { -14, 31,  -9, 3, down25, unbanked }, { -15, 32, -10, 3, down25, unbanked }, { -16, 32, -11, 3, down25, unbanked }, { -17, 33, -11, 3, down25, unbanked }, { -18, 34, -12, 4, down25, unbanked },
    { -19, 35, -13, 4, down25, unbanked }, { -20, 35, -13, 4, down25, unbanked }, { -21, 36, -14, 4, down25, unbanked }, { -22, 37, -14, 4, down25, unbanked }, { -23, 38, -15, 4, down25, unbanked },
    { -24, 39, -16, 4, down25, unbanked }, { -25, 39, -17, 4, down25, unbanked }, { -26, 40, -17, 4, down25, unbanked }, { -27, 41, -18, 4, down25, unbanked }, { -28, 42, -18, 4, down25, unbanked },
    { -29, 43, -19, 4, down25, unbanked }, { -29, 44, -20, 4, down25, unbanked }, { -30, 45, -20, 5, down25, unbanked }, { -31, 46, -21, 5, down25, unbanked }, { -32, 47, -22, 5, down25, unbanked },
    { -32, 48, -22, 5, down25, unbanked }, { -33, 49, -23, 5, down25, unbanked }, { -34, 50, -23, 5, down25, unbanked }, { -34, 51, -24, 5, down25, unbanked }, { -35, 52, -25, 5, down25, unbanked },
    { -36, 53, -25, 5, down25, unbanked }, { -36, 54, -26, 5, down25, unbanked }, { -37, 55, -26, 5, down25, unbanked }, { -38, 56, -27, 5, down25, unbanked }, { -38, 57, -28, 5, down25, unbanked },
    { -39, 58, -28, 6, down25, unbanked }, { -39, 59, -29, 6, down25, unbanked }, { -40, 60, -29, 6, down25, unbanked }, { -40, 61, -30, 6, down25, unbanked }, { -41, 62, -31, 6, down25, unbanked },
    { -41, 63, -31, 6, down25, unbanked }, { -42, 64, -32, 6, down25, unbanked }, { -42, 65, -32, 6, down25, unbanked }, { -43, 66, -33, 6, down25, unbanked }, { -43, 67, -34, 6, down25, unbanked },
    { -43, 68, -34, 6, down25, unbanked }, { -44, 69, -35, 6, down25, unbanked }, { -44, 70, -35, 6, down25, unbanked }, { -44, 71, -36, 6, down25, unbanked }, { -45, 72, -36, 7, down25, unbanked },
    { -45, 73, -37, 7, down25, unbanked }, { -45, 74, -37, 7, down25, unbanked }, { -45, 75, -38, 7, down25, unbanked }, { -46, 76, -38, 7, down25, unbanked }, { -46, 77, -39, 7, down25, unbanked },
    { -46, 78, -39, 7, down25, unbanked }, { -46, 79, -40, 7, down25, unbanked }, { -46, 80, -40, 7, down25, unbanked }, { -47, 81, -41, 7, down25, unbanked }, { -47, 82, -42, 7, down25, unbanked },
    { -47, 83, -42, 7, down25, unbanked }, { -47, 84, -43, 7, down25, unbanked }, { -47, 85, -43, 7, down25, unbanked }, { -47, 86, -43, 7, down25, unbanked }, { -48, 87, -44, 7, down25, unbanked },
    { -48, 88, -45, 8, down25, unbanked }, { -48, 89, -45, 8, down25, unbanked }, { -48, 90, -46, 8, down25, unbanked }, { -48, 91, -46, 8, down25, unbanked }, { -48, 92, -47, 8, down25, unbanked },
    { -48, 93, -47, 8, down25, unbanked }, { -48, 94, -48, 8, down25, unbanked }, { -48, 95, -48, 8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D38A9, {
    { 16,  0,  15,  8, down25, unbanked }, { 16,  1,  15,  8, down25, unbanked }, { 16,  2,  15,  8, down25, unbanked }, { 16,  3,  14,  8, down25, unbanked }, { 16,  4,  14,  8, down25, unbanked },
    { 16,  5,  13,  8, down25, unbanked }, { 16,  6,  13,  8, down25, unbanked }, { 16,  7,  12,  8, down25, unbanked }, { 16,  8,  12,  9, down25, unbanked }, { 17,  9,  11,  9, down25, unbanked },
    { 17, 10,  10,  9, down25, unbanked }, { 17, 11,  10,  9, down25, unbanked }, { 17, 12,  10,  9, down25, unbanked }, { 17, 13,   9,  9, down25, unbanked }, { 17, 14,   9,  9, down25, unbanked },
    { 18, 15,   8,  9, down25, unbanked }, { 18, 16,   7,  9, down25, unbanked }, { 18, 17,   7,  9, down25, unbanked }, { 18, 18,   6,  9, down25, unbanked }, { 18, 19,   6,  9, down25, unbanked },
    { 19, 20,   5,  9, down25, unbanked }, { 19, 21,   5,  9, down25, unbanked }, { 19, 22,   4, 10, down25, unbanked }, { 19, 23,   4, 10, down25, unbanked }, { 20, 24,   3, 10, down25, unbanked },
    { 20, 25,   3, 10, down25, unbanked }, { 20, 26,   2, 10, down25, unbanked }, { 21, 27,   2, 10, down25, unbanked }, { 21, 28,   1, 10, down25, unbanked }, { 21, 29,   1, 10, down25, unbanked },
    { 22, 30,   0, 10, down25, unbanked }, { 22, 31,  -1, 10, down25, unbanked }, { 23, 32,  -1, 10, down25, unbanked }, { 23, 33,  -2, 10, down25, unbanked }, { 24, 34,  -2, 10, down25, unbanked },
    { 24, 35,  -3, 10, down25, unbanked }, { 25, 36,  -3, 10, down25, unbanked }, { 25, 37,  -4, 11, down25, unbanked }, { 26, 38,  -5, 11, down25, unbanked }, { 26, 39,  -5, 11, down25, unbanked },
    { 27, 40,  -6, 11, down25, unbanked }, { 28, 41,  -6, 11, down25, unbanked }, { 28, 42,  -7, 11, down25, unbanked }, { 29, 43,  -8, 11, down25, unbanked }, { 30, 44,  -8, 11, down25, unbanked },
    { 30, 45,  -9, 11, down25, unbanked }, { 31, 46,  -9, 11, down25, unbanked }, { 32, 47, -10, 11, down25, unbanked }, { 32, 48, -11, 11, down25, unbanked }, { 33, 49, -11, 11, down25, unbanked },
    { 34, 50, -12, 12, down25, unbanked }, { 35, 51, -13, 12, down25, unbanked }, { 35, 52, -13, 12, down25, unbanked }, { 36, 53, -14, 12, down25, unbanked }, { 37, 54, -14, 12, down25, unbanked },
    { 38, 55, -15, 12, down25, unbanked }, { 39, 56, -16, 12, down25, unbanked }, { 39, 57, -17, 12, down25, unbanked }, { 40, 58, -17, 12, down25, unbanked }, { 41, 59, -18, 12, down25, unbanked },
    { 42, 60, -18, 12, down25, unbanked }, { 43, 61, -19, 12, down25, unbanked }, { 44, 61, -20, 12, down25, unbanked }, { 45, 62, -20, 13, down25, unbanked }, { 46, 63, -21, 13, down25, unbanked },
    { 47, 64, -22, 13, down25, unbanked }, { 48, 64, -22, 13, down25, unbanked }, { 49, 65, -23, 13, down25, unbanked }, { 50, 66, -23, 13, down25, unbanked }, { 51, 66, -24, 13, down25, unbanked },
    { 52, 67, -25, 13, down25, unbanked }, { 53, 68, -25, 13, down25, unbanked }, { 54, 68, -26, 13, down25, unbanked }, { 55, 69, -26, 13, down25, unbanked }, { 56, 70, -27, 13, down25, unbanked },
    { 57, 70, -28, 13, down25, unbanked }, { 58, 71, -28, 14, down25, unbanked }, { 59, 71, -29, 14, down25, unbanked }, { 60, 72, -29, 14, down25, unbanked }, { 61, 72, -30, 14, down25, unbanked },
    { 62, 73, -31, 14, down25, unbanked }, { 63, 73, -31, 14, down25, unbanked }, { 64, 74, -32, 14, down25, unbanked }, { 65, 74, -32, 14, down25, unbanked }, { 66, 75, -33, 14, down25, unbanked },
    { 67, 75, -34, 14, down25, unbanked }, { 68, 75, -34, 14, down25, unbanked }, { 69, 76, -35, 14, down25, unbanked }, { 70, 76, -35, 14, down25, unbanked }, { 71, 76, -36, 14, down25, unbanked },
    { 72, 77, -36, 15, down25, unbanked }, { 73, 77, -37, 15, down25, unbanked }, { 74, 77, -37, 15, down25, unbanked }, { 75, 77, -38, 15, down25, unbanked }, { 76, 78, -38, 15, down25, unbanked },
    { 77, 78, -39, 15, down25, unbanked }, { 78, 78, -39, 15, down25, unbanked }, { 79, 78, -40, 15, down25, unbanked }, { 80, 78, -40, 15, down25, unbanked }, { 81, 79, -41, 15, down25, unbanked },
    { 82, 79, -42, 15, down25, unbanked }, { 83, 79, -42, 15, down25, unbanked }, { 84, 79, -43, 15, down25, unbanked }, { 85, 79, -43, 15, down25, unbanked }, { 86, 79, -43, 15, down25, unbanked },
    { 87, 80, -44, 15, down25, unbanked }, { 88, 80, -45, 16, down25, unbanked }, { 89, 80, -45, 16, down25, unbanked }, { 90, 80, -46, 16, down25, unbanked }, { 91, 80, -46, 16, down25, unbanked },
    { 92, 80, -47, 16, down25, unbanked }, { 93, 80, -47, 16, down25, unbanked }, { 94, 80, -48, 16, down25, unbanked }, { 95, 80, -48, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D3CAD, {
    {  0,  16,  15, 16, down25, unbanked }, {  1,  16,  15, 16, down25, unbanked }, {  2,  16,  15, 16, down25, unbanked }, {  3,  16,  14, 16, down25, unbanked }, {  4,  16,  14, 16, down25, unbanked },
    {  5,  16,  13, 16, down25, unbanked }, {  6,  16,  13, 16, down25, unbanked }, {  7,  16,  12, 16, down25, unbanked }, {  8,  16,  12, 17, down25, unbanked }, {  9,  15,  11, 17, down25, unbanked },
    { 10,  15,  11, 17, down25, unbanked }, { 11,  15,  10, 17, down25, unbanked }, { 12,  15,  10, 17, down25, unbanked }, { 13,  15,   9, 17, down25, unbanked }, { 14,  15,   9, 17, down25, unbanked },
    { 15,  14,   8, 17, down25, unbanked }, { 16,  14,   7, 17, down25, unbanked }, { 17,  14,   7, 17, down25, unbanked }, { 18,  14,   7, 17, down25, unbanked }, { 19,  14,   6, 17, down25, unbanked },
    { 20,  13,   6, 17, down25, unbanked }, { 21,  13,   5, 17, down25, unbanked }, { 22,  13,   4, 18, down25, unbanked }, { 23,  13,   4, 18, down25, unbanked }, { 24,  12,   3, 18, down25, unbanked },
    { 25,  12,   3, 18, down25, unbanked }, { 26,  12,   2, 18, down25, unbanked }, { 27,  11,   2, 18, down25, unbanked }, { 28,  11,   1, 18, down25, unbanked }, { 29,  11,   1, 18, down25, unbanked },
    { 30,  10,   0, 18, down25, unbanked }, { 31,  10,   0, 18, down25, unbanked }, { 32,   9,  -1, 18, down25, unbanked }, { 33,   9,  -2, 18, down25, unbanked }, { 34,   8,  -2, 18, down25, unbanked },
    { 35,   8,  -3, 18, down25, unbanked }, { 36,   7,  -3, 18, down25, unbanked }, { 37,   7,  -4, 19, down25, unbanked }, { 38,   6,  -4, 19, down25, unbanked }, { 39,   6,  -5, 19, down25, unbanked },
    { 40,   5,  -6, 19, down25, unbanked }, { 41,   4,  -6, 19, down25, unbanked }, { 42,   4,  -7, 19, down25, unbanked }, { 43,   3,  -7, 19, down25, unbanked }, { 44,   2,  -8, 19, down25, unbanked },
    { 45,   2,  -9, 19, down25, unbanked }, { 46,   1,  -9, 19, down25, unbanked }, { 47,   0, -10, 19, down25, unbanked }, { 48,   0, -11, 19, down25, unbanked }, { 49,  -1, -11, 19, down25, unbanked },
    { 50,  -2, -12, 20, down25, unbanked }, { 51,  -3, -12, 20, down25, unbanked }, { 52,  -3, -13, 20, down25, unbanked }, { 53,  -4, -14, 20, down25, unbanked }, { 54,  -5, -14, 20, down25, unbanked },
    { 55,  -6, -15, 20, down25, unbanked }, { 56,  -7, -16, 20, down25, unbanked }, { 57,  -7, -16, 20, down25, unbanked }, { 58,  -8, -17, 20, down25, unbanked }, { 59,  -9, -17, 20, down25, unbanked },
    { 60, -10, -18, 20, down25, unbanked }, { 61, -11, -19, 20, down25, unbanked }, { 61, -12, -19, 20, down25, unbanked }, { 62, -13, -20, 21, down25, unbanked }, { 63, -14, -21, 21, down25, unbanked },
    { 64, -15, -21, 21, down25, unbanked }, { 64, -16, -22, 21, down25, unbanked }, { 65, -17, -22, 21, down25, unbanked }, { 66, -18, -23, 21, down25, unbanked }, { 66, -19, -24, 21, down25, unbanked },
    { 67, -20, -24, 21, down25, unbanked }, { 68, -21, -25, 21, down25, unbanked }, { 68, -22, -26, 21, down25, unbanked }, { 69, -23, -26, 21, down25, unbanked }, { 70, -24, -27, 21, down25, unbanked },
    { 70, -25, -27, 21, down25, unbanked }, { 71, -26, -28, 22, down25, unbanked }, { 71, -27, -29, 22, down25, unbanked }, { 72, -28, -29, 22, down25, unbanked }, { 72, -29, -30, 22, down25, unbanked },
    { 73, -30, -30, 22, down25, unbanked }, { 73, -31, -31, 22, down25, unbanked }, { 74, -32, -31, 22, down25, unbanked }, { 74, -33, -32, 22, down25, unbanked }, { 75, -34, -33, 22, down25, unbanked },
    { 75, -35, -33, 22, down25, unbanked }, { 75, -36, -34, 22, down25, unbanked }, { 76, -37, -34, 22, down25, unbanked }, { 76, -38, -35, 22, down25, unbanked }, { 76, -39, -35, 22, down25, unbanked },
    { 77, -40, -36, 23, down25, unbanked }, { 77, -41, -36, 23, down25, unbanked }, { 77, -42, -37, 23, down25, unbanked }, { 77, -43, -37, 23, down25, unbanked }, { 78, -44, -38, 23, down25, unbanked },
    { 78, -45, -39, 23, down25, unbanked }, { 78, -46, -39, 23, down25, unbanked }, { 78, -47, -40, 23, down25, unbanked }, { 78, -48, -40, 23, down25, unbanked }, { 79, -49, -40, 23, down25, unbanked },
    { 79, -50, -41, 23, down25, unbanked }, { 79, -51, -42, 23, down25, unbanked }, { 79, -52, -42, 23, down25, unbanked }, { 79, -53, -43, 23, down25, unbanked }, { 79, -54, -43, 23, down25, unbanked },
    { 80, -55, -44, 23, down25, unbanked }, { 80, -56, -44, 24, down25, unbanked }, { 80, -57, -45, 24, down25, unbanked }, { 80, -58, -45, 24, down25, unbanked }, { 80, -59, -46, 24, down25, unbanked },
    { 80, -60, -46, 24, down25, unbanked }, { 80, -61, -47, 24, down25, unbanked }, { 80, -62, -47, 24, down25, unbanked }, { 80, -63, -48, 24, down25, unbanked }, { 80, -64, -49, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D40BA, {
    {  16,  31,  15, 24, down25, unbanked }, {  16,  30,  15, 24, down25, unbanked }, {  16,  29,  14, 24, down25, unbanked }, {  16,  28,  14, 24, down25, unbanked }, {  16,  27,  13, 24, down25, unbanked },
    {  16,  26,  13, 24, down25, unbanked }, {  16,  25,  12, 24, down25, unbanked }, {  16,  24,  12, 25, down25, unbanked }, {  15,  23,  11, 25, down25, unbanked }, {  15,  22,  11, 25, down25, unbanked },
    {  15,  21,  10, 25, down25, unbanked }, {  15,  20,  10, 25, down25, unbanked }, {  15,  19,   9, 25, down25, unbanked }, {  15,  18,   9, 25, down25, unbanked }, {  14,  17,   8, 25, down25, unbanked },
    {  14,  16,   7, 25, down25, unbanked }, {  14,  15,   7, 25, down25, unbanked }, {  14,  14,   7, 25, down25, unbanked }, {  14,  13,   6, 25, down25, unbanked }, {  13,  12,   6, 25, down25, unbanked },
    {  13,  11,   5, 25, down25, unbanked }, {  13,  10,   4, 26, down25, unbanked }, {  13,   9,   4, 26, down25, unbanked }, {  12,   8,   3, 26, down25, unbanked }, {  12,   7,   3, 26, down25, unbanked },
    {  12,   6,   2, 26, down25, unbanked }, {  11,   5,   2, 26, down25, unbanked }, {  11,   4,   1, 26, down25, unbanked }, {  11,   3,   1, 26, down25, unbanked }, {  10,   2,   0, 26, down25, unbanked },
    {  10,   1,   0, 26, down25, unbanked }, {   9,   0,  -1, 26, down25, unbanked }, {   9,  -1,  -2, 26, down25, unbanked }, {   8,  -2,  -2, 26, down25, unbanked }, {   8,  -3,  -3, 26, down25, unbanked },
    {   7,  -4,  -3, 26, down25, unbanked }, {   7,  -5,  -4, 27, down25, unbanked }, {   6,  -6,  -4, 27, down25, unbanked }, {   6,  -7,  -5, 27, down25, unbanked }, {   5,  -8,  -6, 27, down25, unbanked },
    {   4,  -9,  -6, 27, down25, unbanked }, {   4, -10,  -7, 27, down25, unbanked }, {   3, -11,  -7, 27, down25, unbanked }, {   2, -12,  -8, 27, down25, unbanked }, {   2, -13,  -9, 27, down25, unbanked },
    {   1, -14,  -9, 27, down25, unbanked }, {   0, -15, -10, 27, down25, unbanked }, {   0, -16, -11, 27, down25, unbanked }, {  -1, -17, -11, 27, down25, unbanked }, {  -2, -18, -12, 28, down25, unbanked },
    {  -3, -19, -12, 28, down25, unbanked }, {  -3, -20, -13, 28, down25, unbanked }, {  -4, -21, -14, 28, down25, unbanked }, {  -5, -22, -14, 28, down25, unbanked }, {  -6, -23, -15, 28, down25, unbanked },
    {  -7, -24, -16, 28, down25, unbanked }, {  -7, -25, -16, 28, down25, unbanked }, {  -8, -26, -17, 28, down25, unbanked }, {  -9, -27, -17, 28, down25, unbanked }, { -10, -28, -18, 28, down25, unbanked },
    { -11, -29, -19, 28, down25, unbanked }, { -12, -29, -19, 28, down25, unbanked }, { -13, -30, -20, 29, down25, unbanked }, { -14, -31, -21, 29, down25, unbanked }, { -15, -32, -21, 29, down25, unbanked },
    { -16, -32, -22, 29, down25, unbanked }, { -17, -33, -22, 29, down25, unbanked }, { -18, -34, -23, 29, down25, unbanked }, { -19, -34, -24, 29, down25, unbanked }, { -20, -35, -24, 29, down25, unbanked },
    { -21, -36, -25, 29, down25, unbanked }, { -22, -36, -26, 29, down25, unbanked }, { -23, -37, -26, 29, down25, unbanked }, { -24, -38, -27, 29, down25, unbanked }, { -25, -38, -27, 29, down25, unbanked },
    { -26, -39, -28, 30, down25, unbanked }, { -27, -39, -29, 30, down25, unbanked }, { -28, -40, -29, 30, down25, unbanked }, { -29, -40, -30, 30, down25, unbanked }, { -30, -41, -30, 30, down25, unbanked },
    { -31, -41, -31, 30, down25, unbanked }, { -32, -42, -31, 30, down25, unbanked }, { -33, -42, -32, 30, down25, unbanked }, { -34, -43, -33, 30, down25, unbanked }, { -35, -43, -33, 30, down25, unbanked },
    { -36, -43, -34, 30, down25, unbanked }, { -37, -44, -34, 30, down25, unbanked }, { -38, -44, -35, 30, down25, unbanked }, { -39, -44, -35, 30, down25, unbanked }, { -40, -45, -36, 31, down25, unbanked },
    { -41, -45, -36, 31, down25, unbanked }, { -42, -45, -37, 31, down25, unbanked }, { -43, -45, -37, 31, down25, unbanked }, { -44, -46, -38, 31, down25, unbanked }, { -45, -46, -39, 31, down25, unbanked },
    { -46, -46, -39, 31, down25, unbanked }, { -47, -46, -40, 31, down25, unbanked }, { -48, -46, -40, 31, down25, unbanked }, { -49, -47, -40, 31, down25, unbanked }, { -50, -47, -41, 31, down25, unbanked },
    { -51, -47, -42, 31, down25, unbanked }, { -52, -47, -42, 31, down25, unbanked }, { -53, -47, -43, 31, down25, unbanked }, { -54, -47, -43, 31, down25, unbanked }, { -55, -48, -44, 31, down25, unbanked },
    { -56, -48, -44,  0, down25, unbanked }, { -57, -48, -45,  0, down25, unbanked }, { -58, -48, -45,  0, down25, unbanked }, { -59, -48, -46,  0, down25, unbanked }, { -60, -48, -46,  0, down25, unbanked },
    { -61, -48, -47,  0, down25, unbanked }, { -62, -48, -47,  0, down25, unbanked }, { -63, -48, -48,  0, down25, unbanked }, { -64, -48, -49,  0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CC0D2, {
    {  32,  16, 0,  0, flat, unbanked }, {  31,  16, 0,  0, flat, unbanked }, {  30,  16, 0,  0, flat, unbanked }, {  29,  16, 0,  0, flat, unbanked }, {  28,  16, 0,  0, flat, unbanked },
    {  27,  16, 0,  0, flat, unbanked }, {  26,  16, 0,  0, flat, unbanked }, {  25,  16, 0,  0, flat, unbanked }, {  24,  16, 0, 31, flat, unbanked }, {  23,  15, 0, 31, flat, unbanked },
    {  22,  15, 0, 31, flat, unbanked }, {  21,  15, 0, 31, flat, unbanked }, {  20,  15, 0, 31, flat, unbanked }, {  19,  15, 0, 31, flat, unbanked }, {  18,  15, 0, 31, flat, unbanked },
    {  17,  14, 0, 31, flat, unbanked }, {  16,  14, 0, 31, flat, unbanked }, {  15,  14, 0, 31, flat, unbanked }, {  14,  14, 0, 31, flat, unbanked }, {  13,  14, 0, 31, flat, unbanked },
    {  12,  13, 0, 31, flat, unbanked }, {  11,  13, 0, 31, flat, unbanked }, {  10,  13, 0, 30, flat, unbanked }, {   9,  13, 0, 30, flat, unbanked }, {   8,  12, 0, 30, flat, unbanked },
    {   7,  12, 0, 30, flat, unbanked }, {   6,  12, 0, 30, flat, unbanked }, {   5,  11, 0, 30, flat, unbanked }, {   4,  11, 0, 30, flat, unbanked }, {   3,  11, 0, 30, flat, unbanked },
    {   2,  10, 0, 30, flat, unbanked }, {   1,  10, 0, 30, flat, unbanked }, {   0,   9, 0, 30, flat, unbanked }, {  -1,   9, 0, 30, flat, unbanked }, {  -2,   8, 0, 30, flat, unbanked },
    {  -3,   8, 0, 30, flat, unbanked }, {  -4,   7, 0, 29, flat, unbanked }, {  -5,   7, 0, 29, flat, unbanked }, {  -6,   6, 0, 29, flat, unbanked }, {  -7,   6, 0, 29, flat, unbanked },
    {  -8,   5, 0, 29, flat, unbanked }, {  -9,   4, 0, 29, flat, unbanked }, { -10,   4, 0, 29, flat, unbanked }, { -11,   3, 0, 29, flat, unbanked }, { -12,   2, 0, 29, flat, unbanked },
    { -13,   2, 0, 29, flat, unbanked }, { -14,   1, 0, 29, flat, unbanked }, { -15,   0, 0, 29, flat, unbanked }, { -16,   0, 0, 29, flat, unbanked }, { -17,  -1, 0, 29, flat, unbanked },
    { -18,  -2, 0, 29, flat, unbanked }, { -19,  -2, 0, 29, flat, unbanked }, { -20,  -3, 0, 29, flat, unbanked }, { -21,  -4, 0, 29, flat, unbanked }, { -22,  -4, 0, 29, flat, unbanked },
    { -23,  -5, 0, 29, flat, unbanked }, { -24,  -6, 0, 29, flat, unbanked }, { -25,  -6, 0, 29, flat, unbanked }, { -26,  -7, 0, 29, flat, unbanked }, { -27,  -7, 0, 29, flat, unbanked },
    { -28,  -8, 0, 30, flat, unbanked }, { -29,  -8, 0, 30, flat, unbanked }, { -30,  -9, 0, 30, flat, unbanked }, { -31,  -9, 0, 30, flat, unbanked }, { -32, -10, 0, 30, flat, unbanked },
    { -33, -10, 0, 30, flat, unbanked }, { -34, -11, 0, 30, flat, unbanked }, { -35, -11, 0, 30, flat, unbanked }, { -36, -11, 0, 30, flat, unbanked }, { -37, -12, 0, 30, flat, unbanked },
    { -38, -12, 0, 30, flat, unbanked }, { -39, -12, 0, 30, flat, unbanked }, { -40, -13, 0, 30, flat, unbanked }, { -41, -13, 0, 31, flat, unbanked }, { -42, -13, 0, 31, flat, unbanked },
    { -43, -13, 0, 31, flat, unbanked }, { -44, -14, 0, 31, flat, unbanked }, { -45, -14, 0, 31, flat, unbanked }, { -46, -14, 0, 31, flat, unbanked }, { -47, -14, 0, 31, flat, unbanked },
    { -48, -14, 0, 31, flat, unbanked }, { -49, -15, 0, 31, flat, unbanked }, { -50, -15, 0, 31, flat, unbanked }, { -51, -15, 0, 31, flat, unbanked }, { -52, -15, 0, 31, flat, unbanked },
    { -53, -15, 0, 31, flat, unbanked }, { -54, -15, 0, 31, flat, unbanked }, { -55, -16, 0, 31, flat, unbanked }, { -56, -16, 0,  0, flat, unbanked }, { -57, -16, 0,  0, flat, unbanked },
    { -58, -16, 0,  0, flat, unbanked }, { -59, -16, 0,  0, flat, unbanked }, { -60, -16, 0,  0, flat, unbanked }, { -61, -16, 0,  0, flat, unbanked }, { -62, -16, 0,  0, flat, unbanked },
    { -63, -16, 0,  0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CC434, {
    {  16,  0, 0, 8, flat, unbanked }, {  16,  1, 0, 8, flat, unbanked }, {  16,  2, 0, 8, flat, unbanked }, {  16,  3, 0, 8, flat, unbanked }, {  16,  4, 0, 8, flat, unbanked }, {  16,  5, 0, 8, flat, unbanked },
    {  16,  6, 0, 8, flat, unbanked }, {  16,  7, 0, 8, flat, unbanked }, {  16,  8, 0, 7, flat, unbanked }, {  15,  9, 0, 7, flat, unbanked }, {  15, 10, 0, 7, flat, unbanked }, {  15, 11, 0, 7, flat, unbanked },
    {  15, 12, 0, 7, flat, unbanked }, {  15, 13, 0, 7, flat, unbanked }, {  15, 14, 0, 7, flat, unbanked }, {  14, 15, 0, 7, flat, unbanked }, {  14, 16, 0, 7, flat, unbanked }, {  14, 17, 0, 7, flat, unbanked },
    {  14, 18, 0, 7, flat, unbanked }, {  14, 19, 0, 7, flat, unbanked }, {  13, 20, 0, 7, flat, unbanked }, {  13, 21, 0, 7, flat, unbanked }, {  13, 22, 0, 6, flat, unbanked }, {  13, 23, 0, 6, flat, unbanked },
    {  12, 24, 0, 6, flat, unbanked }, {  12, 25, 0, 6, flat, unbanked }, {  12, 26, 0, 6, flat, unbanked }, {  11, 27, 0, 6, flat, unbanked }, {  11, 28, 0, 6, flat, unbanked }, {  11, 29, 0, 6, flat, unbanked },
    {  10, 30, 0, 6, flat, unbanked }, {  10, 31, 0, 6, flat, unbanked }, {   9, 32, 0, 6, flat, unbanked }, {   9, 33, 0, 6, flat, unbanked }, {   8, 34, 0, 6, flat, unbanked }, {   8, 35, 0, 6, flat, unbanked },
    {   7, 36, 0, 5, flat, unbanked }, {   7, 37, 0, 5, flat, unbanked }, {   6, 38, 0, 5, flat, unbanked }, {   6, 39, 0, 5, flat, unbanked }, {   5, 40, 0, 5, flat, unbanked }, {   4, 41, 0, 5, flat, unbanked },
    {   4, 42, 0, 5, flat, unbanked }, {   3, 43, 0, 5, flat, unbanked }, {   2, 44, 0, 5, flat, unbanked }, {   2, 45, 0, 5, flat, unbanked }, {   1, 46, 0, 5, flat, unbanked }, {   0, 47, 0, 5, flat, unbanked },
    {   0, 48, 0, 5, flat, unbanked }, {  -1, 49, 0, 5, flat, unbanked }, {  -2, 50, 0, 5, flat, unbanked }, {  -2, 51, 0, 5, flat, unbanked }, {  -3, 52, 0, 5, flat, unbanked }, {  -4, 53, 0, 5, flat, unbanked },
    {  -4, 54, 0, 5, flat, unbanked }, {  -5, 55, 0, 5, flat, unbanked }, {  -6, 56, 0, 5, flat, unbanked }, {  -6, 57, 0, 5, flat, unbanked }, {  -7, 58, 0, 5, flat, unbanked }, {  -7, 59, 0, 5, flat, unbanked },
    {  -8, 60, 0, 6, flat, unbanked }, {  -8, 61, 0, 6, flat, unbanked }, {  -9, 62, 0, 6, flat, unbanked }, {  -9, 63, 0, 6, flat, unbanked }, { -10, 64, 0, 6, flat, unbanked }, { -10, 65, 0, 6, flat, unbanked },
    { -11, 66, 0, 6, flat, unbanked }, { -11, 67, 0, 6, flat, unbanked }, { -11, 68, 0, 6, flat, unbanked }, { -12, 69, 0, 6, flat, unbanked }, { -12, 70, 0, 6, flat, unbanked }, { -12, 71, 0, 6, flat, unbanked },
    { -13, 72, 0, 6, flat, unbanked }, { -13, 73, 0, 7, flat, unbanked }, { -13, 74, 0, 7, flat, unbanked }, { -13, 75, 0, 7, flat, unbanked }, { -14, 76, 0, 7, flat, unbanked }, { -14, 77, 0, 7, flat, unbanked },
    { -14, 78, 0, 7, flat, unbanked }, { -14, 79, 0, 7, flat, unbanked }, { -14, 80, 0, 7, flat, unbanked }, { -15, 81, 0, 7, flat, unbanked }, { -15, 82, 0, 7, flat, unbanked }, { -15, 83, 0, 7, flat, unbanked },
    { -15, 84, 0, 7, flat, unbanked }, { -15, 85, 0, 7, flat, unbanked }, { -15, 86, 0, 7, flat, unbanked }, { -16, 87, 0, 7, flat, unbanked }, { -16, 88, 0, 8, flat, unbanked }, { -16, 89, 0, 8, flat, unbanked },
    { -16, 90, 0, 8, flat, unbanked }, { -16, 91, 0, 8, flat, unbanked }, { -16, 92, 0, 8, flat, unbanked }, { -16, 93, 0, 8, flat, unbanked }, { -16, 94, 0, 8, flat, unbanked }, { -16, 95, 0, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CC796, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 16, flat, unbanked }, {  4, 16, 0, 16, flat, unbanked }, {  5, 16, 0, 16, flat, unbanked },
    {  6, 16, 0, 16, flat, unbanked }, {  7, 16, 0, 16, flat, unbanked }, {  8, 16, 0, 15, flat, unbanked }, {  9, 17, 0, 15, flat, unbanked }, { 10, 17, 0, 15, flat, unbanked }, { 11, 17, 0, 15, flat, unbanked },
    { 12, 17, 0, 15, flat, unbanked }, { 13, 17, 0, 15, flat, unbanked }, { 14, 17, 0, 15, flat, unbanked }, { 15, 18, 0, 15, flat, unbanked }, { 16, 18, 0, 15, flat, unbanked }, { 17, 18, 0, 15, flat, unbanked },
    { 18, 18, 0, 15, flat, unbanked }, { 19, 18, 0, 15, flat, unbanked }, { 20, 19, 0, 15, flat, unbanked }, { 21, 19, 0, 15, flat, unbanked }, { 22, 19, 0, 14, flat, unbanked }, { 23, 19, 0, 14, flat, unbanked },
    { 24, 20, 0, 14, flat, unbanked }, { 25, 20, 0, 14, flat, unbanked }, { 26, 20, 0, 14, flat, unbanked }, { 27, 21, 0, 14, flat, unbanked }, { 28, 21, 0, 14, flat, unbanked }, { 29, 21, 0, 14, flat, unbanked },
    { 30, 22, 0, 14, flat, unbanked }, { 31, 22, 0, 14, flat, unbanked }, { 32, 23, 0, 14, flat, unbanked }, { 33, 23, 0, 14, flat, unbanked }, { 34, 24, 0, 14, flat, unbanked }, { 35, 24, 0, 14, flat, unbanked },
    { 36, 25, 0, 13, flat, unbanked }, { 37, 25, 0, 13, flat, unbanked }, { 38, 26, 0, 13, flat, unbanked }, { 39, 26, 0, 13, flat, unbanked }, { 40, 27, 0, 13, flat, unbanked }, { 41, 28, 0, 13, flat, unbanked },
    { 42, 28, 0, 13, flat, unbanked }, { 43, 29, 0, 13, flat, unbanked }, { 44, 30, 0, 13, flat, unbanked }, { 45, 30, 0, 13, flat, unbanked }, { 46, 31, 0, 13, flat, unbanked }, { 47, 32, 0, 13, flat, unbanked },
    { 48, 32, 0, 13, flat, unbanked }, { 49, 33, 0, 13, flat, unbanked }, { 50, 34, 0, 13, flat, unbanked }, { 51, 34, 0, 13, flat, unbanked }, { 52, 35, 0, 13, flat, unbanked }, { 53, 36, 0, 13, flat, unbanked },
    { 54, 36, 0, 13, flat, unbanked }, { 55, 37, 0, 13, flat, unbanked }, { 56, 38, 0, 13, flat, unbanked }, { 57, 38, 0, 13, flat, unbanked }, { 58, 39, 0, 13, flat, unbanked }, { 59, 39, 0, 13, flat, unbanked },
    { 60, 40, 0, 14, flat, unbanked }, { 61, 40, 0, 14, flat, unbanked }, { 62, 41, 0, 14, flat, unbanked }, { 63, 41, 0, 14, flat, unbanked }, { 64, 42, 0, 14, flat, unbanked }, { 65, 42, 0, 14, flat, unbanked },
    { 66, 43, 0, 14, flat, unbanked }, { 67, 43, 0, 14, flat, unbanked }, { 68, 43, 0, 14, flat, unbanked }, { 69, 44, 0, 14, flat, unbanked }, { 70, 44, 0, 14, flat, unbanked }, { 71, 44, 0, 14, flat, unbanked },
    { 72, 45, 0, 14, flat, unbanked }, { 73, 45, 0, 15, flat, unbanked }, { 74, 45, 0, 15, flat, unbanked }, { 75, 45, 0, 15, flat, unbanked }, { 76, 46, 0, 15, flat, unbanked }, { 77, 46, 0, 15, flat, unbanked },
    { 78, 46, 0, 15, flat, unbanked }, { 79, 46, 0, 15, flat, unbanked }, { 80, 46, 0, 15, flat, unbanked }, { 81, 47, 0, 15, flat, unbanked }, { 82, 47, 0, 15, flat, unbanked }, { 83, 47, 0, 15, flat, unbanked },
    { 84, 47, 0, 15, flat, unbanked }, { 85, 47, 0, 15, flat, unbanked }, { 86, 47, 0, 15, flat, unbanked }, { 87, 48, 0, 15, flat, unbanked }, { 88, 48, 0, 16, flat, unbanked }, { 89, 48, 0, 16, flat, unbanked },
    { 90, 48, 0, 16, flat, unbanked }, { 91, 48, 0, 16, flat, unbanked }, { 92, 48, 0, 16, flat, unbanked }, { 93, 48, 0, 16, flat, unbanked }, { 94, 48, 0, 16, flat, unbanked }, { 95, 48, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CCAF8, {
    { 16,  32, 0, 24, flat, unbanked }, { 16,  31, 0, 24, flat, unbanked }, { 16,  30, 0, 24, flat, unbanked }, { 16,  29, 0, 24, flat, unbanked }, { 16,  28, 0, 24, flat, unbanked },
    { 16,  27, 0, 24, flat, unbanked }, { 16,  26, 0, 24, flat, unbanked }, { 16,  25, 0, 24, flat, unbanked }, { 16,  24, 0, 23, flat, unbanked }, { 17,  23, 0, 23, flat, unbanked },
    { 17,  22, 0, 23, flat, unbanked }, { 17,  21, 0, 23, flat, unbanked }, { 17,  20, 0, 23, flat, unbanked }, { 17,  19, 0, 23, flat, unbanked }, { 17,  18, 0, 23, flat, unbanked },
    { 18,  17, 0, 23, flat, unbanked }, { 18,  16, 0, 23, flat, unbanked }, { 18,  15, 0, 23, flat, unbanked }, { 18,  14, 0, 23, flat, unbanked }, { 18,  13, 0, 23, flat, unbanked },
    { 19,  12, 0, 23, flat, unbanked }, { 19,  11, 0, 23, flat, unbanked }, { 19,  10, 0, 22, flat, unbanked }, { 19,   9, 0, 22, flat, unbanked }, { 20,   8, 0, 22, flat, unbanked },
    { 20,   7, 0, 22, flat, unbanked }, { 20,   6, 0, 22, flat, unbanked }, { 21,   5, 0, 22, flat, unbanked }, { 21,   4, 0, 22, flat, unbanked }, { 21,   3, 0, 22, flat, unbanked },
    { 22,   2, 0, 22, flat, unbanked }, { 22,   1, 0, 22, flat, unbanked }, { 23,   0, 0, 22, flat, unbanked }, { 23,  -1, 0, 22, flat, unbanked }, { 24,  -2, 0, 22, flat, unbanked },
    { 24,  -3, 0, 22, flat, unbanked }, { 25,  -4, 0, 21, flat, unbanked }, { 25,  -5, 0, 21, flat, unbanked }, { 26,  -6, 0, 21, flat, unbanked }, { 26,  -7, 0, 21, flat, unbanked },
    { 27,  -8, 0, 21, flat, unbanked }, { 28,  -9, 0, 21, flat, unbanked }, { 28, -10, 0, 21, flat, unbanked }, { 29, -11, 0, 21, flat, unbanked }, { 30, -12, 0, 21, flat, unbanked },
    { 30, -13, 0, 21, flat, unbanked }, { 31, -14, 0, 21, flat, unbanked }, { 32, -15, 0, 21, flat, unbanked }, { 32, -16, 0, 21, flat, unbanked }, { 33, -17, 0, 21, flat, unbanked },
    { 34, -18, 0, 21, flat, unbanked }, { 34, -19, 0, 21, flat, unbanked }, { 35, -20, 0, 21, flat, unbanked }, { 36, -21, 0, 21, flat, unbanked }, { 36, -22, 0, 21, flat, unbanked },
    { 37, -23, 0, 21, flat, unbanked }, { 38, -24, 0, 21, flat, unbanked }, { 38, -25, 0, 21, flat, unbanked }, { 39, -26, 0, 21, flat, unbanked }, { 39, -27, 0, 21, flat, unbanked },
    { 40, -28, 0, 22, flat, unbanked }, { 40, -29, 0, 22, flat, unbanked }, { 41, -30, 0, 22, flat, unbanked }, { 41, -31, 0, 22, flat, unbanked }, { 42, -32, 0, 22, flat, unbanked },
    { 42, -33, 0, 22, flat, unbanked }, { 43, -34, 0, 22, flat, unbanked }, { 43, -35, 0, 22, flat, unbanked }, { 43, -36, 0, 22, flat, unbanked }, { 44, -37, 0, 22, flat, unbanked },
    { 44, -38, 0, 22, flat, unbanked }, { 44, -39, 0, 22, flat, unbanked }, { 45, -40, 0, 22, flat, unbanked }, { 45, -41, 0, 23, flat, unbanked }, { 45, -42, 0, 23, flat, unbanked },
    { 45, -43, 0, 23, flat, unbanked }, { 46, -44, 0, 23, flat, unbanked }, { 46, -45, 0, 23, flat, unbanked }, { 46, -46, 0, 23, flat, unbanked }, { 46, -47, 0, 23, flat, unbanked },
    { 46, -48, 0, 23, flat, unbanked }, { 47, -49, 0, 23, flat, unbanked }, { 47, -50, 0, 23, flat, unbanked }, { 47, -51, 0, 23, flat, unbanked }, { 47, -52, 0, 23, flat, unbanked },
    { 47, -53, 0, 23, flat, unbanked }, { 47, -54, 0, 23, flat, unbanked }, { 48, -55, 0, 23, flat, unbanked }, { 48, -56, 0, 24, flat, unbanked }, { 48, -57, 0, 24, flat, unbanked },
    { 48, -58, 0, 24, flat, unbanked }, { 48, -59, 0, 24, flat, unbanked }, { 48, -60, 0, 24, flat, unbanked }, { 48, -61, 0, 24, flat, unbanked }, { 48, -62, 0, 24, flat, unbanked },
    { 48, -63, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CCE5A, {
    {  32, 16, 0, 0, flat, unbanked }, {  31, 16, 0, 0, flat, unbanked }, {  30, 16, 0, 0, flat, unbanked }, {  29, 16, 0, 0, flat, unbanked }, {  28, 16, 0, 0, flat, unbanked }, {  27, 16, 0, 0, flat, unbanked },
    {  26, 16, 0, 0, flat, unbanked }, {  25, 16, 0, 0, flat, unbanked }, {  24, 16, 0, 1, flat, unbanked }, {  23, 17, 0, 1, flat, unbanked }, {  22, 17, 0, 1, flat, unbanked }, {  21, 17, 0, 1, flat, unbanked },
    {  20, 17, 0, 1, flat, unbanked }, {  19, 17, 0, 1, flat, unbanked }, {  18, 17, 0, 1, flat, unbanked }, {  17, 18, 0, 1, flat, unbanked }, {  16, 18, 0, 1, flat, unbanked }, {  15, 18, 0, 1, flat, unbanked },
    {  14, 18, 0, 1, flat, unbanked }, {  13, 18, 0, 1, flat, unbanked }, {  12, 19, 0, 1, flat, unbanked }, {  11, 19, 0, 1, flat, unbanked }, {  10, 19, 0, 2, flat, unbanked }, {   9, 19, 0, 2, flat, unbanked },
    {   8, 20, 0, 2, flat, unbanked }, {   7, 20, 0, 2, flat, unbanked }, {   6, 20, 0, 2, flat, unbanked }, {   5, 21, 0, 2, flat, unbanked }, {   4, 21, 0, 2, flat, unbanked }, {   3, 21, 0, 2, flat, unbanked },
    {   2, 22, 0, 2, flat, unbanked }, {   1, 22, 0, 2, flat, unbanked }, {   0, 23, 0, 2, flat, unbanked }, {  -1, 23, 0, 2, flat, unbanked }, {  -2, 24, 0, 2, flat, unbanked }, {  -3, 24, 0, 2, flat, unbanked },
    {  -4, 25, 0, 3, flat, unbanked }, {  -5, 25, 0, 3, flat, unbanked }, {  -6, 26, 0, 3, flat, unbanked }, {  -7, 26, 0, 3, flat, unbanked }, {  -8, 27, 0, 3, flat, unbanked }, {  -9, 28, 0, 3, flat, unbanked },
    { -10, 28, 0, 3, flat, unbanked }, { -11, 29, 0, 3, flat, unbanked }, { -12, 30, 0, 3, flat, unbanked }, { -13, 30, 0, 3, flat, unbanked }, { -14, 31, 0, 3, flat, unbanked }, { -15, 32, 0, 3, flat, unbanked },
    { -16, 32, 0, 3, flat, unbanked }, { -17, 33, 0, 3, flat, unbanked }, { -18, 34, 0, 3, flat, unbanked }, { -19, 34, 0, 3, flat, unbanked }, { -20, 35, 0, 3, flat, unbanked }, { -21, 36, 0, 3, flat, unbanked },
    { -22, 36, 0, 3, flat, unbanked }, { -23, 37, 0, 3, flat, unbanked }, { -24, 38, 0, 3, flat, unbanked }, { -25, 38, 0, 3, flat, unbanked }, { -26, 39, 0, 3, flat, unbanked }, { -27, 39, 0, 3, flat, unbanked },
    { -28, 40, 0, 2, flat, unbanked }, { -29, 40, 0, 2, flat, unbanked }, { -30, 41, 0, 2, flat, unbanked }, { -31, 41, 0, 2, flat, unbanked }, { -32, 42, 0, 2, flat, unbanked }, { -33, 42, 0, 2, flat, unbanked },
    { -34, 43, 0, 2, flat, unbanked }, { -35, 43, 0, 2, flat, unbanked }, { -36, 43, 0, 2, flat, unbanked }, { -37, 44, 0, 2, flat, unbanked }, { -38, 44, 0, 2, flat, unbanked }, { -39, 44, 0, 2, flat, unbanked },
    { -40, 45, 0, 2, flat, unbanked }, { -41, 45, 0, 1, flat, unbanked }, { -42, 45, 0, 1, flat, unbanked }, { -43, 45, 0, 1, flat, unbanked }, { -44, 46, 0, 1, flat, unbanked }, { -45, 46, 0, 1, flat, unbanked },
    { -46, 46, 0, 1, flat, unbanked }, { -47, 46, 0, 1, flat, unbanked }, { -48, 46, 0, 1, flat, unbanked }, { -49, 47, 0, 1, flat, unbanked }, { -50, 47, 0, 1, flat, unbanked }, { -51, 47, 0, 1, flat, unbanked },
    { -52, 47, 0, 1, flat, unbanked }, { -53, 47, 0, 1, flat, unbanked }, { -54, 47, 0, 1, flat, unbanked }, { -55, 48, 0, 1, flat, unbanked }, { -56, 48, 0, 0, flat, unbanked }, { -57, 48, 0, 0, flat, unbanked },
    { -58, 48, 0, 0, flat, unbanked }, { -59, 48, 0, 0, flat, unbanked }, { -60, 48, 0, 0, flat, unbanked }, { -61, 48, 0, 0, flat, unbanked }, { -62, 48, 0, 0, flat, unbanked }, { -63, 48, 0, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CD1BC, {
    { 16,  0, 0,  8, flat, unbanked }, { 16,  1, 0,  8, flat, unbanked }, { 16,  2, 0,  8, flat, unbanked }, { 16,  3, 0,  8, flat, unbanked }, { 16,  4, 0,  8, flat, unbanked }, { 16,  5, 0,  8, flat, unbanked },
    { 16,  6, 0,  8, flat, unbanked }, { 16,  7, 0,  8, flat, unbanked }, { 16,  8, 0,  9, flat, unbanked }, { 17,  9, 0,  9, flat, unbanked }, { 17, 10, 0,  9, flat, unbanked }, { 17, 11, 0,  9, flat, unbanked },
    { 17, 12, 0,  9, flat, unbanked }, { 17, 13, 0,  9, flat, unbanked }, { 17, 14, 0,  9, flat, unbanked }, { 18, 15, 0,  9, flat, unbanked }, { 18, 16, 0,  9, flat, unbanked }, { 18, 17, 0,  9, flat, unbanked },
    { 18, 18, 0,  9, flat, unbanked }, { 18, 19, 0,  9, flat, unbanked }, { 19, 20, 0,  9, flat, unbanked }, { 19, 21, 0,  9, flat, unbanked }, { 19, 22, 0, 10, flat, unbanked }, { 19, 23, 0, 10, flat, unbanked },
    { 20, 24, 0, 10, flat, unbanked }, { 20, 25, 0, 10, flat, unbanked }, { 20, 26, 0, 10, flat, unbanked }, { 21, 27, 0, 10, flat, unbanked }, { 21, 28, 0, 10, flat, unbanked }, { 21, 29, 0, 10, flat, unbanked },
    { 22, 30, 0, 10, flat, unbanked }, { 22, 31, 0, 10, flat, unbanked }, { 23, 32, 0, 10, flat, unbanked }, { 23, 33, 0, 10, flat, unbanked }, { 24, 34, 0, 10, flat, unbanked }, { 24, 35, 0, 10, flat, unbanked },
    { 25, 36, 0, 11, flat, unbanked }, { 25, 37, 0, 11, flat, unbanked }, { 26, 38, 0, 11, flat, unbanked }, { 26, 39, 0, 11, flat, unbanked }, { 27, 40, 0, 11, flat, unbanked }, { 28, 41, 0, 11, flat, unbanked },
    { 28, 42, 0, 11, flat, unbanked }, { 29, 43, 0, 11, flat, unbanked }, { 30, 44, 0, 11, flat, unbanked }, { 30, 45, 0, 11, flat, unbanked }, { 31, 46, 0, 11, flat, unbanked }, { 32, 47, 0, 11, flat, unbanked },
    { 32, 48, 0, 11, flat, unbanked }, { 33, 49, 0, 11, flat, unbanked }, { 34, 50, 0, 11, flat, unbanked }, { 34, 51, 0, 11, flat, unbanked }, { 35, 52, 0, 11, flat, unbanked }, { 36, 53, 0, 11, flat, unbanked },
    { 36, 54, 0, 11, flat, unbanked }, { 37, 55, 0, 11, flat, unbanked }, { 38, 56, 0, 11, flat, unbanked }, { 38, 57, 0, 11, flat, unbanked }, { 39, 58, 0, 11, flat, unbanked }, { 39, 59, 0, 11, flat, unbanked },
    { 40, 60, 0, 10, flat, unbanked }, { 40, 61, 0, 10, flat, unbanked }, { 41, 62, 0, 10, flat, unbanked }, { 41, 63, 0, 10, flat, unbanked }, { 42, 64, 0, 10, flat, unbanked }, { 42, 65, 0, 10, flat, unbanked },
    { 43, 66, 0, 10, flat, unbanked }, { 43, 67, 0, 10, flat, unbanked }, { 43, 68, 0, 10, flat, unbanked }, { 44, 69, 0, 10, flat, unbanked }, { 44, 70, 0, 10, flat, unbanked }, { 44, 71, 0, 10, flat, unbanked },
    { 45, 72, 0, 10, flat, unbanked }, { 45, 73, 0,  9, flat, unbanked }, { 45, 74, 0,  9, flat, unbanked }, { 45, 75, 0,  9, flat, unbanked }, { 46, 76, 0,  9, flat, unbanked }, { 46, 77, 0,  9, flat, unbanked },
    { 46, 78, 0,  9, flat, unbanked }, { 46, 79, 0,  9, flat, unbanked }, { 46, 80, 0,  9, flat, unbanked }, { 47, 81, 0,  9, flat, unbanked }, { 47, 82, 0,  9, flat, unbanked }, { 47, 83, 0,  9, flat, unbanked },
    { 47, 84, 0,  9, flat, unbanked }, { 47, 85, 0,  9, flat, unbanked }, { 47, 86, 0,  9, flat, unbanked }, { 48, 87, 0,  9, flat, unbanked }, { 48, 88, 0,  8, flat, unbanked }, { 48, 89, 0,  8, flat, unbanked },
    { 48, 90, 0,  8, flat, unbanked }, { 48, 91, 0,  8, flat, unbanked }, { 48, 92, 0,  8, flat, unbanked }, { 48, 93, 0,  8, flat, unbanked }, { 48, 94, 0,  8, flat, unbanked }, { 48, 95, 0,  8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CD51E, {
    {  0,  16, 0, 16, flat, unbanked }, {  1,  16, 0, 16, flat, unbanked }, {  2,  16, 0, 16, flat, unbanked }, {  3,  16, 0, 16, flat, unbanked }, {  4,  16, 0, 16, flat, unbanked },
    {  5,  16, 0, 16, flat, unbanked }, {  6,  16, 0, 16, flat, unbanked }, {  7,  16, 0, 16, flat, unbanked }, {  8,  16, 0, 17, flat, unbanked }, {  9,  15, 0, 17, flat, unbanked },
    { 10,  15, 0, 17, flat, unbanked }, { 11,  15, 0, 17, flat, unbanked }, { 12,  15, 0, 17, flat, unbanked }, { 13,  15, 0, 17, flat, unbanked }, { 14,  15, 0, 17, flat, unbanked },
    { 15,  14, 0, 17, flat, unbanked }, { 16,  14, 0, 17, flat, unbanked }, { 17,  14, 0, 17, flat, unbanked }, { 18,  14, 0, 17, flat, unbanked }, { 19,  14, 0, 17, flat, unbanked },
    { 20,  13, 0, 17, flat, unbanked }, { 21,  13, 0, 17, flat, unbanked }, { 22,  13, 0, 18, flat, unbanked }, { 23,  13, 0, 18, flat, unbanked }, { 24,  12, 0, 18, flat, unbanked },
    { 25,  12, 0, 18, flat, unbanked }, { 26,  12, 0, 18, flat, unbanked }, { 27,  11, 0, 18, flat, unbanked }, { 28,  11, 0, 18, flat, unbanked }, { 29,  11, 0, 18, flat, unbanked },
    { 30,  10, 0, 18, flat, unbanked }, { 31,  10, 0, 18, flat, unbanked }, { 32,   9, 0, 18, flat, unbanked }, { 33,   9, 0, 18, flat, unbanked }, { 34,   8, 0, 18, flat, unbanked },
    { 35,   8, 0, 18, flat, unbanked }, { 36,   7, 0, 19, flat, unbanked }, { 37,   7, 0, 19, flat, unbanked }, { 38,   6, 0, 19, flat, unbanked }, { 39,   6, 0, 19, flat, unbanked },
    { 40,   5, 0, 19, flat, unbanked }, { 41,   4, 0, 19, flat, unbanked }, { 42,   4, 0, 19, flat, unbanked }, { 43,   3, 0, 19, flat, unbanked }, { 44,   2, 0, 19, flat, unbanked },
    { 45,   2, 0, 19, flat, unbanked }, { 46,   1, 0, 19, flat, unbanked }, { 47,   0, 0, 19, flat, unbanked }, { 48,   0, 0, 19, flat, unbanked }, { 49,  -1, 0, 19, flat, unbanked },
    { 50,  -2, 0, 19, flat, unbanked }, { 51,  -2, 0, 19, flat, unbanked }, { 52,  -3, 0, 19, flat, unbanked }, { 53,  -4, 0, 19, flat, unbanked }, { 54,  -4, 0, 19, flat, unbanked },
    { 55,  -5, 0, 19, flat, unbanked }, { 56,  -6, 0, 19, flat, unbanked }, { 57,  -6, 0, 19, flat, unbanked }, { 58,  -7, 0, 19, flat, unbanked }, { 59,  -7, 0, 19, flat, unbanked },
    { 60,  -8, 0, 18, flat, unbanked }, { 61,  -8, 0, 18, flat, unbanked }, { 62,  -9, 0, 18, flat, unbanked }, { 63,  -9, 0, 18, flat, unbanked }, { 64, -10, 0, 18, flat, unbanked },
    { 65, -10, 0, 18, flat, unbanked }, { 66, -11, 0, 18, flat, unbanked }, { 67, -11, 0, 18, flat, unbanked }, { 68, -11, 0, 18, flat, unbanked }, { 69, -12, 0, 18, flat, unbanked },
    { 70, -12, 0, 18, flat, unbanked }, { 71, -12, 0, 18, flat, unbanked }, { 72, -13, 0, 18, flat, unbanked }, { 73, -13, 0, 17, flat, unbanked }, { 74, -13, 0, 17, flat, unbanked },
    { 75, -13, 0, 17, flat, unbanked }, { 76, -14, 0, 17, flat, unbanked }, { 77, -14, 0, 17, flat, unbanked }, { 78, -14, 0, 17, flat, unbanked }, { 79, -14, 0, 17, flat, unbanked },
    { 80, -14, 0, 17, flat, unbanked }, { 81, -15, 0, 17, flat, unbanked }, { 82, -15, 0, 17, flat, unbanked }, { 83, -15, 0, 17, flat, unbanked }, { 84, -15, 0, 17, flat, unbanked },
    { 85, -15, 0, 17, flat, unbanked }, { 86, -15, 0, 17, flat, unbanked }, { 87, -16, 0, 17, flat, unbanked }, { 88, -16, 0, 16, flat, unbanked }, { 89, -16, 0, 16, flat, unbanked },
    { 90, -16, 0, 16, flat, unbanked }, { 91, -16, 0, 16, flat, unbanked }, { 92, -16, 0, 16, flat, unbanked }, { 93, -16, 0, 16, flat, unbanked }, { 94, -16, 0, 16, flat, unbanked },
    { 95, -16, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CD880, {
    {  16,  32, 0, 24, flat, unbanked }, {  16,  31, 0, 24, flat, unbanked }, {  16,  30, 0, 24, flat, unbanked }, {  16,  29, 0, 24, flat, unbanked }, {  16,  28, 0, 24, flat, unbanked },
    {  16,  27, 0, 24, flat, unbanked }, {  16,  26, 0, 24, flat, unbanked }, {  16,  25, 0, 24, flat, unbanked }, {  16,  24, 0, 25, flat, unbanked }, {  15,  23, 0, 25, flat, unbanked },
    {  15,  22, 0, 25, flat, unbanked }, {  15,  21, 0, 25, flat, unbanked }, {  15,  20, 0, 25, flat, unbanked }, {  15,  19, 0, 25, flat, unbanked }, {  15,  18, 0, 25, flat, unbanked },
    {  14,  17, 0, 25, flat, unbanked }, {  14,  16, 0, 25, flat, unbanked }, {  14,  15, 0, 25, flat, unbanked }, {  14,  14, 0, 25, flat, unbanked }, {  14,  13, 0, 25, flat, unbanked },
    {  13,  12, 0, 25, flat, unbanked }, {  13,  11, 0, 25, flat, unbanked }, {  13,  10, 0, 26, flat, unbanked }, {  13,   9, 0, 26, flat, unbanked }, {  12,   8, 0, 26, flat, unbanked },
    {  12,   7, 0, 26, flat, unbanked }, {  12,   6, 0, 26, flat, unbanked }, {  11,   5, 0, 26, flat, unbanked }, {  11,   4, 0, 26, flat, unbanked }, {  11,   3, 0, 26, flat, unbanked },
    {  10,   2, 0, 26, flat, unbanked }, {  10,   1, 0, 26, flat, unbanked }, {   9,   0, 0, 26, flat, unbanked }, {   9,  -1, 0, 26, flat, unbanked }, {   8,  -2, 0, 26, flat, unbanked },
    {   8,  -3, 0, 26, flat, unbanked }, {   7,  -4, 0, 27, flat, unbanked }, {   7,  -5, 0, 27, flat, unbanked }, {   6,  -6, 0, 27, flat, unbanked }, {   6,  -7, 0, 27, flat, unbanked },
    {   5,  -8, 0, 27, flat, unbanked }, {   4,  -9, 0, 27, flat, unbanked }, {   4, -10, 0, 27, flat, unbanked }, {   3, -11, 0, 27, flat, unbanked }, {   2, -12, 0, 27, flat, unbanked },
    {   2, -13, 0, 27, flat, unbanked }, {   1, -14, 0, 27, flat, unbanked }, {   0, -15, 0, 27, flat, unbanked }, {   0, -16, 0, 27, flat, unbanked }, {  -1, -17, 0, 27, flat, unbanked },
    {  -2, -18, 0, 27, flat, unbanked }, {  -2, -19, 0, 27, flat, unbanked }, {  -3, -20, 0, 27, flat, unbanked }, {  -4, -21, 0, 27, flat, unbanked }, {  -4, -22, 0, 27, flat, unbanked },
    {  -5, -23, 0, 27, flat, unbanked }, {  -6, -24, 0, 27, flat, unbanked }, {  -6, -25, 0, 27, flat, unbanked }, {  -7, -26, 0, 27, flat, unbanked }, {  -7, -27, 0, 27, flat, unbanked },
    {  -8, -28, 0, 26, flat, unbanked }, {  -8, -29, 0, 26, flat, unbanked }, {  -9, -30, 0, 26, flat, unbanked }, {  -9, -31, 0, 26, flat, unbanked }, { -10, -32, 0, 26, flat, unbanked },
    { -10, -33, 0, 26, flat, unbanked }, { -11, -34, 0, 26, flat, unbanked }, { -11, -35, 0, 26, flat, unbanked }, { -11, -36, 0, 26, flat, unbanked }, { -12, -37, 0, 26, flat, unbanked },
    { -12, -38, 0, 26, flat, unbanked }, { -12, -39, 0, 26, flat, unbanked }, { -13, -40, 0, 26, flat, unbanked }, { -13, -41, 0, 25, flat, unbanked }, { -13, -42, 0, 25, flat, unbanked },
    { -13, -43, 0, 25, flat, unbanked }, { -14, -44, 0, 25, flat, unbanked }, { -14, -45, 0, 25, flat, unbanked }, { -14, -46, 0, 25, flat, unbanked }, { -14, -47, 0, 25, flat, unbanked },
    { -14, -48, 0, 25, flat, unbanked }, { -15, -49, 0, 25, flat, unbanked }, { -15, -50, 0, 25, flat, unbanked }, { -15, -51, 0, 25, flat, unbanked }, { -15, -52, 0, 25, flat, unbanked },
    { -15, -53, 0, 25, flat, unbanked }, { -15, -54, 0, 25, flat, unbanked }, { -16, -55, 0, 25, flat, unbanked }, { -16, -56, 0, 24, flat, unbanked }, { -16, -57, 0, 24, flat, unbanked },
    { -16, -58, 0, 24, flat, unbanked }, { -16, -59, 0, 24, flat, unbanked }, { -16, -60, 0, 24, flat, unbanked }, { -16, -61, 0, 24, flat, unbanked }, { -16, -62, 0, 24, flat, unbanked },
    { -16, -63, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D44BE, {
    {  31,  16,   0, 0,     up25, unbanked }, {  30,  15,   0, 0,     up25, unbanked }, {  29,  15,   1, 0,     up25, unbanked }, {  28,  15,   1, 0,     up25, unbanked }, {  27,  15,   2, 0,     up25, unbanked },
    {  26,  15,   2, 0,     up25, unbanked }, {  25,  15,   3, 0,     up25, unbanked }, {  24,  15,   3, 0,     up25, unbanked }, {  23,  15,   3, 0,     up25, unbanked }, {  22,  15,   4, 0,     up25, unbanked },
    {  21,  14,   4, 0,     up25, unbanked }, {  20,  14,   5, 0,     up25, unbanked }, {  19,  14,   5, 0,     up25, unbanked }, {  18,  14,   6, 0,     up25, unbanked }, {  17,  14,   6, 0,     up25, unbanked },
    {  16,  14,   7, 0,     up25, unbanked }, {  15,  14,   7, 0,     up25, unbanked }, {  14,  14,   8, 0,     up25, unbanked }, {  13,  14,   8, 0,     up25, unbanked }, {  12,  14,   9, 0,     up42, unbanked },
    {  11,  13,   9, 0,     up42, unbanked }, {  10,  13,  10, 0,     up42, unbanked }, {   9,  13,  10, 0,     up42, unbanked }, {   8,  13,  11, 0,     up42, unbanked }, {   7,  13,  11, 0,     up42, unbanked },
    {   6,  13,  12, 0,     up42, unbanked }, {   5,  13,  13, 0,     up42, unbanked }, {   4,  13,  14, 0,     up42, unbanked }, {   3,  13,  15, 0,     up42, unbanked }, {   2,  12,  15, 0,     up42, unbanked },
    {   1,  12,  16, 0,     up42, unbanked }, {   0,  12,  17, 0,     up42, unbanked }, {  -1,  12,  18, 0,     up42, unbanked }, {  -2,  12,  18, 0,     up42, unbanked }, {  -3,  12,  19, 0,     up42, unbanked },
    {  -4,  12,  20, 0,     up42, unbanked }, {  -5,  12,  21, 0,     up42, unbanked }, {  -6,  11,  22, 0,     up42, unbanked }, {  -7,  11,  23, 0,     up42, unbanked }, {  -8,  11,  24, 0,     up42, unbanked },
    {  -9,  11,  25, 0,     up42, unbanked }, { -10,  11,  26, 0,     up42, unbanked }, { -11,  11,  27, 0,     up60, unbanked }, { -12,  11,  28, 0,     up60, unbanked }, { -13,  11,  29, 0,     up60, unbanked },
    { -13,  11,  30, 0,     up60, unbanked }, { -14,  10,  31, 0,     up60, unbanked }, { -15,  10,  32, 0,     up60, unbanked }, { -16,  10,  33, 0,     up60, unbanked }, { -16,  10,  34, 0,     up60, unbanked },
    { -17,  10,  35, 0,     up60, unbanked }, { -18,  10,  36, 0,     up60, unbanked }, { -19,  10,  37, 0,     up60, unbanked }, { -19,  10,  38, 0,     up60, unbanked }, { -20,  10,  39, 0,     up60, unbanked },
    { -20,   9,  40, 0,     up60, unbanked }, { -21,   9,  41, 0,     up60, unbanked }, { -22,   9,  42, 0,     up60, unbanked }, { -22,   9,  43, 0,     up75, unbanked }, { -23,   9,  44, 0,     up75, unbanked },
    { -24,   9,  45, 0,     up75, unbanked }, { -24,   9,  46, 0,     up75, unbanked }, { -25,   9,  47, 0,     up75, unbanked }, { -25,   9,  48, 0,     up75, unbanked }, { -25,   8,  49, 0,     up75, unbanked },
    { -26,   8,  50, 0,     up75, unbanked }, { -26,   8,  51, 0,     up75, unbanked }, { -26,   8,  52, 0,     up75, unbanked }, { -27,   8,  53, 0,     up75, unbanked }, { -27,   8,  54, 0,     up75, unbanked },
    { -27,   8,  55, 0,     up75, unbanked }, { -28,   8,  56, 0,     up75, unbanked }, { -28,   8,  57, 0,     up75, unbanked }, { -28,   8,  58, 0,     up75, unbanked }, { -29,   7,  59, 0,     up75, unbanked },
    { -29,   7,  60, 0,     up75, unbanked }, { -29,   7,  61, 0,     up75, unbanked }, { -30,   7,  62, 0,     up75, unbanked }, { -30,   7,  63, 0,     up75, unbanked }, { -30,   7,  64, 0,     up90, unbanked },
    { -30,   7,  65, 0,     up90, unbanked }, { -31,   7,  66, 0,     up90, unbanked }, { -31,   7,  67, 0,     up90, unbanked }, { -31,   7,  68, 0,     up90, unbanked }, { -31,   6,  69, 0,     up90, unbanked },
    { -31,   6,  70, 0,     up90, unbanked }, { -32,   6,  71, 0,     up90, unbanked }, { -32,   6,  72, 0,     up90, unbanked }, { -32,   6,  73, 0,     up90, unbanked }, { -32,   6,  74, 0,     up90, unbanked },
    { -32,   6,  75, 0,     up90, unbanked }, { -32,   6,  76, 0,     up90, unbanked }, { -32,   6,  77, 0,     up90, unbanked }, { -32,   6,  78, 0,     up90, unbanked }, { -32,   6,  79, 0,     up90, unbanked },
    { -32,   5,  80, 0,     up90, unbanked }, { -32,   5,  81, 0,     up90, unbanked }, { -32,   5,  82, 0,     up90, unbanked }, { -32,   5,  83, 0,     up90, unbanked }, { -32,   5,  84, 0,     up90, unbanked },
    { -32,   5,  85, 0,     up90, unbanked }, { -32,   5,  86, 0,     up90, unbanked }, { -32,   5,  87, 0,     up90, unbanked }, { -32,   5,  88, 0,     up90, unbanked }, { -32,   5,  89, 0,     up90, unbanked },
    { -32,   5,  90, 0,     up90, unbanked }, { -32,   5,  91, 0,    up105, unbanked }, { -32,   4,  92, 0,    up105, unbanked }, { -31,   4,  93, 0,    up105, unbanked }, { -31,   4,  94, 0,    up105, unbanked },
    { -31,   4,  95, 0,    up105, unbanked }, { -31,   4,  96, 0,    up105, unbanked }, { -31,   4,  97, 0,    up105, unbanked }, { -30,   4,  98, 0,    up105, unbanked }, { -30,   4,  99, 0,    up105, unbanked },
    { -30,   4, 100, 0,    up105, unbanked }, { -30,   4, 101, 0,    up105, unbanked }, { -29,   3, 102, 0,    up105, unbanked }, { -29,   3, 103, 0,    up105, unbanked }, { -29,   3, 104, 0,    up105, unbanked },
    { -28,   3, 105, 0,    up120, unbanked }, { -28,   3, 106, 0,    up120, unbanked }, { -27,   3, 107, 0,    up120, unbanked }, { -27,   3, 108, 0,    up120, unbanked }, { -26,   3, 109, 0,    up120, unbanked },
    { -26,   3, 110, 0,    up120, unbanked }, { -26,   3, 111, 0,    up120, unbanked }, { -25,   2, 112, 0,    up120, unbanked }, { -25,   2, 113, 0,    up120, unbanked }, { -24,   2, 114, 0,    up135, unbanked },
    { -24,   2, 115, 0,    up135, unbanked }, { -23,   2, 116, 0,    up135, unbanked }, { -22,   2, 117, 0,    up135, unbanked }, { -22,   2, 118, 0,    up135, unbanked }, { -21,   2, 119, 0,    up135, unbanked },
    { -20,   2, 120, 0,    up135, unbanked }, { -19,   1, 121, 0,    up135, unbanked }, { -18,   1, 122, 0,    up150, unbanked }, { -17,   1, 123, 0,    up150, unbanked }, { -16,   1, 124, 0,    up150, unbanked },
    { -15,   1, 124, 0,    up150, unbanked }, { -14,   1, 125, 0,    up150, unbanked }, { -13,   1, 126, 0,    up165, unbanked }, { -12,   1, 127, 0,    up165, unbanked }, { -11,   0, 128, 0,    up165, unbanked },
    { -10,   0, 128, 0,    up165, unbanked }, {  -9,   0, 129, 0,    up165, unbanked }, {  -8,   0, 129, 0, inverted, unbanked }, {  -7,   0, 129, 0, inverted, unbanked }, {  -6,   0, 130, 0, inverted, unbanked },
    {  -5,   0, 130, 0, inverted, unbanked }, {  -4,   0, 130, 0, inverted, unbanked }, {  -3,   0, 130, 0, inverted, unbanked }, {  -2,   0, 130, 0, inverted, unbanked }, {  -1,   0, 130, 0, inverted, unbanked },
    {   0,   0, 130, 0, inverted, unbanked }, {   1,   0, 130, 0, inverted, unbanked }, {   2,   0, 130, 0, inverted, unbanked }, {   3,   0, 130, 0, inverted, unbanked }, {   4,   0, 130, 0,  down165, unbanked },
    {   5,   0, 130, 0,  down165, unbanked }, {   6,   0, 129, 0,  down165, unbanked }, {   7,   0, 129, 0,  down165, unbanked }, {   8,   0, 129, 0,  down165, unbanked }, {   9,   0, 128, 0,  down150, unbanked },
    {  10,   0, 128, 0,  down150, unbanked }, {  11,  -1, 127, 0,  down150, unbanked }, {  12,  -1, 126, 0,  down150, unbanked }, {  13,  -1, 125, 0,  down150, unbanked }, {  14,  -1, 124, 0,  down135, unbanked },
    {  15,  -1, 124, 0,  down135, unbanked }, {  16,  -1, 123, 0,  down135, unbanked }, {  17,  -1, 122, 0,  down135, unbanked }, {  18,  -1, 121, 0,  down135, unbanked }, {  19,  -2, 120, 0,  down135, unbanked },
    {  20,  -2, 119, 0,  down135, unbanked }, {  21,  -2, 118, 0,  down135, unbanked }, {  21,  -2, 117, 0,  down120, unbanked }, {  22,  -2, 116, 0,  down120, unbanked }, {  23,  -2, 115, 0,  down120, unbanked },
    {  23,  -2, 114, 0,  down120, unbanked }, {  24,  -2, 113, 0,  down120, unbanked }, {  24,  -2, 112, 0,  down120, unbanked }, {  25,  -3, 111, 0,  down120, unbanked }, {  25,  -3, 110, 0,  down120, unbanked },
    {  25,  -3, 109, 0,  down120, unbanked }, {  26,  -3, 108, 0,  down105, unbanked }, {  26,  -3, 107, 0,  down105, unbanked }, {  27,  -3, 106, 0,  down105, unbanked }, {  27,  -3, 105, 0,  down105, unbanked },
    {  28,  -3, 104, 0,  down105, unbanked }, {  28,  -3, 103, 0,  down105, unbanked }, {  28,  -3, 102, 0,  down105, unbanked }, {  29,  -4, 101, 0,  down105, unbanked }, {  29,  -4, 100, 0,  down105, unbanked },
    {  29,  -4,  99, 0,  down105, unbanked }, {  29,  -4,  98, 0,  down105, unbanked }, {  30,  -4,  97, 0,  down105, unbanked }, {  30,  -4,  96, 0,  down105, unbanked }, {  30,  -4,  95, 0,  down105, unbanked },
    {  30,  -4,  94, 0,   down90, unbanked }, {  30,  -4,  93, 0,   down90, unbanked }, {  31,  -4,  92, 0,   down90, unbanked }, {  31,  -5,  91, 0,   down90, unbanked }, {  31,  -5,  90, 0,   down90, unbanked },
    {  31,  -5,  89, 0,   down90, unbanked }, {  31,  -5,  88, 0,   down90, unbanked }, {  31,  -5,  87, 0,   down90, unbanked }, {  31,  -5,  86, 0,   down90, unbanked }, {  31,  -5,  85, 0,   down90, unbanked },
    {  31,  -5,  84, 0,   down90, unbanked }, {  31,  -5,  83, 0,   down90, unbanked }, {  31,  -5,  82, 0,   down90, unbanked }, {  31,  -5,  81, 0,   down90, unbanked }, {  31,  -5,  80, 0,   down90, unbanked },
    {  31,  -6,  79, 0,   down90, unbanked }, {  31,  -6,  78, 0,   down90, unbanked }, {  31,  -6,  77, 0,   down90, unbanked }, {  31,  -6,  76, 0,   down90, unbanked }, {  31,  -6,  75, 0,   down90, unbanked },
    {  31,  -6,  74, 0,   down90, unbanked }, {  31,  -6,  73, 0,   down90, unbanked }, {  31,  -6,  72, 0,   down90, unbanked }, {  31,  -6,  71, 0,   down90, unbanked }, {  30,  -6,  70, 0,   down90, unbanked },
    {  30,  -6,  69, 0,   down90, unbanked }, {  30,  -7,  68, 0,   down90, unbanked }, {  30,  -7,  67, 0,   down75, unbanked }, {  30,  -7,  66, 0,   down75, unbanked }, {  29,  -7,  65, 0,   down75, unbanked },
    {  29,  -7,  64, 0,   down75, unbanked }, {  29,  -7,  63, 0,   down75, unbanked }, {  29,  -7,  62, 0,   down75, unbanked }, {  28,  -7,  61, 0,   down75, unbanked }, {  28,  -7,  60, 0,   down75, unbanked },
    {  28,  -7,  59, 0,   down75, unbanked }, {  27,  -8,  58, 0,   down75, unbanked }, {  27,  -8,  57, 0,   down75, unbanked }, {  27,  -8,  56, 0,   down75, unbanked }, {  26,  -8,  55, 0,   down75, unbanked },
    {  26,  -8,  54, 0,   down75, unbanked }, {  26,  -8,  53, 0,   down75, unbanked }, {  25,  -8,  52, 0,   down75, unbanked }, {  25,  -8,  51, 0,   down75, unbanked }, {  25,  -8,  50, 0,   down75, unbanked },
    {  24,  -8,  49, 0,   down75, unbanked }, {  24,  -9,  48, 0,   down75, unbanked }, {  24,  -9,  47, 0,   down75, unbanked }, {  23,  -9,  46, 0,   down60, unbanked }, {  23,  -9,  45, 0,   down60, unbanked },
    {  22,  -9,  44, 0,   down60, unbanked }, {  21,  -9,  43, 0,   down60, unbanked }, {  21,  -9,  42, 0,   down60, unbanked }, {  20,  -9,  41, 0,   down60, unbanked }, {  19,  -9,  40, 0,   down60, unbanked },
    {  19,  -9,  39, 0,   down60, unbanked }, {  18, -10,  38, 0,   down60, unbanked }, {  18, -10,  37, 0,   down60, unbanked }, {  17, -10,  36, 0,   down60, unbanked }, {  16, -10,  35, 0,   down60, unbanked },
    {  15, -10,  34, 0,   down60, unbanked }, {  15, -10,  33, 0,   down60, unbanked }, {  14, -10,  32, 0,   down60, unbanked }, {  13, -10,  31, 0,   down60, unbanked }, {  12, -11,  30, 0,   down42, unbanked },
    {  12, -11,  29, 0,   down42, unbanked }, {  11, -11,  28, 0,   down42, unbanked }, {  10, -11,  27, 0,   down42, unbanked }, {   9, -11,  26, 0,   down42, unbanked }, {   8, -11,  25, 0,   down42, unbanked },
    {   7, -11,  24, 0,   down42, unbanked }, {   6, -11,  23, 0,   down42, unbanked }, {   5, -11,  22, 0,   down42, unbanked }, {   4, -12,  21, 0,   down42, unbanked }, {   3, -12,  20, 0,   down42, unbanked },
    {   2, -12,  19, 0,   down42, unbanked }, {   1, -12,  18, 0,   down42, unbanked }, {   0, -12,  18, 0,   down42, unbanked }, {  -1, -12,  17, 0,   down42, unbanked }, {  -2, -12,  16, 0,   down42, unbanked },
    {  -3, -12,  15, 0,   down42, unbanked }, {  -4, -13,  15, 0,   down42, unbanked }, {  -5, -13,  14, 0,   down42, unbanked }, {  -6, -13,  13, 0,   down42, unbanked }, {  -7, -13,  12, 0,   down42, unbanked },
    {  -8, -13,  11, 0,   down42, unbanked }, {  -9, -13,  11, 0,   down42, unbanked }, { -10, -13,  10, 0,   down25, unbanked }, { -11, -13,  10, 0,   down25, unbanked }, { -12, -13,   9, 0,   down25, unbanked },
    { -13, -14,   9, 0,   down25, unbanked }, { -14, -14,   8, 0,   down25, unbanked }, { -15, -14,   8, 0,   down25, unbanked }, { -16, -14,   7, 0,   down25, unbanked }, { -17, -14,   7, 0,   down25, unbanked },
    { -18, -14,   6, 0,   down25, unbanked }, { -19, -14,   6, 0,   down25, unbanked }, { -20, -14,   5, 0,   down25, unbanked }, { -21, -14,   5, 0,   down25, unbanked }, { -22, -14,   4, 0,   down25, unbanked },
    { -23, -15,   4, 0,   down25, unbanked }, { -24, -15,   3, 0,   down25, unbanked }, { -25, -15,   3, 0,   down25, unbanked }, { -26, -15,   3, 0,   down25, unbanked }, { -27, -15,   2, 0,   down25, unbanked },
    { -28, -15,   2, 0,   down25, unbanked }, { -29, -15,   1, 0,   down25, unbanked }, { -30, -15,   1, 0,   down25, unbanked }, { -31, -15,   0, 0,   down25, unbanked }, { -32, -16,   0, 0,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D4FA6, {
    {  16,  0,   0, 8,     up25, unbanked }, {  15,  1,   0, 8,     up25, unbanked }, {  15,  2,   1, 8,     up25, unbanked }, {  15,  3,   1, 8,     up25, unbanked }, {  15,  4,   2, 8,     up25, unbanked },
    {  15,  5,   2, 8,     up25, unbanked }, {  15,  6,   3, 8,     up25, unbanked }, {  15,  7,   3, 8,     up25, unbanked }, {  15,  8,   3, 8,     up25, unbanked }, {  15,  9,   4, 8,     up25, unbanked },
    {  14, 10,   4, 8,     up25, unbanked }, {  14, 11,   5, 8,     up25, unbanked }, {  14, 12,   5, 8,     up25, unbanked }, {  14, 13,   6, 8,     up25, unbanked }, {  14, 14,   6, 8,     up25, unbanked },
    {  14, 15,   7, 8,     up25, unbanked }, {  14, 16,   7, 8,     up25, unbanked }, {  14, 17,   8, 8,     up25, unbanked }, {  14, 18,   8, 8,     up25, unbanked }, {  14, 19,   9, 8,     up42, unbanked },
    {  13, 20,   9, 8,     up42, unbanked }, {  13, 21,  10, 8,     up42, unbanked }, {  13, 22,  10, 8,     up42, unbanked }, {  13, 23,  11, 8,     up42, unbanked }, {  13, 24,  11, 8,     up42, unbanked },
    {  13, 25,  12, 8,     up42, unbanked }, {  13, 26,  13, 8,     up42, unbanked }, {  13, 27,  14, 8,     up42, unbanked }, {  13, 28,  15, 8,     up42, unbanked }, {  12, 29,  15, 8,     up42, unbanked },
    {  12, 30,  16, 8,     up42, unbanked }, {  12, 31,  17, 8,     up42, unbanked }, {  12, 32,  18, 8,     up42, unbanked }, {  12, 33,  18, 8,     up42, unbanked }, {  12, 34,  19, 8,     up42, unbanked },
    {  12, 35,  20, 8,     up42, unbanked }, {  12, 36,  21, 8,     up42, unbanked }, {  11, 37,  22, 8,     up42, unbanked }, {  11, 38,  23, 8,     up42, unbanked }, {  11, 39,  24, 8,     up42, unbanked },
    {  11, 40,  25, 8,     up42, unbanked }, {  11, 41,  26, 8,     up42, unbanked }, {  11, 42,  27, 8,     up60, unbanked }, {  11, 43,  28, 8,     up60, unbanked }, {  11, 44,  29, 8,     up60, unbanked },
    {  11, 44,  30, 8,     up60, unbanked }, {  10, 45,  31, 8,     up60, unbanked }, {  10, 46,  32, 8,     up60, unbanked }, {  10, 47,  33, 8,     up60, unbanked }, {  10, 47,  34, 8,     up60, unbanked },
    {  10, 48,  35, 8,     up60, unbanked }, {  10, 49,  36, 8,     up60, unbanked }, {  10, 50,  37, 8,     up60, unbanked }, {  10, 50,  38, 8,     up60, unbanked }, {  10, 51,  39, 8,     up60, unbanked },
    {   9, 51,  40, 8,     up60, unbanked }, {   9, 52,  41, 8,     up60, unbanked }, {   9, 53,  42, 8,     up60, unbanked }, {   9, 53,  43, 8,     up75, unbanked }, {   9, 54,  44, 8,     up75, unbanked },
    {   9, 55,  45, 8,     up75, unbanked }, {   9, 55,  46, 8,     up75, unbanked }, {   9, 56,  47, 8,     up75, unbanked }, {   9, 56,  48, 8,     up75, unbanked }, {   8, 56,  49, 8,     up75, unbanked },
    {   8, 57,  50, 8,     up75, unbanked }, {   8, 57,  51, 8,     up75, unbanked }, {   8, 57,  52, 8,     up75, unbanked }, {   8, 58,  53, 8,     up75, unbanked }, {   8, 58,  54, 8,     up75, unbanked },
    {   8, 58,  55, 8,     up75, unbanked }, {   8, 59,  56, 8,     up75, unbanked }, {   8, 59,  57, 8,     up75, unbanked }, {   8, 59,  58, 8,     up75, unbanked }, {   7, 60,  59, 8,     up75, unbanked },
    {   7, 60,  60, 8,     up75, unbanked }, {   7, 60,  61, 8,     up75, unbanked }, {   7, 61,  62, 8,     up75, unbanked }, {   7, 61,  63, 8,     up75, unbanked }, {   7, 61,  64, 8,     up90, unbanked },
    {   7, 61,  65, 8,     up90, unbanked }, {   7, 62,  66, 8,     up90, unbanked }, {   7, 62,  67, 8,     up90, unbanked }, {   7, 62,  68, 8,     up90, unbanked }, {   6, 62,  69, 8,     up90, unbanked },
    {   6, 62,  70, 8,     up90, unbanked }, {   6, 63,  71, 8,     up90, unbanked }, {   6, 63,  72, 8,     up90, unbanked }, {   6, 63,  73, 8,     up90, unbanked }, {   6, 63,  74, 8,     up90, unbanked },
    {   6, 63,  75, 8,     up90, unbanked }, {   6, 63,  76, 8,     up90, unbanked }, {   6, 63,  77, 8,     up90, unbanked }, {   6, 63,  78, 8,     up90, unbanked }, {   6, 63,  79, 8,     up90, unbanked },
    {   5, 63,  80, 8,     up90, unbanked }, {   5, 63,  81, 8,     up90, unbanked }, {   5, 63,  82, 8,     up90, unbanked }, {   5, 63,  83, 8,     up90, unbanked }, {   5, 63,  84, 8,     up90, unbanked },
    {   5, 63,  85, 8,     up90, unbanked }, {   5, 63,  86, 8,     up90, unbanked }, {   5, 63,  87, 8,     up90, unbanked }, {   5, 63,  88, 8,     up90, unbanked }, {   5, 63,  89, 8,     up90, unbanked },
    {   5, 63,  90, 8,     up90, unbanked }, {   5, 63,  91, 8,    up105, unbanked }, {   4, 63,  92, 8,    up105, unbanked }, {   4, 62,  93, 8,    up105, unbanked }, {   4, 62,  94, 8,    up105, unbanked },
    {   4, 62,  95, 8,    up105, unbanked }, {   4, 62,  96, 8,    up105, unbanked }, {   4, 62,  97, 8,    up105, unbanked }, {   4, 61,  98, 8,    up105, unbanked }, {   4, 61,  99, 8,    up105, unbanked },
    {   4, 61, 100, 8,    up105, unbanked }, {   4, 61, 101, 8,    up105, unbanked }, {   3, 60, 102, 8,    up105, unbanked }, {   3, 60, 103, 8,    up105, unbanked }, {   3, 60, 104, 8,    up105, unbanked },
    {   3, 59, 105, 8,    up120, unbanked }, {   3, 59, 106, 8,    up120, unbanked }, {   3, 58, 107, 8,    up120, unbanked }, {   3, 58, 108, 8,    up120, unbanked }, {   3, 57, 109, 8,    up120, unbanked },
    {   3, 57, 110, 8,    up120, unbanked }, {   3, 57, 111, 8,    up120, unbanked }, {   2, 56, 112, 8,    up120, unbanked }, {   2, 56, 113, 8,    up120, unbanked }, {   2, 55, 114, 8,    up135, unbanked },
    {   2, 55, 115, 8,    up135, unbanked }, {   2, 54, 116, 8,    up135, unbanked }, {   2, 53, 117, 8,    up135, unbanked }, {   2, 53, 118, 8,    up135, unbanked }, {   2, 52, 119, 8,    up135, unbanked },
    {   2, 51, 120, 8,    up135, unbanked }, {   1, 50, 121, 8,    up135, unbanked }, {   1, 49, 122, 8,    up150, unbanked }, {   1, 48, 123, 8,    up150, unbanked }, {   1, 47, 124, 8,    up150, unbanked },
    {   1, 46, 124, 8,    up150, unbanked }, {   1, 45, 125, 8,    up150, unbanked }, {   1, 44, 126, 8,    up165, unbanked }, {   1, 43, 127, 8,    up165, unbanked }, {   0, 42, 128, 8,    up165, unbanked },
    {   0, 41, 128, 8,    up165, unbanked }, {   0, 40, 129, 8,    up165, unbanked }, {   0, 39, 129, 8, inverted, unbanked }, {   0, 38, 129, 8, inverted, unbanked }, {   0, 37, 130, 8, inverted, unbanked },
    {   0, 36, 130, 8, inverted, unbanked }, {   0, 35, 130, 8, inverted, unbanked }, {   0, 34, 130, 8, inverted, unbanked }, {   0, 33, 130, 8, inverted, unbanked }, {   0, 32, 130, 8, inverted, unbanked },
    {   0, 31, 130, 8, inverted, unbanked }, {   0, 30, 130, 8, inverted, unbanked }, {   0, 29, 130, 8, inverted, unbanked }, {   0, 28, 130, 8, inverted, unbanked }, {   0, 27, 130, 8,  down165, unbanked },
    {   0, 26, 130, 8,  down165, unbanked }, {   0, 25, 129, 8,  down165, unbanked }, {   0, 24, 129, 8,  down165, unbanked }, {   0, 23, 129, 8,  down165, unbanked }, {   0, 22, 128, 8,  down150, unbanked },
    {   0, 21, 128, 8,  down150, unbanked }, {  -1, 20, 127, 8,  down150, unbanked }, {  -1, 19, 126, 8,  down150, unbanked }, {  -1, 18, 125, 8,  down150, unbanked }, {  -1, 17, 124, 8,  down135, unbanked },
    {  -1, 16, 124, 8,  down135, unbanked }, {  -1, 15, 123, 8,  down135, unbanked }, {  -1, 14, 122, 8,  down135, unbanked }, {  -1, 13, 121, 8,  down135, unbanked }, {  -2, 12, 120, 8,  down135, unbanked },
    {  -2, 11, 119, 8,  down135, unbanked }, {  -2, 10, 118, 8,  down135, unbanked }, {  -2, 10, 117, 8,  down120, unbanked }, {  -2,  9, 116, 8,  down120, unbanked }, {  -2,  8, 115, 8,  down120, unbanked },
    {  -2,  8, 114, 8,  down120, unbanked }, {  -2,  7, 113, 8,  down120, unbanked }, {  -2,  7, 112, 8,  down120, unbanked }, {  -3,  6, 111, 8,  down120, unbanked }, {  -3,  6, 110, 8,  down120, unbanked },
    {  -3,  6, 109, 8,  down120, unbanked }, {  -3,  5, 108, 8,  down105, unbanked }, {  -3,  5, 107, 8,  down105, unbanked }, {  -3,  4, 106, 8,  down105, unbanked }, {  -3,  4, 105, 8,  down105, unbanked },
    {  -3,  3, 104, 8,  down105, unbanked }, {  -3,  3, 103, 8,  down105, unbanked }, {  -3,  3, 102, 8,  down105, unbanked }, {  -4,  2, 101, 8,  down105, unbanked }, {  -4,  2, 100, 8,  down105, unbanked },
    {  -4,  2,  99, 8,  down105, unbanked }, {  -4,  2,  98, 8,  down105, unbanked }, {  -4,  1,  97, 8,  down105, unbanked }, {  -4,  1,  96, 8,  down105, unbanked }, {  -4,  1,  95, 8,  down105, unbanked },
    {  -4,  1,  94, 8,   down90, unbanked }, {  -4,  1,  93, 8,   down90, unbanked }, {  -4,  0,  92, 8,   down90, unbanked }, {  -5,  0,  91, 8,   down90, unbanked }, {  -5,  0,  90, 8,   down90, unbanked },
    {  -5,  0,  89, 8,   down90, unbanked }, {  -5,  0,  88, 8,   down90, unbanked }, {  -5,  0,  87, 8,   down90, unbanked }, {  -5,  0,  86, 8,   down90, unbanked }, {  -5,  0,  85, 8,   down90, unbanked },
    {  -5,  0,  84, 8,   down90, unbanked }, {  -5,  0,  83, 8,   down90, unbanked }, {  -5,  0,  82, 8,   down90, unbanked }, {  -5,  0,  81, 8,   down90, unbanked }, {  -5,  0,  80, 8,   down90, unbanked },
    {  -6,  0,  79, 8,   down90, unbanked }, {  -6,  0,  78, 8,   down90, unbanked }, {  -6,  0,  77, 8,   down90, unbanked }, {  -6,  0,  76, 8,   down90, unbanked }, {  -6,  0,  75, 8,   down90, unbanked },
    {  -6,  0,  74, 8,   down90, unbanked }, {  -6,  0,  73, 8,   down90, unbanked }, {  -6,  0,  72, 8,   down90, unbanked }, {  -6,  0,  71, 8,   down90, unbanked }, {  -6,  1,  70, 8,   down90, unbanked },
    {  -6,  1,  69, 8,   down90, unbanked }, {  -7,  1,  68, 8,   down90, unbanked }, {  -7,  1,  67, 8,   down75, unbanked }, {  -7,  1,  66, 8,   down75, unbanked }, {  -7,  2,  65, 8,   down75, unbanked },
    {  -7,  2,  64, 8,   down75, unbanked }, {  -7,  2,  63, 8,   down75, unbanked }, {  -7,  2,  62, 8,   down75, unbanked }, {  -7,  3,  61, 8,   down75, unbanked }, {  -7,  3,  60, 8,   down75, unbanked },
    {  -7,  3,  59, 8,   down75, unbanked }, {  -8,  4,  58, 8,   down75, unbanked }, {  -8,  4,  57, 8,   down75, unbanked }, {  -8,  4,  56, 8,   down75, unbanked }, {  -8,  5,  55, 8,   down75, unbanked },
    {  -8,  5,  54, 8,   down75, unbanked }, {  -8,  5,  53, 8,   down75, unbanked }, {  -8,  6,  52, 8,   down75, unbanked }, {  -8,  6,  51, 8,   down75, unbanked }, {  -8,  6,  50, 8,   down75, unbanked },
    {  -8,  7,  49, 8,   down75, unbanked }, {  -9,  7,  48, 8,   down75, unbanked }, {  -9,  7,  47, 8,   down75, unbanked }, {  -9,  8,  46, 8,   down60, unbanked }, {  -9,  8,  45, 8,   down60, unbanked },
    {  -9,  9,  44, 8,   down60, unbanked }, {  -9, 10,  43, 8,   down60, unbanked }, {  -9, 10,  42, 8,   down60, unbanked }, {  -9, 11,  41, 8,   down60, unbanked }, {  -9, 12,  40, 8,   down60, unbanked },
    {  -9, 12,  39, 8,   down60, unbanked }, { -10, 13,  38, 8,   down60, unbanked }, { -10, 13,  37, 8,   down60, unbanked }, { -10, 14,  36, 8,   down60, unbanked }, { -10, 15,  35, 8,   down60, unbanked },
    { -10, 16,  34, 8,   down60, unbanked }, { -10, 16,  33, 8,   down60, unbanked }, { -10, 17,  32, 8,   down60, unbanked }, { -10, 18,  31, 8,   down60, unbanked }, { -11, 19,  30, 8,   down42, unbanked },
    { -11, 19,  29, 8,   down42, unbanked }, { -11, 20,  28, 8,   down42, unbanked }, { -11, 21,  27, 8,   down42, unbanked }, { -11, 22,  26, 8,   down42, unbanked }, { -11, 23,  25, 8,   down42, unbanked },
    { -11, 24,  24, 8,   down42, unbanked }, { -11, 25,  23, 8,   down42, unbanked }, { -11, 26,  22, 8,   down42, unbanked }, { -12, 27,  21, 8,   down42, unbanked }, { -12, 28,  20, 8,   down42, unbanked },
    { -12, 29,  19, 8,   down42, unbanked }, { -12, 30,  18, 8,   down42, unbanked }, { -12, 31,  18, 8,   down42, unbanked }, { -12, 32,  17, 8,   down42, unbanked }, { -12, 33,  16, 8,   down42, unbanked },
    { -12, 34,  15, 8,   down42, unbanked }, { -13, 35,  15, 8,   down42, unbanked }, { -13, 36,  14, 8,   down42, unbanked }, { -13, 37,  13, 8,   down42, unbanked }, { -13, 38,  12, 8,   down42, unbanked },
    { -13, 39,  11, 8,   down42, unbanked }, { -13, 40,  11, 8,   down42, unbanked }, { -13, 41,  10, 8,   down25, unbanked }, { -13, 42,  10, 8,   down25, unbanked }, { -13, 43,   9, 8,   down25, unbanked },
    { -14, 44,   9, 8,   down25, unbanked }, { -14, 45,   8, 8,   down25, unbanked }, { -14, 46,   8, 8,   down25, unbanked }, { -14, 47,   7, 8,   down25, unbanked }, { -14, 48,   7, 8,   down25, unbanked },
    { -14, 49,   6, 8,   down25, unbanked }, { -14, 50,   6, 8,   down25, unbanked }, { -14, 51,   5, 8,   down25, unbanked }, { -14, 52,   5, 8,   down25, unbanked }, { -14, 53,   4, 8,   down25, unbanked },
    { -15, 54,   4, 8,   down25, unbanked }, { -15, 55,   3, 8,   down25, unbanked }, { -15, 56,   3, 8,   down25, unbanked }, { -15, 57,   3, 8,   down25, unbanked }, { -15, 58,   2, 8,   down25, unbanked },
    { -15, 59,   2, 8,   down25, unbanked }, { -15, 60,   1, 8,   down25, unbanked }, { -15, 61,   1, 8,   down25, unbanked }, { -15, 62,   0, 8,   down25, unbanked }, { -16, 63,   0, 8,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D5A8E, {
    {  0, 16,   0, 16,     up25, unbanked }, {  1, 16,   0, 16,     up25, unbanked }, {  2, 16,   1, 16,     up25, unbanked }, {  3, 16,   1, 16,     up25, unbanked }, {  4, 16,   2, 16,     up25, unbanked },
    {  5, 16,   2, 16,     up25, unbanked }, {  6, 16,   3, 16,     up25, unbanked }, {  7, 16,   3, 16,     up25, unbanked }, {  8, 16,   3, 16,     up25, unbanked }, {  9, 16,   4, 16,     up25, unbanked },
    { 10, 17,   4, 16,     up25, unbanked }, { 11, 17,   5, 16,     up25, unbanked }, { 12, 17,   5, 16,     up25, unbanked }, { 13, 17,   6, 16,     up25, unbanked }, { 14, 17,   6, 16,     up25, unbanked },
    { 15, 17,   7, 16,     up25, unbanked }, { 16, 17,   7, 16,     up25, unbanked }, { 17, 17,   8, 16,     up25, unbanked }, { 18, 17,   8, 16,     up25, unbanked }, { 19, 17,   9, 16,     up42, unbanked },
    { 20, 18,   9, 16,     up42, unbanked }, { 21, 18,  10, 16,     up42, unbanked }, { 22, 18,  10, 16,     up42, unbanked }, { 23, 18,  11, 16,     up42, unbanked }, { 24, 18,  11, 16,     up42, unbanked },
    { 25, 18,  12, 16,     up42, unbanked }, { 26, 18,  13, 16,     up42, unbanked }, { 27, 18,  14, 16,     up42, unbanked }, { 28, 18,  15, 16,     up42, unbanked }, { 29, 19,  15, 16,     up42, unbanked },
    { 30, 19,  16, 16,     up42, unbanked }, { 31, 19,  17, 16,     up42, unbanked }, { 32, 19,  18, 16,     up42, unbanked }, { 33, 19,  18, 16,     up42, unbanked }, { 34, 19,  19, 16,     up42, unbanked },
    { 35, 19,  20, 16,     up42, unbanked }, { 36, 19,  21, 16,     up42, unbanked }, { 37, 20,  22, 16,     up42, unbanked }, { 38, 20,  23, 16,     up42, unbanked }, { 39, 20,  24, 16,     up42, unbanked },
    { 40, 20,  25, 16,     up42, unbanked }, { 41, 20,  26, 16,     up42, unbanked }, { 42, 20,  27, 16,     up60, unbanked }, { 43, 20,  28, 16,     up60, unbanked }, { 44, 20,  29, 16,     up60, unbanked },
    { 44, 20,  30, 16,     up60, unbanked }, { 45, 21,  31, 16,     up60, unbanked }, { 46, 21,  32, 16,     up60, unbanked }, { 47, 21,  33, 16,     up60, unbanked }, { 47, 21,  34, 16,     up60, unbanked },
    { 48, 21,  35, 16,     up60, unbanked }, { 49, 21,  36, 16,     up60, unbanked }, { 50, 21,  37, 16,     up60, unbanked }, { 50, 21,  38, 16,     up60, unbanked }, { 51, 22,  39, 16,     up60, unbanked },
    { 51, 22,  40, 16,     up60, unbanked }, { 52, 22,  41, 16,     up60, unbanked }, { 53, 22,  42, 16,     up60, unbanked }, { 53, 22,  43, 16,     up75, unbanked }, { 54, 22,  44, 16,     up75, unbanked },
    { 55, 22,  45, 16,     up75, unbanked }, { 55, 22,  46, 16,     up75, unbanked }, { 56, 22,  47, 16,     up75, unbanked }, { 56, 22,  48, 16,     up75, unbanked }, { 56, 23,  49, 16,     up75, unbanked },
    { 57, 23,  50, 16,     up75, unbanked }, { 57, 23,  51, 16,     up75, unbanked }, { 57, 23,  52, 16,     up75, unbanked }, { 58, 23,  53, 16,     up75, unbanked }, { 58, 23,  54, 16,     up75, unbanked },
    { 58, 23,  55, 16,     up75, unbanked }, { 59, 23,  56, 16,     up75, unbanked }, { 59, 23,  57, 16,     up75, unbanked }, { 59, 23,  58, 16,     up75, unbanked }, { 60, 24,  59, 16,     up75, unbanked },
    { 60, 24,  60, 16,     up75, unbanked }, { 60, 24,  61, 16,     up75, unbanked }, { 61, 24,  62, 16,     up75, unbanked }, { 61, 24,  63, 16,     up75, unbanked }, { 61, 24,  64, 16,     up90, unbanked },
    { 61, 24,  65, 16,     up90, unbanked }, { 62, 24,  66, 16,     up90, unbanked }, { 62, 24,  67, 16,     up90, unbanked }, { 62, 24,  68, 16,     up90, unbanked }, { 62, 25,  69, 16,     up90, unbanked },
    { 62, 25,  70, 16,     up90, unbanked }, { 63, 25,  71, 16,     up90, unbanked }, { 63, 25,  72, 16,     up90, unbanked }, { 63, 25,  73, 16,     up90, unbanked }, { 63, 25,  74, 16,     up90, unbanked },
    { 63, 25,  75, 16,     up90, unbanked }, { 63, 25,  76, 16,     up90, unbanked }, { 63, 25,  77, 16,     up90, unbanked }, { 63, 25,  78, 16,     up90, unbanked }, { 63, 25,  79, 16,     up90, unbanked },
    { 63, 26,  80, 16,     up90, unbanked }, { 63, 26,  81, 16,     up90, unbanked }, { 63, 26,  82, 16,     up90, unbanked }, { 63, 26,  83, 16,     up90, unbanked }, { 63, 26,  84, 16,     up90, unbanked },
    { 63, 26,  85, 16,     up90, unbanked }, { 63, 26,  86, 16,     up90, unbanked }, { 63, 26,  87, 16,     up90, unbanked }, { 63, 26,  88, 16,     up90, unbanked }, { 63, 26,  89, 16,     up90, unbanked },
    { 63, 26,  90, 16,     up90, unbanked }, { 63, 26,  91, 16,    up105, unbanked }, { 63, 27,  92, 16,    up105, unbanked }, { 62, 27,  93, 16,    up105, unbanked }, { 62, 27,  94, 16,    up105, unbanked },
    { 62, 27,  95, 16,    up105, unbanked }, { 62, 27,  96, 16,    up105, unbanked }, { 62, 27,  97, 16,    up105, unbanked }, { 61, 27,  98, 16,    up105, unbanked }, { 61, 27,  99, 16,    up105, unbanked },
    { 61, 27, 100, 16,    up105, unbanked }, { 61, 27, 101, 16,    up105, unbanked }, { 60, 28, 102, 16,    up105, unbanked }, { 60, 28, 103, 16,    up105, unbanked }, { 60, 28, 104, 16,    up105, unbanked },
    { 59, 28, 105, 16,    up120, unbanked }, { 59, 28, 106, 16,    up120, unbanked }, { 58, 28, 107, 16,    up120, unbanked }, { 58, 28, 108, 16,    up120, unbanked }, { 57, 28, 109, 16,    up120, unbanked },
    { 57, 28, 110, 16,    up120, unbanked }, { 57, 28, 111, 16,    up120, unbanked }, { 56, 29, 112, 16,    up120, unbanked }, { 56, 29, 113, 16,    up120, unbanked }, { 55, 29, 114, 16,    up135, unbanked },
    { 55, 29, 115, 16,    up135, unbanked }, { 54, 29, 116, 16,    up135, unbanked }, { 53, 29, 117, 16,    up135, unbanked }, { 53, 29, 118, 16,    up135, unbanked }, { 52, 29, 119, 16,    up135, unbanked },
    { 51, 29, 120, 16,    up135, unbanked }, { 50, 30, 121, 16,    up135, unbanked }, { 49, 30, 122, 16,    up150, unbanked }, { 48, 30, 123, 16,    up150, unbanked }, { 47, 30, 124, 16,    up150, unbanked },
    { 46, 30, 124, 16,    up150, unbanked }, { 45, 30, 125, 16,    up150, unbanked }, { 44, 30, 126, 16,    up165, unbanked }, { 43, 30, 127, 16,    up165, unbanked }, { 42, 31, 128, 16,    up165, unbanked },
    { 41, 31, 128, 16,    up165, unbanked }, { 40, 31, 129, 16,    up165, unbanked }, { 39, 31, 129, 16, inverted, unbanked }, { 38, 31, 129, 16, inverted, unbanked }, { 37, 31, 130, 16, inverted, unbanked },
    { 36, 31, 130, 16, inverted, unbanked }, { 35, 31, 130, 16, inverted, unbanked }, { 34, 31, 130, 16, inverted, unbanked }, { 33, 31, 130, 16, inverted, unbanked }, { 32, 31, 130, 16, inverted, unbanked },
    { 31, 32, 130, 16, inverted, unbanked }, { 30, 32, 130, 16, inverted, unbanked }, { 29, 32, 130, 16, inverted, unbanked }, { 28, 32, 130, 16, inverted, unbanked }, { 27, 32, 130, 16,  down165, unbanked },
    { 26, 32, 130, 16,  down165, unbanked }, { 25, 32, 129, 16,  down165, unbanked }, { 24, 32, 129, 16,  down165, unbanked }, { 23, 32, 129, 16,  down165, unbanked }, { 22, 32, 128, 16,  down150, unbanked },
    { 21, 32, 128, 16,  down150, unbanked }, { 20, 33, 127, 16,  down150, unbanked }, { 19, 33, 126, 16,  down150, unbanked }, { 18, 33, 125, 16,  down150, unbanked }, { 17, 33, 124, 16,  down135, unbanked },
    { 16, 33, 124, 16,  down135, unbanked }, { 15, 33, 123, 16,  down135, unbanked }, { 14, 33, 122, 16,  down135, unbanked }, { 13, 33, 121, 16,  down135, unbanked }, { 12, 34, 120, 16,  down135, unbanked },
    { 11, 34, 119, 16,  down135, unbanked }, { 10, 34, 118, 16,  down135, unbanked }, { 10, 34, 117, 16,  down120, unbanked }, {  9, 34, 116, 16,  down120, unbanked }, {  8, 34, 115, 16,  down120, unbanked },
    {  8, 34, 114, 16,  down120, unbanked }, {  7, 34, 113, 16,  down120, unbanked }, {  7, 34, 112, 16,  down120, unbanked }, {  6, 35, 111, 16,  down120, unbanked }, {  6, 35, 110, 16,  down120, unbanked },
    {  6, 35, 109, 16,  down120, unbanked }, {  5, 35, 108, 16,  down105, unbanked }, {  5, 35, 107, 16,  down105, unbanked }, {  4, 35, 106, 16,  down105, unbanked }, {  4, 35, 105, 16,  down105, unbanked },
    {  3, 35, 104, 16,  down105, unbanked }, {  3, 35, 103, 16,  down105, unbanked }, {  3, 35, 102, 16,  down105, unbanked }, {  2, 36, 101, 16,  down105, unbanked }, {  2, 36, 100, 16,  down105, unbanked },
    {  2, 36,  99, 16,  down105, unbanked }, {  2, 36,  98, 16,  down105, unbanked }, {  1, 36,  97, 16,  down105, unbanked }, {  1, 36,  96, 16,  down105, unbanked }, {  1, 36,  95, 16,  down105, unbanked },
    {  1, 36,  94, 16,   down90, unbanked }, {  1, 36,  93, 16,   down90, unbanked }, {  0, 36,  92, 16,   down90, unbanked }, {  0, 37,  91, 16,   down90, unbanked }, {  0, 37,  90, 16,   down90, unbanked },
    {  0, 37,  89, 16,   down90, unbanked }, {  0, 37,  88, 16,   down90, unbanked }, {  0, 37,  87, 16,   down90, unbanked }, {  0, 37,  86, 16,   down90, unbanked }, {  0, 37,  85, 16,   down90, unbanked },
    {  0, 37,  84, 16,   down90, unbanked }, {  0, 37,  83, 16,   down90, unbanked }, {  0, 37,  82, 16,   down90, unbanked }, {  0, 37,  81, 16,   down90, unbanked }, {  0, 37,  80, 16,   down90, unbanked },
    {  0, 38,  79, 16,   down90, unbanked }, {  0, 38,  78, 16,   down90, unbanked }, {  0, 38,  77, 16,   down90, unbanked }, {  0, 38,  76, 16,   down90, unbanked }, {  0, 38,  75, 16,   down90, unbanked },
    {  0, 38,  74, 16,   down90, unbanked }, {  0, 38,  73, 16,   down90, unbanked }, {  0, 38,  72, 16,   down90, unbanked }, {  0, 38,  71, 16,   down90, unbanked }, {  1, 38,  70, 16,   down90, unbanked },
    {  1, 38,  69, 16,   down90, unbanked }, {  1, 39,  68, 16,   down90, unbanked }, {  1, 39,  67, 16,   down75, unbanked }, {  1, 39,  66, 16,   down75, unbanked }, {  2, 39,  65, 16,   down75, unbanked },
    {  2, 39,  64, 16,   down75, unbanked }, {  2, 39,  63, 16,   down75, unbanked }, {  2, 39,  62, 16,   down75, unbanked }, {  3, 39,  61, 16,   down75, unbanked }, {  3, 39,  60, 16,   down75, unbanked },
    {  3, 39,  59, 16,   down75, unbanked }, {  4, 40,  58, 16,   down75, unbanked }, {  4, 40,  57, 16,   down75, unbanked }, {  4, 40,  56, 16,   down75, unbanked }, {  5, 40,  55, 16,   down75, unbanked },
    {  5, 40,  54, 16,   down75, unbanked }, {  5, 40,  53, 16,   down75, unbanked }, {  6, 40,  52, 16,   down75, unbanked }, {  6, 40,  51, 16,   down75, unbanked }, {  6, 40,  50, 16,   down75, unbanked },
    {  7, 40,  49, 16,   down75, unbanked }, {  7, 41,  48, 16,   down75, unbanked }, {  7, 41,  47, 16,   down75, unbanked }, {  8, 41,  46, 16,   down60, unbanked }, {  8, 41,  45, 16,   down60, unbanked },
    {  9, 41,  44, 16,   down60, unbanked }, { 10, 41,  43, 16,   down60, unbanked }, { 10, 41,  42, 16,   down60, unbanked }, { 11, 41,  41, 16,   down60, unbanked }, { 12, 41,  40, 16,   down60, unbanked },
    { 12, 41,  39, 16,   down60, unbanked }, { 13, 42,  38, 16,   down60, unbanked }, { 13, 42,  37, 16,   down60, unbanked }, { 14, 42,  36, 16,   down60, unbanked }, { 15, 42,  35, 16,   down60, unbanked },
    { 16, 42,  34, 16,   down60, unbanked }, { 16, 42,  33, 16,   down60, unbanked }, { 17, 42,  32, 16,   down60, unbanked }, { 18, 42,  31, 16,   down60, unbanked }, { 19, 43,  30, 16,   down42, unbanked },
    { 19, 43,  29, 16,   down42, unbanked }, { 20, 43,  28, 16,   down42, unbanked }, { 21, 43,  27, 16,   down42, unbanked }, { 22, 43,  26, 16,   down42, unbanked }, { 23, 43,  25, 16,   down42, unbanked },
    { 24, 43,  24, 16,   down42, unbanked }, { 25, 43,  23, 16,   down42, unbanked }, { 26, 43,  22, 16,   down42, unbanked }, { 27, 44,  21, 16,   down42, unbanked }, { 28, 44,  20, 16,   down42, unbanked },
    { 29, 44,  19, 16,   down42, unbanked }, { 30, 44,  18, 16,   down42, unbanked }, { 31, 44,  18, 16,   down42, unbanked }, { 32, 44,  17, 16,   down42, unbanked }, { 33, 44,  16, 16,   down42, unbanked },
    { 34, 44,  15, 16,   down42, unbanked }, { 35, 45,  15, 16,   down42, unbanked }, { 36, 45,  14, 16,   down42, unbanked }, { 37, 45,  13, 16,   down42, unbanked }, { 38, 45,  12, 16,   down42, unbanked },
    { 39, 45,  11, 16,   down42, unbanked }, { 40, 45,  11, 16,   down42, unbanked }, { 41, 45,  10, 16,   down25, unbanked }, { 42, 45,  10, 16,   down25, unbanked }, { 43, 45,   9, 16,   down25, unbanked },
    { 44, 46,   9, 16,   down25, unbanked }, { 45, 46,   8, 16,   down25, unbanked }, { 46, 46,   8, 16,   down25, unbanked }, { 47, 46,   7, 16,   down25, unbanked }, { 48, 46,   7, 16,   down25, unbanked },
    { 49, 46,   6, 16,   down25, unbanked }, { 50, 46,   6, 16,   down25, unbanked }, { 51, 46,   5, 16,   down25, unbanked }, { 52, 46,   5, 16,   down25, unbanked }, { 53, 46,   4, 16,   down25, unbanked },
    { 54, 47,   4, 16,   down25, unbanked }, { 55, 47,   3, 16,   down25, unbanked }, { 56, 47,   3, 16,   down25, unbanked }, { 57, 47,   3, 16,   down25, unbanked }, { 58, 47,   2, 16,   down25, unbanked },
    { 59, 47,   2, 16,   down25, unbanked }, { 60, 47,   1, 16,   down25, unbanked }, { 61, 47,   1, 16,   down25, unbanked }, { 62, 47,   0, 16,   down25, unbanked }, { 63, 48,   0, 16,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D6576, {
    { 16,  31,   0, 24,     up25, unbanked }, { 16,  30,   0, 24,     up25, unbanked }, { 16,  29,   1, 24,     up25, unbanked }, { 16,  28,   1, 24,     up25, unbanked }, { 16,  27,   2, 24,     up25, unbanked },
    { 16,  26,   2, 24,     up25, unbanked }, { 16,  25,   3, 24,     up25, unbanked }, { 16,  24,   3, 24,     up25, unbanked }, { 16,  23,   3, 24,     up25, unbanked }, { 16,  22,   4, 24,     up25, unbanked },
    { 17,  21,   4, 24,     up25, unbanked }, { 17,  20,   5, 24,     up25, unbanked }, { 17,  19,   5, 24,     up25, unbanked }, { 17,  18,   6, 24,     up25, unbanked }, { 17,  17,   6, 24,     up25, unbanked },
    { 17,  16,   7, 24,     up25, unbanked }, { 17,  15,   7, 24,     up25, unbanked }, { 17,  14,   8, 24,     up25, unbanked }, { 17,  13,   8, 24,     up25, unbanked }, { 17,  12,   9, 24,     up42, unbanked },
    { 18,  11,   9, 24,     up42, unbanked }, { 18,  10,  10, 24,     up42, unbanked }, { 18,   9,  10, 24,     up42, unbanked }, { 18,   8,  11, 24,     up42, unbanked }, { 18,   7,  11, 24,     up42, unbanked },
    { 18,   6,  12, 24,     up42, unbanked }, { 18,   5,  13, 24,     up42, unbanked }, { 18,   4,  14, 24,     up42, unbanked }, { 18,   3,  15, 24,     up42, unbanked }, { 19,   2,  15, 24,     up42, unbanked },
    { 19,   1,  16, 24,     up42, unbanked }, { 19,   0,  17, 24,     up42, unbanked }, { 19,  -1,  18, 24,     up42, unbanked }, { 19,  -2,  18, 24,     up42, unbanked }, { 19,  -3,  19, 24,     up42, unbanked },
    { 19,  -4,  20, 24,     up42, unbanked }, { 19,  -5,  21, 24,     up42, unbanked }, { 20,  -6,  22, 24,     up42, unbanked }, { 20,  -7,  23, 24,     up42, unbanked }, { 20,  -8,  24, 24,     up42, unbanked },
    { 20,  -9,  25, 24,     up42, unbanked }, { 20, -10,  26, 24,     up42, unbanked }, { 20, -11,  27, 24,     up60, unbanked }, { 20, -12,  28, 24,     up60, unbanked }, { 20, -13,  29, 24,     up60, unbanked },
    { 20, -13,  30, 24,     up60, unbanked }, { 21, -14,  31, 24,     up60, unbanked }, { 21, -15,  32, 24,     up60, unbanked }, { 21, -16,  33, 24,     up60, unbanked }, { 21, -16,  34, 24,     up60, unbanked },
    { 21, -17,  35, 24,     up60, unbanked }, { 21, -18,  36, 24,     up60, unbanked }, { 21, -19,  37, 24,     up60, unbanked }, { 21, -19,  38, 24,     up60, unbanked }, { 22, -20,  39, 24,     up60, unbanked },
    { 22, -20,  40, 24,     up60, unbanked }, { 22, -21,  41, 24,     up60, unbanked }, { 22, -22,  42, 24,     up60, unbanked }, { 22, -22,  43, 24,     up75, unbanked }, { 22, -23,  44, 24,     up75, unbanked },
    { 22, -24,  45, 24,     up75, unbanked }, { 22, -24,  46, 24,     up75, unbanked }, { 22, -25,  47, 24,     up75, unbanked }, { 22, -25,  48, 24,     up75, unbanked }, { 23, -25,  49, 24,     up75, unbanked },
    { 23, -26,  50, 24,     up75, unbanked }, { 23, -26,  51, 24,     up75, unbanked }, { 23, -26,  52, 24,     up75, unbanked }, { 23, -27,  53, 24,     up75, unbanked }, { 23, -27,  54, 24,     up75, unbanked },
    { 23, -27,  55, 24,     up75, unbanked }, { 23, -28,  56, 24,     up75, unbanked }, { 23, -28,  57, 24,     up75, unbanked }, { 23, -28,  58, 24,     up75, unbanked }, { 24, -29,  59, 24,     up75, unbanked },
    { 24, -29,  60, 24,     up75, unbanked }, { 24, -29,  61, 24,     up75, unbanked }, { 24, -30,  62, 24,     up75, unbanked }, { 24, -30,  63, 24,     up75, unbanked }, { 24, -30,  64, 24,     up90, unbanked },
    { 24, -30,  65, 24,     up90, unbanked }, { 24, -31,  66, 24,     up90, unbanked }, { 24, -31,  67, 24,     up90, unbanked }, { 24, -31,  68, 24,     up90, unbanked }, { 25, -31,  69, 24,     up90, unbanked },
    { 25, -31,  70, 24,     up90, unbanked }, { 25, -32,  71, 24,     up90, unbanked }, { 25, -32,  72, 24,     up90, unbanked }, { 25, -32,  73, 24,     up90, unbanked }, { 25, -32,  74, 24,     up90, unbanked },
    { 25, -32,  75, 24,     up90, unbanked }, { 25, -32,  76, 24,     up90, unbanked }, { 25, -32,  77, 24,     up90, unbanked }, { 25, -32,  78, 24,     up90, unbanked }, { 25, -32,  79, 24,     up90, unbanked },
    { 26, -32,  80, 24,     up90, unbanked }, { 26, -32,  81, 24,     up90, unbanked }, { 26, -32,  82, 24,     up90, unbanked }, { 26, -32,  83, 24,     up90, unbanked }, { 26, -32,  84, 24,     up90, unbanked },
    { 26, -32,  85, 24,     up90, unbanked }, { 26, -32,  86, 24,     up90, unbanked }, { 26, -32,  87, 24,     up90, unbanked }, { 26, -32,  88, 24,     up90, unbanked }, { 26, -32,  89, 24,     up90, unbanked },
    { 26, -32,  90, 24,     up90, unbanked }, { 26, -32,  91, 24,    up105, unbanked }, { 27, -32,  92, 24,    up105, unbanked }, { 27, -31,  93, 24,    up105, unbanked }, { 27, -31,  94, 24,    up105, unbanked },
    { 27, -31,  95, 24,    up105, unbanked }, { 27, -31,  96, 24,    up105, unbanked }, { 27, -31,  97, 24,    up105, unbanked }, { 27, -30,  98, 24,    up105, unbanked }, { 27, -30,  99, 24,    up105, unbanked },
    { 27, -30, 100, 24,    up105, unbanked }, { 27, -30, 101, 24,    up105, unbanked }, { 28, -29, 102, 24,    up105, unbanked }, { 28, -29, 103, 24,    up105, unbanked }, { 28, -29, 104, 24,    up105, unbanked },
    { 28, -28, 105, 24,    up120, unbanked }, { 28, -28, 106, 24,    up120, unbanked }, { 28, -27, 107, 24,    up120, unbanked }, { 28, -27, 108, 24,    up120, unbanked }, { 28, -26, 109, 24,    up120, unbanked },
    { 28, -26, 110, 24,    up120, unbanked }, { 28, -26, 111, 24,    up120, unbanked }, { 29, -25, 112, 24,    up120, unbanked }, { 29, -25, 113, 24,    up120, unbanked }, { 29, -24, 114, 24,    up135, unbanked },
    { 29, -24, 115, 24,    up135, unbanked }, { 29, -23, 116, 24,    up135, unbanked }, { 29, -22, 117, 24,    up135, unbanked }, { 29, -22, 118, 24,    up135, unbanked }, { 29, -21, 119, 24,    up135, unbanked },
    { 29, -20, 120, 24,    up135, unbanked }, { 30, -19, 121, 24,    up135, unbanked }, { 30, -18, 122, 24,    up150, unbanked }, { 30, -17, 123, 24,    up150, unbanked }, { 30, -16, 124, 24,    up150, unbanked },
    { 30, -15, 124, 24,    up150, unbanked }, { 30, -14, 125, 24,    up150, unbanked }, { 30, -13, 126, 24,    up165, unbanked }, { 30, -12, 127, 24,    up165, unbanked }, { 31, -11, 128, 24,    up165, unbanked },
    { 31, -10, 128, 24,    up165, unbanked }, { 31,  -9, 129, 24,    up165, unbanked }, { 31,  -8, 129, 24, inverted, unbanked }, { 31,  -7, 129, 24, inverted, unbanked }, { 31,  -6, 130, 24, inverted, unbanked },
    { 31,  -5, 130, 24, inverted, unbanked }, { 31,  -4, 130, 24, inverted, unbanked }, { 31,  -3, 130, 24, inverted, unbanked }, { 31,  -2, 130, 24, inverted, unbanked }, { 31,  -1, 130, 24, inverted, unbanked },
    { 32,   0, 130, 24, inverted, unbanked }, { 32,   1, 130, 24, inverted, unbanked }, { 32,   2, 130, 24, inverted, unbanked }, { 32,   3, 130, 24, inverted, unbanked }, { 32,   4, 130, 24,  down165, unbanked },
    { 32,   5, 130, 24,  down165, unbanked }, { 32,   6, 129, 24,  down165, unbanked }, { 32,   7, 129, 24,  down165, unbanked }, { 32,   8, 129, 24,  down165, unbanked }, { 32,   9, 128, 24,  down150, unbanked },
    { 32,  10, 128, 24,  down150, unbanked }, { 33,  11, 127, 24,  down150, unbanked }, { 33,  12, 126, 24,  down150, unbanked }, { 33,  13, 125, 24,  down150, unbanked }, { 33,  14, 124, 24,  down135, unbanked },
    { 33,  15, 124, 24,  down135, unbanked }, { 33,  16, 123, 24,  down135, unbanked }, { 33,  17, 122, 24,  down135, unbanked }, { 33,  18, 121, 24,  down135, unbanked }, { 34,  19, 120, 24,  down135, unbanked },
    { 34,  20, 119, 24,  down135, unbanked }, { 34,  21, 118, 24,  down135, unbanked }, { 34,  21, 117, 24,  down120, unbanked }, { 34,  22, 116, 24,  down120, unbanked }, { 34,  23, 115, 24,  down120, unbanked },
    { 34,  23, 114, 24,  down120, unbanked }, { 34,  24, 113, 24,  down120, unbanked }, { 34,  24, 112, 24,  down120, unbanked }, { 35,  25, 111, 24,  down120, unbanked }, { 35,  25, 110, 24,  down120, unbanked },
    { 35,  25, 109, 24,  down120, unbanked }, { 35,  26, 108, 24,  down105, unbanked }, { 35,  26, 107, 24,  down105, unbanked }, { 35,  27, 106, 24,  down105, unbanked }, { 35,  27, 105, 24,  down105, unbanked },
    { 35,  28, 104, 24,  down105, unbanked }, { 35,  28, 103, 24,  down105, unbanked }, { 35,  28, 102, 24,  down105, unbanked }, { 36,  29, 101, 24,  down105, unbanked }, { 36,  29, 100, 24,  down105, unbanked },
    { 36,  29,  99, 24,  down105, unbanked }, { 36,  29,  98, 24,  down105, unbanked }, { 36,  30,  97, 24,  down105, unbanked }, { 36,  30,  96, 24,  down105, unbanked }, { 36,  30,  95, 24,  down105, unbanked },
    { 36,  30,  94, 24,   down90, unbanked }, { 36,  30,  93, 24,   down90, unbanked }, { 36,  31,  92, 24,   down90, unbanked }, { 37,  31,  91, 24,   down90, unbanked }, { 37,  31,  90, 24,   down90, unbanked },
    { 37,  31,  89, 24,   down90, unbanked }, { 37,  31,  88, 24,   down90, unbanked }, { 37,  31,  87, 24,   down90, unbanked }, { 37,  31,  86, 24,   down90, unbanked }, { 37,  31,  85, 24,   down90, unbanked },
    { 37,  31,  84, 24,   down90, unbanked }, { 37,  31,  83, 24,   down90, unbanked }, { 37,  31,  82, 24,   down90, unbanked }, { 37,  31,  81, 24,   down90, unbanked }, { 37,  31,  80, 24,   down90, unbanked },
    { 38,  31,  79, 24,   down90, unbanked }, { 38,  31,  78, 24,   down90, unbanked }, { 38,  31,  77, 24,   down90, unbanked }, { 38,  31,  76, 24,   down90, unbanked }, { 38,  31,  75, 24,   down90, unbanked },
    { 38,  31,  74, 24,   down90, unbanked }, { 38,  31,  73, 24,   down90, unbanked }, { 38,  31,  72, 24,   down90, unbanked }, { 38,  31,  71, 24,   down90, unbanked }, { 38,  30,  70, 24,   down90, unbanked },
    { 38,  30,  69, 24,   down90, unbanked }, { 39,  30,  68, 24,   down90, unbanked }, { 39,  30,  67, 24,   down75, unbanked }, { 39,  30,  66, 24,   down75, unbanked }, { 39,  29,  65, 24,   down75, unbanked },
    { 39,  29,  64, 24,   down75, unbanked }, { 39,  29,  63, 24,   down75, unbanked }, { 39,  29,  62, 24,   down75, unbanked }, { 39,  28,  61, 24,   down75, unbanked }, { 39,  28,  60, 24,   down75, unbanked },
    { 39,  28,  59, 24,   down75, unbanked }, { 40,  27,  58, 24,   down75, unbanked }, { 40,  27,  57, 24,   down75, unbanked }, { 40,  27,  56, 24,   down75, unbanked }, { 40,  26,  55, 24,   down75, unbanked },
    { 40,  26,  54, 24,   down75, unbanked }, { 40,  26,  53, 24,   down75, unbanked }, { 40,  25,  52, 24,   down75, unbanked }, { 40,  25,  51, 24,   down75, unbanked }, { 40,  25,  50, 24,   down75, unbanked },
    { 40,  24,  49, 24,   down75, unbanked }, { 41,  24,  48, 24,   down75, unbanked }, { 41,  24,  47, 24,   down75, unbanked }, { 41,  23,  46, 24,   down60, unbanked }, { 41,  23,  45, 24,   down60, unbanked },
    { 41,  22,  44, 24,   down60, unbanked }, { 41,  21,  43, 24,   down60, unbanked }, { 41,  21,  42, 24,   down60, unbanked }, { 41,  20,  41, 24,   down60, unbanked }, { 41,  19,  40, 24,   down60, unbanked },
    { 41,  19,  39, 24,   down60, unbanked }, { 42,  18,  38, 24,   down60, unbanked }, { 42,  18,  37, 24,   down60, unbanked }, { 42,  17,  36, 24,   down60, unbanked }, { 42,  16,  35, 24,   down60, unbanked },
    { 42,  15,  34, 24,   down60, unbanked }, { 42,  15,  33, 24,   down60, unbanked }, { 42,  14,  32, 24,   down60, unbanked }, { 42,  13,  31, 24,   down60, unbanked }, { 43,  12,  30, 24,   down42, unbanked },
    { 43,  12,  29, 24,   down42, unbanked }, { 43,  11,  28, 24,   down42, unbanked }, { 43,  10,  27, 24,   down42, unbanked }, { 43,   9,  26, 24,   down42, unbanked }, { 43,   8,  25, 24,   down42, unbanked },
    { 43,   7,  24, 24,   down42, unbanked }, { 43,   6,  23, 24,   down42, unbanked }, { 43,   5,  22, 24,   down42, unbanked }, { 44,   4,  21, 24,   down42, unbanked }, { 44,   3,  20, 24,   down42, unbanked },
    { 44,   2,  19, 24,   down42, unbanked }, { 44,   1,  18, 24,   down42, unbanked }, { 44,   0,  18, 24,   down42, unbanked }, { 44,  -1,  17, 24,   down42, unbanked }, { 44,  -2,  16, 24,   down42, unbanked },
    { 44,  -3,  15, 24,   down42, unbanked }, { 45,  -4,  15, 24,   down42, unbanked }, { 45,  -5,  14, 24,   down42, unbanked }, { 45,  -6,  13, 24,   down42, unbanked }, { 45,  -7,  12, 24,   down42, unbanked },
    { 45,  -8,  11, 24,   down42, unbanked }, { 45,  -9,  11, 24,   down42, unbanked }, { 45, -10,  10, 24,   down25, unbanked }, { 45, -11,  10, 24,   down25, unbanked }, { 45, -12,   9, 24,   down25, unbanked },
    { 46, -13,   9, 24,   down25, unbanked }, { 46, -14,   8, 24,   down25, unbanked }, { 46, -15,   8, 24,   down25, unbanked }, { 46, -16,   7, 24,   down25, unbanked }, { 46, -17,   7, 24,   down25, unbanked },
    { 46, -18,   6, 24,   down25, unbanked }, { 46, -19,   6, 24,   down25, unbanked }, { 46, -20,   5, 24,   down25, unbanked }, { 46, -21,   5, 24,   down25, unbanked }, { 46, -22,   4, 24,   down25, unbanked },
    { 47, -23,   4, 24,   down25, unbanked }, { 47, -24,   3, 24,   down25, unbanked }, { 47, -25,   3, 24,   down25, unbanked }, { 47, -26,   3, 24,   down25, unbanked }, { 47, -27,   2, 24,   down25, unbanked },
    { 47, -28,   2, 24,   down25, unbanked }, { 47, -29,   1, 24,   down25, unbanked }, { 47, -30,   1, 24,   down25, unbanked }, { 47, -31,   0, 24,   down25, unbanked }, { 48, -32,   0, 24,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D705E, {
    {  31, 16,   0, 0,     up25, unbanked }, {  30, 16,   0, 0,     up25, unbanked }, {  29, 16,   1, 0,     up25, unbanked }, {  28, 16,   1, 0,     up25, unbanked }, {  27, 16,   2, 0,     up25, unbanked },
    {  26, 16,   2, 0,     up25, unbanked }, {  25, 16,   3, 0,     up25, unbanked }, {  24, 16,   3, 0,     up25, unbanked }, {  23, 16,   3, 0,     up25, unbanked }, {  22, 16,   4, 0,     up25, unbanked },
    {  21, 17,   4, 0,     up25, unbanked }, {  20, 17,   5, 0,     up25, unbanked }, {  19, 17,   5, 0,     up25, unbanked }, {  18, 17,   6, 0,     up25, unbanked }, {  17, 17,   6, 0,     up25, unbanked },
    {  16, 17,   7, 0,     up25, unbanked }, {  15, 17,   7, 0,     up25, unbanked }, {  14, 17,   8, 0,     up25, unbanked }, {  13, 17,   8, 0,     up25, unbanked }, {  12, 17,   9, 0,     up42, unbanked },
    {  11, 18,   9, 0,     up42, unbanked }, {  10, 18,  10, 0,     up42, unbanked }, {   9, 18,  10, 0,     up42, unbanked }, {   8, 18,  11, 0,     up42, unbanked }, {   7, 18,  11, 0,     up42, unbanked },
    {   6, 18,  12, 0,     up42, unbanked }, {   5, 18,  13, 0,     up42, unbanked }, {   4, 18,  14, 0,     up42, unbanked }, {   3, 18,  15, 0,     up42, unbanked }, {   2, 19,  15, 0,     up42, unbanked },
    {   1, 19,  16, 0,     up42, unbanked }, {   0, 19,  17, 0,     up42, unbanked }, {  -1, 19,  18, 0,     up42, unbanked }, {  -2, 19,  18, 0,     up42, unbanked }, {  -3, 19,  19, 0,     up42, unbanked },
    {  -4, 19,  20, 0,     up42, unbanked }, {  -5, 19,  21, 0,     up42, unbanked }, {  -6, 20,  22, 0,     up42, unbanked }, {  -7, 20,  23, 0,     up42, unbanked }, {  -8, 20,  24, 0,     up42, unbanked },
    {  -9, 20,  25, 0,     up42, unbanked }, { -10, 20,  26, 0,     up42, unbanked }, { -11, 20,  27, 0,     up60, unbanked }, { -12, 20,  28, 0,     up60, unbanked }, { -13, 20,  29, 0,     up60, unbanked },
    { -13, 20,  30, 0,     up60, unbanked }, { -14, 21,  31, 0,     up60, unbanked }, { -15, 21,  32, 0,     up60, unbanked }, { -16, 21,  33, 0,     up60, unbanked }, { -16, 21,  34, 0,     up60, unbanked },
    { -17, 21,  35, 0,     up60, unbanked }, { -18, 21,  36, 0,     up60, unbanked }, { -19, 21,  37, 0,     up60, unbanked }, { -19, 21,  38, 0,     up60, unbanked }, { -20, 22,  39, 0,     up60, unbanked },
    { -20, 22,  40, 0,     up60, unbanked }, { -21, 22,  41, 0,     up60, unbanked }, { -22, 22,  42, 0,     up60, unbanked }, { -22, 22,  43, 0,     up75, unbanked }, { -23, 22,  44, 0,     up75, unbanked },
    { -24, 22,  45, 0,     up75, unbanked }, { -24, 22,  46, 0,     up75, unbanked }, { -25, 22,  47, 0,     up75, unbanked }, { -25, 22,  48, 0,     up75, unbanked }, { -25, 23,  49, 0,     up75, unbanked },
    { -26, 23,  50, 0,     up75, unbanked }, { -26, 23,  51, 0,     up75, unbanked }, { -26, 23,  52, 0,     up75, unbanked }, { -27, 23,  53, 0,     up75, unbanked }, { -27, 23,  54, 0,     up75, unbanked },
    { -27, 23,  55, 0,     up75, unbanked }, { -28, 23,  56, 0,     up75, unbanked }, { -28, 23,  57, 0,     up75, unbanked }, { -28, 23,  58, 0,     up75, unbanked }, { -29, 24,  59, 0,     up75, unbanked },
    { -29, 24,  60, 0,     up75, unbanked }, { -29, 24,  61, 0,     up75, unbanked }, { -30, 24,  62, 0,     up75, unbanked }, { -30, 24,  63, 0,     up75, unbanked }, { -30, 24,  64, 0,     up90, unbanked },
    { -30, 24,  65, 0,     up90, unbanked }, { -31, 24,  66, 0,     up90, unbanked }, { -31, 24,  67, 0,     up90, unbanked }, { -31, 24,  68, 0,     up90, unbanked }, { -31, 25,  69, 0,     up90, unbanked },
    { -31, 25,  70, 0,     up90, unbanked }, { -32, 25,  71, 0,     up90, unbanked }, { -32, 25,  72, 0,     up90, unbanked }, { -32, 25,  73, 0,     up90, unbanked }, { -32, 25,  74, 0,     up90, unbanked },
    { -32, 25,  75, 0,     up90, unbanked }, { -32, 25,  76, 0,     up90, unbanked }, { -32, 25,  77, 0,     up90, unbanked }, { -32, 25,  78, 0,     up90, unbanked }, { -32, 25,  79, 0,     up90, unbanked },
    { -32, 26,  80, 0,     up90, unbanked }, { -32, 26,  81, 0,     up90, unbanked }, { -32, 26,  82, 0,     up90, unbanked }, { -32, 26,  83, 0,     up90, unbanked }, { -32, 26,  84, 0,     up90, unbanked },
    { -32, 26,  85, 0,     up90, unbanked }, { -32, 26,  86, 0,     up90, unbanked }, { -32, 26,  87, 0,     up90, unbanked }, { -32, 26,  88, 0,     up90, unbanked }, { -32, 26,  89, 0,     up90, unbanked },
    { -32, 26,  90, 0,     up90, unbanked }, { -32, 26,  91, 0,    up105, unbanked }, { -32, 27,  92, 0,    up105, unbanked }, { -31, 27,  93, 0,    up105, unbanked }, { -31, 27,  94, 0,    up105, unbanked },
    { -31, 27,  95, 0,    up105, unbanked }, { -31, 27,  96, 0,    up105, unbanked }, { -31, 27,  97, 0,    up105, unbanked }, { -30, 27,  98, 0,    up105, unbanked }, { -30, 27,  99, 0,    up105, unbanked },
    { -30, 27, 100, 0,    up105, unbanked }, { -30, 27, 101, 0,    up105, unbanked }, { -29, 28, 102, 0,    up105, unbanked }, { -29, 28, 103, 0,    up105, unbanked }, { -29, 28, 104, 0,    up105, unbanked },
    { -28, 28, 105, 0,    up120, unbanked }, { -28, 28, 106, 0,    up120, unbanked }, { -27, 28, 107, 0,    up120, unbanked }, { -27, 28, 108, 0,    up120, unbanked }, { -26, 28, 109, 0,    up120, unbanked },
    { -26, 28, 110, 0,    up120, unbanked }, { -26, 28, 111, 0,    up120, unbanked }, { -25, 29, 112, 0,    up120, unbanked }, { -25, 29, 113, 0,    up120, unbanked }, { -24, 29, 114, 0,    up135, unbanked },
    { -24, 29, 115, 0,    up135, unbanked }, { -23, 29, 116, 0,    up135, unbanked }, { -22, 29, 117, 0,    up135, unbanked }, { -22, 29, 118, 0,    up135, unbanked }, { -21, 29, 119, 0,    up135, unbanked },
    { -20, 29, 120, 0,    up135, unbanked }, { -19, 30, 121, 0,    up135, unbanked }, { -18, 30, 122, 0,    up150, unbanked }, { -17, 30, 123, 0,    up150, unbanked }, { -16, 30, 124, 0,    up150, unbanked },
    { -15, 30, 124, 0,    up150, unbanked }, { -14, 30, 125, 0,    up150, unbanked }, { -13, 30, 126, 0,    up165, unbanked }, { -12, 30, 127, 0,    up165, unbanked }, { -11, 31, 128, 0,    up165, unbanked },
    { -10, 31, 128, 0,    up165, unbanked }, {  -9, 31, 129, 0,    up165, unbanked }, {  -8, 31, 129, 0, inverted, unbanked }, {  -7, 31, 129, 0, inverted, unbanked }, {  -6, 31, 130, 0, inverted, unbanked },
    {  -5, 31, 130, 0, inverted, unbanked }, {  -4, 31, 130, 0, inverted, unbanked }, {  -3, 31, 130, 0, inverted, unbanked }, {  -2, 31, 130, 0, inverted, unbanked }, {  -1, 31, 130, 0, inverted, unbanked },
    {   0, 32, 130, 0, inverted, unbanked }, {   1, 32, 130, 0, inverted, unbanked }, {   2, 32, 130, 0, inverted, unbanked }, {   3, 32, 130, 0, inverted, unbanked }, {   4, 32, 130, 0,  down165, unbanked },
    {   5, 32, 130, 0,  down165, unbanked }, {   6, 32, 129, 0,  down165, unbanked }, {   7, 32, 129, 0,  down165, unbanked }, {   8, 32, 129, 0,  down165, unbanked }, {   9, 32, 128, 0,  down150, unbanked },
    {  10, 32, 128, 0,  down150, unbanked }, {  11, 33, 127, 0,  down150, unbanked }, {  12, 33, 126, 0,  down150, unbanked }, {  13, 33, 125, 0,  down150, unbanked }, {  14, 33, 124, 0,  down135, unbanked },
    {  15, 33, 124, 0,  down135, unbanked }, {  16, 33, 123, 0,  down135, unbanked }, {  17, 33, 122, 0,  down135, unbanked }, {  18, 33, 121, 0,  down135, unbanked }, {  19, 34, 120, 0,  down135, unbanked },
    {  20, 34, 119, 0,  down135, unbanked }, {  21, 34, 118, 0,  down135, unbanked }, {  21, 34, 117, 0,  down120, unbanked }, {  22, 34, 116, 0,  down120, unbanked }, {  23, 34, 115, 0,  down120, unbanked },
    {  23, 34, 114, 0,  down120, unbanked }, {  24, 34, 113, 0,  down120, unbanked }, {  24, 34, 112, 0,  down120, unbanked }, {  25, 35, 111, 0,  down120, unbanked }, {  25, 35, 110, 0,  down120, unbanked },
    {  25, 35, 109, 0,  down120, unbanked }, {  26, 35, 108, 0,  down105, unbanked }, {  26, 35, 107, 0,  down105, unbanked }, {  27, 35, 106, 0,  down105, unbanked }, {  27, 35, 105, 0,  down105, unbanked },
    {  28, 35, 104, 0,  down105, unbanked }, {  28, 35, 103, 0,  down105, unbanked }, {  28, 35, 102, 0,  down105, unbanked }, {  29, 36, 101, 0,  down105, unbanked }, {  29, 36, 100, 0,  down105, unbanked },
    {  29, 36,  99, 0,  down105, unbanked }, {  29, 36,  98, 0,  down105, unbanked }, {  30, 36,  97, 0,  down105, unbanked }, {  30, 36,  96, 0,  down105, unbanked }, {  30, 36,  95, 0,  down105, unbanked },
    {  30, 36,  94, 0,   down90, unbanked }, {  30, 36,  93, 0,   down90, unbanked }, {  31, 36,  92, 0,   down90, unbanked }, {  31, 37,  91, 0,   down90, unbanked }, {  31, 37,  90, 0,   down90, unbanked },
    {  31, 37,  89, 0,   down90, unbanked }, {  31, 37,  88, 0,   down90, unbanked }, {  31, 37,  87, 0,   down90, unbanked }, {  31, 37,  86, 0,   down90, unbanked }, {  31, 37,  85, 0,   down90, unbanked },
    {  31, 37,  84, 0,   down90, unbanked }, {  31, 37,  83, 0,   down90, unbanked }, {  31, 37,  82, 0,   down90, unbanked }, {  31, 37,  81, 0,   down90, unbanked }, {  31, 37,  80, 0,   down90, unbanked },
    {  31, 38,  79, 0,   down90, unbanked }, {  31, 38,  78, 0,   down90, unbanked }, {  31, 38,  77, 0,   down90, unbanked }, {  31, 38,  76, 0,   down90, unbanked }, {  31, 38,  75, 0,   down90, unbanked },
    {  31, 38,  74, 0,   down90, unbanked }, {  31, 38,  73, 0,   down90, unbanked }, {  31, 38,  72, 0,   down90, unbanked }, {  31, 38,  71, 0,   down90, unbanked }, {  30, 38,  70, 0,   down90, unbanked },
    {  30, 38,  69, 0,   down90, unbanked }, {  30, 39,  68, 0,   down90, unbanked }, {  30, 39,  67, 0,   down75, unbanked }, {  30, 39,  66, 0,   down75, unbanked }, {  29, 39,  65, 0,   down75, unbanked },
    {  29, 39,  64, 0,   down75, unbanked }, {  29, 39,  63, 0,   down75, unbanked }, {  29, 39,  62, 0,   down75, unbanked }, {  28, 39,  61, 0,   down75, unbanked }, {  28, 39,  60, 0,   down75, unbanked },
    {  28, 39,  59, 0,   down75, unbanked }, {  27, 40,  58, 0,   down75, unbanked }, {  27, 40,  57, 0,   down75, unbanked }, {  27, 40,  56, 0,   down75, unbanked }, {  26, 40,  55, 0,   down75, unbanked },
    {  26, 40,  54, 0,   down75, unbanked }, {  26, 40,  53, 0,   down75, unbanked }, {  25, 40,  52, 0,   down75, unbanked }, {  25, 40,  51, 0,   down75, unbanked }, {  25, 40,  50, 0,   down75, unbanked },
    {  24, 40,  49, 0,   down75, unbanked }, {  24, 41,  48, 0,   down75, unbanked }, {  24, 41,  47, 0,   down75, unbanked }, {  23, 41,  46, 0,   down60, unbanked }, {  23, 41,  45, 0,   down60, unbanked },
    {  22, 41,  44, 0,   down60, unbanked }, {  21, 41,  43, 0,   down60, unbanked }, {  21, 41,  42, 0,   down60, unbanked }, {  20, 41,  41, 0,   down60, unbanked }, {  19, 41,  40, 0,   down60, unbanked },
    {  19, 41,  39, 0,   down60, unbanked }, {  18, 42,  38, 0,   down60, unbanked }, {  18, 42,  37, 0,   down60, unbanked }, {  17, 42,  36, 0,   down60, unbanked }, {  16, 42,  35, 0,   down60, unbanked },
    {  15, 42,  34, 0,   down60, unbanked }, {  15, 42,  33, 0,   down60, unbanked }, {  14, 42,  32, 0,   down60, unbanked }, {  13, 42,  31, 0,   down60, unbanked }, {  12, 43,  30, 0,   down42, unbanked },
    {  12, 43,  29, 0,   down42, unbanked }, {  11, 43,  28, 0,   down42, unbanked }, {  10, 43,  27, 0,   down42, unbanked }, {   9, 43,  26, 0,   down42, unbanked }, {   8, 43,  25, 0,   down42, unbanked },
    {   7, 43,  24, 0,   down42, unbanked }, {   6, 43,  23, 0,   down42, unbanked }, {   5, 43,  22, 0,   down42, unbanked }, {   4, 44,  21, 0,   down42, unbanked }, {   3, 44,  20, 0,   down42, unbanked },
    {   2, 44,  19, 0,   down42, unbanked }, {   1, 44,  18, 0,   down42, unbanked }, {   0, 44,  18, 0,   down42, unbanked }, {  -1, 44,  17, 0,   down42, unbanked }, {  -2, 44,  16, 0,   down42, unbanked },
    {  -3, 44,  15, 0,   down42, unbanked }, {  -4, 45,  15, 0,   down42, unbanked }, {  -5, 45,  14, 0,   down42, unbanked }, {  -6, 45,  13, 0,   down42, unbanked }, {  -7, 45,  12, 0,   down42, unbanked },
    {  -8, 45,  11, 0,   down42, unbanked }, {  -9, 45,  11, 0,   down42, unbanked }, { -10, 45,  10, 0,   down25, unbanked }, { -11, 45,  10, 0,   down25, unbanked }, { -12, 45,   9, 0,   down25, unbanked },
    { -13, 46,   9, 0,   down25, unbanked }, { -14, 46,   8, 0,   down25, unbanked }, { -15, 46,   8, 0,   down25, unbanked }, { -16, 46,   7, 0,   down25, unbanked }, { -17, 46,   7, 0,   down25, unbanked },
    { -18, 46,   6, 0,   down25, unbanked }, { -19, 46,   6, 0,   down25, unbanked }, { -20, 46,   5, 0,   down25, unbanked }, { -21, 46,   5, 0,   down25, unbanked }, { -22, 46,   4, 0,   down25, unbanked },
    { -23, 47,   4, 0,   down25, unbanked }, { -24, 47,   3, 0,   down25, unbanked }, { -25, 47,   3, 0,   down25, unbanked }, { -26, 47,   3, 0,   down25, unbanked }, { -27, 47,   2, 0,   down25, unbanked },
    { -28, 47,   2, 0,   down25, unbanked }, { -29, 47,   1, 0,   down25, unbanked }, { -30, 47,   1, 0,   down25, unbanked }, { -31, 47,   0, 0,   down25, unbanked }, { -32, 48,   0, 0,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D7B46, {
    { 16,  0,   0, 8,     up25, unbanked }, { 16,  1,   0, 8,     up25, unbanked }, { 16,  2,   1, 8,     up25, unbanked }, { 16,  3,   1, 8,     up25, unbanked }, { 16,  4,   2, 8,     up25, unbanked },
    { 16,  5,   2, 8,     up25, unbanked }, { 16,  6,   3, 8,     up25, unbanked }, { 16,  7,   3, 8,     up25, unbanked }, { 16,  8,   3, 8,     up25, unbanked }, { 16,  9,   4, 8,     up25, unbanked },
    { 17, 10,   4, 8,     up25, unbanked }, { 17, 11,   5, 8,     up25, unbanked }, { 17, 12,   5, 8,     up25, unbanked }, { 17, 13,   6, 8,     up25, unbanked }, { 17, 14,   6, 8,     up25, unbanked },
    { 17, 15,   7, 8,     up25, unbanked }, { 17, 16,   7, 8,     up25, unbanked }, { 17, 17,   8, 8,     up25, unbanked }, { 17, 18,   8, 8,     up25, unbanked }, { 17, 19,   9, 8,     up42, unbanked },
    { 18, 20,   9, 8,     up42, unbanked }, { 18, 21,  10, 8,     up42, unbanked }, { 18, 22,  10, 8,     up42, unbanked }, { 18, 23,  11, 8,     up42, unbanked }, { 18, 24,  11, 8,     up42, unbanked },
    { 18, 25,  12, 8,     up42, unbanked }, { 18, 26,  13, 8,     up42, unbanked }, { 18, 27,  14, 8,     up42, unbanked }, { 18, 28,  15, 8,     up42, unbanked }, { 19, 29,  15, 8,     up42, unbanked },
    { 19, 30,  16, 8,     up42, unbanked }, { 19, 31,  17, 8,     up42, unbanked }, { 19, 32,  18, 8,     up42, unbanked }, { 19, 33,  18, 8,     up42, unbanked }, { 19, 34,  19, 8,     up42, unbanked },
    { 19, 35,  20, 8,     up42, unbanked }, { 19, 36,  21, 8,     up42, unbanked }, { 20, 37,  22, 8,     up42, unbanked }, { 20, 38,  23, 8,     up42, unbanked }, { 20, 39,  24, 8,     up42, unbanked },
    { 20, 40,  25, 8,     up42, unbanked }, { 20, 41,  26, 8,     up42, unbanked }, { 20, 42,  27, 8,     up60, unbanked }, { 20, 43,  28, 8,     up60, unbanked }, { 20, 44,  29, 8,     up60, unbanked },
    { 20, 44,  30, 8,     up60, unbanked }, { 21, 45,  31, 8,     up60, unbanked }, { 21, 46,  32, 8,     up60, unbanked }, { 21, 47,  33, 8,     up60, unbanked }, { 21, 47,  34, 8,     up60, unbanked },
    { 21, 48,  35, 8,     up60, unbanked }, { 21, 49,  36, 8,     up60, unbanked }, { 21, 50,  37, 8,     up60, unbanked }, { 21, 50,  38, 8,     up60, unbanked }, { 22, 51,  39, 8,     up60, unbanked },
    { 22, 51,  40, 8,     up60, unbanked }, { 22, 52,  41, 8,     up60, unbanked }, { 22, 53,  42, 8,     up60, unbanked }, { 22, 53,  43, 8,     up75, unbanked }, { 22, 54,  44, 8,     up75, unbanked },
    { 22, 55,  45, 8,     up75, unbanked }, { 22, 55,  46, 8,     up75, unbanked }, { 22, 56,  47, 8,     up75, unbanked }, { 22, 56,  48, 8,     up75, unbanked }, { 23, 56,  49, 8,     up75, unbanked },
    { 23, 57,  50, 8,     up75, unbanked }, { 23, 57,  51, 8,     up75, unbanked }, { 23, 57,  52, 8,     up75, unbanked }, { 23, 58,  53, 8,     up75, unbanked }, { 23, 58,  54, 8,     up75, unbanked },
    { 23, 58,  55, 8,     up75, unbanked }, { 23, 59,  56, 8,     up75, unbanked }, { 23, 59,  57, 8,     up75, unbanked }, { 23, 59,  58, 8,     up75, unbanked }, { 24, 60,  59, 8,     up75, unbanked },
    { 24, 60,  60, 8,     up75, unbanked }, { 24, 60,  61, 8,     up75, unbanked }, { 24, 61,  62, 8,     up75, unbanked }, { 24, 61,  63, 8,     up75, unbanked }, { 24, 61,  64, 8,     up90, unbanked },
    { 24, 61,  65, 8,     up90, unbanked }, { 24, 62,  66, 8,     up90, unbanked }, { 24, 62,  67, 8,     up90, unbanked }, { 24, 62,  68, 8,     up90, unbanked }, { 25, 62,  69, 8,     up90, unbanked },
    { 25, 62,  70, 8,     up90, unbanked }, { 25, 63,  71, 8,     up90, unbanked }, { 25, 63,  72, 8,     up90, unbanked }, { 25, 63,  73, 8,     up90, unbanked }, { 25, 63,  74, 8,     up90, unbanked },
    { 25, 63,  75, 8,     up90, unbanked }, { 25, 63,  76, 8,     up90, unbanked }, { 25, 63,  77, 8,     up90, unbanked }, { 25, 63,  78, 8,     up90, unbanked }, { 25, 63,  79, 8,     up90, unbanked },
    { 26, 63,  80, 8,     up90, unbanked }, { 26, 63,  81, 8,     up90, unbanked }, { 26, 63,  82, 8,     up90, unbanked }, { 26, 63,  83, 8,     up90, unbanked }, { 26, 63,  84, 8,     up90, unbanked },
    { 26, 63,  85, 8,     up90, unbanked }, { 26, 63,  86, 8,     up90, unbanked }, { 26, 63,  87, 8,     up90, unbanked }, { 26, 63,  88, 8,     up90, unbanked }, { 26, 63,  89, 8,     up90, unbanked },
    { 26, 63,  90, 8,     up90, unbanked }, { 26, 63,  91, 8,    up105, unbanked }, { 27, 63,  92, 8,    up105, unbanked }, { 27, 62,  93, 8,    up105, unbanked }, { 27, 62,  94, 8,    up105, unbanked },
    { 27, 62,  95, 8,    up105, unbanked }, { 27, 62,  96, 8,    up105, unbanked }, { 27, 62,  97, 8,    up105, unbanked }, { 27, 61,  98, 8,    up105, unbanked }, { 27, 61,  99, 8,    up105, unbanked },
    { 27, 61, 100, 8,    up105, unbanked }, { 27, 61, 101, 8,    up105, unbanked }, { 28, 60, 102, 8,    up105, unbanked }, { 28, 60, 103, 8,    up105, unbanked }, { 28, 60, 104, 8,    up105, unbanked },
    { 28, 59, 105, 8,    up120, unbanked }, { 28, 59, 106, 8,    up120, unbanked }, { 28, 58, 107, 8,    up120, unbanked }, { 28, 58, 108, 8,    up120, unbanked }, { 28, 57, 109, 8,    up120, unbanked },
    { 28, 57, 110, 8,    up120, unbanked }, { 28, 57, 111, 8,    up120, unbanked }, { 29, 56, 112, 8,    up120, unbanked }, { 29, 56, 113, 8,    up120, unbanked }, { 29, 55, 114, 8,    up135, unbanked },
    { 29, 55, 115, 8,    up135, unbanked }, { 29, 54, 116, 8,    up135, unbanked }, { 29, 53, 117, 8,    up135, unbanked }, { 29, 53, 118, 8,    up135, unbanked }, { 29, 52, 119, 8,    up135, unbanked },
    { 29, 51, 120, 8,    up135, unbanked }, { 30, 50, 121, 8,    up135, unbanked }, { 30, 49, 122, 8,    up150, unbanked }, { 30, 48, 123, 8,    up150, unbanked }, { 30, 47, 124, 8,    up150, unbanked },
    { 30, 46, 124, 8,    up150, unbanked }, { 30, 45, 125, 8,    up150, unbanked }, { 30, 44, 126, 8,    up165, unbanked }, { 30, 43, 127, 8,    up165, unbanked }, { 31, 42, 128, 8,    up165, unbanked },
    { 31, 41, 128, 8,    up165, unbanked }, { 31, 40, 129, 8,    up165, unbanked }, { 31, 39, 129, 8, inverted, unbanked }, { 31, 38, 129, 8, inverted, unbanked }, { 31, 37, 130, 8, inverted, unbanked },
    { 31, 36, 130, 8, inverted, unbanked }, { 31, 35, 130, 8, inverted, unbanked }, { 31, 34, 130, 8, inverted, unbanked }, { 31, 33, 130, 8, inverted, unbanked }, { 31, 32, 130, 8, inverted, unbanked },
    { 32, 31, 130, 8, inverted, unbanked }, { 32, 30, 130, 8, inverted, unbanked }, { 32, 29, 130, 8, inverted, unbanked }, { 32, 28, 130, 8, inverted, unbanked }, { 32, 27, 130, 8,  down165, unbanked },
    { 32, 26, 130, 8,  down165, unbanked }, { 32, 25, 129, 8,  down165, unbanked }, { 32, 24, 129, 8,  down165, unbanked }, { 32, 23, 129, 8,  down165, unbanked }, { 32, 22, 128, 8,  down150, unbanked },
    { 32, 21, 128, 8,  down150, unbanked }, { 33, 20, 127, 8,  down150, unbanked }, { 33, 19, 126, 8,  down150, unbanked }, { 33, 18, 125, 8,  down150, unbanked }, { 33, 17, 124, 8,  down135, unbanked },
    { 33, 16, 124, 8,  down135, unbanked }, { 33, 15, 123, 8,  down135, unbanked }, { 33, 14, 122, 8,  down135, unbanked }, { 33, 13, 121, 8,  down135, unbanked }, { 34, 12, 120, 8,  down135, unbanked },
    { 34, 11, 119, 8,  down135, unbanked }, { 34, 10, 118, 8,  down135, unbanked }, { 34, 10, 117, 8,  down120, unbanked }, { 34,  9, 116, 8,  down120, unbanked }, { 34,  8, 115, 8,  down120, unbanked },
    { 34,  8, 114, 8,  down120, unbanked }, { 34,  7, 113, 8,  down120, unbanked }, { 34,  7, 112, 8,  down120, unbanked }, { 35,  6, 111, 8,  down120, unbanked }, { 35,  6, 110, 8,  down120, unbanked },
    { 35,  6, 109, 8,  down120, unbanked }, { 35,  5, 108, 8,  down105, unbanked }, { 35,  5, 107, 8,  down105, unbanked }, { 35,  4, 106, 8,  down105, unbanked }, { 35,  4, 105, 8,  down105, unbanked },
    { 35,  3, 104, 8,  down105, unbanked }, { 35,  3, 103, 8,  down105, unbanked }, { 35,  3, 102, 8,  down105, unbanked }, { 36,  2, 101, 8,  down105, unbanked }, { 36,  2, 100, 8,  down105, unbanked },
    { 36,  2,  99, 8,  down105, unbanked }, { 36,  2,  98, 8,  down105, unbanked }, { 36,  1,  97, 8,  down105, unbanked }, { 36,  1,  96, 8,  down105, unbanked }, { 36,  1,  95, 8,  down105, unbanked },
    { 36,  1,  94, 8,   down90, unbanked }, { 36,  1,  93, 8,   down90, unbanked }, { 36,  0,  92, 8,   down90, unbanked }, { 37,  0,  91, 8,   down90, unbanked }, { 37,  0,  90, 8,   down90, unbanked },
    { 37,  0,  89, 8,   down90, unbanked }, { 37,  0,  88, 8,   down90, unbanked }, { 37,  0,  87, 8,   down90, unbanked }, { 37,  0,  86, 8,   down90, unbanked }, { 37,  0,  85, 8,   down90, unbanked },
    { 37,  0,  84, 8,   down90, unbanked }, { 37,  0,  83, 8,   down90, unbanked }, { 37,  0,  82, 8,   down90, unbanked }, { 37,  0,  81, 8,   down90, unbanked }, { 37,  0,  80, 8,   down90, unbanked },
    { 38,  0,  79, 8,   down90, unbanked }, { 38,  0,  78, 8,   down90, unbanked }, { 38,  0,  77, 8,   down90, unbanked }, { 38,  0,  76, 8,   down90, unbanked }, { 38,  0,  75, 8,   down90, unbanked },
    { 38,  0,  74, 8,   down90, unbanked }, { 38,  0,  73, 8,   down90, unbanked }, { 38,  0,  72, 8,   down90, unbanked }, { 38,  0,  71, 8,   down90, unbanked }, { 38,  1,  70, 8,   down90, unbanked },
    { 38,  1,  69, 8,   down90, unbanked }, { 39,  1,  68, 8,   down90, unbanked }, { 39,  1,  67, 8,   down75, unbanked }, { 39,  1,  66, 8,   down75, unbanked }, { 39,  2,  65, 8,   down75, unbanked },
    { 39,  2,  64, 8,   down75, unbanked }, { 39,  2,  63, 8,   down75, unbanked }, { 39,  2,  62, 8,   down75, unbanked }, { 39,  3,  61, 8,   down75, unbanked }, { 39,  3,  60, 8,   down75, unbanked },
    { 39,  3,  59, 8,   down75, unbanked }, { 40,  4,  58, 8,   down75, unbanked }, { 40,  4,  57, 8,   down75, unbanked }, { 40,  4,  56, 8,   down75, unbanked }, { 40,  5,  55, 8,   down75, unbanked },
    { 40,  5,  54, 8,   down75, unbanked }, { 40,  5,  53, 8,   down75, unbanked }, { 40,  6,  52, 8,   down75, unbanked }, { 40,  6,  51, 8,   down75, unbanked }, { 40,  6,  50, 8,   down75, unbanked },
    { 40,  7,  49, 8,   down75, unbanked }, { 41,  7,  48, 8,   down75, unbanked }, { 41,  7,  47, 8,   down75, unbanked }, { 41,  8,  46, 8,   down60, unbanked }, { 41,  8,  45, 8,   down60, unbanked },
    { 41,  9,  44, 8,   down60, unbanked }, { 41, 10,  43, 8,   down60, unbanked }, { 41, 10,  42, 8,   down60, unbanked }, { 41, 11,  41, 8,   down60, unbanked }, { 41, 12,  40, 8,   down60, unbanked },
    { 41, 12,  39, 8,   down60, unbanked }, { 42, 13,  38, 8,   down60, unbanked }, { 42, 13,  37, 8,   down60, unbanked }, { 42, 14,  36, 8,   down60, unbanked }, { 42, 15,  35, 8,   down60, unbanked },
    { 42, 16,  34, 8,   down60, unbanked }, { 42, 16,  33, 8,   down60, unbanked }, { 42, 17,  32, 8,   down60, unbanked }, { 42, 18,  31, 8,   down60, unbanked }, { 43, 19,  30, 8,   down42, unbanked },
    { 43, 19,  29, 8,   down42, unbanked }, { 43, 20,  28, 8,   down42, unbanked }, { 43, 21,  27, 8,   down42, unbanked }, { 43, 22,  26, 8,   down42, unbanked }, { 43, 23,  25, 8,   down42, unbanked },
    { 43, 24,  24, 8,   down42, unbanked }, { 43, 25,  23, 8,   down42, unbanked }, { 43, 26,  22, 8,   down42, unbanked }, { 44, 27,  21, 8,   down42, unbanked }, { 44, 28,  20, 8,   down42, unbanked },
    { 44, 29,  19, 8,   down42, unbanked }, { 44, 30,  18, 8,   down42, unbanked }, { 44, 31,  18, 8,   down42, unbanked }, { 44, 32,  17, 8,   down42, unbanked }, { 44, 33,  16, 8,   down42, unbanked },
    { 44, 34,  15, 8,   down42, unbanked }, { 45, 35,  15, 8,   down42, unbanked }, { 45, 36,  14, 8,   down42, unbanked }, { 45, 37,  13, 8,   down42, unbanked }, { 45, 38,  12, 8,   down42, unbanked },
    { 45, 39,  11, 8,   down42, unbanked }, { 45, 40,  11, 8,   down42, unbanked }, { 45, 41,  10, 8,   down25, unbanked }, { 45, 42,  10, 8,   down25, unbanked }, { 45, 43,   9, 8,   down25, unbanked },
    { 46, 44,   9, 8,   down25, unbanked }, { 46, 45,   8, 8,   down25, unbanked }, { 46, 46,   8, 8,   down25, unbanked }, { 46, 47,   7, 8,   down25, unbanked }, { 46, 48,   7, 8,   down25, unbanked },
    { 46, 49,   6, 8,   down25, unbanked }, { 46, 50,   6, 8,   down25, unbanked }, { 46, 51,   5, 8,   down25, unbanked }, { 46, 52,   5, 8,   down25, unbanked }, { 46, 53,   4, 8,   down25, unbanked },
    { 47, 54,   4, 8,   down25, unbanked }, { 47, 55,   3, 8,   down25, unbanked }, { 47, 56,   3, 8,   down25, unbanked }, { 47, 57,   3, 8,   down25, unbanked }, { 47, 58,   2, 8,   down25, unbanked },
    { 47, 59,   2, 8,   down25, unbanked }, { 47, 60,   1, 8,   down25, unbanked }, { 47, 61,   1, 8,   down25, unbanked }, { 47, 62,   0, 8,   down25, unbanked }, { 48, 63,   0, 8,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D862E, {
    {  0,  16,   0, 16,     up25, unbanked }, {  1,  15,   0, 16,     up25, unbanked }, {  2,  15,   1, 16,     up25, unbanked }, {  3,  15,   1, 16,     up25, unbanked }, {  4,  15,   2, 16,     up25, unbanked },
    {  5,  15,   2, 16,     up25, unbanked }, {  6,  15,   3, 16,     up25, unbanked }, {  7,  15,   3, 16,     up25, unbanked }, {  8,  15,   3, 16,     up25, unbanked }, {  9,  15,   4, 16,     up25, unbanked },
    { 10,  14,   4, 16,     up25, unbanked }, { 11,  14,   5, 16,     up25, unbanked }, { 12,  14,   5, 16,     up25, unbanked }, { 13,  14,   6, 16,     up25, unbanked }, { 14,  14,   6, 16,     up25, unbanked },
    { 15,  14,   7, 16,     up25, unbanked }, { 16,  14,   7, 16,     up25, unbanked }, { 17,  14,   8, 16,     up25, unbanked }, { 18,  14,   8, 16,     up25, unbanked }, { 19,  14,   9, 16,     up42, unbanked },
    { 20,  13,   9, 16,     up42, unbanked }, { 21,  13,  10, 16,     up42, unbanked }, { 22,  13,  10, 16,     up42, unbanked }, { 23,  13,  11, 16,     up42, unbanked }, { 24,  13,  11, 16,     up42, unbanked },
    { 25,  13,  12, 16,     up42, unbanked }, { 26,  13,  13, 16,     up42, unbanked }, { 27,  13,  14, 16,     up42, unbanked }, { 28,  13,  15, 16,     up42, unbanked }, { 29,  12,  15, 16,     up42, unbanked },
    { 30,  12,  16, 16,     up42, unbanked }, { 31,  12,  17, 16,     up42, unbanked }, { 32,  12,  18, 16,     up42, unbanked }, { 33,  12,  18, 16,     up42, unbanked }, { 34,  12,  19, 16,     up42, unbanked },
    { 35,  12,  20, 16,     up42, unbanked }, { 36,  12,  21, 16,     up42, unbanked }, { 37,  11,  22, 16,     up42, unbanked }, { 38,  11,  23, 16,     up42, unbanked }, { 39,  11,  24, 16,     up42, unbanked },
    { 40,  11,  25, 16,     up42, unbanked }, { 41,  11,  26, 16,     up42, unbanked }, { 42,  11,  27, 16,     up60, unbanked }, { 43,  11,  28, 16,     up60, unbanked }, { 44,  11,  29, 16,     up60, unbanked },
    { 44,  11,  30, 16,     up60, unbanked }, { 45,  10,  31, 16,     up60, unbanked }, { 46,  10,  32, 16,     up60, unbanked }, { 47,  10,  33, 16,     up60, unbanked }, { 47,  10,  34, 16,     up60, unbanked },
    { 48,  10,  35, 16,     up60, unbanked }, { 49,  10,  36, 16,     up60, unbanked }, { 50,  10,  37, 16,     up60, unbanked }, { 50,  10,  38, 16,     up60, unbanked }, { 51,  10,  39, 16,     up60, unbanked },
    { 51,   9,  40, 16,     up60, unbanked }, { 52,   9,  41, 16,     up60, unbanked }, { 53,   9,  42, 16,     up60, unbanked }, { 53,   9,  43, 16,     up75, unbanked }, { 54,   9,  44, 16,     up75, unbanked },
    { 55,   9,  45, 16,     up75, unbanked }, { 55,   9,  46, 16,     up75, unbanked }, { 56,   9,  47, 16,     up75, unbanked }, { 56,   9,  48, 16,     up75, unbanked }, { 56,   8,  49, 16,     up75, unbanked },
    { 57,   8,  50, 16,     up75, unbanked }, { 57,   8,  51, 16,     up75, unbanked }, { 57,   8,  52, 16,     up75, unbanked }, { 58,   8,  53, 16,     up75, unbanked }, { 58,   8,  54, 16,     up75, unbanked },
    { 58,   8,  55, 16,     up75, unbanked }, { 59,   8,  56, 16,     up75, unbanked }, { 59,   8,  57, 16,     up75, unbanked }, { 59,   8,  58, 16,     up75, unbanked }, { 60,   7,  59, 16,     up75, unbanked },
    { 60,   7,  60, 16,     up75, unbanked }, { 60,   7,  61, 16,     up75, unbanked }, { 61,   7,  62, 16,     up75, unbanked }, { 61,   7,  63, 16,     up75, unbanked }, { 61,   7,  64, 16,     up90, unbanked },
    { 61,   7,  65, 16,     up90, unbanked }, { 62,   7,  66, 16,     up90, unbanked }, { 62,   7,  67, 16,     up90, unbanked }, { 62,   7,  68, 16,     up90, unbanked }, { 62,   6,  69, 16,     up90, unbanked },
    { 62,   6,  70, 16,     up90, unbanked }, { 63,   6,  71, 16,     up90, unbanked }, { 63,   6,  72, 16,     up90, unbanked }, { 63,   6,  73, 16,     up90, unbanked }, { 63,   6,  74, 16,     up90, unbanked },
    { 63,   6,  75, 16,     up90, unbanked }, { 63,   6,  76, 16,     up90, unbanked }, { 63,   6,  77, 16,     up90, unbanked }, { 63,   6,  78, 16,     up90, unbanked }, { 63,   6,  79, 16,     up90, unbanked },
    { 63,   5,  80, 16,     up90, unbanked }, { 63,   5,  81, 16,     up90, unbanked }, { 63,   5,  82, 16,     up90, unbanked }, { 63,   5,  83, 16,     up90, unbanked }, { 63,   5,  84, 16,     up90, unbanked },
    { 63,   5,  85, 16,     up90, unbanked }, { 63,   5,  86, 16,     up90, unbanked }, { 63,   5,  87, 16,     up90, unbanked }, { 63,   5,  88, 16,     up90, unbanked }, { 63,   5,  89, 16,     up90, unbanked },
    { 63,   5,  90, 16,     up90, unbanked }, { 63,   5,  91, 16,    up105, unbanked }, { 63,   4,  92, 16,    up105, unbanked }, { 62,   4,  93, 16,    up105, unbanked }, { 62,   4,  94, 16,    up105, unbanked },
    { 62,   4,  95, 16,    up105, unbanked }, { 62,   4,  96, 16,    up105, unbanked }, { 62,   4,  97, 16,    up105, unbanked }, { 61,   4,  98, 16,    up105, unbanked }, { 61,   4,  99, 16,    up105, unbanked },
    { 61,   4, 100, 16,    up105, unbanked }, { 61,   4, 101, 16,    up105, unbanked }, { 60,   3, 102, 16,    up105, unbanked }, { 60,   3, 103, 16,    up105, unbanked }, { 60,   3, 104, 16,    up105, unbanked },
    { 59,   3, 105, 16,    up120, unbanked }, { 59,   3, 106, 16,    up120, unbanked }, { 58,   3, 107, 16,    up120, unbanked }, { 58,   3, 108, 16,    up120, unbanked }, { 57,   3, 109, 16,    up120, unbanked },
    { 57,   3, 110, 16,    up120, unbanked }, { 57,   3, 111, 16,    up120, unbanked }, { 56,   2, 112, 16,    up120, unbanked }, { 56,   2, 113, 16,    up120, unbanked }, { 55,   2, 114, 16,    up135, unbanked },
    { 55,   2, 115, 16,    up135, unbanked }, { 54,   2, 116, 16,    up135, unbanked }, { 53,   2, 117, 16,    up135, unbanked }, { 53,   2, 118, 16,    up135, unbanked }, { 52,   2, 119, 16,    up135, unbanked },
    { 51,   2, 120, 16,    up135, unbanked }, { 50,   1, 121, 16,    up135, unbanked }, { 49,   1, 122, 16,    up150, unbanked }, { 48,   1, 123, 16,    up150, unbanked }, { 47,   1, 124, 16,    up150, unbanked },
    { 46,   1, 124, 16,    up150, unbanked }, { 45,   1, 125, 16,    up150, unbanked }, { 44,   1, 126, 16,    up165, unbanked }, { 43,   1, 127, 16,    up165, unbanked }, { 42,   0, 128, 16,    up165, unbanked },
    { 41,   0, 128, 16,    up165, unbanked }, { 40,   0, 129, 16,    up165, unbanked }, { 39,   0, 129, 16, inverted, unbanked }, { 38,   0, 129, 16, inverted, unbanked }, { 37,   0, 130, 16, inverted, unbanked },
    { 36,   0, 130, 16, inverted, unbanked }, { 35,   0, 130, 16, inverted, unbanked }, { 34,   0, 130, 16, inverted, unbanked }, { 33,   0, 130, 16, inverted, unbanked }, { 32,   0, 130, 16, inverted, unbanked },
    { 31,   0, 130, 16, inverted, unbanked }, { 30,   0, 130, 16, inverted, unbanked }, { 29,   0, 130, 16, inverted, unbanked }, { 28,   0, 130, 16, inverted, unbanked }, { 27,   0, 130, 16,  down165, unbanked },
    { 26,   0, 130, 16,  down165, unbanked }, { 25,   0, 129, 16,  down165, unbanked }, { 24,   0, 129, 16,  down165, unbanked }, { 23,   0, 129, 16,  down165, unbanked }, { 22,   0, 128, 16,  down150, unbanked },
    { 21,   0, 128, 16,  down150, unbanked }, { 20,  -1, 127, 16,  down150, unbanked }, { 19,  -1, 126, 16,  down150, unbanked }, { 18,  -1, 125, 16,  down150, unbanked }, { 17,  -1, 124, 16,  down135, unbanked },
    { 16,  -1, 124, 16,  down135, unbanked }, { 15,  -1, 123, 16,  down135, unbanked }, { 14,  -1, 122, 16,  down135, unbanked }, { 13,  -1, 121, 16,  down135, unbanked }, { 12,  -2, 120, 16,  down135, unbanked },
    { 11,  -2, 119, 16,  down135, unbanked }, { 10,  -2, 118, 16,  down135, unbanked }, { 10,  -2, 117, 16,  down120, unbanked }, {  9,  -2, 116, 16,  down120, unbanked }, {  8,  -2, 115, 16,  down120, unbanked },
    {  8,  -2, 114, 16,  down120, unbanked }, {  7,  -2, 113, 16,  down120, unbanked }, {  7,  -2, 112, 16,  down120, unbanked }, {  6,  -3, 111, 16,  down120, unbanked }, {  6,  -3, 110, 16,  down120, unbanked },
    {  6,  -3, 109, 16,  down120, unbanked }, {  5,  -3, 108, 16,  down105, unbanked }, {  5,  -3, 107, 16,  down105, unbanked }, {  4,  -3, 106, 16,  down105, unbanked }, {  4,  -3, 105, 16,  down105, unbanked },
    {  3,  -3, 104, 16,  down105, unbanked }, {  3,  -3, 103, 16,  down105, unbanked }, {  3,  -3, 102, 16,  down105, unbanked }, {  2,  -4, 101, 16,  down105, unbanked }, {  2,  -4, 100, 16,  down105, unbanked },
    {  2,  -4,  99, 16,  down105, unbanked }, {  2,  -4,  98, 16,  down105, unbanked }, {  1,  -4,  97, 16,  down105, unbanked }, {  1,  -4,  96, 16,  down105, unbanked }, {  1,  -4,  95, 16,  down105, unbanked },
    {  1,  -4,  94, 16,   down90, unbanked }, {  1,  -4,  93, 16,   down90, unbanked }, {  0,  -4,  92, 16,   down90, unbanked }, {  0,  -5,  91, 16,   down90, unbanked }, {  0,  -5,  90, 16,   down90, unbanked },
    {  0,  -5,  89, 16,   down90, unbanked }, {  0,  -5,  88, 16,   down90, unbanked }, {  0,  -5,  87, 16,   down90, unbanked }, {  0,  -5,  86, 16,   down90, unbanked }, {  0,  -5,  85, 16,   down90, unbanked },
    {  0,  -5,  84, 16,   down90, unbanked }, {  0,  -5,  83, 16,   down90, unbanked }, {  0,  -5,  82, 16,   down90, unbanked }, {  0,  -5,  81, 16,   down90, unbanked }, {  0,  -5,  80, 16,   down90, unbanked },
    {  0,  -6,  79, 16,   down90, unbanked }, {  0,  -6,  78, 16,   down90, unbanked }, {  0,  -6,  77, 16,   down90, unbanked }, {  0,  -6,  76, 16,   down90, unbanked }, {  0,  -6,  75, 16,   down90, unbanked },
    {  0,  -6,  74, 16,   down90, unbanked }, {  0,  -6,  73, 16,   down90, unbanked }, {  0,  -6,  72, 16,   down90, unbanked }, {  0,  -6,  71, 16,   down90, unbanked }, {  1,  -6,  70, 16,   down90, unbanked },
    {  1,  -6,  69, 16,   down90, unbanked }, {  1,  -7,  68, 16,   down90, unbanked }, {  1,  -7,  67, 16,   down75, unbanked }, {  1,  -7,  66, 16,   down75, unbanked }, {  2,  -7,  65, 16,   down75, unbanked },
    {  2,  -7,  64, 16,   down75, unbanked }, {  2,  -7,  63, 16,   down75, unbanked }, {  2,  -7,  62, 16,   down75, unbanked }, {  3,  -7,  61, 16,   down75, unbanked }, {  3,  -7,  60, 16,   down75, unbanked },
    {  3,  -7,  59, 16,   down75, unbanked }, {  4,  -8,  58, 16,   down75, unbanked }, {  4,  -8,  57, 16,   down75, unbanked }, {  4,  -8,  56, 16,   down75, unbanked }, {  5,  -8,  55, 16,   down75, unbanked },
    {  5,  -8,  54, 16,   down75, unbanked }, {  5,  -8,  53, 16,   down75, unbanked }, {  6,  -8,  52, 16,   down75, unbanked }, {  6,  -8,  51, 16,   down75, unbanked }, {  6,  -8,  50, 16,   down75, unbanked },
    {  7,  -8,  49, 16,   down75, unbanked }, {  7,  -9,  48, 16,   down75, unbanked }, {  7,  -9,  47, 16,   down75, unbanked }, {  8,  -9,  46, 16,   down60, unbanked }, {  8,  -9,  45, 16,   down60, unbanked },
    {  9,  -9,  44, 16,   down60, unbanked }, { 10,  -9,  43, 16,   down60, unbanked }, { 10,  -9,  42, 16,   down60, unbanked }, { 11,  -9,  41, 16,   down60, unbanked }, { 12,  -9,  40, 16,   down60, unbanked },
    { 12,  -9,  39, 16,   down60, unbanked }, { 13, -10,  38, 16,   down60, unbanked }, { 13, -10,  37, 16,   down60, unbanked }, { 14, -10,  36, 16,   down60, unbanked }, { 15, -10,  35, 16,   down60, unbanked },
    { 16, -10,  34, 16,   down60, unbanked }, { 16, -10,  33, 16,   down60, unbanked }, { 17, -10,  32, 16,   down60, unbanked }, { 18, -10,  31, 16,   down60, unbanked }, { 19, -11,  30, 16,   down42, unbanked },
    { 19, -11,  29, 16,   down42, unbanked }, { 20, -11,  28, 16,   down42, unbanked }, { 21, -11,  27, 16,   down42, unbanked }, { 22, -11,  26, 16,   down42, unbanked }, { 23, -11,  25, 16,   down42, unbanked },
    { 24, -11,  24, 16,   down42, unbanked }, { 25, -11,  23, 16,   down42, unbanked }, { 26, -11,  22, 16,   down42, unbanked }, { 27, -12,  21, 16,   down42, unbanked }, { 28, -12,  20, 16,   down42, unbanked },
    { 29, -12,  19, 16,   down42, unbanked }, { 30, -12,  18, 16,   down42, unbanked }, { 31, -12,  18, 16,   down42, unbanked }, { 32, -12,  17, 16,   down42, unbanked }, { 33, -12,  16, 16,   down42, unbanked },
    { 34, -12,  15, 16,   down42, unbanked }, { 35, -13,  15, 16,   down42, unbanked }, { 36, -13,  14, 16,   down42, unbanked }, { 37, -13,  13, 16,   down42, unbanked }, { 38, -13,  12, 16,   down42, unbanked },
    { 39, -13,  11, 16,   down42, unbanked }, { 40, -13,  11, 16,   down42, unbanked }, { 41, -13,  10, 16,   down25, unbanked }, { 42, -13,  10, 16,   down25, unbanked }, { 43, -13,   9, 16,   down25, unbanked },
    { 44, -14,   9, 16,   down25, unbanked }, { 45, -14,   8, 16,   down25, unbanked }, { 46, -14,   8, 16,   down25, unbanked }, { 47, -14,   7, 16,   down25, unbanked }, { 48, -14,   7, 16,   down25, unbanked },
    { 49, -14,   6, 16,   down25, unbanked }, { 50, -14,   6, 16,   down25, unbanked }, { 51, -14,   5, 16,   down25, unbanked }, { 52, -14,   5, 16,   down25, unbanked }, { 53, -14,   4, 16,   down25, unbanked },
    { 54, -15,   4, 16,   down25, unbanked }, { 55, -15,   3, 16,   down25, unbanked }, { 56, -15,   3, 16,   down25, unbanked }, { 57, -15,   3, 16,   down25, unbanked }, { 58, -15,   2, 16,   down25, unbanked },
    { 59, -15,   2, 16,   down25, unbanked }, { 60, -15,   1, 16,   down25, unbanked }, { 61, -15,   1, 16,   down25, unbanked }, { 62, -15,   0, 16,   down25, unbanked }, { 63, -16,   0, 16,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D9116, {
    {  16,  31,   0, 24,     up25, unbanked }, {  15,  30,   0, 24,     up25, unbanked }, {  15,  29,   1, 24,     up25, unbanked }, {  15,  28,   1, 24,     up25, unbanked }, {  15,  27,   2, 24,     up25, unbanked },
    {  15,  26,   2, 24,     up25, unbanked }, {  15,  25,   3, 24,     up25, unbanked }, {  15,  24,   3, 24,     up25, unbanked }, {  15,  23,   3, 24,     up25, unbanked }, {  15,  22,   4, 24,     up25, unbanked },
    {  14,  21,   4, 24,     up25, unbanked }, {  14,  20,   5, 24,     up25, unbanked }, {  14,  19,   5, 24,     up25, unbanked }, {  14,  18,   6, 24,     up25, unbanked }, {  14,  17,   6, 24,     up25, unbanked },
    {  14,  16,   7, 24,     up25, unbanked }, {  14,  15,   7, 24,     up25, unbanked }, {  14,  14,   8, 24,     up25, unbanked }, {  14,  13,   8, 24,     up25, unbanked }, {  14,  12,   9, 24,     up42, unbanked },
    {  13,  11,   9, 24,     up42, unbanked }, {  13,  10,  10, 24,     up42, unbanked }, {  13,   9,  10, 24,     up42, unbanked }, {  13,   8,  11, 24,     up42, unbanked }, {  13,   7,  11, 24,     up42, unbanked },
    {  13,   6,  12, 24,     up42, unbanked }, {  13,   5,  13, 24,     up42, unbanked }, {  13,   4,  14, 24,     up42, unbanked }, {  13,   3,  15, 24,     up42, unbanked }, {  12,   2,  15, 24,     up42, unbanked },
    {  12,   1,  16, 24,     up42, unbanked }, {  12,   0,  17, 24,     up42, unbanked }, {  12,  -1,  18, 24,     up42, unbanked }, {  12,  -2,  18, 24,     up42, unbanked }, {  12,  -3,  19, 24,     up42, unbanked },
    {  12,  -4,  20, 24,     up42, unbanked }, {  12,  -5,  21, 24,     up42, unbanked }, {  11,  -6,  22, 24,     up42, unbanked }, {  11,  -7,  23, 24,     up42, unbanked }, {  11,  -8,  24, 24,     up42, unbanked },
    {  11,  -9,  25, 24,     up42, unbanked }, {  11, -10,  26, 24,     up42, unbanked }, {  11, -11,  27, 24,     up60, unbanked }, {  11, -12,  28, 24,     up60, unbanked }, {  11, -13,  29, 24,     up60, unbanked },
    {  11, -13,  30, 24,     up60, unbanked }, {  10, -14,  31, 24,     up60, unbanked }, {  10, -15,  32, 24,     up60, unbanked }, {  10, -16,  33, 24,     up60, unbanked }, {  10, -16,  34, 24,     up60, unbanked },
    {  10, -17,  35, 24,     up60, unbanked }, {  10, -18,  36, 24,     up60, unbanked }, {  10, -19,  37, 24,     up60, unbanked }, {  10, -19,  38, 24,     up60, unbanked }, {  10, -20,  39, 24,     up60, unbanked },
    {   9, -20,  40, 24,     up60, unbanked }, {   9, -21,  41, 24,     up60, unbanked }, {   9, -22,  42, 24,     up60, unbanked }, {   9, -22,  43, 24,     up75, unbanked }, {   9, -23,  44, 24,     up75, unbanked },
    {   9, -24,  45, 24,     up75, unbanked }, {   9, -24,  46, 24,     up75, unbanked }, {   9, -25,  47, 24,     up75, unbanked }, {   9, -25,  48, 24,     up75, unbanked }, {   8, -25,  49, 24,     up75, unbanked },
    {   8, -26,  50, 24,     up75, unbanked }, {   8, -26,  51, 24,     up75, unbanked }, {   8, -26,  52, 24,     up75, unbanked }, {   8, -27,  53, 24,     up75, unbanked }, {   8, -27,  54, 24,     up75, unbanked },
    {   8, -27,  55, 24,     up75, unbanked }, {   8, -28,  56, 24,     up75, unbanked }, {   8, -28,  57, 24,     up75, unbanked }, {   8, -28,  58, 24,     up75, unbanked }, {   7, -29,  59, 24,     up75, unbanked },
    {   7, -29,  60, 24,     up75, unbanked }, {   7, -29,  61, 24,     up75, unbanked }, {   7, -30,  62, 24,     up75, unbanked }, {   7, -30,  63, 24,     up75, unbanked }, {   7, -30,  64, 24,     up90, unbanked },
    {   7, -30,  65, 24,     up90, unbanked }, {   7, -31,  66, 24,     up90, unbanked }, {   7, -31,  67, 24,     up90, unbanked }, {   7, -31,  68, 24,     up90, unbanked }, {   6, -31,  69, 24,     up90, unbanked },
    {   6, -31,  70, 24,     up90, unbanked }, {   6, -32,  71, 24,     up90, unbanked }, {   6, -32,  72, 24,     up90, unbanked }, {   6, -32,  73, 24,     up90, unbanked }, {   6, -32,  74, 24,     up90, unbanked },
    {   6, -32,  75, 24,     up90, unbanked }, {   6, -32,  76, 24,     up90, unbanked }, {   6, -32,  77, 24,     up90, unbanked }, {   6, -32,  78, 24,     up90, unbanked }, {   6, -32,  79, 24,     up90, unbanked },
    {   5, -32,  80, 24,     up90, unbanked }, {   5, -32,  81, 24,     up90, unbanked }, {   5, -32,  82, 24,     up90, unbanked }, {   5, -32,  83, 24,     up90, unbanked }, {   5, -32,  84, 24,     up90, unbanked },
    {   5, -32,  85, 24,     up90, unbanked }, {   5, -32,  86, 24,     up90, unbanked }, {   5, -32,  87, 24,     up90, unbanked }, {   5, -32,  88, 24,     up90, unbanked }, {   5, -32,  89, 24,     up90, unbanked },
    {   5, -32,  90, 24,     up90, unbanked }, {   5, -32,  91, 24,    up105, unbanked }, {   4, -32,  92, 24,    up105, unbanked }, {   4, -31,  93, 24,    up105, unbanked }, {   4, -31,  94, 24,    up105, unbanked },
    {   4, -31,  95, 24,    up105, unbanked }, {   4, -31,  96, 24,    up105, unbanked }, {   4, -31,  97, 24,    up105, unbanked }, {   4, -30,  98, 24,    up105, unbanked }, {   4, -30,  99, 24,    up105, unbanked },
    {   4, -30, 100, 24,    up105, unbanked }, {   4, -30, 101, 24,    up105, unbanked }, {   3, -29, 102, 24,    up105, unbanked }, {   3, -29, 103, 24,    up105, unbanked }, {   3, -29, 104, 24,    up105, unbanked },
    {   3, -28, 105, 24,    up120, unbanked }, {   3, -28, 106, 24,    up120, unbanked }, {   3, -27, 107, 24,    up120, unbanked }, {   3, -27, 108, 24,    up120, unbanked }, {   3, -26, 109, 24,    up120, unbanked },
    {   3, -26, 110, 24,    up120, unbanked }, {   3, -26, 111, 24,    up120, unbanked }, {   2, -25, 112, 24,    up120, unbanked }, {   2, -25, 113, 24,    up120, unbanked }, {   2, -24, 114, 24,    up135, unbanked },
    {   2, -24, 115, 24,    up135, unbanked }, {   2, -23, 116, 24,    up135, unbanked }, {   2, -22, 117, 24,    up135, unbanked }, {   2, -22, 118, 24,    up135, unbanked }, {   2, -21, 119, 24,    up135, unbanked },
    {   2, -20, 120, 24,    up135, unbanked }, {   1, -19, 121, 24,    up135, unbanked }, {   1, -18, 122, 24,    up150, unbanked }, {   1, -17, 123, 24,    up150, unbanked }, {   1, -16, 124, 24,    up150, unbanked },
    {   1, -15, 124, 24,    up150, unbanked }, {   1, -14, 125, 24,    up150, unbanked }, {   1, -13, 126, 24,    up165, unbanked }, {   1, -12, 127, 24,    up165, unbanked }, {   0, -11, 128, 24,    up165, unbanked },
    {   0, -10, 128, 24,    up165, unbanked }, {   0,  -9, 129, 24,    up165, unbanked }, {   0,  -8, 129, 24, inverted, unbanked }, {   0,  -7, 129, 24, inverted, unbanked }, {   0,  -6, 130, 24, inverted, unbanked },
    {   0,  -5, 130, 24, inverted, unbanked }, {   0,  -4, 130, 24, inverted, unbanked }, {   0,  -3, 130, 24, inverted, unbanked }, {   0,  -2, 130, 24, inverted, unbanked }, {   0,  -1, 130, 24, inverted, unbanked },
    {   0,   0, 130, 24, inverted, unbanked }, {   0,   1, 130, 24, inverted, unbanked }, {   0,   2, 130, 24, inverted, unbanked }, {   0,   3, 130, 24, inverted, unbanked }, {   0,   4, 130, 24,  down165, unbanked },
    {   0,   5, 130, 24,  down165, unbanked }, {   0,   6, 129, 24,  down165, unbanked }, {   0,   7, 129, 24,  down165, unbanked }, {   0,   8, 129, 24,  down165, unbanked }, {   0,   9, 128, 24,  down150, unbanked },
    {   0,  10, 128, 24,  down150, unbanked }, {  -1,  11, 127, 24,  down150, unbanked }, {  -1,  12, 126, 24,  down150, unbanked }, {  -1,  13, 125, 24,  down150, unbanked }, {  -1,  14, 124, 24,  down135, unbanked },
    {  -1,  15, 124, 24,  down135, unbanked }, {  -1,  16, 123, 24,  down135, unbanked }, {  -1,  17, 122, 24,  down135, unbanked }, {  -1,  18, 121, 24,  down135, unbanked }, {  -2,  19, 120, 24,  down135, unbanked },
    {  -2,  20, 119, 24,  down135, unbanked }, {  -2,  21, 118, 24,  down135, unbanked }, {  -2,  21, 117, 24,  down120, unbanked }, {  -2,  22, 116, 24,  down120, unbanked }, {  -2,  23, 115, 24,  down120, unbanked },
    {  -2,  23, 114, 24,  down120, unbanked }, {  -2,  24, 113, 24,  down120, unbanked }, {  -2,  24, 112, 24,  down120, unbanked }, {  -3,  25, 111, 24,  down120, unbanked }, {  -3,  25, 110, 24,  down120, unbanked },
    {  -3,  25, 109, 24,  down120, unbanked }, {  -3,  26, 108, 24,  down105, unbanked }, {  -3,  26, 107, 24,  down105, unbanked }, {  -3,  27, 106, 24,  down105, unbanked }, {  -3,  27, 105, 24,  down105, unbanked },
    {  -3,  28, 104, 24,  down105, unbanked }, {  -3,  28, 103, 24,  down105, unbanked }, {  -3,  28, 102, 24,  down105, unbanked }, {  -4,  29, 101, 24,  down105, unbanked }, {  -4,  29, 100, 24,  down105, unbanked },
    {  -4,  29,  99, 24,  down105, unbanked }, {  -4,  29,  98, 24,  down105, unbanked }, {  -4,  30,  97, 24,  down105, unbanked }, {  -4,  30,  96, 24,  down105, unbanked }, {  -4,  30,  95, 24,  down105, unbanked },
    {  -4,  30,  94, 24,   down90, unbanked }, {  -4,  30,  93, 24,   down90, unbanked }, {  -4,  31,  92, 24,   down90, unbanked }, {  -5,  31,  91, 24,   down90, unbanked }, {  -5,  31,  90, 24,   down90, unbanked },
    {  -5,  31,  89, 24,   down90, unbanked }, {  -5,  31,  88, 24,   down90, unbanked }, {  -5,  31,  87, 24,   down90, unbanked }, {  -5,  31,  86, 24,   down90, unbanked }, {  -5,  31,  85, 24,   down90, unbanked },
    {  -5,  31,  84, 24,   down90, unbanked }, {  -5,  31,  83, 24,   down90, unbanked }, {  -5,  31,  82, 24,   down90, unbanked }, {  -5,  31,  81, 24,   down90, unbanked }, {  -5,  31,  80, 24,   down90, unbanked },
    {  -6,  31,  79, 24,   down90, unbanked }, {  -6,  31,  78, 24,   down90, unbanked }, {  -6,  31,  77, 24,   down90, unbanked }, {  -6,  31,  76, 24,   down90, unbanked }, {  -6,  31,  75, 24,   down90, unbanked },
    {  -6,  31,  74, 24,   down90, unbanked }, {  -6,  31,  73, 24,   down90, unbanked }, {  -6,  31,  72, 24,   down90, unbanked }, {  -6,  31,  71, 24,   down90, unbanked }, {  -6,  30,  70, 24,   down90, unbanked },
    {  -6,  30,  69, 24,   down90, unbanked }, {  -7,  30,  68, 24,   down90, unbanked }, {  -7,  30,  67, 24,   down75, unbanked }, {  -7,  30,  66, 24,   down75, unbanked }, {  -7,  29,  65, 24,   down75, unbanked },
    {  -7,  29,  64, 24,   down75, unbanked }, {  -7,  29,  63, 24,   down75, unbanked }, {  -7,  29,  62, 24,   down75, unbanked }, {  -7,  28,  61, 24,   down75, unbanked }, {  -7,  28,  60, 24,   down75, unbanked },
    {  -7,  28,  59, 24,   down75, unbanked }, {  -8,  27,  58, 24,   down75, unbanked }, {  -8,  27,  57, 24,   down75, unbanked }, {  -8,  27,  56, 24,   down75, unbanked }, {  -8,  26,  55, 24,   down75, unbanked },
    {  -8,  26,  54, 24,   down75, unbanked }, {  -8,  26,  53, 24,   down75, unbanked }, {  -8,  25,  52, 24,   down75, unbanked }, {  -8,  25,  51, 24,   down75, unbanked }, {  -8,  25,  50, 24,   down75, unbanked },
    {  -8,  24,  49, 24,   down75, unbanked }, {  -9,  24,  48, 24,   down75, unbanked }, {  -9,  24,  47, 24,   down75, unbanked }, {  -9,  23,  46, 24,   down60, unbanked }, {  -9,  23,  45, 24,   down60, unbanked },
    {  -9,  22,  44, 24,   down60, unbanked }, {  -9,  21,  43, 24,   down60, unbanked }, {  -9,  21,  42, 24,   down60, unbanked }, {  -9,  20,  41, 24,   down60, unbanked }, {  -9,  19,  40, 24,   down60, unbanked },
    {  -9,  19,  39, 24,   down60, unbanked }, { -10,  18,  38, 24,   down60, unbanked }, { -10,  18,  37, 24,   down60, unbanked }, { -10,  17,  36, 24,   down60, unbanked }, { -10,  16,  35, 24,   down60, unbanked },
    { -10,  15,  34, 24,   down60, unbanked }, { -10,  15,  33, 24,   down60, unbanked }, { -10,  14,  32, 24,   down60, unbanked }, { -10,  13,  31, 24,   down60, unbanked }, { -11,  12,  30, 24,   down42, unbanked },
    { -11,  12,  29, 24,   down42, unbanked }, { -11,  11,  28, 24,   down42, unbanked }, { -11,  10,  27, 24,   down42, unbanked }, { -11,   9,  26, 24,   down42, unbanked }, { -11,   8,  25, 24,   down42, unbanked },
    { -11,   7,  24, 24,   down42, unbanked }, { -11,   6,  23, 24,   down42, unbanked }, { -11,   5,  22, 24,   down42, unbanked }, { -12,   4,  21, 24,   down42, unbanked }, { -12,   3,  20, 24,   down42, unbanked },
    { -12,   2,  19, 24,   down42, unbanked }, { -12,   1,  18, 24,   down42, unbanked }, { -12,   0,  18, 24,   down42, unbanked }, { -12,  -1,  17, 24,   down42, unbanked }, { -12,  -2,  16, 24,   down42, unbanked },
    { -12,  -3,  15, 24,   down42, unbanked }, { -13,  -4,  15, 24,   down42, unbanked }, { -13,  -5,  14, 24,   down42, unbanked }, { -13,  -6,  13, 24,   down42, unbanked }, { -13,  -7,  12, 24,   down42, unbanked },
    { -13,  -8,  11, 24,   down42, unbanked }, { -13,  -9,  11, 24,   down42, unbanked }, { -13, -10,  10, 24,   down25, unbanked }, { -13, -11,  10, 24,   down25, unbanked }, { -13, -12,   9, 24,   down25, unbanked },
    { -14, -13,   9, 24,   down25, unbanked }, { -14, -14,   8, 24,   down25, unbanked }, { -14, -15,   8, 24,   down25, unbanked }, { -14, -16,   7, 24,   down25, unbanked }, { -14, -17,   7, 24,   down25, unbanked },
    { -14, -18,   6, 24,   down25, unbanked }, { -14, -19,   6, 24,   down25, unbanked }, { -14, -20,   5, 24,   down25, unbanked }, { -14, -21,   5, 24,   down25, unbanked }, { -14, -22,   4, 24,   down25, unbanked },
    { -15, -23,   4, 24,   down25, unbanked }, { -15, -24,   3, 24,   down25, unbanked }, { -15, -25,   3, 24,   down25, unbanked }, { -15, -26,   3, 24,   down25, unbanked }, { -15, -27,   2, 24,   down25, unbanked },
    { -15, -28,   2, 24,   down25, unbanked }, { -15, -29,   1, 24,   down25, unbanked }, { -15, -30,   1, 24,   down25, unbanked }, { -15, -31,   0, 24,   down25, unbanked }, { -16, -32,   0, 24,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DED2E, {
    {  31,  16, 0,  0, flat, unbanked }, {  30,  16, 0,  0, flat, unbanked }, {  29,  16, 0,  0, flat, unbanked }, {  28,  16, 0,  0, flat, unbanked }, {  27,  16, 0, 31, flat, unbanked },
    {  26,  16, 0, 31, flat, unbanked }, {  25,  15, 0, 31, flat, unbanked }, {  24,  15, 0, 31, flat, unbanked }, {  23,  15, 0, 31, flat, unbanked }, {  22,  15, 0, 31, flat, unbanked },
    {  21,  15, 0, 31, flat, unbanked }, {  20,  15, 0, 31, flat, unbanked }, {  19,  14, 0, 31, flat, unbanked }, {  18,  14, 0, 30, flat, unbanked }, {  17,  14, 0, 30, flat, unbanked },
    {  16,  13, 0, 30, flat, unbanked }, {  15,  13, 0, 30, flat, unbanked }, {  14,  13, 0, 30, flat, unbanked }, {  13,  12, 0, 30, flat, unbanked }, {  12,  12, 0, 30, flat, unbanked },
    {  11,  11, 0, 30, flat, unbanked }, {  10,  11, 0, 30, flat, unbanked }, {   9,  10, 0, 30, flat, unbanked }, {   8,  10, 0, 29, flat, unbanked }, {   7,   9, 0, 29, flat, unbanked },
    {   6,   9, 0, 29, flat, unbanked }, {   5,   8, 0, 29, flat, unbanked }, {   4,   7, 0, 29, flat, unbanked }, {   3,   7, 0, 29, flat, unbanked }, {   2,   6, 0, 29, flat, unbanked },
    {   1,   5, 0, 29, flat, unbanked }, {   0,   4, 0, 29, flat, unbanked }, {  -1,   3, 0, 28, flat, unbanked }, {  -3,   3, 0, 28, flat, unbanked }, {  -4,   2, 0, 28, flat, unbanked },
    {  -5,   1, 0, 28, flat, unbanked }, {  -6,   0, 0, 28, flat, unbanked }, {  -7,  -1, 0, 27, flat, unbanked }, {  -7,  -2, 0, 27, flat, unbanked }, {  -8,  -3, 0, 27, flat, unbanked },
    {  -9,  -4, 0, 27, flat, unbanked }, {  -9,  -5, 0, 27, flat, unbanked }, { -10,  -6, 0, 27, flat, unbanked }, { -10,  -7, 0, 27, flat, unbanked }, { -11,  -8, 0, 27, flat, unbanked },
    { -11,  -9, 0, 27, flat, unbanked }, { -12, -10, 0, 26, flat, unbanked }, { -12, -11, 0, 26, flat, unbanked }, { -13, -12, 0, 26, flat, unbanked }, { -13, -13, 0, 26, flat, unbanked },
    { -13, -14, 0, 26, flat, unbanked }, { -14, -15, 0, 26, flat, unbanked }, { -14, -16, 0, 26, flat, unbanked }, { -14, -17, 0, 26, flat, unbanked }, { -15, -18, 0, 26, flat, unbanked },
    { -15, -19, 0, 26, flat, unbanked }, { -15, -20, 0, 25, flat, unbanked }, { -15, -21, 0, 25, flat, unbanked }, { -15, -22, 0, 25, flat, unbanked }, { -15, -23, 0, 25, flat, unbanked },
    { -16, -24, 0, 25, flat, unbanked }, { -16, -25, 0, 25, flat, unbanked }, { -16, -26, 0, 25, flat, unbanked }, { -16, -27, 0, 25, flat, unbanked }, { -16, -28, 0, 24, flat, unbanked },
    { -16, -29, 0, 24, flat, unbanked }, { -16, -30, 0, 24, flat, unbanked }, { -16, -31, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DEF94, {
    {  16,  0, 0, 8, flat, unbanked }, {  16,  1, 0, 8, flat, unbanked }, {  16,  2, 0, 8, flat, unbanked }, {  16,  3, 0, 8, flat, unbanked }, {  16,  4, 0, 8, flat, unbanked }, {  16,  5, 0, 7, flat, unbanked },
    {  16,  6, 0, 7, flat, unbanked }, {  15,  7, 0, 7, flat, unbanked }, {  15,  8, 0, 7, flat, unbanked }, {  15,  9, 0, 7, flat, unbanked }, {  15, 10, 0, 7, flat, unbanked }, {  15, 11, 0, 7, flat, unbanked },
    {  15, 12, 0, 7, flat, unbanked }, {  14, 13, 0, 7, flat, unbanked }, {  14, 14, 0, 6, flat, unbanked }, {  14, 15, 0, 6, flat, unbanked }, {  13, 16, 0, 6, flat, unbanked }, {  13, 17, 0, 6, flat, unbanked },
    {  13, 18, 0, 6, flat, unbanked }, {  12, 19, 0, 6, flat, unbanked }, {  12, 20, 0, 6, flat, unbanked }, {  11, 21, 0, 6, flat, unbanked }, {  11, 22, 0, 6, flat, unbanked }, {  10, 23, 0, 6, flat, unbanked },
    {  10, 24, 0, 5, flat, unbanked }, {   9, 25, 0, 5, flat, unbanked }, {   9, 26, 0, 5, flat, unbanked }, {   8, 27, 0, 5, flat, unbanked }, {   7, 28, 0, 5, flat, unbanked }, {   7, 29, 0, 5, flat, unbanked },
    {   6, 30, 0, 5, flat, unbanked }, {   5, 31, 0, 5, flat, unbanked }, {   4, 32, 0, 5, flat, unbanked }, {   3, 33, 0, 4, flat, unbanked }, {   3, 35, 0, 4, flat, unbanked }, {   2, 36, 0, 4, flat, unbanked },
    {   1, 37, 0, 4, flat, unbanked }, {   0, 38, 0, 4, flat, unbanked }, {  -1, 39, 0, 3, flat, unbanked }, {  -2, 39, 0, 3, flat, unbanked }, {  -3, 40, 0, 3, flat, unbanked }, {  -4, 41, 0, 3, flat, unbanked },
    {  -5, 41, 0, 3, flat, unbanked }, {  -6, 42, 0, 3, flat, unbanked }, {  -7, 42, 0, 3, flat, unbanked }, {  -8, 43, 0, 3, flat, unbanked }, {  -9, 43, 0, 3, flat, unbanked }, { -10, 44, 0, 2, flat, unbanked },
    { -11, 44, 0, 2, flat, unbanked }, { -12, 45, 0, 2, flat, unbanked }, { -13, 45, 0, 2, flat, unbanked }, { -14, 45, 0, 2, flat, unbanked }, { -15, 46, 0, 2, flat, unbanked }, { -16, 46, 0, 2, flat, unbanked },
    { -17, 46, 0, 2, flat, unbanked }, { -18, 47, 0, 2, flat, unbanked }, { -19, 47, 0, 2, flat, unbanked }, { -20, 47, 0, 1, flat, unbanked }, { -21, 47, 0, 1, flat, unbanked }, { -22, 47, 0, 1, flat, unbanked },
    { -23, 47, 0, 1, flat, unbanked }, { -24, 48, 0, 1, flat, unbanked }, { -25, 48, 0, 1, flat, unbanked }, { -26, 48, 0, 1, flat, unbanked }, { -27, 48, 0, 1, flat, unbanked }, { -28, 48, 0, 0, flat, unbanked },
    { -29, 48, 0, 0, flat, unbanked }, { -30, 48, 0, 0, flat, unbanked }, { -31, 48, 0, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF203, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 16, flat, unbanked }, {  4, 16, 0, 16, flat, unbanked }, {  5, 16, 0, 15, flat, unbanked },
    {  6, 16, 0, 15, flat, unbanked }, {  7, 17, 0, 15, flat, unbanked }, {  8, 17, 0, 15, flat, unbanked }, {  9, 17, 0, 15, flat, unbanked }, { 10, 17, 0, 15, flat, unbanked }, { 11, 17, 0, 15, flat, unbanked },
    { 12, 17, 0, 15, flat, unbanked }, { 13, 18, 0, 15, flat, unbanked }, { 14, 18, 0, 14, flat, unbanked }, { 15, 18, 0, 14, flat, unbanked }, { 16, 19, 0, 14, flat, unbanked }, { 17, 19, 0, 14, flat, unbanked },
    { 18, 19, 0, 14, flat, unbanked }, { 19, 20, 0, 14, flat, unbanked }, { 20, 20, 0, 14, flat, unbanked }, { 21, 21, 0, 14, flat, unbanked }, { 22, 21, 0, 14, flat, unbanked }, { 23, 22, 0, 14, flat, unbanked },
    { 24, 22, 0, 13, flat, unbanked }, { 25, 23, 0, 13, flat, unbanked }, { 26, 23, 0, 13, flat, unbanked }, { 27, 24, 0, 13, flat, unbanked }, { 28, 25, 0, 13, flat, unbanked }, { 29, 25, 0, 13, flat, unbanked },
    { 30, 26, 0, 13, flat, unbanked }, { 31, 27, 0, 13, flat, unbanked }, { 32, 28, 0, 13, flat, unbanked }, { 33, 29, 0, 12, flat, unbanked }, { 35, 29, 0, 12, flat, unbanked }, { 36, 30, 0, 12, flat, unbanked },
    { 37, 31, 0, 12, flat, unbanked }, { 38, 32, 0, 12, flat, unbanked }, { 39, 33, 0, 11, flat, unbanked }, { 39, 34, 0, 11, flat, unbanked }, { 40, 35, 0, 11, flat, unbanked }, { 41, 36, 0, 11, flat, unbanked },
    { 41, 37, 0, 11, flat, unbanked }, { 42, 38, 0, 11, flat, unbanked }, { 42, 39, 0, 11, flat, unbanked }, { 43, 40, 0, 11, flat, unbanked }, { 43, 41, 0, 11, flat, unbanked }, { 44, 42, 0, 10, flat, unbanked },
    { 44, 43, 0, 10, flat, unbanked }, { 45, 44, 0, 10, flat, unbanked }, { 45, 45, 0, 10, flat, unbanked }, { 45, 46, 0, 10, flat, unbanked }, { 46, 47, 0, 10, flat, unbanked }, { 46, 48, 0, 10, flat, unbanked },
    { 46, 49, 0, 10, flat, unbanked }, { 47, 50, 0, 10, flat, unbanked }, { 47, 51, 0, 10, flat, unbanked }, { 47, 52, 0,  9, flat, unbanked }, { 47, 53, 0,  9, flat, unbanked }, { 47, 54, 0,  9, flat, unbanked },
    { 47, 55, 0,  9, flat, unbanked }, { 48, 56, 0,  9, flat, unbanked }, { 48, 57, 0,  9, flat, unbanked }, { 48, 58, 0,  9, flat, unbanked }, { 48, 59, 0,  9, flat, unbanked }, { 48, 60, 0,  8, flat, unbanked },
    { 48, 61, 0,  8, flat, unbanked }, { 48, 62, 0,  8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF469, {
    { 16,  31, 0, 24, flat, unbanked }, { 16,  30, 0, 24, flat, unbanked }, { 16,  29, 0, 24, flat, unbanked }, { 16,  28, 0, 24, flat, unbanked }, { 16,  27, 0, 23, flat, unbanked },
    { 16,  26, 0, 23, flat, unbanked }, { 17,  25, 0, 23, flat, unbanked }, { 17,  24, 0, 23, flat, unbanked }, { 17,  23, 0, 23, flat, unbanked }, { 17,  22, 0, 23, flat, unbanked },
    { 17,  21, 0, 23, flat, unbanked }, { 17,  20, 0, 23, flat, unbanked }, { 18,  19, 0, 23, flat, unbanked }, { 18,  18, 0, 22, flat, unbanked }, { 18,  17, 0, 22, flat, unbanked },
    { 19,  16, 0, 22, flat, unbanked }, { 19,  15, 0, 22, flat, unbanked }, { 19,  14, 0, 22, flat, unbanked }, { 20,  13, 0, 22, flat, unbanked }, { 20,  12, 0, 22, flat, unbanked },
    { 21,  11, 0, 22, flat, unbanked }, { 21,  10, 0, 22, flat, unbanked }, { 22,   9, 0, 22, flat, unbanked }, { 22,   8, 0, 21, flat, unbanked }, { 23,   7, 0, 21, flat, unbanked },
    { 23,   6, 0, 21, flat, unbanked }, { 24,   5, 0, 21, flat, unbanked }, { 25,   4, 0, 21, flat, unbanked }, { 25,   3, 0, 21, flat, unbanked }, { 26,   2, 0, 21, flat, unbanked },
    { 27,   1, 0, 21, flat, unbanked }, { 28,   0, 0, 21, flat, unbanked }, { 29,  -1, 0, 20, flat, unbanked }, { 29,  -3, 0, 20, flat, unbanked }, { 30,  -4, 0, 20, flat, unbanked },
    { 31,  -5, 0, 20, flat, unbanked }, { 32,  -6, 0, 20, flat, unbanked }, { 33,  -7, 0, 19, flat, unbanked }, { 34,  -7, 0, 19, flat, unbanked }, { 35,  -8, 0, 19, flat, unbanked },
    { 36,  -9, 0, 19, flat, unbanked }, { 37,  -9, 0, 19, flat, unbanked }, { 38, -10, 0, 19, flat, unbanked }, { 39, -10, 0, 19, flat, unbanked }, { 40, -11, 0, 19, flat, unbanked },
    { 41, -11, 0, 19, flat, unbanked }, { 42, -12, 0, 18, flat, unbanked }, { 43, -12, 0, 18, flat, unbanked }, { 44, -13, 0, 18, flat, unbanked }, { 45, -13, 0, 18, flat, unbanked },
    { 46, -13, 0, 18, flat, unbanked }, { 47, -14, 0, 18, flat, unbanked }, { 48, -14, 0, 18, flat, unbanked }, { 49, -14, 0, 18, flat, unbanked }, { 50, -15, 0, 18, flat, unbanked },
    { 51, -15, 0, 18, flat, unbanked }, { 52, -15, 0, 17, flat, unbanked }, { 53, -15, 0, 17, flat, unbanked }, { 54, -15, 0, 17, flat, unbanked }, { 55, -15, 0, 17, flat, unbanked },
    { 56, -16, 0, 17, flat, unbanked }, { 57, -16, 0, 17, flat, unbanked }, { 58, -16, 0, 17, flat, unbanked }, { 59, -16, 0, 17, flat, unbanked }, { 60, -16, 0, 16, flat, unbanked },
    { 61, -16, 0, 16, flat, unbanked }, { 62, -16, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF6C6, {
    {  31, 16, 0, 0, flat, unbanked }, {  30, 16, 0, 0, flat, unbanked }, {  29, 16, 0, 0, flat, unbanked }, {  28, 16, 0, 0, flat, unbanked }, {  27, 16, 0, 1, flat, unbanked }, {  26, 16, 0, 1, flat, unbanked },
    {  25, 17, 0, 1, flat, unbanked }, {  24, 17, 0, 1, flat, unbanked }, {  23, 17, 0, 1, flat, unbanked }, {  22, 17, 0, 1, flat, unbanked }, {  21, 17, 0, 1, flat, unbanked }, {  20, 17, 0, 1, flat, unbanked },
    {  19, 18, 0, 1, flat, unbanked }, {  18, 18, 0, 2, flat, unbanked }, {  17, 18, 0, 2, flat, unbanked }, {  16, 19, 0, 2, flat, unbanked }, {  15, 19, 0, 2, flat, unbanked }, {  14, 19, 0, 2, flat, unbanked },
    {  13, 20, 0, 2, flat, unbanked }, {  12, 20, 0, 2, flat, unbanked }, {  11, 21, 0, 2, flat, unbanked }, {  10, 21, 0, 2, flat, unbanked }, {   9, 22, 0, 2, flat, unbanked }, {   8, 22, 0, 3, flat, unbanked },
    {   7, 23, 0, 3, flat, unbanked }, {   6, 23, 0, 3, flat, unbanked }, {   5, 24, 0, 3, flat, unbanked }, {   4, 25, 0, 3, flat, unbanked }, {   3, 25, 0, 3, flat, unbanked }, {   2, 26, 0, 3, flat, unbanked },
    {   1, 27, 0, 3, flat, unbanked }, {   0, 28, 0, 3, flat, unbanked }, {  -1, 29, 0, 4, flat, unbanked }, {  -3, 29, 0, 4, flat, unbanked }, {  -4, 30, 0, 4, flat, unbanked }, {  -5, 31, 0, 4, flat, unbanked },
    {  -6, 32, 0, 4, flat, unbanked }, {  -7, 33, 0, 5, flat, unbanked }, {  -7, 34, 0, 5, flat, unbanked }, {  -8, 35, 0, 5, flat, unbanked }, {  -9, 36, 0, 5, flat, unbanked }, {  -9, 37, 0, 5, flat, unbanked },
    { -10, 38, 0, 5, flat, unbanked }, { -10, 39, 0, 5, flat, unbanked }, { -11, 40, 0, 5, flat, unbanked }, { -11, 41, 0, 5, flat, unbanked }, { -12, 42, 0, 6, flat, unbanked }, { -12, 43, 0, 6, flat, unbanked },
    { -13, 44, 0, 6, flat, unbanked }, { -13, 45, 0, 6, flat, unbanked }, { -13, 46, 0, 6, flat, unbanked }, { -14, 47, 0, 6, flat, unbanked }, { -14, 48, 0, 6, flat, unbanked }, { -14, 49, 0, 6, flat, unbanked },
    { -15, 50, 0, 6, flat, unbanked }, { -15, 51, 0, 6, flat, unbanked }, { -15, 52, 0, 7, flat, unbanked }, { -15, 53, 0, 7, flat, unbanked }, { -15, 54, 0, 7, flat, unbanked }, { -15, 55, 0, 7, flat, unbanked },
    { -16, 56, 0, 7, flat, unbanked }, { -16, 57, 0, 7, flat, unbanked }, { -16, 58, 0, 7, flat, unbanked }, { -16, 59, 0, 7, flat, unbanked }, { -16, 60, 0, 8, flat, unbanked }, { -16, 61, 0, 8, flat, unbanked },
    { -16, 62, 0, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF923, {
    { 16,  0, 0,  8, flat, unbanked }, { 16,  1, 0,  8, flat, unbanked }, { 16,  2, 0,  8, flat, unbanked }, { 16,  3, 0,  8, flat, unbanked }, { 16,  4, 0,  8, flat, unbanked }, { 16,  5, 0,  9, flat, unbanked },
    { 16,  6, 0,  9, flat, unbanked }, { 17,  7, 0,  9, flat, unbanked }, { 17,  8, 0,  9, flat, unbanked }, { 17,  9, 0,  9, flat, unbanked }, { 17, 10, 0,  9, flat, unbanked }, { 17, 11, 0,  9, flat, unbanked },
    { 17, 12, 0,  9, flat, unbanked }, { 18, 13, 0,  9, flat, unbanked }, { 18, 14, 0, 10, flat, unbanked }, { 18, 15, 0, 10, flat, unbanked }, { 19, 16, 0, 10, flat, unbanked }, { 19, 17, 0, 10, flat, unbanked },
    { 19, 18, 0, 10, flat, unbanked }, { 20, 19, 0, 10, flat, unbanked }, { 20, 20, 0, 10, flat, unbanked }, { 21, 21, 0, 10, flat, unbanked }, { 21, 22, 0, 10, flat, unbanked }, { 22, 23, 0, 10, flat, unbanked },
    { 22, 24, 0, 11, flat, unbanked }, { 23, 25, 0, 11, flat, unbanked }, { 23, 26, 0, 11, flat, unbanked }, { 24, 27, 0, 11, flat, unbanked }, { 25, 28, 0, 11, flat, unbanked }, { 25, 29, 0, 11, flat, unbanked },
    { 26, 30, 0, 11, flat, unbanked }, { 27, 31, 0, 11, flat, unbanked }, { 28, 32, 0, 11, flat, unbanked }, { 29, 33, 0, 12, flat, unbanked }, { 29, 35, 0, 12, flat, unbanked }, { 30, 36, 0, 12, flat, unbanked },
    { 31, 37, 0, 12, flat, unbanked }, { 32, 38, 0, 12, flat, unbanked }, { 33, 39, 0, 13, flat, unbanked }, { 34, 39, 0, 13, flat, unbanked }, { 35, 40, 0, 13, flat, unbanked }, { 36, 41, 0, 13, flat, unbanked },
    { 37, 41, 0, 13, flat, unbanked }, { 38, 42, 0, 13, flat, unbanked }, { 39, 42, 0, 13, flat, unbanked }, { 40, 43, 0, 13, flat, unbanked }, { 41, 43, 0, 13, flat, unbanked }, { 42, 44, 0, 14, flat, unbanked },
    { 43, 44, 0, 14, flat, unbanked }, { 44, 45, 0, 14, flat, unbanked }, { 45, 45, 0, 14, flat, unbanked }, { 46, 45, 0, 14, flat, unbanked }, { 47, 46, 0, 14, flat, unbanked }, { 48, 46, 0, 14, flat, unbanked },
    { 49, 46, 0, 14, flat, unbanked }, { 50, 47, 0, 14, flat, unbanked }, { 51, 47, 0, 14, flat, unbanked }, { 52, 47, 0, 15, flat, unbanked }, { 53, 47, 0, 15, flat, unbanked }, { 54, 47, 0, 15, flat, unbanked },
    { 55, 47, 0, 15, flat, unbanked }, { 56, 48, 0, 15, flat, unbanked }, { 57, 48, 0, 15, flat, unbanked }, { 58, 48, 0, 15, flat, unbanked }, { 59, 48, 0, 15, flat, unbanked }, { 60, 48, 0, 16, flat, unbanked },
    { 61, 48, 0, 16, flat, unbanked }, { 62, 48, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DFB89, {
    {  0,  16, 0, 16, flat, unbanked }, {  1,  16, 0, 16, flat, unbanked }, {  2,  16, 0, 16, flat, unbanked }, {  3,  16, 0, 16, flat, unbanked }, {  4,  16, 0, 16, flat, unbanked },
    {  5,  16, 0, 17, flat, unbanked }, {  6,  16, 0, 17, flat, unbanked }, {  7,  15, 0, 17, flat, unbanked }, {  8,  15, 0, 17, flat, unbanked }, {  9,  15, 0, 17, flat, unbanked },
    { 10,  15, 0, 17, flat, unbanked }, { 11,  15, 0, 17, flat, unbanked }, { 12,  15, 0, 17, flat, unbanked }, { 13,  14, 0, 17, flat, unbanked }, { 14,  14, 0, 18, flat, unbanked },
    { 15,  14, 0, 18, flat, unbanked }, { 16,  13, 0, 18, flat, unbanked }, { 17,  13, 0, 18, flat, unbanked }, { 18,  13, 0, 18, flat, unbanked }, { 19,  12, 0, 18, flat, unbanked },
    { 20,  12, 0, 18, flat, unbanked }, { 21,  11, 0, 18, flat, unbanked }, { 22,  11, 0, 18, flat, unbanked }, { 23,  10, 0, 18, flat, unbanked }, { 24,  10, 0, 19, flat, unbanked },
    { 25,   9, 0, 19, flat, unbanked }, { 26,   9, 0, 19, flat, unbanked }, { 27,   8, 0, 19, flat, unbanked }, { 28,   7, 0, 19, flat, unbanked }, { 29,   7, 0, 19, flat, unbanked },
    { 30,   6, 0, 19, flat, unbanked }, { 31,   5, 0, 19, flat, unbanked }, { 32,   4, 0, 19, flat, unbanked }, { 33,   3, 0, 20, flat, unbanked }, { 35,   3, 0, 20, flat, unbanked },
    { 36,   2, 0, 20, flat, unbanked }, { 37,   1, 0, 20, flat, unbanked }, { 38,   0, 0, 20, flat, unbanked }, { 39,  -1, 0, 21, flat, unbanked }, { 39,  -2, 0, 21, flat, unbanked },
    { 40,  -3, 0, 21, flat, unbanked }, { 41,  -4, 0, 21, flat, unbanked }, { 41,  -5, 0, 21, flat, unbanked }, { 42,  -6, 0, 21, flat, unbanked }, { 42,  -7, 0, 21, flat, unbanked },
    { 43,  -8, 0, 21, flat, unbanked }, { 43,  -9, 0, 21, flat, unbanked }, { 44, -10, 0, 22, flat, unbanked }, { 44, -11, 0, 22, flat, unbanked }, { 45, -12, 0, 22, flat, unbanked },
    { 45, -13, 0, 22, flat, unbanked }, { 45, -14, 0, 22, flat, unbanked }, { 46, -15, 0, 22, flat, unbanked }, { 46, -16, 0, 22, flat, unbanked }, { 46, -17, 0, 22, flat, unbanked },
    { 47, -18, 0, 22, flat, unbanked }, { 47, -19, 0, 22, flat, unbanked }, { 47, -20, 0, 23, flat, unbanked }, { 47, -21, 0, 23, flat, unbanked }, { 47, -22, 0, 23, flat, unbanked },
    { 47, -23, 0, 23, flat, unbanked }, { 48, -24, 0, 23, flat, unbanked }, { 48, -25, 0, 23, flat, unbanked }, { 48, -26, 0, 23, flat, unbanked }, { 48, -27, 0, 23, flat, unbanked },
    { 48, -28, 0, 24, flat, unbanked }, { 48, -29, 0, 24, flat, unbanked }, { 48, -30, 0, 24, flat, unbanked }, { 48, -31, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DFDF8, {
    {  16,  31, 0, 24, flat, unbanked }, {  16,  30, 0, 24, flat, unbanked }, {  16,  29, 0, 24, flat, unbanked }, {  16,  28, 0, 24, flat, unbanked }, {  16,  27, 0, 25, flat, unbanked },
    {  16,  26, 0, 25, flat, unbanked }, {  15,  25, 0, 25, flat, unbanked }, {  15,  24, 0, 25, flat, unbanked }, {  15,  23, 0, 25, flat, unbanked }, {  15,  22, 0, 25, flat, unbanked },
    {  15,  21, 0, 25, flat, unbanked }, {  15,  20, 0, 25, flat, unbanked }, {  14,  19, 0, 25, flat, unbanked }, {  14,  18, 0, 26, flat, unbanked }, {  14,  17, 0, 26, flat, unbanked },
    {  13,  16, 0, 26, flat, unbanked }, {  13,  15, 0, 26, flat, unbanked }, {  13,  14, 0, 26, flat, unbanked }, {  12,  13, 0, 26, flat, unbanked }, {  12,  12, 0, 26, flat, unbanked },
    {  11,  11, 0, 26, flat, unbanked }, {  11,  10, 0, 26, flat, unbanked }, {  10,   9, 0, 26, flat, unbanked }, {  10,   8, 0, 27, flat, unbanked }, {   9,   7, 0, 27, flat, unbanked },
    {   9,   6, 0, 27, flat, unbanked }, {   8,   5, 0, 27, flat, unbanked }, {   7,   4, 0, 27, flat, unbanked }, {   7,   3, 0, 27, flat, unbanked }, {   6,   2, 0, 27, flat, unbanked },
    {   5,   1, 0, 27, flat, unbanked }, {   4,   0, 0, 27, flat, unbanked }, {   3,  -1, 0, 28, flat, unbanked }, {   3,  -3, 0, 28, flat, unbanked }, {   2,  -4, 0, 28, flat, unbanked },
    {   1,  -5, 0, 28, flat, unbanked }, {   0,  -6, 0, 28, flat, unbanked }, {  -1,  -7, 0, 29, flat, unbanked }, {  -2,  -7, 0, 29, flat, unbanked }, {  -3,  -8, 0, 29, flat, unbanked },
    {  -4,  -9, 0, 29, flat, unbanked }, {  -5,  -9, 0, 29, flat, unbanked }, {  -6, -10, 0, 29, flat, unbanked }, {  -7, -10, 0, 29, flat, unbanked }, {  -8, -11, 0, 29, flat, unbanked },
    {  -9, -11, 0, 29, flat, unbanked }, { -10, -12, 0, 30, flat, unbanked }, { -11, -12, 0, 30, flat, unbanked }, { -12, -13, 0, 30, flat, unbanked }, { -13, -13, 0, 30, flat, unbanked },
    { -14, -13, 0, 30, flat, unbanked }, { -15, -14, 0, 30, flat, unbanked }, { -16, -14, 0, 30, flat, unbanked }, { -17, -14, 0, 30, flat, unbanked }, { -18, -15, 0, 30, flat, unbanked },
    { -19, -15, 0, 30, flat, unbanked }, { -20, -15, 0, 31, flat, unbanked }, { -21, -15, 0, 31, flat, unbanked }, { -22, -15, 0, 31, flat, unbanked }, { -23, -15, 0, 31, flat, unbanked },
    { -24, -16, 0, 31, flat, unbanked }, { -25, -16, 0, 31, flat, unbanked }, { -26, -16, 0, 31, flat, unbanked }, { -27, -16, 0, 31, flat, unbanked }, { -28, -16, 0,  0, flat, unbanked },
    { -29, -16, 0,  0, flat, unbanked }, { -30, -16, 0,  0, flat, unbanked }, { -31, -16, 0,  0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E005E, {
    {  31,  16, 0,  0, flat, left45 }, {  30,  16, 0,  0, flat, left45 }, {  29,  16, 0,  0, flat, left45 }, {  28,  16, 0,  0, flat, left45 }, {  27,  16, 0, 31, flat, left45 }, {  26,  16, 0, 31, flat, left45 },
    {  25,  15, 0, 31, flat, left45 }, {  24,  15, 0, 31, flat, left45 }, {  23,  15, 0, 31, flat, left45 }, {  22,  15, 0, 31, flat, left45 }, {  21,  15, 0, 31, flat, left45 }, {  20,  15, 0, 31, flat, left45 },
    {  19,  14, 0, 31, flat, left45 }, {  18,  14, 0, 30, flat, left45 }, {  17,  14, 0, 30, flat, left45 }, {  16,  13, 0, 30, flat, left45 }, {  15,  13, 0, 30, flat, left45 }, {  14,  13, 0, 30, flat, left45 },
    {  13,  12, 0, 30, flat, left45 }, {  12,  12, 0, 30, flat, left45 }, {  11,  11, 0, 30, flat, left45 }, {  10,  11, 0, 30, flat, left45 }, {   9,  10, 0, 30, flat, left45 }, {   8,  10, 0, 29, flat, left45 },
    {   7,   9, 0, 29, flat, left45 }, {   6,   9, 0, 29, flat, left45 }, {   5,   8, 0, 29, flat, left45 }, {   4,   7, 0, 29, flat, left45 }, {   3,   7, 0, 29, flat, left45 }, {   2,   6, 0, 29, flat, left45 },
    {   1,   5, 0, 29, flat, left45 }, {   0,   4, 0, 29, flat, left45 }, {  -1,   3, 0, 28, flat, left45 }, {  -3,   3, 0, 28, flat, left45 }, {  -4,   2, 0, 28, flat, left45 }, {  -5,   1, 0, 28, flat, left45 },
    {  -6,   0, 0, 28, flat, left45 }, {  -7,  -1, 0, 27, flat, left45 }, {  -7,  -2, 0, 27, flat, left45 }, {  -8,  -3, 0, 27, flat, left45 }, {  -9,  -4, 0, 27, flat, left45 }, {  -9,  -5, 0, 27, flat, left45 },
    { -10,  -6, 0, 27, flat, left45 }, { -10,  -7, 0, 27, flat, left45 }, { -11,  -8, 0, 27, flat, left45 }, { -11,  -9, 0, 27, flat, left45 }, { -12, -10, 0, 26, flat, left45 }, { -12, -11, 0, 26, flat, left45 },
    { -13, -12, 0, 26, flat, left45 }, { -13, -13, 0, 26, flat, left45 }, { -13, -14, 0, 26, flat, left45 }, { -14, -15, 0, 26, flat, left45 }, { -14, -16, 0, 26, flat, left45 }, { -14, -17, 0, 26, flat, left45 },
    { -15, -18, 0, 26, flat, left45 }, { -15, -19, 0, 26, flat, left45 }, { -15, -20, 0, 25, flat, left45 }, { -15, -21, 0, 25, flat, left45 }, { -15, -22, 0, 25, flat, left45 }, { -15, -23, 0, 25, flat, left45 },
    { -16, -24, 0, 25, flat, left45 }, { -16, -25, 0, 25, flat, left45 }, { -16, -26, 0, 25, flat, left45 }, { -16, -27, 0, 25, flat, left45 }, { -16, -28, 0, 24, flat, left45 }, { -16, -29, 0, 24, flat, left45 },
    { -16, -30, 0, 24, flat, left45 }, { -16, -31, 0, 24, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E02C4, {
    {  16,  0, 0, 8, flat, left45 }, {  16,  1, 0, 8, flat, left45 }, {  16,  2, 0, 8, flat, left45 }, {  16,  3, 0, 8, flat, left45 }, {  16,  4, 0, 8, flat, left45 }, {  16,  5, 0, 7, flat, left45 },
    {  16,  6, 0, 7, flat, left45 }, {  15,  7, 0, 7, flat, left45 }, {  15,  8, 0, 7, flat, left45 }, {  15,  9, 0, 7, flat, left45 }, {  15, 10, 0, 7, flat, left45 }, {  15, 11, 0, 7, flat, left45 },
    {  15, 12, 0, 7, flat, left45 }, {  14, 13, 0, 7, flat, left45 }, {  14, 14, 0, 6, flat, left45 }, {  14, 15, 0, 6, flat, left45 }, {  13, 16, 0, 6, flat, left45 }, {  13, 17, 0, 6, flat, left45 },
    {  13, 18, 0, 6, flat, left45 }, {  12, 19, 0, 6, flat, left45 }, {  12, 20, 0, 6, flat, left45 }, {  11, 21, 0, 6, flat, left45 }, {  11, 22, 0, 6, flat, left45 }, {  10, 23, 0, 6, flat, left45 },
    {  10, 24, 0, 5, flat, left45 }, {   9, 25, 0, 5, flat, left45 }, {   9, 26, 0, 5, flat, left45 }, {   8, 27, 0, 5, flat, left45 }, {   7, 28, 0, 5, flat, left45 }, {   7, 29, 0, 5, flat, left45 },
    {   6, 30, 0, 5, flat, left45 }, {   5, 31, 0, 5, flat, left45 }, {   4, 32, 0, 5, flat, left45 }, {   3, 33, 0, 4, flat, left45 }, {   3, 35, 0, 4, flat, left45 }, {   2, 36, 0, 4, flat, left45 },
    {   1, 37, 0, 4, flat, left45 }, {   0, 38, 0, 4, flat, left45 }, {  -1, 39, 0, 3, flat, left45 }, {  -2, 39, 0, 3, flat, left45 }, {  -3, 40, 0, 3, flat, left45 }, {  -4, 41, 0, 3, flat, left45 },
    {  -5, 41, 0, 3, flat, left45 }, {  -6, 42, 0, 3, flat, left45 }, {  -7, 42, 0, 3, flat, left45 }, {  -8, 43, 0, 3, flat, left45 }, {  -9, 43, 0, 3, flat, left45 }, { -10, 44, 0, 2, flat, left45 },
    { -11, 44, 0, 2, flat, left45 }, { -12, 45, 0, 2, flat, left45 }, { -13, 45, 0, 2, flat, left45 }, { -14, 45, 0, 2, flat, left45 }, { -15, 46, 0, 2, flat, left45 }, { -16, 46, 0, 2, flat, left45 },
    { -17, 46, 0, 2, flat, left45 }, { -18, 47, 0, 2, flat, left45 }, { -19, 47, 0, 2, flat, left45 }, { -20, 47, 0, 1, flat, left45 }, { -21, 47, 0, 1, flat, left45 }, { -22, 47, 0, 1, flat, left45 },
    { -23, 47, 0, 1, flat, left45 }, { -24, 48, 0, 1, flat, left45 }, { -25, 48, 0, 1, flat, left45 }, { -26, 48, 0, 1, flat, left45 }, { -27, 48, 0, 1, flat, left45 }, { -28, 48, 0, 0, flat, left45 },
    { -29, 48, 0, 0, flat, left45 }, { -30, 48, 0, 0, flat, left45 }, { -31, 48, 0, 0, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0533, {
    {  0, 16, 0, 16, flat, left45 }, {  1, 16, 0, 16, flat, left45 }, {  2, 16, 0, 16, flat, left45 }, {  3, 16, 0, 16, flat, left45 }, {  4, 16, 0, 16, flat, left45 }, {  5, 16, 0, 15, flat, left45 },
    {  6, 16, 0, 15, flat, left45 }, {  7, 17, 0, 15, flat, left45 }, {  8, 17, 0, 15, flat, left45 }, {  9, 17, 0, 15, flat, left45 }, { 10, 17, 0, 15, flat, left45 }, { 11, 17, 0, 15, flat, left45 },
    { 12, 17, 0, 15, flat, left45 }, { 13, 18, 0, 15, flat, left45 }, { 14, 18, 0, 14, flat, left45 }, { 15, 18, 0, 14, flat, left45 }, { 16, 19, 0, 14, flat, left45 }, { 17, 19, 0, 14, flat, left45 },
    { 18, 19, 0, 14, flat, left45 }, { 19, 20, 0, 14, flat, left45 }, { 20, 20, 0, 14, flat, left45 }, { 21, 21, 0, 14, flat, left45 }, { 22, 21, 0, 14, flat, left45 }, { 23, 22, 0, 14, flat, left45 },
    { 24, 22, 0, 13, flat, left45 }, { 25, 23, 0, 13, flat, left45 }, { 26, 23, 0, 13, flat, left45 }, { 27, 24, 0, 13, flat, left45 }, { 28, 25, 0, 13, flat, left45 }, { 29, 25, 0, 13, flat, left45 },
    { 30, 26, 0, 13, flat, left45 }, { 31, 27, 0, 13, flat, left45 }, { 32, 28, 0, 13, flat, left45 }, { 33, 29, 0, 12, flat, left45 }, { 35, 29, 0, 12, flat, left45 }, { 36, 30, 0, 12, flat, left45 },
    { 37, 31, 0, 12, flat, left45 }, { 38, 32, 0, 12, flat, left45 }, { 39, 33, 0, 11, flat, left45 }, { 39, 34, 0, 11, flat, left45 }, { 40, 35, 0, 11, flat, left45 }, { 41, 36, 0, 11, flat, left45 },
    { 41, 37, 0, 11, flat, left45 }, { 42, 38, 0, 11, flat, left45 }, { 42, 39, 0, 11, flat, left45 }, { 43, 40, 0, 11, flat, left45 }, { 43, 41, 0, 11, flat, left45 }, { 44, 42, 0, 10, flat, left45 },
    { 44, 43, 0, 10, flat, left45 }, { 45, 44, 0, 10, flat, left45 }, { 45, 45, 0, 10, flat, left45 }, { 45, 46, 0, 10, flat, left45 }, { 46, 47, 0, 10, flat, left45 }, { 46, 48, 0, 10, flat, left45 },
    { 46, 49, 0, 10, flat, left45 }, { 47, 50, 0, 10, flat, left45 }, { 47, 51, 0, 10, flat, left45 }, { 47, 52, 0,  9, flat, left45 }, { 47, 53, 0,  9, flat, left45 }, { 47, 54, 0,  9, flat, left45 },
    { 47, 55, 0,  9, flat, left45 }, { 48, 56, 0,  9, flat, left45 }, { 48, 57, 0,  9, flat, left45 }, { 48, 58, 0,  9, flat, left45 }, { 48, 59, 0,  9, flat, left45 }, { 48, 60, 0,  8, flat, left45 },
    { 48, 61, 0,  8, flat, left45 }, { 48, 62, 0,  8, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0799, {
    { 16,  31, 0, 24, flat, left45 }, { 16,  30, 0, 24, flat, left45 }, { 16,  29, 0, 24, flat, left45 }, { 16,  28, 0, 24, flat, left45 }, { 16,  27, 0, 23, flat, left45 }, { 16,  26, 0, 23, flat, left45 },
    { 17,  25, 0, 23, flat, left45 }, { 17,  24, 0, 23, flat, left45 }, { 17,  23, 0, 23, flat, left45 }, { 17,  22, 0, 23, flat, left45 }, { 17,  21, 0, 23, flat, left45 }, { 17,  20, 0, 23, flat, left45 },
    { 18,  19, 0, 23, flat, left45 }, { 18,  18, 0, 22, flat, left45 }, { 18,  17, 0, 22, flat, left45 }, { 19,  16, 0, 22, flat, left45 }, { 19,  15, 0, 22, flat, left45 }, { 19,  14, 0, 22, flat, left45 },
    { 20,  13, 0, 22, flat, left45 }, { 20,  12, 0, 22, flat, left45 }, { 21,  11, 0, 22, flat, left45 }, { 21,  10, 0, 22, flat, left45 }, { 22,   9, 0, 22, flat, left45 }, { 22,   8, 0, 21, flat, left45 },
    { 23,   7, 0, 21, flat, left45 }, { 23,   6, 0, 21, flat, left45 }, { 24,   5, 0, 21, flat, left45 }, { 25,   4, 0, 21, flat, left45 }, { 25,   3, 0, 21, flat, left45 }, { 26,   2, 0, 21, flat, left45 },
    { 27,   1, 0, 21, flat, left45 }, { 28,   0, 0, 21, flat, left45 }, { 29,  -1, 0, 20, flat, left45 }, { 29,  -3, 0, 20, flat, left45 }, { 30,  -4, 0, 20, flat, left45 }, { 31,  -5, 0, 20, flat, left45 },
    { 32,  -6, 0, 20, flat, left45 }, { 33,  -7, 0, 19, flat, left45 }, { 34,  -7, 0, 19, flat, left45 }, { 35,  -8, 0, 19, flat, left45 }, { 36,  -9, 0, 19, flat, left45 }, { 37,  -9, 0, 19, flat, left45 },
    { 38, -10, 0, 19, flat, left45 }, { 39, -10, 0, 19, flat, left45 }, { 40, -11, 0, 19, flat, left45 }, { 41, -11, 0, 19, flat, left45 }, { 42, -12, 0, 18, flat, left45 }, { 43, -12, 0, 18, flat, left45 },
    { 44, -13, 0, 18, flat, left45 }, { 45, -13, 0, 18, flat, left45 }, { 46, -13, 0, 18, flat, left45 }, { 47, -14, 0, 18, flat, left45 }, { 48, -14, 0, 18, flat, left45 }, { 49, -14, 0, 18, flat, left45 },
    { 50, -15, 0, 18, flat, left45 }, { 51, -15, 0, 18, flat, left45 }, { 52, -15, 0, 17, flat, left45 }, { 53, -15, 0, 17, flat, left45 }, { 54, -15, 0, 17, flat, left45 }, { 55, -15, 0, 17, flat, left45 },
    { 56, -16, 0, 17, flat, left45 }, { 57, -16, 0, 17, flat, left45 }, { 58, -16, 0, 17, flat, left45 }, { 59, -16, 0, 17, flat, left45 }, { 60, -16, 0, 16, flat, left45 }, { 61, -16, 0, 16, flat, left45 },
    { 62, -16, 0, 16, flat, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E09F6, {
    {  31, 16, 0, 0, flat, right45 }, {  30, 16, 0, 0, flat, right45 }, {  29, 16, 0, 0, flat, right45 }, {  28, 16, 0, 0, flat, right45 }, {  27, 16, 0, 1, flat, right45 }, {  26, 16, 0, 1, flat, right45 },
    {  25, 17, 0, 1, flat, right45 }, {  24, 17, 0, 1, flat, right45 }, {  23, 17, 0, 1, flat, right45 }, {  22, 17, 0, 1, flat, right45 }, {  21, 17, 0, 1, flat, right45 }, {  20, 17, 0, 1, flat, right45 },
    {  19, 18, 0, 1, flat, right45 }, {  18, 18, 0, 2, flat, right45 }, {  17, 18, 0, 2, flat, right45 }, {  16, 19, 0, 2, flat, right45 }, {  15, 19, 0, 2, flat, right45 }, {  14, 19, 0, 2, flat, right45 },
    {  13, 20, 0, 2, flat, right45 }, {  12, 20, 0, 2, flat, right45 }, {  11, 21, 0, 2, flat, right45 }, {  10, 21, 0, 2, flat, right45 }, {   9, 22, 0, 2, flat, right45 }, {   8, 22, 0, 3, flat, right45 },
    {   7, 23, 0, 3, flat, right45 }, {   6, 23, 0, 3, flat, right45 }, {   5, 24, 0, 3, flat, right45 }, {   4, 25, 0, 3, flat, right45 }, {   3, 25, 0, 3, flat, right45 }, {   2, 26, 0, 3, flat, right45 },
    {   1, 27, 0, 3, flat, right45 }, {   0, 28, 0, 3, flat, right45 }, {  -1, 29, 0, 4, flat, right45 }, {  -3, 29, 0, 4, flat, right45 }, {  -4, 30, 0, 4, flat, right45 }, {  -5, 31, 0, 4, flat, right45 },
    {  -6, 32, 0, 4, flat, right45 }, {  -7, 33, 0, 5, flat, right45 }, {  -7, 34, 0, 5, flat, right45 }, {  -8, 35, 0, 5, flat, right45 }, {  -9, 36, 0, 5, flat, right45 }, {  -9, 37, 0, 5, flat, right45 },
    { -10, 38, 0, 5, flat, right45 }, { -10, 39, 0, 5, flat, right45 }, { -11, 40, 0, 5, flat, right45 }, { -11, 41, 0, 5, flat, right45 }, { -12, 42, 0, 6, flat, right45 }, { -12, 43, 0, 6, flat, right45 },
    { -13, 44, 0, 6, flat, right45 }, { -13, 45, 0, 6, flat, right45 }, { -13, 46, 0, 6, flat, right45 }, { -14, 47, 0, 6, flat, right45 }, { -14, 48, 0, 6, flat, right45 }, { -14, 49, 0, 6, flat, right45 },
    { -15, 50, 0, 6, flat, right45 }, { -15, 51, 0, 6, flat, right45 }, { -15, 52, 0, 7, flat, right45 }, { -15, 53, 0, 7, flat, right45 }, { -15, 54, 0, 7, flat, right45 }, { -15, 55, 0, 7, flat, right45 },
    { -16, 56, 0, 7, flat, right45 }, { -16, 57, 0, 7, flat, right45 }, { -16, 58, 0, 7, flat, right45 }, { -16, 59, 0, 7, flat, right45 }, { -16, 60, 0, 8, flat, right45 }, { -16, 61, 0, 8, flat, right45 },
    { -16, 62, 0, 8, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0C53, {
    { 16,  0, 0,  8, flat, right45 }, { 16,  1, 0,  8, flat, right45 }, { 16,  2, 0,  8, flat, right45 }, { 16,  3, 0,  8, flat, right45 }, { 16,  4, 0,  8, flat, right45 }, { 16,  5, 0,  9, flat, right45 },
    { 16,  6, 0,  9, flat, right45 }, { 17,  7, 0,  9, flat, right45 }, { 17,  8, 0,  9, flat, right45 }, { 17,  9, 0,  9, flat, right45 }, { 17, 10, 0,  9, flat, right45 }, { 17, 11, 0,  9, flat, right45 },
    { 17, 12, 0,  9, flat, right45 }, { 18, 13, 0,  9, flat, right45 }, { 18, 14, 0, 10, flat, right45 }, { 18, 15, 0, 10, flat, right45 }, { 19, 16, 0, 10, flat, right45 }, { 19, 17, 0, 10, flat, right45 },
    { 19, 18, 0, 10, flat, right45 }, { 20, 19, 0, 10, flat, right45 }, { 20, 20, 0, 10, flat, right45 }, { 21, 21, 0, 10, flat, right45 }, { 21, 22, 0, 10, flat, right45 }, { 22, 23, 0, 10, flat, right45 },
    { 22, 24, 0, 11, flat, right45 }, { 23, 25, 0, 11, flat, right45 }, { 23, 26, 0, 11, flat, right45 }, { 24, 27, 0, 11, flat, right45 }, { 25, 28, 0, 11, flat, right45 }, { 25, 29, 0, 11, flat, right45 },
    { 26, 30, 0, 11, flat, right45 }, { 27, 31, 0, 11, flat, right45 }, { 28, 32, 0, 11, flat, right45 }, { 29, 33, 0, 12, flat, right45 }, { 29, 35, 0, 12, flat, right45 }, { 30, 36, 0, 12, flat, right45 },
    { 31, 37, 0, 12, flat, right45 }, { 32, 38, 0, 12, flat, right45 }, { 33, 39, 0, 13, flat, right45 }, { 34, 39, 0, 13, flat, right45 }, { 35, 40, 0, 13, flat, right45 }, { 36, 41, 0, 13, flat, right45 },
    { 37, 41, 0, 13, flat, right45 }, { 38, 42, 0, 13, flat, right45 }, { 39, 42, 0, 13, flat, right45 }, { 40, 43, 0, 13, flat, right45 }, { 41, 43, 0, 13, flat, right45 }, { 42, 44, 0, 14, flat, right45 },
    { 43, 44, 0, 14, flat, right45 }, { 44, 45, 0, 14, flat, right45 }, { 45, 45, 0, 14, flat, right45 }, { 46, 45, 0, 14, flat, right45 }, { 47, 46, 0, 14, flat, right45 }, { 48, 46, 0, 14, flat, right45 },
    { 49, 46, 0, 14, flat, right45 }, { 50, 47, 0, 14, flat, right45 }, { 51, 47, 0, 14, flat, right45 }, { 52, 47, 0, 15, flat, right45 }, { 53, 47, 0, 15, flat, right45 }, { 54, 47, 0, 15, flat, right45 },
    { 55, 47, 0, 15, flat, right45 }, { 56, 48, 0, 15, flat, right45 }, { 57, 48, 0, 15, flat, right45 }, { 58, 48, 0, 15, flat, right45 }, { 59, 48, 0, 15, flat, right45 }, { 60, 48, 0, 16, flat, right45 },
    { 61, 48, 0, 16, flat, right45 }, { 62, 48, 0, 16, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0EB9, {
    {  0,  16, 0, 16, flat, right45 }, {  1,  16, 0, 16, flat, right45 }, {  2,  16, 0, 16, flat, right45 }, {  3,  16, 0, 16, flat, right45 }, {  4,  16, 0, 16, flat, right45 }, {  5,  16, 0, 17, flat, right45 },
    {  6,  16, 0, 17, flat, right45 }, {  7,  15, 0, 17, flat, right45 }, {  8,  15, 0, 17, flat, right45 }, {  9,  15, 0, 17, flat, right45 }, { 10,  15, 0, 17, flat, right45 }, { 11,  15, 0, 17, flat, right45 },
    { 12,  15, 0, 17, flat, right45 }, { 13,  14, 0, 17, flat, right45 }, { 14,  14, 0, 18, flat, right45 }, { 15,  14, 0, 18, flat, right45 }, { 16,  13, 0, 18, flat, right45 }, { 17,  13, 0, 18, flat, right45 },
    { 18,  13, 0, 18, flat, right45 }, { 19,  12, 0, 18, flat, right45 }, { 20,  12, 0, 18, flat, right45 }, { 21,  11, 0, 18, flat, right45 }, { 22,  11, 0, 18, flat, right45 }, { 23,  10, 0, 18, flat, right45 },
    { 24,  10, 0, 19, flat, right45 }, { 25,   9, 0, 19, flat, right45 }, { 26,   9, 0, 19, flat, right45 }, { 27,   8, 0, 19, flat, right45 }, { 28,   7, 0, 19, flat, right45 }, { 29,   7, 0, 19, flat, right45 },
    { 30,   6, 0, 19, flat, right45 }, { 31,   5, 0, 19, flat, right45 }, { 32,   4, 0, 19, flat, right45 }, { 33,   3, 0, 20, flat, right45 }, { 35,   3, 0, 20, flat, right45 }, { 36,   2, 0, 20, flat, right45 },
    { 37,   1, 0, 20, flat, right45 }, { 38,   0, 0, 20, flat, right45 }, { 39,  -1, 0, 21, flat, right45 }, { 39,  -2, 0, 21, flat, right45 }, { 40,  -3, 0, 21, flat, right45 }, { 41,  -4, 0, 21, flat, right45 },
    { 41,  -5, 0, 21, flat, right45 }, { 42,  -6, 0, 21, flat, right45 }, { 42,  -7, 0, 21, flat, right45 }, { 43,  -8, 0, 21, flat, right45 }, { 43,  -9, 0, 21, flat, right45 }, { 44, -10, 0, 22, flat, right45 },
    { 44, -11, 0, 22, flat, right45 }, { 45, -12, 0, 22, flat, right45 }, { 45, -13, 0, 22, flat, right45 }, { 45, -14, 0, 22, flat, right45 }, { 46, -15, 0, 22, flat, right45 }, { 46, -16, 0, 22, flat, right45 },
    { 46, -17, 0, 22, flat, right45 }, { 47, -18, 0, 22, flat, right45 }, { 47, -19, 0, 22, flat, right45 }, { 47, -20, 0, 23, flat, right45 }, { 47, -21, 0, 23, flat, right45 }, { 47, -22, 0, 23, flat, right45 },
    { 47, -23, 0, 23, flat, right45 }, { 48, -24, 0, 23, flat, right45 }, { 48, -25, 0, 23, flat, right45 }, { 48, -26, 0, 23, flat, right45 }, { 48, -27, 0, 23, flat, right45 }, { 48, -28, 0, 24, flat, right45 },
    { 48, -29, 0, 24, flat, right45 }, { 48, -30, 0, 24, flat, right45 }, { 48, -31, 0, 24, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1128, {
    {  16,  31, 0, 24, flat, right45 }, {  16,  30, 0, 24, flat, right45 }, {  16,  29, 0, 24, flat, right45 }, {  16,  28, 0, 24, flat, right45 }, {  16,  27, 0, 25, flat, right45 },
    {  16,  26, 0, 25, flat, right45 }, {  15,  25, 0, 25, flat, right45 }, {  15,  24, 0, 25, flat, right45 }, {  15,  23, 0, 25, flat, right45 }, {  15,  22, 0, 25, flat, right45 },
    {  15,  21, 0, 25, flat, right45 }, {  15,  20, 0, 25, flat, right45 }, {  14,  19, 0, 25, flat, right45 }, {  14,  18, 0, 26, flat, right45 }, {  14,  17, 0, 26, flat, right45 },
    {  13,  16, 0, 26, flat, right45 }, {  13,  15, 0, 26, flat, right45 }, {  13,  14, 0, 26, flat, right45 }, {  12,  13, 0, 26, flat, right45 }, {  12,  12, 0, 26, flat, right45 },
    {  11,  11, 0, 26, flat, right45 }, {  11,  10, 0, 26, flat, right45 }, {  10,   9, 0, 26, flat, right45 }, {  10,   8, 0, 27, flat, right45 }, {   9,   7, 0, 27, flat, right45 },
    {   9,   6, 0, 27, flat, right45 }, {   8,   5, 0, 27, flat, right45 }, {   7,   4, 0, 27, flat, right45 }, {   7,   3, 0, 27, flat, right45 }, {   6,   2, 0, 27, flat, right45 },
    {   5,   1, 0, 27, flat, right45 }, {   4,   0, 0, 27, flat, right45 }, {   3,  -1, 0, 28, flat, right45 }, {   3,  -3, 0, 28, flat, right45 }, {   2,  -4, 0, 28, flat, right45 },
    {   1,  -5, 0, 28, flat, right45 }, {   0,  -6, 0, 28, flat, right45 }, {  -1,  -7, 0, 29, flat, right45 }, {  -2,  -7, 0, 29, flat, right45 }, {  -3,  -8, 0, 29, flat, right45 },
    {  -4,  -9, 0, 29, flat, right45 }, {  -5,  -9, 0, 29, flat, right45 }, {  -6, -10, 0, 29, flat, right45 }, {  -7, -10, 0, 29, flat, right45 }, {  -8, -11, 0, 29, flat, right45 },
    {  -9, -11, 0, 29, flat, right45 }, { -10, -12, 0, 30, flat, right45 }, { -11, -12, 0, 30, flat, right45 }, { -12, -13, 0, 30, flat, right45 }, { -13, -13, 0, 30, flat, right45 },
    { -14, -13, 0, 30, flat, right45 }, { -15, -14, 0, 30, flat, right45 }, { -16, -14, 0, 30, flat, right45 }, { -17, -14, 0, 30, flat, right45 }, { -18, -15, 0, 30, flat, right45 },
    { -19, -15, 0, 30, flat, right45 }, { -20, -15, 0, 31, flat, right45 }, { -21, -15, 0, 31, flat, right45 }, { -22, -15, 0, 31, flat, right45 }, { -23, -15, 0, 31, flat, right45 },
    { -24, -16, 0, 31, flat, right45 }, { -25, -16, 0, 31, flat, right45 }, { -26, -16, 0, 31, flat, right45 }, { -27, -16, 0, 31, flat, right45 }, { -28, -16, 0,  0, flat, right45 },
    { -29, -16, 0,  0, flat, right45 }, { -30, -16, 0,  0, flat, right45 }, { -31, -16, 0,  0, flat, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E26BE, {
    {  31,  16,  0,  0, up25, unbanked }, {  30,  16,  0,  0, up25, unbanked }, {  29,  16,  1,  0, up25, unbanked }, {  28,  16,  1,  0, up25, unbanked }, {  27,  16,  2, 31, up25, unbanked },
    {  26,  16,  2, 31, up25, unbanked }, {  25,  15,  2, 31, up25, unbanked }, {  24,  15,  3, 31, up25, unbanked }, {  23,  15,  3, 31, up25, unbanked }, {  22,  15,  4, 31, up25, unbanked },
    {  21,  15,  4, 31, up25, unbanked }, {  20,  15,  4, 31, up25, unbanked }, {  19,  14,  5, 31, up25, unbanked }, {  18,  14,  5, 30, up25, unbanked }, {  17,  14,  6, 30, up25, unbanked },
    {  16,  13,  6, 30, up25, unbanked }, {  15,  13,  7, 30, up25, unbanked }, {  14,  13,  7, 30, up25, unbanked }, {  13,  12,  8, 30, up25, unbanked }, {  12,  12,  8, 30, up25, unbanked },
    {  11,  11,  9, 30, up25, unbanked }, {  10,  11,  9, 30, up25, unbanked }, {   9,  10, 10, 30, up25, unbanked }, {   8,  10, 10, 29, up25, unbanked }, {   7,   9, 11, 29, up25, unbanked },
    {   6,   9, 11, 29, up25, unbanked }, {   5,   8, 11, 29, up25, unbanked }, {   4,   7, 12, 29, up25, unbanked }, {   3,   7, 13, 29, up25, unbanked }, {   2,   6, 13, 29, up25, unbanked },
    {   1,   5, 14, 29, up25, unbanked }, {   0,   4, 14, 29, up25, unbanked }, {  -1,   3, 15, 28, up25, unbanked }, {  -3,   3, 15, 28, up25, unbanked }, {  -4,   2, 16, 28, up25, unbanked },
    {  -5,   1, 16, 28, up25, unbanked }, {  -6,   0, 17, 28, up25, unbanked }, {  -7,  -1, 17, 27, up25, unbanked }, {  -7,  -2, 18, 27, up25, unbanked }, {  -8,  -3, 18, 27, up25, unbanked },
    {  -9,  -4, 19, 27, up25, unbanked }, {  -9,  -5, 19, 27, up25, unbanked }, { -10,  -6, 20, 27, up25, unbanked }, { -10,  -7, 20, 27, up25, unbanked }, { -11,  -8, 21, 27, up25, unbanked },
    { -11,  -9, 21, 27, up25, unbanked }, { -12, -10, 22, 26, up25, unbanked }, { -12, -11, 22, 26, up25, unbanked }, { -13, -12, 23, 26, up25, unbanked }, { -13, -13, 23, 26, up25, unbanked },
    { -13, -14, 24, 26, up25, unbanked }, { -14, -15, 24, 26, up25, unbanked }, { -14, -16, 25, 26, up25, unbanked }, { -14, -17, 25, 26, up25, unbanked }, { -15, -18, 25, 26, up25, unbanked },
    { -15, -19, 26, 26, up25, unbanked }, { -15, -20, 26, 25, up25, unbanked }, { -15, -21, 27, 25, up25, unbanked }, { -15, -22, 27, 25, up25, unbanked }, { -15, -23, 28, 25, up25, unbanked },
    { -16, -24, 28, 25, up25, unbanked }, { -16, -25, 29, 25, up25, unbanked }, { -16, -26, 29, 25, up25, unbanked }, { -16, -27, 29, 25, up25, unbanked }, { -16, -28, 30, 24, up25, unbanked },
    { -16, -29, 30, 24, up25, unbanked }, { -16, -30, 31, 24, up25, unbanked }, { -16, -31, 31, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2924, {
    {  16,  0,  0, 8, up25, unbanked }, {  16,  1,  0, 8, up25, unbanked }, {  16,  2,  0, 8, up25, unbanked }, {  16,  3,  1, 8, up25, unbanked }, {  16,  4,  1, 8, up25, unbanked },
    {  16,  5,  2, 7, up25, unbanked }, {  16,  6,  2, 7, up25, unbanked }, {  15,  7,  2, 7, up25, unbanked }, {  15,  8,  3, 7, up25, unbanked }, {  15,  9,  3, 7, up25, unbanked },
    {  15, 10,  4, 7, up25, unbanked }, {  15, 11,  4, 7, up25, unbanked }, {  15, 12,  4, 7, up25, unbanked }, {  14, 13,  5, 7, up25, unbanked }, {  14, 14,  5, 6, up25, unbanked },
    {  14, 15,  6, 6, up25, unbanked }, {  13, 16,  6, 6, up25, unbanked }, {  13, 17,  7, 6, up25, unbanked }, {  13, 18,  7, 6, up25, unbanked }, {  12, 19,  8, 6, up25, unbanked },
    {  12, 20,  8, 6, up25, unbanked }, {  11, 21,  9, 6, up25, unbanked }, {  11, 22,  9, 6, up25, unbanked }, {  10, 23, 10, 6, up25, unbanked }, {  10, 24, 10, 5, up25, unbanked },
    {   9, 25, 11, 5, up25, unbanked }, {   9, 26, 11, 5, up25, unbanked }, {   8, 27, 11, 5, up25, unbanked }, {   7, 28, 12, 5, up25, unbanked }, {   7, 29, 13, 5, up25, unbanked },
    {   6, 30, 13, 5, up25, unbanked }, {   5, 31, 14, 5, up25, unbanked }, {   4, 32, 14, 5, up25, unbanked }, {   3, 33, 15, 4, up25, unbanked }, {   3, 35, 15, 4, up25, unbanked },
    {   2, 36, 16, 4, up25, unbanked }, {   1, 37, 16, 4, up25, unbanked }, {   0, 38, 17, 4, up25, unbanked }, {  -1, 39, 17, 3, up25, unbanked }, {  -2, 39, 18, 3, up25, unbanked },
    {  -3, 40, 18, 3, up25, unbanked }, {  -4, 41, 19, 3, up25, unbanked }, {  -5, 41, 19, 3, up25, unbanked }, {  -6, 42, 20, 3, up25, unbanked }, {  -7, 42, 20, 3, up25, unbanked },
    {  -8, 43, 21, 3, up25, unbanked }, {  -9, 43, 21, 3, up25, unbanked }, { -10, 44, 22, 2, up25, unbanked }, { -11, 44, 22, 2, up25, unbanked }, { -12, 45, 23, 2, up25, unbanked },
    { -13, 45, 23, 2, up25, unbanked }, { -14, 45, 24, 2, up25, unbanked }, { -15, 46, 24, 2, up25, unbanked }, { -16, 46, 25, 2, up25, unbanked }, { -17, 46, 25, 2, up25, unbanked },
    { -18, 47, 25, 2, up25, unbanked }, { -19, 47, 26, 2, up25, unbanked }, { -20, 47, 26, 1, up25, unbanked }, { -21, 47, 27, 1, up25, unbanked }, { -22, 47, 27, 1, up25, unbanked },
    { -23, 47, 28, 1, up25, unbanked }, { -24, 48, 28, 1, up25, unbanked }, { -25, 48, 29, 1, up25, unbanked }, { -26, 48, 29, 1, up25, unbanked }, { -27, 48, 29, 1, up25, unbanked },
    { -28, 48, 30, 0, up25, unbanked }, { -29, 48, 30, 0, up25, unbanked }, { -30, 48, 31, 0, up25, unbanked }, { -31, 48, 31, 0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2B93, {
    {  0, 16,  0, 16, up25, unbanked }, {  1, 16,  0, 16, up25, unbanked }, {  2, 16,  0, 16, up25, unbanked }, {  3, 16,  1, 16, up25, unbanked }, {  4, 16,  1, 16, up25, unbanked },
    {  5, 16,  2, 15, up25, unbanked }, {  6, 16,  2, 15, up25, unbanked }, {  7, 17,  2, 15, up25, unbanked }, {  8, 17,  3, 15, up25, unbanked }, {  9, 17,  3, 15, up25, unbanked },
    { 10, 17,  4, 15, up25, unbanked }, { 11, 17,  4, 15, up25, unbanked }, { 12, 17,  5, 15, up25, unbanked }, { 13, 18,  5, 15, up25, unbanked }, { 14, 18,  6, 14, up25, unbanked },
    { 15, 18,  6, 14, up25, unbanked }, { 16, 19,  6, 14, up25, unbanked }, { 17, 19,  7, 14, up25, unbanked }, { 18, 19,  7, 14, up25, unbanked }, { 19, 20,  8, 14, up25, unbanked },
    { 20, 20,  8, 14, up25, unbanked }, { 21, 21,  9, 14, up25, unbanked }, { 22, 21,  9, 14, up25, unbanked }, { 23, 22, 10, 14, up25, unbanked }, { 24, 22, 10, 13, up25, unbanked },
    { 25, 23, 11, 13, up25, unbanked }, { 26, 23, 11, 13, up25, unbanked }, { 27, 24, 12, 13, up25, unbanked }, { 28, 25, 12, 13, up25, unbanked }, { 29, 25, 13, 13, up25, unbanked },
    { 30, 26, 13, 13, up25, unbanked }, { 31, 27, 14, 13, up25, unbanked }, { 32, 28, 14, 13, up25, unbanked }, { 33, 29, 15, 12, up25, unbanked }, { 35, 29, 15, 12, up25, unbanked },
    { 36, 30, 16, 12, up25, unbanked }, { 37, 31, 16, 12, up25, unbanked }, { 38, 32, 17, 12, up25, unbanked }, { 39, 33, 18, 11, up25, unbanked }, { 39, 34, 18, 11, up25, unbanked },
    { 40, 35, 19, 11, up25, unbanked }, { 41, 36, 19, 11, up25, unbanked }, { 41, 37, 20, 11, up25, unbanked }, { 42, 38, 20, 11, up25, unbanked }, { 42, 39, 21, 11, up25, unbanked },
    { 43, 40, 21, 11, up25, unbanked }, { 43, 41, 22, 11, up25, unbanked }, { 44, 42, 22, 10, up25, unbanked }, { 44, 43, 23, 10, up25, unbanked }, { 45, 44, 23, 10, up25, unbanked },
    { 45, 45, 24, 10, up25, unbanked }, { 45, 46, 24, 10, up25, unbanked }, { 46, 47, 24, 10, up25, unbanked }, { 46, 48, 25, 10, up25, unbanked }, { 46, 49, 25, 10, up25, unbanked },
    { 47, 50, 26, 10, up25, unbanked }, { 47, 51, 26, 10, up25, unbanked }, { 47, 52, 27,  9, up25, unbanked }, { 47, 53, 27,  9, up25, unbanked }, { 47, 54, 28,  9, up25, unbanked },
    { 47, 55, 28,  9, up25, unbanked }, { 48, 56, 28,  9, up25, unbanked }, { 48, 57, 29,  9, up25, unbanked }, { 48, 58, 29,  9, up25, unbanked }, { 48, 59, 30,  9, up25, unbanked },
    { 48, 60, 30,  8, up25, unbanked }, { 48, 61, 31,  8, up25, unbanked }, { 48, 62, 31,  8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2DF9, {
    { 16,  31,  0, 24, up25, unbanked }, { 16,  30,  0, 24, up25, unbanked }, { 16,  29,  1, 24, up25, unbanked }, { 16,  28,  1, 24, up25, unbanked }, { 16,  27,  2, 23, up25, unbanked },
    { 16,  26,  2, 23, up25, unbanked }, { 17,  25,  2, 23, up25, unbanked }, { 17,  24,  3, 23, up25, unbanked }, { 17,  23,  3, 23, up25, unbanked }, { 17,  22,  4, 23, up25, unbanked },
    { 17,  21,  4, 23, up25, unbanked }, { 17,  20,  5, 23, up25, unbanked }, { 18,  19,  5, 23, up25, unbanked }, { 18,  18,  6, 22, up25, unbanked }, { 18,  17,  6, 22, up25, unbanked },
    { 19,  16,  6, 22, up25, unbanked }, { 19,  15,  7, 22, up25, unbanked }, { 19,  14,  7, 22, up25, unbanked }, { 20,  13,  8, 22, up25, unbanked }, { 20,  12,  8, 22, up25, unbanked },
    { 21,  11,  9, 22, up25, unbanked }, { 21,  10,  9, 22, up25, unbanked }, { 22,   9, 10, 22, up25, unbanked }, { 22,   8, 10, 21, up25, unbanked }, { 23,   7, 11, 21, up25, unbanked },
    { 23,   6, 11, 21, up25, unbanked }, { 24,   5, 12, 21, up25, unbanked }, { 25,   4, 12, 21, up25, unbanked }, { 25,   3, 13, 21, up25, unbanked }, { 26,   2, 13, 21, up25, unbanked },
    { 27,   1, 14, 21, up25, unbanked }, { 28,   0, 14, 21, up25, unbanked }, { 29,  -1, 15, 20, up25, unbanked }, { 29,  -3, 15, 20, up25, unbanked }, { 30,  -4, 16, 20, up25, unbanked },
    { 31,  -5, 16, 20, up25, unbanked }, { 32,  -6, 17, 20, up25, unbanked }, { 33,  -7, 18, 19, up25, unbanked }, { 34,  -7, 18, 19, up25, unbanked }, { 35,  -8, 19, 19, up25, unbanked },
    { 36,  -9, 19, 19, up25, unbanked }, { 37,  -9, 20, 19, up25, unbanked }, { 38, -10, 20, 19, up25, unbanked }, { 39, -10, 21, 19, up25, unbanked }, { 40, -11, 21, 19, up25, unbanked },
    { 41, -11, 22, 19, up25, unbanked }, { 42, -12, 22, 18, up25, unbanked }, { 43, -12, 23, 18, up25, unbanked }, { 44, -13, 23, 18, up25, unbanked }, { 45, -13, 24, 18, up25, unbanked },
    { 46, -13, 24, 18, up25, unbanked }, { 47, -14, 24, 18, up25, unbanked }, { 48, -14, 25, 18, up25, unbanked }, { 49, -14, 25, 18, up25, unbanked }, { 50, -15, 26, 18, up25, unbanked },
    { 51, -15, 26, 18, up25, unbanked }, { 52, -15, 27, 17, up25, unbanked }, { 53, -15, 27, 17, up25, unbanked }, { 54, -15, 28, 17, up25, unbanked }, { 55, -15, 28, 17, up25, unbanked },
    { 56, -16, 28, 17, up25, unbanked }, { 57, -16, 29, 17, up25, unbanked }, { 58, -16, 29, 17, up25, unbanked }, { 59, -16, 30, 17, up25, unbanked }, { 60, -16, 30, 16, up25, unbanked },
    { 61, -16, 31, 16, up25, unbanked }, { 62, -16, 31, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3056, {
    {  31, 16,  0, 0, up25, unbanked }, {  30, 16,  0, 0, up25, unbanked }, {  29, 16,  1, 0, up25, unbanked }, {  28, 16,  1, 0, up25, unbanked }, {  27, 16,  2, 1, up25, unbanked },
    {  26, 16,  2, 1, up25, unbanked }, {  25, 17,  2, 1, up25, unbanked }, {  24, 17,  3, 1, up25, unbanked }, {  23, 17,  3, 1, up25, unbanked }, {  22, 17,  4, 1, up25, unbanked },
    {  21, 17,  4, 1, up25, unbanked }, {  20, 17,  5, 1, up25, unbanked }, {  19, 18,  5, 1, up25, unbanked }, {  18, 18,  6, 2, up25, unbanked }, {  17, 18,  6, 2, up25, unbanked },
    {  16, 19,  6, 2, up25, unbanked }, {  15, 19,  7, 2, up25, unbanked }, {  14, 19,  7, 2, up25, unbanked }, {  13, 20,  8, 2, up25, unbanked }, {  12, 20,  8, 2, up25, unbanked },
    {  11, 21,  9, 2, up25, unbanked }, {  10, 21,  9, 2, up25, unbanked }, {   9, 22, 10, 2, up25, unbanked }, {   8, 22, 10, 3, up25, unbanked }, {   7, 23, 11, 3, up25, unbanked },
    {   6, 23, 11, 3, up25, unbanked }, {   5, 24, 12, 3, up25, unbanked }, {   4, 25, 12, 3, up25, unbanked }, {   3, 25, 13, 3, up25, unbanked }, {   2, 26, 13, 3, up25, unbanked },
    {   1, 27, 14, 3, up25, unbanked }, {   0, 28, 14, 3, up25, unbanked }, {  -1, 29, 15, 4, up25, unbanked }, {  -3, 29, 15, 4, up25, unbanked }, {  -4, 30, 16, 4, up25, unbanked },
    {  -5, 31, 16, 4, up25, unbanked }, {  -6, 32, 17, 4, up25, unbanked }, {  -7, 33, 18, 5, up25, unbanked }, {  -7, 34, 18, 5, up25, unbanked }, {  -8, 35, 19, 5, up25, unbanked },
    {  -9, 36, 19, 5, up25, unbanked }, {  -9, 37, 20, 5, up25, unbanked }, { -10, 38, 20, 5, up25, unbanked }, { -10, 39, 21, 5, up25, unbanked }, { -11, 40, 21, 5, up25, unbanked },
    { -11, 41, 22, 5, up25, unbanked }, { -12, 42, 22, 6, up25, unbanked }, { -12, 43, 23, 6, up25, unbanked }, { -13, 44, 23, 6, up25, unbanked }, { -13, 45, 24, 6, up25, unbanked },
    { -13, 46, 24, 6, up25, unbanked }, { -14, 47, 24, 6, up25, unbanked }, { -14, 48, 25, 6, up25, unbanked }, { -14, 49, 25, 6, up25, unbanked }, { -15, 50, 26, 6, up25, unbanked },
    { -15, 51, 26, 6, up25, unbanked }, { -15, 52, 27, 7, up25, unbanked }, { -15, 53, 27, 7, up25, unbanked }, { -15, 54, 28, 7, up25, unbanked }, { -15, 55, 28, 7, up25, unbanked },
    { -16, 56, 28, 7, up25, unbanked }, { -16, 57, 29, 7, up25, unbanked }, { -16, 58, 29, 7, up25, unbanked }, { -16, 59, 30, 7, up25, unbanked }, { -16, 60, 30, 8, up25, unbanked },
    { -16, 61, 31, 8, up25, unbanked }, { -16, 62, 31, 8, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E32B3, {
    { 16,  0,  0,  8, up25, unbanked }, { 16,  1,  0,  8, up25, unbanked }, { 16,  2,  0,  8, up25, unbanked }, { 16,  3,  1,  8, up25, unbanked }, { 16,  4,  1,  8, up25, unbanked },
    { 16,  5,  2,  9, up25, unbanked }, { 16,  6,  2,  9, up25, unbanked }, { 17,  7,  2,  9, up25, unbanked }, { 17,  8,  3,  9, up25, unbanked }, { 17,  9,  3,  9, up25, unbanked },
    { 17, 10,  4,  9, up25, unbanked }, { 17, 11,  4,  9, up25, unbanked }, { 17, 12,  5,  9, up25, unbanked }, { 18, 13,  5,  9, up25, unbanked }, { 18, 14,  6, 10, up25, unbanked },
    { 18, 15,  6, 10, up25, unbanked }, { 19, 16,  6, 10, up25, unbanked }, { 19, 17,  7, 10, up25, unbanked }, { 19, 18,  7, 10, up25, unbanked }, { 20, 19,  8, 10, up25, unbanked },
    { 20, 20,  8, 10, up25, unbanked }, { 21, 21,  9, 10, up25, unbanked }, { 21, 22,  9, 10, up25, unbanked }, { 22, 23, 10, 10, up25, unbanked }, { 22, 24, 10, 11, up25, unbanked },
    { 23, 25, 11, 11, up25, unbanked }, { 23, 26, 11, 11, up25, unbanked }, { 24, 27, 12, 11, up25, unbanked }, { 25, 28, 12, 11, up25, unbanked }, { 25, 29, 13, 11, up25, unbanked },
    { 26, 30, 13, 11, up25, unbanked }, { 27, 31, 14, 11, up25, unbanked }, { 28, 32, 14, 11, up25, unbanked }, { 29, 33, 15, 12, up25, unbanked }, { 29, 35, 15, 12, up25, unbanked },
    { 30, 36, 16, 12, up25, unbanked }, { 31, 37, 16, 12, up25, unbanked }, { 32, 38, 17, 12, up25, unbanked }, { 33, 39, 18, 13, up25, unbanked }, { 34, 39, 18, 13, up25, unbanked },
    { 35, 40, 19, 13, up25, unbanked }, { 36, 41, 19, 13, up25, unbanked }, { 37, 41, 20, 13, up25, unbanked }, { 38, 42, 20, 13, up25, unbanked }, { 39, 42, 21, 13, up25, unbanked },
    { 40, 43, 21, 13, up25, unbanked }, { 41, 43, 22, 13, up25, unbanked }, { 42, 44, 22, 14, up25, unbanked }, { 43, 44, 23, 14, up25, unbanked }, { 44, 45, 23, 14, up25, unbanked },
    { 45, 45, 24, 14, up25, unbanked }, { 46, 45, 24, 14, up25, unbanked }, { 47, 46, 24, 14, up25, unbanked }, { 48, 46, 25, 14, up25, unbanked }, { 49, 46, 25, 14, up25, unbanked },
    { 50, 47, 26, 14, up25, unbanked }, { 51, 47, 26, 14, up25, unbanked }, { 52, 47, 27, 15, up25, unbanked }, { 53, 47, 27, 15, up25, unbanked }, { 54, 47, 28, 15, up25, unbanked },
    { 55, 47, 28, 15, up25, unbanked }, { 56, 48, 28, 15, up25, unbanked }, { 57, 48, 29, 15, up25, unbanked }, { 58, 48, 29, 15, up25, unbanked }, { 59, 48, 30, 15, up25, unbanked },
    { 60, 48, 30, 16, up25, unbanked }, { 61, 48, 31, 16, up25, unbanked }, { 62, 48, 31, 16, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3519, {
    {  0,  16,  0, 16, up25, unbanked }, {  1,  16,  0, 16, up25, unbanked }, {  2,  16,  0, 16, up25, unbanked }, {  3,  16,  1, 16, up25, unbanked }, {  4,  16,  1, 16, up25, unbanked },
    {  5,  16,  2, 17, up25, unbanked }, {  6,  16,  2, 17, up25, unbanked }, {  7,  15,  2, 17, up25, unbanked }, {  8,  15,  3, 17, up25, unbanked }, {  9,  15,  3, 17, up25, unbanked },
    { 10,  15,  4, 17, up25, unbanked }, { 11,  15,  4, 17, up25, unbanked }, { 12,  15,  4, 17, up25, unbanked }, { 13,  14,  5, 17, up25, unbanked }, { 14,  14,  5, 18, up25, unbanked },
    { 15,  14,  6, 18, up25, unbanked }, { 16,  13,  6, 18, up25, unbanked }, { 17,  13,  7, 18, up25, unbanked }, { 18,  13,  7, 18, up25, unbanked }, { 19,  12,  8, 18, up25, unbanked },
    { 20,  12,  8, 18, up25, unbanked }, { 21,  11,  9, 18, up25, unbanked }, { 22,  11,  9, 18, up25, unbanked }, { 23,  10, 10, 18, up25, unbanked }, { 24,  10, 10, 19, up25, unbanked },
    { 25,   9, 11, 19, up25, unbanked }, { 26,   9, 11, 19, up25, unbanked }, { 27,   8, 11, 19, up25, unbanked }, { 28,   7, 12, 19, up25, unbanked }, { 29,   7, 13, 19, up25, unbanked },
    { 30,   6, 13, 19, up25, unbanked }, { 31,   5, 14, 19, up25, unbanked }, { 32,   4, 14, 19, up25, unbanked }, { 33,   3, 15, 20, up25, unbanked }, { 35,   3, 15, 20, up25, unbanked },
    { 36,   2, 16, 20, up25, unbanked }, { 37,   1, 16, 20, up25, unbanked }, { 38,   0, 17, 20, up25, unbanked }, { 39,  -1, 17, 21, up25, unbanked }, { 39,  -2, 18, 21, up25, unbanked },
    { 40,  -3, 18, 21, up25, unbanked }, { 41,  -4, 19, 21, up25, unbanked }, { 41,  -5, 19, 21, up25, unbanked }, { 42,  -6, 20, 21, up25, unbanked }, { 42,  -7, 20, 21, up25, unbanked },
    { 43,  -8, 21, 21, up25, unbanked }, { 43,  -9, 21, 21, up25, unbanked }, { 44, -10, 22, 22, up25, unbanked }, { 44, -11, 22, 22, up25, unbanked }, { 45, -12, 23, 22, up25, unbanked },
    { 45, -13, 23, 22, up25, unbanked }, { 45, -14, 24, 22, up25, unbanked }, { 46, -15, 24, 22, up25, unbanked }, { 46, -16, 25, 22, up25, unbanked }, { 46, -17, 25, 22, up25, unbanked },
    { 47, -18, 25, 22, up25, unbanked }, { 47, -19, 26, 22, up25, unbanked }, { 47, -20, 26, 23, up25, unbanked }, { 47, -21, 27, 23, up25, unbanked }, { 47, -22, 27, 23, up25, unbanked },
    { 47, -23, 28, 23, up25, unbanked }, { 48, -24, 28, 23, up25, unbanked }, { 48, -25, 29, 23, up25, unbanked }, { 48, -26, 29, 23, up25, unbanked }, { 48, -27, 29, 23, up25, unbanked },
    { 48, -28, 30, 24, up25, unbanked }, { 48, -29, 30, 24, up25, unbanked }, { 48, -30, 31, 24, up25, unbanked }, { 48, -31, 31, 24, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3788, {
    {  16,  31,  0, 24, up25, unbanked }, {  16,  30,  0, 24, up25, unbanked }, {  16,  29,  1, 24, up25, unbanked }, {  16,  28,  1, 24, up25, unbanked }, {  16,  27,  2, 25, up25, unbanked },
    {  16,  26,  2, 25, up25, unbanked }, {  15,  25,  2, 25, up25, unbanked }, {  15,  24,  3, 25, up25, unbanked }, {  15,  23,  3, 25, up25, unbanked }, {  15,  22,  4, 25, up25, unbanked },
    {  15,  21,  4, 25, up25, unbanked }, {  15,  20,  4, 25, up25, unbanked }, {  14,  19,  5, 25, up25, unbanked }, {  14,  18,  5, 26, up25, unbanked }, {  14,  17,  6, 26, up25, unbanked },
    {  13,  16,  6, 26, up25, unbanked }, {  13,  15,  7, 26, up25, unbanked }, {  13,  14,  7, 26, up25, unbanked }, {  12,  13,  8, 26, up25, unbanked }, {  12,  12,  8, 26, up25, unbanked },
    {  11,  11,  9, 26, up25, unbanked }, {  11,  10,  9, 26, up25, unbanked }, {  10,   9, 10, 26, up25, unbanked }, {  10,   8, 10, 27, up25, unbanked }, {   9,   7, 11, 27, up25, unbanked },
    {   9,   6, 11, 27, up25, unbanked }, {   8,   5, 11, 27, up25, unbanked }, {   7,   4, 12, 27, up25, unbanked }, {   7,   3, 13, 27, up25, unbanked }, {   6,   2, 13, 27, up25, unbanked },
    {   5,   1, 14, 27, up25, unbanked }, {   4,   0, 14, 27, up25, unbanked }, {   3,  -1, 15, 28, up25, unbanked }, {   3,  -3, 15, 28, up25, unbanked }, {   2,  -4, 16, 28, up25, unbanked },
    {   1,  -5, 16, 28, up25, unbanked }, {   0,  -6, 17, 28, up25, unbanked }, {  -1,  -7, 17, 29, up25, unbanked }, {  -2,  -7, 18, 29, up25, unbanked }, {  -3,  -8, 18, 29, up25, unbanked },
    {  -4,  -9, 19, 29, up25, unbanked }, {  -5,  -9, 19, 29, up25, unbanked }, {  -6, -10, 20, 29, up25, unbanked }, {  -7, -10, 20, 29, up25, unbanked }, {  -8, -11, 21, 29, up25, unbanked },
    {  -9, -11, 21, 29, up25, unbanked }, { -10, -12, 22, 30, up25, unbanked }, { -11, -12, 22, 30, up25, unbanked }, { -12, -13, 23, 30, up25, unbanked }, { -13, -13, 23, 30, up25, unbanked },
    { -14, -13, 24, 30, up25, unbanked }, { -15, -14, 24, 30, up25, unbanked }, { -16, -14, 25, 30, up25, unbanked }, { -17, -14, 25, 30, up25, unbanked }, { -18, -15, 25, 30, up25, unbanked },
    { -19, -15, 26, 30, up25, unbanked }, { -20, -15, 26, 31, up25, unbanked }, { -21, -15, 27, 31, up25, unbanked }, { -22, -15, 27, 31, up25, unbanked }, { -23, -15, 28, 31, up25, unbanked },
    { -24, -16, 28, 31, up25, unbanked }, { -25, -16, 29, 31, up25, unbanked }, { -26, -16, 29, 31, up25, unbanked }, { -27, -16, 29, 31, up25, unbanked }, { -28, -16, 30,  0, up25, unbanked },
    { -29, -16, 30,  0, up25, unbanked }, { -30, -16, 31,  0, up25, unbanked }, { -31, -16, 31,  0, up25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E138E, {
    {  31,  16,  15,  0, down25, unbanked }, {  30,  16,  15,  0, down25, unbanked }, {  29,  16,  14,  0, down25, unbanked }, {  28,  16,  14,  0, down25, unbanked }, {  27,  16,  13, 31, down25, unbanked },
    {  26,  16,  13, 31, down25, unbanked }, {  25,  15,  13, 31, down25, unbanked }, {  24,  15,  12, 31, down25, unbanked }, {  23,  15,  12, 31, down25, unbanked }, {  22,  15,  11, 31, down25, unbanked },
    {  21,  15,  11, 31, down25, unbanked }, {  20,  15,  11, 31, down25, unbanked }, {  19,  14,  10, 31, down25, unbanked }, {  18,  14,  10, 30, down25, unbanked }, {  17,  14,   9, 30, down25, unbanked },
    {  16,  13,   9, 30, down25, unbanked }, {  15,  13,   8, 30, down25, unbanked }, {  14,  13,   8, 30, down25, unbanked }, {  13,  12,   7, 30, down25, unbanked }, {  12,  12,   7, 30, down25, unbanked },
    {  11,  11,   6, 30, down25, unbanked }, {  10,  11,   6, 30, down25, unbanked }, {   9,  10,   5, 30, down25, unbanked }, {   8,  10,   5, 29, down25, unbanked }, {   7,   9,   4, 29, down25, unbanked },
    {   6,   9,   4, 29, down25, unbanked }, {   5,   8,   4, 29, down25, unbanked }, {   4,   7,   3, 29, down25, unbanked }, {   3,   7,   2, 29, down25, unbanked }, {   2,   6,   2, 29, down25, unbanked },
    {   1,   5,   1, 29, down25, unbanked }, {   0,   4,   1, 29, down25, unbanked }, {  -1,   3,   0, 28, down25, unbanked }, {  -3,   3,   0, 28, down25, unbanked }, {  -4,   2,  -1, 28, down25, unbanked },
    {  -5,   1,  -1, 28, down25, unbanked }, {  -6,   0,  -2, 28, down25, unbanked }, {  -7,  -1,  -2, 27, down25, unbanked }, {  -7,  -2,  -3, 27, down25, unbanked }, {  -8,  -3,  -3, 27, down25, unbanked },
    {  -9,  -4,  -4, 27, down25, unbanked }, {  -9,  -5,  -5, 27, down25, unbanked }, { -10,  -6,  -5, 27, down25, unbanked }, { -10,  -7,  -5, 27, down25, unbanked }, { -11,  -8,  -6, 27, down25, unbanked },
    { -11,  -9,  -6, 27, down25, unbanked }, { -12, -10,  -7, 26, down25, unbanked }, { -12, -11,  -7, 26, down25, unbanked }, { -13, -12,  -8, 26, down25, unbanked }, { -13, -13,  -8, 26, down25, unbanked },
    { -13, -14,  -9, 26, down25, unbanked }, { -14, -15,  -9, 26, down25, unbanked }, { -14, -16, -10, 26, down25, unbanked }, { -14, -17, -10, 26, down25, unbanked }, { -15, -18, -11, 26, down25, unbanked },
    { -15, -19, -11, 26, down25, unbanked }, { -15, -20, -12, 25, down25, unbanked }, { -15, -21, -12, 25, down25, unbanked }, { -15, -22, -12, 25, down25, unbanked }, { -15, -23, -13, 25, down25, unbanked },
    { -16, -24, -13, 25, down25, unbanked }, { -16, -25, -14, 25, down25, unbanked }, { -16, -26, -14, 25, down25, unbanked }, { -16, -27, -14, 25, down25, unbanked }, { -16, -28, -15, 24, down25, unbanked },
    { -16, -29, -15, 24, down25, unbanked }, { -16, -30, -16, 24, down25, unbanked }, { -16, -31, -17, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E15F4, {
    {  16,  0,  15, 8, down25, unbanked }, {  16,  1,  15, 8, down25, unbanked }, {  16,  2,  15, 8, down25, unbanked }, {  16,  3,  14, 8, down25, unbanked }, {  16,  4,  14, 8, down25, unbanked },
    {  16,  5,  13, 7, down25, unbanked }, {  16,  6,  13, 7, down25, unbanked }, {  15,  7,  13, 7, down25, unbanked }, {  15,  8,  12, 7, down25, unbanked }, {  15,  9,  12, 7, down25, unbanked },
    {  15, 10,  11, 7, down25, unbanked }, {  15, 11,  11, 7, down25, unbanked }, {  15, 12,  11, 7, down25, unbanked }, {  14, 13,  10, 7, down25, unbanked }, {  14, 14,  10, 6, down25, unbanked },
    {  14, 15,   9, 6, down25, unbanked }, {  13, 16,   9, 6, down25, unbanked }, {  13, 17,   8, 6, down25, unbanked }, {  13, 18,   8, 6, down25, unbanked }, {  12, 19,   7, 6, down25, unbanked },
    {  12, 20,   7, 6, down25, unbanked }, {  11, 21,   6, 6, down25, unbanked }, {  11, 22,   6, 6, down25, unbanked }, {  10, 23,   5, 6, down25, unbanked }, {  10, 24,   5, 5, down25, unbanked },
    {   9, 25,   4, 5, down25, unbanked }, {   9, 26,   4, 5, down25, unbanked }, {   8, 27,   4, 5, down25, unbanked }, {   7, 28,   3, 5, down25, unbanked }, {   7, 29,   2, 5, down25, unbanked },
    {   6, 30,   2, 5, down25, unbanked }, {   5, 31,   1, 5, down25, unbanked }, {   4, 32,   1, 5, down25, unbanked }, {   3, 33,   0, 4, down25, unbanked }, {   3, 35,   0, 4, down25, unbanked },
    {   2, 36,  -1, 4, down25, unbanked }, {   1, 37,  -1, 4, down25, unbanked }, {   0, 38,  -2, 4, down25, unbanked }, {  -1, 39,  -2, 3, down25, unbanked }, {  -2, 39,  -3, 3, down25, unbanked },
    {  -3, 40,  -3, 3, down25, unbanked }, {  -4, 41,  -4, 3, down25, unbanked }, {  -5, 41,  -5, 3, down25, unbanked }, {  -6, 42,  -5, 3, down25, unbanked }, {  -7, 42,  -5, 3, down25, unbanked },
    {  -8, 43,  -6, 3, down25, unbanked }, {  -9, 43,  -6, 3, down25, unbanked }, { -10, 44,  -7, 2, down25, unbanked }, { -11, 44,  -7, 2, down25, unbanked }, { -12, 45,  -8, 2, down25, unbanked },
    { -13, 45,  -8, 2, down25, unbanked }, { -14, 45,  -9, 2, down25, unbanked }, { -15, 46,  -9, 2, down25, unbanked }, { -16, 46, -10, 2, down25, unbanked }, { -17, 46, -10, 2, down25, unbanked },
    { -18, 47, -11, 2, down25, unbanked }, { -19, 47, -11, 2, down25, unbanked }, { -20, 47, -12, 1, down25, unbanked }, { -21, 47, -12, 1, down25, unbanked }, { -22, 47, -12, 1, down25, unbanked },
    { -23, 47, -13, 1, down25, unbanked }, { -24, 48, -13, 1, down25, unbanked }, { -25, 48, -14, 1, down25, unbanked }, { -26, 48, -14, 1, down25, unbanked }, { -27, 48, -14, 1, down25, unbanked },
    { -28, 48, -15, 0, down25, unbanked }, { -29, 48, -15, 0, down25, unbanked }, { -30, 48, -16, 0, down25, unbanked }, { -31, 48, -17, 0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1863, {
    {  0, 16,  15, 16, down25, unbanked }, {  1, 16,  15, 16, down25, unbanked }, {  2, 16,  15, 16, down25, unbanked }, {  3, 16,  14, 16, down25, unbanked }, {  4, 16,  14, 16, down25, unbanked },
    {  5, 16,  13, 15, down25, unbanked }, {  6, 16,  13, 15, down25, unbanked }, {  7, 17,  13, 15, down25, unbanked }, {  8, 17,  12, 15, down25, unbanked }, {  9, 17,  12, 15, down25, unbanked },
    { 10, 17,  11, 15, down25, unbanked }, { 11, 17,  11, 15, down25, unbanked }, { 12, 17,  10, 15, down25, unbanked }, { 13, 18,  10, 15, down25, unbanked }, { 14, 18,   9, 14, down25, unbanked },
    { 15, 18,   9, 14, down25, unbanked }, { 16, 19,   9, 14, down25, unbanked }, { 17, 19,   8, 14, down25, unbanked }, { 18, 19,   8, 14, down25, unbanked }, { 19, 20,   7, 14, down25, unbanked },
    { 20, 20,   7, 14, down25, unbanked }, { 21, 21,   6, 14, down25, unbanked }, { 22, 21,   6, 14, down25, unbanked }, { 23, 22,   5, 14, down25, unbanked }, { 24, 22,   5, 13, down25, unbanked },
    { 25, 23,   4, 13, down25, unbanked }, { 26, 23,   4, 13, down25, unbanked }, { 27, 24,   3, 13, down25, unbanked }, { 28, 25,   3, 13, down25, unbanked }, { 29, 25,   2, 13, down25, unbanked },
    { 30, 26,   2, 13, down25, unbanked }, { 31, 27,   1, 13, down25, unbanked }, { 32, 28,   1, 13, down25, unbanked }, { 33, 29,   0, 12, down25, unbanked }, { 35, 29,  -1, 12, down25, unbanked },
    { 36, 30,  -1, 12, down25, unbanked }, { 37, 31,  -1, 12, down25, unbanked }, { 38, 32,  -2, 12, down25, unbanked }, { 39, 33,  -3, 11, down25, unbanked }, { 39, 34,  -3, 11, down25, unbanked },
    { 40, 35,  -4, 11, down25, unbanked }, { 41, 36,  -4, 11, down25, unbanked }, { 41, 37,  -5, 11, down25, unbanked }, { 42, 38,  -5, 11, down25, unbanked }, { 42, 39,  -6, 11, down25, unbanked },
    { 43, 40,  -6, 11, down25, unbanked }, { 43, 41,  -7, 11, down25, unbanked }, { 44, 42,  -7, 10, down25, unbanked }, { 44, 43,  -8, 10, down25, unbanked }, { 45, 44,  -8, 10, down25, unbanked },
    { 45, 45,  -9, 10, down25, unbanked }, { 45, 46,  -9, 10, down25, unbanked }, { 46, 47,  -9, 10, down25, unbanked }, { 46, 48, -10, 10, down25, unbanked }, { 46, 49, -10, 10, down25, unbanked },
    { 47, 50, -11, 10, down25, unbanked }, { 47, 51, -11, 10, down25, unbanked }, { 47, 52, -12,  9, down25, unbanked }, { 47, 53, -12,  9, down25, unbanked }, { 47, 54, -13,  9, down25, unbanked },
    { 47, 55, -13,  9, down25, unbanked }, { 48, 56, -13,  9, down25, unbanked }, { 48, 57, -14,  9, down25, unbanked }, { 48, 58, -14,  9, down25, unbanked }, { 48, 59, -15,  9, down25, unbanked },
    { 48, 60, -15,  8, down25, unbanked }, { 48, 61, -16,  8, down25, unbanked }, { 48, 62, -16,  8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1AC9, {
    { 16,  31,  15, 24, down25, unbanked }, { 16,  30,  15, 24, down25, unbanked }, { 16,  29,  14, 24, down25, unbanked }, { 16,  28,  14, 24, down25, unbanked }, { 16,  27,  13, 23, down25, unbanked },
    { 16,  26,  13, 23, down25, unbanked }, { 17,  25,  13, 23, down25, unbanked }, { 17,  24,  12, 23, down25, unbanked }, { 17,  23,  12, 23, down25, unbanked }, { 17,  22,  11, 23, down25, unbanked },
    { 17,  21,  11, 23, down25, unbanked }, { 17,  20,  10, 23, down25, unbanked }, { 18,  19,  10, 23, down25, unbanked }, { 18,  18,   9, 22, down25, unbanked }, { 18,  17,   9, 22, down25, unbanked },
    { 19,  16,   9, 22, down25, unbanked }, { 19,  15,   8, 22, down25, unbanked }, { 19,  14,   8, 22, down25, unbanked }, { 20,  13,   7, 22, down25, unbanked }, { 20,  12,   7, 22, down25, unbanked },
    { 21,  11,   6, 22, down25, unbanked }, { 21,  10,   6, 22, down25, unbanked }, { 22,   9,   5, 22, down25, unbanked }, { 22,   8,   5, 21, down25, unbanked }, { 23,   7,   4, 21, down25, unbanked },
    { 23,   6,   4, 21, down25, unbanked }, { 24,   5,   3, 21, down25, unbanked }, { 25,   4,   3, 21, down25, unbanked }, { 25,   3,   2, 21, down25, unbanked }, { 26,   2,   2, 21, down25, unbanked },
    { 27,   1,   1, 21, down25, unbanked }, { 28,   0,   1, 21, down25, unbanked }, { 29,  -1,   0, 20, down25, unbanked }, { 29,  -3,  -1, 20, down25, unbanked }, { 30,  -4,  -1, 20, down25, unbanked },
    { 31,  -5,  -1, 20, down25, unbanked }, { 32,  -6,  -2, 20, down25, unbanked }, { 33,  -7,  -3, 19, down25, unbanked }, { 34,  -7,  -3, 19, down25, unbanked }, { 35,  -8,  -4, 19, down25, unbanked },
    { 36,  -9,  -4, 19, down25, unbanked }, { 37,  -9,  -5, 19, down25, unbanked }, { 38, -10,  -5, 19, down25, unbanked }, { 39, -10,  -6, 19, down25, unbanked }, { 40, -11,  -6, 19, down25, unbanked },
    { 41, -11,  -7, 19, down25, unbanked }, { 42, -12,  -7, 18, down25, unbanked }, { 43, -12,  -8, 18, down25, unbanked }, { 44, -13,  -8, 18, down25, unbanked }, { 45, -13,  -9, 18, down25, unbanked },
    { 46, -13,  -9, 18, down25, unbanked }, { 47, -14,  -9, 18, down25, unbanked }, { 48, -14, -10, 18, down25, unbanked }, { 49, -14, -10, 18, down25, unbanked }, { 50, -15, -11, 18, down25, unbanked },
    { 51, -15, -11, 18, down25, unbanked }, { 52, -15, -12, 17, down25, unbanked }, { 53, -15, -12, 17, down25, unbanked }, { 54, -15, -13, 17, down25, unbanked }, { 55, -15, -13, 17, down25, unbanked },
    { 56, -16, -13, 17, down25, unbanked }, { 57, -16, -14, 17, down25, unbanked }, { 58, -16, -14, 17, down25, unbanked }, { 59, -16, -15, 17, down25, unbanked }, { 60, -16, -15, 16, down25, unbanked },
    { 61, -16, -16, 16, down25, unbanked }, { 62, -16, -16, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1D26, {
    {  31, 16,  15, 0, down25, unbanked }, {  30, 16,  15, 0, down25, unbanked }, {  29, 16,  14, 0, down25, unbanked }, {  28, 16,  14, 0, down25, unbanked }, {  27, 16,  13, 1, down25, unbanked },
    {  26, 16,  13, 1, down25, unbanked }, {  25, 17,  13, 1, down25, unbanked }, {  24, 17,  12, 1, down25, unbanked }, {  23, 17,  12, 1, down25, unbanked }, {  22, 17,  11, 1, down25, unbanked },
    {  21, 17,  11, 1, down25, unbanked }, {  20, 17,  10, 1, down25, unbanked }, {  19, 18,  10, 1, down25, unbanked }, {  18, 18,   9, 2, down25, unbanked }, {  17, 18,   9, 2, down25, unbanked },
    {  16, 19,   9, 2, down25, unbanked }, {  15, 19,   8, 2, down25, unbanked }, {  14, 19,   8, 2, down25, unbanked }, {  13, 20,   7, 2, down25, unbanked }, {  12, 20,   7, 2, down25, unbanked },
    {  11, 21,   6, 2, down25, unbanked }, {  10, 21,   6, 2, down25, unbanked }, {   9, 22,   5, 2, down25, unbanked }, {   8, 22,   5, 3, down25, unbanked }, {   7, 23,   4, 3, down25, unbanked },
    {   6, 23,   4, 3, down25, unbanked }, {   5, 24,   3, 3, down25, unbanked }, {   4, 25,   3, 3, down25, unbanked }, {   3, 25,   2, 3, down25, unbanked }, {   2, 26,   2, 3, down25, unbanked },
    {   1, 27,   1, 3, down25, unbanked }, {   0, 28,   1, 3, down25, unbanked }, {  -1, 29,   0, 4, down25, unbanked }, {  -3, 29,  -1, 4, down25, unbanked }, {  -4, 30,  -1, 4, down25, unbanked },
    {  -5, 31,  -1, 4, down25, unbanked }, {  -6, 32,  -2, 4, down25, unbanked }, {  -7, 33,  -3, 5, down25, unbanked }, {  -7, 34,  -3, 5, down25, unbanked }, {  -8, 35,  -4, 5, down25, unbanked },
    {  -9, 36,  -4, 5, down25, unbanked }, {  -9, 37,  -5, 5, down25, unbanked }, { -10, 38,  -5, 5, down25, unbanked }, { -10, 39,  -6, 5, down25, unbanked }, { -11, 40,  -6, 5, down25, unbanked },
    { -11, 41,  -7, 5, down25, unbanked }, { -12, 42,  -7, 6, down25, unbanked }, { -12, 43,  -8, 6, down25, unbanked }, { -13, 44,  -8, 6, down25, unbanked }, { -13, 45,  -9, 6, down25, unbanked },
    { -13, 46,  -9, 6, down25, unbanked }, { -14, 47,  -9, 6, down25, unbanked }, { -14, 48, -10, 6, down25, unbanked }, { -14, 49, -10, 6, down25, unbanked }, { -15, 50, -11, 6, down25, unbanked },
    { -15, 51, -11, 6, down25, unbanked }, { -15, 52, -12, 7, down25, unbanked }, { -15, 53, -12, 7, down25, unbanked }, { -15, 54, -13, 7, down25, unbanked }, { -15, 55, -13, 7, down25, unbanked },
    { -16, 56, -13, 7, down25, unbanked }, { -16, 57, -14, 7, down25, unbanked }, { -16, 58, -14, 7, down25, unbanked }, { -16, 59, -15, 7, down25, unbanked }, { -16, 60, -15, 8, down25, unbanked },
    { -16, 61, -16, 8, down25, unbanked }, { -16, 62, -16, 8, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1F83, {
    { 16,  0,  15,  8, down25, unbanked }, { 16,  1,  15,  8, down25, unbanked }, { 16,  2,  15,  8, down25, unbanked }, { 16,  3,  14,  8, down25, unbanked }, { 16,  4,  14,  8, down25, unbanked },
    { 16,  5,  13,  9, down25, unbanked }, { 16,  6,  13,  9, down25, unbanked }, { 17,  7,  13,  9, down25, unbanked }, { 17,  8,  12,  9, down25, unbanked }, { 17,  9,  12,  9, down25, unbanked },
    { 17, 10,  11,  9, down25, unbanked }, { 17, 11,  11,  9, down25, unbanked }, { 17, 12,  10,  9, down25, unbanked }, { 18, 13,  10,  9, down25, unbanked }, { 18, 14,   9, 10, down25, unbanked },
    { 18, 15,   9, 10, down25, unbanked }, { 19, 16,   9, 10, down25, unbanked }, { 19, 17,   8, 10, down25, unbanked }, { 19, 18,   8, 10, down25, unbanked }, { 20, 19,   7, 10, down25, unbanked },
    { 20, 20,   7, 10, down25, unbanked }, { 21, 21,   6, 10, down25, unbanked }, { 21, 22,   6, 10, down25, unbanked }, { 22, 23,   5, 10, down25, unbanked }, { 22, 24,   5, 11, down25, unbanked },
    { 23, 25,   4, 11, down25, unbanked }, { 23, 26,   4, 11, down25, unbanked }, { 24, 27,   3, 11, down25, unbanked }, { 25, 28,   3, 11, down25, unbanked }, { 25, 29,   2, 11, down25, unbanked },
    { 26, 30,   2, 11, down25, unbanked }, { 27, 31,   1, 11, down25, unbanked }, { 28, 32,   1, 11, down25, unbanked }, { 29, 33,   0, 12, down25, unbanked }, { 29, 35,  -1, 12, down25, unbanked },
    { 30, 36,  -1, 12, down25, unbanked }, { 31, 37,  -1, 12, down25, unbanked }, { 32, 38,  -2, 12, down25, unbanked }, { 33, 39,  -3, 13, down25, unbanked }, { 34, 39,  -3, 13, down25, unbanked },
    { 35, 40,  -4, 13, down25, unbanked }, { 36, 41,  -4, 13, down25, unbanked }, { 37, 41,  -5, 13, down25, unbanked }, { 38, 42,  -5, 13, down25, unbanked }, { 39, 42,  -6, 13, down25, unbanked },
    { 40, 43,  -6, 13, down25, unbanked }, { 41, 43,  -7, 13, down25, unbanked }, { 42, 44,  -7, 14, down25, unbanked }, { 43, 44,  -8, 14, down25, unbanked }, { 44, 45,  -8, 14, down25, unbanked },
    { 45, 45,  -9, 14, down25, unbanked }, { 46, 45,  -9, 14, down25, unbanked }, { 47, 46,  -9, 14, down25, unbanked }, { 48, 46, -10, 14, down25, unbanked }, { 49, 46, -10, 14, down25, unbanked },
    { 50, 47, -11, 14, down25, unbanked }, { 51, 47, -11, 14, down25, unbanked }, { 52, 47, -12, 15, down25, unbanked }, { 53, 47, -12, 15, down25, unbanked }, { 54, 47, -13, 15, down25, unbanked },
    { 55, 47, -13, 15, down25, unbanked }, { 56, 48, -13, 15, down25, unbanked }, { 57, 48, -14, 15, down25, unbanked }, { 58, 48, -14, 15, down25, unbanked }, { 59, 48, -15, 15, down25, unbanked },
    { 60, 48, -15, 16, down25, unbanked }, { 61, 48, -16, 16, down25, unbanked }, { 62, 48, -16, 16, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E21E9, {
    {  0,  16,  15, 16, down25, unbanked }, {  1,  16,  15, 16, down25, unbanked }, {  2,  16,  15, 16, down25, unbanked }, {  3,  16,  14, 16, down25, unbanked }, {  4,  16,  14, 16, down25, unbanked },
    {  5,  16,  13, 17, down25, unbanked }, {  6,  16,  13, 17, down25, unbanked }, {  7,  15,  13, 17, down25, unbanked }, {  8,  15,  12, 17, down25, unbanked }, {  9,  15,  12, 17, down25, unbanked },
    { 10,  15,  11, 17, down25, unbanked }, { 11,  15,  11, 17, down25, unbanked }, { 12,  15,  11, 17, down25, unbanked }, { 13,  14,  10, 17, down25, unbanked }, { 14,  14,  10, 18, down25, unbanked },
    { 15,  14,   9, 18, down25, unbanked }, { 16,  13,   9, 18, down25, unbanked }, { 17,  13,   8, 18, down25, unbanked }, { 18,  13,   8, 18, down25, unbanked }, { 19,  12,   7, 18, down25, unbanked },
    { 20,  12,   7, 18, down25, unbanked }, { 21,  11,   6, 18, down25, unbanked }, { 22,  11,   6, 18, down25, unbanked }, { 23,  10,   5, 18, down25, unbanked }, { 24,  10,   5, 19, down25, unbanked },
    { 25,   9,   4, 19, down25, unbanked }, { 26,   9,   4, 19, down25, unbanked }, { 27,   8,   4, 19, down25, unbanked }, { 28,   7,   3, 19, down25, unbanked }, { 29,   7,   2, 19, down25, unbanked },
    { 30,   6,   2, 19, down25, unbanked }, { 31,   5,   1, 19, down25, unbanked }, { 32,   4,   1, 19, down25, unbanked }, { 33,   3,   0, 20, down25, unbanked }, { 35,   3,   0, 20, down25, unbanked },
    { 36,   2,  -1, 20, down25, unbanked }, { 37,   1,  -1, 20, down25, unbanked }, { 38,   0,  -2, 20, down25, unbanked }, { 39,  -1,  -2, 21, down25, unbanked }, { 39,  -2,  -3, 21, down25, unbanked },
    { 40,  -3,  -3, 21, down25, unbanked }, { 41,  -4,  -4, 21, down25, unbanked }, { 41,  -5,  -4, 21, down25, unbanked }, { 42,  -6,  -5, 21, down25, unbanked }, { 42,  -7,  -5, 21, down25, unbanked },
    { 43,  -8,  -6, 21, down25, unbanked }, { 43,  -9,  -6, 21, down25, unbanked }, { 44, -10,  -7, 22, down25, unbanked }, { 44, -11,  -7, 22, down25, unbanked }, { 45, -12,  -8, 22, down25, unbanked },
    { 45, -13,  -8, 22, down25, unbanked }, { 45, -14,  -9, 22, down25, unbanked }, { 46, -15,  -9, 22, down25, unbanked }, { 46, -16, -10, 22, down25, unbanked }, { 46, -17, -10, 22, down25, unbanked },
    { 47, -18, -10, 22, down25, unbanked }, { 47, -19, -11, 22, down25, unbanked }, { 47, -20, -11, 23, down25, unbanked }, { 47, -21, -12, 23, down25, unbanked }, { 47, -22, -12, 23, down25, unbanked },
    { 47, -23, -13, 23, down25, unbanked }, { 48, -24, -13, 23, down25, unbanked }, { 48, -25, -14, 23, down25, unbanked }, { 48, -26, -14, 23, down25, unbanked }, { 48, -27, -14, 23, down25, unbanked },
    { 48, -28, -15, 24, down25, unbanked }, { 48, -29, -15, 24, down25, unbanked }, { 48, -30, -16, 24, down25, unbanked }, { 48, -31, -16, 24, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2458, {
    {  16,  31,  15, 24, down25, unbanked }, {  16,  30,  15, 24, down25, unbanked }, {  16,  29,  14, 24, down25, unbanked }, {  16,  28,  14, 24, down25, unbanked }, {  16,  27,  13, 25, down25, unbanked },
    {  16,  26,  13, 25, down25, unbanked }, {  15,  25,  13, 25, down25, unbanked }, {  15,  24,  12, 25, down25, unbanked }, {  15,  23,  12, 25, down25, unbanked }, {  15,  22,  11, 25, down25, unbanked },
    {  15,  21,  11, 25, down25, unbanked }, {  15,  20,  11, 25, down25, unbanked }, {  14,  19,  10, 25, down25, unbanked }, {  14,  18,  10, 26, down25, unbanked }, {  14,  17,   9, 26, down25, unbanked },
    {  13,  16,   9, 26, down25, unbanked }, {  13,  15,   8, 26, down25, unbanked }, {  13,  14,   8, 26, down25, unbanked }, {  12,  13,   7, 26, down25, unbanked }, {  12,  12,   7, 26, down25, unbanked },
    {  11,  11,   6, 26, down25, unbanked }, {  11,  10,   6, 26, down25, unbanked }, {  10,   9,   5, 26, down25, unbanked }, {  10,   8,   5, 27, down25, unbanked }, {   9,   7,   4, 27, down25, unbanked },
    {   9,   6,   4, 27, down25, unbanked }, {   8,   5,   4, 27, down25, unbanked }, {   7,   4,   3, 27, down25, unbanked }, {   7,   3,   2, 27, down25, unbanked }, {   6,   2,   2, 27, down25, unbanked },
    {   5,   1,   1, 27, down25, unbanked }, {   4,   0,   1, 27, down25, unbanked }, {   3,  -1,   0, 28, down25, unbanked }, {   3,  -3,   0, 28, down25, unbanked }, {   2,  -4,  -1, 28, down25, unbanked },
    {   1,  -5,  -1, 28, down25, unbanked }, {   0,  -6,  -2, 28, down25, unbanked }, {  -1,  -7,  -2, 29, down25, unbanked }, {  -2,  -7,  -3, 29, down25, unbanked }, {  -3,  -8,  -3, 29, down25, unbanked },
    {  -4,  -9,  -4, 29, down25, unbanked }, {  -5,  -9,  -4, 29, down25, unbanked }, {  -6, -10,  -5, 29, down25, unbanked }, {  -7, -10,  -5, 29, down25, unbanked }, {  -8, -11,  -6, 29, down25, unbanked },
    {  -9, -11,  -6, 29, down25, unbanked }, { -10, -12,  -7, 30, down25, unbanked }, { -11, -12,  -7, 30, down25, unbanked }, { -12, -13,  -8, 30, down25, unbanked }, { -13, -13,  -8, 30, down25, unbanked },
    { -14, -13,  -9, 30, down25, unbanked }, { -15, -14,  -9, 30, down25, unbanked }, { -16, -14, -10, 30, down25, unbanked }, { -17, -14, -10, 30, down25, unbanked }, { -18, -15, -10, 30, down25, unbanked },
    { -19, -15, -11, 30, down25, unbanked }, { -20, -15, -11, 31, down25, unbanked }, { -21, -15, -12, 31, down25, unbanked }, { -22, -15, -12, 31, down25, unbanked }, { -23, -15, -13, 31, down25, unbanked },
    { -24, -16, -13, 31, down25, unbanked }, { -25, -16, -14, 31, down25, unbanked }, { -26, -16, -14, 31, down25, unbanked }, { -27, -16, -14, 31, down25, unbanked }, { -28, -16, -15,  0, down25, unbanked },
    { -29, -16, -15,  0, down25, unbanked }, { -30, -16, -16,  0, down25, unbanked }, { -31, -16, -16,  0, down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E39EE, {
    { 31, 16, 0,  0, flat, unbanked }, { 30, 16, 0,  0, flat, unbanked }, { 29, 16, 0, 31, flat, unbanked }, { 28, 15, 0, 31, flat, unbanked }, { 27, 15, 0, 30, flat, unbanked }, { 26, 15, 0, 30, flat, unbanked },
    { 25, 14, 0, 30, flat, unbanked }, { 24, 14, 0, 29, flat, unbanked }, { 23, 13, 0, 29, flat, unbanked }, { 22, 12, 0, 28, flat, unbanked }, { 21, 11, 0, 28, flat, unbanked }, { 20, 10, 0, 28, flat, unbanked },
    { 19,  9, 0, 27, flat, unbanked }, { 18,  8, 0, 27, flat, unbanked }, { 18,  7, 0, 26, flat, unbanked }, { 17,  6, 0, 26, flat, unbanked }, { 17,  5, 0, 26, flat, unbanked }, { 17,  4, 0, 25, flat, unbanked },
    { 16,  3, 0, 25, flat, unbanked }, { 16,  2, 0, 24, flat, unbanked }, { 16,  1, 0, 24, flat, unbanked }, { 16,  0, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3AB6, {
    { 16,  0, 0, 8, flat, unbanked }, { 16,  1, 0, 8, flat, unbanked }, { 16,  2, 0, 8, flat, unbanked }, { 16,  3, 0, 7, flat, unbanked }, { 15,  4, 0, 7, flat, unbanked }, { 15,  5, 0, 6, flat, unbanked },
    { 15,  6, 0, 6, flat, unbanked }, { 14,  7, 0, 6, flat, unbanked }, { 14,  8, 0, 5, flat, unbanked }, { 13,  9, 0, 5, flat, unbanked }, { 12, 10, 0, 4, flat, unbanked }, { 11, 11, 0, 4, flat, unbanked },
    { 10, 12, 0, 4, flat, unbanked }, {  9, 13, 0, 3, flat, unbanked }, {  8, 14, 0, 3, flat, unbanked }, {  7, 14, 0, 2, flat, unbanked }, {  6, 15, 0, 2, flat, unbanked }, {  5, 15, 0, 2, flat, unbanked },
    {  4, 15, 0, 1, flat, unbanked }, {  3, 16, 0, 1, flat, unbanked }, {  2, 16, 0, 0, flat, unbanked }, {  1, 16, 0, 0, flat, unbanked }, {  0, 16, 0, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3B87, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 15, flat, unbanked }, {  4, 17, 0, 15, flat, unbanked }, {  5, 17, 0, 14, flat, unbanked },
    {  6, 17, 0, 14, flat, unbanked }, {  7, 18, 0, 14, flat, unbanked }, {  8, 18, 0, 13, flat, unbanked }, {  9, 19, 0, 13, flat, unbanked }, { 10, 20, 0, 12, flat, unbanked }, { 11, 21, 0, 12, flat, unbanked },
    { 12, 22, 0, 12, flat, unbanked }, { 13, 23, 0, 11, flat, unbanked }, { 14, 24, 0, 11, flat, unbanked }, { 14, 25, 0, 10, flat, unbanked }, { 15, 26, 0, 10, flat, unbanked }, { 15, 27, 0, 10, flat, unbanked },
    { 15, 28, 0,  9, flat, unbanked }, { 16, 29, 0,  9, flat, unbanked }, { 16, 30, 0,  8, flat, unbanked }, { 16, 31, 0,  8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3C4F, {
    { 16, 31, 0, 24, flat, unbanked }, { 16, 30, 0, 24, flat, unbanked }, { 16, 29, 0, 23, flat, unbanked }, { 17, 28, 0, 23, flat, unbanked }, { 17, 27, 0, 22, flat, unbanked }, { 17, 26, 0, 22, flat, unbanked },
    { 18, 25, 0, 22, flat, unbanked }, { 18, 24, 0, 21, flat, unbanked }, { 19, 23, 0, 21, flat, unbanked }, { 20, 22, 0, 20, flat, unbanked }, { 21, 21, 0, 20, flat, unbanked }, { 22, 20, 0, 20, flat, unbanked },
    { 23, 19, 0, 19, flat, unbanked }, { 24, 18, 0, 19, flat, unbanked }, { 25, 18, 0, 18, flat, unbanked }, { 26, 17, 0, 18, flat, unbanked }, { 27, 17, 0, 18, flat, unbanked }, { 28, 17, 0, 17, flat, unbanked },
    { 29, 16, 0, 17, flat, unbanked }, { 30, 16, 0, 16, flat, unbanked }, { 31, 16, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3D0E, {
    { 31, 16, 0, 0, flat, unbanked }, { 30, 16, 0, 0, flat, unbanked }, { 29, 16, 0, 1, flat, unbanked }, { 28, 17, 0, 1, flat, unbanked }, { 27, 17, 0, 2, flat, unbanked }, { 26, 17, 0, 2, flat, unbanked },
    { 25, 18, 0, 2, flat, unbanked }, { 24, 18, 0, 3, flat, unbanked }, { 23, 19, 0, 3, flat, unbanked }, { 22, 20, 0, 4, flat, unbanked }, { 21, 21, 0, 4, flat, unbanked }, { 20, 22, 0, 4, flat, unbanked },
    { 19, 23, 0, 5, flat, unbanked }, { 18, 24, 0, 5, flat, unbanked }, { 18, 25, 0, 6, flat, unbanked }, { 17, 26, 0, 6, flat, unbanked }, { 17, 27, 0, 6, flat, unbanked }, { 17, 28, 0, 7, flat, unbanked },
    { 16, 29, 0, 7, flat, unbanked }, { 16, 30, 0, 8, flat, unbanked }, { 16, 31, 0, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3DCD, {
    { 16,  0, 0,  8, flat, unbanked }, { 16,  1, 0,  8, flat, unbanked }, { 16,  2, 0,  8, flat, unbanked }, { 16,  3, 0,  9, flat, unbanked }, { 17,  4, 0,  9, flat, unbanked }, { 17,  5, 0, 10, flat, unbanked },
    { 17,  6, 0, 10, flat, unbanked }, { 18,  7, 0, 10, flat, unbanked }, { 18,  8, 0, 11, flat, unbanked }, { 19,  9, 0, 11, flat, unbanked }, { 20, 10, 0, 12, flat, unbanked }, { 21, 11, 0, 12, flat, unbanked },
    { 22, 12, 0, 12, flat, unbanked }, { 23, 13, 0, 13, flat, unbanked }, { 24, 14, 0, 13, flat, unbanked }, { 25, 14, 0, 14, flat, unbanked }, { 26, 15, 0, 14, flat, unbanked }, { 27, 15, 0, 14, flat, unbanked },
    { 28, 15, 0, 15, flat, unbanked }, { 29, 16, 0, 15, flat, unbanked }, { 30, 16, 0, 16, flat, unbanked }, { 31, 16, 0, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3E95, {
    {  0, 16, 0, 16, flat, unbanked }, {  1, 16, 0, 16, flat, unbanked }, {  2, 16, 0, 16, flat, unbanked }, {  3, 16, 0, 17, flat, unbanked }, {  4, 15, 0, 17, flat, unbanked }, {  5, 15, 0, 18, flat, unbanked },
    {  6, 15, 0, 18, flat, unbanked }, {  7, 14, 0, 18, flat, unbanked }, {  8, 14, 0, 19, flat, unbanked }, {  9, 13, 0, 19, flat, unbanked }, { 10, 12, 0, 20, flat, unbanked }, { 11, 11, 0, 20, flat, unbanked },
    { 12, 10, 0, 20, flat, unbanked }, { 13,  9, 0, 21, flat, unbanked }, { 14,  8, 0, 21, flat, unbanked }, { 14,  7, 0, 22, flat, unbanked }, { 15,  6, 0, 22, flat, unbanked }, { 15,  5, 0, 22, flat, unbanked },
    { 15,  4, 0, 23, flat, unbanked }, { 16,  3, 0, 23, flat, unbanked }, { 16,  2, 0, 24, flat, unbanked }, { 16,  1, 0, 24, flat, unbanked }, { 16,  0, 0, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3F66, {
    { 16, 31, 0, 24, flat, unbanked }, { 16, 30, 0, 24, flat, unbanked }, { 16, 29, 0, 25, flat, unbanked }, { 15, 28, 0, 25, flat, unbanked }, { 15, 27, 0, 26, flat, unbanked }, { 15, 26, 0, 26, flat, unbanked },
    { 14, 25, 0, 26, flat, unbanked }, { 14, 24, 0, 27, flat, unbanked }, { 13, 23, 0, 27, flat, unbanked }, { 12, 22, 0, 28, flat, unbanked }, { 11, 21, 0, 28, flat, unbanked }, { 10, 20, 0, 28, flat, unbanked },
    {  9, 19, 0, 29, flat, unbanked }, {  8, 18, 0, 29, flat, unbanked }, {  7, 18, 0, 30, flat, unbanked }, {  6, 17, 0, 30, flat, unbanked }, {  5, 17, 0, 30, flat, unbanked }, {  4, 17, 0, 31, flat, unbanked },
    {  3, 16, 0, 31, flat, unbanked }, {  2, 16, 0,  0, flat, unbanked }, {  1, 16, 0,  0, flat, unbanked }, {  0, 16, 0,  0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D9BFE, {
    {  31, 16, 0,  0,     flat, unbanked }, {  30, 16, 0,  0,     flat, unbanked }, {  29, 16, 0,  0,     flat, unbanked }, {  28, 16, 0,  0,     flat, unbanked }, {  27, 16, 0,  0,     flat, unbanked },
    {  26, 16, 0,  0,     flat,   left22 }, {  25, 16, 0,  0,     flat,   left22 }, {  24, 16, 0,  0,     flat,   left22 }, {  23, 16, 0,  0,     flat,   left22 }, {  22, 16, 0,  0,     flat,   left22 },
    {  21, 16, 0,  0,     flat,   left22 }, {  20, 16, 0,  0,     flat,   left22 }, {  19, 16, 0,  0,     flat,   left22 }, {  18, 16, 0,  0,     flat,   left22 }, {  17, 16, 0,  0,     flat,   left22 },
    {  16, 16, 0,  0,     flat,   left22 }, {  15, 16, 0,  0,     flat,   left22 }, {  14, 16, 0,  0,     flat,   left22 }, {  13, 16, 0,  0,     flat,   left45 }, {  12, 16, 0,  0,     flat,   left45 },
    {  11, 16, 0,  0,     flat,   left45 }, {  10, 16, 0,  0,     flat,   left45 }, {   9, 16, 0,  0,     flat,   left45 }, {   8, 16, 0,  0,     flat,   left45 }, {   7, 16, 0,  0,     flat,   left45 },
    {   6, 16, 0,  0,     flat,   left45 }, {   5, 16, 0,  0,     flat,   left45 }, {   4, 16, 0,  0,     flat,   left45 }, {   3, 16, 0,  0,     flat,   left45 }, {   2, 16, 0,  0,     flat,   left67 },
    {   1, 16, 0,  0,     flat,   left67 }, {   0, 16, 0,  0,     flat,   left67 }, {  -1, 16, 0,  0,     flat,   left67 }, {  -2, 16, 0,  0,     flat,   left67 }, {  -3, 16, 0,  0,     flat,   left67 },
    {  -4, 16, 0,  0,     flat,   left67 }, {  -5, 16, 0,  0,     flat,   left67 }, {  -6, 16, 0,  0,     flat,   left67 }, {  -7, 16, 0,  0,     flat,   left67 }, {  -8, 16, 0,  0,     flat,   left67 },
    {  -9, 16, 0,  0,     flat,   left67 }, { -10, 16, 0,  0,     flat,   left67 }, { -11, 16, 0,  0,     flat,   left90 }, { -12, 16, 0,  0,     flat,   left90 }, { -13, 16, 0,  0,     flat,   left90 },
    { -14, 16, 0,  0,     flat,   left90 }, { -15, 16, 0,  0,     flat,   left90 }, { -16, 16, 0,  0,     flat,   left90 }, { -17, 16, 0,  0,     flat,   left90 }, { -18, 16, 0,  0,     flat,   left90 },
    { -19, 16, 0,  0,     flat,   left90 }, { -20, 16, 0,  0,     flat,   left90 }, { -21, 16, 0,  0,     flat,   left90 }, { -22, 16, 0,  0,     flat,  left112 }, { -23, 16, 0,  0,     flat,  left112 },
    { -24, 16, 0,  0,     flat,  left112 }, { -25, 16, 0,  0,     flat,  left112 }, { -26, 16, 0,  0,     flat,  left112 }, { -27, 16, 0,  0,     flat,  left112 }, { -28, 16, 0,  0,     flat,  left112 },
    { -29, 16, 0,  0,     flat,  left112 }, { -30, 16, 0,  0,     flat,  left112 }, { -31, 16, 0,  0,     flat,  left112 }, { -32, 16, 0,  0,     flat,  left112 }, { -33, 16, 0,  0,     flat,  left112 },
    { -34, 16, 0,  0,     flat,  left112 }, { -35, 16, 0,  0,     flat,  left135 }, { -36, 16, 0,  0,     flat,  left135 }, { -37, 16, 0,  0,     flat,  left135 }, { -38, 16, 0,  0,     flat,  left135 },
    { -39, 16, 0,  0,     flat,  left135 }, { -40, 16, 0,  0,     flat,  left135 }, { -41, 16, 0,  0,     flat,  left135 }, { -42, 16, 0,  0,     flat,  left135 }, { -43, 16, 0,  0,     flat,  left135 },
    { -44, 16, 0,  0,     flat,  left135 }, { -45, 16, 0,  0,     flat,  left135 }, { -46, 16, 0,  0,     flat,  left157 }, { -47, 16, 0,  0,     flat,  left157 }, { -48, 16, 0,  0,     flat,  left157 },
    { -49, 16, 0,  0,     flat,  left157 }, { -50, 16, 0,  0,     flat,  left157 }, { -51, 16, 0,  0,     flat,  left157 }, { -52, 16, 0,  0,     flat,  left157 }, { -53, 16, 0,  0,     flat,  left157 },
    { -54, 16, 0,  0,     flat,  left157 }, { -55, 16, 0,  0,     flat,  left157 }, { -56, 16, 0,  0,     flat,  left157 }, { -57, 16, 0,  0,     flat,  left157 }, { -58, 16, 0,  0,     flat,  left157 },
    { -59, 16, 0, 16, inverted, unbanked }, { -60, 16, 0, 16, inverted, unbanked }, { -61, 16, 0, 16, inverted, unbanked }, { -62, 16, 0, 16, inverted, unbanked }, { -63, 16, 0, 16, inverted, unbanked },
    { -64, 16, 0, 16, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D9F60, {
    { 16,  0, 0,  8,     flat, unbanked }, { 16,  1, 0,  8,     flat, unbanked }, { 16,  2, 0,  8,     flat, unbanked }, { 16,  3, 0,  8,     flat, unbanked }, { 16,  4, 0,  8,     flat, unbanked },
    { 16,  5, 0,  8,     flat,   left22 }, { 16,  6, 0,  8,     flat,   left22 }, { 16,  7, 0,  8,     flat,   left22 }, { 16,  8, 0,  8,     flat,   left22 }, { 16,  9, 0,  8,     flat,   left22 },
    { 16, 10, 0,  8,     flat,   left22 }, { 16, 11, 0,  8,     flat,   left22 }, { 16, 12, 0,  8,     flat,   left22 }, { 16, 13, 0,  8,     flat,   left22 }, { 16, 14, 0,  8,     flat,   left22 },
    { 16, 15, 0,  8,     flat,   left22 }, { 16, 16, 0,  8,     flat,   left22 }, { 16, 17, 0,  8,     flat,   left22 }, { 16, 18, 0,  8,     flat,   left45 }, { 16, 19, 0,  8,     flat,   left45 },
    { 16, 20, 0,  8,     flat,   left45 }, { 16, 21, 0,  8,     flat,   left45 }, { 16, 22, 0,  8,     flat,   left45 }, { 16, 23, 0,  8,     flat,   left45 }, { 16, 24, 0,  8,     flat,   left45 },
    { 16, 25, 0,  8,     flat,   left45 }, { 16, 26, 0,  8,     flat,   left45 }, { 16, 27, 0,  8,     flat,   left45 }, { 16, 28, 0,  8,     flat,   left45 }, { 16, 29, 0,  8,     flat,   left67 },
    { 16, 30, 0,  8,     flat,   left67 }, { 16, 31, 0,  8,     flat,   left67 }, { 16, 32, 0,  8,     flat,   left67 }, { 16, 33, 0,  8,     flat,   left67 }, { 16, 34, 0,  8,     flat,   left67 },
    { 16, 35, 0,  8,     flat,   left67 }, { 16, 36, 0,  8,     flat,   left67 }, { 16, 37, 0,  8,     flat,   left67 }, { 16, 38, 0,  8,     flat,   left67 }, { 16, 39, 0,  8,     flat,   left67 },
    { 16, 40, 0,  8,     flat,   left67 }, { 16, 41, 0,  8,     flat,   left67 }, { 16, 42, 0,  8,     flat,   left90 }, { 16, 43, 0,  8,     flat,   left90 }, { 16, 44, 0,  8,     flat,   left90 },
    { 16, 45, 0,  8,     flat,   left90 }, { 16, 46, 0,  8,     flat,   left90 }, { 16, 47, 0,  8,     flat,   left90 }, { 16, 48, 0,  8,     flat,   left90 }, { 16, 49, 0,  8,     flat,   left90 },
    { 16, 50, 0,  8,     flat,   left90 }, { 16, 51, 0,  8,     flat,   left90 }, { 16, 52, 0,  8,     flat,   left90 }, { 16, 53, 0,  8,     flat,  left112 }, { 16, 54, 0,  8,     flat,  left112 },
    { 16, 55, 0,  8,     flat,  left112 }, { 16, 56, 0,  8,     flat,  left112 }, { 16, 57, 0,  8,     flat,  left112 }, { 16, 58, 0,  8,     flat,  left112 }, { 16, 59, 0,  8,     flat,  left112 },
    { 16, 60, 0,  8,     flat,  left112 }, { 16, 61, 0,  8,     flat,  left112 }, { 16, 62, 0,  8,     flat,  left112 }, { 16, 63, 0,  8,     flat,  left112 }, { 16, 64, 0,  8,     flat,  left112 },
    { 16, 65, 0,  8,     flat,  left112 }, { 16, 66, 0,  8,     flat,  left135 }, { 16, 67, 0,  8,     flat,  left135 }, { 16, 68, 0,  8,     flat,  left135 }, { 16, 69, 0,  8,     flat,  left135 },
    { 16, 70, 0,  8,     flat,  left135 }, { 16, 71, 0,  8,     flat,  left135 }, { 16, 72, 0,  8,     flat,  left135 }, { 16, 73, 0,  8,     flat,  left135 }, { 16, 74, 0,  8,     flat,  left135 },
    { 16, 75, 0,  8,     flat,  left135 }, { 16, 76, 0,  8,     flat,  left135 }, { 16, 77, 0,  8,     flat,  left157 }, { 16, 78, 0,  8,     flat,  left157 }, { 16, 79, 0,  8,     flat,  left157 },
    { 16, 80, 0,  8,     flat,  left157 }, { 16, 81, 0,  8,     flat,  left157 }, { 16, 82, 0,  8,     flat,  left157 }, { 16, 83, 0,  8,     flat,  left157 }, { 16, 84, 0,  8,     flat,  left157 },
    { 16, 85, 0,  8,     flat,  left157 }, { 16, 86, 0,  8,     flat,  left157 }, { 16, 87, 0,  8,     flat,  left157 }, { 16, 88, 0,  8,     flat,  left157 }, { 16, 89, 0,  8,     flat,  left157 },
    { 16, 90, 0, 24, inverted, unbanked }, { 16, 91, 0, 24, inverted, unbanked }, { 16, 92, 0, 24, inverted, unbanked }, { 16, 93, 0, 24, inverted, unbanked }, { 16, 94, 0, 24, inverted, unbanked },
    { 16, 95, 0, 24, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DA2C2, {
    {  0, 16, 0, 16,     flat, unbanked }, {  1, 16, 0, 16,     flat, unbanked }, {  2, 16, 0, 16,     flat, unbanked }, {  3, 16, 0, 16,     flat, unbanked }, {  4, 16, 0, 16,     flat, unbanked },
    {  5, 16, 0, 16,     flat,   left22 }, {  6, 16, 0, 16,     flat,   left22 }, {  7, 16, 0, 16,     flat,   left22 }, {  8, 16, 0, 16,     flat,   left22 }, {  9, 16, 0, 16,     flat,   left22 },
    { 10, 16, 0, 16,     flat,   left22 }, { 11, 16, 0, 16,     flat,   left22 }, { 12, 16, 0, 16,     flat,   left22 }, { 13, 16, 0, 16,     flat,   left22 }, { 14, 16, 0, 16,     flat,   left22 },
    { 15, 16, 0, 16,     flat,   left22 }, { 16, 16, 0, 16,     flat,   left22 }, { 17, 16, 0, 16,     flat,   left22 }, { 18, 16, 0, 16,     flat,   left45 }, { 19, 16, 0, 16,     flat,   left45 },
    { 20, 16, 0, 16,     flat,   left45 }, { 21, 16, 0, 16,     flat,   left45 }, { 22, 16, 0, 16,     flat,   left45 }, { 23, 16, 0, 16,     flat,   left45 }, { 24, 16, 0, 16,     flat,   left45 },
    { 25, 16, 0, 16,     flat,   left45 }, { 26, 16, 0, 16,     flat,   left45 }, { 27, 16, 0, 16,     flat,   left45 }, { 28, 16, 0, 16,     flat,   left45 }, { 29, 16, 0, 16,     flat,   left67 },
    { 30, 16, 0, 16,     flat,   left67 }, { 31, 16, 0, 16,     flat,   left67 }, { 32, 16, 0, 16,     flat,   left67 }, { 33, 16, 0, 16,     flat,   left67 }, { 34, 16, 0, 16,     flat,   left67 },
    { 35, 16, 0, 16,     flat,   left67 }, { 36, 16, 0, 16,     flat,   left67 }, { 37, 16, 0, 16,     flat,   left67 }, { 38, 16, 0, 16,     flat,   left67 }, { 39, 16, 0, 16,     flat,   left67 },
    { 40, 16, 0, 16,     flat,   left67 }, { 41, 16, 0, 16,     flat,   left67 }, { 42, 16, 0, 16,     flat,   left90 }, { 43, 16, 0, 16,     flat,   left90 }, { 44, 16, 0, 16,     flat,   left90 },
    { 45, 16, 0, 16,     flat,   left90 }, { 46, 16, 0, 16,     flat,   left90 }, { 47, 16, 0, 16,     flat,   left90 }, { 48, 16, 0, 16,     flat,   left90 }, { 49, 16, 0, 16,     flat,   left90 },
    { 50, 16, 0, 16,     flat,   left90 }, { 51, 16, 0, 16,     flat,   left90 }, { 52, 16, 0, 16,     flat,   left90 }, { 53, 16, 0, 16,     flat,  left112 }, { 54, 16, 0, 16,     flat,  left112 },
    { 55, 16, 0, 16,     flat,  left112 }, { 56, 16, 0, 16,     flat,  left112 }, { 57, 16, 0, 16,     flat,  left112 }, { 58, 16, 0, 16,     flat,  left112 }, { 59, 16, 0, 16,     flat,  left112 },
    { 60, 16, 0, 16,     flat,  left112 }, { 61, 16, 0, 16,     flat,  left112 }, { 62, 16, 0, 16,     flat,  left112 }, { 63, 16, 0, 16,     flat,  left112 }, { 64, 16, 0, 16,     flat,  left112 },
    { 65, 16, 0, 16,     flat,  left112 }, { 66, 16, 0, 16,     flat,  left135 }, { 67, 16, 0, 16,     flat,  left135 }, { 68, 16, 0, 16,     flat,  left135 }, { 69, 16, 0, 16,     flat,  left135 },
    { 70, 16, 0, 16,     flat,  left135 }, { 71, 16, 0, 16,     flat,  left135 }, { 72, 16, 0, 16,     flat,  left135 }, { 73, 16, 0, 16,     flat,  left135 }, { 74, 16, 0, 16,     flat,  left135 },
    { 75, 16, 0, 16,     flat,  left135 }, { 76, 16, 0, 16,     flat,  left135 }, { 77, 16, 0, 16,     flat,  left157 }, { 78, 16, 0, 16,     flat,  left157 }, { 79, 16, 0, 16,     flat,  left157 },
    { 80, 16, 0, 16,     flat,  left157 }, { 81, 16, 0, 16,     flat,  left157 }, { 82, 16, 0, 16,     flat,  left157 }, { 83, 16, 0, 16,     flat,  left157 }, { 84, 16, 0, 16,     flat,  left157 },
    { 85, 16, 0, 16,     flat,  left157 }, { 86, 16, 0, 16,     flat,  left157 }, { 87, 16, 0, 16,     flat,  left157 }, { 88, 16, 0, 16,     flat,  left157 }, { 89, 16, 0, 16,     flat,  left157 },
    { 90, 16, 0,  0, inverted, unbanked }, { 91, 16, 0,  0, inverted, unbanked }, { 92, 16, 0,  0, inverted, unbanked }, { 93, 16, 0,  0, inverted, unbanked }, { 94, 16, 0,  0, inverted, unbanked },
    { 95, 16, 0,  0, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DA624, {
    { 16,  31, 0, 24,     flat, unbanked }, { 16,  30, 0, 24,     flat, unbanked }, { 16,  29, 0, 24,     flat, unbanked }, { 16,  28, 0, 24,     flat, unbanked }, { 16,  27, 0, 24,     flat, unbanked },
    { 16,  26, 0, 24,     flat,   left22 }, { 16,  25, 0, 24,     flat,   left22 }, { 16,  24, 0, 24,     flat,   left22 }, { 16,  23, 0, 24,     flat,   left22 }, { 16,  22, 0, 24,     flat,   left22 },
    { 16,  21, 0, 24,     flat,   left22 }, { 16,  20, 0, 24,     flat,   left22 }, { 16,  19, 0, 24,     flat,   left22 }, { 16,  18, 0, 24,     flat,   left22 }, { 16,  17, 0, 24,     flat,   left22 },
    { 16,  16, 0, 24,     flat,   left22 }, { 16,  15, 0, 24,     flat,   left22 }, { 16,  14, 0, 24,     flat,   left22 }, { 16,  13, 0, 24,     flat,   left45 }, { 16,  12, 0, 24,     flat,   left45 },
    { 16,  11, 0, 24,     flat,   left45 }, { 16,  10, 0, 24,     flat,   left45 }, { 16,   9, 0, 24,     flat,   left45 }, { 16,   8, 0, 24,     flat,   left45 }, { 16,   7, 0, 24,     flat,   left45 },
    { 16,   6, 0, 24,     flat,   left45 }, { 16,   5, 0, 24,     flat,   left45 }, { 16,   4, 0, 24,     flat,   left45 }, { 16,   3, 0, 24,     flat,   left45 }, { 16,   2, 0, 24,     flat,   left67 },
    { 16,   1, 0, 24,     flat,   left67 }, { 16,   0, 0, 24,     flat,   left67 }, { 16,  -1, 0, 24,     flat,   left67 }, { 16,  -2, 0, 24,     flat,   left67 }, { 16,  -3, 0, 24,     flat,   left67 },
    { 16,  -4, 0, 24,     flat,   left67 }, { 16,  -5, 0, 24,     flat,   left67 }, { 16,  -6, 0, 24,     flat,   left67 }, { 16,  -7, 0, 24,     flat,   left67 }, { 16,  -8, 0, 24,     flat,   left67 },
    { 16,  -9, 0, 24,     flat,   left67 }, { 16, -10, 0, 24,     flat,   left67 }, { 16, -11, 0, 24,     flat,   left90 }, { 16, -12, 0, 24,     flat,   left90 }, { 16, -13, 0, 24,     flat,   left90 },
    { 16, -14, 0, 24,     flat,   left90 }, { 16, -15, 0, 24,     flat,   left90 }, { 16, -16, 0, 24,     flat,   left90 }, { 16, -17, 0, 24,     flat,   left90 }, { 16, -18, 0, 24,     flat,   left90 },
    { 16, -19, 0, 24,     flat,   left90 }, { 16, -20, 0, 24,     flat,   left90 }, { 16, -21, 0, 24,     flat,   left90 }, { 16, -22, 0, 24,     flat,  left112 }, { 16, -23, 0, 24,     flat,  left112 },
    { 16, -24, 0, 24,     flat,  left112 }, { 16, -25, 0, 24,     flat,  left112 }, { 16, -26, 0, 24,     flat,  left112 }, { 16, -27, 0, 24,     flat,  left112 }, { 16, -28, 0, 24,     flat,  left112 },
    { 16, -29, 0, 24,     flat,  left112 }, { 16, -30, 0, 24,     flat,  left112 }, { 16, -31, 0, 24,     flat,  left112 }, { 16, -32, 0, 24,     flat,  left112 }, { 16, -33, 0, 24,     flat,  left112 },
    { 16, -34, 0, 24,     flat,  left112 }, { 16, -35, 0, 24,     flat,  left135 }, { 16, -36, 0, 24,     flat,  left135 }, { 16, -37, 0, 24,     flat,  left135 }, { 16, -38, 0, 24,     flat,  left135 },
    { 16, -39, 0, 24,     flat,  left135 }, { 16, -40, 0, 24,     flat,  left135 }, { 16, -41, 0, 24,     flat,  left135 }, { 16, -42, 0, 24,     flat,  left135 }, { 16, -43, 0, 24,     flat,  left135 },
    { 16, -44, 0, 24,     flat,  left135 }, { 16, -45, 0, 24,     flat,  left135 }, { 16, -46, 0, 24,     flat,  left157 }, { 16, -47, 0, 24,     flat,  left157 }, { 16, -48, 0, 24,     flat,  left157 },
    { 16, -49, 0, 24,     flat,  left157 }, { 16, -50, 0, 24,     flat,  left157 }, { 16, -51, 0, 24,     flat,  left157 }, { 16, -52, 0, 24,     flat,  left157 }, { 16, -53, 0, 24,     flat,  left157 },
    { 16, -54, 0, 24,     flat,  left157 }, { 16, -55, 0, 24,     flat,  left157 }, { 16, -56, 0, 24,     flat,  left157 }, { 16, -57, 0, 24,     flat,  left157 }, { 16, -58, 0, 24,     flat,  left157 },
    { 16, -59, 0,  8, inverted, unbanked }, { 16, -60, 0,  8, inverted, unbanked }, { 16, -61, 0,  8, inverted, unbanked }, { 16, -62, 0,  8, inverted, unbanked }, { 16, -63, 0,  8, inverted, unbanked },
    { 16, -64, 0,  8, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DA986, {
    {  31, 16, 0,  0,     flat, unbanked }, {  30, 16, 0,  0,     flat, unbanked }, {  29, 16, 0,  0,     flat, unbanked }, {  28, 16, 0,  0,     flat, unbanked }, {  27, 16, 0,  0,     flat, unbanked },
    {  26, 16, 0,  0,     flat,  right22 }, {  25, 16, 0,  0,     flat,  right22 }, {  24, 16, 0,  0,     flat,  right22 }, {  23, 16, 0,  0,     flat,  right22 }, {  22, 16, 0,  0,     flat,  right22 },
    {  21, 16, 0,  0,     flat,  right22 }, {  20, 16, 0,  0,     flat,  right22 }, {  19, 16, 0,  0,     flat,  right22 }, {  18, 16, 0,  0,     flat,  right22 }, {  17, 16, 0,  0,     flat,  right22 },
    {  16, 16, 0,  0,     flat,  right22 }, {  15, 16, 0,  0,     flat,  right22 }, {  14, 16, 0,  0,     flat,  right22 }, {  13, 16, 0,  0,     flat,  right45 }, {  12, 16, 0,  0,     flat,  right45 },
    {  11, 16, 0,  0,     flat,  right45 }, {  10, 16, 0,  0,     flat,  right45 }, {   9, 16, 0,  0,     flat,  right45 }, {   8, 16, 0,  0,     flat,  right45 }, {   7, 16, 0,  0,     flat,  right45 },
    {   6, 16, 0,  0,     flat,  right45 }, {   5, 16, 0,  0,     flat,  right45 }, {   4, 16, 0,  0,     flat,  right45 }, {   3, 16, 0,  0,     flat,  right45 }, {   2, 16, 0,  0,     flat,  right67 },
    {   1, 16, 0,  0,     flat,  right67 }, {   0, 16, 0,  0,     flat,  right67 }, {  -1, 16, 0,  0,     flat,  right67 }, {  -2, 16, 0,  0,     flat,  right67 }, {  -3, 16, 0,  0,     flat,  right67 },
    {  -4, 16, 0,  0,     flat,  right67 }, {  -5, 16, 0,  0,     flat,  right67 }, {  -6, 16, 0,  0,     flat,  right67 }, {  -7, 16, 0,  0,     flat,  right67 }, {  -8, 16, 0,  0,     flat,  right67 },
    {  -9, 16, 0,  0,     flat,  right67 }, { -10, 16, 0,  0,     flat,  right67 }, { -11, 16, 0,  0,     flat,  right90 }, { -12, 16, 0,  0,     flat,  right90 }, { -13, 16, 0,  0,     flat,  right90 },
    { -14, 16, 0,  0,     flat,  right90 }, { -15, 16, 0,  0,     flat,  right90 }, { -16, 16, 0,  0,     flat,  right90 }, { -17, 16, 0,  0,     flat,  right90 }, { -18, 16, 0,  0,     flat,  right90 },
    { -19, 16, 0,  0,     flat,  right90 }, { -20, 16, 0,  0,     flat,  right90 }, { -21, 16, 0,  0,     flat,  right90 }, { -22, 16, 0,  0,     flat, right112 }, { -23, 16, 0,  0,     flat, right112 },
    { -24, 16, 0,  0,     flat, right112 }, { -25, 16, 0,  0,     flat, right112 }, { -26, 16, 0,  0,     flat, right112 }, { -27, 16, 0,  0,     flat, right112 }, { -28, 16, 0,  0,     flat, right112 },
    { -29, 16, 0,  0,     flat, right112 }, { -30, 16, 0,  0,     flat, right112 }, { -31, 16, 0,  0,     flat, right112 }, { -32, 16, 0,  0,     flat, right112 }, { -33, 16, 0,  0,     flat, right112 },
    { -34, 16, 0,  0,     flat, right112 }, { -35, 16, 0,  0,     flat, right135 }, { -36, 16, 0,  0,     flat, right135 }, { -37, 16, 0,  0,     flat, right135 }, { -38, 16, 0,  0,     flat, right135 },
    { -39, 16, 0,  0,     flat, right135 }, { -40, 16, 0,  0,     flat, right135 }, { -41, 16, 0,  0,     flat, right135 }, { -42, 16, 0,  0,     flat, right135 }, { -43, 16, 0,  0,     flat, right135 },
    { -44, 16, 0,  0,     flat, right135 }, { -45, 16, 0,  0,     flat, right135 }, { -46, 16, 0,  0,     flat, right157 }, { -47, 16, 0,  0,     flat, right157 }, { -48, 16, 0,  0,     flat, right157 },
    { -49, 16, 0,  0,     flat, right157 }, { -50, 16, 0,  0,     flat, right157 }, { -51, 16, 0,  0,     flat, right157 }, { -52, 16, 0,  0,     flat, right157 }, { -53, 16, 0,  0,     flat, right157 },
    { -54, 16, 0,  0,     flat, right157 }, { -55, 16, 0,  0,     flat, right157 }, { -56, 16, 0,  0,     flat, right157 }, { -57, 16, 0,  0,     flat, right157 }, { -58, 16, 0,  0,     flat, right157 },
    { -59, 16, 0, 16, inverted, unbanked }, { -60, 16, 0, 16, inverted, unbanked }, { -61, 16, 0, 16, inverted, unbanked }, { -62, 16, 0, 16, inverted, unbanked }, { -63, 16, 0, 16, inverted, unbanked },
    { -64, 16, 0, 16, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DACE8, {
    { 16,  0, 0,  8,     flat, unbanked }, { 16,  1, 0,  8,     flat, unbanked }, { 16,  2, 0,  8,     flat, unbanked }, { 16,  3, 0,  8,     flat, unbanked }, { 16,  4, 0,  8,     flat, unbanked },
    { 16,  5, 0,  8,     flat,  right22 }, { 16,  6, 0,  8,     flat,  right22 }, { 16,  7, 0,  8,     flat,  right22 }, { 16,  8, 0,  8,     flat,  right22 }, { 16,  9, 0,  8,     flat,  right22 },
    { 16, 10, 0,  8,     flat,  right22 }, { 16, 11, 0,  8,     flat,  right22 }, { 16, 12, 0,  8,     flat,  right22 }, { 16, 13, 0,  8,     flat,  right22 }, { 16, 14, 0,  8,     flat,  right22 },
    { 16, 15, 0,  8,     flat,  right22 }, { 16, 16, 0,  8,     flat,  right22 }, { 16, 17, 0,  8,     flat,  right22 }, { 16, 18, 0,  8,     flat,  right45 }, { 16, 19, 0,  8,     flat,  right45 },
    { 16, 20, 0,  8,     flat,  right45 }, { 16, 21, 0,  8,     flat,  right45 }, { 16, 22, 0,  8,     flat,  right45 }, { 16, 23, 0,  8,     flat,  right45 }, { 16, 24, 0,  8,     flat,  right45 },
    { 16, 25, 0,  8,     flat,  right45 }, { 16, 26, 0,  8,     flat,  right45 }, { 16, 27, 0,  8,     flat,  right45 }, { 16, 28, 0,  8,     flat,  right45 }, { 16, 29, 0,  8,     flat,  right67 },
    { 16, 30, 0,  8,     flat,  right67 }, { 16, 31, 0,  8,     flat,  right67 }, { 16, 32, 0,  8,     flat,  right67 }, { 16, 33, 0,  8,     flat,  right67 }, { 16, 34, 0,  8,     flat,  right67 },
    { 16, 35, 0,  8,     flat,  right67 }, { 16, 36, 0,  8,     flat,  right67 }, { 16, 37, 0,  8,     flat,  right67 }, { 16, 38, 0,  8,     flat,  right67 }, { 16, 39, 0,  8,     flat,  right67 },
    { 16, 40, 0,  8,     flat,  right67 }, { 16, 41, 0,  8,     flat,  right67 }, { 16, 42, 0,  8,     flat,  right90 }, { 16, 43, 0,  8,     flat,  right90 }, { 16, 44, 0,  8,     flat,  right90 },
    { 16, 45, 0,  8,     flat,  right90 }, { 16, 46, 0,  8,     flat,  right90 }, { 16, 47, 0,  8,     flat,  right90 }, { 16, 48, 0,  8,     flat,  right90 }, { 16, 49, 0,  8,     flat,  right90 },
    { 16, 50, 0,  8,     flat,  right90 }, { 16, 51, 0,  8,     flat,  right90 }, { 16, 52, 0,  8,     flat,  right90 }, { 16, 53, 0,  8,     flat, right112 }, { 16, 54, 0,  8,     flat, right112 },
    { 16, 55, 0,  8,     flat, right112 }, { 16, 56, 0,  8,     flat, right112 }, { 16, 57, 0,  8,     flat, right112 }, { 16, 58, 0,  8,     flat, right112 }, { 16, 59, 0,  8,     flat, right112 },
    { 16, 60, 0,  8,     flat, right112 }, { 16, 61, 0,  8,     flat, right112 }, { 16, 62, 0,  8,     flat, right112 }, { 16, 63, 0,  8,     flat, right112 }, { 16, 64, 0,  8,     flat, right112 },
    { 16, 65, 0,  8,     flat, right112 }, { 16, 66, 0,  8,     flat, right135 }, { 16, 67, 0,  8,     flat, right135 }, { 16, 68, 0,  8,     flat, right135 }, { 16, 69, 0,  8,     flat, right135 },
    { 16, 70, 0,  8,     flat, right135 }, { 16, 71, 0,  8,     flat, right135 }, { 16, 72, 0,  8,     flat, right135 }, { 16, 73, 0,  8,     flat, right135 }, { 16, 74, 0,  8,     flat, right135 },
    { 16, 75, 0,  8,     flat, right135 }, { 16, 76, 0,  8,     flat, right135 }, { 16, 77, 0,  8,     flat, right157 }, { 16, 78, 0,  8,     flat, right157 }, { 16, 79, 0,  8,     flat, right157 },
    { 16, 80, 0,  8,     flat, right157 }, { 16, 81, 0,  8,     flat, right157 }, { 16, 82, 0,  8,     flat, right157 }, { 16, 83, 0,  8,     flat, right157 }, { 16, 84, 0,  8,     flat, right157 },
    { 16, 85, 0,  8,     flat, right157 }, { 16, 86, 0,  8,     flat, right157 }, { 16, 87, 0,  8,     flat, right157 }, { 16, 88, 0,  8,     flat, right157 }, { 16, 89, 0,  8,     flat, right157 },
    { 16, 90, 0, 24, inverted, unbanked }, { 16, 91, 0, 24, inverted, unbanked }, { 16, 92, 0, 24, inverted, unbanked }, { 16, 93, 0, 24, inverted, unbanked }, { 16, 94, 0, 24, inverted, unbanked },
    { 16, 95, 0, 24, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DB04A, {
    {  0, 16, 0, 16,     flat, unbanked }, {  1, 16, 0, 16,     flat, unbanked }, {  2, 16, 0, 16,     flat, unbanked }, {  3, 16, 0, 16,     flat, unbanked }, {  4, 16, 0, 16,     flat, unbanked },
    {  5, 16, 0, 16,     flat,  right22 }, {  6, 16, 0, 16,     flat,  right22 }, {  7, 16, 0, 16,     flat,  right22 }, {  8, 16, 0, 16,     flat,  right22 }, {  9, 16, 0, 16,     flat,  right22 },
    { 10, 16, 0, 16,     flat,  right22 }, { 11, 16, 0, 16,     flat,  right22 }, { 12, 16, 0, 16,     flat,  right22 }, { 13, 16, 0, 16,     flat,  right22 }, { 14, 16, 0, 16,     flat,  right22 },
    { 15, 16, 0, 16,     flat,  right22 }, { 16, 16, 0, 16,     flat,  right22 }, { 17, 16, 0, 16,     flat,  right22 }, { 18, 16, 0, 16,     flat,  right45 }, { 19, 16, 0, 16,     flat,  right45 },
    { 20, 16, 0, 16,     flat,  right45 }, { 21, 16, 0, 16,     flat,  right45 }, { 22, 16, 0, 16,     flat,  right45 }, { 23, 16, 0, 16,     flat,  right45 }, { 24, 16, 0, 16,     flat,  right45 },
    { 25, 16, 0, 16,     flat,  right45 }, { 26, 16, 0, 16,     flat,  right45 }, { 27, 16, 0, 16,     flat,  right45 }, { 28, 16, 0, 16,     flat,  right45 }, { 29, 16, 0, 16,     flat,  right67 },
    { 30, 16, 0, 16,     flat,  right67 }, { 31, 16, 0, 16,     flat,  right67 }, { 32, 16, 0, 16,     flat,  right67 }, { 33, 16, 0, 16,     flat,  right67 }, { 34, 16, 0, 16,     flat,  right67 },
    { 35, 16, 0, 16,     flat,  right67 }, { 36, 16, 0, 16,     flat,  right67 }, { 37, 16, 0, 16,     flat,  right67 }, { 38, 16, 0, 16,     flat,  right67 }, { 39, 16, 0, 16,     flat,  right67 },
    { 40, 16, 0, 16,     flat,  right67 }, { 41, 16, 0, 16,     flat,  right67 }, { 42, 16, 0, 16,     flat,  right90 }, { 43, 16, 0, 16,     flat,  right90 }, { 44, 16, 0, 16,     flat,  right90 },
    { 45, 16, 0, 16,     flat,  right90 }, { 46, 16, 0, 16,     flat,  right90 }, { 47, 16, 0, 16,     flat,  right90 }, { 48, 16, 0, 16,     flat,  right90 }, { 49, 16, 0, 16,     flat,  right90 },
    { 50, 16, 0, 16,     flat,  right90 }, { 51, 16, 0, 16,     flat,  right90 }, { 52, 16, 0, 16,     flat,  right90 }, { 53, 16, 0, 16,     flat, right112 }, { 54, 16, 0, 16,     flat, right112 },
    { 55, 16, 0, 16,     flat, right112 }, { 56, 16, 0, 16,     flat, right112 }, { 57, 16, 0, 16,     flat, right112 }, { 58, 16, 0, 16,     flat, right112 }, { 59, 16, 0, 16,     flat, right112 },
    { 60, 16, 0, 16,     flat, right112 }, { 61, 16, 0, 16,     flat, right112 }, { 62, 16, 0, 16,     flat, right112 }, { 63, 16, 0, 16,     flat, right112 }, { 64, 16, 0, 16,     flat, right112 },
    { 65, 16, 0, 16,     flat, right112 }, { 66, 16, 0, 16,     flat, right135 }, { 67, 16, 0, 16,     flat, right135 }, { 68, 16, 0, 16,     flat, right135 }, { 69, 16, 0, 16,     flat, right135 },
    { 70, 16, 0, 16,     flat, right135 }, { 71, 16, 0, 16,     flat, right135 }, { 72, 16, 0, 16,     flat, right135 }, { 73, 16, 0, 16,     flat, right135 }, { 74, 16, 0, 16,     flat, right135 },
    { 75, 16, 0, 16,     flat, right135 }, { 76, 16, 0, 16,     flat, right135 }, { 77, 16, 0, 16,     flat, right157 }, { 78, 16, 0, 16,     flat, right157 }, { 79, 16, 0, 16,     flat, right157 },
    { 80, 16, 0, 16,     flat, right157 }, { 81, 16, 0, 16,     flat, right157 }, { 82, 16, 0, 16,     flat, right157 }, { 83, 16, 0, 16,     flat, right157 }, { 84, 16, 0, 16,     flat, right157 },
    { 85, 16, 0, 16,     flat, right157 }, { 86, 16, 0, 16,     flat, right157 }, { 87, 16, 0, 16,     flat, right157 }, { 88, 16, 0, 16,     flat, right157 }, { 89, 16, 0, 16,     flat, right157 },
    { 90, 16, 0,  0, inverted, unbanked }, { 91, 16, 0,  0, inverted, unbanked }, { 92, 16, 0,  0, inverted, unbanked }, { 93, 16, 0,  0, inverted, unbanked }, { 94, 16, 0,  0, inverted, unbanked },
    { 95, 16, 0,  0, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DB3AC, {
    { 16,  31, 0, 24,     flat, unbanked }, { 16,  30, 0, 24,     flat, unbanked }, { 16,  29, 0, 24,     flat, unbanked }, { 16,  28, 0, 24,     flat, unbanked }, { 16,  27, 0, 24,     flat, unbanked },
    { 16,  26, 0, 24,     flat,  right22 }, { 16,  25, 0, 24,     flat,  right22 }, { 16,  24, 0, 24,     flat,  right22 }, { 16,  23, 0, 24,     flat,  right22 }, { 16,  22, 0, 24,     flat,  right22 },
    { 16,  21, 0, 24,     flat,  right22 }, { 16,  20, 0, 24,     flat,  right22 }, { 16,  19, 0, 24,     flat,  right22 }, { 16,  18, 0, 24,     flat,  right22 }, { 16,  17, 0, 24,     flat,  right22 },
    { 16,  16, 0, 24,     flat,  right22 }, { 16,  15, 0, 24,     flat,  right22 }, { 16,  14, 0, 24,     flat,  right22 }, { 16,  13, 0, 24,     flat,  right45 }, { 16,  12, 0, 24,     flat,  right45 },
    { 16,  11, 0, 24,     flat,  right45 }, { 16,  10, 0, 24,     flat,  right45 }, { 16,   9, 0, 24,     flat,  right45 }, { 16,   8, 0, 24,     flat,  right45 }, { 16,   7, 0, 24,     flat,  right45 },
    { 16,   6, 0, 24,     flat,  right45 }, { 16,   5, 0, 24,     flat,  right45 }, { 16,   4, 0, 24,     flat,  right45 }, { 16,   3, 0, 24,     flat,  right45 }, { 16,   2, 0, 24,     flat,  right67 },
    { 16,   1, 0, 24,     flat,  right67 }, { 16,   0, 0, 24,     flat,  right67 }, { 16,  -1, 0, 24,     flat,  right67 }, { 16,  -2, 0, 24,     flat,  right67 }, { 16,  -3, 0, 24,     flat,  right67 },
    { 16,  -4, 0, 24,     flat,  right67 }, { 16,  -5, 0, 24,     flat,  right67 }, { 16,  -6, 0, 24,     flat,  right67 }, { 16,  -7, 0, 24,     flat,  right67 }, { 16,  -8, 0, 24,     flat,  right67 },
    { 16,  -9, 0, 24,     flat,  right67 }, { 16, -10, 0, 24,     flat,  right67 }, { 16, -11, 0, 24,     flat,  right90 }, { 16, -12, 0, 24,     flat,  right90 }, { 16, -13, 0, 24,     flat,  right90 },
    { 16, -14, 0, 24,     flat,  right90 }, { 16, -15, 0, 24,     flat,  right90 }, { 16, -16, 0, 24,     flat,  right90 }, { 16, -17, 0, 24,     flat,  right90 }, { 16, -18, 0, 24,     flat,  right90 },
    { 16, -19, 0, 24,     flat,  right90 }, { 16, -20, 0, 24,     flat,  right90 }, { 16, -21, 0, 24,     flat,  right90 }, { 16, -22, 0, 24,     flat, right112 }, { 16, -23, 0, 24,     flat, right112 },
    { 16, -24, 0, 24,     flat, right112 }, { 16, -25, 0, 24,     flat, right112 }, { 16, -26, 0, 24,     flat, right112 }, { 16, -27, 0, 24,     flat, right112 }, { 16, -28, 0, 24,     flat, right112 },
    { 16, -29, 0, 24,     flat, right112 }, { 16, -30, 0, 24,     flat, right112 }, { 16, -31, 0, 24,     flat, right112 }, { 16, -32, 0, 24,     flat, right112 }, { 16, -33, 0, 24,     flat, right112 },
    { 16, -34, 0, 24,     flat, right112 }, { 16, -35, 0, 24,     flat, right135 }, { 16, -36, 0, 24,     flat, right135 }, { 16, -37, 0, 24,     flat, right135 }, { 16, -38, 0, 24,     flat, right135 },
    { 16, -39, 0, 24,     flat, right135 }, { 16, -40, 0, 24,     flat, right135 }, { 16, -41, 0, 24,     flat, right135 }, { 16, -42, 0, 24,     flat, right135 }, { 16, -43, 0, 24,     flat, right135 },
    { 16, -44, 0, 24,     flat, right135 }, { 16, -45, 0, 24,     flat, right135 }, { 16, -46, 0, 24,     flat, right157 }, { 16, -47, 0, 24,     flat, right157 }, { 16, -48, 0, 24,     flat, right157 },
    { 16, -49, 0, 24,     flat, right157 }, { 16, -50, 0, 24,     flat, right157 }, { 16, -51, 0, 24,     flat, right157 }, { 16, -52, 0, 24,     flat, right157 }, { 16, -53, 0, 24,     flat, right157 },
    { 16, -54, 0, 24,     flat, right157 }, { 16, -55, 0, 24,     flat, right157 }, { 16, -56, 0, 24,     flat, right157 }, { 16, -57, 0, 24,     flat, right157 }, { 16, -58, 0, 24,     flat, right157 },
    { 16, -59, 0,  8, inverted, unbanked }, { 16, -60, 0,  8, inverted, unbanked }, { 16, -61, 0,  8, inverted, unbanked }, { 16, -62, 0,  8, inverted, unbanked }, { 16, -63, 0,  8, inverted, unbanked },
    { 16, -64, 0,  8, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DB70E, {
    {  31, 16, -16, 16, inverted, unbanked }, {  30, 16, -16, 16, inverted, unbanked }, {  29, 16, -16, 16, inverted, unbanked }, {  28, 16, -16, 16, inverted, unbanked }, {  27, 16, -16, 16, inverted, unbanked },
    {  26, 16, -16,  0,     flat, right157 }, {  25, 16, -16,  0,     flat, right157 }, {  24, 16, -16,  0,     flat, right157 }, {  23, 16, -16,  0,     flat, right157 }, {  22, 16, -16,  0,     flat, right157 },
    {  21, 16, -16,  0,     flat, right157 }, {  20, 16, -16,  0,     flat, right157 }, {  19, 16, -16,  0,     flat, right157 }, {  18, 16, -16,  0,     flat, right157 }, {  17, 16, -16,  0,     flat, right157 },
    {  16, 16, -16,  0,     flat, right157 }, {  15, 16, -16,  0,     flat, right157 }, {  14, 16, -16,  0,     flat, right157 }, {  13, 16, -16,  0,     flat, right135 }, {  12, 16, -16,  0,     flat, right135 },
    {  11, 16, -16,  0,     flat, right135 }, {  10, 16, -16,  0,     flat, right135 }, {   9, 16, -16,  0,     flat, right135 }, {   8, 16, -16,  0,     flat, right135 }, {   7, 16, -16,  0,     flat, right135 },
    {   6, 16, -16,  0,     flat, right135 }, {   5, 16, -16,  0,     flat, right135 }, {   4, 16, -16,  0,     flat, right135 }, {   3, 16, -16,  0,     flat, right135 }, {   2, 16, -16,  0,     flat, right112 },
    {   1, 16, -16,  0,     flat, right112 }, {   0, 16, -16,  0,     flat, right112 }, {  -1, 16, -16,  0,     flat, right112 }, {  -2, 16, -16,  0,     flat, right112 }, {  -3, 16, -16,  0,     flat, right112 },
    {  -4, 16, -16,  0,     flat, right112 }, {  -5, 16, -16,  0,     flat, right112 }, {  -6, 16, -16,  0,     flat, right112 }, {  -7, 16, -16,  0,     flat, right112 }, {  -8, 16, -16,  0,     flat, right112 },
    {  -9, 16, -16,  0,     flat, right112 }, { -10, 16, -16,  0,     flat, right112 }, { -11, 16, -16,  0,     flat,  right90 }, { -12, 16, -16,  0,     flat,  right90 }, { -13, 16, -16,  0,     flat,  right90 },
    { -14, 16, -16,  0,     flat,  right90 }, { -15, 16, -16,  0,     flat,  right90 }, { -16, 16, -16,  0,     flat,  right90 }, { -17, 16, -16,  0,     flat,  right90 }, { -18, 16, -16,  0,     flat,  right90 },
    { -19, 16, -16,  0,     flat,  right90 }, { -20, 16, -16,  0,     flat,  right90 }, { -21, 16, -16,  0,     flat,  right90 }, { -22, 16, -16,  0,     flat,  right67 }, { -23, 16, -16,  0,     flat,  right67 },
    { -24, 16, -16,  0,     flat,  right67 }, { -25, 16, -16,  0,     flat,  right67 }, { -26, 16, -16,  0,     flat,  right67 }, { -27, 16, -16,  0,     flat,  right67 }, { -28, 16, -16,  0,     flat,  right67 },
    { -29, 16, -16,  0,     flat,  right67 }, { -30, 16, -16,  0,     flat,  right67 }, { -31, 16, -16,  0,     flat,  right67 }, { -32, 16, -16,  0,     flat,  right67 }, { -33, 16, -16,  0,     flat,  right67 },
    { -34, 16, -16,  0,     flat,  right67 }, { -35, 16, -16,  0,     flat,  right45 }, { -36, 16, -16,  0,     flat,  right45 }, { -37, 16, -16,  0,     flat,  right45 }, { -38, 16, -16,  0,     flat,  right45 },
    { -39, 16, -16,  0,     flat,  right45 }, { -40, 16, -16,  0,     flat,  right45 }, { -41, 16, -16,  0,     flat,  right45 }, { -42, 16, -16,  0,     flat,  right45 }, { -43, 16, -16,  0,     flat,  right45 },
    { -44, 16, -16,  0,     flat,  right45 }, { -45, 16, -16,  0,     flat,  right45 }, { -46, 16, -16,  0,     flat,  right22 }, { -47, 16, -16,  0,     flat,  right22 }, { -48, 16, -16,  0,     flat,  right22 },
    { -49, 16, -16,  0,     flat,  right22 }, { -50, 16, -16,  0,     flat,  right22 }, { -51, 16, -16,  0,     flat,  right22 }, { -52, 16, -16,  0,     flat,  right22 }, { -53, 16, -16,  0,     flat,  right22 },
    { -54, 16, -16,  0,     flat,  right22 }, { -55, 16, -16,  0,     flat,  right22 }, { -56, 16, -16,  0,     flat,  right22 }, { -57, 16, -16,  0,     flat,  right22 }, { -58, 16, -16,  0,     flat,  right22 },
    { -59, 16, -16,  0,     flat, unbanked }, { -60, 16, -16,  0,     flat, unbanked }, { -61, 16, -16,  0,     flat, unbanked }, { -62, 16, -16,  0,     flat, unbanked }, { -63, 16, -16,  0,     flat, unbanked },
    { -64, 16, -16,  0,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DBA70, {
    { 16,  0, -16, 24, inverted, unbanked }, { 16,  1, -16, 24, inverted, unbanked }, { 16,  2, -16, 24, inverted, unbanked }, { 16,  3, -16, 24, inverted, unbanked }, { 16,  4, -16, 24, inverted, unbanked },
    { 16,  5, -16,  8,     flat, right157 }, { 16,  6, -16,  8,     flat, right157 }, { 16,  7, -16,  8,     flat, right157 }, { 16,  8, -16,  8,     flat, right157 }, { 16,  9, -16,  8,     flat, right157 },
    { 16, 10, -16,  8,     flat, right157 }, { 16, 11, -16,  8,     flat, right157 }, { 16, 12, -16,  8,     flat, right157 }, { 16, 13, -16,  8,     flat, right157 }, { 16, 14, -16,  8,     flat, right157 },
    { 16, 15, -16,  8,     flat, right157 }, { 16, 16, -16,  8,     flat, right157 }, { 16, 17, -16,  8,     flat, right157 }, { 16, 18, -16,  8,     flat, right135 }, { 16, 19, -16,  8,     flat, right135 },
    { 16, 20, -16,  8,     flat, right135 }, { 16, 21, -16,  8,     flat, right135 }, { 16, 22, -16,  8,     flat, right135 }, { 16, 23, -16,  8,     flat, right135 }, { 16, 24, -16,  8,     flat, right135 },
    { 16, 25, -16,  8,     flat, right135 }, { 16, 26, -16,  8,     flat, right135 }, { 16, 27, -16,  8,     flat, right135 }, { 16, 28, -16,  8,     flat, right135 }, { 16, 29, -16,  8,     flat, right112 },
    { 16, 30, -16,  8,     flat, right112 }, { 16, 31, -16,  8,     flat, right112 }, { 16, 32, -16,  8,     flat, right112 }, { 16, 33, -16,  8,     flat, right112 }, { 16, 34, -16,  8,     flat, right112 },
    { 16, 35, -16,  8,     flat, right112 }, { 16, 36, -16,  8,     flat, right112 }, { 16, 37, -16,  8,     flat, right112 }, { 16, 38, -16,  8,     flat, right112 }, { 16, 39, -16,  8,     flat, right112 },
    { 16, 40, -16,  8,     flat, right112 }, { 16, 41, -16,  8,     flat, right112 }, { 16, 42, -16,  8,     flat,  right90 }, { 16, 43, -16,  8,     flat,  right90 }, { 16, 44, -16,  8,     flat,  right90 },
    { 16, 45, -16,  8,     flat,  right90 }, { 16, 46, -16,  8,     flat,  right90 }, { 16, 47, -16,  8,     flat,  right90 }, { 16, 48, -16,  8,     flat,  right90 }, { 16, 49, -16,  8,     flat,  right90 },
    { 16, 50, -16,  8,     flat,  right90 }, { 16, 51, -16,  8,     flat,  right90 }, { 16, 52, -16,  8,     flat,  right90 }, { 16, 53, -16,  8,     flat,  right67 }, { 16, 54, -16,  8,     flat,  right67 },
    { 16, 55, -16,  8,     flat,  right67 }, { 16, 56, -16,  8,     flat,  right67 }, { 16, 57, -16,  8,     flat,  right67 }, { 16, 58, -16,  8,     flat,  right67 }, { 16, 59, -16,  8,     flat,  right67 },
    { 16, 60, -16,  8,     flat,  right67 }, { 16, 61, -16,  8,     flat,  right67 }, { 16, 62, -16,  8,     flat,  right67 }, { 16, 63, -16,  8,     flat,  right67 }, { 16, 64, -16,  8,     flat,  right67 },
    { 16, 65, -16,  8,     flat,  right67 }, { 16, 66, -16,  8,     flat,  right45 }, { 16, 67, -16,  8,     flat,  right45 }, { 16, 68, -16,  8,     flat,  right45 }, { 16, 69, -16,  8,     flat,  right45 },
    { 16, 70, -16,  8,     flat,  right45 }, { 16, 71, -16,  8,     flat,  right45 }, { 16, 72, -16,  8,     flat,  right45 }, { 16, 73, -16,  8,     flat,  right45 }, { 16, 74, -16,  8,     flat,  right45 },
    { 16, 75, -16,  8,     flat,  right45 }, { 16, 76, -16,  8,     flat,  right45 }, { 16, 77, -16,  8,     flat,  right22 }, { 16, 78, -16,  8,     flat,  right22 }, { 16, 79, -16,  8,     flat,  right22 },
    { 16, 80, -16,  8,     flat,  right22 }, { 16, 81, -16,  8,     flat,  right22 }, { 16, 82, -16,  8,     flat,  right22 }, { 16, 83, -16,  8,     flat,  right22 }, { 16, 84, -16,  8,     flat,  right22 },
    { 16, 85, -16,  8,     flat,  right22 }, { 16, 86, -16,  8,     flat,  right22 }, { 16, 87, -16,  8,     flat,  right22 }, { 16, 88, -16,  8,     flat,  right22 }, { 16, 89, -16,  8,     flat,  right22 },
    { 16, 90, -16,  8,     flat, unbanked }, { 16, 91, -16,  8,     flat, unbanked }, { 16, 92, -16,  8,     flat, unbanked }, { 16, 93, -16,  8,     flat, unbanked }, { 16, 94, -16,  8,     flat, unbanked },
    { 16, 95, -16,  8,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DBDD2, {
    {  0, 16, -16,  0, inverted, unbanked }, {  1, 16, -16,  0, inverted, unbanked }, {  2, 16, -16,  0, inverted, unbanked }, {  3, 16, -16,  0, inverted, unbanked }, {  4, 16, -16,  0, inverted, unbanked },
    {  5, 16, -16, 16,     flat, right157 }, {  6, 16, -16, 16,     flat, right157 }, {  7, 16, -16, 16,     flat, right157 }, {  8, 16, -16, 16,     flat, right157 }, {  9, 16, -16, 16,     flat, right157 },
    { 10, 16, -16, 16,     flat, right157 }, { 11, 16, -16, 16,     flat, right157 }, { 12, 16, -16, 16,     flat, right157 }, { 13, 16, -16, 16,     flat, right157 }, { 14, 16, -16, 16,     flat, right157 },
    { 15, 16, -16, 16,     flat, right157 }, { 16, 16, -16, 16,     flat, right157 }, { 17, 16, -16, 16,     flat, right157 }, { 18, 16, -16, 16,     flat, right135 }, { 19, 16, -16, 16,     flat, right135 },
    { 20, 16, -16, 16,     flat, right135 }, { 21, 16, -16, 16,     flat, right135 }, { 22, 16, -16, 16,     flat, right135 }, { 23, 16, -16, 16,     flat, right135 }, { 24, 16, -16, 16,     flat, right135 },
    { 25, 16, -16, 16,     flat, right135 }, { 26, 16, -16, 16,     flat, right135 }, { 27, 16, -16, 16,     flat, right135 }, { 28, 16, -16, 16,     flat, right135 }, { 29, 16, -16, 16,     flat, right112 },
    { 30, 16, -16, 16,     flat, right112 }, { 31, 16, -16, 16,     flat, right112 }, { 32, 16, -16, 16,     flat, right112 }, { 33, 16, -16, 16,     flat, right112 }, { 34, 16, -16, 16,     flat, right112 },
    { 35, 16, -16, 16,     flat, right112 }, { 36, 16, -16, 16,     flat, right112 }, { 37, 16, -16, 16,     flat, right112 }, { 38, 16, -16, 16,     flat, right112 }, { 39, 16, -16, 16,     flat, right112 },
    { 40, 16, -16, 16,     flat, right112 }, { 41, 16, -16, 16,     flat, right112 }, { 42, 16, -16, 16,     flat,  right90 }, { 43, 16, -16, 16,     flat,  right90 }, { 44, 16, -16, 16,     flat,  right90 },
    { 45, 16, -16, 16,     flat,  right90 }, { 46, 16, -16, 16,     flat,  right90 }, { 47, 16, -16, 16,     flat,  right90 }, { 48, 16, -16, 16,     flat,  right90 }, { 49, 16, -16, 16,     flat,  right90 },
    { 50, 16, -16, 16,     flat,  right90 }, { 51, 16, -16, 16,     flat,  right90 }, { 52, 16, -16, 16,     flat,  right90 }, { 53, 16, -16, 16,     flat,  right67 }, { 54, 16, -16, 16,     flat,  right67 },
    { 55, 16, -16, 16,     flat,  right67 }, { 56, 16, -16, 16,     flat,  right67 }, { 57, 16, -16, 16,     flat,  right67 }, { 58, 16, -16, 16,     flat,  right67 }, { 59, 16, -16, 16,     flat,  right67 },
    { 60, 16, -16, 16,     flat,  right67 }, { 61, 16, -16, 16,     flat,  right67 }, { 62, 16, -16, 16,     flat,  right67 }, { 63, 16, -16, 16,     flat,  right67 }, { 64, 16, -16, 16,     flat,  right67 },
    { 65, 16, -16, 16,     flat,  right67 }, { 66, 16, -16, 16,     flat,  right45 }, { 67, 16, -16, 16,     flat,  right45 }, { 68, 16, -16, 16,     flat,  right45 }, { 69, 16, -16, 16,     flat,  right45 },
    { 70, 16, -16, 16,     flat,  right45 }, { 71, 16, -16, 16,     flat,  right45 }, { 72, 16, -16, 16,     flat,  right45 }, { 73, 16, -16, 16,     flat,  right45 }, { 74, 16, -16, 16,     flat,  right45 },
    { 75, 16, -16, 16,     flat,  right45 }, { 76, 16, -16, 16,     flat,  right45 }, { 77, 16, -16, 16,     flat,  right22 }, { 78, 16, -16, 16,     flat,  right22 }, { 79, 16, -16, 16,     flat,  right22 },
    { 80, 16, -16, 16,     flat,  right22 }, { 81, 16, -16, 16,     flat,  right22 }, { 82, 16, -16, 16,     flat,  right22 }, { 83, 16, -16, 16,     flat,  right22 }, { 84, 16, -16, 16,     flat,  right22 },
    { 85, 16, -16, 16,     flat,  right22 }, { 86, 16, -16, 16,     flat,  right22 }, { 87, 16, -16, 16,     flat,  right22 }, { 88, 16, -16, 16,     flat,  right22 }, { 89, 16, -16, 16,     flat,  right22 },
    { 90, 16, -16, 16,     flat, unbanked }, { 91, 16, -16, 16,     flat, unbanked }, { 92, 16, -16, 16,     flat, unbanked }, { 93, 16, -16, 16,     flat, unbanked }, { 94, 16, -16, 16,     flat, unbanked },
    { 95, 16, -16, 16,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DC134, {
    { 16,  31, -16,  8, inverted, unbanked }, { 16,  30, -16,  8, inverted, unbanked }, { 16,  29, -16,  8, inverted, unbanked }, { 16,  28, -16,  8, inverted, unbanked }, { 16,  27, -16,  8, inverted, unbanked },
    { 16,  26, -16, 24,     flat, right157 }, { 16,  25, -16, 24,     flat, right157 }, { 16,  24, -16, 24,     flat, right157 }, { 16,  23, -16, 24,     flat, right157 }, { 16,  22, -16, 24,     flat, right157 },
    { 16,  21, -16, 24,     flat, right157 }, { 16,  20, -16, 24,     flat, right157 }, { 16,  19, -16, 24,     flat, right157 }, { 16,  18, -16, 24,     flat, right157 }, { 16,  17, -16, 24,     flat, right157 },
    { 16,  16, -16, 24,     flat, right157 }, { 16,  15, -16, 24,     flat, right157 }, { 16,  14, -16, 24,     flat, right157 }, { 16,  13, -16, 24,     flat, right135 }, { 16,  12, -16, 24,     flat, right135 },
    { 16,  11, -16, 24,     flat, right135 }, { 16,  10, -16, 24,     flat, right135 }, { 16,   9, -16, 24,     flat, right135 }, { 16,   8, -16, 24,     flat, right135 }, { 16,   7, -16, 24,     flat, right135 },
    { 16,   6, -16, 24,     flat, right135 }, { 16,   5, -16, 24,     flat, right135 }, { 16,   4, -16, 24,     flat, right135 }, { 16,   3, -16, 24,     flat, right135 }, { 16,   2, -16, 24,     flat, right112 },
    { 16,   1, -16, 24,     flat, right112 }, { 16,   0, -16, 24,     flat, right112 }, { 16,  -1, -16, 24,     flat, right112 }, { 16,  -2, -16, 24,     flat, right112 }, { 16,  -3, -16, 24,     flat, right112 },
    { 16,  -4, -16, 24,     flat, right112 }, { 16,  -5, -16, 24,     flat, right112 }, { 16,  -6, -16, 24,     flat, right112 }, { 16,  -7, -16, 24,     flat, right112 }, { 16,  -8, -16, 24,     flat, right112 },
    { 16,  -9, -16, 24,     flat, right112 }, { 16, -10, -16, 24,     flat, right112 }, { 16, -11, -16, 24,     flat,  right90 }, { 16, -12, -16, 24,     flat,  right90 }, { 16, -13, -16, 24,     flat,  right90 },
    { 16, -14, -16, 24,     flat,  right90 }, { 16, -15, -16, 24,     flat,  right90 }, { 16, -16, -16, 24,     flat,  right90 }, { 16, -17, -16, 24,     flat,  right90 }, { 16, -18, -16, 24,     flat,  right90 },
    { 16, -19, -16, 24,     flat,  right90 }, { 16, -20, -16, 24,     flat,  right90 }, { 16, -21, -16, 24,     flat,  right90 }, { 16, -22, -16, 24,     flat,  right67 }, { 16, -23, -16, 24,     flat,  right67 },
    { 16, -24, -16, 24,     flat,  right67 }, { 16, -25, -16, 24,     flat,  right67 }, { 16, -26, -16, 24,     flat,  right67 }, { 16, -27, -16, 24,     flat,  right67 }, { 16, -28, -16, 24,     flat,  right67 },
    { 16, -29, -16, 24,     flat,  right67 }, { 16, -30, -16, 24,     flat,  right67 }, { 16, -31, -16, 24,     flat,  right67 }, { 16, -32, -16, 24,     flat,  right67 }, { 16, -33, -16, 24,     flat,  right67 },
    { 16, -34, -16, 24,     flat,  right67 }, { 16, -35, -16, 24,     flat,  right45 }, { 16, -36, -16, 24,     flat,  right45 }, { 16, -37, -16, 24,     flat,  right45 }, { 16, -38, -16, 24,     flat,  right45 },
    { 16, -39, -16, 24,     flat,  right45 }, { 16, -40, -16, 24,     flat,  right45 }, { 16, -41, -16, 24,     flat,  right45 }, { 16, -42, -16, 24,     flat,  right45 }, { 16, -43, -16, 24,     flat,  right45 },
    { 16, -44, -16, 24,     flat,  right45 }, { 16, -45, -16, 24,     flat,  right45 }, { 16, -46, -16, 24,     flat,  right22 }, { 16, -47, -16, 24,     flat,  right22 }, { 16, -48, -16, 24,     flat,  right22 },
    { 16, -49, -16, 24,     flat,  right22 }, { 16, -50, -16, 24,     flat,  right22 }, { 16, -51, -16, 24,     flat,  right22 }, { 16, -52, -16, 24,     flat,  right22 }, { 16, -53, -16, 24,     flat,  right22 },
    { 16, -54, -16, 24,     flat,  right22 }, { 16, -55, -16, 24,     flat,  right22 }, { 16, -56, -16, 24,     flat,  right22 }, { 16, -57, -16, 24,     flat,  right22 }, { 16, -58, -16, 24,     flat,  right22 },
    { 16, -59, -16, 24,     flat, unbanked }, { 16, -60, -16, 24,     flat, unbanked }, { 16, -61, -16, 24,     flat, unbanked }, { 16, -62, -16, 24,     flat, unbanked }, { 16, -63, -16, 24,     flat, unbanked },
    { 16, -64, -16, 24,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DC496, {
    {  31, 16, -16, 16, inverted, unbanked }, {  30, 16, -16, 16, inverted, unbanked }, {  29, 16, -16, 16, inverted, unbanked }, {  28, 16, -16, 16, inverted, unbanked }, {  27, 16, -16, 16, inverted, unbanked },
    {  26, 16, -16,  0,     flat,  left157 }, {  25, 16, -16,  0,     flat,  left157 }, {  24, 16, -16,  0,     flat,  left157 }, {  23, 16, -16,  0,     flat,  left157 }, {  22, 16, -16,  0,     flat,  left157 },
    {  21, 16, -16,  0,     flat,  left157 }, {  20, 16, -16,  0,     flat,  left157 }, {  19, 16, -16,  0,     flat,  left157 }, {  18, 16, -16,  0,     flat,  left157 }, {  17, 16, -16,  0,     flat,  left157 },
    {  16, 16, -16,  0,     flat,  left157 }, {  15, 16, -16,  0,     flat,  left157 }, {  14, 16, -16,  0,     flat,  left157 }, {  13, 16, -16,  0,     flat,  left135 }, {  12, 16, -16,  0,     flat,  left135 },
    {  11, 16, -16,  0,     flat,  left135 }, {  10, 16, -16,  0,     flat,  left135 }, {   9, 16, -16,  0,     flat,  left135 }, {   8, 16, -16,  0,     flat,  left135 }, {   7, 16, -16,  0,     flat,  left135 },
    {   6, 16, -16,  0,     flat,  left135 }, {   5, 16, -16,  0,     flat,  left135 }, {   4, 16, -16,  0,     flat,  left135 }, {   3, 16, -16,  0,     flat,  left135 }, {   2, 16, -16,  0,     flat,  left112 },
    {   1, 16, -16,  0,     flat,  left112 }, {   0, 16, -16,  0,     flat,  left112 }, {  -1, 16, -16,  0,     flat,  left112 }, {  -2, 16, -16,  0,     flat,  left112 }, {  -3, 16, -16,  0,     flat,  left112 },
    {  -4, 16, -16,  0,     flat,  left112 }, {  -5, 16, -16,  0,     flat,  left112 }, {  -6, 16, -16,  0,     flat,  left112 }, {  -7, 16, -16,  0,     flat,  left112 }, {  -8, 16, -16,  0,     flat,  left112 },
    {  -9, 16, -16,  0,     flat,  left112 }, { -10, 16, -16,  0,     flat,  left112 }, { -11, 16, -16,  0,     flat,   left90 }, { -12, 16, -16,  0,     flat,   left90 }, { -13, 16, -16,  0,     flat,   left90 },
    { -14, 16, -16,  0,     flat,   left90 }, { -15, 16, -16,  0,     flat,   left90 }, { -16, 16, -16,  0,     flat,   left90 }, { -17, 16, -16,  0,     flat,   left90 }, { -18, 16, -16,  0,     flat,   left90 },
    { -19, 16, -16,  0,     flat,   left90 }, { -20, 16, -16,  0,     flat,   left90 }, { -21, 16, -16,  0,     flat,   left90 }, { -22, 16, -16,  0,     flat,   left67 }, { -23, 16, -16,  0,     flat,   left67 },
    { -24, 16, -16,  0,     flat,   left67 }, { -25, 16, -16,  0,     flat,   left67 }, { -26, 16, -16,  0,     flat,   left67 }, { -27, 16, -16,  0,     flat,   left67 }, { -28, 16, -16,  0,     flat,   left67 },
    { -29, 16, -16,  0,     flat,   left67 }, { -30, 16, -16,  0,     flat,   left67 }, { -31, 16, -16,  0,     flat,   left67 }, { -32, 16, -16,  0,     flat,   left67 }, { -33, 16, -16,  0,     flat,   left67 },
    { -34, 16, -16,  0,     flat,   left67 }, { -35, 16, -16,  0,     flat,   left45 }, { -36, 16, -16,  0,     flat,   left45 }, { -37, 16, -16,  0,     flat,   left45 }, { -38, 16, -16,  0,     flat,   left45 },
    { -39, 16, -16,  0,     flat,   left45 }, { -40, 16, -16,  0,     flat,   left45 }, { -41, 16, -16,  0,     flat,   left45 }, { -42, 16, -16,  0,     flat,   left45 }, { -43, 16, -16,  0,     flat,   left45 },
    { -44, 16, -16,  0,     flat,   left45 }, { -45, 16, -16,  0,     flat,   left45 }, { -46, 16, -16,  0,     flat,   left22 }, { -47, 16, -16,  0,     flat,   left22 }, { -48, 16, -16,  0,     flat,   left22 },
    { -49, 16, -16,  0,     flat,   left22 }, { -50, 16, -16,  0,     flat,   left22 }, { -51, 16, -16,  0,     flat,   left22 }, { -52, 16, -16,  0,     flat,   left22 }, { -53, 16, -16,  0,     flat,   left22 },
    { -54, 16, -16,  0,     flat,   left22 }, { -55, 16, -16,  0,     flat,   left22 }, { -56, 16, -16,  0,     flat,   left22 }, { -57, 16, -16,  0,     flat,   left22 }, { -58, 16, -16,  0,     flat,   left22 },
    { -59, 16, -16,  0,     flat, unbanked }, { -60, 16, -16,  0,     flat, unbanked }, { -61, 16, -16,  0,     flat, unbanked }, { -62, 16, -16,  0,     flat, unbanked }, { -63, 16, -16,  0,     flat, unbanked },
    { -64, 16, -16,  0,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DC7F8, {
    { 16,  0, -16, 24, inverted, unbanked }, { 16,  1, -16, 24, inverted, unbanked }, { 16,  2, -16, 24, inverted, unbanked }, { 16,  3, -16, 24, inverted, unbanked }, { 16,  4, -16, 24, inverted, unbanked },
    { 16,  5, -16,  8,     flat,  left157 }, { 16,  6, -16,  8,     flat,  left157 }, { 16,  7, -16,  8,     flat,  left157 }, { 16,  8, -16,  8,     flat,  left157 }, { 16,  9, -16,  8,     flat,  left157 },
    { 16, 10, -16,  8,     flat,  left157 }, { 16, 11, -16,  8,     flat,  left157 }, { 16, 12, -16,  8,     flat,  left157 }, { 16, 13, -16,  8,     flat,  left157 }, { 16, 14, -16,  8,     flat,  left157 },
    { 16, 15, -16,  8,     flat,  left157 }, { 16, 16, -16,  8,     flat,  left157 }, { 16, 17, -16,  8,     flat,  left157 }, { 16, 18, -16,  8,     flat,  left135 }, { 16, 19, -16,  8,     flat,  left135 },
    { 16, 20, -16,  8,     flat,  left135 }, { 16, 21, -16,  8,     flat,  left135 }, { 16, 22, -16,  8,     flat,  left135 }, { 16, 23, -16,  8,     flat,  left135 }, { 16, 24, -16,  8,     flat,  left135 },
    { 16, 25, -16,  8,     flat,  left135 }, { 16, 26, -16,  8,     flat,  left135 }, { 16, 27, -16,  8,     flat,  left135 }, { 16, 28, -16,  8,     flat,  left135 }, { 16, 29, -16,  8,     flat,  left112 },
    { 16, 30, -16,  8,     flat,  left112 }, { 16, 31, -16,  8,     flat,  left112 }, { 16, 32, -16,  8,     flat,  left112 }, { 16, 33, -16,  8,     flat,  left112 }, { 16, 34, -16,  8,     flat,  left112 },
    { 16, 35, -16,  8,     flat,  left112 }, { 16, 36, -16,  8,     flat,  left112 }, { 16, 37, -16,  8,     flat,  left112 }, { 16, 38, -16,  8,     flat,  left112 }, { 16, 39, -16,  8,     flat,  left112 },
    { 16, 40, -16,  8,     flat,  left112 }, { 16, 41, -16,  8,     flat,  left112 }, { 16, 42, -16,  8,     flat,   left90 }, { 16, 43, -16,  8,     flat,   left90 }, { 16, 44, -16,  8,     flat,   left90 },
    { 16, 45, -16,  8,     flat,   left90 }, { 16, 46, -16,  8,     flat,   left90 }, { 16, 47, -16,  8,     flat,   left90 }, { 16, 48, -16,  8,     flat,   left90 }, { 16, 49, -16,  8,     flat,   left90 },
    { 16, 50, -16,  8,     flat,   left90 }, { 16, 51, -16,  8,     flat,   left90 }, { 16, 52, -16,  8,     flat,   left90 }, { 16, 53, -16,  8,     flat,   left67 }, { 16, 54, -16,  8,     flat,   left67 },
    { 16, 55, -16,  8,     flat,   left67 }, { 16, 56, -16,  8,     flat,   left67 }, { 16, 57, -16,  8,     flat,   left67 }, { 16, 58, -16,  8,     flat,   left67 }, { 16, 59, -16,  8,     flat,   left67 },
    { 16, 60, -16,  8,     flat,   left67 }, { 16, 61, -16,  8,     flat,   left67 }, { 16, 62, -16,  8,     flat,   left67 }, { 16, 63, -16,  8,     flat,   left67 }, { 16, 64, -16,  8,     flat,   left67 },
    { 16, 65, -16,  8,     flat,   left67 }, { 16, 66, -16,  8,     flat,   left45 }, { 16, 67, -16,  8,     flat,   left45 }, { 16, 68, -16,  8,     flat,   left45 }, { 16, 69, -16,  8,     flat,   left45 },
    { 16, 70, -16,  8,     flat,   left45 }, { 16, 71, -16,  8,     flat,   left45 }, { 16, 72, -16,  8,     flat,   left45 }, { 16, 73, -16,  8,     flat,   left45 }, { 16, 74, -16,  8,     flat,   left45 },
    { 16, 75, -16,  8,     flat,   left45 }, { 16, 76, -16,  8,     flat,   left45 }, { 16, 77, -16,  8,     flat,   left22 }, { 16, 78, -16,  8,     flat,   left22 }, { 16, 79, -16,  8,     flat,   left22 },
    { 16, 80, -16,  8,     flat,   left22 }, { 16, 81, -16,  8,     flat,   left22 }, { 16, 82, -16,  8,     flat,   left22 }, { 16, 83, -16,  8,     flat,   left22 }, { 16, 84, -16,  8,     flat,   left22 },
    { 16, 85, -16,  8,     flat,   left22 }, { 16, 86, -16,  8,     flat,   left22 }, { 16, 87, -16,  8,     flat,   left22 }, { 16, 88, -16,  8,     flat,   left22 }, { 16, 89, -16,  8,     flat,   left22 },
    { 16, 90, -16,  8,     flat, unbanked }, { 16, 91, -16,  8,     flat, unbanked }, { 16, 92, -16,  8,     flat, unbanked }, { 16, 93, -16,  8,     flat, unbanked }, { 16, 94, -16,  8,     flat, unbanked },
    { 16, 95, -16,  8,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DCB5A, {
    {  0, 16, -16,  0, inverted, unbanked }, {  1, 16, -16,  0, inverted, unbanked }, {  2, 16, -16,  0, inverted, unbanked }, {  3, 16, -16,  0, inverted, unbanked }, {  4, 16, -16,  0, inverted, unbanked },
    {  5, 16, -16, 16,     flat,  left157 }, {  6, 16, -16, 16,     flat,  left157 }, {  7, 16, -16, 16,     flat,  left157 }, {  8, 16, -16, 16,     flat,  left157 }, {  9, 16, -16, 16,     flat,  left157 },
    { 10, 16, -16, 16,     flat,  left157 }, { 11, 16, -16, 16,     flat,  left157 }, { 12, 16, -16, 16,     flat,  left157 }, { 13, 16, -16, 16,     flat,  left157 }, { 14, 16, -16, 16,     flat,  left157 },
    { 15, 16, -16, 16,     flat,  left157 }, { 16, 16, -16, 16,     flat,  left157 }, { 17, 16, -16, 16,     flat,  left157 }, { 18, 16, -16, 16,     flat,  left135 }, { 19, 16, -16, 16,     flat,  left135 },
    { 20, 16, -16, 16,     flat,  left135 }, { 21, 16, -16, 16,     flat,  left135 }, { 22, 16, -16, 16,     flat,  left135 }, { 23, 16, -16, 16,     flat,  left135 }, { 24, 16, -16, 16,     flat,  left135 },
    { 25, 16, -16, 16,     flat,  left135 }, { 26, 16, -16, 16,     flat,  left135 }, { 27, 16, -16, 16,     flat,  left135 }, { 28, 16, -16, 16,     flat,  left135 }, { 29, 16, -16, 16,     flat,  left112 },
    { 30, 16, -16, 16,     flat,  left112 }, { 31, 16, -16, 16,     flat,  left112 }, { 32, 16, -16, 16,     flat,  left112 }, { 33, 16, -16, 16,     flat,  left112 }, { 34, 16, -16, 16,     flat,  left112 },
    { 35, 16, -16, 16,     flat,  left112 }, { 36, 16, -16, 16,     flat,  left112 }, { 37, 16, -16, 16,     flat,  left112 }, { 38, 16, -16, 16,     flat,  left112 }, { 39, 16, -16, 16,     flat,  left112 },
    { 40, 16, -16, 16,     flat,  left112 }, { 41, 16, -16, 16,     flat,  left112 }, { 42, 16, -16, 16,     flat,   left90 }, { 43, 16, -16, 16,     flat,   left90 }, { 44, 16, -16, 16,     flat,   left90 },
    { 45, 16, -16, 16,     flat,   left90 }, { 46, 16, -16, 16,     flat,   left90 }, { 47, 16, -16, 16,     flat,   left90 }, { 48, 16, -16, 16,     flat,   left90 }, { 49, 16, -16, 16,     flat,   left90 },
    { 50, 16, -16, 16,     flat,   left90 }, { 51, 16, -16, 16,     flat,   left90 }, { 52, 16, -16, 16,     flat,   left90 }, { 53, 16, -16, 16,     flat,   left67 }, { 54, 16, -16, 16,     flat,   left67 },
    { 55, 16, -16, 16,     flat,   left67 }, { 56, 16, -16, 16,     flat,   left67 }, { 57, 16, -16, 16,     flat,   left67 }, { 58, 16, -16, 16,     flat,   left67 }, { 59, 16, -16, 16,     flat,   left67 },
    { 60, 16, -16, 16,     flat,   left67 }, { 61, 16, -16, 16,     flat,   left67 }, { 62, 16, -16, 16,     flat,   left67 }, { 63, 16, -16, 16,     flat,   left67 }, { 64, 16, -16, 16,     flat,   left67 },
    { 65, 16, -16, 16,     flat,   left67 }, { 66, 16, -16, 16,     flat,   left45 }, { 67, 16, -16, 16,     flat,   left45 }, { 68, 16, -16, 16,     flat,   left45 }, { 69, 16, -16, 16,     flat,   left45 },
    { 70, 16, -16, 16,     flat,   left45 }, { 71, 16, -16, 16,     flat,   left45 }, { 72, 16, -16, 16,     flat,   left45 }, { 73, 16, -16, 16,     flat,   left45 }, { 74, 16, -16, 16,     flat,   left45 },
    { 75, 16, -16, 16,     flat,   left45 }, { 76, 16, -16, 16,     flat,   left45 }, { 77, 16, -16, 16,     flat,   left22 }, { 78, 16, -16, 16,     flat,   left22 }, { 79, 16, -16, 16,     flat,   left22 },
    { 80, 16, -16, 16,     flat,   left22 }, { 81, 16, -16, 16,     flat,   left22 }, { 82, 16, -16, 16,     flat,   left22 }, { 83, 16, -16, 16,     flat,   left22 }, { 84, 16, -16, 16,     flat,   left22 },
    { 85, 16, -16, 16,     flat,   left22 }, { 86, 16, -16, 16,     flat,   left22 }, { 87, 16, -16, 16,     flat,   left22 }, { 88, 16, -16, 16,     flat,   left22 }, { 89, 16, -16, 16,     flat,   left22 },
    { 90, 16, -16, 16,     flat, unbanked }, { 91, 16, -16, 16,     flat, unbanked }, { 92, 16, -16, 16,     flat, unbanked }, { 93, 16, -16, 16,     flat, unbanked }, { 94, 16, -16, 16,     flat, unbanked },
    { 95, 16, -16, 16,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DCEBC, {
    { 16,  31, -16,  8, inverted, unbanked }, { 16,  30, -16,  8, inverted, unbanked }, { 16,  29, -16,  8, inverted, unbanked }, { 16,  28, -16,  8, inverted, unbanked }, { 16,  27, -16,  8, inverted, unbanked },
    { 16,  26, -16, 24,     flat,  left157 }, { 16,  25, -16, 24,     flat,  left157 }, { 16,  24, -16, 24,     flat,  left157 }, { 16,  23, -16, 24,     flat,  left157 }, { 16,  22, -16, 24,     flat,  left157 },
    { 16,  21, -16, 24,     flat,  left157 }, { 16,  20, -16, 24,     flat,  left157 }, { 16,  19, -16, 24,     flat,  left157 }, { 16,  18, -16, 24,     flat,  left157 }, { 16,  17, -16, 24,     flat,  left157 },
    { 16,  16, -16, 24,     flat,  left157 }, { 16,  15, -16, 24,     flat,  left157 }, { 16,  14, -16, 24,     flat,  left157 }, { 16,  13, -16, 24,     flat,  left135 }, { 16,  12, -16, 24,     flat,  left135 },
    { 16,  11, -16, 24,     flat,  left135 }, { 16,  10, -16, 24,     flat,  left135 }, { 16,   9, -16, 24,     flat,  left135 }, { 16,   8, -16, 24,     flat,  left135 }, { 16,   7, -16, 24,     flat,  left135 },
    { 16,   6, -16, 24,     flat,  left135 }, { 16,   5, -16, 24,     flat,  left135 }, { 16,   4, -16, 24,     flat,  left135 }, { 16,   3, -16, 24,     flat,  left135 }, { 16,   2, -16, 24,     flat,  left112 },
    { 16,   1, -16, 24,     flat,  left112 }, { 16,   0, -16, 24,     flat,  left112 }, { 16,  -1, -16, 24,     flat,  left112 }, { 16,  -2, -16, 24,     flat,  left112 }, { 16,  -3, -16, 24,     flat,  left112 },
    { 16,  -4, -16, 24,     flat,  left112 }, { 16,  -5, -16, 24,     flat,  left112 }, { 16,  -6, -16, 24,     flat,  left112 }, { 16,  -7, -16, 24,     flat,  left112 }, { 16,  -8, -16, 24,     flat,  left112 },
    { 16,  -9, -16, 24,     flat,  left112 }, { 16, -10, -16, 24,     flat,  left112 }, { 16, -11, -16, 24,     flat,   left90 }, { 16, -12, -16, 24,     flat,   left90 }, { 16, -13, -16, 24,     flat,   left90 },
    { 16, -14, -16, 24,     flat,   left90 }, { 16, -15, -16, 24,     flat,   left90 }, { 16, -16, -16, 24,     flat,   left90 }, { 16, -17, -16, 24,     flat,   left90 }, { 16, -18, -16, 24,     flat,   left90 },
    { 16, -19, -16, 24,     flat,   left90 }, { 16, -20, -16, 24,     flat,   left90 }, { 16, -21, -16, 24,     flat,   left90 }, { 16, -22, -16, 24,     flat,   left67 }, { 16, -23, -16, 24,     flat,   left67 },
    { 16, -24, -16, 24,     flat,   left67 }, { 16, -25, -16, 24,     flat,   left67 }, { 16, -26, -16, 24,     flat,   left67 }, { 16, -27, -16, 24,     flat,   left67 }, { 16, -28, -16, 24,     flat,   left67 },
    { 16, -29, -16, 24,     flat,   left67 }, { 16, -30, -16, 24,     flat,   left67 }, { 16, -31, -16, 24,     flat,   left67 }, { 16, -32, -16, 24,     flat,   left67 }, { 16, -33, -16, 24,     flat,   left67 },
    { 16, -34, -16, 24,     flat,   left67 }, { 16, -35, -16, 24,     flat,   left45 }, { 16, -36, -16, 24,     flat,   left45 }, { 16, -37, -16, 24,     flat,   left45 }, { 16, -38, -16, 24,     flat,   left45 },
    { 16, -39, -16, 24,     flat,   left45 }, { 16, -40, -16, 24,     flat,   left45 }, { 16, -41, -16, 24,     flat,   left45 }, { 16, -42, -16, 24,     flat,   left45 }, { 16, -43, -16, 24,     flat,   left45 },
    { 16, -44, -16, 24,     flat,   left45 }, { 16, -45, -16, 24,     flat,   left45 }, { 16, -46, -16, 24,     flat,   left22 }, { 16, -47, -16, 24,     flat,   left22 }, { 16, -48, -16, 24,     flat,   left22 },
    { 16, -49, -16, 24,     flat,   left22 }, { 16, -50, -16, 24,     flat,   left22 }, { 16, -51, -16, 24,     flat,   left22 }, { 16, -52, -16, 24,     flat,   left22 }, { 16, -53, -16, 24,     flat,   left22 },
    { 16, -54, -16, 24,     flat,   left22 }, { 16, -55, -16, 24,     flat,   left22 }, { 16, -56, -16, 24,     flat,   left22 }, { 16, -57, -16, 24,     flat,   left22 }, { 16, -58, -16, 24,     flat,   left22 },
    { 16, -59, -16, 24,     flat, unbanked }, { 16, -60, -16, 24,     flat, unbanked }, { 16, -61, -16, 24,     flat, unbanked }, { 16, -62, -16, 24,     flat, unbanked }, { 16, -63, -16, 24,     flat, unbanked },
    { 16, -64, -16, 24,     flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E644E, {
    {  31, 16,   0, 0,     up25, unbanked }, {  30, 16,   0, 0,     up25, unbanked }, {  29, 16,   1, 0,     up25, unbanked }, {  28, 16,   1, 0,     up25, unbanked }, {  27, 16,   2, 0,     up25, unbanked },
    {  26, 16,   2, 0,     up25, unbanked }, {  25, 16,   3, 0,     up25, unbanked }, {  24, 16,   3, 0,     up25, unbanked }, {  23, 16,   3, 0,     up25, unbanked }, {  22, 16,   4, 0,     up25, unbanked },
    {  21, 16,   4, 0,     up25, unbanked }, {  20, 16,   5, 0,     up25, unbanked }, {  19, 16,   5, 0,     up25, unbanked }, {  18, 16,   6, 0,     up25, unbanked }, {  17, 16,   6, 0,     up25, unbanked },
    {  16, 16,   7, 0,     up25, unbanked }, {  15, 16,   7, 0,     up25, unbanked }, {  14, 16,   8, 0,     up25, unbanked }, {  13, 16,   8, 0,     up25, unbanked }, {  12, 16,   9, 0,     up42, unbanked },
    {  11, 16,   9, 0,     up42, unbanked }, {  10, 16,  10, 0,     up42, unbanked }, {   9, 16,  10, 0,     up42, unbanked }, {   8, 16,  11, 0,     up42, unbanked }, {   7, 16,  11, 0,     up42, unbanked },
    {   6, 16,  12, 0,     up42, unbanked }, {   5, 16,  13, 0,     up42, unbanked }, {   4, 16,  14, 0,     up42, unbanked }, {   3, 16,  15, 0,     up42, unbanked }, {   2, 16,  15, 0,     up42, unbanked },
    {   1, 16,  16, 0,     up42, unbanked }, {   0, 16,  17, 0,     up42, unbanked }, {  -1, 16,  18, 0,     up42, unbanked }, {  -2, 16,  18, 0,     up42, unbanked }, {  -3, 16,  19, 0,     up42, unbanked },
    {  -4, 16,  20, 0,     up42, unbanked }, {  -5, 16,  21, 0,     up42, unbanked }, {  -6, 16,  22, 0,     up42, unbanked }, {  -7, 16,  23, 0,     up42, unbanked }, {  -8, 16,  24, 0,     up42, unbanked },
    {  -9, 16,  25, 0,     up42, unbanked }, { -10, 16,  26, 0,     up42, unbanked }, { -11, 16,  27, 0,     up60, unbanked }, { -12, 16,  28, 0,     up60, unbanked }, { -13, 16,  29, 0,     up60, unbanked },
    { -13, 16,  30, 0,     up60, unbanked }, { -14, 16,  31, 0,     up60, unbanked }, { -15, 16,  32, 0,     up60, unbanked }, { -16, 16,  33, 0,     up60, unbanked }, { -16, 16,  34, 0,     up60, unbanked },
    { -17, 16,  35, 0,     up60, unbanked }, { -18, 16,  36, 0,     up60, unbanked }, { -19, 16,  37, 0,     up60, unbanked }, { -19, 16,  38, 0,     up60, unbanked }, { -20, 16,  39, 0,     up60, unbanked },
    { -20, 16,  40, 0,     up60, unbanked }, { -21, 16,  41, 0,     up60, unbanked }, { -22, 16,  42, 0,     up60, unbanked }, { -22, 16,  43, 0,     up75, unbanked }, { -23, 16,  44, 0,     up75, unbanked },
    { -24, 16,  45, 0,     up75, unbanked }, { -24, 16,  46, 0,     up75, unbanked }, { -25, 16,  47, 0,     up75, unbanked }, { -25, 16,  48, 0,     up75, unbanked }, { -25, 16,  49, 0,     up75, unbanked },
    { -26, 16,  50, 0,     up75, unbanked }, { -26, 16,  51, 0,     up75, unbanked }, { -26, 16,  52, 0,     up75, unbanked }, { -27, 16,  53, 0,     up75, unbanked }, { -27, 16,  54, 0,     up75, unbanked },
    { -27, 16,  55, 0,     up75, unbanked }, { -28, 16,  56, 0,     up75, unbanked }, { -28, 16,  57, 0,     up75, unbanked }, { -28, 16,  58, 0,     up75, unbanked }, { -29, 16,  59, 0,     up75, unbanked },
    { -29, 16,  60, 0,     up75, unbanked }, { -29, 16,  61, 0,     up75, unbanked }, { -30, 16,  62, 0,     up75, unbanked }, { -30, 16,  63, 0,     up75, unbanked }, { -30, 16,  64, 0,     up90, unbanked },
    { -30, 16,  65, 0,     up90, unbanked }, { -31, 16,  66, 0,     up90, unbanked }, { -31, 16,  67, 0,     up90, unbanked }, { -31, 16,  68, 0,     up90, unbanked }, { -31, 16,  69, 0,     up90, unbanked },
    { -31, 16,  70, 0,     up90, unbanked }, { -32, 16,  71, 0,     up90, unbanked }, { -32, 16,  72, 0,     up90, unbanked }, { -32, 16,  73, 0,     up90, unbanked }, { -32, 16,  74, 0,     up90, unbanked },
    { -32, 16,  75, 0,     up90, unbanked }, { -32, 16,  76, 0,     up90, unbanked }, { -32, 16,  77, 0,     up90, unbanked }, { -32, 16,  78, 0,     up90, unbanked }, { -32, 16,  79, 0,     up90, unbanked },
    { -32, 16,  80, 0,     up90, unbanked }, { -32, 16,  81, 0,     up90, unbanked }, { -32, 16,  82, 0,     up90, unbanked }, { -32, 16,  83, 0,     up90, unbanked }, { -32, 16,  84, 0,     up90, unbanked },
    { -32, 16,  85, 0,     up90, unbanked }, { -32, 16,  86, 0,     up90, unbanked }, { -32, 16,  87, 0,     up90, unbanked }, { -32, 16,  88, 0,     up90, unbanked }, { -32, 16,  89, 0,     up90, unbanked },
    { -32, 16,  90, 0,     up90, unbanked }, { -32, 16,  91, 0,     up90, unbanked }, { -32, 16,  92, 0,     up90, unbanked }, { -32, 16,  93, 0,     up90, unbanked }, { -32, 16,  94, 0,     up90, unbanked },
    { -32, 16,  95, 0,     up90, unbanked }, { -32, 16,  96, 0,     up90, unbanked }, { -32, 16,  97, 0,    up105, unbanked }, { -32, 16,  98, 0,    up105, unbanked }, { -31, 16,  99, 0,    up105, unbanked },
    { -31, 16, 100, 0,    up105, unbanked }, { -31, 16, 101, 0,    up105, unbanked }, { -31, 16, 102, 0,    up105, unbanked }, { -31, 16, 103, 0,    up105, unbanked }, { -30, 16, 104, 0,    up105, unbanked },
    { -30, 16, 105, 0,    up105, unbanked }, { -30, 16, 106, 0,    up105, unbanked }, { -30, 16, 107, 0,    up105, unbanked }, { -29, 16, 108, 0,    up105, unbanked }, { -29, 16, 109, 0,    up105, unbanked },
    { -29, 16, 110, 0,    up105, unbanked }, { -28, 16, 111, 0,    up120, unbanked }, { -28, 16, 112, 0,    up120, unbanked }, { -27, 16, 113, 0,    up120, unbanked }, { -27, 16, 114, 0,    up120, unbanked },
    { -26, 16, 115, 0,    up120, unbanked }, { -26, 16, 116, 0,    up120, unbanked }, { -26, 16, 117, 0,    up120, unbanked }, { -25, 16, 118, 0,    up120, unbanked }, { -25, 16, 119, 0,    up120, unbanked },
    { -24, 16, 120, 0,    up135, unbanked }, { -24, 16, 121, 0,    up135, unbanked }, { -23, 16, 122, 0,    up135, unbanked }, { -22, 16, 123, 0,    up135, unbanked }, { -22, 16, 124, 0,    up135, unbanked },
    { -21, 16, 125, 0,    up135, unbanked }, { -20, 16, 126, 0,    up135, unbanked }, { -19, 16, 127, 0,    up135, unbanked }, { -18, 16, 128, 0,    up150, unbanked }, { -17, 16, 129, 0,    up150, unbanked },
    { -16, 16, 130, 0,    up150, unbanked }, { -15, 16, 130, 0,    up150, unbanked }, { -14, 16, 131, 0,    up150, unbanked }, { -13, 16, 132, 0,    up165, unbanked }, { -12, 16, 133, 0,    up165, unbanked },
    { -11, 16, 134, 0,    up165, unbanked }, { -10, 16, 134, 0,    up165, unbanked }, {  -9, 16, 135, 0,    up165, unbanked }, {  -8, 16, 135, 0, inverted, unbanked }, {  -7, 16, 135, 0, inverted, unbanked },
    {  -6, 16, 136, 0, inverted, unbanked }, {  -5, 16, 136, 0, inverted, unbanked }, {  -4, 16, 136, 0, inverted, unbanked }, {  -3, 16, 136, 0, inverted, unbanked }, {  -2, 16, 136, 0, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E69F9, {
    { 16,  0,   0, 8,     up25, unbanked }, { 16,  1,   0, 8,     up25, unbanked }, { 16,  2,   1, 8,     up25, unbanked }, { 16,  3,   1, 8,     up25, unbanked }, { 16,  4,   2, 8,     up25, unbanked },
    { 16,  5,   2, 8,     up25, unbanked }, { 16,  6,   3, 8,     up25, unbanked }, { 16,  7,   3, 8,     up25, unbanked }, { 16,  8,   3, 8,     up25, unbanked }, { 16,  9,   4, 8,     up25, unbanked },
    { 16, 10,   4, 8,     up25, unbanked }, { 16, 11,   5, 8,     up25, unbanked }, { 16, 12,   5, 8,     up25, unbanked }, { 16, 13,   6, 8,     up25, unbanked }, { 16, 14,   6, 8,     up25, unbanked },
    { 16, 15,   7, 8,     up25, unbanked }, { 16, 16,   7, 8,     up25, unbanked }, { 16, 17,   8, 8,     up25, unbanked }, { 16, 18,   8, 8,     up25, unbanked }, { 16, 19,   9, 8,     up42, unbanked },
    { 16, 20,   9, 8,     up42, unbanked }, { 16, 21,  10, 8,     up42, unbanked }, { 16, 22,  10, 8,     up42, unbanked }, { 16, 23,  11, 8,     up42, unbanked }, { 16, 24,  11, 8,     up42, unbanked },
    { 16, 25,  12, 8,     up42, unbanked }, { 16, 26,  13, 8,     up42, unbanked }, { 16, 27,  14, 8,     up42, unbanked }, { 16, 28,  15, 8,     up42, unbanked }, { 16, 29,  15, 8,     up42, unbanked },
    { 16, 30,  16, 8,     up42, unbanked }, { 16, 31,  17, 8,     up42, unbanked }, { 16, 32,  18, 8,     up42, unbanked }, { 16, 33,  18, 8,     up42, unbanked }, { 16, 34,  19, 8,     up42, unbanked },
    { 16, 35,  20, 8,     up42, unbanked }, { 16, 36,  21, 8,     up42, unbanked }, { 16, 37,  22, 8,     up42, unbanked }, { 16, 38,  23, 8,     up42, unbanked }, { 16, 39,  24, 8,     up42, unbanked },
    { 16, 40,  25, 8,     up42, unbanked }, { 16, 41,  26, 8,     up42, unbanked }, { 16, 42,  27, 8,     up60, unbanked }, { 16, 43,  28, 8,     up60, unbanked }, { 16, 44,  29, 8,     up60, unbanked },
    { 16, 44,  30, 8,     up60, unbanked }, { 16, 45,  31, 8,     up60, unbanked }, { 16, 46,  32, 8,     up60, unbanked }, { 16, 47,  33, 8,     up60, unbanked }, { 16, 47,  34, 8,     up60, unbanked },
    { 16, 48,  35, 8,     up60, unbanked }, { 16, 49,  36, 8,     up60, unbanked }, { 16, 50,  37, 8,     up60, unbanked }, { 16, 50,  38, 8,     up60, unbanked }, { 16, 51,  39, 8,     up60, unbanked },
    { 16, 51,  40, 8,     up60, unbanked }, { 16, 52,  41, 8,     up60, unbanked }, { 16, 53,  42, 8,     up60, unbanked }, { 16, 53,  43, 8,     up75, unbanked }, { 16, 54,  44, 8,     up75, unbanked },
    { 16, 55,  45, 8,     up75, unbanked }, { 16, 55,  46, 8,     up75, unbanked }, { 16, 56,  47, 8,     up75, unbanked }, { 16, 56,  48, 8,     up75, unbanked }, { 16, 56,  49, 8,     up75, unbanked },
    { 16, 57,  50, 8,     up75, unbanked }, { 16, 57,  51, 8,     up75, unbanked }, { 16, 57,  52, 8,     up75, unbanked }, { 16, 58,  53, 8,     up75, unbanked }, { 16, 58,  54, 8,     up75, unbanked },
    { 16, 58,  55, 8,     up75, unbanked }, { 16, 59,  56, 8,     up75, unbanked }, { 16, 59,  57, 8,     up75, unbanked }, { 16, 59,  58, 8,     up75, unbanked }, { 16, 60,  59, 8,     up75, unbanked },
    { 16, 60,  60, 8,     up75, unbanked }, { 16, 60,  61, 8,     up75, unbanked }, { 16, 61,  62, 8,     up75, unbanked }, { 16, 61,  63, 8,     up75, unbanked }, { 16, 61,  64, 8,     up90, unbanked },
    { 16, 61,  65, 8,     up90, unbanked }, { 16, 62,  66, 8,     up90, unbanked }, { 16, 62,  67, 8,     up90, unbanked }, { 16, 62,  68, 8,     up90, unbanked }, { 16, 62,  69, 8,     up90, unbanked },
    { 16, 62,  70, 8,     up90, unbanked }, { 16, 63,  71, 8,     up90, unbanked }, { 16, 63,  72, 8,     up90, unbanked }, { 16, 63,  73, 8,     up90, unbanked }, { 16, 63,  74, 8,     up90, unbanked },
    { 16, 63,  75, 8,     up90, unbanked }, { 16, 63,  76, 8,     up90, unbanked }, { 16, 63,  77, 8,     up90, unbanked }, { 16, 63,  78, 8,     up90, unbanked }, { 16, 63,  79, 8,     up90, unbanked },
    { 16, 63,  80, 8,     up90, unbanked }, { 16, 63,  81, 8,     up90, unbanked }, { 16, 63,  82, 8,     up90, unbanked }, { 16, 63,  83, 8,     up90, unbanked }, { 16, 63,  84, 8,     up90, unbanked },
    { 16, 63,  85, 8,     up90, unbanked }, { 16, 63,  86, 8,     up90, unbanked }, { 16, 63,  87, 8,     up90, unbanked }, { 16, 63,  88, 8,     up90, unbanked }, { 16, 63,  89, 8,     up90, unbanked },
    { 16, 63,  90, 8,     up90, unbanked }, { 16, 63,  91, 8,     up90, unbanked }, { 16, 63,  92, 8,     up90, unbanked }, { 16, 63,  93, 8,     up90, unbanked }, { 16, 63,  94, 8,     up90, unbanked },
    { 16, 63,  95, 8,     up90, unbanked }, { 16, 63,  96, 8,     up90, unbanked }, { 16, 63,  97, 8,    up105, unbanked }, { 16, 63,  98, 8,    up105, unbanked }, { 16, 62,  99, 8,    up105, unbanked },
    { 16, 62, 100, 8,    up105, unbanked }, { 16, 62, 101, 8,    up105, unbanked }, { 16, 62, 102, 8,    up105, unbanked }, { 16, 62, 103, 8,    up105, unbanked }, { 16, 61, 104, 8,    up105, unbanked },
    { 16, 61, 105, 8,    up105, unbanked }, { 16, 61, 106, 8,    up105, unbanked }, { 16, 61, 107, 8,    up105, unbanked }, { 16, 60, 108, 8,    up105, unbanked }, { 16, 60, 109, 8,    up105, unbanked },
    { 16, 60, 110, 8,    up105, unbanked }, { 16, 59, 111, 8,    up120, unbanked }, { 16, 59, 112, 8,    up120, unbanked }, { 16, 58, 113, 8,    up120, unbanked }, { 16, 58, 114, 8,    up120, unbanked },
    { 16, 57, 115, 8,    up120, unbanked }, { 16, 57, 116, 8,    up120, unbanked }, { 16, 57, 117, 8,    up120, unbanked }, { 16, 56, 118, 8,    up120, unbanked }, { 16, 56, 119, 8,    up120, unbanked },
    { 16, 55, 120, 8,    up135, unbanked }, { 16, 55, 121, 8,    up135, unbanked }, { 16, 54, 122, 8,    up135, unbanked }, { 16, 53, 123, 8,    up135, unbanked }, { 16, 53, 124, 8,    up135, unbanked },
    { 16, 52, 125, 8,    up135, unbanked }, { 16, 51, 126, 8,    up135, unbanked }, { 16, 50, 127, 8,    up135, unbanked }, { 16, 49, 128, 8,    up150, unbanked }, { 16, 48, 129, 8,    up150, unbanked },
    { 16, 47, 130, 8,    up150, unbanked }, { 16, 46, 130, 8,    up150, unbanked }, { 16, 45, 131, 8,    up150, unbanked }, { 16, 44, 132, 8,    up165, unbanked }, { 16, 43, 133, 8,    up165, unbanked },
    { 16, 42, 134, 8,    up165, unbanked }, { 16, 41, 134, 8,    up165, unbanked }, { 16, 40, 135, 8,    up165, unbanked }, { 16, 39, 135, 8, inverted, unbanked }, { 16, 38, 135, 8, inverted, unbanked },
    { 16, 37, 136, 8, inverted, unbanked }, { 16, 36, 136, 8, inverted, unbanked }, { 16, 35, 136, 8, inverted, unbanked }, { 16, 34, 136, 8, inverted, unbanked }, { 16, 33, 136, 8, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E6FA4, {
    {  0, 16,   0, 16,     up25, unbanked }, {  1, 16,   0, 16,     up25, unbanked }, {  2, 16,   1, 16,     up25, unbanked }, {  3, 16,   1, 16,     up25, unbanked }, {  4, 16,   2, 16,     up25, unbanked },
    {  5, 16,   2, 16,     up25, unbanked }, {  6, 16,   3, 16,     up25, unbanked }, {  7, 16,   3, 16,     up25, unbanked }, {  8, 16,   3, 16,     up25, unbanked }, {  9, 16,   4, 16,     up25, unbanked },
    { 10, 16,   4, 16,     up25, unbanked }, { 11, 16,   5, 16,     up25, unbanked }, { 12, 16,   5, 16,     up25, unbanked }, { 13, 16,   6, 16,     up25, unbanked }, { 14, 16,   6, 16,     up25, unbanked },
    { 15, 16,   7, 16,     up25, unbanked }, { 16, 16,   7, 16,     up25, unbanked }, { 17, 16,   8, 16,     up25, unbanked }, { 18, 16,   8, 16,     up25, unbanked }, { 19, 16,   9, 16,     up42, unbanked },
    { 20, 16,   9, 16,     up42, unbanked }, { 21, 16,  10, 16,     up42, unbanked }, { 22, 16,  10, 16,     up42, unbanked }, { 23, 16,  11, 16,     up42, unbanked }, { 24, 16,  11, 16,     up42, unbanked },
    { 25, 16,  12, 16,     up42, unbanked }, { 26, 16,  13, 16,     up42, unbanked }, { 27, 16,  14, 16,     up42, unbanked }, { 28, 16,  15, 16,     up42, unbanked }, { 29, 16,  15, 16,     up42, unbanked },
    { 30, 16,  16, 16,     up42, unbanked }, { 31, 16,  17, 16,     up42, unbanked }, { 32, 16,  18, 16,     up42, unbanked }, { 33, 16,  18, 16,     up42, unbanked }, { 34, 16,  19, 16,     up42, unbanked },
    { 35, 16,  20, 16,     up42, unbanked }, { 36, 16,  21, 16,     up42, unbanked }, { 37, 16,  22, 16,     up42, unbanked }, { 38, 16,  23, 16,     up42, unbanked }, { 39, 16,  24, 16,     up42, unbanked },
    { 40, 16,  25, 16,     up42, unbanked }, { 41, 16,  26, 16,     up42, unbanked }, { 42, 16,  27, 16,     up60, unbanked }, { 43, 16,  28, 16,     up60, unbanked }, { 44, 16,  29, 16,     up60, unbanked },
    { 44, 16,  30, 16,     up60, unbanked }, { 45, 16,  31, 16,     up60, unbanked }, { 46, 16,  32, 16,     up60, unbanked }, { 47, 16,  33, 16,     up60, unbanked }, { 47, 16,  34, 16,     up60, unbanked },
    { 48, 16,  35, 16,     up60, unbanked }, { 49, 16,  36, 16,     up60, unbanked }, { 50, 16,  37, 16,     up60, unbanked }, { 50, 16,  38, 16,     up60, unbanked }, { 51, 16,  39, 16,     up60, unbanked },
    { 51, 16,  40, 16,     up60, unbanked }, { 52, 16,  41, 16,     up60, unbanked }, { 53, 16,  42, 16,     up60, unbanked }, { 53, 16,  43, 16,     up75, unbanked }, { 54, 16,  44, 16,     up75, unbanked },
    { 55, 16,  45, 16,     up75, unbanked }, { 55, 16,  46, 16,     up75, unbanked }, { 56, 16,  47, 16,     up75, unbanked }, { 56, 16,  48, 16,     up75, unbanked }, { 56, 16,  49, 16,     up75, unbanked },
    { 57, 16,  50, 16,     up75, unbanked }, { 57, 16,  51, 16,     up75, unbanked }, { 57, 16,  52, 16,     up75, unbanked }, { 58, 16,  53, 16,     up75, unbanked }, { 58, 16,  54, 16,     up75, unbanked },
    { 58, 16,  55, 16,     up75, unbanked }, { 59, 16,  56, 16,     up75, unbanked }, { 59, 16,  57, 16,     up75, unbanked }, { 59, 16,  58, 16,     up75, unbanked }, { 60, 16,  59, 16,     up75, unbanked },
    { 60, 16,  60, 16,     up75, unbanked }, { 60, 16,  61, 16,     up75, unbanked }, { 61, 16,  62, 16,     up75, unbanked }, { 61, 16,  63, 16,     up75, unbanked }, { 61, 16,  64, 16,     up90, unbanked },
    { 61, 16,  65, 16,     up90, unbanked }, { 62, 16,  66, 16,     up90, unbanked }, { 62, 16,  67, 16,     up90, unbanked }, { 62, 16,  68, 16,     up90, unbanked }, { 62, 16,  69, 16,     up90, unbanked },
    { 62, 16,  70, 16,     up90, unbanked }, { 63, 16,  71, 16,     up90, unbanked }, { 63, 16,  72, 16,     up90, unbanked }, { 63, 16,  73, 16,     up90, unbanked }, { 63, 16,  74, 16,     up90, unbanked },
    { 63, 16,  75, 16,     up90, unbanked }, { 63, 16,  76, 16,     up90, unbanked }, { 63, 16,  77, 16,     up90, unbanked }, { 63, 16,  78, 16,     up90, unbanked }, { 63, 16,  79, 16,     up90, unbanked },
    { 63, 16,  80, 16,     up90, unbanked }, { 63, 16,  81, 16,     up90, unbanked }, { 63, 16,  82, 16,     up90, unbanked }, { 63, 16,  83, 16,     up90, unbanked }, { 63, 16,  84, 16,     up90, unbanked },
    { 63, 16,  85, 16,     up90, unbanked }, { 63, 16,  86, 16,     up90, unbanked }, { 63, 16,  87, 16,     up90, unbanked }, { 63, 16,  88, 16,     up90, unbanked }, { 63, 16,  89, 16,     up90, unbanked },
    { 63, 16,  90, 16,     up90, unbanked }, { 63, 16,  91, 16,     up90, unbanked }, { 63, 16,  92, 16,     up90, unbanked }, { 63, 16,  93, 16,     up90, unbanked }, { 63, 16,  94, 16,     up90, unbanked },
    { 63, 16,  95, 16,     up90, unbanked }, { 63, 16,  96, 16,     up90, unbanked }, { 63, 16,  97, 16,    up105, unbanked }, { 63, 16,  98, 16,    up105, unbanked }, { 62, 16,  99, 16,    up105, unbanked },
    { 62, 16, 100, 16,    up105, unbanked }, { 62, 16, 101, 16,    up105, unbanked }, { 62, 16, 102, 16,    up105, unbanked }, { 62, 16, 103, 16,    up105, unbanked }, { 61, 16, 104, 16,    up105, unbanked },
    { 61, 16, 105, 16,    up105, unbanked }, { 61, 16, 106, 16,    up105, unbanked }, { 61, 16, 107, 16,    up105, unbanked }, { 60, 16, 108, 16,    up105, unbanked }, { 60, 16, 109, 16,    up105, unbanked },
    { 60, 16, 110, 16,    up105, unbanked }, { 59, 16, 111, 16,    up120, unbanked }, { 59, 16, 112, 16,    up120, unbanked }, { 58, 16, 113, 16,    up120, unbanked }, { 58, 16, 114, 16,    up120, unbanked },
    { 57, 16, 115, 16,    up120, unbanked }, { 57, 16, 116, 16,    up120, unbanked }, { 57, 16, 117, 16,    up120, unbanked }, { 56, 16, 118, 16,    up120, unbanked }, { 56, 16, 119, 16,    up120, unbanked },
    { 55, 16, 120, 16,    up135, unbanked }, { 55, 16, 121, 16,    up135, unbanked }, { 54, 16, 122, 16,    up135, unbanked }, { 53, 16, 123, 16,    up135, unbanked }, { 53, 16, 124, 16,    up135, unbanked },
    { 52, 16, 125, 16,    up135, unbanked }, { 51, 16, 126, 16,    up135, unbanked }, { 50, 16, 127, 16,    up135, unbanked }, { 49, 16, 128, 16,    up150, unbanked }, { 48, 16, 129, 16,    up150, unbanked },
    { 47, 16, 130, 16,    up150, unbanked }, { 46, 16, 130, 16,    up150, unbanked }, { 45, 16, 131, 16,    up150, unbanked }, { 44, 16, 132, 16,    up165, unbanked }, { 43, 16, 133, 16,    up165, unbanked },
    { 42, 16, 134, 16,    up165, unbanked }, { 41, 16, 134, 16,    up165, unbanked }, { 40, 16, 135, 16,    up165, unbanked }, { 39, 16, 135, 16, inverted, unbanked }, { 38, 16, 135, 16, inverted, unbanked },
    { 37, 16, 136, 16, inverted, unbanked }, { 36, 16, 136, 16, inverted, unbanked }, { 35, 16, 136, 16, inverted, unbanked }, { 34, 16, 136, 16, inverted, unbanked }, { 33, 16, 136, 16, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E754F, {
    { 16,  31,   0, 24,     up25, unbanked }, { 16,  30,   0, 24,     up25, unbanked }, { 16,  29,   1, 24,     up25, unbanked }, { 16,  28,   1, 24,     up25, unbanked }, { 16,  27,   2, 24,     up25, unbanked },
    { 16,  26,   2, 24,     up25, unbanked }, { 16,  25,   3, 24,     up25, unbanked }, { 16,  24,   3, 24,     up25, unbanked }, { 16,  23,   3, 24,     up25, unbanked }, { 16,  22,   4, 24,     up25, unbanked },
    { 16,  21,   4, 24,     up25, unbanked }, { 16,  20,   5, 24,     up25, unbanked }, { 16,  19,   5, 24,     up25, unbanked }, { 16,  18,   6, 24,     up25, unbanked }, { 16,  17,   6, 24,     up25, unbanked },
    { 16,  16,   7, 24,     up25, unbanked }, { 16,  15,   7, 24,     up25, unbanked }, { 16,  14,   8, 24,     up25, unbanked }, { 16,  13,   8, 24,     up25, unbanked }, { 16,  12,   9, 24,     up42, unbanked },
    { 16,  11,   9, 24,     up42, unbanked }, { 16,  10,  10, 24,     up42, unbanked }, { 16,   9,  10, 24,     up42, unbanked }, { 16,   8,  11, 24,     up42, unbanked }, { 16,   7,  11, 24,     up42, unbanked },
    { 16,   6,  12, 24,     up42, unbanked }, { 16,   5,  13, 24,     up42, unbanked }, { 16,   4,  14, 24,     up42, unbanked }, { 16,   3,  15, 24,     up42, unbanked }, { 16,   2,  15, 24,     up42, unbanked },
    { 16,   1,  16, 24,     up42, unbanked }, { 16,   0,  17, 24,     up42, unbanked }, { 16,  -1,  18, 24,     up42, unbanked }, { 16,  -2,  18, 24,     up42, unbanked }, { 16,  -3,  19, 24,     up42, unbanked },
    { 16,  -4,  20, 24,     up42, unbanked }, { 16,  -5,  21, 24,     up42, unbanked }, { 16,  -6,  22, 24,     up42, unbanked }, { 16,  -7,  23, 24,     up42, unbanked }, { 16,  -8,  24, 24,     up42, unbanked },
    { 16,  -9,  25, 24,     up42, unbanked }, { 16, -10,  26, 24,     up42, unbanked }, { 16, -11,  27, 24,     up60, unbanked }, { 16, -12,  28, 24,     up60, unbanked }, { 16, -13,  29, 24,     up60, unbanked },
    { 16, -13,  30, 24,     up60, unbanked }, { 16, -14,  31, 24,     up60, unbanked }, { 16, -15,  32, 24,     up60, unbanked }, { 16, -16,  33, 24,     up60, unbanked }, { 16, -16,  34, 24,     up60, unbanked },
    { 16, -17,  35, 24,     up60, unbanked }, { 16, -18,  36, 24,     up60, unbanked }, { 16, -19,  37, 24,     up60, unbanked }, { 16, -19,  38, 24,     up60, unbanked }, { 16, -20,  39, 24,     up60, unbanked },
    { 16, -20,  40, 24,     up60, unbanked }, { 16, -21,  41, 24,     up60, unbanked }, { 16, -22,  42, 24,     up60, unbanked }, { 16, -22,  43, 24,     up75, unbanked }, { 16, -23,  44, 24,     up75, unbanked },
    { 16, -24,  45, 24,     up75, unbanked }, { 16, -24,  46, 24,     up75, unbanked }, { 16, -25,  47, 24,     up75, unbanked }, { 16, -25,  48, 24,     up75, unbanked }, { 16, -25,  49, 24,     up75, unbanked },
    { 16, -26,  50, 24,     up75, unbanked }, { 16, -26,  51, 24,     up75, unbanked }, { 16, -26,  52, 24,     up75, unbanked }, { 16, -27,  53, 24,     up75, unbanked }, { 16, -27,  54, 24,     up75, unbanked },
    { 16, -27,  55, 24,     up75, unbanked }, { 16, -28,  56, 24,     up75, unbanked }, { 16, -28,  57, 24,     up75, unbanked }, { 16, -28,  58, 24,     up75, unbanked }, { 16, -29,  59, 24,     up75, unbanked },
    { 16, -29,  60, 24,     up75, unbanked }, { 16, -29,  61, 24,     up75, unbanked }, { 16, -30,  62, 24,     up75, unbanked }, { 16, -30,  63, 24,     up75, unbanked }, { 16, -30,  64, 24,     up90, unbanked },
    { 16, -30,  65, 24,     up90, unbanked }, { 16, -31,  66, 24,     up90, unbanked }, { 16, -31,  67, 24,     up90, unbanked }, { 16, -31,  68, 24,     up90, unbanked }, { 16, -31,  69, 24,     up90, unbanked },
    { 16, -31,  70, 24,     up90, unbanked }, { 16, -32,  71, 24,     up90, unbanked }, { 16, -32,  72, 24,     up90, unbanked }, { 16, -32,  73, 24,     up90, unbanked }, { 16, -32,  74, 24,     up90, unbanked },
    { 16, -32,  75, 24,     up90, unbanked }, { 16, -32,  76, 24,     up90, unbanked }, { 16, -32,  77, 24,     up90, unbanked }, { 16, -32,  78, 24,     up90, unbanked }, { 16, -32,  79, 24,     up90, unbanked },
    { 16, -32,  80, 24,     up90, unbanked }, { 16, -32,  81, 24,     up90, unbanked }, { 16, -32,  82, 24,     up90, unbanked }, { 16, -32,  83, 24,     up90, unbanked }, { 16, -32,  84, 24,     up90, unbanked },
    { 16, -32,  85, 24,     up90, unbanked }, { 16, -32,  86, 24,     up90, unbanked }, { 16, -32,  87, 24,     up90, unbanked }, { 16, -32,  88, 24,     up90, unbanked }, { 16, -32,  89, 24,     up90, unbanked },
    { 16, -32,  90, 24,     up90, unbanked }, { 16, -32,  91, 24,     up90, unbanked }, { 16, -32,  92, 24,     up90, unbanked }, { 16, -32,  93, 24,     up90, unbanked }, { 16, -32,  94, 24,     up90, unbanked },
    { 16, -32,  95, 24,     up90, unbanked }, { 16, -32,  96, 24,     up90, unbanked }, { 16, -32,  97, 24,    up105, unbanked }, { 16, -32,  98, 24,    up105, unbanked }, { 16, -31,  99, 24,    up105, unbanked },
    { 16, -31, 100, 24,    up105, unbanked }, { 16, -31, 101, 24,    up105, unbanked }, { 16, -31, 102, 24,    up105, unbanked }, { 16, -31, 103, 24,    up105, unbanked }, { 16, -30, 104, 24,    up105, unbanked },
    { 16, -30, 105, 24,    up105, unbanked }, { 16, -30, 106, 24,    up105, unbanked }, { 16, -30, 107, 24,    up105, unbanked }, { 16, -29, 108, 24,    up105, unbanked }, { 16, -29, 109, 24,    up105, unbanked },
    { 16, -29, 110, 24,    up105, unbanked }, { 16, -28, 111, 24,    up120, unbanked }, { 16, -28, 112, 24,    up120, unbanked }, { 16, -27, 113, 24,    up120, unbanked }, { 16, -27, 114, 24,    up120, unbanked },
    { 16, -26, 115, 24,    up120, unbanked }, { 16, -26, 116, 24,    up120, unbanked }, { 16, -26, 117, 24,    up120, unbanked }, { 16, -25, 118, 24,    up120, unbanked }, { 16, -25, 119, 24,    up120, unbanked },
    { 16, -24, 120, 24,    up135, unbanked }, { 16, -24, 121, 24,    up135, unbanked }, { 16, -23, 122, 24,    up135, unbanked }, { 16, -22, 123, 24,    up135, unbanked }, { 16, -22, 124, 24,    up135, unbanked },
    { 16, -21, 125, 24,    up135, unbanked }, { 16, -20, 126, 24,    up135, unbanked }, { 16, -19, 127, 24,    up135, unbanked }, { 16, -18, 128, 24,    up150, unbanked }, { 16, -17, 129, 24,    up150, unbanked },
    { 16, -16, 130, 24,    up150, unbanked }, { 16, -15, 130, 24,    up150, unbanked }, { 16, -14, 131, 24,    up150, unbanked }, { 16, -13, 132, 24,    up165, unbanked }, { 16, -12, 133, 24,    up165, unbanked },
    { 16, -11, 134, 24,    up165, unbanked }, { 16, -10, 134, 24,    up165, unbanked }, { 16,  -9, 135, 24,    up165, unbanked }, { 16,  -8, 135, 24, inverted, unbanked }, { 16,  -7, 135, 24, inverted, unbanked },
    { 16,  -6, 136, 24, inverted, unbanked }, { 16,  -5, 136, 24, inverted, unbanked }, { 16,  -4, 136, 24, inverted, unbanked }, { 16,  -3, 136, 24, inverted, unbanked }, { 16,  -2, 136, 24, inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E7AFA, {
    { 31, 16,   16, 16, inverted, unbanked }, { 30, 16,   16, 16, inverted, unbanked }, { 29, 16,   16, 16, inverted, unbanked }, { 28, 16,   16, 16, inverted, unbanked }, { 27, 16,   16, 16, inverted, unbanked },
    { 26, 16,   16, 16,  down165, unbanked }, { 25, 16,   15, 16,  down165, unbanked }, { 24, 16,   15, 16,  down165, unbanked }, { 23, 16,   15, 16,  down165, unbanked }, { 22, 16,   14, 16,  down165, unbanked },
    { 21, 16,   14, 16,  down150, unbanked }, { 20, 16,   13, 16,  down150, unbanked }, { 19, 16,   12, 16,  down150, unbanked }, { 18, 16,   11, 16,  down150, unbanked }, { 17, 16,   10, 16,  down150, unbanked },
    { 16, 16,   10, 16,  down135, unbanked }, { 15, 16,    9, 16,  down135, unbanked }, { 14, 16,    8, 16,  down135, unbanked }, { 13, 16,    7, 16,  down135, unbanked }, { 12, 16,    6, 16,  down135, unbanked },
    { 11, 16,    5, 16,  down135, unbanked }, { 10, 16,    4, 16,  down135, unbanked }, { 10, 16,    3, 16,  down135, unbanked }, {  9, 16,    2, 16,  down120, unbanked }, {  8, 16,    1, 16,  down120, unbanked },
    {  8, 16,    0, 16,  down120, unbanked }, {  7, 16,   -1, 16,  down120, unbanked }, {  7, 16,   -2, 16,  down120, unbanked }, {  6, 16,   -3, 16,  down120, unbanked }, {  6, 16,   -4, 16,  down120, unbanked },
    {  6, 16,   -5, 16,  down120, unbanked }, {  5, 16,   -6, 16,  down120, unbanked }, {  5, 16,   -7, 16,  down105, unbanked }, {  4, 16,   -8, 16,  down105, unbanked }, {  4, 16,   -9, 16,  down105, unbanked },
    {  3, 16,  -10, 16,  down105, unbanked }, {  3, 16,  -11, 16,  down105, unbanked }, {  3, 16,  -12, 16,  down105, unbanked }, {  2, 16,  -13, 16,  down105, unbanked }, {  2, 16,  -14, 16,  down105, unbanked },
    {  2, 16,  -15, 16,  down105, unbanked }, {  2, 16,  -16, 16,  down105, unbanked }, {  1, 16,  -17, 16,  down105, unbanked }, {  1, 16,  -18, 16,  down105, unbanked }, {  1, 16,  -19, 16,  down105, unbanked },
    {  1, 16,  -20, 16,  down105, unbanked }, {  1, 16,  -21, 16,   down90, unbanked }, {  0, 16,  -22, 16,   down90, unbanked }, {  0, 16,  -23, 16,   down90, unbanked }, {  0, 16,  -24, 16,   down90, unbanked },
    {  0, 16,  -25, 16,   down90, unbanked }, {  0, 16,  -26, 16,   down90, unbanked }, {  0, 16,  -27, 16,   down90, unbanked }, {  0, 16,  -28, 16,   down90, unbanked }, {  0, 16,  -29, 16,   down90, unbanked },
    {  0, 16,  -30, 16,   down90, unbanked }, {  0, 16,  -31, 16,   down90, unbanked }, {  0, 16,  -32, 16,   down90, unbanked }, {  0, 16,  -33, 16,   down90, unbanked }, {  0, 16,  -34, 16,   down90, unbanked },
    {  0, 16,  -35, 16,   down90, unbanked }, {  0, 16,  -36, 16,   down90, unbanked }, {  0, 16,  -37, 16,   down90, unbanked }, {  0, 16,  -38, 16,   down90, unbanked }, {  0, 16,  -39, 16,   down90, unbanked },
    {  0, 16,  -40, 16,   down90, unbanked }, {  0, 16,  -41, 16,   down90, unbanked }, {  0, 16,  -42, 16,   down90, unbanked }, {  0, 16,  -43, 16,   down90, unbanked }, {  0, 16,  -44, 16,   down90, unbanked },
    {  0, 16,  -45, 16,   down90, unbanked }, {  0, 16,  -46, 16,   down90, unbanked }, {  0, 16,  -47, 16,   down90, unbanked }, {  0, 16,  -48, 16,   down90, unbanked }, {  0, 16,  -49, 16,   down90, unbanked },
    {  1, 16,  -50, 16,   down90, unbanked }, {  1, 16,  -51, 16,   down90, unbanked }, {  1, 16,  -52, 16,   down90, unbanked }, {  1, 16,  -53, 16,   down90, unbanked }, {  1, 16,  -54, 16,   down75, unbanked },
    {  2, 16,  -55, 16,   down75, unbanked }, {  2, 16,  -56, 16,   down75, unbanked }, {  2, 16,  -57, 16,   down75, unbanked }, {  2, 16,  -58, 16,   down75, unbanked }, {  3, 16,  -59, 16,   down75, unbanked },
    {  3, 16,  -60, 16,   down75, unbanked }, {  3, 16,  -61, 16,   down75, unbanked }, {  4, 16,  -62, 16,   down75, unbanked }, {  4, 16,  -63, 16,   down75, unbanked }, {  4, 16,  -64, 16,   down75, unbanked },
    {  5, 16,  -65, 16,   down75, unbanked }, {  5, 16,  -66, 16,   down75, unbanked }, {  5, 16,  -67, 16,   down75, unbanked }, {  6, 16,  -68, 16,   down75, unbanked }, {  6, 16,  -69, 16,   down75, unbanked },
    {  6, 16,  -70, 16,   down75, unbanked }, {  7, 16,  -71, 16,   down75, unbanked }, {  7, 16,  -72, 16,   down75, unbanked }, {  7, 16,  -73, 16,   down75, unbanked }, {  8, 16,  -74, 16,   down75, unbanked },
    {  8, 16,  -75, 16,   down60, unbanked }, {  9, 16,  -76, 16,   down60, unbanked }, { 10, 16,  -77, 16,   down60, unbanked }, { 10, 16,  -78, 16,   down60, unbanked }, { 11, 16,  -79, 16,   down60, unbanked },
    { 12, 16,  -80, 16,   down60, unbanked }, { 12, 16,  -81, 16,   down60, unbanked }, { 13, 16,  -82, 16,   down60, unbanked }, { 13, 16,  -83, 16,   down60, unbanked }, { 14, 16,  -84, 16,   down60, unbanked },
    { 15, 16,  -85, 16,   down60, unbanked }, { 16, 16,  -86, 16,   down60, unbanked }, { 16, 16,  -87, 16,   down60, unbanked }, { 17, 16,  -88, 16,   down60, unbanked }, { 18, 16,  -89, 16,   down60, unbanked },
    { 19, 16,  -90, 16,   down60, unbanked }, { 19, 16,  -91, 16,   down42, unbanked }, { 20, 16,  -92, 16,   down42, unbanked }, { 21, 16,  -93, 16,   down42, unbanked }, { 22, 16,  -94, 16,   down42, unbanked },
    { 23, 16,  -95, 16,   down42, unbanked }, { 24, 16,  -96, 16,   down42, unbanked }, { 25, 16,  -97, 16,   down42, unbanked }, { 26, 16,  -98, 16,   down42, unbanked }, { 27, 16,  -99, 16,   down42, unbanked },
    { 28, 16, -100, 16,   down42, unbanked }, { 29, 16, -101, 16,   down42, unbanked }, { 30, 16, -102, 16,   down42, unbanked }, { 31, 16, -102, 16,   down42, unbanked }, { 32, 16, -103, 16,   down42, unbanked },
    { 33, 16, -104, 16,   down42, unbanked }, { 34, 16, -105, 16,   down42, unbanked }, { 35, 16, -105, 16,   down42, unbanked }, { 36, 16, -106, 16,   down42, unbanked }, { 37, 16, -107, 16,   down42, unbanked },
    { 38, 16, -108, 16,   down42, unbanked }, { 39, 16, -109, 16,   down42, unbanked }, { 40, 16, -109, 16,   down42, unbanked }, { 41, 16, -110, 16,   down42, unbanked }, { 42, 16, -110, 16,   down25, unbanked },
    { 43, 16, -111, 16,   down25, unbanked }, { 44, 16, -111, 16,   down25, unbanked }, { 45, 16, -112, 16,   down25, unbanked }, { 46, 16, -112, 16,   down25, unbanked }, { 47, 16, -113, 16,   down25, unbanked },
    { 48, 16, -113, 16,   down25, unbanked }, { 49, 16, -114, 16,   down25, unbanked }, { 50, 16, -114, 16,   down25, unbanked }, { 51, 16, -115, 16,   down25, unbanked }, { 52, 16, -115, 16,   down25, unbanked },
    { 53, 16, -116, 16,   down25, unbanked }, { 54, 16, -116, 16,   down25, unbanked }, { 55, 16, -117, 16,   down25, unbanked }, { 56, 16, -117, 16,   down25, unbanked }, { 57, 16, -117, 16,   down25, unbanked },
    { 58, 16, -118, 16,   down25, unbanked }, { 59, 16, -118, 16,   down25, unbanked }, { 60, 16, -119, 16,   down25, unbanked }, { 61, 16, -119, 16,   down25, unbanked }, { 62, 16, -120, 16,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E80A5, {
    { 16,   0,   16, 24, inverted, unbanked }, { 16,   1,   16, 24, inverted, unbanked }, { 16,   2,   16, 24, inverted, unbanked }, { 16,   3,   16, 24, inverted, unbanked }, { 16,   4,   16, 24, inverted, unbanked },
    { 16,   5,   16, 24,  down165, unbanked }, { 16,   6,   15, 24,  down165, unbanked }, { 16,   7,   15, 24,  down165, unbanked }, { 16,   8,   15, 24,  down165, unbanked }, { 16,   9,   14, 24,  down165, unbanked },
    { 16,  10,   14, 24,  down150, unbanked }, { 16,  11,   13, 24,  down150, unbanked }, { 16,  12,   12, 24,  down150, unbanked }, { 16,  13,   11, 24,  down150, unbanked }, { 16,  14,   10, 24,  down150, unbanked },
    { 16,  15,   10, 24,  down135, unbanked }, { 16,  16,    9, 24,  down135, unbanked }, { 16,  17,    8, 24,  down135, unbanked }, { 16,  18,    7, 24,  down135, unbanked }, { 16,  19,    6, 24,  down135, unbanked },
    { 16,  20,    5, 24,  down135, unbanked }, { 16,  21,    4, 24,  down135, unbanked }, { 16,  21,    3, 24,  down135, unbanked }, { 16,  22,    2, 24,  down120, unbanked }, { 16,  23,    1, 24,  down120, unbanked },
    { 16,  23,    0, 24,  down120, unbanked }, { 16,  24,   -1, 24,  down120, unbanked }, { 16,  24,   -2, 24,  down120, unbanked }, { 16,  25,   -3, 24,  down120, unbanked }, { 16,  25,   -4, 24,  down120, unbanked },
    { 16,  25,   -5, 24,  down120, unbanked }, { 16,  26,   -6, 24,  down120, unbanked }, { 16,  26,   -7, 24,  down105, unbanked }, { 16,  27,   -8, 24,  down105, unbanked }, { 16,  27,   -9, 24,  down105, unbanked },
    { 16,  28,  -10, 24,  down105, unbanked }, { 16,  28,  -11, 24,  down105, unbanked }, { 16,  28,  -12, 24,  down105, unbanked }, { 16,  29,  -13, 24,  down105, unbanked }, { 16,  29,  -14, 24,  down105, unbanked },
    { 16,  29,  -15, 24,  down105, unbanked }, { 16,  29,  -16, 24,  down105, unbanked }, { 16,  30,  -17, 24,  down105, unbanked }, { 16,  30,  -18, 24,  down105, unbanked }, { 16,  30,  -19, 24,  down105, unbanked },
    { 16,  30,  -20, 24,  down105, unbanked }, { 16,  30,  -21, 24,   down90, unbanked }, { 16,  31,  -22, 24,   down90, unbanked }, { 16,  31,  -23, 24,   down90, unbanked }, { 16,  31,  -24, 24,   down90, unbanked },
    { 16,  31,  -25, 24,   down90, unbanked }, { 16,  31,  -26, 24,   down90, unbanked }, { 16,  31,  -27, 24,   down90, unbanked }, { 16,  31,  -28, 24,   down90, unbanked }, { 16,  31,  -29, 24,   down90, unbanked },
    { 16,  31,  -30, 24,   down90, unbanked }, { 16,  31,  -31, 24,   down90, unbanked }, { 16,  31,  -32, 24,   down90, unbanked }, { 16,  31,  -33, 24,   down90, unbanked }, { 16,  31,  -34, 24,   down90, unbanked },
    { 16,  31,  -35, 24,   down90, unbanked }, { 16,  31,  -36, 24,   down90, unbanked }, { 16,  31,  -37, 24,   down90, unbanked }, { 16,  31,  -38, 24,   down90, unbanked }, { 16,  31,  -39, 24,   down90, unbanked },
    { 16,  31,  -40, 24,   down90, unbanked }, { 16,  31,  -41, 24,   down90, unbanked }, { 16,  31,  -42, 24,   down90, unbanked }, { 16,  31,  -43, 24,   down90, unbanked }, { 16,  31,  -44, 24,   down90, unbanked },
    { 16,  31,  -45, 24,   down90, unbanked }, { 16,  31,  -46, 24,   down90, unbanked }, { 16,  31,  -47, 24,   down90, unbanked }, { 16,  31,  -48, 24,   down90, unbanked }, { 16,  31,  -49, 24,   down90, unbanked },
    { 16,  30,  -50, 24,   down90, unbanked }, { 16,  30,  -51, 24,   down90, unbanked }, { 16,  30,  -52, 24,   down90, unbanked }, { 16,  30,  -53, 24,   down90, unbanked }, { 16,  30,  -54, 24,   down75, unbanked },
    { 16,  29,  -55, 24,   down75, unbanked }, { 16,  29,  -56, 24,   down75, unbanked }, { 16,  29,  -57, 24,   down75, unbanked }, { 16,  29,  -58, 24,   down75, unbanked }, { 16,  28,  -59, 24,   down75, unbanked },
    { 16,  28,  -60, 24,   down75, unbanked }, { 16,  28,  -61, 24,   down75, unbanked }, { 16,  27,  -62, 24,   down75, unbanked }, { 16,  27,  -63, 24,   down75, unbanked }, { 16,  27,  -64, 24,   down75, unbanked },
    { 16,  26,  -65, 24,   down75, unbanked }, { 16,  26,  -66, 24,   down75, unbanked }, { 16,  26,  -67, 24,   down75, unbanked }, { 16,  25,  -68, 24,   down75, unbanked }, { 16,  25,  -69, 24,   down75, unbanked },
    { 16,  25,  -70, 24,   down75, unbanked }, { 16,  24,  -71, 24,   down75, unbanked }, { 16,  24,  -72, 24,   down75, unbanked }, { 16,  24,  -73, 24,   down75, unbanked }, { 16,  23,  -74, 24,   down75, unbanked },
    { 16,  23,  -75, 24,   down60, unbanked }, { 16,  22,  -76, 24,   down60, unbanked }, { 16,  21,  -77, 24,   down60, unbanked }, { 16,  21,  -78, 24,   down60, unbanked }, { 16,  20,  -79, 24,   down60, unbanked },
    { 16,  19,  -80, 24,   down60, unbanked }, { 16,  19,  -81, 24,   down60, unbanked }, { 16,  18,  -82, 24,   down60, unbanked }, { 16,  18,  -83, 24,   down60, unbanked }, { 16,  17,  -84, 24,   down60, unbanked },
    { 16,  16,  -85, 24,   down60, unbanked }, { 16,  15,  -86, 24,   down60, unbanked }, { 16,  15,  -87, 24,   down60, unbanked }, { 16,  14,  -88, 24,   down60, unbanked }, { 16,  13,  -89, 24,   down60, unbanked },
    { 16,  12,  -90, 24,   down60, unbanked }, { 16,  12,  -91, 24,   down42, unbanked }, { 16,  11,  -92, 24,   down42, unbanked }, { 16,  10,  -93, 24,   down42, unbanked }, { 16,   9,  -94, 24,   down42, unbanked },
    { 16,   8,  -95, 24,   down42, unbanked }, { 16,   7,  -96, 24,   down42, unbanked }, { 16,   6,  -97, 24,   down42, unbanked }, { 16,   5,  -98, 24,   down42, unbanked }, { 16,   4,  -99, 24,   down42, unbanked },
    { 16,   3, -100, 24,   down42, unbanked }, { 16,   2, -101, 24,   down42, unbanked }, { 16,   1, -102, 24,   down42, unbanked }, { 16,   0, -102, 24,   down42, unbanked }, { 16,  -1, -103, 24,   down42, unbanked },
    { 16,  -2, -104, 24,   down42, unbanked }, { 16,  -3, -105, 24,   down42, unbanked }, { 16,  -4, -105, 24,   down42, unbanked }, { 16,  -5, -106, 24,   down42, unbanked }, { 16,  -6, -107, 24,   down42, unbanked },
    { 16,  -7, -108, 24,   down42, unbanked }, { 16,  -8, -109, 24,   down42, unbanked }, { 16,  -9, -109, 24,   down42, unbanked }, { 16, -10, -110, 24,   down42, unbanked }, { 16, -11, -110, 24,   down25, unbanked },
    { 16, -12, -111, 24,   down25, unbanked }, { 16, -13, -111, 24,   down25, unbanked }, { 16, -14, -112, 24,   down25, unbanked }, { 16, -15, -112, 24,   down25, unbanked }, { 16, -16, -113, 24,   down25, unbanked },
    { 16, -17, -113, 24,   down25, unbanked }, { 16, -18, -114, 24,   down25, unbanked }, { 16, -19, -114, 24,   down25, unbanked }, { 16, -20, -115, 24,   down25, unbanked }, { 16, -21, -115, 24,   down25, unbanked },
    { 16, -22, -116, 24,   down25, unbanked }, { 16, -23, -116, 24,   down25, unbanked }, { 16, -24, -117, 24,   down25, unbanked }, { 16, -25, -117, 24,   down25, unbanked }, { 16, -26, -117, 24,   down25, unbanked },
    { 16, -27, -118, 24,   down25, unbanked }, { 16, -28, -118, 24,   down25, unbanked }, { 16, -29, -119, 24,   down25, unbanked }, { 16, -30, -119, 24,   down25, unbanked }, { 16, -31, -120, 24,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E8650, {
    {   0, 16,   16, 0, inverted, unbanked }, {   1, 16,   16, 0, inverted, unbanked }, {   2, 16,   16, 0, inverted, unbanked }, {   3, 16,   16, 0, inverted, unbanked }, {   4, 16,   16, 0, inverted, unbanked },
    {   5, 16,   16, 0,  down165, unbanked }, {   6, 16,   15, 0,  down165, unbanked }, {   7, 16,   15, 0,  down165, unbanked }, {   8, 16,   15, 0,  down165, unbanked }, {   9, 16,   14, 0,  down165, unbanked },
    {  10, 16,   14, 0,  down150, unbanked }, {  11, 16,   13, 0,  down150, unbanked }, {  12, 16,   12, 0,  down150, unbanked }, {  13, 16,   11, 0,  down150, unbanked }, {  14, 16,   10, 0,  down150, unbanked },
    {  15, 16,   10, 0,  down135, unbanked }, {  16, 16,    9, 0,  down135, unbanked }, {  17, 16,    8, 0,  down135, unbanked }, {  18, 16,    7, 0,  down135, unbanked }, {  19, 16,    6, 0,  down135, unbanked },
    {  20, 16,    5, 0,  down135, unbanked }, {  21, 16,    4, 0,  down135, unbanked }, {  21, 16,    3, 0,  down135, unbanked }, {  22, 16,    2, 0,  down120, unbanked }, {  23, 16,    1, 0,  down120, unbanked },
    {  23, 16,    0, 0,  down120, unbanked }, {  24, 16,   -1, 0,  down120, unbanked }, {  24, 16,   -2, 0,  down120, unbanked }, {  25, 16,   -3, 0,  down120, unbanked }, {  25, 16,   -4, 0,  down120, unbanked },
    {  25, 16,   -5, 0,  down120, unbanked }, {  26, 16,   -6, 0,  down120, unbanked }, {  26, 16,   -7, 0,  down105, unbanked }, {  27, 16,   -8, 0,  down105, unbanked }, {  27, 16,   -9, 0,  down105, unbanked },
    {  28, 16,  -10, 0,  down105, unbanked }, {  28, 16,  -11, 0,  down105, unbanked }, {  28, 16,  -12, 0,  down105, unbanked }, {  29, 16,  -13, 0,  down105, unbanked }, {  29, 16,  -14, 0,  down105, unbanked },
    {  29, 16,  -15, 0,  down105, unbanked }, {  29, 16,  -16, 0,  down105, unbanked }, {  30, 16,  -17, 0,  down105, unbanked }, {  30, 16,  -18, 0,  down105, unbanked }, {  30, 16,  -19, 0,  down105, unbanked },
    {  30, 16,  -20, 0,  down105, unbanked }, {  30, 16,  -21, 0,   down90, unbanked }, {  31, 16,  -22, 0,   down90, unbanked }, {  31, 16,  -23, 0,   down90, unbanked }, {  31, 16,  -24, 0,   down90, unbanked },
    {  31, 16,  -25, 0,   down90, unbanked }, {  31, 16,  -26, 0,   down90, unbanked }, {  31, 16,  -27, 0,   down90, unbanked }, {  31, 16,  -28, 0,   down90, unbanked }, {  31, 16,  -29, 0,   down90, unbanked },
    {  31, 16,  -30, 0,   down90, unbanked }, {  31, 16,  -31, 0,   down90, unbanked }, {  31, 16,  -32, 0,   down90, unbanked }, {  31, 16,  -33, 0,   down90, unbanked }, {  31, 16,  -34, 0,   down90, unbanked },
    {  31, 16,  -35, 0,   down90, unbanked }, {  31, 16,  -36, 0,   down90, unbanked }, {  31, 16,  -37, 0,   down90, unbanked }, {  31, 16,  -38, 0,   down90, unbanked }, {  31, 16,  -39, 0,   down90, unbanked },
    {  31, 16,  -40, 0,   down90, unbanked }, {  31, 16,  -41, 0,   down90, unbanked }, {  31, 16,  -42, 0,   down90, unbanked }, {  31, 16,  -43, 0,   down90, unbanked }, {  31, 16,  -44, 0,   down90, unbanked },
    {  31, 16,  -45, 0,   down90, unbanked }, {  31, 16,  -46, 0,   down90, unbanked }, {  31, 16,  -47, 0,   down90, unbanked }, {  31, 16,  -48, 0,   down90, unbanked }, {  31, 16,  -49, 0,   down90, unbanked },
    {  30, 16,  -50, 0,   down90, unbanked }, {  30, 16,  -51, 0,   down90, unbanked }, {  30, 16,  -52, 0,   down90, unbanked }, {  30, 16,  -53, 0,   down90, unbanked }, {  30, 16,  -54, 0,   down75, unbanked },
    {  29, 16,  -55, 0,   down75, unbanked }, {  29, 16,  -56, 0,   down75, unbanked }, {  29, 16,  -57, 0,   down75, unbanked }, {  29, 16,  -58, 0,   down75, unbanked }, {  28, 16,  -59, 0,   down75, unbanked },
    {  28, 16,  -60, 0,   down75, unbanked }, {  28, 16,  -61, 0,   down75, unbanked }, {  27, 16,  -62, 0,   down75, unbanked }, {  27, 16,  -63, 0,   down75, unbanked }, {  27, 16,  -64, 0,   down75, unbanked },
    {  26, 16,  -65, 0,   down75, unbanked }, {  26, 16,  -66, 0,   down75, unbanked }, {  26, 16,  -67, 0,   down75, unbanked }, {  25, 16,  -68, 0,   down75, unbanked }, {  25, 16,  -69, 0,   down75, unbanked },
    {  25, 16,  -70, 0,   down75, unbanked }, {  24, 16,  -71, 0,   down75, unbanked }, {  24, 16,  -72, 0,   down75, unbanked }, {  24, 16,  -73, 0,   down75, unbanked }, {  23, 16,  -74, 0,   down75, unbanked },
    {  23, 16,  -75, 0,   down60, unbanked }, {  22, 16,  -76, 0,   down60, unbanked }, {  21, 16,  -77, 0,   down60, unbanked }, {  21, 16,  -78, 0,   down60, unbanked }, {  20, 16,  -79, 0,   down60, unbanked },
    {  19, 16,  -80, 0,   down60, unbanked }, {  19, 16,  -81, 0,   down60, unbanked }, {  18, 16,  -82, 0,   down60, unbanked }, {  18, 16,  -83, 0,   down60, unbanked }, {  17, 16,  -84, 0,   down60, unbanked },
    {  16, 16,  -85, 0,   down60, unbanked }, {  15, 16,  -86, 0,   down60, unbanked }, {  15, 16,  -87, 0,   down60, unbanked }, {  14, 16,  -88, 0,   down60, unbanked }, {  13, 16,  -89, 0,   down60, unbanked },
    {  12, 16,  -90, 0,   down60, unbanked }, {  12, 16,  -91, 0,   down42, unbanked }, {  11, 16,  -92, 0,   down42, unbanked }, {  10, 16,  -93, 0,   down42, unbanked }, {   9, 16,  -94, 0,   down42, unbanked },
    {   8, 16,  -95, 0,   down42, unbanked }, {   7, 16,  -96, 0,   down42, unbanked }, {   6, 16,  -97, 0,   down42, unbanked }, {   5, 16,  -98, 0,   down42, unbanked }, {   4, 16,  -99, 0,   down42, unbanked },
    {   3, 16, -100, 0,   down42, unbanked }, {   2, 16, -101, 0,   down42, unbanked }, {   1, 16, -102, 0,   down42, unbanked }, {   0, 16, -102, 0,   down42, unbanked }, {  -1, 16, -103, 0,   down42, unbanked },
    {  -2, 16, -104, 0,   down42, unbanked }, {  -3, 16, -105, 0,   down42, unbanked }, {  -4, 16, -105, 0,   down42, unbanked }, {  -5, 16, -106, 0,   down42, unbanked }, {  -6, 16, -107, 0,   down42, unbanked },
    {  -7, 16, -108, 0,   down42, unbanked }, {  -8, 16, -109, 0,   down42, unbanked }, {  -9, 16, -109, 0,   down42, unbanked }, { -10, 16, -110, 0,   down42, unbanked }, { -11, 16, -110, 0,   down25, unbanked },
    { -12, 16, -111, 0,   down25, unbanked }, { -13, 16, -111, 0,   down25, unbanked }, { -14, 16, -112, 0,   down25, unbanked }, { -15, 16, -112, 0,   down25, unbanked }, { -16, 16, -113, 0,   down25, unbanked },
    { -17, 16, -113, 0,   down25, unbanked }, { -18, 16, -114, 0,   down25, unbanked }, { -19, 16, -114, 0,   down25, unbanked }, { -20, 16, -115, 0,   down25, unbanked }, { -21, 16, -115, 0,   down25, unbanked },
    { -22, 16, -116, 0,   down25, unbanked }, { -23, 16, -116, 0,   down25, unbanked }, { -24, 16, -117, 0,   down25, unbanked }, { -25, 16, -117, 0,   down25, unbanked }, { -26, 16, -117, 0,   down25, unbanked },
    { -27, 16, -118, 0,   down25, unbanked }, { -28, 16, -118, 0,   down25, unbanked }, { -29, 16, -119, 0,   down25, unbanked }, { -30, 16, -119, 0,   down25, unbanked }, { -31, 16, -120, 0,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E8BFB, {
    { 16, 31,   16, 8, inverted, unbanked }, { 16, 30,   16, 8, inverted, unbanked }, { 16, 29,   16, 8, inverted, unbanked }, { 16, 28,   16, 8, inverted, unbanked }, { 16, 27,   16, 8, inverted, unbanked },
    { 16, 26,   16, 8,  down165, unbanked }, { 16, 25,   15, 8,  down165, unbanked }, { 16, 24,   15, 8,  down165, unbanked }, { 16, 23,   15, 8,  down165, unbanked }, { 16, 22,   14, 8,  down165, unbanked },
    { 16, 21,   14, 8,  down150, unbanked }, { 16, 20,   13, 8,  down150, unbanked }, { 16, 19,   12, 8,  down150, unbanked }, { 16, 18,   11, 8,  down150, unbanked }, { 16, 17,   10, 8,  down150, unbanked },
    { 16, 16,   10, 8,  down135, unbanked }, { 16, 15,    9, 8,  down135, unbanked }, { 16, 14,    8, 8,  down135, unbanked }, { 16, 13,    7, 8,  down135, unbanked }, { 16, 12,    6, 8,  down135, unbanked },
    { 16, 11,    5, 8,  down135, unbanked }, { 16, 10,    4, 8,  down135, unbanked }, { 16, 10,    3, 8,  down135, unbanked }, { 16,  9,    2, 8,  down120, unbanked }, { 16,  8,    1, 8,  down120, unbanked },
    { 16,  8,    0, 8,  down120, unbanked }, { 16,  7,   -1, 8,  down120, unbanked }, { 16,  7,   -2, 8,  down120, unbanked }, { 16,  6,   -3, 8,  down120, unbanked }, { 16,  6,   -4, 8,  down120, unbanked },
    { 16,  6,   -5, 8,  down120, unbanked }, { 16,  5,   -6, 8,  down120, unbanked }, { 16,  5,   -7, 8,  down105, unbanked }, { 16,  4,   -8, 8,  down105, unbanked }, { 16,  4,   -9, 8,  down105, unbanked },
    { 16,  3,  -10, 8,  down105, unbanked }, { 16,  3,  -11, 8,  down105, unbanked }, { 16,  3,  -12, 8,  down105, unbanked }, { 16,  2,  -13, 8,  down105, unbanked }, { 16,  2,  -14, 8,  down105, unbanked },
    { 16,  2,  -15, 8,  down105, unbanked }, { 16,  2,  -16, 8,  down105, unbanked }, { 16,  1,  -17, 8,  down105, unbanked }, { 16,  1,  -18, 8,  down105, unbanked }, { 16,  1,  -19, 8,  down105, unbanked },
    { 16,  1,  -20, 8,  down105, unbanked }, { 16,  1,  -21, 8,   down90, unbanked }, { 16,  0,  -22, 8,   down90, unbanked }, { 16,  0,  -23, 8,   down90, unbanked }, { 16,  0,  -24, 8,   down90, unbanked },
    { 16,  0,  -25, 8,   down90, unbanked }, { 16,  0,  -26, 8,   down90, unbanked }, { 16,  0,  -27, 8,   down90, unbanked }, { 16,  0,  -28, 8,   down90, unbanked }, { 16,  0,  -29, 8,   down90, unbanked },
    { 16,  0,  -30, 8,   down90, unbanked }, { 16,  0,  -31, 8,   down90, unbanked }, { 16,  0,  -32, 8,   down90, unbanked }, { 16,  0,  -33, 8,   down90, unbanked }, { 16,  0,  -34, 8,   down90, unbanked },
    { 16,  0,  -35, 8,   down90, unbanked }, { 16,  0,  -36, 8,   down90, unbanked }, { 16,  0,  -37, 8,   down90, unbanked }, { 16,  0,  -38, 8,   down90, unbanked }, { 16,  0,  -39, 8,   down90, unbanked },
    { 16,  0,  -40, 8,   down90, unbanked }, { 16,  0,  -41, 8,   down90, unbanked }, { 16,  0,  -42, 8,   down90, unbanked }, { 16,  0,  -43, 8,   down90, unbanked }, { 16,  0,  -44, 8,   down90, unbanked },
    { 16,  0,  -45, 8,   down90, unbanked }, { 16,  0,  -46, 8,   down90, unbanked }, { 16,  0,  -47, 8,   down90, unbanked }, { 16,  0,  -48, 8,   down90, unbanked }, { 16,  0,  -49, 8,   down90, unbanked },
    { 16,  1,  -50, 8,   down90, unbanked }, { 16,  1,  -51, 8,   down90, unbanked }, { 16,  1,  -52, 8,   down90, unbanked }, { 16,  1,  -53, 8,   down90, unbanked }, { 16,  1,  -54, 8,   down75, unbanked },
    { 16,  2,  -55, 8,   down75, unbanked }, { 16,  2,  -56, 8,   down75, unbanked }, { 16,  2,  -57, 8,   down75, unbanked }, { 16,  2,  -58, 8,   down75, unbanked }, { 16,  3,  -59, 8,   down75, unbanked },
    { 16,  3,  -60, 8,   down75, unbanked }, { 16,  3,  -61, 8,   down75, unbanked }, { 16,  4,  -62, 8,   down75, unbanked }, { 16,  4,  -63, 8,   down75, unbanked }, { 16,  4,  -64, 8,   down75, unbanked },
    { 16,  5,  -65, 8,   down75, unbanked }, { 16,  5,  -66, 8,   down75, unbanked }, { 16,  5,  -67, 8,   down75, unbanked }, { 16,  6,  -68, 8,   down75, unbanked }, { 16,  6,  -69, 8,   down75, unbanked },
    { 16,  6,  -70, 8,   down75, unbanked }, { 16,  7,  -71, 8,   down75, unbanked }, { 16,  7,  -72, 8,   down75, unbanked }, { 16,  7,  -73, 8,   down75, unbanked }, { 16,  8,  -74, 8,   down75, unbanked },
    { 16,  8,  -75, 8,   down60, unbanked }, { 16,  9,  -76, 8,   down60, unbanked }, { 16, 10,  -77, 8,   down60, unbanked }, { 16, 10,  -78, 8,   down60, unbanked }, { 16, 11,  -79, 8,   down60, unbanked },
    { 16, 12,  -80, 8,   down60, unbanked }, { 16, 12,  -81, 8,   down60, unbanked }, { 16, 13,  -82, 8,   down60, unbanked }, { 16, 13,  -83, 8,   down60, unbanked }, { 16, 14,  -84, 8,   down60, unbanked },
    { 16, 15,  -85, 8,   down60, unbanked }, { 16, 16,  -86, 8,   down60, unbanked }, { 16, 16,  -87, 8,   down60, unbanked }, { 16, 17,  -88, 8,   down60, unbanked }, { 16, 18,  -89, 8,   down60, unbanked },
    { 16, 19,  -90, 8,   down60, unbanked }, { 16, 19,  -91, 8,   down42, unbanked }, { 16, 20,  -92, 8,   down42, unbanked }, { 16, 21,  -93, 8,   down42, unbanked }, { 16, 22,  -94, 8,   down42, unbanked },
    { 16, 23,  -95, 8,   down42, unbanked }, { 16, 24,  -96, 8,   down42, unbanked }, { 16, 25,  -97, 8,   down42, unbanked }, { 16, 26,  -98, 8,   down42, unbanked }, { 16, 27,  -99, 8,   down42, unbanked },
    { 16, 28, -100, 8,   down42, unbanked }, { 16, 29, -101, 8,   down42, unbanked }, { 16, 30, -102, 8,   down42, unbanked }, { 16, 31, -102, 8,   down42, unbanked }, { 16, 32, -103, 8,   down42, unbanked },
    { 16, 33, -104, 8,   down42, unbanked }, { 16, 34, -105, 8,   down42, unbanked }, { 16, 35, -105, 8,   down42, unbanked }, { 16, 36, -106, 8,   down42, unbanked }, { 16, 37, -107, 8,   down42, unbanked },
    { 16, 38, -108, 8,   down42, unbanked }, { 16, 39, -109, 8,   down42, unbanked }, { 16, 40, -109, 8,   down42, unbanked }, { 16, 41, -110, 8,   down42, unbanked }, { 16, 42, -110, 8,   down25, unbanked },
    { 16, 43, -111, 8,   down25, unbanked }, { 16, 44, -111, 8,   down25, unbanked }, { 16, 45, -112, 8,   down25, unbanked }, { 16, 46, -112, 8,   down25, unbanked }, { 16, 47, -113, 8,   down25, unbanked },
    { 16, 48, -113, 8,   down25, unbanked }, { 16, 49, -114, 8,   down25, unbanked }, { 16, 50, -114, 8,   down25, unbanked }, { 16, 51, -115, 8,   down25, unbanked }, { 16, 52, -115, 8,   down25, unbanked },
    { 16, 53, -116, 8,   down25, unbanked }, { 16, 54, -116, 8,   down25, unbanked }, { 16, 55, -117, 8,   down25, unbanked }, { 16, 56, -117, 8,   down25, unbanked }, { 16, 57, -117, 8,   down25, unbanked },
    { 16, 58, -118, 8,   down25, unbanked }, { 16, 59, -118, 8,   down25, unbanked }, { 16, 60, -119, 8,   down25, unbanked }, { 16, 61, -119, 8,   down25, unbanked }, { 16, 62, -120, 8,   down25, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EA852, {
    {  31,  16,  0, 0,             flat, unbanked }, {  30,  16,  0, 0,             flat, unbanked }, {  29,  16,  0, 0,             flat, unbanked }, {  28,  16,  0, 0,             flat, unbanked },
    {  27,  16,  0, 0,             flat, unbanked }, {  26,  16,  0, 0,             flat, unbanked }, {  25,  16,  1, 0,             flat, unbanked }, {  24,  16,  1, 0,             flat, unbanked },
    {  23,  16,  1, 0, corkscrewUpLeft0, unbanked }, {  22,  16,  1, 0, corkscrewUpLeft0, unbanked }, {  21,  16,  1, 0, corkscrewUpLeft0, unbanked }, {  20,  16,  2, 0, corkscrewUpLeft0, unbanked },
    {  19,  16,  2, 0, corkscrewUpLeft0, unbanked }, {  18,  16,  2, 0, corkscrewUpLeft0, unbanked }, {  17,  16,  3, 0, corkscrewUpLeft0, unbanked }, {  16,  16,  3, 0, corkscrewUpLeft0, unbanked },
    {  15,  16,  4, 0, corkscrewUpLeft0, unbanked }, {  14,  16,  4, 0, corkscrewUpLeft0, unbanked }, {  13,  16,  5, 0, corkscrewUpLeft0, unbanked }, {  12,  16,  5, 0, corkscrewUpLeft0, unbanked },
    {  11,  16,  6, 0, corkscrewUpLeft0, unbanked }, {  10,  16,  6, 0, corkscrewUpLeft0, unbanked }, {   9,  16,  7, 0, corkscrewUpLeft0, unbanked }, {   8,  16,  8, 0, corkscrewUpLeft0, unbanked },
    {   7,  16,  9, 0, corkscrewUpLeft1, unbanked }, {   6,  16,  9, 0, corkscrewUpLeft1, unbanked }, {   5,  15, 10, 0, corkscrewUpLeft1, unbanked }, {   4,  15, 11, 0, corkscrewUpLeft1, unbanked },
    {   3,  15, 12, 0, corkscrewUpLeft1, unbanked }, {   2,  15, 13, 0, corkscrewUpLeft1, unbanked }, {   1,  15, 14, 0, corkscrewUpLeft1, unbanked }, {   0,  15, 15, 0, corkscrewUpLeft1, unbanked },
    {  -1,  14, 16, 0, corkscrewUpLeft1, unbanked }, {  -2,  14, 17, 0, corkscrewUpLeft1, unbanked }, {  -2,  14, 18, 0, corkscrewUpLeft1, unbanked }, {  -3,  14, 19, 0, corkscrewUpLeft1, unbanked },
    {  -4,  14, 20, 0, corkscrewUpLeft1, unbanked }, {  -5,  13, 21, 0, corkscrewUpLeft1, unbanked }, {  -5,  13, 22, 0, corkscrewUpLeft1, unbanked }, {  -6,  13, 23, 0, corkscrewUpLeft1, unbanked },
    {  -6,  12, 24, 0, corkscrewUpLeft2, unbanked }, {  -7,  12, 25, 0, corkscrewUpLeft2, unbanked }, {  -8,  12, 26, 0, corkscrewUpLeft2, unbanked }, {  -8,  12, 27, 0, corkscrewUpLeft2, unbanked },
    {  -9,  11, 28, 0, corkscrewUpLeft2, unbanked }, {  -9,  11, 29, 0, corkscrewUpLeft2, unbanked }, { -10,  10, 30, 0, corkscrewUpLeft2, unbanked }, { -10,  10, 31, 0, corkscrewUpLeft2, unbanked },
    { -11,  10, 32, 0, corkscrewUpLeft2, unbanked }, { -11,   9, 33, 0, corkscrewUpLeft2, unbanked }, { -11,   9, 34, 0, corkscrewUpLeft2, unbanked }, { -12,   8, 35, 0, corkscrewUpLeft2, unbanked },
    { -12,   8, 36, 0, corkscrewUpLeft2, unbanked }, { -13,   7, 37, 0, corkscrewUpLeft2, unbanked }, { -13,   7, 38, 0, corkscrewUpLeft2, unbanked }, { -13,   6, 39, 0, corkscrewUpLeft2, unbanked },
    { -13,   5, 40, 0, corkscrewUpLeft2, unbanked }, { -14,   5, 41, 0, corkscrewUpLeft3, unbanked }, { -14,   4, 42, 0, corkscrewUpLeft3, unbanked }, { -14,   4, 43, 0, corkscrewUpLeft3, unbanked },
    { -15,   3, 44, 0, corkscrewUpLeft3, unbanked }, { -15,   2, 45, 0, corkscrewUpLeft3, unbanked }, { -15,   1, 46, 0, corkscrewUpLeft3, unbanked }, { -15,   1, 47, 0, corkscrewUpLeft3, unbanked },
    { -15,   0, 48, 0, corkscrewUpLeft3, unbanked }, { -16,  -1, 49, 0, corkscrewUpLeft3, unbanked }, { -16,  -2, 50, 0, corkscrewUpLeft3, unbanked }, { -16,  -3, 51, 0, corkscrewUpLeft3, unbanked },
    { -16,  -4, 52, 0, corkscrewUpLeft3, unbanked }, { -16,  -5, 53, 0, corkscrewUpLeft3, unbanked }, { -16,  -6, 54, 0, corkscrewUpLeft3, unbanked }, { -17,  -7, 55, 0, corkscrewUpLeft3, unbanked },
    { -17,  -8, 55, 0, corkscrewUpLeft3, unbanked }, { -17,  -9, 56, 0, corkscrewUpLeft4, unbanked }, { -17, -10, 57, 0, corkscrewUpLeft4, unbanked }, { -17, -11, 58, 0, corkscrewUpLeft4, unbanked },
    { -17, -12, 58, 0, corkscrewUpLeft4, unbanked }, { -17, -13, 59, 0, corkscrewUpLeft4, unbanked }, { -17, -14, 59, 0, corkscrewUpLeft4, unbanked }, { -17, -15, 60, 0, corkscrewUpLeft4, unbanked },
    { -17, -16, 60, 0, corkscrewUpLeft4, unbanked }, { -17, -17, 61, 0, corkscrewUpLeft4, unbanked }, { -17, -18, 61, 0, corkscrewUpLeft4, unbanked }, { -17, -19, 62, 0, corkscrewUpLeft4, unbanked },
    { -17, -20, 62, 0, corkscrewUpLeft4, unbanked }, { -17, -21, 62, 0, corkscrewUpLeft4, unbanked }, { -17, -22, 63, 0, corkscrewUpLeft4, unbanked }, { -17, -23, 63, 0, corkscrewUpLeft4, unbanked },
    { -17, -24, 63, 0, corkscrewUpLeft4, unbanked }, { -17, -25, 63, 0, corkscrewUpLeft4, unbanked }, { -17, -26, 63, 8,         inverted, unbanked }, { -17, -27, 64, 8,         inverted, unbanked },
    { -17, -28, 64, 8,         inverted, unbanked }, { -17, -29, 64, 8,         inverted, unbanked }, { -17, -30, 64, 8,         inverted, unbanked }, { -17, -31, 64, 8,         inverted, unbanked },
    { -17, -32, 64, 8,         inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EABBD, {
    {  16,  0,  0,  8,             flat, unbanked }, {  16,  1,  0,  8,             flat, unbanked }, {  16,  2,  0,  8,             flat, unbanked }, {  16,  3,  0,  8,             flat, unbanked },
    {  16,  4,  0,  8,             flat, unbanked }, {  16,  5,  0,  8,             flat, unbanked }, {  16,  6,  1,  8,             flat, unbanked }, {  16,  7,  1,  8,             flat, unbanked },
    {  16,  8,  1,  8, corkscrewUpLeft0, unbanked }, {  16,  9,  1,  8, corkscrewUpLeft0, unbanked }, {  16, 10,  1,  8, corkscrewUpLeft0, unbanked }, {  16, 11,  2,  8, corkscrewUpLeft0, unbanked },
    {  16, 12,  2,  8, corkscrewUpLeft0, unbanked }, {  16, 13,  2,  8, corkscrewUpLeft0, unbanked }, {  16, 14,  3,  8, corkscrewUpLeft0, unbanked }, {  16, 15,  3,  8, corkscrewUpLeft0, unbanked },
    {  16, 16,  4,  8, corkscrewUpLeft0, unbanked }, {  16, 17,  4,  8, corkscrewUpLeft0, unbanked }, {  16, 18,  5,  8, corkscrewUpLeft0, unbanked }, {  16, 19,  5,  8, corkscrewUpLeft0, unbanked },
    {  16, 20,  6,  8, corkscrewUpLeft0, unbanked }, {  16, 21,  6,  8, corkscrewUpLeft0, unbanked }, {  16, 22,  7,  8, corkscrewUpLeft0, unbanked }, {  16, 23,  8,  8, corkscrewUpLeft0, unbanked },
    {  16, 24,  9,  8, corkscrewUpLeft1, unbanked }, {  16, 25,  9,  8, corkscrewUpLeft1, unbanked }, {  15, 26, 10,  8, corkscrewUpLeft1, unbanked }, {  15, 27, 11,  8, corkscrewUpLeft1, unbanked },
    {  15, 28, 12,  8, corkscrewUpLeft1, unbanked }, {  15, 29, 13,  8, corkscrewUpLeft1, unbanked }, {  15, 30, 14,  8, corkscrewUpLeft1, unbanked }, {  15, 31, 15,  8, corkscrewUpLeft1, unbanked },
    {  14, 32, 16,  8, corkscrewUpLeft1, unbanked }, {  14, 33, 17,  8, corkscrewUpLeft1, unbanked }, {  14, 33, 18,  8, corkscrewUpLeft1, unbanked }, {  14, 34, 19,  8, corkscrewUpLeft1, unbanked },
    {  14, 35, 20,  8, corkscrewUpLeft1, unbanked }, {  13, 36, 21,  8, corkscrewUpLeft1, unbanked }, {  13, 36, 22,  8, corkscrewUpLeft1, unbanked }, {  13, 37, 23,  8, corkscrewUpLeft1, unbanked },
    {  12, 37, 24,  8, corkscrewUpLeft2, unbanked }, {  12, 38, 25,  8, corkscrewUpLeft2, unbanked }, {  12, 39, 26,  8, corkscrewUpLeft2, unbanked }, {  12, 39, 27,  8, corkscrewUpLeft2, unbanked },
    {  11, 40, 28,  8, corkscrewUpLeft2, unbanked }, {  11, 40, 29,  8, corkscrewUpLeft2, unbanked }, {  10, 41, 30,  8, corkscrewUpLeft2, unbanked }, {  10, 41, 31,  8, corkscrewUpLeft2, unbanked },
    {  10, 42, 32,  8, corkscrewUpLeft2, unbanked }, {   9, 42, 33,  8, corkscrewUpLeft2, unbanked }, {   9, 42, 34,  8, corkscrewUpLeft2, unbanked }, {   8, 43, 35,  8, corkscrewUpLeft2, unbanked },
    {   8, 43, 36,  8, corkscrewUpLeft2, unbanked }, {   7, 44, 37,  8, corkscrewUpLeft2, unbanked }, {   7, 44, 38,  8, corkscrewUpLeft2, unbanked }, {   6, 44, 39,  8, corkscrewUpLeft2, unbanked },
    {   5, 44, 40,  8, corkscrewUpLeft2, unbanked }, {   5, 45, 41,  8, corkscrewUpLeft3, unbanked }, {   4, 45, 42,  8, corkscrewUpLeft3, unbanked }, {   4, 45, 43,  8, corkscrewUpLeft3, unbanked },
    {   3, 46, 44,  8, corkscrewUpLeft3, unbanked }, {   2, 46, 45,  8, corkscrewUpLeft3, unbanked }, {   1, 46, 46,  8, corkscrewUpLeft3, unbanked }, {   1, 46, 47,  8, corkscrewUpLeft3, unbanked },
    {   0, 46, 48,  8, corkscrewUpLeft3, unbanked }, {  -1, 47, 49,  8, corkscrewUpLeft3, unbanked }, {  -2, 47, 50,  8, corkscrewUpLeft3, unbanked }, {  -3, 47, 51,  8, corkscrewUpLeft3, unbanked },
    {  -4, 47, 52,  8, corkscrewUpLeft3, unbanked }, {  -5, 47, 53,  8, corkscrewUpLeft3, unbanked }, {  -6, 47, 54,  8, corkscrewUpLeft3, unbanked }, {  -7, 48, 55,  8, corkscrewUpLeft3, unbanked },
    {  -8, 48, 55,  8, corkscrewUpLeft3, unbanked }, {  -9, 48, 56,  8, corkscrewUpLeft4, unbanked }, { -10, 48, 57,  8, corkscrewUpLeft4, unbanked }, { -11, 48, 58,  8, corkscrewUpLeft4, unbanked },
    { -12, 48, 58,  8, corkscrewUpLeft4, unbanked }, { -13, 48, 59,  8, corkscrewUpLeft4, unbanked }, { -14, 48, 59,  8, corkscrewUpLeft4, unbanked }, { -15, 48, 60,  8, corkscrewUpLeft4, unbanked },
    { -16, 48, 60,  8, corkscrewUpLeft4, unbanked }, { -17, 48, 61,  8, corkscrewUpLeft4, unbanked }, { -18, 48, 61,  8, corkscrewUpLeft4, unbanked }, { -19, 48, 62,  8, corkscrewUpLeft4, unbanked },
    { -20, 48, 62,  8, corkscrewUpLeft4, unbanked }, { -21, 48, 62,  8, corkscrewUpLeft4, unbanked }, { -22, 48, 63,  8, corkscrewUpLeft4, unbanked }, { -23, 48, 63,  8, corkscrewUpLeft4, unbanked },
    { -24, 48, 63,  8, corkscrewUpLeft4, unbanked }, { -25, 48, 63,  8, corkscrewUpLeft4, unbanked }, { -26, 48, 63, 16,         inverted, unbanked }, { -27, 48, 64, 16,         inverted, unbanked },
    { -28, 48, 64, 16,         inverted, unbanked }, { -29, 48, 64, 16,         inverted, unbanked }, { -30, 48, 64, 16,         inverted, unbanked }, { -31, 48, 64, 16,         inverted, unbanked },
    { -32, 48, 64, 16,         inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EAF28, {
    {  0, 16,  0, 16,             flat, unbanked }, {  1, 16,  0, 16,             flat, unbanked }, {  2, 16,  0, 16,             flat, unbanked }, {  3, 16,  0, 16,             flat, unbanked },
    {  4, 16,  0, 16,             flat, unbanked }, {  5, 16,  0, 16,             flat, unbanked }, {  6, 16,  1, 16,             flat, unbanked }, {  7, 16,  1, 16,             flat, unbanked },
    {  8, 16,  1, 16, corkscrewUpLeft0, unbanked }, {  9, 16,  1, 16, corkscrewUpLeft0, unbanked }, { 10, 16,  1, 16, corkscrewUpLeft0, unbanked }, { 11, 16,  2, 16, corkscrewUpLeft0, unbanked },
    { 12, 16,  2, 16, corkscrewUpLeft0, unbanked }, { 13, 16,  2, 16, corkscrewUpLeft0, unbanked }, { 14, 16,  3, 16, corkscrewUpLeft0, unbanked }, { 15, 16,  3, 16, corkscrewUpLeft0, unbanked },
    { 16, 16,  4, 16, corkscrewUpLeft0, unbanked }, { 17, 16,  4, 16, corkscrewUpLeft0, unbanked }, { 18, 16,  5, 16, corkscrewUpLeft0, unbanked }, { 19, 16,  5, 16, corkscrewUpLeft0, unbanked },
    { 20, 16,  6, 16, corkscrewUpLeft0, unbanked }, { 21, 16,  6, 16, corkscrewUpLeft0, unbanked }, { 22, 16,  7, 16, corkscrewUpLeft0, unbanked }, { 23, 16,  8, 16, corkscrewUpLeft0, unbanked },
    { 24, 16,  9, 16, corkscrewUpLeft1, unbanked }, { 25, 16,  9, 16, corkscrewUpLeft1, unbanked }, { 26, 17, 10, 16, corkscrewUpLeft1, unbanked }, { 27, 17, 11, 16, corkscrewUpLeft1, unbanked },
    { 28, 17, 12, 16, corkscrewUpLeft1, unbanked }, { 29, 17, 13, 16, corkscrewUpLeft1, unbanked }, { 30, 17, 14, 16, corkscrewUpLeft1, unbanked }, { 31, 17, 15, 16, corkscrewUpLeft1, unbanked },
    { 32, 18, 16, 16, corkscrewUpLeft1, unbanked }, { 33, 18, 17, 16, corkscrewUpLeft1, unbanked }, { 33, 18, 18, 16, corkscrewUpLeft1, unbanked }, { 34, 18, 19, 16, corkscrewUpLeft1, unbanked },
    { 35, 18, 20, 16, corkscrewUpLeft1, unbanked }, { 36, 19, 21, 16, corkscrewUpLeft1, unbanked }, { 36, 19, 22, 16, corkscrewUpLeft1, unbanked }, { 37, 19, 23, 16, corkscrewUpLeft1, unbanked },
    { 37, 20, 24, 16, corkscrewUpLeft2, unbanked }, { 38, 20, 25, 16, corkscrewUpLeft2, unbanked }, { 39, 20, 26, 16, corkscrewUpLeft2, unbanked }, { 39, 20, 27, 16, corkscrewUpLeft2, unbanked },
    { 40, 21, 28, 16, corkscrewUpLeft2, unbanked }, { 40, 21, 29, 16, corkscrewUpLeft2, unbanked }, { 41, 22, 30, 16, corkscrewUpLeft2, unbanked }, { 41, 22, 31, 16, corkscrewUpLeft2, unbanked },
    { 42, 22, 32, 16, corkscrewUpLeft2, unbanked }, { 42, 23, 33, 16, corkscrewUpLeft2, unbanked }, { 42, 23, 34, 16, corkscrewUpLeft2, unbanked }, { 43, 24, 35, 16, corkscrewUpLeft2, unbanked },
    { 43, 24, 36, 16, corkscrewUpLeft2, unbanked }, { 44, 25, 37, 16, corkscrewUpLeft2, unbanked }, { 44, 25, 38, 16, corkscrewUpLeft2, unbanked }, { 44, 26, 39, 16, corkscrewUpLeft2, unbanked },
    { 44, 27, 40, 16, corkscrewUpLeft2, unbanked }, { 45, 27, 41, 16, corkscrewUpLeft3, unbanked }, { 45, 28, 42, 16, corkscrewUpLeft3, unbanked }, { 45, 28, 43, 16, corkscrewUpLeft3, unbanked },
    { 46, 29, 44, 16, corkscrewUpLeft3, unbanked }, { 46, 30, 45, 16, corkscrewUpLeft3, unbanked }, { 46, 31, 46, 16, corkscrewUpLeft3, unbanked }, { 46, 31, 47, 16, corkscrewUpLeft3, unbanked },
    { 46, 32, 48, 16, corkscrewUpLeft3, unbanked }, { 47, 33, 49, 16, corkscrewUpLeft3, unbanked }, { 47, 34, 50, 16, corkscrewUpLeft3, unbanked }, { 47, 35, 51, 16, corkscrewUpLeft3, unbanked },
    { 47, 36, 52, 16, corkscrewUpLeft3, unbanked }, { 47, 37, 53, 16, corkscrewUpLeft3, unbanked }, { 47, 38, 54, 16, corkscrewUpLeft3, unbanked }, { 48, 39, 55, 16, corkscrewUpLeft3, unbanked },
    { 48, 40, 55, 16, corkscrewUpLeft3, unbanked }, { 48, 41, 56, 16, corkscrewUpLeft4, unbanked }, { 48, 42, 57, 16, corkscrewUpLeft4, unbanked }, { 48, 43, 58, 16, corkscrewUpLeft4, unbanked },
    { 48, 44, 58, 16, corkscrewUpLeft4, unbanked }, { 48, 45, 59, 16, corkscrewUpLeft4, unbanked }, { 48, 46, 59, 16, corkscrewUpLeft4, unbanked }, { 48, 47, 60, 16, corkscrewUpLeft4, unbanked },
    { 48, 48, 60, 16, corkscrewUpLeft4, unbanked }, { 48, 49, 61, 16, corkscrewUpLeft4, unbanked }, { 48, 50, 61, 16, corkscrewUpLeft4, unbanked }, { 48, 51, 62, 16, corkscrewUpLeft4, unbanked },
    { 48, 52, 62, 16, corkscrewUpLeft4, unbanked }, { 48, 53, 62, 16, corkscrewUpLeft4, unbanked }, { 48, 54, 63, 16, corkscrewUpLeft4, unbanked }, { 48, 55, 63, 16, corkscrewUpLeft4, unbanked },
    { 48, 56, 63, 16, corkscrewUpLeft4, unbanked }, { 48, 57, 63, 16, corkscrewUpLeft4, unbanked }, { 48, 58, 63, 24,         inverted, unbanked }, { 48, 59, 64, 24,         inverted, unbanked },
    { 48, 60, 64, 24,         inverted, unbanked }, { 48, 61, 64, 24,         inverted, unbanked }, { 48, 62, 64, 24,         inverted, unbanked }, { 48, 63, 64, 24,         inverted, unbanked },
    { 48, 64, 64, 24,         inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EB293, {
    { 16,  31,  0, 24,             flat, unbanked }, { 16,  30,  0, 24,             flat, unbanked }, { 16,  29,  0, 24,             flat, unbanked }, { 16,  28,  0, 24,             flat, unbanked },
    { 16,  27,  0, 24,             flat, unbanked }, { 16,  26,  0, 24,             flat, unbanked }, { 16,  25,  1, 24,             flat, unbanked }, { 16,  24,  1, 24,             flat, unbanked },
    { 16,  23,  1, 24, corkscrewUpLeft0, unbanked }, { 16,  22,  1, 24, corkscrewUpLeft0, unbanked }, { 16,  21,  1, 24, corkscrewUpLeft0, unbanked }, { 16,  20,  2, 24, corkscrewUpLeft0, unbanked },
    { 16,  19,  2, 24, corkscrewUpLeft0, unbanked }, { 16,  18,  2, 24, corkscrewUpLeft0, unbanked }, { 16,  17,  3, 24, corkscrewUpLeft0, unbanked }, { 16,  16,  3, 24, corkscrewUpLeft0, unbanked },
    { 16,  15,  4, 24, corkscrewUpLeft0, unbanked }, { 16,  14,  4, 24, corkscrewUpLeft0, unbanked }, { 16,  13,  5, 24, corkscrewUpLeft0, unbanked }, { 16,  12,  5, 24, corkscrewUpLeft0, unbanked },
    { 16,  11,  6, 24, corkscrewUpLeft0, unbanked }, { 16,  10,  6, 24, corkscrewUpLeft0, unbanked }, { 16,   9,  7, 24, corkscrewUpLeft0, unbanked }, { 16,   8,  8, 24, corkscrewUpLeft0, unbanked },
    { 16,   7,  9, 24, corkscrewUpLeft1, unbanked }, { 16,   6,  9, 24, corkscrewUpLeft1, unbanked }, { 17,   5, 10, 24, corkscrewUpLeft1, unbanked }, { 17,   4, 11, 24, corkscrewUpLeft1, unbanked },
    { 17,   3, 12, 24, corkscrewUpLeft1, unbanked }, { 17,   2, 13, 24, corkscrewUpLeft1, unbanked }, { 17,   1, 14, 24, corkscrewUpLeft1, unbanked }, { 17,   0, 15, 24, corkscrewUpLeft1, unbanked },
    { 18,  -1, 16, 24, corkscrewUpLeft1, unbanked }, { 18,  -2, 17, 24, corkscrewUpLeft1, unbanked }, { 18,  -2, 18, 24, corkscrewUpLeft1, unbanked }, { 18,  -3, 19, 24, corkscrewUpLeft1, unbanked },
    { 18,  -4, 20, 24, corkscrewUpLeft1, unbanked }, { 19,  -5, 21, 24, corkscrewUpLeft1, unbanked }, { 19,  -5, 22, 24, corkscrewUpLeft1, unbanked }, { 19,  -6, 23, 24, corkscrewUpLeft1, unbanked },
    { 20,  -6, 24, 24, corkscrewUpLeft2, unbanked }, { 20,  -7, 25, 24, corkscrewUpLeft2, unbanked }, { 20,  -8, 26, 24, corkscrewUpLeft2, unbanked }, { 20,  -8, 27, 24, corkscrewUpLeft2, unbanked },
    { 21,  -9, 28, 24, corkscrewUpLeft2, unbanked }, { 21,  -9, 29, 24, corkscrewUpLeft2, unbanked }, { 22, -10, 30, 24, corkscrewUpLeft2, unbanked }, { 22, -10, 31, 24, corkscrewUpLeft2, unbanked },
    { 22, -11, 32, 24, corkscrewUpLeft2, unbanked }, { 23, -11, 33, 24, corkscrewUpLeft2, unbanked }, { 23, -11, 34, 24, corkscrewUpLeft2, unbanked }, { 24, -12, 35, 24, corkscrewUpLeft2, unbanked },
    { 24, -12, 36, 24, corkscrewUpLeft2, unbanked }, { 25, -13, 37, 24, corkscrewUpLeft2, unbanked }, { 25, -13, 38, 24, corkscrewUpLeft2, unbanked }, { 26, -13, 39, 24, corkscrewUpLeft2, unbanked },
    { 27, -13, 40, 24, corkscrewUpLeft2, unbanked }, { 27, -14, 41, 24, corkscrewUpLeft3, unbanked }, { 28, -14, 42, 24, corkscrewUpLeft3, unbanked }, { 28, -14, 43, 24, corkscrewUpLeft3, unbanked },
    { 29, -15, 44, 24, corkscrewUpLeft3, unbanked }, { 30, -15, 45, 24, corkscrewUpLeft3, unbanked }, { 31, -15, 46, 24, corkscrewUpLeft3, unbanked }, { 31, -15, 47, 24, corkscrewUpLeft3, unbanked },
    { 32, -15, 48, 24, corkscrewUpLeft3, unbanked }, { 33, -16, 49, 24, corkscrewUpLeft3, unbanked }, { 34, -16, 50, 24, corkscrewUpLeft3, unbanked }, { 35, -16, 51, 24, corkscrewUpLeft3, unbanked },
    { 36, -16, 52, 24, corkscrewUpLeft3, unbanked }, { 37, -16, 53, 24, corkscrewUpLeft3, unbanked }, { 38, -16, 54, 24, corkscrewUpLeft3, unbanked }, { 39, -17, 55, 24, corkscrewUpLeft3, unbanked },
    { 40, -17, 55, 24, corkscrewUpLeft3, unbanked }, { 41, -17, 56, 24, corkscrewUpLeft4, unbanked }, { 42, -17, 57, 24, corkscrewUpLeft4, unbanked }, { 43, -17, 58, 24, corkscrewUpLeft4, unbanked },
    { 44, -17, 58, 24, corkscrewUpLeft4, unbanked }, { 45, -17, 59, 24, corkscrewUpLeft4, unbanked }, { 46, -17, 59, 24, corkscrewUpLeft4, unbanked }, { 47, -17, 60, 24, corkscrewUpLeft4, unbanked },
    { 48, -17, 60, 24, corkscrewUpLeft4, unbanked }, { 49, -17, 61, 24, corkscrewUpLeft4, unbanked }, { 50, -17, 61, 24, corkscrewUpLeft4, unbanked }, { 51, -17, 62, 24, corkscrewUpLeft4, unbanked },
    { 52, -17, 62, 24, corkscrewUpLeft4, unbanked }, { 53, -17, 62, 24, corkscrewUpLeft4, unbanked }, { 54, -17, 63, 24, corkscrewUpLeft4, unbanked }, { 55, -17, 63, 24, corkscrewUpLeft4, unbanked },
    { 56, -17, 63, 24, corkscrewUpLeft4, unbanked }, { 57, -17, 63, 24, corkscrewUpLeft4, unbanked }, { 58, -17, 63,  0,         inverted, unbanked }, { 59, -17, 64,  0,         inverted, unbanked },
    { 60, -17, 64,  0,         inverted, unbanked }, { 61, -17, 64,  0,         inverted, unbanked }, { 62, -17, 64,  0,         inverted, unbanked }, { 63, -17, 64,  0,         inverted, unbanked },
    { 64, -17, 64,  0,         inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EB5FE, {
    {  31, 16,  0,  0,              flat, unbanked }, {  30, 16,  0,  0,              flat, unbanked }, {  29, 16,  0,  0,              flat, unbanked }, {  28, 16,  0,  0,              flat, unbanked },
    {  27, 16,  0,  0,              flat, unbanked }, {  26, 16,  0,  0,              flat, unbanked }, {  25, 16,  1,  0,              flat, unbanked }, {  24, 16,  1,  0,              flat, unbanked },
    {  23, 16,  1,  0, corkscrewUpRight0, unbanked }, {  22, 16,  1,  0, corkscrewUpRight0, unbanked }, {  21, 16,  1,  0, corkscrewUpRight0, unbanked }, {  20, 16,  2,  0, corkscrewUpRight0, unbanked },
    {  19, 16,  2,  0, corkscrewUpRight0, unbanked }, {  18, 16,  2,  0, corkscrewUpRight0, unbanked }, {  17, 16,  3,  0, corkscrewUpRight0, unbanked }, {  16, 16,  3,  0, corkscrewUpRight0, unbanked },
    {  15, 16,  4,  0, corkscrewUpRight0, unbanked }, {  14, 16,  4,  0, corkscrewUpRight0, unbanked }, {  13, 16,  5,  0, corkscrewUpRight0, unbanked }, {  12, 16,  5,  0, corkscrewUpRight0, unbanked },
    {  11, 16,  6,  0, corkscrewUpRight0, unbanked }, {  10, 16,  6,  0, corkscrewUpRight0, unbanked }, {   9, 16,  7,  0, corkscrewUpRight0, unbanked }, {   8, 16,  8,  0, corkscrewUpRight0, unbanked },
    {   7, 16,  9,  0, corkscrewUpRight1, unbanked }, {   6, 16,  9,  0, corkscrewUpRight1, unbanked }, {   5, 17, 10,  0, corkscrewUpRight1, unbanked }, {   4, 17, 11,  0, corkscrewUpRight1, unbanked },
    {   3, 17, 12,  0, corkscrewUpRight1, unbanked }, {   2, 17, 13,  0, corkscrewUpRight1, unbanked }, {   1, 17, 14,  0, corkscrewUpRight1, unbanked }, {   0, 17, 15,  0, corkscrewUpRight1, unbanked },
    {  -1, 18, 16,  0, corkscrewUpRight1, unbanked }, {  -2, 18, 17,  0, corkscrewUpRight1, unbanked }, {  -2, 18, 18,  0, corkscrewUpRight1, unbanked }, {  -3, 18, 19,  0, corkscrewUpRight1, unbanked },
    {  -4, 18, 20,  0, corkscrewUpRight1, unbanked }, {  -5, 19, 21,  0, corkscrewUpRight1, unbanked }, {  -5, 19, 22,  0, corkscrewUpRight1, unbanked }, {  -6, 19, 23,  0, corkscrewUpRight1, unbanked },
    {  -6, 20, 24,  0, corkscrewUpRight2, unbanked }, {  -7, 20, 25,  0, corkscrewUpRight2, unbanked }, {  -8, 20, 26,  0, corkscrewUpRight2, unbanked }, {  -8, 20, 27,  0, corkscrewUpRight2, unbanked },
    {  -9, 21, 28,  0, corkscrewUpRight2, unbanked }, {  -9, 21, 29,  0, corkscrewUpRight2, unbanked }, { -10, 22, 30,  0, corkscrewUpRight2, unbanked }, { -10, 22, 31,  0, corkscrewUpRight2, unbanked },
    { -11, 22, 32,  0, corkscrewUpRight2, unbanked }, { -11, 23, 33,  0, corkscrewUpRight2, unbanked }, { -11, 23, 34,  0, corkscrewUpRight2, unbanked }, { -12, 24, 35,  0, corkscrewUpRight2, unbanked },
    { -12, 24, 36,  0, corkscrewUpRight2, unbanked }, { -13, 25, 37,  0, corkscrewUpRight2, unbanked }, { -13, 25, 38,  0, corkscrewUpRight2, unbanked }, { -13, 26, 39,  0, corkscrewUpRight2, unbanked },
    { -13, 27, 40,  0, corkscrewUpRight2, unbanked }, { -14, 27, 41,  0, corkscrewUpRight3, unbanked }, { -14, 28, 42,  0, corkscrewUpRight3, unbanked }, { -14, 28, 43,  0, corkscrewUpRight3, unbanked },
    { -15, 29, 44,  0, corkscrewUpRight3, unbanked }, { -15, 30, 45,  0, corkscrewUpRight3, unbanked }, { -15, 31, 46,  0, corkscrewUpRight3, unbanked }, { -15, 31, 47,  0, corkscrewUpRight3, unbanked },
    { -15, 32, 48,  0, corkscrewUpRight3, unbanked }, { -16, 33, 49,  0, corkscrewUpRight3, unbanked }, { -16, 34, 50,  0, corkscrewUpRight3, unbanked }, { -16, 35, 51,  0, corkscrewUpRight3, unbanked },
    { -16, 36, 52,  0, corkscrewUpRight3, unbanked }, { -16, 37, 53,  0, corkscrewUpRight3, unbanked }, { -16, 38, 54,  0, corkscrewUpRight3, unbanked }, { -17, 39, 55,  0, corkscrewUpRight3, unbanked },
    { -17, 40, 55,  0, corkscrewUpRight3, unbanked }, { -17, 41, 56,  0, corkscrewUpRight4, unbanked }, { -17, 42, 57,  0, corkscrewUpRight4, unbanked }, { -17, 43, 58,  0, corkscrewUpRight4, unbanked },
    { -17, 44, 58,  0, corkscrewUpRight4, unbanked }, { -17, 45, 59,  0, corkscrewUpRight4, unbanked }, { -17, 46, 59,  0, corkscrewUpRight4, unbanked }, { -17, 47, 60,  0, corkscrewUpRight4, unbanked },
    { -17, 48, 60,  0, corkscrewUpRight4, unbanked }, { -17, 49, 61,  0, corkscrewUpRight4, unbanked }, { -17, 50, 61,  0, corkscrewUpRight4, unbanked }, { -17, 51, 62,  0, corkscrewUpRight4, unbanked },
    { -17, 52, 62,  0, corkscrewUpRight4, unbanked }, { -17, 53, 62,  0, corkscrewUpRight4, unbanked }, { -17, 54, 63,  0, corkscrewUpRight4, unbanked }, { -17, 55, 63,  0, corkscrewUpRight4, unbanked },
    { -17, 56, 63,  0, corkscrewUpRight4, unbanked }, { -17, 57, 63,  0, corkscrewUpRight4, unbanked }, { -17, 58, 63, 24,          inverted, unbanked }, { -17, 59, 64, 24,          inverted, unbanked },
    { -17, 60, 64, 24,          inverted, unbanked }, { -17, 61, 64, 24,          inverted, unbanked }, { -17, 62, 64, 24,          inverted, unbanked }, { -17, 63, 64, 24,          inverted, unbanked },
    { -17, 64, 64, 24,          inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EB969, {
    { 16,  0,  0, 8,              flat, unbanked }, { 16,  1,  0, 8,              flat, unbanked }, { 16,  2,  0, 8,              flat, unbanked }, { 16,  3,  0, 8,              flat, unbanked },
    { 16,  4,  0, 8,              flat, unbanked }, { 16,  5,  0, 8,              flat, unbanked }, { 16,  6,  1, 8,              flat, unbanked }, { 16,  7,  1, 8,              flat, unbanked },
    { 16,  8,  1, 8, corkscrewUpRight0, unbanked }, { 16,  9,  1, 8, corkscrewUpRight0, unbanked }, { 16, 10,  1, 8, corkscrewUpRight0, unbanked }, { 16, 11,  2, 8, corkscrewUpRight0, unbanked },
    { 16, 12,  2, 8, corkscrewUpRight0, unbanked }, { 16, 13,  2, 8, corkscrewUpRight0, unbanked }, { 16, 14,  3, 8, corkscrewUpRight0, unbanked }, { 16, 15,  3, 8, corkscrewUpRight0, unbanked },
    { 16, 16,  4, 8, corkscrewUpRight0, unbanked }, { 16, 17,  4, 8, corkscrewUpRight0, unbanked }, { 16, 18,  5, 8, corkscrewUpRight0, unbanked }, { 16, 19,  5, 8, corkscrewUpRight0, unbanked },
    { 16, 20,  6, 8, corkscrewUpRight0, unbanked }, { 16, 21,  6, 8, corkscrewUpRight0, unbanked }, { 16, 22,  7, 8, corkscrewUpRight0, unbanked }, { 16, 23,  8, 8, corkscrewUpRight0, unbanked },
    { 16, 24,  9, 8, corkscrewUpRight1, unbanked }, { 16, 25,  9, 8, corkscrewUpRight1, unbanked }, { 17, 26, 10, 8, corkscrewUpRight1, unbanked }, { 17, 27, 11, 8, corkscrewUpRight1, unbanked },
    { 17, 28, 12, 8, corkscrewUpRight1, unbanked }, { 17, 29, 13, 8, corkscrewUpRight1, unbanked }, { 17, 30, 14, 8, corkscrewUpRight1, unbanked }, { 17, 31, 15, 8, corkscrewUpRight1, unbanked },
    { 18, 32, 16, 8, corkscrewUpRight1, unbanked }, { 18, 33, 17, 8, corkscrewUpRight1, unbanked }, { 18, 33, 18, 8, corkscrewUpRight1, unbanked }, { 18, 34, 19, 8, corkscrewUpRight1, unbanked },
    { 18, 35, 20, 8, corkscrewUpRight1, unbanked }, { 19, 36, 21, 8, corkscrewUpRight1, unbanked }, { 19, 36, 22, 8, corkscrewUpRight1, unbanked }, { 19, 37, 23, 8, corkscrewUpRight1, unbanked },
    { 20, 37, 24, 8, corkscrewUpRight2, unbanked }, { 20, 38, 25, 8, corkscrewUpRight2, unbanked }, { 20, 39, 26, 8, corkscrewUpRight2, unbanked }, { 20, 39, 27, 8, corkscrewUpRight2, unbanked },
    { 21, 40, 28, 8, corkscrewUpRight2, unbanked }, { 21, 40, 29, 8, corkscrewUpRight2, unbanked }, { 22, 41, 30, 8, corkscrewUpRight2, unbanked }, { 22, 41, 31, 8, corkscrewUpRight2, unbanked },
    { 22, 42, 32, 8, corkscrewUpRight2, unbanked }, { 23, 42, 33, 8, corkscrewUpRight2, unbanked }, { 23, 42, 34, 8, corkscrewUpRight2, unbanked }, { 24, 43, 35, 8, corkscrewUpRight2, unbanked },
    { 24, 43, 36, 8, corkscrewUpRight2, unbanked }, { 25, 44, 37, 8, corkscrewUpRight2, unbanked }, { 25, 44, 38, 8, corkscrewUpRight2, unbanked }, { 26, 44, 39, 8, corkscrewUpRight2, unbanked },
    { 27, 44, 40, 8, corkscrewUpRight2, unbanked }, { 27, 45, 41, 8, corkscrewUpRight3, unbanked }, { 28, 45, 42, 8, corkscrewUpRight3, unbanked }, { 28, 45, 43, 8, corkscrewUpRight3, unbanked },
    { 29, 46, 44, 8, corkscrewUpRight3, unbanked }, { 30, 46, 45, 8, corkscrewUpRight3, unbanked }, { 31, 46, 46, 8, corkscrewUpRight3, unbanked }, { 31, 46, 47, 8, corkscrewUpRight3, unbanked },
    { 32, 46, 48, 8, corkscrewUpRight3, unbanked }, { 33, 47, 49, 8, corkscrewUpRight3, unbanked }, { 34, 47, 50, 8, corkscrewUpRight3, unbanked }, { 35, 47, 51, 8, corkscrewUpRight3, unbanked },
    { 36, 47, 52, 8, corkscrewUpRight3, unbanked }, { 37, 47, 53, 8, corkscrewUpRight3, unbanked }, { 38, 47, 54, 8, corkscrewUpRight3, unbanked }, { 39, 48, 55, 8, corkscrewUpRight3, unbanked },
    { 40, 48, 55, 8, corkscrewUpRight3, unbanked }, { 41, 48, 56, 8, corkscrewUpRight4, unbanked }, { 42, 48, 57, 8, corkscrewUpRight4, unbanked }, { 43, 48, 58, 8, corkscrewUpRight4, unbanked },
    { 44, 48, 58, 8, corkscrewUpRight4, unbanked }, { 45, 48, 59, 8, corkscrewUpRight4, unbanked }, { 46, 48, 59, 8, corkscrewUpRight4, unbanked }, { 47, 48, 60, 8, corkscrewUpRight4, unbanked },
    { 48, 48, 60, 8, corkscrewUpRight4, unbanked }, { 49, 48, 61, 8, corkscrewUpRight4, unbanked }, { 50, 48, 61, 8, corkscrewUpRight4, unbanked }, { 51, 48, 62, 8, corkscrewUpRight4, unbanked },
    { 52, 48, 62, 8, corkscrewUpRight4, unbanked }, { 53, 48, 62, 8, corkscrewUpRight4, unbanked }, { 54, 48, 63, 8, corkscrewUpRight4, unbanked }, { 55, 48, 63, 8, corkscrewUpRight4, unbanked },
    { 56, 48, 63, 8, corkscrewUpRight4, unbanked }, { 57, 48, 63, 8, corkscrewUpRight4, unbanked }, { 58, 48, 63, 0,          inverted, unbanked }, { 59, 48, 64, 0,          inverted, unbanked },
    { 60, 48, 64, 0,          inverted, unbanked }, { 61, 48, 64, 0,          inverted, unbanked }, { 62, 48, 64, 0,          inverted, unbanked }, { 63, 48, 64, 0,          inverted, unbanked },
    { 64, 48, 64, 0,          inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EBCD4, {
    {  0,  16,  0, 16,              flat, unbanked }, {  1,  16,  0, 16,              flat, unbanked }, {  2,  16,  0, 16,              flat, unbanked },
    {  3,  16,  0, 16,              flat, unbanked }, {  4,  16,  0, 16,              flat, unbanked }, {  5,  16,  0, 16,              flat, unbanked },
    {  6,  16,  1, 16,              flat, unbanked }, {  7,  16,  1, 16,              flat, unbanked }, {  8,  16,  1, 16, corkscrewUpRight0, unbanked },
    {  9,  16,  1, 16, corkscrewUpRight0, unbanked }, { 10,  16,  1, 16, corkscrewUpRight0, unbanked }, { 11,  16,  2, 16, corkscrewUpRight0, unbanked },
    { 12,  16,  2, 16, corkscrewUpRight0, unbanked }, { 13,  16,  2, 16, corkscrewUpRight0, unbanked }, { 14,  16,  3, 16, corkscrewUpRight0, unbanked },
    { 15,  16,  3, 16, corkscrewUpRight0, unbanked }, { 16,  16,  4, 16, corkscrewUpRight0, unbanked }, { 17,  16,  4, 16, corkscrewUpRight0, unbanked },
    { 18,  16,  5, 16, corkscrewUpRight0, unbanked }, { 19,  16,  5, 16, corkscrewUpRight0, unbanked }, { 20,  16,  6, 16, corkscrewUpRight0, unbanked },
    { 21,  16,  6, 16, corkscrewUpRight0, unbanked }, { 22,  16,  7, 16, corkscrewUpRight0, unbanked }, { 23,  16,  8, 16, corkscrewUpRight0, unbanked },
    { 24,  16,  9, 16, corkscrewUpRight1, unbanked }, { 25,  16,  9, 16, corkscrewUpRight1, unbanked }, { 26,  15, 10, 16, corkscrewUpRight1, unbanked },
    { 27,  15, 11, 16, corkscrewUpRight1, unbanked }, { 28,  15, 12, 16, corkscrewUpRight1, unbanked }, { 29,  15, 13, 16, corkscrewUpRight1, unbanked },
    { 30,  15, 14, 16, corkscrewUpRight1, unbanked }, { 31,  15, 15, 16, corkscrewUpRight1, unbanked }, { 32,  14, 16, 16, corkscrewUpRight1, unbanked },
    { 33,  14, 17, 16, corkscrewUpRight1, unbanked }, { 33,  14, 18, 16, corkscrewUpRight1, unbanked }, { 34,  14, 19, 16, corkscrewUpRight1, unbanked },
    { 35,  14, 20, 16, corkscrewUpRight1, unbanked }, { 36,  13, 21, 16, corkscrewUpRight1, unbanked }, { 36,  13, 22, 16, corkscrewUpRight1, unbanked },
    { 37,  13, 23, 16, corkscrewUpRight1, unbanked }, { 37,  12, 24, 16, corkscrewUpRight2, unbanked }, { 38,  12, 25, 16, corkscrewUpRight2, unbanked },
    { 39,  12, 26, 16, corkscrewUpRight2, unbanked }, { 39,  12, 27, 16, corkscrewUpRight2, unbanked }, { 40,  11, 28, 16, corkscrewUpRight2, unbanked },
    { 40,  11, 29, 16, corkscrewUpRight2, unbanked }, { 41,  10, 30, 16, corkscrewUpRight2, unbanked }, { 41,  10, 31, 16, corkscrewUpRight2, unbanked },
    { 42,  10, 32, 16, corkscrewUpRight2, unbanked }, { 42,   9, 33, 16, corkscrewUpRight2, unbanked }, { 42,   9, 34, 16, corkscrewUpRight2, unbanked },
    { 43,   8, 35, 16, corkscrewUpRight2, unbanked }, { 43,   8, 36, 16, corkscrewUpRight2, unbanked }, { 44,   7, 37, 16, corkscrewUpRight2, unbanked },
    { 44,   7, 38, 16, corkscrewUpRight2, unbanked }, { 44,   6, 39, 16, corkscrewUpRight2, unbanked }, { 44,   5, 40, 16, corkscrewUpRight2, unbanked },
    { 45,   5, 41, 16, corkscrewUpRight3, unbanked }, { 45,   4, 42, 16, corkscrewUpRight3, unbanked }, { 45,   4, 43, 16, corkscrewUpRight3, unbanked },
    { 46,   3, 44, 16, corkscrewUpRight3, unbanked }, { 46,   2, 45, 16, corkscrewUpRight3, unbanked }, { 46,   1, 46, 16, corkscrewUpRight3, unbanked },
    { 46,   1, 47, 16, corkscrewUpRight3, unbanked }, { 46,   0, 48, 16, corkscrewUpRight3, unbanked }, { 47,  -1, 49, 16, corkscrewUpRight3, unbanked },
    { 47,  -2, 50, 16, corkscrewUpRight3, unbanked }, { 47,  -3, 51, 16, corkscrewUpRight3, unbanked }, { 47,  -4, 52, 16, corkscrewUpRight3, unbanked },
    { 47,  -5, 53, 16, corkscrewUpRight3, unbanked }, { 47,  -6, 54, 16, corkscrewUpRight3, unbanked }, { 48,  -7, 55, 16, corkscrewUpRight3, unbanked },
    { 48,  -8, 55, 16, corkscrewUpRight3, unbanked }, { 48,  -9, 56, 16, corkscrewUpRight4, unbanked }, { 48, -10, 57, 16, corkscrewUpRight4, unbanked },
    { 48, -11, 58, 16, corkscrewUpRight4, unbanked }, { 48, -12, 58, 16, corkscrewUpRight4, unbanked }, { 48, -13, 59, 16, corkscrewUpRight4, unbanked },
    { 48, -14, 59, 16, corkscrewUpRight4, unbanked }, { 48, -15, 60, 16, corkscrewUpRight4, unbanked }, { 48, -16, 60, 16, corkscrewUpRight4, unbanked },
    { 48, -17, 61, 16, corkscrewUpRight4, unbanked }, { 48, -18, 61, 16, corkscrewUpRight4, unbanked }, { 48, -19, 62, 16, corkscrewUpRight4, unbanked },
    { 48, -20, 62, 16, corkscrewUpRight4, unbanked }, { 48, -21, 62, 16, corkscrewUpRight4, unbanked }, { 48, -22, 63, 16, corkscrewUpRight4, unbanked },
    { 48, -23, 63, 16, corkscrewUpRight4, unbanked }, { 48, -24, 63, 16, corkscrewUpRight4, unbanked }, { 48, -25, 63, 16, corkscrewUpRight4, unbanked },
    { 48, -26, 63,  8,          inverted, unbanked }, { 48, -27, 64,  8,          inverted, unbanked }, { 48, -28, 64,  8,          inverted, unbanked },
    { 48, -29, 64,  8,          inverted, unbanked }, { 48, -30, 64,  8,          inverted, unbanked }, { 48, -31, 64,  8,          inverted, unbanked },
    { 48, -32, 64,  8,          inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EC03F, {
    {  16,  31,  0, 24,              flat, unbanked }, {  16,  30,  0, 24,              flat, unbanked }, {  16,  29,  0, 24,              flat, unbanked },
    {  16,  28,  0, 24,              flat, unbanked }, {  16,  27,  0, 24,              flat, unbanked }, {  16,  26,  0, 24,              flat, unbanked },
    {  16,  25,  1, 24,              flat, unbanked }, {  16,  24,  1, 24,              flat, unbanked }, {  16,  23,  1, 24, corkscrewUpRight0, unbanked },
    {  16,  22,  1, 24, corkscrewUpRight0, unbanked }, {  16,  21,  1, 24, corkscrewUpRight0, unbanked }, {  16,  20,  2, 24, corkscrewUpRight0, unbanked },
    {  16,  19,  2, 24, corkscrewUpRight0, unbanked }, {  16,  18,  2, 24, corkscrewUpRight0, unbanked }, {  16,  17,  3, 24, corkscrewUpRight0, unbanked },
    {  16,  16,  3, 24, corkscrewUpRight0, unbanked }, {  16,  15,  4, 24, corkscrewUpRight0, unbanked }, {  16,  14,  4, 24, corkscrewUpRight0, unbanked },
    {  16,  13,  5, 24, corkscrewUpRight0, unbanked }, {  16,  12,  5, 24, corkscrewUpRight0, unbanked }, {  16,  11,  6, 24, corkscrewUpRight0, unbanked },
    {  16,  10,  6, 24, corkscrewUpRight0, unbanked }, {  16,   9,  7, 24, corkscrewUpRight0, unbanked }, {  16,   8,  8, 24, corkscrewUpRight0, unbanked },
    {  16,   7,  9, 24, corkscrewUpRight1, unbanked }, {  16,   6,  9, 24, corkscrewUpRight1, unbanked }, {  15,   5, 10, 24, corkscrewUpRight1, unbanked },
    {  15,   4, 11, 24, corkscrewUpRight1, unbanked }, {  15,   3, 12, 24, corkscrewUpRight1, unbanked }, {  15,   2, 13, 24, corkscrewUpRight1, unbanked },
    {  15,   1, 14, 24, corkscrewUpRight1, unbanked }, {  15,   0, 15, 24, corkscrewUpRight1, unbanked }, {  14,  -1, 16, 24, corkscrewUpRight1, unbanked },
    {  14,  -2, 17, 24, corkscrewUpRight1, unbanked }, {  14,  -2, 18, 24, corkscrewUpRight1, unbanked }, {  14,  -3, 19, 24, corkscrewUpRight1, unbanked },
    {  14,  -4, 20, 24, corkscrewUpRight1, unbanked }, {  13,  -5, 21, 24, corkscrewUpRight1, unbanked }, {  13,  -5, 22, 24, corkscrewUpRight1, unbanked },
    {  13,  -6, 23, 24, corkscrewUpRight1, unbanked }, {  12,  -6, 24, 24, corkscrewUpRight2, unbanked }, {  12,  -7, 25, 24, corkscrewUpRight2, unbanked },
    {  12,  -8, 26, 24, corkscrewUpRight2, unbanked }, {  12,  -8, 27, 24, corkscrewUpRight2, unbanked }, {  11,  -9, 28, 24, corkscrewUpRight2, unbanked },
    {  11,  -9, 29, 24, corkscrewUpRight2, unbanked }, {  10, -10, 30, 24, corkscrewUpRight2, unbanked }, {  10, -10, 31, 24, corkscrewUpRight2, unbanked },
    {  10, -11, 32, 24, corkscrewUpRight2, unbanked }, {   9, -11, 33, 24, corkscrewUpRight2, unbanked }, {   9, -11, 34, 24, corkscrewUpRight2, unbanked },
    {   8, -12, 35, 24, corkscrewUpRight2, unbanked }, {   8, -12, 36, 24, corkscrewUpRight2, unbanked }, {   7, -13, 37, 24, corkscrewUpRight2, unbanked },
    {   7, -13, 38, 24, corkscrewUpRight2, unbanked }, {   6, -13, 39, 24, corkscrewUpRight2, unbanked }, {   5, -13, 40, 24, corkscrewUpRight2, unbanked },
    {   5, -14, 41, 24, corkscrewUpRight3, unbanked }, {   4, -14, 42, 24, corkscrewUpRight3, unbanked }, {   4, -14, 43, 24, corkscrewUpRight3, unbanked },
    {   3, -15, 44, 24, corkscrewUpRight3, unbanked }, {   2, -15, 45, 24, corkscrewUpRight3, unbanked }, {   1, -15, 46, 24, corkscrewUpRight3, unbanked },
    {   1, -15, 47, 24, corkscrewUpRight3, unbanked }, {   0, -15, 48, 24, corkscrewUpRight3, unbanked }, {  -1, -16, 49, 24, corkscrewUpRight3, unbanked },
    {  -2, -16, 50, 24, corkscrewUpRight3, unbanked }, {  -3, -16, 51, 24, corkscrewUpRight3, unbanked }, {  -4, -16, 52, 24, corkscrewUpRight3, unbanked },
    {  -5, -16, 53, 24, corkscrewUpRight3, unbanked }, {  -6, -16, 54, 24, corkscrewUpRight3, unbanked }, {  -7, -17, 55, 24, corkscrewUpRight3, unbanked },
    {  -8, -17, 55, 24, corkscrewUpRight3, unbanked }, {  -9, -17, 56, 24, corkscrewUpRight4, unbanked }, { -10, -17, 57, 24, corkscrewUpRight4, unbanked },
    { -11, -17, 58, 24, corkscrewUpRight4, unbanked }, { -12, -17, 58, 24, corkscrewUpRight4, unbanked }, { -13, -17, 59, 24, corkscrewUpRight4, unbanked },
    { -14, -17, 59, 24, corkscrewUpRight4, unbanked }, { -15, -17, 60, 24, corkscrewUpRight4, unbanked }, { -16, -17, 60, 24, corkscrewUpRight4, unbanked },
    { -17, -17, 61, 24, corkscrewUpRight4, unbanked }, { -18, -17, 61, 24, corkscrewUpRight4, unbanked }, { -19, -17, 62, 24, corkscrewUpRight4, unbanked },
    { -20, -17, 62, 24, corkscrewUpRight4, unbanked }, { -21, -17, 62, 24, corkscrewUpRight4, unbanked }, { -22, -17, 63, 24, corkscrewUpRight4, unbanked },
    { -23, -17, 63, 24, corkscrewUpRight4, unbanked }, { -24, -17, 63, 24, corkscrewUpRight4, unbanked }, { -25, -17, 63, 24, corkscrewUpRight4, unbanked },
    { -26, -17, 63, 16,          inverted, unbanked }, { -27, -17, 64, 16,          inverted, unbanked }, { -28, -17, 64, 16,          inverted, unbanked },
    { -29, -17, 64, 16,          inverted, unbanked }, { -30, -17, 64, 16,          inverted, unbanked }, { -31, -17, 64, 16,          inverted, unbanked },
    { -32, -17, 64, 16,          inverted, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EC3AA, {
    {  31,  16,  16, 16,           inverted, unbanked }, {  30,  16,  16, 16,           inverted, unbanked }, {  29,  16,  16, 16,           inverted, unbanked },
    {  28,  16,  16, 16,           inverted, unbanked }, {  27,  16,  16, 16,           inverted, unbanked }, {  26,  16,  16, 16,           inverted, unbanked },
    {  25,  16,  15, 16,           inverted, unbanked }, {  24,  16,  15, 16,           inverted, unbanked }, {  23,  16,  15, 24, corkscrewDownLeft4, unbanked },
    {  22,  16,  15, 24, corkscrewDownLeft4, unbanked }, {  21,  16,  15, 24, corkscrewDownLeft4, unbanked }, {  20,  16,  14, 24, corkscrewDownLeft4, unbanked },
    {  19,  16,  14, 24, corkscrewDownLeft4, unbanked }, {  18,  16,  14, 24, corkscrewDownLeft4, unbanked }, {  17,  16,  13, 24, corkscrewDownLeft4, unbanked },
    {  16,  16,  13, 24, corkscrewDownLeft4, unbanked }, {  15,  16,  12, 24, corkscrewDownLeft4, unbanked }, {  14,  16,  12, 24, corkscrewDownLeft4, unbanked },
    {  13,  16,  11, 24, corkscrewDownLeft4, unbanked }, {  12,  16,  11, 24, corkscrewDownLeft4, unbanked }, {  11,  16,  10, 24, corkscrewDownLeft4, unbanked },
    {  10,  16,  10, 24, corkscrewDownLeft4, unbanked }, {   9,  16,   9, 24, corkscrewDownLeft4, unbanked }, {   8,  16,   8, 24, corkscrewDownLeft4, unbanked },
    {   7,  16,   7, 24, corkscrewDownLeft3, unbanked }, {   6,  16,   7, 24, corkscrewDownLeft3, unbanked }, {   5,  15,   6, 24, corkscrewDownLeft3, unbanked },
    {   4,  15,   5, 24, corkscrewDownLeft3, unbanked }, {   3,  15,   4, 24, corkscrewDownLeft3, unbanked }, {   2,  15,   3, 24, corkscrewDownLeft3, unbanked },
    {   1,  15,   2, 24, corkscrewDownLeft3, unbanked }, {   0,  15,   1, 24, corkscrewDownLeft3, unbanked }, {  -1,  14,   0, 24, corkscrewDownLeft3, unbanked },
    {  -2,  14,  -1, 24, corkscrewDownLeft3, unbanked }, {  -2,  14,  -2, 24, corkscrewDownLeft3, unbanked }, {  -3,  14,  -3, 24, corkscrewDownLeft3, unbanked },
    {  -4,  14,  -4, 24, corkscrewDownLeft3, unbanked }, {  -5,  13,  -5, 24, corkscrewDownLeft3, unbanked }, {  -5,  13,  -6, 24, corkscrewDownLeft3, unbanked },
    {  -6,  13,  -7, 24, corkscrewDownLeft3, unbanked }, {  -6,  12,  -8, 24, corkscrewDownLeft2, unbanked }, {  -7,  12,  -9, 24, corkscrewDownLeft2, unbanked },
    {  -8,  12, -10, 24, corkscrewDownLeft2, unbanked }, {  -8,  12, -11, 24, corkscrewDownLeft2, unbanked }, {  -9,  11, -12, 24, corkscrewDownLeft2, unbanked },
    {  -9,  11, -13, 24, corkscrewDownLeft2, unbanked }, { -10,  10, -14, 24, corkscrewDownLeft2, unbanked }, { -10,  10, -15, 24, corkscrewDownLeft2, unbanked },
    { -11,  10, -16, 24, corkscrewDownLeft2, unbanked }, { -11,   9, -17, 24, corkscrewDownLeft2, unbanked }, { -11,   9, -18, 24, corkscrewDownLeft2, unbanked },
    { -12,   8, -19, 24, corkscrewDownLeft2, unbanked }, { -12,   8, -20, 24, corkscrewDownLeft2, unbanked }, { -13,   7, -21, 24, corkscrewDownLeft2, unbanked },
    { -13,   7, -22, 24, corkscrewDownLeft2, unbanked }, { -13,   6, -23, 24, corkscrewDownLeft2, unbanked }, { -13,   5, -24, 24, corkscrewDownLeft2, unbanked },
    { -14,   5, -25, 24, corkscrewDownLeft1, unbanked }, { -14,   4, -26, 24, corkscrewDownLeft1, unbanked }, { -14,   4, -27, 24, corkscrewDownLeft1, unbanked },
    { -15,   3, -28, 24, corkscrewDownLeft1, unbanked }, { -15,   2, -29, 24, corkscrewDownLeft1, unbanked }, { -15,   1, -30, 24, corkscrewDownLeft1, unbanked },
    { -15,   1, -31, 24, corkscrewDownLeft1, unbanked }, { -15,   0, -32, 24, corkscrewDownLeft1, unbanked }, { -16,  -1, -33, 24, corkscrewDownLeft1, unbanked },
    { -16,  -2, -34, 24, corkscrewDownLeft1, unbanked }, { -16,  -3, -35, 24, corkscrewDownLeft1, unbanked }, { -16,  -4, -36, 24, corkscrewDownLeft1, unbanked },
    { -16,  -5, -37, 24, corkscrewDownLeft1, unbanked }, { -16,  -6, -38, 24, corkscrewDownLeft1, unbanked }, { -17,  -7, -39, 24, corkscrewDownLeft1, unbanked },
    { -17,  -8, -39, 24, corkscrewDownLeft1, unbanked }, { -17,  -9, -40, 24, corkscrewDownLeft0, unbanked }, { -17, -10, -41, 24, corkscrewDownLeft0, unbanked },
    { -17, -11, -42, 24, corkscrewDownLeft0, unbanked }, { -17, -12, -42, 24, corkscrewDownLeft0, unbanked }, { -17, -13, -43, 24, corkscrewDownLeft0, unbanked },
    { -17, -14, -43, 24, corkscrewDownLeft0, unbanked }, { -17, -15, -44, 24, corkscrewDownLeft0, unbanked }, { -17, -16, -44, 24, corkscrewDownLeft0, unbanked },
    { -17, -17, -45, 24, corkscrewDownLeft0, unbanked }, { -17, -18, -45, 24, corkscrewDownLeft0, unbanked }, { -17, -19, -46, 24, corkscrewDownLeft0, unbanked },
    { -17, -20, -46, 24, corkscrewDownLeft0, unbanked }, { -17, -21, -46, 24, corkscrewDownLeft0, unbanked }, { -17, -22, -47, 24, corkscrewDownLeft0, unbanked },
    { -17, -23, -47, 24, corkscrewDownLeft0, unbanked }, { -17, -24, -47, 24, corkscrewDownLeft0, unbanked }, { -17, -25, -47, 24, corkscrewDownLeft0, unbanked },
    { -17, -26, -47, 24,               flat, unbanked }, { -17, -27, -48, 24,               flat, unbanked }, { -17, -28, -48, 24,               flat, unbanked },
    { -17, -29, -48, 24,               flat, unbanked }, { -17, -30, -48, 24,               flat, unbanked }, { -17, -31, -48, 24,               flat, unbanked },
    { -17, -32, -48, 24,               flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EC715, {
    {  16,  0,  16, 24,           inverted, unbanked }, {  16,  1,  16, 24,           inverted, unbanked }, {  16,  2,  16, 24,           inverted, unbanked },
    {  16,  3,  16, 24,           inverted, unbanked }, {  16,  4,  16, 24,           inverted, unbanked }, {  16,  5,  16, 24,           inverted, unbanked },
    {  16,  6,  15, 24,           inverted, unbanked }, {  16,  7,  15, 24,           inverted, unbanked }, {  16,  8,  15,  0, corkscrewDownLeft4, unbanked },
    {  16,  9,  15,  0, corkscrewDownLeft4, unbanked }, {  16, 10,  15,  0, corkscrewDownLeft4, unbanked }, {  16, 11,  14,  0, corkscrewDownLeft4, unbanked },
    {  16, 12,  14,  0, corkscrewDownLeft4, unbanked }, {  16, 13,  14,  0, corkscrewDownLeft4, unbanked }, {  16, 14,  13,  0, corkscrewDownLeft4, unbanked },
    {  16, 15,  13,  0, corkscrewDownLeft4, unbanked }, {  16, 16,  12,  0, corkscrewDownLeft4, unbanked }, {  16, 17,  12,  0, corkscrewDownLeft4, unbanked },
    {  16, 18,  11,  0, corkscrewDownLeft4, unbanked }, {  16, 19,  11,  0, corkscrewDownLeft4, unbanked }, {  16, 20,  10,  0, corkscrewDownLeft4, unbanked },
    {  16, 21,  10,  0, corkscrewDownLeft4, unbanked }, {  16, 22,   9,  0, corkscrewDownLeft4, unbanked }, {  16, 23,   8,  0, corkscrewDownLeft4, unbanked },
    {  16, 24,   7,  0, corkscrewDownLeft3, unbanked }, {  16, 25,   7,  0, corkscrewDownLeft3, unbanked }, {  15, 26,   6,  0, corkscrewDownLeft3, unbanked },
    {  15, 27,   5,  0, corkscrewDownLeft3, unbanked }, {  15, 28,   4,  0, corkscrewDownLeft3, unbanked }, {  15, 29,   3,  0, corkscrewDownLeft3, unbanked },
    {  15, 30,   2,  0, corkscrewDownLeft3, unbanked }, {  15, 31,   1,  0, corkscrewDownLeft3, unbanked }, {  14, 32,   0,  0, corkscrewDownLeft3, unbanked },
    {  14, 33,  -1,  0, corkscrewDownLeft3, unbanked }, {  14, 33,  -2,  0, corkscrewDownLeft3, unbanked }, {  14, 34,  -3,  0, corkscrewDownLeft3, unbanked },
    {  14, 35,  -4,  0, corkscrewDownLeft3, unbanked }, {  13, 36,  -5,  0, corkscrewDownLeft3, unbanked }, {  13, 36,  -6,  0, corkscrewDownLeft3, unbanked },
    {  13, 37,  -7,  0, corkscrewDownLeft3, unbanked }, {  12, 37,  -8,  0, corkscrewDownLeft2, unbanked }, {  12, 38,  -9,  0, corkscrewDownLeft2, unbanked },
    {  12, 39, -10,  0, corkscrewDownLeft2, unbanked }, {  12, 39, -11,  0, corkscrewDownLeft2, unbanked }, {  11, 40, -12,  0, corkscrewDownLeft2, unbanked },
    {  11, 40, -13,  0, corkscrewDownLeft2, unbanked }, {  10, 41, -14,  0, corkscrewDownLeft2, unbanked }, {  10, 41, -15,  0, corkscrewDownLeft2, unbanked },
    {  10, 42, -16,  0, corkscrewDownLeft2, unbanked }, {   9, 42, -17,  0, corkscrewDownLeft2, unbanked }, {   9, 42, -18,  0, corkscrewDownLeft2, unbanked },
    {   8, 43, -19,  0, corkscrewDownLeft2, unbanked }, {   8, 43, -20,  0, corkscrewDownLeft2, unbanked }, {   7, 44, -21,  0, corkscrewDownLeft2, unbanked },
    {   7, 44, -22,  0, corkscrewDownLeft2, unbanked }, {   6, 44, -23,  0, corkscrewDownLeft2, unbanked }, {   5, 44, -24,  0, corkscrewDownLeft2, unbanked },
    {   5, 45, -25,  0, corkscrewDownLeft1, unbanked }, {   4, 45, -26,  0, corkscrewDownLeft1, unbanked }, {   4, 45, -27,  0, corkscrewDownLeft1, unbanked },
    {   3, 46, -28,  0, corkscrewDownLeft1, unbanked }, {   2, 46, -29,  0, corkscrewDownLeft1, unbanked }, {   1, 46, -30,  0, corkscrewDownLeft1, unbanked },
    {   1, 46, -31,  0, corkscrewDownLeft1, unbanked }, {   0, 46, -32,  0, corkscrewDownLeft1, unbanked }, {  -1, 47, -33,  0, corkscrewDownLeft1, unbanked },
    {  -2, 47, -34,  0, corkscrewDownLeft1, unbanked }, {  -3, 47, -35,  0, corkscrewDownLeft1, unbanked }, {  -4, 47, -36,  0, corkscrewDownLeft1, unbanked },
    {  -5, 47, -37,  0, corkscrewDownLeft1, unbanked }, {  -6, 47, -38,  0, corkscrewDownLeft1, unbanked }, {  -7, 48, -39,  0, corkscrewDownLeft1, unbanked },
    {  -8, 48, -39,  0, corkscrewDownLeft1, unbanked }, {  -9, 48, -40,  0, corkscrewDownLeft0, unbanked }, { -10, 48, -41,  0, corkscrewDownLeft0, unbanked },
    { -11, 48, -42,  0, corkscrewDownLeft0, unbanked }, { -12, 48, -42,  0, corkscrewDownLeft0, unbanked }, { -13, 48, -43,  0, corkscrewDownLeft0, unbanked },
    { -14, 48, -43,  0, corkscrewDownLeft0, unbanked }, { -15, 48, -44,  0, corkscrewDownLeft0, unbanked }, { -16, 48, -44,  0, corkscrewDownLeft0, unbanked },
    { -17, 48, -45,  0, corkscrewDownLeft0, unbanked }, { -18, 48, -45,  0, corkscrewDownLeft0, unbanked }, { -19, 48, -46,  0, corkscrewDownLeft0, unbanked },
    { -20, 48, -46,  0, corkscrewDownLeft0, unbanked }, { -21, 48, -46,  0, corkscrewDownLeft0, unbanked }, { -22, 48, -47,  0, corkscrewDownLeft0, unbanked },
    { -23, 48, -47,  0, corkscrewDownLeft0, unbanked }, { -24, 48, -47,  0, corkscrewDownLeft0, unbanked }, { -25, 48, -47,  0, corkscrewDownLeft0, unbanked },
    { -26, 48, -47,  0,               flat, unbanked }, { -27, 48, -48,  0,               flat, unbanked }, { -28, 48, -48,  0,               flat, unbanked },
    { -29, 48, -48,  0,               flat, unbanked }, { -30, 48, -48,  0,               flat, unbanked }, { -31, 48, -48,  0,               flat, unbanked },
    { -32, 48, -48,  0,               flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ECA80, {
    {  0, 16,  16, 0,           inverted, unbanked }, {  1, 16,  16, 0,           inverted, unbanked }, {  2, 16,  16, 0,           inverted, unbanked },
    {  3, 16,  16, 0,           inverted, unbanked }, {  4, 16,  16, 0,           inverted, unbanked }, {  5, 16,  16, 0,           inverted, unbanked },
    {  6, 16,  15, 0,           inverted, unbanked }, {  7, 16,  15, 0,           inverted, unbanked }, {  8, 16,  15, 8, corkscrewDownLeft4, unbanked },
    {  9, 16,  15, 8, corkscrewDownLeft4, unbanked }, { 10, 16,  15, 8, corkscrewDownLeft4, unbanked }, { 11, 16,  14, 8, corkscrewDownLeft4, unbanked },
    { 12, 16,  14, 8, corkscrewDownLeft4, unbanked }, { 13, 16,  14, 8, corkscrewDownLeft4, unbanked }, { 14, 16,  13, 8, corkscrewDownLeft4, unbanked },
    { 15, 16,  13, 8, corkscrewDownLeft4, unbanked }, { 16, 16,  12, 8, corkscrewDownLeft4, unbanked }, { 17, 16,  12, 8, corkscrewDownLeft4, unbanked },
    { 18, 16,  11, 8, corkscrewDownLeft4, unbanked }, { 19, 16,  11, 8, corkscrewDownLeft4, unbanked }, { 20, 16,  10, 8, corkscrewDownLeft4, unbanked },
    { 21, 16,  10, 8, corkscrewDownLeft4, unbanked }, { 22, 16,   9, 8, corkscrewDownLeft4, unbanked }, { 23, 16,   8, 8, corkscrewDownLeft4, unbanked },
    { 24, 16,   7, 8, corkscrewDownLeft3, unbanked }, { 25, 16,   7, 8, corkscrewDownLeft3, unbanked }, { 26, 17,   6, 8, corkscrewDownLeft3, unbanked },
    { 27, 17,   5, 8, corkscrewDownLeft3, unbanked }, { 28, 17,   4, 8, corkscrewDownLeft3, unbanked }, { 29, 17,   3, 8, corkscrewDownLeft3, unbanked },
    { 30, 17,   2, 8, corkscrewDownLeft3, unbanked }, { 31, 17,   1, 8, corkscrewDownLeft3, unbanked }, { 32, 18,   0, 8, corkscrewDownLeft3, unbanked },
    { 33, 18,  -1, 8, corkscrewDownLeft3, unbanked }, { 33, 18,  -2, 8, corkscrewDownLeft3, unbanked }, { 34, 18,  -3, 8, corkscrewDownLeft3, unbanked },
    { 35, 18,  -4, 8, corkscrewDownLeft3, unbanked }, { 36, 19,  -5, 8, corkscrewDownLeft3, unbanked }, { 36, 19,  -6, 8, corkscrewDownLeft3, unbanked },
    { 37, 19,  -7, 8, corkscrewDownLeft3, unbanked }, { 37, 20,  -8, 8, corkscrewDownLeft2, unbanked }, { 38, 20,  -9, 8, corkscrewDownLeft2, unbanked },
    { 39, 20, -10, 8, corkscrewDownLeft2, unbanked }, { 39, 20, -11, 8, corkscrewDownLeft2, unbanked }, { 40, 21, -12, 8, corkscrewDownLeft2, unbanked },
    { 40, 21, -13, 8, corkscrewDownLeft2, unbanked }, { 41, 22, -14, 8, corkscrewDownLeft2, unbanked }, { 41, 22, -15, 8, corkscrewDownLeft2, unbanked },
    { 42, 22, -16, 8, corkscrewDownLeft2, unbanked }, { 42, 23, -17, 8, corkscrewDownLeft2, unbanked }, { 42, 23, -18, 8, corkscrewDownLeft2, unbanked },
    { 43, 24, -19, 8, corkscrewDownLeft2, unbanked }, { 43, 24, -20, 8, corkscrewDownLeft2, unbanked }, { 44, 25, -21, 8, corkscrewDownLeft2, unbanked },
    { 44, 25, -22, 8, corkscrewDownLeft2, unbanked }, { 44, 26, -23, 8, corkscrewDownLeft2, unbanked }, { 44, 27, -24, 8, corkscrewDownLeft2, unbanked },
    { 45, 27, -25, 8, corkscrewDownLeft1, unbanked }, { 45, 28, -26, 8, corkscrewDownLeft1, unbanked }, { 45, 28, -27, 8, corkscrewDownLeft1, unbanked },
    { 46, 29, -28, 8, corkscrewDownLeft1, unbanked }, { 46, 30, -29, 8, corkscrewDownLeft1, unbanked }, { 46, 31, -30, 8, corkscrewDownLeft1, unbanked },
    { 46, 31, -31, 8, corkscrewDownLeft1, unbanked }, { 46, 32, -32, 8, corkscrewDownLeft1, unbanked }, { 47, 33, -33, 8, corkscrewDownLeft1, unbanked },
    { 47, 34, -34, 8, corkscrewDownLeft1, unbanked }, { 47, 35, -35, 8, corkscrewDownLeft1, unbanked }, { 47, 36, -36, 8, corkscrewDownLeft1, unbanked },
    { 47, 37, -37, 8, corkscrewDownLeft1, unbanked }, { 47, 38, -38, 8, corkscrewDownLeft1, unbanked }, { 48, 39, -39, 8, corkscrewDownLeft1, unbanked },
    { 48, 40, -39, 8, corkscrewDownLeft1, unbanked }, { 48, 41, -40, 8, corkscrewDownLeft0, unbanked }, { 48, 42, -41, 8, corkscrewDownLeft0, unbanked },
    { 48, 43, -42, 8, corkscrewDownLeft0, unbanked }, { 48, 44, -42, 8, corkscrewDownLeft0, unbanked }, { 48, 45, -43, 8, corkscrewDownLeft0, unbanked },
    { 48, 46, -43, 8, corkscrewDownLeft0, unbanked }, { 48, 47, -44, 8, corkscrewDownLeft0, unbanked }, { 48, 48, -44, 8, corkscrewDownLeft0, unbanked },
    { 48, 49, -45, 8, corkscrewDownLeft0, unbanked }, { 48, 50, -45, 8, corkscrewDownLeft0, unbanked }, { 48, 51, -46, 8, corkscrewDownLeft0, unbanked },
    { 48, 52, -46, 8, corkscrewDownLeft0, unbanked }, { 48, 53, -46, 8, corkscrewDownLeft0, unbanked }, { 48, 54, -47, 8, corkscrewDownLeft0, unbanked },
    { 48, 55, -47, 8, corkscrewDownLeft0, unbanked }, { 48, 56, -47, 8, corkscrewDownLeft0, unbanked }, { 48, 57, -47, 8, corkscrewDownLeft0, unbanked },
    { 48, 58, -47, 8,               flat, unbanked }, { 48, 59, -48, 8,               flat, unbanked }, { 48, 60, -48, 8,               flat, unbanked },
    { 48, 61, -48, 8,               flat, unbanked }, { 48, 62, -48, 8,               flat, unbanked }, { 48, 63, -48, 8,               flat, unbanked },
    { 48, 64, -48, 8,               flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ECDEB, {
    { 16,  31,  16,  8,           inverted, unbanked }, { 16,  30,  16,  8,           inverted, unbanked }, { 16,  29,  16,  8,           inverted, unbanked },
    { 16,  28,  16,  8,           inverted, unbanked }, { 16,  27,  16,  8,           inverted, unbanked }, { 16,  26,  16,  8,           inverted, unbanked },
    { 16,  25,  15,  8,           inverted, unbanked }, { 16,  24,  15,  8,           inverted, unbanked }, { 16,  23,  15, 16, corkscrewDownLeft4, unbanked },
    { 16,  22,  15, 16, corkscrewDownLeft4, unbanked }, { 16,  21,  15, 16, corkscrewDownLeft4, unbanked }, { 16,  20,  14, 16, corkscrewDownLeft4, unbanked },
    { 16,  19,  14, 16, corkscrewDownLeft4, unbanked }, { 16,  18,  14, 16, corkscrewDownLeft4, unbanked }, { 16,  17,  13, 16, corkscrewDownLeft4, unbanked },
    { 16,  16,  13, 16, corkscrewDownLeft4, unbanked }, { 16,  15,  12, 16, corkscrewDownLeft4, unbanked }, { 16,  14,  12, 16, corkscrewDownLeft4, unbanked },
    { 16,  13,  11, 16, corkscrewDownLeft4, unbanked }, { 16,  12,  11, 16, corkscrewDownLeft4, unbanked }, { 16,  11,  10, 16, corkscrewDownLeft4, unbanked },
    { 16,  10,  10, 16, corkscrewDownLeft4, unbanked }, { 16,   9,   9, 16, corkscrewDownLeft4, unbanked }, { 16,   8,   8, 16, corkscrewDownLeft4, unbanked },
    { 16,   7,   7, 16, corkscrewDownLeft3, unbanked }, { 16,   6,   7, 16, corkscrewDownLeft3, unbanked }, { 17,   5,   6, 16, corkscrewDownLeft3, unbanked },
    { 17,   4,   5, 16, corkscrewDownLeft3, unbanked }, { 17,   3,   4, 16, corkscrewDownLeft3, unbanked }, { 17,   2,   3, 16, corkscrewDownLeft3, unbanked },
    { 17,   1,   2, 16, corkscrewDownLeft3, unbanked }, { 17,   0,   1, 16, corkscrewDownLeft3, unbanked }, { 18,  -1,   0, 16, corkscrewDownLeft3, unbanked },
    { 18,  -2,  -1, 16, corkscrewDownLeft3, unbanked }, { 18,  -2,  -2, 16, corkscrewDownLeft3, unbanked }, { 18,  -3,  -3, 16, corkscrewDownLeft3, unbanked },
    { 18,  -4,  -4, 16, corkscrewDownLeft3, unbanked }, { 19,  -5,  -5, 16, corkscrewDownLeft3, unbanked }, { 19,  -5,  -6, 16, corkscrewDownLeft3, unbanked },
    { 19,  -6,  -7, 16, corkscrewDownLeft3, unbanked }, { 20,  -6,  -8, 16, corkscrewDownLeft2, unbanked }, { 20,  -7,  -9, 16, corkscrewDownLeft2, unbanked },
    { 20,  -8, -10, 16, corkscrewDownLeft2, unbanked }, { 20,  -8, -11, 16, corkscrewDownLeft2, unbanked }, { 21,  -9, -12, 16, corkscrewDownLeft2, unbanked },
    { 21,  -9, -13, 16, corkscrewDownLeft2, unbanked }, { 22, -10, -14, 16, corkscrewDownLeft2, unbanked }, { 22, -10, -15, 16, corkscrewDownLeft2, unbanked },
    { 22, -11, -16, 16, corkscrewDownLeft2, unbanked }, { 23, -11, -17, 16, corkscrewDownLeft2, unbanked }, { 23, -11, -18, 16, corkscrewDownLeft2, unbanked },
    { 24, -12, -19, 16, corkscrewDownLeft2, unbanked }, { 24, -12, -20, 16, corkscrewDownLeft2, unbanked }, { 25, -13, -21, 16, corkscrewDownLeft2, unbanked },
    { 25, -13, -22, 16, corkscrewDownLeft2, unbanked }, { 26, -13, -23, 16, corkscrewDownLeft2, unbanked }, { 27, -13, -24, 16, corkscrewDownLeft2, unbanked },
    { 27, -14, -25, 16, corkscrewDownLeft1, unbanked }, { 28, -14, -26, 16, corkscrewDownLeft1, unbanked }, { 28, -14, -27, 16, corkscrewDownLeft1, unbanked },
    { 29, -15, -28, 16, corkscrewDownLeft1, unbanked }, { 30, -15, -29, 16, corkscrewDownLeft1, unbanked }, { 31, -15, -30, 16, corkscrewDownLeft1, unbanked },
    { 31, -15, -31, 16, corkscrewDownLeft1, unbanked }, { 32, -15, -32, 16, corkscrewDownLeft1, unbanked }, { 33, -16, -33, 16, corkscrewDownLeft1, unbanked },
    { 34, -16, -34, 16, corkscrewDownLeft1, unbanked }, { 35, -16, -35, 16, corkscrewDownLeft1, unbanked }, { 36, -16, -36, 16, corkscrewDownLeft1, unbanked },
    { 37, -16, -37, 16, corkscrewDownLeft1, unbanked }, { 38, -16, -38, 16, corkscrewDownLeft1, unbanked }, { 39, -17, -39, 16, corkscrewDownLeft1, unbanked },
    { 40, -17, -39, 16, corkscrewDownLeft1, unbanked }, { 41, -17, -40, 16, corkscrewDownLeft0, unbanked }, { 42, -17, -41, 16, corkscrewDownLeft0, unbanked },
    { 43, -17, -42, 16, corkscrewDownLeft0, unbanked }, { 44, -17, -42, 16, corkscrewDownLeft0, unbanked }, { 45, -17, -43, 16, corkscrewDownLeft0, unbanked },
    { 46, -17, -43, 16, corkscrewDownLeft0, unbanked }, { 47, -17, -44, 16, corkscrewDownLeft0, unbanked }, { 48, -17, -44, 16, corkscrewDownLeft0, unbanked },
    { 49, -17, -45, 16, corkscrewDownLeft0, unbanked }, { 50, -17, -45, 16, corkscrewDownLeft0, unbanked }, { 51, -17, -46, 16, corkscrewDownLeft0, unbanked },
    { 52, -17, -46, 16, corkscrewDownLeft0, unbanked }, { 53, -17, -46, 16, corkscrewDownLeft0, unbanked }, { 54, -17, -47, 16, corkscrewDownLeft0, unbanked },
    { 55, -17, -47, 16, corkscrewDownLeft0, unbanked }, { 56, -17, -47, 16, corkscrewDownLeft0, unbanked }, { 57, -17, -47, 16, corkscrewDownLeft0, unbanked },
    { 58, -17, -47, 16,               flat, unbanked }, { 59, -17, -48, 16,               flat, unbanked }, { 60, -17, -48, 16,               flat, unbanked },
    { 61, -17, -48, 16,               flat, unbanked }, { 62, -17, -48, 16,               flat, unbanked }, { 63, -17, -48, 16,               flat, unbanked },
    { 64, -17, -48, 16,               flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ED156, {
    {  31, 16,  16, 16,            inverted, unbanked }, {  30, 16,  16, 16,            inverted, unbanked }, {  29, 16,  16, 16,            inverted, unbanked },
    {  28, 16,  16, 16,            inverted, unbanked }, {  27, 16,  16, 16,            inverted, unbanked }, {  26, 16,  16, 16,            inverted, unbanked },
    {  25, 16,  15, 16,            inverted, unbanked }, {  24, 16,  15, 16,            inverted, unbanked }, {  23, 16,  15,  8, corkscrewDownRight4, unbanked },
    {  22, 16,  15,  8, corkscrewDownRight4, unbanked }, {  21, 16,  15,  8, corkscrewDownRight4, unbanked }, {  20, 16,  14,  8, corkscrewDownRight4, unbanked },
    {  19, 16,  14,  8, corkscrewDownRight4, unbanked }, {  18, 16,  14,  8, corkscrewDownRight4, unbanked }, {  17, 16,  13,  8, corkscrewDownRight4, unbanked },
    {  16, 16,  13,  8, corkscrewDownRight4, unbanked }, {  15, 16,  12,  8, corkscrewDownRight4, unbanked }, {  14, 16,  12,  8, corkscrewDownRight4, unbanked },
    {  13, 16,  11,  8, corkscrewDownRight4, unbanked }, {  12, 16,  11,  8, corkscrewDownRight4, unbanked }, {  11, 16,  10,  8, corkscrewDownRight4, unbanked },
    {  10, 16,  10,  8, corkscrewDownRight4, unbanked }, {   9, 16,   9,  8, corkscrewDownRight4, unbanked }, {   8, 16,   8,  8, corkscrewDownRight4, unbanked },
    {   7, 16,   7,  8, corkscrewDownRight3, unbanked }, {   6, 16,   7,  8, corkscrewDownRight3, unbanked }, {   5, 17,   6,  8, corkscrewDownRight3, unbanked },
    {   4, 17,   5,  8, corkscrewDownRight3, unbanked }, {   3, 17,   4,  8, corkscrewDownRight3, unbanked }, {   2, 17,   3,  8, corkscrewDownRight3, unbanked },
    {   1, 17,   2,  8, corkscrewDownRight3, unbanked }, {   0, 17,   1,  8, corkscrewDownRight3, unbanked }, {  -1, 18,   0,  8, corkscrewDownRight3, unbanked },
    {  -2, 18,  -1,  8, corkscrewDownRight3, unbanked }, {  -2, 18,  -2,  8, corkscrewDownRight3, unbanked }, {  -3, 18,  -3,  8, corkscrewDownRight3, unbanked },
    {  -4, 18,  -4,  8, corkscrewDownRight3, unbanked }, {  -5, 19,  -5,  8, corkscrewDownRight3, unbanked }, {  -5, 19,  -6,  8, corkscrewDownRight3, unbanked },
    {  -6, 19,  -7,  8, corkscrewDownRight3, unbanked }, {  -6, 20,  -8,  8, corkscrewDownRight2, unbanked }, {  -7, 20,  -9,  8, corkscrewDownRight2, unbanked },
    {  -8, 20, -10,  8, corkscrewDownRight2, unbanked }, {  -8, 20, -11,  8, corkscrewDownRight2, unbanked }, {  -9, 21, -12,  8, corkscrewDownRight2, unbanked },
    {  -9, 21, -13,  8, corkscrewDownRight2, unbanked }, { -10, 22, -14,  8, corkscrewDownRight2, unbanked }, { -10, 22, -15,  8, corkscrewDownRight2, unbanked },
    { -11, 22, -16,  8, corkscrewDownRight2, unbanked }, { -11, 23, -17,  8, corkscrewDownRight2, unbanked }, { -11, 23, -18,  8, corkscrewDownRight2, unbanked },
    { -12, 24, -19,  8, corkscrewDownRight2, unbanked }, { -12, 24, -20,  8, corkscrewDownRight2, unbanked }, { -13, 25, -21,  8, corkscrewDownRight2, unbanked },
    { -13, 25, -22,  8, corkscrewDownRight2, unbanked }, { -13, 26, -23,  8, corkscrewDownRight2, unbanked }, { -13, 27, -24,  8, corkscrewDownRight2, unbanked },
    { -14, 27, -25,  8, corkscrewDownRight1, unbanked }, { -14, 28, -26,  8, corkscrewDownRight1, unbanked }, { -14, 28, -27,  8, corkscrewDownRight1, unbanked },
    { -15, 29, -28,  8, corkscrewDownRight1, unbanked }, { -15, 30, -29,  8, corkscrewDownRight1, unbanked }, { -15, 31, -30,  8, corkscrewDownRight1, unbanked },
    { -15, 31, -31,  8, corkscrewDownRight1, unbanked }, { -15, 32, -32,  8, corkscrewDownRight1, unbanked }, { -16, 33, -33,  8, corkscrewDownRight1, unbanked },
    { -16, 34, -34,  8, corkscrewDownRight1, unbanked }, { -16, 35, -35,  8, corkscrewDownRight1, unbanked }, { -16, 36, -36,  8, corkscrewDownRight1, unbanked },
    { -16, 37, -37,  8, corkscrewDownRight1, unbanked }, { -16, 38, -38,  8, corkscrewDownRight1, unbanked }, { -17, 39, -39,  8, corkscrewDownRight1, unbanked },
    { -17, 40, -39,  8, corkscrewDownRight1, unbanked }, { -17, 41, -40,  8, corkscrewDownRight0, unbanked }, { -17, 42, -41,  8, corkscrewDownRight0, unbanked },
    { -17, 43, -42,  8, corkscrewDownRight0, unbanked }, { -17, 44, -42,  8, corkscrewDownRight0, unbanked }, { -17, 45, -43,  8, corkscrewDownRight0, unbanked },
    { -17, 46, -43,  8, corkscrewDownRight0, unbanked }, { -17, 47, -44,  8, corkscrewDownRight0, unbanked }, { -17, 48, -44,  8, corkscrewDownRight0, unbanked },
    { -17, 49, -45,  8, corkscrewDownRight0, unbanked }, { -17, 50, -45,  8, corkscrewDownRight0, unbanked }, { -17, 51, -46,  8, corkscrewDownRight0, unbanked },
    { -17, 52, -46,  8, corkscrewDownRight0, unbanked }, { -17, 53, -46,  8, corkscrewDownRight0, unbanked }, { -17, 54, -47,  8, corkscrewDownRight0, unbanked },
    { -17, 55, -47,  8, corkscrewDownRight0, unbanked }, { -17, 56, -47,  8, corkscrewDownRight0, unbanked }, { -17, 57, -47,  8, corkscrewDownRight0, unbanked },
    { -17, 58, -47,  8,                flat, unbanked }, { -17, 59, -48,  8,                flat, unbanked }, { -17, 60, -48,  8,                flat, unbanked },
    { -17, 61, -48,  8,                flat, unbanked }, { -17, 62, -48,  8,                flat, unbanked }, { -17, 63, -48,  8,                flat, unbanked },
    { -17, 64, -48,  8,                flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ED4C1, {
    { 16,  0,  16, 24,            inverted, unbanked }, { 16,  1,  16, 24,            inverted, unbanked }, { 16,  2,  16, 24,            inverted, unbanked },
    { 16,  3,  16, 24,            inverted, unbanked }, { 16,  4,  16, 24,            inverted, unbanked }, { 16,  5,  16, 24,            inverted, unbanked },
    { 16,  6,  15, 24,            inverted, unbanked }, { 16,  7,  15, 24,            inverted, unbanked }, { 16,  8,  15, 16, corkscrewDownRight4, unbanked },
    { 16,  9,  15, 16, corkscrewDownRight4, unbanked }, { 16, 10,  15, 16, corkscrewDownRight4, unbanked }, { 16, 11,  14, 16, corkscrewDownRight4, unbanked },
    { 16, 12,  14, 16, corkscrewDownRight4, unbanked }, { 16, 13,  14, 16, corkscrewDownRight4, unbanked }, { 16, 14,  13, 16, corkscrewDownRight4, unbanked },
    { 16, 15,  13, 16, corkscrewDownRight4, unbanked }, { 16, 16,  12, 16, corkscrewDownRight4, unbanked }, { 16, 17,  12, 16, corkscrewDownRight4, unbanked },
    { 16, 18,  11, 16, corkscrewDownRight4, unbanked }, { 16, 19,  11, 16, corkscrewDownRight4, unbanked }, { 16, 20,  10, 16, corkscrewDownRight4, unbanked },
    { 16, 21,  10, 16, corkscrewDownRight4, unbanked }, { 16, 22,   9, 16, corkscrewDownRight4, unbanked }, { 16, 23,   8, 16, corkscrewDownRight4, unbanked },
    { 16, 24,   7, 16, corkscrewDownRight3, unbanked }, { 16, 25,   7, 16, corkscrewDownRight3, unbanked }, { 17, 26,   6, 16, corkscrewDownRight3, unbanked },
    { 17, 27,   5, 16, corkscrewDownRight3, unbanked }, { 17, 28,   4, 16, corkscrewDownRight3, unbanked }, { 17, 29,   3, 16, corkscrewDownRight3, unbanked },
    { 17, 30,   2, 16, corkscrewDownRight3, unbanked }, { 17, 31,   1, 16, corkscrewDownRight3, unbanked }, { 18, 32,   0, 16, corkscrewDownRight3, unbanked },
    { 18, 33,  -1, 16, corkscrewDownRight3, unbanked }, { 18, 33,  -2, 16, corkscrewDownRight3, unbanked }, { 18, 34,  -3, 16, corkscrewDownRight3, unbanked },
    { 18, 35,  -4, 16, corkscrewDownRight3, unbanked }, { 19, 36,  -5, 16, corkscrewDownRight3, unbanked }, { 19, 36,  -6, 16, corkscrewDownRight3, unbanked },
    { 19, 37,  -7, 16, corkscrewDownRight3, unbanked }, { 20, 37,  -8, 16, corkscrewDownRight2, unbanked }, { 20, 38,  -9, 16, corkscrewDownRight2, unbanked },
    { 20, 39, -10, 16, corkscrewDownRight2, unbanked }, { 20, 39, -11, 16, corkscrewDownRight2, unbanked }, { 21, 40, -12, 16, corkscrewDownRight2, unbanked },
    { 21, 40, -13, 16, corkscrewDownRight2, unbanked }, { 22, 41, -14, 16, corkscrewDownRight2, unbanked }, { 22, 41, -15, 16, corkscrewDownRight2, unbanked },
    { 22, 42, -16, 16, corkscrewDownRight2, unbanked }, { 23, 42, -17, 16, corkscrewDownRight2, unbanked }, { 23, 42, -18, 16, corkscrewDownRight2, unbanked },
    { 24, 43, -19, 16, corkscrewDownRight2, unbanked }, { 24, 43, -20, 16, corkscrewDownRight2, unbanked }, { 25, 44, -21, 16, corkscrewDownRight2, unbanked },
    { 25, 44, -22, 16, corkscrewDownRight2, unbanked }, { 26, 44, -23, 16, corkscrewDownRight2, unbanked }, { 27, 44, -24, 16, corkscrewDownRight2, unbanked },
    { 27, 45, -25, 16, corkscrewDownRight1, unbanked }, { 28, 45, -26, 16, corkscrewDownRight1, unbanked }, { 28, 45, -27, 16, corkscrewDownRight1, unbanked },
    { 29, 46, -28, 16, corkscrewDownRight1, unbanked }, { 30, 46, -29, 16, corkscrewDownRight1, unbanked }, { 31, 46, -30, 16, corkscrewDownRight1, unbanked },
    { 31, 46, -31, 16, corkscrewDownRight1, unbanked }, { 32, 46, -32, 16, corkscrewDownRight1, unbanked }, { 33, 47, -33, 16, corkscrewDownRight1, unbanked },
    { 34, 47, -34, 16, corkscrewDownRight1, unbanked }, { 35, 47, -35, 16, corkscrewDownRight1, unbanked }, { 36, 47, -36, 16, corkscrewDownRight1, unbanked },
    { 37, 47, -37, 16, corkscrewDownRight1, unbanked }, { 38, 47, -38, 16, corkscrewDownRight1, unbanked }, { 39, 48, -39, 16, corkscrewDownRight1, unbanked },
    { 40, 48, -39, 16, corkscrewDownRight1, unbanked }, { 41, 48, -40, 16, corkscrewDownRight0, unbanked }, { 42, 48, -41, 16, corkscrewDownRight0, unbanked },
    { 43, 48, -42, 16, corkscrewDownRight0, unbanked }, { 44, 48, -42, 16, corkscrewDownRight0, unbanked }, { 45, 48, -43, 16, corkscrewDownRight0, unbanked },
    { 46, 48, -43, 16, corkscrewDownRight0, unbanked }, { 47, 48, -44, 16, corkscrewDownRight0, unbanked }, { 48, 48, -44, 16, corkscrewDownRight0, unbanked },
    { 49, 48, -45, 16, corkscrewDownRight0, unbanked }, { 50, 48, -45, 16, corkscrewDownRight0, unbanked }, { 51, 48, -46, 16, corkscrewDownRight0, unbanked },
    { 52, 48, -46, 16, corkscrewDownRight0, unbanked }, { 53, 48, -46, 16, corkscrewDownRight0, unbanked }, { 54, 48, -47, 16, corkscrewDownRight0, unbanked },
    { 55, 48, -47, 16, corkscrewDownRight0, unbanked }, { 56, 48, -47, 16, corkscrewDownRight0, unbanked }, { 57, 48, -47, 16, corkscrewDownRight0, unbanked },
    { 58, 48, -47, 16,                flat, unbanked }, { 59, 48, -48, 16,                flat, unbanked }, { 60, 48, -48, 16,                flat, unbanked },
    { 61, 48, -48, 16,                flat, unbanked }, { 62, 48, -48, 16,                flat, unbanked }, { 63, 48, -48, 16,                flat, unbanked },
    { 64, 48, -48, 16,                flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ED82C, {
    {  0,  16,  16,  0,            inverted, unbanked }, {  1,  16,  16,  0,            inverted, unbanked }, {  2,  16,  16,  0,            inverted, unbanked },
    {  3,  16,  16,  0,            inverted, unbanked }, {  4,  16,  16,  0,            inverted, unbanked }, {  5,  16,  16,  0,            inverted, unbanked },
    {  6,  16,  15,  0,            inverted, unbanked }, {  7,  16,  15,  0,            inverted, unbanked }, {  8,  16,  15, 24, corkscrewDownRight4, unbanked },
    {  9,  16,  15, 24, corkscrewDownRight4, unbanked }, { 10,  16,  15, 24, corkscrewDownRight4, unbanked }, { 11,  16,  14, 24, corkscrewDownRight4, unbanked },
    { 12,  16,  14, 24, corkscrewDownRight4, unbanked }, { 13,  16,  14, 24, corkscrewDownRight4, unbanked }, { 14,  16,  13, 24, corkscrewDownRight4, unbanked },
    { 15,  16,  13, 24, corkscrewDownRight4, unbanked }, { 16,  16,  12, 24, corkscrewDownRight4, unbanked }, { 17,  16,  12, 24, corkscrewDownRight4, unbanked },
    { 18,  16,  11, 24, corkscrewDownRight4, unbanked }, { 19,  16,  11, 24, corkscrewDownRight4, unbanked }, { 20,  16,  10, 24, corkscrewDownRight4, unbanked },
    { 21,  16,  10, 24, corkscrewDownRight4, unbanked }, { 22,  16,   9, 24, corkscrewDownRight4, unbanked }, { 23,  16,   8, 24, corkscrewDownRight4, unbanked },
    { 24,  16,   7, 24, corkscrewDownRight3, unbanked }, { 25,  16,   7, 24, corkscrewDownRight3, unbanked }, { 26,  15,   6, 24, corkscrewDownRight3, unbanked },
    { 27,  15,   5, 24, corkscrewDownRight3, unbanked }, { 28,  15,   4, 24, corkscrewDownRight3, unbanked }, { 29,  15,   3, 24, corkscrewDownRight3, unbanked },
    { 30,  15,   2, 24, corkscrewDownRight3, unbanked }, { 31,  15,   1, 24, corkscrewDownRight3, unbanked }, { 32,  14,   0, 24, corkscrewDownRight3, unbanked },
    { 33,  14,  -1, 24, corkscrewDownRight3, unbanked }, { 33,  14,  -2, 24, corkscrewDownRight3, unbanked }, { 34,  14,  -3, 24, corkscrewDownRight3, unbanked },
    { 35,  14,  -4, 24, corkscrewDownRight3, unbanked }, { 36,  13,  -5, 24, corkscrewDownRight3, unbanked }, { 36,  13,  -6, 24, corkscrewDownRight3, unbanked },
    { 37,  13,  -7, 24, corkscrewDownRight3, unbanked }, { 37,  12,  -8, 24, corkscrewDownRight2, unbanked }, { 38,  12,  -9, 24, corkscrewDownRight2, unbanked },
    { 39,  12, -10, 24, corkscrewDownRight2, unbanked }, { 39,  12, -11, 24, corkscrewDownRight2, unbanked }, { 40,  11, -12, 24, corkscrewDownRight2, unbanked },
    { 40,  11, -13, 24, corkscrewDownRight2, unbanked }, { 41,  10, -14, 24, corkscrewDownRight2, unbanked }, { 41,  10, -15, 24, corkscrewDownRight2, unbanked },
    { 42,  10, -16, 24, corkscrewDownRight2, unbanked }, { 42,   9, -17, 24, corkscrewDownRight2, unbanked }, { 42,   9, -18, 24, corkscrewDownRight2, unbanked },
    { 43,   8, -19, 24, corkscrewDownRight2, unbanked }, { 43,   8, -20, 24, corkscrewDownRight2, unbanked }, { 44,   7, -21, 24, corkscrewDownRight2, unbanked },
    { 44,   7, -22, 24, corkscrewDownRight2, unbanked }, { 44,   6, -23, 24, corkscrewDownRight2, unbanked }, { 44,   5, -24, 24, corkscrewDownRight2, unbanked },
    { 45,   5, -25, 24, corkscrewDownRight1, unbanked }, { 45,   4, -26, 24, corkscrewDownRight1, unbanked }, { 45,   4, -27, 24, corkscrewDownRight1, unbanked },
    { 46,   3, -28, 24, corkscrewDownRight1, unbanked }, { 46,   2, -29, 24, corkscrewDownRight1, unbanked }, { 46,   1, -30, 24, corkscrewDownRight1, unbanked },
    { 46,   1, -31, 24, corkscrewDownRight1, unbanked }, { 46,   0, -32, 24, corkscrewDownRight1, unbanked }, { 47,  -1, -33, 24, corkscrewDownRight1, unbanked },
    { 47,  -2, -34, 24, corkscrewDownRight1, unbanked }, { 47,  -3, -35, 24, corkscrewDownRight1, unbanked }, { 47,  -4, -36, 24, corkscrewDownRight1, unbanked },
    { 47,  -5, -37, 24, corkscrewDownRight1, unbanked }, { 47,  -6, -38, 24, corkscrewDownRight1, unbanked }, { 48,  -7, -39, 24, corkscrewDownRight1, unbanked },
    { 48,  -8, -39, 24, corkscrewDownRight1, unbanked }, { 48,  -9, -40, 24, corkscrewDownRight0, unbanked }, { 48, -10, -41, 24, corkscrewDownRight0, unbanked },
    { 48, -11, -42, 24, corkscrewDownRight0, unbanked }, { 48, -12, -42, 24, corkscrewDownRight0, unbanked }, { 48, -13, -43, 24, corkscrewDownRight0, unbanked },
    { 48, -14, -43, 24, corkscrewDownRight0, unbanked }, { 48, -15, -44, 24, corkscrewDownRight0, unbanked }, { 48, -16, -44, 24, corkscrewDownRight0, unbanked },
    { 48, -17, -45, 24, corkscrewDownRight0, unbanked }, { 48, -18, -45, 24, corkscrewDownRight0, unbanked }, { 48, -19, -46, 24, corkscrewDownRight0, unbanked },
    { 48, -20, -46, 24, corkscrewDownRight0, unbanked }, { 48, -21, -46, 24, corkscrewDownRight0, unbanked }, { 48, -22, -47, 24, corkscrewDownRight0, unbanked },
    { 48, -23, -47, 24, corkscrewDownRight0, unbanked }, { 48, -24, -47, 24, corkscrewDownRight0, unbanked }, { 48, -25, -47, 24, corkscrewDownRight0, unbanked },
    { 48, -26, -47, 24,                flat, unbanked }, { 48, -27, -48, 24,                flat, unbanked }, { 48, -28, -48, 24,                flat, unbanked },
    { 48, -29, -48, 24,                flat, unbanked }, { 48, -30, -48, 24,                flat, unbanked }, { 48, -31, -48, 24,                flat, unbanked },
    { 48, -32, -48, 24,                flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EDB97, {
    {  16,  31,  16, 8,            inverted, unbanked }, {  16,  30,  16, 8,            inverted, unbanked }, {  16,  29,  16, 8,            inverted, unbanked },
    {  16,  28,  16, 8,            inverted, unbanked }, {  16,  27,  16, 8,            inverted, unbanked }, {  16,  26,  16, 8,            inverted, unbanked },
    {  16,  25,  15, 8,            inverted, unbanked }, {  16,  24,  15, 8,            inverted, unbanked }, {  16,  23,  15, 0, corkscrewDownRight4, unbanked },
    {  16,  22,  15, 0, corkscrewDownRight4, unbanked }, {  16,  21,  15, 0, corkscrewDownRight4, unbanked }, {  16,  20,  14, 0, corkscrewDownRight4, unbanked },
    {  16,  19,  14, 0, corkscrewDownRight4, unbanked }, {  16,  18,  14, 0, corkscrewDownRight4, unbanked }, {  16,  17,  13, 0, corkscrewDownRight4, unbanked },
    {  16,  16,  13, 0, corkscrewDownRight4, unbanked }, {  16,  15,  12, 0, corkscrewDownRight4, unbanked }, {  16,  14,  12, 0, corkscrewDownRight4, unbanked },
    {  16,  13,  11, 0, corkscrewDownRight4, unbanked }, {  16,  12,  11, 0, corkscrewDownRight4, unbanked }, {  16,  11,  10, 0, corkscrewDownRight4, unbanked },
    {  16,  10,  10, 0, corkscrewDownRight4, unbanked }, {  16,   9,   9, 0, corkscrewDownRight4, unbanked }, {  16,   8,   8, 0, corkscrewDownRight4, unbanked },
    {  16,   7,   7, 0, corkscrewDownRight3, unbanked }, {  16,   6,   7, 0, corkscrewDownRight3, unbanked }, {  15,   5,   6, 0, corkscrewDownRight3, unbanked },
    {  15,   4,   5, 0, corkscrewDownRight3, unbanked }, {  15,   3,   4, 0, corkscrewDownRight3, unbanked }, {  15,   2,   3, 0, corkscrewDownRight3, unbanked },
    {  15,   1,   2, 0, corkscrewDownRight3, unbanked }, {  15,   0,   1, 0, corkscrewDownRight3, unbanked }, {  14,  -1,   0, 0, corkscrewDownRight3, unbanked },
    {  14,  -2,  -1, 0, corkscrewDownRight3, unbanked }, {  14,  -2,  -2, 0, corkscrewDownRight3, unbanked }, {  14,  -3,  -3, 0, corkscrewDownRight3, unbanked },
    {  14,  -4,  -4, 0, corkscrewDownRight3, unbanked }, {  13,  -5,  -5, 0, corkscrewDownRight3, unbanked }, {  13,  -5,  -6, 0, corkscrewDownRight3, unbanked },
    {  13,  -6,  -7, 0, corkscrewDownRight3, unbanked }, {  12,  -6,  -8, 0, corkscrewDownRight2, unbanked }, {  12,  -7,  -9, 0, corkscrewDownRight2, unbanked },
    {  12,  -8, -10, 0, corkscrewDownRight2, unbanked }, {  12,  -8, -11, 0, corkscrewDownRight2, unbanked }, {  11,  -9, -12, 0, corkscrewDownRight2, unbanked },
    {  11,  -9, -13, 0, corkscrewDownRight2, unbanked }, {  10, -10, -14, 0, corkscrewDownRight2, unbanked }, {  10, -10, -15, 0, corkscrewDownRight2, unbanked },
    {  10, -11, -16, 0, corkscrewDownRight2, unbanked }, {   9, -11, -17, 0, corkscrewDownRight2, unbanked }, {   9, -11, -18, 0, corkscrewDownRight2, unbanked },
    {   8, -12, -19, 0, corkscrewDownRight2, unbanked }, {   8, -12, -20, 0, corkscrewDownRight2, unbanked }, {   7, -13, -21, 0, corkscrewDownRight2, unbanked },
    {   7, -13, -22, 0, corkscrewDownRight2, unbanked }, {   6, -13, -23, 0, corkscrewDownRight2, unbanked }, {   5, -13, -24, 0, corkscrewDownRight2, unbanked },
    {   5, -14, -25, 0, corkscrewDownRight1, unbanked }, {   4, -14, -26, 0, corkscrewDownRight1, unbanked }, {   4, -14, -27, 0, corkscrewDownRight1, unbanked },
    {   3, -15, -28, 0, corkscrewDownRight1, unbanked }, {   2, -15, -29, 0, corkscrewDownRight1, unbanked }, {   1, -15, -30, 0, corkscrewDownRight1, unbanked },
    {   1, -15, -31, 0, corkscrewDownRight1, unbanked }, {   0, -15, -32, 0, corkscrewDownRight1, unbanked }, {  -1, -16, -33, 0, corkscrewDownRight1, unbanked },
    {  -2, -16, -34, 0, corkscrewDownRight1, unbanked }, {  -3, -16, -35, 0, corkscrewDownRight1, unbanked }, {  -4, -16, -36, 0, corkscrewDownRight1, unbanked },
    {  -5, -16, -37, 0, corkscrewDownRight1, unbanked }, {  -6, -16, -38, 0, corkscrewDownRight1, unbanked }, {  -7, -17, -39, 0, corkscrewDownRight1, unbanked },
    {  -8, -17, -39, 0, corkscrewDownRight1, unbanked }, {  -9, -17, -40, 0, corkscrewDownRight0, unbanked }, { -10, -17, -41, 0, corkscrewDownRight0, unbanked },
    { -11, -17, -42, 0, corkscrewDownRight0, unbanked }, { -12, -17, -42, 0, corkscrewDownRight0, unbanked }, { -13, -17, -43, 0, corkscrewDownRight0, unbanked },
    { -14, -17, -43, 0, corkscrewDownRight0, unbanked }, { -15, -17, -44, 0, corkscrewDownRight0, unbanked }, { -16, -17, -44, 0, corkscrewDownRight0, unbanked },
    { -17, -17, -45, 0, corkscrewDownRight0, unbanked }, { -18, -17, -45, 0, corkscrewDownRight0, unbanked }, { -19, -17, -46, 0, corkscrewDownRight0, unbanked },
    { -20, -17, -46, 0, corkscrewDownRight0, unbanked }, { -21, -17, -46, 0, corkscrewDownRight0, unbanked }, { -22, -17, -47, 0, corkscrewDownRight0, unbanked },
    { -23, -17, -47, 0, corkscrewDownRight0, unbanked }, { -24, -17, -47, 0, corkscrewDownRight0, unbanked }, { -25, -17, -47, 0, corkscrewDownRight0, unbanked },
    { -26, -17, -47, 0,                flat, unbanked }, { -27, -17, -48, 0,                flat, unbanked }, { -28, -17, -48, 0,                flat, unbanked },
    { -29, -17, -48, 0,                flat, unbanked }, { -30, -17, -48, 0,                flat, unbanked }, { -31, -17, -48, 0,                flat, unbanked },
    { -32, -17, -48, 0,                flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6C32, {
    { 31, 16,  0, 0, flat, unbanked }, { 30, 16,  0, 0, flat, unbanked }, { 29, 16,  0, 0, flat, unbanked }, { 28, 16,  0, 0, flat, unbanked }, { 27, 16,  1, 0, flat, unbanked }, { 26, 16,  1, 0, up12, unbanked },
    { 25, 16,  1, 0, up12, unbanked }, { 24, 16,  2, 0, up12, unbanked }, { 23, 16,  2, 0, up12, unbanked }, { 22, 16,  2, 0, up12, unbanked }, { 21, 16,  3, 0, up12, unbanked }, { 20, 16,  3, 0, up12, unbanked },
    { 19, 16,  4, 0, up12, unbanked }, { 18, 16,  4, 0, up25, unbanked }, { 17, 16,  5, 0, up25, unbanked }, { 16, 16,  5, 0, up25, unbanked }, { 15, 16,  6, 0, up25, unbanked }, { 14, 16,  6, 0, up25, unbanked },
    { 13, 16,  7, 0, up25, unbanked }, { 12, 16,  8, 0, up25, unbanked }, { 11, 16,  8, 0, up25, unbanked }, { 10, 16,  9, 0, up25, unbanked }, {  9, 16, 10, 0, up42, unbanked }, {  8, 16, 11, 0, up42, unbanked },
    {  7, 16, 12, 0, up42, unbanked }, {  6, 16, 13, 0, up42, unbanked }, {  5, 16, 14, 0, up42, unbanked }, {  4, 16, 15, 0, up42, unbanked }, {  4, 16, 16, 0, up42, unbanked }, {  3, 16, 17, 0, up60, unbanked },
    {  2, 16, 18, 0, up60, unbanked }, {  2, 16, 19, 0, up60, unbanked }, {  1, 16, 20, 0, up60, unbanked }, {  1, 16, 21, 0, up60, unbanked }, {  0, 16, 22, 0, up60, unbanked }, {  0, 16, 23, 0, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6D78, {
    { 16,  0,  0, 8, flat, unbanked }, { 16,  1,  0, 8, flat, unbanked }, { 16,  2,  0, 8, flat, unbanked }, { 16,  3,  0, 8, flat, unbanked }, { 16,  4,  1, 8, flat, unbanked }, { 16,  5,  1, 8, up12, unbanked },
    { 16,  6,  1, 8, up12, unbanked }, { 16,  7,  2, 8, up12, unbanked }, { 16,  8,  2, 8, up12, unbanked }, { 16,  9,  2, 8, up12, unbanked }, { 16, 10,  3, 8, up12, unbanked }, { 16, 11,  3, 8, up12, unbanked },
    { 16, 12,  4, 8, up12, unbanked }, { 16, 13,  4, 8, up25, unbanked }, { 16, 14,  5, 8, up25, unbanked }, { 16, 15,  5, 8, up25, unbanked }, { 16, 16,  6, 8, up25, unbanked }, { 16, 17,  6, 8, up25, unbanked },
    { 16, 18,  7, 8, up25, unbanked }, { 16, 19,  8, 8, up25, unbanked }, { 16, 20,  8, 8, up25, unbanked }, { 16, 21,  9, 8, up25, unbanked }, { 16, 22, 10, 8, up42, unbanked }, { 16, 23, 11, 8, up42, unbanked },
    { 16, 24, 12, 8, up42, unbanked }, { 16, 25, 13, 8, up42, unbanked }, { 16, 26, 14, 8, up42, unbanked }, { 16, 27, 15, 8, up42, unbanked }, { 16, 27, 16, 8, up42, unbanked }, { 16, 28, 17, 8, up60, unbanked },
    { 16, 29, 18, 8, up60, unbanked }, { 16, 29, 19, 8, up60, unbanked }, { 16, 30, 20, 8, up60, unbanked }, { 16, 30, 21, 8, up60, unbanked }, { 16, 31, 22, 8, up60, unbanked }, { 16, 31, 23, 8, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6EBE, {
    {  0, 16,  0, 16, flat, unbanked }, {  1, 16,  0, 16, flat, unbanked }, {  2, 16,  0, 16, flat, unbanked }, {  3, 16,  0, 16, flat, unbanked }, {  4, 16,  1, 16, flat, unbanked },
    {  5, 16,  1, 16, up12, unbanked }, {  6, 16,  1, 16, up12, unbanked }, {  7, 16,  2, 16, up12, unbanked }, {  8, 16,  2, 16, up12, unbanked }, {  9, 16,  2, 16, up12, unbanked },
    { 10, 16,  3, 16, up12, unbanked }, { 11, 16,  3, 16, up12, unbanked }, { 12, 16,  4, 16, up12, unbanked }, { 13, 16,  4, 16, up25, unbanked }, { 14, 16,  5, 16, up25, unbanked },
    { 15, 16,  5, 16, up25, unbanked }, { 16, 16,  6, 16, up25, unbanked }, { 17, 16,  6, 16, up25, unbanked }, { 18, 16,  7, 16, up25, unbanked }, { 19, 16,  8, 16, up25, unbanked },
    { 20, 16,  8, 16, up25, unbanked }, { 21, 16,  9, 16, up25, unbanked }, { 22, 16, 10, 16, up42, unbanked }, { 23, 16, 11, 16, up42, unbanked }, { 24, 16, 12, 16, up42, unbanked },
    { 25, 16, 13, 16, up42, unbanked }, { 26, 16, 14, 16, up42, unbanked }, { 27, 16, 15, 16, up42, unbanked }, { 27, 16, 16, 16, up42, unbanked }, { 28, 16, 17, 16, up60, unbanked },
    { 29, 16, 18, 16, up60, unbanked }, { 29, 16, 19, 16, up60, unbanked }, { 30, 16, 20, 16, up60, unbanked }, { 30, 16, 21, 16, up60, unbanked }, { 31, 16, 22, 16, up60, unbanked },
    { 31, 16, 23, 16, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7004, {
    { 16, 31,  0, 24, flat, unbanked }, { 16, 30,  0, 24, flat, unbanked }, { 16, 29,  0, 24, flat, unbanked }, { 16, 28,  0, 24, flat, unbanked }, { 16, 27,  1, 24, flat, unbanked }, { 16, 26,  1, 24, up12, unbanked },
    { 16, 25,  1, 24, up12, unbanked }, { 16, 24,  2, 24, up12, unbanked }, { 16, 23,  2, 24, up12, unbanked }, { 16, 22,  2, 24, up12, unbanked }, { 16, 21,  3, 24, up12, unbanked }, { 16, 20,  3, 24, up12, unbanked },
    { 16, 19,  4, 24, up12, unbanked }, { 16, 18,  4, 24, up25, unbanked }, { 16, 17,  5, 24, up25, unbanked }, { 16, 16,  5, 24, up25, unbanked }, { 16, 15,  6, 24, up25, unbanked }, { 16, 14,  6, 24, up25, unbanked },
    { 16, 13,  7, 24, up25, unbanked }, { 16, 12,  8, 24, up25, unbanked }, { 16, 11,  8, 24, up25, unbanked }, { 16, 10,  9, 24, up25, unbanked }, { 16,  9, 10, 24, up42, unbanked }, { 16,  8, 11, 24, up42, unbanked },
    { 16,  7, 12, 24, up42, unbanked }, { 16,  6, 13, 24, up42, unbanked }, { 16,  5, 14, 24, up42, unbanked }, { 16,  4, 15, 24, up42, unbanked }, { 16,  4, 16, 24, up42, unbanked }, { 16,  3, 17, 24, up60, unbanked },
    { 16,  2, 18, 24, up60, unbanked }, { 16,  2, 19, 24, up60, unbanked }, { 16,  1, 20, 24, up60, unbanked }, { 16,  1, 21, 24, up60, unbanked }, { 16,  0, 22, 24, up60, unbanked }, { 16,  0, 23, 24, up60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C714A, {
    { 31, 16,  0, 0, up60, unbanked }, { 31, 16,  1, 0, up60, unbanked }, { 30, 16,  2, 0, up60, unbanked }, { 30, 16,  3, 0, up60, unbanked }, { 29, 16,  4, 0, up60, unbanked }, { 29, 16,  5, 0, up60, unbanked },
    { 28, 16,  6, 0, up60, unbanked }, { 27, 16,  7, 0, up42, unbanked }, { 27, 16,  8, 0, up42, unbanked }, { 26, 16,  9, 0, up42, unbanked }, { 25, 16, 10, 0, up42, unbanked }, { 24, 16, 11, 0, up42, unbanked },
    { 23, 16, 12, 0, up42, unbanked }, { 22, 16, 13, 0, up42, unbanked }, { 21, 16, 14, 0, up25, unbanked }, { 20, 16, 15, 0, up25, unbanked }, { 19, 16, 15, 0, up25, unbanked }, { 18, 16, 16, 0, up25, unbanked },
    { 17, 16, 17, 0, up25, unbanked }, { 16, 16, 17, 0, up25, unbanked }, { 15, 16, 18, 0, up25, unbanked }, { 14, 16, 18, 0, up25, unbanked }, { 13, 16, 19, 0, up25, unbanked }, { 12, 16, 19, 0, up12, unbanked },
    { 11, 16, 20, 0, up12, unbanked }, { 10, 16, 20, 0, up12, unbanked }, {  9, 16, 21, 0, up12, unbanked }, {  8, 16, 21, 0, up12, unbanked }, {  7, 16, 21, 0, up12, unbanked }, {  6, 16, 22, 0, up12, unbanked },
    {  5, 16, 22, 0, up12, unbanked }, {  4, 16, 22, 0, flat, unbanked }, {  3, 16, 23, 0, flat, unbanked }, {  2, 16, 23, 0, flat, unbanked }, {  1, 16, 23, 0, flat, unbanked }, {  0, 16, 23, 0, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7290, {
    { 16,  0,  0, 8, up60, unbanked }, { 16,  0,  1, 8, up60, unbanked }, { 16,  1,  2, 8, up60, unbanked }, { 16,  1,  3, 8, up60, unbanked }, { 16,  2,  4, 8, up60, unbanked }, { 16,  2,  5, 8, up60, unbanked },
    { 16,  3,  6, 8, up60, unbanked }, { 16,  4,  7, 8, up42, unbanked }, { 16,  4,  8, 8, up42, unbanked }, { 16,  5,  9, 8, up42, unbanked }, { 16,  6, 10, 8, up42, unbanked }, { 16,  7, 11, 8, up42, unbanked },
    { 16,  8, 12, 8, up42, unbanked }, { 16,  9, 13, 8, up42, unbanked }, { 16, 10, 14, 8, up25, unbanked }, { 16, 11, 15, 8, up25, unbanked }, { 16, 12, 15, 8, up25, unbanked }, { 16, 13, 16, 8, up25, unbanked },
    { 16, 14, 17, 8, up25, unbanked }, { 16, 15, 17, 8, up25, unbanked }, { 16, 16, 18, 8, up25, unbanked }, { 16, 17, 18, 8, up25, unbanked }, { 16, 18, 19, 8, up25, unbanked }, { 16, 19, 19, 8, up12, unbanked },
    { 16, 20, 20, 8, up12, unbanked }, { 16, 21, 20, 8, up12, unbanked }, { 16, 22, 21, 8, up12, unbanked }, { 16, 23, 21, 8, up12, unbanked }, { 16, 24, 21, 8, up12, unbanked }, { 16, 25, 22, 8, up12, unbanked },
    { 16, 26, 22, 8, up12, unbanked }, { 16, 27, 22, 8, flat, unbanked }, { 16, 28, 23, 8, flat, unbanked }, { 16, 29, 23, 8, flat, unbanked }, { 16, 30, 23, 8, flat, unbanked }, { 16, 31, 23, 8, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C73D6, {
    {  0, 16,  0, 16, up60, unbanked }, {  0, 16,  1, 16, up60, unbanked }, {  1, 16,  2, 16, up60, unbanked }, {  1, 16,  3, 16, up60, unbanked }, {  2, 16,  4, 16, up60, unbanked },
    {  2, 16,  5, 16, up60, unbanked }, {  3, 16,  6, 16, up60, unbanked }, {  4, 16,  7, 16, up42, unbanked }, {  4, 16,  8, 16, up42, unbanked }, {  5, 16,  9, 16, up42, unbanked },
    {  6, 16, 10, 16, up42, unbanked }, {  7, 16, 11, 16, up42, unbanked }, {  8, 16, 12, 16, up42, unbanked }, {  9, 16, 13, 16, up42, unbanked }, { 10, 16, 14, 16, up25, unbanked },
    { 11, 16, 15, 16, up25, unbanked }, { 12, 16, 15, 16, up25, unbanked }, { 13, 16, 16, 16, up25, unbanked }, { 14, 16, 17, 16, up25, unbanked }, { 15, 16, 17, 16, up25, unbanked },
    { 16, 16, 18, 16, up25, unbanked }, { 17, 16, 18, 16, up25, unbanked }, { 18, 16, 19, 16, up25, unbanked }, { 19, 16, 19, 16, up12, unbanked }, { 20, 16, 20, 16, up12, unbanked },
    { 21, 16, 20, 16, up12, unbanked }, { 22, 16, 21, 16, up12, unbanked }, { 23, 16, 21, 16, up12, unbanked }, { 24, 16, 21, 16, up12, unbanked }, { 25, 16, 22, 16, up12, unbanked },
    { 26, 16, 22, 16, up12, unbanked }, { 27, 16, 22, 16, flat, unbanked }, { 28, 16, 23, 16, flat, unbanked }, { 29, 16, 23, 16, flat, unbanked }, { 30, 16, 23, 16, flat, unbanked },
    { 31, 16, 23, 16, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C751C, {
    { 16, 31,  0, 24, up60, unbanked }, { 16, 31,  1, 24, up60, unbanked }, { 16, 30,  2, 24, up60, unbanked }, { 16, 30,  3, 24, up60, unbanked }, { 16, 29,  4, 24, up60, unbanked },
    { 16, 29,  5, 24, up60, unbanked }, { 16, 28,  6, 24, up60, unbanked }, { 16, 27,  7, 24, up42, unbanked }, { 16, 27,  8, 24, up42, unbanked }, { 16, 26,  9, 24, up42, unbanked },
    { 16, 25, 10, 24, up42, unbanked }, { 16, 24, 11, 24, up42, unbanked }, { 16, 23, 12, 24, up42, unbanked }, { 16, 22, 13, 24, up42, unbanked }, { 16, 21, 14, 24, up25, unbanked },
    { 16, 20, 15, 24, up25, unbanked }, { 16, 19, 15, 24, up25, unbanked }, { 16, 18, 16, 24, up25, unbanked }, { 16, 17, 17, 24, up25, unbanked }, { 16, 16, 17, 24, up25, unbanked },
    { 16, 15, 18, 24, up25, unbanked }, { 16, 14, 18, 24, up25, unbanked }, { 16, 13, 19, 24, up25, unbanked }, { 16, 12, 19, 24, up12, unbanked }, { 16, 11, 20, 24, up12, unbanked },
    { 16, 10, 20, 24, up12, unbanked }, { 16,  9, 21, 24, up12, unbanked }, { 16,  8, 21, 24, up12, unbanked }, { 16,  7, 21, 24, up12, unbanked }, { 16,  6, 22, 24, up12, unbanked },
    { 16,  5, 22, 24, up12, unbanked }, { 16,  4, 22, 24, flat, unbanked }, { 16,  3, 23, 24, flat, unbanked }, { 16,  2, 23, 24, flat, unbanked }, { 16,  1, 23, 24, flat, unbanked },
    { 16,  0, 23, 24, flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7662, {
    { 31, 16, 23, 0,   flat, unbanked }, { 30, 16, 23, 0,   flat, unbanked }, { 29, 16, 23, 0,   flat, unbanked }, { 28, 16, 23, 0,   flat, unbanked }, { 27, 16, 22, 0,   flat, unbanked },
    { 26, 16, 22, 0, down12, unbanked }, { 25, 16, 22, 0, down12, unbanked }, { 24, 16, 21, 0, down12, unbanked }, { 23, 16, 21, 0, down12, unbanked }, { 22, 16, 21, 0, down12, unbanked },
    { 21, 16, 20, 0, down12, unbanked }, { 20, 16, 20, 0, down12, unbanked }, { 19, 16, 19, 0, down12, unbanked }, { 18, 16, 19, 0, down25, unbanked }, { 17, 16, 18, 0, down25, unbanked },
    { 16, 16, 18, 0, down25, unbanked }, { 15, 16, 17, 0, down25, unbanked }, { 14, 16, 17, 0, down25, unbanked }, { 13, 16, 16, 0, down25, unbanked }, { 12, 16, 15, 0, down25, unbanked },
    { 11, 16, 15, 0, down25, unbanked }, { 10, 16, 14, 0, down25, unbanked }, {  9, 16, 13, 0, down42, unbanked }, {  8, 16, 12, 0, down42, unbanked }, {  7, 16, 11, 0, down42, unbanked },
    {  6, 16, 10, 0, down42, unbanked }, {  5, 16,  9, 0, down42, unbanked }, {  4, 16,  8, 0, down42, unbanked }, {  4, 16,  7, 0, down42, unbanked }, {  3, 16,  6, 0, down60, unbanked },
    {  2, 16,  5, 0, down60, unbanked }, {  2, 16,  4, 0, down60, unbanked }, {  1, 16,  3, 0, down60, unbanked }, {  1, 16,  2, 0, down60, unbanked }, {  0, 16,  1, 0, down60, unbanked },
    {  0, 16,  0, 0, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C77A8, {
    { 16,  0, 23, 8,   flat, unbanked }, { 16,  1, 23, 8,   flat, unbanked }, { 16,  2, 23, 8,   flat, unbanked }, { 16,  3, 23, 8,   flat, unbanked }, { 16,  4, 22, 8,   flat, unbanked },
    { 16,  5, 22, 8, down12, unbanked }, { 16,  6, 22, 8, down12, unbanked }, { 16,  7, 21, 8, down12, unbanked }, { 16,  8, 21, 8, down12, unbanked }, { 16,  9, 21, 8, down12, unbanked },
    { 16, 10, 20, 8, down12, unbanked }, { 16, 11, 20, 8, down12, unbanked }, { 16, 12, 19, 8, down12, unbanked }, { 16, 13, 19, 8, down25, unbanked }, { 16, 14, 18, 8, down25, unbanked },
    { 16, 15, 18, 8, down25, unbanked }, { 16, 16, 17, 8, down25, unbanked }, { 16, 17, 17, 8, down25, unbanked }, { 16, 18, 16, 8, down25, unbanked }, { 16, 19, 15, 8, down25, unbanked },
    { 16, 20, 15, 8, down25, unbanked }, { 16, 21, 14, 8, down25, unbanked }, { 16, 22, 13, 8, down42, unbanked }, { 16, 23, 12, 8, down42, unbanked }, { 16, 24, 11, 8, down42, unbanked },
    { 16, 25, 10, 8, down42, unbanked }, { 16, 26,  9, 8, down42, unbanked }, { 16, 27,  8, 8, down42, unbanked }, { 16, 27,  7, 8, down42, unbanked }, { 16, 28,  6, 8, down60, unbanked },
    { 16, 29,  5, 8, down60, unbanked }, { 16, 29,  4, 8, down60, unbanked }, { 16, 30,  3, 8, down60, unbanked }, { 16, 30,  2, 8, down60, unbanked }, { 16, 31,  1, 8, down60, unbanked },
    { 16, 31,  0, 8, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C78EE, {
    {  0, 16, 23, 16,   flat, unbanked }, {  1, 16, 23, 16,   flat, unbanked }, {  2, 16, 23, 16,   flat, unbanked }, {  3, 16, 23, 16,   flat, unbanked }, {  4, 16, 22, 16,   flat, unbanked },
    {  5, 16, 22, 16, down12, unbanked }, {  6, 16, 22, 16, down12, unbanked }, {  7, 16, 21, 16, down12, unbanked }, {  8, 16, 21, 16, down12, unbanked }, {  9, 16, 21, 16, down12, unbanked },
    { 10, 16, 20, 16, down12, unbanked }, { 11, 16, 20, 16, down12, unbanked }, { 12, 16, 19, 16, down12, unbanked }, { 13, 16, 19, 16, down25, unbanked }, { 14, 16, 18, 16, down25, unbanked },
    { 15, 16, 18, 16, down25, unbanked }, { 16, 16, 17, 16, down25, unbanked }, { 17, 16, 17, 16, down25, unbanked }, { 18, 16, 16, 16, down25, unbanked }, { 19, 16, 15, 16, down25, unbanked },
    { 20, 16, 15, 16, down25, unbanked }, { 21, 16, 14, 16, down25, unbanked }, { 22, 16, 13, 16, down42, unbanked }, { 23, 16, 12, 16, down42, unbanked }, { 24, 16, 11, 16, down42, unbanked },
    { 25, 16, 10, 16, down42, unbanked }, { 26, 16,  9, 16, down42, unbanked }, { 27, 16,  8, 16, down42, unbanked }, { 27, 16,  7, 16, down42, unbanked }, { 28, 16,  6, 16, down60, unbanked },
    { 29, 16,  5, 16, down60, unbanked }, { 29, 16,  4, 16, down60, unbanked }, { 30, 16,  3, 16, down60, unbanked }, { 30, 16,  2, 16, down60, unbanked }, { 31, 16,  1, 16, down60, unbanked },
    { 31, 16,  0, 16, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7A34, {
    { 16, 31, 23, 24,   flat, unbanked }, { 16, 30, 23, 24,   flat, unbanked }, { 16, 29, 23, 24,   flat, unbanked }, { 16, 28, 23, 24,   flat, unbanked }, { 16, 27, 22, 24,   flat, unbanked },
    { 16, 26, 22, 24, down12, unbanked }, { 16, 25, 22, 24, down12, unbanked }, { 16, 24, 21, 24, down12, unbanked }, { 16, 23, 21, 24, down12, unbanked }, { 16, 22, 21, 24, down12, unbanked },
    { 16, 21, 20, 24, down12, unbanked }, { 16, 20, 20, 24, down12, unbanked }, { 16, 19, 19, 24, down12, unbanked }, { 16, 18, 19, 24, down25, unbanked }, { 16, 17, 18, 24, down25, unbanked },
    { 16, 16, 18, 24, down25, unbanked }, { 16, 15, 17, 24, down25, unbanked }, { 16, 14, 17, 24, down25, unbanked }, { 16, 13, 16, 24, down25, unbanked }, { 16, 12, 15, 24, down25, unbanked },
    { 16, 11, 15, 24, down25, unbanked }, { 16, 10, 14, 24, down25, unbanked }, { 16,  9, 13, 24, down42, unbanked }, { 16,  8, 12, 24, down42, unbanked }, { 16,  7, 11, 24, down42, unbanked },
    { 16,  6, 10, 24, down42, unbanked }, { 16,  5,  9, 24, down42, unbanked }, { 16,  4,  8, 24, down42, unbanked }, { 16,  4,  7, 24, down42, unbanked }, { 16,  3,  6, 24, down60, unbanked },
    { 16,  2,  5, 24, down60, unbanked }, { 16,  2,  4, 24, down60, unbanked }, { 16,  1,  3, 24, down60, unbanked }, { 16,  1,  2, 24, down60, unbanked }, { 16,  0,  1, 24, down60, unbanked },
    { 16,  0,  0, 24, down60, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7B7A, {
    { 31, 16, 23, 0, down60, unbanked }, { 31, 16, 22, 0, down60, unbanked }, { 30, 16, 21, 0, down60, unbanked }, { 30, 16, 20, 0, down60, unbanked }, { 29, 16, 19, 0, down60, unbanked },
    { 29, 16, 18, 0, down60, unbanked }, { 28, 16, 17, 0, down60, unbanked }, { 27, 16, 16, 0, down42, unbanked }, { 27, 16, 15, 0, down42, unbanked }, { 26, 16, 14, 0, down42, unbanked },
    { 25, 16, 13, 0, down42, unbanked }, { 24, 16, 12, 0, down42, unbanked }, { 23, 16, 11, 0, down42, unbanked }, { 22, 16, 10, 0, down42, unbanked }, { 21, 16,  9, 0, down25, unbanked },
    { 20, 16,  8, 0, down25, unbanked }, { 19, 16,  8, 0, down25, unbanked }, { 18, 16,  7, 0, down25, unbanked }, { 17, 16,  6, 0, down25, unbanked }, { 16, 16,  6, 0, down25, unbanked },
    { 15, 16,  5, 0, down25, unbanked }, { 14, 16,  5, 0, down25, unbanked }, { 13, 16,  4, 0, down25, unbanked }, { 12, 16,  4, 0, down12, unbanked }, { 11, 16,  3, 0, down12, unbanked },
    { 10, 16,  3, 0, down12, unbanked }, {  9, 16,  2, 0, down12, unbanked }, {  8, 16,  2, 0, down12, unbanked }, {  7, 16,  2, 0, down12, unbanked }, {  6, 16,  1, 0, down12, unbanked },
    {  5, 16,  1, 0, down12, unbanked }, {  4, 16,  1, 0,   flat, unbanked }, {  3, 16,  0, 0,   flat, unbanked }, {  2, 16,  0, 0,   flat, unbanked }, {  1, 16,  0, 0,   flat, unbanked },
    {  0, 16,  0, 0,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7CC0, {
    { 16,  0, 23, 8, down60, unbanked }, { 16,  0, 22, 8, down60, unbanked }, { 16,  1, 21, 8, down60, unbanked }, { 16,  1, 20, 8, down60, unbanked }, { 16,  2, 19, 8, down60, unbanked },
    { 16,  2, 18, 8, down60, unbanked }, { 16,  3, 17, 8, down60, unbanked }, { 16,  4, 16, 8, down42, unbanked }, { 16,  4, 15, 8, down42, unbanked }, { 16,  5, 14, 8, down42, unbanked },
    { 16,  6, 13, 8, down42, unbanked }, { 16,  7, 12, 8, down42, unbanked }, { 16,  8, 11, 8, down42, unbanked }, { 16,  9, 10, 8, down42, unbanked }, { 16, 10,  9, 8, down25, unbanked },
    { 16, 11,  8, 8, down25, unbanked }, { 16, 12,  8, 8, down25, unbanked }, { 16, 13,  7, 8, down25, unbanked }, { 16, 14,  6, 8, down25, unbanked }, { 16, 15,  6, 8, down25, unbanked },
    { 16, 16,  5, 8, down25, unbanked }, { 16, 17,  5, 8, down25, unbanked }, { 16, 18,  4, 8, down25, unbanked }, { 16, 19,  4, 8, down12, unbanked }, { 16, 20,  3, 8, down12, unbanked },
    { 16, 21,  3, 8, down12, unbanked }, { 16, 22,  2, 8, down12, unbanked }, { 16, 23,  2, 8, down12, unbanked }, { 16, 24,  2, 8, down12, unbanked }, { 16, 25,  1, 8, down12, unbanked },
    { 16, 26,  1, 8, down12, unbanked }, { 16, 27,  1, 8,   flat, unbanked }, { 16, 28,  0, 8,   flat, unbanked }, { 16, 29,  0, 8,   flat, unbanked }, { 16, 30,  0, 8,   flat, unbanked },
    { 16, 31,  0, 8,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7E06, {
    {  0, 16, 23, 16, down60, unbanked }, {  0, 16, 22, 16, down60, unbanked }, {  1, 16, 21, 16, down60, unbanked }, {  1, 16, 20, 16, down60, unbanked }, {  2, 16, 19, 16, down60, unbanked },
    {  2, 16, 18, 16, down60, unbanked }, {  3, 16, 17, 16, down60, unbanked }, {  4, 16, 16, 16, down42, unbanked }, {  4, 16, 15, 16, down42, unbanked }, {  5, 16, 14, 16, down42, unbanked },
    {  6, 16, 13, 16, down42, unbanked }, {  7, 16, 12, 16, down42, unbanked }, {  8, 16, 11, 16, down42, unbanked }, {  9, 16, 10, 16, down42, unbanked }, { 10, 16,  9, 16, down25, unbanked },
    { 11, 16,  8, 16, down25, unbanked }, { 12, 16,  8, 16, down25, unbanked }, { 13, 16,  7, 16, down25, unbanked }, { 14, 16,  6, 16, down25, unbanked }, { 15, 16,  6, 16, down25, unbanked },
    { 16, 16,  5, 16, down25, unbanked }, { 17, 16,  5, 16, down25, unbanked }, { 18, 16,  4, 16, down25, unbanked }, { 19, 16,  4, 16, down12, unbanked }, { 20, 16,  3, 16, down12, unbanked },
    { 21, 16,  3, 16, down12, unbanked }, { 22, 16,  2, 16, down12, unbanked }, { 23, 16,  2, 16, down12, unbanked }, { 24, 16,  2, 16, down12, unbanked }, { 25, 16,  1, 16, down12, unbanked },
    { 26, 16,  1, 16, down12, unbanked }, { 27, 16,  1, 16,   flat, unbanked }, { 28, 16,  0, 16,   flat, unbanked }, { 29, 16,  0, 16,   flat, unbanked }, { 30, 16,  0, 16,   flat, unbanked },
    { 31, 16,  0, 16,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7F4C, {
    { 16, 31, 23, 24, down60, unbanked }, { 16, 31, 22, 24, down60, unbanked }, { 16, 30, 21, 24, down60, unbanked }, { 16, 30, 20, 24, down60, unbanked }, { 16, 29, 19, 24, down60, unbanked },
    { 16, 29, 18, 24, down60, unbanked }, { 16, 28, 17, 24, down60, unbanked }, { 16, 27, 16, 24, down42, unbanked }, { 16, 27, 15, 24, down42, unbanked }, { 16, 26, 14, 24, down42, unbanked },
    { 16, 25, 13, 24, down42, unbanked }, { 16, 24, 12, 24, down42, unbanked }, { 16, 23, 11, 24, down42, unbanked }, { 16, 22, 10, 24, down42, unbanked }, { 16, 21,  9, 24, down25, unbanked },
    { 16, 20,  8, 24, down25, unbanked }, { 16, 19,  8, 24, down25, unbanked }, { 16, 18,  7, 24, down25, unbanked }, { 16, 17,  6, 24, down25, unbanked }, { 16, 16,  6, 24, down25, unbanked },
    { 16, 15,  5, 24, down25, unbanked }, { 16, 14,  5, 24, down25, unbanked }, { 16, 13,  4, 24, down25, unbanked }, { 16, 12,  4, 24, down12, unbanked }, { 16, 11,  3, 24, down12, unbanked },
    { 16, 10,  3, 24, down12, unbanked }, { 16,  9,  2, 24, down12, unbanked }, { 16,  8,  2, 24, down12, unbanked }, { 16,  7,  2, 24, down12, unbanked }, { 16,  6,  1, 24, down12, unbanked },
    { 16,  5,  1, 24, down12, unbanked }, { 16,  4,  1, 24,   flat, unbanked }, { 16,  3,  0, 24,   flat, unbanked }, { 16,  2,  0, 24,   flat, unbanked }, { 16,  1,  0, 24,   flat, unbanked },
    { 16,  0,  0, 24,   flat, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EFA5A, {
    { 16, 16,  2, 0, up90, unbanked }, { 16, 16,  3, 0, up90, unbanked }, { 16, 16,  4, 0, up90, unbanked }, { 16, 16,  5, 0, up90, unbanked }, { 16, 16,  6, 0, up90, unbanked }, { 16, 16,  7, 0, up90, unbanked },
    { 16, 16,  8, 0, up90, unbanked }, { 16, 16,  9, 0, up90, unbanked }, { 16, 16, 10, 0, up90, unbanked }, { 16, 16, 11, 0, up90, unbanked }, { 16, 16, 12, 0, up90, unbanked }, { 16, 16, 13, 0, up90, unbanked },
    { 16, 16, 14, 0, up90, unbanked }, { 16, 16, 15, 0, up90, unbanked }, { 16, 16, 16, 0, up90, unbanked }, { 16, 16, 17, 0, up90, unbanked }, { 16, 16, 18, 0, up90, unbanked }, { 16, 16, 19, 0, up90, unbanked },
    { 16, 16, 20, 0, up90, unbanked }, { 16, 16, 21, 0, up90, unbanked }, { 16, 16, 22, 0, up90, unbanked }, { 16, 16, 23, 0, up90, unbanked }, { 16, 16, 24, 0, up90, unbanked }, { 16, 16, 25, 0, up90, unbanked },
    { 16, 16, 26, 0, up90, unbanked }, { 16, 16, 27, 0, up90, unbanked }, { 16, 16, 28, 0, up90, unbanked }, { 16, 16, 29, 0, up90, unbanked }, { 16, 16, 30, 0, up90, unbanked }, { 16, 16, 31, 0, up90, unbanked },
    { 16, 16, 32, 0, up90, unbanked }, { 16, 16, 33, 0, up90, unbanked }, { 16, 16, 34, 0, up90, unbanked }, { 16, 16, 35, 0, up90, unbanked }, { 16, 16, 36, 0, up90, unbanked }, { 16, 16, 37, 0, up90, unbanked },
    { 16, 16, 38, 0, up90, unbanked }, { 16, 16, 39, 0, up90, unbanked }, { 16, 16, 40, 0, up90, unbanked }, { 16, 16, 41, 0, up90, unbanked }, { 16, 16, 42, 0, up90, unbanked }, { 16, 16, 43, 0, up90, unbanked },
    { 16, 16, 44, 0, up90, unbanked }, { 16, 16, 45, 0, up90, unbanked }, { 16, 16, 46, 0, up90, unbanked }, { 16, 16, 47, 0, up90, unbanked }, { 16, 16, 48, 0, up90, unbanked }, { 16, 16, 49, 0, up90, unbanked },
    { 16, 16, 50, 0, up90, unbanked }, { 16, 16, 51, 0, up90, unbanked }, { 16, 16, 52, 0, up90, unbanked }, { 16, 16, 53, 0, up90, unbanked }, { 16, 16, 54, 0, up90, unbanked }, { 16, 16, 55, 0, up90, unbanked },
    { 16, 16, 56, 0, up90, unbanked }, { 16, 16, 57, 0, up90, unbanked }, { 16, 16, 58, 0, up90, unbanked }, { 16, 16, 59, 0, up90, unbanked }, { 16, 16, 60, 0, up90, unbanked }, { 16, 16, 61, 0, up90, unbanked },
    { 16, 16, 62, 0, up90, unbanked }, { 16, 16, 63, 0, up90, unbanked }, { 16, 16, 64, 0, up90, unbanked }, { 16, 16, 65, 0, up90, unbanked }, { 16, 16, 66, 0, up90, unbanked }, { 16, 16, 67, 0, up90, unbanked },
    { 16, 16, 68, 0, up90, unbanked }, { 16, 16, 69, 0, up90, unbanked }, { 16, 16, 70, 0, up90, unbanked }, { 16, 16, 71, 0, up90, unbanked }, { 16, 16, 72, 0, up90, unbanked }, { 16, 16, 73, 0, up90, unbanked },
    { 16, 16, 74, 0, up90, unbanked }, { 16, 16, 75, 0, up90, unbanked }, { 16, 16, 76, 0, up90, unbanked }, { 16, 16, 77, 0, up90, unbanked }, { 16, 16, 78, 0, up90, unbanked }, { 16, 16, 79, 0, up90, unbanked },
    { 16, 16, 80, 0, up90, unbanked }, { 16, 16, 81, 0, up90, unbanked }, { 16, 16, 82, 0, up90, unbanked }, { 16, 16, 83, 0, up90, unbanked }, { 16, 16, 84, 0, up90, unbanked }, { 16, 16, 85, 0, up90, unbanked },
    { 16, 16, 86, 0, up90, unbanked }, { 16, 16, 87, 0, up90, unbanked }, { 16, 16, 88, 0, up90, unbanked }, { 16, 16, 89, 0, up90, unbanked }, { 16, 16, 90, 0, up90, unbanked }, { 16, 16, 91, 0, up90, unbanked },
    { 16, 16, 92, 0, up90, unbanked }, { 16, 16, 93, 0, up90, unbanked }, { 16, 16, 94, 0, up90, unbanked }, { 16, 16, 95, 0, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EFDAA, {
    { 16, 16,  2, 8, up90, unbanked }, { 16, 16,  3, 8, up90, unbanked }, { 16, 16,  4, 8, up90, unbanked }, { 16, 16,  5, 8, up90, unbanked }, { 16, 16,  6, 8, up90, unbanked }, { 16, 16,  7, 8, up90, unbanked },
    { 16, 16,  8, 8, up90, unbanked }, { 16, 16,  9, 8, up90, unbanked }, { 16, 16, 10, 8, up90, unbanked }, { 16, 16, 11, 8, up90, unbanked }, { 16, 16, 12, 8, up90, unbanked }, { 16, 16, 13, 8, up90, unbanked },
    { 16, 16, 14, 8, up90, unbanked }, { 16, 16, 15, 8, up90, unbanked }, { 16, 16, 16, 8, up90, unbanked }, { 16, 16, 17, 8, up90, unbanked }, { 16, 16, 18, 8, up90, unbanked }, { 16, 16, 19, 8, up90, unbanked },
    { 16, 16, 20, 8, up90, unbanked }, { 16, 16, 21, 8, up90, unbanked }, { 16, 16, 22, 8, up90, unbanked }, { 16, 16, 23, 8, up90, unbanked }, { 16, 16, 24, 8, up90, unbanked }, { 16, 16, 25, 8, up90, unbanked },
    { 16, 16, 26, 8, up90, unbanked }, { 16, 16, 27, 8, up90, unbanked }, { 16, 16, 28, 8, up90, unbanked }, { 16, 16, 29, 8, up90, unbanked }, { 16, 16, 30, 8, up90, unbanked }, { 16, 16, 31, 8, up90, unbanked },
    { 16, 16, 32, 8, up90, unbanked }, { 16, 16, 33, 8, up90, unbanked }, { 16, 16, 34, 8, up90, unbanked }, { 16, 16, 35, 8, up90, unbanked }, { 16, 16, 36, 8, up90, unbanked }, { 16, 16, 37, 8, up90, unbanked },
    { 16, 16, 38, 8, up90, unbanked }, { 16, 16, 39, 8, up90, unbanked }, { 16, 16, 40, 8, up90, unbanked }, { 16, 16, 41, 8, up90, unbanked }, { 16, 16, 42, 8, up90, unbanked }, { 16, 16, 43, 8, up90, unbanked },
    { 16, 16, 44, 8, up90, unbanked }, { 16, 16, 45, 8, up90, unbanked }, { 16, 16, 46, 8, up90, unbanked }, { 16, 16, 47, 8, up90, unbanked }, { 16, 16, 48, 8, up90, unbanked }, { 16, 16, 49, 8, up90, unbanked },
    { 16, 16, 50, 8, up90, unbanked }, { 16, 16, 51, 8, up90, unbanked }, { 16, 16, 52, 8, up90, unbanked }, { 16, 16, 53, 8, up90, unbanked }, { 16, 16, 54, 8, up90, unbanked }, { 16, 16, 55, 8, up90, unbanked },
    { 16, 16, 56, 8, up90, unbanked }, { 16, 16, 57, 8, up90, unbanked }, { 16, 16, 58, 8, up90, unbanked }, { 16, 16, 59, 8, up90, unbanked }, { 16, 16, 60, 8, up90, unbanked }, { 16, 16, 61, 8, up90, unbanked },
    { 16, 16, 62, 8, up90, unbanked }, { 16, 16, 63, 8, up90, unbanked }, { 16, 16, 64, 8, up90, unbanked }, { 16, 16, 65, 8, up90, unbanked }, { 16, 16, 66, 8, up90, unbanked }, { 16, 16, 67, 8, up90, unbanked },
    { 16, 16, 68, 8, up90, unbanked }, { 16, 16, 69, 8, up90, unbanked }, { 16, 16, 70, 8, up90, unbanked }, { 16, 16, 71, 8, up90, unbanked }, { 16, 16, 72, 8, up90, unbanked }, { 16, 16, 73, 8, up90, unbanked },
    { 16, 16, 74, 8, up90, unbanked }, { 16, 16, 75, 8, up90, unbanked }, { 16, 16, 76, 8, up90, unbanked }, { 16, 16, 77, 8, up90, unbanked }, { 16, 16, 78, 8, up90, unbanked }, { 16, 16, 79, 8, up90, unbanked },
    { 16, 16, 80, 8, up90, unbanked }, { 16, 16, 81, 8, up90, unbanked }, { 16, 16, 82, 8, up90, unbanked }, { 16, 16, 83, 8, up90, unbanked }, { 16, 16, 84, 8, up90, unbanked }, { 16, 16, 85, 8, up90, unbanked },
    { 16, 16, 86, 8, up90, unbanked }, { 16, 16, 87, 8, up90, unbanked }, { 16, 16, 88, 8, up90, unbanked }, { 16, 16, 89, 8, up90, unbanked }, { 16, 16, 90, 8, up90, unbanked }, { 16, 16, 91, 8, up90, unbanked },
    { 16, 16, 92, 8, up90, unbanked }, { 16, 16, 93, 8, up90, unbanked }, { 16, 16, 94, 8, up90, unbanked }, { 16, 16, 95, 8, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F00FA, {
    { 16, 16,  2, 16, up90, unbanked }, { 16, 16,  3, 16, up90, unbanked }, { 16, 16,  4, 16, up90, unbanked }, { 16, 16,  5, 16, up90, unbanked }, { 16, 16,  6, 16, up90, unbanked },
    { 16, 16,  7, 16, up90, unbanked }, { 16, 16,  8, 16, up90, unbanked }, { 16, 16,  9, 16, up90, unbanked }, { 16, 16, 10, 16, up90, unbanked }, { 16, 16, 11, 16, up90, unbanked },
    { 16, 16, 12, 16, up90, unbanked }, { 16, 16, 13, 16, up90, unbanked }, { 16, 16, 14, 16, up90, unbanked }, { 16, 16, 15, 16, up90, unbanked }, { 16, 16, 16, 16, up90, unbanked },
    { 16, 16, 17, 16, up90, unbanked }, { 16, 16, 18, 16, up90, unbanked }, { 16, 16, 19, 16, up90, unbanked }, { 16, 16, 20, 16, up90, unbanked }, { 16, 16, 21, 16, up90, unbanked },
    { 16, 16, 22, 16, up90, unbanked }, { 16, 16, 23, 16, up90, unbanked }, { 16, 16, 24, 16, up90, unbanked }, { 16, 16, 25, 16, up90, unbanked }, { 16, 16, 26, 16, up90, unbanked },
    { 16, 16, 27, 16, up90, unbanked }, { 16, 16, 28, 16, up90, unbanked }, { 16, 16, 29, 16, up90, unbanked }, { 16, 16, 30, 16, up90, unbanked }, { 16, 16, 31, 16, up90, unbanked },
    { 16, 16, 32, 16, up90, unbanked }, { 16, 16, 33, 16, up90, unbanked }, { 16, 16, 34, 16, up90, unbanked }, { 16, 16, 35, 16, up90, unbanked }, { 16, 16, 36, 16, up90, unbanked },
    { 16, 16, 37, 16, up90, unbanked }, { 16, 16, 38, 16, up90, unbanked }, { 16, 16, 39, 16, up90, unbanked }, { 16, 16, 40, 16, up90, unbanked }, { 16, 16, 41, 16, up90, unbanked },
    { 16, 16, 42, 16, up90, unbanked }, { 16, 16, 43, 16, up90, unbanked }, { 16, 16, 44, 16, up90, unbanked }, { 16, 16, 45, 16, up90, unbanked }, { 16, 16, 46, 16, up90, unbanked },
    { 16, 16, 47, 16, up90, unbanked }, { 16, 16, 48, 16, up90, unbanked }, { 16, 16, 49, 16, up90, unbanked }, { 16, 16, 50, 16, up90, unbanked }, { 16, 16, 51, 16, up90, unbanked },
    { 16, 16, 52, 16, up90, unbanked }, { 16, 16, 53, 16, up90, unbanked }, { 16, 16, 54, 16, up90, unbanked }, { 16, 16, 55, 16, up90, unbanked }, { 16, 16, 56, 16, up90, unbanked },
    { 16, 16, 57, 16, up90, unbanked }, { 16, 16, 58, 16, up90, unbanked }, { 16, 16, 59, 16, up90, unbanked }, { 16, 16, 60, 16, up90, unbanked }, { 16, 16, 61, 16, up90, unbanked },
    { 16, 16, 62, 16, up90, unbanked }, { 16, 16, 63, 16, up90, unbanked }, { 16, 16, 64, 16, up90, unbanked }, { 16, 16, 65, 16, up90, unbanked }, { 16, 16, 66, 16, up90, unbanked },
    { 16, 16, 67, 16, up90, unbanked }, { 16, 16, 68, 16, up90, unbanked }, { 16, 16, 69, 16, up90, unbanked }, { 16, 16, 70, 16, up90, unbanked }, { 16, 16, 71, 16, up90, unbanked },
    { 16, 16, 72, 16, up90, unbanked }, { 16, 16, 73, 16, up90, unbanked }, { 16, 16, 74, 16, up90, unbanked }, { 16, 16, 75, 16, up90, unbanked }, { 16, 16, 76, 16, up90, unbanked },
    { 16, 16, 77, 16, up90, unbanked }, { 16, 16, 78, 16, up90, unbanked }, { 16, 16, 79, 16, up90, unbanked }, { 16, 16, 80, 16, up90, unbanked }, { 16, 16, 81, 16, up90, unbanked },
    { 16, 16, 82, 16, up90, unbanked }, { 16, 16, 83, 16, up90, unbanked }, { 16, 16, 84, 16, up90, unbanked }, { 16, 16, 85, 16, up90, unbanked }, { 16, 16, 86, 16, up90, unbanked },
    { 16, 16, 87, 16, up90, unbanked }, { 16, 16, 88, 16, up90, unbanked }, { 16, 16, 89, 16, up90, unbanked }, { 16, 16, 90, 16, up90, unbanked }, { 16, 16, 91, 16, up90, unbanked },
    { 16, 16, 92, 16, up90, unbanked }, { 16, 16, 93, 16, up90, unbanked }, { 16, 16, 94, 16, up90, unbanked }, { 16, 16, 95, 16, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F044A, {
    { 16, 16,  2, 24, up90, unbanked }, { 16, 16,  3, 24, up90, unbanked }, { 16, 16,  4, 24, up90, unbanked }, { 16, 16,  5, 24, up90, unbanked }, { 16, 16,  6, 24, up90, unbanked },
    { 16, 16,  7, 24, up90, unbanked }, { 16, 16,  8, 24, up90, unbanked }, { 16, 16,  9, 24, up90, unbanked }, { 16, 16, 10, 24, up90, unbanked }, { 16, 16, 11, 24, up90, unbanked },
    { 16, 16, 12, 24, up90, unbanked }, { 16, 16, 13, 24, up90, unbanked }, { 16, 16, 14, 24, up90, unbanked }, { 16, 16, 15, 24, up90, unbanked }, { 16, 16, 16, 24, up90, unbanked },
    { 16, 16, 17, 24, up90, unbanked }, { 16, 16, 18, 24, up90, unbanked }, { 16, 16, 19, 24, up90, unbanked }, { 16, 16, 20, 24, up90, unbanked }, { 16, 16, 21, 24, up90, unbanked },
    { 16, 16, 22, 24, up90, unbanked }, { 16, 16, 23, 24, up90, unbanked }, { 16, 16, 24, 24, up90, unbanked }, { 16, 16, 25, 24, up90, unbanked }, { 16, 16, 26, 24, up90, unbanked },
    { 16, 16, 27, 24, up90, unbanked }, { 16, 16, 28, 24, up90, unbanked }, { 16, 16, 29, 24, up90, unbanked }, { 16, 16, 30, 24, up90, unbanked }, { 16, 16, 31, 24, up90, unbanked },
    { 16, 16, 32, 24, up90, unbanked }, { 16, 16, 33, 24, up90, unbanked }, { 16, 16, 34, 24, up90, unbanked }, { 16, 16, 35, 24, up90, unbanked }, { 16, 16, 36, 24, up90, unbanked },
    { 16, 16, 37, 24, up90, unbanked }, { 16, 16, 38, 24, up90, unbanked }, { 16, 16, 39, 24, up90, unbanked }, { 16, 16, 40, 24, up90, unbanked }, { 16, 16, 41, 24, up90, unbanked },
    { 16, 16, 42, 24, up90, unbanked }, { 16, 16, 43, 24, up90, unbanked }, { 16, 16, 44, 24, up90, unbanked }, { 16, 16, 45, 24, up90, unbanked }, { 16, 16, 46, 24, up90, unbanked },
    { 16, 16, 47, 24, up90, unbanked }, { 16, 16, 48, 24, up90, unbanked }, { 16, 16, 49, 24, up90, unbanked }, { 16, 16, 50, 24, up90, unbanked }, { 16, 16, 51, 24, up90, unbanked },
    { 16, 16, 52, 24, up90, unbanked }, { 16, 16, 53, 24, up90, unbanked }, { 16, 16, 54, 24, up90, unbanked }, { 16, 16, 55, 24, up90, unbanked }, { 16, 16, 56, 24, up90, unbanked },
    { 16, 16, 57, 24, up90, unbanked }, { 16, 16, 58, 24, up90, unbanked }, { 16, 16, 59, 24, up90, unbanked }, { 16, 16, 60, 24, up90, unbanked }, { 16, 16, 61, 24, up90, unbanked },
    { 16, 16, 62, 24, up90, unbanked }, { 16, 16, 63, 24, up90, unbanked }, { 16, 16, 64, 24, up90, unbanked }, { 16, 16, 65, 24, up90, unbanked }, { 16, 16, 66, 24, up90, unbanked },
    { 16, 16, 67, 24, up90, unbanked }, { 16, 16, 68, 24, up90, unbanked }, { 16, 16, 69, 24, up90, unbanked }, { 16, 16, 70, 24, up90, unbanked }, { 16, 16, 71, 24, up90, unbanked },
    { 16, 16, 72, 24, up90, unbanked }, { 16, 16, 73, 24, up90, unbanked }, { 16, 16, 74, 24, up90, unbanked }, { 16, 16, 75, 24, up90, unbanked }, { 16, 16, 76, 24, up90, unbanked },
    { 16, 16, 77, 24, up90, unbanked }, { 16, 16, 78, 24, up90, unbanked }, { 16, 16, 79, 24, up90, unbanked }, { 16, 16, 80, 24, up90, unbanked }, { 16, 16, 81, 24, up90, unbanked },
    { 16, 16, 82, 24, up90, unbanked }, { 16, 16, 83, 24, up90, unbanked }, { 16, 16, 84, 24, up90, unbanked }, { 16, 16, 85, 24, up90, unbanked }, { 16, 16, 86, 24, up90, unbanked },
    { 16, 16, 87, 24, up90, unbanked }, { 16, 16, 88, 24, up90, unbanked }, { 16, 16, 89, 24, up90, unbanked }, { 16, 16, 90, 24, up90, unbanked }, { 16, 16, 91, 24, up90, unbanked },
    { 16, 16, 92, 24, up90, unbanked }, { 16, 16, 93, 24, up90, unbanked }, { 16, 16, 94, 24, up90, unbanked }, { 16, 16, 95, 24, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F079A, {
    { 16, 16,  0, 0, up90, unbanked }, { 16, 16,  1, 0, up90, unbanked }, { 16, 16,  2, 0, up90, unbanked }, { 16, 16,  3, 0, up90, unbanked }, { 16, 16,  4, 0, up90, unbanked }, { 16, 16,  5, 0, up90, unbanked },
    { 16, 16,  6, 0, up90, unbanked }, { 16, 16,  7, 0, up90, unbanked }, { 16, 16,  8, 0, up90, unbanked }, { 16, 16,  9, 0, up90, unbanked }, { 16, 16, 10, 0, up90, unbanked }, { 16, 16, 11, 0, up90, unbanked },
    { 16, 16, 12, 0, up90, unbanked }, { 16, 16, 13, 0, up90, unbanked }, { 16, 16, 14, 0, up90, unbanked }, { 16, 16, 15, 0, up90, unbanked }, { 16, 16, 16, 0, up90, unbanked }, { 16, 16, 17, 0, up90, unbanked },
    { 16, 16, 18, 0, up90, unbanked }, { 16, 16, 19, 0, up90, unbanked }, { 16, 16, 20, 0, up90, unbanked }, { 16, 16, 21, 0, up90, unbanked }, { 16, 16, 22, 0, up90, unbanked }, { 16, 16, 23, 0, up90, unbanked },
    { 16, 16, 24, 0, up90, unbanked }, { 16, 16, 25, 0, up90, unbanked }, { 16, 16, 26, 0, up90, unbanked }, { 16, 16, 27, 0, up90, unbanked }, { 16, 16, 28, 0, up90, unbanked }, { 16, 16, 29, 0, up90, unbanked },
    { 16, 16, 30, 0, up90, unbanked }, { 16, 16, 31, 0, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F08BC, {
    { 16, 16,  0, 8, up90, unbanked }, { 16, 16,  1, 8, up90, unbanked }, { 16, 16,  2, 8, up90, unbanked }, { 16, 16,  3, 8, up90, unbanked }, { 16, 16,  4, 8, up90, unbanked }, { 16, 16,  5, 8, up90, unbanked },
    { 16, 16,  6, 8, up90, unbanked }, { 16, 16,  7, 8, up90, unbanked }, { 16, 16,  8, 8, up90, unbanked }, { 16, 16,  9, 8, up90, unbanked }, { 16, 16, 10, 8, up90, unbanked }, { 16, 16, 11, 8, up90, unbanked },
    { 16, 16, 12, 8, up90, unbanked }, { 16, 16, 13, 8, up90, unbanked }, { 16, 16, 14, 8, up90, unbanked }, { 16, 16, 15, 8, up90, unbanked }, { 16, 16, 16, 8, up90, unbanked }, { 16, 16, 17, 8, up90, unbanked },
    { 16, 16, 18, 8, up90, unbanked }, { 16, 16, 19, 8, up90, unbanked }, { 16, 16, 20, 8, up90, unbanked }, { 16, 16, 21, 8, up90, unbanked }, { 16, 16, 22, 8, up90, unbanked }, { 16, 16, 23, 8, up90, unbanked },
    { 16, 16, 24, 8, up90, unbanked }, { 16, 16, 25, 8, up90, unbanked }, { 16, 16, 26, 8, up90, unbanked }, { 16, 16, 27, 8, up90, unbanked }, { 16, 16, 28, 8, up90, unbanked }, { 16, 16, 29, 8, up90, unbanked },
    { 16, 16, 30, 8, up90, unbanked }, { 16, 16, 31, 8, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F09DE, {
    { 16, 16,  0, 16, up90, unbanked }, { 16, 16,  1, 16, up90, unbanked }, { 16, 16,  2, 16, up90, unbanked }, { 16, 16,  3, 16, up90, unbanked }, { 16, 16,  4, 16, up90, unbanked },
    { 16, 16,  5, 16, up90, unbanked }, { 16, 16,  6, 16, up90, unbanked }, { 16, 16,  7, 16, up90, unbanked }, { 16, 16,  8, 16, up90, unbanked }, { 16, 16,  9, 16, up90, unbanked },
    { 16, 16, 10, 16, up90, unbanked }, { 16, 16, 11, 16, up90, unbanked }, { 16, 16, 12, 16, up90, unbanked }, { 16, 16, 13, 16, up90, unbanked }, { 16, 16, 14, 16, up90, unbanked },
    { 16, 16, 15, 16, up90, unbanked }, { 16, 16, 16, 16, up90, unbanked }, { 16, 16, 17, 16, up90, unbanked }, { 16, 16, 18, 16, up90, unbanked }, { 16, 16, 19, 16, up90, unbanked },
    { 16, 16, 20, 16, up90, unbanked }, { 16, 16, 21, 16, up90, unbanked }, { 16, 16, 22, 16, up90, unbanked }, { 16, 16, 23, 16, up90, unbanked }, { 16, 16, 24, 16, up90, unbanked },
    { 16, 16, 25, 16, up90, unbanked }, { 16, 16, 26, 16, up90, unbanked }, { 16, 16, 27, 16, up90, unbanked }, { 16, 16, 28, 16, up90, unbanked }, { 16, 16, 29, 16, up90, unbanked },
    { 16, 16, 30, 16, up90, unbanked }, { 16, 16, 31, 16, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F0B00, {
    { 16, 16,  0, 24, up90, unbanked }, { 16, 16,  1, 24, up90, unbanked }, { 16, 16,  2, 24, up90, unbanked }, { 16, 16,  3, 24, up90, unbanked }, { 16, 16,  4, 24, up90, unbanked },
    { 16, 16,  5, 24, up90, unbanked }, { 16, 16,  6, 24, up90, unbanked }, { 16, 16,  7, 24, up90, unbanked }, { 16, 16,  8, 24, up90, unbanked }, { 16, 16,  9, 24, up90, unbanked },
    { 16, 16, 10, 24, up90, unbanked }, { 16, 16, 11, 24, up90, unbanked }, { 16, 16, 12, 24, up90, unbanked }, { 16, 16, 13, 24, up90, unbanked }, { 16, 16, 14, 24, up90, unbanked },
    { 16, 16, 15, 24, up90, unbanked }, { 16, 16, 16, 24, up90, unbanked }, { 16, 16, 17, 24, up90, unbanked }, { 16, 16, 18, 24, up90, unbanked }, { 16, 16, 19, 24, up90, unbanked },
    { 16, 16, 20, 24, up90, unbanked }, { 16, 16, 21, 24, up90, unbanked }, { 16, 16, 22, 24, up90, unbanked }, { 16, 16, 23, 24, up90, unbanked }, { 16, 16, 24, 24, up90, unbanked },
    { 16, 16, 25, 24, up90, unbanked }, { 16, 16, 26, 24, up90, unbanked }, { 16, 16, 27, 24, up90, unbanked }, { 16, 16, 28, 24, up90, unbanked }, { 16, 16, 29, 24, up90, unbanked },
    { 16, 16, 30, 24, up90, unbanked }, { 16, 16, 31, 24, up90, unbanked },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F8C82, {
    {  31,  16,  0,  0, upHalfHelixSmall, left45 }, {  30,  16,  0,  0, upHalfHelixSmall, left45 }, {  29,  16,  0,  0, upHalfHelixSmall, left45 }, {  28,  16,  0,  0, upHalfHelixSmall, left45 },
    {  27,  16,  0, 31, upHalfHelixSmall, left45 }, {  26,  16,  0, 31, upHalfHelixSmall, left45 }, {  25,  15,  0, 31, upHalfHelixSmall, left45 }, {  24,  15,  0, 31, upHalfHelixSmall, left45 },
    {  23,  15,  1, 31, upHalfHelixSmall, left45 }, {  22,  15,  1, 31, upHalfHelixSmall, left45 }, {  21,  15,  1, 31, upHalfHelixSmall, left45 }, {  20,  15,  1, 31, upHalfHelixSmall, left45 },
    {  19,  14,  1, 31, upHalfHelixSmall, left45 }, {  18,  14,  1, 30, upHalfHelixSmall, left45 }, {  17,  14,  1, 30, upHalfHelixSmall, left45 }, {  16,  13,  1, 30, upHalfHelixSmall, left45 },
    {  15,  13,  2, 30, upHalfHelixSmall, left45 }, {  14,  13,  2, 30, upHalfHelixSmall, left45 }, {  13,  12,  2, 30, upHalfHelixSmall, left45 }, {  12,  12,  2, 30, upHalfHelixSmall, left45 },
    {  11,  11,  2, 30, upHalfHelixSmall, left45 }, {  10,  11,  2, 30, upHalfHelixSmall, left45 }, {   9,  10,  2, 30, upHalfHelixSmall, left45 }, {   8,  10,  2, 29, upHalfHelixSmall, left45 },
    {   7,   9,  2, 29, upHalfHelixSmall, left45 }, {   6,   9,  3, 29, upHalfHelixSmall, left45 }, {   5,   8,  3, 29, upHalfHelixSmall, left45 }, {   4,   7,  3, 29, upHalfHelixSmall, left45 },
    {   3,   7,  3, 29, upHalfHelixSmall, left45 }, {   2,   6,  3, 29, upHalfHelixSmall, left45 }, {   1,   5,  3, 29, upHalfHelixSmall, left45 }, {   0,   4,  3, 29, upHalfHelixSmall, left45 },
    {  -1,   3,  3, 28, upHalfHelixSmall, left45 }, {  -3,   3,  4, 28, upHalfHelixSmall, left45 }, {  -4,   2,  4, 28, upHalfHelixSmall, left45 }, {  -5,   1,  4, 28, upHalfHelixSmall, left45 },
    {  -6,   0,  4, 28, upHalfHelixSmall, left45 }, {  -7,  -1,  4, 27, upHalfHelixSmall, left45 }, {  -7,  -2,  4, 27, upHalfHelixSmall, left45 }, {  -8,  -3,  4, 27, upHalfHelixSmall, left45 },
    {  -9,  -4,  4, 27, upHalfHelixSmall, left45 }, {  -9,  -5,  4, 27, upHalfHelixSmall, left45 }, { -10,  -6,  5, 27, upHalfHelixSmall, left45 }, { -10,  -7,  5, 27, upHalfHelixSmall, left45 },
    { -11,  -8,  5, 27, upHalfHelixSmall, left45 }, { -11,  -9,  5, 27, upHalfHelixSmall, left45 }, { -12, -10,  5, 26, upHalfHelixSmall, left45 }, { -12, -11,  5, 26, upHalfHelixSmall, left45 },
    { -13, -12,  5, 26, upHalfHelixSmall, left45 }, { -13, -13,  5, 26, upHalfHelixSmall, left45 }, { -13, -14,  6, 26, upHalfHelixSmall, left45 }, { -14, -15,  6, 26, upHalfHelixSmall, left45 },
    { -14, -16,  6, 26, upHalfHelixSmall, left45 }, { -14, -17,  6, 26, upHalfHelixSmall, left45 }, { -15, -18,  6, 26, upHalfHelixSmall, left45 }, { -15, -19,  6, 26, upHalfHelixSmall, left45 },
    { -15, -20,  6, 25, upHalfHelixSmall, left45 }, { -15, -21,  6, 25, upHalfHelixSmall, left45 }, { -15, -22,  6, 25, upHalfHelixSmall, left45 }, { -15, -23,  7, 25, upHalfHelixSmall, left45 },
    { -16, -24,  7, 25, upHalfHelixSmall, left45 }, { -16, -25,  7, 25, upHalfHelixSmall, left45 }, { -16, -26,  7, 25, upHalfHelixSmall, left45 }, { -16, -27,  7, 25, upHalfHelixSmall, left45 },
    { -16, -28,  7, 24, upHalfHelixSmall, left45 }, { -16, -29,  7, 24, upHalfHelixSmall, left45 }, { -16, -30,  7, 24, upHalfHelixSmall, left45 }, { -16, -31,  8, 24, upHalfHelixSmall, left45 },
    { -16, -33,  8, 24, upHalfHelixSmall, left45 }, { -16, -34,  8, 24, upHalfHelixSmall, left45 }, { -16, -35,  8, 24, upHalfHelixSmall, left45 }, { -16, -36,  8, 24, upHalfHelixSmall, left45 },
    { -16, -37,  8, 23, upHalfHelixSmall, left45 }, { -16, -38,  8, 23, upHalfHelixSmall, left45 }, { -15, -39,  8, 23, upHalfHelixSmall, left45 }, { -15, -40,  8, 23, upHalfHelixSmall, left45 },
    { -15, -41,  9, 23, upHalfHelixSmall, left45 }, { -15, -42,  9, 23, upHalfHelixSmall, left45 }, { -15, -43,  9, 23, upHalfHelixSmall, left45 }, { -15, -44,  9, 23, upHalfHelixSmall, left45 },
    { -14, -45,  9, 23, upHalfHelixSmall, left45 }, { -14, -46,  9, 22, upHalfHelixSmall, left45 }, { -14, -47,  9, 22, upHalfHelixSmall, left45 }, { -13, -48,  9, 22, upHalfHelixSmall, left45 },
    { -13, -49, 10, 22, upHalfHelixSmall, left45 }, { -13, -50, 10, 22, upHalfHelixSmall, left45 }, { -12, -51, 10, 22, upHalfHelixSmall, left45 }, { -12, -52, 10, 22, upHalfHelixSmall, left45 },
    { -11, -53, 10, 22, upHalfHelixSmall, left45 }, { -11, -54, 10, 22, upHalfHelixSmall, left45 }, { -10, -55, 10, 22, upHalfHelixSmall, left45 }, { -10, -56, 10, 21, upHalfHelixSmall, left45 },
    {  -9, -57, 10, 21, upHalfHelixSmall, left45 }, {  -9, -58, 11, 21, upHalfHelixSmall, left45 }, {  -8, -59, 11, 21, upHalfHelixSmall, left45 }, {  -7, -60, 11, 21, upHalfHelixSmall, left45 },
    {  -7, -61, 11, 21, upHalfHelixSmall, left45 }, {  -6, -62, 11, 21, upHalfHelixSmall, left45 }, {  -5, -63, 11, 21, upHalfHelixSmall, left45 }, {  -4, -64, 11, 21, upHalfHelixSmall, left45 },
    {  -3, -65, 11, 20, upHalfHelixSmall, left45 }, {  -3, -67, 12, 20, upHalfHelixSmall, left45 }, {  -2, -68, 12, 20, upHalfHelixSmall, left45 }, {  -1, -69, 12, 20, upHalfHelixSmall, left45 },
    {   0, -70, 12, 20, upHalfHelixSmall, left45 }, {   1, -71, 12, 19, upHalfHelixSmall, left45 }, {   2, -71, 12, 19, upHalfHelixSmall, left45 }, {   3, -72, 12, 19, upHalfHelixSmall, left45 },
    {   4, -73, 12, 19, upHalfHelixSmall, left45 }, {   5, -73, 13, 19, upHalfHelixSmall, left45 }, {   6, -74, 13, 19, upHalfHelixSmall, left45 }, {   7, -74, 13, 19, upHalfHelixSmall, left45 },
    {   8, -75, 13, 19, upHalfHelixSmall, left45 }, {   9, -75, 13, 19, upHalfHelixSmall, left45 }, {  10, -76, 13, 18, upHalfHelixSmall, left45 }, {  11, -76, 13, 18, upHalfHelixSmall, left45 },
    {  12, -77, 13, 18, upHalfHelixSmall, left45 }, {  13, -77, 13, 18, upHalfHelixSmall, left45 }, {  14, -77, 14, 18, upHalfHelixSmall, left45 }, {  15, -78, 14, 18, upHalfHelixSmall, left45 },
    {  16, -78, 14, 18, upHalfHelixSmall, left45 }, {  17, -78, 14, 18, upHalfHelixSmall, left45 }, {  18, -79, 14, 18, upHalfHelixSmall, left45 }, {  19, -79, 14, 18, upHalfHelixSmall, left45 },
    {  20, -79, 14, 17, upHalfHelixSmall, left45 }, {  21, -79, 14, 17, upHalfHelixSmall, left45 }, {  22, -79, 15, 17, upHalfHelixSmall, left45 }, {  23, -79, 15, 17, upHalfHelixSmall, left45 },
    {  24, -80, 15, 17, upHalfHelixSmall, left45 }, {  25, -80, 15, 17, upHalfHelixSmall, left45 }, {  26, -80, 15, 17, upHalfHelixSmall, left45 }, {  27, -80, 15, 17, upHalfHelixSmall, left45 },
    {  28, -80, 15, 16, upHalfHelixSmall, left45 }, {  29, -80, 15, 16, upHalfHelixSmall, left45 }, {  30, -80, 16, 16, upHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9143, {
    {  16,  0,  0,  8, upHalfHelixSmall, left45 }, {  16,  1,  0,  8, upHalfHelixSmall, left45 }, {  16,  2,  0,  8, upHalfHelixSmall, left45 }, {  16,  3,  0,  8, upHalfHelixSmall, left45 },
    {  16,  4,  0,  8, upHalfHelixSmall, left45 }, {  16,  5,  0,  7, upHalfHelixSmall, left45 }, {  16,  6,  0,  7, upHalfHelixSmall, left45 }, {  15,  7,  0,  7, upHalfHelixSmall, left45 },
    {  15,  8,  0,  7, upHalfHelixSmall, left45 }, {  15,  9,  1,  7, upHalfHelixSmall, left45 }, {  15, 10,  1,  7, upHalfHelixSmall, left45 }, {  15, 11,  1,  7, upHalfHelixSmall, left45 },
    {  15, 12,  1,  7, upHalfHelixSmall, left45 }, {  14, 13,  1,  7, upHalfHelixSmall, left45 }, {  14, 14,  1,  6, upHalfHelixSmall, left45 }, {  14, 15,  1,  6, upHalfHelixSmall, left45 },
    {  13, 16,  1,  6, upHalfHelixSmall, left45 }, {  13, 17,  1,  6, upHalfHelixSmall, left45 }, {  13, 18,  2,  6, upHalfHelixSmall, left45 }, {  12, 19,  2,  6, upHalfHelixSmall, left45 },
    {  12, 20,  2,  6, upHalfHelixSmall, left45 }, {  11, 21,  2,  6, upHalfHelixSmall, left45 }, {  11, 22,  2,  6, upHalfHelixSmall, left45 }, {  10, 23,  2,  6, upHalfHelixSmall, left45 },
    {  10, 24,  2,  5, upHalfHelixSmall, left45 }, {   9, 25,  2,  5, upHalfHelixSmall, left45 }, {   9, 26,  3,  5, upHalfHelixSmall, left45 }, {   8, 27,  3,  5, upHalfHelixSmall, left45 },
    {   7, 28,  3,  5, upHalfHelixSmall, left45 }, {   7, 29,  3,  5, upHalfHelixSmall, left45 }, {   6, 30,  3,  5, upHalfHelixSmall, left45 }, {   5, 31,  3,  5, upHalfHelixSmall, left45 },
    {   4, 32,  3,  5, upHalfHelixSmall, left45 }, {   3, 33,  3,  4, upHalfHelixSmall, left45 }, {   3, 35,  3,  4, upHalfHelixSmall, left45 }, {   2, 36,  4,  4, upHalfHelixSmall, left45 },
    {   1, 37,  4,  4, upHalfHelixSmall, left45 }, {   0, 38,  4,  4, upHalfHelixSmall, left45 }, {  -1, 39,  4,  3, upHalfHelixSmall, left45 }, {  -2, 39,  4,  3, upHalfHelixSmall, left45 },
    {  -3, 40,  4,  3, upHalfHelixSmall, left45 }, {  -4, 41,  4,  3, upHalfHelixSmall, left45 }, {  -5, 41,  4,  3, upHalfHelixSmall, left45 }, {  -6, 42,  4,  3, upHalfHelixSmall, left45 },
    {  -7, 42,  5,  3, upHalfHelixSmall, left45 }, {  -8, 43,  5,  3, upHalfHelixSmall, left45 }, {  -9, 43,  5,  3, upHalfHelixSmall, left45 }, { -10, 44,  5,  2, upHalfHelixSmall, left45 },
    { -11, 44,  5,  2, upHalfHelixSmall, left45 }, { -12, 45,  5,  2, upHalfHelixSmall, left45 }, { -13, 45,  5,  2, upHalfHelixSmall, left45 }, { -14, 45,  5,  2, upHalfHelixSmall, left45 },
    { -15, 46,  6,  2, upHalfHelixSmall, left45 }, { -16, 46,  6,  2, upHalfHelixSmall, left45 }, { -17, 46,  6,  2, upHalfHelixSmall, left45 }, { -18, 47,  6,  2, upHalfHelixSmall, left45 },
    { -19, 47,  6,  2, upHalfHelixSmall, left45 }, { -20, 47,  6,  1, upHalfHelixSmall, left45 }, { -21, 47,  6,  1, upHalfHelixSmall, left45 }, { -22, 47,  6,  1, upHalfHelixSmall, left45 },
    { -23, 47,  6,  1, upHalfHelixSmall, left45 }, { -24, 48,  7,  1, upHalfHelixSmall, left45 }, { -25, 48,  7,  1, upHalfHelixSmall, left45 }, { -26, 48,  7,  1, upHalfHelixSmall, left45 },
    { -27, 48,  7,  1, upHalfHelixSmall, left45 }, { -28, 48,  7,  0, upHalfHelixSmall, left45 }, { -29, 48,  7,  0, upHalfHelixSmall, left45 }, { -30, 48,  7,  0, upHalfHelixSmall, left45 },
    { -31, 48,  7,  0, upHalfHelixSmall, left45 }, { -33, 48,  8,  0, upHalfHelixSmall, left45 }, { -34, 48,  8,  0, upHalfHelixSmall, left45 }, { -35, 48,  8,  0, upHalfHelixSmall, left45 },
    { -36, 48,  8,  0, upHalfHelixSmall, left45 }, { -37, 48,  8, 31, upHalfHelixSmall, left45 }, { -38, 48,  8, 31, upHalfHelixSmall, left45 }, { -39, 47,  8, 31, upHalfHelixSmall, left45 },
    { -40, 47,  8, 31, upHalfHelixSmall, left45 }, { -41, 47,  9, 31, upHalfHelixSmall, left45 }, { -42, 47,  9, 31, upHalfHelixSmall, left45 }, { -43, 47,  9, 31, upHalfHelixSmall, left45 },
    { -44, 47,  9, 31, upHalfHelixSmall, left45 }, { -45, 46,  9, 31, upHalfHelixSmall, left45 }, { -46, 46,  9, 30, upHalfHelixSmall, left45 }, { -47, 46,  9, 30, upHalfHelixSmall, left45 },
    { -48, 45,  9, 30, upHalfHelixSmall, left45 }, { -49, 45, 10, 30, upHalfHelixSmall, left45 }, { -50, 45, 10, 30, upHalfHelixSmall, left45 }, { -51, 44, 10, 30, upHalfHelixSmall, left45 },
    { -52, 44, 10, 30, upHalfHelixSmall, left45 }, { -53, 43, 10, 30, upHalfHelixSmall, left45 }, { -54, 43, 10, 30, upHalfHelixSmall, left45 }, { -55, 42, 10, 30, upHalfHelixSmall, left45 },
    { -56, 42, 10, 29, upHalfHelixSmall, left45 }, { -57, 41, 10, 29, upHalfHelixSmall, left45 }, { -58, 41, 11, 29, upHalfHelixSmall, left45 }, { -59, 40, 11, 29, upHalfHelixSmall, left45 },
    { -60, 39, 11, 29, upHalfHelixSmall, left45 }, { -61, 39, 11, 29, upHalfHelixSmall, left45 }, { -62, 38, 11, 29, upHalfHelixSmall, left45 }, { -63, 37, 11, 29, upHalfHelixSmall, left45 },
    { -64, 36, 11, 29, upHalfHelixSmall, left45 }, { -65, 35, 11, 28, upHalfHelixSmall, left45 }, { -67, 35, 12, 28, upHalfHelixSmall, left45 }, { -68, 34, 12, 28, upHalfHelixSmall, left45 },
    { -69, 33, 12, 28, upHalfHelixSmall, left45 }, { -70, 32, 12, 28, upHalfHelixSmall, left45 }, { -71, 31, 12, 27, upHalfHelixSmall, left45 }, { -71, 30, 12, 27, upHalfHelixSmall, left45 },
    { -72, 29, 12, 27, upHalfHelixSmall, left45 }, { -73, 28, 12, 27, upHalfHelixSmall, left45 }, { -73, 27, 12, 27, upHalfHelixSmall, left45 }, { -74, 26, 13, 27, upHalfHelixSmall, left45 },
    { -74, 25, 13, 27, upHalfHelixSmall, left45 }, { -75, 24, 13, 27, upHalfHelixSmall, left45 }, { -75, 23, 13, 27, upHalfHelixSmall, left45 }, { -76, 22, 13, 26, upHalfHelixSmall, left45 },
    { -76, 21, 13, 26, upHalfHelixSmall, left45 }, { -77, 20, 13, 26, upHalfHelixSmall, left45 }, { -77, 19, 13, 26, upHalfHelixSmall, left45 }, { -77, 18, 14, 26, upHalfHelixSmall, left45 },
    { -78, 17, 14, 26, upHalfHelixSmall, left45 }, { -78, 16, 14, 26, upHalfHelixSmall, left45 }, { -78, 15, 14, 26, upHalfHelixSmall, left45 }, { -79, 14, 14, 26, upHalfHelixSmall, left45 },
    { -79, 13, 14, 26, upHalfHelixSmall, left45 }, { -79, 12, 14, 25, upHalfHelixSmall, left45 }, { -79, 11, 14, 25, upHalfHelixSmall, left45 }, { -79, 10, 14, 25, upHalfHelixSmall, left45 },
    { -79,  9, 15, 25, upHalfHelixSmall, left45 }, { -80,  8, 15, 25, upHalfHelixSmall, left45 }, { -80,  7, 15, 25, upHalfHelixSmall, left45 }, { -80,  6, 15, 25, upHalfHelixSmall, left45 },
    { -80,  5, 15, 25, upHalfHelixSmall, left45 }, { -80,  4, 15, 24, upHalfHelixSmall, left45 }, { -80,  3, 15, 24, upHalfHelixSmall, left45 }, { -80,  2, 15, 24, upHalfHelixSmall, left45 },
    { -80,  1, 16, 24, upHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9616, {
    {  0,  16,  0, 16, upHalfHelixSmall, left45 }, {  1,  16,  0, 16, upHalfHelixSmall, left45 }, {  2,  16,  0, 16, upHalfHelixSmall, left45 }, {  3,  16,  0, 16, upHalfHelixSmall, left45 },
    {  4,  16,  0, 16, upHalfHelixSmall, left45 }, {  5,  16,  0, 15, upHalfHelixSmall, left45 }, {  6,  16,  0, 15, upHalfHelixSmall, left45 }, {  7,  17,  0, 15, upHalfHelixSmall, left45 },
    {  8,  17,  0, 15, upHalfHelixSmall, left45 }, {  9,  17,  1, 15, upHalfHelixSmall, left45 }, { 10,  17,  1, 15, upHalfHelixSmall, left45 }, { 11,  17,  1, 15, upHalfHelixSmall, left45 },
    { 12,  17,  1, 15, upHalfHelixSmall, left45 }, { 13,  18,  1, 15, upHalfHelixSmall, left45 }, { 14,  18,  1, 14, upHalfHelixSmall, left45 }, { 15,  18,  1, 14, upHalfHelixSmall, left45 },
    { 16,  19,  1, 14, upHalfHelixSmall, left45 }, { 17,  19,  2, 14, upHalfHelixSmall, left45 }, { 18,  19,  2, 14, upHalfHelixSmall, left45 }, { 19,  20,  2, 14, upHalfHelixSmall, left45 },
    { 20,  20,  2, 14, upHalfHelixSmall, left45 }, { 21,  21,  2, 14, upHalfHelixSmall, left45 }, { 22,  21,  2, 14, upHalfHelixSmall, left45 }, { 23,  22,  2, 14, upHalfHelixSmall, left45 },
    { 24,  22,  2, 13, upHalfHelixSmall, left45 }, { 25,  23,  2, 13, upHalfHelixSmall, left45 }, { 26,  23,  3, 13, upHalfHelixSmall, left45 }, { 27,  24,  3, 13, upHalfHelixSmall, left45 },
    { 28,  25,  3, 13, upHalfHelixSmall, left45 }, { 29,  25,  3, 13, upHalfHelixSmall, left45 }, { 30,  26,  3, 13, upHalfHelixSmall, left45 }, { 31,  27,  3, 13, upHalfHelixSmall, left45 },
    { 32,  28,  3, 13, upHalfHelixSmall, left45 }, { 33,  29,  3, 12, upHalfHelixSmall, left45 }, { 35,  29,  4, 12, upHalfHelixSmall, left45 }, { 36,  30,  4, 12, upHalfHelixSmall, left45 },
    { 37,  31,  4, 12, upHalfHelixSmall, left45 }, { 38,  32,  4, 12, upHalfHelixSmall, left45 }, { 39,  33,  4, 11, upHalfHelixSmall, left45 }, { 39,  34,  4, 11, upHalfHelixSmall, left45 },
    { 40,  35,  4, 11, upHalfHelixSmall, left45 }, { 41,  36,  4, 11, upHalfHelixSmall, left45 }, { 41,  37,  4, 11, upHalfHelixSmall, left45 }, { 42,  38,  5, 11, upHalfHelixSmall, left45 },
    { 42,  39,  5, 11, upHalfHelixSmall, left45 }, { 43,  40,  5, 11, upHalfHelixSmall, left45 }, { 43,  41,  5, 11, upHalfHelixSmall, left45 }, { 44,  42,  5, 10, upHalfHelixSmall, left45 },
    { 44,  43,  5, 10, upHalfHelixSmall, left45 }, { 45,  44,  5, 10, upHalfHelixSmall, left45 }, { 45,  45,  5, 10, upHalfHelixSmall, left45 }, { 45,  46,  6, 10, upHalfHelixSmall, left45 },
    { 46,  47,  6, 10, upHalfHelixSmall, left45 }, { 46,  48,  6, 10, upHalfHelixSmall, left45 }, { 46,  49,  6, 10, upHalfHelixSmall, left45 }, { 47,  50,  6, 10, upHalfHelixSmall, left45 },
    { 47,  51,  6, 10, upHalfHelixSmall, left45 }, { 47,  52,  6,  9, upHalfHelixSmall, left45 }, { 47,  53,  6,  9, upHalfHelixSmall, left45 }, { 47,  54,  6,  9, upHalfHelixSmall, left45 },
    { 47,  55,  7,  9, upHalfHelixSmall, left45 }, { 48,  56,  7,  9, upHalfHelixSmall, left45 }, { 48,  57,  7,  9, upHalfHelixSmall, left45 }, { 48,  58,  7,  9, upHalfHelixSmall, left45 },
    { 48,  59,  7,  9, upHalfHelixSmall, left45 }, { 48,  60,  7,  8, upHalfHelixSmall, left45 }, { 48,  61,  7,  8, upHalfHelixSmall, left45 }, { 48,  62,  7,  8, upHalfHelixSmall, left45 },
    { 48,  64,  8,  8, upHalfHelixSmall, left45 }, { 48,  65,  8,  8, upHalfHelixSmall, left45 }, { 48,  66,  8,  8, upHalfHelixSmall, left45 }, { 48,  67,  8,  8, upHalfHelixSmall, left45 },
    { 48,  68,  8,  8, upHalfHelixSmall, left45 }, { 48,  69,  8,  7, upHalfHelixSmall, left45 }, { 48,  70,  8,  7, upHalfHelixSmall, left45 }, { 47,  71,  8,  7, upHalfHelixSmall, left45 },
    { 47,  72,  8,  7, upHalfHelixSmall, left45 }, { 47,  73,  9,  7, upHalfHelixSmall, left45 }, { 47,  74,  9,  7, upHalfHelixSmall, left45 }, { 47,  75,  9,  7, upHalfHelixSmall, left45 },
    { 47,  76,  9,  7, upHalfHelixSmall, left45 }, { 46,  77,  9,  7, upHalfHelixSmall, left45 }, { 46,  78,  9,  6, upHalfHelixSmall, left45 }, { 46,  79,  9,  6, upHalfHelixSmall, left45 },
    { 45,  80,  9,  6, upHalfHelixSmall, left45 }, { 45,  81,  9,  6, upHalfHelixSmall, left45 }, { 45,  82, 10,  6, upHalfHelixSmall, left45 }, { 44,  83, 10,  6, upHalfHelixSmall, left45 },
    { 44,  84, 10,  6, upHalfHelixSmall, left45 }, { 43,  85, 10,  6, upHalfHelixSmall, left45 }, { 43,  86, 10,  6, upHalfHelixSmall, left45 }, { 42,  87, 10,  6, upHalfHelixSmall, left45 },
    { 42,  88, 10,  5, upHalfHelixSmall, left45 }, { 41,  89, 10,  5, upHalfHelixSmall, left45 }, { 41,  90, 11,  5, upHalfHelixSmall, left45 }, { 40,  91, 11,  5, upHalfHelixSmall, left45 },
    { 39,  92, 11,  5, upHalfHelixSmall, left45 }, { 39,  93, 11,  5, upHalfHelixSmall, left45 }, { 38,  94, 11,  5, upHalfHelixSmall, left45 }, { 37,  95, 11,  5, upHalfHelixSmall, left45 },
    { 36,  96, 11,  5, upHalfHelixSmall, left45 }, { 35,  97, 11,  4, upHalfHelixSmall, left45 }, { 35,  99, 11,  4, upHalfHelixSmall, left45 }, { 34, 100, 12,  4, upHalfHelixSmall, left45 },
    { 33, 101, 12,  4, upHalfHelixSmall, left45 }, { 32, 102, 12,  4, upHalfHelixSmall, left45 }, { 31, 103, 12,  3, upHalfHelixSmall, left45 }, { 30, 103, 12,  3, upHalfHelixSmall, left45 },
    { 29, 104, 12,  3, upHalfHelixSmall, left45 }, { 28, 105, 12,  3, upHalfHelixSmall, left45 }, { 27, 105, 12,  3, upHalfHelixSmall, left45 }, { 26, 106, 12,  3, upHalfHelixSmall, left45 },
    { 25, 106, 13,  3, upHalfHelixSmall, left45 }, { 24, 107, 13,  3, upHalfHelixSmall, left45 }, { 23, 107, 13,  3, upHalfHelixSmall, left45 }, { 22, 108, 13,  2, upHalfHelixSmall, left45 },
    { 21, 108, 13,  2, upHalfHelixSmall, left45 }, { 20, 109, 13,  2, upHalfHelixSmall, left45 }, { 19, 109, 13,  2, upHalfHelixSmall, left45 }, { 18, 109, 13,  2, upHalfHelixSmall, left45 },
    { 17, 110, 14,  2, upHalfHelixSmall, left45 }, { 16, 110, 14,  2, upHalfHelixSmall, left45 }, { 15, 110, 14,  2, upHalfHelixSmall, left45 }, { 14, 111, 14,  2, upHalfHelixSmall, left45 },
    { 13, 111, 14,  2, upHalfHelixSmall, left45 }, { 12, 111, 14,  1, upHalfHelixSmall, left45 }, { 11, 111, 14,  1, upHalfHelixSmall, left45 }, { 10, 111, 14,  1, upHalfHelixSmall, left45 },
    {  9, 111, 14,  1, upHalfHelixSmall, left45 }, {  8, 112, 15,  1, upHalfHelixSmall, left45 }, {  7, 112, 15,  1, upHalfHelixSmall, left45 }, {  6, 112, 15,  1, upHalfHelixSmall, left45 },
    {  5, 112, 15,  1, upHalfHelixSmall, left45 }, {  4, 112, 15,  0, upHalfHelixSmall, left45 }, {  3, 112, 15,  0, upHalfHelixSmall, left45 }, {  2, 112, 15,  0, upHalfHelixSmall, left45 },
    {  1, 112, 15,  0, upHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9AE9, {
    {  16,  31,  0, 24, upHalfHelixSmall, left45 }, {  16,  30,  0, 24, upHalfHelixSmall, left45 }, {  16,  29,  0, 24, upHalfHelixSmall, left45 }, {  16,  28,  0, 24, upHalfHelixSmall, left45 },
    {  16,  27,  0, 23, upHalfHelixSmall, left45 }, {  16,  26,  0, 23, upHalfHelixSmall, left45 }, {  17,  25,  0, 23, upHalfHelixSmall, left45 }, {  17,  24,  0, 23, upHalfHelixSmall, left45 },
    {  17,  23,  1, 23, upHalfHelixSmall, left45 }, {  17,  22,  1, 23, upHalfHelixSmall, left45 }, {  17,  21,  1, 23, upHalfHelixSmall, left45 }, {  17,  20,  1, 23, upHalfHelixSmall, left45 },
    {  18,  19,  1, 23, upHalfHelixSmall, left45 }, {  18,  18,  1, 22, upHalfHelixSmall, left45 }, {  18,  17,  1, 22, upHalfHelixSmall, left45 }, {  19,  16,  1, 22, upHalfHelixSmall, left45 },
    {  19,  15,  2, 22, upHalfHelixSmall, left45 }, {  19,  14,  2, 22, upHalfHelixSmall, left45 }, {  20,  13,  2, 22, upHalfHelixSmall, left45 }, {  20,  12,  2, 22, upHalfHelixSmall, left45 },
    {  21,  11,  2, 22, upHalfHelixSmall, left45 }, {  21,  10,  2, 22, upHalfHelixSmall, left45 }, {  22,   9,  2, 22, upHalfHelixSmall, left45 }, {  22,   8,  2, 21, upHalfHelixSmall, left45 },
    {  23,   7,  2, 21, upHalfHelixSmall, left45 }, {  23,   6,  3, 21, upHalfHelixSmall, left45 }, {  24,   5,  3, 21, upHalfHelixSmall, left45 }, {  25,   4,  3, 21, upHalfHelixSmall, left45 },
    {  25,   3,  3, 21, upHalfHelixSmall, left45 }, {  26,   2,  3, 21, upHalfHelixSmall, left45 }, {  27,   1,  3, 21, upHalfHelixSmall, left45 }, {  28,   0,  3, 21, upHalfHelixSmall, left45 },
    {  29,  -1,  3, 20, upHalfHelixSmall, left45 }, {  29,  -3,  4, 20, upHalfHelixSmall, left45 }, {  30,  -4,  4, 20, upHalfHelixSmall, left45 }, {  31,  -5,  4, 20, upHalfHelixSmall, left45 },
    {  32,  -6,  4, 20, upHalfHelixSmall, left45 }, {  33,  -7,  4, 19, upHalfHelixSmall, left45 }, {  34,  -7,  4, 19, upHalfHelixSmall, left45 }, {  35,  -8,  4, 19, upHalfHelixSmall, left45 },
    {  36,  -9,  4, 19, upHalfHelixSmall, left45 }, {  37,  -9,  5, 19, upHalfHelixSmall, left45 }, {  38, -10,  5, 19, upHalfHelixSmall, left45 }, {  39, -10,  5, 19, upHalfHelixSmall, left45 },
    {  40, -11,  5, 19, upHalfHelixSmall, left45 }, {  41, -11,  5, 19, upHalfHelixSmall, left45 }, {  42, -12,  5, 18, upHalfHelixSmall, left45 }, {  43, -12,  5, 18, upHalfHelixSmall, left45 },
    {  44, -13,  5, 18, upHalfHelixSmall, left45 }, {  45, -13,  5, 18, upHalfHelixSmall, left45 }, {  46, -13,  6, 18, upHalfHelixSmall, left45 }, {  47, -14,  6, 18, upHalfHelixSmall, left45 },
    {  48, -14,  6, 18, upHalfHelixSmall, left45 }, {  49, -14,  6, 18, upHalfHelixSmall, left45 }, {  50, -15,  6, 18, upHalfHelixSmall, left45 }, {  51, -15,  6, 18, upHalfHelixSmall, left45 },
    {  52, -15,  6, 17, upHalfHelixSmall, left45 }, {  53, -15,  6, 17, upHalfHelixSmall, left45 }, {  54, -15,  7, 17, upHalfHelixSmall, left45 }, {  55, -15,  7, 17, upHalfHelixSmall, left45 },
    {  56, -16,  7, 17, upHalfHelixSmall, left45 }, {  57, -16,  7, 17, upHalfHelixSmall, left45 }, {  58, -16,  7, 17, upHalfHelixSmall, left45 }, {  59, -16,  7, 17, upHalfHelixSmall, left45 },
    {  60, -16,  7, 16, upHalfHelixSmall, left45 }, {  61, -16,  7, 16, upHalfHelixSmall, left45 }, {  62, -16,  8, 16, upHalfHelixSmall, left45 }, {  64, -16,  8, 16, upHalfHelixSmall, left45 },
    {  65, -16,  8, 16, upHalfHelixSmall, left45 }, {  66, -16,  8, 16, upHalfHelixSmall, left45 }, {  67, -16,  8, 16, upHalfHelixSmall, left45 }, {  68, -16,  8, 16, upHalfHelixSmall, left45 },
    {  69, -16,  8, 15, upHalfHelixSmall, left45 }, {  70, -16,  8, 15, upHalfHelixSmall, left45 }, {  71, -15,  8, 15, upHalfHelixSmall, left45 }, {  72, -15,  8, 15, upHalfHelixSmall, left45 },
    {  73, -15,  9, 15, upHalfHelixSmall, left45 }, {  74, -15,  9, 15, upHalfHelixSmall, left45 }, {  75, -15,  9, 15, upHalfHelixSmall, left45 }, {  76, -15,  9, 15, upHalfHelixSmall, left45 },
    {  77, -14,  9, 15, upHalfHelixSmall, left45 }, {  78, -14,  9, 14, upHalfHelixSmall, left45 }, {  79, -14,  9, 14, upHalfHelixSmall, left45 }, {  80, -13,  9, 14, upHalfHelixSmall, left45 },
    {  81, -13, 10, 14, upHalfHelixSmall, left45 }, {  82, -13, 10, 14, upHalfHelixSmall, left45 }, {  83, -12, 10, 14, upHalfHelixSmall, left45 }, {  84, -12, 10, 14, upHalfHelixSmall, left45 },
    {  85, -11, 10, 14, upHalfHelixSmall, left45 }, {  86, -11, 10, 14, upHalfHelixSmall, left45 }, {  87, -10, 10, 14, upHalfHelixSmall, left45 }, {  88, -10, 10, 13, upHalfHelixSmall, left45 },
    {  89,  -9, 10, 13, upHalfHelixSmall, left45 }, {  90,  -9, 11, 13, upHalfHelixSmall, left45 }, {  91,  -8, 11, 13, upHalfHelixSmall, left45 }, {  92,  -7, 11, 13, upHalfHelixSmall, left45 },
    {  93,  -7, 11, 13, upHalfHelixSmall, left45 }, {  94,  -6, 11, 13, upHalfHelixSmall, left45 }, {  95,  -5, 11, 13, upHalfHelixSmall, left45 }, {  96,  -4, 11, 13, upHalfHelixSmall, left45 },
    {  97,  -3, 11, 12, upHalfHelixSmall, left45 }, {  99,  -3, 12, 12, upHalfHelixSmall, left45 }, { 100,  -2, 12, 12, upHalfHelixSmall, left45 }, { 101,  -1, 12, 12, upHalfHelixSmall, left45 },
    { 102,   0, 12, 12, upHalfHelixSmall, left45 }, { 103,   1, 12, 11, upHalfHelixSmall, left45 }, { 103,   2, 12, 11, upHalfHelixSmall, left45 }, { 104,   3, 12, 11, upHalfHelixSmall, left45 },
    { 105,   4, 12, 11, upHalfHelixSmall, left45 }, { 105,   5, 12, 11, upHalfHelixSmall, left45 }, { 106,   6, 13, 11, upHalfHelixSmall, left45 }, { 106,   7, 13, 11, upHalfHelixSmall, left45 },
    { 107,   8, 13, 11, upHalfHelixSmall, left45 }, { 107,   9, 13, 11, upHalfHelixSmall, left45 }, { 108,  10, 13, 10, upHalfHelixSmall, left45 }, { 108,  11, 13, 10, upHalfHelixSmall, left45 },
    { 109,  12, 13, 10, upHalfHelixSmall, left45 }, { 109,  13, 13, 10, upHalfHelixSmall, left45 }, { 109,  14, 14, 10, upHalfHelixSmall, left45 }, { 110,  15, 14, 10, upHalfHelixSmall, left45 },
    { 110,  16, 14, 10, upHalfHelixSmall, left45 }, { 110,  17, 14, 10, upHalfHelixSmall, left45 }, { 111,  18, 14, 10, upHalfHelixSmall, left45 }, { 111,  19, 14, 10, upHalfHelixSmall, left45 },
    { 111,  20, 14,  9, upHalfHelixSmall, left45 }, { 111,  21, 14,  9, upHalfHelixSmall, left45 }, { 111,  22, 14,  9, upHalfHelixSmall, left45 }, { 111,  23, 15,  9, upHalfHelixSmall, left45 },
    { 112,  24, 15,  9, upHalfHelixSmall, left45 }, { 112,  25, 15,  9, upHalfHelixSmall, left45 }, { 112,  26, 15,  9, upHalfHelixSmall, left45 }, { 112,  27, 15,  9, upHalfHelixSmall, left45 },
    { 112,  28, 15,  8, upHalfHelixSmall, left45 }, { 112,  29, 15,  8, upHalfHelixSmall, left45 }, { 112,  30, 15,  8, upHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9FAA, {
    {  31,  16,  0,  0, upHalfHelixSmall, right45 }, {  30,  16,  0,  0, upHalfHelixSmall, right45 }, {  29,  16,  0,  0, upHalfHelixSmall, right45 }, {  28,  16,  0,  0, upHalfHelixSmall, right45 },
    {  27,  16,  0,  1, upHalfHelixSmall, right45 }, {  26,  16,  0,  1, upHalfHelixSmall, right45 }, {  25,  17,  0,  1, upHalfHelixSmall, right45 }, {  24,  17,  0,  1, upHalfHelixSmall, right45 },
    {  23,  17,  1,  1, upHalfHelixSmall, right45 }, {  22,  17,  1,  1, upHalfHelixSmall, right45 }, {  21,  17,  1,  1, upHalfHelixSmall, right45 }, {  20,  17,  1,  1, upHalfHelixSmall, right45 },
    {  19,  18,  1,  1, upHalfHelixSmall, right45 }, {  18,  18,  1,  2, upHalfHelixSmall, right45 }, {  17,  18,  1,  2, upHalfHelixSmall, right45 }, {  16,  19,  1,  2, upHalfHelixSmall, right45 },
    {  15,  19,  2,  2, upHalfHelixSmall, right45 }, {  14,  19,  2,  2, upHalfHelixSmall, right45 }, {  13,  20,  2,  2, upHalfHelixSmall, right45 }, {  12,  20,  2,  2, upHalfHelixSmall, right45 },
    {  11,  21,  2,  2, upHalfHelixSmall, right45 }, {  10,  21,  2,  2, upHalfHelixSmall, right45 }, {   9,  22,  2,  2, upHalfHelixSmall, right45 }, {   8,  22,  2,  3, upHalfHelixSmall, right45 },
    {   7,  23,  2,  3, upHalfHelixSmall, right45 }, {   6,  23,  3,  3, upHalfHelixSmall, right45 }, {   5,  24,  3,  3, upHalfHelixSmall, right45 }, {   4,  25,  3,  3, upHalfHelixSmall, right45 },
    {   3,  25,  3,  3, upHalfHelixSmall, right45 }, {   2,  26,  3,  3, upHalfHelixSmall, right45 }, {   1,  27,  3,  3, upHalfHelixSmall, right45 }, {   0,  28,  3,  3, upHalfHelixSmall, right45 },
    {  -1,  29,  3,  4, upHalfHelixSmall, right45 }, {  -3,  29,  4,  4, upHalfHelixSmall, right45 }, {  -4,  30,  4,  4, upHalfHelixSmall, right45 }, {  -5,  31,  4,  4, upHalfHelixSmall, right45 },
    {  -6,  32,  4,  4, upHalfHelixSmall, right45 }, {  -7,  33,  4,  5, upHalfHelixSmall, right45 }, {  -7,  34,  4,  5, upHalfHelixSmall, right45 }, {  -8,  35,  4,  5, upHalfHelixSmall, right45 },
    {  -9,  36,  4,  5, upHalfHelixSmall, right45 }, {  -9,  37,  5,  5, upHalfHelixSmall, right45 }, { -10,  38,  5,  5, upHalfHelixSmall, right45 }, { -10,  39,  5,  5, upHalfHelixSmall, right45 },
    { -11,  40,  5,  5, upHalfHelixSmall, right45 }, { -11,  41,  5,  5, upHalfHelixSmall, right45 }, { -12,  42,  5,  6, upHalfHelixSmall, right45 }, { -12,  43,  5,  6, upHalfHelixSmall, right45 },
    { -13,  44,  5,  6, upHalfHelixSmall, right45 }, { -13,  45,  5,  6, upHalfHelixSmall, right45 }, { -13,  46,  6,  6, upHalfHelixSmall, right45 }, { -14,  47,  6,  6, upHalfHelixSmall, right45 },
    { -14,  48,  6,  6, upHalfHelixSmall, right45 }, { -14,  49,  6,  6, upHalfHelixSmall, right45 }, { -15,  50,  6,  6, upHalfHelixSmall, right45 }, { -15,  51,  6,  6, upHalfHelixSmall, right45 },
    { -15,  52,  6,  7, upHalfHelixSmall, right45 }, { -15,  53,  6,  7, upHalfHelixSmall, right45 }, { -15,  54,  7,  7, upHalfHelixSmall, right45 }, { -15,  55,  7,  7, upHalfHelixSmall, right45 },
    { -16,  56,  7,  7, upHalfHelixSmall, right45 }, { -16,  57,  7,  7, upHalfHelixSmall, right45 }, { -16,  58,  7,  7, upHalfHelixSmall, right45 }, { -16,  59,  7,  7, upHalfHelixSmall, right45 },
    { -16,  60,  7,  8, upHalfHelixSmall, right45 }, { -16,  61,  7,  8, upHalfHelixSmall, right45 }, { -16,  62,  8,  8, upHalfHelixSmall, right45 }, { -16,  64,  8,  8, upHalfHelixSmall, right45 },
    { -16,  65,  8,  8, upHalfHelixSmall, right45 }, { -16,  66,  8,  8, upHalfHelixSmall, right45 }, { -16,  67,  8,  8, upHalfHelixSmall, right45 }, { -16,  68,  8,  8, upHalfHelixSmall, right45 },
    { -16,  69,  8,  9, upHalfHelixSmall, right45 }, { -16,  70,  8,  9, upHalfHelixSmall, right45 }, { -15,  71,  8,  9, upHalfHelixSmall, right45 }, { -15,  72,  8,  9, upHalfHelixSmall, right45 },
    { -15,  73,  9,  9, upHalfHelixSmall, right45 }, { -15,  74,  9,  9, upHalfHelixSmall, right45 }, { -15,  75,  9,  9, upHalfHelixSmall, right45 }, { -15,  76,  9,  9, upHalfHelixSmall, right45 },
    { -14,  77,  9,  9, upHalfHelixSmall, right45 }, { -14,  78,  9, 10, upHalfHelixSmall, right45 }, { -14,  79,  9, 10, upHalfHelixSmall, right45 }, { -13,  80,  9, 10, upHalfHelixSmall, right45 },
    { -13,  81, 10, 10, upHalfHelixSmall, right45 }, { -13,  82, 10, 10, upHalfHelixSmall, right45 }, { -12,  83, 10, 10, upHalfHelixSmall, right45 }, { -12,  84, 10, 10, upHalfHelixSmall, right45 },
    { -11,  85, 10, 10, upHalfHelixSmall, right45 }, { -11,  86, 10, 10, upHalfHelixSmall, right45 }, { -10,  87, 10, 10, upHalfHelixSmall, right45 }, { -10,  88, 10, 11, upHalfHelixSmall, right45 },
    {  -9,  89, 10, 11, upHalfHelixSmall, right45 }, {  -9,  90, 11, 11, upHalfHelixSmall, right45 }, {  -8,  91, 11, 11, upHalfHelixSmall, right45 }, {  -7,  92, 11, 11, upHalfHelixSmall, right45 },
    {  -7,  93, 11, 11, upHalfHelixSmall, right45 }, {  -6,  94, 11, 11, upHalfHelixSmall, right45 }, {  -5,  95, 11, 11, upHalfHelixSmall, right45 }, {  -4,  96, 11, 11, upHalfHelixSmall, right45 },
    {  -3,  97, 11, 12, upHalfHelixSmall, right45 }, {  -3,  99, 12, 12, upHalfHelixSmall, right45 }, {  -2, 100, 12, 12, upHalfHelixSmall, right45 }, {  -1, 101, 12, 12, upHalfHelixSmall, right45 },
    {   0, 102, 12, 12, upHalfHelixSmall, right45 }, {   1, 103, 12, 13, upHalfHelixSmall, right45 }, {   2, 103, 12, 13, upHalfHelixSmall, right45 }, {   3, 104, 12, 13, upHalfHelixSmall, right45 },
    {   4, 105, 12, 13, upHalfHelixSmall, right45 }, {   5, 105, 12, 13, upHalfHelixSmall, right45 }, {   6, 106, 13, 13, upHalfHelixSmall, right45 }, {   7, 106, 13, 13, upHalfHelixSmall, right45 },
    {   8, 107, 13, 13, upHalfHelixSmall, right45 }, {   9, 107, 13, 13, upHalfHelixSmall, right45 }, {  10, 108, 13, 14, upHalfHelixSmall, right45 }, {  11, 108, 13, 14, upHalfHelixSmall, right45 },
    {  12, 109, 13, 14, upHalfHelixSmall, right45 }, {  13, 109, 13, 14, upHalfHelixSmall, right45 }, {  14, 109, 14, 14, upHalfHelixSmall, right45 }, {  15, 110, 14, 14, upHalfHelixSmall, right45 },
    {  16, 110, 14, 14, upHalfHelixSmall, right45 }, {  17, 110, 14, 14, upHalfHelixSmall, right45 }, {  18, 111, 14, 14, upHalfHelixSmall, right45 }, {  19, 111, 14, 14, upHalfHelixSmall, right45 },
    {  20, 111, 14, 15, upHalfHelixSmall, right45 }, {  21, 111, 14, 15, upHalfHelixSmall, right45 }, {  22, 111, 14, 15, upHalfHelixSmall, right45 }, {  23, 111, 15, 15, upHalfHelixSmall, right45 },
    {  24, 112, 15, 15, upHalfHelixSmall, right45 }, {  25, 112, 15, 15, upHalfHelixSmall, right45 }, {  26, 112, 15, 15, upHalfHelixSmall, right45 }, {  27, 112, 15, 15, upHalfHelixSmall, right45 },
    {  28, 112, 15, 16, upHalfHelixSmall, right45 }, {  29, 112, 15, 16, upHalfHelixSmall, right45 }, {  30, 112, 15, 16, upHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FA46B, {
    {  16,  0,  0,  8, upHalfHelixSmall, right45 }, {  16,  1,  0,  8, upHalfHelixSmall, right45 }, {  16,  2,  0,  8, upHalfHelixSmall, right45 }, {  16,  3,  0,  8, upHalfHelixSmall, right45 },
    {  16,  4,  0,  8, upHalfHelixSmall, right45 }, {  16,  5,  0,  9, upHalfHelixSmall, right45 }, {  16,  6,  0,  9, upHalfHelixSmall, right45 }, {  17,  7,  0,  9, upHalfHelixSmall, right45 },
    {  17,  8,  0,  9, upHalfHelixSmall, right45 }, {  17,  9,  1,  9, upHalfHelixSmall, right45 }, {  17, 10,  1,  9, upHalfHelixSmall, right45 }, {  17, 11,  1,  9, upHalfHelixSmall, right45 },
    {  17, 12,  1,  9, upHalfHelixSmall, right45 }, {  18, 13,  1,  9, upHalfHelixSmall, right45 }, {  18, 14,  1, 10, upHalfHelixSmall, right45 }, {  18, 15,  1, 10, upHalfHelixSmall, right45 },
    {  19, 16,  1, 10, upHalfHelixSmall, right45 }, {  19, 17,  2, 10, upHalfHelixSmall, right45 }, {  19, 18,  2, 10, upHalfHelixSmall, right45 }, {  20, 19,  2, 10, upHalfHelixSmall, right45 },
    {  20, 20,  2, 10, upHalfHelixSmall, right45 }, {  21, 21,  2, 10, upHalfHelixSmall, right45 }, {  21, 22,  2, 10, upHalfHelixSmall, right45 }, {  22, 23,  2, 10, upHalfHelixSmall, right45 },
    {  22, 24,  2, 11, upHalfHelixSmall, right45 }, {  23, 25,  2, 11, upHalfHelixSmall, right45 }, {  23, 26,  3, 11, upHalfHelixSmall, right45 }, {  24, 27,  3, 11, upHalfHelixSmall, right45 },
    {  25, 28,  3, 11, upHalfHelixSmall, right45 }, {  25, 29,  3, 11, upHalfHelixSmall, right45 }, {  26, 30,  3, 11, upHalfHelixSmall, right45 }, {  27, 31,  3, 11, upHalfHelixSmall, right45 },
    {  28, 32,  3, 11, upHalfHelixSmall, right45 }, {  29, 33,  3, 12, upHalfHelixSmall, right45 }, {  29, 35,  4, 12, upHalfHelixSmall, right45 }, {  30, 36,  4, 12, upHalfHelixSmall, right45 },
    {  31, 37,  4, 12, upHalfHelixSmall, right45 }, {  32, 38,  4, 12, upHalfHelixSmall, right45 }, {  33, 39,  4, 13, upHalfHelixSmall, right45 }, {  34, 39,  4, 13, upHalfHelixSmall, right45 },
    {  35, 40,  4, 13, upHalfHelixSmall, right45 }, {  36, 41,  4, 13, upHalfHelixSmall, right45 }, {  37, 41,  4, 13, upHalfHelixSmall, right45 }, {  38, 42,  5, 13, upHalfHelixSmall, right45 },
    {  39, 42,  5, 13, upHalfHelixSmall, right45 }, {  40, 43,  5, 13, upHalfHelixSmall, right45 }, {  41, 43,  5, 13, upHalfHelixSmall, right45 }, {  42, 44,  5, 14, upHalfHelixSmall, right45 },
    {  43, 44,  5, 14, upHalfHelixSmall, right45 }, {  44, 45,  5, 14, upHalfHelixSmall, right45 }, {  45, 45,  5, 14, upHalfHelixSmall, right45 }, {  46, 45,  6, 14, upHalfHelixSmall, right45 },
    {  47, 46,  6, 14, upHalfHelixSmall, right45 }, {  48, 46,  6, 14, upHalfHelixSmall, right45 }, {  49, 46,  6, 14, upHalfHelixSmall, right45 }, {  50, 47,  6, 14, upHalfHelixSmall, right45 },
    {  51, 47,  6, 14, upHalfHelixSmall, right45 }, {  52, 47,  6, 15, upHalfHelixSmall, right45 }, {  53, 47,  6, 15, upHalfHelixSmall, right45 }, {  54, 47,  6, 15, upHalfHelixSmall, right45 },
    {  55, 47,  7, 15, upHalfHelixSmall, right45 }, {  56, 48,  7, 15, upHalfHelixSmall, right45 }, {  57, 48,  7, 15, upHalfHelixSmall, right45 }, {  58, 48,  7, 15, upHalfHelixSmall, right45 },
    {  59, 48,  7, 15, upHalfHelixSmall, right45 }, {  60, 48,  7, 16, upHalfHelixSmall, right45 }, {  61, 48,  7, 16, upHalfHelixSmall, right45 }, {  62, 48,  7, 16, upHalfHelixSmall, right45 },
    {  64, 48,  8, 16, upHalfHelixSmall, right45 }, {  65, 48,  8, 16, upHalfHelixSmall, right45 }, {  66, 48,  8, 16, upHalfHelixSmall, right45 }, {  67, 48,  8, 16, upHalfHelixSmall, right45 },
    {  68, 48,  8, 16, upHalfHelixSmall, right45 }, {  69, 48,  8, 17, upHalfHelixSmall, right45 }, {  70, 48,  8, 17, upHalfHelixSmall, right45 }, {  71, 47,  8, 17, upHalfHelixSmall, right45 },
    {  72, 47,  8, 17, upHalfHelixSmall, right45 }, {  73, 47,  9, 17, upHalfHelixSmall, right45 }, {  74, 47,  9, 17, upHalfHelixSmall, right45 }, {  75, 47,  9, 17, upHalfHelixSmall, right45 },
    {  76, 47,  9, 17, upHalfHelixSmall, right45 }, {  77, 46,  9, 17, upHalfHelixSmall, right45 }, {  78, 46,  9, 18, upHalfHelixSmall, right45 }, {  79, 46,  9, 18, upHalfHelixSmall, right45 },
    {  80, 45,  9, 18, upHalfHelixSmall, right45 }, {  81, 45,  9, 18, upHalfHelixSmall, right45 }, {  82, 45, 10, 18, upHalfHelixSmall, right45 }, {  83, 44, 10, 18, upHalfHelixSmall, right45 },
    {  84, 44, 10, 18, upHalfHelixSmall, right45 }, {  85, 43, 10, 18, upHalfHelixSmall, right45 }, {  86, 43, 10, 18, upHalfHelixSmall, right45 }, {  87, 42, 10, 18, upHalfHelixSmall, right45 },
    {  88, 42, 10, 19, upHalfHelixSmall, right45 }, {  89, 41, 10, 19, upHalfHelixSmall, right45 }, {  90, 41, 11, 19, upHalfHelixSmall, right45 }, {  91, 40, 11, 19, upHalfHelixSmall, right45 },
    {  92, 39, 11, 19, upHalfHelixSmall, right45 }, {  93, 39, 11, 19, upHalfHelixSmall, right45 }, {  94, 38, 11, 19, upHalfHelixSmall, right45 }, {  95, 37, 11, 19, upHalfHelixSmall, right45 },
    {  96, 36, 11, 19, upHalfHelixSmall, right45 }, {  97, 35, 11, 20, upHalfHelixSmall, right45 }, {  99, 35, 11, 20, upHalfHelixSmall, right45 }, { 100, 34, 12, 20, upHalfHelixSmall, right45 },
    { 101, 33, 12, 20, upHalfHelixSmall, right45 }, { 102, 32, 12, 20, upHalfHelixSmall, right45 }, { 103, 31, 12, 21, upHalfHelixSmall, right45 }, { 103, 30, 12, 21, upHalfHelixSmall, right45 },
    { 104, 29, 12, 21, upHalfHelixSmall, right45 }, { 105, 28, 12, 21, upHalfHelixSmall, right45 }, { 105, 27, 12, 21, upHalfHelixSmall, right45 }, { 106, 26, 12, 21, upHalfHelixSmall, right45 },
    { 106, 25, 13, 21, upHalfHelixSmall, right45 }, { 107, 24, 13, 21, upHalfHelixSmall, right45 }, { 107, 23, 13, 21, upHalfHelixSmall, right45 }, { 108, 22, 13, 22, upHalfHelixSmall, right45 },
    { 108, 21, 13, 22, upHalfHelixSmall, right45 }, { 109, 20, 13, 22, upHalfHelixSmall, right45 }, { 109, 19, 13, 22, upHalfHelixSmall, right45 }, { 109, 18, 13, 22, upHalfHelixSmall, right45 },
    { 110, 17, 14, 22, upHalfHelixSmall, right45 }, { 110, 16, 14, 22, upHalfHelixSmall, right45 }, { 110, 15, 14, 22, upHalfHelixSmall, right45 }, { 111, 14, 14, 22, upHalfHelixSmall, right45 },
    { 111, 13, 14, 22, upHalfHelixSmall, right45 }, { 111, 12, 14, 23, upHalfHelixSmall, right45 }, { 111, 11, 14, 23, upHalfHelixSmall, right45 }, { 111, 10, 14, 23, upHalfHelixSmall, right45 },
    { 111,  9, 14, 23, upHalfHelixSmall, right45 }, { 112,  8, 15, 23, upHalfHelixSmall, right45 }, { 112,  7, 15, 23, upHalfHelixSmall, right45 }, { 112,  6, 15, 23, upHalfHelixSmall, right45 },
    { 112,  5, 15, 23, upHalfHelixSmall, right45 }, { 112,  4, 15, 24, upHalfHelixSmall, right45 }, { 112,  3, 15, 24, upHalfHelixSmall, right45 }, { 112,  2, 15, 24, upHalfHelixSmall, right45 },
    { 112,  1, 15, 24, upHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FA93E, {
    {  0,  16,  0, 16, upHalfHelixSmall, right45 }, {  1,  16,  0, 16, upHalfHelixSmall, right45 }, {  2,  16,  0, 16, upHalfHelixSmall, right45 }, {  3,  16,  0, 16, upHalfHelixSmall, right45 },
    {  4,  16,  0, 16, upHalfHelixSmall, right45 }, {  5,  16,  0, 17, upHalfHelixSmall, right45 }, {  6,  16,  0, 17, upHalfHelixSmall, right45 }, {  7,  15,  0, 17, upHalfHelixSmall, right45 },
    {  8,  15,  0, 17, upHalfHelixSmall, right45 }, {  9,  15,  1, 17, upHalfHelixSmall, right45 }, { 10,  15,  1, 17, upHalfHelixSmall, right45 }, { 11,  15,  1, 17, upHalfHelixSmall, right45 },
    { 12,  15,  1, 17, upHalfHelixSmall, right45 }, { 13,  14,  1, 17, upHalfHelixSmall, right45 }, { 14,  14,  1, 18, upHalfHelixSmall, right45 }, { 15,  14,  1, 18, upHalfHelixSmall, right45 },
    { 16,  13,  1, 18, upHalfHelixSmall, right45 }, { 17,  13,  1, 18, upHalfHelixSmall, right45 }, { 18,  13,  2, 18, upHalfHelixSmall, right45 }, { 19,  12,  2, 18, upHalfHelixSmall, right45 },
    { 20,  12,  2, 18, upHalfHelixSmall, right45 }, { 21,  11,  2, 18, upHalfHelixSmall, right45 }, { 22,  11,  2, 18, upHalfHelixSmall, right45 }, { 23,  10,  2, 18, upHalfHelixSmall, right45 },
    { 24,  10,  2, 19, upHalfHelixSmall, right45 }, { 25,   9,  2, 19, upHalfHelixSmall, right45 }, { 26,   9,  3, 19, upHalfHelixSmall, right45 }, { 27,   8,  3, 19, upHalfHelixSmall, right45 },
    { 28,   7,  3, 19, upHalfHelixSmall, right45 }, { 29,   7,  3, 19, upHalfHelixSmall, right45 }, { 30,   6,  3, 19, upHalfHelixSmall, right45 }, { 31,   5,  3, 19, upHalfHelixSmall, right45 },
    { 32,   4,  3, 19, upHalfHelixSmall, right45 }, { 33,   3,  3, 20, upHalfHelixSmall, right45 }, { 35,   3,  3, 20, upHalfHelixSmall, right45 }, { 36,   2,  4, 20, upHalfHelixSmall, right45 },
    { 37,   1,  4, 20, upHalfHelixSmall, right45 }, { 38,   0,  4, 20, upHalfHelixSmall, right45 }, { 39,  -1,  4, 21, upHalfHelixSmall, right45 }, { 39,  -2,  4, 21, upHalfHelixSmall, right45 },
    { 40,  -3,  4, 21, upHalfHelixSmall, right45 }, { 41,  -4,  4, 21, upHalfHelixSmall, right45 }, { 41,  -5,  4, 21, upHalfHelixSmall, right45 }, { 42,  -6,  4, 21, upHalfHelixSmall, right45 },
    { 42,  -7,  5, 21, upHalfHelixSmall, right45 }, { 43,  -8,  5, 21, upHalfHelixSmall, right45 }, { 43,  -9,  5, 21, upHalfHelixSmall, right45 }, { 44, -10,  5, 22, upHalfHelixSmall, right45 },
    { 44, -11,  5, 22, upHalfHelixSmall, right45 }, { 45, -12,  5, 22, upHalfHelixSmall, right45 }, { 45, -13,  5, 22, upHalfHelixSmall, right45 }, { 45, -14,  5, 22, upHalfHelixSmall, right45 },
    { 46, -15,  6, 22, upHalfHelixSmall, right45 }, { 46, -16,  6, 22, upHalfHelixSmall, right45 }, { 46, -17,  6, 22, upHalfHelixSmall, right45 }, { 47, -18,  6, 22, upHalfHelixSmall, right45 },
    { 47, -19,  6, 22, upHalfHelixSmall, right45 }, { 47, -20,  6, 23, upHalfHelixSmall, right45 }, { 47, -21,  6, 23, upHalfHelixSmall, right45 }, { 47, -22,  6, 23, upHalfHelixSmall, right45 },
    { 47, -23,  6, 23, upHalfHelixSmall, right45 }, { 48, -24,  7, 23, upHalfHelixSmall, right45 }, { 48, -25,  7, 23, upHalfHelixSmall, right45 }, { 48, -26,  7, 23, upHalfHelixSmall, right45 },
    { 48, -27,  7, 23, upHalfHelixSmall, right45 }, { 48, -28,  7, 24, upHalfHelixSmall, right45 }, { 48, -29,  7, 24, upHalfHelixSmall, right45 }, { 48, -30,  7, 24, upHalfHelixSmall, right45 },
    { 48, -31,  7, 24, upHalfHelixSmall, right45 }, { 48, -33,  8, 24, upHalfHelixSmall, right45 }, { 48, -34,  8, 24, upHalfHelixSmall, right45 }, { 48, -35,  8, 24, upHalfHelixSmall, right45 },
    { 48, -36,  8, 24, upHalfHelixSmall, right45 }, { 48, -37,  8, 25, upHalfHelixSmall, right45 }, { 48, -38,  8, 25, upHalfHelixSmall, right45 }, { 47, -39,  8, 25, upHalfHelixSmall, right45 },
    { 47, -40,  8, 25, upHalfHelixSmall, right45 }, { 47, -41,  9, 25, upHalfHelixSmall, right45 }, { 47, -42,  9, 25, upHalfHelixSmall, right45 }, { 47, -43,  9, 25, upHalfHelixSmall, right45 },
    { 47, -44,  9, 25, upHalfHelixSmall, right45 }, { 46, -45,  9, 25, upHalfHelixSmall, right45 }, { 46, -46,  9, 26, upHalfHelixSmall, right45 }, { 46, -47,  9, 26, upHalfHelixSmall, right45 },
    { 45, -48,  9, 26, upHalfHelixSmall, right45 }, { 45, -49, 10, 26, upHalfHelixSmall, right45 }, { 45, -50, 10, 26, upHalfHelixSmall, right45 }, { 44, -51, 10, 26, upHalfHelixSmall, right45 },
    { 44, -52, 10, 26, upHalfHelixSmall, right45 }, { 43, -53, 10, 26, upHalfHelixSmall, right45 }, { 43, -54, 10, 26, upHalfHelixSmall, right45 }, { 42, -55, 10, 26, upHalfHelixSmall, right45 },
    { 42, -56, 10, 27, upHalfHelixSmall, right45 }, { 41, -57, 10, 27, upHalfHelixSmall, right45 }, { 41, -58, 11, 27, upHalfHelixSmall, right45 }, { 40, -59, 11, 27, upHalfHelixSmall, right45 },
    { 39, -60, 11, 27, upHalfHelixSmall, right45 }, { 39, -61, 11, 27, upHalfHelixSmall, right45 }, { 38, -62, 11, 27, upHalfHelixSmall, right45 }, { 37, -63, 11, 27, upHalfHelixSmall, right45 },
    { 36, -64, 11, 27, upHalfHelixSmall, right45 }, { 35, -65, 11, 28, upHalfHelixSmall, right45 }, { 35, -67, 12, 28, upHalfHelixSmall, right45 }, { 34, -68, 12, 28, upHalfHelixSmall, right45 },
    { 33, -69, 12, 28, upHalfHelixSmall, right45 }, { 32, -70, 12, 28, upHalfHelixSmall, right45 }, { 31, -71, 12, 29, upHalfHelixSmall, right45 }, { 30, -71, 12, 29, upHalfHelixSmall, right45 },
    { 29, -72, 12, 29, upHalfHelixSmall, right45 }, { 28, -73, 12, 29, upHalfHelixSmall, right45 }, { 27, -73, 12, 29, upHalfHelixSmall, right45 }, { 26, -74, 13, 29, upHalfHelixSmall, right45 },
    { 25, -74, 13, 29, upHalfHelixSmall, right45 }, { 24, -75, 13, 29, upHalfHelixSmall, right45 }, { 23, -75, 13, 29, upHalfHelixSmall, right45 }, { 22, -76, 13, 30, upHalfHelixSmall, right45 },
    { 21, -76, 13, 30, upHalfHelixSmall, right45 }, { 20, -77, 13, 30, upHalfHelixSmall, right45 }, { 19, -77, 13, 30, upHalfHelixSmall, right45 }, { 18, -77, 14, 30, upHalfHelixSmall, right45 },
    { 17, -78, 14, 30, upHalfHelixSmall, right45 }, { 16, -78, 14, 30, upHalfHelixSmall, right45 }, { 15, -78, 14, 30, upHalfHelixSmall, right45 }, { 14, -79, 14, 30, upHalfHelixSmall, right45 },
    { 13, -79, 14, 30, upHalfHelixSmall, right45 }, { 12, -79, 14, 31, upHalfHelixSmall, right45 }, { 11, -79, 14, 31, upHalfHelixSmall, right45 }, { 10, -79, 14, 31, upHalfHelixSmall, right45 },
    {  9, -79, 15, 31, upHalfHelixSmall, right45 }, {  8, -80, 15, 31, upHalfHelixSmall, right45 }, {  7, -80, 15, 31, upHalfHelixSmall, right45 }, {  6, -80, 15, 31, upHalfHelixSmall, right45 },
    {  5, -80, 15, 31, upHalfHelixSmall, right45 }, {  4, -80, 15,  0, upHalfHelixSmall, right45 }, {  3, -80, 15,  0, upHalfHelixSmall, right45 }, {  2, -80, 15,  0, upHalfHelixSmall, right45 },
    {  1, -80, 16,  0, upHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FAE11, {
    {  16,  31,  0, 24, upHalfHelixSmall, right45 }, {  16,  30,  0, 24, upHalfHelixSmall, right45 }, {  16,  29,  0, 24, upHalfHelixSmall, right45 }, {  16,  28,  0, 24, upHalfHelixSmall, right45 },
    {  16,  27,  0, 25, upHalfHelixSmall, right45 }, {  16,  26,  0, 25, upHalfHelixSmall, right45 }, {  15,  25,  0, 25, upHalfHelixSmall, right45 }, {  15,  24,  0, 25, upHalfHelixSmall, right45 },
    {  15,  23,  1, 25, upHalfHelixSmall, right45 }, {  15,  22,  1, 25, upHalfHelixSmall, right45 }, {  15,  21,  1, 25, upHalfHelixSmall, right45 }, {  15,  20,  1, 25, upHalfHelixSmall, right45 },
    {  14,  19,  1, 25, upHalfHelixSmall, right45 }, {  14,  18,  1, 26, upHalfHelixSmall, right45 }, {  14,  17,  1, 26, upHalfHelixSmall, right45 }, {  13,  16,  1, 26, upHalfHelixSmall, right45 },
    {  13,  15,  2, 26, upHalfHelixSmall, right45 }, {  13,  14,  2, 26, upHalfHelixSmall, right45 }, {  12,  13,  2, 26, upHalfHelixSmall, right45 }, {  12,  12,  2, 26, upHalfHelixSmall, right45 },
    {  11,  11,  2, 26, upHalfHelixSmall, right45 }, {  11,  10,  2, 26, upHalfHelixSmall, right45 }, {  10,   9,  2, 26, upHalfHelixSmall, right45 }, {  10,   8,  2, 27, upHalfHelixSmall, right45 },
    {   9,   7,  2, 27, upHalfHelixSmall, right45 }, {   9,   6,  3, 27, upHalfHelixSmall, right45 }, {   8,   5,  3, 27, upHalfHelixSmall, right45 }, {   7,   4,  3, 27, upHalfHelixSmall, right45 },
    {   7,   3,  3, 27, upHalfHelixSmall, right45 }, {   6,   2,  3, 27, upHalfHelixSmall, right45 }, {   5,   1,  3, 27, upHalfHelixSmall, right45 }, {   4,   0,  3, 27, upHalfHelixSmall, right45 },
    {   3,  -1,  3, 28, upHalfHelixSmall, right45 }, {   3,  -3,  4, 28, upHalfHelixSmall, right45 }, {   2,  -4,  4, 28, upHalfHelixSmall, right45 }, {   1,  -5,  4, 28, upHalfHelixSmall, right45 },
    {   0,  -6,  4, 28, upHalfHelixSmall, right45 }, {  -1,  -7,  4, 29, upHalfHelixSmall, right45 }, {  -2,  -7,  4, 29, upHalfHelixSmall, right45 }, {  -3,  -8,  4, 29, upHalfHelixSmall, right45 },
    {  -4,  -9,  4, 29, upHalfHelixSmall, right45 }, {  -5,  -9,  4, 29, upHalfHelixSmall, right45 }, {  -6, -10,  5, 29, upHalfHelixSmall, right45 }, {  -7, -10,  5, 29, upHalfHelixSmall, right45 },
    {  -8, -11,  5, 29, upHalfHelixSmall, right45 }, {  -9, -11,  5, 29, upHalfHelixSmall, right45 }, { -10, -12,  5, 30, upHalfHelixSmall, right45 }, { -11, -12,  5, 30, upHalfHelixSmall, right45 },
    { -12, -13,  5, 30, upHalfHelixSmall, right45 }, { -13, -13,  5, 30, upHalfHelixSmall, right45 }, { -14, -13,  6, 30, upHalfHelixSmall, right45 }, { -15, -14,  6, 30, upHalfHelixSmall, right45 },
    { -16, -14,  6, 30, upHalfHelixSmall, right45 }, { -17, -14,  6, 30, upHalfHelixSmall, right45 }, { -18, -15,  6, 30, upHalfHelixSmall, right45 }, { -19, -15,  6, 30, upHalfHelixSmall, right45 },
    { -20, -15,  6, 31, upHalfHelixSmall, right45 }, { -21, -15,  6, 31, upHalfHelixSmall, right45 }, { -22, -15,  6, 31, upHalfHelixSmall, right45 }, { -23, -15,  7, 31, upHalfHelixSmall, right45 },
    { -24, -16,  7, 31, upHalfHelixSmall, right45 }, { -25, -16,  7, 31, upHalfHelixSmall, right45 }, { -26, -16,  7, 31, upHalfHelixSmall, right45 }, { -27, -16,  7, 31, upHalfHelixSmall, right45 },
    { -28, -16,  7,  0, upHalfHelixSmall, right45 }, { -29, -16,  7,  0, upHalfHelixSmall, right45 }, { -30, -16,  7,  0, upHalfHelixSmall, right45 }, { -31, -16,  8,  0, upHalfHelixSmall, right45 },
    { -33, -16,  8,  0, upHalfHelixSmall, right45 }, { -34, -16,  8,  0, upHalfHelixSmall, right45 }, { -35, -16,  8,  0, upHalfHelixSmall, right45 }, { -36, -16,  8,  0, upHalfHelixSmall, right45 },
    { -37, -16,  8,  1, upHalfHelixSmall, right45 }, { -38, -16,  8,  1, upHalfHelixSmall, right45 }, { -39, -15,  8,  1, upHalfHelixSmall, right45 }, { -40, -15,  8,  1, upHalfHelixSmall, right45 },
    { -41, -15,  9,  1, upHalfHelixSmall, right45 }, { -42, -15,  9,  1, upHalfHelixSmall, right45 }, { -43, -15,  9,  1, upHalfHelixSmall, right45 }, { -44, -15,  9,  1, upHalfHelixSmall, right45 },
    { -45, -14,  9,  1, upHalfHelixSmall, right45 }, { -46, -14,  9,  2, upHalfHelixSmall, right45 }, { -47, -14,  9,  2, upHalfHelixSmall, right45 }, { -48, -13,  9,  2, upHalfHelixSmall, right45 },
    { -49, -13, 10,  2, upHalfHelixSmall, right45 }, { -50, -13, 10,  2, upHalfHelixSmall, right45 }, { -51, -12, 10,  2, upHalfHelixSmall, right45 }, { -52, -12, 10,  2, upHalfHelixSmall, right45 },
    { -53, -11, 10,  2, upHalfHelixSmall, right45 }, { -54, -11, 10,  2, upHalfHelixSmall, right45 }, { -55, -10, 10,  2, upHalfHelixSmall, right45 }, { -56, -10, 10,  3, upHalfHelixSmall, right45 },
    { -57,  -9, 10,  3, upHalfHelixSmall, right45 }, { -58,  -9, 11,  3, upHalfHelixSmall, right45 }, { -59,  -8, 11,  3, upHalfHelixSmall, right45 }, { -60,  -7, 11,  3, upHalfHelixSmall, right45 },
    { -61,  -7, 11,  3, upHalfHelixSmall, right45 }, { -62,  -6, 11,  3, upHalfHelixSmall, right45 }, { -63,  -5, 11,  3, upHalfHelixSmall, right45 }, { -64,  -4, 11,  3, upHalfHelixSmall, right45 },
    { -65,  -3, 11,  4, upHalfHelixSmall, right45 }, { -67,  -3, 12,  4, upHalfHelixSmall, right45 }, { -68,  -2, 12,  4, upHalfHelixSmall, right45 }, { -69,  -1, 12,  4, upHalfHelixSmall, right45 },
    { -70,   0, 12,  4, upHalfHelixSmall, right45 }, { -71,   1, 12,  5, upHalfHelixSmall, right45 }, { -71,   2, 12,  5, upHalfHelixSmall, right45 }, { -72,   3, 12,  5, upHalfHelixSmall, right45 },
    { -73,   4, 12,  5, upHalfHelixSmall, right45 }, { -73,   5, 13,  5, upHalfHelixSmall, right45 }, { -74,   6, 13,  5, upHalfHelixSmall, right45 }, { -74,   7, 13,  5, upHalfHelixSmall, right45 },
    { -75,   8, 13,  5, upHalfHelixSmall, right45 }, { -75,   9, 13,  5, upHalfHelixSmall, right45 }, { -76,  10, 13,  6, upHalfHelixSmall, right45 }, { -76,  11, 13,  6, upHalfHelixSmall, right45 },
    { -77,  12, 13,  6, upHalfHelixSmall, right45 }, { -77,  13, 13,  6, upHalfHelixSmall, right45 }, { -77,  14, 14,  6, upHalfHelixSmall, right45 }, { -78,  15, 14,  6, upHalfHelixSmall, right45 },
    { -78,  16, 14,  6, upHalfHelixSmall, right45 }, { -78,  17, 14,  6, upHalfHelixSmall, right45 }, { -79,  18, 14,  6, upHalfHelixSmall, right45 }, { -79,  19, 14,  6, upHalfHelixSmall, right45 },
    { -79,  20, 14,  7, upHalfHelixSmall, right45 }, { -79,  21, 14,  7, upHalfHelixSmall, right45 }, { -79,  22, 15,  7, upHalfHelixSmall, right45 }, { -79,  23, 15,  7, upHalfHelixSmall, right45 },
    { -80,  24, 15,  7, upHalfHelixSmall, right45 }, { -80,  25, 15,  7, upHalfHelixSmall, right45 }, { -80,  26, 15,  7, upHalfHelixSmall, right45 }, { -80,  27, 15,  7, upHalfHelixSmall, right45 },
    { -80,  28, 15,  8, upHalfHelixSmall, right45 }, { -80,  29, 15,  8, upHalfHelixSmall, right45 }, { -80,  30, 16,  8, upHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FB2D2, {
    {  31,  16,  8,  0, downHalfHelixSmall, left45 }, {  30,  16,  8,  0, downHalfHelixSmall, left45 }, {  29,  16,  8,  0, downHalfHelixSmall, left45 },
    {  28,  16,  8,  0, downHalfHelixSmall, left45 }, {  27,  16,  8, 31, downHalfHelixSmall, left45 }, {  26,  16,  8, 31, downHalfHelixSmall, left45 },
    {  25,  15,  8, 31, downHalfHelixSmall, left45 }, {  24,  15,  8, 31, downHalfHelixSmall, left45 }, {  23,  15,  7, 31, downHalfHelixSmall, left45 },
    {  22,  15,  7, 31, downHalfHelixSmall, left45 }, {  21,  15,  7, 31, downHalfHelixSmall, left45 }, {  20,  15,  7, 31, downHalfHelixSmall, left45 },
    {  19,  14,  7, 31, downHalfHelixSmall, left45 }, {  18,  14,  7, 30, downHalfHelixSmall, left45 }, {  17,  14,  7, 30, downHalfHelixSmall, left45 },
    {  16,  13,  7, 30, downHalfHelixSmall, left45 }, {  15,  13,  6, 30, downHalfHelixSmall, left45 }, {  14,  13,  6, 30, downHalfHelixSmall, left45 },
    {  13,  12,  6, 30, downHalfHelixSmall, left45 }, {  12,  12,  6, 30, downHalfHelixSmall, left45 }, {  11,  11,  6, 30, downHalfHelixSmall, left45 },
    {  10,  11,  6, 30, downHalfHelixSmall, left45 }, {   9,  10,  6, 30, downHalfHelixSmall, left45 }, {   8,  10,  6, 29, downHalfHelixSmall, left45 },
    {   7,   9,  6, 29, downHalfHelixSmall, left45 }, {   6,   9,  5, 29, downHalfHelixSmall, left45 }, {   5,   8,  5, 29, downHalfHelixSmall, left45 },
    {   4,   7,  5, 29, downHalfHelixSmall, left45 }, {   3,   7,  5, 29, downHalfHelixSmall, left45 }, {   2,   6,  5, 29, downHalfHelixSmall, left45 },
    {   1,   5,  5, 29, downHalfHelixSmall, left45 }, {   0,   4,  5, 29, downHalfHelixSmall, left45 }, {  -1,   3,  5, 28, downHalfHelixSmall, left45 },
    {  -3,   3,  4, 28, downHalfHelixSmall, left45 }, {  -4,   2,  4, 28, downHalfHelixSmall, left45 }, {  -5,   1,  4, 28, downHalfHelixSmall, left45 },
    {  -6,   0,  4, 28, downHalfHelixSmall, left45 }, {  -7,  -1,  4, 27, downHalfHelixSmall, left45 }, {  -7,  -2,  4, 27, downHalfHelixSmall, left45 },
    {  -8,  -3,  4, 27, downHalfHelixSmall, left45 }, {  -9,  -4,  4, 27, downHalfHelixSmall, left45 }, {  -9,  -5,  4, 27, downHalfHelixSmall, left45 },
    { -10,  -6,  3, 27, downHalfHelixSmall, left45 }, { -10,  -7,  3, 27, downHalfHelixSmall, left45 }, { -11,  -8,  3, 27, downHalfHelixSmall, left45 },
    { -11,  -9,  3, 27, downHalfHelixSmall, left45 }, { -12, -10,  3, 26, downHalfHelixSmall, left45 }, { -12, -11,  3, 26, downHalfHelixSmall, left45 },
    { -13, -12,  3, 26, downHalfHelixSmall, left45 }, { -13, -13,  3, 26, downHalfHelixSmall, left45 }, { -13, -14,  2, 26, downHalfHelixSmall, left45 },
    { -14, -15,  2, 26, downHalfHelixSmall, left45 }, { -14, -16,  2, 26, downHalfHelixSmall, left45 }, { -14, -17,  2, 26, downHalfHelixSmall, left45 },
    { -15, -18,  2, 26, downHalfHelixSmall, left45 }, { -15, -19,  2, 26, downHalfHelixSmall, left45 }, { -15, -20,  2, 25, downHalfHelixSmall, left45 },
    { -15, -21,  2, 25, downHalfHelixSmall, left45 }, { -15, -22,  2, 25, downHalfHelixSmall, left45 }, { -15, -23,  1, 25, downHalfHelixSmall, left45 },
    { -16, -24,  1, 25, downHalfHelixSmall, left45 }, { -16, -25,  1, 25, downHalfHelixSmall, left45 }, { -16, -26,  1, 25, downHalfHelixSmall, left45 },
    { -16, -27,  1, 25, downHalfHelixSmall, left45 }, { -16, -28,  1, 24, downHalfHelixSmall, left45 }, { -16, -29,  1, 24, downHalfHelixSmall, left45 },
    { -16, -30,  1, 24, downHalfHelixSmall, left45 }, { -16, -31,  0, 24, downHalfHelixSmall, left45 }, { -16, -33,  0, 24, downHalfHelixSmall, left45 },
    { -16, -34,  0, 24, downHalfHelixSmall, left45 }, { -16, -35,  0, 24, downHalfHelixSmall, left45 }, { -16, -36,  0, 24, downHalfHelixSmall, left45 },
    { -16, -37,  0, 23, downHalfHelixSmall, left45 }, { -16, -38,  0, 23, downHalfHelixSmall, left45 }, { -15, -39,  0, 23, downHalfHelixSmall, left45 },
    { -15, -40,  0, 23, downHalfHelixSmall, left45 }, { -15, -41, -1, 23, downHalfHelixSmall, left45 }, { -15, -42, -1, 23, downHalfHelixSmall, left45 },
    { -15, -43, -1, 23, downHalfHelixSmall, left45 }, { -15, -44, -1, 23, downHalfHelixSmall, left45 }, { -14, -45, -1, 23, downHalfHelixSmall, left45 },
    { -14, -46, -1, 22, downHalfHelixSmall, left45 }, { -14, -47, -1, 22, downHalfHelixSmall, left45 }, { -13, -48, -1, 22, downHalfHelixSmall, left45 },
    { -13, -49, -2, 22, downHalfHelixSmall, left45 }, { -13, -50, -2, 22, downHalfHelixSmall, left45 }, { -12, -51, -2, 22, downHalfHelixSmall, left45 },
    { -12, -52, -2, 22, downHalfHelixSmall, left45 }, { -11, -53, -2, 22, downHalfHelixSmall, left45 }, { -11, -54, -2, 22, downHalfHelixSmall, left45 },
    { -10, -55, -2, 22, downHalfHelixSmall, left45 }, { -10, -56, -2, 21, downHalfHelixSmall, left45 }, {  -9, -57, -2, 21, downHalfHelixSmall, left45 },
    {  -9, -58, -3, 21, downHalfHelixSmall, left45 }, {  -8, -59, -3, 21, downHalfHelixSmall, left45 }, {  -7, -60, -3, 21, downHalfHelixSmall, left45 },
    {  -7, -61, -3, 21, downHalfHelixSmall, left45 }, {  -6, -62, -3, 21, downHalfHelixSmall, left45 }, {  -5, -63, -3, 21, downHalfHelixSmall, left45 },
    {  -4, -64, -3, 21, downHalfHelixSmall, left45 }, {  -3, -65, -3, 20, downHalfHelixSmall, left45 }, {  -3, -67, -4, 20, downHalfHelixSmall, left45 },
    {  -2, -68, -4, 20, downHalfHelixSmall, left45 }, {  -1, -69, -4, 20, downHalfHelixSmall, left45 }, {   0, -70, -4, 20, downHalfHelixSmall, left45 },
    {   1, -71, -4, 19, downHalfHelixSmall, left45 }, {   2, -71, -4, 19, downHalfHelixSmall, left45 }, {   3, -72, -4, 19, downHalfHelixSmall, left45 },
    {   4, -73, -4, 19, downHalfHelixSmall, left45 }, {   5, -73, -5, 19, downHalfHelixSmall, left45 }, {   6, -74, -5, 19, downHalfHelixSmall, left45 },
    {   7, -74, -5, 19, downHalfHelixSmall, left45 }, {   8, -75, -5, 19, downHalfHelixSmall, left45 }, {   9, -75, -5, 19, downHalfHelixSmall, left45 },
    {  10, -76, -5, 18, downHalfHelixSmall, left45 }, {  11, -76, -5, 18, downHalfHelixSmall, left45 }, {  12, -77, -5, 18, downHalfHelixSmall, left45 },
    {  13, -77, -5, 18, downHalfHelixSmall, left45 }, {  14, -77, -6, 18, downHalfHelixSmall, left45 }, {  15, -78, -6, 18, downHalfHelixSmall, left45 },
    {  16, -78, -6, 18, downHalfHelixSmall, left45 }, {  17, -78, -6, 18, downHalfHelixSmall, left45 }, {  18, -79, -6, 18, downHalfHelixSmall, left45 },
    {  19, -79, -6, 18, downHalfHelixSmall, left45 }, {  20, -79, -6, 17, downHalfHelixSmall, left45 }, {  21, -79, -6, 17, downHalfHelixSmall, left45 },
    {  22, -79, -7, 17, downHalfHelixSmall, left45 }, {  23, -79, -7, 17, downHalfHelixSmall, left45 }, {  24, -80, -7, 17, downHalfHelixSmall, left45 },
    {  25, -80, -7, 17, downHalfHelixSmall, left45 }, {  26, -80, -7, 17, downHalfHelixSmall, left45 }, {  27, -80, -7, 17, downHalfHelixSmall, left45 },
    {  28, -80, -7, 16, downHalfHelixSmall, left45 }, {  29, -80, -7, 16, downHalfHelixSmall, left45 }, {  30, -80, -8, 16, downHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FB793, {
    {  16,  0,  8,  8, downHalfHelixSmall, left45 }, {  16,  1,  8,  8, downHalfHelixSmall, left45 }, {  16,  2,  8,  8, downHalfHelixSmall, left45 }, {  16,  3,  8,  8, downHalfHelixSmall, left45 },
    {  16,  4,  8,  8, downHalfHelixSmall, left45 }, {  16,  5,  8,  7, downHalfHelixSmall, left45 }, {  16,  6,  8,  7, downHalfHelixSmall, left45 }, {  15,  7,  8,  7, downHalfHelixSmall, left45 },
    {  15,  8,  8,  7, downHalfHelixSmall, left45 }, {  15,  9,  7,  7, downHalfHelixSmall, left45 }, {  15, 10,  7,  7, downHalfHelixSmall, left45 }, {  15, 11,  7,  7, downHalfHelixSmall, left45 },
    {  15, 12,  7,  7, downHalfHelixSmall, left45 }, {  14, 13,  7,  7, downHalfHelixSmall, left45 }, {  14, 14,  7,  6, downHalfHelixSmall, left45 }, {  14, 15,  7,  6, downHalfHelixSmall, left45 },
    {  13, 16,  7,  6, downHalfHelixSmall, left45 }, {  13, 17,  7,  6, downHalfHelixSmall, left45 }, {  13, 18,  6,  6, downHalfHelixSmall, left45 }, {  12, 19,  6,  6, downHalfHelixSmall, left45 },
    {  12, 20,  6,  6, downHalfHelixSmall, left45 }, {  11, 21,  6,  6, downHalfHelixSmall, left45 }, {  11, 22,  6,  6, downHalfHelixSmall, left45 }, {  10, 23,  6,  6, downHalfHelixSmall, left45 },
    {  10, 24,  6,  5, downHalfHelixSmall, left45 }, {   9, 25,  6,  5, downHalfHelixSmall, left45 }, {   9, 26,  5,  5, downHalfHelixSmall, left45 }, {   8, 27,  5,  5, downHalfHelixSmall, left45 },
    {   7, 28,  5,  5, downHalfHelixSmall, left45 }, {   7, 29,  5,  5, downHalfHelixSmall, left45 }, {   6, 30,  5,  5, downHalfHelixSmall, left45 }, {   5, 31,  5,  5, downHalfHelixSmall, left45 },
    {   4, 32,  5,  5, downHalfHelixSmall, left45 }, {   3, 33,  5,  4, downHalfHelixSmall, left45 }, {   3, 35,  5,  4, downHalfHelixSmall, left45 }, {   2, 36,  4,  4, downHalfHelixSmall, left45 },
    {   1, 37,  4,  4, downHalfHelixSmall, left45 }, {   0, 38,  4,  4, downHalfHelixSmall, left45 }, {  -1, 39,  4,  3, downHalfHelixSmall, left45 }, {  -2, 39,  4,  3, downHalfHelixSmall, left45 },
    {  -3, 40,  4,  3, downHalfHelixSmall, left45 }, {  -4, 41,  4,  3, downHalfHelixSmall, left45 }, {  -5, 41,  4,  3, downHalfHelixSmall, left45 }, {  -6, 42,  4,  3, downHalfHelixSmall, left45 },
    {  -7, 42,  3,  3, downHalfHelixSmall, left45 }, {  -8, 43,  3,  3, downHalfHelixSmall, left45 }, {  -9, 43,  3,  3, downHalfHelixSmall, left45 }, { -10, 44,  3,  2, downHalfHelixSmall, left45 },
    { -11, 44,  3,  2, downHalfHelixSmall, left45 }, { -12, 45,  3,  2, downHalfHelixSmall, left45 }, { -13, 45,  3,  2, downHalfHelixSmall, left45 }, { -14, 45,  3,  2, downHalfHelixSmall, left45 },
    { -15, 46,  2,  2, downHalfHelixSmall, left45 }, { -16, 46,  2,  2, downHalfHelixSmall, left45 }, { -17, 46,  2,  2, downHalfHelixSmall, left45 }, { -18, 47,  2,  2, downHalfHelixSmall, left45 },
    { -19, 47,  2,  2, downHalfHelixSmall, left45 }, { -20, 47,  2,  1, downHalfHelixSmall, left45 }, { -21, 47,  2,  1, downHalfHelixSmall, left45 }, { -22, 47,  2,  1, downHalfHelixSmall, left45 },
    { -23, 47,  2,  1, downHalfHelixSmall, left45 }, { -24, 48,  1,  1, downHalfHelixSmall, left45 }, { -25, 48,  1,  1, downHalfHelixSmall, left45 }, { -26, 48,  1,  1, downHalfHelixSmall, left45 },
    { -27, 48,  1,  1, downHalfHelixSmall, left45 }, { -28, 48,  1,  0, downHalfHelixSmall, left45 }, { -29, 48,  1,  0, downHalfHelixSmall, left45 }, { -30, 48,  1,  0, downHalfHelixSmall, left45 },
    { -31, 48,  1,  0, downHalfHelixSmall, left45 }, { -33, 48,  0,  0, downHalfHelixSmall, left45 }, { -34, 48,  0,  0, downHalfHelixSmall, left45 }, { -35, 48,  0,  0, downHalfHelixSmall, left45 },
    { -36, 48,  0,  0, downHalfHelixSmall, left45 }, { -37, 48,  0, 31, downHalfHelixSmall, left45 }, { -38, 48,  0, 31, downHalfHelixSmall, left45 }, { -39, 47,  0, 31, downHalfHelixSmall, left45 },
    { -40, 47,  0, 31, downHalfHelixSmall, left45 }, { -41, 47, -1, 31, downHalfHelixSmall, left45 }, { -42, 47, -1, 31, downHalfHelixSmall, left45 }, { -43, 47, -1, 31, downHalfHelixSmall, left45 },
    { -44, 47, -1, 31, downHalfHelixSmall, left45 }, { -45, 46, -1, 31, downHalfHelixSmall, left45 }, { -46, 46, -1, 30, downHalfHelixSmall, left45 }, { -47, 46, -1, 30, downHalfHelixSmall, left45 },
    { -48, 45, -1, 30, downHalfHelixSmall, left45 }, { -49, 45, -2, 30, downHalfHelixSmall, left45 }, { -50, 45, -2, 30, downHalfHelixSmall, left45 }, { -51, 44, -2, 30, downHalfHelixSmall, left45 },
    { -52, 44, -2, 30, downHalfHelixSmall, left45 }, { -53, 43, -2, 30, downHalfHelixSmall, left45 }, { -54, 43, -2, 30, downHalfHelixSmall, left45 }, { -55, 42, -2, 30, downHalfHelixSmall, left45 },
    { -56, 42, -2, 29, downHalfHelixSmall, left45 }, { -57, 41, -2, 29, downHalfHelixSmall, left45 }, { -58, 41, -3, 29, downHalfHelixSmall, left45 }, { -59, 40, -3, 29, downHalfHelixSmall, left45 },
    { -60, 39, -3, 29, downHalfHelixSmall, left45 }, { -61, 39, -3, 29, downHalfHelixSmall, left45 }, { -62, 38, -3, 29, downHalfHelixSmall, left45 }, { -63, 37, -3, 29, downHalfHelixSmall, left45 },
    { -64, 36, -3, 29, downHalfHelixSmall, left45 }, { -65, 35, -3, 28, downHalfHelixSmall, left45 }, { -67, 35, -4, 28, downHalfHelixSmall, left45 }, { -68, 34, -4, 28, downHalfHelixSmall, left45 },
    { -69, 33, -4, 28, downHalfHelixSmall, left45 }, { -70, 32, -4, 28, downHalfHelixSmall, left45 }, { -71, 31, -4, 27, downHalfHelixSmall, left45 }, { -71, 30, -4, 27, downHalfHelixSmall, left45 },
    { -72, 29, -4, 27, downHalfHelixSmall, left45 }, { -73, 28, -4, 27, downHalfHelixSmall, left45 }, { -73, 27, -4, 27, downHalfHelixSmall, left45 }, { -74, 26, -5, 27, downHalfHelixSmall, left45 },
    { -74, 25, -5, 27, downHalfHelixSmall, left45 }, { -75, 24, -5, 27, downHalfHelixSmall, left45 }, { -75, 23, -5, 27, downHalfHelixSmall, left45 }, { -76, 22, -5, 26, downHalfHelixSmall, left45 },
    { -76, 21, -5, 26, downHalfHelixSmall, left45 }, { -77, 20, -5, 26, downHalfHelixSmall, left45 }, { -77, 19, -5, 26, downHalfHelixSmall, left45 }, { -77, 18, -6, 26, downHalfHelixSmall, left45 },
    { -78, 17, -6, 26, downHalfHelixSmall, left45 }, { -78, 16, -6, 26, downHalfHelixSmall, left45 }, { -78, 15, -6, 26, downHalfHelixSmall, left45 }, { -79, 14, -6, 26, downHalfHelixSmall, left45 },
    { -79, 13, -6, 26, downHalfHelixSmall, left45 }, { -79, 12, -6, 25, downHalfHelixSmall, left45 }, { -79, 11, -6, 25, downHalfHelixSmall, left45 }, { -79, 10, -6, 25, downHalfHelixSmall, left45 },
    { -79,  9, -7, 25, downHalfHelixSmall, left45 }, { -80,  8, -7, 25, downHalfHelixSmall, left45 }, { -80,  7, -7, 25, downHalfHelixSmall, left45 }, { -80,  6, -7, 25, downHalfHelixSmall, left45 },
    { -80,  5, -7, 25, downHalfHelixSmall, left45 }, { -80,  4, -7, 24, downHalfHelixSmall, left45 }, { -80,  3, -7, 24, downHalfHelixSmall, left45 }, { -80,  2, -7, 24, downHalfHelixSmall, left45 },
    { -80,  1, -8, 24, downHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FBC66, {
    {  0,  16,  8, 16, downHalfHelixSmall, left45 }, {  1,  16,  8, 16, downHalfHelixSmall, left45 }, {  2,  16,  8, 16, downHalfHelixSmall, left45 }, {  3,  16,  8, 16, downHalfHelixSmall, left45 },
    {  4,  16,  8, 16, downHalfHelixSmall, left45 }, {  5,  16,  8, 15, downHalfHelixSmall, left45 }, {  6,  16,  8, 15, downHalfHelixSmall, left45 }, {  7,  17,  8, 15, downHalfHelixSmall, left45 },
    {  8,  17,  8, 15, downHalfHelixSmall, left45 }, {  9,  17,  7, 15, downHalfHelixSmall, left45 }, { 10,  17,  7, 15, downHalfHelixSmall, left45 }, { 11,  17,  7, 15, downHalfHelixSmall, left45 },
    { 12,  17,  7, 15, downHalfHelixSmall, left45 }, { 13,  18,  7, 15, downHalfHelixSmall, left45 }, { 14,  18,  7, 14, downHalfHelixSmall, left45 }, { 15,  18,  7, 14, downHalfHelixSmall, left45 },
    { 16,  19,  7, 14, downHalfHelixSmall, left45 }, { 17,  19,  6, 14, downHalfHelixSmall, left45 }, { 18,  19,  6, 14, downHalfHelixSmall, left45 }, { 19,  20,  6, 14, downHalfHelixSmall, left45 },
    { 20,  20,  6, 14, downHalfHelixSmall, left45 }, { 21,  21,  6, 14, downHalfHelixSmall, left45 }, { 22,  21,  6, 14, downHalfHelixSmall, left45 }, { 23,  22,  6, 14, downHalfHelixSmall, left45 },
    { 24,  22,  6, 13, downHalfHelixSmall, left45 }, { 25,  23,  6, 13, downHalfHelixSmall, left45 }, { 26,  23,  5, 13, downHalfHelixSmall, left45 }, { 27,  24,  5, 13, downHalfHelixSmall, left45 },
    { 28,  25,  5, 13, downHalfHelixSmall, left45 }, { 29,  25,  5, 13, downHalfHelixSmall, left45 }, { 30,  26,  5, 13, downHalfHelixSmall, left45 }, { 31,  27,  5, 13, downHalfHelixSmall, left45 },
    { 32,  28,  5, 13, downHalfHelixSmall, left45 }, { 33,  29,  5, 12, downHalfHelixSmall, left45 }, { 35,  29,  4, 12, downHalfHelixSmall, left45 }, { 36,  30,  4, 12, downHalfHelixSmall, left45 },
    { 37,  31,  4, 12, downHalfHelixSmall, left45 }, { 38,  32,  4, 12, downHalfHelixSmall, left45 }, { 39,  33,  4, 11, downHalfHelixSmall, left45 }, { 39,  34,  4, 11, downHalfHelixSmall, left45 },
    { 40,  35,  4, 11, downHalfHelixSmall, left45 }, { 41,  36,  4, 11, downHalfHelixSmall, left45 }, { 41,  37,  4, 11, downHalfHelixSmall, left45 }, { 42,  38,  3, 11, downHalfHelixSmall, left45 },
    { 42,  39,  3, 11, downHalfHelixSmall, left45 }, { 43,  40,  3, 11, downHalfHelixSmall, left45 }, { 43,  41,  3, 11, downHalfHelixSmall, left45 }, { 44,  42,  3, 10, downHalfHelixSmall, left45 },
    { 44,  43,  3, 10, downHalfHelixSmall, left45 }, { 45,  44,  3, 10, downHalfHelixSmall, left45 }, { 45,  45,  3, 10, downHalfHelixSmall, left45 }, { 45,  46,  2, 10, downHalfHelixSmall, left45 },
    { 46,  47,  2, 10, downHalfHelixSmall, left45 }, { 46,  48,  2, 10, downHalfHelixSmall, left45 }, { 46,  49,  2, 10, downHalfHelixSmall, left45 }, { 47,  50,  2, 10, downHalfHelixSmall, left45 },
    { 47,  51,  2, 10, downHalfHelixSmall, left45 }, { 47,  52,  2,  9, downHalfHelixSmall, left45 }, { 47,  53,  2,  9, downHalfHelixSmall, left45 }, { 47,  54,  2,  9, downHalfHelixSmall, left45 },
    { 47,  55,  1,  9, downHalfHelixSmall, left45 }, { 48,  56,  1,  9, downHalfHelixSmall, left45 }, { 48,  57,  1,  9, downHalfHelixSmall, left45 }, { 48,  58,  1,  9, downHalfHelixSmall, left45 },
    { 48,  59,  1,  9, downHalfHelixSmall, left45 }, { 48,  60,  1,  8, downHalfHelixSmall, left45 }, { 48,  61,  1,  8, downHalfHelixSmall, left45 }, { 48,  62,  1,  8, downHalfHelixSmall, left45 },
    { 48,  64,  0,  8, downHalfHelixSmall, left45 }, { 48,  65,  0,  8, downHalfHelixSmall, left45 }, { 48,  66,  0,  8, downHalfHelixSmall, left45 }, { 48,  67,  0,  8, downHalfHelixSmall, left45 },
    { 48,  68,  0,  8, downHalfHelixSmall, left45 }, { 48,  69,  0,  7, downHalfHelixSmall, left45 }, { 48,  70,  0,  7, downHalfHelixSmall, left45 }, { 47,  71,  0,  7, downHalfHelixSmall, left45 },
    { 47,  72,  0,  7, downHalfHelixSmall, left45 }, { 47,  73, -1,  7, downHalfHelixSmall, left45 }, { 47,  74, -1,  7, downHalfHelixSmall, left45 }, { 47,  75, -1,  7, downHalfHelixSmall, left45 },
    { 47,  76, -1,  7, downHalfHelixSmall, left45 }, { 46,  77, -1,  7, downHalfHelixSmall, left45 }, { 46,  78, -1,  6, downHalfHelixSmall, left45 }, { 46,  79, -1,  6, downHalfHelixSmall, left45 },
    { 45,  80, -1,  6, downHalfHelixSmall, left45 }, { 45,  81, -1,  6, downHalfHelixSmall, left45 }, { 45,  82, -2,  6, downHalfHelixSmall, left45 }, { 44,  83, -2,  6, downHalfHelixSmall, left45 },
    { 44,  84, -2,  6, downHalfHelixSmall, left45 }, { 43,  85, -2,  6, downHalfHelixSmall, left45 }, { 43,  86, -2,  6, downHalfHelixSmall, left45 }, { 42,  87, -2,  6, downHalfHelixSmall, left45 },
    { 42,  88, -2,  5, downHalfHelixSmall, left45 }, { 41,  89, -2,  5, downHalfHelixSmall, left45 }, { 41,  90, -3,  5, downHalfHelixSmall, left45 }, { 40,  91, -3,  5, downHalfHelixSmall, left45 },
    { 39,  92, -3,  5, downHalfHelixSmall, left45 }, { 39,  93, -3,  5, downHalfHelixSmall, left45 }, { 38,  94, -3,  5, downHalfHelixSmall, left45 }, { 37,  95, -3,  5, downHalfHelixSmall, left45 },
    { 36,  96, -3,  5, downHalfHelixSmall, left45 }, { 35,  97, -3,  4, downHalfHelixSmall, left45 }, { 35,  99, -3,  4, downHalfHelixSmall, left45 }, { 34, 100, -4,  4, downHalfHelixSmall, left45 },
    { 33, 101, -4,  4, downHalfHelixSmall, left45 }, { 32, 102, -4,  4, downHalfHelixSmall, left45 }, { 31, 103, -4,  3, downHalfHelixSmall, left45 }, { 30, 103, -4,  3, downHalfHelixSmall, left45 },
    { 29, 104, -4,  3, downHalfHelixSmall, left45 }, { 28, 105, -4,  3, downHalfHelixSmall, left45 }, { 27, 105, -4,  3, downHalfHelixSmall, left45 }, { 26, 106, -4,  3, downHalfHelixSmall, left45 },
    { 25, 106, -5,  3, downHalfHelixSmall, left45 }, { 24, 107, -5,  3, downHalfHelixSmall, left45 }, { 23, 107, -5,  3, downHalfHelixSmall, left45 }, { 22, 108, -5,  2, downHalfHelixSmall, left45 },
    { 21, 108, -5,  2, downHalfHelixSmall, left45 }, { 20, 109, -5,  2, downHalfHelixSmall, left45 }, { 19, 109, -5,  2, downHalfHelixSmall, left45 }, { 18, 109, -5,  2, downHalfHelixSmall, left45 },
    { 17, 110, -6,  2, downHalfHelixSmall, left45 }, { 16, 110, -6,  2, downHalfHelixSmall, left45 }, { 15, 110, -6,  2, downHalfHelixSmall, left45 }, { 14, 111, -6,  2, downHalfHelixSmall, left45 },
    { 13, 111, -6,  2, downHalfHelixSmall, left45 }, { 12, 111, -6,  1, downHalfHelixSmall, left45 }, { 11, 111, -6,  1, downHalfHelixSmall, left45 }, { 10, 111, -6,  1, downHalfHelixSmall, left45 },
    {  9, 111, -6,  1, downHalfHelixSmall, left45 }, {  8, 112, -7,  1, downHalfHelixSmall, left45 }, {  7, 112, -7,  1, downHalfHelixSmall, left45 }, {  6, 112, -7,  1, downHalfHelixSmall, left45 },
    {  5, 112, -7,  1, downHalfHelixSmall, left45 }, {  4, 112, -7,  0, downHalfHelixSmall, left45 }, {  3, 112, -7,  0, downHalfHelixSmall, left45 }, {  2, 112, -7,  0, downHalfHelixSmall, left45 },
    {  1, 112, -7,  0, downHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FC139, {
    {  16,  31,  8, 24, downHalfHelixSmall, left45 }, {  16,  30,  8, 24, downHalfHelixSmall, left45 }, {  16,  29,  8, 24, downHalfHelixSmall, left45 }, {  16,  28,  8, 24, downHalfHelixSmall, left45 },
    {  16,  27,  8, 23, downHalfHelixSmall, left45 }, {  16,  26,  8, 23, downHalfHelixSmall, left45 }, {  17,  25,  8, 23, downHalfHelixSmall, left45 }, {  17,  24,  8, 23, downHalfHelixSmall, left45 },
    {  17,  23,  7, 23, downHalfHelixSmall, left45 }, {  17,  22,  7, 23, downHalfHelixSmall, left45 }, {  17,  21,  7, 23, downHalfHelixSmall, left45 }, {  17,  20,  7, 23, downHalfHelixSmall, left45 },
    {  18,  19,  7, 23, downHalfHelixSmall, left45 }, {  18,  18,  7, 22, downHalfHelixSmall, left45 }, {  18,  17,  7, 22, downHalfHelixSmall, left45 }, {  19,  16,  7, 22, downHalfHelixSmall, left45 },
    {  19,  15,  6, 22, downHalfHelixSmall, left45 }, {  19,  14,  6, 22, downHalfHelixSmall, left45 }, {  20,  13,  6, 22, downHalfHelixSmall, left45 }, {  20,  12,  6, 22, downHalfHelixSmall, left45 },
    {  21,  11,  6, 22, downHalfHelixSmall, left45 }, {  21,  10,  6, 22, downHalfHelixSmall, left45 }, {  22,   9,  6, 22, downHalfHelixSmall, left45 }, {  22,   8,  6, 21, downHalfHelixSmall, left45 },
    {  23,   7,  6, 21, downHalfHelixSmall, left45 }, {  23,   6,  5, 21, downHalfHelixSmall, left45 }, {  24,   5,  5, 21, downHalfHelixSmall, left45 }, {  25,   4,  5, 21, downHalfHelixSmall, left45 },
    {  25,   3,  5, 21, downHalfHelixSmall, left45 }, {  26,   2,  5, 21, downHalfHelixSmall, left45 }, {  27,   1,  5, 21, downHalfHelixSmall, left45 }, {  28,   0,  5, 21, downHalfHelixSmall, left45 },
    {  29,  -1,  5, 20, downHalfHelixSmall, left45 }, {  29,  -3,  4, 20, downHalfHelixSmall, left45 }, {  30,  -4,  4, 20, downHalfHelixSmall, left45 }, {  31,  -5,  4, 20, downHalfHelixSmall, left45 },
    {  32,  -6,  4, 20, downHalfHelixSmall, left45 }, {  33,  -7,  4, 19, downHalfHelixSmall, left45 }, {  34,  -7,  4, 19, downHalfHelixSmall, left45 }, {  35,  -8,  4, 19, downHalfHelixSmall, left45 },
    {  36,  -9,  4, 19, downHalfHelixSmall, left45 }, {  37,  -9,  3, 19, downHalfHelixSmall, left45 }, {  38, -10,  3, 19, downHalfHelixSmall, left45 }, {  39, -10,  3, 19, downHalfHelixSmall, left45 },
    {  40, -11,  3, 19, downHalfHelixSmall, left45 }, {  41, -11,  3, 19, downHalfHelixSmall, left45 }, {  42, -12,  3, 18, downHalfHelixSmall, left45 }, {  43, -12,  3, 18, downHalfHelixSmall, left45 },
    {  44, -13,  3, 18, downHalfHelixSmall, left45 }, {  45, -13,  3, 18, downHalfHelixSmall, left45 }, {  46, -13,  2, 18, downHalfHelixSmall, left45 }, {  47, -14,  2, 18, downHalfHelixSmall, left45 },
    {  48, -14,  2, 18, downHalfHelixSmall, left45 }, {  49, -14,  2, 18, downHalfHelixSmall, left45 }, {  50, -15,  2, 18, downHalfHelixSmall, left45 }, {  51, -15,  2, 18, downHalfHelixSmall, left45 },
    {  52, -15,  2, 17, downHalfHelixSmall, left45 }, {  53, -15,  2, 17, downHalfHelixSmall, left45 }, {  54, -15,  1, 17, downHalfHelixSmall, left45 }, {  55, -15,  1, 17, downHalfHelixSmall, left45 },
    {  56, -16,  1, 17, downHalfHelixSmall, left45 }, {  57, -16,  1, 17, downHalfHelixSmall, left45 }, {  58, -16,  1, 17, downHalfHelixSmall, left45 }, {  59, -16,  1, 17, downHalfHelixSmall, left45 },
    {  60, -16,  1, 16, downHalfHelixSmall, left45 }, {  61, -16,  1, 16, downHalfHelixSmall, left45 }, {  62, -16,  0, 16, downHalfHelixSmall, left45 }, {  64, -16,  0, 16, downHalfHelixSmall, left45 },
    {  65, -16,  0, 16, downHalfHelixSmall, left45 }, {  66, -16,  0, 16, downHalfHelixSmall, left45 }, {  67, -16,  0, 16, downHalfHelixSmall, left45 }, {  68, -16,  0, 16, downHalfHelixSmall, left45 },
    {  69, -16,  0, 15, downHalfHelixSmall, left45 }, {  70, -16,  0, 15, downHalfHelixSmall, left45 }, {  71, -15,  0, 15, downHalfHelixSmall, left45 }, {  72, -15,  0, 15, downHalfHelixSmall, left45 },
    {  73, -15, -1, 15, downHalfHelixSmall, left45 }, {  74, -15, -1, 15, downHalfHelixSmall, left45 }, {  75, -15, -1, 15, downHalfHelixSmall, left45 }, {  76, -15, -1, 15, downHalfHelixSmall, left45 },
    {  77, -14, -1, 15, downHalfHelixSmall, left45 }, {  78, -14, -1, 14, downHalfHelixSmall, left45 }, {  79, -14, -1, 14, downHalfHelixSmall, left45 }, {  80, -13, -1, 14, downHalfHelixSmall, left45 },
    {  81, -13, -2, 14, downHalfHelixSmall, left45 }, {  82, -13, -2, 14, downHalfHelixSmall, left45 }, {  83, -12, -2, 14, downHalfHelixSmall, left45 }, {  84, -12, -2, 14, downHalfHelixSmall, left45 },
    {  85, -11, -2, 14, downHalfHelixSmall, left45 }, {  86, -11, -2, 14, downHalfHelixSmall, left45 }, {  87, -10, -2, 14, downHalfHelixSmall, left45 }, {  88, -10, -2, 13, downHalfHelixSmall, left45 },
    {  89,  -9, -2, 13, downHalfHelixSmall, left45 }, {  90,  -9, -3, 13, downHalfHelixSmall, left45 }, {  91,  -8, -3, 13, downHalfHelixSmall, left45 }, {  92,  -7, -3, 13, downHalfHelixSmall, left45 },
    {  93,  -7, -3, 13, downHalfHelixSmall, left45 }, {  94,  -6, -3, 13, downHalfHelixSmall, left45 }, {  95,  -5, -3, 13, downHalfHelixSmall, left45 }, {  96,  -4, -3, 13, downHalfHelixSmall, left45 },
    {  97,  -3, -3, 12, downHalfHelixSmall, left45 }, {  99,  -3, -4, 12, downHalfHelixSmall, left45 }, { 100,  -2, -4, 12, downHalfHelixSmall, left45 }, { 101,  -1, -4, 12, downHalfHelixSmall, left45 },
    { 102,   0, -4, 12, downHalfHelixSmall, left45 }, { 103,   1, -4, 11, downHalfHelixSmall, left45 }, { 103,   2, -4, 11, downHalfHelixSmall, left45 }, { 104,   3, -4, 11, downHalfHelixSmall, left45 },
    { 105,   4, -4, 11, downHalfHelixSmall, left45 }, { 105,   5, -4, 11, downHalfHelixSmall, left45 }, { 106,   6, -5, 11, downHalfHelixSmall, left45 }, { 106,   7, -5, 11, downHalfHelixSmall, left45 },
    { 107,   8, -5, 11, downHalfHelixSmall, left45 }, { 107,   9, -5, 11, downHalfHelixSmall, left45 }, { 108,  10, -5, 10, downHalfHelixSmall, left45 }, { 108,  11, -5, 10, downHalfHelixSmall, left45 },
    { 109,  12, -5, 10, downHalfHelixSmall, left45 }, { 109,  13, -5, 10, downHalfHelixSmall, left45 }, { 109,  14, -6, 10, downHalfHelixSmall, left45 }, { 110,  15, -6, 10, downHalfHelixSmall, left45 },
    { 110,  16, -6, 10, downHalfHelixSmall, left45 }, { 110,  17, -6, 10, downHalfHelixSmall, left45 }, { 111,  18, -6, 10, downHalfHelixSmall, left45 }, { 111,  19, -6, 10, downHalfHelixSmall, left45 },
    { 111,  20, -6,  9, downHalfHelixSmall, left45 }, { 111,  21, -6,  9, downHalfHelixSmall, left45 }, { 111,  22, -6,  9, downHalfHelixSmall, left45 }, { 111,  23, -7,  9, downHalfHelixSmall, left45 },
    { 112,  24, -7,  9, downHalfHelixSmall, left45 }, { 112,  25, -7,  9, downHalfHelixSmall, left45 }, { 112,  26, -7,  9, downHalfHelixSmall, left45 }, { 112,  27, -7,  9, downHalfHelixSmall, left45 },
    { 112,  28, -7,  8, downHalfHelixSmall, left45 }, { 112,  29, -7,  8, downHalfHelixSmall, left45 }, { 112,  30, -7,  8, downHalfHelixSmall, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FC5FA, {
    {  31,  16,  8,  0, downHalfHelixSmall, right45 }, {  30,  16,  8,  0, downHalfHelixSmall, right45 }, {  29,  16,  8,  0, downHalfHelixSmall, right45 },
    {  28,  16,  8,  0, downHalfHelixSmall, right45 }, {  27,  16,  8,  1, downHalfHelixSmall, right45 }, {  26,  16,  8,  1, downHalfHelixSmall, right45 },
    {  25,  17,  8,  1, downHalfHelixSmall, right45 }, {  24,  17,  8,  1, downHalfHelixSmall, right45 }, {  23,  17,  7,  1, downHalfHelixSmall, right45 },
    {  22,  17,  7,  1, downHalfHelixSmall, right45 }, {  21,  17,  7,  1, downHalfHelixSmall, right45 }, {  20,  17,  7,  1, downHalfHelixSmall, right45 },
    {  19,  18,  7,  1, downHalfHelixSmall, right45 }, {  18,  18,  7,  2, downHalfHelixSmall, right45 }, {  17,  18,  7,  2, downHalfHelixSmall, right45 },
    {  16,  19,  7,  2, downHalfHelixSmall, right45 }, {  15,  19,  6,  2, downHalfHelixSmall, right45 }, {  14,  19,  6,  2, downHalfHelixSmall, right45 },
    {  13,  20,  6,  2, downHalfHelixSmall, right45 }, {  12,  20,  6,  2, downHalfHelixSmall, right45 }, {  11,  21,  6,  2, downHalfHelixSmall, right45 },
    {  10,  21,  6,  2, downHalfHelixSmall, right45 }, {   9,  22,  6,  2, downHalfHelixSmall, right45 }, {   8,  22,  6,  3, downHalfHelixSmall, right45 },
    {   7,  23,  6,  3, downHalfHelixSmall, right45 }, {   6,  23,  5,  3, downHalfHelixSmall, right45 }, {   5,  24,  5,  3, downHalfHelixSmall, right45 },
    {   4,  25,  5,  3, downHalfHelixSmall, right45 }, {   3,  25,  5,  3, downHalfHelixSmall, right45 }, {   2,  26,  5,  3, downHalfHelixSmall, right45 },
    {   1,  27,  5,  3, downHalfHelixSmall, right45 }, {   0,  28,  5,  3, downHalfHelixSmall, right45 }, {  -1,  29,  5,  4, downHalfHelixSmall, right45 },
    {  -3,  29,  4,  4, downHalfHelixSmall, right45 }, {  -4,  30,  4,  4, downHalfHelixSmall, right45 }, {  -5,  31,  4,  4, downHalfHelixSmall, right45 },
    {  -6,  32,  4,  4, downHalfHelixSmall, right45 }, {  -7,  33,  4,  5, downHalfHelixSmall, right45 }, {  -7,  34,  4,  5, downHalfHelixSmall, right45 },
    {  -8,  35,  4,  5, downHalfHelixSmall, right45 }, {  -9,  36,  4,  5, downHalfHelixSmall, right45 }, {  -9,  37,  3,  5, downHalfHelixSmall, right45 },
    { -10,  38,  3,  5, downHalfHelixSmall, right45 }, { -10,  39,  3,  5, downHalfHelixSmall, right45 }, { -11,  40,  3,  5, downHalfHelixSmall, right45 },
    { -11,  41,  3,  5, downHalfHelixSmall, right45 }, { -12,  42,  3,  6, downHalfHelixSmall, right45 }, { -12,  43,  3,  6, downHalfHelixSmall, right45 },
    { -13,  44,  3,  6, downHalfHelixSmall, right45 }, { -13,  45,  3,  6, downHalfHelixSmall, right45 }, { -13,  46,  2,  6, downHalfHelixSmall, right45 },
    { -14,  47,  2,  6, downHalfHelixSmall, right45 }, { -14,  48,  2,  6, downHalfHelixSmall, right45 }, { -14,  49,  2,  6, downHalfHelixSmall, right45 },
    { -15,  50,  2,  6, downHalfHelixSmall, right45 }, { -15,  51,  2,  6, downHalfHelixSmall, right45 }, { -15,  52,  2,  7, downHalfHelixSmall, right45 },
    { -15,  53,  2,  7, downHalfHelixSmall, right45 }, { -15,  54,  1,  7, downHalfHelixSmall, right45 }, { -15,  55,  1,  7, downHalfHelixSmall, right45 },
    { -16,  56,  1,  7, downHalfHelixSmall, right45 }, { -16,  57,  1,  7, downHalfHelixSmall, right45 }, { -16,  58,  1,  7, downHalfHelixSmall, right45 },
    { -16,  59,  1,  7, downHalfHelixSmall, right45 }, { -16,  60,  1,  8, downHalfHelixSmall, right45 }, { -16,  61,  1,  8, downHalfHelixSmall, right45 },
    { -16,  62,  0,  8, downHalfHelixSmall, right45 }, { -16,  64,  0,  8, downHalfHelixSmall, right45 }, { -16,  65,  0,  8, downHalfHelixSmall, right45 },
    { -16,  66,  0,  8, downHalfHelixSmall, right45 }, { -16,  67,  0,  8, downHalfHelixSmall, right45 }, { -16,  68,  0,  8, downHalfHelixSmall, right45 },
    { -16,  69,  0,  9, downHalfHelixSmall, right45 }, { -16,  70,  0,  9, downHalfHelixSmall, right45 }, { -15,  71,  0,  9, downHalfHelixSmall, right45 },
    { -15,  72,  0,  9, downHalfHelixSmall, right45 }, { -15,  73, -1,  9, downHalfHelixSmall, right45 }, { -15,  74, -1,  9, downHalfHelixSmall, right45 },
    { -15,  75, -1,  9, downHalfHelixSmall, right45 }, { -15,  76, -1,  9, downHalfHelixSmall, right45 }, { -14,  77, -1,  9, downHalfHelixSmall, right45 },
    { -14,  78, -1, 10, downHalfHelixSmall, right45 }, { -14,  79, -1, 10, downHalfHelixSmall, right45 }, { -13,  80, -1, 10, downHalfHelixSmall, right45 },
    { -13,  81, -2, 10, downHalfHelixSmall, right45 }, { -13,  82, -2, 10, downHalfHelixSmall, right45 }, { -12,  83, -2, 10, downHalfHelixSmall, right45 },
    { -12,  84, -2, 10, downHalfHelixSmall, right45 }, { -11,  85, -2, 10, downHalfHelixSmall, right45 }, { -11,  86, -2, 10, downHalfHelixSmall, right45 },
    { -10,  87, -2, 10, downHalfHelixSmall, right45 }, { -10,  88, -2, 11, downHalfHelixSmall, right45 }, {  -9,  89, -2, 11, downHalfHelixSmall, right45 },
    {  -9,  90, -3, 11, downHalfHelixSmall, right45 }, {  -8,  91, -3, 11, downHalfHelixSmall, right45 }, {  -7,  92, -3, 11, downHalfHelixSmall, right45 },
    {  -7,  93, -3, 11, downHalfHelixSmall, right45 }, {  -6,  94, -3, 11, downHalfHelixSmall, right45 }, {  -5,  95, -3, 11, downHalfHelixSmall, right45 },
    {  -4,  96, -3, 11, downHalfHelixSmall, right45 }, {  -3,  97, -3, 12, downHalfHelixSmall, right45 }, {  -3,  99, -4, 12, downHalfHelixSmall, right45 },
    {  -2, 100, -4, 12, downHalfHelixSmall, right45 }, {  -1, 101, -4, 12, downHalfHelixSmall, right45 }, {   0, 102, -4, 12, downHalfHelixSmall, right45 },
    {   1, 103, -4, 13, downHalfHelixSmall, right45 }, {   2, 103, -4, 13, downHalfHelixSmall, right45 }, {   3, 104, -4, 13, downHalfHelixSmall, right45 },
    {   4, 105, -4, 13, downHalfHelixSmall, right45 }, {   5, 105, -4, 13, downHalfHelixSmall, right45 }, {   6, 106, -5, 13, downHalfHelixSmall, right45 },
    {   7, 106, -5, 13, downHalfHelixSmall, right45 }, {   8, 107, -5, 13, downHalfHelixSmall, right45 }, {   9, 107, -5, 13, downHalfHelixSmall, right45 },
    {  10, 108, -5, 14, downHalfHelixSmall, right45 }, {  11, 108, -5, 14, downHalfHelixSmall, right45 }, {  12, 109, -5, 14, downHalfHelixSmall, right45 },
    {  13, 109, -5, 14, downHalfHelixSmall, right45 }, {  14, 109, -6, 14, downHalfHelixSmall, right45 }, {  15, 110, -6, 14, downHalfHelixSmall, right45 },
    {  16, 110, -6, 14, downHalfHelixSmall, right45 }, {  17, 110, -6, 14, downHalfHelixSmall, right45 }, {  18, 111, -6, 14, downHalfHelixSmall, right45 },
    {  19, 111, -6, 14, downHalfHelixSmall, right45 }, {  20, 111, -6, 15, downHalfHelixSmall, right45 }, {  21, 111, -6, 15, downHalfHelixSmall, right45 },
    {  22, 111, -6, 15, downHalfHelixSmall, right45 }, {  23, 111, -7, 15, downHalfHelixSmall, right45 }, {  24, 112, -7, 15, downHalfHelixSmall, right45 },
    {  25, 112, -7, 15, downHalfHelixSmall, right45 }, {  26, 112, -7, 15, downHalfHelixSmall, right45 }, {  27, 112, -7, 15, downHalfHelixSmall, right45 },
    {  28, 112, -7, 16, downHalfHelixSmall, right45 }, {  29, 112, -7, 16, downHalfHelixSmall, right45 }, {  30, 112, -7, 16, downHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FCABB, {
    {  16,  0,  8,  8, downHalfHelixSmall, right45 }, {  16,  1,  8,  8, downHalfHelixSmall, right45 }, {  16,  2,  8,  8, downHalfHelixSmall, right45 },
    {  16,  3,  8,  8, downHalfHelixSmall, right45 }, {  16,  4,  8,  8, downHalfHelixSmall, right45 }, {  16,  5,  8,  9, downHalfHelixSmall, right45 },
    {  16,  6,  8,  9, downHalfHelixSmall, right45 }, {  17,  7,  8,  9, downHalfHelixSmall, right45 }, {  17,  8,  8,  9, downHalfHelixSmall, right45 },
    {  17,  9,  7,  9, downHalfHelixSmall, right45 }, {  17, 10,  7,  9, downHalfHelixSmall, right45 }, {  17, 11,  7,  9, downHalfHelixSmall, right45 },
    {  17, 12,  7,  9, downHalfHelixSmall, right45 }, {  18, 13,  7,  9, downHalfHelixSmall, right45 }, {  18, 14,  7, 10, downHalfHelixSmall, right45 },
    {  18, 15,  7, 10, downHalfHelixSmall, right45 }, {  19, 16,  7, 10, downHalfHelixSmall, right45 }, {  19, 17,  6, 10, downHalfHelixSmall, right45 },
    {  19, 18,  6, 10, downHalfHelixSmall, right45 }, {  20, 19,  6, 10, downHalfHelixSmall, right45 }, {  20, 20,  6, 10, downHalfHelixSmall, right45 },
    {  21, 21,  6, 10, downHalfHelixSmall, right45 }, {  21, 22,  6, 10, downHalfHelixSmall, right45 }, {  22, 23,  6, 10, downHalfHelixSmall, right45 },
    {  22, 24,  6, 11, downHalfHelixSmall, right45 }, {  23, 25,  6, 11, downHalfHelixSmall, right45 }, {  23, 26,  5, 11, downHalfHelixSmall, right45 },
    {  24, 27,  5, 11, downHalfHelixSmall, right45 }, {  25, 28,  5, 11, downHalfHelixSmall, right45 }, {  25, 29,  5, 11, downHalfHelixSmall, right45 },
    {  26, 30,  5, 11, downHalfHelixSmall, right45 }, {  27, 31,  5, 11, downHalfHelixSmall, right45 }, {  28, 32,  5, 11, downHalfHelixSmall, right45 },
    {  29, 33,  5, 12, downHalfHelixSmall, right45 }, {  29, 35,  4, 12, downHalfHelixSmall, right45 }, {  30, 36,  4, 12, downHalfHelixSmall, right45 },
    {  31, 37,  4, 12, downHalfHelixSmall, right45 }, {  32, 38,  4, 12, downHalfHelixSmall, right45 }, {  33, 39,  4, 13, downHalfHelixSmall, right45 },
    {  34, 39,  4, 13, downHalfHelixSmall, right45 }, {  35, 40,  4, 13, downHalfHelixSmall, right45 }, {  36, 41,  4, 13, downHalfHelixSmall, right45 },
    {  37, 41,  4, 13, downHalfHelixSmall, right45 }, {  38, 42,  3, 13, downHalfHelixSmall, right45 }, {  39, 42,  3, 13, downHalfHelixSmall, right45 },
    {  40, 43,  3, 13, downHalfHelixSmall, right45 }, {  41, 43,  3, 13, downHalfHelixSmall, right45 }, {  42, 44,  3, 14, downHalfHelixSmall, right45 },
    {  43, 44,  3, 14, downHalfHelixSmall, right45 }, {  44, 45,  3, 14, downHalfHelixSmall, right45 }, {  45, 45,  3, 14, downHalfHelixSmall, right45 },
    {  46, 45,  2, 14, downHalfHelixSmall, right45 }, {  47, 46,  2, 14, downHalfHelixSmall, right45 }, {  48, 46,  2, 14, downHalfHelixSmall, right45 },
    {  49, 46,  2, 14, downHalfHelixSmall, right45 }, {  50, 47,  2, 14, downHalfHelixSmall, right45 }, {  51, 47,  2, 14, downHalfHelixSmall, right45 },
    {  52, 47,  2, 15, downHalfHelixSmall, right45 }, {  53, 47,  2, 15, downHalfHelixSmall, right45 }, {  54, 47,  2, 15, downHalfHelixSmall, right45 },
    {  55, 47,  1, 15, downHalfHelixSmall, right45 }, {  56, 48,  1, 15, downHalfHelixSmall, right45 }, {  57, 48,  1, 15, downHalfHelixSmall, right45 },
    {  58, 48,  1, 15, downHalfHelixSmall, right45 }, {  59, 48,  1, 15, downHalfHelixSmall, right45 }, {  60, 48,  1, 16, downHalfHelixSmall, right45 },
    {  61, 48,  1, 16, downHalfHelixSmall, right45 }, {  62, 48,  1, 16, downHalfHelixSmall, right45 }, {  64, 48,  0, 16, downHalfHelixSmall, right45 },
    {  65, 48,  0, 16, downHalfHelixSmall, right45 }, {  66, 48,  0, 16, downHalfHelixSmall, right45 }, {  67, 48,  0, 16, downHalfHelixSmall, right45 },
    {  68, 48,  0, 16, downHalfHelixSmall, right45 }, {  69, 48,  0, 17, downHalfHelixSmall, right45 }, {  70, 48,  0, 17, downHalfHelixSmall, right45 },
    {  71, 47,  0, 17, downHalfHelixSmall, right45 }, {  72, 47,  0, 17, downHalfHelixSmall, right45 }, {  73, 47, -1, 17, downHalfHelixSmall, right45 },
    {  74, 47, -1, 17, downHalfHelixSmall, right45 }, {  75, 47, -1, 17, downHalfHelixSmall, right45 }, {  76, 47, -1, 17, downHalfHelixSmall, right45 },
    {  77, 46, -1, 17, downHalfHelixSmall, right45 }, {  78, 46, -1, 18, downHalfHelixSmall, right45 }, {  79, 46, -1, 18, downHalfHelixSmall, right45 },
    {  80, 45, -1, 18, downHalfHelixSmall, right45 }, {  81, 45, -1, 18, downHalfHelixSmall, right45 }, {  82, 45, -2, 18, downHalfHelixSmall, right45 },
    {  83, 44, -2, 18, downHalfHelixSmall, right45 }, {  84, 44, -2, 18, downHalfHelixSmall, right45 }, {  85, 43, -2, 18, downHalfHelixSmall, right45 },
    {  86, 43, -2, 18, downHalfHelixSmall, right45 }, {  87, 42, -2, 18, downHalfHelixSmall, right45 }, {  88, 42, -2, 19, downHalfHelixSmall, right45 },
    {  89, 41, -2, 19, downHalfHelixSmall, right45 }, {  90, 41, -3, 19, downHalfHelixSmall, right45 }, {  91, 40, -3, 19, downHalfHelixSmall, right45 },
    {  92, 39, -3, 19, downHalfHelixSmall, right45 }, {  93, 39, -3, 19, downHalfHelixSmall, right45 }, {  94, 38, -3, 19, downHalfHelixSmall, right45 },
    {  95, 37, -3, 19, downHalfHelixSmall, right45 }, {  96, 36, -3, 19, downHalfHelixSmall, right45 }, {  97, 35, -3, 20, downHalfHelixSmall, right45 },
    {  99, 35, -3, 20, downHalfHelixSmall, right45 }, { 100, 34, -4, 20, downHalfHelixSmall, right45 }, { 101, 33, -4, 20, downHalfHelixSmall, right45 },
    { 102, 32, -4, 20, downHalfHelixSmall, right45 }, { 103, 31, -4, 21, downHalfHelixSmall, right45 }, { 103, 30, -4, 21, downHalfHelixSmall, right45 },
    { 104, 29, -4, 21, downHalfHelixSmall, right45 }, { 105, 28, -4, 21, downHalfHelixSmall, right45 }, { 105, 27, -4, 21, downHalfHelixSmall, right45 },
    { 106, 26, -4, 21, downHalfHelixSmall, right45 }, { 106, 25, -5, 21, downHalfHelixSmall, right45 }, { 107, 24, -5, 21, downHalfHelixSmall, right45 },
    { 107, 23, -5, 21, downHalfHelixSmall, right45 }, { 108, 22, -5, 22, downHalfHelixSmall, right45 }, { 108, 21, -5, 22, downHalfHelixSmall, right45 },
    { 109, 20, -5, 22, downHalfHelixSmall, right45 }, { 109, 19, -5, 22, downHalfHelixSmall, right45 }, { 109, 18, -5, 22, downHalfHelixSmall, right45 },
    { 110, 17, -6, 22, downHalfHelixSmall, right45 }, { 110, 16, -6, 22, downHalfHelixSmall, right45 }, { 110, 15, -6, 22, downHalfHelixSmall, right45 },
    { 111, 14, -6, 22, downHalfHelixSmall, right45 }, { 111, 13, -6, 22, downHalfHelixSmall, right45 }, { 111, 12, -6, 23, downHalfHelixSmall, right45 },
    { 111, 11, -6, 23, downHalfHelixSmall, right45 }, { 111, 10, -6, 23, downHalfHelixSmall, right45 }, { 111,  9, -6, 23, downHalfHelixSmall, right45 },
    { 112,  8, -7, 23, downHalfHelixSmall, right45 }, { 112,  7, -7, 23, downHalfHelixSmall, right45 }, { 112,  6, -7, 23, downHalfHelixSmall, right45 },
    { 112,  5, -7, 23, downHalfHelixSmall, right45 }, { 112,  4, -7, 24, downHalfHelixSmall, right45 }, { 112,  3, -7, 24, downHalfHelixSmall, right45 },
    { 112,  2, -7, 24, downHalfHelixSmall, right45 }, { 112,  1, -7, 24, downHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FCF8E, {
    {  0,  16,  8, 16, downHalfHelixSmall, right45 }, {  1,  16,  8, 16, downHalfHelixSmall, right45 }, {  2,  16,  8, 16, downHalfHelixSmall, right45 },
    {  3,  16,  8, 16, downHalfHelixSmall, right45 }, {  4,  16,  8, 16, downHalfHelixSmall, right45 }, {  5,  16,  8, 17, downHalfHelixSmall, right45 },
    {  6,  16,  8, 17, downHalfHelixSmall, right45 }, {  7,  15,  8, 17, downHalfHelixSmall, right45 }, {  8,  15,  8, 17, downHalfHelixSmall, right45 },
    {  9,  15,  7, 17, downHalfHelixSmall, right45 }, { 10,  15,  7, 17, downHalfHelixSmall, right45 }, { 11,  15,  7, 17, downHalfHelixSmall, right45 },
    { 12,  15,  7, 17, downHalfHelixSmall, right45 }, { 13,  14,  7, 17, downHalfHelixSmall, right45 }, { 14,  14,  7, 18, downHalfHelixSmall, right45 },
    { 15,  14,  7, 18, downHalfHelixSmall, right45 }, { 16,  13,  7, 18, downHalfHelixSmall, right45 }, { 17,  13,  7, 18, downHalfHelixSmall, right45 },
    { 18,  13,  6, 18, downHalfHelixSmall, right45 }, { 19,  12,  6, 18, downHalfHelixSmall, right45 }, { 20,  12,  6, 18, downHalfHelixSmall, right45 },
    { 21,  11,  6, 18, downHalfHelixSmall, right45 }, { 22,  11,  6, 18, downHalfHelixSmall, right45 }, { 23,  10,  6, 18, downHalfHelixSmall, right45 },
    { 24,  10,  6, 19, downHalfHelixSmall, right45 }, { 25,   9,  6, 19, downHalfHelixSmall, right45 }, { 26,   9,  5, 19, downHalfHelixSmall, right45 },
    { 27,   8,  5, 19, downHalfHelixSmall, right45 }, { 28,   7,  5, 19, downHalfHelixSmall, right45 }, { 29,   7,  5, 19, downHalfHelixSmall, right45 },
    { 30,   6,  5, 19, downHalfHelixSmall, right45 }, { 31,   5,  5, 19, downHalfHelixSmall, right45 }, { 32,   4,  5, 19, downHalfHelixSmall, right45 },
    { 33,   3,  5, 20, downHalfHelixSmall, right45 }, { 35,   3,  5, 20, downHalfHelixSmall, right45 }, { 36,   2,  4, 20, downHalfHelixSmall, right45 },
    { 37,   1,  4, 20, downHalfHelixSmall, right45 }, { 38,   0,  4, 20, downHalfHelixSmall, right45 }, { 39,  -1,  4, 21, downHalfHelixSmall, right45 },
    { 39,  -2,  4, 21, downHalfHelixSmall, right45 }, { 40,  -3,  4, 21, downHalfHelixSmall, right45 }, { 41,  -4,  4, 21, downHalfHelixSmall, right45 },
    { 41,  -5,  4, 21, downHalfHelixSmall, right45 }, { 42,  -6,  4, 21, downHalfHelixSmall, right45 }, { 42,  -7,  3, 21, downHalfHelixSmall, right45 },
    { 43,  -8,  3, 21, downHalfHelixSmall, right45 }, { 43,  -9,  3, 21, downHalfHelixSmall, right45 }, { 44, -10,  3, 22, downHalfHelixSmall, right45 },
    { 44, -11,  3, 22, downHalfHelixSmall, right45 }, { 45, -12,  3, 22, downHalfHelixSmall, right45 }, { 45, -13,  3, 22, downHalfHelixSmall, right45 },
    { 45, -14,  3, 22, downHalfHelixSmall, right45 }, { 46, -15,  2, 22, downHalfHelixSmall, right45 }, { 46, -16,  2, 22, downHalfHelixSmall, right45 },
    { 46, -17,  2, 22, downHalfHelixSmall, right45 }, { 47, -18,  2, 22, downHalfHelixSmall, right45 }, { 47, -19,  2, 22, downHalfHelixSmall, right45 },
    { 47, -20,  2, 23, downHalfHelixSmall, right45 }, { 47, -21,  2, 23, downHalfHelixSmall, right45 }, { 47, -22,  2, 23, downHalfHelixSmall, right45 },
    { 47, -23,  2, 23, downHalfHelixSmall, right45 }, { 48, -24,  1, 23, downHalfHelixSmall, right45 }, { 48, -25,  1, 23, downHalfHelixSmall, right45 },
    { 48, -26,  1, 23, downHalfHelixSmall, right45 }, { 48, -27,  1, 23, downHalfHelixSmall, right45 }, { 48, -28,  1, 24, downHalfHelixSmall, right45 },
    { 48, -29,  1, 24, downHalfHelixSmall, right45 }, { 48, -30,  1, 24, downHalfHelixSmall, right45 }, { 48, -31,  1, 24, downHalfHelixSmall, right45 },
    { 48, -33,  0, 24, downHalfHelixSmall, right45 }, { 48, -34,  0, 24, downHalfHelixSmall, right45 }, { 48, -35,  0, 24, downHalfHelixSmall, right45 },
    { 48, -36,  0, 24, downHalfHelixSmall, right45 }, { 48, -37,  0, 25, downHalfHelixSmall, right45 }, { 48, -38,  0, 25, downHalfHelixSmall, right45 },
    { 47, -39,  0, 25, downHalfHelixSmall, right45 }, { 47, -40,  0, 25, downHalfHelixSmall, right45 }, { 47, -41, -1, 25, downHalfHelixSmall, right45 },
    { 47, -42, -1, 25, downHalfHelixSmall, right45 }, { 47, -43, -1, 25, downHalfHelixSmall, right45 }, { 47, -44, -1, 25, downHalfHelixSmall, right45 },
    { 46, -45, -1, 25, downHalfHelixSmall, right45 }, { 46, -46, -1, 26, downHalfHelixSmall, right45 }, { 46, -47, -1, 26, downHalfHelixSmall, right45 },
    { 45, -48, -1, 26, downHalfHelixSmall, right45 }, { 45, -49, -2, 26, downHalfHelixSmall, right45 }, { 45, -50, -2, 26, downHalfHelixSmall, right45 },
    { 44, -51, -2, 26, downHalfHelixSmall, right45 }, { 44, -52, -2, 26, downHalfHelixSmall, right45 }, { 43, -53, -2, 26, downHalfHelixSmall, right45 },
    { 43, -54, -2, 26, downHalfHelixSmall, right45 }, { 42, -55, -2, 26, downHalfHelixSmall, right45 }, { 42, -56, -2, 27, downHalfHelixSmall, right45 },
    { 41, -57, -2, 27, downHalfHelixSmall, right45 }, { 41, -58, -3, 27, downHalfHelixSmall, right45 }, { 40, -59, -3, 27, downHalfHelixSmall, right45 },
    { 39, -60, -3, 27, downHalfHelixSmall, right45 }, { 39, -61, -3, 27, downHalfHelixSmall, right45 }, { 38, -62, -3, 27, downHalfHelixSmall, right45 },
    { 37, -63, -3, 27, downHalfHelixSmall, right45 }, { 36, -64, -3, 27, downHalfHelixSmall, right45 }, { 35, -65, -3, 28, downHalfHelixSmall, right45 },
    { 35, -67, -4, 28, downHalfHelixSmall, right45 }, { 34, -68, -4, 28, downHalfHelixSmall, right45 }, { 33, -69, -4, 28, downHalfHelixSmall, right45 },
    { 32, -70, -4, 28, downHalfHelixSmall, right45 }, { 31, -71, -4, 29, downHalfHelixSmall, right45 }, { 30, -71, -4, 29, downHalfHelixSmall, right45 },
    { 29, -72, -4, 29, downHalfHelixSmall, right45 }, { 28, -73, -4, 29, downHalfHelixSmall, right45 }, { 27, -73, -4, 29, downHalfHelixSmall, right45 },
    { 26, -74, -5, 29, downHalfHelixSmall, right45 }, { 25, -74, -5, 29, downHalfHelixSmall, right45 }, { 24, -75, -5, 29, downHalfHelixSmall, right45 },
    { 23, -75, -5, 29, downHalfHelixSmall, right45 }, { 22, -76, -5, 30, downHalfHelixSmall, right45 }, { 21, -76, -5, 30, downHalfHelixSmall, right45 },
    { 20, -77, -5, 30, downHalfHelixSmall, right45 }, { 19, -77, -5, 30, downHalfHelixSmall, right45 }, { 18, -77, -6, 30, downHalfHelixSmall, right45 },
    { 17, -78, -6, 30, downHalfHelixSmall, right45 }, { 16, -78, -6, 30, downHalfHelixSmall, right45 }, { 15, -78, -6, 30, downHalfHelixSmall, right45 },
    { 14, -79, -6, 30, downHalfHelixSmall, right45 }, { 13, -79, -6, 30, downHalfHelixSmall, right45 }, { 12, -79, -6, 31, downHalfHelixSmall, right45 },
    { 11, -79, -6, 31, downHalfHelixSmall, right45 }, { 10, -79, -6, 31, downHalfHelixSmall, right45 }, {  9, -79, -7, 31, downHalfHelixSmall, right45 },
    {  8, -80, -7, 31, downHalfHelixSmall, right45 }, {  7, -80, -7, 31, downHalfHelixSmall, right45 }, {  6, -80, -7, 31, downHalfHelixSmall, right45 },
    {  5, -80, -7, 31, downHalfHelixSmall, right45 }, {  4, -80, -7,  0, downHalfHelixSmall, right45 }, {  3, -80, -7,  0, downHalfHelixSmall, right45 },
    {  2, -80, -7,  0, downHalfHelixSmall, right45 }, {  1, -80, -8,  0, downHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FD461, {
    {  16,  31,  8, 24, downHalfHelixSmall, right45 }, {  16,  30,  8, 24, downHalfHelixSmall, right45 }, {  16,  29,  8, 24, downHalfHelixSmall, right45 },
    {  16,  28,  8, 24, downHalfHelixSmall, right45 }, {  16,  27,  8, 25, downHalfHelixSmall, right45 }, {  16,  26,  8, 25, downHalfHelixSmall, right45 },
    {  15,  25,  8, 25, downHalfHelixSmall, right45 }, {  15,  24,  8, 25, downHalfHelixSmall, right45 }, {  15,  23,  7, 25, downHalfHelixSmall, right45 },
    {  15,  22,  7, 25, downHalfHelixSmall, right45 }, {  15,  21,  7, 25, downHalfHelixSmall, right45 }, {  15,  20,  7, 25, downHalfHelixSmall, right45 },
    {  14,  19,  7, 25, downHalfHelixSmall, right45 }, {  14,  18,  7, 26, downHalfHelixSmall, right45 }, {  14,  17,  7, 26, downHalfHelixSmall, right45 },
    {  13,  16,  7, 26, downHalfHelixSmall, right45 }, {  13,  15,  6, 26, downHalfHelixSmall, right45 }, {  13,  14,  6, 26, downHalfHelixSmall, right45 },
    {  12,  13,  6, 26, downHalfHelixSmall, right45 }, {  12,  12,  6, 26, downHalfHelixSmall, right45 }, {  11,  11,  6, 26, downHalfHelixSmall, right45 },
    {  11,  10,  6, 26, downHalfHelixSmall, right45 }, {  10,   9,  6, 26, downHalfHelixSmall, right45 }, {  10,   8,  6, 27, downHalfHelixSmall, right45 },
    {   9,   7,  6, 27, downHalfHelixSmall, right45 }, {   9,   6,  5, 27, downHalfHelixSmall, right45 }, {   8,   5,  5, 27, downHalfHelixSmall, right45 },
    {   7,   4,  5, 27, downHalfHelixSmall, right45 }, {   7,   3,  5, 27, downHalfHelixSmall, right45 }, {   6,   2,  5, 27, downHalfHelixSmall, right45 },
    {   5,   1,  5, 27, downHalfHelixSmall, right45 }, {   4,   0,  5, 27, downHalfHelixSmall, right45 }, {   3,  -1,  5, 28, downHalfHelixSmall, right45 },
    {   3,  -3,  4, 28, downHalfHelixSmall, right45 }, {   2,  -4,  4, 28, downHalfHelixSmall, right45 }, {   1,  -5,  4, 28, downHalfHelixSmall, right45 },
    {   0,  -6,  4, 28, downHalfHelixSmall, right45 }, {  -1,  -7,  4, 29, downHalfHelixSmall, right45 }, {  -2,  -7,  4, 29, downHalfHelixSmall, right45 },
    {  -3,  -8,  4, 29, downHalfHelixSmall, right45 }, {  -4,  -9,  4, 29, downHalfHelixSmall, right45 }, {  -5,  -9,  4, 29, downHalfHelixSmall, right45 },
    {  -6, -10,  3, 29, downHalfHelixSmall, right45 }, {  -7, -10,  3, 29, downHalfHelixSmall, right45 }, {  -8, -11,  3, 29, downHalfHelixSmall, right45 },
    {  -9, -11,  3, 29, downHalfHelixSmall, right45 }, { -10, -12,  3, 30, downHalfHelixSmall, right45 }, { -11, -12,  3, 30, downHalfHelixSmall, right45 },
    { -12, -13,  3, 30, downHalfHelixSmall, right45 }, { -13, -13,  3, 30, downHalfHelixSmall, right45 }, { -14, -13,  2, 30, downHalfHelixSmall, right45 },
    { -15, -14,  2, 30, downHalfHelixSmall, right45 }, { -16, -14,  2, 30, downHalfHelixSmall, right45 }, { -17, -14,  2, 30, downHalfHelixSmall, right45 },
    { -18, -15,  2, 30, downHalfHelixSmall, right45 }, { -19, -15,  2, 30, downHalfHelixSmall, right45 }, { -20, -15,  2, 31, downHalfHelixSmall, right45 },
    { -21, -15,  2, 31, downHalfHelixSmall, right45 }, { -22, -15,  2, 31, downHalfHelixSmall, right45 }, { -23, -15,  1, 31, downHalfHelixSmall, right45 },
    { -24, -16,  1, 31, downHalfHelixSmall, right45 }, { -25, -16,  1, 31, downHalfHelixSmall, right45 }, { -26, -16,  1, 31, downHalfHelixSmall, right45 },
    { -27, -16,  1, 31, downHalfHelixSmall, right45 }, { -28, -16,  1,  0, downHalfHelixSmall, right45 }, { -29, -16,  1,  0, downHalfHelixSmall, right45 },
    { -30, -16,  1,  0, downHalfHelixSmall, right45 }, { -31, -16,  0,  0, downHalfHelixSmall, right45 }, { -33, -16,  0,  0, downHalfHelixSmall, right45 },
    { -34, -16,  0,  0, downHalfHelixSmall, right45 }, { -35, -16,  0,  0, downHalfHelixSmall, right45 }, { -36, -16,  0,  0, downHalfHelixSmall, right45 },
    { -37, -16,  0,  1, downHalfHelixSmall, right45 }, { -38, -16,  0,  1, downHalfHelixSmall, right45 }, { -39, -15,  0,  1, downHalfHelixSmall, right45 },
    { -40, -15,  0,  1, downHalfHelixSmall, right45 }, { -41, -15, -1,  1, downHalfHelixSmall, right45 }, { -42, -15, -1,  1, downHalfHelixSmall, right45 },
    { -43, -15, -1,  1, downHalfHelixSmall, right45 }, { -44, -15, -1,  1, downHalfHelixSmall, right45 }, { -45, -14, -1,  1, downHalfHelixSmall, right45 },
    { -46, -14, -1,  2, downHalfHelixSmall, right45 }, { -47, -14, -1,  2, downHalfHelixSmall, right45 }, { -48, -13, -1,  2, downHalfHelixSmall, right45 },
    { -49, -13, -2,  2, downHalfHelixSmall, right45 }, { -50, -13, -2,  2, downHalfHelixSmall, right45 }, { -51, -12, -2,  2, downHalfHelixSmall, right45 },
    { -52, -12, -2,  2, downHalfHelixSmall, right45 }, { -53, -11, -2,  2, downHalfHelixSmall, right45 }, { -54, -11, -2,  2, downHalfHelixSmall, right45 },
    { -55, -10, -2,  2, downHalfHelixSmall, right45 }, { -56, -10, -2,  3, downHalfHelixSmall, right45 }, { -57,  -9, -2,  3, downHalfHelixSmall, right45 },
    { -58,  -9, -3,  3, downHalfHelixSmall, right45 }, { -59,  -8, -3,  3, downHalfHelixSmall, right45 }, { -60,  -7, -3,  3, downHalfHelixSmall, right45 },
    { -61,  -7, -3,  3, downHalfHelixSmall, right45 }, { -62,  -6, -3,  3, downHalfHelixSmall, right45 }, { -63,  -5, -3,  3, downHalfHelixSmall, right45 },
    { -64,  -4, -3,  3, downHalfHelixSmall, right45 }, { -65,  -3, -3,  4, downHalfHelixSmall, right45 }, { -67,  -3, -4,  4, downHalfHelixSmall, right45 },
    { -68,  -2, -4,  4, downHalfHelixSmall, right45 }, { -69,  -1, -4,  4, downHalfHelixSmall, right45 }, { -70,   0, -4,  4, downHalfHelixSmall, right45 },
    { -71,   1, -4,  5, downHalfHelixSmall, right45 }, { -71,   2, -4,  5, downHalfHelixSmall, right45 }, { -72,   3, -4,  5, downHalfHelixSmall, right45 },
    { -73,   4, -4,  5, downHalfHelixSmall, right45 }, { -73,   5, -5,  5, downHalfHelixSmall, right45 }, { -74,   6, -5,  5, downHalfHelixSmall, right45 },
    { -74,   7, -5,  5, downHalfHelixSmall, right45 }, { -75,   8, -5,  5, downHalfHelixSmall, right45 }, { -75,   9, -5,  5, downHalfHelixSmall, right45 },
    { -76,  10, -5,  6, downHalfHelixSmall, right45 }, { -76,  11, -5,  6, downHalfHelixSmall, right45 }, { -77,  12, -5,  6, downHalfHelixSmall, right45 },
    { -77,  13, -5,  6, downHalfHelixSmall, right45 }, { -77,  14, -6,  6, downHalfHelixSmall, right45 }, { -78,  15, -6,  6, downHalfHelixSmall, right45 },
    { -78,  16, -6,  6, downHalfHelixSmall, right45 }, { -78,  17, -6,  6, downHalfHelixSmall, right45 }, { -79,  18, -6,  6, downHalfHelixSmall, right45 },
    { -79,  19, -6,  6, downHalfHelixSmall, right45 }, { -79,  20, -6,  7, downHalfHelixSmall, right45 }, { -79,  21, -6,  7, downHalfHelixSmall, right45 },
    { -79,  22, -7,  7, downHalfHelixSmall, right45 }, { -79,  23, -7,  7, downHalfHelixSmall, right45 }, { -80,  24, -7,  7, downHalfHelixSmall, right45 },
    { -80,  25, -7,  7, downHalfHelixSmall, right45 }, { -80,  26, -7,  7, downHalfHelixSmall, right45 }, { -80,  27, -7,  7, downHalfHelixSmall, right45 },
    { -80,  28, -7,  8, downHalfHelixSmall, right45 }, { -80,  29, -7,  8, downHalfHelixSmall, right45 }, { -80,  30, -8,  8, downHalfHelixSmall, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F0C22, {
    {  31,   16,  0,  0, upHalfHelixLarge, left45 }, {  30,   16,  0,  0, upHalfHelixLarge, left45 }, {  29,   16,  0,  0, upHalfHelixLarge, left45 }, {  28,   16,  0,  0, upHalfHelixLarge, left45 },
    {  27,   16,  0,  0, upHalfHelixLarge, left45 }, {  26,   16,  0,  0, upHalfHelixLarge, left45 }, {  25,   16,  0,  0, upHalfHelixLarge, left45 }, {  24,   16,  0, 31, upHalfHelixLarge, left45 },
    {  23,   15,  0, 31, upHalfHelixLarge, left45 }, {  22,   15,  0, 31, upHalfHelixLarge, left45 }, {  21,   15,  0, 31, upHalfHelixLarge, left45 }, {  20,   15,  0, 31, upHalfHelixLarge, left45 },
    {  19,   15,  0, 31, upHalfHelixLarge, left45 }, {  18,   15,  0, 31, upHalfHelixLarge, left45 }, {  17,   14,  1, 31, upHalfHelixLarge, left45 }, {  16,   14,  1, 31, upHalfHelixLarge, left45 },
    {  15,   14,  1, 31, upHalfHelixLarge, left45 }, {  14,   14,  1, 31, upHalfHelixLarge, left45 }, {  13,   14,  1, 31, upHalfHelixLarge, left45 }, {  12,   13,  1, 31, upHalfHelixLarge, left45 },
    {  11,   13,  1, 31, upHalfHelixLarge, left45 }, {  10,   13,  1, 30, upHalfHelixLarge, left45 }, {   9,   13,  1, 30, upHalfHelixLarge, left45 }, {   8,   12,  1, 30, upHalfHelixLarge, left45 },
    {   7,   12,  1, 30, upHalfHelixLarge, left45 }, {   6,   12,  1, 30, upHalfHelixLarge, left45 }, {   5,   11,  1, 30, upHalfHelixLarge, left45 }, {   4,   11,  1, 30, upHalfHelixLarge, left45 },
    {   3,   11,  2, 30, upHalfHelixLarge, left45 }, {   2,   10,  2, 30, upHalfHelixLarge, left45 }, {   1,   10,  2, 30, upHalfHelixLarge, left45 }, {   0,    9,  2, 30, upHalfHelixLarge, left45 },
    {  -1,    9,  2, 30, upHalfHelixLarge, left45 }, {  -2,    8,  2, 30, upHalfHelixLarge, left45 }, {  -3,    8,  2, 30, upHalfHelixLarge, left45 }, {  -4,    7,  2, 30, upHalfHelixLarge, left45 },
    {  -5,    7,  2, 29, upHalfHelixLarge, left45 }, {  -6,    6,  2, 29, upHalfHelixLarge, left45 }, {  -7,    6,  2, 29, upHalfHelixLarge, left45 }, {  -8,    5,  2, 29, upHalfHelixLarge, left45 },
    {  -9,    4,  2, 29, upHalfHelixLarge, left45 }, { -10,    4,  2, 29, upHalfHelixLarge, left45 }, { -11,    3,  3, 29, upHalfHelixLarge, left45 }, { -12,    2,  3, 29, upHalfHelixLarge, left45 },
    { -13,    2,  3, 29, upHalfHelixLarge, left45 }, { -14,    1,  3, 29, upHalfHelixLarge, left45 }, { -15,    0,  3, 29, upHalfHelixLarge, left45 }, { -16,    0,  3, 29, upHalfHelixLarge, left45 },
    { -17,   -1,  3, 29, upHalfHelixLarge, left45 }, { -18,   -2,  3, 28, upHalfHelixLarge, left45 }, { -19,   -3,  3, 28, upHalfHelixLarge, left45 }, { -20,   -3,  3, 28, upHalfHelixLarge, left45 },
    { -21,   -4,  3, 28, upHalfHelixLarge, left45 }, { -22,   -5,  3, 28, upHalfHelixLarge, left45 }, { -23,   -6,  3, 28, upHalfHelixLarge, left45 }, { -24,   -7,  3, 28, upHalfHelixLarge, left45 },
    { -25,   -7,  4, 28, upHalfHelixLarge, left45 }, { -26,   -8,  4, 28, upHalfHelixLarge, left45 }, { -27,   -9,  4, 28, upHalfHelixLarge, left45 }, { -28,  -10,  4, 28, upHalfHelixLarge, left45 },
    { -29,  -11,  4, 28, upHalfHelixLarge, left45 }, { -29,  -12,  4, 28, upHalfHelixLarge, left45 }, { -30,  -13,  4, 27, upHalfHelixLarge, left45 }, { -31,  -14,  4, 27, upHalfHelixLarge, left45 },
    { -32,  -15,  4, 27, upHalfHelixLarge, left45 }, { -32,  -16,  4, 27, upHalfHelixLarge, left45 }, { -33,  -17,  4, 27, upHalfHelixLarge, left45 }, { -34,  -18,  4, 27, upHalfHelixLarge, left45 },
    { -34,  -19,  4, 27, upHalfHelixLarge, left45 }, { -35,  -20,  4, 27, upHalfHelixLarge, left45 }, { -36,  -21,  4, 27, upHalfHelixLarge, left45 }, { -36,  -22,  5, 27, upHalfHelixLarge, left45 },
    { -37,  -23,  5, 27, upHalfHelixLarge, left45 }, { -38,  -24,  5, 27, upHalfHelixLarge, left45 }, { -38,  -25,  5, 27, upHalfHelixLarge, left45 }, { -39,  -26,  5, 26, upHalfHelixLarge, left45 },
    { -39,  -27,  5, 26, upHalfHelixLarge, left45 }, { -40,  -28,  5, 26, upHalfHelixLarge, left45 }, { -40,  -29,  5, 26, upHalfHelixLarge, left45 }, { -41,  -30,  5, 26, upHalfHelixLarge, left45 },
    { -41,  -31,  5, 26, upHalfHelixLarge, left45 }, { -42,  -32,  5, 26, upHalfHelixLarge, left45 }, { -42,  -33,  5, 26, upHalfHelixLarge, left45 }, { -43,  -34,  5, 26, upHalfHelixLarge, left45 },
    { -43,  -35,  5, 26, upHalfHelixLarge, left45 }, { -43,  -36,  6, 26, upHalfHelixLarge, left45 }, { -44,  -37,  6, 26, upHalfHelixLarge, left45 }, { -44,  -38,  6, 26, upHalfHelixLarge, left45 },
    { -44,  -39,  6, 26, upHalfHelixLarge, left45 }, { -45,  -40,  6, 25, upHalfHelixLarge, left45 }, { -45,  -41,  6, 25, upHalfHelixLarge, left45 }, { -45,  -42,  6, 25, upHalfHelixLarge, left45 },
    { -45,  -43,  6, 25, upHalfHelixLarge, left45 }, { -46,  -44,  6, 25, upHalfHelixLarge, left45 }, { -46,  -45,  6, 25, upHalfHelixLarge, left45 }, { -46,  -46,  6, 25, upHalfHelixLarge, left45 },
    { -46,  -47,  6, 25, upHalfHelixLarge, left45 }, { -46,  -48,  6, 25, upHalfHelixLarge, left45 }, { -47,  -49,  6, 25, upHalfHelixLarge, left45 }, { -47,  -50,  7, 25, upHalfHelixLarge, left45 },
    { -47,  -51,  7, 25, upHalfHelixLarge, left45 }, { -47,  -52,  7, 25, upHalfHelixLarge, left45 }, { -47,  -53,  7, 25, upHalfHelixLarge, left45 }, { -47,  -54,  7, 25, upHalfHelixLarge, left45 },
    { -48,  -55,  7, 25, upHalfHelixLarge, left45 }, { -48,  -56,  7, 24, upHalfHelixLarge, left45 }, { -48,  -57,  7, 24, upHalfHelixLarge, left45 }, { -48,  -58,  7, 24, upHalfHelixLarge, left45 },
    { -48,  -59,  7, 24, upHalfHelixLarge, left45 }, { -48,  -60,  7, 24, upHalfHelixLarge, left45 }, { -48,  -61,  7, 24, upHalfHelixLarge, left45 }, { -48,  -62,  7, 24, upHalfHelixLarge, left45 },
    { -48,  -63,  7, 24, upHalfHelixLarge, left45 }, { -48,  -64,  8, 24, upHalfHelixLarge, left45 }, { -48,  -65,  8, 24, upHalfHelixLarge, left45 }, { -48,  -66,  8, 24, upHalfHelixLarge, left45 },
    { -48,  -67,  8, 24, upHalfHelixLarge, left45 }, { -48,  -68,  8, 24, upHalfHelixLarge, left45 }, { -48,  -69,  8, 24, upHalfHelixLarge, left45 }, { -48,  -70,  8, 24, upHalfHelixLarge, left45 },
    { -48,  -71,  8, 24, upHalfHelixLarge, left45 }, { -48,  -72,  8, 23, upHalfHelixLarge, left45 }, { -47,  -73,  8, 23, upHalfHelixLarge, left45 }, { -47,  -74,  8, 23, upHalfHelixLarge, left45 },
    { -47,  -75,  8, 23, upHalfHelixLarge, left45 }, { -47,  -76,  8, 23, upHalfHelixLarge, left45 }, { -47,  -77,  8, 23, upHalfHelixLarge, left45 }, { -47,  -78,  8, 23, upHalfHelixLarge, left45 },
    { -46,  -79,  9, 23, upHalfHelixLarge, left45 }, { -46,  -80,  9, 23, upHalfHelixLarge, left45 }, { -46,  -81,  9, 23, upHalfHelixLarge, left45 }, { -46,  -82,  9, 23, upHalfHelixLarge, left45 },
    { -46,  -83,  9, 23, upHalfHelixLarge, left45 }, { -45,  -84,  9, 23, upHalfHelixLarge, left45 }, { -45,  -85,  9, 23, upHalfHelixLarge, left45 }, { -45,  -86,  9, 22, upHalfHelixLarge, left45 },
    { -45,  -87,  9, 22, upHalfHelixLarge, left45 }, { -44,  -88,  9, 22, upHalfHelixLarge, left45 }, { -44,  -89,  9, 22, upHalfHelixLarge, left45 }, { -44,  -90,  9, 22, upHalfHelixLarge, left45 },
    { -43,  -91,  9, 22, upHalfHelixLarge, left45 }, { -43,  -92,  9, 22, upHalfHelixLarge, left45 }, { -43,  -93, 10, 22, upHalfHelixLarge, left45 }, { -42,  -94, 10, 22, upHalfHelixLarge, left45 },
    { -42,  -95, 10, 22, upHalfHelixLarge, left45 }, { -41,  -96, 10, 22, upHalfHelixLarge, left45 }, { -41,  -97, 10, 22, upHalfHelixLarge, left45 }, { -40,  -98, 10, 22, upHalfHelixLarge, left45 },
    { -40,  -99, 10, 22, upHalfHelixLarge, left45 }, { -39, -100, 10, 22, upHalfHelixLarge, left45 }, { -39, -101, 10, 21, upHalfHelixLarge, left45 }, { -38, -102, 10, 21, upHalfHelixLarge, left45 },
    { -38, -103, 10, 21, upHalfHelixLarge, left45 }, { -37, -104, 10, 21, upHalfHelixLarge, left45 }, { -36, -105, 10, 21, upHalfHelixLarge, left45 }, { -36, -106, 10, 21, upHalfHelixLarge, left45 },
    { -35, -107, 11, 21, upHalfHelixLarge, left45 }, { -34, -108, 11, 21, upHalfHelixLarge, left45 }, { -34, -109, 11, 21, upHalfHelixLarge, left45 }, { -33, -110, 11, 21, upHalfHelixLarge, left45 },
    { -32, -111, 11, 21, upHalfHelixLarge, left45 }, { -32, -112, 11, 21, upHalfHelixLarge, left45 }, { -31, -113, 11, 21, upHalfHelixLarge, left45 }, { -30, -114, 11, 20, upHalfHelixLarge, left45 },
    { -29, -115, 11, 20, upHalfHelixLarge, left45 }, { -29, -116, 11, 20, upHalfHelixLarge, left45 }, { -28, -117, 11, 20, upHalfHelixLarge, left45 }, { -27, -118, 11, 20, upHalfHelixLarge, left45 },
    { -26, -119, 11, 20, upHalfHelixLarge, left45 }, { -25, -120, 11, 20, upHalfHelixLarge, left45 }, { -25, -121, 12, 20, upHalfHelixLarge, left45 }, { -24, -122, 12, 20, upHalfHelixLarge, left45 },
    { -23, -123, 12, 20, upHalfHelixLarge, left45 }, { -22, -124, 12, 20, upHalfHelixLarge, left45 }, { -21, -125, 12, 20, upHalfHelixLarge, left45 }, { -20, -125, 12, 20, upHalfHelixLarge, left45 },
    { -19, -126, 12, 19, upHalfHelixLarge, left45 }, { -18, -127, 12, 19, upHalfHelixLarge, left45 }, { -17, -128, 12, 19, upHalfHelixLarge, left45 }, { -16, -128, 12, 19, upHalfHelixLarge, left45 },
    { -15, -129, 12, 19, upHalfHelixLarge, left45 }, { -14, -130, 12, 19, upHalfHelixLarge, left45 }, { -13, -130, 12, 19, upHalfHelixLarge, left45 }, { -12, -131, 12, 19, upHalfHelixLarge, left45 },
    { -11, -132, 13, 19, upHalfHelixLarge, left45 }, { -10, -132, 13, 19, upHalfHelixLarge, left45 }, {  -9, -133, 13, 19, upHalfHelixLarge, left45 }, {  -8, -134, 13, 19, upHalfHelixLarge, left45 },
    {  -7, -134, 13, 19, upHalfHelixLarge, left45 }, {  -6, -135, 13, 18, upHalfHelixLarge, left45 }, {  -5, -135, 13, 18, upHalfHelixLarge, left45 }, {  -4, -136, 13, 18, upHalfHelixLarge, left45 },
    {  -3, -136, 13, 18, upHalfHelixLarge, left45 }, {  -2, -137, 13, 18, upHalfHelixLarge, left45 }, {  -1, -137, 13, 18, upHalfHelixLarge, left45 }, {   0, -138, 13, 18, upHalfHelixLarge, left45 },
    {   1, -138, 13, 18, upHalfHelixLarge, left45 }, {   2, -139, 13, 18, upHalfHelixLarge, left45 }, {   3, -139, 14, 18, upHalfHelixLarge, left45 }, {   4, -139, 14, 18, upHalfHelixLarge, left45 },
    {   5, -140, 14, 18, upHalfHelixLarge, left45 }, {   6, -140, 14, 18, upHalfHelixLarge, left45 }, {   7, -140, 14, 18, upHalfHelixLarge, left45 }, {   8, -141, 14, 17, upHalfHelixLarge, left45 },
    {   9, -141, 14, 17, upHalfHelixLarge, left45 }, {  10, -141, 14, 17, upHalfHelixLarge, left45 }, {  11, -141, 14, 17, upHalfHelixLarge, left45 }, {  12, -142, 14, 17, upHalfHelixLarge, left45 },
    {  13, -142, 14, 17, upHalfHelixLarge, left45 }, {  14, -142, 14, 17, upHalfHelixLarge, left45 }, {  15, -142, 14, 17, upHalfHelixLarge, left45 }, {  16, -142, 14, 17, upHalfHelixLarge, left45 },
    {  17, -143, 15, 17, upHalfHelixLarge, left45 }, {  18, -143, 15, 17, upHalfHelixLarge, left45 }, {  19, -143, 15, 17, upHalfHelixLarge, left45 }, {  20, -143, 15, 17, upHalfHelixLarge, left45 },
    {  21, -143, 15, 17, upHalfHelixLarge, left45 }, {  22, -143, 15, 17, upHalfHelixLarge, left45 }, {  23, -144, 15, 17, upHalfHelixLarge, left45 }, {  24, -144, 15, 16, upHalfHelixLarge, left45 },
    {  25, -144, 15, 16, upHalfHelixLarge, left45 }, {  26, -144, 15, 16, upHalfHelixLarge, left45 }, {  27, -144, 15, 16, upHalfHelixLarge, left45 }, {  28, -144, 15, 16, upHalfHelixLarge, left45 },
    {  29, -144, 15, 16, upHalfHelixLarge, left45 }, {  30, -144, 15, 16, upHalfHelixLarge, left45 }, {  31, -144, 16, 16, upHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F141F, {
    {   16,  0,  0,  8, upHalfHelixLarge, left45 }, {   16,  1,  0,  8, upHalfHelixLarge, left45 }, {   16,  2,  0,  8, upHalfHelixLarge, left45 }, {   16,  3,  0,  8, upHalfHelixLarge, left45 },
    {   16,  4,  0,  8, upHalfHelixLarge, left45 }, {   16,  5,  0,  8, upHalfHelixLarge, left45 }, {   16,  6,  0,  8, upHalfHelixLarge, left45 }, {   16,  7,  0,  8, upHalfHelixLarge, left45 },
    {   16,  8,  0,  7, upHalfHelixLarge, left45 }, {   15,  9,  0,  7, upHalfHelixLarge, left45 }, {   15, 10,  0,  7, upHalfHelixLarge, left45 }, {   15, 11,  0,  7, upHalfHelixLarge, left45 },
    {   15, 12,  0,  7, upHalfHelixLarge, left45 }, {   15, 13,  0,  7, upHalfHelixLarge, left45 }, {   15, 14,  0,  7, upHalfHelixLarge, left45 }, {   14, 15,  1,  7, upHalfHelixLarge, left45 },
    {   14, 16,  1,  7, upHalfHelixLarge, left45 }, {   14, 17,  1,  7, upHalfHelixLarge, left45 }, {   14, 18,  1,  7, upHalfHelixLarge, left45 }, {   14, 19,  1,  7, upHalfHelixLarge, left45 },
    {   13, 20,  1,  7, upHalfHelixLarge, left45 }, {   13, 21,  1,  7, upHalfHelixLarge, left45 }, {   13, 22,  1,  6, upHalfHelixLarge, left45 }, {   13, 23,  1,  6, upHalfHelixLarge, left45 },
    {   12, 24,  1,  6, upHalfHelixLarge, left45 }, {   12, 25,  1,  6, upHalfHelixLarge, left45 }, {   12, 26,  1,  6, upHalfHelixLarge, left45 }, {   11, 27,  1,  6, upHalfHelixLarge, left45 },
    {   11, 28,  1,  6, upHalfHelixLarge, left45 }, {   11, 29,  2,  6, upHalfHelixLarge, left45 }, {   10, 30,  2,  6, upHalfHelixLarge, left45 }, {   10, 31,  2,  6, upHalfHelixLarge, left45 },
    {    9, 32,  2,  6, upHalfHelixLarge, left45 }, {    9, 33,  2,  6, upHalfHelixLarge, left45 }, {    8, 34,  2,  6, upHalfHelixLarge, left45 }, {    8, 35,  2,  6, upHalfHelixLarge, left45 },
    {    7, 36,  2,  6, upHalfHelixLarge, left45 }, {    7, 37,  2,  5, upHalfHelixLarge, left45 }, {    6, 38,  2,  5, upHalfHelixLarge, left45 }, {    6, 39,  2,  5, upHalfHelixLarge, left45 },
    {    5, 40,  2,  5, upHalfHelixLarge, left45 }, {    4, 41,  2,  5, upHalfHelixLarge, left45 }, {    4, 42,  2,  5, upHalfHelixLarge, left45 }, {    3, 43,  2,  5, upHalfHelixLarge, left45 },
    {    2, 44,  3,  5, upHalfHelixLarge, left45 }, {    2, 45,  3,  5, upHalfHelixLarge, left45 }, {    1, 46,  3,  5, upHalfHelixLarge, left45 }, {    0, 47,  3,  5, upHalfHelixLarge, left45 },
    {    0, 48,  3,  5, upHalfHelixLarge, left45 }, {   -1, 49,  3,  5, upHalfHelixLarge, left45 }, {   -2, 50,  3,  4, upHalfHelixLarge, left45 }, {   -3, 51,  3,  4, upHalfHelixLarge, left45 },
    {   -3, 52,  3,  4, upHalfHelixLarge, left45 }, {   -4, 53,  3,  4, upHalfHelixLarge, left45 }, {   -5, 54,  3,  4, upHalfHelixLarge, left45 }, {   -6, 55,  3,  4, upHalfHelixLarge, left45 },
    {   -7, 56,  3,  4, upHalfHelixLarge, left45 }, {   -7, 57,  3,  4, upHalfHelixLarge, left45 }, {   -8, 58,  4,  4, upHalfHelixLarge, left45 }, {   -9, 59,  4,  4, upHalfHelixLarge, left45 },
    {  -10, 60,  4,  4, upHalfHelixLarge, left45 }, {  -11, 61,  4,  4, upHalfHelixLarge, left45 }, {  -12, 61,  4,  4, upHalfHelixLarge, left45 }, {  -13, 62,  4,  3, upHalfHelixLarge, left45 },
    {  -14, 63,  4,  3, upHalfHelixLarge, left45 }, {  -15, 64,  4,  3, upHalfHelixLarge, left45 }, {  -16, 64,  4,  3, upHalfHelixLarge, left45 }, {  -17, 65,  4,  3, upHalfHelixLarge, left45 },
    {  -18, 66,  4,  3, upHalfHelixLarge, left45 }, {  -19, 66,  4,  3, upHalfHelixLarge, left45 }, {  -20, 67,  4,  3, upHalfHelixLarge, left45 }, {  -21, 68,  4,  3, upHalfHelixLarge, left45 },
    {  -22, 68,  5,  3, upHalfHelixLarge, left45 }, {  -23, 69,  5,  3, upHalfHelixLarge, left45 }, {  -24, 70,  5,  3, upHalfHelixLarge, left45 }, {  -25, 70,  5,  3, upHalfHelixLarge, left45 },
    {  -26, 71,  5,  2, upHalfHelixLarge, left45 }, {  -27, 71,  5,  2, upHalfHelixLarge, left45 }, {  -28, 72,  5,  2, upHalfHelixLarge, left45 }, {  -29, 72,  5,  2, upHalfHelixLarge, left45 },
    {  -30, 73,  5,  2, upHalfHelixLarge, left45 }, {  -31, 73,  5,  2, upHalfHelixLarge, left45 }, {  -32, 74,  5,  2, upHalfHelixLarge, left45 }, {  -33, 74,  5,  2, upHalfHelixLarge, left45 },
    {  -34, 75,  5,  2, upHalfHelixLarge, left45 }, {  -35, 75,  5,  2, upHalfHelixLarge, left45 }, {  -36, 75,  5,  2, upHalfHelixLarge, left45 }, {  -37, 76,  6,  2, upHalfHelixLarge, left45 },
    {  -38, 76,  6,  2, upHalfHelixLarge, left45 }, {  -39, 76,  6,  2, upHalfHelixLarge, left45 }, {  -40, 77,  6,  1, upHalfHelixLarge, left45 }, {  -41, 77,  6,  1, upHalfHelixLarge, left45 },
    {  -42, 77,  6,  1, upHalfHelixLarge, left45 }, {  -43, 77,  6,  1, upHalfHelixLarge, left45 }, {  -44, 78,  6,  1, upHalfHelixLarge, left45 }, {  -45, 78,  6,  1, upHalfHelixLarge, left45 },
    {  -46, 78,  6,  1, upHalfHelixLarge, left45 }, {  -47, 78,  6,  1, upHalfHelixLarge, left45 }, {  -48, 78,  6,  1, upHalfHelixLarge, left45 }, {  -49, 79,  6,  1, upHalfHelixLarge, left45 },
    {  -50, 79,  6,  1, upHalfHelixLarge, left45 }, {  -51, 79,  7,  1, upHalfHelixLarge, left45 }, {  -52, 79,  7,  1, upHalfHelixLarge, left45 }, {  -53, 79,  7,  1, upHalfHelixLarge, left45 },
    {  -54, 79,  7,  1, upHalfHelixLarge, left45 }, {  -55, 80,  7,  1, upHalfHelixLarge, left45 }, {  -56, 80,  7,  0, upHalfHelixLarge, left45 }, {  -57, 80,  7,  0, upHalfHelixLarge, left45 },
    {  -58, 80,  7,  0, upHalfHelixLarge, left45 }, {  -59, 80,  7,  0, upHalfHelixLarge, left45 }, {  -60, 80,  7,  0, upHalfHelixLarge, left45 }, {  -61, 80,  7,  0, upHalfHelixLarge, left45 },
    {  -62, 80,  7,  0, upHalfHelixLarge, left45 }, {  -63, 80,  7,  0, upHalfHelixLarge, left45 }, {  -64, 80,  7,  0, upHalfHelixLarge, left45 }, {  -65, 80,  8,  0, upHalfHelixLarge, left45 },
    {  -66, 80,  8,  0, upHalfHelixLarge, left45 }, {  -67, 80,  8,  0, upHalfHelixLarge, left45 }, {  -68, 80,  8,  0, upHalfHelixLarge, left45 }, {  -69, 80,  8,  0, upHalfHelixLarge, left45 },
    {  -70, 80,  8,  0, upHalfHelixLarge, left45 }, {  -71, 80,  8,  0, upHalfHelixLarge, left45 }, {  -72, 80,  8, 31, upHalfHelixLarge, left45 }, {  -73, 79,  8, 31, upHalfHelixLarge, left45 },
    {  -74, 79,  8, 31, upHalfHelixLarge, left45 }, {  -75, 79,  8, 31, upHalfHelixLarge, left45 }, {  -76, 79,  8, 31, upHalfHelixLarge, left45 }, {  -77, 79,  8, 31, upHalfHelixLarge, left45 },
    {  -78, 79,  8, 31, upHalfHelixLarge, left45 }, {  -79, 78,  9, 31, upHalfHelixLarge, left45 }, {  -80, 78,  9, 31, upHalfHelixLarge, left45 }, {  -81, 78,  9, 31, upHalfHelixLarge, left45 },
    {  -82, 78,  9, 31, upHalfHelixLarge, left45 }, {  -83, 78,  9, 31, upHalfHelixLarge, left45 }, {  -84, 77,  9, 31, upHalfHelixLarge, left45 }, {  -85, 77,  9, 31, upHalfHelixLarge, left45 },
    {  -86, 77,  9, 30, upHalfHelixLarge, left45 }, {  -87, 77,  9, 30, upHalfHelixLarge, left45 }, {  -88, 76,  9, 30, upHalfHelixLarge, left45 }, {  -89, 76,  9, 30, upHalfHelixLarge, left45 },
    {  -90, 76,  9, 30, upHalfHelixLarge, left45 }, {  -91, 75,  9, 30, upHalfHelixLarge, left45 }, {  -92, 75,  9, 30, upHalfHelixLarge, left45 }, {  -93, 75, 10, 30, upHalfHelixLarge, left45 },
    {  -94, 74, 10, 30, upHalfHelixLarge, left45 }, {  -95, 74, 10, 30, upHalfHelixLarge, left45 }, {  -96, 73, 10, 30, upHalfHelixLarge, left45 }, {  -97, 73, 10, 30, upHalfHelixLarge, left45 },
    {  -98, 72, 10, 30, upHalfHelixLarge, left45 }, {  -99, 72, 10, 30, upHalfHelixLarge, left45 }, { -100, 71, 10, 30, upHalfHelixLarge, left45 }, { -101, 71, 10, 29, upHalfHelixLarge, left45 },
    { -102, 70, 10, 29, upHalfHelixLarge, left45 }, { -103, 70, 10, 29, upHalfHelixLarge, left45 }, { -104, 69, 10, 29, upHalfHelixLarge, left45 }, { -105, 68, 10, 29, upHalfHelixLarge, left45 },
    { -106, 68, 10, 29, upHalfHelixLarge, left45 }, { -107, 67, 11, 29, upHalfHelixLarge, left45 }, { -108, 66, 11, 29, upHalfHelixLarge, left45 }, { -109, 66, 11, 29, upHalfHelixLarge, left45 },
    { -110, 65, 11, 29, upHalfHelixLarge, left45 }, { -111, 64, 11, 29, upHalfHelixLarge, left45 }, { -112, 64, 11, 29, upHalfHelixLarge, left45 }, { -113, 63, 11, 29, upHalfHelixLarge, left45 },
    { -114, 62, 11, 28, upHalfHelixLarge, left45 }, { -115, 61, 11, 28, upHalfHelixLarge, left45 }, { -116, 61, 11, 28, upHalfHelixLarge, left45 }, { -117, 60, 11, 28, upHalfHelixLarge, left45 },
    { -118, 59, 11, 28, upHalfHelixLarge, left45 }, { -119, 58, 11, 28, upHalfHelixLarge, left45 }, { -120, 57, 11, 28, upHalfHelixLarge, left45 }, { -121, 57, 12, 28, upHalfHelixLarge, left45 },
    { -122, 56, 12, 28, upHalfHelixLarge, left45 }, { -123, 55, 12, 28, upHalfHelixLarge, left45 }, { -124, 54, 12, 28, upHalfHelixLarge, left45 }, { -125, 53, 12, 28, upHalfHelixLarge, left45 },
    { -125, 52, 12, 28, upHalfHelixLarge, left45 }, { -126, 51, 12, 27, upHalfHelixLarge, left45 }, { -127, 50, 12, 27, upHalfHelixLarge, left45 }, { -128, 49, 12, 27, upHalfHelixLarge, left45 },
    { -128, 48, 12, 27, upHalfHelixLarge, left45 }, { -129, 47, 12, 27, upHalfHelixLarge, left45 }, { -130, 46, 12, 27, upHalfHelixLarge, left45 }, { -130, 45, 12, 27, upHalfHelixLarge, left45 },
    { -131, 44, 12, 27, upHalfHelixLarge, left45 }, { -132, 43, 12, 27, upHalfHelixLarge, left45 }, { -132, 42, 13, 27, upHalfHelixLarge, left45 }, { -133, 41, 13, 27, upHalfHelixLarge, left45 },
    { -134, 40, 13, 27, upHalfHelixLarge, left45 }, { -134, 39, 13, 27, upHalfHelixLarge, left45 }, { -135, 38, 13, 26, upHalfHelixLarge, left45 }, { -135, 37, 13, 26, upHalfHelixLarge, left45 },
    { -136, 36, 13, 26, upHalfHelixLarge, left45 }, { -136, 35, 13, 26, upHalfHelixLarge, left45 }, { -137, 34, 13, 26, upHalfHelixLarge, left45 }, { -137, 33, 13, 26, upHalfHelixLarge, left45 },
    { -138, 32, 13, 26, upHalfHelixLarge, left45 }, { -138, 31, 13, 26, upHalfHelixLarge, left45 }, { -139, 30, 13, 26, upHalfHelixLarge, left45 }, { -139, 29, 13, 26, upHalfHelixLarge, left45 },
    { -139, 28, 14, 26, upHalfHelixLarge, left45 }, { -140, 27, 14, 26, upHalfHelixLarge, left45 }, { -140, 26, 14, 26, upHalfHelixLarge, left45 }, { -140, 25, 14, 26, upHalfHelixLarge, left45 },
    { -141, 24, 14, 25, upHalfHelixLarge, left45 }, { -141, 23, 14, 25, upHalfHelixLarge, left45 }, { -141, 22, 14, 25, upHalfHelixLarge, left45 }, { -141, 21, 14, 25, upHalfHelixLarge, left45 },
    { -142, 20, 14, 25, upHalfHelixLarge, left45 }, { -142, 19, 14, 25, upHalfHelixLarge, left45 }, { -142, 18, 14, 25, upHalfHelixLarge, left45 }, { -142, 17, 14, 25, upHalfHelixLarge, left45 },
    { -142, 16, 14, 25, upHalfHelixLarge, left45 }, { -143, 15, 14, 25, upHalfHelixLarge, left45 }, { -143, 14, 15, 25, upHalfHelixLarge, left45 }, { -143, 13, 15, 25, upHalfHelixLarge, left45 },
    { -143, 12, 15, 25, upHalfHelixLarge, left45 }, { -143, 11, 15, 25, upHalfHelixLarge, left45 }, { -143, 10, 15, 25, upHalfHelixLarge, left45 }, { -144,  9, 15, 25, upHalfHelixLarge, left45 },
    { -144,  8, 15, 24, upHalfHelixLarge, left45 }, { -144,  7, 15, 24, upHalfHelixLarge, left45 }, { -144,  6, 15, 24, upHalfHelixLarge, left45 }, { -144,  5, 15, 24, upHalfHelixLarge, left45 },
    { -144,  4, 15, 24, upHalfHelixLarge, left45 }, { -144,  3, 15, 24, upHalfHelixLarge, left45 }, { -144,  2, 15, 24, upHalfHelixLarge, left45 }, { -144,  1, 15, 24, upHalfHelixLarge, left45 },
    { -144,  0, 16, 24, upHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F1C2E, {
    {  0,  16,  0, 16, upHalfHelixLarge, left45 }, {  1,  16,  0, 16, upHalfHelixLarge, left45 }, {  2,  16,  0, 16, upHalfHelixLarge, left45 }, {  3,  16,  0, 16, upHalfHelixLarge, left45 },
    {  4,  16,  0, 16, upHalfHelixLarge, left45 }, {  5,  16,  0, 16, upHalfHelixLarge, left45 }, {  6,  16,  0, 16, upHalfHelixLarge, left45 }, {  7,  16,  0, 16, upHalfHelixLarge, left45 },
    {  8,  16,  0, 15, upHalfHelixLarge, left45 }, {  9,  17,  0, 15, upHalfHelixLarge, left45 }, { 10,  17,  0, 15, upHalfHelixLarge, left45 }, { 11,  17,  0, 15, upHalfHelixLarge, left45 },
    { 12,  17,  0, 15, upHalfHelixLarge, left45 }, { 13,  17,  0, 15, upHalfHelixLarge, left45 }, { 14,  17,  0, 15, upHalfHelixLarge, left45 }, { 15,  18,  1, 15, upHalfHelixLarge, left45 },
    { 16,  18,  1, 15, upHalfHelixLarge, left45 }, { 17,  18,  1, 15, upHalfHelixLarge, left45 }, { 18,  18,  1, 15, upHalfHelixLarge, left45 }, { 19,  18,  1, 15, upHalfHelixLarge, left45 },
    { 20,  19,  1, 15, upHalfHelixLarge, left45 }, { 21,  19,  1, 15, upHalfHelixLarge, left45 }, { 22,  19,  1, 14, upHalfHelixLarge, left45 }, { 23,  19,  1, 14, upHalfHelixLarge, left45 },
    { 24,  20,  1, 14, upHalfHelixLarge, left45 }, { 25,  20,  1, 14, upHalfHelixLarge, left45 }, { 26,  20,  1, 14, upHalfHelixLarge, left45 }, { 27,  21,  1, 14, upHalfHelixLarge, left45 },
    { 28,  21,  1, 14, upHalfHelixLarge, left45 }, { 29,  21,  2, 14, upHalfHelixLarge, left45 }, { 30,  22,  2, 14, upHalfHelixLarge, left45 }, { 31,  22,  2, 14, upHalfHelixLarge, left45 },
    { 32,  23,  2, 14, upHalfHelixLarge, left45 }, { 33,  23,  2, 14, upHalfHelixLarge, left45 }, { 34,  24,  2, 14, upHalfHelixLarge, left45 }, { 35,  24,  2, 14, upHalfHelixLarge, left45 },
    { 36,  25,  2, 14, upHalfHelixLarge, left45 }, { 37,  25,  2, 13, upHalfHelixLarge, left45 }, { 38,  26,  2, 13, upHalfHelixLarge, left45 }, { 39,  26,  2, 13, upHalfHelixLarge, left45 },
    { 40,  27,  2, 13, upHalfHelixLarge, left45 }, { 41,  28,  2, 13, upHalfHelixLarge, left45 }, { 42,  28,  2, 13, upHalfHelixLarge, left45 }, { 43,  29,  3, 13, upHalfHelixLarge, left45 },
    { 44,  30,  3, 13, upHalfHelixLarge, left45 }, { 45,  30,  3, 13, upHalfHelixLarge, left45 }, { 46,  31,  3, 13, upHalfHelixLarge, left45 }, { 47,  32,  3, 13, upHalfHelixLarge, left45 },
    { 48,  32,  3, 13, upHalfHelixLarge, left45 }, { 49,  33,  3, 13, upHalfHelixLarge, left45 }, { 50,  34,  3, 12, upHalfHelixLarge, left45 }, { 51,  35,  3, 12, upHalfHelixLarge, left45 },
    { 52,  35,  3, 12, upHalfHelixLarge, left45 }, { 53,  36,  3, 12, upHalfHelixLarge, left45 }, { 54,  37,  3, 12, upHalfHelixLarge, left45 }, { 55,  38,  3, 12, upHalfHelixLarge, left45 },
    { 56,  39,  3, 12, upHalfHelixLarge, left45 }, { 57,  39,  4, 12, upHalfHelixLarge, left45 }, { 58,  40,  4, 12, upHalfHelixLarge, left45 }, { 59,  41,  4, 12, upHalfHelixLarge, left45 },
    { 60,  42,  4, 12, upHalfHelixLarge, left45 }, { 61,  43,  4, 12, upHalfHelixLarge, left45 }, { 61,  44,  4, 12, upHalfHelixLarge, left45 }, { 62,  45,  4, 11, upHalfHelixLarge, left45 },
    { 63,  46,  4, 11, upHalfHelixLarge, left45 }, { 64,  47,  4, 11, upHalfHelixLarge, left45 }, { 64,  48,  4, 11, upHalfHelixLarge, left45 }, { 65,  49,  4, 11, upHalfHelixLarge, left45 },
    { 66,  50,  4, 11, upHalfHelixLarge, left45 }, { 66,  51,  4, 11, upHalfHelixLarge, left45 }, { 67,  52,  4, 11, upHalfHelixLarge, left45 }, { 68,  53,  4, 11, upHalfHelixLarge, left45 },
    { 68,  54,  5, 11, upHalfHelixLarge, left45 }, { 69,  55,  5, 11, upHalfHelixLarge, left45 }, { 70,  56,  5, 11, upHalfHelixLarge, left45 }, { 70,  57,  5, 11, upHalfHelixLarge, left45 },
    { 71,  58,  5, 10, upHalfHelixLarge, left45 }, { 71,  59,  5, 10, upHalfHelixLarge, left45 }, { 72,  60,  5, 10, upHalfHelixLarge, left45 }, { 72,  61,  5, 10, upHalfHelixLarge, left45 },
    { 73,  62,  5, 10, upHalfHelixLarge, left45 }, { 73,  63,  5, 10, upHalfHelixLarge, left45 }, { 74,  64,  5, 10, upHalfHelixLarge, left45 }, { 74,  65,  5, 10, upHalfHelixLarge, left45 },
    { 75,  66,  5, 10, upHalfHelixLarge, left45 }, { 75,  67,  5, 10, upHalfHelixLarge, left45 }, { 75,  68,  6, 10, upHalfHelixLarge, left45 }, { 76,  69,  6, 10, upHalfHelixLarge, left45 },
    { 76,  70,  6, 10, upHalfHelixLarge, left45 }, { 76,  71,  6, 10, upHalfHelixLarge, left45 }, { 77,  72,  6,  9, upHalfHelixLarge, left45 }, { 77,  73,  6,  9, upHalfHelixLarge, left45 },
    { 77,  74,  6,  9, upHalfHelixLarge, left45 }, { 77,  75,  6,  9, upHalfHelixLarge, left45 }, { 78,  76,  6,  9, upHalfHelixLarge, left45 }, { 78,  77,  6,  9, upHalfHelixLarge, left45 },
    { 78,  78,  6,  9, upHalfHelixLarge, left45 }, { 78,  79,  6,  9, upHalfHelixLarge, left45 }, { 78,  80,  6,  9, upHalfHelixLarge, left45 }, { 79,  81,  6,  9, upHalfHelixLarge, left45 },
    { 79,  82,  7,  9, upHalfHelixLarge, left45 }, { 79,  83,  7,  9, upHalfHelixLarge, left45 }, { 79,  84,  7,  9, upHalfHelixLarge, left45 }, { 79,  85,  7,  9, upHalfHelixLarge, left45 },
    { 79,  86,  7,  9, upHalfHelixLarge, left45 }, { 80,  87,  7,  9, upHalfHelixLarge, left45 }, { 80,  88,  7,  8, upHalfHelixLarge, left45 }, { 80,  89,  7,  8, upHalfHelixLarge, left45 },
    { 80,  90,  7,  8, upHalfHelixLarge, left45 }, { 80,  91,  7,  8, upHalfHelixLarge, left45 }, { 80,  92,  7,  8, upHalfHelixLarge, left45 }, { 80,  93,  7,  8, upHalfHelixLarge, left45 },
    { 80,  94,  7,  8, upHalfHelixLarge, left45 }, { 80,  95,  7,  8, upHalfHelixLarge, left45 }, { 80,  96,  8,  8, upHalfHelixLarge, left45 }, { 80,  97,  8,  8, upHalfHelixLarge, left45 },
    { 80,  98,  8,  8, upHalfHelixLarge, left45 }, { 80,  99,  8,  8, upHalfHelixLarge, left45 }, { 80, 100,  8,  8, upHalfHelixLarge, left45 }, { 80, 101,  8,  8, upHalfHelixLarge, left45 },
    { 80, 102,  8,  8, upHalfHelixLarge, left45 }, { 80, 103,  8,  8, upHalfHelixLarge, left45 }, { 80, 104,  8,  7, upHalfHelixLarge, left45 }, { 79, 105,  8,  7, upHalfHelixLarge, left45 },
    { 79, 106,  8,  7, upHalfHelixLarge, left45 }, { 79, 107,  8,  7, upHalfHelixLarge, left45 }, { 79, 108,  8,  7, upHalfHelixLarge, left45 }, { 79, 109,  8,  7, upHalfHelixLarge, left45 },
    { 79, 110,  8,  7, upHalfHelixLarge, left45 }, { 78, 111,  9,  7, upHalfHelixLarge, left45 }, { 78, 112,  9,  7, upHalfHelixLarge, left45 }, { 78, 113,  9,  7, upHalfHelixLarge, left45 },
    { 78, 114,  9,  7, upHalfHelixLarge, left45 }, { 78, 115,  9,  7, upHalfHelixLarge, left45 }, { 77, 116,  9,  7, upHalfHelixLarge, left45 }, { 77, 117,  9,  7, upHalfHelixLarge, left45 },
    { 77, 118,  9,  6, upHalfHelixLarge, left45 }, { 77, 119,  9,  6, upHalfHelixLarge, left45 }, { 76, 120,  9,  6, upHalfHelixLarge, left45 }, { 76, 121,  9,  6, upHalfHelixLarge, left45 },
    { 76, 122,  9,  6, upHalfHelixLarge, left45 }, { 75, 123,  9,  6, upHalfHelixLarge, left45 }, { 75, 124,  9,  6, upHalfHelixLarge, left45 }, { 75, 125, 10,  6, upHalfHelixLarge, left45 },
    { 74, 126, 10,  6, upHalfHelixLarge, left45 }, { 74, 127, 10,  6, upHalfHelixLarge, left45 }, { 73, 128, 10,  6, upHalfHelixLarge, left45 }, { 73, 129, 10,  6, upHalfHelixLarge, left45 },
    { 72, 130, 10,  6, upHalfHelixLarge, left45 }, { 72, 131, 10,  6, upHalfHelixLarge, left45 }, { 71, 132, 10,  6, upHalfHelixLarge, left45 }, { 71, 133, 10,  5, upHalfHelixLarge, left45 },
    { 70, 134, 10,  5, upHalfHelixLarge, left45 }, { 70, 135, 10,  5, upHalfHelixLarge, left45 }, { 69, 136, 10,  5, upHalfHelixLarge, left45 }, { 68, 137, 10,  5, upHalfHelixLarge, left45 },
    { 68, 138, 10,  5, upHalfHelixLarge, left45 }, { 67, 139, 10,  5, upHalfHelixLarge, left45 }, { 66, 140, 11,  5, upHalfHelixLarge, left45 }, { 66, 141, 11,  5, upHalfHelixLarge, left45 },
    { 65, 142, 11,  5, upHalfHelixLarge, left45 }, { 64, 143, 11,  5, upHalfHelixLarge, left45 }, { 64, 144, 11,  5, upHalfHelixLarge, left45 }, { 63, 145, 11,  5, upHalfHelixLarge, left45 },
    { 62, 146, 11,  4, upHalfHelixLarge, left45 }, { 61, 147, 11,  4, upHalfHelixLarge, left45 }, { 61, 148, 11,  4, upHalfHelixLarge, left45 }, { 60, 149, 11,  4, upHalfHelixLarge, left45 },
    { 59, 150, 11,  4, upHalfHelixLarge, left45 }, { 58, 151, 11,  4, upHalfHelixLarge, left45 }, { 57, 152, 11,  4, upHalfHelixLarge, left45 }, { 57, 153, 11,  4, upHalfHelixLarge, left45 },
    { 56, 154, 12,  4, upHalfHelixLarge, left45 }, { 55, 155, 12,  4, upHalfHelixLarge, left45 }, { 54, 156, 12,  4, upHalfHelixLarge, left45 }, { 53, 157, 12,  4, upHalfHelixLarge, left45 },
    { 52, 157, 12,  4, upHalfHelixLarge, left45 }, { 51, 158, 12,  3, upHalfHelixLarge, left45 }, { 50, 159, 12,  3, upHalfHelixLarge, left45 }, { 49, 160, 12,  3, upHalfHelixLarge, left45 },
    { 48, 160, 12,  3, upHalfHelixLarge, left45 }, { 47, 161, 12,  3, upHalfHelixLarge, left45 }, { 46, 162, 12,  3, upHalfHelixLarge, left45 }, { 45, 162, 12,  3, upHalfHelixLarge, left45 },
    { 44, 163, 12,  3, upHalfHelixLarge, left45 }, { 43, 164, 12,  3, upHalfHelixLarge, left45 }, { 42, 164, 13,  3, upHalfHelixLarge, left45 }, { 41, 165, 13,  3, upHalfHelixLarge, left45 },
    { 40, 166, 13,  3, upHalfHelixLarge, left45 }, { 39, 166, 13,  3, upHalfHelixLarge, left45 }, { 38, 167, 13,  2, upHalfHelixLarge, left45 }, { 37, 167, 13,  2, upHalfHelixLarge, left45 },
    { 36, 168, 13,  2, upHalfHelixLarge, left45 }, { 35, 168, 13,  2, upHalfHelixLarge, left45 }, { 34, 169, 13,  2, upHalfHelixLarge, left45 }, { 33, 169, 13,  2, upHalfHelixLarge, left45 },
    { 32, 170, 13,  2, upHalfHelixLarge, left45 }, { 31, 170, 13,  2, upHalfHelixLarge, left45 }, { 30, 171, 13,  2, upHalfHelixLarge, left45 }, { 29, 171, 13,  2, upHalfHelixLarge, left45 },
    { 28, 171, 13,  2, upHalfHelixLarge, left45 }, { 27, 172, 14,  2, upHalfHelixLarge, left45 }, { 26, 172, 14,  2, upHalfHelixLarge, left45 }, { 25, 172, 14,  2, upHalfHelixLarge, left45 },
    { 24, 173, 14,  1, upHalfHelixLarge, left45 }, { 23, 173, 14,  1, upHalfHelixLarge, left45 }, { 22, 173, 14,  1, upHalfHelixLarge, left45 }, { 21, 173, 14,  1, upHalfHelixLarge, left45 },
    { 20, 174, 14,  1, upHalfHelixLarge, left45 }, { 19, 174, 14,  1, upHalfHelixLarge, left45 }, { 18, 174, 14,  1, upHalfHelixLarge, left45 }, { 17, 174, 14,  1, upHalfHelixLarge, left45 },
    { 16, 174, 14,  1, upHalfHelixLarge, left45 }, { 15, 175, 14,  1, upHalfHelixLarge, left45 }, { 14, 175, 14,  1, upHalfHelixLarge, left45 }, { 13, 175, 15,  1, upHalfHelixLarge, left45 },
    { 12, 175, 15,  1, upHalfHelixLarge, left45 }, { 11, 175, 15,  1, upHalfHelixLarge, left45 }, { 10, 175, 15,  1, upHalfHelixLarge, left45 }, {  9, 176, 15,  1, upHalfHelixLarge, left45 },
    {  8, 176, 15,  0, upHalfHelixLarge, left45 }, {  7, 176, 15,  0, upHalfHelixLarge, left45 }, {  6, 176, 15,  0, upHalfHelixLarge, left45 }, {  5, 176, 15,  0, upHalfHelixLarge, left45 },
    {  4, 176, 15,  0, upHalfHelixLarge, left45 }, {  3, 176, 15,  0, upHalfHelixLarge, left45 }, {  2, 176, 15,  0, upHalfHelixLarge, left45 }, {  1, 176, 15,  0, upHalfHelixLarge, left45 },
    {  0, 176, 15,  0, upHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F243D, {
    {  16,  31,  0, 24, upHalfHelixLarge, left45 }, {  16,  30,  0, 24, upHalfHelixLarge, left45 }, {  16,  29,  0, 24, upHalfHelixLarge, left45 }, {  16,  28,  0, 24, upHalfHelixLarge, left45 },
    {  16,  27,  0, 24, upHalfHelixLarge, left45 }, {  16,  26,  0, 24, upHalfHelixLarge, left45 }, {  16,  25,  0, 24, upHalfHelixLarge, left45 }, {  16,  24,  0, 23, upHalfHelixLarge, left45 },
    {  17,  23,  0, 23, upHalfHelixLarge, left45 }, {  17,  22,  0, 23, upHalfHelixLarge, left45 }, {  17,  21,  0, 23, upHalfHelixLarge, left45 }, {  17,  20,  0, 23, upHalfHelixLarge, left45 },
    {  17,  19,  0, 23, upHalfHelixLarge, left45 }, {  17,  18,  0, 23, upHalfHelixLarge, left45 }, {  18,  17,  1, 23, upHalfHelixLarge, left45 }, {  18,  16,  1, 23, upHalfHelixLarge, left45 },
    {  18,  15,  1, 23, upHalfHelixLarge, left45 }, {  18,  14,  1, 23, upHalfHelixLarge, left45 }, {  18,  13,  1, 23, upHalfHelixLarge, left45 }, {  19,  12,  1, 23, upHalfHelixLarge, left45 },
    {  19,  11,  1, 23, upHalfHelixLarge, left45 }, {  19,  10,  1, 22, upHalfHelixLarge, left45 }, {  19,   9,  1, 22, upHalfHelixLarge, left45 }, {  20,   8,  1, 22, upHalfHelixLarge, left45 },
    {  20,   7,  1, 22, upHalfHelixLarge, left45 }, {  20,   6,  1, 22, upHalfHelixLarge, left45 }, {  21,   5,  1, 22, upHalfHelixLarge, left45 }, {  21,   4,  1, 22, upHalfHelixLarge, left45 },
    {  21,   3,  2, 22, upHalfHelixLarge, left45 }, {  22,   2,  2, 22, upHalfHelixLarge, left45 }, {  22,   1,  2, 22, upHalfHelixLarge, left45 }, {  23,   0,  2, 22, upHalfHelixLarge, left45 },
    {  23,  -1,  2, 22, upHalfHelixLarge, left45 }, {  24,  -2,  2, 22, upHalfHelixLarge, left45 }, {  24,  -3,  2, 22, upHalfHelixLarge, left45 }, {  25,  -4,  2, 22, upHalfHelixLarge, left45 },
    {  25,  -5,  2, 21, upHalfHelixLarge, left45 }, {  26,  -6,  2, 21, upHalfHelixLarge, left45 }, {  26,  -7,  2, 21, upHalfHelixLarge, left45 }, {  27,  -8,  2, 21, upHalfHelixLarge, left45 },
    {  28,  -9,  2, 21, upHalfHelixLarge, left45 }, {  28, -10,  2, 21, upHalfHelixLarge, left45 }, {  29, -11,  3, 21, upHalfHelixLarge, left45 }, {  30, -12,  3, 21, upHalfHelixLarge, left45 },
    {  30, -13,  3, 21, upHalfHelixLarge, left45 }, {  31, -14,  3, 21, upHalfHelixLarge, left45 }, {  32, -15,  3, 21, upHalfHelixLarge, left45 }, {  32, -16,  3, 21, upHalfHelixLarge, left45 },
    {  33, -17,  3, 21, upHalfHelixLarge, left45 }, {  34, -18,  3, 20, upHalfHelixLarge, left45 }, {  35, -19,  3, 20, upHalfHelixLarge, left45 }, {  35, -20,  3, 20, upHalfHelixLarge, left45 },
    {  36, -21,  3, 20, upHalfHelixLarge, left45 }, {  37, -22,  3, 20, upHalfHelixLarge, left45 }, {  38, -23,  3, 20, upHalfHelixLarge, left45 }, {  39, -24,  3, 20, upHalfHelixLarge, left45 },
    {  39, -25,  4, 20, upHalfHelixLarge, left45 }, {  40, -26,  4, 20, upHalfHelixLarge, left45 }, {  41, -27,  4, 20, upHalfHelixLarge, left45 }, {  42, -28,  4, 20, upHalfHelixLarge, left45 },
    {  43, -29,  4, 20, upHalfHelixLarge, left45 }, {  44, -29,  4, 20, upHalfHelixLarge, left45 }, {  45, -30,  4, 19, upHalfHelixLarge, left45 }, {  46, -31,  4, 19, upHalfHelixLarge, left45 },
    {  47, -32,  4, 19, upHalfHelixLarge, left45 }, {  48, -32,  4, 19, upHalfHelixLarge, left45 }, {  49, -33,  4, 19, upHalfHelixLarge, left45 }, {  50, -34,  4, 19, upHalfHelixLarge, left45 },
    {  51, -34,  4, 19, upHalfHelixLarge, left45 }, {  52, -35,  4, 19, upHalfHelixLarge, left45 }, {  53, -36,  5, 19, upHalfHelixLarge, left45 }, {  54, -36,  5, 19, upHalfHelixLarge, left45 },
    {  55, -37,  5, 19, upHalfHelixLarge, left45 }, {  56, -38,  5, 19, upHalfHelixLarge, left45 }, {  57, -38,  5, 19, upHalfHelixLarge, left45 }, {  58, -39,  5, 18, upHalfHelixLarge, left45 },
    {  59, -39,  5, 18, upHalfHelixLarge, left45 }, {  60, -40,  5, 18, upHalfHelixLarge, left45 }, {  61, -40,  5, 18, upHalfHelixLarge, left45 }, {  62, -41,  5, 18, upHalfHelixLarge, left45 },
    {  63, -41,  5, 18, upHalfHelixLarge, left45 }, {  64, -42,  5, 18, upHalfHelixLarge, left45 }, {  65, -42,  5, 18, upHalfHelixLarge, left45 }, {  66, -43,  5, 18, upHalfHelixLarge, left45 },
    {  67, -43,  6, 18, upHalfHelixLarge, left45 }, {  68, -43,  6, 18, upHalfHelixLarge, left45 }, {  69, -44,  6, 18, upHalfHelixLarge, left45 }, {  70, -44,  6, 18, upHalfHelixLarge, left45 },
    {  71, -44,  6, 18, upHalfHelixLarge, left45 }, {  72, -45,  6, 17, upHalfHelixLarge, left45 }, {  73, -45,  6, 17, upHalfHelixLarge, left45 }, {  74, -45,  6, 17, upHalfHelixLarge, left45 },
    {  75, -45,  6, 17, upHalfHelixLarge, left45 }, {  76, -46,  6, 17, upHalfHelixLarge, left45 }, {  77, -46,  6, 17, upHalfHelixLarge, left45 }, {  78, -46,  6, 17, upHalfHelixLarge, left45 },
    {  79, -46,  6, 17, upHalfHelixLarge, left45 }, {  80, -46,  6, 17, upHalfHelixLarge, left45 }, {  81, -47,  7, 17, upHalfHelixLarge, left45 }, {  82, -47,  7, 17, upHalfHelixLarge, left45 },
    {  83, -47,  7, 17, upHalfHelixLarge, left45 }, {  84, -47,  7, 17, upHalfHelixLarge, left45 }, {  85, -47,  7, 17, upHalfHelixLarge, left45 }, {  86, -47,  7, 17, upHalfHelixLarge, left45 },
    {  87, -48,  7, 17, upHalfHelixLarge, left45 }, {  88, -48,  7, 16, upHalfHelixLarge, left45 }, {  89, -48,  7, 16, upHalfHelixLarge, left45 }, {  90, -48,  7, 16, upHalfHelixLarge, left45 },
    {  91, -48,  7, 16, upHalfHelixLarge, left45 }, {  92, -48,  7, 16, upHalfHelixLarge, left45 }, {  93, -48,  7, 16, upHalfHelixLarge, left45 }, {  94, -48,  7, 16, upHalfHelixLarge, left45 },
    {  95, -48,  8, 16, upHalfHelixLarge, left45 }, {  96, -48,  8, 16, upHalfHelixLarge, left45 }, {  97, -48,  8, 16, upHalfHelixLarge, left45 }, {  98, -48,  8, 16, upHalfHelixLarge, left45 },
    {  99, -48,  8, 16, upHalfHelixLarge, left45 }, { 100, -48,  8, 16, upHalfHelixLarge, left45 }, { 101, -48,  8, 16, upHalfHelixLarge, left45 }, { 102, -48,  8, 16, upHalfHelixLarge, left45 },
    { 103, -48,  8, 16, upHalfHelixLarge, left45 }, { 104, -48,  8, 15, upHalfHelixLarge, left45 }, { 105, -47,  8, 15, upHalfHelixLarge, left45 }, { 106, -47,  8, 15, upHalfHelixLarge, left45 },
    { 107, -47,  8, 15, upHalfHelixLarge, left45 }, { 108, -47,  8, 15, upHalfHelixLarge, left45 }, { 109, -47,  8, 15, upHalfHelixLarge, left45 }, { 110, -47,  8, 15, upHalfHelixLarge, left45 },
    { 111, -46,  9, 15, upHalfHelixLarge, left45 }, { 112, -46,  9, 15, upHalfHelixLarge, left45 }, { 113, -46,  9, 15, upHalfHelixLarge, left45 }, { 114, -46,  9, 15, upHalfHelixLarge, left45 },
    { 115, -46,  9, 15, upHalfHelixLarge, left45 }, { 116, -45,  9, 15, upHalfHelixLarge, left45 }, { 117, -45,  9, 15, upHalfHelixLarge, left45 }, { 118, -45,  9, 14, upHalfHelixLarge, left45 },
    { 119, -45,  9, 14, upHalfHelixLarge, left45 }, { 120, -44,  9, 14, upHalfHelixLarge, left45 }, { 121, -44,  9, 14, upHalfHelixLarge, left45 }, { 122, -44,  9, 14, upHalfHelixLarge, left45 },
    { 123, -43,  9, 14, upHalfHelixLarge, left45 }, { 124, -43,  9, 14, upHalfHelixLarge, left45 }, { 125, -43, 10, 14, upHalfHelixLarge, left45 }, { 126, -42, 10, 14, upHalfHelixLarge, left45 },
    { 127, -42, 10, 14, upHalfHelixLarge, left45 }, { 128, -41, 10, 14, upHalfHelixLarge, left45 }, { 129, -41, 10, 14, upHalfHelixLarge, left45 }, { 130, -40, 10, 14, upHalfHelixLarge, left45 },
    { 131, -40, 10, 14, upHalfHelixLarge, left45 }, { 132, -39, 10, 14, upHalfHelixLarge, left45 }, { 133, -39, 10, 13, upHalfHelixLarge, left45 }, { 134, -38, 10, 13, upHalfHelixLarge, left45 },
    { 135, -38, 10, 13, upHalfHelixLarge, left45 }, { 136, -37, 10, 13, upHalfHelixLarge, left45 }, { 137, -36, 10, 13, upHalfHelixLarge, left45 }, { 138, -36, 10, 13, upHalfHelixLarge, left45 },
    { 139, -35, 11, 13, upHalfHelixLarge, left45 }, { 140, -34, 11, 13, upHalfHelixLarge, left45 }, { 141, -34, 11, 13, upHalfHelixLarge, left45 }, { 142, -33, 11, 13, upHalfHelixLarge, left45 },
    { 143, -32, 11, 13, upHalfHelixLarge, left45 }, { 144, -32, 11, 13, upHalfHelixLarge, left45 }, { 145, -31, 11, 13, upHalfHelixLarge, left45 }, { 146, -30, 11, 12, upHalfHelixLarge, left45 },
    { 147, -29, 11, 12, upHalfHelixLarge, left45 }, { 148, -29, 11, 12, upHalfHelixLarge, left45 }, { 149, -28, 11, 12, upHalfHelixLarge, left45 }, { 150, -27, 11, 12, upHalfHelixLarge, left45 },
    { 151, -26, 11, 12, upHalfHelixLarge, left45 }, { 152, -25, 11, 12, upHalfHelixLarge, left45 }, { 153, -25, 12, 12, upHalfHelixLarge, left45 }, { 154, -24, 12, 12, upHalfHelixLarge, left45 },
    { 155, -23, 12, 12, upHalfHelixLarge, left45 }, { 156, -22, 12, 12, upHalfHelixLarge, left45 }, { 157, -21, 12, 12, upHalfHelixLarge, left45 }, { 157, -20, 12, 12, upHalfHelixLarge, left45 },
    { 158, -19, 12, 11, upHalfHelixLarge, left45 }, { 159, -18, 12, 11, upHalfHelixLarge, left45 }, { 160, -17, 12, 11, upHalfHelixLarge, left45 }, { 160, -16, 12, 11, upHalfHelixLarge, left45 },
    { 161, -15, 12, 11, upHalfHelixLarge, left45 }, { 162, -14, 12, 11, upHalfHelixLarge, left45 }, { 162, -13, 12, 11, upHalfHelixLarge, left45 }, { 163, -12, 12, 11, upHalfHelixLarge, left45 },
    { 164, -11, 12, 11, upHalfHelixLarge, left45 }, { 164, -10, 13, 11, upHalfHelixLarge, left45 }, { 165,  -9, 13, 11, upHalfHelixLarge, left45 }, { 166,  -8, 13, 11, upHalfHelixLarge, left45 },
    { 166,  -7, 13, 11, upHalfHelixLarge, left45 }, { 167,  -6, 13, 10, upHalfHelixLarge, left45 }, { 167,  -5, 13, 10, upHalfHelixLarge, left45 }, { 168,  -4, 13, 10, upHalfHelixLarge, left45 },
    { 168,  -3, 13, 10, upHalfHelixLarge, left45 }, { 169,  -2, 13, 10, upHalfHelixLarge, left45 }, { 169,  -1, 13, 10, upHalfHelixLarge, left45 }, { 170,   0, 13, 10, upHalfHelixLarge, left45 },
    { 170,   1, 13, 10, upHalfHelixLarge, left45 }, { 171,   2, 13, 10, upHalfHelixLarge, left45 }, { 171,   3, 13, 10, upHalfHelixLarge, left45 }, { 171,   4, 14, 10, upHalfHelixLarge, left45 },
    { 172,   5, 14, 10, upHalfHelixLarge, left45 }, { 172,   6, 14, 10, upHalfHelixLarge, left45 }, { 172,   7, 14, 10, upHalfHelixLarge, left45 }, { 173,   8, 14,  9, upHalfHelixLarge, left45 },
    { 173,   9, 14,  9, upHalfHelixLarge, left45 }, { 173,  10, 14,  9, upHalfHelixLarge, left45 }, { 173,  11, 14,  9, upHalfHelixLarge, left45 }, { 174,  12, 14,  9, upHalfHelixLarge, left45 },
    { 174,  13, 14,  9, upHalfHelixLarge, left45 }, { 174,  14, 14,  9, upHalfHelixLarge, left45 }, { 174,  15, 14,  9, upHalfHelixLarge, left45 }, { 174,  16, 14,  9, upHalfHelixLarge, left45 },
    { 175,  17, 14,  9, upHalfHelixLarge, left45 }, { 175,  18, 15,  9, upHalfHelixLarge, left45 }, { 175,  19, 15,  9, upHalfHelixLarge, left45 }, { 175,  20, 15,  9, upHalfHelixLarge, left45 },
    { 175,  21, 15,  9, upHalfHelixLarge, left45 }, { 175,  22, 15,  9, upHalfHelixLarge, left45 }, { 176,  23, 15,  9, upHalfHelixLarge, left45 }, { 176,  24, 15,  8, upHalfHelixLarge, left45 },
    { 176,  25, 15,  8, upHalfHelixLarge, left45 }, { 176,  26, 15,  8, upHalfHelixLarge, left45 }, { 176,  27, 15,  8, upHalfHelixLarge, left45 }, { 176,  28, 15,  8, upHalfHelixLarge, left45 },
    { 176,  29, 15,  8, upHalfHelixLarge, left45 }, { 176,  30, 15,  8, upHalfHelixLarge, left45 }, { 176,  31, 15,  8, upHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F2C3A, {
    {  31,  16,  0,  0, upHalfHelixLarge, right45 }, {  30,  16,  0,  0, upHalfHelixLarge, right45 }, {  29,  16,  0,  0, upHalfHelixLarge, right45 }, {  28,  16,  0,  0, upHalfHelixLarge, right45 },
    {  27,  16,  0,  0, upHalfHelixLarge, right45 }, {  26,  16,  0,  0, upHalfHelixLarge, right45 }, {  25,  16,  0,  0, upHalfHelixLarge, right45 }, {  24,  16,  0,  1, upHalfHelixLarge, right45 },
    {  23,  17,  0,  1, upHalfHelixLarge, right45 }, {  22,  17,  0,  1, upHalfHelixLarge, right45 }, {  21,  17,  0,  1, upHalfHelixLarge, right45 }, {  20,  17,  0,  1, upHalfHelixLarge, right45 },
    {  19,  17,  0,  1, upHalfHelixLarge, right45 }, {  18,  17,  0,  1, upHalfHelixLarge, right45 }, {  17,  18,  1,  1, upHalfHelixLarge, right45 }, {  16,  18,  1,  1, upHalfHelixLarge, right45 },
    {  15,  18,  1,  1, upHalfHelixLarge, right45 }, {  14,  18,  1,  1, upHalfHelixLarge, right45 }, {  13,  18,  1,  1, upHalfHelixLarge, right45 }, {  12,  19,  1,  1, upHalfHelixLarge, right45 },
    {  11,  19,  1,  1, upHalfHelixLarge, right45 }, {  10,  19,  1,  2, upHalfHelixLarge, right45 }, {   9,  19,  1,  2, upHalfHelixLarge, right45 }, {   8,  20,  1,  2, upHalfHelixLarge, right45 },
    {   7,  20,  1,  2, upHalfHelixLarge, right45 }, {   6,  20,  1,  2, upHalfHelixLarge, right45 }, {   5,  21,  1,  2, upHalfHelixLarge, right45 }, {   4,  21,  1,  2, upHalfHelixLarge, right45 },
    {   3,  21,  2,  2, upHalfHelixLarge, right45 }, {   2,  22,  2,  2, upHalfHelixLarge, right45 }, {   1,  22,  2,  2, upHalfHelixLarge, right45 }, {   0,  23,  2,  2, upHalfHelixLarge, right45 },
    {  -1,  23,  2,  2, upHalfHelixLarge, right45 }, {  -2,  24,  2,  2, upHalfHelixLarge, right45 }, {  -3,  24,  2,  2, upHalfHelixLarge, right45 }, {  -4,  25,  2,  2, upHalfHelixLarge, right45 },
    {  -5,  25,  2,  3, upHalfHelixLarge, right45 }, {  -6,  26,  2,  3, upHalfHelixLarge, right45 }, {  -7,  26,  2,  3, upHalfHelixLarge, right45 }, {  -8,  27,  2,  3, upHalfHelixLarge, right45 },
    {  -9,  28,  2,  3, upHalfHelixLarge, right45 }, { -10,  28,  2,  3, upHalfHelixLarge, right45 }, { -11,  29,  3,  3, upHalfHelixLarge, right45 }, { -12,  30,  3,  3, upHalfHelixLarge, right45 },
    { -13,  30,  3,  3, upHalfHelixLarge, right45 }, { -14,  31,  3,  3, upHalfHelixLarge, right45 }, { -15,  32,  3,  3, upHalfHelixLarge, right45 }, { -16,  32,  3,  3, upHalfHelixLarge, right45 },
    { -17,  33,  3,  3, upHalfHelixLarge, right45 }, { -18,  34,  3,  4, upHalfHelixLarge, right45 }, { -19,  35,  3,  4, upHalfHelixLarge, right45 }, { -20,  35,  3,  4, upHalfHelixLarge, right45 },
    { -21,  36,  3,  4, upHalfHelixLarge, right45 }, { -22,  37,  3,  4, upHalfHelixLarge, right45 }, { -23,  38,  3,  4, upHalfHelixLarge, right45 }, { -24,  39,  3,  4, upHalfHelixLarge, right45 },
    { -25,  39,  4,  4, upHalfHelixLarge, right45 }, { -26,  40,  4,  4, upHalfHelixLarge, right45 }, { -27,  41,  4,  4, upHalfHelixLarge, right45 }, { -28,  42,  4,  4, upHalfHelixLarge, right45 },
    { -29,  43,  4,  4, upHalfHelixLarge, right45 }, { -29,  44,  4,  4, upHalfHelixLarge, right45 }, { -30,  45,  4,  5, upHalfHelixLarge, right45 }, { -31,  46,  4,  5, upHalfHelixLarge, right45 },
    { -32,  47,  4,  5, upHalfHelixLarge, right45 }, { -32,  48,  4,  5, upHalfHelixLarge, right45 }, { -33,  49,  4,  5, upHalfHelixLarge, right45 }, { -34,  50,  4,  5, upHalfHelixLarge, right45 },
    { -34,  51,  4,  5, upHalfHelixLarge, right45 }, { -35,  52,  4,  5, upHalfHelixLarge, right45 }, { -36,  53,  5,  5, upHalfHelixLarge, right45 }, { -36,  54,  5,  5, upHalfHelixLarge, right45 },
    { -37,  55,  5,  5, upHalfHelixLarge, right45 }, { -38,  56,  5,  5, upHalfHelixLarge, right45 }, { -38,  57,  5,  5, upHalfHelixLarge, right45 }, { -39,  58,  5,  6, upHalfHelixLarge, right45 },
    { -39,  59,  5,  6, upHalfHelixLarge, right45 }, { -40,  60,  5,  6, upHalfHelixLarge, right45 }, { -40,  61,  5,  6, upHalfHelixLarge, right45 }, { -41,  62,  5,  6, upHalfHelixLarge, right45 },
    { -41,  63,  5,  6, upHalfHelixLarge, right45 }, { -42,  64,  5,  6, upHalfHelixLarge, right45 }, { -42,  65,  5,  6, upHalfHelixLarge, right45 }, { -43,  66,  5,  6, upHalfHelixLarge, right45 },
    { -43,  67,  6,  6, upHalfHelixLarge, right45 }, { -43,  68,  6,  6, upHalfHelixLarge, right45 }, { -44,  69,  6,  6, upHalfHelixLarge, right45 }, { -44,  70,  6,  6, upHalfHelixLarge, right45 },
    { -44,  71,  6,  6, upHalfHelixLarge, right45 }, { -45,  72,  6,  7, upHalfHelixLarge, right45 }, { -45,  73,  6,  7, upHalfHelixLarge, right45 }, { -45,  74,  6,  7, upHalfHelixLarge, right45 },
    { -45,  75,  6,  7, upHalfHelixLarge, right45 }, { -46,  76,  6,  7, upHalfHelixLarge, right45 }, { -46,  77,  6,  7, upHalfHelixLarge, right45 }, { -46,  78,  6,  7, upHalfHelixLarge, right45 },
    { -46,  79,  6,  7, upHalfHelixLarge, right45 }, { -46,  80,  6,  7, upHalfHelixLarge, right45 }, { -47,  81,  7,  7, upHalfHelixLarge, right45 }, { -47,  82,  7,  7, upHalfHelixLarge, right45 },
    { -47,  83,  7,  7, upHalfHelixLarge, right45 }, { -47,  84,  7,  7, upHalfHelixLarge, right45 }, { -47,  85,  7,  7, upHalfHelixLarge, right45 }, { -47,  86,  7,  7, upHalfHelixLarge, right45 },
    { -48,  87,  7,  7, upHalfHelixLarge, right45 }, { -48,  88,  7,  8, upHalfHelixLarge, right45 }, { -48,  89,  7,  8, upHalfHelixLarge, right45 }, { -48,  90,  7,  8, upHalfHelixLarge, right45 },
    { -48,  91,  7,  8, upHalfHelixLarge, right45 }, { -48,  92,  7,  8, upHalfHelixLarge, right45 }, { -48,  93,  7,  8, upHalfHelixLarge, right45 }, { -48,  94,  7,  8, upHalfHelixLarge, right45 },
    { -48,  95,  8,  8, upHalfHelixLarge, right45 }, { -48,  96,  8,  8, upHalfHelixLarge, right45 }, { -48,  97,  8,  8, upHalfHelixLarge, right45 }, { -48,  98,  8,  8, upHalfHelixLarge, right45 },
    { -48,  99,  8,  8, upHalfHelixLarge, right45 }, { -48, 100,  8,  8, upHalfHelixLarge, right45 }, { -48, 101,  8,  8, upHalfHelixLarge, right45 }, { -48, 102,  8,  8, upHalfHelixLarge, right45 },
    { -48, 103,  8,  8, upHalfHelixLarge, right45 }, { -48, 104,  8,  9, upHalfHelixLarge, right45 }, { -47, 105,  8,  9, upHalfHelixLarge, right45 }, { -47, 106,  8,  9, upHalfHelixLarge, right45 },
    { -47, 107,  8,  9, upHalfHelixLarge, right45 }, { -47, 108,  8,  9, upHalfHelixLarge, right45 }, { -47, 109,  8,  9, upHalfHelixLarge, right45 }, { -47, 110,  8,  9, upHalfHelixLarge, right45 },
    { -46, 111,  9,  9, upHalfHelixLarge, right45 }, { -46, 112,  9,  9, upHalfHelixLarge, right45 }, { -46, 113,  9,  9, upHalfHelixLarge, right45 }, { -46, 114,  9,  9, upHalfHelixLarge, right45 },
    { -46, 115,  9,  9, upHalfHelixLarge, right45 }, { -45, 116,  9,  9, upHalfHelixLarge, right45 }, { -45, 117,  9,  9, upHalfHelixLarge, right45 }, { -45, 118,  9, 10, upHalfHelixLarge, right45 },
    { -45, 119,  9, 10, upHalfHelixLarge, right45 }, { -44, 120,  9, 10, upHalfHelixLarge, right45 }, { -44, 121,  9, 10, upHalfHelixLarge, right45 }, { -44, 122,  9, 10, upHalfHelixLarge, right45 },
    { -43, 123,  9, 10, upHalfHelixLarge, right45 }, { -43, 124,  9, 10, upHalfHelixLarge, right45 }, { -43, 125, 10, 10, upHalfHelixLarge, right45 }, { -42, 126, 10, 10, upHalfHelixLarge, right45 },
    { -42, 127, 10, 10, upHalfHelixLarge, right45 }, { -41, 128, 10, 10, upHalfHelixLarge, right45 }, { -41, 129, 10, 10, upHalfHelixLarge, right45 }, { -40, 130, 10, 10, upHalfHelixLarge, right45 },
    { -40, 131, 10, 10, upHalfHelixLarge, right45 }, { -39, 132, 10, 10, upHalfHelixLarge, right45 }, { -39, 133, 10, 11, upHalfHelixLarge, right45 }, { -38, 134, 10, 11, upHalfHelixLarge, right45 },
    { -38, 135, 10, 11, upHalfHelixLarge, right45 }, { -37, 136, 10, 11, upHalfHelixLarge, right45 }, { -36, 137, 10, 11, upHalfHelixLarge, right45 }, { -36, 138, 10, 11, upHalfHelixLarge, right45 },
    { -35, 139, 11, 11, upHalfHelixLarge, right45 }, { -34, 140, 11, 11, upHalfHelixLarge, right45 }, { -34, 141, 11, 11, upHalfHelixLarge, right45 }, { -33, 142, 11, 11, upHalfHelixLarge, right45 },
    { -32, 143, 11, 11, upHalfHelixLarge, right45 }, { -32, 144, 11, 11, upHalfHelixLarge, right45 }, { -31, 145, 11, 11, upHalfHelixLarge, right45 }, { -30, 146, 11, 12, upHalfHelixLarge, right45 },
    { -29, 147, 11, 12, upHalfHelixLarge, right45 }, { -29, 148, 11, 12, upHalfHelixLarge, right45 }, { -28, 149, 11, 12, upHalfHelixLarge, right45 }, { -27, 150, 11, 12, upHalfHelixLarge, right45 },
    { -26, 151, 11, 12, upHalfHelixLarge, right45 }, { -25, 152, 11, 12, upHalfHelixLarge, right45 }, { -25, 153, 12, 12, upHalfHelixLarge, right45 }, { -24, 154, 12, 12, upHalfHelixLarge, right45 },
    { -23, 155, 12, 12, upHalfHelixLarge, right45 }, { -22, 156, 12, 12, upHalfHelixLarge, right45 }, { -21, 157, 12, 12, upHalfHelixLarge, right45 }, { -20, 157, 12, 12, upHalfHelixLarge, right45 },
    { -19, 158, 12, 13, upHalfHelixLarge, right45 }, { -18, 159, 12, 13, upHalfHelixLarge, right45 }, { -17, 160, 12, 13, upHalfHelixLarge, right45 }, { -16, 160, 12, 13, upHalfHelixLarge, right45 },
    { -15, 161, 12, 13, upHalfHelixLarge, right45 }, { -14, 162, 12, 13, upHalfHelixLarge, right45 }, { -13, 162, 12, 13, upHalfHelixLarge, right45 }, { -12, 163, 12, 13, upHalfHelixLarge, right45 },
    { -11, 164, 12, 13, upHalfHelixLarge, right45 }, { -10, 164, 13, 13, upHalfHelixLarge, right45 }, {  -9, 165, 13, 13, upHalfHelixLarge, right45 }, {  -8, 166, 13, 13, upHalfHelixLarge, right45 },
    {  -7, 166, 13, 13, upHalfHelixLarge, right45 }, {  -6, 167, 13, 14, upHalfHelixLarge, right45 }, {  -5, 167, 13, 14, upHalfHelixLarge, right45 }, {  -4, 168, 13, 14, upHalfHelixLarge, right45 },
    {  -3, 168, 13, 14, upHalfHelixLarge, right45 }, {  -2, 169, 13, 14, upHalfHelixLarge, right45 }, {  -1, 169, 13, 14, upHalfHelixLarge, right45 }, {   0, 170, 13, 14, upHalfHelixLarge, right45 },
    {   1, 170, 13, 14, upHalfHelixLarge, right45 }, {   2, 171, 13, 14, upHalfHelixLarge, right45 }, {   3, 171, 13, 14, upHalfHelixLarge, right45 }, {   4, 171, 14, 14, upHalfHelixLarge, right45 },
    {   5, 172, 14, 14, upHalfHelixLarge, right45 }, {   6, 172, 14, 14, upHalfHelixLarge, right45 }, {   7, 172, 14, 14, upHalfHelixLarge, right45 }, {   8, 173, 14, 15, upHalfHelixLarge, right45 },
    {   9, 173, 14, 15, upHalfHelixLarge, right45 }, {  10, 173, 14, 15, upHalfHelixLarge, right45 }, {  11, 173, 14, 15, upHalfHelixLarge, right45 }, {  12, 174, 14, 15, upHalfHelixLarge, right45 },
    {  13, 174, 14, 15, upHalfHelixLarge, right45 }, {  14, 174, 14, 15, upHalfHelixLarge, right45 }, {  15, 174, 14, 15, upHalfHelixLarge, right45 }, {  16, 174, 14, 15, upHalfHelixLarge, right45 },
    {  17, 175, 14, 15, upHalfHelixLarge, right45 }, {  18, 175, 15, 15, upHalfHelixLarge, right45 }, {  19, 175, 15, 15, upHalfHelixLarge, right45 }, {  20, 175, 15, 15, upHalfHelixLarge, right45 },
    {  21, 175, 15, 15, upHalfHelixLarge, right45 }, {  22, 175, 15, 15, upHalfHelixLarge, right45 }, {  23, 176, 15, 15, upHalfHelixLarge, right45 }, {  24, 176, 15, 16, upHalfHelixLarge, right45 },
    {  25, 176, 15, 16, upHalfHelixLarge, right45 }, {  26, 176, 15, 16, upHalfHelixLarge, right45 }, {  27, 176, 15, 16, upHalfHelixLarge, right45 }, {  28, 176, 15, 16, upHalfHelixLarge, right45 },
    {  29, 176, 15, 16, upHalfHelixLarge, right45 }, {  30, 176, 15, 16, upHalfHelixLarge, right45 }, {  31, 176, 15, 16, upHalfHelixLarge, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F3437, {
    {  16,  0,  0,  8, upHalfHelixLarge, right45 }, {  16,  1,  0,  8, upHalfHelixLarge, right45 }, {  16,  2,  0,  8, upHalfHelixLarge, right45 }, {  16,  3,  0,  8, upHalfHelixLarge, right45 },
    {  16,  4,  0,  8, upHalfHelixLarge, right45 }, {  16,  5,  0,  8, upHalfHelixLarge, right45 }, {  16,  6,  0,  8, upHalfHelixLarge, right45 }, {  16,  7,  0,  8, upHalfHelixLarge, right45 },
    {  16,  8,  0,  9, upHalfHelixLarge, right45 }, {  17,  9,  0,  9, upHalfHelixLarge, right45 }, {  17, 10,  0,  9, upHalfHelixLarge, right45 }, {  17, 11,  0,  9, upHalfHelixLarge, right45 },
    {  17, 12,  0,  9, upHalfHelixLarge, right45 }, {  17, 13,  0,  9, upHalfHelixLarge, right45 }, {  17, 14,  0,  9, upHalfHelixLarge, right45 }, {  18, 15,  1,  9, upHalfHelixLarge, right45 },
    {  18, 16,  1,  9, upHalfHelixLarge, right45 }, {  18, 17,  1,  9, upHalfHelixLarge, right45 }, {  18, 18,  1,  9, upHalfHelixLarge, right45 }, {  18, 19,  1,  9, upHalfHelixLarge, right45 },
    {  19, 20,  1,  9, upHalfHelixLarge, right45 }, {  19, 21,  1,  9, upHalfHelixLarge, right45 }, {  19, 22,  1, 10, upHalfHelixLarge, right45 }, {  19, 23,  1, 10, upHalfHelixLarge, right45 },
    {  20, 24,  1, 10, upHalfHelixLarge, right45 }, {  20, 25,  1, 10, upHalfHelixLarge, right45 }, {  20, 26,  1, 10, upHalfHelixLarge, right45 }, {  21, 27,  1, 10, upHalfHelixLarge, right45 },
    {  21, 28,  1, 10, upHalfHelixLarge, right45 }, {  21, 29,  2, 10, upHalfHelixLarge, right45 }, {  22, 30,  2, 10, upHalfHelixLarge, right45 }, {  22, 31,  2, 10, upHalfHelixLarge, right45 },
    {  23, 32,  2, 10, upHalfHelixLarge, right45 }, {  23, 33,  2, 10, upHalfHelixLarge, right45 }, {  24, 34,  2, 10, upHalfHelixLarge, right45 }, {  24, 35,  2, 10, upHalfHelixLarge, right45 },
    {  25, 36,  2, 10, upHalfHelixLarge, right45 }, {  25, 37,  2, 11, upHalfHelixLarge, right45 }, {  26, 38,  2, 11, upHalfHelixLarge, right45 }, {  26, 39,  2, 11, upHalfHelixLarge, right45 },
    {  27, 40,  2, 11, upHalfHelixLarge, right45 }, {  28, 41,  2, 11, upHalfHelixLarge, right45 }, {  28, 42,  2, 11, upHalfHelixLarge, right45 }, {  29, 43,  3, 11, upHalfHelixLarge, right45 },
    {  30, 44,  3, 11, upHalfHelixLarge, right45 }, {  30, 45,  3, 11, upHalfHelixLarge, right45 }, {  31, 46,  3, 11, upHalfHelixLarge, right45 }, {  32, 47,  3, 11, upHalfHelixLarge, right45 },
    {  32, 48,  3, 11, upHalfHelixLarge, right45 }, {  33, 49,  3, 11, upHalfHelixLarge, right45 }, {  34, 50,  3, 12, upHalfHelixLarge, right45 }, {  35, 51,  3, 12, upHalfHelixLarge, right45 },
    {  35, 52,  3, 12, upHalfHelixLarge, right45 }, {  36, 53,  3, 12, upHalfHelixLarge, right45 }, {  37, 54,  3, 12, upHalfHelixLarge, right45 }, {  38, 55,  3, 12, upHalfHelixLarge, right45 },
    {  39, 56,  3, 12, upHalfHelixLarge, right45 }, {  39, 57,  4, 12, upHalfHelixLarge, right45 }, {  40, 58,  4, 12, upHalfHelixLarge, right45 }, {  41, 59,  4, 12, upHalfHelixLarge, right45 },
    {  42, 60,  4, 12, upHalfHelixLarge, right45 }, {  43, 61,  4, 12, upHalfHelixLarge, right45 }, {  44, 61,  4, 12, upHalfHelixLarge, right45 }, {  45, 62,  4, 13, upHalfHelixLarge, right45 },
    {  46, 63,  4, 13, upHalfHelixLarge, right45 }, {  47, 64,  4, 13, upHalfHelixLarge, right45 }, {  48, 64,  4, 13, upHalfHelixLarge, right45 }, {  49, 65,  4, 13, upHalfHelixLarge, right45 },
    {  50, 66,  4, 13, upHalfHelixLarge, right45 }, {  51, 66,  4, 13, upHalfHelixLarge, right45 }, {  52, 67,  4, 13, upHalfHelixLarge, right45 }, {  53, 68,  4, 13, upHalfHelixLarge, right45 },
    {  54, 68,  5, 13, upHalfHelixLarge, right45 }, {  55, 69,  5, 13, upHalfHelixLarge, right45 }, {  56, 70,  5, 13, upHalfHelixLarge, right45 }, {  57, 70,  5, 13, upHalfHelixLarge, right45 },
    {  58, 71,  5, 14, upHalfHelixLarge, right45 }, {  59, 71,  5, 14, upHalfHelixLarge, right45 }, {  60, 72,  5, 14, upHalfHelixLarge, right45 }, {  61, 72,  5, 14, upHalfHelixLarge, right45 },
    {  62, 73,  5, 14, upHalfHelixLarge, right45 }, {  63, 73,  5, 14, upHalfHelixLarge, right45 }, {  64, 74,  5, 14, upHalfHelixLarge, right45 }, {  65, 74,  5, 14, upHalfHelixLarge, right45 },
    {  66, 75,  5, 14, upHalfHelixLarge, right45 }, {  67, 75,  5, 14, upHalfHelixLarge, right45 }, {  68, 75,  6, 14, upHalfHelixLarge, right45 }, {  69, 76,  6, 14, upHalfHelixLarge, right45 },
    {  70, 76,  6, 14, upHalfHelixLarge, right45 }, {  71, 76,  6, 14, upHalfHelixLarge, right45 }, {  72, 77,  6, 15, upHalfHelixLarge, right45 }, {  73, 77,  6, 15, upHalfHelixLarge, right45 },
    {  74, 77,  6, 15, upHalfHelixLarge, right45 }, {  75, 77,  6, 15, upHalfHelixLarge, right45 }, {  76, 78,  6, 15, upHalfHelixLarge, right45 }, {  77, 78,  6, 15, upHalfHelixLarge, right45 },
    {  78, 78,  6, 15, upHalfHelixLarge, right45 }, {  79, 78,  6, 15, upHalfHelixLarge, right45 }, {  80, 78,  6, 15, upHalfHelixLarge, right45 }, {  81, 79,  6, 15, upHalfHelixLarge, right45 },
    {  82, 79,  7, 15, upHalfHelixLarge, right45 }, {  83, 79,  7, 15, upHalfHelixLarge, right45 }, {  84, 79,  7, 15, upHalfHelixLarge, right45 }, {  85, 79,  7, 15, upHalfHelixLarge, right45 },
    {  86, 79,  7, 15, upHalfHelixLarge, right45 }, {  87, 80,  7, 15, upHalfHelixLarge, right45 }, {  88, 80,  7, 16, upHalfHelixLarge, right45 }, {  89, 80,  7, 16, upHalfHelixLarge, right45 },
    {  90, 80,  7, 16, upHalfHelixLarge, right45 }, {  91, 80,  7, 16, upHalfHelixLarge, right45 }, {  92, 80,  7, 16, upHalfHelixLarge, right45 }, {  93, 80,  7, 16, upHalfHelixLarge, right45 },
    {  94, 80,  7, 16, upHalfHelixLarge, right45 }, {  95, 80,  7, 16, upHalfHelixLarge, right45 }, {  96, 80,  8, 16, upHalfHelixLarge, right45 }, {  97, 80,  8, 16, upHalfHelixLarge, right45 },
    {  98, 80,  8, 16, upHalfHelixLarge, right45 }, {  99, 80,  8, 16, upHalfHelixLarge, right45 }, { 100, 80,  8, 16, upHalfHelixLarge, right45 }, { 101, 80,  8, 16, upHalfHelixLarge, right45 },
    { 102, 80,  8, 16, upHalfHelixLarge, right45 }, { 103, 80,  8, 16, upHalfHelixLarge, right45 }, { 104, 80,  8, 17, upHalfHelixLarge, right45 }, { 105, 79,  8, 17, upHalfHelixLarge, right45 },
    { 106, 79,  8, 17, upHalfHelixLarge, right45 }, { 107, 79,  8, 17, upHalfHelixLarge, right45 }, { 108, 79,  8, 17, upHalfHelixLarge, right45 }, { 109, 79,  8, 17, upHalfHelixLarge, right45 },
    { 110, 79,  8, 17, upHalfHelixLarge, right45 }, { 111, 78,  9, 17, upHalfHelixLarge, right45 }, { 112, 78,  9, 17, upHalfHelixLarge, right45 }, { 113, 78,  9, 17, upHalfHelixLarge, right45 },
    { 114, 78,  9, 17, upHalfHelixLarge, right45 }, { 115, 78,  9, 17, upHalfHelixLarge, right45 }, { 116, 77,  9, 17, upHalfHelixLarge, right45 }, { 117, 77,  9, 17, upHalfHelixLarge, right45 },
    { 118, 77,  9, 18, upHalfHelixLarge, right45 }, { 119, 77,  9, 18, upHalfHelixLarge, right45 }, { 120, 76,  9, 18, upHalfHelixLarge, right45 }, { 121, 76,  9, 18, upHalfHelixLarge, right45 },
    { 122, 76,  9, 18, upHalfHelixLarge, right45 }, { 123, 75,  9, 18, upHalfHelixLarge, right45 }, { 124, 75,  9, 18, upHalfHelixLarge, right45 }, { 125, 75, 10, 18, upHalfHelixLarge, right45 },
    { 126, 74, 10, 18, upHalfHelixLarge, right45 }, { 127, 74, 10, 18, upHalfHelixLarge, right45 }, { 128, 73, 10, 18, upHalfHelixLarge, right45 }, { 129, 73, 10, 18, upHalfHelixLarge, right45 },
    { 130, 72, 10, 18, upHalfHelixLarge, right45 }, { 131, 72, 10, 18, upHalfHelixLarge, right45 }, { 132, 71, 10, 18, upHalfHelixLarge, right45 }, { 133, 71, 10, 19, upHalfHelixLarge, right45 },
    { 134, 70, 10, 19, upHalfHelixLarge, right45 }, { 135, 70, 10, 19, upHalfHelixLarge, right45 }, { 136, 69, 10, 19, upHalfHelixLarge, right45 }, { 137, 68, 10, 19, upHalfHelixLarge, right45 },
    { 138, 68, 10, 19, upHalfHelixLarge, right45 }, { 139, 67, 10, 19, upHalfHelixLarge, right45 }, { 140, 66, 11, 19, upHalfHelixLarge, right45 }, { 141, 66, 11, 19, upHalfHelixLarge, right45 },
    { 142, 65, 11, 19, upHalfHelixLarge, right45 }, { 143, 64, 11, 19, upHalfHelixLarge, right45 }, { 144, 64, 11, 19, upHalfHelixLarge, right45 }, { 145, 63, 11, 19, upHalfHelixLarge, right45 },
    { 146, 62, 11, 20, upHalfHelixLarge, right45 }, { 147, 61, 11, 20, upHalfHelixLarge, right45 }, { 148, 61, 11, 20, upHalfHelixLarge, right45 }, { 149, 60, 11, 20, upHalfHelixLarge, right45 },
    { 150, 59, 11, 20, upHalfHelixLarge, right45 }, { 151, 58, 11, 20, upHalfHelixLarge, right45 }, { 152, 57, 11, 20, upHalfHelixLarge, right45 }, { 153, 57, 11, 20, upHalfHelixLarge, right45 },
    { 154, 56, 12, 20, upHalfHelixLarge, right45 }, { 155, 55, 12, 20, upHalfHelixLarge, right45 }, { 156, 54, 12, 20, upHalfHelixLarge, right45 }, { 157, 53, 12, 20, upHalfHelixLarge, right45 },
    { 157, 52, 12, 20, upHalfHelixLarge, right45 }, { 158, 51, 12, 21, upHalfHelixLarge, right45 }, { 159, 50, 12, 21, upHalfHelixLarge, right45 }, { 160, 49, 12, 21, upHalfHelixLarge, right45 },
    { 160, 48, 12, 21, upHalfHelixLarge, right45 }, { 161, 47, 12, 21, upHalfHelixLarge, right45 }, { 162, 46, 12, 21, upHalfHelixLarge, right45 }, { 162, 45, 12, 21, upHalfHelixLarge, right45 },
    { 163, 44, 12, 21, upHalfHelixLarge, right45 }, { 164, 43, 12, 21, upHalfHelixLarge, right45 }, { 164, 42, 13, 21, upHalfHelixLarge, right45 }, { 165, 41, 13, 21, upHalfHelixLarge, right45 },
    { 166, 40, 13, 21, upHalfHelixLarge, right45 }, { 166, 39, 13, 21, upHalfHelixLarge, right45 }, { 167, 38, 13, 22, upHalfHelixLarge, right45 }, { 167, 37, 13, 22, upHalfHelixLarge, right45 },
    { 168, 36, 13, 22, upHalfHelixLarge, right45 }, { 168, 35, 13, 22, upHalfHelixLarge, right45 }, { 169, 34, 13, 22, upHalfHelixLarge, right45 }, { 169, 33, 13, 22, upHalfHelixLarge, right45 },
    { 170, 32, 13, 22, upHalfHelixLarge, right45 }, { 170, 31, 13, 22, upHalfHelixLarge, right45 }, { 171, 30, 13, 22, upHalfHelixLarge, right45 }, { 171, 29, 13, 22, upHalfHelixLarge, right45 },
    { 171, 28, 13, 22, upHalfHelixLarge, right45 }, { 172, 27, 14, 22, upHalfHelixLarge, right45 }, { 172, 26, 14, 22, upHalfHelixLarge, right45 }, { 172, 25, 14, 22, upHalfHelixLarge, right45 },
    { 173, 24, 14, 23, upHalfHelixLarge, right45 }, { 173, 23, 14, 23, upHalfHelixLarge, right45 }, { 173, 22, 14, 23, upHalfHelixLarge, right45 }, { 173, 21, 14, 23, upHalfHelixLarge, right45 },
    { 174, 20, 14, 23, upHalfHelixLarge, right45 }, { 174, 19, 14, 23, upHalfHelixLarge, right45 }, { 174, 18, 14, 23, upHalfHelixLarge, right45 }, { 174, 17, 14, 23, upHalfHelixLarge, right45 },
    { 174, 16, 14, 23, upHalfHelixLarge, right45 }, { 175, 15, 14, 23, upHalfHelixLarge, right45 }, { 175, 14, 14, 23, upHalfHelixLarge, right45 }, { 175, 13, 15, 23, upHalfHelixLarge, right45 },
    { 175, 12, 15, 23, upHalfHelixLarge, right45 }, { 175, 11, 15, 23, upHalfHelixLarge, right45 }, { 175, 10, 15, 23, upHalfHelixLarge, right45 }, { 176,  9, 15, 23, upHalfHelixLarge, right45 },
    { 176,  8, 15, 24, upHalfHelixLarge, right45 }, { 176,  7, 15, 24, upHalfHelixLarge, right45 }, { 176,  6, 15, 24, upHalfHelixLarge, right45 }, { 176,  5, 15, 24, upHalfHelixLarge, right45 },
    { 176,  4, 15, 24, upHalfHelixLarge, right45 }, { 176,  3, 15, 24, upHalfHelixLarge, right45 }, { 176,  2, 15, 24, upHalfHelixLarge, right45 }, { 176,  1, 15, 24, upHalfHelixLarge, right45 },
    { 176,  0, 15, 24, upHalfHelixLarge, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F3C46, {
    {  0,   16,  0, 16, upHalfHelixLarge, right45 }, {  1,   16,  0, 16, upHalfHelixLarge, right45 }, {  2,   16,  0, 16, upHalfHelixLarge, right45 }, {  3,   16,  0, 16, upHalfHelixLarge, right45 },
    {  4,   16,  0, 16, upHalfHelixLarge, right45 }, {  5,   16,  0, 16, upHalfHelixLarge, right45 }, {  6,   16,  0, 16, upHalfHelixLarge, right45 }, {  7,   16,  0, 16, upHalfHelixLarge, right45 },
    {  8,   16,  0, 17, upHalfHelixLarge, right45 }, {  9,   15,  0, 17, upHalfHelixLarge, right45 }, { 10,   15,  0, 17, upHalfHelixLarge, right45 }, { 11,   15,  0, 17, upHalfHelixLarge, right45 },
    { 12,   15,  0, 17, upHalfHelixLarge, right45 }, { 13,   15,  0, 17, upHalfHelixLarge, right45 }, { 14,   15,  0, 17, upHalfHelixLarge, right45 }, { 15,   14,  1, 17, upHalfHelixLarge, right45 },
    { 16,   14,  1, 17, upHalfHelixLarge, right45 }, { 17,   14,  1, 17, upHalfHelixLarge, right45 }, { 18,   14,  1, 17, upHalfHelixLarge, right45 }, { 19,   14,  1, 17, upHalfHelixLarge, right45 },
    { 20,   13,  1, 17, upHalfHelixLarge, right45 }, { 21,   13,  1, 17, upHalfHelixLarge, right45 }, { 22,   13,  1, 18, upHalfHelixLarge, right45 }, { 23,   13,  1, 18, upHalfHelixLarge, right45 },
    { 24,   12,  1, 18, upHalfHelixLarge, right45 }, { 25,   12,  1, 18, upHalfHelixLarge, right45 }, { 26,   12,  1, 18, upHalfHelixLarge, right45 }, { 27,   11,  1, 18, upHalfHelixLarge, right45 },
    { 28,   11,  1, 18, upHalfHelixLarge, right45 }, { 29,   11,  2, 18, upHalfHelixLarge, right45 }, { 30,   10,  2, 18, upHalfHelixLarge, right45 }, { 31,   10,  2, 18, upHalfHelixLarge, right45 },
    { 32,    9,  2, 18, upHalfHelixLarge, right45 }, { 33,    9,  2, 18, upHalfHelixLarge, right45 }, { 34,    8,  2, 18, upHalfHelixLarge, right45 }, { 35,    8,  2, 18, upHalfHelixLarge, right45 },
    { 36,    7,  2, 18, upHalfHelixLarge, right45 }, { 37,    7,  2, 19, upHalfHelixLarge, right45 }, { 38,    6,  2, 19, upHalfHelixLarge, right45 }, { 39,    6,  2, 19, upHalfHelixLarge, right45 },
    { 40,    5,  2, 19, upHalfHelixLarge, right45 }, { 41,    4,  2, 19, upHalfHelixLarge, right45 }, { 42,    4,  2, 19, upHalfHelixLarge, right45 }, { 43,    3,  2, 19, upHalfHelixLarge, right45 },
    { 44,    2,  3, 19, upHalfHelixLarge, right45 }, { 45,    2,  3, 19, upHalfHelixLarge, right45 }, { 46,    1,  3, 19, upHalfHelixLarge, right45 }, { 47,    0,  3, 19, upHalfHelixLarge, right45 },
    { 48,    0,  3, 19, upHalfHelixLarge, right45 }, { 49,   -1,  3, 19, upHalfHelixLarge, right45 }, { 50,   -2,  3, 20, upHalfHelixLarge, right45 }, { 51,   -3,  3, 20, upHalfHelixLarge, right45 },
    { 52,   -3,  3, 20, upHalfHelixLarge, right45 }, { 53,   -4,  3, 20, upHalfHelixLarge, right45 }, { 54,   -5,  3, 20, upHalfHelixLarge, right45 }, { 55,   -6,  3, 20, upHalfHelixLarge, right45 },
    { 56,   -7,  3, 20, upHalfHelixLarge, right45 }, { 57,   -7,  3, 20, upHalfHelixLarge, right45 }, { 58,   -8,  4, 20, upHalfHelixLarge, right45 }, { 59,   -9,  4, 20, upHalfHelixLarge, right45 },
    { 60,  -10,  4, 20, upHalfHelixLarge, right45 }, { 61,  -11,  4, 20, upHalfHelixLarge, right45 }, { 61,  -12,  4, 20, upHalfHelixLarge, right45 }, { 62,  -13,  4, 21, upHalfHelixLarge, right45 },
    { 63,  -14,  4, 21, upHalfHelixLarge, right45 }, { 64,  -15,  4, 21, upHalfHelixLarge, right45 }, { 64,  -16,  4, 21, upHalfHelixLarge, right45 }, { 65,  -17,  4, 21, upHalfHelixLarge, right45 },
    { 66,  -18,  4, 21, upHalfHelixLarge, right45 }, { 66,  -19,  4, 21, upHalfHelixLarge, right45 }, { 67,  -20,  4, 21, upHalfHelixLarge, right45 }, { 68,  -21,  4, 21, upHalfHelixLarge, right45 },
    { 68,  -22,  5, 21, upHalfHelixLarge, right45 }, { 69,  -23,  5, 21, upHalfHelixLarge, right45 }, { 70,  -24,  5, 21, upHalfHelixLarge, right45 }, { 70,  -25,  5, 21, upHalfHelixLarge, right45 },
    { 71,  -26,  5, 22, upHalfHelixLarge, right45 }, { 71,  -27,  5, 22, upHalfHelixLarge, right45 }, { 72,  -28,  5, 22, upHalfHelixLarge, right45 }, { 72,  -29,  5, 22, upHalfHelixLarge, right45 },
    { 73,  -30,  5, 22, upHalfHelixLarge, right45 }, { 73,  -31,  5, 22, upHalfHelixLarge, right45 }, { 74,  -32,  5, 22, upHalfHelixLarge, right45 }, { 74,  -33,  5, 22, upHalfHelixLarge, right45 },
    { 75,  -34,  5, 22, upHalfHelixLarge, right45 }, { 75,  -35,  5, 22, upHalfHelixLarge, right45 }, { 75,  -36,  5, 22, upHalfHelixLarge, right45 }, { 76,  -37,  6, 22, upHalfHelixLarge, right45 },
    { 76,  -38,  6, 22, upHalfHelixLarge, right45 }, { 76,  -39,  6, 22, upHalfHelixLarge, right45 }, { 77,  -40,  6, 23, upHalfHelixLarge, right45 }, { 77,  -41,  6, 23, upHalfHelixLarge, right45 },
    { 77,  -42,  6, 23, upHalfHelixLarge, right45 }, { 77,  -43,  6, 23, upHalfHelixLarge, right45 }, { 78,  -44,  6, 23, upHalfHelixLarge, right45 }, { 78,  -45,  6, 23, upHalfHelixLarge, right45 },
    { 78,  -46,  6, 23, upHalfHelixLarge, right45 }, { 78,  -47,  6, 23, upHalfHelixLarge, right45 }, { 78,  -48,  6, 23, upHalfHelixLarge, right45 }, { 79,  -49,  6, 23, upHalfHelixLarge, right45 },
    { 79,  -50,  6, 23, upHalfHelixLarge, right45 }, { 79,  -51,  7, 23, upHalfHelixLarge, right45 }, { 79,  -52,  7, 23, upHalfHelixLarge, right45 }, { 79,  -53,  7, 23, upHalfHelixLarge, right45 },
    { 79,  -54,  7, 23, upHalfHelixLarge, right45 }, { 80,  -55,  7, 23, upHalfHelixLarge, right45 }, { 80,  -56,  7, 24, upHalfHelixLarge, right45 }, { 80,  -57,  7, 24, upHalfHelixLarge, right45 },
    { 80,  -58,  7, 24, upHalfHelixLarge, right45 }, { 80,  -59,  7, 24, upHalfHelixLarge, right45 }, { 80,  -60,  7, 24, upHalfHelixLarge, right45 }, { 80,  -61,  7, 24, upHalfHelixLarge, right45 },
    { 80,  -62,  7, 24, upHalfHelixLarge, right45 }, { 80,  -63,  7, 24, upHalfHelixLarge, right45 }, { 80,  -64,  7, 24, upHalfHelixLarge, right45 }, { 80,  -65,  8, 24, upHalfHelixLarge, right45 },
    { 80,  -66,  8, 24, upHalfHelixLarge, right45 }, { 80,  -67,  8, 24, upHalfHelixLarge, right45 }, { 80,  -68,  8, 24, upHalfHelixLarge, right45 }, { 80,  -69,  8, 24, upHalfHelixLarge, right45 },
    { 80,  -70,  8, 24, upHalfHelixLarge, right45 }, { 80,  -71,  8, 24, upHalfHelixLarge, right45 }, { 80,  -72,  8, 25, upHalfHelixLarge, right45 }, { 79,  -73,  8, 25, upHalfHelixLarge, right45 },
    { 79,  -74,  8, 25, upHalfHelixLarge, right45 }, { 79,  -75,  8, 25, upHalfHelixLarge, right45 }, { 79,  -76,  8, 25, upHalfHelixLarge, right45 }, { 79,  -77,  8, 25, upHalfHelixLarge, right45 },
    { 79,  -78,  8, 25, upHalfHelixLarge, right45 }, { 78,  -79,  9, 25, upHalfHelixLarge, right45 }, { 78,  -80,  9, 25, upHalfHelixLarge, right45 }, { 78,  -81,  9, 25, upHalfHelixLarge, right45 },
    { 78,  -82,  9, 25, upHalfHelixLarge, right45 }, { 78,  -83,  9, 25, upHalfHelixLarge, right45 }, { 77,  -84,  9, 25, upHalfHelixLarge, right45 }, { 77,  -85,  9, 25, upHalfHelixLarge, right45 },
    { 77,  -86,  9, 26, upHalfHelixLarge, right45 }, { 77,  -87,  9, 26, upHalfHelixLarge, right45 }, { 76,  -88,  9, 26, upHalfHelixLarge, right45 }, { 76,  -89,  9, 26, upHalfHelixLarge, right45 },
    { 76,  -90,  9, 26, upHalfHelixLarge, right45 }, { 75,  -91,  9, 26, upHalfHelixLarge, right45 }, { 75,  -92,  9, 26, upHalfHelixLarge, right45 }, { 75,  -93, 10, 26, upHalfHelixLarge, right45 },
    { 74,  -94, 10, 26, upHalfHelixLarge, right45 }, { 74,  -95, 10, 26, upHalfHelixLarge, right45 }, { 73,  -96, 10, 26, upHalfHelixLarge, right45 }, { 73,  -97, 10, 26, upHalfHelixLarge, right45 },
    { 72,  -98, 10, 26, upHalfHelixLarge, right45 }, { 72,  -99, 10, 26, upHalfHelixLarge, right45 }, { 71, -100, 10, 26, upHalfHelixLarge, right45 }, { 71, -101, 10, 27, upHalfHelixLarge, right45 },
    { 70, -102, 10, 27, upHalfHelixLarge, right45 }, { 70, -103, 10, 27, upHalfHelixLarge, right45 }, { 69, -104, 10, 27, upHalfHelixLarge, right45 }, { 68, -105, 10, 27, upHalfHelixLarge, right45 },
    { 68, -106, 10, 27, upHalfHelixLarge, right45 }, { 67, -107, 11, 27, upHalfHelixLarge, right45 }, { 66, -108, 11, 27, upHalfHelixLarge, right45 }, { 66, -109, 11, 27, upHalfHelixLarge, right45 },
    { 65, -110, 11, 27, upHalfHelixLarge, right45 }, { 64, -111, 11, 27, upHalfHelixLarge, right45 }, { 64, -112, 11, 27, upHalfHelixLarge, right45 }, { 63, -113, 11, 27, upHalfHelixLarge, right45 },
    { 62, -114, 11, 28, upHalfHelixLarge, right45 }, { 61, -115, 11, 28, upHalfHelixLarge, right45 }, { 61, -116, 11, 28, upHalfHelixLarge, right45 }, { 60, -117, 11, 28, upHalfHelixLarge, right45 },
    { 59, -118, 11, 28, upHalfHelixLarge, right45 }, { 58, -119, 11, 28, upHalfHelixLarge, right45 }, { 57, -120, 11, 28, upHalfHelixLarge, right45 }, { 57, -121, 12, 28, upHalfHelixLarge, right45 },
    { 56, -122, 12, 28, upHalfHelixLarge, right45 }, { 55, -123, 12, 28, upHalfHelixLarge, right45 }, { 54, -124, 12, 28, upHalfHelixLarge, right45 }, { 53, -125, 12, 28, upHalfHelixLarge, right45 },
    { 52, -125, 12, 28, upHalfHelixLarge, right45 }, { 51, -126, 12, 29, upHalfHelixLarge, right45 }, { 50, -127, 12, 29, upHalfHelixLarge, right45 }, { 49, -128, 12, 29, upHalfHelixLarge, right45 },
    { 48, -128, 12, 29, upHalfHelixLarge, right45 }, { 47, -129, 12, 29, upHalfHelixLarge, right45 }, { 46, -130, 12, 29, upHalfHelixLarge, right45 }, { 45, -130, 12, 29, upHalfHelixLarge, right45 },
    { 44, -131, 12, 29, upHalfHelixLarge, right45 }, { 43, -132, 12, 29, upHalfHelixLarge, right45 }, { 42, -132, 13, 29, upHalfHelixLarge, right45 }, { 41, -133, 13, 29, upHalfHelixLarge, right45 },
    { 40, -134, 13, 29, upHalfHelixLarge, right45 }, { 39, -134, 13, 29, upHalfHelixLarge, right45 }, { 38, -135, 13, 30, upHalfHelixLarge, right45 }, { 37, -135, 13, 30, upHalfHelixLarge, right45 },
    { 36, -136, 13, 30, upHalfHelixLarge, right45 }, { 35, -136, 13, 30, upHalfHelixLarge, right45 }, { 34, -137, 13, 30, upHalfHelixLarge, right45 }, { 33, -137, 13, 30, upHalfHelixLarge, right45 },
    { 32, -138, 13, 30, upHalfHelixLarge, right45 }, { 31, -138, 13, 30, upHalfHelixLarge, right45 }, { 30, -139, 13, 30, upHalfHelixLarge, right45 }, { 29, -139, 13, 30, upHalfHelixLarge, right45 },
    { 28, -139, 14, 30, upHalfHelixLarge, right45 }, { 27, -140, 14, 30, upHalfHelixLarge, right45 }, { 26, -140, 14, 30, upHalfHelixLarge, right45 }, { 25, -140, 14, 30, upHalfHelixLarge, right45 },
    { 24, -141, 14, 31, upHalfHelixLarge, right45 }, { 23, -141, 14, 31, upHalfHelixLarge, right45 }, { 22, -141, 14, 31, upHalfHelixLarge, right45 }, { 21, -141, 14, 31, upHalfHelixLarge, right45 },
    { 20, -142, 14, 31, upHalfHelixLarge, right45 }, { 19, -142, 14, 31, upHalfHelixLarge, right45 }, { 18, -142, 14, 31, upHalfHelixLarge, right45 }, { 17, -142, 14, 31, upHalfHelixLarge, right45 },
    { 16, -142, 14, 31, upHalfHelixLarge, right45 }, { 15, -143, 14, 31, upHalfHelixLarge, right45 }, { 14, -143, 15, 31, upHalfHelixLarge, right45 }, { 13, -143, 15, 31, upHalfHelixLarge, right45 },
    { 12, -143, 15, 31, upHalfHelixLarge, right45 }, { 11, -143, 15, 31, upHalfHelixLarge, right45 }, { 10, -143, 15, 31, upHalfHelixLarge, right45 }, {  9, -144, 15, 31, upHalfHelixLarge, right45 },
    {  8, -144, 15,  0, upHalfHelixLarge, right45 }, {  7, -144, 15,  0, upHalfHelixLarge, right45 }, {  6, -144, 15,  0, upHalfHelixLarge, right45 }, {  5, -144, 15,  0, upHalfHelixLarge, right45 },
    {  4, -144, 15,  0, upHalfHelixLarge, right45 }, {  3, -144, 15,  0, upHalfHelixLarge, right45 }, {  2, -144, 15,  0, upHalfHelixLarge, right45 }, {  1, -144, 15,  0, upHalfHelixLarge, right45 },
    {  0, -144, 16,  0, upHalfHelixLarge, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F4455, {
    {   16,  31,  0, 24, upHalfHelixLarge, right45 }, {   16,  30,  0, 24, upHalfHelixLarge, right45 }, {   16,  29,  0, 24, upHalfHelixLarge, right45 }, {   16,  28,  0, 24, upHalfHelixLarge, right45 },
    {   16,  27,  0, 24, upHalfHelixLarge, right45 }, {   16,  26,  0, 24, upHalfHelixLarge, right45 }, {   16,  25,  0, 24, upHalfHelixLarge, right45 }, {   16,  24,  0, 25, upHalfHelixLarge, right45 },
    {   15,  23,  0, 25, upHalfHelixLarge, right45 }, {   15,  22,  0, 25, upHalfHelixLarge, right45 }, {   15,  21,  0, 25, upHalfHelixLarge, right45 }, {   15,  20,  0, 25, upHalfHelixLarge, right45 },
    {   15,  19,  0, 25, upHalfHelixLarge, right45 }, {   15,  18,  0, 25, upHalfHelixLarge, right45 }, {   14,  17,  1, 25, upHalfHelixLarge, right45 }, {   14,  16,  1, 25, upHalfHelixLarge, right45 },
    {   14,  15,  1, 25, upHalfHelixLarge, right45 }, {   14,  14,  1, 25, upHalfHelixLarge, right45 }, {   14,  13,  1, 25, upHalfHelixLarge, right45 }, {   13,  12,  1, 25, upHalfHelixLarge, right45 },
    {   13,  11,  1, 25, upHalfHelixLarge, right45 }, {   13,  10,  1, 26, upHalfHelixLarge, right45 }, {   13,   9,  1, 26, upHalfHelixLarge, right45 }, {   12,   8,  1, 26, upHalfHelixLarge, right45 },
    {   12,   7,  1, 26, upHalfHelixLarge, right45 }, {   12,   6,  1, 26, upHalfHelixLarge, right45 }, {   11,   5,  1, 26, upHalfHelixLarge, right45 }, {   11,   4,  1, 26, upHalfHelixLarge, right45 },
    {   11,   3,  2, 26, upHalfHelixLarge, right45 }, {   10,   2,  2, 26, upHalfHelixLarge, right45 }, {   10,   1,  2, 26, upHalfHelixLarge, right45 }, {    9,   0,  2, 26, upHalfHelixLarge, right45 },
    {    9,  -1,  2, 26, upHalfHelixLarge, right45 }, {    8,  -2,  2, 26, upHalfHelixLarge, right45 }, {    8,  -3,  2, 26, upHalfHelixLarge, right45 }, {    7,  -4,  2, 26, upHalfHelixLarge, right45 },
    {    7,  -5,  2, 27, upHalfHelixLarge, right45 }, {    6,  -6,  2, 27, upHalfHelixLarge, right45 }, {    6,  -7,  2, 27, upHalfHelixLarge, right45 }, {    5,  -8,  2, 27, upHalfHelixLarge, right45 },
    {    4,  -9,  2, 27, upHalfHelixLarge, right45 }, {    4, -10,  2, 27, upHalfHelixLarge, right45 }, {    3, -11,  3, 27, upHalfHelixLarge, right45 }, {    2, -12,  3, 27, upHalfHelixLarge, right45 },
    {    2, -13,  3, 27, upHalfHelixLarge, right45 }, {    1, -14,  3, 27, upHalfHelixLarge, right45 }, {    0, -15,  3, 27, upHalfHelixLarge, right45 }, {    0, -16,  3, 27, upHalfHelixLarge, right45 },
    {   -1, -17,  3, 27, upHalfHelixLarge, right45 }, {   -2, -18,  3, 28, upHalfHelixLarge, right45 }, {   -3, -19,  3, 28, upHalfHelixLarge, right45 }, {   -3, -20,  3, 28, upHalfHelixLarge, right45 },
    {   -4, -21,  3, 28, upHalfHelixLarge, right45 }, {   -5, -22,  3, 28, upHalfHelixLarge, right45 }, {   -6, -23,  3, 28, upHalfHelixLarge, right45 }, {   -7, -24,  3, 28, upHalfHelixLarge, right45 },
    {   -7, -25,  4, 28, upHalfHelixLarge, right45 }, {   -8, -26,  4, 28, upHalfHelixLarge, right45 }, {   -9, -27,  4, 28, upHalfHelixLarge, right45 }, {  -10, -28,  4, 28, upHalfHelixLarge, right45 },
    {  -11, -29,  4, 28, upHalfHelixLarge, right45 }, {  -12, -29,  4, 28, upHalfHelixLarge, right45 }, {  -13, -30,  4, 29, upHalfHelixLarge, right45 }, {  -14, -31,  4, 29, upHalfHelixLarge, right45 },
    {  -15, -32,  4, 29, upHalfHelixLarge, right45 }, {  -16, -32,  4, 29, upHalfHelixLarge, right45 }, {  -17, -33,  4, 29, upHalfHelixLarge, right45 }, {  -18, -34,  4, 29, upHalfHelixLarge, right45 },
    {  -19, -34,  4, 29, upHalfHelixLarge, right45 }, {  -20, -35,  4, 29, upHalfHelixLarge, right45 }, {  -21, -36,  4, 29, upHalfHelixLarge, right45 }, {  -22, -36,  5, 29, upHalfHelixLarge, right45 },
    {  -23, -37,  5, 29, upHalfHelixLarge, right45 }, {  -24, -38,  5, 29, upHalfHelixLarge, right45 }, {  -25, -38,  5, 29, upHalfHelixLarge, right45 }, {  -26, -39,  5, 30, upHalfHelixLarge, right45 },
    {  -27, -39,  5, 30, upHalfHelixLarge, right45 }, {  -28, -40,  5, 30, upHalfHelixLarge, right45 }, {  -29, -40,  5, 30, upHalfHelixLarge, right45 }, {  -30, -41,  5, 30, upHalfHelixLarge, right45 },
    {  -31, -41,  5, 30, upHalfHelixLarge, right45 }, {  -32, -42,  5, 30, upHalfHelixLarge, right45 }, {  -33, -42,  5, 30, upHalfHelixLarge, right45 }, {  -34, -43,  5, 30, upHalfHelixLarge, right45 },
    {  -35, -43,  5, 30, upHalfHelixLarge, right45 }, {  -36, -43,  6, 30, upHalfHelixLarge, right45 }, {  -37, -44,  6, 30, upHalfHelixLarge, right45 }, {  -38, -44,  6, 30, upHalfHelixLarge, right45 },
    {  -39, -44,  6, 30, upHalfHelixLarge, right45 }, {  -40, -45,  6, 31, upHalfHelixLarge, right45 }, {  -41, -45,  6, 31, upHalfHelixLarge, right45 }, {  -42, -45,  6, 31, upHalfHelixLarge, right45 },
    {  -43, -45,  6, 31, upHalfHelixLarge, right45 }, {  -44, -46,  6, 31, upHalfHelixLarge, right45 }, {  -45, -46,  6, 31, upHalfHelixLarge, right45 }, {  -46, -46,  6, 31, upHalfHelixLarge, right45 },
    {  -47, -46,  6, 31, upHalfHelixLarge, right45 }, {  -48, -46,  6, 31, upHalfHelixLarge, right45 }, {  -49, -47,  6, 31, upHalfHelixLarge, right45 }, {  -50, -47,  7, 31, upHalfHelixLarge, right45 },
    {  -51, -47,  7, 31, upHalfHelixLarge, right45 }, {  -52, -47,  7, 31, upHalfHelixLarge, right45 }, {  -53, -47,  7, 31, upHalfHelixLarge, right45 }, {  -54, -47,  7, 31, upHalfHelixLarge, right45 },
    {  -55, -48,  7, 31, upHalfHelixLarge, right45 }, {  -56, -48,  7,  0, upHalfHelixLarge, right45 }, {  -57, -48,  7,  0, upHalfHelixLarge, right45 }, {  -58, -48,  7,  0, upHalfHelixLarge, right45 },
    {  -59, -48,  7,  0, upHalfHelixLarge, right45 }, {  -60, -48,  7,  0, upHalfHelixLarge, right45 }, {  -61, -48,  7,  0, upHalfHelixLarge, right45 }, {  -62, -48,  7,  0, upHalfHelixLarge, right45 },
    {  -63, -48,  7,  0, upHalfHelixLarge, right45 }, {  -64, -48,  8,  0, upHalfHelixLarge, right45 }, {  -65, -48,  8,  0, upHalfHelixLarge, right45 }, {  -66, -48,  8,  0, upHalfHelixLarge, right45 },
    {  -67, -48,  8,  0, upHalfHelixLarge, right45 }, {  -68, -48,  8,  0, upHalfHelixLarge, right45 }, {  -69, -48,  8,  0, upHalfHelixLarge, right45 }, {  -70, -48,  8,  0, upHalfHelixLarge, right45 },
    {  -71, -48,  8,  0, upHalfHelixLarge, right45 }, {  -72, -48,  8,  1, upHalfHelixLarge, right45 }, {  -73, -47,  8,  1, upHalfHelixLarge, right45 }, {  -74, -47,  8,  1, upHalfHelixLarge, right45 },
    {  -75, -47,  8,  1, upHalfHelixLarge, right45 }, {  -76, -47,  8,  1, upHalfHelixLarge, right45 }, {  -77, -47,  8,  1, upHalfHelixLarge, right45 }, {  -78, -47,  8,  1, upHalfHelixLarge, right45 },
    {  -79, -46,  9,  1, upHalfHelixLarge, right45 }, {  -80, -46,  9,  1, upHalfHelixLarge, right45 }, {  -81, -46,  9,  1, upHalfHelixLarge, right45 }, {  -82, -46,  9,  1, upHalfHelixLarge, right45 },
    {  -83, -46,  9,  1, upHalfHelixLarge, right45 }, {  -84, -45,  9,  1, upHalfHelixLarge, right45 }, {  -85, -45,  9,  1, upHalfHelixLarge, right45 }, {  -86, -45,  9,  2, upHalfHelixLarge, right45 },
    {  -87, -45,  9,  2, upHalfHelixLarge, right45 }, {  -88, -44,  9,  2, upHalfHelixLarge, right45 }, {  -89, -44,  9,  2, upHalfHelixLarge, right45 }, {  -90, -44,  9,  2, upHalfHelixLarge, right45 },
    {  -91, -43,  9,  2, upHalfHelixLarge, right45 }, {  -92, -43,  9,  2, upHalfHelixLarge, right45 }, {  -93, -43, 10,  2, upHalfHelixLarge, right45 }, {  -94, -42, 10,  2, upHalfHelixLarge, right45 },
    {  -95, -42, 10,  2, upHalfHelixLarge, right45 }, {  -96, -41, 10,  2, upHalfHelixLarge, right45 }, {  -97, -41, 10,  2, upHalfHelixLarge, right45 }, {  -98, -40, 10,  2, upHalfHelixLarge, right45 },
    {  -99, -40, 10,  2, upHalfHelixLarge, right45 }, { -100, -39, 10,  2, upHalfHelixLarge, right45 }, { -101, -39, 10,  3, upHalfHelixLarge, right45 }, { -102, -38, 10,  3, upHalfHelixLarge, right45 },
    { -103, -38, 10,  3, upHalfHelixLarge, right45 }, { -104, -37, 10,  3, upHalfHelixLarge, right45 }, { -105, -36, 10,  3, upHalfHelixLarge, right45 }, { -106, -36, 10,  3, upHalfHelixLarge, right45 },
    { -107, -35, 11,  3, upHalfHelixLarge, right45 }, { -108, -34, 11,  3, upHalfHelixLarge, right45 }, { -109, -34, 11,  3, upHalfHelixLarge, right45 }, { -110, -33, 11,  3, upHalfHelixLarge, right45 },
    { -111, -32, 11,  3, upHalfHelixLarge, right45 }, { -112, -32, 11,  3, upHalfHelixLarge, right45 }, { -113, -31, 11,  3, upHalfHelixLarge, right45 }, { -114, -30, 11,  4, upHalfHelixLarge, right45 },
    { -115, -29, 11,  4, upHalfHelixLarge, right45 }, { -116, -29, 11,  4, upHalfHelixLarge, right45 }, { -117, -28, 11,  4, upHalfHelixLarge, right45 }, { -118, -27, 11,  4, upHalfHelixLarge, right45 },
    { -119, -26, 11,  4, upHalfHelixLarge, right45 }, { -120, -25, 11,  4, upHalfHelixLarge, right45 }, { -121, -25, 12,  4, upHalfHelixLarge, right45 }, { -122, -24, 12,  4, upHalfHelixLarge, right45 },
    { -123, -23, 12,  4, upHalfHelixLarge, right45 }, { -124, -22, 12,  4, upHalfHelixLarge, right45 }, { -125, -21, 12,  4, upHalfHelixLarge, right45 }, { -125, -20, 12,  4, upHalfHelixLarge, right45 },
    { -126, -19, 12,  5, upHalfHelixLarge, right45 }, { -127, -18, 12,  5, upHalfHelixLarge, right45 }, { -128, -17, 12,  5, upHalfHelixLarge, right45 }, { -128, -16, 12,  5, upHalfHelixLarge, right45 },
    { -129, -15, 12,  5, upHalfHelixLarge, right45 }, { -130, -14, 12,  5, upHalfHelixLarge, right45 }, { -130, -13, 12,  5, upHalfHelixLarge, right45 }, { -131, -12, 12,  5, upHalfHelixLarge, right45 },
    { -132, -11, 13,  5, upHalfHelixLarge, right45 }, { -132, -10, 13,  5, upHalfHelixLarge, right45 }, { -133,  -9, 13,  5, upHalfHelixLarge, right45 }, { -134,  -8, 13,  5, upHalfHelixLarge, right45 },
    { -134,  -7, 13,  5, upHalfHelixLarge, right45 }, { -135,  -6, 13,  6, upHalfHelixLarge, right45 }, { -135,  -5, 13,  6, upHalfHelixLarge, right45 }, { -136,  -4, 13,  6, upHalfHelixLarge, right45 },
    { -136,  -3, 13,  6, upHalfHelixLarge, right45 }, { -137,  -2, 13,  6, upHalfHelixLarge, right45 }, { -137,  -1, 13,  6, upHalfHelixLarge, right45 }, { -138,   0, 13,  6, upHalfHelixLarge, right45 },
    { -138,   1, 13,  6, upHalfHelixLarge, right45 }, { -139,   2, 13,  6, upHalfHelixLarge, right45 }, { -139,   3, 14,  6, upHalfHelixLarge, right45 }, { -139,   4, 14,  6, upHalfHelixLarge, right45 },
    { -140,   5, 14,  6, upHalfHelixLarge, right45 }, { -140,   6, 14,  6, upHalfHelixLarge, right45 }, { -140,   7, 14,  6, upHalfHelixLarge, right45 }, { -141,   8, 14,  7, upHalfHelixLarge, right45 },
    { -141,   9, 14,  7, upHalfHelixLarge, right45 }, { -141,  10, 14,  7, upHalfHelixLarge, right45 }, { -141,  11, 14,  7, upHalfHelixLarge, right45 }, { -142,  12, 14,  7, upHalfHelixLarge, right45 },
    { -142,  13, 14,  7, upHalfHelixLarge, right45 }, { -142,  14, 14,  7, upHalfHelixLarge, right45 }, { -142,  15, 14,  7, upHalfHelixLarge, right45 }, { -142,  16, 14,  7, upHalfHelixLarge, right45 },
    { -143,  17, 15,  7, upHalfHelixLarge, right45 }, { -143,  18, 15,  7, upHalfHelixLarge, right45 }, { -143,  19, 15,  7, upHalfHelixLarge, right45 }, { -143,  20, 15,  7, upHalfHelixLarge, right45 },
    { -143,  21, 15,  7, upHalfHelixLarge, right45 }, { -143,  22, 15,  7, upHalfHelixLarge, right45 }, { -144,  23, 15,  7, upHalfHelixLarge, right45 }, { -144,  24, 15,  8, upHalfHelixLarge, right45 },
    { -144,  25, 15,  8, upHalfHelixLarge, right45 }, { -144,  26, 15,  8, upHalfHelixLarge, right45 }, { -144,  27, 15,  8, upHalfHelixLarge, right45 }, { -144,  28, 15,  8, upHalfHelixLarge, right45 },
    { -144,  29, 15,  8, upHalfHelixLarge, right45 }, { -144,  30, 15,  8, upHalfHelixLarge, right45 }, { -144,  31, 16,  8, upHalfHelixLarge, right45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F4C52, {
    {  31,   16,  8,  0, downHalfHelixLarge, left45 }, {  30,   16,  8,  0, downHalfHelixLarge, left45 }, {  29,   16,  8,  0, downHalfHelixLarge, left45 },
    {  28,   16,  8,  0, downHalfHelixLarge, left45 }, {  27,   16,  8,  0, downHalfHelixLarge, left45 }, {  26,   16,  8,  0, downHalfHelixLarge, left45 },
    {  25,   16,  8,  0, downHalfHelixLarge, left45 }, {  24,   16,  8, 31, downHalfHelixLarge, left45 }, {  23,   15,  8, 31, downHalfHelixLarge, left45 },
    {  22,   15,  8, 31, downHalfHelixLarge, left45 }, {  21,   15,  8, 31, downHalfHelixLarge, left45 }, {  20,   15,  8, 31, downHalfHelixLarge, left45 },
    {  19,   15,  8, 31, downHalfHelixLarge, left45 }, {  18,   15,  8, 31, downHalfHelixLarge, left45 }, {  17,   14,  7, 31, downHalfHelixLarge, left45 },
    {  16,   14,  7, 31, downHalfHelixLarge, left45 }, {  15,   14,  7, 31, downHalfHelixLarge, left45 }, {  14,   14,  7, 31, downHalfHelixLarge, left45 },
    {  13,   14,  7, 31, downHalfHelixLarge, left45 }, {  12,   13,  7, 31, downHalfHelixLarge, left45 }, {  11,   13,  7, 31, downHalfHelixLarge, left45 },
    {  10,   13,  7, 30, downHalfHelixLarge, left45 }, {   9,   13,  7, 30, downHalfHelixLarge, left45 }, {   8,   12,  7, 30, downHalfHelixLarge, left45 },
    {   7,   12,  7, 30, downHalfHelixLarge, left45 }, {   6,   12,  7, 30, downHalfHelixLarge, left45 }, {   5,   11,  7, 30, downHalfHelixLarge, left45 },
    {   4,   11,  7, 30, downHalfHelixLarge, left45 }, {   3,   11,  6, 30, downHalfHelixLarge, left45 }, {   2,   10,  6, 30, downHalfHelixLarge, left45 },
    {   1,   10,  6, 30, downHalfHelixLarge, left45 }, {   0,    9,  6, 30, downHalfHelixLarge, left45 }, {  -1,    9,  6, 30, downHalfHelixLarge, left45 },
    {  -2,    8,  6, 30, downHalfHelixLarge, left45 }, {  -3,    8,  6, 30, downHalfHelixLarge, left45 }, {  -4,    7,  6, 30, downHalfHelixLarge, left45 },
    {  -5,    7,  6, 29, downHalfHelixLarge, left45 }, {  -6,    6,  6, 29, downHalfHelixLarge, left45 }, {  -7,    6,  6, 29, downHalfHelixLarge, left45 },
    {  -8,    5,  6, 29, downHalfHelixLarge, left45 }, {  -9,    4,  6, 29, downHalfHelixLarge, left45 }, { -10,    4,  6, 29, downHalfHelixLarge, left45 },
    { -11,    3,  5, 29, downHalfHelixLarge, left45 }, { -12,    2,  5, 29, downHalfHelixLarge, left45 }, { -13,    2,  5, 29, downHalfHelixLarge, left45 },
    { -14,    1,  5, 29, downHalfHelixLarge, left45 }, { -15,    0,  5, 29, downHalfHelixLarge, left45 }, { -16,    0,  5, 29, downHalfHelixLarge, left45 },
    { -17,   -1,  5, 29, downHalfHelixLarge, left45 }, { -18,   -2,  5, 28, downHalfHelixLarge, left45 }, { -19,   -3,  5, 28, downHalfHelixLarge, left45 },
    { -20,   -3,  5, 28, downHalfHelixLarge, left45 }, { -21,   -4,  5, 28, downHalfHelixLarge, left45 }, { -22,   -5,  5, 28, downHalfHelixLarge, left45 },
    { -23,   -6,  5, 28, downHalfHelixLarge, left45 }, { -24,   -7,  5, 28, downHalfHelixLarge, left45 }, { -25,   -7,  4, 28, downHalfHelixLarge, left45 },
    { -26,   -8,  4, 28, downHalfHelixLarge, left45 }, { -27,   -9,  4, 28, downHalfHelixLarge, left45 }, { -28,  -10,  4, 28, downHalfHelixLarge, left45 },
    { -29,  -11,  4, 28, downHalfHelixLarge, left45 }, { -29,  -12,  4, 28, downHalfHelixLarge, left45 }, { -30,  -13,  4, 27, downHalfHelixLarge, left45 },
    { -31,  -14,  4, 27, downHalfHelixLarge, left45 }, { -32,  -15,  4, 27, downHalfHelixLarge, left45 }, { -32,  -16,  4, 27, downHalfHelixLarge, left45 },
    { -33,  -17,  4, 27, downHalfHelixLarge, left45 }, { -34,  -18,  4, 27, downHalfHelixLarge, left45 }, { -34,  -19,  4, 27, downHalfHelixLarge, left45 },
    { -35,  -20,  4, 27, downHalfHelixLarge, left45 }, { -36,  -21,  4, 27, downHalfHelixLarge, left45 }, { -36,  -22,  3, 27, downHalfHelixLarge, left45 },
    { -37,  -23,  3, 27, downHalfHelixLarge, left45 }, { -38,  -24,  3, 27, downHalfHelixLarge, left45 }, { -38,  -25,  3, 27, downHalfHelixLarge, left45 },
    { -39,  -26,  3, 26, downHalfHelixLarge, left45 }, { -39,  -27,  3, 26, downHalfHelixLarge, left45 }, { -40,  -28,  3, 26, downHalfHelixLarge, left45 },
    { -40,  -29,  3, 26, downHalfHelixLarge, left45 }, { -41,  -30,  3, 26, downHalfHelixLarge, left45 }, { -41,  -31,  3, 26, downHalfHelixLarge, left45 },
    { -42,  -32,  3, 26, downHalfHelixLarge, left45 }, { -42,  -33,  3, 26, downHalfHelixLarge, left45 }, { -43,  -34,  3, 26, downHalfHelixLarge, left45 },
    { -43,  -35,  3, 26, downHalfHelixLarge, left45 }, { -43,  -36,  2, 26, downHalfHelixLarge, left45 }, { -44,  -37,  2, 26, downHalfHelixLarge, left45 },
    { -44,  -38,  2, 26, downHalfHelixLarge, left45 }, { -44,  -39,  2, 26, downHalfHelixLarge, left45 }, { -45,  -40,  2, 25, downHalfHelixLarge, left45 },
    { -45,  -41,  2, 25, downHalfHelixLarge, left45 }, { -45,  -42,  2, 25, downHalfHelixLarge, left45 }, { -45,  -43,  2, 25, downHalfHelixLarge, left45 },
    { -46,  -44,  2, 25, downHalfHelixLarge, left45 }, { -46,  -45,  2, 25, downHalfHelixLarge, left45 }, { -46,  -46,  2, 25, downHalfHelixLarge, left45 },
    { -46,  -47,  2, 25, downHalfHelixLarge, left45 }, { -46,  -48,  2, 25, downHalfHelixLarge, left45 }, { -47,  -49,  2, 25, downHalfHelixLarge, left45 },
    { -47,  -50,  1, 25, downHalfHelixLarge, left45 }, { -47,  -51,  1, 25, downHalfHelixLarge, left45 }, { -47,  -52,  1, 25, downHalfHelixLarge, left45 },
    { -47,  -53,  1, 25, downHalfHelixLarge, left45 }, { -47,  -54,  1, 25, downHalfHelixLarge, left45 }, { -48,  -55,  1, 25, downHalfHelixLarge, left45 },
    { -48,  -56,  1, 24, downHalfHelixLarge, left45 }, { -48,  -57,  1, 24, downHalfHelixLarge, left45 }, { -48,  -58,  1, 24, downHalfHelixLarge, left45 },
    { -48,  -59,  1, 24, downHalfHelixLarge, left45 }, { -48,  -60,  1, 24, downHalfHelixLarge, left45 }, { -48,  -61,  1, 24, downHalfHelixLarge, left45 },
    { -48,  -62,  1, 24, downHalfHelixLarge, left45 }, { -48,  -63,  1, 24, downHalfHelixLarge, left45 }, { -48,  -64,  0, 24, downHalfHelixLarge, left45 },
    { -48,  -65,  0, 24, downHalfHelixLarge, left45 }, { -48,  -66,  0, 24, downHalfHelixLarge, left45 }, { -48,  -67,  0, 24, downHalfHelixLarge, left45 },
    { -48,  -68,  0, 24, downHalfHelixLarge, left45 }, { -48,  -69,  0, 24, downHalfHelixLarge, left45 }, { -48,  -70,  0, 24, downHalfHelixLarge, left45 },
    { -48,  -71,  0, 24, downHalfHelixLarge, left45 }, { -48,  -72,  0, 23, downHalfHelixLarge, left45 }, { -47,  -73,  0, 23, downHalfHelixLarge, left45 },
    { -47,  -74,  0, 23, downHalfHelixLarge, left45 }, { -47,  -75,  0, 23, downHalfHelixLarge, left45 }, { -47,  -76,  0, 23, downHalfHelixLarge, left45 },
    { -47,  -77,  0, 23, downHalfHelixLarge, left45 }, { -47,  -78,  0, 23, downHalfHelixLarge, left45 }, { -46,  -79, -1, 23, downHalfHelixLarge, left45 },
    { -46,  -80, -1, 23, downHalfHelixLarge, left45 }, { -46,  -81, -1, 23, downHalfHelixLarge, left45 }, { -46,  -82, -1, 23, downHalfHelixLarge, left45 },
    { -46,  -83, -1, 23, downHalfHelixLarge, left45 }, { -45,  -84, -1, 23, downHalfHelixLarge, left45 }, { -45,  -85, -1, 23, downHalfHelixLarge, left45 },
    { -45,  -86, -1, 22, downHalfHelixLarge, left45 }, { -45,  -87, -1, 22, downHalfHelixLarge, left45 }, { -44,  -88, -1, 22, downHalfHelixLarge, left45 },
    { -44,  -89, -1, 22, downHalfHelixLarge, left45 }, { -44,  -90, -1, 22, downHalfHelixLarge, left45 }, { -43,  -91, -1, 22, downHalfHelixLarge, left45 },
    { -43,  -92, -1, 22, downHalfHelixLarge, left45 }, { -43,  -93, -2, 22, downHalfHelixLarge, left45 }, { -42,  -94, -2, 22, downHalfHelixLarge, left45 },
    { -42,  -95, -2, 22, downHalfHelixLarge, left45 }, { -41,  -96, -2, 22, downHalfHelixLarge, left45 }, { -41,  -97, -2, 22, downHalfHelixLarge, left45 },
    { -40,  -98, -2, 22, downHalfHelixLarge, left45 }, { -40,  -99, -2, 22, downHalfHelixLarge, left45 }, { -39, -100, -2, 22, downHalfHelixLarge, left45 },
    { -39, -101, -2, 21, downHalfHelixLarge, left45 }, { -38, -102, -2, 21, downHalfHelixLarge, left45 }, { -38, -103, -2, 21, downHalfHelixLarge, left45 },
    { -37, -104, -2, 21, downHalfHelixLarge, left45 }, { -36, -105, -2, 21, downHalfHelixLarge, left45 }, { -36, -106, -2, 21, downHalfHelixLarge, left45 },
    { -35, -107, -3, 21, downHalfHelixLarge, left45 }, { -34, -108, -3, 21, downHalfHelixLarge, left45 }, { -34, -109, -3, 21, downHalfHelixLarge, left45 },
    { -33, -110, -3, 21, downHalfHelixLarge, left45 }, { -32, -111, -3, 21, downHalfHelixLarge, left45 }, { -32, -112, -3, 21, downHalfHelixLarge, left45 },
    { -31, -113, -3, 21, downHalfHelixLarge, left45 }, { -30, -114, -3, 20, downHalfHelixLarge, left45 }, { -29, -115, -3, 20, downHalfHelixLarge, left45 },
    { -29, -116, -3, 20, downHalfHelixLarge, left45 }, { -28, -117, -3, 20, downHalfHelixLarge, left45 }, { -27, -118, -3, 20, downHalfHelixLarge, left45 },
    { -26, -119, -3, 20, downHalfHelixLarge, left45 }, { -25, -120, -3, 20, downHalfHelixLarge, left45 }, { -25, -121, -4, 20, downHalfHelixLarge, left45 },
    { -24, -122, -4, 20, downHalfHelixLarge, left45 }, { -23, -123, -4, 20, downHalfHelixLarge, left45 }, { -22, -124, -4, 20, downHalfHelixLarge, left45 },
    { -21, -125, -4, 20, downHalfHelixLarge, left45 }, { -20, -125, -4, 20, downHalfHelixLarge, left45 }, { -19, -126, -4, 19, downHalfHelixLarge, left45 },
    { -18, -127, -4, 19, downHalfHelixLarge, left45 }, { -17, -128, -4, 19, downHalfHelixLarge, left45 }, { -16, -128, -4, 19, downHalfHelixLarge, left45 },
    { -15, -129, -4, 19, downHalfHelixLarge, left45 }, { -14, -130, -4, 19, downHalfHelixLarge, left45 }, { -13, -130, -4, 19, downHalfHelixLarge, left45 },
    { -12, -131, -4, 19, downHalfHelixLarge, left45 }, { -11, -132, -5, 19, downHalfHelixLarge, left45 }, { -10, -132, -5, 19, downHalfHelixLarge, left45 },
    {  -9, -133, -5, 19, downHalfHelixLarge, left45 }, {  -8, -134, -5, 19, downHalfHelixLarge, left45 }, {  -7, -134, -5, 19, downHalfHelixLarge, left45 },
    {  -6, -135, -5, 18, downHalfHelixLarge, left45 }, {  -5, -135, -5, 18, downHalfHelixLarge, left45 }, {  -4, -136, -5, 18, downHalfHelixLarge, left45 },
    {  -3, -136, -5, 18, downHalfHelixLarge, left45 }, {  -2, -137, -5, 18, downHalfHelixLarge, left45 }, {  -1, -137, -5, 18, downHalfHelixLarge, left45 },
    {   0, -138, -5, 18, downHalfHelixLarge, left45 }, {   1, -138, -5, 18, downHalfHelixLarge, left45 }, {   2, -139, -5, 18, downHalfHelixLarge, left45 },
    {   3, -139, -6, 18, downHalfHelixLarge, left45 }, {   4, -139, -6, 18, downHalfHelixLarge, left45 }, {   5, -140, -6, 18, downHalfHelixLarge, left45 },
    {   6, -140, -6, 18, downHalfHelixLarge, left45 }, {   7, -140, -6, 18, downHalfHelixLarge, left45 }, {   8, -141, -6, 17, downHalfHelixLarge, left45 },
    {   9, -141, -6, 17, downHalfHelixLarge, left45 }, {  10, -141, -6, 17, downHalfHelixLarge, left45 }, {  11, -141, -6, 17, downHalfHelixLarge, left45 },
    {  12, -142, -6, 17, downHalfHelixLarge, left45 }, {  13, -142, -6, 17, downHalfHelixLarge, left45 }, {  14, -142, -6, 17, downHalfHelixLarge, left45 },
    {  15, -142, -6, 17, downHalfHelixLarge, left45 }, {  16, -142, -6, 17, downHalfHelixLarge, left45 }, {  17, -143, -7, 17, downHalfHelixLarge, left45 },
    {  18, -143, -7, 17, downHalfHelixLarge, left45 }, {  19, -143, -7, 17, downHalfHelixLarge, left45 }, {  20, -143, -7, 17, downHalfHelixLarge, left45 },
    {  21, -143, -7, 17, downHalfHelixLarge, left45 }, {  22, -143, -7, 17, downHalfHelixLarge, left45 }, {  23, -144, -7, 17, downHalfHelixLarge, left45 },
    {  24, -144, -7, 16, downHalfHelixLarge, left45 }, {  25, -144, -7, 16, downHalfHelixLarge, left45 }, {  26, -144, -7, 16, downHalfHelixLarge, left45 },
    {  27, -144, -7, 16, downHalfHelixLarge, left45 }, {  28, -144, -7, 16, downHalfHelixLarge, left45 }, {  29, -144, -7, 16, downHalfHelixLarge, left45 },
    {  30, -144, -7, 16, downHalfHelixLarge, left45 }, {  31, -144, -8, 16, downHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F544F, {
    {   16,  0,  8,  8, downHalfHelixLarge, left45 }, {   16,  1,  8,  8, downHalfHelixLarge, left45 }, {   16,  2,  8,  8, downHalfHelixLarge, left45 },
    {   16,  3,  8,  8, downHalfHelixLarge, left45 }, {   16,  4,  8,  8, downHalfHelixLarge, left45 }, {   16,  5,  8,  8, downHalfHelixLarge, left45 },
    {   16,  6,  8,  8, downHalfHelixLarge, left45 }, {   16,  7,  8,  8, downHalfHelixLarge, left45 }, {   16,  8,  8,  7, downHalfHelixLarge, left45 },
    {   15,  9,  8,  7, downHalfHelixLarge, left45 }, {   15, 10,  8,  7, downHalfHelixLarge, left45 }, {   15, 11,  8,  7, downHalfHelixLarge, left45 },
    {   15, 12,  8,  7, downHalfHelixLarge, left45 }, {   15, 13,  8,  7, downHalfHelixLarge, left45 }, {   15, 14,  8,  7, downHalfHelixLarge, left45 },
    {   14, 15,  7,  7, downHalfHelixLarge, left45 }, {   14, 16,  7,  7, downHalfHelixLarge, left45 }, {   14, 17,  7,  7, downHalfHelixLarge, left45 },
    {   14, 18,  7,  7, downHalfHelixLarge, left45 }, {   14, 19,  7,  7, downHalfHelixLarge, left45 }, {   13, 20,  7,  7, downHalfHelixLarge, left45 },
    {   13, 21,  7,  7, downHalfHelixLarge, left45 }, {   13, 22,  7,  6, downHalfHelixLarge, left45 }, {   13, 23,  7,  6, downHalfHelixLarge, left45 },
    {   12, 24,  7,  6, downHalfHelixLarge, left45 }, {   12, 25,  7,  6, downHalfHelixLarge, left45 }, {   12, 26,  7,  6, downHalfHelixLarge, left45 },
    {   11, 27,  7,  6, downHalfHelixLarge, left45 }, {   11, 28,  7,  6, downHalfHelixLarge, left45 }, {   11, 29,  6,  6, downHalfHelixLarge, left45 },
    {   10, 30,  6,  6, downHalfHelixLarge, left45 }, {   10, 31,  6,  6, downHalfHelixLarge, left45 }, {    9, 32,  6,  6, downHalfHelixLarge, left45 },
    {    9, 33,  6,  6, downHalfHelixLarge, left45 }, {    8, 34,  6,  6, downHalfHelixLarge, left45 }, {    8, 35,  6,  6, downHalfHelixLarge, left45 },
    {    7, 36,  6,  6, downHalfHelixLarge, left45 }, {    7, 37,  6,  5, downHalfHelixLarge, left45 }, {    6, 38,  6,  5, downHalfHelixLarge, left45 },
    {    6, 39,  6,  5, downHalfHelixLarge, left45 }, {    5, 40,  6,  5, downHalfHelixLarge, left45 }, {    4, 41,  6,  5, downHalfHelixLarge, left45 },
    {    4, 42,  6,  5, downHalfHelixLarge, left45 }, {    3, 43,  6,  5, downHalfHelixLarge, left45 }, {    2, 44,  5,  5, downHalfHelixLarge, left45 },
    {    2, 45,  5,  5, downHalfHelixLarge, left45 }, {    1, 46,  5,  5, downHalfHelixLarge, left45 }, {    0, 47,  5,  5, downHalfHelixLarge, left45 },
    {    0, 48,  5,  5, downHalfHelixLarge, left45 }, {   -1, 49,  5,  5, downHalfHelixLarge, left45 }, {   -2, 50,  5,  4, downHalfHelixLarge, left45 },
    {   -3, 51,  5,  4, downHalfHelixLarge, left45 }, {   -3, 52,  5,  4, downHalfHelixLarge, left45 }, {   -4, 53,  5,  4, downHalfHelixLarge, left45 },
    {   -5, 54,  5,  4, downHalfHelixLarge, left45 }, {   -6, 55,  5,  4, downHalfHelixLarge, left45 }, {   -7, 56,  5,  4, downHalfHelixLarge, left45 },
    {   -7, 57,  5,  4, downHalfHelixLarge, left45 }, {   -8, 58,  4,  4, downHalfHelixLarge, left45 }, {   -9, 59,  4,  4, downHalfHelixLarge, left45 },
    {  -10, 60,  4,  4, downHalfHelixLarge, left45 }, {  -11, 61,  4,  4, downHalfHelixLarge, left45 }, {  -12, 61,  4,  4, downHalfHelixLarge, left45 },
    {  -13, 62,  4,  3, downHalfHelixLarge, left45 }, {  -14, 63,  4,  3, downHalfHelixLarge, left45 }, {  -15, 64,  4,  3, downHalfHelixLarge, left45 },
    {  -16, 64,  4,  3, downHalfHelixLarge, left45 }, {  -17, 65,  4,  3, downHalfHelixLarge, left45 }, {  -18, 66,  4,  3, downHalfHelixLarge, left45 },
    {  -19, 66,  4,  3, downHalfHelixLarge, left45 }, {  -20, 67,  4,  3, downHalfHelixLarge, left45 }, {  -21, 68,  4,  3, downHalfHelixLarge, left45 },
    {  -22, 68,  3,  3, downHalfHelixLarge, left45 }, {  -23, 69,  3,  3, downHalfHelixLarge, left45 }, {  -24, 70,  3,  3, downHalfHelixLarge, left45 },
    {  -25, 70,  3,  3, downHalfHelixLarge, left45 }, {  -26, 71,  3,  2, downHalfHelixLarge, left45 }, {  -27, 71,  3,  2, downHalfHelixLarge, left45 },
    {  -28, 72,  3,  2, downHalfHelixLarge, left45 }, {  -29, 72,  3,  2, downHalfHelixLarge, left45 }, {  -30, 73,  3,  2, downHalfHelixLarge, left45 },
    {  -31, 73,  3,  2, downHalfHelixLarge, left45 }, {  -32, 74,  3,  2, downHalfHelixLarge, left45 }, {  -33, 74,  3,  2, downHalfHelixLarge, left45 },
    {  -34, 75,  3,  2, downHalfHelixLarge, left45 }, {  -35, 75,  3,  2, downHalfHelixLarge, left45 }, {  -36, 75,  3,  2, downHalfHelixLarge, left45 },
    {  -37, 76,  2,  2, downHalfHelixLarge, left45 }, {  -38, 76,  2,  2, downHalfHelixLarge, left45 }, {  -39, 76,  2,  2, downHalfHelixLarge, left45 },
    {  -40, 77,  2,  1, downHalfHelixLarge, left45 }, {  -41, 77,  2,  1, downHalfHelixLarge, left45 }, {  -42, 77,  2,  1, downHalfHelixLarge, left45 },
    {  -43, 77,  2,  1, downHalfHelixLarge, left45 }, {  -44, 78,  2,  1, downHalfHelixLarge, left45 }, {  -45, 78,  2,  1, downHalfHelixLarge, left45 },
    {  -46, 78,  2,  1, downHalfHelixLarge, left45 }, {  -47, 78,  2,  1, downHalfHelixLarge, left45 }, {  -48, 78,  2,  1, downHalfHelixLarge, left45 },
    {  -49, 79,  2,  1, downHalfHelixLarge, left45 }, {  -50, 79,  2,  1, downHalfHelixLarge, left45 }, {  -51, 79,  1,  1, downHalfHelixLarge, left45 },
    {  -52, 79,  1,  1, downHalfHelixLarge, left45 }, {  -53, 79,  1,  1, downHalfHelixLarge, left45 }, {  -54, 79,  1,  1, downHalfHelixLarge, left45 },
    {  -55, 80,  1,  1, downHalfHelixLarge, left45 }, {  -56, 80,  1,  0, downHalfHelixLarge, left45 }, {  -57, 80,  1,  0, downHalfHelixLarge, left45 },
    {  -58, 80,  1,  0, downHalfHelixLarge, left45 }, {  -59, 80,  1,  0, downHalfHelixLarge, left45 }, {  -60, 80,  1,  0, downHalfHelixLarge, left45 },
    {  -61, 80,  1,  0, downHalfHelixLarge, left45 }, {  -62, 80,  1,  0, downHalfHelixLarge, left45 }, {  -63, 80,  1,  0, downHalfHelixLarge, left45 },
    {  -64, 80,  1,  0, downHalfHelixLarge, left45 }, {  -65, 80,  0,  0, downHalfHelixLarge, left45 }, {  -66, 80,  0,  0, downHalfHelixLarge, left45 },
    {  -67, 80,  0,  0, downHalfHelixLarge, left45 }, {  -68, 80,  0,  0, downHalfHelixLarge, left45 }, {  -69, 80,  0,  0, downHalfHelixLarge, left45 },
    {  -70, 80,  0,  0, downHalfHelixLarge, left45 }, {  -71, 80,  0,  0, downHalfHelixLarge, left45 }, {  -72, 80,  0, 31, downHalfHelixLarge, left45 },
    {  -73, 79,  0, 31, downHalfHelixLarge, left45 }, {  -74, 79,  0, 31, downHalfHelixLarge, left45 }, {  -75, 79,  0, 31, downHalfHelixLarge, left45 },
    {  -76, 79,  0, 31, downHalfHelixLarge, left45 }, {  -77, 79,  0, 31, downHalfHelixLarge, left45 }, {  -78, 79,  0, 31, downHalfHelixLarge, left45 },
    {  -79, 78, -1, 31, downHalfHelixLarge, left45 }, {  -80, 78, -1, 31, downHalfHelixLarge, left45 }, {  -81, 78, -1, 31, downHalfHelixLarge, left45 },
    {  -82, 78, -1, 31, downHalfHelixLarge, left45 }, {  -83, 78, -1, 31, downHalfHelixLarge, left45 }, {  -84, 77, -1, 31, downHalfHelixLarge, left45 },
    {  -85, 77, -1, 31, downHalfHelixLarge, left45 }, {  -86, 77, -1, 30, downHalfHelixLarge, left45 }, {  -87, 77, -1, 30, downHalfHelixLarge, left45 },
    {  -88, 76, -1, 30, downHalfHelixLarge, left45 }, {  -89, 76, -1, 30, downHalfHelixLarge, left45 }, {  -90, 76, -1, 30, downHalfHelixLarge, left45 },
    {  -91, 75, -1, 30, downHalfHelixLarge, left45 }, {  -92, 75, -1, 30, downHalfHelixLarge, left45 }, {  -93, 75, -2, 30, downHalfHelixLarge, left45 },
    {  -94, 74, -2, 30, downHalfHelixLarge, left45 }, {  -95, 74, -2, 30, downHalfHelixLarge, left45 }, {  -96, 73, -2, 30, downHalfHelixLarge, left45 },
    {  -97, 73, -2, 30, downHalfHelixLarge, left45 }, {  -98, 72, -2, 30, downHalfHelixLarge, left45 }, {  -99, 72, -2, 30, downHalfHelixLarge, left45 },
    { -100, 71, -2, 30, downHalfHelixLarge, left45 }, { -101, 71, -2, 29, downHalfHelixLarge, left45 }, { -102, 70, -2, 29, downHalfHelixLarge, left45 },
    { -103, 70, -2, 29, downHalfHelixLarge, left45 }, { -104, 69, -2, 29, downHalfHelixLarge, left45 }, { -105, 68, -2, 29, downHalfHelixLarge, left45 },
    { -106, 68, -2, 29, downHalfHelixLarge, left45 }, { -107, 67, -3, 29, downHalfHelixLarge, left45 }, { -108, 66, -3, 29, downHalfHelixLarge, left45 },
    { -109, 66, -3, 29, downHalfHelixLarge, left45 }, { -110, 65, -3, 29, downHalfHelixLarge, left45 }, { -111, 64, -3, 29, downHalfHelixLarge, left45 },
    { -112, 64, -3, 29, downHalfHelixLarge, left45 }, { -113, 63, -3, 29, downHalfHelixLarge, left45 }, { -114, 62, -3, 28, downHalfHelixLarge, left45 },
    { -115, 61, -3, 28, downHalfHelixLarge, left45 }, { -116, 61, -3, 28, downHalfHelixLarge, left45 }, { -117, 60, -3, 28, downHalfHelixLarge, left45 },
    { -118, 59, -3, 28, downHalfHelixLarge, left45 }, { -119, 58, -3, 28, downHalfHelixLarge, left45 }, { -120, 57, -3, 28, downHalfHelixLarge, left45 },
    { -121, 57, -4, 28, downHalfHelixLarge, left45 }, { -122, 56, -4, 28, downHalfHelixLarge, left45 }, { -123, 55, -4, 28, downHalfHelixLarge, left45 },
    { -124, 54, -4, 28, downHalfHelixLarge, left45 }, { -125, 53, -4, 28, downHalfHelixLarge, left45 }, { -125, 52, -4, 28, downHalfHelixLarge, left45 },
    { -126, 51, -4, 27, downHalfHelixLarge, left45 }, { -127, 50, -4, 27, downHalfHelixLarge, left45 }, { -128, 49, -4, 27, downHalfHelixLarge, left45 },
    { -128, 48, -4, 27, downHalfHelixLarge, left45 }, { -129, 47, -4, 27, downHalfHelixLarge, left45 }, { -130, 46, -4, 27, downHalfHelixLarge, left45 },
    { -130, 45, -4, 27, downHalfHelixLarge, left45 }, { -131, 44, -4, 27, downHalfHelixLarge, left45 }, { -132, 43, -4, 27, downHalfHelixLarge, left45 },
    { -132, 42, -5, 27, downHalfHelixLarge, left45 }, { -133, 41, -5, 27, downHalfHelixLarge, left45 }, { -134, 40, -5, 27, downHalfHelixLarge, left45 },
    { -134, 39, -5, 27, downHalfHelixLarge, left45 }, { -135, 38, -5, 26, downHalfHelixLarge, left45 }, { -135, 37, -5, 26, downHalfHelixLarge, left45 },
    { -136, 36, -5, 26, downHalfHelixLarge, left45 }, { -136, 35, -5, 26, downHalfHelixLarge, left45 }, { -137, 34, -5, 26, downHalfHelixLarge, left45 },
    { -137, 33, -5, 26, downHalfHelixLarge, left45 }, { -138, 32, -5, 26, downHalfHelixLarge, left45 }, { -138, 31, -5, 26, downHalfHelixLarge, left45 },
    { -139, 30, -5, 26, downHalfHelixLarge, left45 }, { -139, 29, -5, 26, downHalfHelixLarge, left45 }, { -139, 28, -6, 26, downHalfHelixLarge, left45 },
    { -140, 27, -6, 26, downHalfHelixLarge, left45 }, { -140, 26, -6, 26, downHalfHelixLarge, left45 }, { -140, 25, -6, 26, downHalfHelixLarge, left45 },
    { -141, 24, -6, 25, downHalfHelixLarge, left45 }, { -141, 23, -6, 25, downHalfHelixLarge, left45 }, { -141, 22, -6, 25, downHalfHelixLarge, left45 },
    { -141, 21, -6, 25, downHalfHelixLarge, left45 }, { -142, 20, -6, 25, downHalfHelixLarge, left45 }, { -142, 19, -6, 25, downHalfHelixLarge, left45 },
    { -142, 18, -6, 25, downHalfHelixLarge, left45 }, { -142, 17, -6, 25, downHalfHelixLarge, left45 }, { -142, 16, -6, 25, downHalfHelixLarge, left45 },
    { -143, 15, -6, 25, downHalfHelixLarge, left45 }, { -143, 14, -7, 25, downHalfHelixLarge, left45 }, { -143, 13, -7, 25, downHalfHelixLarge, left45 },
    { -143, 12, -7, 25, downHalfHelixLarge, left45 }, { -143, 11, -7, 25, downHalfHelixLarge, left45 }, { -143, 10, -7, 25, downHalfHelixLarge, left45 },
    { -144,  9, -7, 25, downHalfHelixLarge, left45 }, { -144,  8, -7, 24, downHalfHelixLarge, left45 }, { -144,  7, -7, 24, downHalfHelixLarge, left45 },
    { -144,  6, -7, 24, downHalfHelixLarge, left45 }, { -144,  5, -7, 24, downHalfHelixLarge, left45 }, { -144,  4, -7, 24, downHalfHelixLarge, left45 },
    { -144,  3, -7, 24, downHalfHelixLarge, left45 }, { -144,  2, -7, 24, downHalfHelixLarge, left45 }, { -144,  1, -7, 24, downHalfHelixLarge, left45 },
    { -144,  0, -8, 24, downHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F5C5E, {
    {  0,  16,  8, 16, downHalfHelixLarge, left45 }, {  1,  16,  8, 16, downHalfHelixLarge, left45 }, {  2,  16,  8, 16, downHalfHelixLarge, left45 }, {  3,  16,  8, 16, downHalfHelixLarge, left45 },
    {  4,  16,  8, 16, downHalfHelixLarge, left45 }, {  5,  16,  8, 16, downHalfHelixLarge, left45 }, {  6,  16,  8, 16, downHalfHelixLarge, left45 }, {  7,  16,  8, 16, downHalfHelixLarge, left45 },
    {  8,  16,  8, 15, downHalfHelixLarge, left45 }, {  9,  17,  8, 15, downHalfHelixLarge, left45 }, { 10,  17,  8, 15, downHalfHelixLarge, left45 }, { 11,  17,  8, 15, downHalfHelixLarge, left45 },
    { 12,  17,  8, 15, downHalfHelixLarge, left45 }, { 13,  17,  8, 15, downHalfHelixLarge, left45 }, { 14,  17,  8, 15, downHalfHelixLarge, left45 }, { 15,  18,  7, 15, downHalfHelixLarge, left45 },
    { 16,  18,  7, 15, downHalfHelixLarge, left45 }, { 17,  18,  7, 15, downHalfHelixLarge, left45 }, { 18,  18,  7, 15, downHalfHelixLarge, left45 }, { 19,  18,  7, 15, downHalfHelixLarge, left45 },
    { 20,  19,  7, 15, downHalfHelixLarge, left45 }, { 21,  19,  7, 15, downHalfHelixLarge, left45 }, { 22,  19,  7, 14, downHalfHelixLarge, left45 }, { 23,  19,  7, 14, downHalfHelixLarge, left45 },
    { 24,  20,  7, 14, downHalfHelixLarge, left45 }, { 25,  20,  7, 14, downHalfHelixLarge, left45 }, { 26,  20,  7, 14, downHalfHelixLarge, left45 }, { 27,  21,  7, 14, downHalfHelixLarge, left45 },
    { 28,  21,  7, 14, downHalfHelixLarge, left45 }, { 29,  21,  6, 14, downHalfHelixLarge, left45 }, { 30,  22,  6, 14, downHalfHelixLarge, left45 }, { 31,  22,  6, 14, downHalfHelixLarge, left45 },
    { 32,  23,  6, 14, downHalfHelixLarge, left45 }, { 33,  23,  6, 14, downHalfHelixLarge, left45 }, { 34,  24,  6, 14, downHalfHelixLarge, left45 }, { 35,  24,  6, 14, downHalfHelixLarge, left45 },
    { 36,  25,  6, 14, downHalfHelixLarge, left45 }, { 37,  25,  6, 13, downHalfHelixLarge, left45 }, { 38,  26,  6, 13, downHalfHelixLarge, left45 }, { 39,  26,  6, 13, downHalfHelixLarge, left45 },
    { 40,  27,  6, 13, downHalfHelixLarge, left45 }, { 41,  28,  6, 13, downHalfHelixLarge, left45 }, { 42,  28,  6, 13, downHalfHelixLarge, left45 }, { 43,  29,  5, 13, downHalfHelixLarge, left45 },
    { 44,  30,  5, 13, downHalfHelixLarge, left45 }, { 45,  30,  5, 13, downHalfHelixLarge, left45 }, { 46,  31,  5, 13, downHalfHelixLarge, left45 }, { 47,  32,  5, 13, downHalfHelixLarge, left45 },
    { 48,  32,  5, 13, downHalfHelixLarge, left45 }, { 49,  33,  5, 13, downHalfHelixLarge, left45 }, { 50,  34,  5, 12, downHalfHelixLarge, left45 }, { 51,  35,  5, 12, downHalfHelixLarge, left45 },
    { 52,  35,  5, 12, downHalfHelixLarge, left45 }, { 53,  36,  5, 12, downHalfHelixLarge, left45 }, { 54,  37,  5, 12, downHalfHelixLarge, left45 }, { 55,  38,  5, 12, downHalfHelixLarge, left45 },
    { 56,  39,  5, 12, downHalfHelixLarge, left45 }, { 57,  39,  4, 12, downHalfHelixLarge, left45 }, { 58,  40,  4, 12, downHalfHelixLarge, left45 }, { 59,  41,  4, 12, downHalfHelixLarge, left45 },
    { 60,  42,  4, 12, downHalfHelixLarge, left45 }, { 61,  43,  4, 12, downHalfHelixLarge, left45 }, { 61,  44,  4, 12, downHalfHelixLarge, left45 }, { 62,  45,  4, 11, downHalfHelixLarge, left45 },
    { 63,  46,  4, 11, downHalfHelixLarge, left45 }, { 64,  47,  4, 11, downHalfHelixLarge, left45 }, { 64,  48,  4, 11, downHalfHelixLarge, left45 }, { 65,  49,  4, 11, downHalfHelixLarge, left45 },
    { 66,  50,  4, 11, downHalfHelixLarge, left45 }, { 66,  51,  4, 11, downHalfHelixLarge, left45 }, { 67,  52,  4, 11, downHalfHelixLarge, left45 }, { 68,  53,  4, 11, downHalfHelixLarge, left45 },
    { 68,  54,  3, 11, downHalfHelixLarge, left45 }, { 69,  55,  3, 11, downHalfHelixLarge, left45 }, { 70,  56,  3, 11, downHalfHelixLarge, left45 }, { 70,  57,  3, 11, downHalfHelixLarge, left45 },
    { 71,  58,  3, 10, downHalfHelixLarge, left45 }, { 71,  59,  3, 10, downHalfHelixLarge, left45 }, { 72,  60,  3, 10, downHalfHelixLarge, left45 }, { 72,  61,  3, 10, downHalfHelixLarge, left45 },
    { 73,  62,  3, 10, downHalfHelixLarge, left45 }, { 73,  63,  3, 10, downHalfHelixLarge, left45 }, { 74,  64,  3, 10, downHalfHelixLarge, left45 }, { 74,  65,  3, 10, downHalfHelixLarge, left45 },
    { 75,  66,  3, 10, downHalfHelixLarge, left45 }, { 75,  67,  3, 10, downHalfHelixLarge, left45 }, { 75,  68,  2, 10, downHalfHelixLarge, left45 }, { 76,  69,  2, 10, downHalfHelixLarge, left45 },
    { 76,  70,  2, 10, downHalfHelixLarge, left45 }, { 76,  71,  2, 10, downHalfHelixLarge, left45 }, { 77,  72,  2,  9, downHalfHelixLarge, left45 }, { 77,  73,  2,  9, downHalfHelixLarge, left45 },
    { 77,  74,  2,  9, downHalfHelixLarge, left45 }, { 77,  75,  2,  9, downHalfHelixLarge, left45 }, { 78,  76,  2,  9, downHalfHelixLarge, left45 }, { 78,  77,  2,  9, downHalfHelixLarge, left45 },
    { 78,  78,  2,  9, downHalfHelixLarge, left45 }, { 78,  79,  2,  9, downHalfHelixLarge, left45 }, { 78,  80,  2,  9, downHalfHelixLarge, left45 }, { 79,  81,  2,  9, downHalfHelixLarge, left45 },
    { 79,  82,  1,  9, downHalfHelixLarge, left45 }, { 79,  83,  1,  9, downHalfHelixLarge, left45 }, { 79,  84,  1,  9, downHalfHelixLarge, left45 }, { 79,  85,  1,  9, downHalfHelixLarge, left45 },
    { 79,  86,  1,  9, downHalfHelixLarge, left45 }, { 80,  87,  1,  9, downHalfHelixLarge, left45 }, { 80,  88,  1,  8, downHalfHelixLarge, left45 }, { 80,  89,  1,  8, downHalfHelixLarge, left45 },
    { 80,  90,  1,  8, downHalfHelixLarge, left45 }, { 80,  91,  1,  8, downHalfHelixLarge, left45 }, { 80,  92,  1,  8, downHalfHelixLarge, left45 }, { 80,  93,  1,  8, downHalfHelixLarge, left45 },
    { 80,  94,  1,  8, downHalfHelixLarge, left45 }, { 80,  95,  1,  8, downHalfHelixLarge, left45 }, { 80,  96,  0,  8, downHalfHelixLarge, left45 }, { 80,  97,  0,  8, downHalfHelixLarge, left45 },
    { 80,  98,  0,  8, downHalfHelixLarge, left45 }, { 80,  99,  0,  8, downHalfHelixLarge, left45 }, { 80, 100,  0,  8, downHalfHelixLarge, left45 }, { 80, 101,  0,  8, downHalfHelixLarge, left45 },
    { 80, 102,  0,  8, downHalfHelixLarge, left45 }, { 80, 103,  0,  8, downHalfHelixLarge, left45 }, { 80, 104,  0,  7, downHalfHelixLarge, left45 }, { 79, 105,  0,  7, downHalfHelixLarge, left45 },
    { 79, 106,  0,  7, downHalfHelixLarge, left45 }, { 79, 107,  0,  7, downHalfHelixLarge, left45 }, { 79, 108,  0,  7, downHalfHelixLarge, left45 }, { 79, 109,  0,  7, downHalfHelixLarge, left45 },
    { 79, 110,  0,  7, downHalfHelixLarge, left45 }, { 78, 111, -1,  7, downHalfHelixLarge, left45 }, { 78, 112, -1,  7, downHalfHelixLarge, left45 }, { 78, 113, -1,  7, downHalfHelixLarge, left45 },
    { 78, 114, -1,  7, downHalfHelixLarge, left45 }, { 78, 115, -1,  7, downHalfHelixLarge, left45 }, { 77, 116, -1,  7, downHalfHelixLarge, left45 }, { 77, 117, -1,  7, downHalfHelixLarge, left45 },
    { 77, 118, -1,  6, downHalfHelixLarge, left45 }, { 77, 119, -1,  6, downHalfHelixLarge, left45 }, { 76, 120, -1,  6, downHalfHelixLarge, left45 }, { 76, 121, -1,  6, downHalfHelixLarge, left45 },
    { 76, 122, -1,  6, downHalfHelixLarge, left45 }, { 75, 123, -1,  6, downHalfHelixLarge, left45 }, { 75, 124, -1,  6, downHalfHelixLarge, left45 }, { 75, 125, -2,  6, downHalfHelixLarge, left45 },
    { 74, 126, -2,  6, downHalfHelixLarge, left45 }, { 74, 127, -2,  6, downHalfHelixLarge, left45 }, { 73, 128, -2,  6, downHalfHelixLarge, left45 }, { 73, 129, -2,  6, downHalfHelixLarge, left45 },
    { 72, 130, -2,  6, downHalfHelixLarge, left45 }, { 72, 131, -2,  6, downHalfHelixLarge, left45 }, { 71, 132, -2,  6, downHalfHelixLarge, left45 }, { 71, 133, -2,  5, downHalfHelixLarge, left45 },
    { 70, 134, -2,  5, downHalfHelixLarge, left45 }, { 70, 135, -2,  5, downHalfHelixLarge, left45 }, { 69, 136, -2,  5, downHalfHelixLarge, left45 }, { 68, 137, -2,  5, downHalfHelixLarge, left45 },
    { 68, 138, -2,  5, downHalfHelixLarge, left45 }, { 67, 139, -2,  5, downHalfHelixLarge, left45 }, { 66, 140, -3,  5, downHalfHelixLarge, left45 }, { 66, 141, -3,  5, downHalfHelixLarge, left45 },
    { 65, 142, -3,  5, downHalfHelixLarge, left45 }, { 64, 143, -3,  5, downHalfHelixLarge, left45 }, { 64, 144, -3,  5, downHalfHelixLarge, left45 }, { 63, 145, -3,  5, downHalfHelixLarge, left45 },
    { 62, 146, -3,  4, downHalfHelixLarge, left45 }, { 61, 147, -3,  4, downHalfHelixLarge, left45 }, { 61, 148, -3,  4, downHalfHelixLarge, left45 }, { 60, 149, -3,  4, downHalfHelixLarge, left45 },
    { 59, 150, -3,  4, downHalfHelixLarge, left45 }, { 58, 151, -3,  4, downHalfHelixLarge, left45 }, { 57, 152, -3,  4, downHalfHelixLarge, left45 }, { 57, 153, -3,  4, downHalfHelixLarge, left45 },
    { 56, 154, -4,  4, downHalfHelixLarge, left45 }, { 55, 155, -4,  4, downHalfHelixLarge, left45 }, { 54, 156, -4,  4, downHalfHelixLarge, left45 }, { 53, 157, -4,  4, downHalfHelixLarge, left45 },
    { 52, 157, -4,  4, downHalfHelixLarge, left45 }, { 51, 158, -4,  3, downHalfHelixLarge, left45 }, { 50, 159, -4,  3, downHalfHelixLarge, left45 }, { 49, 160, -4,  3, downHalfHelixLarge, left45 },
    { 48, 160, -4,  3, downHalfHelixLarge, left45 }, { 47, 161, -4,  3, downHalfHelixLarge, left45 }, { 46, 162, -4,  3, downHalfHelixLarge, left45 }, { 45, 162, -4,  3, downHalfHelixLarge, left45 },
    { 44, 163, -4,  3, downHalfHelixLarge, left45 }, { 43, 164, -4,  3, downHalfHelixLarge, left45 }, { 42, 164, -5,  3, downHalfHelixLarge, left45 }, { 41, 165, -5,  3, downHalfHelixLarge, left45 },
    { 40, 166, -5,  3, downHalfHelixLarge, left45 }, { 39, 166, -5,  3, downHalfHelixLarge, left45 }, { 38, 167, -5,  2, downHalfHelixLarge, left45 }, { 37, 167, -5,  2, downHalfHelixLarge, left45 },
    { 36, 168, -5,  2, downHalfHelixLarge, left45 }, { 35, 168, -5,  2, downHalfHelixLarge, left45 }, { 34, 169, -5,  2, downHalfHelixLarge, left45 }, { 33, 169, -5,  2, downHalfHelixLarge, left45 },
    { 32, 170, -5,  2, downHalfHelixLarge, left45 }, { 31, 170, -5,  2, downHalfHelixLarge, left45 }, { 30, 171, -5,  2, downHalfHelixLarge, left45 }, { 29, 171, -5,  2, downHalfHelixLarge, left45 },
    { 28, 171, -5,  2, downHalfHelixLarge, left45 }, { 27, 172, -6,  2, downHalfHelixLarge, left45 }, { 26, 172, -6,  2, downHalfHelixLarge, left45 }, { 25, 172, -6,  2, downHalfHelixLarge, left45 },
    { 24, 173, -6,  1, downHalfHelixLarge, left45 }, { 23, 173, -6,  1, downHalfHelixLarge, left45 }, { 22, 173, -6,  1, downHalfHelixLarge, left45 }, { 21, 173, -6,  1, downHalfHelixLarge, left45 },
    { 20, 174, -6,  1, downHalfHelixLarge, left45 }, { 19, 174, -6,  1, downHalfHelixLarge, left45 }, { 18, 174, -6,  1, downHalfHelixLarge, left45 }, { 17, 174, -6,  1, downHalfHelixLarge, left45 },
    { 16, 174, -6,  1, downHalfHelixLarge, left45 }, { 15, 175, -6,  1, downHalfHelixLarge, left45 }, { 14, 175, -6,  1, downHalfHelixLarge, left45 }, { 13, 175, -7,  1, downHalfHelixLarge, left45 },
    { 12, 175, -7,  1, downHalfHelixLarge, left45 }, { 11, 175, -7,  1, downHalfHelixLarge, left45 }, { 10, 175, -7,  1, downHalfHelixLarge, left45 }, {  9, 176, -7,  1, downHalfHelixLarge, left45 },
    {  8, 176, -7,  0, downHalfHelixLarge, left45 }, {  7, 176, -7,  0, downHalfHelixLarge, left45 }, {  6, 176, -7,  0, downHalfHelixLarge, left45 }, {  5, 176, -7,  0, downHalfHelixLarge, left45 },
    {  4, 176, -7,  0, downHalfHelixLarge, left45 }, {  3, 176, -7,  0, downHalfHelixLarge, left45 }, {  2, 176, -7,  0, downHalfHelixLarge, left45 }, {  1, 176, -7,  0, downHalfHelixLarge, left45 },
    {  0, 176, -7,  0, downHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F646D, {
    {  16,  31,  8, 24, downHalfHelixLarge, left45 }, {  16,  30,  8, 24, downHalfHelixLarge, left45 }, {  16,  29,  8, 24, downHalfHelixLarge, left45 },
    {  16,  28,  8, 24, downHalfHelixLarge, left45 }, {  16,  27,  8, 24, downHalfHelixLarge, left45 }, {  16,  26,  8, 24, downHalfHelixLarge, left45 },
    {  16,  25,  8, 24, downHalfHelixLarge, left45 }, {  16,  24,  8, 23, downHalfHelixLarge, left45 }, {  17,  23,  8, 23, downHalfHelixLarge, left45 },
    {  17,  22,  8, 23, downHalfHelixLarge, left45 }, {  17,  21,  8, 23, downHalfHelixLarge, left45 }, {  17,  20,  8, 23, downHalfHelixLarge, left45 },
    {  17,  19,  8, 23, downHalfHelixLarge, left45 }, {  17,  18,  8, 23, downHalfHelixLarge, left45 }, {  18,  17,  7, 23, downHalfHelixLarge, left45 },
    {  18,  16,  7, 23, downHalfHelixLarge, left45 }, {  18,  15,  7, 23, downHalfHelixLarge, left45 }, {  18,  14,  7, 23, downHalfHelixLarge, left45 },
    {  18,  13,  7, 23, downHalfHelixLarge, left45 }, {  19,  12,  7, 23, downHalfHelixLarge, left45 }, {  19,  11,  7, 23, downHalfHelixLarge, left45 },
    {  19,  10,  7, 22, downHalfHelixLarge, left45 }, {  19,   9,  7, 22, downHalfHelixLarge, left45 }, {  20,   8,  7, 22, downHalfHelixLarge, left45 },
    {  20,   7,  7, 22, downHalfHelixLarge, left45 }, {  20,   6,  7, 22, downHalfHelixLarge, left45 }, {  21,   5,  7, 22, downHalfHelixLarge, left45 },
    {  21,   4,  7, 22, downHalfHelixLarge, left45 }, {  21,   3,  6, 22, downHalfHelixLarge, left45 }, {  22,   2,  6, 22, downHalfHelixLarge, left45 },
    {  22,   1,  6, 22, downHalfHelixLarge, left45 }, {  23,   0,  6, 22, downHalfHelixLarge, left45 }, {  23,  -1,  6, 22, downHalfHelixLarge, left45 },
    {  24,  -2,  6, 22, downHalfHelixLarge, left45 }, {  24,  -3,  6, 22, downHalfHelixLarge, left45 }, {  25,  -4,  6, 22, downHalfHelixLarge, left45 },
    {  25,  -5,  6, 21, downHalfHelixLarge, left45 }, {  26,  -6,  6, 21, downHalfHelixLarge, left45 }, {  26,  -7,  6, 21, downHalfHelixLarge, left45 },
    {  27,  -8,  6, 21, downHalfHelixLarge, left45 }, {  28,  -9,  6, 21, downHalfHelixLarge, left45 }, {  28, -10,  6, 21, downHalfHelixLarge, left45 },
    {  29, -11,  5, 21, downHalfHelixLarge, left45 }, {  30, -12,  5, 21, downHalfHelixLarge, left45 }, {  30, -13,  5, 21, downHalfHelixLarge, left45 },
    {  31, -14,  5, 21, downHalfHelixLarge, left45 }, {  32, -15,  5, 21, downHalfHelixLarge, left45 }, {  32, -16,  5, 21, downHalfHelixLarge, left45 },
    {  33, -17,  5, 21, downHalfHelixLarge, left45 }, {  34, -18,  5, 20, downHalfHelixLarge, left45 }, {  35, -19,  5, 20, downHalfHelixLarge, left45 },
    {  35, -20,  5, 20, downHalfHelixLarge, left45 }, {  36, -21,  5, 20, downHalfHelixLarge, left45 }, {  37, -22,  5, 20, downHalfHelixLarge, left45 },
    {  38, -23,  5, 20, downHalfHelixLarge, left45 }, {  39, -24,  5, 20, downHalfHelixLarge, left45 }, {  39, -25,  4, 20, downHalfHelixLarge, left45 },
    {  40, -26,  4, 20, downHalfHelixLarge, left45 }, {  41, -27,  4, 20, downHalfHelixLarge, left45 }, {  42, -28,  4, 20, downHalfHelixLarge, left45 },
    {  43, -29,  4, 20, downHalfHelixLarge, left45 }, {  44, -29,  4, 20, downHalfHelixLarge, left45 }, {  45, -30,  4, 19, downHalfHelixLarge, left45 },
    {  46, -31,  4, 19, downHalfHelixLarge, left45 }, {  47, -32,  4, 19, downHalfHelixLarge, left45 }, {  48, -32,  4, 19, downHalfHelixLarge, left45 },
    {  49, -33,  4, 19, downHalfHelixLarge, left45 }, {  50, -34,  4, 19, downHalfHelixLarge, left45 }, {  51, -34,  4, 19, downHalfHelixLarge, left45 },
    {  52, -35,  4, 19, downHalfHelixLarge, left45 }, {  53, -36,  3, 19, downHalfHelixLarge, left45 }, {  54, -36,  3, 19, downHalfHelixLarge, left45 },
    {  55, -37,  3, 19, downHalfHelixLarge, left45 }, {  56, -38,  3, 19, downHalfHelixLarge, left45 }, {  57, -38,  3, 19, downHalfHelixLarge, left45 },
    {  58, -39,  3, 18, downHalfHelixLarge, left45 }, {  59, -39,  3, 18, downHalfHelixLarge, left45 }, {  60, -40,  3, 18, downHalfHelixLarge, left45 },
    {  61, -40,  3, 18, downHalfHelixLarge, left45 }, {  62, -41,  3, 18, downHalfHelixLarge, left45 }, {  63, -41,  3, 18, downHalfHelixLarge, left45 },
    {  64, -42,  3, 18, downHalfHelixLarge, left45 }, {  65, -42,  3, 18, downHalfHelixLarge, left45 }, {  66, -43,  3, 18, downHalfHelixLarge, left45 },
    {  67, -43,  2, 18, downHalfHelixLarge, left45 }, {  68, -43,  2, 18, downHalfHelixLarge, left45 }, {  69, -44,  2, 18, downHalfHelixLarge, left45 },
    {  70, -44,  2, 18, downHalfHelixLarge, left45 }, {  71, -44,  2, 18, downHalfHelixLarge, left45 }, {  72, -45,  2, 17, downHalfHelixLarge, left45 },
    {  73, -45,  2, 17, downHalfHelixLarge, left45 }, {  74, -45,  2, 17, downHalfHelixLarge, left45 }, {  75, -45,  2, 17, downHalfHelixLarge, left45 },
    {  76, -46,  2, 17, downHalfHelixLarge, left45 }, {  77, -46,  2, 17, downHalfHelixLarge, left45 }, {  78, -46,  2, 17, downHalfHelixLarge, left45 },
    {  79, -46,  2, 17, downHalfHelixLarge, left45 }, {  80, -46,  2, 17, downHalfHelixLarge, left45 }, {  81, -47,  1, 17, downHalfHelixLarge, left45 },
    {  82, -47,  1, 17, downHalfHelixLarge, left45 }, {  83, -47,  1, 17, downHalfHelixLarge, left45 }, {  84, -47,  1, 17, downHalfHelixLarge, left45 },
    {  85, -47,  1, 17, downHalfHelixLarge, left45 }, {  86, -47,  1, 17, downHalfHelixLarge, left45 }, {  87, -48,  1, 17, downHalfHelixLarge, left45 },
    {  88, -48,  1, 16, downHalfHelixLarge, left45 }, {  89, -48,  1, 16, downHalfHelixLarge, left45 }, {  90, -48,  1, 16, downHalfHelixLarge, left45 },
    {  91, -48,  1, 16, downHalfHelixLarge, left45 }, {  92, -48,  1, 16, downHalfHelixLarge, left45 }, {  93, -48,  1, 16, downHalfHelixLarge, left45 },
    {  94, -48,  1, 16, downHalfHelixLarge, left45 }, {  95, -48,  0, 16, downHalfHelixLarge, left45 }, {  96, -48,  0, 16, downHalfHelixLarge, left45 },
    {  97, -48,  0, 16, downHalfHelixLarge, left45 }, {  98, -48,  0, 16, downHalfHelixLarge, left45 }, {  99, -48,  0, 16, downHalfHelixLarge, left45 },
    { 100, -48,  0, 16, downHalfHelixLarge, left45 }, { 101, -48,  0, 16, downHalfHelixLarge, left45 }, { 102, -48,  0, 16, downHalfHelixLarge, left45 },
    { 103, -48,  0, 16, downHalfHelixLarge, left45 }, { 104, -48,  0, 15, downHalfHelixLarge, left45 }, { 105, -47,  0, 15, downHalfHelixLarge, left45 },
    { 106, -47,  0, 15, downHalfHelixLarge, left45 }, { 107, -47,  0, 15, downHalfHelixLarge, left45 }, { 108, -47,  0, 15, downHalfHelixLarge, left45 },
    { 109, -47,  0, 15, downHalfHelixLarge, left45 }, { 110, -47,  0, 15, downHalfHelixLarge, left45 }, { 111, -46, -1, 15, downHalfHelixLarge, left45 },
    { 112, -46, -1, 15, downHalfHelixLarge, left45 }, { 113, -46, -1, 15, downHalfHelixLarge, left45 }, { 114, -46, -1, 15, downHalfHelixLarge, left45 },
    { 115, -46, -1, 15, downHalfHelixLarge, left45 }, { 116, -45, -1, 15, downHalfHelixLarge, left45 }, { 117, -45, -1, 15, downHalfHelixLarge, left45 },
    { 118, -45, -1, 14, downHalfHelixLarge, left45 }, { 119, -45, -1, 14, downHalfHelixLarge, left45 }, { 120, -44, -1, 14, downHalfHelixLarge, left45 },
    { 121, -44, -1, 14, downHalfHelixLarge, left45 }, { 122, -44, -1, 14, downHalfHelixLarge, left45 }, { 123, -43, -1, 14, downHalfHelixLarge, left45 },
    { 124, -43, -1, 14, downHalfHelixLarge, left45 }, { 125, -43, -2, 14, downHalfHelixLarge, left45 }, { 126, -42, -2, 14, downHalfHelixLarge, left45 },
    { 127, -42, -2, 14, downHalfHelixLarge, left45 }, { 128, -41, -2, 14, downHalfHelixLarge, left45 }, { 129, -41, -2, 14, downHalfHelixLarge, left45 },
    { 130, -40, -2, 14, downHalfHelixLarge, left45 }, { 131, -40, -2, 14, downHalfHelixLarge, left45 }, { 132, -39, -2, 14, downHalfHelixLarge, left45 },
    { 133, -39, -2, 13, downHalfHelixLarge, left45 }, { 134, -38, -2, 13, downHalfHelixLarge, left45 }, { 135, -38, -2, 13, downHalfHelixLarge, left45 },
    { 136, -37, -2, 13, downHalfHelixLarge, left45 }, { 137, -36, -2, 13, downHalfHelixLarge, left45 }, { 138, -36, -2, 13, downHalfHelixLarge, left45 },
    { 139, -35, -3, 13, downHalfHelixLarge, left45 }, { 140, -34, -3, 13, downHalfHelixLarge, left45 }, { 141, -34, -3, 13, downHalfHelixLarge, left45 },
    { 142, -33, -3, 13, downHalfHelixLarge, left45 }, { 143, -32, -3, 13, downHalfHelixLarge, left45 }, { 144, -32, -3, 13, downHalfHelixLarge, left45 },
    { 145, -31, -3, 13, downHalfHelixLarge, left45 }, { 146, -30, -3, 12, downHalfHelixLarge, left45 }, { 147, -29, -3, 12, downHalfHelixLarge, left45 },
    { 148, -29, -3, 12, downHalfHelixLarge, left45 }, { 149, -28, -3, 12, downHalfHelixLarge, left45 }, { 150, -27, -3, 12, downHalfHelixLarge, left45 },
    { 151, -26, -3, 12, downHalfHelixLarge, left45 }, { 152, -25, -3, 12, downHalfHelixLarge, left45 }, { 153, -25, -4, 12, downHalfHelixLarge, left45 },
    { 154, -24, -4, 12, downHalfHelixLarge, left45 }, { 155, -23, -4, 12, downHalfHelixLarge, left45 }, { 156, -22, -4, 12, downHalfHelixLarge, left45 },
    { 157, -21, -4, 12, downHalfHelixLarge, left45 }, { 157, -20, -4, 12, downHalfHelixLarge, left45 }, { 158, -19, -4, 11, downHalfHelixLarge, left45 },
    { 159, -18, -4, 11, downHalfHelixLarge, left45 }, { 160, -17, -4, 11, downHalfHelixLarge, left45 }, { 160, -16, -4, 11, downHalfHelixLarge, left45 },
    { 161, -15, -4, 11, downHalfHelixLarge, left45 }, { 162, -14, -4, 11, downHalfHelixLarge, left45 }, { 162, -13, -4, 11, downHalfHelixLarge, left45 },
    { 163, -12, -4, 11, downHalfHelixLarge, left45 }, { 164, -11, -4, 11, downHalfHelixLarge, left45 }, { 164, -10, -5, 11, downHalfHelixLarge, left45 },
    { 165,  -9, -5, 11, downHalfHelixLarge, left45 }, { 166,  -8, -5, 11, downHalfHelixLarge, left45 }, { 166,  -7, -5, 11, downHalfHelixLarge, left45 },
    { 167,  -6, -5, 10, downHalfHelixLarge, left45 }, { 167,  -5, -5, 10, downHalfHelixLarge, left45 }, { 168,  -4, -5, 10, downHalfHelixLarge, left45 },
    { 168,  -3, -5, 10, downHalfHelixLarge, left45 }, { 169,  -2, -5, 10, downHalfHelixLarge, left45 }, { 169,  -1, -5, 10, downHalfHelixLarge, left45 },
    { 170,   0, -5, 10, downHalfHelixLarge, left45 }, { 170,   1, -5, 10, downHalfHelixLarge, left45 }, { 171,   2, -5, 10, downHalfHelixLarge, left45 },
    { 171,   3, -5, 10, downHalfHelixLarge, left45 }, { 171,   4, -6, 10, downHalfHelixLarge, left45 }, { 172,   5, -6, 10, downHalfHelixLarge, left45 },
    { 172,   6, -6, 10, downHalfHelixLarge, left45 }, { 172,   7, -6, 10, downHalfHelixLarge, left45 }, { 173,   8, -6,  9, downHalfHelixLarge, left45 },
    { 173,   9, -6,  9, downHalfHelixLarge, left45 }, { 173,  10, -6,  9, downHalfHelixLarge, left45 }, { 173,  11, -6,  9, downHalfHelixLarge, left45 },
    { 174,  12, -6,  9, downHalfHelixLarge, left45 }, { 174,  13, -6,  9, downHalfHelixLarge, left45 }, { 174,  14, -6,  9, downHalfHelixLarge, left45 },
    { 174,  15, -6,  9, downHalfHelixLarge, left45 }, { 174,  16, -6,  9, downHalfHelixLarge, left45 }, { 175,  17, -6,  9, downHalfHelixLarge, left45 },
    { 175,  18, -7,  9, downHalfHelixLarge, left45 }, { 175,  19, -7,  9, downHalfHelixLarge, left45 }, { 175,  20, -7,  9, downHalfHelixLarge, left45 },
    { 175,  21, -7,  9, downHalfHelixLarge, left45 }, { 175,  22, -7,  9, downHalfHelixLarge, left45 }, { 176,  23, -7,  9, downHalfHelixLarge, left45 },
    { 176,  24, -7,  8, downHalfHelixLarge, left45 }, { 176,  25, -7,  8, downHalfHelixLarge, left45 }, { 176,  26, -7,  8, downHalfHelixLarge, left45 },
    { 176,  27, -7,  8, downHalfHelixLarge, left45 }, { 176,  28, -7,  8, downHalfHelixLarge, left45 }, { 176,  29, -7,  8, downHalfHelixLarge, left45 },
    { 176,  30, -7,  8, downHalfHelixLarge, left45 }, { 176,  31, -7,  8, downHalfHelixLarge, left45 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F6C6A, {
    {  31,  16,  8,  0, downHalfHelixLarge, right45 }, {  30,  16,  8,  0, downHalfHelixLarge, right45 }, {  29,  16,  8,  0, downHalfHelixLarge, right45 },
    {  28,  16,  8,  0, downHalfHelixLarge, right45 }, {  27,  16,  8,  0, downHalfHelixLarge, right45 }, {  26,  16,  8,  0, downHalfHelixLarge, right45 },
    {  25,  16,  8,  0, downHalfHelixLarge, right45 }, {  24,  16,  8,  1, downHalfHelixLarge, right45 }, {  23,  17,  8,  1, downHalfHelixLarge, right45 },
    {  22,  17,  8,  1, downHalfHelixLarge, right45 }, {  21,  17,  8,  1, downHalfHelixLarge, right45 }, {  20,  17,  8,  1, downHalfHelixLarge, right45 },
    {  19,  17,  8,  1, downHalfHelixLarge, right45 }, {  18,  17,  8,  1, downHalfHelixLarge, right45 }, {  17,  18,  7,  1, downHalfHelixLarge, right45 },
    {  16,  18,  7,  1, downHalfHelixLarge, right45 }, {  15,  18,  7,  1, downHalfHelixLarge, right45 }, {  14,  18,  7,  1, downHalfHelixLarge, right45 },
    {  13,  18,  7,  1, downHalfHelixLarge, right45 }, {  12,  19,  7,  1, downHalfHelixLarge, right45 }, {  11,  19,  7,  1, downHalfHelixLarge, right45 },
    {  10,  19,  7,  2, downHalfHelixLarge, right45 }, {   9,  19,  7,  2, downHalfHelixLarge, right45 }, {   8,  20,  7,  2, downHalfHelixLarge, right45 },
    {   7,  20,  7,  2, downHalfHelixLarge, right45 }, {   6,  20,  7,  2, downHalfHelixLarge, right45 }, {   5,  21,  7,  2, downHalfHelixLarge, right45 },
    {   4,  21,  7,  2, downHalfHelixLarge, right45 }, {   3,  21,  6,  2, downHalfHelixLarge, right45 }, {   2,  22,  6,  2, downHalfHelixLarge, right45 },
    {   1,  22,  6,  2, downHalfHelixLarge, right45 }, {   0,  23,  6,  2, downHalfHelixLarge, right45 }, {  -1,  23,  6,  2, downHalfHelixLarge, right45 },
    {  -2,  24,  6,  2, downHalfHelixLarge, right45 }, {  -3,  24,  6,  2, downHalfHelixLarge, right45 }, {  -4,  25,  6,  2, downHalfHelixLarge, right45 },
    {  -5,  25,  6,  3, downHalfHelixLarge, right45 }, {  -6,  26,  6,  3, downHalfHelixLarge, right45 }, {  -7,  26,  6,  3, downHalfHelixLarge, right45 },
    {  -8,  27,  6,  3, downHalfHelixLarge, right45 }, {  -9,  28,  6,  3, downHalfHelixLarge, right45 }, { -10,  28,  6,  3, downHalfHelixLarge, right45 },
    { -11,  29,  5,  3, downHalfHelixLarge, right45 }, { -12,  30,  5,  3, downHalfHelixLarge, right45 }, { -13,  30,  5,  3, downHalfHelixLarge, right45 },
    { -14,  31,  5,  3, downHalfHelixLarge, right45 }, { -15,  32,  5,  3, downHalfHelixLarge, right45 }, { -16,  32,  5,  3, downHalfHelixLarge, right45 },
    { -17,  33,  5,  3, downHalfHelixLarge, right45 }, { -18,  34,  5,  4, downHalfHelixLarge, right45 }, { -19,  35,  5,  4, downHalfHelixLarge, right45 },
    { -20,  35,  5,  4, downHalfHelixLarge, right45 }, { -21,  36,  5,  4, downHalfHelixLarge, right45 }, { -22,  37,  5,  4, downHalfHelixLarge, right45 },
    { -23,  38,  5,  4, downHalfHelixLarge, right45 }, { -24,  39,  5,  4, downHalfHelixLarge, right45 }, { -25,  39,  4,  4, downHalfHelixLarge, right45 },
    { -26,  40,  4,  4, downHalfHelixLarge, right45 }, { -27,  41,  4,  4, downHalfHelixLarge, right45 }, { -28,  42,  4,  4, downHalfHelixLarge, right45 },
    { -29,  43,  4,  4, downHalfHelixLarge, right45 }, { -29,  44,  4,  4, downHalfHelixLarge, right45 }, { -30,  45,  4,  5, downHalfHelixLarge, right45 },
    { -31,  46,  4,  5, downHalfHelixLarge, right45 }, { -32,  47,  4,  5, downHalfHelixLarge, right45 }, { -32,  48,  4,  5, downHalfHelixLarge, right45 },
    { -33,  49,  4,  5, downHalfHelixLarge, right45 }, { -34,  50,  4,  5, downHalfHelixLarge, right45 }, { -34,  51,  4,  5, downHalfHelixLarge, right45 },
    { -35,  52,  4,  5, downHalfHelixLarge, right45 }, { -36,  53,  3,  5, downHalfHelixLarge, right45 }, { -36,  54,  3,  5, downHalfHelixLarge, right45 },
    { -37,  55,  3,  5, downHalfHelixLarge, right45 }, { -38,  56,  3,  5, downHalfHelixLarge, right45 }, { -38,  57,  3,  5, downHalfHelixLarge, right45 },
    { -39,  58,  3,  6, downHalfHelixLarge, right45 }, { -39,  59,  3,  6, downHalfHelixLarge, right45 }, { -40,  60,  3,  6, downHalfHelixLarge, right45 },
    { -40,  61,  3,  6, downHalfHelixLarge, right45 }, { -41,  62,  3,  6, downHalfHelixLarge, right45 }, { -41,  63,  3,  6, downHalfHelixLarge, right45 },
    { -42,  64,  3,  6, downHalfHelixLarge, right45 }, { -42,  65,  3,  6, downHalfHelixLarge, right45 }, { -43,  66,  3,  6, downHalfHelixLarge, right45 },
    { -43,  67,  2,  6, downHalfHelixLarge, right45 }, { -43,  68,  2,  6, downHalfHelixLarge, right45 }, { -44,  69,  2,  6, downHalfHelixLarge, right45 },
    { -44,  70,  2,  6, downHalfHelixLarge, right45 }, { -44,  71,  2,  6, downHalfHelixLarge, right45 }, { -45,  72,