/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTCanvasView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    private boolean isStyledText;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        NSView nsClipView = this.contentView();
        if (nsClipView == null) {
            return new Control[0];
        }
        NSArray views = nsClipView.subviews();
        int count = (int)views.count();
        Control[] children = new Control[count];
        if (count == 0) {
            return children;
        }
        int j = 0;
        for (int i = 0; i < count; ++i) {
            Widget widget = this.display.getWidget(views.objectAtIndex((long)((long)(count - i - 1))).id);
            if (widget == null || widget == this || !(widget instanceof Control)) continue;
            children[j++] = (Control)widget;
        }
        if (j == count) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            ++count;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            newList[index++] = this.tabList[i];
        }
        this.tabList = newList;
        return this.tabList;
    }

    @Override
    boolean acceptsFirstMouse(long id2, long sel, long theEvent) {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.acceptsFirstMouse(id2, sel, theEvent);
    }

    @Override
    boolean acceptsFirstResponder(long id2, long sel) {
        if ((this.state & 2) != 0) {
            return (this.style & 0x80000) == 0 && this.hooksKeys() && this.contentView().subviews().count() == 0L;
        }
        return super.acceptsFirstResponder(id2, sel);
    }

    @Override
    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        NSString nsAttributeName = new NSString(arg0);
        long superValue = super.accessibilityAttributeValue(id2, sel, arg0);
        if ((this.state & 2) != 0 && id2 == this.accessibleHandle()) {
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                NSString role;
                if (superValue != 0L && !(role = new NSString(superValue)).isEqualToString(OS.NSAccessibilityUnknownRole)) {
                    return superValue;
                }
                role = NSString.stringWith("SWTComposite");
                return role.id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
                NSString role;
                if (superValue != 0L && !(role = new NSString(superValue)).isEqualToString(OS.NSAccessibilityUnknownSubrole)) {
                    return superValue;
                }
                NSString roleDescription = NSString.stringWith("generic container view");
                return roleDescription.id;
            }
        }
        return superValue;
    }

    @Override
    boolean accessibilityIsIgnored(long id2, long sel) {
        if (id2 == this.accessibleHandle() && this.accessible != null) {
            return this.accessible.internal_accessibilityIsIgnored(-1);
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    @Deprecated
    public void changed(Control[] changed) {
        this.layout(changed, 4);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        this.display.runSkin();
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x2000) != 0);
                this.state &= 0xFFFFDFFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
            if (size.x == 0) {
                size.x = 64;
            }
            if (size.y == 0) {
                size.y = 64;
            }
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    Widget[] computeTabList() {
        Widget[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i = 0; i < list.length; ++i) {
            Control child = list[i];
            Widget[] childList = child.computeTabList();
            if (childList.length == 0) continue;
            Widget[] newResult = new Widget[result.length + childList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(childList, 0, newResult, result.length, childList.length);
            result = newResult;
        }
        return result;
    }

    @Override
    void createHandle() {
        boolean scrolled;
        this.state |= 2;
        boolean bl = scrolled = (this.style & 0x300) != 0;
        if (!scrolled) {
            this.state |= 0x800;
        }
        NSRect rect = new NSRect();
        if (scrolled || this.hasBorder()) {
            NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
            scrollWidget.initWithFrame(rect);
            scrollWidget.setDrawsBackground(false);
            if ((this.style & 0x100) != 0) {
                scrollWidget.setHasHorizontalScroller(true);
            }
            if ((this.style & 0x200) != 0) {
                scrollWidget.setHasVerticalScroller(true);
            }
            scrollWidget.setBorderType(this.hasBorder() ? 2L : 0L);
            this.scrollView = scrollWidget;
        }
        NSView widget = (NSView)new SWTCanvasView().alloc();
        widget.initWithFrame(rect);
        this.view = widget;
        if (this.scrollView != null) {
            NSClipView contentView = this.scrollView.contentView();
            contentView.setAutoresizesSubviews(true);
            this.view.setAutoresizingMask(18L);
        }
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            int imgHeight = -1;
            GCData data = gc.getGCData();
            if (data.image != null) {
                imgHeight = data.image.getBounds().height;
            }
            NSGraphicsContext context = gc.handle;
            if (data.flippedContext != null) {
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(context);
            }
            control.fillBackground(this.view, context, rect, imgHeight, data.view, offsetX, offsetY);
            if (data.flippedContext != null) {
                NSGraphicsContext.static_restoreGraphicsState();
            }
        } else {
            gc.fillRectangle(x, y, width, height);
        }
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        if ((this.state & 2) != 0 && (this.style & 0x40000) == 0) {
            this.fillBackground(this.view, context, rect, -1);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    @Override
    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length == 0) continue;
            Menu[] newResult = new Menu[result.length + menuList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
            result = newResult;
        }
        return result;
    }

    @Override
    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i] != control) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            for (int i = 0; i < this.tabList.length; ++i) {
                if (this.tabList[i] == control) continue;
                newList[index++] = this.tabList[i];
            }
        }
        this.tabList = newList;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isTabGroup()) continue;
                ++count;
            }
            tabList = new Control[count];
            int index = 0;
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isTabGroup()) continue;
                tabList[index++] = list[i];
            }
        }
        return tabList;
    }

    @Override
    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    @Override
    void invalidateChildrenVisibleRegion() {
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            child.resetVisibleRegion();
            child.invalidateChildrenVisibleRegion();
        }
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    @Override
    boolean isOpaque(long id2, long sel) {
        if ((this.state & 2) != 0 && id2 == this.view.id) {
            return this.region == null && this.isOpaque();
        }
        return super.isOpaque(id2, sel);
    }

    boolean isOpaque() {
        if (this.isStyledText) {
            return this.background == null || this.backgroundAlpha == 255;
        }
        return this.background != null && this.background[3] == 1.0 && !this.isObscured();
    }

    @Override
    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    @Override
    void keyDown(long id2, long sel, long theEvent) {
        if (this.hasFocus() && (this.state & 2) != 0) {
            Shell s = this.getShell();
            s.deferFlushing();
            NSArray array = NSArray.arrayWithObject(new NSEvent(theEvent));
            s.keyInputHappened = false;
            this.view.interpretKeyEvents(array);
            if (this.imeInComposition()) {
                return;
            }
            if (!s.keyInputHappened) {
                NSEvent nsEvent = new NSEvent(theEvent);
                boolean[] consume = new boolean[1];
                if (this.translateTraversal(nsEvent.keyCode(), nsEvent, consume)) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                if (!this.sendKeyEvent(nsEvent, 1)) {
                    return;
                }
                if (consume[0]) {
                    return;
                }
            }
            return;
        }
        super.keyDown(id2, sel, theEvent);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        this.layout(changed, 0);
    }

    public void layout(Control[] changed, int flags) {
        this.checkWidget();
        if (changed != null) {
            int i;
            for (int i2 = 0; i2 < changed.length; ++i2) {
                Control control = changed[i2];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                boolean ancestor = false;
                Composite composite = control.parent;
                while (composite != null) {
                    boolean bl = ancestor = composite == this;
                    if (ancestor) break;
                    composite = composite.parent;
                }
                if (ancestor) continue;
                this.error(32);
            }
            int updateCount = 0;
            Composite[] update = new Composite[16];
            for (i = 0; i < changed.length; ++i) {
                Control child = changed[i];
                Composite composite = child.parent;
                child.markLayout(false, false);
                while (child != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x1000;
                        if (!composite.layout.flushCache(child)) {
                            composite.state |= 0x2000;
                        }
                    }
                    if (updateCount == update.length) {
                        Composite[] newUpdate = new Composite[update.length + 16];
                        System.arraycopy(update, 0, newUpdate, 0, update.length);
                        update = newUpdate;
                    }
                    int n = updateCount++;
                    Composite composite2 = composite;
                    update[n] = composite2;
                    child = composite2;
                    composite = child.parent;
                }
            }
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            for (i = updateCount - 1; i >= 0; --i) {
                update[i].updateLayout(false);
            }
        } else {
            if (this.layout == null && (flags & 1) == 0) {
                return;
            }
            this.markLayout((flags & 2) != 0, (flags & 1) != 0);
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((flags & 1) != 0);
        }
    }

    @Override
    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x1000;
            if (changed) {
                this.state |= 0x2000;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].markLayout(changed, all);
            }
        }
    }

    Point minimumSize(int wHint, int Hint, boolean changed) {
        Control[] children = this._getChildren();
        Rectangle clientArea = this.getClientArea();
        int width = 0;
        int height = 0;
        for (int i = 0; i < children.length; ++i) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x - clientArea.x + rect.width);
            height = Math.max(height, rect.y - clientArea.y + rect.height);
        }
        return new Point(width, height);
    }

    @Override
    boolean mouseEvent(long id2, long sel, long theEvent, int type) {
        boolean result = super.mouseEvent(id2, sel, theEvent, type);
        return (this.state & 2) == 0 ? result : new NSEvent(theEvent).type() != 1L;
    }

    @Override
    void pageDown(long id2, long sel, long sender) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageDown(id2, sel, sender);
    }

    @Override
    void pageUp(long id2, long sel, long sender) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageUp(id2, sel, sender);
    }

    @Override
    void reflectScrolledClipView(long id2, long sel, long aClipView) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.reflectScrolledClipView(id2, sel, aClipView);
    }

    @Override
    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child == null || child.isDisposed()) continue;
            child.release(false);
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        if (control.hasFocus()) {
            this.redrawWidget(this.view, true);
        }
        this.fixTabList(control);
    }

    @Override
    void reskinChildren(int flags) {
        super.reskinChildren(flags);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child == null) continue;
            child.reskin(flags);
        }
    }

    @Override
    void resized() {
        super.resized();
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    @Override
    void scrollWheel(long id2, long sel, long theEvent) {
        if ((this.state & 2) != 0) {
            NSView view;
            NSView nSView = view = this.scrollView != null ? this.scrollView : this.view;
            if (id2 == view.id) {
                this.getShell().deferFlushing();
                NSEvent nsEvent = new NSEvent(theEvent);
                boolean handled = false;
                double deltaY = nsEvent.deltaY();
                double deltaX = nsEvent.deltaX();
                if ((this.hooks(48) || this.filters(48)) && !this.gestureEvent(id2, theEvent, 64)) {
                    handled = true;
                }
                if (!handled) {
                    Event event;
                    int selection;
                    ScrollBar bar;
                    boolean doit;
                    if (deltaY != 0.0) {
                        doit = true;
                        if (this.hooks(37) || this.filters(37)) {
                            doit = this.sendMouseEvent(nsEvent, 37, true);
                        }
                        bar = this.verticalBar;
                        if (doit && bar != null && bar.getEnabled()) {
                            if (-1.0 < deltaY && deltaY < 0.0) {
                                deltaY = -1.0;
                            }
                            if (0.0 < deltaY && deltaY < 1.0) {
                                deltaY = 1.0;
                            }
                            selection = Math.max(0, (int)((double)(0.5f + (float)bar.getSelection()) - (double)bar.getIncrement() * deltaY));
                            bar.setSelection(selection);
                            event = new Event();
                            event.detail = deltaY > 0.0 ? 0x1000005 : 0x1000006;
                            bar.sendSelectionEvent(13, event, true);
                            handled = true;
                        }
                        if (!doit) {
                            handled = true;
                        }
                    }
                    if (deltaX != 0.0) {
                        doit = true;
                        if (this.hooks(38) || this.filters(38)) {
                            doit = this.sendMouseEvent(nsEvent, 38, true);
                        }
                        bar = this.horizontalBar;
                        if (doit && bar != null && bar.getEnabled()) {
                            if (-1.0 < deltaX && deltaX < 0.0) {
                                deltaX = -1.0;
                            }
                            if (0.0 < deltaX && deltaX < 1.0) {
                                deltaX = 1.0;
                            }
                            selection = Math.max(0, (int)((double)(0.5f + (float)bar.getSelection()) - (double)bar.getIncrement() * deltaX));
                            bar.setSelection(selection);
                            event = new Event();
                            event.detail = deltaX > 0.0 ? 0x1000005 : 0x1000006;
                            bar.sendSelectionEvent(13, event, true);
                            handled = true;
                        }
                        if (!doit) {
                            handled = true;
                        }
                    }
                    if (!handled) {
                        view.superview().scrollWheel(nsEvent);
                    }
                }
                return;
            }
            this.callSuper(id2, sel, theEvent);
            return;
        }
        super.scrollWheel(id2, sel, theEvent);
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].updateBackgroundMode();
        }
    }

    @Override
    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    @Override
    void setIsStyledText() {
        this.isStyledText = true;
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        this.checkWidget();
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x4000) != 0 || (this.state & 0x1000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    @Override
    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean changed = super.setScrollBarVisible(bar, visible);
        if (changed && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return changed;
    }

    @Override
    boolean setTabGroupFocus() {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (takeFocus && this.setTabItemFocus()) {
            return true;
        }
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    @Override
    int traversalCode(int key, NSEvent theEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, theEvent);
    }

    @Override
    void updateBackgroundColor() {
        super.updateBackgroundColor();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            if ((children[i].state & 0x400) == 0) continue;
            children[i].updateBackgroundColor();
        }
    }

    @Override
    void updateBackgroundImage() {
        super.updateBackgroundImage();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            if ((children[i].state & 0x400) == 0) continue;
            children[i].updateBackgroundImage();
        }
    }

    @Override
    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].updateBackgroundMode();
        }
    }

    @Override
    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            control.updateCursorRects(enabled && control.isEnabled());
        }
    }

    @Override
    void updateLayout(boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x4000;
            return;
        }
        if ((this.state & 0x1000) != 0) {
            boolean changed = (this.state & 0x2000) != 0;
            this.state &= 0xFFFFCFFF;
            this.display.runSkin();
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFFFBFFF;
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].updateLayout(all);
            }
        }
    }
}

