//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowrestoration?language=objc)
    pub unsafe trait NSWindowRestoration: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(
            feature = "NSResponder",
            feature = "NSUserInterfaceItemIdentification",
            feature = "NSWindow",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `state` possibly has further requirements.
        #[unsafe(method(restoreWindowWithIdentifier:state:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn restoreWindowWithIdentifier_state_completionHandler(
            identifier: &NSUserInterfaceItemIdentifier,
            state: &NSCoder,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSWindow, *mut NSError)>,
            mtm: MainThreadMarker,
        );
    }
);

/// NSWindowRestoration.
#[cfg(feature = "NSDocumentController")]
impl NSDocumentController {
    extern_methods!();
}

#[cfg(feature = "NSDocumentController")]
extern_conformance!(
    unsafe impl NSWindowRestoration for NSDocumentController {}
);

/// NSWindowRestoration.
#[cfg(all(feature = "NSApplication", feature = "NSResponder"))]
impl NSApplication {
    extern_methods!(
        #[cfg(all(
            feature = "NSUserInterfaceItemIdentification",
            feature = "NSWindow",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `state` possibly has further requirements.
        #[unsafe(method(restoreWindowWithIdentifier:state:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoreWindowWithIdentifier_state_completionHandler(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
            state: &NSCoder,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSWindow, *mut NSError)>,
        ) -> bool;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationdidfinishrestoringwindowsnotification?language=objc)
    pub static NSApplicationDidFinishRestoringWindowsNotification: &'static NSNotificationName;
}

/// NSUserInterfaceRestoration.
#[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
impl NSWindow {
    extern_methods!(
        #[unsafe(method(isRestorable))]
        #[unsafe(method_family = none)]
        pub fn isRestorable(&self) -> bool;

        /// Setter for [`isRestorable`][Self::isRestorable].
        #[unsafe(method(setRestorable:))]
        #[unsafe(method_family = none)]
        pub fn setRestorable(&self, restorable: bool);

        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(restorationClass))]
        #[unsafe(method_family = none)]
        pub unsafe fn restorationClass(&self) -> Option<&'static AnyClass>;

        /// Setter for [`restorationClass`][Self::restorationClass].
        ///
        /// # Safety
        ///
        /// - `restoration_class` must implement NSWindowRestoration.
        /// - This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setRestorationClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRestorationClass(&self, restoration_class: Option<&AnyClass>);

        #[unsafe(method(disableSnapshotRestoration))]
        #[unsafe(method_family = none)]
        pub fn disableSnapshotRestoration(&self);

        #[unsafe(method(enableSnapshotRestoration))]
        #[unsafe(method_family = none)]
        pub fn enableSnapshotRestoration(&self);
    );
}

/// NSRestorableState.
#[cfg(feature = "NSResponder")]
impl NSResponder {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(encodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeRestorableStateWithCoder(&self, coder: &NSCoder);

        /// # Safety
        ///
        /// - `coder` possibly has further requirements.
        /// - `queue` possibly has additional threading requirements.
        #[unsafe(method(encodeRestorableStateWithCoder:backgroundQueue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeRestorableStateWithCoder_backgroundQueue(
            &self,
            coder: &NSCoder,
            queue: &NSOperationQueue,
        );

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(restoreStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoreStateWithCoder(&self, coder: &NSCoder);

        #[unsafe(method(invalidateRestorableState))]
        #[unsafe(method_family = none)]
        pub fn invalidateRestorableState(&self);

        #[unsafe(method(restorableStateKeyPaths))]
        #[unsafe(method_family = none)]
        pub fn restorableStateKeyPaths(mtm: MainThreadMarker) -> Retained<NSArray<NSString>>;

        /// When secure state restoration is used, values at restorableStateKeyPaths must support NSSecureCoding and this method will be consulted when restoring state. Any values not of an allowed class will not be set.
        #[unsafe(method(allowedClassesForRestorableStateKeyPath:))]
        #[unsafe(method_family = none)]
        pub fn allowedClassesForRestorableStateKeyPath(
            key_path: &NSString,
            mtm: MainThreadMarker,
        ) -> Retained<NSArray<AnyClass>>;
    );
}

/// NSRestorableStateExtension.
#[cfg(all(feature = "NSApplication", feature = "NSResponder"))]
impl NSApplication {
    extern_methods!(
        #[unsafe(method(extendStateRestoration))]
        #[unsafe(method_family = none)]
        pub fn extendStateRestoration(&self);

        #[unsafe(method(completeStateRestoration))]
        #[unsafe(method_family = none)]
        pub fn completeStateRestoration(&self);
    );
}

/// NSRestorableState.
#[cfg(feature = "NSDocument")]
impl NSDocument {
    extern_methods!(
        #[cfg(all(
            feature = "NSResponder",
            feature = "NSUserInterfaceItemIdentification",
            feature = "NSWindow",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `state` possibly has further requirements.
        #[unsafe(method(restoreDocumentWindowWithIdentifier:state:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoreDocumentWindowWithIdentifier_state_completionHandler(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
            state: &NSCoder,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSWindow, *mut NSError)>,
        );

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(encodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeRestorableStateWithCoder(&self, coder: &NSCoder);

        /// # Safety
        ///
        /// - `coder` possibly has further requirements.
        /// - `queue` possibly has additional threading requirements.
        #[unsafe(method(encodeRestorableStateWithCoder:backgroundQueue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeRestorableStateWithCoder_backgroundQueue(
            &self,
            coder: &NSCoder,
            queue: &NSOperationQueue,
        );

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(restoreStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoreStateWithCoder(&self, coder: &NSCoder);

        #[unsafe(method(invalidateRestorableState))]
        #[unsafe(method_family = none)]
        pub fn invalidateRestorableState(&self);

        #[unsafe(method(restorableStateKeyPaths))]
        #[unsafe(method_family = none)]
        pub fn restorableStateKeyPaths(mtm: MainThreadMarker) -> Retained<NSArray<NSString>>;

        #[unsafe(method(allowedClassesForRestorableStateKeyPath:))]
        #[unsafe(method_family = none)]
        pub fn allowedClassesForRestorableStateKeyPath(
            key_path: &NSString,
            mtm: MainThreadMarker,
        ) -> Retained<NSArray<AnyClass>>;
    );
}
