#ifndef H_CDW_DLL
#define H_CDW_DLL

#include <stdbool.h>
#include <stddef.h> /* size_t */

#include "main.h"

typedef struct cdw_dll_item cdw_dll_item_t;
typedef struct cdw_dll_item cdw_dll_t;
struct cdw_dll_item {
	cdw_dll_item_t *prev;
	cdw_dll_item_t *next;
	void *data;
};


cdw_rv_t cdw_dll_append(cdw_dll_item_t **head, void *data, bool (*pred)(const void *, const void *)); /* tested */
cdw_rv_t cdw_dll_append_non_unique(cdw_dll_item_t **head, void *data); /* tested indirectly */
cdw_rv_t cdw_dll_init(cdw_dll_item_t **head, void *data); /* tested */
cdw_dll_item_t *cdw_dll_last_item(cdw_dll_item_t *head); /* tested */
cdw_dll_item_t *cdw_dll_new_item(void *data); /* tested */
cdw_dll_item_t *cdw_dll_ith_item(cdw_dll_item_t *head, size_t i); /* tested */
cdw_rv_t cdw_dll_remove_ith_item(cdw_dll_item_t **head, size_t i); /* partially tested */
size_t cdw_dll_length(cdw_dll_item_t *head); /* tested */
bool cdw_dll_is_empty(cdw_dll_item_t *head); /* partially tested */
bool cdw_dll_is_member(cdw_dll_item_t const * head, void const * data, bool (*pred)(void const *, void const *)); /* tested */
cdw_rv_t cdw_dll_clean(cdw_dll_item_t *head);
cdw_rv_t cdw_dll_delete(cdw_dll_t **head, cdw_deallocator_t dealloc);


/* unit tests */
void cdw_dll_run_tests(void);

#endif /* H_CDW_DLL */
