/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsState;
import org.gradle.initialization.buildsrc.BuildSrcDetector;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.Path;

public class DefaultSettingsLoader
implements SettingsLoader {
    public static final String BUILD_SRC_PROJECT_PATH = ":buildSrc";
    private final SettingsProcessor settingsProcessor;
    private final BuildLayoutFactory buildLayoutFactory;
    private final List<BuiltInCommand> builtInCommands;
    private final Logger logger;

    public DefaultSettingsLoader(SettingsProcessor settingsProcessor, BuildLayoutFactory buildLayoutFactory, List<BuiltInCommand> builtInCommands) {
        this(settingsProcessor, buildLayoutFactory, builtInCommands, Logging.getLogger(DefaultSettingsLoader.class));
    }

    @VisibleForTesting
    DefaultSettingsLoader(SettingsProcessor settingsProcessor, BuildLayoutFactory buildLayoutFactory, List<BuiltInCommand> builtInCommands, Logger logger) {
        this.settingsProcessor = settingsProcessor;
        this.buildLayoutFactory = buildLayoutFactory;
        this.builtInCommands = builtInCommands;
        this.logger = logger;
    }

    @Override
    public SettingsState findAndLoadSettings(GradleInternal gradle) {
        ProjectSpec spec;
        SettingsState state;
        StartParameterInternal startParameter = gradle.getStartParameter();
        BuildLayout settingsLocation = this.buildLayoutFactory.getLayoutFor(new BuildLayoutConfiguration(startParameter));
        if (this.shouldSkipLoadingBuildDefinition(startParameter)) {
            this.logger.debug("Skipping loading of build definition for build: '{}'", (Object)gradle.getIdentityPath());
            state = this.createEmptySettings(gradle, startParameter, gradle.getClassLoaderScope());
            spec = ProjectSpecs.forStartParameter(startParameter, state.getSettings());
        } else {
            this.logger.debug("Loading build definition for build: '{}'", (Object)gradle.getIdentityPath());
            state = this.findSettingsAndLoadIfAppropriate(gradle, startParameter, settingsLocation, gradle.getClassLoaderScope());
            SettingsInternal settings = state.getSettings();
            spec = ProjectSpecs.forStartParameter(startParameter, settings);
            if (this.useEmptySettings(spec, settings, startParameter)) {
                this.logger.debug("Discarding loaded settings and replacing with empty settings for build: '{}'", (Object)gradle.getIdentityPath());
                state.close();
                state = this.createEmptySettings(gradle, startParameter, settings.getClassLoaderScope());
            }
        }
        this.setDefaultProject(spec, state.getSettings());
        return state;
    }

    private boolean shouldSkipLoadingBuildDefinition(StartParameter startParameter) {
        for (BuiltInCommand command : this.builtInCommands) {
            if (!command.requireEmptyBuildDefinition() || !command.wasInvoked(startParameter)) continue;
            return true;
        }
        return false;
    }

    private boolean useEmptySettings(ProjectSpec spec, SettingsInternal loadedSettings, StartParameter startParameter) {
        File customSettingsFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameter)startParameter).getSettingsFile());
        if (customSettingsFile != null) {
            return false;
        }
        if (spec.containsProject(loadedSettings.getProjectRegistry())) {
            return false;
        }
        for (BuiltInCommand command : this.builtInCommands) {
            if (!command.wasInvoked(startParameter)) continue;
            return true;
        }
        if (startParameter.getProjectDir() != null && startParameter.getProjectDir().getName().equals("buildSrc") && BuildSrcDetector.isValidBuildSrcBuild(startParameter.getProjectDir())) {
            return true;
        }
        return startParameter.getProjectDir() != null && loadedSettings.getSettingsDir().equals(startParameter.getProjectDir());
    }

    private SettingsState createEmptySettings(GradleInternal gradle, StartParameter startParameter, ClassLoaderScope classLoaderScope) {
        this.logger.debug("Creating empty settings for build: '{}'", (Object)gradle.getIdentityPath());
        StartParameterInternal noSearchParameter = (StartParameterInternal)startParameter.newInstance();
        DeprecationLogger.whileDisabled(() -> noSearchParameter.setSettingsFile(null));
        noSearchParameter.useEmptySettings();
        noSearchParameter.doNotSearchUpwards();
        BuildLayout layout = this.buildLayoutFactory.getLayoutFor(new BuildLayoutConfiguration(noSearchParameter));
        SettingsState state = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter, layout, classLoaderScope);
        File customBuildFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameterInternal)noSearchParameter).getBuildFile());
        if (customBuildFile != null) {
            ProjectDescriptor rootProject = state.getSettings().getRootProject();
            rootProject.setBuildFileName(customBuildFile.getName());
        }
        return state;
    }

    private void setDefaultProject(ProjectSpec spec, SettingsInternal settings) {
        settings.setDefaultProject(spec.selectProject(settings.getSettingsScript().getDisplayName(), settings.getProjectRegistry()));
    }

    private SettingsState findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter, SettingsLocation settingsLocation, ClassLoaderScope classLoaderScope) {
        SettingsState state = this.settingsProcessor.process(gradle, settingsLocation, classLoaderScope, startParameter);
        this.validate(state.getSettings());
        return state;
    }

    private void validate(SettingsInternal settings) {
        settings.getProjectRegistry().getAllProjects().forEach(project -> {
            if (project.getPath().equals(BUILD_SRC_PROJECT_PATH)) {
                Path buildPath = settings.getGradle().getIdentityPath();
                String suffix = buildPath == Path.ROOT ? "" : " (in build " + buildPath + ")";
                throw new GradleException("'buildSrc' cannot be used as a project name as it is a reserved name" + suffix);
            }
            if (!(project.getProjectDir().exists() && project.getProjectDir().isDirectory() && project.getProjectDir().canWrite())) {
                DefaultSettingsLoader.emitProjectDirectoryMissingWarning(project.getPath(), project.getProjectDir().toString());
            }
        });
    }

    private static void emitProjectDirectoryMissingWarning(String projectPath, String projectDir) {
        String template = "Configuring project '%s' without an existing directory is deprecated. The configured projectDirectory '%s' does not exist, can't be written to or is not a directory.";
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format(template, projectPath, projectDir)).withAdvice("Make sure the project directory exists and can be written.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "deprecated_missing_project_directory")).nagUser();
    }
}

