/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.logging;

import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.CryptoUtil;
import org.signal.core.util.Hex;
import org.signal.core.util.StringExtensionsKt;
import org.signal.core.util.logging.Scrubber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0007J\f\u0010)\u001a\u00020'*\u00020'H\u0002J\f\u0010*\u001a\u00020'*\u00020'H\u0002J\f\u0010+\u001a\u00020'*\u00020'H\u0002J\f\u0010,\u001a\u00020'*\u00020'H\u0002J\f\u0010-\u001a\u00020'*\u00020'H\u0002J\f\u0010.\u001a\u00020'*\u00020'H\u0002J\f\u0010/\u001a\u00020'*\u00020'H\u0002J\f\u00100\u001a\u00020'*\u00020'H\u0002J\f\u00101\u001a\u00020'*\u00020'H\u0002J\f\u00102\u001a\u00020'*\u00020'H\u0002J\f\u00103\u001a\u00020'*\u00020'H\u0002J\f\u00104\u001a\u00020'*\u00020'H\u0002J\u001c\u00105\u001a\u00020\u000b*\u00020\u000b2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0002J:\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u00109\u001a\u00020\u00052 \u0010:\u001a\u001c\u0012\u0004\u0012\u00020<\u0012\b\u0012\u00060=j\u0002`>\u0012\u0004\u0012\u00020?0;j\u0002`@H\u0002J\u0010\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000bH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\r\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\u000e\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\u0011\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R,\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b%\u0010\u0003\u00a8\u0006C"}, d2={"Lorg/signal/core/util/logging/Scrubber;", "", "<init>", "()V", "E164_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "E164_ZERO_PATTERN", "CRUDE_EMAIL_PATTERN", "EMAIL_CENSOR", "", "GROUP_ID_V1_PATTERN", "GROUP_ID_V2_PATTERN", "UUID_PATTERN", "UUID_CENSOR", "PNI_PATTERN", "IPV4_PATTERN", "IPV4_CENSOR", "IPV6_PATTERN", "IPV6_CENSOR", "URL_PATTERN", "URL_CENSOR", "TOP_100_TLDS", "", "CALL_LINK_PATTERN", "CALL_LINK_CENSOR_SUFFIX", "CALL_LINK_ROOM_ID_PATTERN", "identifierHmacKeyProvider", "Lkotlin/Function0;", "", "getIdentifierHmacKeyProvider$annotations", "getIdentifierHmacKeyProvider", "()Lkotlin/jvm/functions/Function0;", "setIdentifierHmacKeyProvider", "(Lkotlin/jvm/functions/Function0;)V", "identifierHmacKey", "getIdentifierHmacKey$annotations", "scrub", "", "input", "scrubE164", "scrubE164Zero", "scrubEmail", "scrubGroupsV1", "scrubGroupsV2", "scrubPnis", "scrubUuids", "scrubUrls", "scrubIpv4", "scrubIpv6", "scrubCallLinkKeys", "scrubCallLinkRoomIds", "censorMiddle", "leading", "", "trailing", "pattern", "processMatch", "Lkotlin/Function2;", "Ljava/util/regex/Matcher;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "Lorg/signal/core/util/logging/MatchProcessor;", "hash", "value", "core-util-jvm"})
public final class Scrubber {
    @NotNull
    public static final Scrubber INSTANCE = new Scrubber();
    private static final Pattern E164_PATTERN = Pattern.compile("(KEEP_E164::)?(\\+|%2B)(\\d{7,15})");
    private static final Pattern E164_ZERO_PATTERN = Pattern.compile("\\b(KEEP_E164::)?0(\\d{10})\\b");
    private static final Pattern CRUDE_EMAIL_PATTERN = Pattern.compile("\\b([^\\s/,()])([^\\s/,()]*@[^\\s]+\\.[^\\s]+)");
    @NotNull
    private static final String EMAIL_CENSOR = "...@...";
    private static final Pattern GROUP_ID_V1_PATTERN = Pattern.compile("(__textsecure_group__!)([^\\s]+)([^\\s]{3})");
    private static final Pattern GROUP_ID_V2_PATTERN = Pattern.compile("(__signal_group__v2__!)([^\\s]+)([^\\s]{3})");
    private static final Pattern UUID_PATTERN = Pattern.compile("(JOB::)?([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{9})([0-9a-f]{3})", 2);
    @NotNull
    private static final String UUID_CENSOR = "********-****-****-****-*********";
    private static final Pattern PNI_PATTERN = Pattern.compile("PNI:([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{9}[0-9a-f]{3})", 2);
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");
    @NotNull
    private static final String IPV4_CENSOR = "...ipv4...";
    private static final Pattern IPV6_PATTERN = Pattern.compile("([0-9a-fA-F]{0,4}:){3,7}([0-9a-fA-F]){0,4}");
    @NotNull
    private static final String IPV6_CENSOR = "...ipv6...";
    private static final Pattern URL_PATTERN = Pattern.compile("([a-z0-9]+\\.)+([a-z0-9\\-]*[a-z\\-][a-z0-9\\-]*)(/[/a-z0-9\\-_.~:@?&=#%+\\[\\]!$()*,;]*)?", 2);
    @NotNull
    private static final String URL_CENSOR = "***";
    @NotNull
    private static final Set<String> TOP_100_TLDS;
    private static final Pattern CALL_LINK_PATTERN;
    @NotNull
    private static final String CALL_LINK_CENSOR_SUFFIX = "-XXXX-XXXX-XXXX-XXXX-XXXX-XXXX-XXXX";
    private static final Pattern CALL_LINK_ROOM_ID_PATTERN;
    @NotNull
    private static volatile Function0<byte[]> identifierHmacKeyProvider;
    @Nullable
    private static volatile byte[] identifierHmacKey;

    private Scrubber() {
    }

    @NotNull
    public static final Function0<byte[]> getIdentifierHmacKeyProvider() {
        return identifierHmacKeyProvider;
    }

    public static final void setIdentifierHmacKeyProvider(@NotNull Function0<byte[]> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        identifierHmacKeyProvider = function0;
    }

    @JvmStatic
    public static /* synthetic */ void getIdentifierHmacKeyProvider$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void getIdentifierHmacKey$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final CharSequence scrub(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return INSTANCE.scrubCallLinkRoomIds(INSTANCE.scrubCallLinkKeys(INSTANCE.scrubIpv6(INSTANCE.scrubIpv4(INSTANCE.scrubUrls(INSTANCE.scrubUuids(INSTANCE.scrubPnis(INSTANCE.scrubGroupsV2(INSTANCE.scrubGroupsV1(INSTANCE.scrubEmail(INSTANCE.scrubE164Zero(INSTANCE.scrubE164(input))))))))))));
    }

    private final CharSequence scrubE164(CharSequence $this$scrubE164) {
        Pattern pattern = E164_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"E164_PATTERN");
        return this.scrub($this$scrubE164, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubE164$lambda$0));
    }

    private final CharSequence scrubE164Zero(CharSequence $this$scrubE164Zero) {
        Pattern pattern = E164_ZERO_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"E164_ZERO_PATTERN");
        return this.scrub($this$scrubE164Zero, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubE164Zero$lambda$1));
    }

    private final CharSequence scrubEmail(CharSequence $this$scrubEmail) {
        Pattern pattern = CRUDE_EMAIL_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"CRUDE_EMAIL_PATTERN");
        return this.scrub($this$scrubEmail, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubEmail$lambda$2));
    }

    private final CharSequence scrubGroupsV1(CharSequence $this$scrubGroupsV1) {
        Pattern pattern = GROUP_ID_V1_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GROUP_ID_V1_PATTERN");
        return this.scrub($this$scrubGroupsV1, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubGroupsV1$lambda$3));
    }

    private final CharSequence scrubGroupsV2(CharSequence $this$scrubGroupsV2) {
        Pattern pattern = GROUP_ID_V2_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GROUP_ID_V2_PATTERN");
        return this.scrub($this$scrubGroupsV2, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubGroupsV2$lambda$4));
    }

    private final CharSequence scrubPnis(CharSequence $this$scrubPnis) {
        Pattern pattern = PNI_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"PNI_PATTERN");
        return this.scrub($this$scrubPnis, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubPnis$lambda$5));
    }

    private final CharSequence scrubUuids(CharSequence $this$scrubUuids) {
        Pattern pattern = UUID_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"UUID_PATTERN");
        return this.scrub($this$scrubUuids, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubUuids$lambda$6));
    }

    private final CharSequence scrubUrls(CharSequence $this$scrubUrls) {
        Pattern pattern = URL_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"URL_PATTERN");
        return this.scrub($this$scrubUrls, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubUrls$lambda$8));
    }

    private final CharSequence scrubIpv4(CharSequence $this$scrubIpv4) {
        Pattern pattern = IPV4_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"IPV4_PATTERN");
        return this.scrub($this$scrubIpv4, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubIpv4$lambda$9));
    }

    private final CharSequence scrubIpv6(CharSequence $this$scrubIpv6) {
        Pattern pattern = IPV6_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"IPV6_PATTERN");
        return this.scrub($this$scrubIpv6, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubIpv6$lambda$10));
    }

    private final CharSequence scrubCallLinkKeys(CharSequence $this$scrubCallLinkKeys) {
        Pattern pattern = CALL_LINK_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"CALL_LINK_PATTERN");
        return this.scrub($this$scrubCallLinkKeys, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubCallLinkKeys$lambda$11));
    }

    private final CharSequence scrubCallLinkRoomIds(CharSequence $this$scrubCallLinkRoomIds) {
        Pattern pattern = CALL_LINK_ROOM_ID_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"CALL_LINK_ROOM_ID_PATTERN");
        return this.scrub($this$scrubCallLinkRoomIds, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)Scrubber::scrubCallLinkRoomIds$lambda$12));
    }

    private final String censorMiddle(String $this$censorMiddle, int leading, int trailing) {
        int totalKept = leading + trailing;
        if ($this$censorMiddle.length() < totalKept) {
            return StringsKt.repeat((CharSequence)"*", (int)$this$censorMiddle.length());
        }
        String middle = StringsKt.repeat((CharSequence)"*", (int)($this$censorMiddle.length() - totalKept));
        return StringsKt.take((String)$this$censorMiddle, (int)leading) + middle + StringsKt.takeLast((String)$this$censorMiddle, (int)trailing);
    }

    private final CharSequence scrub(CharSequence input, Pattern pattern, Function2<? super Matcher, ? super StringBuilder, Unit> processMatch) {
        CharSequence charSequence;
        StringBuilder output = new StringBuilder(input.length());
        Matcher matcher = pattern.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        int lastEndingPos = 0;
        while (matcher2.find()) {
            output.append(input, lastEndingPos, matcher2.start());
            processMatch.invoke((Object)matcher2, (Object)output);
            lastEndingPos = matcher2.end();
        }
        if (lastEndingPos == 0) {
            charSequence = input;
        } else {
            output.append(input, lastEndingPos, input.length());
            charSequence = output;
        }
        return charSequence;
    }

    private final String hash(String value) {
        if (identifierHmacKey == null) {
            identifierHmacKey = (byte[])identifierHmacKeyProvider.invoke();
        }
        if (identifierHmacKey == null) {
            return "<redacted>";
        }
        byte[] key = identifierHmacKey;
        String string = value;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hash = CryptoUtil.hmacSha256(key, byArray);
        String string2 = Hex.toStringCondensed(hash);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toStringCondensed(...)");
        return "<" + StringsKt.take((String)string2, (int)5) + ">";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Unit scrubE164$lambda$0(Matcher matcher, StringBuilder output) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (matcher.group(1) != null) {
            String string = matcher.group(1);
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                stringBuilder = output.append("KEEP_E164::").append(INSTANCE.censorMiddle(matcher.group(2) + matcher.group(3), 2, 2));
                return Unit.INSTANCE;
            }
        }
        StringBuilder stringBuilder2 = output.append("E164:");
        String string = matcher.group(3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        stringBuilder = stringBuilder2.append(INSTANCE.hash(string));
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Unit scrubE164Zero$lambda$1(Matcher matcher, StringBuilder output) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (matcher.group(1) != null) {
            String string = matcher.group(1);
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                stringBuilder = output.append("KEEP_E164::").append(INSTANCE.censorMiddle("0" + matcher.group(2), 2, 2));
                return Unit.INSTANCE;
            }
        }
        StringBuilder stringBuilder2 = output.append("E164:");
        String string = matcher.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        stringBuilder = stringBuilder2.append(INSTANCE.hash(string));
        return Unit.INSTANCE;
    }

    private static final Unit scrubEmail$lambda$2(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.append(matcher.group(1)).append(EMAIL_CENSOR);
        return Unit.INSTANCE;
    }

    private static final Unit scrubGroupsV1$lambda$3(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.append("GV1::***").append(matcher.group(3));
        return Unit.INSTANCE;
    }

    private static final Unit scrubGroupsV2$lambda$4(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.append("GV2::***").append(matcher.group(3));
        return Unit.INSTANCE;
    }

    private static final Unit scrubPnis$lambda$5(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        StringBuilder stringBuilder = output.append("PNI:");
        String string = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        stringBuilder.append(INSTANCE.hash(string));
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Unit scrubUuids$lambda$6(Matcher matcher, StringBuilder output) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (matcher.group(1) != null) {
            String string = matcher.group(1);
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                stringBuilder = output.append(matcher.group(1)).append(matcher.group(2)).append(matcher.group(3));
                return Unit.INSTANCE;
            }
        }
        stringBuilder = output.append(UUID_CENSOR).append(matcher.group(3));
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Unit scrubUrls$lambda$8(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String string = matcher.group(0);
        Intrinsics.checkNotNull((Object)string);
        String match = string;
        if (matcher.groupCount() == 2 || matcher.groupCount() == 3) {
            String string2 = matcher.group(2);
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (TOP_100_TLDS.contains(string3)) {
                String string4 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
                if (!StringsKt.endsWith$default((String)string4, (String)"signal.", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)matcher.group(2), (Object)"org") || StringsKt.contains$default((CharSequence)match, (CharSequence)"cdn", (boolean)false, (int)2, null)) {
                    String string5 = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"group(...)");
                    if (!StringsKt.endsWith$default((String)string5, (String)"debuglogs.", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)matcher.group(2), (Object)"org")) {
                        StringBuilder $this$scrubUrls_u24lambda_u248_u24lambda_u247 = output.append(URL_CENSOR).append(".").append(matcher.group(2));
                        boolean bl = false;
                        if (matcher.groupCount() != 3) return Unit.INSTANCE;
                        if (!StringExtensionsKt.isNotNullOrBlank(matcher.group(3))) return Unit.INSTANCE;
                        $this$scrubUrls_u24lambda_u248_u24lambda_u247.append("/");
                        $this$scrubUrls_u24lambda_u248_u24lambda_u247.append(URL_CENSOR);
                        return Unit.INSTANCE;
                    }
                }
            }
        }
        output.append(match);
        return Unit.INSTANCE;
    }

    private static final Unit scrubIpv4$lambda$9(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.append(IPV4_CENSOR);
        return Unit.INSTANCE;
    }

    private static final Unit scrubIpv6$lambda$10(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.append(IPV6_CENSOR);
        return Unit.INSTANCE;
    }

    private static final Unit scrubCallLinkKeys$lambda$11(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String match = matcher.group(1);
        output.append(match).append(CALL_LINK_CENSOR_SUFFIX);
        return Unit.INSTANCE;
    }

    private static final Unit scrubCallLinkRoomIds$lambda$12(Matcher matcher, StringBuilder output) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.append(matcher.group(1)).append("*************************************************************").append(matcher.group(3));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"com", "net", "org", "jp", "de", "uk", "fr", "br", "it", "ru", "es", "me", "gov", "pl", "ca", "au", "cn", "co", "in", "nl", "edu", "info", "eu", "ch", "id", "at", "kr", "cz", "mx", "be", "tv", "se", "tr", "tw", "al", "ua", "ir", "vn", "cl", "sk", "ly", "cc", "to", "no", "fi", "us", "pt", "dk", "ar", "hu", "tk", "gr", "il", "news", "ro", "my", "biz", "ie", "za", "nz", "sg", "ee", "th", "io", "xyz", "pe", "bg", "hk", "lt", "link", "ph", "club", "si", "site", "mobi", "by", "cat", "wiki", "la", "ga", "xxx", "cf", "hr", "ng", "jobs", "online", "kz", "ug", "gq", "ae", "is", "lv", "pro", "fm", "tips", "ms", "sa", "app"};
        TOP_100_TLDS = SetsKt.setOf((Object[])objectArray);
        CALL_LINK_PATTERN = Pattern.compile("([bBcCdDfFgGhHkKmMnNpPqQrRsStTxXzZ]{4})(-[bBcCdDfFgGhHkKmMnNpPqQrRsStTxXzZ]{4}){7}");
        CALL_LINK_ROOM_ID_PATTERN = Pattern.compile("([^/])([0-9a-f]{61})([0-9a-f]{3})");
        identifierHmacKeyProvider = identifierHmacKeyProvider.1.INSTANCE;
    }
}

