/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.actions;

import java.util.Objects;
import org.asamk.signal.manager.actions.HandleAction;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.sendLog.MessageSendLogEntry;

public class ResendMessageAction
implements HandleAction {
    private final RecipientId recipientId;
    private final long timestamp;
    private final MessageSendLogEntry messageSendLogEntry;

    public ResendMessageAction(RecipientId recipientId, long timestamp, MessageSendLogEntry messageSendLogEntry) {
        this.recipientId = recipientId;
        this.timestamp = timestamp;
        this.messageSendLogEntry = messageSendLogEntry;
    }

    @Override
    public void execute(Context context) throws Throwable {
        context.getSendHelper().resendMessage(this.recipientId, this.timestamp, this.messageSendLogEntry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResendMessageAction that = (ResendMessageAction)o;
        return this.timestamp == that.timestamp && this.recipientId.equals(that.recipientId) && this.messageSendLogEntry.equals(that.messageSendLogEntry);
    }

    public int hashCode() {
        return Objects.hash(this.recipientId, this.timestamp, this.messageSendLogEntry);
    }
}

