/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.configuration.ConfigurationStore;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.stickers.StickerPack;
import org.asamk.signal.manager.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.protocol.IdentityKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.messages.SendMessageResult;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.messages.SignalServiceReceiptMessage;
import org.whispersystems.signalservice.api.messages.multidevice.BlockedListMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ConfigurationMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ContactsMessage;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContact;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContactAvatar;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContactsInputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContactsOutputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceGroup;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceGroupsInputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceGroupsOutputStream;
import org.whispersystems.signalservice.api.messages.multidevice.KeysMessage;
import org.whispersystems.signalservice.api.messages.multidevice.MessageRequestResponseMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ReadMessage;
import org.whispersystems.signalservice.api.messages.multidevice.RequestMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SignalServiceSyncMessage;
import org.whispersystems.signalservice.api.messages.multidevice.StickerPackOperationMessage;
import org.whispersystems.signalservice.api.messages.multidevice.VerifiedMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ViewedMessage;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.util.StreamDetails;
import org.whispersystems.signalservice.internal.push.SyncMessage;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;

public class SyncHelper {
    private static final Logger logger = LoggerFactory.getLogger(SyncHelper.class);
    private final Context context;
    private final SignalAccount account;

    public SyncHelper(Context context) {
        this.context = context;
        this.account = context.getAccount();
    }

    public void requestAllSyncData() {
        this.requestSyncData(SyncMessage.Request.Type.GROUPS);
        this.requestSyncData(SyncMessage.Request.Type.CONTACTS);
        this.requestSyncData(SyncMessage.Request.Type.BLOCKED);
        this.requestSyncData(SyncMessage.Request.Type.CONFIGURATION);
        this.requestSyncKeys();
    }

    public void requestSyncKeys() {
        this.requestSyncData(SyncMessage.Request.Type.KEYS);
    }

    public SendMessageResult sendSyncFetchProfileMessage() {
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forFetchLatest((SignalServiceSyncMessage.FetchType)SignalServiceSyncMessage.FetchType.LOCAL_PROFILE));
    }

    public void sendSyncFetchStorageMessage() {
        this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forFetchLatest((SignalServiceSyncMessage.FetchType)SignalServiceSyncMessage.FetchType.STORAGE_MANIFEST));
    }

    public void sendSyncReceiptMessage(ServiceId sender, SignalServiceReceiptMessage receiptMessage) {
        if (receiptMessage.isReadReceipt()) {
            List<ReadMessage> readMessages = receiptMessage.getTimestamps().stream().map(t -> new ReadMessage(sender, t.longValue())).toList();
            this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forRead(readMessages));
        } else if (receiptMessage.isViewedReceipt()) {
            List<ViewedMessage> viewedMessages = receiptMessage.getTimestamps().stream().map(t -> new ViewedMessage(sender, t.longValue())).toList();
            this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forViewed(viewedMessages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGroups() throws IOException {
        block19: {
            File groupsFile = IOUtils.createTempFile();
            try {
                try (FileOutputStream fos = new FileOutputStream(groupsFile);){
                    DeviceGroupsOutputStream out = new DeviceGroupsOutputStream((OutputStream)fos);
                    for (GroupInfo record : this.account.getGroupStore().getGroups()) {
                        if (!(record instanceof GroupInfoV1)) continue;
                        GroupInfoV1 groupInfo = (GroupInfoV1)record;
                        out.write(new DeviceGroup(groupInfo.getGroupId().serialize(), Optional.ofNullable(groupInfo.name), groupInfo.getMembers().stream().map(this.context.getRecipientHelper()::resolveSignalServiceAddress).toList(), this.context.getGroupHelper().createGroupAvatarAttachment(groupInfo.getGroupId()), groupInfo.isMember(this.account.getSelfRecipientId()), Optional.of(groupInfo.messageExpirationTime), Optional.ofNullable(groupInfo.color), groupInfo.blocked, Optional.empty(), groupInfo.archived));
                    }
                }
                if (!groupsFile.exists() || groupsFile.length() <= 0L) break block19;
                try (FileInputStream groupsFileStream = new FileInputStream(groupsFile);){
                    ResumableUploadSpec uploadSpec = this.context.getDependencies().getMessageSender().getResumableUploadSpec();
                    SignalServiceAttachmentStream attachmentStream = SignalServiceAttachment.newStreamBuilder().withStream((InputStream)groupsFileStream).withContentType("application/octet-stream").withLength(groupsFile.length()).withResumableUploadSpec(uploadSpec).build();
                    this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forGroups((SignalServiceAttachment)attachmentStream));
                }
            }
            finally {
                try {
                    Files.delete(groupsFile.toPath());
                }
                catch (IOException e) {
                    logger.warn("Failed to delete groups temp file \u201c{}\u201d, ignoring: {}", (Object)groupsFile, (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendContacts() throws IOException {
        block20: {
            File contactsFile = IOUtils.createTempFile();
            try {
                try (FileOutputStream fos = new FileOutputStream(contactsFile);){
                    DeviceContactsOutputStream out = new DeviceContactsOutputStream((OutputStream)fos);
                    for (Pair<RecipientId, Contact> contactPair : this.account.getContactStore().getContacts()) {
                        RecipientId recipientId = contactPair.first();
                        Contact contact = contactPair.second();
                        RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId);
                        DeviceContact deviceContact = this.getDeviceContact(address, contact);
                        out.write(deviceContact);
                        deviceContact.getAvatar().ifPresent(a -> {
                            try {
                                a.getInputStream().close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                    }
                    if (this.account.getProfileKey() != null) {
                        RecipientAddress address = this.account.getSelfRecipientAddress();
                        RecipientId recipientId = this.account.getSelfRecipientId();
                        Contact contact = this.account.getContactStore().getContact(recipientId);
                        DeviceContact deviceContact = this.getDeviceContact(address, contact);
                        out.write(deviceContact);
                        deviceContact.getAvatar().ifPresent(a -> {
                            try {
                                a.getInputStream().close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                    }
                }
                if (!contactsFile.exists() || contactsFile.length() <= 0L) break block20;
                try (FileInputStream contactsFileStream = new FileInputStream(contactsFile);){
                    ResumableUploadSpec uploadSpec = this.context.getDependencies().getMessageSender().getResumableUploadSpec();
                    SignalServiceAttachmentStream attachmentStream = SignalServiceAttachment.newStreamBuilder().withStream((InputStream)contactsFileStream).withContentType("application/octet-stream").withLength(contactsFile.length()).withResumableUploadSpec(uploadSpec).build();
                    this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forContacts((ContactsMessage)new ContactsMessage((SignalServiceAttachment)attachmentStream, true)));
                }
            }
            finally {
                try {
                    Files.delete(contactsFile.toPath());
                }
                catch (IOException e) {
                    logger.warn("Failed to delete contacts temp file \u201c{}\u201d, ignoring: {}", (Object)contactsFile, (Object)e.getMessage());
                }
            }
        }
    }

    @NotNull
    private DeviceContact getDeviceContact(RecipientAddress address, Contact contact) throws IOException {
        return new DeviceContact(address.aci(), address.number(), Optional.ofNullable(contact == null ? null : contact.getName()), this.createContactAvatarAttachment(address), Optional.ofNullable(contact == null ? null : Integer.valueOf(contact.messageExpirationTime())), Optional.ofNullable(contact == null ? null : Integer.valueOf(contact.messageExpirationTimeVersion())), Optional.empty());
    }

    public SendMessageResult sendBlockedList() {
        ArrayList<BlockedListMessage.Individual> addresses = new ArrayList<BlockedListMessage.Individual>();
        for (Pair<RecipientId, Contact> record : this.account.getContactStore().getContacts()) {
            RecipientAddress address;
            if (!record.second().isBlocked() || !(address = this.account.getRecipientAddressResolver().resolveRecipientAddress(record.first())).aci().isPresent() && !address.number().isPresent()) continue;
            addresses.add(new BlockedListMessage.Individual((ServiceId.ACI)address.aci().orElse(null), (String)address.number().orElse(null)));
        }
        ArrayList<byte[]> groupIds = new ArrayList<byte[]>();
        for (GroupInfo record : this.account.getGroupStore().getGroups()) {
            if (!record.isBlocked()) continue;
            groupIds.add(record.getGroupId().serialize());
        }
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forBlocked((BlockedListMessage)new BlockedListMessage(addresses, groupIds)));
    }

    public SendMessageResult sendVerifiedMessage(SignalServiceAddress destination, IdentityKey identityKey, TrustLevel trustLevel) {
        VerifiedMessage verifiedMessage = new VerifiedMessage(destination, identityKey, trustLevel.toVerifiedState(), System.currentTimeMillis());
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forVerified((VerifiedMessage)verifiedMessage));
    }

    public SendMessageResult sendKeysMessage() {
        KeysMessage keysMessage = new KeysMessage(this.account.getOrCreateStorageKey(), this.account.getOrCreatePinMasterKey(), this.account.getOrCreateAccountEntropyPool(), this.account.getOrCreateMediaRootBackupKey());
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forKeys((KeysMessage)keysMessage));
    }

    public SendMessageResult sendStickerOperationsMessage(List<StickerPack> installStickers, List<StickerPack> removeStickers) {
        Stream<StickerPackOperationMessage> installStickerMessages = installStickers.stream().map(s -> SyncHelper.getStickerPackOperationMessage(s, true));
        Stream<StickerPackOperationMessage> removeStickerMessages = removeStickers.stream().map(s -> SyncHelper.getStickerPackOperationMessage(s, false));
        List<StickerPackOperationMessage> stickerMessages = Stream.concat(installStickerMessages, removeStickerMessages).toList();
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forStickerPackOperations(stickerMessages));
    }

    private static StickerPackOperationMessage getStickerPackOperationMessage(StickerPack s, boolean installed) {
        return new StickerPackOperationMessage(s.packId().serialize(), s.packKey(), installed ? StickerPackOperationMessage.Type.INSTALL : StickerPackOperationMessage.Type.REMOVE);
    }

    public SendMessageResult sendConfigurationMessage() {
        ConfigurationStore config = this.account.getConfigurationStore();
        ConfigurationMessage configurationMessage = new ConfigurationMessage(Optional.ofNullable(config.getReadReceipts()), Optional.ofNullable(config.getUnidentifiedDeliveryIndicators()), Optional.ofNullable(config.getTypingIndicators()), Optional.ofNullable(config.getLinkPreviews()));
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forConfiguration((ConfigurationMessage)configurationMessage));
    }

    public void handleSyncDeviceGroups(InputStream input) {
        DeviceGroupsInputStream s = new DeviceGroupsInputStream(input);
        while (true) {
            DeviceGroup g;
            try {
                g = s.read();
            }
            catch (IOException e) {
                logger.warn("Sync groups contained invalid group, ignoring: {}", (Object)e.getMessage());
                continue;
            }
            if (g == null) break;
            GroupInfoV1 syncGroup = this.account.getGroupStore().getOrCreateGroupV1(GroupId.v1(g.getId()));
            if (syncGroup == null) continue;
            if (g.getName().isPresent()) {
                syncGroup.name = (String)g.getName().get();
            }
            syncGroup.addMembers(g.getMembers().stream().map(this.account.getRecipientResolver()::resolveRecipient).collect(Collectors.toSet()));
            if (!g.isActive()) {
                syncGroup.removeMember(this.account.getSelfRecipientId());
            } else {
                syncGroup.addMembers(List.of(this.account.getSelfRecipientId()));
            }
            syncGroup.blocked = g.isBlocked();
            if (g.getColor().isPresent()) {
                syncGroup.color = (String)g.getColor().get();
            }
            if (g.getAvatar().isPresent()) {
                this.context.getGroupHelper().downloadGroupAvatar(syncGroup.getGroupId(), (SignalServiceAttachment)g.getAvatar().get());
            }
            syncGroup.archived = g.isArchived();
            this.account.getGroupStore().updateGroup(syncGroup);
        }
    }

    public void handleSyncDeviceContacts(InputStream input) throws IOException {
        DeviceContactsInputStream s = new DeviceContactsInputStream(input);
        while (true) {
            Contact.Builder builder;
            DeviceContact c;
            try {
                c = s.read();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("Missing contact address!")) {
                    logger.debug("Sync contacts contained invalid contact, ignoring: {}", (Object)e.getMessage());
                    continue;
                }
                throw e;
            }
            if (c == null || c.getAci().isEmpty() && c.getE164().isEmpty()) break;
            RecipientAddress address = new RecipientAddress(c.getAci(), Optional.empty(), c.getE164(), Optional.empty());
            RecipientId recipientId = this.account.getRecipientTrustedResolver().resolveRecipientTrusted(address);
            Contact contact = this.account.getContactStore().getContact(recipientId);
            Contact.Builder builder2 = builder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
            if (c.getName().isPresent() && (contact == null || contact.givenName() == null && contact.familyName() == null)) {
                builder.withGivenName((String)c.getName().get());
                builder.withFamilyName(null);
            }
            if (c.getExpirationTimer().isPresent()) {
                if (c.getExpirationTimerVersion().isPresent() && (contact == null || (Integer)c.getExpirationTimerVersion().get() > contact.messageExpirationTimeVersion())) {
                    builder.withMessageExpirationTime((Integer)c.getExpirationTimer().get());
                    builder.withMessageExpirationTimeVersion((Integer)c.getExpirationTimerVersion().get());
                } else {
                    logger.debug("[ContactSync] {} was synced with an old expiration timer. Ignoring. Received: {} Current: {}", new Object[]{recipientId, c.getExpirationTimerVersion(), contact == null ? 1 : contact.messageExpirationTimeVersion()});
                }
            }
            this.account.getContactStore().storeContact(recipientId, builder.build());
            if (!c.getAvatar().isPresent()) continue;
            this.storeContactAvatar((DeviceContactAvatar)c.getAvatar().get(), address);
        }
    }

    public SendMessageResult sendMessageRequestResponse(MessageEnvelope.Sync.MessageRequestResponse.Type type, GroupId groupId) {
        MessageRequestResponseMessage response = MessageRequestResponseMessage.forGroup((byte[])groupId.serialize(), (MessageRequestResponseMessage.Type)this.localToRemoteType(type));
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forMessageRequestResponse((MessageRequestResponseMessage)response));
    }

    public SendMessageResult sendMessageRequestResponse(MessageEnvelope.Sync.MessageRequestResponse.Type type, RecipientId recipientId) {
        RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId);
        if (address.serviceId().isEmpty()) {
            return null;
        }
        this.context.getContactHelper().setContactProfileSharing(recipientId, type == MessageEnvelope.Sync.MessageRequestResponse.Type.ACCEPT || type == MessageEnvelope.Sync.MessageRequestResponse.Type.UNBLOCK_AND_ACCEPT);
        MessageRequestResponseMessage response = MessageRequestResponseMessage.forIndividual((ServiceId)address.serviceId().get(), (MessageRequestResponseMessage.Type)this.localToRemoteType(type));
        return this.context.getSendHelper().sendSyncMessage(SignalServiceSyncMessage.forMessageRequestResponse((MessageRequestResponseMessage)response));
    }

    private SendMessageResult requestSyncData(SyncMessage.Request.Type type) {
        SyncMessage.Request r = new SyncMessage.Request.Builder().type(type).build();
        SignalServiceSyncMessage message = SignalServiceSyncMessage.forRequest((RequestMessage)new RequestMessage(r));
        return this.context.getSendHelper().sendSyncMessage(message);
    }

    private Optional<DeviceContactAvatar> createContactAvatarAttachment(RecipientAddress address) throws IOException {
        StreamDetails streamDetails = this.context.getAvatarStore().retrieveContactAvatar(address);
        if (streamDetails == null) {
            return Optional.empty();
        }
        return Optional.of(new DeviceContactAvatar(streamDetails.getStream(), streamDetails.getLength(), streamDetails.getContentType()));
    }

    private void storeContactAvatar(DeviceContactAvatar avatar, RecipientAddress address) {
        try {
            this.context.getAvatarStore().storeContactAvatar(address, (OutputStream outputStream) -> IOUtils.copyStream(avatar.getInputStream(), outputStream));
        }
        catch (IOException e) {
            logger.warn("Failed to download avatar for contact {}, ignoring: {}", (Object)address, (Object)e.getMessage());
        }
    }

    private MessageRequestResponseMessage.Type localToRemoteType(MessageEnvelope.Sync.MessageRequestResponse.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MessageEnvelope.Sync.MessageRequestResponse.Type.UNKNOWN -> MessageRequestResponseMessage.Type.UNKNOWN;
            case MessageEnvelope.Sync.MessageRequestResponse.Type.ACCEPT -> MessageRequestResponseMessage.Type.ACCEPT;
            case MessageEnvelope.Sync.MessageRequestResponse.Type.DELETE -> MessageRequestResponseMessage.Type.DELETE;
            case MessageEnvelope.Sync.MessageRequestResponse.Type.BLOCK -> MessageRequestResponseMessage.Type.BLOCK;
            case MessageEnvelope.Sync.MessageRequestResponse.Type.BLOCK_AND_DELETE -> MessageRequestResponseMessage.Type.BLOCK_AND_DELETE;
            case MessageEnvelope.Sync.MessageRequestResponse.Type.UNBLOCK_AND_ACCEPT -> MessageRequestResponseMessage.Type.UNBLOCK_AND_ACCEPT;
            case MessageEnvelope.Sync.MessageRequestResponse.Type.SPAM -> MessageRequestResponseMessage.Type.SPAM;
            case MessageEnvelope.Sync.MessageRequestResponse.Type.BLOCK_AND_SPAM -> MessageRequestResponseMessage.Type.BLOCK_AND_SPAM;
        };
    }
}

