/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.SignalAccountFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAccountManagerImpl
implements MultiAccountManager {
    private static final Logger logger = LoggerFactory.getLogger(MultiAccountManagerImpl.class);
    private final Set<Consumer<Manager>> onManagerAddedHandlers = new HashSet<Consumer<Manager>>();
    private final Set<Consumer<Manager>> onManagerRemovedHandlers = new HashSet<Consumer<Manager>>();
    private final Set<Manager> managers = new HashSet<Manager>();
    private final Map<URI, ProvisioningManager> provisioningManagers = new HashMap<URI, ProvisioningManager>();
    private final SignalAccountFiles signalAccountFiles;

    public MultiAccountManagerImpl(Collection<Manager> managers, SignalAccountFiles signalAccountFiles) {
        this.signalAccountFiles = signalAccountFiles;
        this.managers.addAll(managers);
        managers.forEach(m -> m.addClosedListener(() -> this.removeManager((Manager)m)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAccountNumbers() {
        Set<Manager> set = this.managers;
        synchronized (set) {
            return this.managers.stream().map(Manager::getSelfNumber).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Manager> getManagers() {
        Set<Manager> set = this.managers;
        synchronized (set) {
            return new ArrayList<Manager>(this.managers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addManager(Manager m) {
        Set<Object> set = this.managers;
        synchronized (set) {
            if (this.managers.contains(m)) {
                return;
            }
            this.managers.add(m);
            m.addClosedListener(() -> this.removeManager(m));
        }
        set = this.onManagerAddedHandlers;
        synchronized (set) {
            for (Consumer<Manager> handler : this.onManagerAddedHandlers) {
                handler.accept(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnManagerAddedHandler(Consumer<Manager> handler) {
        Set<Consumer<Manager>> set = this.onManagerAddedHandlers;
        synchronized (set) {
            this.onManagerAddedHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManager(Manager m) {
        Set<Object> set = this.managers;
        synchronized (set) {
            if (!this.managers.remove(m)) {
                return;
            }
        }
        set = this.onManagerRemovedHandlers;
        synchronized (set) {
            for (Consumer<Manager> handler : this.onManagerRemovedHandlers) {
                handler.accept(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnManagerRemovedHandler(Consumer<Manager> handler) {
        Set<Consumer<Manager>> set = this.onManagerRemovedHandlers;
        synchronized (set) {
            this.onManagerRemovedHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manager getManager(String number) {
        Set<Manager> set = this.managers;
        synchronized (set) {
            return this.managers.stream().filter(m -> m.getSelfNumber().equals(number)).findFirst().orElse(null);
        }
    }

    @Override
    public URI getNewProvisioningDeviceLinkUri() throws TimeoutException, IOException {
        ProvisioningManager provisioningManager = this.getNewProvisioningManager();
        URI deviceLinkUri = provisioningManager.getDeviceLinkUri();
        this.provisioningManagers.put(deviceLinkUri, provisioningManager);
        return deviceLinkUri;
    }

    @Override
    public ProvisioningManager getProvisioningManagerFor(URI deviceLinkUri) {
        return this.provisioningManagers.remove(deviceLinkUri);
    }

    private ProvisioningManager getNewProvisioningManager() {
        return this.signalAccountFiles.initProvisioningManager(this::addManager);
    }

    @Override
    public RegistrationManager getNewRegistrationManager(String number) throws IOException {
        return this.signalAccountFiles.initRegistrationManager(number, this::addManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<Manager> set = this.managers;
        synchronized (set) {
            for (Manager m : new ArrayList<Manager>(this.managers)) {
                m.close();
            }
            this.managers.clear();
        }
    }
}

