/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.prekeys;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServicePreKeyStore;
import org.whispersystems.signalservice.api.push.ServiceIdType;

public class PreKeyStore
implements SignalServicePreKeyStore {
    private static final String TABLE_PRE_KEY = "pre_key";
    private static final Logger logger = LoggerFactory.getLogger(PreKeyStore.class);
    private final Database database;
    private final int accountIdType;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE pre_key (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  key_id INTEGER NOT NULL,\n  public_key BLOB NOT NULL,\n  private_key BLOB NOT NULL,\n  stale_timestamp INTEGER,\n  UNIQUE(account_id_type, key_id)\n) STRICT;\n");
        }
    }

    public PreKeyStore(Database database, ServiceIdType serviceIdType) {
        this.database = database;
        this.accountIdType = Utils.getAccountIdType(serviceIdType);
    }

    public PreKeyRecord loadPreKey(int preKeyId) throws InvalidKeyIdException {
        PreKeyRecord preKey = this.getPreKey(preKeyId);
        if (preKey == null) {
            throw new InvalidKeyIdException("No such pre key record: " + preKeyId);
        }
        return preKey;
    }

    public void storePreKey(int preKeyId, PreKeyRecord record) {
        String sql = "INSERT INTO %s (account_id_type, key_id, public_key, private_key)\nVALUES (?, ?, ?, ?)\n".formatted(TABLE_PRE_KEY);
        try (Connection connection = this.database.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, this.accountIdType);
                statement.setInt(2, preKeyId);
                ECKeyPair keyPair = record.getKeyPair();
                statement.setBytes(3, keyPair.getPublicKey().serialize());
                statement.setBytes(4, keyPair.getPrivateKey().serialize());
                statement.executeUpdate();
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update pre_key store", e);
        }
    }

    public boolean containsPreKey(int preKeyId) {
        return this.getPreKey(preKeyId) != null;
    }

    public void removePreKey(int preKeyId) {
        String sql = "DELETE FROM %s AS p\nWHERE p.account_id_type = ? AND p.key_id = ?\n".formatted(TABLE_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setInt(2, preKeyId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update pre_key store", e);
        }
    }

    public void removeAllPreKeys() {
        String sql = "DELETE FROM %s AS p\nWHERE p.account_id_type = ?\n".formatted(TABLE_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update pre_key store", e);
        }
    }

    void addLegacyPreKeys(Collection<PreKeyRecord> preKeys) {
        logger.debug("Migrating legacy preKeys to database");
        long start = System.nanoTime();
        String sql = "INSERT INTO %s (account_id_type, key_id, public_key, private_key)\nVALUES (?, ?, ?, ?)\n".formatted(TABLE_PRE_KEY);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            String deleteSql = "DELETE FROM %s AS p WHERE p.account_id_type = ?".formatted(TABLE_PRE_KEY);
            try (PreparedStatement statement = connection.prepareStatement(deleteSql);){
                statement.setInt(1, this.accountIdType);
                statement.executeUpdate();
            }
            try {
                statement = connection.prepareStatement(sql);
                try {
                    for (PreKeyRecord record : preKeys) {
                        statement.setInt(1, this.accountIdType);
                        statement.setInt(2, record.getId());
                        ECKeyPair keyPair = record.getKeyPair();
                        statement.setBytes(3, keyPair.getPublicKey().serialize());
                        statement.setBytes(4, keyPair.getPrivateKey().serialize());
                        statement.executeUpdate();
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update preKey store", e);
        }
        logger.debug("Complete preKeys migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PreKeyRecord getPreKey(int preKeyId) {
        String sql = "SELECT p.key_id, p.public_key, p.private_key\nFROM %s p\nWHERE p.account_id_type = ? AND p.key_id = ?\n".formatted(TABLE_PRE_KEY);
        try (Connection connection = this.database.getConnection();){
            PreKeyRecord preKeyRecord;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, this.accountIdType);
                    statement.setInt(2, preKeyId);
                    preKeyRecord = Utils.executeQueryForOptional(statement, this::getPreKeyRecordFromResultSet).orElse(null);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return preKeyRecord;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from pre_key store", e);
        }
    }

    private PreKeyRecord getPreKeyRecordFromResultSet(ResultSet resultSet) throws SQLException {
        try {
            int keyId = resultSet.getInt("key_id");
            ECPublicKey publicKey = new ECPublicKey(resultSet.getBytes("public_key"));
            ECPrivateKey privateKey = new ECPrivateKey(resultSet.getBytes("private_key"));
            return new PreKeyRecord(keyId, new ECKeyPair(publicKey, privateKey));
        }
        catch (InvalidKeyException e) {
            return null;
        }
    }

    public void deleteAllStaleOneTimeEcPreKeys(long threshold, int minCount) {
        String sql = "DELETE FROM %s AS p\nWHERE p.account_id_type = ?1\n    AND p.stale_timestamp < ?2\n    AND p._id NOT IN (\n        SELECT _id\n        FROM %s AS p2\n        WHERE p2.account_id_type = ?1\n        ORDER BY\n          CASE WHEN p2.stale_timestamp IS NULL THEN 1 ELSE 0 END DESC,\n          p2.stale_timestamp DESC,\n          p2._id DESC\n        LIMIT ?3\n    )\n".formatted(TABLE_PRE_KEY, TABLE_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setLong(2, threshold);
            statement.setInt(3, minCount);
            int rowCount = statement.executeUpdate();
            if (rowCount > 0) {
                logger.debug("Deleted {} stale one time pre keys", (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update pre_key store", e);
        }
    }

    public void markAllOneTimeEcPreKeysStaleIfNecessary(long staleTime) {
        String sql = "UPDATE %s\nSET stale_timestamp = ?\nWHERE account_id_type = ? AND stale_timestamp IS NULL\n".formatted(TABLE_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, staleTime);
            statement.setInt(2, this.accountIdType);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update pre_key store", e);
        }
    }
}

