/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import java.util.Optional;
import java.util.function.Supplier;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;

public interface RecipientTrustedResolver {
    public RecipientId resolveSelfRecipientTrusted(RecipientAddress var1);

    public RecipientId resolveRecipientTrusted(RecipientAddress var1);

    public RecipientId resolveRecipientTrusted(SignalServiceAddress var1);

    public RecipientId resolveRecipientTrusted(Optional<ServiceId.ACI> var1, Optional<ServiceId.PNI> var2, Optional<String> var3);

    public RecipientId resolveRecipientTrusted(ServiceId.ACI var1, String var2);

    public static class RecipientTrustedResolverWrapper
    implements RecipientTrustedResolver {
        private final Supplier<RecipientTrustedResolver> recipientTrustedResolverSupplier;

        public RecipientTrustedResolverWrapper(Supplier<RecipientTrustedResolver> recipientTrustedResolverSupplier) {
            this.recipientTrustedResolverSupplier = recipientTrustedResolverSupplier;
        }

        @Override
        public RecipientId resolveSelfRecipientTrusted(RecipientAddress address) {
            return this.recipientTrustedResolverSupplier.get().resolveSelfRecipientTrusted(address);
        }

        @Override
        public RecipientId resolveRecipientTrusted(RecipientAddress address) {
            return this.recipientTrustedResolverSupplier.get().resolveRecipientTrusted(address);
        }

        @Override
        public RecipientId resolveRecipientTrusted(SignalServiceAddress address) {
            return this.recipientTrustedResolverSupplier.get().resolveRecipientTrusted(address);
        }

        @Override
        public RecipientId resolveRecipientTrusted(Optional<ServiceId.ACI> aci, Optional<ServiceId.PNI> pni, Optional<String> number) {
            return this.recipientTrustedResolverSupplier.get().resolveRecipientTrusted(aci, pni, number);
        }

        @Override
        public RecipientId resolveRecipientTrusted(ServiceId.ACI aci, String username) {
            return this.recipientTrustedResolverSupplier.get().resolveRecipientTrusted(aci, username);
        }
    }
}

