/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.threads;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asamk.signal.manager.storage.threads.LegacyThreadInfo;

public class LegacyJsonThreadStore {
    private static final ObjectMapper jsonProcessor = new ObjectMapper();
    @JsonProperty(value="threads")
    @JsonSerialize(using=MapToListSerializer.class)
    @JsonDeserialize(using=ThreadsDeserializer.class)
    private final Map<String, LegacyThreadInfo> threads = new HashMap<String, LegacyThreadInfo>();

    public List<LegacyThreadInfo> getThreads() {
        return new ArrayList<LegacyThreadInfo>(this.threads.values());
    }

    private static class ThreadsDeserializer
    extends JsonDeserializer<Map<String, LegacyThreadInfo>> {
        private ThreadsDeserializer() {
        }

        public Map<String, LegacyThreadInfo> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            HashMap<String, LegacyThreadInfo> threads = new HashMap<String, LegacyThreadInfo>();
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            for (JsonNode n : node) {
                LegacyThreadInfo t = (LegacyThreadInfo)jsonProcessor.treeToValue((TreeNode)n, LegacyThreadInfo.class);
                threads.put(t.id, t);
            }
            return threads;
        }
    }

    private static class MapToListSerializer
    extends JsonSerializer<Map<?, ?>> {
        private MapToListSerializer() {
        }

        public void serialize(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.values());
        }
    }
}

