/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record DataURI(String mediaType, Map<String, String> parameter, byte[] data) {
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("\\Adata:(?<type>.+?/.+?)?(?<parameters>;.+?=.+?)?(?<base64>;base64)?,(?<data>.+)\\z", 2);
    public static final Pattern PARAMETER_PATTERN = Pattern.compile("\\G;(?<key>.+)=(?<value>.+)", 2);

    public static DataURI of(String dataURI) {
        Matcher matcher = DATA_URI_PATTERN.matcher(dataURI);
        if (!matcher.find()) {
            throw new IllegalArgumentException("The given string is not a valid data URI.");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        String params = matcher.group("parameters");
        if (params != null) {
            Matcher paramsMatcher = PARAMETER_PATTERN.matcher(params);
            while (paramsMatcher.find()) {
                String key = paramsMatcher.group("key");
                String value = URLDecoder.decode(paramsMatcher.group("value"), StandardCharsets.UTF_8);
                parameters.put(key, value);
            }
        }
        boolean isBase64 = matcher.group("base64") != null;
        byte[] data = isBase64 ? Base64.getDecoder().decode(matcher.group("data").getBytes(StandardCharsets.UTF_8)) : URLDecoder.decode(matcher.group("data"), StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8);
        return new DataURI(Optional.ofNullable(matcher.group("type")).orElse("text/plain"), parameters, data);
    }
}

