/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.StickerPackInvalidException;
import org.asamk.signal.manager.storage.stickerPacks.JsonStickerPack;
import org.asamk.signal.manager.util.MimeUtils;
import org.whispersystems.signalservice.api.messages.SignalServiceStickerManifestUpload;

public class StickerUtils {
    public static SignalServiceStickerManifestUpload getSignalServiceStickerManifestUpload(File file) throws IOException, StickerPackInvalidException {
        ZipFile zip = null;
        String rootPath = null;
        if (file.getName().endsWith(".zip")) {
            zip = new ZipFile(file);
        } else if (file.getName().equals("manifest.json")) {
            rootPath = file.getParent();
        } else {
            throw new StickerPackInvalidException("Could not find manifest.json");
        }
        JsonStickerPack pack = StickerUtils.parseStickerPack(rootPath, zip);
        if (pack.stickers() == null) {
            throw new StickerPackInvalidException("Must set a 'stickers' field.");
        }
        if (pack.stickers().isEmpty()) {
            throw new StickerPackInvalidException("Must include stickers.");
        }
        ArrayList<SignalServiceStickerManifestUpload.StickerInfo> stickers = new ArrayList<SignalServiceStickerManifestUpload.StickerInfo>(pack.stickers().size());
        for (JsonStickerPack.JsonSticker sticker : pack.stickers()) {
            Pair<InputStream, Long> data;
            if (sticker.file() == null) {
                throw new StickerPackInvalidException("Must set a 'file' field on each sticker.");
            }
            try {
                data = StickerUtils.getInputStreamAndLength(rootPath, zip, sticker.file());
            }
            catch (IOException ignored) {
                throw new StickerPackInvalidException("Could not find find " + sticker.file());
            }
            String contentType = sticker.contentType() != null && !sticker.contentType().isEmpty() ? sticker.contentType() : StickerUtils.getContentType(rootPath, zip, sticker.file());
            SignalServiceStickerManifestUpload.StickerInfo stickerInfo = new SignalServiceStickerManifestUpload.StickerInfo(data.first(), data.second().longValue(), Optional.ofNullable(sticker.emoji()).orElse(""), contentType);
            stickers.add(stickerInfo);
        }
        SignalServiceStickerManifestUpload.StickerInfo cover = null;
        if (pack.cover() != null) {
            Pair<InputStream, Long> data;
            if (pack.cover().file() == null) {
                throw new StickerPackInvalidException("Must set a 'file' field on the cover.");
            }
            try {
                data = StickerUtils.getInputStreamAndLength(rootPath, zip, pack.cover().file());
            }
            catch (IOException ignored) {
                throw new StickerPackInvalidException("Could not find find " + pack.cover().file());
            }
            String contentType = pack.cover().contentType() != null && !pack.cover().contentType().isEmpty() ? pack.cover().contentType() : StickerUtils.getContentType(rootPath, zip, pack.cover().file());
            cover = new SignalServiceStickerManifestUpload.StickerInfo(data.first(), data.second().longValue(), Optional.ofNullable(pack.cover().emoji()).orElse(""), contentType);
        }
        return new SignalServiceStickerManifestUpload(pack.title(), pack.author(), cover, stickers);
    }

    private static JsonStickerPack parseStickerPack(String rootPath, ZipFile zip) throws IOException {
        InputStream inputStream = zip != null ? zip.getInputStream(zip.getEntry("manifest.json")) : new FileInputStream(new File(rootPath, "manifest.json"));
        return (JsonStickerPack)new ObjectMapper().readValue(inputStream, JsonStickerPack.class);
    }

    private static Pair<InputStream, Long> getInputStreamAndLength(String rootPath, ZipFile zip, String subfile) throws IOException {
        if (zip != null) {
            ZipEntry entry = zip.getEntry(subfile);
            return new Pair<InputStream, Long>(zip.getInputStream(entry), entry.getSize());
        }
        File file = new File(rootPath, subfile);
        return new Pair<InputStream, Long>(new FileInputStream(file), file.length());
    }

    private static String getContentType(String rootPath, ZipFile zip, String subfile) throws IOException {
        if (zip != null) {
            ZipEntry entry = zip.getEntry(subfile);
            try (BufferedInputStream bufferedStream = new BufferedInputStream(zip.getInputStream(entry));){
                String string = MimeUtils.getStreamMimeType(bufferedStream).orElse(null);
                return string;
            }
        }
        File file = new File(rootPath, subfile);
        return MimeUtils.getFileMimeType(file).orElse(null);
    }
}

