/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.output.OutputWriter;

public class RemoveDeviceCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "removeDevice";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Remove a linked device.");
        subparser.addArgument(new String[]{"-d", "--device-id", "--deviceId"}).type(Integer.TYPE).required(true).help("Specify the device you want to remove. Use listDevices to see the deviceIds.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        try {
            Integer deviceId = ns.getInt("device-id");
            m.removeLinkedDevices(deviceId.intValue());
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
        catch (IOException e) {
            throw new IOErrorException("Error while removing device: " + e.getMessage(), e);
        }
    }
}

