/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.IOException;
import java.util.List;
import org.asamk.Signal;
import org.asamk.SignalControl;
import org.asamk.signal.DbusConfig;
import org.asamk.signal.commands.Command;
import org.asamk.signal.commands.CommandHandler;
import org.asamk.signal.commands.LocalCommand;
import org.asamk.signal.commands.MultiLocalCommand;
import org.asamk.signal.commands.ProvisioningCommand;
import org.asamk.signal.commands.RegistrationCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.dbus.DbusManagerImpl;
import org.asamk.signal.dbus.DbusMultiAccountManagerImpl;
import org.asamk.signal.dbus.DbusProvisioningManagerImpl;
import org.asamk.signal.dbus.DbusRegistrationManagerImpl;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.errors.ServiceUnknown;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

public class DbusCommandHandler {
    public static void initDbusClient(Command command, String account, boolean systemBus, String busname, CommandHandler commandHandler) throws CommandException {
        try {
            DBusConnection.DBusBusType busType = systemBus ? DBusConnection.DBusBusType.SYSTEM : DBusConnection.DBusBusType.SESSION;
            try (DBusConnection dBusConn = DBusConnectionBuilder.forType((DBusConnection.DBusBusType)busType).build();){
                DbusCommandHandler.handleCommand(command, account, dBusConn, busname, commandHandler);
            }
        }
        catch (ServiceUnknown e) {
            throw new UserErrorException("signal-cli DBus daemon not running on " + (systemBus ? "system" : "session") + " bus: " + e.getMessage(), e);
        }
        catch (IOException | DBusException | DBusExecutionException e) {
            throw new UnexpectedErrorException("Dbus client failed: " + e.getMessage(), e);
        }
    }

    public static void handleCommand(Command command, String account, DBusConnection dBusConn, String busname, CommandHandler commandHandler) throws CommandException, DBusException {
        try {
            String accountObjectPath;
            if (command instanceof ProvisioningCommand) {
                ProvisioningCommand c = (ProvisioningCommand)command;
                if (account != null) {
                    throw new UserErrorException("You cannot specify a account (phone number) when linking");
                }
                DbusCommandHandler.handleProvisioningCommand(c, dBusConn, busname, commandHandler);
                return;
            }
            if (account == null && command instanceof MultiLocalCommand) {
                MultiLocalCommand c = (MultiLocalCommand)command;
                DbusCommandHandler.handleMultiLocalCommand(c, dBusConn, busname, commandHandler);
                return;
            }
            if (account != null && command instanceof RegistrationCommand) {
                RegistrationCommand c = (RegistrationCommand)command;
                DbusCommandHandler.handleRegistrationCommand(c, account, dBusConn, busname, commandHandler);
                return;
            }
            if (!(command instanceof LocalCommand)) {
                throw new UserErrorException("Command only works in multi-account mode");
            }
            LocalCommand localCommand = (LocalCommand)command;
            String string = accountObjectPath = account == null ? DbusCommandHandler.tryGetSingleAccountObjectPath(dBusConn, busname) : null;
            if (accountObjectPath == null) {
                accountObjectPath = DbusConfig.getObjectPath(account);
            }
            DbusCommandHandler.handleLocalCommand(localCommand, accountObjectPath, dBusConn, busname, commandHandler);
        }
        catch (UnsupportedOperationException e) {
            throw new UserErrorException("Command is not yet implemented via dbus", e);
        }
        catch (DBusExecutionException e) {
            throw new UnexpectedErrorException(e.getMessage(), e);
        }
    }

    private static String tryGetSingleAccountObjectPath(DBusConnection dBusConn, String busname) throws DBusException, CommandException {
        SignalControl control = (SignalControl)dBusConn.getRemoteObject(busname, DbusConfig.getObjectPath(), SignalControl.class);
        try {
            List<DBusPath> accounts = control.listAccounts();
            if (accounts.isEmpty()) {
                throw new UserErrorException("No local users found, you first need to register or link an account");
            }
            if (accounts.size() > 1) {
                throw new UserErrorException("Multiple users found, you need to specify an account (phone number) with -a");
            }
            return accounts.getFirst().getPath();
        }
        catch (UnknownMethod e) {
            return null;
        }
    }

    private static void handleMultiLocalCommand(MultiLocalCommand c, DBusConnection dBusConn, String busname, CommandHandler commandHandler) throws CommandException, DBusException {
        SignalControl signalControl = (SignalControl)dBusConn.getRemoteObject(busname, DbusConfig.getObjectPath(), SignalControl.class);
        try (DbusMultiAccountManagerImpl multiAccountManager = new DbusMultiAccountManagerImpl(signalControl, dBusConn, busname);){
            commandHandler.handleMultiLocalCommand(c, multiAccountManager);
        }
    }

    private static void handleLocalCommand(LocalCommand c, String accountObjectPath, DBusConnection dBusConn, String busname, CommandHandler commandHandler) throws CommandException, DBusException {
        Signal signal = (Signal)dBusConn.getRemoteObject(busname, accountObjectPath, Signal.class);
        try (DbusManagerImpl manager = new DbusManagerImpl(signal, dBusConn, busname);){
            commandHandler.handleLocalCommand(c, manager);
        }
    }

    private static void handleRegistrationCommand(RegistrationCommand c, String account, DBusConnection dBusConn, String busname, CommandHandler commandHandler) throws CommandException, DBusException {
        SignalControl signalControl = (SignalControl)dBusConn.getRemoteObject(busname, DbusConfig.getObjectPath(), SignalControl.class);
        try (DbusRegistrationManagerImpl registrationManager = new DbusRegistrationManagerImpl(account, signalControl, dBusConn);){
            commandHandler.handleRegistrationCommand(c, registrationManager);
        }
    }

    private static void handleProvisioningCommand(ProvisioningCommand c, DBusConnection dBusConn, String busname, CommandHandler commandHandler) throws CommandException, DBusException {
        SignalControl signalControl = (SignalControl)dBusConn.getRemoteObject(busname, DbusConfig.getObjectPath(), SignalControl.class);
        DbusProvisioningManagerImpl provisioningManager = new DbusProvisioningManagerImpl(signalControl, dBusConn);
        commandHandler.handleProvisioningCommand(c, provisioningManager);
    }
}

