/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asamk.Signal;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.AlreadyReceivingException;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.Configuration;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.Device;
import org.asamk.signal.manager.api.DeviceLinkUrl;
import org.asamk.signal.manager.api.Group;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupPermission;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.Identity;
import org.asamk.signal.manager.api.IdentityVerificationCode;
import org.asamk.signal.manager.api.InactiveGroupLinkException;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.InvalidDeviceLinkException;
import org.asamk.signal.manager.api.InvalidStickerException;
import org.asamk.signal.manager.api.InvalidUsernameException;
import org.asamk.signal.manager.api.LastGroupAdminException;
import org.asamk.signal.manager.api.Message;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.manager.api.Recipient;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.StickerPack;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.api.StickerPackInvalidException;
import org.asamk.signal.manager.api.StickerPackUrl;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.api.TypingAction;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.api.UpdateGroup;
import org.asamk.signal.manager.api.UpdateProfile;
import org.asamk.signal.manager.api.UserStatus;
import org.asamk.signal.manager.api.UsernameLinkUrl;
import org.asamk.signal.manager.api.UsernameStatus;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.types.Variant;

public class DbusManagerImpl
implements Manager {
    private final Signal signal;
    private final DBusConnection connection;
    private final Set<Manager.ReceiveMessageHandler> weakHandlers = new HashSet<Manager.ReceiveMessageHandler>();
    private final Set<Manager.ReceiveMessageHandler> messageHandlers = new HashSet<Manager.ReceiveMessageHandler>();
    private final List<Runnable> closedListeners = new ArrayList<Runnable>();
    private final String busname;
    private DBusSigHandler<Signal.MessageReceivedV2> dbusMsgHandler;
    private DBusSigHandler<Signal.EditMessageReceived> dbusEditMsgHandler;
    private DBusSigHandler<Signal.ReceiptReceivedV2> dbusRcptHandler;
    private DBusSigHandler<Signal.SyncMessageReceivedV2> dbusSyncHandler;
    private Thread receiveThread;

    public DbusManagerImpl(Signal signal, DBusConnection connection, String busname) {
        this.signal = signal;
        this.connection = connection;
        this.busname = busname;
    }

    public String getSelfNumber() {
        return this.signal.getSelfNumber();
    }

    public Map<String, UserStatus> getUserStatus(Set<String> numbers) throws IOException {
        ArrayList<String> numbersList = new ArrayList<String>(numbers);
        List<Boolean> registered = this.signal.isRegistered(numbersList);
        HashMap<String, UserStatus> result = new HashMap<String, UserStatus>();
        for (int i = 0; i < numbersList.size(); ++i) {
            result.put(numbersList.get(i), new UserStatus(numbersList.get(i), registered.get(i) != false ? RecipientAddress.UNKNOWN_UUID : null, false));
        }
        return result;
    }

    public Map<String, UsernameStatus> getUsernameStatus(Set<String> usernames) {
        throw new UnsupportedOperationException();
    }

    public void updateAccountAttributes(String deviceName, Boolean unrestrictedUnidentifiedSender, Boolean discoverableByNumber, Boolean numberSharing) throws IOException {
        if (deviceName == null) {
            throw new UnsupportedOperationException();
        }
        DBusPath devicePath = this.signal.getThisDevice();
        this.getRemoteObject(devicePath, Signal.Device.class).Set("org.asamk.Signal.Device", "Name", deviceName);
    }

    public Configuration getConfiguration() {
        Map configuration = this.getRemoteObject(new DBusPath(this.signal.getObjectPath() + "/Configuration"), Signal.Configuration.class).GetAll("org.asamk.Signal.Configuration");
        return new Configuration(Optional.of((Boolean)((Variant)configuration.get("ReadReceipts")).getValue()), Optional.of((Boolean)((Variant)configuration.get("UnidentifiedDeliveryIndicators")).getValue()), Optional.of((Boolean)((Variant)configuration.get("TypingIndicators")).getValue()), Optional.of((Boolean)((Variant)configuration.get("LinkPreviews")).getValue()));
    }

    public void updateConfiguration(Configuration newConfiguration) {
        Signal.Configuration configuration = this.getRemoteObject(new DBusPath(this.signal.getObjectPath() + "/Configuration"), Signal.Configuration.class);
        newConfiguration.readReceipts().ifPresent(v -> configuration.Set("org.asamk.Signal.Configuration", "ReadReceipts", v));
        newConfiguration.unidentifiedDeliveryIndicators().ifPresent(v -> configuration.Set("org.asamk.Signal.Configuration", "UnidentifiedDeliveryIndicators", v));
        newConfiguration.typingIndicators().ifPresent(v -> configuration.Set("org.asamk.Signal.Configuration", "TypingIndicators", v));
        newConfiguration.linkPreviews().ifPresent(v -> configuration.Set("org.asamk.Signal.Configuration", "LinkPreviews", v));
    }

    public void updateProfile(UpdateProfile updateProfile) throws IOException {
        this.signal.updateProfile(this.emptyIfNull(updateProfile.getGivenName()), this.emptyIfNull(updateProfile.getFamilyName()), this.emptyIfNull(updateProfile.getAbout()), this.emptyIfNull(updateProfile.getAboutEmoji()), updateProfile.getAvatar() == null ? "" : updateProfile.getAvatar(), updateProfile.isDeleteAvatar());
    }

    public String getUsername() {
        throw new UnsupportedOperationException();
    }

    public UsernameLinkUrl getUsernameLink() {
        throw new UnsupportedOperationException();
    }

    public void setUsername(String username) throws IOException, InvalidUsernameException {
        throw new UnsupportedOperationException();
    }

    public void deleteUsername() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void startChangeNumber(String newNumber, boolean voiceVerification, String captcha) throws RateLimitException, IOException, CaptchaRequiredException, NonNormalizedPhoneNumberException {
        throw new UnsupportedOperationException();
    }

    public void finishChangeNumber(String newNumber, String verificationCode, String pin) throws IncorrectPinException, PinLockedException, IOException {
        throw new UnsupportedOperationException();
    }

    public void unregister() throws IOException {
        this.signal.unregister();
    }

    public void deleteAccount() throws IOException {
        this.signal.deleteAccount();
    }

    public void submitRateLimitRecaptchaChallenge(String challenge, String captcha) throws IOException {
        this.signal.submitRateLimitChallenge(challenge, captcha);
    }

    public List<Device> getLinkedDevices() throws IOException {
        DBusPath thisDevice = this.signal.getThisDevice();
        return this.signal.listDevices().stream().map(d -> {
            Map device = this.getRemoteObject(d.getObjectPath(), Signal.Device.class).GetAll("org.asamk.Signal.Device");
            return new Device(((Integer)((Variant)device.get("Id")).getValue()).intValue(), (String)((Variant)device.get("Name")).getValue(), ((Long)((Variant)device.get("Created")).getValue()).longValue(), ((Long)((Variant)device.get("LastSeen")).getValue()).longValue(), thisDevice.equals((Object)d.getObjectPath()));
        }).toList();
    }

    public void removeLinkedDevices(int deviceId) throws IOException {
        DBusPath devicePath = this.signal.getDevice(deviceId);
        this.getRemoteObject(devicePath, Signal.Device.class).removeDevice();
    }

    public void addDeviceLink(DeviceLinkUrl linkUri) throws IOException, InvalidDeviceLinkException {
        this.signal.addDevice(linkUri.createDeviceLinkUri().toString());
    }

    public void setRegistrationLockPin(Optional<String> pin) throws IOException {
        if (pin.isPresent()) {
            this.signal.setPin(pin.get());
        } else {
            this.signal.removePin();
        }
    }

    public List<Group> getGroups() {
        List<Signal.StructGroup> groups = this.signal.listGroups();
        return groups.stream().map(Signal.StructGroup::getObjectPath).map(this::getGroup).toList();
    }

    public List<Group> getGroups(Collection<GroupId> groupIds) {
        List<Signal.StructGroup> groups = this.signal.listGroups();
        return groups.stream().map(Signal.StructGroup::getObjectPath).map(this::getGroup).filter(g -> groupIds.contains(g.groupId())).toList();
    }

    public SendGroupMessageResults quitGroup(GroupId groupId, Set<RecipientIdentifier.Single> groupAdmins) throws GroupNotFoundException, IOException, NotAGroupMemberException, LastGroupAdminException {
        if (!groupAdmins.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        Signal.Group group = this.getRemoteObject(this.signal.getGroup(groupId.serialize()), Signal.Group.class);
        try {
            group.quitGroup();
        }
        catch (Signal.Error.GroupNotFound e) {
            throw new GroupNotFoundException(groupId);
        }
        catch (Signal.Error.NotAGroupMember e) {
            throw new NotAGroupMemberException(groupId, (String)group.Get("org.asamk.Signal.Group", "Name"));
        }
        catch (Signal.Error.LastGroupAdmin e) {
            throw new LastGroupAdminException(groupId, (String)group.Get("org.asamk.Signal.Group", "Name"));
        }
        return new SendGroupMessageResults(0L, List.of());
    }

    public void deleteGroup(GroupId groupId) throws IOException {
        Signal.Group group = this.getRemoteObject(this.signal.getGroup(groupId.serialize()), Signal.Group.class);
        group.deleteGroup();
    }

    public Pair<GroupId, SendGroupMessageResults> createGroup(String name, Set<RecipientIdentifier.Single> members, String avatarFile) throws IOException, AttachmentInvalidException {
        byte[] newGroupId = this.signal.createGroup(this.emptyIfNull(name), members.stream().map(RecipientIdentifier::getIdentifier).toList(), avatarFile == null ? "" : avatarFile);
        return new Pair((Object)GroupId.unknownVersion((byte[])newGroupId), (Object)new SendGroupMessageResults(0L, List.of()));
    }

    public SendGroupMessageResults updateGroup(GroupId groupId, UpdateGroup updateGroup) throws IOException, GroupNotFoundException, AttachmentInvalidException, NotAGroupMemberException, GroupSendingNotAllowedException {
        Signal.Group group = this.getRemoteObject(this.signal.getGroup(groupId.serialize()), Signal.Group.class);
        if (updateGroup.getName() != null) {
            group.Set("org.asamk.Signal.Group", "Name", updateGroup.getName());
        }
        if (updateGroup.getDescription() != null) {
            group.Set("org.asamk.Signal.Group", "Description", updateGroup.getDescription());
        }
        if (updateGroup.getAvatarFile() != null) {
            group.Set("org.asamk.Signal.Group", "Avatar", updateGroup.getAvatarFile() == null ? "" : updateGroup.getAvatarFile());
        }
        if (updateGroup.getExpirationTimer() != null) {
            group.Set("org.asamk.Signal.Group", "MessageExpirationTimer", updateGroup.getExpirationTimer());
        }
        if (updateGroup.getAddMemberPermission() != null) {
            group.Set("org.asamk.Signal.Group", "PermissionAddMember", updateGroup.getAddMemberPermission().name());
        }
        if (updateGroup.getEditDetailsPermission() != null) {
            group.Set("org.asamk.Signal.Group", "PermissionEditDetails", updateGroup.getEditDetailsPermission().name());
        }
        if (updateGroup.getIsAnnouncementGroup() != null) {
            group.Set("org.asamk.Signal.Group", "PermissionSendMessage", updateGroup.getIsAnnouncementGroup() != false ? GroupPermission.ONLY_ADMINS.name() : GroupPermission.EVERY_MEMBER.name());
        }
        if (updateGroup.getMembers() != null) {
            group.addMembers(updateGroup.getMembers().stream().map(RecipientIdentifier::getIdentifier).toList());
        }
        if (updateGroup.getRemoveMembers() != null) {
            group.removeMembers(updateGroup.getRemoveMembers().stream().map(RecipientIdentifier::getIdentifier).toList());
        }
        if (updateGroup.getAdmins() != null) {
            group.addAdmins(updateGroup.getAdmins().stream().map(RecipientIdentifier::getIdentifier).toList());
        }
        if (updateGroup.getRemoveAdmins() != null) {
            group.removeAdmins(updateGroup.getRemoveAdmins().stream().map(RecipientIdentifier::getIdentifier).toList());
        }
        if (updateGroup.isResetGroupLink()) {
            group.resetLink();
        }
        if (updateGroup.getGroupLinkState() != null) {
            switch (updateGroup.getGroupLinkState()) {
                case DISABLED: {
                    group.disableLink();
                    break;
                }
                case ENABLED: {
                    group.enableLink(false);
                    break;
                }
                case ENABLED_WITH_APPROVAL: {
                    group.enableLink(true);
                }
            }
        }
        return new SendGroupMessageResults(0L, List.of());
    }

    public Pair<GroupId, SendGroupMessageResults> joinGroup(GroupInviteLinkUrl inviteLinkUrl) throws IOException, InactiveGroupLinkException {
        try {
            byte[] newGroupId = this.signal.joinGroup(inviteLinkUrl.getUrl());
            return new Pair((Object)GroupId.unknownVersion((byte[])newGroupId), (Object)new SendGroupMessageResults(0L, List.of()));
        }
        catch (DBusExecutionException e) {
            throw new IOException("Failed to join group: " + e.getMessage() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + ")", e);
        }
    }

    public SendMessageResults sendTypingMessage(TypingAction action, Set<RecipientIdentifier> recipients) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        return this.handleMessage(recipients, numbers -> {
            numbers.forEach(n -> this.signal.sendTyping((String)n, action == TypingAction.STOP));
            return 0L;
        }, () -> {
            this.signal.sendTyping(this.signal.getSelfNumber(), action == TypingAction.STOP);
            return 0L;
        }, groupId -> {
            this.signal.sendGroupTyping((byte[])groupId, action == TypingAction.STOP);
            return 0L;
        });
    }

    public SendMessageResults sendReadReceipt(RecipientIdentifier.Single sender, List<Long> messageIds) {
        this.signal.sendReadReceipt(sender.getIdentifier(), messageIds);
        return new SendMessageResults(0L, Map.of());
    }

    public SendMessageResults sendViewedReceipt(RecipientIdentifier.Single sender, List<Long> messageIds) {
        this.signal.sendViewedReceipt(sender.getIdentifier(), messageIds);
        return new SendMessageResults(0L, Map.of());
    }

    public SendMessageResults sendMessage(Message message, Set<RecipientIdentifier> recipients, boolean notifySelf) throws IOException, AttachmentInvalidException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        return this.handleMessage(recipients, numbers -> this.signal.sendMessage(message.messageText(), (List<String>)message.attachments(), (List<String>)numbers), () -> this.signal.sendNoteToSelfMessage(message.messageText(), message.attachments()), groupId -> this.signal.sendGroupMessage(message.messageText(), message.attachments(), (byte[])groupId));
    }

    public SendMessageResults sendEditMessage(Message message, Set<RecipientIdentifier> recipients, long editTargetTimestamp) throws IOException, AttachmentInvalidException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException, UnregisteredRecipientException, InvalidStickerException {
        throw new UnsupportedOperationException();
    }

    public SendMessageResults sendRemoteDeleteMessage(long targetSentTimestamp, Set<RecipientIdentifier> recipients) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        return this.handleMessage(recipients, numbers -> this.signal.sendRemoteDeleteMessage(targetSentTimestamp, (List<String>)numbers), () -> this.signal.sendRemoteDeleteMessage(targetSentTimestamp, this.signal.getSelfNumber()), groupId -> this.signal.sendGroupRemoteDeleteMessage(targetSentTimestamp, (byte[])groupId));
    }

    public SendMessageResults sendMessageReaction(String emoji, boolean remove, RecipientIdentifier.Single targetAuthor, long targetSentTimestamp, Set<RecipientIdentifier> recipients, boolean isStory) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        return this.handleMessage(recipients, numbers -> this.signal.sendMessageReaction(emoji, remove, targetAuthor.getIdentifier(), targetSentTimestamp, (List<String>)numbers), () -> this.signal.sendMessageReaction(emoji, remove, targetAuthor.getIdentifier(), targetSentTimestamp, this.signal.getSelfNumber()), groupId -> this.signal.sendGroupMessageReaction(emoji, remove, targetAuthor.getIdentifier(), targetSentTimestamp, (byte[])groupId));
    }

    public SendMessageResults sendPaymentNotificationMessage(byte[] receipt, String note, RecipientIdentifier.Single recipient) throws IOException {
        long timestamp = this.signal.sendPaymentNotification(receipt, note, recipient.getIdentifier());
        return new SendMessageResults(timestamp, Map.of());
    }

    public SendMessageResults sendEndSessionMessage(Set<RecipientIdentifier.Single> recipients) throws IOException {
        this.signal.sendEndSessionMessage(recipients.stream().map(RecipientIdentifier::getIdentifier).toList());
        return new SendMessageResults(0L, Map.of());
    }

    public SendMessageResults sendMessageRequestResponse(MessageEnvelope.Sync.MessageRequestResponse.Type type, Set<RecipientIdentifier> recipientIdentifiers) {
        throw new UnsupportedOperationException();
    }

    public void hideRecipient(RecipientIdentifier.Single recipient) {
        throw new UnsupportedOperationException();
    }

    public void deleteRecipient(RecipientIdentifier.Single recipient) {
        this.signal.deleteRecipient(recipient.getIdentifier());
    }

    public void deleteContact(RecipientIdentifier.Single recipient) {
        this.signal.deleteContact(recipient.getIdentifier());
    }

    public void setContactName(RecipientIdentifier.Single recipient, String givenName, String familyName, String nickGivenName, String nickFamilyName, String note) throws NotPrimaryDeviceException {
        this.signal.setContactName(recipient.getIdentifier(), givenName);
    }

    public void setContactsBlocked(Collection<RecipientIdentifier.Single> recipients, boolean blocked) throws NotPrimaryDeviceException, IOException {
        for (RecipientIdentifier.Single recipient : recipients) {
            this.signal.setContactBlocked(recipient.getIdentifier(), blocked);
        }
    }

    public void setGroupsBlocked(Collection<GroupId> groupIds, boolean blocked) throws GroupNotFoundException, IOException {
        for (GroupId groupId : groupIds) {
            this.setGroupProperty(groupId, "IsBlocked", blocked);
        }
    }

    private void setGroupProperty(GroupId groupId, String propertyName, boolean blocked) {
        Signal.Group group = this.getRemoteObject(this.signal.getGroup(groupId.serialize()), Signal.Group.class);
        group.Set("org.asamk.Signal.Group", propertyName, blocked);
    }

    public void setExpirationTimer(RecipientIdentifier.Single recipient, int messageExpirationTimer) throws IOException {
        this.signal.setExpirationTimer(recipient.getIdentifier(), messageExpirationTimer);
    }

    public StickerPackUrl uploadStickerPack(File path) throws IOException, StickerPackInvalidException {
        try {
            return StickerPackUrl.fromUri((URI)new URI(this.signal.uploadStickerPack(path.getPath())));
        }
        catch (URISyntaxException | StickerPackUrl.InvalidStickerPackLinkException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void installStickerPack(StickerPackUrl url) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<StickerPack> getStickerPacks() {
        throw new UnsupportedOperationException();
    }

    public void requestAllSyncData() throws IOException {
        this.signal.sendSyncRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiveHandler(Manager.ReceiveMessageHandler handler, boolean isWeakListener) {
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            if (isWeakListener) {
                this.weakHandlers.add(handler);
            } else {
                if (this.messageHandlers.isEmpty()) {
                    this.installMessageHandlers();
                }
                this.messageHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReceiveHandler(Manager.ReceiveMessageHandler handler) {
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            this.weakHandlers.remove(handler);
            this.messageHandlers.remove(handler);
            if (this.messageHandlers.isEmpty()) {
                this.uninstallMessageHandlers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceiving() {
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            return !this.messageHandlers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessages(Optional<Duration> timeout, Optional<Integer> maxMessages, Manager.ReceiveMessageHandler handler) throws IOException, AlreadyReceivingException {
        if (this.receiveThread != null) {
            throw new AlreadyReceivingException("Already receiving message.");
        }
        this.receiveThread = Thread.currentThread();
        AtomicInteger remainingMessages = new AtomicInteger(maxMessages.orElse(-1));
        AtomicLong lastMessage = new AtomicLong(System.currentTimeMillis());
        Thread thread = Thread.currentThread();
        Manager.ReceiveMessageHandler receiveHandler = (envelope, e) -> {
            lastMessage.set(System.currentTimeMillis());
            handler.handleMessage(envelope, e);
            if (remainingMessages.get() > 0 && remainingMessages.decrementAndGet() <= 0) {
                remainingMessages.set(0);
                thread.interrupt();
            }
        };
        this.addReceiveHandler(receiveHandler);
        if (timeout.isPresent()) {
            while (remainingMessages.get() != 0) {
                try {
                    long passedTime = System.currentTimeMillis() - lastMessage.get();
                    long sleepTimeRemaining = timeout.get().toMillis() - passedTime;
                    if (sleepTimeRemaining >= 0L) {
                        Thread.sleep(sleepTimeRemaining);
                        continue;
                    }
                    break;
                }
                catch (InterruptedException ignored) {
                    break;
                }
            }
        } else {
            try {
                DbusManagerImpl dbusManagerImpl = this;
                synchronized (dbusManagerImpl) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.removeReceiveHandler(receiveHandler);
        this.receiveThread = null;
    }

    public void stopReceiveMessages() {
        if (this.receiveThread != null) {
            this.receiveThread.interrupt();
        }
    }

    public void setReceiveConfig(ReceiveConfig receiveConfig) {
    }

    public boolean isContactBlocked(RecipientIdentifier.Single recipient) {
        return this.signal.isContactBlocked(recipient.getIdentifier());
    }

    public void sendContacts() throws IOException {
        this.signal.sendContacts();
    }

    public List<Recipient> getRecipients(boolean onlyContacts, Optional<Boolean> blocked, Collection<RecipientIdentifier.Single> addresses, Optional<String> name) {
        Set numbers = addresses.stream().filter(s -> s instanceof RecipientIdentifier.Number).map(s -> ((RecipientIdentifier.Number)s).number()).collect(Collectors.toSet());
        return this.signal.listNumbers().stream().filter(n -> addresses.isEmpty() || numbers.contains(n)).map(n -> {
            boolean contactBlocked = this.signal.isContactBlocked((String)n);
            if (blocked.isPresent() && (Boolean)blocked.get() != contactBlocked) {
                return null;
            }
            String contactName = this.signal.getContactName((String)n);
            if (onlyContacts && contactName.isEmpty()) {
                return null;
            }
            if (name.isPresent() && !((String)name.get()).equals(contactName)) {
                return null;
            }
            return Recipient.newBuilder().withAddress(new RecipientAddress(n)).withContact(new Contact(contactName, null, null, null, null, null, null, 0, 1, 0L, false, contactBlocked, false, false, false, null)).build();
        }).filter(Objects::nonNull).toList();
    }

    public String getContactOrProfileName(RecipientIdentifier.Single recipient) {
        return this.signal.getContactName(recipient.getIdentifier());
    }

    public Group getGroup(GroupId groupId) {
        DBusPath groupPath = this.signal.getGroup(groupId.serialize());
        return this.getGroup(groupPath);
    }

    private Group getGroup(DBusPath groupPath) {
        Map group = this.getRemoteObject(groupPath, Signal.Group.class).GetAll("org.asamk.Signal.Group");
        byte[] id = (byte[])((Variant)group.get("Id")).getValue();
        try {
            return new Group(GroupId.unknownVersion((byte[])id), (String)((Variant)group.get("Name")).getValue(), (String)((Variant)group.get("Description")).getValue(), GroupInviteLinkUrl.fromUri((String)((String)((Variant)group.get("GroupInviteLink")).getValue())), ((List)((Variant)group.get("Members")).getValue()).stream().map(m -> new RecipientAddress(m)).collect(Collectors.toSet()), ((List)((Variant)group.get("PendingMembers")).getValue()).stream().map(m -> new RecipientAddress(m)).collect(Collectors.toSet()), ((List)((Variant)group.get("RequestingMembers")).getValue()).stream().map(m -> new RecipientAddress(m)).collect(Collectors.toSet()), ((List)((Variant)group.get("Admins")).getValue()).stream().map(m -> new RecipientAddress(m)).collect(Collectors.toSet()), ((List)((Variant)group.get("Banned")).getValue()).stream().map(m -> new RecipientAddress(m)).collect(Collectors.toSet()), ((Boolean)((Variant)group.get("IsBlocked")).getValue()).booleanValue(), ((Integer)((Variant)group.get("MessageExpirationTimer")).getValue()).intValue(), GroupPermission.valueOf((String)((String)((Variant)group.get("PermissionAddMember")).getValue())), GroupPermission.valueOf((String)((String)((Variant)group.get("PermissionEditDetails")).getValue())), GroupPermission.valueOf((String)((String)((Variant)group.get("PermissionSendMessage")).getValue())), ((Boolean)((Variant)group.get("IsMember")).getValue()).booleanValue(), ((Boolean)((Variant)group.get("IsAdmin")).getValue()).booleanValue());
        }
        catch (GroupInviteLinkUrl.InvalidGroupLinkException | GroupInviteLinkUrl.UnknownGroupLinkVersionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<Identity> getIdentities() {
        List<Signal.StructIdentity> identities = this.signal.listIdentities();
        return identities.stream().map(Signal.StructIdentity::getObjectPath).map(this::getIdentity).toList();
    }

    public List<Identity> getIdentities(RecipientIdentifier.Single recipient) {
        DBusPath path = this.signal.getIdentity(recipient.getIdentifier());
        return List.of(this.getIdentity(path));
    }

    private Identity getIdentity(DBusPath identityPath) {
        Map group = this.getRemoteObject(identityPath, Signal.Identity.class).GetAll("org.asamk.Signal.Identity");
        String aci = (String)((Variant)group.get("Uuid")).getValue();
        String number = (String)((Variant)group.get("Number")).getValue();
        return new Identity(new RecipientAddress(aci, null, number, null), (byte[])((Variant)group.get("Fingerprint")).getValue(), (String)((Variant)group.get("SafetyNumber")).getValue(), (byte[])((Variant)group.get("ScannableSafetyNumber")).getValue(), TrustLevel.valueOf((String)((String)((Variant)group.get("TrustLevel")).getValue())), ((Long)((Variant)group.get("AddedDate")).getValue()).longValue());
    }

    public boolean trustIdentityVerified(RecipientIdentifier.Single recipient, IdentityVerificationCode verificationCode) {
        throw new UnsupportedOperationException();
    }

    public boolean trustIdentityAllKeys(RecipientIdentifier.Single recipient) {
        throw new UnsupportedOperationException();
    }

    public void addAddressChangedListener(Runnable listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClosedListener(Runnable listener) {
        List<Runnable> list = this.closedListeners;
        synchronized (list) {
            this.closedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<Runnable> list = this;
        synchronized (list) {
            this.notify();
        }
        list = this.messageHandlers;
        synchronized (list) {
            if (!this.messageHandlers.isEmpty()) {
                this.uninstallMessageHandlers();
            }
            this.weakHandlers.clear();
            this.messageHandlers.clear();
        }
        list = this.closedListeners;
        synchronized (list) {
            this.closedListeners.forEach(Runnable::run);
            this.closedListeners.clear();
        }
    }

    private SendMessageResults handleMessage(Set<RecipientIdentifier> recipients, Function<List<String>, Long> recipientsHandler, Supplier<Long> noteToSelfHandler, Function<byte[], Long> groupHandler) {
        long timestamp = 0L;
        List<String> singleRecipients = recipients.stream().filter(r -> r instanceof RecipientIdentifier.Single).map(RecipientIdentifier.Single.class::cast).map(RecipientIdentifier::getIdentifier).toList();
        if (!singleRecipients.isEmpty()) {
            timestamp = recipientsHandler.apply(singleRecipients);
        }
        if (recipients.contains(RecipientIdentifier.NoteToSelf.INSTANCE)) {
            timestamp = noteToSelfHandler.get();
        }
        List<GroupId> groupRecipients = recipients.stream().filter(r -> r instanceof RecipientIdentifier.Group).map(RecipientIdentifier.Group.class::cast).map(RecipientIdentifier.Group::groupId).toList();
        for (GroupId groupId : groupRecipients) {
            timestamp = groupHandler.apply(groupId.serialize());
        }
        return new SendMessageResults(timestamp, Map.of());
    }

    private String emptyIfNull(String string) {
        return string == null ? "" : string;
    }

    private <T extends DBusInterface> T getRemoteObject(DBusPath path, Class<T> type) {
        try {
            return (T)this.connection.getRemoteObject(this.busname, path.getPath(), type);
        }
        catch (DBusException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void installMessageHandlers() {
        try {
            this.dbusMsgHandler = messageReceived -> {
                Map<String, Variant<?>> extras = messageReceived.getExtras();
                MessageEnvelope envelope = new MessageEnvelope(Optional.of(new RecipientAddress(messageReceived.getSender())), 0, messageReceived.getTimestamp(), 0L, 0L, false, Optional.empty(), Optional.empty(), Optional.of(new MessageEnvelope.Data(messageReceived.getTimestamp(), messageReceived.getGroupId().length > 0 ? Optional.of(new MessageEnvelope.Data.GroupContext(GroupId.unknownVersion((byte[])messageReceived.getGroupId()), false, 0)) : Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(messageReceived.getMessage()), 0, false, false, false, false, false, Optional.empty(), Optional.empty(), Optional.empty(), this.getAttachments(extras), Optional.empty(), Optional.empty(), List.of(), this.getMentions(extras), List.of(), List.of())), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
                this.notifyMessageHandlers(envelope);
            };
            this.connection.addSigHandler(Signal.MessageReceivedV2.class, (DBusInterface)this.signal, this.dbusMsgHandler);
            this.dbusEditMsgHandler = messageReceived -> {
                Map<String, Variant<?>> extras = messageReceived.getExtras();
                MessageEnvelope envelope = new MessageEnvelope(Optional.of(new RecipientAddress(messageReceived.getSender())), 0, messageReceived.getTimestamp(), 0L, 0L, false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new MessageEnvelope.Edit(messageReceived.getTargetSentTimestamp(), new MessageEnvelope.Data(messageReceived.getTimestamp(), messageReceived.getGroupId().length > 0 ? Optional.of(new MessageEnvelope.Data.GroupContext(GroupId.unknownVersion((byte[])messageReceived.getGroupId()), false, 0)) : Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(messageReceived.getMessage()), 0, false, false, false, false, false, Optional.empty(), Optional.empty(), Optional.empty(), this.getAttachments(extras), Optional.empty(), Optional.empty(), List.of(), this.getMentions(extras), List.of(), List.of()))), Optional.empty(), Optional.empty(), Optional.empty());
                this.notifyMessageHandlers(envelope);
            };
            this.connection.addSigHandler(Signal.EditMessageReceived.class, (DBusInterface)this.signal, this.dbusEditMsgHandler);
            this.dbusRcptHandler = receiptReceived -> {
                MessageEnvelope.Receipt.Type type = switch (receiptReceived.getReceiptType()) {
                    case "read" -> MessageEnvelope.Receipt.Type.READ;
                    case "viewed" -> MessageEnvelope.Receipt.Type.VIEWED;
                    case "delivery" -> MessageEnvelope.Receipt.Type.DELIVERY;
                    default -> MessageEnvelope.Receipt.Type.UNKNOWN;
                };
                MessageEnvelope envelope = new MessageEnvelope(Optional.of(new RecipientAddress(receiptReceived.getSender())), 0, receiptReceived.getTimestamp(), 0L, 0L, false, Optional.of(new MessageEnvelope.Receipt(receiptReceived.getTimestamp(), type, List.of(Long.valueOf(receiptReceived.getTimestamp())))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
                this.notifyMessageHandlers(envelope);
            };
            this.connection.addSigHandler(Signal.ReceiptReceivedV2.class, (DBusInterface)this.signal, this.dbusRcptHandler);
            this.dbusSyncHandler = syncReceived -> {
                Map<String, Variant<?>> extras = syncReceived.getExtras();
                MessageEnvelope envelope = new MessageEnvelope(Optional.of(new RecipientAddress(syncReceived.getSource())), 0, syncReceived.getTimestamp(), 0L, 0L, false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new MessageEnvelope.Sync(Optional.of(new MessageEnvelope.Sync.Sent(syncReceived.getTimestamp(), syncReceived.getTimestamp(), syncReceived.getDestination().isEmpty() ? Optional.empty() : Optional.of(new RecipientAddress(syncReceived.getDestination())), Set.of(), Optional.of(new MessageEnvelope.Data(syncReceived.getTimestamp(), syncReceived.getGroupId().length > 0 ? Optional.of(new MessageEnvelope.Data.GroupContext(GroupId.unknownVersion((byte[])syncReceived.getGroupId()), false, 0)) : Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(syncReceived.getMessage()), 0, false, false, false, false, false, Optional.empty(), Optional.empty(), Optional.empty(), this.getAttachments(extras), Optional.empty(), Optional.empty(), List.of(), this.getMentions(extras), List.of(), List.of())), Optional.empty(), Optional.empty())), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())), Optional.empty(), Optional.empty());
                this.notifyMessageHandlers(envelope);
            };
            this.connection.addSigHandler(Signal.SyncMessageReceivedV2.class, (DBusInterface)this.signal, this.dbusSyncHandler);
        }
        catch (DBusException e) {
            throw new RuntimeException(e);
        }
        this.signal.subscribeReceive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMessageHandlers(MessageEnvelope envelope) {
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            Stream.concat(this.messageHandlers.stream(), this.weakHandlers.stream()).forEach(h -> h.handleMessage(envelope, null));
        }
    }

    private void uninstallMessageHandlers() {
        try {
            this.signal.unsubscribeReceive();
            this.connection.removeSigHandler(Signal.MessageReceivedV2.class, (DBusInterface)this.signal, this.dbusMsgHandler);
            this.connection.removeSigHandler(Signal.EditMessageReceived.class, (DBusInterface)this.signal, this.dbusEditMsgHandler);
            this.connection.removeSigHandler(Signal.ReceiptReceivedV2.class, (DBusInterface)this.signal, this.dbusRcptHandler);
            this.connection.removeSigHandler(Signal.SyncMessageReceivedV2.class, (DBusInterface)this.signal, this.dbusSyncHandler);
        }
        catch (DBusException e) {
            throw new RuntimeException(e);
        }
    }

    private List<MessageEnvelope.Data.Attachment> getAttachments(Map<String, Variant<?>> extras) {
        if (!extras.containsKey("attachments")) {
            return List.of();
        }
        List attachments = (List)this.getValue(extras, "attachments");
        return attachments.stream().map(a -> {
            String file = a.containsKey("file") ? (String)this.getValue((Map<String, Variant<?>>)a, "file") : null;
            return new MessageEnvelope.Data.Attachment(a.containsKey("remoteId") ? Optional.of((String)this.getValue((Map<String, Variant<?>>)a, "remoteId")) : Optional.empty(), file != null ? Optional.of(new File(file)) : Optional.empty(), Optional.empty(), (String)this.getValue((Map<String, Variant<?>>)a, "contentType"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), ((Boolean)this.getValue((Map<String, Variant<?>>)a, "isVoiceNote")).booleanValue(), ((Boolean)this.getValue((Map<String, Variant<?>>)a, "isGif")).booleanValue(), ((Boolean)this.getValue((Map<String, Variant<?>>)a, "isBorderless")).booleanValue());
        }).toList();
    }

    private List<MessageEnvelope.Data.Mention> getMentions(Map<String, Variant<?>> extras) {
        if (!extras.containsKey("mentions")) {
            return List.of();
        }
        List mentions = (List)this.getValue(extras, "mentions");
        return mentions.stream().map(a -> new MessageEnvelope.Data.Mention(new RecipientAddress((String)this.getValue((Map<String, Variant<?>>)a, "recipient")), ((Integer)this.getValue((Map<String, Variant<?>>)a, "start")).intValue(), ((Integer)this.getValue((Map<String, Variant<?>>)a, "length")).intValue())).toList();
    }

    public InputStream retrieveAttachment(String id) throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream retrieveContactAvatar(RecipientIdentifier.Single recipient) throws IOException, UnregisteredRecipientException {
        throw new UnsupportedOperationException();
    }

    public InputStream retrieveProfileAvatar(RecipientIdentifier.Single recipient) throws IOException, UnregisteredRecipientException {
        throw new UnsupportedOperationException();
    }

    public InputStream retrieveGroupAvatar(GroupId groupId) throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream retrieveSticker(StickerPackId stickerPackId, int stickerId) throws IOException {
        throw new UnsupportedOperationException();
    }

    private <T> T getValue(Map<String, Variant<?>> stringVariantMap, String field) {
        return (T)stringVariantMap.get(field).getValue();
    }
}

