/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.IOException;
import org.asamk.SignalControl;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.PinLockedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;

public class DbusRegistrationManagerImpl
implements RegistrationManager {
    private final String number;
    private final SignalControl signalControl;
    private final DBusConnection connection;

    public DbusRegistrationManagerImpl(String number, SignalControl signalControl, DBusConnection connection) {
        this.number = number;
        this.signalControl = signalControl;
        this.connection = connection;
    }

    public void register(boolean voiceVerification, String captcha, boolean forceRegister) throws IOException, CaptchaRequiredException {
        if (forceRegister) {
            throw new UnsupportedOperationException();
        }
        if (captcha == null) {
            this.signalControl.register(this.number, voiceVerification);
        } else {
            this.signalControl.registerWithCaptcha(this.number, voiceVerification, captcha);
        }
    }

    public void verifyAccount(String verificationCode, String pin) throws IOException, PinLockedException, IncorrectPinException {
        if (pin == null) {
            this.signalControl.verify(this.number, verificationCode);
        } else {
            this.signalControl.verifyWithPin(this.number, verificationCode, pin);
        }
    }

    public void deleteLocalAccountData() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isRegistered() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

