/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.RateLimitErrorException;
import org.asamk.signal.commands.exceptions.UntrustedKeyErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonSendMessageResult;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.ProofRequiredException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.manager.api.SendMessageResult;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;

public class SendMessageResultUtils {
    private SendMessageResultUtils() {
    }

    public static void outputResult(OutputWriter outputWriter, SendGroupMessageResults sendMessageResults) {
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                List<String> errors = SendMessageResultUtils.getErrorMessagesFromSendMessageResults(sendMessageResults.results());
                SendMessageResultUtils.printSendMessageResultErrors(writer, errors);
                writer.println("{}", sendMessageResults.timestamp());
                break;
            }
            case 1: {
                JsonWriter writer = (JsonWriter)outputWriter3;
                List<JsonSendMessageResult> results = SendMessageResultUtils.getJsonSendMessageResults(sendMessageResults.results());
                writer.write(Map.of("timestamp", sendMessageResults.timestamp(), "results", results));
            }
        }
    }

    public static void outputResult(OutputWriter outputWriter, SendMessageResults sendMessageResults) throws CommandException {
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                List<String> errors = SendMessageResultUtils.getErrorMessagesFromSendMessageResults(sendMessageResults.results());
                SendMessageResultUtils.printSendMessageResultErrors(writer, errors);
                writer.println("{}", sendMessageResults.timestamp());
                break;
            }
            case 1: {
                JsonWriter writer = (JsonWriter)outputWriter3;
                List<JsonSendMessageResult> results = SendMessageResultUtils.getJsonSendMessageResults(sendMessageResults.results());
                writer.write(Map.of("timestamp", sendMessageResults.timestamp(), "results", results));
            }
        }
        if (!sendMessageResults.hasSuccess()) {
            if (sendMessageResults.hasOnlyUntrustedIdentity()) {
                throw new UntrustedKeyErrorException("Failed to send message due to untrusted identities");
            }
            if (sendMessageResults.hasOnlyRateLimitFailure()) {
                throw new RateLimitErrorException("Failed to send message due to rate limiting", new RateLimitException(0L));
            }
            throw new UserErrorException("Failed to send message");
        }
    }

    public static List<String> getErrorMessagesFromSendMessageResults(Map<RecipientIdentifier, List<SendMessageResult>> mapResults) {
        return mapResults.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(SendMessageResultUtils::getErrorMessageFromSendMessageResult).filter(Objects::nonNull).map(error -> ((RecipientIdentifier)entry.getKey()).getIdentifier() + ": " + error)).toList();
    }

    public static List<String> getErrorMessagesFromSendMessageResults(Collection<SendMessageResult> results) {
        return results.stream().map(SendMessageResultUtils::getErrorMessageFromSendMessageResult).filter(Objects::nonNull).toList();
    }

    public static String getErrorMessageFromSendMessageResult(SendMessageResult result) {
        String identifier = result.address().getLegacyIdentifier();
        if (result.proofRequiredFailure() != null) {
            ProofRequiredException failure = result.proofRequiredFailure();
            return String.format("CAPTCHA proof required for sending to \"%s\", available options \"%s\" with challenge token \"%s\", or wait \"%d\" seconds.\n" + (failure.getOptions().contains(ProofRequiredException.Option.CAPTCHA) ? "To get the captcha token, go to https://signalcaptchas.org/challenge/generate.html\nAfter solving the captcha, right-click on the \"Open Signal\" link and copy the link.\nUse the following command to submit the captcha token:\nsignal-cli submitRateLimitChallenge --challenge CHALLENGE_TOKEN --captcha CAPTCHA_TOKEN" : ""), identifier, failure.getOptions().stream().map(Enum::toString).collect(Collectors.joining(", ")), failure.getToken(), failure.getRetryAfterSeconds());
        }
        if (result.isNetworkFailure()) {
            return String.format("Network failure for \"%s\"", identifier);
        }
        if (result.isRateLimitFailure()) {
            return String.format("Rate limit failure for \"%s\"", identifier);
        }
        if (result.isUnregisteredFailure()) {
            return String.format("Unregistered user \"%s\"", identifier);
        }
        if (result.isIdentityFailure()) {
            return String.format("Untrusted Identity for \"%s\"", identifier);
        }
        return null;
    }

    public static void printSendMessageResultErrors(PlainTextWriter writer, List<String> errors) {
        if (errors.isEmpty()) {
            return;
        }
        writer.println("Failed to send (some) messages:", new Object[0]);
        for (String error : errors) {
            writer.println(error, new Object[0]);
        }
    }

    private static List<JsonSendMessageResult> getJsonSendMessageResults(Map<RecipientIdentifier, List<SendMessageResult>> mapResults) {
        return mapResults.entrySet().stream().flatMap(entry -> {
            GroupId groupId;
            Object patt0$temp = entry.getKey();
            if (patt0$temp instanceof RecipientIdentifier.Group) {
                RecipientIdentifier.Group g = (RecipientIdentifier.Group)patt0$temp;
                groupId = g.groupId();
            } else {
                groupId = null;
            }
            GroupId groupId2 = groupId;
            return ((List)entry.getValue()).stream().map(r -> JsonSendMessageResult.from(r, groupId2));
        }).toList();
    }

    public static List<JsonSendMessageResult> getJsonSendMessageResults(Collection<SendMessageResult> results) {
        return results.stream().map(JsonSendMessageResult::from).toList();
    }
}

