/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.util.ExpiringProfileCredentialUtil;

public final class GroupCandidate {
    private final ServiceId serviceId;
    private final Optional<ExpiringProfileKeyCredential> expiringProfileKeyCredential;

    public GroupCandidate(ServiceId serviceId, Optional<ExpiringProfileKeyCredential> expiringProfileKeyCredential) {
        this.serviceId = serviceId;
        this.expiringProfileKeyCredential = expiringProfileKeyCredential;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public Optional<ExpiringProfileKeyCredential> getExpiringProfileKeyCredential() {
        return this.expiringProfileKeyCredential;
    }

    public ExpiringProfileKeyCredential requireExpiringProfileKeyCredential() {
        if (this.expiringProfileKeyCredential.isPresent()) {
            return this.expiringProfileKeyCredential.get();
        }
        throw new IllegalStateException("no profile key credential");
    }

    public boolean hasValidProfileKeyCredential() {
        return this.expiringProfileKeyCredential.map(ExpiringProfileCredentialUtil::isValid).orElse(false);
    }

    public static Set<GroupCandidate> withoutExpiringProfileKeyCredentials(Set<GroupCandidate> groupCandidates) {
        HashSet<GroupCandidate> result2 = new HashSet<GroupCandidate>(groupCandidates.size());
        for (GroupCandidate candidate : groupCandidates) {
            result2.add(candidate.withoutExpiringProfileKeyCredential());
        }
        return result2;
    }

    public GroupCandidate withoutExpiringProfileKeyCredential() {
        return this.expiringProfileKeyCredential.isPresent() ? new GroupCandidate(this.serviceId, Optional.empty()) : this;
    }

    public GroupCandidate withExpiringProfileKeyCredential(ExpiringProfileKeyCredential expiringProfileKeyCredential) {
        return new GroupCandidate(this.serviceId, Optional.of(expiringProfileKeyCredential));
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GroupCandidate other = (GroupCandidate)obj;
        return other.serviceId.equals(this.serviceId);
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }
}

