/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import com.squareup.wire.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.protocol.message.DecryptionErrorMessage;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialPresentation;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.internal.push.AttachmentPointer;
import org.whispersystems.signalservice.internal.push.BodyRange;
import org.whispersystems.signalservice.internal.push.Content;
import org.whispersystems.signalservice.internal.push.DataMessage;
import org.whispersystems.signalservice.internal.push.EditMessage;
import org.whispersystems.signalservice.internal.push.Envelope;
import org.whispersystems.signalservice.internal.push.GroupContextV2;
import org.whispersystems.signalservice.internal.push.PniSignatureMessage;
import org.whispersystems.signalservice.internal.push.Preview;
import org.whispersystems.signalservice.internal.push.ReceiptMessage;
import org.whispersystems.signalservice.internal.push.StoryMessage;
import org.whispersystems.signalservice.internal.push.SyncMessage;
import org.whispersystems.signalservice.internal.push.TypingMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020(*\u0004\u0018\u00010)H\u0002J\u000e\u0010*\u001a\u00020(*\u0004\u0018\u00010)H\u0002J\u000e\u0010+\u001a\u00020(*\u0004\u0018\u00010,H\u0002J\u000e\u0010-\u001a\u00020(*\u0004\u0018\u00010,H\u0002J\f\u0010.\u001a\u00020(*\u00020,H\u0002J\u000e\u0010/\u001a\u00020(*\u0004\u0018\u00010,H\u0002J\u000e\u00100\u001a\u00020(*\u0004\u0018\u000101H\u0002J\u000e\u00102\u001a\u00020(*\u0004\u0018\u00010\tH\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u00104\u001a\u0004\u0018\u00010\u001c2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020,H\u0002\u00a8\u00069"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator;", "", "<init>", "()V", "validate", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "envelope", "Lorg/whispersystems/signalservice/internal/push/Envelope;", "content", "Lorg/whispersystems/signalservice/internal/push/Content;", "localAci", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "validateDataMessage", "dataMessage", "Lorg/whispersystems/signalservice/internal/push/DataMessage;", "validateSyncMessage", "syncMessage", "Lorg/whispersystems/signalservice/internal/push/SyncMessage;", "validateReceiptMessage", "receiptMessage", "Lorg/whispersystems/signalservice/internal/push/ReceiptMessage;", "validateTypingMessage", "typingMessage", "Lorg/whispersystems/signalservice/internal/push/TypingMessage;", "validateDecryptionErrorMessage", "serializedDecryptionErrorMessage", "", "validateSenderKeyDistributionMessage", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Invalid;", "serializedSenderKeyDistributionMessage", "validatePniSignatureMessage", "pniSignatureMessage", "Lorg/whispersystems/signalservice/internal/push/PniSignatureMessage;", "validateStoryMessage", "storyMessage", "Lorg/whispersystems/signalservice/internal/push/StoryMessage;", "validateEditMessage", "editMessage", "Lorg/whispersystems/signalservice/internal/push/EditMessage;", "isNullOrInvalid", "", "Lorg/whispersystems/signalservice/internal/push/AttachmentPointer;", "isPresentAndInvalid", "isValidServiceId", "", "isNullOrInvalidServiceId", "isInvalidServiceId", "isNullOrInvalidAci", "isNullOrInvalidPni", "Lokio/ByteString;", "meetsStoryFlagCriteria", "validatePlaintextContent", "validateGroupContextV2", "groupContext", "Lorg/whispersystems/signalservice/internal/push/GroupContextV2;", "prefix", "Result", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nEnvelopeContentValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvelopeContentValidator.kt\norg/whispersystems/signalservice/api/messages/EnvelopeContentValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1#2:439\n1761#3,3:440\n1761#3,3:443\n1761#3,3:446\n1761#3,3:449\n1761#3,3:452\n1761#3,3:455\n1761#3,3:458\n1761#3,3:461\n1761#3,3:464\n1761#3,3:467\n1761#3,3:470\n*S KotlinDebug\n*F\n+ 1 EnvelopeContentValidator.kt\norg/whispersystems/signalservice/api/messages/EnvelopeContentValidator\n*L\n87#1:440,3\n91#1:443,3\n95#1:446,3\n133#1:449,3\n195#1:452,3\n199#1:455,3\n211#1:458,3\n215#1:461,3\n306#1:464,3\n310#1:467,3\n314#1:470,3\n*E\n"})
public final class EnvelopeContentValidator {
    @NotNull
    public static final EnvelopeContentValidator INSTANCE = new EnvelopeContentValidator();

    private EnvelopeContentValidator() {
    }

    @NotNull
    public final Result validate(@NotNull Envelope envelope, @NotNull Content content, @NotNull ServiceId.ACI localAci) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)((Object)envelope), (String)"envelope");
        Intrinsics.checkNotNullParameter((Object)((Object)content), (String)"content");
        Intrinsics.checkNotNullParameter((Object)localAci, (String)"localAci");
        if (envelope.type == Envelope.Type.PLAINTEXT_CONTENT && (result2 = this.validatePlaintextContent(content)) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        if (envelope.sourceServiceId != null && this.isInvalidServiceId(envelope.sourceServiceId)) {
            return new Result.Invalid("Envelope had an invalid sourceServiceId!", null, 2, null);
        }
        if (content.senderKeyDistributionMessage != null && (result2 = this.validateSenderKeyDistributionMessage(content.senderKeyDistributionMessage.toByteArray())) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        if (content.pniSignatureMessage != null && (result2 = this.validatePniSignatureMessage(content.pniSignatureMessage)) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return Intrinsics.areEqual((Object)envelope.story, (Object)true) && !this.meetsStoryFlagCriteria(content) ? (Result)new Result.Invalid("Envelope was flagged as a story, but it did not have any story-related content!", null, 2, null) : (content.dataMessage != null ? this.validateDataMessage(envelope, content.dataMessage) : (content.syncMessage != null ? this.validateSyncMessage(envelope, content.syncMessage, localAci) : (content.callMessage != null ? (Result)Result.Valid.INSTANCE : (content.nullMessage != null ? (Result)Result.Valid.INSTANCE : (content.receiptMessage != null ? this.validateReceiptMessage(content.receiptMessage) : (content.typingMessage != null ? this.validateTypingMessage(envelope, content.typingMessage) : (content.decryptionErrorMessage != null ? this.validateDecryptionErrorMessage(content.decryptionErrorMessage.toByteArray()) : (content.storyMessage != null ? this.validateStoryMessage(content.storyMessage) : (content.editMessage != null ? this.validateEditMessage(content.editMessage) : (content.pniSignatureMessage != null ? (Result)Result.Valid.INSTANCE : (content.senderKeyDistributionMessage != null ? (Result)Result.Valid.INSTANCE : (Result)new Result.Invalid("Content is empty!", null, 2, null))))))))))));
    }

    private final Result validateDataMessage(Envelope envelope, DataMessage dataMessage) {
        Result.Invalid invalid;
        boolean bl;
        block34: {
            boolean bl2;
            Message it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block33: {
                boolean bl3;
                block32: {
                    boolean bl4;
                    block31: {
                        if (dataMessage.requiredProtocolVersion != null && dataMessage.requiredProtocolVersion > DataMessage.ProtocolVersion.CURRENT.getValue()) {
                            return new Result.UnsupportedDataMessage(DataMessage.ProtocolVersion.CURRENT.getValue(), dataMessage.requiredProtocolVersion);
                        }
                        if (dataMessage.timestamp == null) {
                            return new Result.Invalid("[DataMessage] Missing timestamp!", null, 2, null);
                        }
                        if (!Intrinsics.areEqual((Object)dataMessage.timestamp, (Object)envelope.timestamp)) {
                            return new Result.Invalid("[DataMessage] Timestamps don't match! envelope: " + envelope.timestamp + ", content: " + dataMessage.timestamp, null, 2, null);
                        }
                        if (dataMessage.quote != null && this.isNullOrInvalidAci(dataMessage.quote.authorAci)) {
                            return new Result.Invalid("[DataMessage] Invalid ACI on quote!", null, 2, null);
                        }
                        $this$any$iv = dataMessage.contact;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (DataMessage.Contact)((Object)element$iv);
                                boolean bl5 = false;
                                if (!(it.avatar != null && INSTANCE.isPresentAndInvalid(it.avatar.avatar))) continue;
                                bl4 = true;
                                break block31;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        return new Result.Invalid("[DataMessage] Invalid AttachmentPointer on DataMessage.contactList.avatar!", null, 2, null);
                    }
                    $this$any$iv = dataMessage.preview;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Preview)((Object)element$iv);
                            boolean bl6 = false;
                            if (!(it.image != null && INSTANCE.isPresentAndInvalid(it.image))) continue;
                            bl3 = true;
                            break block32;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return new Result.Invalid("[DataMessage] Invalid AttachmentPointer on DataMessage.previewList.image!", null, 2, null);
                }
                $this$any$iv = dataMessage.bodyRanges;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (BodyRange)((Object)element$iv);
                        boolean bl7 = false;
                        if (!(it.mentionAci != null && INSTANCE.isNullOrInvalidAci(it.mentionAci))) continue;
                        bl2 = true;
                        break block33;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return new Result.Invalid("[DataMessage] Invalid ACI on body range!", null, 2, null);
            }
            if (dataMessage.sticker != null && this.isNullOrInvalid(dataMessage.sticker.data_)) {
                return new Result.Invalid("[DataMessage] Invalid AttachmentPointer on DataMessage.sticker!", null, 2, null);
            }
            if (dataMessage.reaction != null) {
                if (dataMessage.reaction.targetSentTimestamp == null) {
                    return new Result.Invalid("[DataMessage] Missing timestamp on DataMessage.reaction!", null, 2, null);
                }
                if (this.isNullOrInvalidAci(dataMessage.reaction.targetAuthorAci)) {
                    return new Result.Invalid("[DataMessage] Invalid ACI on DataMessage.reaction!", null, 2, null);
                }
            }
            if (dataMessage.delete != null && dataMessage.delete.targetSentTimestamp == null) {
                return new Result.Invalid("[DataMessage] Missing timestamp on DataMessage.delete!", null, 2, null);
            }
            if (dataMessage.storyContext != null && this.isNullOrInvalidAci(dataMessage.storyContext.authorAci)) {
                return new Result.Invalid("[DataMessage] Invalid ACI on DataMessage.storyContext!", null, 2, null);
            }
            if (dataMessage.giftBadge != null) {
                if (dataMessage.giftBadge.receiptCredentialPresentation == null) {
                    return new Result.Invalid("[DataMessage] Missing DataMessage.giftBadge.receiptCredentialPresentation!", null, 2, null);
                }
                try {
                    new ReceiptCredentialPresentation(dataMessage.giftBadge.receiptCredentialPresentation.toByteArray());
                }
                catch (InvalidInputException e) {
                    return new Result.Invalid("[DataMessage] Invalid DataMessage.giftBadge.receiptCredentialPresentation!", null, 2, null);
                }
            }
            $this$any$iv = dataMessage.attachments;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (AttachmentPointer)((Object)element$iv);
                    boolean bl8 = false;
                    if (!INSTANCE.isNullOrInvalid((AttachmentPointer)it)) continue;
                    bl = true;
                    break block34;
                }
                bl = false;
            }
        }
        if (bl) {
            return new Result.Invalid("[DataMessage] Invalid attachments!", null, 2, null);
        }
        if (dataMessage.groupV2 != null && (invalid = this.validateGroupContextV2(dataMessage.groupV2, "[DataMessage]")) != null) {
            Result.Invalid it = invalid;
            boolean bl9 = false;
            return it;
        }
        return Result.Valid.INSTANCE;
    }

    private final Result validateSyncMessage(Envelope envelope, SyncMessage syncMessage, ServiceId.ACI localAci) {
        boolean bl;
        Object it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block33: {
            boolean bl2;
            block32: {
                boolean bl3;
                block31: {
                    String string = envelope.sourceServiceId;
                    Intrinsics.checkNotNull((Object)string);
                    ServiceId sourceServiceId = ServiceId.Companion.parseOrThrow(string);
                    if (!Intrinsics.areEqual((Object)sourceServiceId, (Object)localAci)) {
                        return new Result.Invalid("[SyncMessage] Source was not our own account!", null, 2, null);
                    }
                    if (syncMessage.sent != null) {
                        Object object;
                        boolean hasEditMessageGroup;
                        boolean validAddress = this.isValidServiceId(syncMessage.sent.destinationServiceId);
                        DataMessage dataMessage = syncMessage.sent.message;
                        boolean hasDataGroup = (dataMessage != null ? dataMessage.groupV2 : null) != null;
                        DataMessage dataMessage2 = syncMessage.sent.message;
                        boolean isRemoteDelete = (dataMessage2 != null ? dataMessage2.delete : null) != null;
                        StoryMessage storyMessage = syncMessage.sent.storyMessage;
                        boolean hasStoryGroup = (storyMessage != null ? storyMessage.group : null) != null;
                        boolean hasStoryManifest = !((Collection)syncMessage.sent.storyMessageRecipients).isEmpty();
                        Message message = syncMessage.sent.editMessage;
                        boolean bl4 = hasEditMessageGroup = (message != null && (message = message.dataMessage) != null ? message.groupV2 : null) != null;
                        if (hasDataGroup) {
                            DataMessage dataMessage3 = syncMessage.sent.message;
                            Intrinsics.checkNotNull((Object)((Object)dataMessage3));
                            GroupContextV2 groupContextV2 = dataMessage3.groupV2;
                            Intrinsics.checkNotNull((Object)((Object)groupContextV2));
                            object = this.validateGroupContextV2(groupContextV2, "[SyncMessage.Sent.Message]");
                            if (object != null) {
                                Object it2 = object;
                                boolean bl5 = false;
                                return (Result)it2;
                            }
                        }
                        if (hasStoryGroup) {
                            StoryMessage storyMessage2 = syncMessage.sent.storyMessage;
                            Intrinsics.checkNotNull((Object)((Object)storyMessage2));
                            GroupContextV2 groupContextV2 = storyMessage2.group;
                            Intrinsics.checkNotNull((Object)((Object)groupContextV2));
                            object = this.validateGroupContextV2(groupContextV2, "[SyncMessage.Sent.StoryMessage]");
                            if (object != null) {
                                Object it3 = object;
                                boolean bl6 = false;
                                return (Result)it3;
                            }
                        }
                        if (hasEditMessageGroup) {
                            EditMessage editMessage = syncMessage.sent.editMessage;
                            Intrinsics.checkNotNull((Object)((Object)editMessage));
                            DataMessage dataMessage4 = editMessage.dataMessage;
                            Intrinsics.checkNotNull((Object)((Object)dataMessage4));
                            GroupContextV2 groupContextV2 = dataMessage4.groupV2;
                            Intrinsics.checkNotNull((Object)((Object)groupContextV2));
                            object = this.validateGroupContextV2(groupContextV2, "[SyncMessage.Sent.EditMessage]");
                            if (object != null) {
                                Object it4 = object;
                                boolean bl7 = false;
                                return (Result)it4;
                            }
                        }
                        if (!(validAddress || hasDataGroup || hasStoryGroup || hasStoryManifest || hasEditMessageGroup || isRemoteDelete)) {
                            return new Result.Invalid("[SyncMessage] No valid destination! Checked the destination, DataMessage.group, StoryMessage.group, EditMessage.group and storyMessageRecipientList", null, 2, null);
                        }
                        for (SyncMessage.Sent.UnidentifiedDeliveryStatus status : syncMessage.sent.unidentifiedStatus) {
                            if (!this.isNullOrInvalidServiceId(status.destinationServiceId)) continue;
                            return new Result.Invalid("[SyncMessage] Invalid ServiceId in SyncMessage.sent.unidentifiedStatusList!", null, 2, null);
                        }
                        return syncMessage.sent.message != null ? this.validateDataMessage(envelope, syncMessage.sent.message) : (syncMessage.sent.storyMessage != null ? this.validateStoryMessage(syncMessage.sent.storyMessage) : (!((Collection)syncMessage.sent.storyMessageRecipients).isEmpty() ? (Result)Result.Valid.INSTANCE : (syncMessage.sent.editMessage != null ? this.validateEditMessage(syncMessage.sent.editMessage) : (Result)new Result.Invalid("[SyncMessage] Empty SyncMessage.sent!", null, 2, null))));
                    }
                    $this$any$iv = syncMessage.read;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (SyncMessage.Read)((Object)element$iv);
                            boolean bl8 = false;
                            if (!INSTANCE.isNullOrInvalidAci(it.senderAci)) continue;
                            bl3 = true;
                            break block31;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.readList!", null, 2, null);
                }
                $this$any$iv = syncMessage.viewed;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (SyncMessage.Viewed)((Object)element$iv);
                        boolean bl9 = false;
                        if (!INSTANCE.isNullOrInvalidAci(it.senderAci)) continue;
                        bl2 = true;
                        break block32;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.viewList!", null, 2, null);
            }
            if (syncMessage.viewOnceOpen != null && this.isNullOrInvalidAci(syncMessage.viewOnceOpen.senderAci)) {
                return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.viewOnceOpen!", null, 2, null);
            }
            if (syncMessage.verified != null && this.isNullOrInvalidAci(syncMessage.verified.destinationAci)) {
                return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.verified!", null, 2, null);
            }
            $this$any$iv = syncMessage.stickerPackOperation;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (SyncMessage.StickerPackOperation)((Object)element$iv);
                    boolean bl10 = false;
                    if (!(it.packId == null)) continue;
                    bl = true;
                    break block33;
                }
                bl = false;
            }
        }
        if (bl) {
            return new Result.Invalid("[SyncMessage] Missing packId in stickerPackOperationList!", null, 2, null);
        }
        if (syncMessage.blocked != null) {
            boolean bl11;
            block34: {
                $this$any$iv = syncMessage.blocked.acis;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl11 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl12 = false;
                        if (!INSTANCE.isNullOrInvalidAci((String)it)) continue;
                        bl11 = true;
                        break block34;
                    }
                    bl11 = false;
                }
            }
            if (bl11) {
                return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.blocked!", null, 2, null);
            }
        }
        if (syncMessage.messageRequestResponse != null && syncMessage.messageRequestResponse.groupId == null && this.isNullOrInvalidAci(syncMessage.messageRequestResponse.threadAci)) {
            return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.messageRequestResponse!", null, 2, null);
        }
        if (syncMessage.outgoingPayment != null && this.isNullOrInvalidServiceId(syncMessage.outgoingPayment.recipientServiceId)) {
            return new Result.Invalid("[SyncMessage] Invalid ServiceId in SyncMessage.outgoingPayment!", null, 2, null);
        }
        return Result.Valid.INSTANCE;
    }

    private final Result validateReceiptMessage(ReceiptMessage receiptMessage) {
        return receiptMessage.type == null ? (Result)new Result.Invalid("[ReceiptMessage] Missing type!", null, 2, null) : (Result)Result.Valid.INSTANCE;
    }

    private final Result validateTypingMessage(Envelope envelope, TypingMessage typingMessage) {
        if (typingMessage.timestamp == null) {
            return new Result.Invalid("[TypingMessage] Missing timestamp!", null, 2, null);
        }
        return !Intrinsics.areEqual((Object)typingMessage.timestamp, (Object)envelope.timestamp) ? (Result)new Result.Invalid("[TypingMessage] Timestamps don't match! envelope: " + envelope.timestamp + ", content: " + typingMessage.timestamp, null, 2, null) : (typingMessage.action == null ? (Result)new Result.Invalid("[TypingMessage] Missing action!", null, 2, null) : (Result)Result.Valid.INSTANCE);
    }

    private final Result validateDecryptionErrorMessage(byte[] serializedDecryptionErrorMessage) {
        Result result2;
        try {
            new DecryptionErrorMessage(serializedDecryptionErrorMessage);
            result2 = Result.Valid.INSTANCE;
        }
        catch (Exception e) {
            result2 = new Result.Invalid("[DecryptionErrorMessage] Bad decryption error message!", e);
        }
        return result2;
    }

    private final Result.Invalid validateSenderKeyDistributionMessage(byte[] serializedSenderKeyDistributionMessage) {
        Result.Invalid invalid;
        try {
            new SenderKeyDistributionMessage(serializedSenderKeyDistributionMessage);
            invalid = null;
        }
        catch (Exception e) {
            invalid = new Result.Invalid("[SenderKeyDistributionMessage] Bad sender key distribution message!", e);
        }
        return invalid;
    }

    private final Result validatePniSignatureMessage(PniSignatureMessage pniSignatureMessage) {
        if (this.isNullOrInvalidPni(pniSignatureMessage.pni)) {
            return new Result.Invalid("[PniSignatureMessage] Invalid PNI", null, 2, null);
        }
        if (pniSignatureMessage.signature == null) {
            return new Result.Invalid("[PniSignatureMessage] Signature is null", null, 2, null);
        }
        return null;
    }

    private final Result validateStoryMessage(StoryMessage storyMessage) {
        if (storyMessage.group != null) {
            Result.Invalid invalid = this.validateGroupContextV2(storyMessage.group, "[StoryMessage]");
            if (invalid != null) {
                Result.Invalid it = invalid;
                boolean bl = false;
                return it;
            }
        }
        return Result.Valid.INSTANCE;
    }

    private final Result validateEditMessage(EditMessage editMessage) {
        Result.Invalid invalid;
        boolean bl;
        DataMessage dataMessage;
        block18: {
            boolean bl2;
            Message it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block17: {
                boolean bl3;
                block16: {
                    if (editMessage.dataMessage == null) {
                        return new Result.Invalid("[EditMessage] No data message present", null, 2, null);
                    }
                    if (editMessage.targetSentTimestamp == null) {
                        return new Result.Invalid("[EditMessage] No targetSentTimestamp specified", null, 2, null);
                    }
                    dataMessage = editMessage.dataMessage;
                    if (dataMessage.requiredProtocolVersion != null && dataMessage.requiredProtocolVersion > DataMessage.ProtocolVersion.CURRENT.getValue()) {
                        return new Result.UnsupportedDataMessage(DataMessage.ProtocolVersion.CURRENT.getValue(), dataMessage.requiredProtocolVersion);
                    }
                    $this$any$iv = dataMessage.preview;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Preview)((Object)element$iv);
                            boolean bl4 = false;
                            if (!(it.image != null && INSTANCE.isPresentAndInvalid(it.image))) continue;
                            bl3 = true;
                            break block16;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return new Result.Invalid("[EditMessage] Invalid AttachmentPointer on DataMessage.previewList.image!", null, 2, null);
                }
                $this$any$iv = dataMessage.bodyRanges;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (BodyRange)((Object)element$iv);
                        boolean bl5 = false;
                        if (!(it.mentionAci != null && INSTANCE.isNullOrInvalidAci(it.mentionAci))) continue;
                        bl2 = true;
                        break block17;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return new Result.Invalid("[EditMessage] Invalid UUID on body range!", null, 2, null);
            }
            $this$any$iv = dataMessage.attachments;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (AttachmentPointer)((Object)element$iv);
                    boolean bl6 = false;
                    if (!INSTANCE.isNullOrInvalid((AttachmentPointer)it)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        if (bl) {
            return new Result.Invalid("[EditMessage] Invalid attachments!", null, 2, null);
        }
        if (dataMessage.groupV2 != null && (invalid = this.validateGroupContextV2(dataMessage.groupV2, "[EditMessage]")) != null) {
            Result.Invalid it = invalid;
            boolean bl7 = false;
            return it;
        }
        return Result.Valid.INSTANCE;
    }

    private final boolean isNullOrInvalid(AttachmentPointer $this$isNullOrInvalid) {
        return $this$isNullOrInvalid == null || $this$isNullOrInvalid.cdnId == null && $this$isNullOrInvalid.cdnKey == null;
    }

    private final boolean isPresentAndInvalid(AttachmentPointer $this$isPresentAndInvalid) {
        return $this$isPresentAndInvalid != null && $this$isPresentAndInvalid.cdnId == null && $this$isPresentAndInvalid.cdnKey == null;
    }

    private final boolean isValidServiceId(String $this$isValidServiceId) {
        ServiceId parsed = ServiceId.Companion.parseOrNull$default(ServiceId.Companion, $this$isValidServiceId, false, 2, null);
        return parsed != null && parsed.isValid();
    }

    private final boolean isNullOrInvalidServiceId(String $this$isNullOrInvalidServiceId) {
        ServiceId parsed = ServiceId.Companion.parseOrNull$default(ServiceId.Companion, $this$isNullOrInvalidServiceId, false, 2, null);
        return parsed == null || parsed.isUnknown();
    }

    private final boolean isInvalidServiceId(String $this$isInvalidServiceId) {
        ServiceId parsed = ServiceId.Companion.parseOrNull$default(ServiceId.Companion, $this$isInvalidServiceId, false, 2, null);
        return parsed == null || parsed.isUnknown();
    }

    private final boolean isNullOrInvalidAci(String $this$isNullOrInvalidAci) {
        ServiceId.ACI parsed = ServiceId.ACI.Companion.parseOrNull($this$isNullOrInvalidAci);
        return parsed == null || parsed.isUnknown();
    }

    private final boolean isNullOrInvalidPni(ByteString $this$isNullOrInvalidPni) {
        ByteString byteString = $this$isNullOrInvalidPni;
        ServiceId.PNI parsed = ServiceId.PNI.Companion.parseOrNull((byte[])(byteString != null ? byteString.toByteArray() : null));
        return parsed == null || parsed.isUnknown();
    }

    private final boolean meetsStoryFlagCriteria(Content $this$meetsStoryFlagCriteria) {
        return $this$meetsStoryFlagCriteria == null ? false : ($this$meetsStoryFlagCriteria.senderKeyDistributionMessage != null ? true : ($this$meetsStoryFlagCriteria.storyMessage != null ? true : ($this$meetsStoryFlagCriteria.dataMessage != null && $this$meetsStoryFlagCriteria.dataMessage.storyContext != null && $this$meetsStoryFlagCriteria.dataMessage.groupV2 != null ? true : $this$meetsStoryFlagCriteria.dataMessage != null && $this$meetsStoryFlagCriteria.dataMessage.delete != null)));
    }

    private final Result validatePlaintextContent(Content content) {
        List errors = new ArrayList();
        if (content.decryptionErrorMessage == null) {
            ((Collection)errors).add("Missing DecryptionErrorMessage");
        }
        if (content.dataMessage != null) {
            ((Collection)errors).add("Unexpected DataMessage");
        }
        if (content.syncMessage != null) {
            ((Collection)errors).add("Unexpected SyncMessage");
        }
        if (content.callMessage != null) {
            ((Collection)errors).add("Unexpected CallMessage");
        }
        if (content.nullMessage != null) {
            ((Collection)errors).add("Unexpected NullMessage");
        }
        if (content.receiptMessage != null) {
            ((Collection)errors).add("Unexpected ReceiptMessage");
        }
        if (content.typingMessage != null) {
            ((Collection)errors).add("Unexpected TypingMessage");
        }
        if (content.senderKeyDistributionMessage != null) {
            ((Collection)errors).add("Unexpected SenderKeyDistributionMessage");
        }
        if (content.storyMessage != null) {
            ((Collection)errors).add("Unexpected StoryMessage");
        }
        if (content.pniSignatureMessage != null) {
            ((Collection)errors).add("Unexpected PniSignatureMessage");
        }
        if (content.editMessage != null) {
            ((Collection)errors).add("Unexpected EditMessage");
        }
        return !((Collection)errors).isEmpty() ? (Result)new Result.Invalid("Invalid PLAINTEXT_CONTENT! Errors: " + errors, null, 2, null) : null;
    }

    private final Result.Invalid validateGroupContextV2(GroupContextV2 groupContext, String prefix) {
        Result.Invalid invalid;
        if (groupContext.masterKey == null) {
            invalid = new Result.Invalid(prefix + " Missing GV2 master key!", null, 2, null);
        } else if (groupContext.revision == null) {
            invalid = new Result.Invalid(prefix + " Missing GV2 revision!", null, 2, null);
        } else {
            Result.Invalid invalid2;
            try {
                new GroupMasterKey(groupContext.masterKey.toByteArray());
                invalid2 = null;
            }
            catch (InvalidInputException e) {
                invalid2 = new Result.Invalid(prefix + " Bad GV2 master key!", e);
            }
            invalid = invalid2;
        }
        return invalid;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "", "<init>", "()V", "Valid", "UnsupportedDataMessage", "Invalid", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Invalid;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$UnsupportedDataMessage;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Valid;", "signal-service-java"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Invalid;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "reason", "", "throwable", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getReason", "()Ljava/lang/String;", "getThrowable", "()Ljava/lang/Throwable;", "signal-service-java"})
        public static final class Invalid
        extends Result {
            @NotNull
            private final String reason;
            @NotNull
            private final Throwable throwable;

            public Invalid(@NotNull String reason, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                super(null);
                this.reason = reason;
                this.throwable = throwable;
            }

            public /* synthetic */ Invalid(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    throwable = new Throwable();
                }
                this(string, throwable);
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final Throwable getThrowable() {
                return this.throwable;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$UnsupportedDataMessage;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "ourVersion", "", "theirVersion", "<init>", "(ILjava/lang/Integer;)V", "getOurVersion", "()I", "getTheirVersion", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "signal-service-java"})
        public static final class UnsupportedDataMessage
        extends Result {
            private final int ourVersion;
            @Nullable
            private final Integer theirVersion;

            public UnsupportedDataMessage(int ourVersion, @Nullable Integer theirVersion) {
                super(null);
                this.ourVersion = ourVersion;
                this.theirVersion = theirVersion;
            }

            public final int getOurVersion() {
                return this.ourVersion;
            }

            @Nullable
            public final Integer getTheirVersion() {
                return this.theirVersion;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Valid;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "<init>", "()V", "signal-service-java"})
        public static final class Valid
        extends Result {
            @NotNull
            public static final Valid INSTANCE = new Valid();

            private Valid() {
                super(null);
            }
        }
    }
}

